<?php
/**
 * Currencies based on ISO 4217 standard
 *
 * Some special codes for funds, complementary currencies, precious metals
 * and used in testing are excluded.
 *
 * @link https://en.wikipedia.org/wiki/ISO_4217
 */

class Listo_Currencies implements Listo {
	private function __construct() {}

	public static function items() {
		return array(
			'aed' => _x( "United Arab Emirates dirham", 'currencies', 'listo' ),
			'afn' => _x( "Afghan afghani", 'currencies', 'listo' ),
			'all' => _x( "Albanian lek", 'currencies', 'listo' ),
			'amd' => _x( "Armenian dram", 'currencies', 'listo' ),
			'ang' => _x( "Netherlands Antillean guilder", 'currencies', 'listo' ),
			'aoa' => _x( "Angolan kwanza", 'currencies', 'listo' ),
			'ars' => _x( "Argentine peso", 'currencies', 'listo' ),
			'aud' => _x( "Australian dollar", 'currencies', 'listo' ),
			'awg' => _x( "Aruban florin", 'currencies', 'listo' ),
			'azn' => _x( "Azerbaijani manat", 'currencies', 'listo' ),
			'bam' => _x( "Bosnia and Herzegovina convertible mark", 'currencies', 'listo' ),
			'bbd' => _x( "Barbados dollar", 'currencies', 'listo' ),
			'bdt' => _x( "Bangladeshi taka", 'currencies', 'listo' ),
			'bgn' => _x( "Bulgarian lev", 'currencies', 'listo' ),
			'bhd' => _x( "Bahraini dinar", 'currencies', 'listo' ),
			'bif' => _x( "Burundian franc", 'currencies', 'listo' ),
			'bmd' => _x( "Bermudian dollar", 'currencies', 'listo' ),
			'bnd' => _x( "Brunei dollar", 'currencies', 'listo' ),
			'bob' => _x( "Boliviano", 'currencies', 'listo' ),
			'brl' => _x( "Brazilian real", 'currencies', 'listo' ),
			'bsd' => _x( "Bahamian dollar", 'currencies', 'listo' ),
			'btn' => _x( "Bhutanese ngultrum", 'currencies', 'listo' ),
			'bwp' => _x( "Botswana pula", 'currencies', 'listo' ),
			'byr' => _x( "Belarusian ruble", 'currencies', 'listo' ),
			'bzd' => _x( "Belize dollar", 'currencies', 'listo' ),
			'cad' => _x( "Canadian dollar", 'currencies', 'listo' ),
			'cdf' => _x( "Congolese franc", 'currencies', 'listo' ),
			'chf' => _x( "Swiss franc", 'currencies', 'listo' ),
			'clp' => _x( "Chilean peso", 'currencies', 'listo' ),
			'cny' => _x( "Chinese yuan", 'currencies', 'listo' ),
			'cop' => _x( "Colombian peso", 'currencies', 'listo' ),
			'crc' => _x( "Costa Rican colon", 'currencies', 'listo' ),
			'cup' => _x( "Cuban peso", 'currencies', 'listo' ),
			'cve' => _x( "Cape Verde escudo", 'currencies', 'listo' ),
			'czk' => _x( "Czech koruna", 'currencies', 'listo' ),
			'djf' => _x( "Djiboutian franc", 'currencies', 'listo' ),
			'dkk' => _x( "Danish krone", 'currencies', 'listo' ),
			'dop' => _x( "Dominican peso", 'currencies', 'listo' ),
			'dzd' => _x( "Algerian dinar", 'currencies', 'listo' ),
			'egp' => _x( "Egyptian pound", 'currencies', 'listo' ),
			'ern' => _x( "Eritrean nakfa", 'currencies', 'listo' ),
			'etb' => _x( "Ethiopian birr", 'currencies', 'listo' ),
			'eur' => _x( "Euro", 'currencies', 'listo' ),
			'fjd' => _x( "Fiji dollar", 'currencies', 'listo' ),
			'fkp' => _x( "Falkland Islands pound", 'currencies', 'listo' ),
			'gbp' => _x( "Pound sterling", 'currencies', 'listo' ),
			'gel' => _x( "Georgian lari", 'currencies', 'listo' ),
			'ghs' => _x( "Ghanaian cedi", 'currencies', 'listo' ),
			'gip' => _x( "Gibraltar pound", 'currencies', 'listo' ),
			'gmd' => _x( "Gambian dalasi", 'currencies', 'listo' ),
			'gnf' => _x( "Guinean franc", 'currencies', 'listo' ),
			'gtq' => _x( "Guatemalan quetzal", 'currencies', 'listo' ),
			'gyd' => _x( "Guyanese dollar", 'currencies', 'listo' ),
			'hkd' => _x( "Hong Kong dollar", 'currencies', 'listo' ),
			'hnl' => _x( "Honduran lempira", 'currencies', 'listo' ),
			'hrk' => _x( "Croatian kuna", 'currencies', 'listo' ),
			'htg' => _x( "Haitian gourde", 'currencies', 'listo' ),
			'huf' => _x( "Hungarian forint", 'currencies', 'listo' ),
			'idr' => _x( "Indonesian rupiah", 'currencies', 'listo' ),
			'ils' => _x( "Israeli new shekel", 'currencies', 'listo' ),
			'inr' => _x( "Indian rupee", 'currencies', 'listo' ),
			'iqd' => _x( "Iraqi dinar", 'currencies', 'listo' ),
			'irr' => _x( "Iranian rial", 'currencies', 'listo' ),
			'isk' => _x( "Icelandic króna", 'currencies', 'listo' ),
			'jmd' => _x( "Jamaican dollar", 'currencies', 'listo' ),
			'jod' => _x( "Jordanian dinar", 'currencies', 'listo' ),
			'jpy' => _x( "Japanese yen", 'currencies', 'listo' ),
			'kes' => _x( "Kenyan shilling", 'currencies', 'listo' ),
			'kgs' => _x( "Kyrgyzstani som", 'currencies', 'listo' ),
			'khr' => _x( "Cambodian riel", 'currencies', 'listo' ),
			'kmf' => _x( "Comoro franc", 'currencies', 'listo' ),
			'kpw' => _x( "North Korean won", 'currencies', 'listo' ),
			'krw' => _x( "South Korean won", 'currencies', 'listo' ),
			'kwd' => _x( "Kuwaiti dinar", 'currencies', 'listo' ),
			'kyd' => _x( "Cayman Islands dollar", 'currencies', 'listo' ),
			'kzt' => _x( "Kazakhstani tenge", 'currencies', 'listo' ),
			'lak' => _x( "Lao kip", 'currencies', 'listo' ),
			'lbp' => _x( "Lebanese pound", 'currencies', 'listo' ),
			'lkr' => _x( "Sri Lankan rupee", 'currencies', 'listo' ),
			'lrd' => _x( "Liberian dollar", 'currencies', 'listo' ),
			'lsl' => _x( "Lesotho loti", 'currencies', 'listo' ),
			'ltl' => _x( "Lithuanian litas", 'currencies', 'listo' ),
			'lyd' => _x( "Libyan dinar", 'currencies', 'listo' ),
			'mad' => _x( "Moroccan dirham", 'currencies', 'listo' ),
			'mdl' => _x( "Moldovan leu", 'currencies', 'listo' ),
			'mga' => _x( "Malagasy ariary", 'currencies', 'listo' ),
			'mkd' => _x( "Macedonian denar", 'currencies', 'listo' ),
			'mmk' => _x( "Myanma kyat", 'currencies', 'listo' ),
			'mnt' => _x( "Mongolian tugrik", 'currencies', 'listo' ),
			'mop' => _x( "Macanese pataca", 'currencies', 'listo' ),
			'mro' => _x( "Mauritanian ouguiya", 'currencies', 'listo' ),
			'mur' => _x( "Mauritian rupee", 'currencies', 'listo' ),
			'mvr' => _x( "Maldivian rufiyaa", 'currencies', 'listo' ),
			'mwk' => _x( "Malawian kwacha", 'currencies', 'listo' ),
			'mxn' => _x( "Mexican peso", 'currencies', 'listo' ),
			'myr' => _x( "Malaysian ringgit", 'currencies', 'listo' ),
			'mzn' => _x( "Mozambican metical", 'currencies', 'listo' ),
			'nad' => _x( "Namibian dollar", 'currencies', 'listo' ),
			'ngn' => _x( "Nigerian naira", 'currencies', 'listo' ),
			'nio' => _x( "Nicaraguan córdoba", 'currencies', 'listo' ),
			'nok' => _x( "Norwegian krone", 'currencies', 'listo' ),
			'npr' => _x( "Nepalese rupee", 'currencies', 'listo' ),
			'nzd' => _x( "New Zealand dollar", 'currencies', 'listo' ),
			'omr' => _x( "Omani rial", 'currencies', 'listo' ),
			'pab' => _x( "Panamanian balboa", 'currencies', 'listo' ),
			'pen' => _x( "Peruvian nuevo sol", 'currencies', 'listo' ),
			'pgk' => _x( "Papua New Guinean kina", 'currencies', 'listo' ),
			'php' => _x( "Philippine peso", 'currencies', 'listo' ),
			'pkr' => _x( "Pakistani rupee", 'currencies', 'listo' ),
			'pln' => _x( "Polish złoty", 'currencies', 'listo' ),
			'pyg' => _x( "Paraguayan guaraní", 'currencies', 'listo' ),
			'qar' => _x( "Qatari riyal", 'currencies', 'listo' ),
			'ron' => _x( "Romanian new leu", 'currencies', 'listo' ),
			'rsd' => _x( "Serbian dinar", 'currencies', 'listo' ),
			'rub' => _x( "Russian ruble", 'currencies', 'listo' ),
			'rwf' => _x( "Rwandan franc", 'currencies', 'listo' ),
			'sar' => _x( "Saudi riyal", 'currencies', 'listo' ),
			'sbd' => _x( "Solomon Islands dollar", 'currencies', 'listo' ),
			'scr' => _x( "Seychelles rupee", 'currencies', 'listo' ),
			'sdg' => _x( "Sudanese pound", 'currencies', 'listo' ),
			'sek' => _x( "Swedish krona/kronor", 'currencies', 'listo' ),
			'sgd' => _x( "Singapore dollar", 'currencies', 'listo' ),
			'shp' => _x( "Saint Helena pound", 'currencies', 'listo' ),
			'sll' => _x( "Sierra Leonean leone", 'currencies', 'listo' ),
			'sos' => _x( "Somali shilling", 'currencies', 'listo' ),
			'srd' => _x( "Surinamese dollar", 'currencies', 'listo' ),
			'ssp' => _x( "South Sudanese pound", 'currencies', 'listo' ),
			'std' => _x( "São Tomé and Príncipe dobra", 'currencies', 'listo' ),
			'syp' => _x( "Syrian pound", 'currencies', 'listo' ),
			'szl' => _x( "Swazi lilangeni", 'currencies', 'listo' ),
			'thb' => _x( "Thai baht", 'currencies', 'listo' ),
			'tjs' => _x( "Tajikistani somoni", 'currencies', 'listo' ),
			'tmt' => _x( "Turkmenistani manat", 'currencies', 'listo' ),
			'tnd' => _x( "Tunisian dinar", 'currencies', 'listo' ),
			'top' => _x( "Tongan paʻanga", 'currencies', 'listo' ),
			'try' => _x( "Turkish lira", 'currencies', 'listo' ),
			'ttd' => _x( "Trinidad and Tobago dollar", 'currencies', 'listo' ),
			'twd' => _x( "New Taiwan dollar", 'currencies', 'listo' ),
			'tzs' => _x( "Tanzanian shilling", 'currencies', 'listo' ),
			'uah' => _x( "Ukrainian hryvnia", 'currencies', 'listo' ),
			'ugx' => _x( "Ugandan shilling", 'currencies', 'listo' ),
			'usd' => _x( "United States dollar", 'currencies', 'listo' ),
			'uyu' => _x( "Uruguayan peso", 'currencies', 'listo' ),
			'uzs' => _x( "Uzbekistan som", 'currencies', 'listo' ),
			'vef' => _x( "Venezuelan bolívar", 'currencies', 'listo' ),
			'vnd' => _x( "Vietnamese dong", 'currencies', 'listo' ),
			'vuv' => _x( "Vanuatu vatu", 'currencies', 'listo' ),
			'wst' => _x( "Samoan tala", 'currencies', 'listo' ),
			'xaf' => _x( "CFA franc BEAC", 'currencies', 'listo' ),
			'xcd' => _x( "East Caribbean dollar", 'currencies', 'listo' ),
			'xof' => _x( "CFA franc BCEAO", 'currencies', 'listo' ),
			'xpf' => _x( "CFP franc (franc Pacifique)", 'currencies', 'listo' ),
			'yer' => _x( "Yemeni rial", 'currencies', 'listo' ),
			'zar' => _x( "South African rand", 'currencies', 'listo' ),
			'zmw' => _x( "Zambian kwacha", 'currencies', 'listo' ),
			'zwl' => _x( "Zimbabwe dollar", 'currencies', 'listo' ),
		);
	}

	public static function groups() {
		return array();
	}
}
