<?php
/**
 * ISO 3166-1 countries Alpha-2 to Alpha-3 code mapping
 *
 * @link https://en.wikipedia.org/wiki/ISO_3166-1
 */

class Listo_Countries_A2A3 implements Listo {
	private function __construct() {}

	private static $items = array(
		'ad' => 'AND',
		'ae' => 'ARE',
		'af' => 'AFG',
		'ag' => 'ATG',
		'ai' => 'AIA',
		'al' => 'ALB',
		'am' => 'ARM',
		'ao' => 'AGO',
		'aq' => 'ATA',
		'ar' => 'ARG',
		'as' => 'ASM',
		'at' => 'AUT',
		'au' => 'AUS',
		'aw' => 'ABW',
		'ax' => 'ALA',
		'az' => 'AZE',
		'ba' => 'BIH',
		'bb' => 'BRB',
		'bd' => 'BGD',
		'be' => 'BEL',
		'bf' => 'BFA',
		'bg' => 'BGR',
		'bh' => 'BHR',
		'bi' => 'BDI',
		'bj' => 'BEN',
		'bl' => 'BLM',
		'bm' => 'BMU',
		'bn' => 'BRN',
		'bo' => 'BOL',
		'bq' => 'BES',
		'br' => 'BRA',
		'bs' => 'BHS',
		'bt' => 'BTN',
		'bv' => 'BVT',
		'bw' => 'BWA',
		'by' => 'BLR',
		'bz' => 'BLZ',
		'ca' => 'CAN',
		'cc' => 'CCK',
		'cd' => 'COD',
		'cf' => 'CAF',
		'cg' => 'COG',
		'ch' => 'CHE',
		'ci' => 'CIV',
		'ck' => 'COK',
		'cl' => 'CHL',
		'cm' => 'CMR',
		'cn' => 'CHN',
		'co' => 'COL',
		'cr' => 'CRI',
		'cu' => 'CUB',
		'cv' => 'CPV',
		'cw' => 'CUW',
		'cx' => 'CXR',
		'cy' => 'CYP',
		'cz' => 'CZE',
		'de' => 'DEU',
		'dj' => 'DJI',
		'dk' => 'DNK',
		'dm' => 'DMA',
		'do' => 'DOM',
		'dz' => 'DZA',
		'ec' => 'ECU',
		'ee' => 'EST',
		'eg' => 'EGY',
		'eh' => 'ESH',
		'er' => 'ERI',
		'es' => 'ESP',
		'et' => 'ETH',
		'fi' => 'FIN',
		'fj' => 'FJI',
		'fk' => 'FLK',
		'fm' => 'FSM',
		'fo' => 'FRO',
		'fr' => 'FRA',
		'ga' => 'GAB',
		'gb' => 'GBR',
		'gd' => 'GRD',
		'ge' => 'GEO',
		'gf' => 'GUF',
		'gg' => 'GGY',
		'gh' => 'GHA',
		'gi' => 'GIB',
		'gl' => 'GRL',
		'gm' => 'GMB',
		'gn' => 'GIN',
		'gp' => 'GLP',
		'gq' => 'GNQ',
		'gr' => 'GRC',
		'gs' => 'SGS',
		'gt' => 'GTM',
		'gu' => 'GUM',
		'gw' => 'GNB',
		'gy' => 'GUY',
		'hk' => 'HKG',
		'hm' => 'HMD',
		'hn' => 'HND',
		'hr' => 'HRV',
		'ht' => 'HTI',
		'hu' => 'HUN',
		'id' => 'IDN',
		'ie' => 'IRL',
		'il' => 'ISR',
		'im' => 'IMN',
		'in' => 'IND',
		'io' => 'IOT',
		'iq' => 'IRQ',
		'ir' => 'IRN',
		'is' => 'ISL',
		'it' => 'ITA',
		'je' => 'JEY',
		'jm' => 'JAM',
		'jo' => 'JOR',
		'jp' => 'JPN',
		'ke' => 'KEN',
		'kg' => 'KGZ',
		'kh' => 'KHM',
		'ki' => 'KIR',
		'km' => 'COM',
		'kn' => 'KNA',
		'kp' => 'PRK',
		'kr' => 'KOR',
		'kw' => 'KWT',
		'ky' => 'CYM',
		'kz' => 'KAZ',
		'la' => 'LAO',
		'lb' => 'LBN',
		'lc' => 'LCA',
		'li' => 'LIE',
		'lk' => 'LKA',
		'lr' => 'LBR',
		'ls' => 'LSO',
		'lt' => 'LTU',
		'lu' => 'LUX',
		'lv' => 'LVA',
		'ly' => 'LBY',
		'ma' => 'MAR',
		'mc' => 'MCO',
		'md' => 'MDA',
		'me' => 'MNE',
		'mf' => 'MAF',
		'mg' => 'MDG',
		'mh' => 'MHL',
		'mk' => 'MKD',
		'ml' => 'MLI',
		'mm' => 'MMR',
		'mn' => 'MNG',
		'mo' => 'MAC',
		'mp' => 'MNP',
		'mq' => 'MTQ',
		'mr' => 'MRT',
		'ms' => 'MSR',
		'mt' => 'MLT',
		'mu' => 'MUS',
		'mv' => 'MDV',
		'mw' => 'MWI',
		'mx' => 'MEX',
		'my' => 'MYS',
		'mz' => 'MOZ',
		'na' => 'NAM',
		'nc' => 'NCL',
		'ne' => 'NER',
		'nf' => 'NFK',
		'ng' => 'NGA',
		'ni' => 'NIC',
		'nl' => 'NLD',
		'no' => 'NOR',
		'np' => 'NPL',
		'nr' => 'NRU',
		'nu' => 'NIU',
		'nz' => 'NZL',
		'om' => 'OMN',
		'pa' => 'PAN',
		'pe' => 'PER',
		'pf' => 'PYF',
		'pg' => 'PNG',
		'ph' => 'PHL',
		'pk' => 'PAK',
		'pl' => 'POL',
		'pm' => 'SPM',
		'pn' => 'PCN',
		'pr' => 'PRI',
		'ps' => 'PSE',
		'pt' => 'PRT',
		'pw' => 'PLW',
		'py' => 'PRY',
		'qa' => 'QAT',
		're' => 'REU',
		'ro' => 'ROU',
		'rs' => 'SRB',
		'ru' => 'RUS',
		'rw' => 'RWA',
		'sa' => 'SAU',
		'sb' => 'SLB',
		'sc' => 'SYC',
		'sd' => 'SDN',
		'se' => 'SWE',
		'sg' => 'SGP',
		'sh' => 'SHN',
		'si' => 'SVN',
		'sj' => 'SJM',
		'sk' => 'SVK',
		'sl' => 'SLE',
		'sm' => 'SMR',
		'sn' => 'SEN',
		'so' => 'SOM',
		'sr' => 'SUR',
		'ss' => 'SSD',
		'st' => 'STP',
		'sv' => 'SLV',
		'sx' => 'SXM',
		'sy' => 'SYR',
		'sz' => 'SWZ',
		'tc' => 'TCA',
		'td' => 'TCD',
		'tf' => 'ATF',
		'tg' => 'TGO',
		'th' => 'THA',
		'tj' => 'TJK',
		'tk' => 'TKL',
		'tl' => 'TLS',
		'tm' => 'TKM',
		'tn' => 'TUN',
		'to' => 'TON',
		'tr' => 'TUR',
		'tt' => 'TTO',
		'tv' => 'TUV',
		'tw' => 'TWN',
		'tz' => 'TZA',
		'ua' => 'UKR',
		'ug' => 'UGA',
		'um' => 'UMI',
		'us' => 'USA',
		'uy' => 'URY',
		'uz' => 'UZB',
		'va' => 'VAT',
		'vc' => 'VCT',
		've' => 'VEN',
		'vg' => 'VGB',
		'vi' => 'VIR',
		'vn' => 'VNM',
		'vu' => 'VUT',
		'wf' => 'WLF',
		'ws' => 'WSM',
		'ye' => 'YEM',
		'yt' => 'MYT',
		'za' => 'ZAF',
		'zm' => 'ZMB',
		'zw' => 'ZWE',
	);

	public static function items() {
		return self::$items;
	}

	public static function groups() {
		return array();
	}

	public static function convert_a2_to_a3( $a2 ) {
		$a2 = strtolower( $a2 );
		$a3 = self::$items[$a2] ?? '';
		return strtolower( $a3 );
	}

	public static function convert_a3_to_a2( $a3 ) {
		$a3 = strtoupper( $a3 );
		$a2 = array_search( $a3, self::$items );
		return strtolower( $a2 );
	}
}
