import React from 'react';

export default {
	controlIcon: {
		'text-align-left': (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path d="M3,19.94H21V22H3Zm0-4.45,12.28,0v2L3,17.47ZM3,10.9l17.81,0v2.22L3,13ZM3,2,21,2v2H3ZM3,6.51l12.27,0,0,2L3,8.47Z" />
			</svg>
		),
		'text-align-right': (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path d="M3,19.94H21V22H3Zm5.7-4.45,12.28,0v2l-12.28,0ZM3.13,10.9l17.81,0v2.22L3.13,13ZM3,2,21,2v2H3ZM8.71,6.51,21,6.56l0,2-12.26,0Z" />
			</svg>
		),
		'text-align-center': (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path d="M3,19.94H21V22H3Zm3-4.45,12,0v2l-12,0ZM3,10.9l17.81,0v2.22L3,13ZM3,2,21,2v2H3ZM6,6.51l12,0,0,2-12,0Z" />
			</svg>
		),
		'text-align-justify': (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path d="M3,15.53H21V17.6H3ZM6,20l12,0v2L6,22ZM3,10.9l17.81,0v2.22L3,13ZM3,2,21,2v2H3ZM3,6.51l18,0,0,2-18,0Z" />
			</svg>
		),
		'align-center': (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<rect x="11" y="2" width="2" height="20" />
				<rect x="3" y="6" width="18" height="12" />
			</svg>
		),
		'align-left': (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<rect x="3" y="2" width="2" height="20" />
				<rect x="7" y="6" width="14" height="12" />
			</svg>
		),
		'align-right': (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<rect x="19" y="2" width="2" height="20" />
				<rect x="3" y="6" width="14" height="12" />
			</svg>
		),
		'chevron-down': (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path d="M20.5 6.2L12 14.7 3.5 6.2 2 7.8l10 10 9.9-10-1.4-1.6z" />
			</svg>
		),
		'chevron-up': (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path d="M2 16.1l1.4 1.4L12 8.9l8.6 8.6 1.4-1.4-10-10-10 10z" />
			</svg>
		),
		'chevron-up-circle': (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path
					d="M22 12c0 5.5-4.5 10-10 10S2 17.5 2 12 6.5 2 12 2s10 4.5 10 10zM2.5 12c0 5.3 4.3 9.5 9.5 9.5s9.5-4.3 9.5-9.5-4.2-9.5-9.5-9.5c-5.2 0-9.5 4.3-9.5 9.5z"
					fill="#e2e8f0"
				/>
				<path d="M7.7 14.9l4.3-4.3 4.3 4.3.8-.8-5-5-5 5 .6.8z" fill="#64748b" />
			</svg>
		),
		'chevron-down-circle': (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path
					d="M12,22A10,10,0,1,1,22,12,10,10,0,0,1,12,22ZM12,2.49A9.51,9.51,0,1,0,21.51,12,9.53,9.53,0,0,0,12,2.49Z"
					fill="#e2e8f0"
				/>
				<path
					d="M16.28,9.1,12,13.35,7.78,9.1,7,9.9l5,5L17,9.9Z"
					fill="#64748b"
				/>
			</svg>
		),
		cog: (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path d="M12 16c2.2 0 4-1.8 4-4s-1.8-4-4-4-4 1.8-4 4 1.8 4 4 4zm0-6c1.1 0 2 .9 2 2s-.9 2-2 2-2-.9-2-2 .9-2 2-2z" />
				{/* eslint-disable-next-line max-len */}
				<path d="M2.8 16.1l1 1.7c.5.9 1.8 1.3 2.7.7l.5-.3c.6.5 1.2.8 1.9 1.1v.7c0 1.1.9 2 2 2h2c1.1 0 2-.9 2-2v-.6c.7-.3 1.3-.7 1.9-1.1l.5.3c.9.5 2.2.2 2.7-.7l1-1.7c.6-1 .2-2.2-.7-2.7l-.5-.3c.1-.7.1-1.5 0-2.2l.5-.3c1-.6 1.3-1.8.7-2.7l-1-1.7c-.5-.9-1.8-1.3-2.7-.7l-.5.3c-.6-.5-1.2-.8-1.9-1.1V4c0-1.1-.9-2-2-2h-2C9.9 2 9 2.9 9 4v.6c-.7.3-1.3.7-1.9 1.1l-.5-.3c-.9-.5-2.2-.2-2.8.7l-1 1.7c-.6 1-.2 2.2.7 2.7l.5.3c-.1.7-.1 1.5 0 2.2l-.5.3c-.9.7-1.2 1.9-.7 2.8zm3.4-2.7c-.1-.5-.2-.9-.2-1.4 0-.5.1-.9.2-1.4.1-.4-.1-.9-.5-1.1l-1.1-.6 1-1.7 1.1.7c.4.1.9.1 1.2-.2.7-.7 1.5-1.2 2.4-1.4.4-.1.7-.5.7-1V4h2v1.3c0 .4.3.8.7 1 .9.3 1.7.8 2.4 1.4.3.3.8.3 1.2.1l1.1-.7 1 1.7-1.1.6c-.4.2-.6.7-.5 1.1.1.5.2.9.2 1.4 0 .5-.1.9-.2 1.4-.1.4.1.9.5 1.1l1.1.6-1 1.7-1.1-.7c-.4-.2-.9-.2-1.2.1-.7.6-1.5 1.1-2.4 1.4-.4.1-.7.5-.7 1v1.3h-2v-1.3c0-.4-.3-.8-.7-1-.9-.3-1.7-.8-2.4-1.4-.3-.1-.8-.1-1.2.1l-1.1.7-1-1.7 1.1-.7c.4-.2.6-.7.5-1.1z" />
			</svg>
		),
		lock: (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				{' '}
				<path d="M12,22.14a4.67,4.67,0,0,0,3.27-1.33,4.57,4.57,0,0,0,1.21-3.27l-.06-3.69H14.59l.06,3.69A2.63,2.63,0,0,1,12,20.33a2.54,2.54,0,0,1-2.53-2.79l.06-3.69-2-.06-.06,3.69A4.6,4.6,0,0,0,12,22.14ZM16.54,6.46a4.48,4.48,0,1,0-9,0l.06,3.69H9.53L9.47,6.46a2.59,2.59,0,1,1,5.17,0l-.06,3.69h1.9C16.54,10.09,16.54,6.46,16.54,6.46Z" />
				<path d="M13,17.15H11V6.85h2Z" />
			</svg>
		),
		'un-link': (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path d="M12,22.14a4.67,4.67,0,0,0,3.27-1.33,4.57,4.57,0,0,0,1.21-3.27l-.06-3.69H14.59l.06,3.69A2.63,2.63,0,0,1,12,20.33a2.54,2.54,0,0,1-2.53-2.79l.06-3.69-2-.06-.06,3.69A4.6,4.6,0,0,0,12,22.14ZM16.54,6.46a4.48,4.48,0,1,0-9,0l.06,3.69H9.53L9.47,6.46a2.59,2.59,0,1,1,5.17,0l-.06,3.69h1.9C16.54,10.09,16.54,6.46,16.54,6.46Z" />
			</svg>
		),
		desktop: (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path d="M20 2.6H4c-1.1 0-2 .9-2 2v11c0 1.1.9 2 2 2h7v2H8v2h8v-2h-3v-2h7c1.1 0 2-.9 2-2v-11c0-1.1-.9-2-2-2zm-16 11v-9h16v9H4z" />
			</svg>
		),
		tablet: (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path d="M20 2H4c-1.1 0-2 .9-2 2v16c0 1.1.8 2 1.9 2h16c1.1 0 2-.9 2-2V4c.1-1.1-.8-2-1.9-2zM4 20V4h15.8v16H4z" />
				<circle cx="12" cy="18" r="1" />
			</svg>
		),
		mobile: (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path d="M16.9 2h-10c-1.1 0-2 .9-2 2v16c0 1.1.9 2 2 2h10c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-10 18V4h10v16h-10z" />
				<circle cx="11.9" cy="18" r="1" />
			</svg>
		),
	},
	blockIcon: {
		courses: (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path d="M5.999 3H3.001L3 3.143v5.714L3.001 9h2.998L6 8.857V3.143L5.999 3ZM8 8.857c0 .265 0 .537-.02.757-.02.203-.073.582-.352.902-.304.347-.698.43-.924.459-.218.027-.482.025-.704.025H3c-.222 0-.486.002-.704-.025-.226-.029-.62-.112-.924-.46-.28-.319-.332-.698-.351-.9C.999 9.393 1 9.121 1 8.856V3.143c0-.264 0-.537.02-.757.02-.203.073-.582.352-.902.304-.347.698-.43.924-.459C2.514.998 2.778 1 3 1h3c.222 0 .486-.002.704.025.226.03.62.112.924.46.28.319.332.698.351.9.022.221.021.494.021.758v5.714ZM20.999 14h-2.998l-.001.143v5.715l.001.142h2.998l.001-.142v-5.715L20.999 14ZM23 19.858c0 .264 0 .536-.02.756-.02.203-.073.582-.352.902-.304.347-.698.43-.924.459-.218.027-.482.025-.704.025h-3c-.222 0-.485.002-.704-.025-.226-.029-.62-.112-.924-.46-.28-.319-.332-.698-.352-.9-.02-.221-.02-.493-.02-.757v-5.715c0-.264 0-.537.02-.757.02-.203.073-.582.352-.902.304-.347.698-.43.924-.459.219-.027.482-.025.704-.025h3c.222 0 .486-.002.704.025.226.03.62.112.924.46.28.319.332.698.352.9.02.221.02.494.02.758v5.715ZM13.999 3h-2.998L11 3.143v5.714l.001.143h2.998L14 8.857V3.143L13.999 3ZM16 8.857c0 .265 0 .537-.02.757-.02.203-.073.582-.352.902-.304.347-.698.43-.924.459-.218.027-.482.025-.704.025h-3c-.222 0-.486.002-.704-.025-.226-.029-.62-.112-.924-.46-.28-.319-.332-.698-.351-.9C8.999 9.393 9 9.121 9 8.856V3.143c0-.264 0-.537.02-.757.02-.203.073-.582.352-.902.304-.347.698-.43.924-.459C10.515.998 10.778 1 11 1h3c.222 0 .486-.002.704.025.226.03.62.112.924.46.28.319.332.698.351.9.022.221.021.494.021.758v5.714ZM21 3h-2v6h2V3Zm2 5.857c0 .269 0 .53-.016.739-.014.181-.05.527-.265.835-.268.383-.65.5-.9.539-.209.033-.453.03-.619.03h-2.4c-.166 0-.41.003-.62-.03a1.319 1.319 0 0 1-.899-.54c-.215-.307-.251-.653-.265-.834-.017-.209-.016-.47-.016-.739V3.143c0-.269 0-.53.016-.739.014-.18.05-.526.265-.835.268-.382.65-.5.9-.539.209-.033.453-.03.619-.03h2.4c.166 0 .41-.003.62.03.248.04.63.157.899.54.215.307.251.653.265.834.017.21.016.47.016.739v5.714ZM5 14H3v6h2v-6Zm2 5.858c0 .268 0 .529-.016.738-.014.181-.05.527-.265.835-.268.383-.65.5-.9.539-.209.033-.453.03-.619.03H2.8c-.166 0-.41.003-.62-.03a1.319 1.319 0 0 1-.899-.54c-.215-.307-.251-.653-.265-.834-.017-.209-.016-.47-.016-.738v-5.715c0-.269 0-.53.016-.739.014-.18.05-.527.265-.835.268-.382.65-.5.9-.539.209-.033.453-.03.619-.03h2.4c.166 0 .41-.003.62.03.248.04.63.157.899.54.215.307.251.653.265.834.017.21.016.47.016.739v5.715ZM12.999 14h-2.998l-.001.143v5.715l.001.142h2.998l.001-.142v-5.715L12.999 14ZM15 19.858c0 .264 0 .536-.02.756-.02.203-.073.582-.352.902-.304.347-.698.43-.924.459-.218.027-.482.025-.704.025h-3c-.222 0-.486.002-.704-.025-.226-.029-.62-.112-.924-.46-.28-.319-.332-.698-.351-.9-.022-.221-.021-.493-.021-.757v-5.715c0-.264 0-.537.02-.757.02-.203.073-.582.352-.902.304-.347.698-.43.924-.459.218-.027.482-.025.704-.025h3c.222 0 .486-.002.704.025.226.03.62.112.924.46.28.319.332.698.351.9.022.221.021.494.021.758v5.715Z" />
			</svg>
		),
		'course-categories': (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path d="M9 2c.225 0 .479-.002.688.02.201.023.583.087.893.397.31.31.374.692.397.894.023.209.021.463.021.688v5.604c-.003.125-.009.411-.129.68a1.177 1.177 0 0 1-.848.678c-.203.044-.433.038-.522.038H4c-.222 0-.448.003-.605 0-.126-.004-.411-.01-.679-.13a1.175 1.175 0 0 1-.678-.85C1.995 9.819 2 9.589 2 9.5V4c0-.222-.004-.448 0-.605.004-.126.01-.411.13-.679a1.177 1.177 0 0 1 .849-.678C3.18 1.994 3.41 2 3.5 2H9ZM4 9h5V4H4v5Zm16-7c.225 0 .479-.002.688.021.202.023.583.087.893.397.31.31.375.692.397.893.023.21.021.463.021.689v5.603c-.003.126-.008.412-.128.68a1.176 1.176 0 0 1-.849.679c-.202.043-.433.038-.521.038h-5.502c-.221 0-.447.003-.604-.001-.126-.003-.41-.009-.679-.129a1.176 1.176 0 0 1-.677-.85C12.995 9.818 13 9.59 13 9.5L12.998 4c0-.222-.003-.448.002-.606.003-.125.01-.41.13-.678a1.176 1.176 0 0 1 .848-.678c.202-.043.433-.038.522-.038H20Zm-5 7h5V4h-5v5Zm5.562 8.75a2.813 2.813 0 1 0-5.625 0 2.813 2.813 0 0 0 5.625 0Zm1.875 0a4.688 4.688 0 1 1-9.375 0 4.688 4.688 0 0 1 9.375 0ZM9 13c.225 0 .479-.002.688.02.201.023.583.087.893.397.31.31.374.692.397.894.023.209.021.463.021.688v5.604c-.003.125-.009.411-.129.68a1.177 1.177 0 0 1-.848.678c-.203.044-.433.038-.522.038H4c-.222 0-.448.003-.605 0-.126-.004-.411-.01-.679-.13a1.175 1.175 0 0 1-.678-.85c-.043-.2-.038-.43-.038-.519V15c0-.222-.004-.448 0-.605.004-.126.01-.411.13-.679a1.176 1.176 0 0 1 .849-.678C3.18 12.994 3.41 13 3.5 13H9Zm-5 7h5v-5H4v5Z" />
			</svg>
		),
		'course-category': (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path d="M9 2c.225 0 .479-.002.688.02.201.023.583.087.893.397.31.31.374.692.397.894.023.209.021.463.021.688v5.604c-.003.125-.009.411-.129.68a1.177 1.177 0 0 1-.848.678c-.203.044-.433.038-.522.038H4c-.222 0-.448.003-.605 0-.126-.004-.411-.01-.679-.13a1.175 1.175 0 0 1-.678-.85C1.995 9.819 2 9.589 2 9.5V4c0-.222-.004-.448 0-.605.004-.126.01-.411.13-.679a1.177 1.177 0 0 1 .849-.678C3.18 1.994 3.41 2 3.5 2H9ZM4 9h5V4H4v5Zm16-7c.225 0 .479-.002.688.021.202.023.583.087.893.397.31.31.375.692.397.893.023.21.021.463.021.689v5.603c-.003.126-.008.412-.128.68a1.176 1.176 0 0 1-.849.679c-.202.043-.433.038-.521.038h-5.502c-.221 0-.447.003-.604-.001-.126-.003-.41-.009-.679-.129a1.176 1.176 0 0 1-.677-.85C12.995 9.818 13 9.59 13 9.5L12.998 4c0-.222-.003-.448.002-.606.003-.125.01-.41.13-.678a1.176 1.176 0 0 1 .848-.678c.202-.043.433-.038.522-.038H20Zm-5 7h5V4h-5v5Zm5.562 8.75a2.813 2.813 0 1 0-5.625 0 2.813 2.813 0 0 0 5.625 0Zm1.875 0a4.688 4.688 0 1 1-9.375 0 4.688 4.688 0 0 1 9.375 0ZM9 13c.225 0 .479-.002.688.02.201.023.583.087.893.397.31.31.374.692.397.894.023.209.021.463.021.688v5.604c-.003.125-.009.411-.129.68a1.177 1.177 0 0 1-.848.678c-.203.044-.433.038-.522.038H4c-.222 0-.448.003-.605 0-.126-.004-.411-.01-.679-.13a1.175 1.175 0 0 1-.678-.85c-.043-.2-.038-.43-.038-.519V15c0-.222-.004-.448 0-.605.004-.126.01-.411.13-.679a1.176 1.176 0 0 1 .849-.678C3.18 12.994 3.41 13 3.5 13H9Zm-5 7h5v-5H4v5Z" />
			</svg>
		),
		'single-course-title': (
			<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
				<path
					fill="#000"
					fillRule="evenodd"
					d="M2 3a1 1 0 0 1 1-1h18a1 1 0 0 1 1 1v3.375a1 1 0 1 1-2 0V4h-7v16h2.375a1 1 0 1 1 0 2h-6.75a1 1 0 1 1 0-2H11V4H4v2.375a1 1 0 0 1-2 0V3Z"
					clipRule="evenodd"
				/>
			</svg>
		),
		'course-search-form': (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path d="M10 21V7a1 1 0 1 1 2 0v14a1 1 0 1 1-2 0Z" />
				<path d="M21 4.5a1 1 0 1 1-2 0V4h-4.4c-.654 0-1.304.288-1.802.84a3.199 3.199 0 0 0-.784 1.852L12 7l-.005.103A1 1 0 0 1 10 7c0-.828-.297-1.603-.798-2.16-.435-.483-.988-.764-1.557-.826L7.4 4H3v13h5.3c1.017 0 1.968.45 2.652 1.21.017.018.032.037.048.056.016-.019.031-.038.048-.056.684-.76 1.635-1.21 2.652-1.21h5.238l.01-.047A3.811 3.811 0 0 0 19 16.5a1 1 0 1 1 2 0 5.032 5.032 0 0 1-.2 1.283 1.625 1.625 0 0 1-.32.593c-.347.385-.84.624-1.38.624h-5.4c-.415 0-.837.182-1.166.548-.29.323-.481.762-.524 1.243l-.015.311A1 1 0 0 1 10 21c0-.562-.202-1.083-.534-1.452C9.136 19.182 8.715 19 8.3 19H2.9c-.54 0-1.033-.24-1.38-.624A2.059 2.059 0 0 1 1 17V4c0-.498.177-.995.52-1.376C1.868 2.239 2.36 2 2.9 2h4.5l.235.007c1.167.064 2.254.608 3.053 1.496.11.123.215.25.312.383a4.74 4.74 0 0 1 .312-.383C12.164 2.556 13.344 2 14.6 2h4.5l.2.01c.46.052.877.277 1.18.614.343.381.52.878.52 1.376v.5Z" />
				<path d="M19.393 11.393a1 1 0 0 1 1.414 0l1.9 1.9a1 1 0 0 1-1.414 1.415l-1.9-1.9a1 1 0 0 1 0-1.415Z" />
				<path d="M20 10a2 2 0 1 0-4 0 2 2 0 0 0 4 0Zm2 0a4 4 0 1 1-8 0 4 4 0 0 1 8 0Z" />
			</svg>
		),
		'course-reviews': (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path d="M20 4.223c0-.356-.128-.68-.33-.903a.925.925 0 0 0-.583-.315L19 3H5a.9.9 0 0 0-.67.32 1.35 1.35 0 0 0-.33.903v15.17l2.257-2.506.074-.076A1 1 0 0 1 7 16.556h12c.23 0 .473-.101.67-.32.202-.224.33-.547.33-.903V4.223Zm2 11.11c0 .822-.294 1.63-.843 2.24a2.904 2.904 0 0 1-2.157.983H7.445l-3.702 4.113A1 1 0 0 1 2 22V4.223c0-.823.293-1.631.843-2.242A2.904 2.904 0 0 1 5 1h14c.831 0 1.605.368 2.157.981.55.61.843 1.42.843 2.242v11.11Z" />
				<path d="M12 5.2a1 1 0 0 1 .423.093l.126.07.113.086c.071.063.133.134.184.212l.068.121.924 1.963a.086.086 0 0 0 .023.031.028.028 0 0 0 .013.006l2.066.318a.99.99 0 0 1 .4.154l.114.087.1.1c.06.072.111.15.15.235l.05.129.031.133a1.036 1.036 0 0 1-.277.89l-1.494 1.527a.1.1 0 0 0-.023.04.132.132 0 0 0-.004.06l.353 2.154a1.032 1.032 0 0 1-.389.985 1.009 1.009 0 0 1-1.1.079l-1.842-1.017a.02.02 0 0 0-.009-.003l-.009.002.001.001-1.846 1.017a1.005 1.005 0 0 1-1.43-.525 1.032 1.032 0 0 1-.055-.538l.353-2.156a.132.132 0 0 0-.004-.06.1.1 0 0 0-.023-.04l-1.49-1.523a1.025 1.025 0 0 1-.25-1.026l.049-.13a1.008 1.008 0 0 1 .766-.576l2.065-.317a.031.031 0 0 0 .013-.006.086.086 0 0 0 .023-.03l.924-1.964a1.03 1.03 0 0 1 .365-.419l.126-.07c.13-.06.275-.093.422-.093Zm-2.327 8.575-.004.005.01-.004h-.006Zm.006.001-.01.004.004-.005.006.001Zm1.931-5.35a1.686 1.686 0 0 1-.5.623 1.63 1.63 0 0 1-.74.315l-.951.145.712.726.132.153a1.733 1.733 0 0 1 .33 1.325l-.16.976.787-.434.183-.087a1.613 1.613 0 0 1 1.377.087l.787.433-.159-.976a1.733 1.733 0 0 1 .055-.791 1.7 1.7 0 0 1 .407-.686l.711-.726-.95-.146a1.63 1.63 0 0 1-.74-.315 1.681 1.681 0 0 1-.5-.62L12 7.598l-.39.829Zm-3.394.693v-.007l-.001.001v.006Z" />
			</svg>
		),
		'course-rating': (
			<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
				<path
					fill="#000"
					fillRule="evenodd"
					d="M4.727 2A2.727 2.727 0 0 0 2 4.727v14.546A2.727 2.727 0 0 0 4.727 22h14.546A2.727 2.727 0 0 0 22 19.273V4.727A2.727 2.727 0 0 0 19.273 2H4.727Zm-.909 2.727a.91.91 0 0 1 .91-.909h14.545a.91.91 0 0 1 .909.91v14.545a.91.91 0 0 1-.91.909H4.728a.91.91 0 0 1-.909-.91V4.728Zm8.875 1.476a.773.773 0 0 0-1.386 0L9.801 9.254l-3.367.492a.773.773 0 0 0-.428 1.319l2.436 2.372-.575 3.352a.773.773 0 0 0 1.122.815L12 16.02l3.011 1.584a.773.773 0 0 0 1.122-.815l-.575-3.352 2.436-2.372a.773.773 0 0 0-.428-1.319L14.2 9.254l-1.506-3.05Zm-1.685 4.099L12 8.292l.992 2.01c.113.228.33.386.582.423l2.22.324-1.606 1.565a.773.773 0 0 0-.222.684l.379 2.21-1.985-1.045a.772.772 0 0 0-.72 0l-1.985 1.044.38-2.21a.773.773 0 0 0-.223-.683l-1.606-1.565 2.22-.324a.773.773 0 0 0 .582-.423Z"
					clipRule="evenodd"
				/>
			</svg>
		),
		'course-price': (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path d="M21 12a9 9 0 1 0-18 0 9 9 0 0 0 18 0Zm2 0c0 6.075-4.925 11-11 11S1 18.075 1 12 5.925 1 12 1s11 4.925 11 11Z" />
				<path d="M15 14a1 1 0 0 0-1-1h-4a3 3 0 0 1-2.985-2.703L7 10a3 3 0 0 1 3-3h6a1 1 0 1 1 0 2h-6a1 1 0 0 0-1 1l.005.099A1 1 0 0 0 10 11h4a3 3 0 0 1 0 6H8a1 1 0 1 1 0-2h6a1 1 0 0 0 1-1Z" />
				<path d="M11 18V6a1 1 0 1 1 2 0v12a1 1 0 1 1-2 0Z" />
			</svg>
		),
		'course-pagination': (
			<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
				<path
					stroke="#000"
					strokeLinecap="round"
					strokeLinejoin="round"
					strokeWidth="2"
					d="M14 12h8m0 0-4-4m4 4-4 4M6 16l-4-4m0 0 4-4m-4 4h8"
				/>
			</svg>
		),
		'course-overview': (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path d="M9 21V7a1 1 0 0 1 2 0v14a1 1 0 1 1-2 0Z" />
				<path d="M9.001 21c0-.594-.191-1.13-.484-1.496C8.228 19.144 7.89 19 7.6 19H2a1 1 0 0 1-1-.999L1.001 17V4L1 3.401v-.4A1 1 0 0 1 2 2h4.8c1.196 0 2.282.595 3.044 1.547.054.067.106.137.156.207a4.5 4.5 0 0 1 .157-.207C10.92 2.595 12.005 2 13.2 2h5.801a1 1 0 0 1 1 1v2a1 1 0 0 1-2 0V4h-4.8c-.503 0-1.044.248-1.482.796-.388.485-.647 1.151-.705 1.886L11 7l-.006.103A1 1 0 0 1 9.001 7c0-.859-.275-1.65-.719-2.204C7.844 4.248 7.302 4 6.801 4H3v13h4.6c.942 0 1.792.45 2.399 1.161.607-.71 1.458-1.16 2.4-1.161H18v-1.5a1 1 0 0 1 2 0V18a1 1 0 0 1-1 1h-6.6c-.29 0-.628.143-.917.504-.256.32-.434.771-.474 1.276L11 21l-.006.102A1 1 0 0 1 9.001 21Z" />
				<path d="M17.397 7.015a5.374 5.374 0 0 1 4.572 3.311.5.5 0 0 1 0 .348l-.165.362a5.375 5.375 0 0 1-1.815 2.056l-.339.209A5.373 5.373 0 0 1 17 14v-1.4c.787 0 1.557-.233 2.21-.671A3.973 3.973 0 0 0 20.5 10.5a3.973 3.973 0 0 0-1.29-1.429 3.974 3.974 0 0 0-5.712 1.429 3.973 3.973 0 0 0 1.29 1.429c.655.438 1.425.67 2.212.67V14l-.398-.015a5.376 5.376 0 0 1-2.253-.684l-.338-.21a5.377 5.377 0 0 1-1.98-2.417.5.5 0 0 1-.023-.262l.023-.086a5.377 5.377 0 0 1 1.657-2.184l.323-.234A5.374 5.374 0 0 1 17 7l.397.015Z" />
				<path d="M17.8 10.5c0-.437-.143-.793-.323-1.019-.178-.222-.355-.28-.477-.28-.123 0-.3.058-.478.28-.18.226-.322.582-.322 1.019 0 .437.142.793.322 1.019.179.223.355.28.478.28V13c-1.105 0-2-1.12-2-2.5S15.895 8 17 8c1.104 0 2 1.12 2 2.5s-.896 2.5-2 2.5v-1.2c.122 0 .299-.059.477-.281.18-.226.323-.582.323-1.019Z" />
			</svg>
		),
		'course-highlights': (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path d="M10 21V7a1 1 0 1 1 2 0v14a1 1 0 1 1-2 0Z" />
				<path d="M21 4a1 1 0 1 1-2 0h-4.4c-.654 0-1.304.288-1.802.84C12.298 5.398 12 6.173 12 7a1 1 0 1 1-2 0c0-.828-.297-1.603-.798-2.16C8.705 4.289 8.054 4 7.4 4H3v13h5.3c1.017 0 1.968.45 2.652 1.21.017.018.032.037.048.056.016-.019.031-.038.048-.056.684-.76 1.635-1.21 2.652-1.21H19a1 1 0 1 1 2 0c0 .498-.177.995-.52 1.376-.347.385-.84.624-1.38.624h-5.4c-.415 0-.837.182-1.166.548-.332.369-.534.89-.534 1.452a1 1 0 1 1-2 0c0-.562-.202-1.083-.534-1.452C9.136 19.182 8.715 19 8.3 19H2.9c-.54 0-1.033-.24-1.38-.624A2.059 2.059 0 0 1 1 17V4c0-.498.177-.995.52-1.376C1.868 2.239 2.36 2 2.9 2h4.5c1.256 0 2.436.556 3.288 1.503.11.123.215.25.312.383a4.74 4.74 0 0 1 .312-.383C12.164 2.556 13.344 2 14.6 2h4.5c.54 0 1.033.24 1.38.624.343.381.52.878.52 1.376Z" />
				<path d="M18 5.2a1 1 0 0 1 .423.093l.126.07.113.086c.072.063.133.134.184.212l.068.121.924 1.963a.086.086 0 0 0 .023.031.028.028 0 0 0 .013.006l2.066.318a.99.99 0 0 1 .4.154l.114.087.1.1c.06.072.111.15.15.235l.05.129.031.133a1.036 1.036 0 0 1-.277.89l-1.494 1.527a.1.1 0 0 0-.023.04.132.132 0 0 0-.004.06l.353 2.154a1.032 1.032 0 0 1-.389.985 1.009 1.009 0 0 1-1.1.079l-1.842-1.017a.02.02 0 0 0-.009-.003l-.009.002.001.001-1.846 1.017a1.005 1.005 0 0 1-1.43-.525 1.033 1.033 0 0 1-.055-.538l.353-2.156a.132.132 0 0 0-.004-.06.102.102 0 0 0-.023-.04l-1.49-1.523a1.026 1.026 0 0 1-.25-1.026l.049-.13a1.022 1.022 0 0 1 .766-.576l2.065-.317a.031.031 0 0 0 .013-.006.086.086 0 0 0 .023-.03l.924-1.964a1.03 1.03 0 0 1 .365-.419l.126-.07c.13-.06.275-.093.422-.093Zm-2.327 8.575-.004.005.01-.004h-.006Zm.006.001-.01.004.004-.005.006.001Zm1.931-5.35a1.686 1.686 0 0 1-.5.623 1.63 1.63 0 0 1-.74.315l-.951.145.712.726.132.153a1.733 1.733 0 0 1 .33 1.325l-.16.976.787-.434.183-.087a1.613 1.613 0 0 1 1.377.087l.787.433-.159-.976a1.733 1.733 0 0 1 .055-.791 1.7 1.7 0 0 1 .407-.686l.711-.726-.95-.146a1.63 1.63 0 0 1-.74-.315 1.681 1.681 0 0 1-.5-.62L18 7.598l-.39.829Zm-3.394.693v-.007l-.001.001v.006Z" />
			</svg>
		),
		'course-feature-image': (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path d="M20 5a1 1 0 0 0-1-1H5a1 1 0 0 0-1 1v14a1 1 0 0 0 1 1h14a1 1 0 0 0 1-1V5Zm2 14a3 3 0 0 1-3 3H5a3 3 0 0 1-3-3V5a3 3 0 0 1 3-3h14a3 3 0 0 1 3 3v14Z" />
				<path d="M10 9a1 1 0 1 0-2 0 1 1 0 0 0 2 0Zm2 0a3 3 0 1 1-6 0 3 3 0 0 1 6 0Zm4.5 1.328a3 3 0 0 1 2.121.878l3.086 3.087a1 1 0 0 1-1.414 1.414l-3.086-3.086a1 1 0 0 0-1.414 0l-9.086 9.086a1 1 0 0 1-1.414-1.414l9.086-9.086a3.001 3.001 0 0 1 2.121-.879Z" />
			</svg>
		),
		'course-enroll-button': (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path d="M20 5a1 1 0 0 0-1-1H5a1 1 0 0 0-1 1v14a1 1 0 0 0 1 1h14a1 1 0 0 0 1-1V5Zm2 14a3 3 0 0 1-3 3H5a3 3 0 0 1-3-3V5a3 3 0 0 1 3-3h14a3 3 0 0 1 3 3v14Z" />
				<path d="M14.293 9.293a1 1 0 1 1 1.414 1.414l-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 1 1 1.414-1.414L11 12.586l3.293-3.293Z" />
			</svg>
		),
		'course-curriculum': (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path d="M21 11a1 1 0 1 1 0 2H10a1 1 0 1 1 0-2h11Zm0 6a1 1 0 1 1 0 2H10a1 1 0 1 1 0-2h11Zm0-12a1 1 0 1 1 0 2H10a1 1 0 0 1 0-2h11ZM6 9a1 1 0 1 1 0 2H4a1 1 0 1 1 0-2h2Z" />
				<path d="M4 10V7a1 1 0 0 1 0-2h1l.103.005A1 1 0 0 1 6 6v4a1 1 0 1 1-2 0Zm-.447 3.106c.736-.368 1.57-.413 2.27-.063C6.546 13.405 7 14.133 7 15c0 .576-.282 1.042-.512 1.35a6.677 6.677 0 0 1-.579.65H6a1 1 0 0 1 0 2H4a1 1 0 0 1-.995-.897L3 18c0-.576.282-1.043.513-1.35.238-.318.543-.62.78-.857.263-.263.458-.461.595-.643a.899.899 0 0 0 .108-.175.238.238 0 0 0-.022-.104.105.105 0 0 0-.046-.039c-.05-.025-.216-.07-.48.063a1 1 0 0 1-.895-1.79Z" />
			</svg>
		),
		'course-contents': (
			<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
				<path
					fill="#000"
					fillRule="evenodd"
					d="M5 2a3 3 0 0 0-3 3v14a3 3 0 0 0 3 3h14a3 3 0 0 0 3-3V5a3 3 0 0 0-3-3H5ZM4 5a1 1 0 0 1 1-1h14a1 1 0 0 1 1 1v14a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V5Zm3 2a1 1 0 0 0 0 2h10a1 1 0 1 0 0-2H7Zm-1 5a1 1 0 0 1 1-1h6.667a1 1 0 1 1 0 2H7a1 1 0 0 1-1-1Zm1 3a1 1 0 1 0 0 2h7.778a1 1 0 1 0 0-2H7Z"
					clipRule="evenodd"
				/>
			</svg>
		),
		'course-author': (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path d="M21 12a9 9 0 1 0-18 0 9 9 0 0 0 18 0Zm2 0c0 6.075-4.925 11-11 11S1 18.075 1 12 5.925 1 12 1s11 4.925 11 11Z" />
				<path d="M14 10a2 2 0 1 0-4 0 2 2 0 0 0 4 0Zm2 0a4 4 0 1 1-8 0 4 4 0 0 1 8 0Zm0 10.662V19a1 1 0 0 0-1-1H9a1 1 0 0 0-1 1v1.662a1 1 0 0 1-2 0V19a3 3 0 0 1 3-3h6a3 3 0 0 1 3 3v1.662a1 1 0 0 1-2 0Z" />
			</svg>
		),
		'course-archieve-view': (
			<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
				<path
					fill="#000"
					fillRule="evenodd"
					d="M2 4a2 2 0 0 1 2-2h16a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V4Zm18 0H4v5h16V4ZM2 15a2 2 0 0 1 2-2h5a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2v-5Zm7 0H4v5h5v-5Zm6-2a2 2 0 0 0-2 2v5a2 2 0 0 0 2 2h5a2 2 0 0 0 2-2v-5a2 2 0 0 0-2-2h-5Zm0 2h5v5h-5v-5Z"
					clipRule="evenodd"
				/>
			</svg>
		),
		'single-course': (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path d="M11 21V7a1 1 0 1 1 2 0v14a1 1 0 1 1-2 0Zm7-10a1 1 0 1 1 0 2h-2a1 1 0 1 1 0-2h2Zm0-4a1 1 0 1 1 0 2h-2a1 1 0 1 1 0-2h2Z" />
				<path d="M16 4a3 3 0 0 0-3 3l-.005.103A1 1 0 0 1 11 7a3 3 0 0 0-3-3H3v13h6a4 4 0 0 1 3 1.355A4 4 0 0 1 15 17h6V4h-5Zm7 13a2 2 0 0 1-2 2h-6a2 2 0 0 0-2 2 1 1 0 1 1-2 0 2 2 0 0 0-1.803-1.99L9 19H3a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h5a5 5 0 0 1 4 2.001A5 5 0 0 1 16 2h5a2 2 0 0 1 2 2v13Z" />
				<path d="M8 11a1 1 0 1 1 0 2H6a1 1 0 1 1 0-2h2Zm0-4a1 1 0 0 1 0 2H6a1 1 0 0 1 0-2h2Z" />
			</svg>
		),
		'course-stats': (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path d="M20 5a1 1 0 0 0-1-1H5a1 1 0 0 0-1 1v14a1 1 0 0 0 1 1h14a1 1 0 0 0 1-1V5Zm2 14a3 3 0 0 1-3 3H5a3 3 0 0 1-3-3V5a3 3 0 0 1 3-3h14a3 3 0 0 1 3 3v14Z" />
				<path d="M11.417 17.25v-2.917a.583.583 0 1 1 1.166 0v2.917a.583.583 0 0 1-1.166 0Zm2.335 0v-4.083a.583.583 0 1 1 1.166 0v4.083a.584.584 0 1 1-1.166 0Zm2.33 0v-6.417a.583.583 0 1 1 1.166 0v6.417a.583.583 0 0 1-1.166 0Zm1.183-11.065a.8.8 0 0 1 1.132 1.13l-5.044 5.044a1.09 1.09 0 0 1-1.545 0l-1.56-1.561-3.518 3.517a.8.8 0 1 1-1.13-1.13l3.876-3.877.08-.073c.195-.159.44-.248.693-.248l.107.006c.215.021.418.106.584.242l.08.073 1.56 1.56 4.685-4.683ZM6.752 17.25V15.5a.583.583 0 1 1 1.166 0v1.75a.583.583 0 1 1-1.166 0Z" />
				<path d="M9.082 17.25v-4.083a.583.583 0 1 1 1.166 0v4.083a.584.584 0 1 1-1.166 0Z" />
			</svg>
		),
		'course-coming-soon': (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path d="M9 21V7a1 1 0 0 1 2 0v14a1 1 0 1 1-2 0Z" />
				<path d="M9.001 21c0-.594-.191-1.13-.484-1.496C8.228 19.144 7.89 19 7.6 19H2a1 1 0 0 1-1-.999L1.001 17V4L1 3.401v-.4A1 1 0 0 1 2 2h4.8c1.196 0 2.282.595 3.044 1.547.054.067.106.137.156.207a4.5 4.5 0 0 1 .157-.207C10.92 2.595 12.005 2 13.2 2h5.801a1 1 0 0 1 1 1v1.5a1 1 0 0 1-2 0V4h-4.8c-.503 0-1.044.248-1.482.796-.388.485-.647 1.151-.705 1.886L11 7l-.006.103A1 1 0 0 1 9.001 7c0-.859-.275-1.65-.719-2.204C7.844 4.248 7.302 4 6.801 4H3v13h4.6c.942 0 1.792.45 2.399 1.161.607-.71 1.458-1.16 2.4-1.161H18v-.5a1 1 0 1 1 2 0V18a1 1 0 0 1-1 1h-6.6c-.29 0-.628.143-.917.504-.256.32-.434.771-.474 1.276L11 21l-.006.102A1 1 0 0 1 9.001 21Z" />
				<path d="M17 9a.5.5 0 0 1 1 0v1.139l1.158.386a.5.5 0 0 1-.316.95l-1.5-.5A.5.5 0 0 1 17 10.5V9Z" />
				<path d="M20.4 10.5a2.9 2.9 0 1 0-2.9 2.9V15a4.5 4.5 0 1 1 0-9 4.5 4.5 0 0 1 0 9v-1.6a2.9 2.9 0 0 0 2.9-2.9Z" />
			</svg>
		),
		'group-price-button': (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path d="M1 7.994c0-.39.094-.784.283-1.133.188-.345.47-.647.833-.842l8.565-4.68.152-.077A2.71 2.71 0 0 1 11.99 1c.46 0 .908.119 1.31.339h-.001l8.585 4.691c.364.196.645.498.833.843.19.349.283.742.283 1.133 0 .39-.094.784-.283 1.133-.188.345-.47.646-.835.841v.001l-8.573 4.68a2.698 2.698 0 0 1-2.466.077l-.153-.077-8.562-4.686a2.07 2.07 0 0 1-.845-.848A2.38 2.38 0 0 1 1 7.994Zm2 0c0 .074.019.137.041.178.011.02.02.031.025.036h-.002l.012.007 8.574 4.691A.726.726 0 0 0 12 13c.112 0 .23-.029.349-.094h.002l8.574-4.68.01-.006c-.014.007.002.005.024-.035a.384.384 0 0 0 .041-.18.38.38 0 0 0-.041-.177c-.022-.04-.038-.044-.023-.036l-.012-.006-8.584-4.692A.726.726 0 0 0 11.99 3a.725.725 0 0 0-.35.094l-8.565 4.68-.01.006c.014-.007-.002-.005-.024.035a.384.384 0 0 0-.041.18Z" />
				<path d="M21.992 12a1 1 0 0 1 1.008.992 2 2 0 0 1-1.18 1.84l-8.576 3.898-.002.001a3 3 0 0 1-2.474 0h-.001l-8.601-3.91-.006-.004A2 2 0 0 1 1 12.997a1 1 0 0 1 1.999.005l8.593 3.907a1.004 1.004 0 0 0 .824 0l8.58-3.9.004-.001A1 1 0 0 1 21.992 12Z" />
				<path d="M21.992 16a1 1 0 0 1 1.008.992 2 2 0 0 1-1.18 1.84l-8.576 3.898-.002.001a3 3 0 0 1-2.474 0h-.001l-8.601-3.91-.006-.004A2 2 0 0 1 1 16.997a1 1 0 0 1 1.999.005l8.593 3.907a1.004 1.004 0 0 0 .824 0l8.58-3.9.004-.001A1 1 0 0 1 21.992 16Zm-8.136-8.541a.564.564 0 0 0-.795.06l-1.387 1.614a1.563 1.563 0 1 1-2.372-2.038l2.08-2.42a.5.5 0 0 1 .758.65l-2.08 2.422a.564.564 0 0 0 .856.734l1.386-1.614a1.565 1.565 0 0 1 2.373 2.038l-2.08 2.42a.5.5 0 0 1-.758-.65l2.08-2.422a.564.564 0 0 0-.06-.794Z" />
				<path d="M14.086 10.458 9.245 6.3a.5.5 0 0 1 .651-.759L14.738 9.7l.07.074a.5.5 0 0 1-.638.744l-.084-.059Z" />
			</svg>
		),
		'course-user-progress': (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path d="M12 1a11 11 0 0 1 8.118 18.425 1 1 0 0 1-1.475-1.35 9.002 9.002 0 0 0-1.725-13.614A9.002 9.002 0 0 0 12 3a1 1 0 0 1 0-2Z" />
				<path d="M11.995 7.4a1.8 1.8 0 0 1 .746.162l5.139 2.341-.001.001a1.198 1.198 0 0 1 .006 2.196l-.001-.001-5.144 2.334a1.798 1.798 0 0 1-1.492 0l-5.13-2.34A1.198 1.198 0 0 1 6.11 9.9l5.138-2.337a1.82 1.82 0 0 1 .747-.163ZM6.608 11l5.138 2.343a.601.601 0 0 0 .497 0l5.152-2.337.006-.003a.47.47 0 0 1-.018-.008l-5.139-2.34a.604.604 0 0 0-.498 0l-5.139 2.338-.007.003.008.004Z" />
				<path d="M17.389 14.595v-3.597a.6.6 0 1 1 1.199 0v3.598a.6.6 0 0 1-1.2 0Zm-9.592 0v-2.098a.6.6 0 0 1 1.2 0v2.098c0 .135.121.436.72.736.573.286 1.392.463 2.277.463.885 0 1.703-.177 2.276-.463.6-.3.721-.6.721-.736v-2.098a.6.6 0 0 1 1.2 0v2.098c0 .82-.636 1.433-1.385 1.808-.777.388-1.789.59-2.812.59s-2.035-.202-2.812-.59c-.749-.375-1.385-.989-1.385-1.808ZM1.55 8.563a1 1 0 0 1 1.9.624 9.002 9.002 0 0 0-.45 2.7 1 1 0 0 1-2-.025 11 11 0 0 1 .55-3.3Zm.882 6.52a1 1 0 0 1 1.315.519 9 9 0 0 0 2.188 3.06 1 1 0 0 1-1.35 1.477 11 11 0 0 1-2.672-3.74 1 1 0 0 1 .519-1.316ZM4.88 3.616A1 1 0 1 1 6.174 5.14a9.12 9.12 0 0 0-.802.771A1 1 0 1 1 3.9 4.56c.307-.334.634-.649.98-.943Zm10.967 16.52a1 1 0 0 1 .856 1.808 11.001 11.001 0 0 1-8.395.418 1.001 1.001 0 0 1 .672-1.883 9 9 0 0 0 6.867-.343Z" />
			</svg>
		),
		'chevron-down': (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path d="M20.5 6.2L12 14.7 3.5 6.2 2 7.8l10 10 9.9-10-1.4-1.6z" />
			</svg>
		),
		'chevron-up': (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path d="M2 16.1l1.4 1.4L12 8.9l8.6 8.6 1.4-1.4-10-10-10 10z" />
			</svg>
		),
		'chevron-up-circle': (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path
					d="M22 12c0 5.5-4.5 10-10 10S2 17.5 2 12 6.5 2 12 2s10 4.5 10 10zM2.5 12c0 5.3 4.3 9.5 9.5 9.5s9.5-4.3 9.5-9.5-4.2-9.5-9.5-9.5c-5.2 0-9.5 4.3-9.5 9.5z"
					fill="#e2e8f0"
				/>
				<path d="M7.7 14.9l4.3-4.3 4.3 4.3.8-.8-5-5-5 5 .6.8z" fill="#64748b" />
			</svg>
		),
		'chevron-down-circle': (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path
					d="M12,22A10,10,0,1,1,22,12,10,10,0,0,1,12,22ZM12,2.49A9.51,9.51,0,1,0,21.51,12,9.53,9.53,0,0,0,12,2.49Z"
					fill="#e2e8f0"
				/>
				<path
					d="M16.28,9.1,12,13.35,7.78,9.1,7,9.9l5,5L17,9.9Z"
					fill="#64748b"
				/>
			</svg>
		),
		courseName: (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path
					fill="none"
					stroke="#000"
					strokeLinecap="round"
					strokeLinejoin="round"
					d="M7.5 4.5c1.55.16 2.95.84 4.5 1v14l-2.5-2h-7v-13c1.61.17 3.39-.17 5 0Zm9.05 0c-1.55.16-3 .84-4.5 1v14l2.5-2h7v-13c-1.61.17-3.39-.17-5 0Z"
				/>
				<circle
					cx="18.55"
					cy="14.25"
					r="5.25"
					fill="#fff"
					stroke="#fff"
					strokeMiterlimit="10"
					strokeWidth=".25"
				/>
				<path d="M15.05 12.31H16v-.78h2V17h-1.39v.75h3.88V17H19v-5.47h2v.78h1.05v-1.56h-7Z" />
				<path
					fill="none"
					stroke="#000"
					strokeLinecap="round"
					strokeMiterlimit="10"
					d="M4.5 8.5h4.97M4.5 11.6H8"
				/>
			</svg>
		),
		courseCompletionDate: (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path
					fill="none"
					stroke="#000"
					strokeLinecap="round"
					strokeLinejoin="round"
					d="M3 4.5h18m-14-2v2m10-2v2M4.5 7.5h15v13h-15zM9 13.5l2 2 4-4"
				/>
			</svg>
		),
		certificationVerificationCode: (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path
					fill="none"
					stroke="#000"
					strokeLinecap="round"
					strokeLinejoin="round"
					d="M12 2.5l2.5 7.5h7.5l-6 4.5 2.5 7.5-6-4.5-6 4.5 2.5-7.5-6-4.5h7.5z"
				/>
				<path d="M12 6l1.5 4.5h3l-2.5 2.5 1.5 4.5-4-3-4 3 1.5-4.5-2.5-2.5h3z" />
			</svg>
		),
		courseStartDate: (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path
					fill="none"
					stroke="#000"
					strokeLinecap="round"
					strokeLinejoin="round"
					d="M3 4.5h18m-14-2v2m10-2v2M4.5 7.5h15v13h-15zM9 10.5h6v6H9z"
				/>
			</svg>
		),
		courseGradeResult: (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path
					fill="none"
					stroke="#000"
					strokeLinecap="round"
					strokeLinejoin="round"
					d="M12 3.5l3 6 6 .9-4.5 4.4 1 6-5.5-3-5.5 3 1-6L3 10.4l6-.9z"
				/>
			</svg>
		),
		instructorName: (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path
					fill="none"
					stroke="#000"
					strokeLinecap="round"
					strokeLinejoin="round"
					d="M12 12a5 5 0 1 0-5-5 5 5 0 0 0 5 5zm0 2c-5.33 0-8 2.67-8 8h16c0-5.33-2.67-8-8-8z"
				/>
			</svg>
		),
		coInstructorsName: (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path
					fill="none"
					stroke="#000"
					strokeLinecap="round"
					strokeLinejoin="round"
					d="M12 12a5 5 0 1 0-5-5 5 5 0 0 0 5 5zm0 2c-5.33 0-8 2.67-8 8h16c0-5.33-2.67-8-8-8z"
				/>
				<circle cx="16.5" cy="4.5" r="2.5" />
				<path d="M20.5 22h-8c0-2 1.33-4.67 4-4.67s4 2.67 4 4.67z" />
			</svg>
		),
		courseDuration: (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path
					fill="none"
					stroke="#000"
					strokeLinecap="round"
					strokeLinejoin="round"
					d="M12 1.5a10.5 10.5 0 1 0 10.5 10.5A10.5 10.5 0 0 0 12 1.5zM12 12V7m-3 0h6"
				/>
			</svg>
		),
		currentTimestamp: (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path
					fill="none"
					stroke="#000"
					strokeLinecap="round"
					strokeLinejoin="round"
					d="M12 1.5a10.5 10.5 0 1 0 10.5 10.5A10.5 10.5 0 0 0 12 1.5zM12 6v6.75h6M4.5 19.5L5.25 15.75M18.75 19.5L18 15.75"
				/>
			</svg>
		),
		studentName: (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path
					fill="none"
					stroke="#000"
					strokeLinecap="round"
					strokeLinejoin="round"
					d="M2.5 5h17.96v11.89H2.5z"
				/>
				<path
					fill="none"
					stroke="#000"
					strokeLinecap="round"
					strokeLinejoin="round"
					strokeWidth=".75"
					d="M4.17 12.68V9.21l2 3.47V9.21m7 3.47V9.21l-1.45 3.47-1.4-3.47v3.47m5.48-3.47h-1.65v3.47h1.65m0-1.73h-1.16M9.3 12.68 8.24 9.21l-1 3.47m.37-1h1"
				/>
				<ellipse
					cx="18.71"
					cy="15.72"
					fill="#fff"
					stroke="#fff"
					strokeMiterlimit="10"
					strokeWidth=".25"
					rx="3.71"
					ry="3.69"
				/>
				<path d="M17.43 14.29a1.29 1.29 0 0 0 2.57 0 1.29 1.29 0 1 0-2.57 0ZM21 18.43h.28v-.29a2 2 0 0 0-2-2h-1.14a2 2 0 0 0-2 2v.29Z" />
			</svg>
		),
		QRCode: (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<rect
					x="3"
					y="3"
					width="6"
					height="6"
					fill="none"
					stroke="#000"
					strokeLinecap="round"
					strokeLinejoin="round"
				/>
				<rect
					x="3"
					y="15"
					width="6"
					height="6"
					fill="none"
					stroke="#000"
					strokeLinecap="round"
					strokeLinejoin="round"
				/>
				<rect
					x="15"
					y="3"
					width="6"
					height="6"
					fill="none"
					stroke="#000"
					strokeLinecap="round"
					strokeLinejoin="round"
				/>
				<path
					d="M15 15h2v2h2v-2h2v4h-2v2h-4v-4h2v-2h-2v-2h-2v-2h2v2z"
					fill="none"
					stroke="#000"
					strokeLinecap="round"
					strokeLinejoin="round"
				/>
				<rect
					x="10"
					y="10"
					width="4"
					height="4"
					fill="none"
					stroke="#000"
					strokeLinecap="round"
					strokeLinejoin="round"
				/>
			</svg>
		),
		currentTime: (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path
					fill="none"
					stroke="#000"
					strokeLinecap="round"
					strokeLinejoin="round"
					d="M12 1.5a10.5 10.5 0 1 0 10.5 10.5A10.5 10.5 0 0 0 12 1.5zM12 6v6.75h6"
				/>
			</svg>
		),
		currentDate: (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
				<path
					fill="none"
					stroke="#000"
					strokeLinecap="round"
					strokeLinejoin="round"
					d="M3 4.5h18m-14-2v2m10-2v2M4.5 7.5h15v13h-15zM12 12v6m-3-3h6"
				/>
			</svg>
		),
	},
};
