<?php
/**
 * Display Other Products Page.
 *
 * @package miniOrange_LDAP_AD_Integration
 * @subpackage views
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>

<div class="mo_ldap_other_products_cards">

	<div id="mo_ldap_other_products_navbar" class="mo_ldap_other_products_nav">
		<div class="mo_ldap_other_products_opt mo_ldap_other_products_nav_checked" data-id="mo_ldap_local_other_product_0">
			WordPress Login and User Management
		</div>
		<div class="mo_ldap_other_products_opt" data-id="mo_ldap_local_other_product_1">
			Staff/Employee Business Directory for Active Directory
		</div>
		<div class="mo_ldap_other_products_opt" data-id="mo_ldap_local_other_product_2">
			LDAP/AD Login for Cloud & Shared Hosting
		</div>
		<div class="mo_ldap_other_products_opt" data-id="mo_ldap_local_other_product_3">
			WordPress LMS and LDAP/AD Integrations
		</div>
	</div>



	<div class="mo_ldap_other_products_card mo_ldap_other_current_product" id="mo_ldap_local_other_product_0" >
		<div class="other_product_card_description">
			<div class="other_product_card_description_heading">
				User Session and Login Management
			</div>
			<div class="other_product_card_description_para">
				This Plugin offers serveral functionalities, including bulkuser management, user redirection based on WordPress roles, user session management and more.
			</div>

			<a target="_blank" rel="noopener" style="text-decoration:none; color:#fff;" href="https://plugins.miniorange.com/wordpress-login-and-user-management-plugin">
				<button class="mo_ldap_other_products_card_learn_more">
					Learn More
				</button>
			</a>
		</div>
		<div class="other_product_card_image">
			<img src="<?php echo esc_url( MO_LDAP_LOCAL_IMAGES ) . 'otherProducts1.png'; ?>" width="100%">
		</div>
	</div>

	<div class="mo_ldap_other_products_card other_product_card_color2 mo_ldap_other_product" id="mo_ldap_local_other_product_1">
		<div class="other_product_card_description">
			<div class="other_product_card_description_heading">
				Staff/Employee Bussiness Directory for Active Directory
			</div>
			<div class="other_product_card_description_para">
			This Plugin allows you to search and display the users present in  your Active Directory/LDAP Server on a  WordPress page using a shortcode.
			</div>

			<a target="_blank" rel="noopener" style="text-decoration:none; color:#fff;" href="https://plugins.miniorange.com/wordpress-ldap-directory-search">
				<button class="mo_ldap_other_products_card_learn_more">
					Learn More
				</button>
			</a>
		</div>
		<div class="other_product_card_image">
			<img src="<?php echo esc_url( MO_LDAP_LOCAL_IMAGES ) . 'otherProducts2.png'; ?>" width="100%">
		</div>
	</div>

	<div class="mo_ldap_other_products_card other_product_card_color3 mo_ldap_other_product" id="mo_ldap_local_other_product_2" >
		<div class="other_product_card_description">
			<div class="other_product_card_description_heading">
				LDAP/AD Login for Cloud & Shared Hosting
			</div>
			<div class="other_product_card_description_para">
				Login to WordPress sites hosted on shared hosting platform using credentials stored in active directory and LDAP Directory systems.
			</div>

			<a target="_blank" rel="noopener" style="text-decoration:none; color:#fff;" href="https://plugins.miniorange.com/wordpress-ldap-login-cloud">
				<button class="mo_ldap_other_products_card_learn_more">
					Learn More
				</button>
			</a>
		</div>
		<div class="other_product_card_image">
			<img src="<?php echo esc_url( MO_LDAP_LOCAL_IMAGES ) . 'otherProducts3.png'; ?>" width="80%">
		</div>
	</div>

	<div class="mo_ldap_other_products_card other_product_card_color4 mo_ldap_other_product" id="mo_ldap_local_other_product_3">
		<div class="other_product_card_description">
			<div class="other_product_card_description_heading">
				WordPress LMS and LDAP/AD Integrations
			</div>
			<div class="other_product_card_description_para">
				Integrate WordPress LMS with your  LDAP / Active Directory. Access content on the LMS  platform using LDAP/Active Directory credentials.
			</div>
			<a target="_blank" rel="noopener" style="text-decoration:none; color:#fff;" href="https://plugins.miniorange.com/wordpress-lms-ldap-active-directory-integration">
				<button class="mo_ldap_other_products_card_learn_more">
					Learn More
				</button>
			</a>
		</div>
		<div class="other_product_card_image">
			<img src="<?php echo esc_url( MO_LDAP_LOCAL_IMAGES ) . 'otherProducts4.png'; ?>" width="100%">
		</div>
	</div>

</div>

