<?php
namespace LaStudioKitThemeBuilder\Modules\Woocommerce\Tags;

use LaStudioKitThemeBuilder\Modules\Woocommerce\Module;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Product_Gallery extends Base_Data_Tag {
	public function get_name() {
		return 'woocommerce-product-gallery-tag';
	}

	public function get_title() {
		return esc_html__( 'Product Gallery', 'lastudio-kit' );
	}

	public function get_group() {
		return Module::WOOCOMMERCE_GROUP;
	}

	public function get_categories() {
		return [ \Elementor\Modules\DynamicTags\Module::GALLERY_CATEGORY ];
	}

	public function get_value( array $options = [] ) {
		$product = wc_get_product();
		if ( ! $product ) {
			return [];
		}
		$value = [];

		$attachment_ids = $product->get_gallery_image_ids();

		foreach ( $attachment_ids as $attachment_id ) {
			$value[] = [
				'id' => $attachment_id,
			];
		}

		return $value;
	}
}
