<?php


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


/*
 * Add spamfilter fields to lost password form.
 *
 * @since 1.0.0
 */
function la_sentinelle_lostpassword_form() {

	echo la_sentinelle_get_spamfilters();

}
if (get_option( 'la_sentinelle-wppassword', 'false') === 'true') {
	// Add spamfilter fields to WordPress lost password form.
	add_action( 'lostpassword_form', 'la_sentinelle_lostpassword_form' );
	add_action( 'lostpassword_form', 'la_sentinelle_dead_enqueue' );

	// Add spamfilter fields to WooCommerce lost password form.
	add_action( 'woocommerce_lostpassword_form', 'la_sentinelle_lostpassword_form' );
}


/*
 * Check fields in lost password form.
 *
 * @param object errors WP_Error object containing any errors generated by using invalid credentials.
 * @param object user_data WP_User object if found, false if the user does not exist. Only since WP 5.4.0, not yet in Woo 4.7.1
 *
 * @return object errors.
 *
 * @since 1.0.0
 */
function la_sentinelle_lostpassword_post( $errors, $user_data = array() ) {

	if ( defined('XMLRPC_REQUEST') && XMLRPC_REQUEST ) {
		return;
	}

	// password reset on user profile admin page.
	if ( isset( $_POST['action'] ) && $_POST['action'] === 'send-password-reset' ) {
		return $errors;
	}

	la_sentinelle_check_spamfilters();

	$error_messages = la_sentinelle_get_default_error_messages();

	$user_array = (array) $user_data;
	$marker_sfs = la_sentinelle_check_stop_forum_spam_wplogin( $user_array ); // wplogin check should work the same for lost password.
	if ( $marker_sfs === 'spam' ) {
		$errors->add( 'likely_spammer', $error_messages['try_again'] );
	}

	$markers = la_sentinelle_check_scores();
	if ( is_array( $markers ) && ! empty( $markers ) ) {
		$errors->add( 'likely_spammer', $error_messages['try_again'] );
	}
	if ( ( is_array( $markers ) && ! empty( $markers ) ) || $marker_sfs === 'spam' ) {
		la_sentinelle_add_statistic_blocked( 'wppassword' );
	}

	return $errors;

}
if (get_option( 'la_sentinelle-wppassword', 'false') === 'true') {

	// Check fields in lost password form for WordPress Core.
	add_action( 'lostpassword_post', 'la_sentinelle_lostpassword_post', 10, 2 );

	// Do not check fields in lost password form for WooCommerce, is already done in 'lostpassword_post' action above.
	//add_filter( 'allow_password_reset', 'la_sentinelle_lostpassword_post', 10, 2 );

}
