Koko Analytics for WordPress
===========
[![License: GPLv3](https://img.shields.io/badge/License-GPLv3-blue.svg)](https://raw.githubusercontent.com/ibericode/koko-analytics/master/LICENSE)
[![Active installs](https://img.shields.io/wordpress/plugin/installs/koko-analytics.svg)](https://wordpress.org/plugins/koko-analytics/advanced/)
[![Rating](https://img.shields.io/wordpress/plugin/r/koko-analytics.svg)](https://wordpress.org/support/plugin/koko-analytics/reviews/)
[![Lighthouse performance score](https://raw.githubusercontent.com/ibericode/koko-analytics/master/assets/src/github/lighthouse_performance.svg)](https://pagespeed.web.dev/analysis/https-www-kokoanalytics-com/e8d4epi2jf?form_factor=mobile)

**[Koko Analytics](https://www.kokoanalytics.com/) is a fast, privacy-friendly, open-source analytics plugin for WordPress — no cookies, no tracking, no external services.**

<figure>
  <img src="https://raw.githubusercontent.com/ibericode/koko-analytics/main/assets/src/img/screenshot-1-830x447.png" alt="Screenshot of the Koko Analytics dashboard" loading="lazy" width="830" height="447" />
  <figcaption>Screenshot of the Koko Analytics dashboard. You can <a href="https://www.kokoanalytics.com/?koko-analytics-dashboard">view a live demo here</a>.</figcaption>
</figure>

---

## Why Koko Analytics?

Koko Analytics is a simple replacement for Google Analytics that:

- Works out-of-the-box (no setup wizard or API keys)
- Stores all data on your server
- Tracks only aggregated counts, never personal data
- Respects GDPR and CCPA by design
- Loads lightning-fast with a script under 500 bytes

[See All Features →](https://www.kokoanalytics.com/features/)

---

### Koko Analytics Pro (optional add-on)

Upgrade for advanced insights while keeping your visitors’ privacy intact:

- 🌍 [Geo-location](https://www.kokoanalytics.com/features/geo-location/)
- 🔗 [Event Tracking](https://www.kokoanalytics.com/features/custom-event-tracking/)
- 📨 [Email Reports](https://www.kokoanalytics.com/features/email-reports/)
- 🛠 [CSV Export](https://www.kokoanalytics.com/features/csv-export/)
- 📈 [Pageviews Column in WP Admin](https://www.kokoanalytics.com/features/pageviews-column/)
- 📊 [Admin Bar stats](https://www.kokoanalytics.com/features/admin-bar/)
- 🚨 [Traffic Spike Notifications](https://www.kokoanalytics.com/features/traffic-spike-notifications/)

[Get Koko Analytics Pro →](https://www.kokoanalytics.com/pricing/)

---

## Quick Start

### Requirements

- WordPress 6.0+
- PHP 7.4+ (latest recommended)

### Install from WordPress.org

1. In your WordPress dashboard, go to **Plugins → Add New**
1. Search for “Koko Analytics”
1. Click **Install** and **Activate** — stats start recording immediately

### Install from GitHub (latest development version)

```sh
git clone git@github.com:ibericode/koko-analytics.git wp-content/plugins/koko-analytics
cd wp-content/plugins/koko-analytics
composer install
npm install
npm run build
```

---

## Usage

Once activated, visit Dashboard → Analytics in WordPress to view your stats.

See our [Knowledge Base](https://www.kokoanalytics.com/kb/) for advanced configuration, REST API usage, and code snippets.

---

## Contributing

Koko Analytics is open source and community-driven. You can:

- ⭐ Star this repo
- 🗣 [Suggest & vote on features](https://github.com/ibericode/koko-analytics/discussions)
- 🌍 [Translate the plugin](https://translate.wordpress.org/projects/wp-plugins/koko-analytics/stable/)
- 📝 Write about it on your blog or social media
- 💖 [Upgrade to Koko Analytics Pro](https://www.kokoanalytics.com/pricing/) to fund development

---

## License

GNU General Public License v3.0
