<?php
/**
 * Currencies
 *
 * @author    Pronamic <info@pronamic.eu>
 * @copyright 2005-2023 Pronamic
 * @license   GPL-3.0-or-later
 * @package   Pronamic\WordPress\Money
 */

namespace Pronamic\WordPress\Money;

/**
 * Currencies
 *
 * @link https://github.com/moneyphp/money/blob/v3.1.3/src/Currencies/ISOCurrencies.php#L90-L102
 * @link https://github.com/moneyphp/money/blob/v3.1.3/resources/currency.php
 *
 * @author Remco Tolsma
 * @version 1.2.2
 */
return [
	new Currency(
		'AED',
		'784',
		__( 'UAE Dirham', 'pronamic-money' ),
		'د.إ',
		2
	),
	new Currency(
		'AFN',
		'971',
		__( 'Afghan Afghani', 'pronamic-money' ),
		'؋',
		2
	),
	new Currency(
		'ALL',
		'008',
		__( 'Albanian Lek', 'pronamic-money' ),
		'L',
		2
	),
	new Currency(
		'AMD',
		'051',
		__( 'Armenian Dram', 'pronamic-money' ),
		'֏',
		2
	),
	new Currency(
		'ANG',
		'532',
		__( 'Netherlands Antillean Guilder', 'pronamic-money' ),
		'ƒ',
		2
	),
	new Currency(
		'AOA',
		'973',
		__( 'Angolan Kwanza', 'pronamic-money' ),
		'Kz',
		2
	),
	new Currency(
		'ARS',
		'032',
		__( 'Argentine Peso', 'pronamic-money' ),
		'$',
		2
	),
	new Currency(
		'AUD',
		'036',
		__( 'Australian Dollar', 'pronamic-money' ),
		'$',
		2
	),
	new Currency(
		'AWG',
		'533',
		__( 'Aruban Florin', 'pronamic-money' ),
		'ƒ',
		2
	),
	new Currency(
		'AZN',
		'944',
		__( 'Azerbaijan Manat', 'pronamic-money' ),
		'₼',
		2
	),
	new Currency(
		'BAM',
		'977',
		__( 'Bosnia and Herzegovina Convertible Mark', 'pronamic-money' ),
		'KM',
		2
	),
	new Currency(
		'BBD',
		'052',
		__( 'Barbados Dollar', 'pronamic-money' ),
		'$',
		2
	),
	new Currency(
		'BDT',
		'050',
		__( 'Bangladeshi Taka', 'pronamic-money' ),
		'৳',
		2
	),
	new Currency(
		'BGN',
		'975',
		__( 'Bulgarian Lev', 'pronamic-money' ),
		'лв.',
		2
	),
	new Currency(
		'BHD',
		'048',
		__( 'Bahraini Dinar', 'pronamic-money' ),
		'.د.ب',
		3
	),
	new Currency(
		'BIF',
		'108',
		__( 'Burundian Franc', 'pronamic-money' ),
		'FBu',
		0
	),
	new Currency(
		'BMD',
		'060',
		__( 'Bermudian Dollar', 'pronamic-money' ),
		'$',
		2
	),
	new Currency(
		'BND',
		'096',
		__( 'Brunei Dollar', 'pronamic-money' ),
		'$',
		2
	),
	new Currency(
		'BOB',
		'068',
		__( 'Bolíviano', 'pronamic-money' ),
		'$b',
		2
	),
	new Currency(
		'BOV',
		'984',
		__( 'Bolivian Mvdol', 'pronamic-money' ),
		null,
		2
	),
	new Currency(
		'BRL',
		'986',
		__( 'Brazilian Real', 'pronamic-money' ),
		'R$',
		2
	),
	new Currency(
		'BSD',
		'044',
		__( 'Bahamian Dollar', 'pronamic-money' ),
		'$',
		2
	),
	new Currency(
		'BTN',
		'064',
		__( 'Bhutanese Ngultrum', 'pronamic-money' ),
		'Nu.',
		2
	),
	new Currency(
		'BWP',
		'072',
		__( 'Botswana Pula', 'pronamic-money' ),
		'P',
		2
	),
	new Currency(
		'BYN',
		'933',
		__( 'Belarusian Ruble', 'pronamic-money' ),
		'Br',
		2
	),
	new Currency(
		'BZD',
		'084',
		__( 'Belize Dollar', 'pronamic-money' ),
		'$',
		2
	),
	new Currency(
		'CAD',
		'124',
		__( 'Canadian Dollar', 'pronamic-money' ),
		'$',
		2
	),
	new Currency(
		'CDF',
		'976',
		__( 'Congolese Franc', 'pronamic-money' ),
		'F',
		2
	),
	new Currency(
		'CHE',
		'947',
		__( 'WIR Euro', 'pronamic-money' ),
		'€',
		2
	),
	new Currency(
		'CHF',
		'756',
		__( 'Swiss Franc', 'pronamic-money' ),
		'F',
		2
	),
	new Currency(
		'CHW',
		'948',
		__( 'WIR Franc', 'pronamic-money' ),
		'F',
		2
	),
	new Currency(
		'CLF',
		'990',
		__( 'Unidad de Fomento', 'pronamic-money' ),
		'UF',
		4
	),
	new Currency(
		'CLP',
		'152',
		__( 'Chilean Peso', 'pronamic-money' ),
		'$',
		0
	),
	new Currency(
		'CNY',
		'156',
		__( 'Renminbi Yuan', 'pronamic-money' ),
		'元',
		2
	),
	new Currency(
		'COP',
		'170',
		__( 'Colombian Peso', 'pronamic-money' ),
		'$',
		2
	),
	new Currency(
		'COU',
		'970',
		__( 'Unidad de Valor Real', 'pronamic-money' ),
		'$',
		2
	),
	new Currency(
		'CRC',
		'188',
		__( 'Costa Rican Colon', 'pronamic-money' ),
		'₡',
		2
	),
	new Currency(
		'CUC',
		'931',
		__( 'Cuban Convertible Peso', 'pronamic-money' ),
		'$',
		2
	),
	new Currency(
		'CUP',
		'192',
		__( 'Cuban Peso', 'pronamic-money' ),
		'$',
		2
	),
	new Currency(
		'CVE',
		'132',
		__( 'Cape Verde Escudo', 'pronamic-money' ),
		'Esc',
		2
	),
	new Currency(
		'CZK',
		'203',
		__( 'Czech Koruna', 'pronamic-money' ),
		'Kč',
		2
	),
	new Currency(
		'DJF',
		'262',
		__( 'Djiboutian Franc', 'pronamic-money' ),
		'F',
		0
	),
	new Currency(
		'DKK',
		'208',
		__( 'Danish Krone', 'pronamic-money' ),
		'kr',
		2
	),
	new Currency(
		'DOP',
		'214',
		__( 'Dominican Peso', 'pronamic-money' ),
		'$',
		2
	),
	new Currency(
		'DZD',
		'012',
		__( 'Algerian Dinar', 'pronamic-money' ),
		'دج',
		2
	),
	new Currency(
		'EGP',
		'818',
		__( 'Egyptian Pound', 'pronamic-money' ),
		'£',
		2
	),
	new Currency(
		'ERN',
		'232',
		__( 'Eritrean Nakfa', 'pronamic-money' ),
		'Nfk',
		2
	),
	new Currency(
		'ETB',
		'230',
		__( 'Ethiopian Birr', 'pronamic-money' ),
		'Br',
		2
	),
	new Currency(
		'EUR',
		'978',
		__( 'Euro', 'pronamic-money' ),
		'€',
		2
	),
	new Currency(
		'FJD',
		'242',
		__( 'Fiji Dollar', 'pronamic-money' ),
		'$',
		2
	),
	new Currency(
		'FKP',
		'238',
		__( 'Falkland Islands Pound', 'pronamic-money' ),
		'£',
		2
	),
	new Currency(
		'GBP',
		'826',
		__( 'Pound Sterling', 'pronamic-money' ),
		'£',
		2
	),
	new Currency(
		'GEL',
		'981',
		__( 'Georgian Lari', 'pronamic-money' ),
		'ლ',
		2
	),
	new Currency(
		'GHS',
		'936',
		__( 'Ghanaian Cedi', 'pronamic-money' ),
		'GH₵',
		2
	),
	new Currency(
		'GIP',
		'292',
		__( 'Gibraltar Pound', 'pronamic-money' ),
		'£',
		2
	),
	new Currency(
		'GMD',
		'270',
		__( 'Gambian Dalasi', 'pronamic-money' ),
		'D',
		2
	),
	new Currency(
		'GNF',
		'324',
		__( 'Guinean Franc', 'pronamic-money' ),
		'F',
		0
	),
	new Currency(
		'GTQ',
		'320',
		__( 'Guatemalan Quetzal', 'pronamic-money' ),
		'Q',
		2
	),
	new Currency(
		'GYD',
		'328',
		__( 'Guyanese Dollar', 'pronamic-money' ),
		'$',
		2
	),
	new Currency(
		'HKD',
		'344',
		__( 'Hong Kong Dollar', 'pronamic-money' ),
		'$',
		2
	),
	new Currency(
		'HNL',
		'340',
		__( 'Honduran Lempira', 'pronamic-money' ),
		'L',
		2
	),
	new Currency(
		'HRK',
		'191',
		__( 'Croatian Kuna', 'pronamic-money' ),
		'kn',
		2
	),
	new Currency(
		'HTG',
		'332',
		__( 'Haitian Gourde', 'pronamic-money' ),
		'G',
		2
	),
	new Currency(
		'HUF',
		'348',
		__( 'Hungarian Forint', 'pronamic-money' ),
		'Ft',
		2
	),
	new Currency(
		'IDR',
		'360',
		__( 'Indonesian Rupiah', 'pronamic-money' ),
		'Rp',
		2
	),
	new Currency(
		'ILS',
		'376',
		__( 'Israeli New Sheqel', 'pronamic-money' ),
		'₪',
		2
	),
	new Currency(
		'INR',
		'356',
		__( 'Indian Rupee', 'pronamic-money' ),
		'₹',
		2
	),
	new Currency(
		'IQD',
		'368',
		__( 'Iraqi Dinar', 'pronamic-money' ),
		'د.ع',
		3
	),
	new Currency(
		'IRR',
		'364',
		__( 'Iranian Rial', 'pronamic-money' ),
		'﷼',
		2
	),
	new Currency(
		'ISK',
		'352',
		__( 'Icelandic Króna', 'pronamic-money' ),
		'kr',
		0
	),
	new Currency(
		'JMD',
		'388',
		__( 'Jamaican Dollar', 'pronamic-money' ),
		'$',
		2
	),
	new Currency(
		'JOD',
		'400',
		__( 'Jordanian Dinar', 'pronamic-money' ),
		'JD',
		3
	),
	new Currency(
		'JPY',
		'392',
		__( 'Japanese Yen', 'pronamic-money' ),
		'¥',
		0
	),
	new Currency(
		'KES',
		'404',
		__( 'Kenyan Shilling', 'pronamic-money' ),
		'Ksh',
		2
	),
	new Currency(
		'KGS',
		'417',
		__( 'Kyrgyzstani Som', 'pronamic-money' ),
		'С̲',
		2
	),
	new Currency(
		'KHR',
		'116',
		__( 'Cambodian Riel', 'pronamic-money' ),
		'៛',
		2
	),
	new Currency(
		'KMF',
		'174',
		__( 'Comorian Franc', 'pronamic-money' ),
		'F',
		0
	),
	new Currency(
		'KPW',
		'408',
		__( 'North Korean Won', 'pronamic-money' ),
		'₩',
		2
	),
	new Currency(
		'KRW',
		'410',
		__( 'South Korean Won', 'pronamic-money' ),
		'₩',
		0
	),
	new Currency(
		'KWD',
		'414',
		__( 'Kuwaiti Dinar', 'pronamic-money' ),
		'د.ك',
		3
	),
	new Currency(
		'KYD',
		'136',
		__( 'Cayman Islands Dollar', 'pronamic-money' ),
		'$',
		2
	),
	new Currency(
		'KZT',
		'398',
		__( 'Kazakhstani Tenge', 'pronamic-money' ),
		'₸',
		2
	),
	new Currency(
		'LAK',
		'418',
		__( 'Lao Kip', 'pronamic-money' ),
		'₭',
		2
	),
	new Currency(
		'LBP',
		'422',
		__( 'Lebanese Pound', 'pronamic-money' ),
		'LL',
		2
	),
	new Currency(
		'LKR',
		'144',
		__( 'Sri Lankan Rupee', 'pronamic-money' ),
		'₨',
		2
	),
	new Currency(
		'LRD',
		'430',
		__( 'Liberian Dollar', 'pronamic-money' ),
		'$',
		2
	),
	new Currency(
		'LSL',
		'426',
		__( 'Lesotho Loti', 'pronamic-money' ),
		/**
		 * Symbol based on plural form "maloti". The one-loti note employs the symbol L.
		 *
		 * @link https://en.wikipedia.org/wiki/Currency_symbol#List_of_currency_symbols_currently_in_use
		 */
		'M',
		2
	),
	new Currency(
		'LYD',
		'434',
		__( 'Libyan Dinar', 'pronamic-money' ),
		'ل.د',
		3
	),
	new Currency(
		'MAD',
		'504',
		__( 'Moroccan Dirham', 'pronamic-money' ),
		'د.م.',
		2
	),
	new Currency(
		'MDL',
		'498',
		__( 'Moldovan Leu', 'pronamic-money' ),
		'L',
		2
	),
	new Currency(
		'MGA',
		'969',
		__( 'Malagasy Ariary', 'pronamic-money' ),
		'Ar',
		2
	),
	new Currency(
		'MKD',
		'807',
		__( 'Macedonian Denar', 'pronamic-money' ),
		'ден',
		2
	),
	new Currency(
		'MMK',
		'104',
		__( 'Myanmar Kyat', 'pronamic-money' ),
		'K',
		2
	),
	new Currency(
		'MNT',
		'496',
		__( 'Mongolian Tögrög', 'pronamic-money' ),
		'₮',
		2
	),
	new Currency(
		'MOP',
		'446',
		__( 'Macanese Pataca', 'pronamic-money' ),
		'MOP$',
		2
	),
	new Currency(
		'MRO',
		'478',
		__( 'Mauritanian Ouguiya', 'pronamic-money' ),
		'UM',
		2
	),
	new Currency(
		'MUR',
		'480',
		__( 'Mauritian Rupee', 'pronamic-money' ),
		'₨',
		2
	),
	new Currency(
		'MVR',
		'462',
		__( 'Maldivian Rufiyaa', 'pronamic-money' ),
		'Rf.',
		2
	),
	new Currency(
		'MWK',
		'454',
		__( 'Malawian Kwacha', 'pronamic-money' ),
		'K',
		2
	),
	new Currency(
		'MXN',
		'484',
		__( 'Mexican Peso', 'pronamic-money' ),
		'$',
		2
	),
	new Currency(
		'MXV',
		'979',
		__( 'Mexican Unidad de Inversion (UDI)', 'pronamic-money' ),
		'UDI',
		2
	),
	new Currency(
		'MYR',
		'458',
		__( 'Malaysian Ringgit', 'pronamic-money' ),
		'RM',
		2
	),
	new Currency(
		'MZN',
		'943',
		__( 'Mozambican Metical', 'pronamic-money' ),
		'MT',
		2
	),
	new Currency(
		'NAD',
		'516',
		__( 'Namibian Dollar', 'pronamic-money' ),
		'$',
		2
	),
	new Currency(
		'NGN',
		'566',
		__( 'Nigerian Naira', 'pronamic-money' ),
		'₦',
		2
	),
	new Currency(
		'NIO',
		'558',
		__( 'Nicaraguan Córdoba', 'pronamic-money' ),
		'C$',
		2
	),
	new Currency(
		'NLG',
		null,
		__( 'Gulden', 'pronamic-money' ),
		'G',
		4
	),
	new Currency(
		'NOK',
		'578',
		__( 'Norwegian Krone', 'pronamic-money' ),
		'kr',
		2
	),
	new Currency(
		'NPR',
		'524',
		__( 'Nepalese Rupee', 'pronamic-money' ),
		'₨',
		2
	),
	new Currency(
		'NZD',
		'554',
		__( 'New Zealand Dollar', 'pronamic-money' ),
		'$',
		2
	),
	new Currency(
		'OMR',
		'512',
		__( 'Omani Rial', 'pronamic-money' ),
		'ر.ع.',
		3
	),
	new Currency(
		'PAB',
		'590',
		__( 'Panamanian Balboa', 'pronamic-money' ),
		'B/.',
		2
	),
	new Currency(
		'PEN',
		'604',
		__( 'Peruvian Sol', 'pronamic-money' ),
		'S/',
		2
	),
	new Currency(
		'PGK',
		'598',
		__( 'Papua New Guinean Kina', 'pronamic-money' ),
		'K',
		2
	),
	new Currency(
		'PHP',
		'608',
		__( 'Philippine Peso', 'pronamic-money' ),
		'₱',
		2
	),
	new Currency(
		'PKR',
		'586',
		__( 'Pakistani Rupee', 'pronamic-money' ),
		'₨',
		2
	),
	new Currency(
		'PLN',
		'985',
		__( 'Polish Zloty', 'pronamic-money' ),
		'zł',
		2
	),
	new Currency(
		'PYG',
		'600',
		__( 'Paraguayan Guaraní', 'pronamic-money' ),
		'₲',
		0
	),
	new Currency(
		'QAR',
		'634',
		__( 'Qatari Rial', 'pronamic-money' ),
		'ر.ق',
		2
	),
	new Currency(
		'RON',
		'946',
		__( 'Romanian Leu', 'pronamic-money' ),
		'L',
		2
	),
	new Currency(
		'RSD',
		'941',
		__( 'Serbian Dinar', 'pronamic-money' ),
		'дин',
		2
	),
	new Currency(
		'RUB',
		'643',
		__( 'Russian Ruble', 'pronamic-money' ),
		'₽',
		2
	),
	new Currency(
		'RWF',
		'646',
		__( 'Rwandan Franc', 'pronamic-money' ),
		'FRw',
		0
	),
	new Currency(
		'SAR',
		'682',
		__( 'Saudi Riyal', 'pronamic-money' ),
		'ر.س',
		2
	),
	new Currency(
		'SBD',
		'090',
		__( 'Solomon Islands Dollar', 'pronamic-money' ),
		'$',
		2
	),
	new Currency(
		'SCR',
		'690',
		__( 'Seychelles Rupee', 'pronamic-money' ),
		'SRe',
		2
	),
	new Currency(
		'SDG',
		'938',
		__( 'Sudanese Pound', 'pronamic-money' ),
		'ج.س',
		2
	),
	new Currency(
		'SEK',
		'752',
		__( 'Swedish Krona', 'pronamic-money' ),
		'kr',
		2
	),
	new Currency(
		'SGD',
		'702',
		__( 'Singapore Dollar', 'pronamic-money' ),
		'$',
		2
	),
	new Currency(
		'SHP',
		'654',
		__( 'Saint Helena Pound', 'pronamic-money' ),
		'£',
		2
	),
	new Currency(
		'SLL',
		'694',
		__( 'Sierra Leonean Leone', 'pronamic-money' ),
		'Le',
		2
	),
	new Currency(
		'SOS',
		'706',
		__( 'Somali Shilling', 'pronamic-money' ),
		'Sh.So.',
		2
	),
	new Currency(
		'SRD',
		'968',
		__( 'Surinamese Dollar', 'pronamic-money' ),
		'$',
		2
	),
	new Currency(
		'SSP',
		'728',
		__( 'South Sudanese Pound', 'pronamic-money' ),
		'SS£',
		2
	),
	new Currency(
		'STD',
		'678',
		__( 'São Tomé and Príncipe Dobra', 'pronamic-money' ),
		'Db',
		2
	),
	new Currency(
		'SVC',
		'222',
		__( 'Salvadoran Colon', 'pronamic-money' ),
		'₡',
		2
	),
	new Currency(
		'SYP',
		'760',
		__( 'Syrian Pound', 'pronamic-money' ),
		'£',
		2
	),
	new Currency(
		'SZL',
		'748',
		__( 'Swazi Lilangeni', 'pronamic-money' ),
		/**
		 * Symbol based on the plural form "emalangeni" However the one-lilageni note employs the currency symbol L.
		 *
		 * @link https://en.wikipedia.org/wiki/Currency_symbol#List_of_currency_symbols_currently_in_use
		 */
		'E',
		2
	),
	new Currency(
		'THB',
		'764',
		__( 'Thai Baht', 'pronamic-money' ),
		'฿',
		2
	),
	new Currency(
		'TJS',
		'972',
		__( 'Tajikistani Somoni', 'pronamic-money' ),
		'SM',
		2
	),
	new Currency(
		'TMT',
		'934',
		__( 'Turkmenistan Manat', 'pronamic-money' ),
		'T',
		2
	),
	new Currency(
		'TND',
		'788',
		__( 'Tunisian Dinar', 'pronamic-money' ),
		'د.ت',
		3
	),
	new Currency(
		'TOP',
		'776',
		__( 'Tongan Pa’anga', 'pronamic-money' ),
		'T$',
		2
	),
	new Currency(
		'TRY',
		'949',
		__( 'Turkish Lira', 'pronamic-money' ),
		'₺',
		2
	),
	new Currency(
		'TTD',
		'780',
		__( 'Trinidad and Tobago Dollar', 'pronamic-money' ),
		'$',
		2
	),
	new Currency(
		'TWD',
		'901',
		__( 'New Taiwan Dollar', 'pronamic-money' ),
		'$',
		2
	),
	new Currency(
		'TZS',
		'834',
		__( 'Tanzanian Shilling', 'pronamic-money' ),
		'Tsh',
		2
	),
	new Currency(
		'UAH',
		'980',
		__( 'Ukrainian Hryvnia', 'pronamic-money' ),
		'₴',
		2
	),
	new Currency(
		'UGX',
		'800',
		__( 'Ugandan Shilling', 'pronamic-money' ),
		'USh',
		0
	),
	new Currency(
		'USD',
		'840',
		__( 'US Dollar', 'pronamic-money' ),
		'$',
		2
	),
	new Currency(
		'USN',
		'997',
		__( 'US Dollar (Next day)', 'pronamic-money' ),
		'$',
		2
	),
	new Currency(
		'UYI',
		'940',
		__( 'Uruguay Peso en Unidades Indexadas (URUIURUI)', 'pronamic-money' ),
		'$',
		0
	),
	new Currency(
		'UYU',
		'858',
		__( 'Uruguayan Peso', 'pronamic-money' ),
		'$',
		2
	),
	new Currency(
		'UYW',
		'927',
		__( 'Unidad Previsional', 'pronamic-money' ),
		null,
		4
	),
	new Currency(
		'UZS',
		'860',
		__( 'Uzbekistan Som', 'pronamic-money' ),
		'лв',
		2
	),
	new Currency(
		'VES',
		'928',
		__( 'Venezuelan Bolívar Soberano', 'pronamic-money' ),
		'Bs.S.',
		2
	),
	new Currency(
		'VND',
		'704',
		__( 'Vietnamese Dồng', 'pronamic-money' ),
		'₫',
		0
	),
	new Currency(
		'VUV',
		'548',
		__( 'Vanuatu Vatu', 'pronamic-money' ),
		'VT',
		0
	),
	new Currency(
		'WST',
		'882',
		__( 'Samoan Tala', 'pronamic-money' ),
		'WS$',
		2
	),
	new Currency(
		'XAF',
		'950',
		__( 'CFA Franc BEAC', 'pronamic-money' ),
		'FCFA',
		0
	),
	new Currency(
		'XAG',
		'961',
		__( 'Silver', 'pronamic-money' ),
		'Ag oz t.',
		0
	),
	new Currency(
		'XAU',
		'959',
		__( 'Gold', 'pronamic-money' ),
		'Au oz t.',
		0
	),
	new Currency(
		'XBA',
		'955',
		__( 'Bond Markets Unit European Composite Unit (EURCO)', 'pronamic-money' ),
		null,
		0
	),
	new Currency(
		'XBB',
		'956',
		__( 'Bond Markets Unit European Monetary Unit (E.M.U.-6)', 'pronamic-money' ),
		null,
		0
	),
	new Currency(
		'XBC',
		'957',
		__( 'Bond Markets Unit European Unit of Account 9 (E.U.A.-9)', 'pronamic-money' ),
		null,
		0
	),
	new Currency(
		'XBD',
		'958',
		__( 'Bond Markets Unit European Unit of Account 17 (E.U.A.-17)', 'pronamic-money' ),
		null,
		0
	),
	new Currency(
		'XCD',
		'951',
		__( 'East Caribbean Dollar', 'pronamic-money' ),
		'$',
		2
	),
	new Currency(
		'XDR',
		'960',
		__( 'SDR (Special Drawing Right)', 'pronamic-money' ),
		'SDR',
		0
	),
	new Currency(
		'XOF',
		'952',
		__( 'CFA Franc BCEAO', 'pronamic-money' ),
		'CFA',
		0
	),
	new Currency(
		'XPD',
		'964',
		__( 'Palladium', 'pronamic-money' ),
		'Pd oz t.',
		0
	),
	new Currency(
		'XPF',
		'953',
		__( 'CFP Franc', 'pronamic-money' ),
		'F',
		0
	),
	new Currency(
		'XPT',
		'962',
		__( 'Platinum', 'pronamic-money' ),
		'Pt oz t.',
		0
	),
	new Currency(
		'XSU',
		'994',
		__( 'Sucre', 'pronamic-money' ),
		'Sucre',
		0
	),
	new Currency(
		'XTS',
		'963',
		__( 'Code reserved for testing', 'pronamic-money' ),
		null,
		0
	),
	new Currency(
		'XUA',
		'965',
		__( 'ADB Unit of Account', 'pronamic-money' ),
		null,
		0
	),
	new Currency(
		'XXX',
		'999',
		__( 'No currency', 'pronamic-money' ),
		null,
		0
	),
	new Currency(
		'YER',
		'886',
		__( 'Yemeni Rial', 'pronamic-money' ),
		'ر.ي',
		2
	),
	new Currency(
		'ZAR',
		'710',
		__( 'South African Rand', 'pronamic-money' ),
		'R',
		2
	),
	new Currency(
		'ZMW',
		'967',
		__( 'Zambian Kwacha', 'pronamic-money' ),
		'K',
		2
	),
	new Currency(
		'ZWL',
		'932',
		__( 'Zimbabwean Dollar', 'pronamic-money' ),
		'$',
		2
	),
];
