# Wordpress Query Builder Library

[![Latest Stable Version](https://poser.pugx.org/10quality/wp-query-builder/v/stable)](https://packagist.org/packages/10quality/wp-query-builder)
[![Total Downloads](https://poser.pugx.org/10quality/wp-query-builder/downloads)](https://packagist.org/packages/10quality/wp-query-builder)
[![License](https://poser.pugx.org/10quality/wp-query-builder/license)](https://packagist.org/packages/10quality/wp-query-builder)
[![Codacy Badge](https://api.codacy.com/project/badge/Grade/549d3f322a0a4eafa0ea2f4c6206a9b1)](https://www.codacy.com/manual/amostajo/wp-query-builder?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=10quality/wp-query-builder&amp;utm_campaign=Badge_Grade)

This package provides a SQL query builder class built on top of WordPress core Database accessor. Usability is similar to Laravel's Eloquent.

The library also provides an abstract class and a trait to be used on data models built for custom tables. The abstract class extends our generic [PHP model](https://github.com/10quality/php-data-model) class.

This is the perfect package to use within the [WordPress MVC](https://www.wordpress-mvc.com/) framework.

## Install

This package / library requires composer.

```bash
composer require 10quality/wp-query-builder
```

## Usage & Documentation

Please read the [wiki](https://github.com/10quality/wp-query-builder/wiki) for documentation.

## Coding Guidelines

PSR-2 coding guidelines.

## License

MIT License (c) 2019 [10 Quality](https://www.10quality.com/).