<?php

namespace King_Addons;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

final class SectionsMap
{
    public static function getSectionsMapArray(): array
    {
        return [
            'sections' => [
                't15-agency-section-1' => [
                    'title' => esc_html__('Our agency would like - Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-agency',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['hero', 'agency', 'image', 'styled text', 'text', 'button'],
                ],
                't15-agency-section-2' => [
                    'title' => esc_html__('Trusted by over 5,000 - Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-agency',
                    'section_number' => 2,
                    'images_count' => 5,
                    'tags' => ['header', 'agency', 'heading', 'image'],
                ],
                't15-agency-section-3' => [
                    'title' => esc_html__('We use the best - Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-agency',
                    'section_number' => 3,
                    'images_count' => 12,
                    'tags' => ['hero', 'agency', 'heading', 'text', 'image', 'button', 'king addons auto scrolling text'],
                ],
                't15-agency-section-4' => [
                    'title' => esc_html__('Our agency would like - Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-agency',
                    'section_number' => 4,
                    'images_count' => 5,
                    'tags' => ['hero', 'agency', 'heading', 'text', 'image', 'button'],
                ],
                't15-agency-section-5' => [
                    'title' => esc_html__('Our agency would like - Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-agency',
                    'section_number' => 5,
                    'images_count' => 4,
                    'tags' => ['header', 'agency', 'image', 'heading', 'text'],
                ],
                't15-agency-section-6' => [
                    'title' => esc_html__('Our agency would like - Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-agency',
                    'section_number' => 6,
                    'images_count' => 4,
                    'tags' => ['hero', 'agency', 'image', 'heading', 'text', 'button'],
                ],
                't15-broadband-section-1' => [
                    'title' => esc_html__('Get unlimited home broadband, - Broadband', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'internet & telecom',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-broadband',
                    'section_number' => 1,
                    'images_count' => 7,
                    'tags' => ['hero', 'broadband', 'styled text', 'text', 'button', 'image', 'heading'],
                ],
                't15-broadband-section-2' => [
                    'title' => esc_html__('In telecommunications, a broadband - Broadband', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'internet & telecom',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-broadband',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['cta', 'broadband', 'image', 'text', 'button'],
                ],
                't15-broadband-section-3' => [
                    'title' => esc_html__('In telecommunications, a broadband - Broadband', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'internet & telecom',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-broadband',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['cta', 'broadband', 'text', 'button', 'image'],
                ],
                't15-broadband-section-4' => [
                    'title' => esc_html__('Do you have any - Broadband', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'internet & telecom',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-broadband',
                    'section_number' => 4,
                    'images_count' => 0,
                    'tags' => ['hero', 'broadband', 'text', 'heading', 'icon list', 'button'],
                ],
                't15-broadband-section-5' => [
                    'title' => esc_html__('In telecommunications, a broadband - Broadband', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'internet & telecom',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-broadband',
                    'section_number' => 5,
                    'images_count' => 2,
                    'tags' => ['cta', 'broadband', 'image', 'text', 'button'],
                ],
                't15-broadband-section-6' => [
                    'title' => esc_html__('Get unlimited home broadband, - Broadband', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'internet & telecom',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-broadband',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['cta', 'broadband', 'text', 'button'],
                ],
                't15-business-consultant-section-1' => [
                    'title' => esc_html__('A business consultant is - Business Consultant', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-business-consultant',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['cta', 'business', 'consultant', 'text', 'button', 'image'],
                ],
                't15-business-consultant-section-2' => [
                    'title' => esc_html__('Strategic planning and critical - Business Consultant', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-business-consultant',
                    'section_number' => 2,
                    'images_count' => 4,
                    'tags' => ['header', 'business', 'consultant', 'image', 'heading'],
                ],
                't15-business-consultant-section-3' => [
                    'title' => esc_html__('A business consultant is - Business Consultant', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-business-consultant',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['cta', 'business', 'consultant', 'image', 'text', 'button'],
                ],
                't15-business-consultant-section-4' => [
                    'title' => esc_html__('Consultants can save their - Business Consultant', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-business-consultant',
                    'section_number' => 4,
                    'images_count' => 4,
                    'tags' => ['hero', 'business', 'consultant', 'text', 'heading', 'image', 'button'],
                ],
                't15-business-consultant-section-5' => [
                    'title' => esc_html__('A business consultant is - Business Consultant', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-business-consultant',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['cta', 'business', 'consultant', 'text', 'button', 'image'],
                ],
                't15-business-consultant-section-6' => [
                    'title' => esc_html__('Consultants can save their - Business Consultant', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-business-consultant',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['cta', 'business', 'consultant', 'text', 'button'],
                ],
                't15-business-consulting-1-section-1' => [
                    'title' => esc_html__('Our independent consulting company - Business Consulting 1', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-business-consulting-1',
                    'section_number' => 1,
                    'images_count' => 5,
                    'tags' => ['hero', 'business', 'consulting', 'text', 'styled text', 'button', 'image'],
                ],
                't15-business-consulting-1-section-2' => [
                    'title' => esc_html__('Plan your business  - Business Consulting 1', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-business-consulting-1',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['hero', 'business', 'consulting', 'image', 'heading', 'text', 'button'],
                ],
                't15-business-consulting-1-section-3' => [
                    'title' => esc_html__('Our independent consulting company - Business Consulting 1', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-business-consulting-1',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['cta', 'business', 'consulting', 'image', 'text', 'icon list', 'button'],
                ],
                't15-business-consulting-1-section-4' => [
                    'title' => esc_html__('Our independent consulting company - Business Consulting 1', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't15-business-consulting-1',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['content', 'business', 'consulting', 'text', 'counter', 'video'],
                ],
                't15-business-consulting-1-section-5' => [
                    'title' => esc_html__('Fell free to ask - Business Consulting 1', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-business-consulting-1',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['header', 'business', 'consulting', 'text', 'heading', 'accordion', 'image'],
                ],
                't15-business-consulting-1-section-6' => [
                    'title' => esc_html__('Our independent consulting company - Business Consulting 1', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-business-consulting-1',
                    'section_number' => 6,
                    'images_count' => 2,
                    'tags' => ['cta', 'business', 'consulting', 'text', 'button'],
                ],
                't15-business-consulting-2-section-1' => [
                    'title' => esc_html__('Our business consulting agency - Business Consulting 2', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-business-consulting-2',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['cta', 'business', 'consulting', 'image', 'text', 'button'],
                ],
                't15-business-consulting-2-section-2' => [
                    'title' => esc_html__('Our business consulting agency - Business Consulting 2', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-business-consulting-2',
                    'section_number' => 2,
                    'images_count' => 0,
                    'tags' => ['header', 'business', 'consulting', 'text', 'heading'],
                ],
                't15-business-consulting-2-section-3' => [
                    'title' => esc_html__('Our business consulting agency - Business Consulting 2', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-business-consulting-2',
                    'section_number' => 3,
                    'images_count' => 3,
                    'tags' => ['hero', 'business', 'consulting', 'image', 'heading', 'text', 'button'],
                ],
                't15-business-consulting-2-section-4' => [
                    'title' => esc_html__('Our business consulting agency - Business Consulting 2', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-business-consulting-2',
                    'section_number' => 4,
                    'images_count' => 9,
                    'tags' => ['cta', 'business', 'consulting', 'text', 'button', 'image', 'image carousel'],
                ],
                't15-business-consulting-2-section-5' => [
                    'title' => esc_html__('Our business consulting agency - Business Consulting 2', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-business-consulting-2',
                    'section_number' => 5,
                    'images_count' => 4,
                    'tags' => ['hero', 'business', 'consulting', 'text', 'heading', 'image', 'button'],
                ],
                't15-business-consulting-2-section-6' => [
                    'title' => esc_html__('Our business consulting agency - Business Consulting 2', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-business-consulting-2',
                    'section_number' => 6,
                    'images_count' => 6,
                    'tags' => ['header', 'business', 'consulting', 'text', 'heading', 'image'],
                ],
                't15-business-consulting-2-section-7' => [
                    'title' => esc_html__('Our business consulting agency - Business Consulting 2', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-business-consulting-2',
                    'section_number' => 7,
                    'images_count' => 2,
                    'tags' => ['header', 'business', 'consulting', 'image', 'text', 'heading', 'shortcode'],
                ],
                't15-business-consulting-3-section-1' => [
                    'title' => esc_html__('Our consulting agency brings - Business Consulting 3', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-business-consulting-3',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['cta', 'business', 'consulting', 'text', 'button', 'image'],
                ],
                't15-business-consulting-3-section-2' => [
                    'title' => esc_html__('Business Consulting 3 - Gallery Section 2', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'galleries',
                    'section_type' => 'gallery',
                    'parent_template' => 't15-business-consulting-3',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['gallery', 'business', 'consulting', 'image'],
                ],
                't15-business-consulting-3-section-3' => [
                    'title' => esc_html__('Quality services with the - Business Consulting 3', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-business-consulting-3',
                    'section_number' => 3,
                    'images_count' => 0,
                    'tags' => ['header', 'business', 'consulting', 'text', 'heading'],
                ],
                't15-business-consulting-3-section-4' => [
                    'title' => esc_html__('Finance and restructuring - Business Consulting 3', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-business-consulting-3',
                    'section_number' => 4,
                    'images_count' => 5,
                    'tags' => ['hero', 'business', 'consulting', 'image', 'heading', 'icon list', 'button'],
                ],
                't15-business-consulting-3-section-5' => [
                    'title' => esc_html__('An experienced firm with - Business Consulting 3', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-business-consulting-3',
                    'section_number' => 5,
                    'images_count' => 0,
                    'tags' => ['header', 'business', 'consulting', 'text', 'heading'],
                ],
                't15-business-consulting-3-section-6' => [
                    'title' => esc_html__('Our consulting agency brings - Business Consulting 3', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-business-consulting-3',
                    'section_number' => 6,
                    'images_count' => 2,
                    'tags' => ['header', 'business', 'consulting', 'image', 'heading', 'text'],
                ],
                't15-business-consulting-3-section-7' => [
                    'title' => esc_html__('Completed 1500+ projects  - Business Consulting 3', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-business-consulting-3',
                    'section_number' => 7,
                    'images_count' => 1,
                    'tags' => ['header', 'business', 'consulting', 'heading', 'counter'],
                ],
                't15-business-consulting-3-section-8' => [
                    'title' => esc_html__('Sed ut perspiciatis unde - Business Consulting 3', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-business-consulting-3',
                    'section_number' => 8,
                    'images_count' => 7,
                    'tags' => ['hero', 'business', 'consulting', 'text', 'heading', 'image', 'button'],
                ],
                't15-business-consulting-3-section-9' => [
                    'title' => esc_html__('\"An excellent job has - Business Consulting 3', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-business-consulting-3',
                    'section_number' => 9,
                    'images_count' => 3,
                    'tags' => ['header', 'business', 'consulting', 'image', 'text', 'heading'],
                ],
                't15-business-consulting-3-section-10' => [
                    'title' => esc_html__('Our consulting agency brings - Business Consulting 3', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-business-consulting-3',
                    'section_number' => 10,
                    'images_count' => 2,
                    'tags' => ['header', 'business', 'consulting', 'text', 'heading', 'shortcode'],
                ],
                't15-business-consulting-services-section-1' => [
                    'title' => esc_html__('More than 20 years - Business Consulting Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-business-consulting-services',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['cta', 'business', 'consulting', 'services', 'text', 'button', 'image'],
                ],
                't15-business-consulting-services-section-2' => [
                    'title' => esc_html__('Marketing and public relations - Business Consulting Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-business-consulting-services',
                    'section_number' => 2,
                    'images_count' => 4,
                    'tags' => ['header', 'business', 'consulting', 'services', 'image', 'heading'],
                ],
                't15-business-consulting-services-section-3' => [
                    'title' => esc_html__('Management consulting is the - Business Consulting Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-business-consulting-services',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['hero', 'business', 'consulting', 'services', 'image', 'text', 'heading', 'button'],
                ],
                't15-business-consulting-services-section-4' => [
                    'title' => esc_html__('Business Consulting Services - General Section 4', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't15-business-consulting-services',
                    'section_number' => 4,
                    'images_count' => 8,
                    'tags' => ['general', 'business', 'consulting', 'services', 'image carousel'],
                ],
                't15-business-consulting-services-section-5' => [
                    'title' => esc_html__('Management consulting is the - Business Consulting Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-business-consulting-services',
                    'section_number' => 5,
                    'images_count' => 2,
                    'tags' => ['hero', 'business', 'consulting', 'services', 'text', 'heading', 'icon list', 'button', 'image'],
                ],
                't15-business-consulting-services-section-6' => [
                    'title' => esc_html__('Management consulting is the - Business Consulting Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-business-consulting-services',
                    'section_number' => 6,
                    'images_count' => 3,
                    'tags' => ['hero', 'business', 'consulting', 'services', 'text', 'heading', 'icon list', 'button', 'testimonial'],
                ],
                't15-business-consulting-services-section-7' => [
                    'title' => esc_html__('Management consulting is the - Business Consulting Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-business-consulting-services',
                    'section_number' => 7,
                    'images_count' => 2,
                    'tags' => ['hero', 'business', 'consulting', 'services', 'image', 'heading', 'text', 'button'],
                ],
                't15-content-writing-agency-section-1' => [
                    'title' => esc_html__('Spend less time on - Content Writing Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-content-writing-agency',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['hero', 'content', 'writing', 'agency', 'image', 'text', 'styled text', 'button'],
                ],
                't15-content-writing-agency-section-2' => [
                    'title' => esc_html__('Spend less time on - Content Writing Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-content-writing-agency',
                    'section_number' => 2,
                    'images_count' => 0,
                    'tags' => ['header', 'content', 'writing', 'agency', 'heading', 'text'],
                ],
                't15-content-writing-agency-section-3' => [
                    'title' => esc_html__('Spend less time on - Content Writing Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-content-writing-agency',
                    'section_number' => 3,
                    'images_count' => 4,
                    'tags' => ['hero', 'content', 'writing', 'agency', 'text', 'image', 'heading', 'button'],
                ],
                't15-content-writing-agency-section-4' => [
                    'title' => esc_html__('Stop spending a lot - Content Writing Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't15-content-writing-agency',
                    'section_number' => 4,
                    'images_count' => 2,
                    'tags' => ['content', 'writing', 'agency', 'image', 'text'],
                ],
                't15-content-writing-agency-section-5' => [
                    'title' => esc_html__('Spend less time on - Content Writing Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-content-writing-agency',
                    'section_number' => 5,
                    'images_count' => 8,
                    'tags' => ['header', 'content', 'writing', 'agency', 'heading', 'text', 'image'],
                ],
                't15-content-writing-agency-section-6' => [
                    'title' => esc_html__('Content writing services are - Content Writing Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-content-writing-agency',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['cta', 'content', 'writing', 'agency', 'text', 'button', 'image'],
                ],
                't15-content-writing-agency-section-7' => [
                    'title' => esc_html__('Content writing services are - Content Writing Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-content-writing-agency',
                    'section_number' => 7,
                    'images_count' => 4,
                    'tags' => ['cta', 'content', 'writing', 'agency', 'text', 'button'],
                ],
                't15-creative-agency-section-1' => [
                    'title' => esc_html__('Our creative agency can - Creative Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-creative-agency',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['cta', 'creative', 'agency', 'text', 'button', 'image'],
                ],
                't15-creative-agency-section-2' => [
                    'title' => esc_html__('Our creative agency can - Creative Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-creative-agency',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['header', 'creative', 'agency', 'heading', 'text', 'image'],
                ],
                't15-creative-agency-section-3' => [
                    'title' => esc_html__('Welcome to our studio! - Creative Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-creative-agency',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['hero', 'creative', 'agency', 'heading', 'text', 'button', 'image'],
                ],
                't15-creative-agency-section-4' => [
                    'title' => esc_html__('Website design and development - Creative Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-creative-agency',
                    'section_number' => 4,
                    'images_count' => 4,
                    'tags' => ['hero', 'creative', 'agency', 'heading', 'text', 'image', 'button'],
                ],
                't15-creative-agency-section-5' => [
                    'title' => esc_html__('Welcome to our studio! - Creative Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-creative-agency',
                    'section_number' => 5,
                    'images_count' => 3,
                    'tags' => ['header', 'creative', 'agency', 'heading', 'text', 'video'],
                ],
                't15-creative-agency-section-6' => [
                    'title' => esc_html__('Welcome to our studio! - Creative Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-creative-agency',
                    'section_number' => 6,
                    'images_count' => 2,
                    'tags' => ['cta', 'creative', 'agency', 'text', 'button'],
                ],
                't15-digital-marketing-agency-section-1' => [
                    'title' => esc_html__('Our digital marketing agency - Digital Marketing Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-digital-marketing-agency',
                    'section_number' => 1,
                    'images_count' => 7,
                    'tags' => ['hero', 'digital', 'marketing', 'agency', 'text', 'button', 'image', 'heading'],
                ],
                't15-digital-marketing-agency-section-2' => [
                    'title' => esc_html__('Our digital marketing agency - Digital Marketing Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-digital-marketing-agency',
                    'section_number' => 2,
                    'images_count' => 0,
                    'tags' => ['header', 'digital', 'marketing', 'agency', 'heading', 'text'],
                ],
                't15-digital-marketing-agency-section-3' => [
                    'title' => esc_html__('Our digital marketing agency - Digital Marketing Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-digital-marketing-agency',
                    'section_number' => 3,
                    'images_count' => 3,
                    'tags' => ['header', 'digital', 'marketing', 'agency', 'image', 'heading', 'text'],
                ],
                't15-digital-marketing-agency-section-4' => [
                    'title' => esc_html__('Our digital marketing agency - Digital Marketing Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-digital-marketing-agency',
                    'section_number' => 4,
                    'images_count' => 0,
                    'tags' => ['header', 'digital', 'marketing', 'agency', 'heading', 'text'],
                ],
                't15-digital-marketing-agency-section-5' => [
                    'title' => esc_html__('Our digital marketing agency - Digital Marketing Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-digital-marketing-agency',
                    'section_number' => 5,
                    'images_count' => 3,
                    'tags' => ['hero', 'digital', 'marketing', 'agency', 'image', 'heading', 'text', 'button'],
                ],
                't15-digital-marketing-agency-section-6' => [
                    'title' => esc_html__('Our digital marketing agency - Digital Marketing Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-digital-marketing-agency',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['header', 'digital', 'marketing', 'agency', 'heading', 'text', 'icon list', 'image'],
                ],
                't15-digital-marketing-agency-section-7' => [
                    'title' => esc_html__('Marketing strategies already created - Digital Marketing Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't15-digital-marketing-agency',
                    'section_number' => 7,
                    'images_count' => 0,
                    'tags' => ['general', 'digital', 'marketing', 'agency', 'counter'],
                ],
                't15-digital-marketing-agency-section-8' => [
                    'title' => esc_html__('Our digital marketing agency - Digital Marketing Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-digital-marketing-agency',
                    'section_number' => 8,
                    'images_count' => 3,
                    'tags' => ['hero', 'digital', 'marketing', 'agency', 'heading', 'text', 'button'],
                ],
                't15-digital-marketing-agency-section-9' => [
                    'title' => esc_html__('Our digital marketing agency - Digital Marketing Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-digital-marketing-agency',
                    'section_number' => 9,
                    'images_count' => 3,
                    'tags' => ['header', 'digital', 'marketing', 'agency', 'heading', 'text', 'image'],
                ],
                't15-digital-marketing-agency-section-10' => [
                    'title' => esc_html__('Ready to grow your - Digital Marketing Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-digital-marketing-agency',
                    'section_number' => 10,
                    'images_count' => 1,
                    'tags' => ['hero', 'digital', 'marketing', 'agency', 'heading', 'button'],
                ],
                't15-digital-marketing-section-1' => [
                    'title' => esc_html__('Our digital marketing services - Digital Marketing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-digital-marketing',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['cta', 'digital', 'marketing', 'text', 'button', 'image'],
                ],
                't15-digital-marketing-section-2' => [
                    'title' => esc_html__('Our digital marketing services - Digital Marketing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-digital-marketing',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['header', 'digital', 'marketing', 'image', 'heading', 'text'],
                ],
                't15-digital-marketing-section-3' => [
                    'title' => esc_html__('Digital marketing is the - Digital Marketing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-digital-marketing',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['cta', 'digital', 'marketing', 'image', 'text', 'button'],
                ],
                't15-digital-marketing-section-4' => [
                    'title' => esc_html__('Digital marketing is the - Digital Marketing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-digital-marketing',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['cta', 'digital', 'marketing', 'text', 'button', 'video'],
                ],
                't15-digital-marketing-section-5' => [
                    'title' => esc_html__('Our digital marketing services - Digital Marketing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-digital-marketing',
                    'section_number' => 5,
                    'images_count' => 3,
                    'tags' => ['header', 'digital', 'marketing', 'text', 'heading', 'image'],
                ],
                't15-digital-marketing-section-6' => [
                    'title' => esc_html__('Digital marketing is the - Digital Marketing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-digital-marketing',
                    'section_number' => 6,
                    'images_count' => 6,
                    'tags' => ['cta', 'digital', 'marketing', 'text', 'button', 'image carousel'],
                ],
                't15-digital-marketing-section-7' => [
                    'title' => esc_html__('Average increase in the - Digital Marketing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't15-digital-marketing',
                    'section_number' => 7,
                    'images_count' => 0,
                    'tags' => ['general', 'digital', 'marketing', 'counter'],
                ],
                't15-digital-marketing-section-8' => [
                    'title' => esc_html__('Our digital marketing services - Digital Marketing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-digital-marketing',
                    'section_number' => 8,
                    'images_count' => 2,
                    'tags' => ['cta', 'digital', 'marketing', 'text', 'button'],
                ],
                't15-ebook-landing-section-1' => [
                    'title' => esc_html__('Learn how to create - Ebook Landing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'education',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-ebook-landing',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['cta', 'ebook', 'landing', 'text', 'button', 'image'],
                ],
                't15-ebook-landing-section-2' => [
                    'title' => esc_html__('An ebook, also known - Ebook Landing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'education',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-ebook-landing',
                    'section_number' => 2,
                    'images_count' => 6,
                    'tags' => ['hero', 'ebook', 'landing', 'text', 'image', 'heading', 'button'],
                ],
                't15-ebook-landing-section-3' => [
                    'title' => esc_html__('What will you learn - Ebook Landing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'education',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-ebook-landing',
                    'section_number' => 3,
                    'images_count' => 6,
                    'tags' => ['header', 'ebook', 'landing', 'heading', 'image box'],
                ],
                't15-ebook-landing-section-4' => [
                    'title' => esc_html__('What\'s Inside? - Ebook Landing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'education',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-ebook-landing',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['header', 'ebook', 'landing', 'heading', 'accordion', 'image'],
                ],
                't15-ebook-landing-section-5' => [
                    'title' => esc_html__('Learn how to create - Ebook Landing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'education',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-ebook-landing',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['hero', 'ebook', 'landing', 'image', 'heading', 'text', 'button'],
                ],
                't15-ebook-landing-section-6' => [
                    'title' => esc_html__('An ebook, also known - Ebook Landing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'education',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-ebook-landing',
                    'section_number' => 6,
                    'images_count' => 7,
                    'tags' => ['hero', 'ebook', 'landing', 'heading', 'testimonial', 'text', 'button', 'image'],
                ],
                't15-ebook-landing-section-7' => [
                    'title' => esc_html__('Learn how to create - Ebook Landing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'education',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-ebook-landing',
                    'section_number' => 7,
                    'images_count' => 1,
                    'tags' => ['cta', 'ebook', 'landing', 'image', 'text', 'button'],
                ],
                't15-email-marketing-services-section-1' => [
                    'title' => esc_html__('We are zero complexity - Email Marketing Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-email-marketing-services',
                    'section_number' => 1,
                    'images_count' => 4,
                    'tags' => ['cta', 'email', 'marketing', 'services', 'text', 'button', 'image'],
                ],
                't15-email-marketing-services-section-2' => [
                    'title' => esc_html__('Our service is a - Email Marketing Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-email-marketing-services',
                    'section_number' => 2,
                    'images_count' => 4,
                    'tags' => ['hero', 'email', 'marketing', 'services', 'text', 'image', 'heading', 'button'],
                ],
                't15-email-marketing-services-section-3' => [
                    'title' => esc_html__('Tired of dealing with - Email Marketing Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-email-marketing-services',
                    'section_number' => 3,
                    'images_count' => 4,
                    'tags' => ['cta', 'email', 'marketing', 'services', 'image', 'text', 'button'],
                ],
                't15-email-marketing-services-section-4' => [
                    'title' => esc_html__('Tired of dealing with - Email Marketing Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-email-marketing-services',
                    'section_number' => 4,
                    'images_count' => 2,
                    'tags' => ['cta', 'email', 'marketing', 'services', 'text', 'button', 'image'],
                ],
                't15-email-marketing-services-section-5' => [
                    'title' => esc_html__('Email Marketing Services - General Section 5', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't15-email-marketing-services',
                    'section_number' => 5,
                    'images_count' => 7,
                    'tags' => ['general', 'email', 'marketing', 'services', 'king addons auto scrolling text'],
                ],
                't15-email-marketing-services-section-6' => [
                    'title' => esc_html__('Tired of dealing with - Email Marketing Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-email-marketing-services',
                    'section_number' => 6,
                    'images_count' => 3,
                    'tags' => ['header', 'email', 'marketing', 'services', 'text', 'image', 'star rating', 'heading'],
                ],
                't15-email-marketing-services-section-7' => [
                    'title' => esc_html__('Tired of dealing with - Email Marketing Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-email-marketing-services',
                    'section_number' => 7,
                    'images_count' => 4,
                    'tags' => ['cta', 'email', 'marketing', 'services', 'text', 'button', 'image'],
                ],
                't15-event-2-section-1' => [
                    'title' => esc_html__('Master Classes, Live Work - Event 2', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'events',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-event-2',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['cta', 'event', 'text', 'button', 'icon box'],
                ],
                't15-event-2-section-2' => [
                    'title' => esc_html__('Baza has brought together - Event 2', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'events',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-event-2',
                    'section_number' => 2,
                    'images_count' => 6,
                    'tags' => ['hero', 'event', 'text', 'image', 'heading', 'button'],
                ],
                't15-event-2-section-3' => [
                    'title' => esc_html__('Master Classes, Live Work - Event 2', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'events',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-event-2',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['header', 'event', 'heading', 'text', 'counter', 'video'],
                ],
                't15-event-2-section-4' => [
                    'title' => esc_html__('What things are we - Event 2', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'events',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-event-2',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['header', 'event', 'text', 'heading', 'accordion', 'image'],
                ],
                't15-event-2-section-5' => [
                    'title' => esc_html__('Event 2 - General Section 5', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'events',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't15-event-2',
                    'section_number' => 5,
                    'images_count' => 4,
                    'tags' => ['general', 'event', 'image'],
                ],
                't15-event-2-section-6' => [
                    'title' => esc_html__('Master Classes, Live Work - Event 2', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'events',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-event-2',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['hero', 'event', 'heading', 'text', 'button'],
                ],
                't15-event-3-section-1' => [
                    'title' => esc_html__('Baza has brought together - Event 3', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'events',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-event-3',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['cta', 'event', 'text', 'button'],
                ],
                't15-event-3-section-2' => [
                    'title' => esc_html__('Master Classes, Live Work - Event 3', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'events',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-event-3',
                    'section_number' => 2,
                    'images_count' => 4,
                    'tags' => ['header', 'event', 'image', 'heading', 'text'],
                ],
                't15-event-3-section-3' => [
                    'title' => esc_html__('Event 3 - General Section 3', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'events',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't15-event-3',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['general', 'event', 'video'],
                ],
                't15-event-3-section-4' => [
                    'title' => esc_html__('Baza has brought together - Event 3', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'events',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-event-3',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['hero', 'event', 'text', 'button', 'spacer', 'heading'],
                ],
                't15-event-3-section-5' => [
                    'title' => esc_html__('Baza has brought together - Event 3', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'events',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-event-3',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['cta', 'event', 'image', 'text', 'button'],
                ],
                't15-event-3-section-6' => [
                    'title' => esc_html__('Event 3 - General Section 6', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'events',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't15-event-3',
                    'section_number' => 6,
                    'images_count' => 6,
                    'tags' => ['general', 'event', 'image'],
                ],
                't15-event-3-section-7' => [
                    'title' => esc_html__('Master Classes, Live Work - Event 3', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'events',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-event-3',
                    'section_number' => 7,
                    'images_count' => 3,
                    'tags' => ['header', 'event', 'text', 'heading', 'shortcode'],
                ],
                't15-event-section-1' => [
                    'title' => esc_html__('Baza has brought together - Event', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'events',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-event',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['cta', 'event', 'text', 'button', 'image'],
                ],
                't15-event-section-2' => [
                    'title' => esc_html__('Opportunities for growth - Event', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'events',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-event',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['header', 'event', 'image', 'heading'],
                ],
                't15-event-section-3' => [
                    'title' => esc_html__('Baza has brought together - Event', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'events',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-event',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['cta', 'event', 'text', 'button', 'image'],
                ],
                't15-event-section-4' => [
                    'title' => esc_html__('Baza has brought together - Event', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'events',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-event',
                    'section_number' => 4,
                    'images_count' => 6,
                    'tags' => ['header', 'event', 'text', 'heading', 'image'],
                ],
                't15-event-section-5' => [
                    'title' => esc_html__('Baza has brought together - Event', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'events',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-event',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['cta', 'event', 'image', 'text', 'button'],
                ],
                't15-event-section-6' => [
                    'title' => esc_html__('Baza has brought together - Event', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'events',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-event',
                    'section_number' => 6,
                    'images_count' => 2,
                    'tags' => ['cta', 'event', 'text', 'button', 'image'],
                ],
                't15-financial-consultant-section-1' => [
                    'title' => esc_html__('A financial advisor can - Financial Consultant', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-financial-consultant',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['cta', 'financial', 'consultant', 'text', 'button', 'image'],
                ],
                't15-financial-consultant-section-2' => [
                    'title' => esc_html__('Reevaluate your future goals - Financial Consultant', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-financial-consultant',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['hero', 'financial', 'consultant', 'image', 'heading', 'text', 'button'],
                ],
                't15-financial-consultant-section-3' => [
                    'title' => esc_html__('A financial advisor can - Financial Consultant', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-financial-consultant',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['hero', 'financial', 'consultant', 'heading', 'text', 'button', 'image'],
                ],
                't15-financial-consultant-section-4' => [
                    'title' => esc_html__('A financial advisor can - Financial Consultant', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-financial-consultant',
                    'section_number' => 4,
                    'images_count' => 5,
                    'tags' => ['header', 'financial', 'consultant', 'heading', 'text', 'image', 'video'],
                ],
                't15-financial-consultant-section-5' => [
                    'title' => esc_html__('A financial advisor can - Financial Consultant', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-financial-consultant',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['cta', 'financial', 'consultant', 'text', 'button'],
                ],
                't15-graphic-design-services-section-1' => [
                    'title' => esc_html__('Our award-winning graphic design - Graphic Design Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-graphic-design-services',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['cta', 'graphic', 'design', 'services', 'text', 'button', 'image'],
                ],
                't15-graphic-design-services-section-2' => [
                    'title' => esc_html__('appreciated talents - Graphic Design Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't15-graphic-design-services',
                    'section_number' => 2,
                    'images_count' => 0,
                    'tags' => ['content', 'graphic', 'design', 'services', 'text', 'icon box'],
                ],
                't15-graphic-design-services-section-3' => [
                    'title' => esc_html__('Graphic design is the - Graphic Design Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-graphic-design-services',
                    'section_number' => 3,
                    'images_count' => 8,
                    'tags' => ['cta', 'graphic', 'design', 'services', 'image', 'text', 'button', 'king addons auto scrolling text'],
                ],
                't15-graphic-design-services-section-4' => [
                    'title' => esc_html__('Our award-winning graphic design - Graphic Design Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-graphic-design-services',
                    'section_number' => 4,
                    'images_count' => 3,
                    'tags' => ['cta', 'graphic', 'design', 'services', 'image', 'text', 'button'],
                ],
                't15-graphic-design-services-section-5' => [
                    'title' => esc_html__('Case studies - Graphic Design Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't15-graphic-design-services',
                    'section_number' => 5,
                    'images_count' => 0,
                    'tags' => ['content', 'graphic', 'design', 'services', 'text'],
                ],
                't15-graphic-design-services-section-6' => [
                    'title' => esc_html__('Web-designer Personal Branding - Graphic Design Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-graphic-design-services',
                    'section_number' => 6,
                    'images_count' => 4,
                    'tags' => ['hero', 'graphic', 'design', 'services', 'image', 'text', 'heading', 'button'],
                ],
                't15-graphic-design-services-section-7' => [
                    'title' => esc_html__('Our award-winning graphic design - Graphic Design Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-graphic-design-services',
                    'section_number' => 7,
                    'images_count' => 2,
                    'tags' => ['hero', 'graphic', 'design', 'services', 'image', 'heading', 'text', 'button'],
                ],
                't15-it-consultant-section-1' => [
                    'title' => esc_html__('Stuck on something?
Get help - It Consultant', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-it-consultant',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['cta', 'consultant', 'text', 'button', 'image'],
                ],
                't15-it-consultant-section-2' => [
                    'title' => esc_html__('Ready to solve problems - It Consultant', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-it-consultant',
                    'section_number' => 2,
                    'images_count' => 2,
                    'tags' => ['hero', 'consultant', 'image', 'heading', 'text', 'button'],
                ],
                't15-it-consultant-section-3' => [
                    'title' => esc_html__('I am Max - - It Consultant', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-it-consultant',
                    'section_number' => 3,
                    'images_count' => 8,
                    'tags' => ['header', 'consultant', 'text', 'heading', 'image'],
                ],
                't15-it-consultant-section-4' => [
                    'title' => esc_html__('At vero eos et - It Consultant', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-it-consultant',
                    'section_number' => 4,
                    'images_count' => 2,
                    'tags' => ['hero', 'consultant', 'image', 'text', 'heading', 'button'],
                ],
                't15-it-consultant-section-5' => [
                    'title' => esc_html__('I\'m not just talking.
Look - It Consultant', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-it-consultant',
                    'section_number' => 5,
                    'images_count' => 7,
                    'tags' => ['hero', 'consultant', 'text', 'heading', 'image', 'button'],
                ],
                't15-it-consultant-section-6' => [
                    'title' => esc_html__('\"Max gave me an - It Consultant', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-it-consultant',
                    'section_number' => 6,
                    'images_count' => 4,
                    'tags' => ['header', 'consultant', 'image', 'text', 'heading'],
                ],
                't15-it-consultant-section-7' => [
                    'title' => esc_html__('I am Max - - It Consultant', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-it-consultant',
                    'section_number' => 7,
                    'images_count' => 2,
                    'tags' => ['hero', 'consultant', 'text', 'heading', 'button'],
                ],
                't15-it-hr-services-section-1' => [
                    'title' => esc_html__('From now on, you - It Hr Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-it-hr-services',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['hero', 'services', 'text', 'styled text', 'button', 'image'],
                ],
                't15-it-hr-services-section-2' => [
                    'title' => esc_html__('Spend more time with - It Hr Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-it-hr-services',
                    'section_number' => 2,
                    'images_count' => 2,
                    'tags' => ['hero', 'services', 'image', 'heading', 'text', 'button'],
                ],
                't15-it-hr-services-section-3' => [
                    'title' => esc_html__('Our company was founded - It Hr Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-it-hr-services',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['hero', 'services', 'image', 'text', 'heading', 'button'],
                ],
                't15-it-hr-services-section-4' => [
                    'title' => esc_html__('It Hr Services - General Section 4', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'technology',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't15-it-hr-services',
                    'section_number' => 4,
                    'images_count' => 8,
                    'tags' => ['general', 'services', 'image carousel'],
                ],
                't15-it-hr-services-section-5' => [
                    'title' => esc_html__('From now on, you - It Hr Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'technology',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-it-hr-services',
                    'section_number' => 5,
                    'images_count' => 7,
                    'tags' => ['header', 'services', 'text', 'heading', 'image'],
                ],
                't15-it-hr-services-section-6' => [
                    'title' => esc_html__('Human resource companies play - It Hr Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-it-hr-services',
                    'section_number' => 6,
                    'images_count' => 2,
                    'tags' => ['hero', 'services', 'text', 'heading', 'button', 'image'],
                ],
                't15-it-hr-services-section-7' => [
                    'title' => esc_html__('From now on, you - It Hr Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'technology',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-it-hr-services',
                    'section_number' => 7,
                    'images_count' => 3,
                    'tags' => ['header', 'services', 'text', 'image', 'star rating', 'heading'],
                ],
                't15-it-hr-services-section-8' => [
                    'title' => esc_html__('From now on, you - It Hr Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-it-hr-services',
                    'section_number' => 8,
                    'images_count' => 1,
                    'tags' => ['cta', 'services', 'text', 'button'],
                ],
                't15-language-school-section-1' => [
                    'title' => esc_html__('Learn languages at the - Language School', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'education',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-language-school',
                    'section_number' => 1,
                    'images_count' => 4,
                    'tags' => ['cta', 'language', 'school', 'text', 'button', 'image'],
                ],
                't15-language-school-section-2' => [
                    'title' => esc_html__('Learn languages at the - Language School', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'education',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-language-school',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['header', 'language', 'school', 'image', 'heading', 'text'],
                ],
                't15-language-school-section-3' => [
                    'title' => esc_html__('Learn languages at the - Language School', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'education',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-language-school',
                    'section_number' => 3,
                    'images_count' => 9,
                    'tags' => ['cta', 'language', 'school', 'image', 'text', 'button', 'image carousel'],
                ],
                't15-language-school-section-4' => [
                    'title' => esc_html__('Learn languages at the - Language School', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'education',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-language-school',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['header', 'language', 'school', 'text', 'heading', 'icon list', 'image'],
                ],
                't15-language-school-section-5' => [
                    'title' => esc_html__('Learn languages at the - Language School', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'education',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-language-school',
                    'section_number' => 5,
                    'images_count' => 0,
                    'tags' => ['hero', 'language', 'school', 'text', 'heading', 'icon list', 'button'],
                ],
                't15-language-school-section-6' => [
                    'title' => esc_html__('Language School - General Section 6', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'education',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't15-language-school',
                    'section_number' => 6,
                    'images_count' => 8,
                    'tags' => ['general', 'language', 'school', 'king addons auto scrolling text'],
                ],
                't15-language-school-section-7' => [
                    'title' => esc_html__('Tired of dealing with - Language School', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'education',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-language-school',
                    'section_number' => 7,
                    'images_count' => 3,
                    'tags' => ['header', 'language', 'school', 'text', 'image', 'star rating', 'heading'],
                ],
                't15-language-school-section-8' => [
                    'title' => esc_html__('Do you have any - Language School', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'education',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-language-school',
                    'section_number' => 8,
                    'images_count' => 2,
                    'tags' => ['header', 'language', 'school', 'image', 'text', 'heading', 'shortcode'],
                ],
                't15-law-2-section-1' => [
                    'title' => esc_html__('Our team consists only - Law 2', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'legal',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-law-2',
                    'section_number' => 1,
                    'images_count' => 4,
                    'tags' => ['cta', 'law', 'text', 'divider', 'button'],
                ],
                't15-law-2-section-2' => [
                    'title' => esc_html__('The main service provided - Law 2', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'legal',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-law-2',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['hero', 'law', 'text', 'heading', 'divider', 'button', 'image'],
                ],
                't15-law-2-section-3' => [
                    'title' => esc_html__('Our team consists only - Law 2', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'legal',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-law-2',
                    'section_number' => 3,
                    'images_count' => 12,
                    'tags' => ['header', 'law', 'text', 'heading', 'divider', 'image'],
                ],
                't15-law-2-section-4' => [
                    'title' => esc_html__('Change is the law - Law 2', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'legal',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't15-law-2',
                    'section_number' => 4,
                    'images_count' => 2,
                    'tags' => ['content', 'law', 'image', 'text'],
                ],
                't15-law-2-section-5' => [
                    'title' => esc_html__('The main service provided - Law 2', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'legal',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-law-2',
                    'section_number' => 5,
                    'images_count' => 2,
                    'tags' => ['hero', 'law', 'text', 'heading', 'divider', 'button', 'image'],
                ],
                't15-law-2-section-6' => [
                    'title' => esc_html__('Our team consists only - Law 2', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'legal',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-law-2',
                    'section_number' => 6,
                    'images_count' => 6,
                    'tags' => ['hero', 'law', 'text', 'divider', 'heading', 'image', 'button'],
                ],
                't15-law-2-section-7' => [
                    'title' => esc_html__('Our team consists only - Law 2', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'legal',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-law-2',
                    'section_number' => 7,
                    'images_count' => 2,
                    'tags' => ['cta', 'law', 'text', 'button'],
                ],
                't15-law-section-1' => [
                    'title' => esc_html__('A law firm is - Law', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'legal',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-law',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['cta', 'law', 'text', 'button', 'image'],
                ],
                't15-law-section-2' => [
                    'title' => esc_html__('A law firm is - Law', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'legal',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-law',
                    'section_number' => 2,
                    'images_count' => 5,
                    'tags' => ['hero', 'law', 'text', 'button', 'image', 'heading'],
                ],
                't15-law-section-3' => [
                    'title' => esc_html__('Law - General Section 3', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'legal',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't15-law',
                    'section_number' => 3,
                    'images_count' => 0,
                    'tags' => ['general', 'law'],
                ],
                't15-law-section-4' => [
                    'title' => esc_html__('The primary service rendered - Law', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'legal',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-law',
                    'section_number' => 4,
                    'images_count' => 2,
                    'tags' => ['header', 'law', 'image', 'text', 'heading'],
                ],
                't15-law-section-5' => [
                    'title' => esc_html__('A law firm is - Law', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'legal',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-law',
                    'section_number' => 5,
                    'images_count' => 6,
                    'tags' => ['header', 'law', 'heading', 'text', 'image'],
                ],
                't15-law-section-6' => [
                    'title' => esc_html__('A law firm is - Law', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'legal',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-law',
                    'section_number' => 6,
                    'images_count' => 3,
                    'tags' => ['header', 'law', 'heading', 'text', 'image'],
                ],
                't15-law-section-7' => [
                    'title' => esc_html__('Testimonial - Law', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'legal',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't15-law',
                    'section_number' => 7,
                    'images_count' => 2,
                    'tags' => ['content', 'law', 'text', 'testimonial'],
                ],
                't15-law-section-8' => [
                    'title' => esc_html__('A law firm is - Law', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'legal',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-law',
                    'section_number' => 8,
                    'images_count' => 2,
                    'tags' => ['cta', 'law', 'text', 'button'],
                ],
                't15-mobile-app-landing-section-1' => [
                    'title' => esc_html__('Baza App - the - Mobile App Landing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-mobile-app-landing',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['cta', 'mobile', 'app', 'landing', 'text', 'button', 'star rating', 'image'],
                ],
                't15-mobile-app-landing-section-2' => [
                    'title' => esc_html__('Baza App - the - Mobile App Landing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'technology',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-mobile-app-landing',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['header', 'mobile', 'app', 'landing', 'image', 'heading', 'text'],
                ],
                't15-mobile-app-landing-section-3' => [
                    'title' => esc_html__('Mobile App Landing - General Section 3', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'technology',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't15-mobile-app-landing',
                    'section_number' => 3,
                    'images_count' => 0,
                    'tags' => ['general', 'mobile', 'app', 'landing', 'spacer'],
                ],
                't15-mobile-app-landing-section-4' => [
                    'title' => esc_html__('A cryptocurrency, crypto-currency, or - Mobile App Landing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-mobile-app-landing',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['hero', 'mobile', 'app', 'landing', 'image', 'text', 'heading', 'button'],
                ],
                't15-mobile-app-landing-section-5' => [
                    'title' => esc_html__('Baza App - the - Mobile App Landing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-mobile-app-landing',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['hero', 'mobile', 'app', 'landing', 'text', 'heading', 'icon list', 'button', 'image'],
                ],
                't15-mobile-app-landing-section-6' => [
                    'title' => esc_html__('A cryptocurrency, crypto-currency, or - Mobile App Landing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-mobile-app-landing',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['hero', 'mobile', 'app', 'landing', 'image', 'text', 'heading', 'button'],
                ],
                't15-mobile-app-landing-section-7' => [
                    'title' => esc_html__('Baza App - the - Mobile App Landing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'technology',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-mobile-app-landing',
                    'section_number' => 7,
                    'images_count' => 4,
                    'tags' => ['header', 'mobile', 'app', 'landing', 'heading', 'text', 'image carousel'],
                ],
                't15-mobile-app-landing-section-8' => [
                    'title' => esc_html__('Baza App - the - Mobile App Landing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'technology',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-mobile-app-landing',
                    'section_number' => 8,
                    'images_count' => 0,
                    'tags' => ['header', 'mobile', 'app', 'landing', 'heading', 'text'],
                ],
                't15-mobile-app-landing-section-9' => [
                    'title' => esc_html__('\"Best choice! Everything is - Mobile App Landing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'technology',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-mobile-app-landing',
                    'section_number' => 9,
                    'images_count' => 3,
                    'tags' => ['header', 'mobile', 'app', 'landing', 'image', 'text', 'heading'],
                ],
                't15-mobile-app-landing-section-10' => [
                    'title' => esc_html__('Baza App - the - Mobile App Landing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-mobile-app-landing',
                    'section_number' => 10,
                    'images_count' => 3,
                    'tags' => ['hero', 'mobile', 'app', 'landing', 'image', 'heading', 'text', 'button'],
                ],
                't15-nft-single-item-landing-section-1' => [
                    'title' => esc_html__('Buy the new super - Nft Single Item Landing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'media & entertainment',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-nft-single-item-landing',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['cta', 'nft', 'single', 'item', 'landing', 'text', 'button', 'icon list', 'image'],
                ],
                't15-nft-single-item-landing-section-2' => [
                    'title' => esc_html__('A non-fungible token is - Nft Single Item Landing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'media & entertainment',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-nft-single-item-landing',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['cta', 'nft', 'single', 'item', 'landing', 'image', 'text', 'button'],
                ],
                't15-nft-single-item-landing-section-3' => [
                    'title' => esc_html__('Nft Single Item Landing - General Section 3', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'media & entertainment',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't15-nft-single-item-landing',
                    'section_number' => 3,
                    'images_count' => 8,
                    'tags' => ['general', 'nft', 'single', 'item', 'landing', 'king addons auto scrolling text'],
                ],
                't15-nft-single-item-landing-section-4' => [
                    'title' => esc_html__('An NFT is a - Nft Single Item Landing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'media & entertainment',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-nft-single-item-landing',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['cta', 'nft', 'single', 'item', 'landing', 'text', 'button', 'image'],
                ],
                't15-nft-single-item-landing-section-5' => [
                    'title' => esc_html__('Browse dozens of my - Nft Single Item Landing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'media & entertainment',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-nft-single-item-landing',
                    'section_number' => 5,
                    'images_count' => 0,
                    'tags' => ['cta', 'nft', 'single', 'item', 'landing', 'text', 'button'],
                ],
                't15-online-course-landing-section-1' => [
                    'title' => esc_html__('Our team has developed - Online Course Landing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'education',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-online-course-landing',
                    'section_number' => 1,
                    'images_count' => 0,
                    'tags' => ['cta', 'online', 'course', 'landing', 'text', 'button', 'icon list'],
                ],
                't15-online-course-landing-section-2' => [
                    'title' => esc_html__('Online Course Landing - Gallery Section 2', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'education',
                    'subcategory' => 'galleries',
                    'section_type' => 'gallery',
                    'parent_template' => 't15-online-course-landing',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['gallery', 'online', 'course', 'landing', 'image'],
                ],
                't15-online-course-landing-section-3' => [
                    'title' => esc_html__('Supported by over 5,000 - Online Course Landing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'education',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-online-course-landing',
                    'section_number' => 3,
                    'images_count' => 5,
                    'tags' => ['header', 'online', 'course', 'landing', 'heading', 'image'],
                ],
                't15-online-course-landing-section-4' => [
                    'title' => esc_html__('Our team has developed - Online Course Landing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'education',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-online-course-landing',
                    'section_number' => 4,
                    'images_count' => 2,
                    'tags' => ['hero', 'online', 'course', 'landing', 'heading', 'image', 'text', 'button'],
                ],
                't15-online-course-landing-section-5' => [
                    'title' => esc_html__('Course helped me to - Online Course Landing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'education',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't15-online-course-landing',
                    'section_number' => 5,
                    'images_count' => 2,
                    'tags' => ['content', 'online', 'course', 'landing', 'image', 'text'],
                ],
                't15-online-course-landing-section-6' => [
                    'title' => esc_html__('Baza has developed an - Online Course Landing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'education',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-online-course-landing',
                    'section_number' => 6,
                    'images_count' => 3,
                    'tags' => ['hero', 'online', 'course', 'landing', 'text', 'heading', 'button', 'image'],
                ],
                't15-online-course-landing-section-7' => [
                    'title' => esc_html__('Join other 5000+ people - Online Course Landing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'education',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-online-course-landing',
                    'section_number' => 7,
                    'images_count' => 2,
                    'tags' => ['hero', 'online', 'course', 'landing', 'image', 'heading', 'button', 'icon list'],
                ],
                't15-saas-services-section-1' => [
                    'title' => esc_html__('Our app will help - Saas Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-saas-services',
                    'section_number' => 1,
                    'images_count' => 4,
                    'tags' => ['hero', 'saas', 'services', 'styled text', 'text', 'button', 'image'],
                ],
                't15-saas-services-section-2' => [
                    'title' => esc_html__('Our app will help - Saas Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'technology',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-saas-services',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['header', 'saas', 'services', 'image', 'heading', 'text'],
                ],
                't15-saas-services-section-3' => [
                    'title' => esc_html__('Our app will help - Saas Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-saas-services',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['hero', 'saas', 'services', 'heading', 'text', 'button', 'image'],
                ],
                't15-saas-services-section-4' => [
                    'title' => esc_html__('Reports generated - Saas Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'technology',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't15-saas-services',
                    'section_number' => 4,
                    'images_count' => 0,
                    'tags' => ['general', 'saas', 'services', 'counter'],
                ],
                't15-saas-services-section-5' => [
                    'title' => esc_html__('Our app will help - Saas Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'technology',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-saas-services',
                    'section_number' => 5,
                    'images_count' => 0,
                    'tags' => ['header', 'saas', 'services', 'heading', 'text'],
                ],
                't15-saas-services-section-6' => [
                    'title' => esc_html__('Saas Services - General Section 6', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'technology',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't15-saas-services',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['general', 'saas', 'services', 'image', 'icon box'],
                ],
                't15-saas-services-section-7' => [
                    'title' => esc_html__('Everything is done perfectly - Saas Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'technology',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-saas-services',
                    'section_number' => 7,
                    'images_count' => 2,
                    'tags' => ['header', 'saas', 'services', 'image', 'heading', 'text'],
                ],
                't15-saas-services-section-8' => [
                    'title' => esc_html__('Didn\'t find your answer?  - Saas Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-saas-services',
                    'section_number' => 8,
                    'images_count' => 0,
                    'tags' => ['hero', 'saas', 'services', 'heading', 'text', 'icon list', 'button', 'icon box'],
                ],
                't15-saas-services-section-9' => [
                    'title' => esc_html__('Our app will help - Saas Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-saas-services',
                    'section_number' => 9,
                    'images_count' => 1,
                    'tags' => ['hero', 'saas', 'services', 'image', 'heading', 'text', 'button'],
                ],
                't15-seo-agency-section-1' => [
                    'title' => esc_html__('Do you want to - Seo Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-seo-agency',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['cta', 'seo', 'agency', 'image', 'text', 'button'],
                ],
                't15-seo-agency-section-2' => [
                    'title' => esc_html__('Do you want to - Seo Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-seo-agency',
                    'section_number' => 2,
                    'images_count' => 2,
                    'tags' => ['cta', 'seo', 'agency', 'text', 'button', 'image'],
                ],
                't15-seo-agency-section-3' => [
                    'title' => esc_html__('Do you want to - Seo Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-seo-agency',
                    'section_number' => 3,
                    'images_count' => 7,
                    'tags' => ['header', 'seo', 'agency', 'image', 'text', 'heading'],
                ],
                't15-seo-agency-section-4' => [
                    'title' => esc_html__('Do you want to - Seo Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-seo-agency',
                    'section_number' => 4,
                    'images_count' => 0,
                    'tags' => ['hero', 'seo', 'agency', 'text', 'heading', 'icon list', 'button'],
                ],
                't15-seo-agency-section-5' => [
                    'title' => esc_html__('Do you want to - Seo Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-seo-agency',
                    'section_number' => 5,
                    'images_count' => 7,
                    'tags' => ['hero', 'seo', 'agency', 'text', 'button', 'image carousel', 'heading'],
                ],
                't15-seo-agency-section-6' => [
                    'title' => esc_html__('Do you want to - Seo Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-seo-agency',
                    'section_number' => 6,
                    'images_count' => 4,
                    'tags' => ['header', 'seo', 'agency', 'image', 'text', 'star rating', 'heading'],
                ],
                't15-seo-agency-section-7' => [
                    'title' => esc_html__('You can use search - Seo Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-seo-agency',
                    'section_number' => 7,
                    'images_count' => 2,
                    'tags' => ['hero', 'seo', 'agency', 'image', 'heading', 'text', 'button'],
                ],
                't15-seo-services-section-1' => [
                    'title' => esc_html__('We can optimize your - Seo Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-seo-services',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['cta', 'seo', 'services', 'text', 'button', 'image'],
                ],
                't15-seo-services-section-2' => [
                    'title' => esc_html__('As an Internet marketing - Seo Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-seo-services',
                    'section_number' => 2,
                    'images_count' => 5,
                    'tags' => ['hero', 'seo', 'services', 'text', 'image', 'heading', 'button', 'counter'],
                ],
                't15-seo-services-section-3' => [
                    'title' => esc_html__('We can optimize your - Seo Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-seo-services',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['cta', 'seo', 'services', 'text', 'button', 'image'],
                ],
                't15-seo-services-section-4' => [
                    'title' => esc_html__('Content quality improvement - Seo Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-seo-services',
                    'section_number' => 4,
                    'images_count' => 7,
                    'tags' => ['header', 'seo', 'services', 'text', 'image', 'heading'],
                ],
                't15-seo-services-section-5' => [
                    'title' => esc_html__('We can optimize your - Seo Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-seo-services',
                    'section_number' => 5,
                    'images_count' => 0,
                    'tags' => ['hero', 'seo', 'services', 'text', 'heading', 'icon list', 'button'],
                ],
                't15-seo-services-section-6' => [
                    'title' => esc_html__('What our happy clients - Seo Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't15-seo-services',
                    'section_number' => 6,
                    'images_count' => 2,
                    'tags' => ['content', 'seo', 'services', 'image', 'text', 'testimonial'],
                ],
                't15-seo-services-section-7' => [
                    'title' => esc_html__('We can optimize your - Seo Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-seo-services',
                    'section_number' => 7,
                    'images_count' => 1,
                    'tags' => ['cta', 'seo', 'services', 'text', 'button', 'image'],
                ],
                't15-smm-instagram-section-1' => [
                    'title' => esc_html__('We will increase the - Smm Instagram', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-smm-instagram',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['hero', 'smm', 'instagram', 'heading', 'text', 'button'],
                ],
                't15-smm-instagram-section-2' => [
                    'title' => esc_html__('We will increase the - Smm Instagram', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-smm-instagram',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['header', 'smm', 'instagram', 'image', 'heading', 'text'],
                ],
                't15-smm-instagram-section-3' => [
                    'title' => esc_html__('We will increase the - Smm Instagram', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-smm-instagram',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['cta', 'smm', 'instagram', 'image', 'text', 'button'],
                ],
                't15-smm-instagram-section-4' => [
                    'title' => esc_html__('Why you can trust - Smm Instagram', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't15-smm-instagram',
                    'section_number' => 4,
                    'images_count' => 2,
                    'tags' => ['content', 'smm', 'instagram', 'text', 'counter'],
                ],
                't15-smm-instagram-section-5' => [
                    'title' => esc_html__('Integrated promotion on Instagram - Smm Instagram', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-smm-instagram',
                    'section_number' => 5,
                    'images_count' => 3,
                    'tags' => ['header', 'smm', 'instagram', 'heading', 'text', 'image'],
                ],
                't15-smm-instagram-section-6' => [
                    'title' => esc_html__('\"The guys from Baza - Smm Instagram', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-smm-instagram',
                    'section_number' => 6,
                    'images_count' => 2,
                    'tags' => ['header', 'smm', 'instagram', 'heading', 'image', 'text'],
                ],
                't15-smm-instagram-section-7' => [
                    'title' => esc_html__('Send a line and - Smm Instagram', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-smm-instagram',
                    'section_number' => 7,
                    'images_count' => 1,
                    'tags' => ['cta', 'smm', 'instagram', 'text', 'button'],
                ],
                't15-smm-services-section-1' => [
                    'title' => esc_html__('We have extremely experienced - Smm Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-smm-services',
                    'section_number' => 1,
                    'images_count' => 4,
                    'tags' => ['cta', 'smm', 'services', 'text', 'button', 'image'],
                ],
                't15-smm-services-section-2' => [
                    'title' => esc_html__('Do you want to - Smm Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-smm-services',
                    'section_number' => 2,
                    'images_count' => 2,
                    'tags' => ['cta', 'smm', 'services', 'image', 'text', 'button', 'counter'],
                ],
                't15-smm-services-section-3' => [
                    'title' => esc_html__('We have extremely experienced - Smm Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-smm-services',
                    'section_number' => 3,
                    'images_count' => 3,
                    'tags' => ['hero', 'smm', 'services', 'text', 'image', 'heading', 'button'],
                ],
                't15-smm-services-section-4' => [
                    'title' => esc_html__('Do you want to - Smm Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-smm-services',
                    'section_number' => 4,
                    'images_count' => 2,
                    'tags' => ['cta', 'smm', 'services', 'text', 'icon list', 'button', 'image'],
                ],
                't15-smm-services-section-5' => [
                    'title' => esc_html__('We have extremely experienced - Smm Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-smm-services',
                    'section_number' => 5,
                    'images_count' => 0,
                    'tags' => ['hero', 'smm', 'services', 'text', 'heading', 'icon list', 'button'],
                ],
                't15-smm-services-section-6' => [
                    'title' => esc_html__('We have extremely experienced - Smm Services', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'marketing',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-smm-services',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['hero', 'smm', 'services', 'image', 'heading', 'text', 'button'],
                ],
                't15-software-landing-section-1' => [
                    'title' => esc_html__('Our app will help - Software Landing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-software-landing',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['cta', 'software', 'landing', 'text', 'button', 'image'],
                ],
                't15-software-landing-section-2' => [
                    'title' => esc_html__('Business Analytics is the - Software Landing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-software-landing',
                    'section_number' => 2,
                    'images_count' => 7,
                    'tags' => ['cta', 'software', 'landing', 'text', 'image', 'button'],
                ],
                't15-software-landing-section-3' => [
                    'title' => esc_html__('Our app will help - Software Landing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-software-landing',
                    'section_number' => 3,
                    'images_count' => 3,
                    'tags' => ['hero', 'software', 'landing', 'text', 'image', 'heading', 'button'],
                ],
                't15-software-landing-section-4' => [
                    'title' => esc_html__('Business Analytics is the - Software Landing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-software-landing',
                    'section_number' => 4,
                    'images_count' => 8,
                    'tags' => ['hero', 'software', 'landing', 'text', 'button', 'image carousel', 'heading'],
                ],
                't15-software-landing-section-5' => [
                    'title' => esc_html__('Our app will help - Software Landing', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-software-landing',
                    'section_number' => 5,
                    'images_count' => 2,
                    'tags' => ['cta', 'software', 'landing', 'text', 'button'],
                ],
                't15-web-development-agency-section-1' => [
                    'title' => esc_html__('Our web development agency - Web Development Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-web-development-agency',
                    'section_number' => 1,
                    'images_count' => 4,
                    'tags' => ['hero', 'web', 'development', 'agency', 'text', 'styled text', 'button', 'image'],
                ],
                't15-web-development-agency-section-2' => [
                    'title' => esc_html__('Sed ut perspiciatis unde - Web Development Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-web-development-agency',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['hero', 'web', 'development', 'agency', 'image', 'heading', 'text', 'button'],
                ],
                't15-web-development-agency-section-3' => [
                    'title' => esc_html__('At vero eos et - Web Development Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-web-development-agency',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['hero', 'web', 'development', 'agency', 'image', 'text', 'heading', 'button'],
                ],
                't15-web-development-agency-section-4' => [
                    'title' => esc_html__('Satisfaction rate from our - Web Development Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't15-web-development-agency',
                    'section_number' => 4,
                    'images_count' => 0,
                    'tags' => ['general', 'web', 'development', 'agency', 'counter'],
                ],
                't15-web-development-agency-section-5' => [
                    'title' => esc_html__('Our professional web designers - Web Development Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-web-development-agency',
                    'section_number' => 5,
                    'images_count' => 6,
                    'tags' => ['hero', 'web', 'development', 'agency', 'text', 'heading', 'image box', 'styled text', 'button'],
                ],
                't15-web-development-agency-section-6' => [
                    'title' => esc_html__('We are proud of - Web Development Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-web-development-agency',
                    'section_number' => 6,
                    'images_count' => 12,
                    'tags' => ['hero', 'web', 'development', 'agency', 'king addons auto scrolling text', 'text', 'heading', 'image', 'button'],
                ],
                't15-web-development-agency-section-7' => [
                    'title' => esc_html__('Testimonial - Web Development Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't15-web-development-agency',
                    'section_number' => 7,
                    'images_count' => 2,
                    'tags' => ['content', 'web', 'development', 'agency', 'text', 'testimonial'],
                ],
                't15-webinar-section-1' => [
                    'title' => esc_html__('Our app will help - Webinar', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'education',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't15-webinar',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['cta', 'webinar', 'text', 'button', 'image'],
                ],
                't15-webinar-section-2' => [
                    'title' => esc_html__('More than 10,000 people - Webinar', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'education',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't15-webinar',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['content', 'webinar', 'text', 'image'],
                ],
                't15-webinar-section-3' => [
                    'title' => esc_html__('Baza has brought together - Webinar', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'education',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-webinar',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['hero', 'webinar', 'text', 'heading', 'button'],
                ],
                't15-webinar-section-4' => [
                    'title' => esc_html__('Webinar - General Section 4', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'education',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't15-webinar',
                    'section_number' => 4,
                    'images_count' => 4,
                    'tags' => ['general', 'webinar', 'image'],
                ],
                't15-webinar-section-5' => [
                    'title' => esc_html__('Baza has brought together - Webinar', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'education',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-webinar',
                    'section_number' => 5,
                    'images_count' => 20,
                    'tags' => ['header', 'webinar', 'text', 'heading', 'image'],
                ],
                't15-webinar-section-6' => [
                    'title' => esc_html__('Our app will help - Webinar', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'education',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-webinar',
                    'section_number' => 6,
                    'images_count' => 2,
                    'tags' => ['hero', 'webinar', 'text', 'heading', 'icon list', 'button', 'image'],
                ],
                't15-webinar-section-7' => [
                    'title' => esc_html__('Baza has brought together - Webinar', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'education',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't15-webinar',
                    'section_number' => 7,
                    'images_count' => 6,
                    'tags' => ['header', 'webinar', 'text', 'heading', 'image'],
                ],
                't15-webinar-section-8' => [
                    'title' => esc_html__('Baza has brought together - Webinar', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'education',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't15-webinar',
                    'section_number' => 8,
                    'images_count' => 3,
                    'tags' => ['hero', 'webinar', 'image', 'heading', 'text', 'button'],
                ],
                't6-digital-marketing-agency-section-1' => [
                    'title' => esc_html__('Improve your business in - Digital Marketing Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't6-digital-marketing-agency',
                    'section_number' => 1,
                    'images_count' => 10,
                    'tags' => ['cta', 'digital', 'marketing', 'agency', 'text', 'image', 'button', 'text path'],
                ],
                't6-digital-marketing-agency-section-2' => [
                    'title' => esc_html__('Industry experience - Digital Marketing Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't6-digital-marketing-agency',
                    'section_number' => 2,
                    'images_count' => 0,
                    'tags' => ['header', 'digital', 'marketing', 'agency', 'heading', 'text'],
                ],
                't6-digital-marketing-agency-section-3' => [
                    'title' => esc_html__('In order to scale - Digital Marketing Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't6-digital-marketing-agency',
                    'section_number' => 3,
                    'images_count' => 7,
                    'tags' => ['hero', 'digital', 'marketing', 'agency', 'heading', 'image', 'text', 'button'],
                ],
                't6-digital-marketing-agency-section-4' => [
                    'title' => esc_html__('Our team has a - Digital Marketing Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't6-digital-marketing-agency',
                    'section_number' => 4,
                    'images_count' => 6,
                    'tags' => ['hero', 'digital', 'marketing', 'agency', 'image', 'heading', 'text', 'button'],
                ],
                't6-digital-marketing-agency-section-5' => [
                    'title' => esc_html__('In order to scale - Digital Marketing Agency', 'king-addons'),
                    'plan' => 'free',
                    'category' => 'creative',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't6-digital-marketing-agency',
                    'section_number' => 5,
                    'images_count' => 9,
                    'tags' => ['hero', 'digital', 'marketing', 'agency', 'text', 'image', 'icon', 'star rating', 'heading', 'button'],
                ],
                't1-about-us-dark-section-1' => [
                    'title' => esc_html__('We are Company Inc. - About Us Dark', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-about-us-dark',
                    'section_number' => 1,
                    'images_count' => 0,
                    'tags' => ['content', 'about', 'dark', 'text'],
                ],
                't1-about-us-dark-section-2' => [
                    'title' => esc_html__('About Us Dark - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't1-about-us-dark',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['general', 'about', 'dark', 'king addons video popup'],
                ],
                't1-about-us-dark-section-3' => [
                    'title' => esc_html__('Satisfaction rate - About Us Dark', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't1-about-us-dark',
                    'section_number' => 3,
                    'images_count' => 0,
                    'tags' => ['header', 'about', 'dark', 'heading', 'text'],
                ],
                't1-about-us-dark-section-4' => [
                    'title' => esc_html__('Our web development company - About Us Dark', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-about-us-dark',
                    'section_number' => 4,
                    'images_count' => 0,
                    'tags' => ['content', 'about', 'dark', 'text'],
                ],
                't1-about-us-dark-section-5' => [
                    'title' => esc_html__('About Us Dark - General Section 5', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't1-about-us-dark',
                    'section_number' => 5,
                    'images_count' => 3,
                    'tags' => ['general', 'about', 'dark', 'image box'],
                ],
                't1-about-us-dark-section-6' => [
                    'title' => esc_html__('We solve your challenges - About Us Dark', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-about-us-dark',
                    'section_number' => 6,
                    'images_count' => 5,
                    'tags' => ['content', 'about', 'dark', 'text', 'king addons image grid'],
                ],
                't1-about-us-dark-section-7' => [
                    'title' => esc_html__('Our web development company - About Us Dark', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-about-us-dark',
                    'section_number' => 7,
                    'images_count' => 6,
                    'tags' => ['content', 'about', 'dark', 'text', 'image', 'social icons'],
                ],
                't1-about-us-dark-section-8' => [
                    'title' => esc_html__('Our web development company - About Us Dark', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-about-us-dark',
                    'section_number' => 8,
                    'images_count' => 7,
                    'tags' => ['content', 'about', 'dark', 'text', 'image'],
                ],
                't1-about-us-dark-section-9' => [
                    'title' => esc_html__('Write us a message - About Us Dark', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-about-us-dark',
                    'section_number' => 9,
                    'images_count' => 0,
                    'tags' => ['cta', 'about', 'dark', 'text', 'button'],
                ],
                't1-about-us-section-1' => [
                    'title' => esc_html__('We are Company Inc. - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-about-us',
                    'section_number' => 1,
                    'images_count' => 0,
                    'tags' => ['content', 'about', 'text'],
                ],
                't1-about-us-section-2' => [
                    'title' => esc_html__('About Us - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't1-about-us',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['general', 'about', 'king addons video popup'],
                ],
                't1-about-us-section-4' => [
                    'title' => esc_html__('Our web development company - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-about-us',
                    'section_number' => 4,
                    'images_count' => 0,
                    'tags' => ['content', 'about', 'text'],
                ],
                't1-about-us-section-5' => [
                    'title' => esc_html__('About Us - General Section 5', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't1-about-us',
                    'section_number' => 5,
                    'images_count' => 3,
                    'tags' => ['general', 'about', 'image box'],
                ],
                't1-about-us-section-6' => [
                    'title' => esc_html__('We solve your challenges - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-about-us',
                    'section_number' => 6,
                    'images_count' => 5,
                    'tags' => ['content', 'about', 'text', 'king addons image grid'],
                ],
                't1-about-us-section-7' => [
                    'title' => esc_html__('Our web development company - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-about-us',
                    'section_number' => 7,
                    'images_count' => 6,
                    'tags' => ['content', 'about', 'text', 'image', 'social icons'],
                ],
                't1-about-us-section-8' => [
                    'title' => esc_html__('Our web development company - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-about-us',
                    'section_number' => 8,
                    'images_count' => 7,
                    'tags' => ['content', 'about', 'text', 'image'],
                ],
                't1-about-us-section-9' => [
                    'title' => esc_html__('Write us a message - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-about-us',
                    'section_number' => 9,
                    'images_count' => 0,
                    'tags' => ['cta', 'about', 'text', 'button'],
                ],
                't1-contact-us-dark-section-1' => [
                    'title' => esc_html__('Get in touch with - Contact Us Dark', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-contact-us-dark',
                    'section_number' => 1,
                    'images_count' => 0,
                    'tags' => ['content', 'contact', 'dark', 'text'],
                ],
                't1-contact-us-dark-section-2' => [
                    'title' => esc_html__('Need any help? - Contact Us Dark', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't1-contact-us-dark',
                    'section_number' => 2,
                    'images_count' => 2,
                    'tags' => ['header', 'contact', 'dark', 'heading', 'shortcode', 'html', 'spacer'],
                ],
                't1-contact-us-dark-section-3' => [
                    'title' => esc_html__('Contact Us Dark - General Section 3', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't1-contact-us-dark',
                    'section_number' => 3,
                    'images_count' => 3,
                    'tags' => ['general', 'contact', 'dark', 'image box'],
                ],
                't1-contact-us-dark-section-4' => [
                    'title' => esc_html__('Our web development company - Contact Us Dark', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-contact-us-dark',
                    'section_number' => 4,
                    'images_count' => 0,
                    'tags' => ['content', 'contact', 'dark', 'text'],
                ],
                't1-contact-us-dark-section-5' => [
                    'title' => esc_html__('Contact Us Dark - General Section 5', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't1-contact-us-dark',
                    'section_number' => 5,
                    'images_count' => 0,
                    'tags' => ['general', 'contact', 'dark', 'toggle'],
                ],
                't1-contact-us-dark-section-6' => [
                    'title' => esc_html__('Our web development company - Contact Us Dark', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-contact-us-dark',
                    'section_number' => 6,
                    'images_count' => 7,
                    'tags' => ['content', 'contact', 'dark', 'text', 'image'],
                ],
                't1-contact-us-dark-section-7' => [
                    'title' => esc_html__('Contact Us Dark - General Section 7', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't1-contact-us-dark',
                    'section_number' => 7,
                    'images_count' => 0,
                    'tags' => ['general', 'contact', 'dark', 'google_maps'],
                ],
                't1-contact-us-section-1' => [
                    'title' => esc_html__('Get in touch with - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-contact-us',
                    'section_number' => 1,
                    'images_count' => 0,
                    'tags' => ['content', 'contact', 'text'],
                ],
                't1-contact-us-section-2' => [
                    'title' => esc_html__('Need any help? - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't1-contact-us',
                    'section_number' => 2,
                    'images_count' => 2,
                    'tags' => ['header', 'contact', 'heading', 'shortcode', 'spacer'],
                ],
                't1-contact-us-section-3' => [
                    'title' => esc_html__('Contact Us - General Section 3', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't1-contact-us',
                    'section_number' => 3,
                    'images_count' => 3,
                    'tags' => ['general', 'contact', 'image box'],
                ],
                't1-contact-us-section-4' => [
                    'title' => esc_html__('Our web development company - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-contact-us',
                    'section_number' => 4,
                    'images_count' => 0,
                    'tags' => ['content', 'contact', 'text'],
                ],
                't1-contact-us-section-5' => [
                    'title' => esc_html__('Contact Us - General Section 5', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't1-contact-us',
                    'section_number' => 5,
                    'images_count' => 0,
                    'tags' => ['general', 'contact', 'toggle'],
                ],
                't1-contact-us-section-6' => [
                    'title' => esc_html__('Our web development company - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-contact-us',
                    'section_number' => 6,
                    'images_count' => 7,
                    'tags' => ['content', 'contact', 'text', 'image'],
                ],
                't1-design-agency-section-1' => [
                    'title' => esc_html__('Our team of creative - Design Agency', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'creative',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-design-agency',
                    'section_number' => 1,
                    'images_count' => 21,
                    'tags' => ['cta', 'design', 'agency', 'image', 'text', 'button', 'image carousel', 'text path'],
                ],
                't1-design-agency-section-2' => [
                    'title' => esc_html__('No matter how big - Design Agency', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'creative',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-design-agency',
                    'section_number' => 2,
                    'images_count' => 6,
                    'tags' => ['cta', 'design', 'agency', 'text', 'button', 'image', 'image box'],
                ],
                't1-design-agency-section-3' => [
                    'title' => esc_html__('No matter how big - Design Agency', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'creative',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-design-agency',
                    'section_number' => 3,
                    'images_count' => 8,
                    'tags' => ['cta', 'design', 'agency', 'text', 'image', 'divider', 'icon list', 'button'],
                ],
                't1-design-agency-section-4' => [
                    'title' => esc_html__('Offering transparent, fair, and - Design Agency', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'creative',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-design-agency',
                    'section_number' => 4,
                    'images_count' => 3,
                    'tags' => ['cta', 'design', 'agency', 'text', 'button'],
                ],
                't1-digital-marketing-section-1' => [
                    'title' => esc_html__('We collaborate, we think, - Digital Marketing', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'marketing',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-digital-marketing',
                    'section_number' => 1,
                    'images_count' => 9,
                    'tags' => ['cta', 'digital', 'marketing', 'text', 'button', 'image'],
                ],
                't1-digital-marketing-section-2' => [
                    'title' => esc_html__('We collaborate, we think, - Digital Marketing', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'marketing',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't1-digital-marketing',
                    'section_number' => 2,
                    'images_count' => 11,
                    'tags' => ['header', 'digital', 'marketing', 'text', 'image', 'heading', 'image box'],
                ],
                't1-digital-marketing-section-3' => [
                    'title' => esc_html__('We collaborate, we think, - Digital Marketing', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'marketing',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-digital-marketing',
                    'section_number' => 3,
                    'images_count' => 5,
                    'tags' => ['cta', 'digital', 'marketing', 'text', 'button', 'image', 'king addons video popup'],
                ],
                't1-digital-marketing-section-4' => [
                    'title' => esc_html__('\"Lorem ipsum dolor sit - Digital Marketing', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'marketing',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't1-digital-marketing',
                    'section_number' => 4,
                    'images_count' => 6,
                    'tags' => ['header', 'digital', 'marketing', 'text', 'star rating', 'image', 'heading'],
                ],
                't1-digital-marketing-section-5' => [
                    'title' => esc_html__('We collaborate, we think, - Digital Marketing', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'marketing',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-digital-marketing',
                    'section_number' => 5,
                    'images_count' => 10,
                    'tags' => ['cta', 'digital', 'marketing', 'image', 'text', 'toggle', 'button'],
                ],
                't1-digital-studio-section-1' => [
                    'title' => esc_html__('We Design Brands, Apps - Digital Studio', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-digital-studio',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['cta', 'digital', 'studio', 'text', 'button', 'image'],
                ],
                't1-digital-studio-section-2' => [
                    'title' => esc_html__('Digital Studio - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't1-digital-studio',
                    'section_number' => 2,
                    'images_count' => 5,
                    'tags' => ['general', 'digital', 'studio', 'image'],
                ],
                't1-digital-studio-section-3' => [
                    'title' => esc_html__('Cras finibus feugiat posuere. - Digital Studio', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-digital-studio',
                    'section_number' => 3,
                    'images_count' => 12,
                    'tags' => ['cta', 'digital', 'studio', 'image', 'text', 'button', 'king addons auto scrolling text', 'king addons card carousel'],
                ],
                't1-digital-studio-section-4' => [
                    'title' => esc_html__('As a web design - Digital Studio', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-digital-studio',
                    'section_number' => 4,
                    'images_count' => 3,
                    'tags' => ['content', 'digital', 'studio', 'text', 'king addons video popup'],
                ],
                't1-digital-studio-section-5' => [
                    'title' => esc_html__('As a web design - Digital Studio', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't1-digital-studio',
                    'section_number' => 5,
                    'images_count' => 4,
                    'tags' => ['hero', 'digital', 'studio', 'text', 'icon', 'image', 'heading', 'star rating', 'king addons blog posts', 'button'],
                ],
                't1-hardware-services-section-1' => [
                    'title' => esc_html__('You can rely on - Hardware Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-hardware-services',
                    'section_number' => 1,
                    'images_count' => 4,
                    'tags' => ['cta', 'hardware', 'services', 'text', 'image', 'king addons video popup', 'button'],
                ],
                't1-hardware-services-section-2' => [
                    'title' => esc_html__('With the right equipment, - Hardware Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-hardware-services',
                    'section_number' => 2,
                    'images_count' => 9,
                    'tags' => ['cta', 'hardware', 'services', 'text', 'image', 'button'],
                ],
                't1-hardware-services-section-3' => [
                    'title' => esc_html__('
Plug it in, set - Hardware Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't1-hardware-services',
                    'section_number' => 3,
                    'images_count' => 15,
                    'tags' => ['hero', 'hardware', 'services', 'text', 'image', 'heading', 'divider', 'button', 'image carousel'],
                ],
                't1-hardware-services-section-4' => [
                    'title' => esc_html__('“I was so happy - Hardware Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't1-hardware-services',
                    'section_number' => 4,
                    'images_count' => 6,
                    'tags' => ['header', 'hardware', 'services', 'text', 'image', 'heading', 'star rating'],
                ],
                't1-hardware-services-section-5' => [
                    'title' => esc_html__('
Plug it in, set - Hardware Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-hardware-services',
                    'section_number' => 5,
                    'images_count' => 2,
                    'tags' => ['content', 'hardware', 'services', 'text', 'image', 'toggle'],
                ],
                't1-hardware-services-section-6' => [
                    'title' => esc_html__('With the right equipment, - Hardware Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-hardware-services',
                    'section_number' => 6,
                    'images_count' => 2,
                    'tags' => ['cta', 'hardware', 'services', 'text', 'button', 'image'],
                ],
                't1-hosting-section-1' => [
                    'title' => esc_html__('Affordable hosting solution with - Hosting', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-hosting',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['cta', 'hosting', 'text', 'button', 'icon list', 'image'],
                ],
                't1-hosting-section-2' => [
                    'title' => esc_html__('Hosting - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't1-hosting',
                    'section_number' => 2,
                    'images_count' => 5,
                    'tags' => ['general', 'hosting', 'image carousel'],
                ],
                't1-hosting-section-3' => [
                    'title' => esc_html__('Affordable hosting solution with - Hosting', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-hosting',
                    'section_number' => 3,
                    'images_count' => 11,
                    'tags' => ['cta', 'hosting', 'image', 'text', 'image box', 'button'],
                ],
                't1-hosting-section-4' => [
                    'title' => esc_html__('Affordable hosting solution with - Hosting', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-hosting',
                    'section_number' => 4,
                    'images_count' => 4,
                    'tags' => ['cta', 'hosting', 'text', 'image', 'button', 'divider', 'icon list'],
                ],
                't1-hosting-section-5' => [
                    'title' => esc_html__('Affordable hosting solution with - Hosting', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't1-hosting',
                    'section_number' => 5,
                    'images_count' => 4,
                    'tags' => ['hero', 'hosting', 'image', 'text', 'button', 'star rating', 'heading'],
                ],
                't1-hosting-section-6' => [
                    'title' => esc_html__('Affordable hosting solution with - Hosting', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-hosting',
                    'section_number' => 6,
                    'images_count' => 6,
                    'tags' => ['content', 'hosting', 'text', 'toggle'],
                ],
                't1-hosting-section-7' => [
                    'title' => esc_html__('Affordable hosting solution with - Hosting', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-hosting',
                    'section_number' => 7,
                    'images_count' => 1,
                    'tags' => ['cta', 'hosting', 'text', 'button', 'image'],
                ],
                't1-it-services-section-1' => [
                    'title' => esc_html__('With our marketing and - It Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-it-services',
                    'section_number' => 1,
                    'images_count' => 4,
                    'tags' => ['cta', 'services', 'image', 'text path', 'text', 'button'],
                ],
                't1-it-services-section-2' => [
                    'title' => esc_html__('Keeping your business on - It Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-it-services',
                    'section_number' => 2,
                    'images_count' => 6,
                    'tags' => ['cta', 'services', 'text', 'image', 'button'],
                ],
                't1-it-services-section-3' => [
                    'title' => esc_html__('Keeping your business on - It Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't1-it-services',
                    'section_number' => 3,
                    'images_count' => 11,
                    'tags' => ['hero', 'services', 'heading', 'text', 'spacer', 'icon list', 'image', 'button'],
                ],
                't1-it-services-section-4' => [
                    'title' => esc_html__('With our marketing and - It Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-it-services',
                    'section_number' => 4,
                    'images_count' => 6,
                    'tags' => ['cta', 'services', 'text', 'image box', 'button'],
                ],
                't1-it-services-section-5' => [
                    'title' => esc_html__('Keeping your business on - It Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-it-services',
                    'section_number' => 5,
                    'images_count' => 2,
                    'tags' => ['content', 'services', 'text', 'image', 'testimonial', 'icon box'],
                ],
                't1-it-services-section-6' => [
                    'title' => esc_html__('Keeping your business on - It Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-it-services',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['cta', 'services', 'text', 'button'],
                ],
                't1-our-services-dark-section-1' => [
                    'title' => esc_html__('Developing digital products is - Our Services Dark', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-our-services-dark',
                    'section_number' => 1,
                    'images_count' => 0,
                    'tags' => ['content', 'our', 'services', 'dark', 'text'],
                ],
                't1-our-services-dark-section-2' => [
                    'title' => esc_html__('Our Services Dark - Gallery Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'galleries',
                    'section_type' => 'gallery',
                    'parent_template' => 't1-our-services-dark',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['gallery', 'our', 'services', 'dark', 'image'],
                ],
                't1-our-services-dark-section-3' => [
                    'title' => esc_html__('Satisfaction rate - Our Services Dark', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't1-our-services-dark',
                    'section_number' => 3,
                    'images_count' => 0,
                    'tags' => ['header', 'our', 'services', 'dark', 'heading', 'text'],
                ],
                't1-our-services-dark-section-4' => [
                    'title' => esc_html__('Our web development company - Our Services Dark', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-our-services-dark',
                    'section_number' => 4,
                    'images_count' => 5,
                    'tags' => ['cta', 'our', 'services', 'dark', 'text', 'image', 'button'],
                ],
                't1-our-services-dark-section-5' => [
                    'title' => esc_html__('Our web development company - Our Services Dark', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't1-our-services-dark',
                    'section_number' => 5,
                    'images_count' => 3,
                    'tags' => ['header', 'our', 'services', 'dark', 'text', 'star rating', 'image', 'heading'],
                ],
                't1-our-services-dark-section-6' => [
                    'title' => esc_html__('Our web development company - Our Services Dark', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't1-our-services-dark',
                    'section_number' => 6,
                    'images_count' => 0,
                    'tags' => ['hero', 'our', 'services', 'dark', 'text', 'heading', 'divider', 'icon list', 'button'],
                ],
                't1-our-services-dark-section-7' => [
                    'title' => esc_html__('Our web development company - Our Services Dark', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-our-services-dark',
                    'section_number' => 7,
                    'images_count' => 7,
                    'tags' => ['content', 'our', 'services', 'dark', 'text', 'image'],
                ],
                't1-our-services-dark-section-8' => [
                    'title' => esc_html__('Write us a message - Our Services Dark', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-our-services-dark',
                    'section_number' => 8,
                    'images_count' => 0,
                    'tags' => ['cta', 'our', 'services', 'dark', 'text', 'button'],
                ],
                't1-our-services-section-1' => [
                    'title' => esc_html__('Developing digital products is - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-our-services',
                    'section_number' => 1,
                    'images_count' => 0,
                    'tags' => ['content', 'our', 'services', 'text'],
                ],
                't1-our-services-section-2' => [
                    'title' => esc_html__('Our Services - Gallery Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'galleries',
                    'section_type' => 'gallery',
                    'parent_template' => 't1-our-services',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['gallery', 'our', 'services', 'image'],
                ],
                't1-our-services-section-3' => [
                    'title' => esc_html__('Satisfaction rate - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't1-our-services',
                    'section_number' => 3,
                    'images_count' => 0,
                    'tags' => ['header', 'our', 'services', 'heading', 'text'],
                ],
                't1-our-services-section-4' => [
                    'title' => esc_html__('Our web development company - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-our-services',
                    'section_number' => 4,
                    'images_count' => 5,
                    'tags' => ['cta', 'our', 'services', 'text', 'image', 'button'],
                ],
                't1-our-services-section-5' => [
                    'title' => esc_html__('Our web development company - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't1-our-services',
                    'section_number' => 5,
                    'images_count' => 3,
                    'tags' => ['header', 'our', 'services', 'text', 'star rating', 'image', 'heading'],
                ],
                't1-our-services-section-6' => [
                    'title' => esc_html__('Our web development company - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't1-our-services',
                    'section_number' => 6,
                    'images_count' => 0,
                    'tags' => ['hero', 'our', 'services', 'text', 'heading', 'divider', 'icon list', 'button'],
                ],
                't1-our-services-section-7' => [
                    'title' => esc_html__('Our web development company - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-our-services',
                    'section_number' => 7,
                    'images_count' => 7,
                    'tags' => ['content', 'our', 'services', 'text', 'image'],
                ],
                't1-our-team-dark-section-1' => [
                    'title' => esc_html__('Creative solutions. Everyday.
 - Our Team Dark', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-our-team-dark',
                    'section_number' => 1,
                    'images_count' => 0,
                    'tags' => ['content', 'our', 'team', 'dark', 'text'],
                ],
                't1-our-team-dark-section-2' => [
                    'title' => esc_html__('Our Team Dark - Gallery Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'galleries',
                    'section_type' => 'gallery',
                    'parent_template' => 't1-our-team-dark',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['gallery', 'our', 'team', 'dark', 'image'],
                ],
                't1-our-team-dark-section-4' => [
                    'title' => esc_html__('Our web development company - Our Team Dark', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-our-team-dark',
                    'section_number' => 4,
                    'images_count' => 9,
                    'tags' => ['content', 'our', 'team', 'dark', 'text', 'image', 'social icons'],
                ],
                't1-our-team-dark-section-5' => [
                    'title' => esc_html__('Our web development company - Our Team Dark', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-our-team-dark',
                    'section_number' => 5,
                    'images_count' => 7,
                    'tags' => ['content', 'our', 'team', 'dark', 'text', 'image'],
                ],
                't1-our-team-section-1' => [
                    'title' => esc_html__('Creative solutions. Everyday.
 - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-our-team',
                    'section_number' => 1,
                    'images_count' => 0,
                    'tags' => ['content', 'our', 'team', 'text'],
                ],
                't1-our-team-section-2' => [
                    'title' => esc_html__('Our Team - Gallery Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'galleries',
                    'section_type' => 'gallery',
                    'parent_template' => 't1-our-team',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['gallery', 'our', 'team', 'image'],
                ],
                't1-our-team-section-4' => [
                    'title' => esc_html__('Our web development company - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-our-team',
                    'section_number' => 4,
                    'images_count' => 9,
                    'tags' => ['content', 'our', 'team', 'text', 'image', 'social icons'],
                ],
                't1-our-team-section-5' => [
                    'title' => esc_html__('Our web development company - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-our-team',
                    'section_number' => 5,
                    'images_count' => 7,
                    'tags' => ['content', 'our', 'team', 'text', 'image'],
                ],
                't1-saas-finance-section-1' => [
                    'title' => esc_html__('Make your finance goal - Saas Finance', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-saas-finance',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['cta', 'saas', 'finance', 'text', 'button', 'icon list', 'image'],
                ],
                't1-saas-finance-section-2' => [
                    'title' => esc_html__('Trusted by industry leaders - Saas Finance', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-saas-finance',
                    'section_number' => 2,
                    'images_count' => 6,
                    'tags' => ['content', 'saas', 'finance', 'text', 'image carousel'],
                ],
                't1-saas-finance-section-3' => [
                    'title' => esc_html__('Make your finance goal - Saas Finance', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't1-saas-finance',
                    'section_number' => 3,
                    'images_count' => 4,
                    'tags' => ['hero', 'saas', 'finance', 'text', 'star rating', 'image', 'divider', 'heading', 'button'],
                ],
                't1-saas-finance-section-4' => [
                    'title' => esc_html__('Reports generated - Saas Finance', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't1-saas-finance',
                    'section_number' => 4,
                    'images_count' => 0,
                    'tags' => ['general', 'saas', 'finance', 'counter'],
                ],
                't1-saas-finance-section-5' => [
                    'title' => esc_html__(' Interdum et malesuada - Saas Finance', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't1-saas-finance',
                    'section_number' => 5,
                    'images_count' => 6,
                    'tags' => ['hero', 'saas', 'finance', 'text', 'heading', 'image box', 'image', 'button', 'divider'],
                ],
                't1-saas-finance-section-6' => [
                    'title' => esc_html__('“I am happy that - Saas Finance', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't1-saas-finance',
                    'section_number' => 6,
                    'images_count' => 5,
                    'tags' => ['header', 'saas', 'finance', 'heading', 'divider', 'image', 'text', 'star rating'],
                ],
                't1-saas-finance-section-7' => [
                    'title' => esc_html__('Didn\'t find your answer?  - Saas Finance', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-saas-finance',
                    'section_number' => 7,
                    'images_count' => 0,
                    'tags' => ['content', 'saas', 'finance', 'text', 'icon box'],
                ],
                't1-saas-finance-section-8' => [
                    'title' => esc_html__('Make your finance goal - Saas Finance', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-saas-finance',
                    'section_number' => 8,
                    'images_count' => 1,
                    'tags' => ['cta', 'saas', 'finance', 'text', 'button'],
                ],
                't1-saas-task-management-section-1' => [
                    'title' => esc_html__('Take care of all - Saas Task Management', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-saas-task-management',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['cta', 'saas', 'task', 'management', 'text', 'button', 'image'],
                ],
                't1-saas-task-management-section-2' => [
                    'title' => esc_html__('Trusted by 10,000+ customers - Saas Task Management', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-saas-task-management',
                    'section_number' => 2,
                    'images_count' => 6,
                    'tags' => ['content', 'saas', 'task', 'management', 'text', 'image carousel'],
                ],
                't1-saas-task-management-section-3' => [
                    'title' => esc_html__('Keeping track of everything - Saas Task Management', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-saas-task-management',
                    'section_number' => 3,
                    'images_count' => 6,
                    'tags' => ['content', 'saas', 'task', 'management', 'text', 'image box'],
                ],
                't1-saas-task-management-section-4' => [
                    'title' => esc_html__('Saluta boards are built - Saas Task Management', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-saas-task-management',
                    'section_number' => 4,
                    'images_count' => 7,
                    'tags' => ['cta', 'saas', 'task', 'management', 'image', 'text', 'button'],
                ],
                't1-saas-task-management-section-5' => [
                    'title' => esc_html__('Keeping track of everything - Saas Task Management', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-saas-task-management',
                    'section_number' => 5,
                    'images_count' => 8,
                    'tags' => ['content', 'saas', 'task', 'management', 'text', 'image box'],
                ],
                't1-saas-task-management-section-6' => [
                    'title' => esc_html__('Saluta boards are built - Saas Task Management', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-saas-task-management',
                    'section_number' => 6,
                    'images_count' => 4,
                    'tags' => ['cta', 'saas', 'task', 'management', 'image', 'text', 'button'],
                ],
                't1-saas-task-management-section-7' => [
                    'title' => esc_html__('\"I am happy that - Saas Task Management', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't1-saas-task-management',
                    'section_number' => 7,
                    'images_count' => 6,
                    'tags' => ['header', 'saas', 'task', 'management', 'text', 'image', 'heading'],
                ],
                't1-saas-task-management-section-8' => [
                    'title' => esc_html__('Take care of all - Saas Task Management', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-saas-task-management',
                    'section_number' => 8,
                    'images_count' => 2,
                    'tags' => ['cta', 'saas', 'task', 'management', 'text', 'button'],
                ],
                't1-startup-section-1' => [
                    'title' => esc_html__('We provide platform with - Startup', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't1-startup',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['hero', 'startup', 'text', 'styled text', 'button', 'icon list', 'king addons video popup'],
                ],
                't1-startup-section-2' => [
                    'title' => esc_html__('Tasks completed - Startup', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't1-startup',
                    'section_number' => 2,
                    'images_count' => 0,
                    'tags' => ['header', 'startup', 'heading', 'text'],
                ],
                't1-startup-section-3' => [
                    'title' => esc_html__('We provide platform with - Startup', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't1-startup',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['hero', 'startup', 'text', 'counter', 'heading', 'button'],
                ],
                't1-startup-section-4' => [
                    'title' => esc_html__('We provide platform with - Startup', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-startup',
                    'section_number' => 4,
                    'images_count' => 3,
                    'tags' => ['cta', 'startup', 'text', 'button'],
                ],
                't1-startup-section-5' => [
                    'title' => esc_html__('Curabitur lacus est, pretium - Startup', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't1-startup',
                    'section_number' => 5,
                    'images_count' => 2,
                    'tags' => ['hero', 'startup', 'styled text', 'text', 'image', 'button'],
                ],
                't1-startup-section-6' => [
                    'title' => esc_html__('We provide platform with - Startup', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-startup',
                    'section_number' => 6,
                    'images_count' => 0,
                    'tags' => ['content', 'startup', 'text', 'toggle'],
                ],
                't1-startup-section-7' => [
                    'title' => esc_html__('We provide platform with - Startup', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-startup',
                    'section_number' => 7,
                    'images_count' => 0,
                    'tags' => ['cta', 'startup', 'text', 'button'],
                ],
                't1-web-app-showcase-section-1' => [
                    'title' => esc_html__('You can work faster - Web App Showcase', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-web-app-showcase',
                    'section_number' => 1,
                    'images_count' => 4,
                    'tags' => ['cta', 'web', 'app', 'showcase', 'text', 'image', 'button'],
                ],
                't1-web-app-showcase-section-2' => [
                    'title' => esc_html__('Trusted by companies all - Web App Showcase', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-web-app-showcase',
                    'section_number' => 2,
                    'images_count' => 6,
                    'tags' => ['content', 'web', 'app', 'showcase', 'text', 'image carousel'],
                ],
                't1-web-app-showcase-section-3' => [
                    'title' => esc_html__('If you want to - Web App Showcase', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't1-web-app-showcase',
                    'section_number' => 3,
                    'images_count' => 3,
                    'tags' => ['header', 'web', 'app', 'showcase', 'text', 'image', 'heading'],
                ],
                't1-web-app-showcase-section-4' => [
                    'title' => esc_html__('With Saluta, you can - Web App Showcase', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-web-app-showcase',
                    'section_number' => 4,
                    'images_count' => 7,
                    'tags' => ['cta', 'web', 'app', 'showcase', 'image', 'text', 'button', 'icon list'],
                ],
                't1-web-app-showcase-section-5' => [
                    'title' => esc_html__('Our happy customers stories - Web App Showcase', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't1-web-app-showcase',
                    'section_number' => 5,
                    'images_count' => 6,
                    'tags' => ['content', 'web', 'app', 'showcase', 'text', 'image', 'king addons card carousel'],
                ],
                't1-web-app-showcase-section-6' => [
                    'title' => esc_html__('Work faster and more - Web App Showcase', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-web-app-showcase',
                    'section_number' => 6,
                    'images_count' => 2,
                    'tags' => ['cta', 'web', 'app', 'showcase', 'text', 'button', 'image', 'king addons blog posts'],
                ],
                't1-web-development-section-1' => [
                    'title' => esc_html__('By creating a custom - Web Development', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-web-development',
                    'section_number' => 1,
                    'images_count' => 4,
                    'tags' => ['cta', 'web', 'development', 'text', 'button', 'image'],
                ],
                't1-web-development-section-2' => [
                    'title' => esc_html__('Through innovative custom design, - Web Development', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-web-development',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['cta', 'web', 'development', 'text', 'image', 'counter', 'button'],
                ],
                't1-web-development-section-3' => [
                    'title' => esc_html__('By creating a custom - Web Development', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-web-development',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['cta', 'web', 'development', 'text', 'button'],
                ],
                't1-web-development-section-4' => [
                    'title' => esc_html__('Through innovative custom design, - Web Development', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-web-development',
                    'section_number' => 4,
                    'images_count' => 2,
                    'tags' => ['cta', 'web', 'development', 'image', 'text', 'button'],
                ],
                't1-web-development-section-5' => [
                    'title' => esc_html__('Find your solution — - Web Development', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't1-web-development',
                    'section_number' => 5,
                    'images_count' => 4,
                    'tags' => ['cta', 'web', 'development', 'text', 'image box', 'button', 'king addons blog posts', 'image'],
                ],
                't10-a-taste-of-italy-section-1' => [
                    'title' => esc_html__('From our kitchen to - A Taste Of Italy', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't10-a-taste-of-italy',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['cta', 'taste', 'italy', 'text path', 'text', 'button'],
                ],
                't10-a-taste-of-italy-section-2' => [
                    'title' => esc_html__('A Taste Of Italy - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't10-a-taste-of-italy',
                    'section_number' => 2,
                    'images_count' => 7,
                    'tags' => ['general', 'taste', 'italy', 'image carousel'],
                ],
                't10-a-taste-of-italy-section-3' => [
                    'title' => esc_html__('Each dish is thoughtfully - A Taste Of Italy', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't10-a-taste-of-italy',
                    'section_number' => 3,
                    'images_count' => 3,
                    'tags' => ['cta', 'taste', 'italy', 'text', 'image', 'button'],
                ],
                't10-a-taste-of-italy-section-4' => [
                    'title' => esc_html__('With years of experience - A Taste Of Italy', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't10-a-taste-of-italy',
                    'section_number' => 4,
                    'images_count' => 7,
                    'tags' => ['cta', 'taste', 'italy', 'image', 'text', 'button'],
                ],
                't10-a-taste-of-italy-section-5' => [
                    'title' => esc_html__('We import our olive - A Taste Of Italy', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't10-a-taste-of-italy',
                    'section_number' => 5,
                    'images_count' => 4,
                    'tags' => ['hero', 'taste', 'italy', 'text', 'counter', 'heading', 'button'],
                ],
                't10-a-taste-of-italy-section-6' => [
                    'title' => esc_html__('We take pride in - A Taste Of Italy', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't10-a-taste-of-italy',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['content', 'taste', 'italy', 'text'],
                ],
                't10-a-taste-of-italy-section-7' => [
                    'title' => esc_html__('Chef\'s Recommendations from Italy\'s - A Taste Of Italy', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't10-a-taste-of-italy',
                    'section_number' => 7,
                    'images_count' => 2,
                    'tags' => ['content', 'taste', 'italy', 'text', 'divider', 'king addons price list'],
                ],
                't10-a-taste-of-italy-section-8' => [
                    'title' => esc_html__('A Taste Of Italy - General Section 8', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't10-a-taste-of-italy',
                    'section_number' => 8,
                    'images_count' => 9,
                    'tags' => ['general', 'taste', 'italy', 'king addons image grid'],
                ],
                't10-a-taste-of-italy-section-9' => [
                    'title' => esc_html__('Immerse Yourself in the - A Taste Of Italy', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't10-a-taste-of-italy',
                    'section_number' => 9,
                    'images_count' => 0,
                    'tags' => ['content', 'taste', 'italy', 'text', 'king addons blog posts'],
                ],
                't10-a-taste-of-italy-section-10' => [
                    'title' => esc_html__('Our passion for authentic - A Taste Of Italy', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't10-a-taste-of-italy',
                    'section_number' => 10,
                    'images_count' => 3,
                    'tags' => ['cta', 'taste', 'italy', 'text', 'button'],
                ],
                't10-about-us-section-1' => [
                    'title' => esc_html__('Our chefs bring a - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't10-about-us',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['content', 'about', 'text'],
                ],
                't10-about-us-section-2' => [
                    'title' => esc_html__('Each dish is thoughtfully - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't10-about-us',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['cta', 'about', 'text', 'image', 'button'],
                ],
                't10-about-us-section-3' => [
                    'title' => esc_html__('With years of experience - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't10-about-us',
                    'section_number' => 3,
                    'images_count' => 11,
                    'tags' => ['cta', 'about', 'text', 'image', 'button'],
                ],
                't10-about-us-section-4' => [
                    'title' => esc_html__('We take pride in - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't10-about-us',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['content', 'about', 'text'],
                ],
                't10-about-us-section-5' => [
                    'title' => esc_html__('Our passion for authentic - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't10-about-us',
                    'section_number' => 5,
                    'images_count' => 3,
                    'tags' => ['cta', 'about', 'text', 'button'],
                ],
                't10-contact-us-section-1' => [
                    'title' => esc_html__('Our chefs bring a - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't10-contact-us',
                    'section_number' => 1,
                    'images_count' => 7,
                    'tags' => ['header', 'contact', 'text', 'heading', 'shortcode', 'spacer'],
                ],
                't10-contact-us-section-2' => [
                    'title' => esc_html__('Contact Us - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't10-contact-us',
                    'section_number' => 2,
                    'images_count' => 0,
                    'tags' => ['general', 'contact', 'icon box'],
                ],
                't10-contact-us-section-3' => [
                    'title' => esc_html__('A Journey Through Italian - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't10-contact-us',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['content', 'contact', 'text', 'google_maps'],
                ],
                't10-contact-us-section-4' => [
                    'title' => esc_html__('Our passion for authentic - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't10-contact-us',
                    'section_number' => 4,
                    'images_count' => 3,
                    'tags' => ['cta', 'contact', 'text', 'button'],
                ],
                't10-menu-section-1' => [
                    'title' => esc_html__('Our chefs bring a - Menu', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't10-menu',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['content', 'menu', 'text'],
                ],
                't10-menu-section-2' => [
                    'title' => esc_html__('Chef\'s Recommendations from Italy\'s - Menu', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't10-menu',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['content', 'menu', 'text', 'divider', 'king addons price list'],
                ],
                't10-menu-section-3' => [
                    'title' => esc_html__('Our passion for authentic - Menu', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't10-menu',
                    'section_number' => 3,
                    'images_count' => 3,
                    'tags' => ['cta', 'menu', 'text', 'button'],
                ],
                't10-our-team-section-1' => [
                    'title' => esc_html__('Our chefs bring a - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't10-our-team',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['content', 'our', 'team', 'text'],
                ],
                't10-our-team-section-2' => [
                    'title' => esc_html__('Restaurant Manager - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't10-our-team',
                    'section_number' => 2,
                    'images_count' => 9,
                    'tags' => ['header', 'our', 'team', 'image', 'heading', 'social icons'],
                ],
                't10-our-team-section-3' => [
                    'title' => esc_html__('Our passion for authentic - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't10-our-team',
                    'section_number' => 3,
                    'images_count' => 3,
                    'tags' => ['cta', 'our', 'team', 'text', 'button'],
                ],
                't10-savor-the-moment-section-1' => [
                    'title' => esc_html__('Our passion for authentic - Savor The Moment', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't10-savor-the-moment',
                    'section_number' => 1,
                    'images_count' => 6,
                    'tags' => ['cta', 'savor', 'the', 'moment', 'image', 'text path', 'text', 'button'],
                ],
                't10-savor-the-moment-section-2' => [
                    'title' => esc_html__('Each dish is thoughtfully - Savor The Moment', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't10-savor-the-moment',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['cta', 'savor', 'the', 'moment', 'text', 'image', 'button'],
                ],
                't10-savor-the-moment-section-3' => [
                    'title' => esc_html__('With years of experience - Savor The Moment', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't10-savor-the-moment',
                    'section_number' => 3,
                    'images_count' => 7,
                    'tags' => ['cta', 'savor', 'the', 'moment', 'image', 'text', 'button'],
                ],
                't10-savor-the-moment-section-4' => [
                    'title' => esc_html__('We import our olive - Savor The Moment', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't10-savor-the-moment',
                    'section_number' => 4,
                    'images_count' => 4,
                    'tags' => ['hero', 'savor', 'the', 'moment', 'text', 'counter', 'heading', 'button'],
                ],
                't10-savor-the-moment-section-5' => [
                    'title' => esc_html__('We take pride in - Savor The Moment', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't10-savor-the-moment',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['content', 'savor', 'the', 'moment', 'text'],
                ],
                't10-savor-the-moment-section-6' => [
                    'title' => esc_html__('Chef\'s Recommendations from Italy\'s - Savor The Moment', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't10-savor-the-moment',
                    'section_number' => 6,
                    'images_count' => 2,
                    'tags' => ['content', 'savor', 'the', 'moment', 'text', 'divider', 'king addons price list'],
                ],
                't10-savor-the-moment-section-7' => [
                    'title' => esc_html__('Hear What Our Guests - Savor The Moment', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't10-savor-the-moment',
                    'section_number' => 7,
                    'images_count' => 7,
                    'tags' => ['content', 'savor', 'the', 'moment', 'text', 'king addons card carousel'],
                ],
                't10-savor-the-moment-section-9' => [
                    'title' => esc_html__('Our passion for authentic - Savor The Moment', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't10-savor-the-moment',
                    'section_number' => 9,
                    'images_count' => 3,
                    'tags' => ['content', 'savor', 'the', 'moment', 'text', 'social icons'],
                ],
                't10-served-with-love-section-1' => [
                    'title' => esc_html__('Our passion for authentic - Served With Love', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't10-served-with-love',
                    'section_number' => 1,
                    'images_count' => 8,
                    'tags' => ['cta', 'served', 'with', 'love', 'text path', 'text', 'button', 'image', 'image box', 'king addons video popup'],
                ],
                't10-served-with-love-section-2' => [
                    'title' => esc_html__('Served With Love - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't10-served-with-love',
                    'section_number' => 2,
                    'images_count' => 7,
                    'tags' => ['general', 'served', 'with', 'love', 'image carousel'],
                ],
                't10-served-with-love-section-3' => [
                    'title' => esc_html__('Each dish is thoughtfully - Served With Love', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't10-served-with-love',
                    'section_number' => 3,
                    'images_count' => 3,
                    'tags' => ['cta', 'served', 'with', 'love', 'text', 'image', 'button'],
                ],
                't10-served-with-love-section-4' => [
                    'title' => esc_html__('With years of experience - Served With Love', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't10-served-with-love',
                    'section_number' => 4,
                    'images_count' => 11,
                    'tags' => ['cta', 'served', 'with', 'love', 'text', 'image', 'button'],
                ],
                't10-served-with-love-section-5' => [
                    'title' => esc_html__('We take pride in - Served With Love', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't10-served-with-love',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['content', 'served', 'with', 'love', 'text'],
                ],
                't10-served-with-love-section-6' => [
                    'title' => esc_html__('Chef\'s Recommendations from Italy\'s - Served With Love', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't10-served-with-love',
                    'section_number' => 6,
                    'images_count' => 2,
                    'tags' => ['content', 'served', 'with', 'love', 'text', 'divider', 'king addons price list'],
                ],
                't10-served-with-love-section-7' => [
                    'title' => esc_html__('Hear What Our Guests - Served With Love', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't10-served-with-love',
                    'section_number' => 7,
                    'images_count' => 7,
                    'tags' => ['content', 'served', 'with', 'love', 'text', 'king addons card carousel'],
                ],
                't10-served-with-love-section-8' => [
                    'title' => esc_html__('Served With Love - General Section 8', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't10-served-with-love',
                    'section_number' => 8,
                    'images_count' => 9,
                    'tags' => ['general', 'served', 'with', 'love', 'king addons image grid'],
                ],
                't10-served-with-love-section-9' => [
                    'title' => esc_html__('Immerse Yourself in the - Served With Love', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't10-served-with-love',
                    'section_number' => 9,
                    'images_count' => 0,
                    'tags' => ['content', 'served', 'with', 'love', 'text', 'king addons blog posts'],
                ],
                't10-served-with-love-section-10' => [
                    'title' => esc_html__('Our passion for authentic - Served With Love', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't10-served-with-love',
                    'section_number' => 10,
                    'images_count' => 3,
                    'tags' => ['cta', 'served', 'with', 'love', 'text', 'button'],
                ],
                't10-the-heart-of-italy-section-1' => [
                    'title' => esc_html__('Our passion for authentic - The Heart Of Italy', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't10-the-heart-of-italy',
                    'section_number' => 1,
                    'images_count' => 7,
                    'tags' => ['cta', 'the', 'heart', 'italy', 'image', 'king addons video popup', 'text path', 'text', 'button', 'social icons'],
                ],
                't10-the-heart-of-italy-section-2' => [
                    'title' => esc_html__('The Heart Of Italy - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't10-the-heart-of-italy',
                    'section_number' => 2,
                    'images_count' => 7,
                    'tags' => ['general', 'the', 'heart', 'italy', 'image carousel'],
                ],
                't10-the-heart-of-italy-section-3' => [
                    'title' => esc_html__('Each dish is thoughtfully - The Heart Of Italy', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't10-the-heart-of-italy',
                    'section_number' => 3,
                    'images_count' => 3,
                    'tags' => ['cta', 'the', 'heart', 'italy', 'text', 'image', 'button'],
                ],
                't10-the-heart-of-italy-section-4' => [
                    'title' => esc_html__('With years of experience - The Heart Of Italy', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't10-the-heart-of-italy',
                    'section_number' => 4,
                    'images_count' => 15,
                    'tags' => ['cta', 'the', 'heart', 'italy', 'text', 'image', 'button', 'king addons auto scrolling text'],
                ],
                't10-the-heart-of-italy-section-5' => [
                    'title' => esc_html__('We take pride in - The Heart Of Italy', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't10-the-heart-of-italy',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['content', 'the', 'heart', 'italy', 'text'],
                ],
                't10-the-heart-of-italy-section-6' => [
                    'title' => esc_html__('Chef\'s Recommendations from Italy\'s - The Heart Of Italy', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't10-the-heart-of-italy',
                    'section_number' => 6,
                    'images_count' => 2,
                    'tags' => ['content', 'the', 'heart', 'italy', 'text', 'divider', 'king addons price list'],
                ],
                't10-the-heart-of-italy-section-7' => [
                    'title' => esc_html__('Hear What Our Guests - The Heart Of Italy', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't10-the-heart-of-italy',
                    'section_number' => 7,
                    'images_count' => 7,
                    'tags' => ['content', 'the', 'heart', 'italy', 'text', 'king addons card carousel'],
                ],
                't10-the-heart-of-italy-section-8' => [
                    'title' => esc_html__('The Heart Of Italy - General Section 8', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't10-the-heart-of-italy',
                    'section_number' => 8,
                    'images_count' => 9,
                    'tags' => ['general', 'the', 'heart', 'italy', 'king addons image grid'],
                ],
                't10-the-heart-of-italy-section-9' => [
                    'title' => esc_html__('Immerse Yourself in the - The Heart Of Italy', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't10-the-heart-of-italy',
                    'section_number' => 9,
                    'images_count' => 0,
                    'tags' => ['content', 'the', 'heart', 'italy', 'text', 'king addons blog posts'],
                ],
                't10-the-heart-of-italy-section-10' => [
                    'title' => esc_html__('Our passion for authentic - The Heart Of Italy', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't10-the-heart-of-italy',
                    'section_number' => 10,
                    'images_count' => 3,
                    'tags' => ['cta', 'the', 'heart', 'italy', 'text', 'button'],
                ],
                't11-about-us-section-1' => [
                    'title' => esc_html__('Your Partner in Reliable - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't11-about-us',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['content', 'about', 'text'],
                ],
                't11-about-us-section-2' => [
                    'title' => esc_html__('About Us - Gallery Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'galleries',
                    'section_type' => 'gallery',
                    'parent_template' => 't11-about-us',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['gallery', 'about', 'image'],
                ],
                't11-about-us-section-3' => [
                    'title' => esc_html__('In today\'s rapidly evolving - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't11-about-us',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['header', 'about', 'image', 'html', 'text', 'styled text', 'icon list'],
                ],
                't11-about-us-section-4' => [
                    'title' => esc_html__('With operations in 20 - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't11-about-us',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['header', 'about', 'styled text', 'counter', 'heading'],
                ],
                't11-about-us-section-5' => [
                    'title' => esc_html__('About Us - General Section 5', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't11-about-us',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['general', 'about', 'king addons video popup'],
                ],
                't11-about-us-section-6' => [
                    'title' => esc_html__('Empowering Your Business with - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't11-about-us',
                    'section_number' => 6,
                    'images_count' => 9,
                    'tags' => ['header', 'about', 'text', 'styled text', 'image'],
                ],
                't11-about-us-section-7' => [
                    'title' => esc_html__(' Our company specializes - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't11-about-us',
                    'section_number' => 7,
                    'images_count' => 1,
                    'tags' => ['hero', 'about', 'text', 'styled text', 'heading', 'button', 'icon box', 'king addons business hours'],
                ],
                't11-about-us-section-8' => [
                    'title' => esc_html__('About Us - General Section 8', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't11-about-us',
                    'section_number' => 8,
                    'images_count' => 0,
                    'tags' => ['general', 'about', 'google_maps'],
                ],
                't11-contact-us-section-1' => [
                    'title' => esc_html__('Discover Our Customer-Centric Services - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't11-contact-us',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['content', 'contact', 'text'],
                ],
                't11-contact-us-section-2' => [
                    'title' => esc_html__('Contact Us - Gallery Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'galleries',
                    'section_type' => 'gallery',
                    'parent_template' => 't11-contact-us',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['gallery', 'contact', 'image'],
                ],
                't11-contact-us-section-3' => [
                    'title' => esc_html__('Cooperate with You - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't11-contact-us',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['header', 'contact', 'text', 'styled text', 'shortcode'],
                ],
                't11-contact-us-section-4' => [
                    'title' => esc_html__(' Our company specializes - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't11-contact-us',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['hero', 'contact', 'text', 'styled text', 'heading', 'button', 'icon box', 'king addons business hours'],
                ],
                't11-efficient-logistics-section-1' => [
                    'title' => esc_html__('Our expertise and experience - Efficient Logistics', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't11-efficient-logistics',
                    'section_number' => 1,
                    'images_count' => 8,
                    'tags' => ['hero', 'efficient', 'logistics', 'text', 'styled text', 'button', 'image', 'image carousel'],
                ],
                't11-efficient-logistics-section-2' => [
                    'title' => esc_html__('In today\'s rapidly evolving - Efficient Logistics', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't11-efficient-logistics',
                    'section_number' => 2,
                    'images_count' => 2,
                    'tags' => ['header', 'efficient', 'logistics', 'image', 'text', 'styled text', 'icon list'],
                ],
                't11-efficient-logistics-section-3' => [
                    'title' => esc_html__('Our advanced route optimization - Efficient Logistics', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't11-efficient-logistics',
                    'section_number' => 3,
                    'images_count' => 10,
                    'tags' => ['header', 'efficient', 'logistics', 'king addons auto scrolling text', 'text', 'styled text', 'image'],
                ],
                't11-efficient-logistics-section-4' => [
                    'title' => esc_html__('Efficient Logistics - General Section 4', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't11-efficient-logistics',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['general', 'efficient', 'logistics', 'king addons video popup'],
                ],
                't11-efficient-logistics-section-5' => [
                    'title' => esc_html__('With operations in 20 - Efficient Logistics', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't11-efficient-logistics',
                    'section_number' => 5,
                    'images_count' => 0,
                    'tags' => ['header', 'efficient', 'logistics', 'text', 'styled text', 'counter', 'heading'],
                ],
                't11-efficient-logistics-section-6' => [
                    'title' => esc_html__('We pride ourselves on - Efficient Logistics', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't11-efficient-logistics',
                    'section_number' => 6,
                    'images_count' => 6,
                    'tags' => ['hero', 'efficient', 'logistics', 'text', 'styled text', 'king addons image hover box', 'button', 'image'],
                ],
                't11-efficient-logistics-section-7' => [
                    'title' => esc_html__(' to our customers - Efficient Logistics', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't11-efficient-logistics',
                    'section_number' => 7,
                    'images_count' => 1,
                    'tags' => ['header', 'efficient', 'logistics', 'styled text'],
                ],
                't11-efficient-logistics-section-8' => [
                    'title' => esc_html__('Why People Consider Us - Efficient Logistics', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't11-efficient-logistics',
                    'section_number' => 8,
                    'images_count' => 5,
                    'tags' => ['header', 'efficient', 'logistics', 'text', 'styled text', 'king addons card carousel'],
                ],
                't11-efficient-logistics-section-9' => [
                    'title' => esc_html__('Our expertise and experience - Efficient Logistics', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't11-efficient-logistics',
                    'section_number' => 9,
                    'images_count' => 1,
                    'tags' => ['hero', 'efficient', 'logistics', 'styled text', 'text', 'button'],
                ],
                't11-effortless-shipping-solutions-section-1' => [
                    'title' => esc_html__('Our expertise and experience - Effortless Shipping Solutions', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't11-effortless-shipping-solutions',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['cta', 'effortless', 'shipping', 'solutions', 'text', 'button', 'image'],
                ],
                't11-effortless-shipping-solutions-section-2' => [
                    'title' => esc_html__('Our advanced route optimization - Effortless Shipping Solutions', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't11-effortless-shipping-solutions',
                    'section_number' => 2,
                    'images_count' => 4,
                    'tags' => ['header', 'effortless', 'shipping', 'solutions', 'text', 'styled text', 'image'],
                ],
                't11-effortless-shipping-solutions-section-3' => [
                    'title' => esc_html__('Effortless Shipping Solutions - General Section 3', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't11-effortless-shipping-solutions',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['general', 'effortless', 'shipping', 'solutions', 'king addons video popup'],
                ],
                't11-effortless-shipping-solutions-section-4' => [
                    'title' => esc_html__('In today\'s rapidly evolving - Effortless Shipping Solutions', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't11-effortless-shipping-solutions',
                    'section_number' => 4,
                    'images_count' => 2,
                    'tags' => ['header', 'effortless', 'shipping', 'solutions', 'image', 'text', 'styled text', 'icon list'],
                ],
                't11-effortless-shipping-solutions-section-5' => [
                    'title' => esc_html__('With operations in 20 - Effortless Shipping Solutions', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't11-effortless-shipping-solutions',
                    'section_number' => 5,
                    'images_count' => 0,
                    'tags' => ['header', 'effortless', 'shipping', 'solutions', 'text', 'styled text', 'counter', 'heading'],
                ],
                't11-effortless-shipping-solutions-section-6' => [
                    'title' => esc_html__('We pride ourselves on - Effortless Shipping Solutions', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't11-effortless-shipping-solutions',
                    'section_number' => 6,
                    'images_count' => 6,
                    'tags' => ['hero', 'effortless', 'shipping', 'solutions', 'text', 'styled text', 'king addons image hover box', 'button', 'image'],
                ],
                't11-effortless-shipping-solutions-section-7' => [
                    'title' => esc_html__('Why People Consider Us - Effortless Shipping Solutions', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't11-effortless-shipping-solutions',
                    'section_number' => 7,
                    'images_count' => 5,
                    'tags' => ['header', 'effortless', 'shipping', 'solutions', 'text', 'styled text', 'king addons card carousel'],
                ],
                't11-effortless-shipping-solutions-section-8' => [
                    'title' => esc_html__('Our expertise and experience - Effortless Shipping Solutions', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't11-effortless-shipping-solutions',
                    'section_number' => 8,
                    'images_count' => 2,
                    'tags' => ['cta', 'effortless', 'shipping', 'solutions', 'text', 'button'],
                ],
                't11-our-services-section-1' => [
                    'title' => esc_html__('Simplifying Your Logistics Experience - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't11-our-services',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['content', 'our', 'services', 'text'],
                ],
                't11-our-services-section-2' => [
                    'title' => esc_html__('Our Services - Gallery Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'galleries',
                    'section_type' => 'gallery',
                    'parent_template' => 't11-our-services',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['gallery', 'our', 'services', 'image'],
                ],
                't11-our-services-section-3' => [
                    'title' => esc_html__('Delivering Peace of Mind - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't11-our-services',
                    'section_number' => 3,
                    'images_count' => 10,
                    'tags' => ['header', 'our', 'services', 'text', 'styled text', 'king addons image hover box', 'king addons auto scrolling text'],
                ],
                't11-our-services-section-4' => [
                    'title' => esc_html__('Our Services - General Section 4', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't11-our-services',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['general', 'our', 'services', 'king addons video popup'],
                ],
                't11-our-services-section-5' => [
                    'title' => esc_html__('We pride ourselves on - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't11-our-services',
                    'section_number' => 5,
                    'images_count' => 3,
                    'tags' => ['hero', 'our', 'services', 'text', 'styled text', 'button', 'image'],
                ],
                't11-our-services-section-6' => [
                    'title' => esc_html__(' Our company specializes - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't11-our-services',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['hero', 'our', 'services', 'text', 'styled text', 'heading', 'button', 'icon box', 'king addons business hours'],
                ],
                't11-our-services-section-7' => [
                    'title' => esc_html__('Our Services - General Section 7', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't11-our-services',
                    'section_number' => 7,
                    'images_count' => 0,
                    'tags' => ['general', 'our', 'services', 'google_maps'],
                ],
                't11-our-team-section-1' => [
                    'title' => esc_html__('From Point A to - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't11-our-team',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['content', 'our', 'team', 'text'],
                ],
                't11-our-team-section-2' => [
                    'title' => esc_html__('Our Team - Gallery Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'galleries',
                    'section_type' => 'gallery',
                    'parent_template' => 't11-our-team',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['gallery', 'our', 'team', 'image'],
                ],
                't11-our-team-section-3' => [
                    'title' => esc_html__('Delivering Peace of Mind - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't11-our-team',
                    'section_number' => 3,
                    'images_count' => 11,
                    'tags' => ['header', 'our', 'team', 'text', 'styled text', 'image', 'social icons'],
                ],
                't11-our-team-section-4' => [
                    'title' => esc_html__('Empowering Your Business with - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't11-our-team',
                    'section_number' => 4,
                    'images_count' => 9,
                    'tags' => ['header', 'our', 'team', 'text', 'styled text', 'image'],
                ],
                't11-our-team-section-5' => [
                    'title' => esc_html__(' Our company specializes - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't11-our-team',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['hero', 'our', 'team', 'text', 'styled text', 'heading', 'button', 'icon box', 'king addons business hours'],
                ],
                't11-revolutionizing-logistics-section-1' => [
                    'title' => esc_html__('Our expertise and experience - Revolutionizing Logistics', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't11-revolutionizing-logistics',
                    'section_number' => 1,
                    'images_count' => 12,
                    'tags' => ['cta', 'revolutionizing', 'logistics', 'text', 'button', 'text path', 'image carousel'],
                ],
                't11-revolutionizing-logistics-section-2' => [
                    'title' => esc_html__('Our advanced route optimization - Revolutionizing Logistics', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't11-revolutionizing-logistics',
                    'section_number' => 2,
                    'images_count' => 4,
                    'tags' => ['header', 'revolutionizing', 'logistics', 'text', 'styled text', 'image'],
                ],
                't11-revolutionizing-logistics-section-3' => [
                    'title' => esc_html__('Revolutionizing Logistics - General Section 3', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't11-revolutionizing-logistics',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['general', 'revolutionizing', 'logistics', 'king addons video popup'],
                ],
                't11-revolutionizing-logistics-section-4' => [
                    'title' => esc_html__('In today\'s rapidly evolving - Revolutionizing Logistics', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't11-revolutionizing-logistics',
                    'section_number' => 4,
                    'images_count' => 2,
                    'tags' => ['header', 'revolutionizing', 'logistics', 'image', 'text', 'styled text', 'icon list'],
                ],
                't11-revolutionizing-logistics-section-5' => [
                    'title' => esc_html__('With operations in 20 - Revolutionizing Logistics', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't11-revolutionizing-logistics',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['header', 'revolutionizing', 'logistics', 'styled text', 'counter', 'heading'],
                ],
                't11-revolutionizing-logistics-section-6' => [
                    'title' => esc_html__('We pride ourselves on - Revolutionizing Logistics', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't11-revolutionizing-logistics',
                    'section_number' => 6,
                    'images_count' => 6,
                    'tags' => ['hero', 'revolutionizing', 'logistics', 'text', 'styled text', 'king addons image hover box', 'button', 'image'],
                ],
                't11-revolutionizing-logistics-section-7' => [
                    'title' => esc_html__('Latest Insights and Updates - Revolutionizing Logistics', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't11-revolutionizing-logistics',
                    'section_number' => 7,
                    'images_count' => 1,
                    'tags' => ['header', 'revolutionizing', 'logistics', 'text', 'styled text', 'king addons blog posts'],
                ],
                't11-revolutionizing-logistics-section-8' => [
                    'title' => esc_html__(' Our company specializes - Revolutionizing Logistics', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't11-revolutionizing-logistics',
                    'section_number' => 8,
                    'images_count' => 1,
                    'tags' => ['hero', 'revolutionizing', 'logistics', 'text', 'styled text', 'heading', 'button', 'icon box', 'king addons business hours'],
                ],
                't11-your-cargo-our-care-section-1' => [
                    'title' => esc_html__('In today\'s rapidly evolving - Your Cargo Our Care', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't11-your-cargo-our-care',
                    'section_number' => 1,
                    'images_count' => 4,
                    'tags' => ['cta', 'your', 'cargo', 'our', 'care', 'text', 'button', 'image', 'text path'],
                ],
                't11-your-cargo-our-care-section-2' => [
                    'title' => esc_html__('We pride ourselves on - Your Cargo Our Care', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't11-your-cargo-our-care',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['hero', 'your', 'cargo', 'our', 'care', 'text', 'styled text', 'button', 'image'],
                ],
                't11-your-cargo-our-care-section-3' => [
                    'title' => esc_html__('Your Cargo Our Care - General Section 3', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't11-your-cargo-our-care',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['general', 'your', 'cargo', 'our', 'care', 'king addons video popup'],
                ],
                't11-your-cargo-our-care-section-4' => [
                    'title' => esc_html__('Delivering Peace of Mind - Your Cargo Our Care', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't11-your-cargo-our-care',
                    'section_number' => 4,
                    'images_count' => 10,
                    'tags' => ['header', 'your', 'cargo', 'our', 'care', 'text', 'styled text', 'king addons image hover box', 'king addons auto scrolling text'],
                ],
                't11-your-cargo-our-care-section-5' => [
                    'title' => esc_html__('In today\'s rapidly evolving - Your Cargo Our Care', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't11-your-cargo-our-care',
                    'section_number' => 5,
                    'images_count' => 2,
                    'tags' => ['header', 'your', 'cargo', 'our', 'care', 'image', 'text', 'styled text', 'icon list'],
                ],
                't11-your-cargo-our-care-section-6' => [
                    'title' => esc_html__('With operations in 20 - Your Cargo Our Care', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't11-your-cargo-our-care',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['header', 'your', 'cargo', 'our', 'care', 'styled text', 'counter', 'heading'],
                ],
                't11-your-cargo-our-care-section-7' => [
                    'title' => esc_html__('Latest Insights and Updates - Your Cargo Our Care', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't11-your-cargo-our-care',
                    'section_number' => 7,
                    'images_count' => 1,
                    'tags' => ['header', 'your', 'cargo', 'our', 'care', 'text', 'styled text', 'king addons blog posts'],
                ],
                't11-your-cargo-our-care-section-8' => [
                    'title' => esc_html__(' Our company specializes - Your Cargo Our Care', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't11-your-cargo-our-care',
                    'section_number' => 8,
                    'images_count' => 1,
                    'tags' => ['hero', 'your', 'cargo', 'our', 'care', 'text', 'styled text', 'heading', 'button', 'king addons business hours', 'shortcode'],
                ],
                't12-about-us-section-1' => [
                    'title' => esc_html__('From Concept to Cutting-Edge - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't12-about-us',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['header', 'about', 'text', 'styled text', 'image'],
                ],
                't12-about-us-section-2' => [
                    'title' => esc_html__('We operate with the - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't12-about-us',
                    'section_number' => 2,
                    'images_count' => 0,
                    'tags' => ['header', 'about', 'styled text', 'text'],
                ],
                't12-about-us-section-3' => [
                    'title' => esc_html__('Grow your e-commerce business - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't12-about-us',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['hero', 'about', 'text', 'styled text', 'button', 'image'],
                ],
                't12-about-us-section-4' => [
                    'title' => esc_html__('As we look to - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't12-about-us',
                    'section_number' => 4,
                    'images_count' => 0,
                    'tags' => ['header', 'about', 'text', 'styled text', 'heading'],
                ],
                't12-about-us-section-5' => [
                    'title' => esc_html__('We operate with the - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't12-about-us',
                    'section_number' => 5,
                    'images_count' => 3,
                    'tags' => ['header', 'about', 'text', 'styled text', 'image'],
                ],
                't12-about-us-section-6' => [
                    'title' => esc_html__('We envision a world - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't12-about-us',
                    'section_number' => 6,
                    'images_count' => 2,
                    'tags' => ['header', 'about', 'styled text'],
                ],
                't12-about-us-section-7' => [
                    'title' => esc_html__('Our team is composed - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't12-about-us',
                    'section_number' => 7,
                    'images_count' => 11,
                    'tags' => ['header', 'about', 'text', 'styled text', 'image box', 'image carousel'],
                ],
                't12-about-us-section-8' => [
                    'title' => esc_html__('We believe in the - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't12-about-us',
                    'section_number' => 8,
                    'images_count' => 2,
                    'tags' => ['hero', 'about', 'styled text', 'text', 'button'],
                ],
                't12-ai-startup-section-1' => [
                    'title' => esc_html__('Our advanced analytics tools - Ai Startup', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't12-ai-startup',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['hero', 'startup', 'text', 'styled text', 'button', 'star rating', 'image'],
                ],
                't12-ai-startup-section-2' => [
                    'title' => esc_html__('Enhance your customer engagement - Ai Startup', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't12-ai-startup',
                    'section_number' => 2,
                    'images_count' => 4,
                    'tags' => ['header', 'startup', 'text', 'styled text', 'image box'],
                ],
                't12-ai-startup-section-3' => [
                    'title' => esc_html__('Our algorithms analyze customer - Ai Startup', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't12-ai-startup',
                    'section_number' => 3,
                    'images_count' => 8,
                    'tags' => ['header', 'startup', 'image', 'text', 'styled text', 'king addons auto scrolling text'],
                ],
                't12-ai-startup-section-4' => [
                    'title' => esc_html__('Our AI analytics web - Ai Startup', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't12-ai-startup',
                    'section_number' => 4,
                    'images_count' => 4,
                    'tags' => ['hero', 'startup', 'text', 'styled text', 'heading', 'button', 'image'],
                ],
                't12-ai-startup-section-5' => [
                    'title' => esc_html__(' Latest AI Innovations - Ai Startup', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't12-ai-startup',
                    'section_number' => 5,
                    'images_count' => 0,
                    'tags' => ['header', 'startup', 'text', 'styled text', 'king addons blog posts'],
                ],
                't12-ai-startup-section-6' => [
                    'title' => esc_html__('From inventory tracking to - Ai Startup', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't12-ai-startup',
                    'section_number' => 6,
                    'images_count' => 3,
                    'tags' => ['header', 'startup', 'text', 'styled text', 'rating', 'testimonial'],
                ],
                't12-ai-startup-section-7' => [
                    'title' => esc_html__('Our AI analytics web - Ai Startup', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't12-ai-startup',
                    'section_number' => 7,
                    'images_count' => 2,
                    'tags' => ['hero', 'startup', 'styled text', 'text', 'button'],
                ],
                't12-contact-us-section-1' => [
                    'title' => esc_html__('We\'re ready to listen! - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't12-contact-us',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['header', 'contact', 'text', 'styled text', 'social icons', 'heading', 'shortcode', 'spacer'],
                ],
                't12-contact-us-section-2' => [
                    'title' => esc_html__('Join us on this - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't12-contact-us',
                    'section_number' => 2,
                    'images_count' => 0,
                    'tags' => ['header', 'contact', 'text', 'styled text', 'google_maps', 'icon box'],
                ],
                't12-contact-us-section-3' => [
                    'title' => esc_html__('We envision a world - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't12-contact-us',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['header', 'contact', 'styled text'],
                ],
                't12-contact-us-section-4' => [
                    'title' => esc_html__('Your Popular Questions, - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't12-contact-us',
                    'section_number' => 4,
                    'images_count' => 0,
                    'tags' => ['header', 'contact', 'text', 'styled text', 'accordion'],
                ],
                't12-contact-us-section-5' => [
                    'title' => esc_html__('We believe in the - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't12-contact-us',
                    'section_number' => 5,
                    'images_count' => 2,
                    'tags' => ['hero', 'contact', 'styled text', 'text', 'button'],
                ],
                't12-mobile-app-section-1' => [
                    'title' => esc_html__('With intuitive features and - Mobile App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't12-mobile-app',
                    'section_number' => 1,
                    'images_count' => 5,
                    'tags' => ['hero', 'mobile', 'app', 'text', 'styled text', 'button', 'image box', 'image'],
                ],
                't12-mobile-app-section-2' => [
                    'title' => esc_html__('We are trusted across - Mobile App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't12-mobile-app',
                    'section_number' => 2,
                    'images_count' => 6,
                    'tags' => ['content', 'mobile', 'app', 'text', 'image carousel'],
                ],
                't12-mobile-app-section-3' => [
                    'title' => esc_html__('Through innovative products, tools, - Mobile App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't12-mobile-app',
                    'section_number' => 3,
                    'images_count' => 5,
                    'tags' => ['header', 'mobile', 'app', 'text', 'styled text', 'image'],
                ],
                't12-mobile-app-section-4' => [
                    'title' => esc_html__('Our fintech app empowers - Mobile App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't12-mobile-app',
                    'section_number' => 4,
                    'images_count' => 12,
                    'tags' => ['hero', 'mobile', 'app', 'text', 'styled text', 'button', 'image', 'icon list', 'king addons auto scrolling text'],
                ],
                't12-mobile-app-section-5' => [
                    'title' => esc_html__('Effortless Financial  - Mobile App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't12-mobile-app',
                    'section_number' => 5,
                    'images_count' => 6,
                    'tags' => ['header', 'mobile', 'app', 'text', 'styled text', 'image box'],
                ],
                't12-mobile-app-section-6' => [
                    'title' => esc_html__('Through innovative products, tools, - Mobile App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't12-mobile-app',
                    'section_number' => 6,
                    'images_count' => 4,
                    'tags' => ['header', 'mobile', 'app', 'text', 'styled text', 'king addons card carousel'],
                ],
                't12-mobile-app-section-7' => [
                    'title' => esc_html__('Say goodbye to complicated - Mobile App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't12-mobile-app',
                    'section_number' => 7,
                    'images_count' => 4,
                    'tags' => ['header', 'mobile', 'app', 'styled text', 'text', 'image'],
                ],
                't12-our-services-section-1' => [
                    'title' => esc_html__('Next-Generation Financial  - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't12-our-services',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['header', 'our', 'services', 'text', 'styled text', 'image'],
                ],
                't12-our-services-section-2' => [
                    'title' => esc_html__('Our AI analytics web - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't12-our-services',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['hero', 'our', 'services', 'text', 'styled text', 'heading', 'button', 'image'],
                ],
                't12-our-services-section-3' => [
                    'title' => esc_html__(' Join us on - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't12-our-services',
                    'section_number' => 3,
                    'images_count' => 0,
                    'tags' => ['hero', 'our', 'services', 'text', 'styled text', 'divider', 'heading', 'button', 'icon list'],
                ],
                't12-our-services-section-4' => [
                    'title' => esc_html__('Gain Actionable Business - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't12-our-services',
                    'section_number' => 4,
                    'images_count' => 12,
                    'tags' => ['header', 'our', 'services', 'text', 'styled text', 'image', 'image box', 'image carousel'],
                ],
                't12-our-services-section-5' => [
                    'title' => esc_html__('We believe in the - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't12-our-services',
                    'section_number' => 5,
                    'images_count' => 2,
                    'tags' => ['hero', 'our', 'services', 'styled text', 'text', 'button'],
                ],
                't12-our-team-section-1' => [
                    'title' => esc_html__('The Team Behind the - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't12-our-team',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['header', 'our', 'team', 'text', 'styled text', 'image'],
                ],
                't12-our-team-section-2' => [
                    'title' => esc_html__('Our team is composed - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't12-our-team',
                    'section_number' => 2,
                    'images_count' => 12,
                    'tags' => ['header', 'our', 'team', 'text', 'styled text', 'image box'],
                ],
                't12-our-team-section-3' => [
                    'title' => esc_html__('We believe in the - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't12-our-team',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['hero', 'our', 'team', 'styled text', 'text', 'button'],
                ],
                't12-saas-startup-section-1' => [
                    'title' => esc_html__('Our CRM platform automates - Saas Startup', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't12-saas-startup',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['hero', 'saas', 'startup', 'text', 'styled text', 'button', 'image'],
                ],
                't12-saas-startup-section-2' => [
                    'title' => esc_html__('Make data-driven decisions with - Saas Startup', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't12-saas-startup',
                    'section_number' => 2,
                    'images_count' => 0,
                    'tags' => ['header', 'saas', 'startup', 'styled text', 'text'],
                ],
                't12-saas-startup-section-3' => [
                    'title' => esc_html__('Grow your e-commerce business - Saas Startup', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't12-saas-startup',
                    'section_number' => 3,
                    'images_count' => 10,
                    'tags' => ['hero', 'saas', 'startup', 'text', 'styled text', 'button', 'image', 'king addons auto scrolling text', 'icon list'],
                ],
                't12-saas-startup-section-4' => [
                    'title' => esc_html__('Supercharge your marketing efforts - Saas Startup', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't12-saas-startup',
                    'section_number' => 4,
                    'images_count' => 6,
                    'tags' => ['hero', 'saas', 'startup', 'text', 'styled text', 'image', 'image box', 'button'],
                ],
                't12-saas-startup-section-5' => [
                    'title' => esc_html__('Exploring the Latest Innovations - Saas Startup', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't12-saas-startup',
                    'section_number' => 5,
                    'images_count' => 0,
                    'tags' => ['header', 'saas', 'startup', 'text', 'styled text', 'king addons blog posts'],
                ],
                't12-saas-startup-section-6' => [
                    'title' => esc_html__('From inventory tracking to - Saas Startup', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't12-saas-startup',
                    'section_number' => 6,
                    'images_count' => 6,
                    'tags' => ['header', 'saas', 'startup', 'text', 'styled text', 'testimonial'],
                ],
                't12-saas-startup-section-7' => [
                    'title' => esc_html__('Our CRM platform automates - Saas Startup', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't12-saas-startup',
                    'section_number' => 7,
                    'images_count' => 2,
                    'tags' => ['hero', 'saas', 'startup', 'styled text', 'text', 'button'],
                ],
                't12-web-app-section-1' => [
                    'title' => esc_html__('Designed to simplify and - Web App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't12-web-app',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['hero', 'web', 'app', 'text', 'image', 'styled text', 'button'],
                ],
                't12-web-app-section-2' => [
                    'title' => esc_html__('Through innovative products, tools, - Web App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't12-web-app',
                    'section_number' => 2,
                    'images_count' => 12,
                    'tags' => ['header', 'web', 'app', 'text', 'image carousel', 'styled text', 'image'],
                ],
                't12-web-app-section-3' => [
                    'title' => esc_html__('Segment your audience, track - Web App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't12-web-app',
                    'section_number' => 3,
                    'images_count' => 3,
                    'tags' => ['hero', 'web', 'app', 'text', 'styled text', 'icon list', 'image', 'button'],
                ],
                't12-web-app-section-4' => [
                    'title' => esc_html__('View enhanced transactions in - Web App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't12-web-app',
                    'section_number' => 4,
                    'images_count' => 9,
                    'tags' => ['header', 'web', 'app', 'text', 'styled text', 'image box', 'image'],
                ],
                't12-web-app-section-5' => [
                    'title' => esc_html__('Master Your Finances with - Web App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't12-web-app',
                    'section_number' => 5,
                    'images_count' => 0,
                    'tags' => ['hero', 'web', 'app', 'text', 'styled text', 'divider', 'heading', 'button', 'icon list'],
                ],
                't12-web-app-section-6' => [
                    'title' => esc_html__('Your Popular Questions, - Web App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't12-web-app',
                    'section_number' => 6,
                    'images_count' => 0,
                    'tags' => ['header', 'web', 'app', 'text', 'styled text', 'accordion'],
                ],
                't12-web-app-section-7' => [
                    'title' => esc_html__('Designed to simplify and - Web App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't12-web-app',
                    'section_number' => 7,
                    'images_count' => 3,
                    'tags' => ['hero', 'web', 'app', 'text', 'image', 'styled text', 'button'],
                ],
                't13-about-us-section-1' => [
                    'title' => esc_html__(' Our skilled orthodontists - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-about-us',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['header', 'about', 'styled text', 'text', 'king addons video popup'],
                ],
                't13-about-us-section-2' => [
                    'title' => esc_html__('With our cutting-edge technology - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't13-about-us',
                    'section_number' => 2,
                    'images_count' => 2,
                    'tags' => ['hero', 'about', 'styled text', 'text', 'image', 'button'],
                ],
                't13-about-us-section-3' => [
                    'title' => esc_html__('At our clinic, we - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-about-us',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['header', 'about', 'styled text'],
                ],
                't13-about-us-section-4' => [
                    'title' => esc_html__('Our friendly and knowledgeable - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-about-us',
                    'section_number' => 4,
                    'images_count' => 5,
                    'tags' => ['header', 'about', 'styled text', 'text', 'king addons card carousel'],
                ],
                't13-about-us-section-5' => [
                    'title' => esc_html__('Popular Patient\'s Questions - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-about-us',
                    'section_number' => 5,
                    'images_count' => 0,
                    'tags' => ['header', 'about', 'styled text', 'accordion'],
                ],
                't13-about-us-section-6' => [
                    'title' => esc_html__('Follow our clinic on - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-about-us',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['header', 'about', 'styled text', 'text', 'social icons'],
                ],
                't13-contact-us-section-1' => [
                    'title' => esc_html__(' Our skilled orthodontists - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-contact-us',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['header', 'contact', 'styled text', 'text', 'image'],
                ],
                't13-contact-us-section-2' => [
                    'title' => esc_html__('We are happy to - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-contact-us',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['header', 'contact', 'styled text', 'shortcode', 'html', 'spacer', 'icon box'],
                ],
                't13-contact-us-section-3' => [
                    'title' => esc_html__('Nearest tube is Maida - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-contact-us',
                    'section_number' => 3,
                    'images_count' => 0,
                    'tags' => ['header', 'contact', 'styled text', 'google_maps', 'heading', 'text'],
                ],
                't13-contact-us-section-5' => [
                    'title' => esc_html__('Follow our clinic on - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-contact-us',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['header', 'contact', 'styled text', 'text', 'social icons'],
                ],
                't13-orthodontic-care-section-1' => [
                    'title' => esc_html__(' Our skilled orthodontists - Orthodontic Care', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't13-orthodontic-care',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['hero', 'orthodontic', 'care', 'styled text', 'text', 'button', 'text path', 'king addons video popup'],
                ],
                't13-orthodontic-care-section-2' => [
                    'title' => esc_html__('Orthodontic Care - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't13-orthodontic-care',
                    'section_number' => 2,
                    'images_count' => 8,
                    'tags' => ['general', 'orthodontic', 'care', 'king addons auto scrolling text'],
                ],
                't13-orthodontic-care-section-3' => [
                    'title' => esc_html__('With our cutting-edge technology - Orthodontic Care', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't13-orthodontic-care',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['hero', 'orthodontic', 'care', 'styled text', 'text', 'image', 'button'],
                ],
                't13-orthodontic-care-section-4' => [
                    'title' => esc_html__('Our skilled orthodontists use - Orthodontic Care', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't13-orthodontic-care',
                    'section_number' => 4,
                    'images_count' => 3,
                    'tags' => ['hero', 'orthodontic', 'care', 'styled text', 'text', 'button'],
                ],
                't13-orthodontic-care-section-5' => [
                    'title' => esc_html__('Our clinic offers a - Orthodontic Care', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-orthodontic-care',
                    'section_number' => 5,
                    'images_count' => 5,
                    'tags' => ['header', 'orthodontic', 'care', 'styled text', 'king addons card carousel'],
                ],
                't13-orthodontic-care-section-6' => [
                    'title' => esc_html__('With a focus on - Orthodontic Care', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't13-orthodontic-care',
                    'section_number' => 6,
                    'images_count' => 4,
                    'tags' => ['hero', 'orthodontic', 'care', 'styled text', 'text', 'button', 'image', 'divider', 'image box'],
                ],
                't13-orthodontic-care-section-7' => [
                    'title' => esc_html__('At our clinic, we - Orthodontic Care', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-orthodontic-care',
                    'section_number' => 7,
                    'images_count' => 2,
                    'tags' => ['header', 'orthodontic', 'care', 'styled text'],
                ],
                't13-orthodontic-care-section-8' => [
                    'title' => esc_html__('With a focus on - Orthodontic Care', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-orthodontic-care',
                    'section_number' => 8,
                    'images_count' => 5,
                    'tags' => ['header', 'orthodontic', 'care', 'styled text', 'text', 'king addons card carousel'],
                ],
                't13-orthodontic-care-section-9' => [
                    'title' => esc_html__('With a focus on - Orthodontic Care', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-orthodontic-care',
                    'section_number' => 9,
                    'images_count' => 0,
                    'tags' => ['header', 'orthodontic', 'care', 'styled text', 'text', 'king addons blog posts'],
                ],
                't13-orthodontic-care-section-11' => [
                    'title' => esc_html__('Follow our clinic on - Orthodontic Care', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-orthodontic-care',
                    'section_number' => 11,
                    'images_count' => 1,
                    'tags' => ['header', 'orthodontic', 'care', 'styled text', 'text', 'social icons'],
                ],
                't13-our-services-section-1' => [
                    'title' => esc_html__(' Our skilled orthodontists - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-our-services',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['header', 'our', 'services', 'styled text', 'text', 'image'],
                ],
                't13-our-services-section-2' => [
                    'title' => esc_html__('Our skilled orthodontists use - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't13-our-services',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['hero', 'our', 'services', 'styled text', 'text', 'button'],
                ],
                't13-our-services-section-3' => [
                    'title' => esc_html__('At our clinic, we - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-our-services',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['header', 'our', 'services', 'styled text'],
                ],
                't13-our-services-section-4' => [
                    'title' => esc_html__('Our clinic offers a - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-our-services',
                    'section_number' => 4,
                    'images_count' => 5,
                    'tags' => ['header', 'our', 'services', 'styled text', 'king addons card carousel'],
                ],
                't13-our-services-section-6' => [
                    'title' => esc_html__('Follow our clinic on - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-our-services',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['header', 'our', 'services', 'styled text', 'text', 'social icons'],
                ],
                't13-our-team-section-1' => [
                    'title' => esc_html__('At our clinic, we - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-our-team',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['header', 'our', 'team', 'styled text', 'text', 'image'],
                ],
                't13-our-team-section-2' => [
                    'title' => esc_html__('Pediatric Orthodontist
 - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-our-team',
                    'section_number' => 2,
                    'images_count' => 9,
                    'tags' => ['header', 'our', 'team', 'image', 'heading', 'social icons'],
                ],
                't13-our-team-section-4' => [
                    'title' => esc_html__('Follow our clinic on - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-our-team',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['header', 'our', 'team', 'styled text', 'text', 'social icons'],
                ],
                't13-perfect-smiles-section-1' => [
                    'title' => esc_html__('Our orthodontists are dedicated - Perfect Smiles', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't13-perfect-smiles',
                    'section_number' => 1,
                    'images_count' => 5,
                    'tags' => ['hero', 'perfect', 'smiles', 'image', 'text', 'button', 'styled text'],
                ],
                't13-perfect-smiles-section-2' => [
                    'title' => esc_html__('Our clinic offers a - Perfect Smiles', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-perfect-smiles',
                    'section_number' => 2,
                    'images_count' => 5,
                    'tags' => ['header', 'perfect', 'smiles', 'styled text', 'king addons card carousel'],
                ],
                't13-perfect-smiles-section-3' => [
                    'title' => esc_html__('With our cutting-edge technology - Perfect Smiles', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't13-perfect-smiles',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['hero', 'perfect', 'smiles', 'styled text', 'text', 'image', 'button'],
                ],
                't13-perfect-smiles-section-4' => [
                    'title' => esc_html__('At our clinic, we - Perfect Smiles', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-perfect-smiles',
                    'section_number' => 4,
                    'images_count' => 2,
                    'tags' => ['header', 'perfect', 'smiles', 'styled text'],
                ],
                't13-perfect-smiles-section-5' => [
                    'title' => esc_html__('Our skilled orthodontists use - Perfect Smiles', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't13-perfect-smiles',
                    'section_number' => 5,
                    'images_count' => 3,
                    'tags' => ['hero', 'perfect', 'smiles', 'styled text', 'text', 'button'],
                ],
                't13-perfect-smiles-section-6' => [
                    'title' => esc_html__('Our friendly and knowledgeable - Perfect Smiles', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-perfect-smiles',
                    'section_number' => 6,
                    'images_count' => 5,
                    'tags' => ['header', 'perfect', 'smiles', 'styled text', 'text', 'king addons card carousel'],
                ],
                't13-perfect-smiles-section-7' => [
                    'title' => esc_html__('Perfect Smiles - General Section 7', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't13-perfect-smiles',
                    'section_number' => 7,
                    'images_count' => 1,
                    'tags' => ['general', 'perfect', 'smiles', 'king addons video popup'],
                ],
                't13-perfect-smiles-section-9' => [
                    'title' => esc_html__('Follow our clinic on - Perfect Smiles', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-perfect-smiles',
                    'section_number' => 9,
                    'images_count' => 1,
                    'tags' => ['header', 'perfect', 'smiles', 'styled text', 'text', 'social icons'],
                ],
                't13-smile-brighter-section-1' => [
                    'title' => esc_html__('Advanced technology not only - Smile Brighter', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't13-smile-brighter',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['hero', 'smile', 'brighter', 'image', 'text path', 'styled text', 'text', 'button'],
                ],
                't13-smile-brighter-section-2' => [
                    'title' => esc_html__('Smile Brighter - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't13-smile-brighter',
                    'section_number' => 2,
                    'images_count' => 8,
                    'tags' => ['general', 'smile', 'brighter', 'king addons auto scrolling text'],
                ],
                't13-smile-brighter-section-3' => [
                    'title' => esc_html__('Our skilled orthodontists use - Smile Brighter', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't13-smile-brighter',
                    'section_number' => 3,
                    'images_count' => 3,
                    'tags' => ['hero', 'smile', 'brighter', 'styled text', 'text', 'button'],
                ],
                't13-smile-brighter-section-4' => [
                    'title' => esc_html__('Our clinic offers a - Smile Brighter', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-smile-brighter',
                    'section_number' => 4,
                    'images_count' => 5,
                    'tags' => ['header', 'smile', 'brighter', 'styled text', 'king addons card carousel'],
                ],
                't13-smile-brighter-section-5' => [
                    'title' => esc_html__('With our cutting-edge technology - Smile Brighter', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't13-smile-brighter',
                    'section_number' => 5,
                    'images_count' => 2,
                    'tags' => ['hero', 'smile', 'brighter', 'styled text', 'text', 'image', 'button'],
                ],
                't13-smile-brighter-section-6' => [
                    'title' => esc_html__('At our clinic, we - Smile Brighter', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-smile-brighter',
                    'section_number' => 6,
                    'images_count' => 2,
                    'tags' => ['header', 'smile', 'brighter', 'styled text'],
                ],
                't13-smile-brighter-section-7' => [
                    'title' => esc_html__('Our friendly and knowledgeable - Smile Brighter', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-smile-brighter',
                    'section_number' => 7,
                    'images_count' => 5,
                    'tags' => ['header', 'smile', 'brighter', 'styled text', 'text', 'king addons card carousel'],
                ],
                't13-smile-brighter-section-8' => [
                    'title' => esc_html__('Smile Brighter - General Section 8', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't13-smile-brighter',
                    'section_number' => 8,
                    'images_count' => 1,
                    'tags' => ['general', 'smile', 'brighter', 'king addons video popup'],
                ],
                't13-smile-brighter-section-9' => [
                    'title' => esc_html__('With a focus on - Smile Brighter', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-smile-brighter',
                    'section_number' => 9,
                    'images_count' => 5,
                    'tags' => ['header', 'smile', 'brighter', 'styled text', 'text', 'king addons card carousel'],
                ],
                't13-smile-brighter-section-12' => [
                    'title' => esc_html__('Follow our clinic on - Smile Brighter', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-smile-brighter',
                    'section_number' => 12,
                    'images_count' => 1,
                    'tags' => ['header', 'smile', 'brighter', 'styled text', 'text', 'social icons'],
                ],
                't13-smile-transformation-section-1' => [
                    'title' => esc_html__(' Our skilled orthodontists - Smile Transformation', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't13-smile-transformation',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['hero', 'smile', 'transformation', 'styled text', 'text', 'button', 'image', 'text path'],
                ],
                't13-smile-transformation-section-2' => [
                    'title' => esc_html__('Smile Transformation - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't13-smile-transformation',
                    'section_number' => 2,
                    'images_count' => 8,
                    'tags' => ['general', 'smile', 'transformation', 'king addons auto scrolling text'],
                ],
                't13-smile-transformation-section-3' => [
                    'title' => esc_html__('Our skilled orthodontists use - Smile Transformation', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't13-smile-transformation',
                    'section_number' => 3,
                    'images_count' => 3,
                    'tags' => ['hero', 'smile', 'transformation', 'styled text', 'text', 'button'],
                ],
                't13-smile-transformation-section-4' => [
                    'title' => esc_html__('Our clinic offers a - Smile Transformation', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-smile-transformation',
                    'section_number' => 4,
                    'images_count' => 5,
                    'tags' => ['header', 'smile', 'transformation', 'styled text', 'king addons card carousel'],
                ],
                't13-smile-transformation-section-5' => [
                    'title' => esc_html__('With our cutting-edge technology - Smile Transformation', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't13-smile-transformation',
                    'section_number' => 5,
                    'images_count' => 2,
                    'tags' => ['hero', 'smile', 'transformation', 'styled text', 'text', 'image', 'button'],
                ],
                't13-smile-transformation-section-6' => [
                    'title' => esc_html__('At our clinic, we - Smile Transformation', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-smile-transformation',
                    'section_number' => 6,
                    'images_count' => 2,
                    'tags' => ['header', 'smile', 'transformation', 'styled text'],
                ],
                't13-smile-transformation-section-7' => [
                    'title' => esc_html__('Our friendly and knowledgeable - Smile Transformation', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-smile-transformation',
                    'section_number' => 7,
                    'images_count' => 5,
                    'tags' => ['header', 'smile', 'transformation', 'styled text', 'text', 'king addons card carousel'],
                ],
                't13-smile-transformation-section-8' => [
                    'title' => esc_html__('Smile Transformation - General Section 8', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't13-smile-transformation',
                    'section_number' => 8,
                    'images_count' => 1,
                    'tags' => ['general', 'smile', 'transformation', 'king addons video popup'],
                ],
                't13-smile-transformation-section-9' => [
                    'title' => esc_html__('With a focus on - Smile Transformation', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-smile-transformation',
                    'section_number' => 9,
                    'images_count' => 5,
                    'tags' => ['header', 'smile', 'transformation', 'styled text', 'text', 'king addons card carousel'],
                ],
                't13-smile-transformation-section-10' => [
                    'title' => esc_html__('Follow our clinic on - Smile Transformation', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't13-smile-transformation',
                    'section_number' => 10,
                    'images_count' => 1,
                    'tags' => ['header', 'smile', 'transformation', 'styled text', 'text', 'social icons'],
                ],
                't14-about-us-section-1' => [
                    'title' => esc_html__('Integrity, Quality, Innovation,  - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-about-us',
                    'section_number' => 1,
                    'images_count' => 5,
                    'tags' => ['header', 'about', 'text', 'styled text'],
                ],
                't14-about-us-section-2' => [
                    'title' => esc_html__('Our team of skilled - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-about-us',
                    'section_number' => 2,
                    'images_count' => 7,
                    'tags' => ['header', 'about', 'text', 'styled text', 'image carousel'],
                ],
                't14-about-us-section-3' => [
                    'title' => esc_html__('We pride ourselves on - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-about-us',
                    'section_number' => 3,
                    'images_count' => 3,
                    'tags' => ['header', 'about', 'image', 'text', 'styled text'],
                ],
                't14-about-us-section-4' => [
                    'title' => esc_html__('With meticulous planning, expert - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-about-us',
                    'section_number' => 4,
                    'images_count' => 2,
                    'tags' => ['header', 'about', 'styled text'],
                ],
                't14-about-us-section-5' => [
                    'title' => esc_html__('Construction Insights - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-about-us',
                    'section_number' => 5,
                    'images_count' => 0,
                    'tags' => ['header', 'about', 'text', 'styled text', 'accordion'],
                ],
                't14-about-us-section-6' => [
                    'title' => esc_html__('We pride ourselves on - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't14-about-us',
                    'section_number' => 6,
                    'images_count' => 2,
                    'tags' => ['hero', 'about', 'styled text', 'text', 'button'],
                ],
                't14-blueprints-into-reality-section-1' => [
                    'title' => esc_html__('Our commitment to excellence - Blueprints Into Reality', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't14-blueprints-into-reality',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['hero', 'blueprints', 'into', 'reality', 'text', 'styled text', 'button', 'king addons video popup'],
                ],
                't14-blueprints-into-reality-section-2' => [
                    'title' => esc_html__('We pride ourselves on - Blueprints Into Reality', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-blueprints-into-reality',
                    'section_number' => 2,
                    'images_count' => 13,
                    'tags' => ['header', 'blueprints', 'into', 'reality', 'text', 'styled text', 'image box', 'king addons auto scrolling text', 'image'],
                ],
                't14-blueprints-into-reality-section-3' => [
                    'title' => esc_html__('With meticulous planning, expert - Blueprints Into Reality', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-blueprints-into-reality',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['header', 'blueprints', 'into', 'reality', 'styled text'],
                ],
                't14-blueprints-into-reality-section-4' => [
                    'title' => esc_html__('Construction Drawings - Blueprints Into Reality', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-blueprints-into-reality',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['header', 'blueprints', 'into', 'reality', 'text', 'styled text', 'king addons image hotspots', 'heading', 'toggle'],
                ],
                't14-blueprints-into-reality-section-5' => [
                    'title' => esc_html__('Our team of skilled - Blueprints Into Reality', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-blueprints-into-reality',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['header', 'blueprints', 'into', 'reality', 'text', 'styled text'],
                ],
                't14-blueprints-into-reality-section-6' => [
                    'title' => esc_html__('Our commitment to excellence - Blueprints Into Reality', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-blueprints-into-reality',
                    'section_number' => 6,
                    'images_count' => 19,
                    'tags' => ['header', 'blueprints', 'into', 'reality', 'king addons image grid', 'text', 'styled text', 'king addons card carousel', 'image carousel'],
                ],
                't14-blueprints-into-reality-section-7' => [
                    'title' => esc_html__('Innovative Construction - Blueprints Into Reality', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-blueprints-into-reality',
                    'section_number' => 7,
                    'images_count' => 0,
                    'tags' => ['header', 'blueprints', 'into', 'reality', 'text', 'styled text', 'king addons blog posts'],
                ],
                't14-blueprints-into-reality-section-8' => [
                    'title' => esc_html__('Trust us to bring - Blueprints Into Reality', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't14-blueprints-into-reality',
                    'section_number' => 8,
                    'images_count' => 2,
                    'tags' => ['hero', 'blueprints', 'into', 'reality', 'styled text', 'text', 'button'],
                ],
                't14-brighter-tomorrow-section-1' => [
                    'title' => esc_html__('Our commitment to excellence - Brighter Tomorrow', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't14-brighter-tomorrow',
                    'section_number' => 1,
                    'images_count' => 14,
                    'tags' => ['hero', 'brighter', 'tomorrow', 'text', 'styled text', 'image', 'text path', 'button', 'social icons', 'image carousel'],
                ],
                't14-brighter-tomorrow-section-2' => [
                    'title' => esc_html__('Our team of skilled - Brighter Tomorrow', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-brighter-tomorrow',
                    'section_number' => 2,
                    'images_count' => 7,
                    'tags' => ['header', 'brighter', 'tomorrow', 'text', 'styled text', 'image carousel'],
                ],
                't14-brighter-tomorrow-section-3' => [
                    'title' => esc_html__('We pride ourselves on - Brighter Tomorrow', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-brighter-tomorrow',
                    'section_number' => 3,
                    'images_count' => 13,
                    'tags' => ['header', 'brighter', 'tomorrow', 'image', 'text', 'styled text', 'king addons auto scrolling text', 'image box'],
                ],
                't14-brighter-tomorrow-section-4' => [
                    'title' => esc_html__('With meticulous planning, expert - Brighter Tomorrow', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-brighter-tomorrow',
                    'section_number' => 4,
                    'images_count' => 2,
                    'tags' => ['header', 'brighter', 'tomorrow', 'styled text'],
                ],
                't14-brighter-tomorrow-section-5' => [
                    'title' => esc_html__('Construction Drawings - Brighter Tomorrow', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-brighter-tomorrow',
                    'section_number' => 5,
                    'images_count' => 10,
                    'tags' => ['header', 'brighter', 'tomorrow', 'text', 'styled text', 'king addons image hotspots', 'heading', 'toggle', 'king addons image grid'],
                ],
                't14-brighter-tomorrow-section-6' => [
                    'title' => esc_html__('Our commitment to excellence - Brighter Tomorrow', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-brighter-tomorrow',
                    'section_number' => 6,
                    'images_count' => 4,
                    'tags' => ['header', 'brighter', 'tomorrow', 'text', 'styled text', 'king addons card carousel'],
                ],
                't14-brighter-tomorrow-section-7' => [
                    'title' => esc_html__('We pride ourselves on - Brighter Tomorrow', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't14-brighter-tomorrow',
                    'section_number' => 7,
                    'images_count' => 2,
                    'tags' => ['hero', 'brighter', 'tomorrow', 'styled text', 'text', 'button'],
                ],
                't14-building-dreams-section-1' => [
                    'title' => esc_html__('Trust us to bring - Building Dreams', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't14-building-dreams',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['hero', 'building', 'dreams', 'text', 'styled text', 'button', 'social icons', 'image'],
                ],
                't14-building-dreams-section-2' => [
                    'title' => esc_html__('Building Dreams - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't14-building-dreams',
                    'section_number' => 2,
                    'images_count' => 6,
                    'tags' => ['general', 'building', 'dreams', 'king addons auto scrolling text'],
                ],
                't14-building-dreams-section-3' => [
                    'title' => esc_html__('Our team of skilled - Building Dreams', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-building-dreams',
                    'section_number' => 3,
                    'images_count' => 7,
                    'tags' => ['header', 'building', 'dreams', 'text', 'styled text', 'image carousel'],
                ],
                't14-building-dreams-section-4' => [
                    'title' => esc_html__('Construction Drawings - Building Dreams', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-building-dreams',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['header', 'building', 'dreams', 'text', 'styled text', 'king addons image hotspots', 'heading', 'toggle'],
                ],
                't14-building-dreams-section-5' => [
                    'title' => esc_html__('With meticulous planning, expert - Building Dreams', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-building-dreams',
                    'section_number' => 5,
                    'images_count' => 2,
                    'tags' => ['header', 'building', 'dreams', 'styled text'],
                ],
                't14-building-dreams-section-6' => [
                    'title' => esc_html__('From residential homes to - Building Dreams', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-building-dreams',
                    'section_number' => 6,
                    'images_count' => 0,
                    'tags' => ['header', 'building', 'dreams', 'text', 'styled text'],
                ],
                't14-building-dreams-section-7' => [
                    'title' => esc_html__('Our commitment to excellence - Building Dreams', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-building-dreams',
                    'section_number' => 7,
                    'images_count' => 17,
                    'tags' => ['header', 'building', 'dreams', 'image box', 'king addons image grid', 'text', 'styled text', 'king addons card carousel'],
                ],
                't14-building-dreams-section-9' => [
                    'title' => esc_html__('We pride ourselves on - Building Dreams', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't14-building-dreams',
                    'section_number' => 9,
                    'images_count' => 2,
                    'tags' => ['hero', 'building', 'dreams', 'styled text', 'text', 'button'],
                ],
                't14-contact-us-section-1' => [
                    'title' => esc_html__('Where Your Dreams  - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-contact-us',
                    'section_number' => 1,
                    'images_count' => 5,
                    'tags' => ['header', 'contact', 'text', 'styled text'],
                ],
                't14-contact-us-section-2' => [
                    'title' => esc_html__('Write us a message - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-contact-us',
                    'section_number' => 2,
                    'images_count' => 5,
                    'tags' => ['header', 'contact', 'heading', 'shortcode', 'spacer'],
                ],
                't14-contact-us-section-3' => [
                    'title' => esc_html__('Contact Us - General Section 3', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't14-contact-us',
                    'section_number' => 3,
                    'images_count' => 0,
                    'tags' => ['general', 'contact', 'icon box'],
                ],
                't14-contact-us-section-4' => [
                    'title' => esc_html__('Our commitment to excellence - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-contact-us',
                    'section_number' => 4,
                    'images_count' => 0,
                    'tags' => ['header', 'contact', 'text', 'styled text', 'google_maps', 'king addons business hours'],
                ],
                't14-contact-us-section-6' => [
                    'title' => esc_html__('We pride ourselves on - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't14-contact-us',
                    'section_number' => 6,
                    'images_count' => 2,
                    'tags' => ['hero', 'contact', 'styled text', 'text', 'button'],
                ],
                't14-our-gallery-section-1' => [
                    'title' => esc_html__('Step into the Future - Our Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-our-gallery',
                    'section_number' => 1,
                    'images_count' => 5,
                    'tags' => ['header', 'our', 'gallery', 'text', 'styled text'],
                ],
                't14-our-gallery-section-2' => [
                    'title' => esc_html__('Our Gallery - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't14-our-gallery',
                    'section_number' => 2,
                    'images_count' => 25,
                    'tags' => ['general', 'our', 'gallery', 'king addons image grid'],
                ],
                't14-our-gallery-section-3' => [
                    'title' => esc_html__('We pride ourselves on - Our Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't14-our-gallery',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['hero', 'our', 'gallery', 'styled text', 'text', 'button'],
                ],
                't14-our-services-section-1' => [
                    'title' => esc_html__('Construction Expertise  - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-our-services',
                    'section_number' => 1,
                    'images_count' => 5,
                    'tags' => ['header', 'our', 'services', 'text', 'styled text'],
                ],
                't14-our-services-section-2' => [
                    'title' => esc_html__('From residential homes to - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-our-services',
                    'section_number' => 2,
                    'images_count' => 10,
                    'tags' => ['header', 'our', 'services', 'text', 'styled text', 'image box', 'king addons auto scrolling text'],
                ],
                't14-our-services-section-3' => [
                    'title' => esc_html__('With meticulous planning, expert - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-our-services',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['header', 'our', 'services', 'styled text'],
                ],
                't14-our-services-section-4' => [
                    'title' => esc_html__('Construction Drawings - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-our-services',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['header', 'our', 'services', 'text', 'styled text', 'king addons image hotspots', 'heading', 'toggle'],
                ],
                't14-our-services-section-5' => [
                    'title' => esc_html__('Our Services - General Section 5', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't14-our-services',
                    'section_number' => 5,
                    'images_count' => 9,
                    'tags' => ['general', 'our', 'services', 'king addons image grid'],
                ],
                't14-our-services-section-6' => [
                    'title' => esc_html__('We pride ourselves on - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't14-our-services',
                    'section_number' => 6,
                    'images_count' => 2,
                    'tags' => ['hero', 'our', 'services', 'styled text', 'text', 'button'],
                ],
                't14-transforming-spaces-section-1' => [
                    'title' => esc_html__('Our commitment to excellence - Transforming Spaces', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't14-transforming-spaces',
                    'section_number' => 1,
                    'images_count' => 6,
                    'tags' => ['hero', 'transforming', 'spaces', 'text', 'styled text', 'social icons', 'button'],
                ],
                't14-transforming-spaces-section-2' => [
                    'title' => esc_html__('We pride ourselves on - Transforming Spaces', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-transforming-spaces',
                    'section_number' => 2,
                    'images_count' => 13,
                    'tags' => ['header', 'transforming', 'spaces', 'text', 'styled text', 'image box', 'king addons auto scrolling text', 'image'],
                ],
                't14-transforming-spaces-section-3' => [
                    'title' => esc_html__('With meticulous planning, expert - Transforming Spaces', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-transforming-spaces',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['header', 'transforming', 'spaces', 'styled text'],
                ],
                't14-transforming-spaces-section-4' => [
                    'title' => esc_html__('Our team of skilled - Transforming Spaces', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-transforming-spaces',
                    'section_number' => 4,
                    'images_count' => 7,
                    'tags' => ['header', 'transforming', 'spaces', 'text', 'styled text', 'image carousel'],
                ],
                't14-transforming-spaces-section-5' => [
                    'title' => esc_html__('Our commitment to excellence - Transforming Spaces', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-transforming-spaces',
                    'section_number' => 5,
                    'images_count' => 4,
                    'tags' => ['header', 'transforming', 'spaces', 'text', 'styled text', 'king addons card carousel'],
                ],
                't14-transforming-spaces-section-6' => [
                    'title' => esc_html__('Construction Drawings - Transforming Spaces', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-transforming-spaces',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['header', 'transforming', 'spaces', 'text', 'styled text', 'king addons image hotspots', 'heading', 'toggle'],
                ],
                't14-transforming-spaces-section-7' => [
                    'title' => esc_html__('Innovative Construction - Transforming Spaces', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't14-transforming-spaces',
                    'section_number' => 7,
                    'images_count' => 0,
                    'tags' => ['header', 'transforming', 'spaces', 'text', 'styled text', 'king addons blog posts'],
                ],
                't14-transforming-spaces-section-8' => [
                    'title' => esc_html__('Trust us to bring - Transforming Spaces', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't14-transforming-spaces',
                    'section_number' => 8,
                    'images_count' => 1,
                    'tags' => ['hero', 'transforming', 'spaces', 'styled text', 'text', 'button'],
                ],
                't16-contact-us-section-1' => [
                    'title' => esc_html__('At our shelter charity, - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't16-contact-us',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['header', 'contact', 'text', 'spacer', 'heading', 'shortcode'],
                ],
                't16-contact-us-section-2' => [
                    'title' => esc_html__('Contact Us - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't16-contact-us',
                    'section_number' => 2,
                    'images_count' => 0,
                    'tags' => ['general', 'contact', 'icon box'],
                ],
                't16-contact-us-section-3' => [
                    'title' => esc_html__('With your support, we - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't16-contact-us',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['content', 'contact', 'text', 'google_maps'],
                ],
                't16-contact-us-section-4' => [
                    'title' => esc_html__('At our shelter charity, - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't16-contact-us',
                    'section_number' => 4,
                    'images_count' => 2,
                    'tags' => ['cta', 'contact', 'text', 'button'],
                ],
                't16-hope-for-paws-section-1' => [
                    'title' => esc_html__('At our shelter charity, - Hope For Paws', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't16-hope-for-paws',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['cta', 'hope', 'for', 'paws', 'text', 'button', 'image'],
                ],
                't16-hope-for-paws-section-2' => [
                    'title' => esc_html__('At our shelter charity, - Hope For Paws', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't16-hope-for-paws',
                    'section_number' => 2,
                    'images_count' => 6,
                    'tags' => ['content', 'hope', 'for', 'paws', 'text', 'image box', 'king addons video popup'],
                ],
                't16-hope-for-paws-section-3' => [
                    'title' => esc_html__('Together, we can make - Hope For Paws', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't16-hope-for-paws',
                    'section_number' => 3,
                    'images_count' => 4,
                    'tags' => ['cta', 'hope', 'for', 'paws', 'text', 'image', 'button'],
                ],
                't16-hope-for-paws-section-4' => [
                    'title' => esc_html__('Every animal deserves a - Hope For Paws', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't16-hope-for-paws',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['content', 'hope', 'for', 'paws', 'text'],
                ],
                't16-hope-for-paws-section-5' => [
                    'title' => esc_html__('With your support, we - Hope For Paws', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't16-hope-for-paws',
                    'section_number' => 5,
                    'images_count' => 3,
                    'tags' => ['content', 'hope', 'for', 'paws', 'image', 'text', 'icon list'],
                ],
                't16-hope-for-paws-section-6' => [
                    'title' => esc_html__('Our shelter charity is - Hope For Paws', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't16-hope-for-paws',
                    'section_number' => 6,
                    'images_count' => 6,
                    'tags' => ['content', 'hope', 'for', 'paws', 'text', 'image'],
                ],
                't16-hope-for-paws-section-7' => [
                    'title' => esc_html__('With your support, we - Hope For Paws', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't16-hope-for-paws',
                    'section_number' => 7,
                    'images_count' => 7,
                    'tags' => ['content', 'hope', 'for', 'paws', 'text', 'king addons card carousel', 'image'],
                ],
                't16-hope-for-paws-section-8' => [
                    'title' => esc_html__('At our shelter charity, - Hope For Paws', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't16-hope-for-paws',
                    'section_number' => 8,
                    'images_count' => 2,
                    'tags' => ['cta', 'hope', 'for', 'paws', 'text', 'button'],
                ],
                't16-our-gallery-section-1' => [
                    'title' => esc_html__('At our shelter charity, - Our Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't16-our-gallery',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['content', 'our', 'gallery', 'text'],
                ],
                't16-our-gallery-section-2' => [
                    'title' => esc_html__('Our Gallery - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't16-our-gallery',
                    'section_number' => 2,
                    'images_count' => 11,
                    'tags' => ['general', 'our', 'gallery', 'king addons image grid'],
                ],
                't16-our-gallery-section-3' => [
                    'title' => esc_html__('At our shelter charity, - Our Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't16-our-gallery',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['cta', 'our', 'gallery', 'text', 'button'],
                ],
                't16-our-services-section-1' => [
                    'title' => esc_html__('At our shelter charity, - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't16-our-services',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['content', 'our', 'services', 'text'],
                ],
                't16-our-services-section-2' => [
                    'title' => esc_html__('Our Services - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't16-our-services',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['general', 'our', 'services', 'king addons video popup'],
                ],
                't16-our-services-section-3' => [
                    'title' => esc_html__('Together, we can make - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't16-our-services',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['cta', 'our', 'services', 'image', 'counter', 'text', 'button'],
                ],
                't16-our-services-section-4' => [
                    'title' => esc_html__('Our shelter charity is - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't16-our-services',
                    'section_number' => 4,
                    'images_count' => 6,
                    'tags' => ['content', 'our', 'services', 'text', 'image'],
                ],
                't16-our-services-section-5' => [
                    'title' => esc_html__('With your support, we - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't16-our-services',
                    'section_number' => 5,
                    'images_count' => 3,
                    'tags' => ['content', 'our', 'services', 'image', 'text', 'icon list'],
                ],
                't16-our-services-section-6' => [
                    'title' => esc_html__('At our shelter charity, - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't16-our-services',
                    'section_number' => 6,
                    'images_count' => 2,
                    'tags' => ['cta', 'our', 'services', 'text', 'button'],
                ],
                't16-our-team-section-1' => [
                    'title' => esc_html__('At our shelter charity, - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't16-our-team',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['content', 'our', 'team', 'text'],
                ],
                't16-our-team-section-2' => [
                    'title' => esc_html__(' Veterinary Technician - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't16-our-team',
                    'section_number' => 2,
                    'images_count' => 11,
                    'tags' => ['header', 'our', 'team', 'image', 'heading', 'social icons'],
                ],
                't16-our-team-section-3' => [
                    'title' => esc_html__('At our shelter charity, - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't16-our-team',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['cta', 'our', 'team', 'text', 'button'],
                ],
                't16-rescue-rehabilitate-rehome-section-1' => [
                    'title' => esc_html__('At our shelter charity, - Rescue Rehabilitate Rehome', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't16-rescue-rehabilitate-rehome',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['cta', 'rescue', 'rehabilitate', 'rehome', 'text', 'button', 'image'],
                ],
                't16-rescue-rehabilitate-rehome-section-2' => [
                    'title' => esc_html__('Together, we can make - Rescue Rehabilitate Rehome', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't16-rescue-rehabilitate-rehome',
                    'section_number' => 2,
                    'images_count' => 4,
                    'tags' => ['cta', 'rescue', 'rehabilitate', 'rehome', 'text', 'image', 'button'],
                ],
                't16-rescue-rehabilitate-rehome-section-3' => [
                    'title' => esc_html__('Our shelter charity is - Rescue Rehabilitate Rehome', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't16-rescue-rehabilitate-rehome',
                    'section_number' => 3,
                    'images_count' => 6,
                    'tags' => ['content', 'rescue', 'rehabilitate', 'rehome', 'text', 'image'],
                ],
                't16-rescue-rehabilitate-rehome-section-4' => [
                    'title' => esc_html__('With your support, we - Rescue Rehabilitate Rehome', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't16-rescue-rehabilitate-rehome',
                    'section_number' => 4,
                    'images_count' => 3,
                    'tags' => ['content', 'rescue', 'rehabilitate', 'rehome', 'image', 'text', 'icon list'],
                ],
                't16-rescue-rehabilitate-rehome-section-5' => [
                    'title' => esc_html__('Every animal deserves a - Rescue Rehabilitate Rehome', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't16-rescue-rehabilitate-rehome',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['content', 'rescue', 'rehabilitate', 'rehome', 'text'],
                ],
                't16-rescue-rehabilitate-rehome-section-6' => [
                    'title' => esc_html__('At our shelter charity, - Rescue Rehabilitate Rehome', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't16-rescue-rehabilitate-rehome',
                    'section_number' => 6,
                    'images_count' => 6,
                    'tags' => ['content', 'rescue', 'rehabilitate', 'rehome', 'text', 'image box', 'king addons video popup'],
                ],
                't16-rescue-rehabilitate-rehome-section-7' => [
                    'title' => esc_html__('With your support, we - Rescue Rehabilitate Rehome', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't16-rescue-rehabilitate-rehome',
                    'section_number' => 7,
                    'images_count' => 7,
                    'tags' => ['content', 'rescue', 'rehabilitate', 'rehome', 'text', 'king addons card carousel', 'image'],
                ],
                't16-rescue-rehabilitate-rehome-section-8' => [
                    'title' => esc_html__('At our shelter charity, - Rescue Rehabilitate Rehome', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't16-rescue-rehabilitate-rehome',
                    'section_number' => 8,
                    'images_count' => 2,
                    'tags' => ['cta', 'rescue', 'rehabilitate', 'rehome', 'text', 'button'],
                ],
                't16-tails-of-hope-section-1' => [
                    'title' => esc_html__(' Every animal deserves - Tails Of Hope', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't16-tails-of-hope',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['cta', 'tails', 'hope', 'text', 'button', 'text path', 'image'],
                ],
                't16-tails-of-hope-section-2' => [
                    'title' => esc_html__('Tails Of Hope - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't16-tails-of-hope',
                    'section_number' => 2,
                    'images_count' => 9,
                    'tags' => ['general', 'tails', 'hope', 'image carousel'],
                ],
                't16-tails-of-hope-section-3' => [
                    'title' => esc_html__('Together, we can make - Tails Of Hope', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't16-tails-of-hope',
                    'section_number' => 3,
                    'images_count' => 4,
                    'tags' => ['cta', 'tails', 'hope', 'text', 'image', 'button'],
                ],
                't16-tails-of-hope-section-4' => [
                    'title' => esc_html__('At our shelter charity, - Tails Of Hope', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't16-tails-of-hope',
                    'section_number' => 4,
                    'images_count' => 6,
                    'tags' => ['content', 'tails', 'hope', 'text', 'image box', 'king addons video popup'],
                ],
                't16-tails-of-hope-section-5' => [
                    'title' => esc_html__('Every animal deserves a - Tails Of Hope', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't16-tails-of-hope',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['content', 'tails', 'hope', 'text'],
                ],
                't16-tails-of-hope-section-6' => [
                    'title' => esc_html__('With your support, we - Tails Of Hope', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't16-tails-of-hope',
                    'section_number' => 6,
                    'images_count' => 3,
                    'tags' => ['content', 'tails', 'hope', 'image', 'text', 'icon list'],
                ],
                't16-tails-of-hope-section-7' => [
                    'title' => esc_html__('Our shelter charity is - Tails Of Hope', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't16-tails-of-hope',
                    'section_number' => 7,
                    'images_count' => 6,
                    'tags' => ['content', 'tails', 'hope', 'text', 'image'],
                ],
                't16-tails-of-hope-section-8' => [
                    'title' => esc_html__('With your support, we - Tails Of Hope', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't16-tails-of-hope',
                    'section_number' => 8,
                    'images_count' => 7,
                    'tags' => ['content', 'tails', 'hope', 'text', 'king addons card carousel', 'image'],
                ],
                't16-tails-of-hope-section-9' => [
                    'title' => esc_html__('At our shelter charity, - Tails Of Hope', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't16-tails-of-hope',
                    'section_number' => 9,
                    'images_count' => 2,
                    'tags' => ['cta', 'tails', 'hope', 'text', 'button'],
                ],
                't16-wagging-tails-happy-hearts-section-1' => [
                    'title' => esc_html__('Every animal deserves a - Wagging Tails Happy Hearts', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't16-wagging-tails-happy-hearts',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['cta', 'wagging', 'tails', 'happy', 'hearts', 'text', 'button'],
                ],
                't16-wagging-tails-happy-hearts-section-2' => [
                    'title' => esc_html__('Wagging Tails Happy Hearts - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't16-wagging-tails-happy-hearts',
                    'section_number' => 2,
                    'images_count' => 9,
                    'tags' => ['general', 'wagging', 'tails', 'happy', 'hearts', 'image carousel'],
                ],
                't16-wagging-tails-happy-hearts-section-3' => [
                    'title' => esc_html__('With your support, we - Wagging Tails Happy Hearts', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't16-wagging-tails-happy-hearts',
                    'section_number' => 3,
                    'images_count' => 3,
                    'tags' => ['content', 'wagging', 'tails', 'happy', 'hearts', 'image', 'text', 'icon list'],
                ],
                't16-wagging-tails-happy-hearts-section-4' => [
                    'title' => esc_html__('Our shelter charity is - Wagging Tails Happy Hearts', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't16-wagging-tails-happy-hearts',
                    'section_number' => 4,
                    'images_count' => 6,
                    'tags' => ['content', 'wagging', 'tails', 'happy', 'hearts', 'text', 'image'],
                ],
                't16-wagging-tails-happy-hearts-section-5' => [
                    'title' => esc_html__('Together, we can make - Wagging Tails Happy Hearts', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't16-wagging-tails-happy-hearts',
                    'section_number' => 5,
                    'images_count' => 4,
                    'tags' => ['cta', 'wagging', 'tails', 'happy', 'hearts', 'text', 'image', 'button'],
                ],
                't16-wagging-tails-happy-hearts-section-6' => [
                    'title' => esc_html__('Every animal deserves a - Wagging Tails Happy Hearts', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't16-wagging-tails-happy-hearts',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['content', 'wagging', 'tails', 'happy', 'hearts', 'text'],
                ],
                't16-wagging-tails-happy-hearts-section-7' => [
                    'title' => esc_html__('At our shelter charity, - Wagging Tails Happy Hearts', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't16-wagging-tails-happy-hearts',
                    'section_number' => 7,
                    'images_count' => 6,
                    'tags' => ['content', 'wagging', 'tails', 'happy', 'hearts', 'text', 'image box', 'king addons video popup'],
                ],
                't16-wagging-tails-happy-hearts-section-8' => [
                    'title' => esc_html__('With your support, we - Wagging Tails Happy Hearts', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't16-wagging-tails-happy-hearts',
                    'section_number' => 8,
                    'images_count' => 7,
                    'tags' => ['content', 'wagging', 'tails', 'happy', 'hearts', 'text', 'king addons card carousel', 'image'],
                ],
                't16-wagging-tails-happy-hearts-section-9' => [
                    'title' => esc_html__('At our shelter charity, - Wagging Tails Happy Hearts', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't16-wagging-tails-happy-hearts',
                    'section_number' => 9,
                    'images_count' => 2,
                    'tags' => ['cta', 'wagging', 'tails', 'happy', 'hearts', 'text', 'button'],
                ],
                't17-about-us-section-1' => [
                    'title' => esc_html__('Order your favorite farm-fresh - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't17-about-us',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['content', 'about', 'text'],
                ],
                't17-about-us-section-2' => [
                    'title' => esc_html__('About Us - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't17-about-us',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['general', 'about', 'king addons video popup'],
                ],
                't17-about-us-section-3' => [
                    'title' => esc_html__('Capturing a significant market - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't17-about-us',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['header', 'about', 'text', 'counter', 'heading'],
                ],
                't17-about-us-section-4' => [
                    'title' => esc_html__('From seed to harvest, - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't17-about-us',
                    'section_number' => 4,
                    'images_count' => 4,
                    'tags' => ['cta', 'about', 'image', 'text', 'button'],
                ],
                't17-about-us-section-5' => [
                    'title' => esc_html__('From seed to harvest, - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't17-about-us',
                    'section_number' => 5,
                    'images_count' => 3,
                    'tags' => ['cta', 'about', 'image', 'counter', 'text', 'button'],
                ],
                't17-about-us-section-6' => [
                    'title' => esc_html__('Whether you\'re a restaurant - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't17-about-us',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['cta', 'about', 'text', 'button'],
                ],
                't17-contact-us-section-1' => [
                    'title' => esc_html__('Order your favorite farm-fresh - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't17-contact-us',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['header', 'contact', 'text', 'spacer', 'heading', 'shortcode'],
                ],
                't17-contact-us-section-2' => [
                    'title' => esc_html__('Contact Us - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't17-contact-us',
                    'section_number' => 2,
                    'images_count' => 0,
                    'tags' => ['general', 'contact', 'icon box'],
                ],
                't17-contact-us-section-3' => [
                    'title' => esc_html__('Whether you\'re a seasoned - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't17-contact-us',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['content', 'contact', 'text', 'google_maps'],
                ],
                't17-contact-us-section-4' => [
                    'title' => esc_html__('Whether you\'re a restaurant - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't17-contact-us',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['cta', 'contact', 'text', 'button'],
                ],
                't17-enjoy-the-freshness-section-1' => [
                    'title' => esc_html__('In today\'s environmentally conscious - Enjoy The Freshness', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't17-enjoy-the-freshness',
                    'section_number' => 1,
                    'images_count' => 6,
                    'tags' => ['content', 'enjoy', 'the', 'freshness', 'text', 'image', 'text path', 'king addons video popup', 'icon box'],
                ],
                't17-enjoy-the-freshness-section-2' => [
                    'title' => esc_html__('Capturing a significant market - Enjoy The Freshness', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't17-enjoy-the-freshness',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['header', 'enjoy', 'the', 'freshness', 'text', 'counter', 'heading'],
                ],
                't17-enjoy-the-freshness-section-3' => [
                    'title' => esc_html__('Share the story of - Enjoy The Freshness', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't17-enjoy-the-freshness',
                    'section_number' => 3,
                    'images_count' => 4,
                    'tags' => ['content', 'enjoy', 'the', 'freshness', 'text', 'image'],
                ],
                't17-enjoy-the-freshness-section-4' => [
                    'title' => esc_html__('Share the story of - Enjoy The Freshness', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't17-enjoy-the-freshness',
                    'section_number' => 4,
                    'images_count' => 4,
                    'tags' => ['content', 'enjoy', 'the', 'freshness', 'text', 'image box'],
                ],
                't17-enjoy-the-freshness-section-5' => [
                    'title' => esc_html__('From seed to harvest, - Enjoy The Freshness', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't17-enjoy-the-freshness',
                    'section_number' => 5,
                    'images_count' => 4,
                    'tags' => ['cta', 'enjoy', 'the', 'freshness', 'image', 'text', 'button'],
                ],
                't17-enjoy-the-freshness-section-6' => [
                    'title' => esc_html__('From seed to harvest, - Enjoy The Freshness', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't17-enjoy-the-freshness',
                    'section_number' => 6,
                    'images_count' => 3,
                    'tags' => ['cta', 'enjoy', 'the', 'freshness', 'image', 'counter', 'text', 'button'],
                ],
                't17-enjoy-the-freshness-section-7' => [
                    'title' => esc_html__('We\'re dedicated to serving - Enjoy The Freshness', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't17-enjoy-the-freshness',
                    'section_number' => 7,
                    'images_count' => 1,
                    'tags' => ['content', 'enjoy', 'the', 'freshness', 'text'],
                ],
                't17-enjoy-the-freshness-section-8' => [
                    'title' => esc_html__('The Organic Edge: Marketing - Enjoy The Freshness', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't17-enjoy-the-freshness',
                    'section_number' => 8,
                    'images_count' => 2,
                    'tags' => ['content', 'enjoy', 'the', 'freshness', 'text', 'king addons blog posts'],
                ],
                't17-enjoy-the-freshness-section-9' => [
                    'title' => esc_html__('Whether you\'re a restaurant - Enjoy The Freshness', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't17-enjoy-the-freshness',
                    'section_number' => 9,
                    'images_count' => 1,
                    'tags' => ['cta', 'enjoy', 'the', 'freshness', 'text', 'button'],
                ],
                't17-farm-fresh-delights-section-1' => [
                    'title' => esc_html__('Explore the Vibrant Colors - Farm Fresh Delights', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't17-farm-fresh-delights',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['cta', 'farm', 'fresh', 'delights', 'text', 'button', 'king addons video popup'],
                ],
                't17-farm-fresh-delights-section-2' => [
                    'title' => esc_html__('Share the story of - Farm Fresh Delights', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't17-farm-fresh-delights',
                    'section_number' => 2,
                    'images_count' => 4,
                    'tags' => ['content', 'farm', 'fresh', 'delights', 'text', 'image box'],
                ],
                't17-farm-fresh-delights-section-3' => [
                    'title' => esc_html__('Share the story of - Farm Fresh Delights', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't17-farm-fresh-delights',
                    'section_number' => 3,
                    'images_count' => 4,
                    'tags' => ['content', 'farm', 'fresh', 'delights', 'text', 'image'],
                ],
                't17-farm-fresh-delights-section-4' => [
                    'title' => esc_html__('From seed to harvest, - Farm Fresh Delights', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't17-farm-fresh-delights',
                    'section_number' => 4,
                    'images_count' => 3,
                    'tags' => ['cta', 'farm', 'fresh', 'delights', 'image', 'counter', 'text', 'button'],
                ],
                't17-farm-fresh-delights-section-5' => [
                    'title' => esc_html__('From seed to harvest, - Farm Fresh Delights', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't17-farm-fresh-delights',
                    'section_number' => 5,
                    'images_count' => 4,
                    'tags' => ['cta', 'farm', 'fresh', 'delights', 'image', 'text', 'button'],
                ],
                't17-farm-fresh-delights-section-6' => [
                    'title' => esc_html__('We\'re dedicated to serving - Farm Fresh Delights', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't17-farm-fresh-delights',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['content', 'farm', 'fresh', 'delights', 'text'],
                ],
                't17-farm-fresh-delights-section-7' => [
                    'title' => esc_html__('Capturing a significant market - Farm Fresh Delights', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't17-farm-fresh-delights',
                    'section_number' => 7,
                    'images_count' => 1,
                    'tags' => ['header', 'farm', 'fresh', 'delights', 'text', 'counter', 'heading'],
                ],
                't17-farm-fresh-delights-section-8' => [
                    'title' => esc_html__('The Organic Edge: Marketing - Farm Fresh Delights', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't17-farm-fresh-delights',
                    'section_number' => 8,
                    'images_count' => 2,
                    'tags' => ['content', 'farm', 'fresh', 'delights', 'text', 'king addons blog posts'],
                ],
                't17-farm-fresh-delights-section-9' => [
                    'title' => esc_html__('Your Source for Wholesome, - Farm Fresh Delights', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't17-farm-fresh-delights',
                    'section_number' => 9,
                    'images_count' => 3,
                    'tags' => ['cta', 'farm', 'fresh', 'delights', 'image', 'text', 'toggle', 'button'],
                ],
                't17-farm-fresh-delights-section-10' => [
                    'title' => esc_html__('Whether you\'re a restaurant - Farm Fresh Delights', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't17-farm-fresh-delights',
                    'section_number' => 10,
                    'images_count' => 1,
                    'tags' => ['cta', 'farm', 'fresh', 'delights', 'text', 'button'],
                ],
                't17-innovations-in-agriculture-section-1' => [
                    'title' => esc_html__('Order your favorite farm-fresh - Innovations In Agriculture', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't17-innovations-in-agriculture',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['cta', 'innovations', 'agriculture', 'text', 'button'],
                ],
                't17-innovations-in-agriculture-section-2' => [
                    'title' => esc_html__('From seed to harvest, - Innovations In Agriculture', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't17-innovations-in-agriculture',
                    'section_number' => 2,
                    'images_count' => 4,
                    'tags' => ['cta', 'innovations', 'agriculture', 'image', 'text', 'button'],
                ],
                't17-innovations-in-agriculture-section-3' => [
                    'title' => esc_html__('Share the story of - Innovations In Agriculture', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't17-innovations-in-agriculture',
                    'section_number' => 3,
                    'images_count' => 4,
                    'tags' => ['content', 'innovations', 'agriculture', 'text', 'image box'],
                ],
                't17-innovations-in-agriculture-section-4' => [
                    'title' => esc_html__('We\'re dedicated to serving - Innovations In Agriculture', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't17-innovations-in-agriculture',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['content', 'innovations', 'agriculture', 'text'],
                ],
                't17-innovations-in-agriculture-section-5' => [
                    'title' => esc_html__('Share the story of - Innovations In Agriculture', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't17-innovations-in-agriculture',
                    'section_number' => 5,
                    'images_count' => 4,
                    'tags' => ['content', 'innovations', 'agriculture', 'text', 'image'],
                ],
                't17-innovations-in-agriculture-section-6' => [
                    'title' => esc_html__('Capturing a significant market - Innovations In Agriculture', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't17-innovations-in-agriculture',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['header', 'innovations', 'agriculture', 'text', 'counter', 'heading'],
                ],
                't17-innovations-in-agriculture-section-7' => [
                    'title' => esc_html__('The Organic Edge: Marketing - Innovations In Agriculture', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't17-innovations-in-agriculture',
                    'section_number' => 7,
                    'images_count' => 2,
                    'tags' => ['content', 'innovations', 'agriculture', 'text', 'king addons blog posts'],
                ],
                't17-innovations-in-agriculture-section-8' => [
                    'title' => esc_html__('Your Source for Wholesome, - Innovations In Agriculture', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't17-innovations-in-agriculture',
                    'section_number' => 8,
                    'images_count' => 3,
                    'tags' => ['cta', 'innovations', 'agriculture', 'image', 'text', 'toggle', 'button'],
                ],
                't17-innovations-in-agriculture-section-9' => [
                    'title' => esc_html__('Whether you\'re a restaurant - Innovations In Agriculture', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't17-innovations-in-agriculture',
                    'section_number' => 9,
                    'images_count' => 3,
                    'tags' => ['cta', 'innovations', 'agriculture', 'text', 'button'],
                ],
                't17-our-gallery-section-1' => [
                    'title' => esc_html__('Order your favorite farm-fresh - Our Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't17-our-gallery',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['content', 'our', 'gallery', 'text'],
                ],
                't17-our-gallery-section-2' => [
                    'title' => esc_html__('Our Gallery - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't17-our-gallery',
                    'section_number' => 2,
                    'images_count' => 8,
                    'tags' => ['general', 'our', 'gallery', 'king addons image grid'],
                ],
                't17-our-gallery-section-3' => [
                    'title' => esc_html__('Whether you\'re a restaurant - Our Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't17-our-gallery',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['cta', 'our', 'gallery', 'text', 'button'],
                ],
                't17-our-services-section-1' => [
                    'title' => esc_html__('Order your favorite farm-fresh - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't17-our-services',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['content', 'our', 'services', 'text'],
                ],
                't17-our-services-section-2' => [
                    'title' => esc_html__('Our Services - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't17-our-services',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['general', 'our', 'services', 'king addons video popup'],
                ],
                't17-our-services-section-3' => [
                    'title' => esc_html__('Share the story of - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't17-our-services',
                    'section_number' => 3,
                    'images_count' => 4,
                    'tags' => ['content', 'our', 'services', 'text', 'image box'],
                ],
                't17-our-services-section-4' => [
                    'title' => esc_html__('Share the story of - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't17-our-services',
                    'section_number' => 4,
                    'images_count' => 4,
                    'tags' => ['content', 'our', 'services', 'text', 'image'],
                ],
                't17-our-services-section-5' => [
                    'title' => esc_html__('Whether you\'re a restaurant - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't17-our-services',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['cta', 'our', 'services', 'text', 'button'],
                ],
                't17-the-taste-of-tradition-section-1' => [
                    'title' => esc_html__('Order your favorite farm-fresh - The Taste Of Tradition', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't17-the-taste-of-tradition',
                    'section_number' => 1,
                    'images_count' => 4,
                    'tags' => ['cta', 'the', 'taste', 'tradition', 'text', 'button', 'image', 'text path'],
                ],
                't17-the-taste-of-tradition-section-2' => [
                    'title' => esc_html__('Share the story of - The Taste Of Tradition', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't17-the-taste-of-tradition',
                    'section_number' => 2,
                    'images_count' => 4,
                    'tags' => ['content', 'the', 'taste', 'tradition', 'text', 'image'],
                ],
                't17-the-taste-of-tradition-section-3' => [
                    'title' => esc_html__('Share the story of - The Taste Of Tradition', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't17-the-taste-of-tradition',
                    'section_number' => 3,
                    'images_count' => 4,
                    'tags' => ['content', 'the', 'taste', 'tradition', 'text', 'image box'],
                ],
                't17-the-taste-of-tradition-section-4' => [
                    'title' => esc_html__('From seed to harvest, - The Taste Of Tradition', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't17-the-taste-of-tradition',
                    'section_number' => 4,
                    'images_count' => 4,
                    'tags' => ['cta', 'the', 'taste', 'tradition', 'image', 'text', 'button'],
                ],
                't17-the-taste-of-tradition-section-5' => [
                    'title' => esc_html__('We\'re dedicated to serving - The Taste Of Tradition', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't17-the-taste-of-tradition',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['content', 'the', 'taste', 'tradition', 'text'],
                ],
                't17-the-taste-of-tradition-section-6' => [
                    'title' => esc_html__('Capturing a significant market - The Taste Of Tradition', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't17-the-taste-of-tradition',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['header', 'the', 'taste', 'tradition', 'text', 'counter', 'heading'],
                ],
                't17-the-taste-of-tradition-section-7' => [
                    'title' => esc_html__('The Organic Edge: Marketing - The Taste Of Tradition', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't17-the-taste-of-tradition',
                    'section_number' => 7,
                    'images_count' => 2,
                    'tags' => ['content', 'the', 'taste', 'tradition', 'text', 'king addons blog posts'],
                ],
                't17-the-taste-of-tradition-section-8' => [
                    'title' => esc_html__('Your Source for Wholesome, - The Taste Of Tradition', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't17-the-taste-of-tradition',
                    'section_number' => 8,
                    'images_count' => 3,
                    'tags' => ['cta', 'the', 'taste', 'tradition', 'image', 'text', 'toggle', 'button'],
                ],
                't17-the-taste-of-tradition-section-9' => [
                    'title' => esc_html__('Whether you\'re a restaurant - The Taste Of Tradition', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't17-the-taste-of-tradition',
                    'section_number' => 9,
                    'images_count' => 3,
                    'tags' => ['cta', 'the', 'taste', 'tradition', 'text', 'button'],
                ],
                't18-about-us-section-1' => [
                    'title' => esc_html__('Weaving Dreams: Quality Textiles - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't18-about-us',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['content', 'about', 'text'],
                ],
                't18-about-us-section-2' => [
                    'title' => esc_html__('About Us - Gallery Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'galleries',
                    'section_type' => 'gallery',
                    'parent_template' => 't18-about-us',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['gallery', 'about', 'image'],
                ],
                't18-about-us-section-3' => [
                    'title' => esc_html__('Our eco-friendly practices, responsible - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't18-about-us',
                    'section_number' => 3,
                    'images_count' => 4,
                    'tags' => ['cta', 'about', 'text', 'image', 'button'],
                ],
                't18-about-us-section-4' => [
                    'title' => esc_html__('Our eco-friendly practices, responsible - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't18-about-us',
                    'section_number' => 4,
                    'images_count' => 7,
                    'tags' => ['content', 'about', 'text', 'image'],
                ],
                't18-about-us-section-5' => [
                    'title' => esc_html__('Whether you\'re a designer - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't18-about-us',
                    'section_number' => 5,
                    'images_count' => 3,
                    'tags' => ['cta', 'about', 'image', 'counter', 'text', 'button'],
                ],
                't18-about-us-section-6' => [
                    'title' => esc_html__('Whether you\'re a designer - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't18-about-us',
                    'section_number' => 6,
                    'images_count' => 2,
                    'tags' => ['cta', 'about', 'text', 'button'],
                ],
                't18-contact-us-section-1' => [
                    'title' => esc_html__('Your One-Stop Manufacturing Partner - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't18-contact-us',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['content', 'contact', 'text', 'spacer', 'shortcode'],
                ],
                't18-contact-us-section-2' => [
                    'title' => esc_html__('Contact Us - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't18-contact-us',
                    'section_number' => 2,
                    'images_count' => 0,
                    'tags' => ['general', 'contact', 'icon box'],
                ],
                't18-contact-us-section-3' => [
                    'title' => esc_html__('From luxurious silks to - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't18-contact-us',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['content', 'contact', 'text', 'google_maps'],
                ],
                't18-contact-us-section-4' => [
                    'title' => esc_html__('We believe in creating - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't18-contact-us',
                    'section_number' => 4,
                    'images_count' => 3,
                    'tags' => ['content', 'contact', 'text', 'accordion', 'image'],
                ],
                't18-contact-us-section-5' => [
                    'title' => esc_html__('Whether you\'re a designer - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't18-contact-us',
                    'section_number' => 5,
                    'images_count' => 2,
                    'tags' => ['cta', 'contact', 'text', 'button'],
                ],
                't18-masters-of-textile-section-1' => [
                    'title' => esc_html__(' Whether you\'re a - Masters Of Textile', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't18-masters-of-textile',
                    'section_number' => 1,
                    'images_count' => 6,
                    'tags' => ['cta', 'masters', 'textile', 'divider', 'text', 'image', 'text path', 'button'],
                ],
                't18-masters-of-textile-section-2' => [
                    'title' => esc_html__('Our eco-friendly practices, responsible - Masters Of Textile', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't18-masters-of-textile',
                    'section_number' => 2,
                    'images_count' => 4,
                    'tags' => ['cta', 'masters', 'textile', 'text', 'image', 'button'],
                ],
                't18-masters-of-textile-section-3' => [
                    'title' => esc_html__('Whether you\'re a designer - Masters Of Textile', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't18-masters-of-textile',
                    'section_number' => 3,
                    'images_count' => 8,
                    'tags' => ['content', 'masters', 'textile', 'text', 'image box', 'king addons auto scrolling text'],
                ],
                't18-masters-of-textile-section-4' => [
                    'title' => esc_html__('Whether you\'re a designer - Masters Of Textile', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't18-masters-of-textile',
                    'section_number' => 4,
                    'images_count' => 3,
                    'tags' => ['cta', 'masters', 'textile', 'image', 'counter', 'text', 'button'],
                ],
                't18-masters-of-textile-section-5' => [
                    'title' => esc_html__('Our eco-friendly practices, responsible - Masters Of Textile', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't18-masters-of-textile',
                    'section_number' => 5,
                    'images_count' => 8,
                    'tags' => ['content', 'masters', 'textile', 'king addons video popup', 'text', 'image'],
                ],
                't18-masters-of-textile-section-6' => [
                    'title' => esc_html__('We believe in creating - Masters Of Textile', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't18-masters-of-textile',
                    'section_number' => 6,
                    'images_count' => 3,
                    'tags' => ['content', 'masters', 'textile', 'text', 'accordion', 'image'],
                ],
                't18-masters-of-textile-section-7' => [
                    'title' => esc_html__('Whether you\'re a designer - Masters Of Textile', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't18-masters-of-textile',
                    'section_number' => 7,
                    'images_count' => 1,
                    'tags' => ['cta', 'masters', 'textile', 'text', 'button'],
                ],
                't18-our-gallery-section-1' => [
                    'title' => esc_html__('Crafting Fashion, Stitching Style: - Our Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't18-our-gallery',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['content', 'our', 'gallery', 'text'],
                ],
                't18-our-gallery-section-2' => [
                    'title' => esc_html__('Our Gallery - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't18-our-gallery',
                    'section_number' => 2,
                    'images_count' => 11,
                    'tags' => ['general', 'our', 'gallery', 'king addons image grid'],
                ],
                't18-our-gallery-section-3' => [
                    'title' => esc_html__('Whether you\'re a designer - Our Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't18-our-gallery',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['cta', 'our', 'gallery', 'text', 'button'],
                ],
                't18-our-services-section-1' => [
                    'title' => esc_html__('The Fabric of Fashion: - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't18-our-services',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['content', 'our', 'services', 'text'],
                ],
                't18-our-services-section-2' => [
                    'title' => esc_html__('Our Services - Gallery Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'galleries',
                    'section_type' => 'gallery',
                    'parent_template' => 't18-our-services',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['gallery', 'our', 'services', 'image'],
                ],
                't18-our-services-section-3' => [
                    'title' => esc_html__('Whether you\'re a designer - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't18-our-services',
                    'section_number' => 3,
                    'images_count' => 8,
                    'tags' => ['content', 'our', 'services', 'text', 'image box', 'king addons auto scrolling text'],
                ],
                't18-our-services-section-4' => [
                    'title' => esc_html__('Whether you\'re a designer - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't18-our-services',
                    'section_number' => 4,
                    'images_count' => 3,
                    'tags' => ['cta', 'our', 'services', 'image', 'counter', 'text', 'button'],
                ],
                't18-our-services-section-5' => [
                    'title' => esc_html__('When you choose us, - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't18-our-services',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['content', 'our', 'services', 'text'],
                ],
                't18-our-services-section-6' => [
                    'title' => esc_html__('Whether you\'re a designer - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't18-our-services',
                    'section_number' => 6,
                    'images_count' => 2,
                    'tags' => ['cta', 'our', 'services', 'text', 'button'],
                ],
                't18-textile-tailoring-section-1' => [
                    'title' => esc_html__('Cutting-Edge Fashion & Textile - Textile Tailoring', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't18-textile-tailoring',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['content', 'textile', 'tailoring', 'divider', 'text', 'image'],
                ],
                't18-textile-tailoring-section-2' => [
                    'title' => esc_html__('Whether you\'re a designer - Textile Tailoring', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't18-textile-tailoring',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['cta', 'textile', 'tailoring', 'image', 'counter', 'text', 'button'],
                ],
                't18-textile-tailoring-section-3' => [
                    'title' => esc_html__('Whether you\'re a designer - Textile Tailoring', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't18-textile-tailoring',
                    'section_number' => 3,
                    'images_count' => 8,
                    'tags' => ['content', 'textile', 'tailoring', 'text', 'image box', 'king addons auto scrolling text'],
                ],
                't18-textile-tailoring-section-4' => [
                    'title' => esc_html__('Our eco-friendly practices, responsible - Textile Tailoring', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't18-textile-tailoring',
                    'section_number' => 4,
                    'images_count' => 4,
                    'tags' => ['cta', 'textile', 'tailoring', 'text', 'image', 'button'],
                ],
                't18-textile-tailoring-section-5' => [
                    'title' => esc_html__('Our eco-friendly practices, responsible - Textile Tailoring', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't18-textile-tailoring',
                    'section_number' => 5,
                    'images_count' => 8,
                    'tags' => ['content', 'textile', 'tailoring', 'king addons video popup', 'text', 'image'],
                ],
                't18-textile-tailoring-section-6' => [
                    'title' => esc_html__('We believe in creating - Textile Tailoring', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't18-textile-tailoring',
                    'section_number' => 6,
                    'images_count' => 3,
                    'tags' => ['content', 'textile', 'tailoring', 'text', 'accordion', 'image'],
                ],
                't18-textile-tailoring-section-7' => [
                    'title' => esc_html__('When you choose us, - Textile Tailoring', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't18-textile-tailoring',
                    'section_number' => 7,
                    'images_count' => 1,
                    'tags' => ['content', 'textile', 'tailoring', 'text'],
                ],
                't18-textile-tailoring-section-8' => [
                    'title' => esc_html__('Whether you\'re a designer - Textile Tailoring', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't18-textile-tailoring',
                    'section_number' => 8,
                    'images_count' => 2,
                    'tags' => ['cta', 'textile', 'tailoring', 'text', 'button'],
                ],
                't18-the-fabric-of-fashion-section-1' => [
                    'title' => esc_html__('Our relentless commitment to - The Fabric Of Fashion', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't18-the-fabric-of-fashion',
                    'section_number' => 1,
                    'images_count' => 4,
                    'tags' => ['cta', 'the', 'fabric', 'fashion', 'text', 'button', 'king addons video popup'],
                ],
                't18-the-fabric-of-fashion-section-2' => [
                    'title' => esc_html__('Our eco-friendly practices, responsible - The Fabric Of Fashion', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't18-the-fabric-of-fashion',
                    'section_number' => 2,
                    'images_count' => 4,
                    'tags' => ['cta', 'the', 'fabric', 'fashion', 'text', 'image', 'button'],
                ],
                't18-the-fabric-of-fashion-section-3' => [
                    'title' => esc_html__('Whether you\'re a designer - The Fabric Of Fashion', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't18-the-fabric-of-fashion',
                    'section_number' => 3,
                    'images_count' => 8,
                    'tags' => ['content', 'the', 'fabric', 'fashion', 'text', 'image box', 'king addons auto scrolling text'],
                ],
                't18-the-fabric-of-fashion-section-4' => [
                    'title' => esc_html__('Whether you\'re a designer - The Fabric Of Fashion', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't18-the-fabric-of-fashion',
                    'section_number' => 4,
                    'images_count' => 3,
                    'tags' => ['cta', 'the', 'fabric', 'fashion', 'image', 'counter', 'text', 'button'],
                ],
                't18-the-fabric-of-fashion-section-5' => [
                    'title' => esc_html__('Whether you\'re a designer - The Fabric Of Fashion', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't18-the-fabric-of-fashion',
                    'section_number' => 5,
                    'images_count' => 5,
                    'tags' => ['cta', 'the', 'fabric', 'fashion', 'king addons video popup', 'image', 'text', 'icon list', 'button'],
                ],
                't18-the-fabric-of-fashion-section-6' => [
                    'title' => esc_html__('We believe in creating - The Fabric Of Fashion', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't18-the-fabric-of-fashion',
                    'section_number' => 6,
                    'images_count' => 3,
                    'tags' => ['content', 'the', 'fabric', 'fashion', 'text', 'accordion', 'image'],
                ],
                't18-the-fabric-of-fashion-section-7' => [
                    'title' => esc_html__('Whether you\'re a designer - The Fabric Of Fashion', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't18-the-fabric-of-fashion',
                    'section_number' => 7,
                    'images_count' => 1,
                    'tags' => ['cta', 'the', 'fabric', 'fashion', 'text', 'button'],
                ],
                't18-your-fashion-source-section-1' => [
                    'title' => esc_html__('Eco-Friendly Fashion & Textiles - Your Fashion Source', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't18-your-fashion-source',
                    'section_number' => 1,
                    'images_count' => 6,
                    'tags' => ['content', 'your', 'fashion', 'source', 'text', 'image', 'text path'],
                ],
                't18-your-fashion-source-section-2' => [
                    'title' => esc_html__('Whether you\'re a designer - Your Fashion Source', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't18-your-fashion-source',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['cta', 'your', 'fashion', 'source', 'image', 'counter', 'text', 'button'],
                ],
                't18-your-fashion-source-section-3' => [
                    'title' => esc_html__('Whether you\'re a designer - Your Fashion Source', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't18-your-fashion-source',
                    'section_number' => 3,
                    'images_count' => 8,
                    'tags' => ['content', 'your', 'fashion', 'source', 'text', 'image box', 'king addons auto scrolling text'],
                ],
                't18-your-fashion-source-section-4' => [
                    'title' => esc_html__('Our eco-friendly practices, responsible - Your Fashion Source', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't18-your-fashion-source',
                    'section_number' => 4,
                    'images_count' => 4,
                    'tags' => ['cta', 'your', 'fashion', 'source', 'text', 'image', 'button'],
                ],
                't18-your-fashion-source-section-5' => [
                    'title' => esc_html__('Our eco-friendly practices, responsible - Your Fashion Source', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't18-your-fashion-source',
                    'section_number' => 5,
                    'images_count' => 7,
                    'tags' => ['content', 'your', 'fashion', 'source', 'text', 'image'],
                ],
                't18-your-fashion-source-section-6' => [
                    'title' => esc_html__('When you choose us, - Your Fashion Source', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't18-your-fashion-source',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['content', 'your', 'fashion', 'source', 'text'],
                ],
                't18-your-fashion-source-section-7' => [
                    'title' => esc_html__('We believe in creating - Your Fashion Source', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't18-your-fashion-source',
                    'section_number' => 7,
                    'images_count' => 3,
                    'tags' => ['content', 'your', 'fashion', 'source', 'text', 'accordion', 'image'],
                ],
                't18-your-fashion-source-section-8' => [
                    'title' => esc_html__('Whether you\'re a designer - Your Fashion Source', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't18-your-fashion-source',
                    'section_number' => 8,
                    'images_count' => 2,
                    'tags' => ['cta', 'your', 'fashion', 'source', 'text', 'button'],
                ],
                't19-about-us-section-1' => [
                    'title' => esc_html__('Your time and skills - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't19-about-us',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['content', 'about', 'text'],
                ],
                't19-about-us-section-2' => [
                    'title' => esc_html__('About Us - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't19-about-us',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['general', 'about', 'king addons video popup'],
                ],
                't19-about-us-section-3' => [
                    'title' => esc_html__('Your time and skills - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't19-about-us',
                    'section_number' => 3,
                    'images_count' => 3,
                    'tags' => ['content', 'about', 'text', 'divider', 'image box', 'image'],
                ],
                't19-about-us-section-4' => [
                    'title' => esc_html__(' From disaster response - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't19-about-us',
                    'section_number' => 4,
                    'images_count' => 6,
                    'tags' => ['content', 'about', 'text', 'king addons image hover box'],
                ],
                't19-about-us-section-5' => [
                    'title' => esc_html__('With your support, we - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't19-about-us',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['content', 'about', 'text'],
                ],
                't19-about-us-section-6' => [
                    'title' => esc_html__('We secured $100,000 in - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't19-about-us',
                    'section_number' => 6,
                    'images_count' => 3,
                    'tags' => ['cta', 'about', 'counter', 'text', 'button', 'image'],
                ],
                't19-about-us-section-7' => [
                    'title' => esc_html__('Your contributions directly impact - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't19-about-us',
                    'section_number' => 7,
                    'images_count' => 1,
                    'tags' => ['cta', 'about', 'text', 'button'],
                ],
                't19-contact-us-section-1' => [
                    'title' => esc_html__('Your time and skills - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't19-contact-us',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['header', 'contact', 'text', 'spacer', 'heading', 'shortcode'],
                ],
                't19-contact-us-section-2' => [
                    'title' => esc_html__('Contact Us - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't19-contact-us',
                    'section_number' => 2,
                    'images_count' => 0,
                    'tags' => ['general', 'contact', 'icon box'],
                ],
                't19-contact-us-section-3' => [
                    'title' => esc_html__('Your time and skills - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't19-contact-us',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['content', 'contact', 'text', 'google_maps'],
                ],
                't19-contact-us-section-4' => [
                    'title' => esc_html__('Your contributions directly impact - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't19-contact-us',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['cta', 'contact', 'text', 'button'],
                ],
                't19-inspiring-hope-section-1' => [
                    'title' => esc_html__('Read about the stories - Inspiring Hope', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't19-inspiring-hope',
                    'section_number' => 1,
                    'images_count' => 6,
                    'tags' => ['content', 'inspiring', 'hope', 'text', 'image'],
                ],
                't19-inspiring-hope-section-2' => [
                    'title' => esc_html__(' From disaster response - Inspiring Hope', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't19-inspiring-hope',
                    'section_number' => 2,
                    'images_count' => 6,
                    'tags' => ['content', 'inspiring', 'hope', 'text', 'image box', 'king addons video popup'],
                ],
                't19-inspiring-hope-section-3' => [
                    'title' => esc_html__('Your time and skills - Inspiring Hope', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't19-inspiring-hope',
                    'section_number' => 3,
                    'images_count' => 3,
                    'tags' => ['content', 'inspiring', 'hope', 'text', 'divider', 'image box', 'image'],
                ],
                't19-inspiring-hope-section-4' => [
                    'title' => esc_html__('With your support, we - Inspiring Hope', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't19-inspiring-hope',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['content', 'inspiring', 'hope', 'text'],
                ],
                't19-inspiring-hope-section-5' => [
                    'title' => esc_html__('We secured $100,000 in - Inspiring Hope', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't19-inspiring-hope',
                    'section_number' => 5,
                    'images_count' => 2,
                    'tags' => ['cta', 'inspiring', 'hope', 'image', 'counter', 'text', 'button'],
                ],
                't19-inspiring-hope-section-6' => [
                    'title' => esc_html__('Our charity offers a - Inspiring Hope', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't19-inspiring-hope',
                    'section_number' => 6,
                    'images_count' => 7,
                    'tags' => ['content', 'inspiring', 'hope', 'text', 'image'],
                ],
                't19-inspiring-hope-section-7' => [
                    'title' => esc_html__('Church Life Beyond Sundays: - Inspiring Hope', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't19-inspiring-hope',
                    'section_number' => 7,
                    'images_count' => 2,
                    'tags' => ['content', 'inspiring', 'hope', 'text', 'king addons blog posts'],
                ],
                't19-inspiring-hope-section-8' => [
                    'title' => esc_html__('Your contributions directly impact - Inspiring Hope', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't19-inspiring-hope',
                    'section_number' => 8,
                    'images_count' => 1,
                    'tags' => ['cta', 'inspiring', 'hope', 'text', 'button'],
                ],
                't19-our-services-section-1' => [
                    'title' => esc_html__('Your time and skills - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't19-our-services',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['content', 'our', 'services', 'text'],
                ],
                't19-our-services-section-2' => [
                    'title' => esc_html__('Our Services - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't19-our-services',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['general', 'our', 'services', 'king addons video popup'],
                ],
                't19-our-services-section-3' => [
                    'title' => esc_html__(' From disaster response - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't19-our-services',
                    'section_number' => 3,
                    'images_count' => 6,
                    'tags' => ['content', 'our', 'services', 'text', 'king addons image hover box'],
                ],
                't19-our-services-section-4' => [
                    'title' => esc_html__(' From disaster response - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't19-our-services',
                    'section_number' => 4,
                    'images_count' => 6,
                    'tags' => ['content', 'our', 'services', 'text', 'image box', 'ucaddon_blox_play_button'],
                ],
                't19-our-services-section-5' => [
                    'title' => esc_html__('We secured $100,000 in - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't19-our-services',
                    'section_number' => 5,
                    'images_count' => 3,
                    'tags' => ['cta', 'our', 'services', 'counter', 'text', 'button', 'image'],
                ],
                't19-our-services-section-6' => [
                    'title' => esc_html__('Your contributions directly impact - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't19-our-services',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['cta', 'our', 'services', 'text', 'button'],
                ],
                't19-our-team-section-1' => [
                    'title' => esc_html__('Your time and skills - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't19-our-team',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['content', 'our', 'team', 'text'],
                ],
                't19-our-team-section-2' => [
                    'title' => esc_html__('Reverend Sarah Mitchell  - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't19-our-team',
                    'section_number' => 2,
                    'images_count' => 11,
                    'tags' => ['header', 'our', 'team', 'image', 'heading', 'social icons'],
                ],
                't19-our-team-section-3' => [
                    'title' => esc_html__('Your contributions directly impact - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't19-our-team',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['cta', 'our', 'team', 'text', 'button'],
                ],
                't19-serving-with-love-section-1' => [
                    'title' => esc_html__('Your time and skills - Serving With Love', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't19-serving-with-love',
                    'section_number' => 1,
                    'images_count' => 4,
                    'tags' => ['cta', 'serving', 'with', 'love', 'image', 'text', 'button', 'text path'],
                ],
                't19-serving-with-love-section-2' => [
                    'title' => esc_html__('We secured $100,000 in - Serving With Love', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't19-serving-with-love',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['cta', 'serving', 'with', 'love', 'counter', 'text', 'button', 'image'],
                ],
                't19-serving-with-love-section-3' => [
                    'title' => esc_html__('With your support, we - Serving With Love', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't19-serving-with-love',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['content', 'serving', 'with', 'love', 'text'],
                ],
                't19-serving-with-love-section-4' => [
                    'title' => esc_html__('Our charity offers a - Serving With Love', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't19-serving-with-love',
                    'section_number' => 4,
                    'images_count' => 7,
                    'tags' => ['content', 'serving', 'with', 'love', 'text', 'image'],
                ],
                't19-serving-with-love-section-5' => [
                    'title' => esc_html__('Your time and skills - Serving With Love', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't19-serving-with-love',
                    'section_number' => 5,
                    'images_count' => 5,
                    'tags' => ['content', 'serving', 'with', 'love', 'text', 'divider', 'image box', 'image'],
                ],
                't19-serving-with-love-section-6' => [
                    'title' => esc_html__(' From disaster response - Serving With Love', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't19-serving-with-love',
                    'section_number' => 6,
                    'images_count' => 6,
                    'tags' => ['content', 'serving', 'with', 'love', 'text', 'image box', 'king addons video popup'],
                ],
                't19-serving-with-love-section-7' => [
                    'title' => esc_html__('Church Life Beyond Sundays: - Serving With Love', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't19-serving-with-love',
                    'section_number' => 7,
                    'images_count' => 2,
                    'tags' => ['content', 'serving', 'with', 'love', 'text', 'king addons blog posts'],
                ],
                't19-serving-with-love-section-8' => [
                    'title' => esc_html__('Your contributions directly impact - Serving With Love', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't19-serving-with-love',
                    'section_number' => 8,
                    'images_count' => 1,
                    'tags' => ['cta', 'serving', 'with', 'love', 'text', 'button'],
                ],
                't19-sunday-worship-section-1' => [
                    'title' => esc_html__('Your time and skills - Sunday Worship', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't19-sunday-worship',
                    'section_number' => 1,
                    'images_count' => 4,
                    'tags' => ['cta', 'sunday', 'worship', 'image', 'king addons video popup', 'text', 'button'],
                ],
                't19-sunday-worship-section-2' => [
                    'title' => esc_html__('We secured $100,000 in - Sunday Worship', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't19-sunday-worship',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['cta', 'sunday', 'worship', 'counter', 'text', 'button', 'image'],
                ],
                't19-sunday-worship-section-3' => [
                    'title' => esc_html__('With your support, we - Sunday Worship', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't19-sunday-worship',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['content', 'sunday', 'worship', 'text'],
                ],
                't19-sunday-worship-section-4' => [
                    'title' => esc_html__('Our charity offers a - Sunday Worship', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't19-sunday-worship',
                    'section_number' => 4,
                    'images_count' => 7,
                    'tags' => ['content', 'sunday', 'worship', 'text', 'image'],
                ],
                't19-sunday-worship-section-5' => [
                    'title' => esc_html__('Your time and skills - Sunday Worship', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't19-sunday-worship',
                    'section_number' => 5,
                    'images_count' => 3,
                    'tags' => ['content', 'sunday', 'worship', 'text', 'divider', 'image box', 'image'],
                ],
                't19-sunday-worship-section-6' => [
                    'title' => esc_html__(' From disaster response - Sunday Worship', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't19-sunday-worship',
                    'section_number' => 6,
                    'images_count' => 6,
                    'tags' => ['content', 'sunday', 'worship', 'text', 'king addons image hover box'],
                ],
                't19-sunday-worship-section-7' => [
                    'title' => esc_html__('Church Life Beyond Sundays: - Sunday Worship', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't19-sunday-worship',
                    'section_number' => 7,
                    'images_count' => 2,
                    'tags' => ['content', 'sunday', 'worship', 'text', 'king addons blog posts'],
                ],
                't19-sunday-worship-section-8' => [
                    'title' => esc_html__(' Your contributions directly - Sunday Worship', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't19-sunday-worship',
                    'section_number' => 8,
                    'images_count' => 2,
                    'tags' => ['cta', 'sunday', 'worship', 'text', 'button'],
                ],
                't19-transforming-lives-section-1' => [
                    'title' => esc_html__('Join our community and - Transforming Lives', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't19-transforming-lives',
                    'section_number' => 1,
                    'images_count' => 8,
                    'tags' => ['cta', 'transforming', 'lives', 'text', 'button', 'king addons video popup', 'image'],
                ],
                't19-transforming-lives-section-2' => [
                    'title' => esc_html__(' From disaster response - Transforming Lives', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't19-transforming-lives',
                    'section_number' => 2,
                    'images_count' => 6,
                    'tags' => ['content', 'transforming', 'lives', 'text', 'king addons image hover box'],
                ],
                't19-transforming-lives-section-3' => [
                    'title' => esc_html__('Your time and skills - Transforming Lives', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't19-transforming-lives',
                    'section_number' => 3,
                    'images_count' => 3,
                    'tags' => ['content', 'transforming', 'lives', 'text', 'divider', 'image box', 'image'],
                ],
                't19-transforming-lives-section-4' => [
                    'title' => esc_html__('With your support, we - Transforming Lives', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't19-transforming-lives',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['content', 'transforming', 'lives', 'text'],
                ],
                't19-transforming-lives-section-5' => [
                    'title' => esc_html__('We secured $100,000 in - Transforming Lives', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't19-transforming-lives',
                    'section_number' => 5,
                    'images_count' => 2,
                    'tags' => ['cta', 'transforming', 'lives', 'image', 'counter', 'text', 'button'],
                ],
                't19-transforming-lives-section-6' => [
                    'title' => esc_html__('Our charity offers a - Transforming Lives', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't19-transforming-lives',
                    'section_number' => 6,
                    'images_count' => 7,
                    'tags' => ['content', 'transforming', 'lives', 'text', 'image'],
                ],
                't19-transforming-lives-section-7' => [
                    'title' => esc_html__('Church Life Beyond Sundays: - Transforming Lives', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't19-transforming-lives',
                    'section_number' => 7,
                    'images_count' => 2,
                    'tags' => ['content', 'transforming', 'lives', 'text', 'king addons blog posts'],
                ],
                't19-transforming-lives-section-8' => [
                    'title' => esc_html__(' Your contributions directly - Transforming Lives', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't19-transforming-lives',
                    'section_number' => 8,
                    'images_count' => 2,
                    'tags' => ['cta', 'transforming', 'lives', 'text', 'button'],
                ],
                't2-3d-design-app-section-1' => [
                    'title' => esc_html__('Introducing the first fully - 3d Design App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'creative',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't2-3d-design-app',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['hero', 'design', 'app', 'text', 'button', 'heading', 'image'],
                ],
                't2-3d-design-app-section-2' => [
                    'title' => esc_html__('Create compelling compositions for - 3d Design App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'creative',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't2-3d-design-app',
                    'section_number' => 2,
                    'images_count' => 5,
                    'tags' => ['content', 'design', 'app', 'image', 'text'],
                ],
                't2-3d-design-app-section-3' => [
                    'title' => esc_html__('Create compelling compositions for - 3d Design App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'creative',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't2-3d-design-app',
                    'section_number' => 3,
                    'images_count' => 3,
                    'tags' => ['cta', 'design', 'app', 'image', 'text', 'divider', 'button', 'king addons video popup'],
                ],
                't2-3d-design-app-section-4' => [
                    'title' => esc_html__('Create compelling compositions for - 3d Design App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'creative',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't2-3d-design-app',
                    'section_number' => 4,
                    'images_count' => 4,
                    'tags' => ['cta', 'design', 'app', 'text', 'button', 'image box'],
                ],
                't2-3d-design-app-section-5' => [
                    'title' => esc_html__('Create compelling compositions for - 3d Design App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'creative',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't2-3d-design-app',
                    'section_number' => 5,
                    'images_count' => 2,
                    'tags' => ['cta', 'design', 'app', 'image', 'text', 'button'],
                ],
                't2-3d-design-app-section-6' => [
                    'title' => esc_html__('Create compelling compositions for - 3d Design App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'creative',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't2-3d-design-app',
                    'section_number' => 6,
                    'images_count' => 5,
                    'tags' => ['cta', 'design', 'app', 'text', 'button', 'image'],
                ],
                't2-3d-design-app-section-7' => [
                    'title' => esc_html__('Create compelling compositions for - 3d Design App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'creative',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't2-3d-design-app',
                    'section_number' => 7,
                    'images_count' => 3,
                    'tags' => ['content', 'design', 'app', 'image', 'text'],
                ],
                't2-about-us-section-1' => [
                    'title' => esc_html__('Vivamus lectus nibh, mollis - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't2-about-us',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['content', 'about', 'text', 'image', 'counter', 'icon box'],
                ],
                't2-about-us-section-2' => [
                    'title' => esc_html__('About Us - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't2-about-us',
                    'section_number' => 2,
                    'images_count' => 4,
                    'tags' => ['general', 'about', 'image carousel'],
                ],
                't2-about-us-section-3' => [
                    'title' => esc_html__('Lorem ipsum dolor sit - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't2-about-us',
                    'section_number' => 3,
                    'images_count' => 11,
                    'tags' => ['hero', 'about', 'text', 'button', 'image', 'heading'],
                ],
                't2-about-us-section-4' => [
                    'title' => esc_html__('Vivamus lectus nibh, mollis - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't2-about-us',
                    'section_number' => 4,
                    'images_count' => 6,
                    'tags' => ['header', 'about', 'text', 'heading', 'image'],
                ],
                't2-about-us-section-5' => [
                    'title' => esc_html__('Ready to work together?! - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't2-about-us',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['cta', 'about', 'text', 'button'],
                ],
                't2-banking-app-section-1' => [
                    'title' => esc_html__('View enhanced transactions in - Banking App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't2-banking-app',
                    'section_number' => 1,
                    'images_count' => 9,
                    'tags' => ['cta', 'banking', 'app', 'text', 'button', 'image'],
                ],
                't2-banking-app-section-2' => [
                    'title' => esc_html__('Through innovative products, tools, - Banking App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't2-banking-app',
                    'section_number' => 2,
                    'images_count' => 0,
                    'tags' => ['header', 'banking', 'app', 'heading', 'text'],
                ],
                't2-banking-app-section-3' => [
                    'title' => esc_html__('Through innovative products, tools, - Banking App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't2-banking-app',
                    'section_number' => 3,
                    'images_count' => 5,
                    'tags' => ['header', 'banking', 'app', 'text', 'heading', 'image'],
                ],
                't2-banking-app-section-4' => [
                    'title' => esc_html__('View enhanced transactions in - Banking App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't2-banking-app',
                    'section_number' => 4,
                    'images_count' => 12,
                    'tags' => ['hero', 'banking', 'app', 'text', 'heading', 'button', 'image', 'image box'],
                ],
                't2-banking-app-section-5' => [
                    'title' => esc_html__('Through innovative products, tools, - Banking App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't2-banking-app',
                    'section_number' => 5,
                    'images_count' => 8,
                    'tags' => ['header', 'banking', 'app', 'text', 'heading', 'testimonial'],
                ],
                't2-banking-app-section-6' => [
                    'title' => esc_html__('Start managing your money - Banking App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't2-banking-app',
                    'section_number' => 6,
                    'images_count' => 4,
                    'tags' => ['header', 'banking', 'app', 'heading', 'image'],
                ],
                't2-contact-us-section-1' => [
                    'title' => esc_html__('Vivamus lectus nibh, mollis - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't2-contact-us',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['header', 'contact', 'text', 'spacer', 'heading', 'shortcode', 'toggle'],
                ],
                't2-contact-us-section-2' => [
                    'title' => esc_html__('Contact Us - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't2-contact-us',
                    'section_number' => 2,
                    'images_count' => 0,
                    'tags' => ['general', 'contact', 'google_maps'],
                ],
                't2-contact-us-section-3' => [
                    'title' => esc_html__('Ready to work together?! - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't2-contact-us',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['cta', 'contact', 'text', 'button'],
                ],
                't2-currency-exchange-app-section-1' => [
                    'title' => esc_html__('Send money internationally, check - Currency Exchange App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't2-currency-exchange-app',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['hero', 'currency', 'exchange', 'app', 'text', 'button', 'heading', 'image'],
                ],
                't2-currency-exchange-app-section-2' => [
                    'title' => esc_html__('Trusted by hundreds of - Currency Exchange App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't2-currency-exchange-app',
                    'section_number' => 2,
                    'images_count' => 8,
                    'tags' => ['content', 'currency', 'exchange', 'app', 'text', 'image', 'image carousel'],
                ],
                't2-currency-exchange-app-section-3' => [
                    'title' => esc_html__('You\'ll be able to - Currency Exchange App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't2-currency-exchange-app',
                    'section_number' => 3,
                    'images_count' => 9,
                    'tags' => ['content', 'currency', 'exchange', 'app', 'text', 'image', 'image box'],
                ],
                't2-currency-exchange-app-section-4' => [
                    'title' => esc_html__('Send money internationally, check - Currency Exchange App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't2-currency-exchange-app',
                    'section_number' => 4,
                    'images_count' => 3,
                    'tags' => ['cta', 'currency', 'exchange', 'app', 'text', 'button', 'image'],
                ],
                't2-currency-exchange-app-section-5' => [
                    'title' => esc_html__('Send money internationally, check - Currency Exchange App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't2-currency-exchange-app',
                    'section_number' => 5,
                    'images_count' => 2,
                    'tags' => ['cta', 'currency', 'exchange', 'app', 'text', 'button', 'image'],
                ],
                't2-currency-exchange-app-section-6' => [
                    'title' => esc_html__('Send money internationally, check - Currency Exchange App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't2-currency-exchange-app',
                    'section_number' => 6,
                    'images_count' => 9,
                    'tags' => ['content', 'currency', 'exchange', 'app', 'image', 'text', 'image carousel'],
                ],
                't2-currency-exchange-app-section-7' => [
                    'title' => esc_html__('“The best app ever! - Currency Exchange App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't2-currency-exchange-app',
                    'section_number' => 7,
                    'images_count' => 3,
                    'tags' => ['hero', 'currency', 'exchange', 'app', 'text', 'button', 'star rating', 'image', 'heading'],
                ],
                't2-currency-exchange-app-section-8' => [
                    'title' => esc_html__('You\'ll be able to - Currency Exchange App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't2-currency-exchange-app',
                    'section_number' => 8,
                    'images_count' => 3,
                    'tags' => ['content', 'currency', 'exchange', 'app', 'image', 'text', 'toggle'],
                ],
                't2-currency-exchange-app-section-9' => [
                    'title' => esc_html__('Your card is ready - Currency Exchange App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't2-currency-exchange-app',
                    'section_number' => 9,
                    'images_count' => 1,
                    'tags' => ['cta', 'currency', 'exchange', 'app', 'text', 'button', 'image'],
                ],
                't2-finance-app-section-1' => [
                    'title' => esc_html__('Find savings opportunities by - Finance App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't2-finance-app',
                    'section_number' => 1,
                    'images_count' => 6,
                    'tags' => ['hero', 'finance', 'app', 'image', 'styled text', 'text', 'button', 'heading'],
                ],
                't2-finance-app-section-2' => [
                    'title' => esc_html__('Sinking funds and savings - Finance App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't2-finance-app',
                    'section_number' => 2,
                    'images_count' => 11,
                    'tags' => ['cta', 'finance', 'app', 'text', 'button', 'image'],
                ],
                't2-finance-app-section-3' => [
                    'title' => esc_html__('Change the way you - Finance App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't2-finance-app',
                    'section_number' => 3,
                    'images_count' => 3,
                    'tags' => ['cta', 'finance', 'app', 'text', 'button', 'image'],
                ],
                't2-finance-app-section-4' => [
                    'title' => esc_html__('Now you can see - Finance App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't2-finance-app',
                    'section_number' => 4,
                    'images_count' => 23,
                    'tags' => ['hero', 'finance', 'app', 'text', 'image carousel', 'image', 'star rating', 'heading', 'button'],
                ],
                't2-finance-tracking-section-1' => [
                    'title' => esc_html__('You can manage your - Finance Tracking', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't2-finance-tracking',
                    'section_number' => 1,
                    'images_count' => 4,
                    'tags' => ['cta', 'finance', 'tracking', 'text', 'image', 'button'],
                ],
                't2-finance-tracking-section-2' => [
                    'title' => esc_html__('Finance Tracking - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't2-finance-tracking',
                    'section_number' => 2,
                    'images_count' => 11,
                    'tags' => ['general', 'finance', 'tracking', 'image carousel'],
                ],
                't2-finance-tracking-section-3' => [
                    'title' => esc_html__('You can manage your - Finance Tracking', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't2-finance-tracking',
                    'section_number' => 3,
                    'images_count' => 4,
                    'tags' => ['content', 'finance', 'tracking', 'text', 'image'],
                ],
                't2-finance-tracking-section-4' => [
                    'title' => esc_html__('Save, invest and send - Finance Tracking', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't2-finance-tracking',
                    'section_number' => 4,
                    'images_count' => 7,
                    'tags' => ['cta', 'finance', 'tracking', 'text', 'button', 'image', 'text path'],
                ],
                't2-finance-tracking-section-5' => [
                    'title' => esc_html__('trusted partners - Finance Tracking', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't2-finance-tracking',
                    'section_number' => 5,
                    'images_count' => 0,
                    'tags' => ['header', 'finance', 'tracking', 'heading', 'text'],
                ],
                't2-finance-tracking-section-6' => [
                    'title' => esc_html__('You can manage your - Finance Tracking', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't2-finance-tracking',
                    'section_number' => 6,
                    'images_count' => 9,
                    'tags' => ['content', 'finance', 'tracking', 'text', 'image', 'testimonial', 'toggle'],
                ],
                't2-finance-tracking-section-7' => [
                    'title' => esc_html__('You can manage your - Finance Tracking', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't2-finance-tracking',
                    'section_number' => 7,
                    'images_count' => 1,
                    'tags' => ['hero', 'finance', 'tracking', 'text', 'image', 'divider', 'heading', 'icon list', 'button'],
                ],
                't2-finance-tracking-section-8' => [
                    'title' => esc_html__('Save, invest and send - Finance Tracking', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't2-finance-tracking',
                    'section_number' => 8,
                    'images_count' => 6,
                    'tags' => ['cta', 'finance', 'tracking', 'text', 'button', 'image'],
                ],
                't2-fitness-app-section-1' => [
                    'title' => esc_html__('Do you already have - Fitness App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't2-fitness-app',
                    'section_number' => 1,
                    'images_count' => 6,
                    'tags' => ['hero', 'fitness', 'app', 'text', 'button', 'image', 'image box', 'heading'],
                ],
                't2-fitness-app-section-2' => [
                    'title' => esc_html__('Using ApkaFitness, you can - Fitness App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't2-fitness-app',
                    'section_number' => 2,
                    'images_count' => 8,
                    'tags' => ['cta', 'fitness', 'app', 'image', 'text', 'button'],
                ],
                't2-fitness-app-section-3' => [
                    'title' => esc_html__('Across all fitness levels, - Fitness App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't2-fitness-app',
                    'section_number' => 3,
                    'images_count' => 6,
                    'tags' => ['content', 'fitness', 'app', 'text', 'image'],
                ],
                't2-fitness-app-section-4' => [
                    'title' => esc_html__('View progress and reach - Fitness App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't2-fitness-app',
                    'section_number' => 4,
                    'images_count' => 2,
                    'tags' => ['cta', 'fitness', 'app', 'text', 'icon list', 'button', 'image'],
                ],
                't2-fitness-app-section-5' => [
                    'title' => esc_html__('Sign up for unlimited - Fitness App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't2-fitness-app',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['cta', 'fitness', 'app', 'text', 'button'],
                ],
                't2-fitness-app-section-6' => [
                    'title' => esc_html__('\"Within a year I - Fitness App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't2-fitness-app',
                    'section_number' => 6,
                    'images_count' => 5,
                    'tags' => ['header', 'fitness', 'app', 'text', 'heading', 'star rating', 'image'],
                ],
                't2-fitness-app-section-7' => [
                    'title' => esc_html__('Across all fitness levels, - Fitness App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't2-fitness-app',
                    'section_number' => 7,
                    'images_count' => 1,
                    'tags' => ['content', 'fitness', 'app', 'counter', 'text', 'image'],
                ],
                't2-fitness-app-section-8' => [
                    'title' => esc_html__('Using ApkaFitness, you can - Fitness App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't2-fitness-app',
                    'section_number' => 8,
                    'images_count' => 2,
                    'tags' => ['hero', 'fitness', 'app', 'heading', 'text', 'button'],
                ],
                't2-mobile-payment-section-1' => [
                    'title' => esc_html__('Make your daily routine - Mobile Payment', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't2-mobile-payment',
                    'section_number' => 1,
                    'images_count' => 6,
                    'tags' => ['cta', 'mobile', 'payment', 'image', 'text', 'button', 'star rating'],
                ],
                't2-mobile-payment-section-2' => [
                    'title' => esc_html__('Keep track of your - Mobile Payment', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't2-mobile-payment',
                    'section_number' => 2,
                    'images_count' => 6,
                    'tags' => ['hero', 'mobile', 'payment', 'heading', 'text', 'image', 'button'],
                ],
                't2-mobile-payment-section-3' => [
                    'title' => esc_html__('Get more done by - Mobile Payment', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't2-mobile-payment',
                    'section_number' => 3,
                    'images_count' => 7,
                    'tags' => ['content', 'mobile', 'payment', 'text', 'image', 'image box'],
                ],
                't2-mobile-payment-section-4' => [
                    'title' => esc_html__('View enhanced transactions in - Mobile Payment', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't2-mobile-payment',
                    'section_number' => 4,
                    'images_count' => 5,
                    'tags' => ['content', 'mobile', 'payment', 'text', 'image'],
                ],
                't2-mobile-payment-section-5' => [
                    'title' => esc_html__('Keep track of your - Mobile Payment', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't2-mobile-payment',
                    'section_number' => 5,
                    'images_count' => 5,
                    'tags' => ['header', 'mobile', 'payment', 'image', 'text', 'heading', 'icon list'],
                ],
                't2-mobile-payment-section-6' => [
                    'title' => esc_html__('Make your daily routine - Mobile Payment', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't2-mobile-payment',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['cta', 'mobile', 'payment', 'text', 'button'],
                ],
                't2-our-team-section-1' => [
                    'title' => esc_html__('Vivamus lectus nibh, mollis - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't2-our-team',
                    'section_number' => 1,
                    'images_count' => 10,
                    'tags' => ['content', 'our', 'team', 'text', 'image'],
                ],
                't2-our-team-section-2' => [
                    'title' => esc_html__('Ready to work together?! - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't2-our-team',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['cta', 'our', 'team', 'text', 'button'],
                ],
                't2-task-management-app-section-1' => [
                    'title' => esc_html__('We connect everyone to - Task Management App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't2-task-management-app',
                    'section_number' => 1,
                    'images_count' => 10,
                    'tags' => ['cta', 'task', 'management', 'app', 'image box', 'text', 'image', 'button'],
                ],
                't2-task-management-app-section-2' => [
                    'title' => esc_html__('Get all your work - Task Management App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't2-task-management-app',
                    'section_number' => 2,
                    'images_count' => 0,
                    'tags' => ['header', 'task', 'management', 'app', 'text', 'heading'],
                ],
                't2-task-management-app-section-3' => [
                    'title' => esc_html__('The highly customizable project - Task Management App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't2-task-management-app',
                    'section_number' => 3,
                    'images_count' => 8,
                    'tags' => ['hero', 'task', 'management', 'app', 'text', 'button', 'image', 'heading', 'king addons card carousel'],
                ],
                't2-task-management-app-section-4' => [
                    'title' => esc_html__('Praesent vel metus erat. - Task Management App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't2-task-management-app',
                    'section_number' => 4,
                    'images_count' => 7,
                    'tags' => ['header', 'task', 'management', 'app', 'text', 'heading', 'image'],
                ],
                't2-task-management-app-section-5' => [
                    'title' => esc_html__('Flexible options for any - Task Management App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't2-task-management-app',
                    'section_number' => 5,
                    'images_count' => 6,
                    'tags' => ['hero', 'task', 'management', 'app', 'text', 'heading', 'icon', 'image', 'icon list', 'button'],
                ],
                't2-task-management-app-section-6' => [
                    'title' => esc_html__('With real-time chat, assign - Task Management App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't2-task-management-app',
                    'section_number' => 6,
                    'images_count' => 3,
                    'tags' => ['cta', 'task', 'management', 'app', 'text', 'button', 'image'],
                ],
                't2-task-management-app-section-7' => [
                    'title' => esc_html__('Follow updates in your - Task Management App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't2-task-management-app',
                    'section_number' => 7,
                    'images_count' => 5,
                    'tags' => ['cta', 'task', 'management', 'app', 'image', 'text', 'button'],
                ],
                't2-task-management-app-section-8' => [
                    'title' => esc_html__('Deliver better products, faster. - Task Management App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't2-task-management-app',
                    'section_number' => 8,
                    'images_count' => 2,
                    'tags' => ['cta', 'task', 'management', 'app', 'text', 'button'],
                ],
                't20-about-us-section-1' => [
                    'title' => esc_html__('We meticulously select and - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't20-about-us',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['content', 'about', 'text'],
                ],
                't20-about-us-section-2' => [
                    'title' => esc_html__('About Us - Gallery Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'galleries',
                    'section_type' => 'gallery',
                    'parent_template' => 't20-about-us',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['gallery', 'about', 'image'],
                ],
                't20-about-us-section-3' => [
                    'title' => esc_html__('Our commitment to the - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't20-about-us',
                    'section_number' => 3,
                    'images_count' => 5,
                    'tags' => ['cta', 'about', 'text', 'image', 'button'],
                ],
                't20-about-us-section-4' => [
                    'title' => esc_html__('Our passion for dogs - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't20-about-us',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['content', 'about', 'text'],
                ],
                't20-about-us-section-5' => [
                    'title' => esc_html__('We meticulously select and - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't20-about-us',
                    'section_number' => 5,
                    'images_count' => 6,
                    'tags' => ['content', 'about', 'image', 'text', 'divider', 'image box'],
                ],
                't20-about-us-section-6' => [
                    'title' => esc_html__('Whether you\'re seeking a - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't20-about-us',
                    'section_number' => 6,
                    'images_count' => 2,
                    'tags' => ['cta', 'about', 'text', 'button'],
                ],
                't20-contact-us-section-1' => [
                    'title' => esc_html__('Our commitment to compassionate, - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't20-contact-us',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['header', 'contact', 'text', 'spacer', 'heading', 'shortcode'],
                ],
                't20-contact-us-section-2' => [
                    'title' => esc_html__('Contact Us - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't20-contact-us',
                    'section_number' => 2,
                    'images_count' => 0,
                    'tags' => ['general', 'contact', 'icon box'],
                ],
                't20-contact-us-section-3' => [
                    'title' => esc_html__('We meticulously select and - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't20-contact-us',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['content', 'contact', 'text', 'google_maps'],
                ],
                't20-contact-us-section-4' => [
                    'title' => esc_html__('For those interested in - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't20-contact-us',
                    'section_number' => 4,
                    'images_count' => 4,
                    'tags' => ['content', 'contact', 'text', 'accordion', 'image'],
                ],
                't20-contact-us-section-5' => [
                    'title' => esc_html__('Whether you\'re seeking a - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't20-contact-us',
                    'section_number' => 5,
                    'images_count' => 2,
                    'tags' => ['cta', 'contact', 'text', 'button'],
                ],
                't20-loving-homes-happy-dogs-section-1' => [
                    'title' => esc_html__('We meticulously select and - Loving Homes Happy Dogs', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't20-loving-homes-happy-dogs',
                    'section_number' => 1,
                    'images_count' => 7,
                    'tags' => ['cta', 'loving', 'homes', 'happy', 'dogs', 'text', 'image', 'text path', 'divider', 'button'],
                ],
                't20-loving-homes-happy-dogs-section-2' => [
                    'title' => esc_html__('We meticulously select and - Loving Homes Happy Dogs', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't20-loving-homes-happy-dogs',
                    'section_number' => 2,
                    'images_count' => 6,
                    'tags' => ['content', 'loving', 'homes', 'happy', 'dogs', 'image', 'text', 'divider', 'image box'],
                ],
                't20-loving-homes-happy-dogs-section-3' => [
                    'title' => esc_html__('We meticulously select and - Loving Homes Happy Dogs', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't20-loving-homes-happy-dogs',
                    'section_number' => 3,
                    'images_count' => 5,
                    'tags' => ['content', 'loving', 'homes', 'happy', 'dogs', 'text', 'image box'],
                ],
                't20-loving-homes-happy-dogs-section-4' => [
                    'title' => esc_html__('Loving Homes Happy Dogs - General Section 4', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't20-loving-homes-happy-dogs',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['general', 'loving', 'homes', 'happy', 'dogs', 'king addons video popup'],
                ],
                't20-loving-homes-happy-dogs-section-5' => [
                    'title' => esc_html__('Our commitment to the - Loving Homes Happy Dogs', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't20-loving-homes-happy-dogs',
                    'section_number' => 5,
                    'images_count' => 5,
                    'tags' => ['cta', 'loving', 'homes', 'happy', 'dogs', 'text', 'image', 'button'],
                ],
                't20-loving-homes-happy-dogs-section-6' => [
                    'title' => esc_html__('We meticulously select and - Loving Homes Happy Dogs', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't20-loving-homes-happy-dogs',
                    'section_number' => 6,
                    'images_count' => 8,
                    'tags' => ['content', 'loving', 'homes', 'happy', 'dogs', 'text', 'king addons card carousel', 'image'],
                ],
                't20-loving-homes-happy-dogs-section-7' => [
                    'title' => esc_html__('Our passion for dogs - Loving Homes Happy Dogs', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't20-loving-homes-happy-dogs',
                    'section_number' => 7,
                    'images_count' => 1,
                    'tags' => ['content', 'loving', 'homes', 'happy', 'dogs', 'text'],
                ],
                't20-loving-homes-happy-dogs-section-8' => [
                    'title' => esc_html__('We meticulously select and - Loving Homes Happy Dogs', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't20-loving-homes-happy-dogs',
                    'section_number' => 8,
                    'images_count' => 8,
                    'tags' => ['content', 'loving', 'homes', 'happy', 'dogs', 'text', 'king addons card carousel'],
                ],
                't20-loving-homes-happy-dogs-section-9' => [
                    'title' => esc_html__('Whether you\'re seeking a - Loving Homes Happy Dogs', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't20-loving-homes-happy-dogs',
                    'section_number' => 9,
                    'images_count' => 2,
                    'tags' => ['cta', 'loving', 'homes', 'happy', 'dogs', 'text', 'button'],
                ],
                't20-our-gallery-section-1' => [
                    'title' => esc_html__('We meticulously select and - Our Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't20-our-gallery',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['content', 'our', 'gallery', 'text'],
                ],
                't20-our-gallery-section-2' => [
                    'title' => esc_html__('Our Gallery - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't20-our-gallery',
                    'section_number' => 2,
                    'images_count' => 15,
                    'tags' => ['general', 'our', 'gallery', 'king addons image grid'],
                ],
                't20-our-gallery-section-3' => [
                    'title' => esc_html__('Whether you\'re seeking a - Our Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't20-our-gallery',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['cta', 'our', 'gallery', 'text', 'button'],
                ],
                't20-our-services-section-1' => [
                    'title' => esc_html__('We meticulously select and - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't20-our-services',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['content', 'our', 'services', 'text'],
                ],
                't20-our-services-section-2' => [
                    'title' => esc_html__('Our Services - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't20-our-services',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['general', 'our', 'services', 'king addons video popup'],
                ],
                't20-our-services-section-3' => [
                    'title' => esc_html__('We meticulously select and - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't20-our-services',
                    'section_number' => 3,
                    'images_count' => 5,
                    'tags' => ['content', 'our', 'services', 'text', 'image box'],
                ],
                't20-our-services-section-4' => [
                    'title' => esc_html__('Our passion for dogs - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't20-our-services',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['content', 'our', 'services', 'text'],
                ],
                't20-our-services-section-5' => [
                    'title' => esc_html__('We meticulously select and - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't20-our-services',
                    'section_number' => 5,
                    'images_count' => 6,
                    'tags' => ['content', 'our', 'services', 'image', 'text', 'divider', 'image box'],
                ],
                't20-our-services-section-6' => [
                    'title' => esc_html__('Whether you\'re seeking a - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't20-our-services',
                    'section_number' => 6,
                    'images_count' => 2,
                    'tags' => ['cta', 'our', 'services', 'text', 'button'],
                ],
                't20-your-dog-your-story-section-1' => [
                    'title' => esc_html__('Whether you\'re seeking a - Your Dog Your Story', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't20-your-dog-your-story',
                    'section_number' => 1,
                    'images_count' => 6,
                    'tags' => ['cta', 'your', 'dog', 'story', 'text', 'button', 'image', 'king addons video popup'],
                ],
                't20-your-dog-your-story-section-2' => [
                    'title' => esc_html__('We meticulously select and - Your Dog Your Story', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't20-your-dog-your-story',
                    'section_number' => 2,
                    'images_count' => 8,
                    'tags' => ['content', 'your', 'dog', 'story', 'text', 'king addons card carousel'],
                ],
                't20-your-dog-your-story-section-3' => [
                    'title' => esc_html__('We meticulously select and - Your Dog Your Story', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't20-your-dog-your-story',
                    'section_number' => 3,
                    'images_count' => 5,
                    'tags' => ['content', 'your', 'dog', 'story', 'text', 'image box'],
                ],
                't20-your-dog-your-story-section-4' => [
                    'title' => esc_html__('Your Dog Your Story - General Section 4', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't20-your-dog-your-story',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['general', 'your', 'dog', 'story', 'king addons video popup'],
                ],
                't20-your-dog-your-story-section-5' => [
                    'title' => esc_html__('Our commitment to the - Your Dog Your Story', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't20-your-dog-your-story',
                    'section_number' => 5,
                    'images_count' => 4,
                    'tags' => ['cta', 'your', 'dog', 'story', 'counter', 'text', 'button', 'image'],
                ],
                't20-your-dog-your-story-section-6' => [
                    'title' => esc_html__('We meticulously select and - Your Dog Your Story', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't20-your-dog-your-story',
                    'section_number' => 6,
                    'images_count' => 8,
                    'tags' => ['content', 'your', 'dog', 'story', 'text', 'king addons card carousel', 'image'],
                ],
                't20-your-dog-your-story-section-7' => [
                    'title' => esc_html__('Our passion for dogs - Your Dog Your Story', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't20-your-dog-your-story',
                    'section_number' => 7,
                    'images_count' => 1,
                    'tags' => ['content', 'your', 'dog', 'story', 'text'],
                ],
                't20-your-dog-your-story-section-8' => [
                    'title' => esc_html__('We meticulously select and - Your Dog Your Story', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't20-your-dog-your-story',
                    'section_number' => 8,
                    'images_count' => 6,
                    'tags' => ['content', 'your', 'dog', 'story', 'image', 'text', 'divider', 'image box'],
                ],
                't20-your-dog-your-story-section-9' => [
                    'title' => esc_html__('Whether you\'re seeking a - Your Dog Your Story', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't20-your-dog-your-story',
                    'section_number' => 9,
                    'images_count' => 1,
                    'tags' => ['cta', 'your', 'dog', 'story', 'text', 'button'],
                ],
                't20-your-furry-friend-section-1' => [
                    'title' => esc_html__('Whether you\'re seeking a - Your Furry Friend', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't20-your-furry-friend',
                    'section_number' => 1,
                    'images_count' => 6,
                    'tags' => ['cta', 'your', 'furry', 'friend', 'image', 'king addons video popup', 'text', 'button'],
                ],
                't20-your-furry-friend-section-2' => [
                    'title' => esc_html__('Our commitment to the - Your Furry Friend', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't20-your-furry-friend',
                    'section_number' => 2,
                    'images_count' => 5,
                    'tags' => ['cta', 'your', 'furry', 'friend', 'text', 'image', 'button'],
                ],
                't20-your-furry-friend-section-3' => [
                    'title' => esc_html__('We meticulously select and - Your Furry Friend', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't20-your-furry-friend',
                    'section_number' => 3,
                    'images_count' => 5,
                    'tags' => ['content', 'your', 'furry', 'friend', 'text', 'image box'],
                ],
                't20-your-furry-friend-section-4' => [
                    'title' => esc_html__('We meticulously select and - Your Furry Friend', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't20-your-furry-friend',
                    'section_number' => 4,
                    'images_count' => 8,
                    'tags' => ['content', 'your', 'furry', 'friend', 'text', 'king addons card carousel'],
                ],
                't20-your-furry-friend-section-5' => [
                    'title' => esc_html__('Our passion for dogs - Your Furry Friend', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't20-your-furry-friend',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['content', 'your', 'furry', 'friend', 'text'],
                ],
                't20-your-furry-friend-section-6' => [
                    'title' => esc_html__('We meticulously select and - Your Furry Friend', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't20-your-furry-friend',
                    'section_number' => 6,
                    'images_count' => 8,
                    'tags' => ['content', 'your', 'furry', 'friend', 'text', 'king addons card carousel', 'image'],
                ],
                't20-your-furry-friend-section-7' => [
                    'title' => esc_html__('Our commitment to the - Your Furry Friend', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't20-your-furry-friend',
                    'section_number' => 7,
                    'images_count' => 4,
                    'tags' => ['cta', 'your', 'furry', 'friend', 'counter', 'text', 'button', 'image'],
                ],
                't20-your-furry-friend-section-8' => [
                    'title' => esc_html__('Whether you\'re seeking a - Your Furry Friend', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't20-your-furry-friend',
                    'section_number' => 8,
                    'images_count' => 2,
                    'tags' => ['cta', 'your', 'furry', 'friend', 'text', 'button'],
                ],
                't20-your-trusted-breeder-section-1' => [
                    'title' => esc_html__('Our commitment to compassionate, - Your Trusted Breeder', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't20-your-trusted-breeder',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['cta', 'your', 'trusted', 'breeder', 'text', 'button'],
                ],
                't20-your-trusted-breeder-section-2' => [
                    'title' => esc_html__('Your Trusted Breeder - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't20-your-trusted-breeder',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['general', 'your', 'trusted', 'breeder', 'king addons video popup'],
                ],
                't20-your-trusted-breeder-section-3' => [
                    'title' => esc_html__('Our commitment to the - Your Trusted Breeder', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't20-your-trusted-breeder',
                    'section_number' => 3,
                    'images_count' => 5,
                    'tags' => ['cta', 'your', 'trusted', 'breeder', 'text', 'image', 'button'],
                ],
                't20-your-trusted-breeder-section-4' => [
                    'title' => esc_html__('We meticulously select and - Your Trusted Breeder', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't20-your-trusted-breeder',
                    'section_number' => 4,
                    'images_count' => 5,
                    'tags' => ['content', 'your', 'trusted', 'breeder', 'text', 'image box'],
                ],
                't20-your-trusted-breeder-section-5' => [
                    'title' => esc_html__('Our passion for dogs - Your Trusted Breeder', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't20-your-trusted-breeder',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['content', 'your', 'trusted', 'breeder', 'text'],
                ],
                't20-your-trusted-breeder-section-6' => [
                    'title' => esc_html__('We meticulously select and - Your Trusted Breeder', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't20-your-trusted-breeder',
                    'section_number' => 6,
                    'images_count' => 8,
                    'tags' => ['content', 'your', 'trusted', 'breeder', 'text', 'king addons card carousel'],
                ],
                't20-your-trusted-breeder-section-7' => [
                    'title' => esc_html__('We meticulously select and - Your Trusted Breeder', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't20-your-trusted-breeder',
                    'section_number' => 7,
                    'images_count' => 8,
                    'tags' => ['content', 'your', 'trusted', 'breeder', 'text', 'king addons card carousel', 'image'],
                ],
                't20-your-trusted-breeder-section-8' => [
                    'title' => esc_html__('We meticulously select and - Your Trusted Breeder', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't20-your-trusted-breeder',
                    'section_number' => 8,
                    'images_count' => 6,
                    'tags' => ['content', 'your', 'trusted', 'breeder', 'image', 'text', 'divider', 'image box'],
                ],
                't20-your-trusted-breeder-section-9' => [
                    'title' => esc_html__('Whether you\'re seeking a - Your Trusted Breeder', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't20-your-trusted-breeder',
                    'section_number' => 9,
                    'images_count' => 1,
                    'tags' => ['cta', 'your', 'trusted', 'breeder', 'text', 'button'],
                ],
                't21-about-our-studio-section-1' => [
                    'title' => esc_html__('Your Journey to a - About Our Studio', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't21-about-our-studio',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['content', 'about', 'our', 'studio', 'text'],
                ],
                't21-about-our-studio-section-2' => [
                    'title' => esc_html__('About Our Studio - Gallery Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'galleries',
                    'section_type' => 'gallery',
                    'parent_template' => 't21-about-our-studio',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['gallery', 'about', 'our', 'studio', 'image'],
                ],
                't21-about-our-studio-section-3' => [
                    'title' => esc_html__('Yoga incorporates mindful breathing - About Our Studio', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't21-about-our-studio',
                    'section_number' => 3,
                    'images_count' => 9,
                    'tags' => ['cta', 'about', 'our', 'studio', 'image', 'text', 'king addons auto scrolling text', 'button'],
                ],
                't21-about-our-studio-section-4' => [
                    'title' => esc_html__('About Our Studio - General Section 4', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't21-about-our-studio',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['general', 'about', 'our', 'studio', 'king addons video popup'],
                ],
                't21-about-our-studio-section-5' => [
                    'title' => esc_html__('Our classes are designed - About Our Studio', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't21-about-our-studio',
                    'section_number' => 5,
                    'images_count' => 7,
                    'tags' => ['header', 'about', 'our', 'studio', 'text', 'image', 'heading'],
                ],
                't21-about-our-studio-section-6' => [
                    'title' => esc_html__('Our classes are designed - About Our Studio', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't21-about-our-studio',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['cta', 'about', 'our', 'studio', 'text', 'button'],
                ],
                't21-contact-us-section-1' => [
                    'title' => esc_html__('Your Journey to a - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't21-contact-us',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['header', 'contact', 'text', 'spacer', 'heading', 'shortcode'],
                ],
                't21-contact-us-section-2' => [
                    'title' => esc_html__('Contact Us - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't21-contact-us',
                    'section_number' => 2,
                    'images_count' => 0,
                    'tags' => ['general', 'contact', 'icon box'],
                ],
                't21-contact-us-section-3' => [
                    'title' => esc_html__('Our classes are designed - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't21-contact-us',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['content', 'contact', 'text', 'google_maps'],
                ],
                't21-contact-us-section-4' => [
                    'title' => esc_html__('Our classes are designed - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't21-contact-us',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['cta', 'contact', 'text', 'button'],
                ],
                't21-our-services-section-1' => [
                    'title' => esc_html__('Start Your Journey to - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't21-our-services',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['content', 'our', 'services', 'text'],
                ],
                't21-our-services-section-2' => [
                    'title' => esc_html__('Our Services - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't21-our-services',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['general', 'our', 'services', 'king addons video popup'],
                ],
                't21-our-services-section-3' => [
                    'title' => esc_html__('Our classes are designed - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't21-our-services',
                    'section_number' => 3,
                    'images_count' => 9,
                    'tags' => ['content', 'our', 'services', 'text', 'king addons video popup'],
                ],
                't21-our-services-section-4' => [
                    'title' => esc_html__('Our classes are designed - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't21-our-services',
                    'section_number' => 4,
                    'images_count' => 6,
                    'tags' => ['content', 'our', 'services', 'text', 'image box', 'image'],
                ],
                't21-our-services-section-5' => [
                    'title' => esc_html__('Yoga incorporates mindful breathing - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't21-our-services',
                    'section_number' => 5,
                    'images_count' => 5,
                    'tags' => ['cta', 'our', 'services', 'text', 'button', 'image'],
                ],
                't21-our-services-section-6' => [
                    'title' => esc_html__('Our classes are designed - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't21-our-services',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['cta', 'our', 'services', 'text', 'button'],
                ],
                't21-our-teachers-section-1' => [
                    'title' => esc_html__('Where Mindfulness Meets Movement - Our Teachers', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't21-our-teachers',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['content', 'our', 'teachers', 'text'],
                ],
                't21-our-teachers-section-2' => [
                    'title' => esc_html__('Our Teachers - Gallery Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'galleries',
                    'section_type' => 'gallery',
                    'parent_template' => 't21-our-teachers',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['gallery', 'our', 'teachers', 'image'],
                ],
                't21-our-teachers-section-3' => [
                    'title' => esc_html__('Our classes are designed - Our Teachers', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't21-our-teachers',
                    'section_number' => 3,
                    'images_count' => 13,
                    'tags' => ['header', 'our', 'teachers', 'text', 'image', 'heading'],
                ],
                't21-our-teachers-section-4' => [
                    'title' => esc_html__('Our classes are designed - Our Teachers', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't21-our-teachers',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['cta', 'our', 'teachers', 'text', 'button'],
                ],
                't21-prices-section-1' => [
                    'title' => esc_html__('Revitalize Your Life with - Prices', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't21-prices',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['content', 'prices', 'text'],
                ],
                't21-prices-section-2' => [
                    'title' => esc_html__('Prices - Gallery Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'galleries',
                    'section_type' => 'gallery',
                    'parent_template' => 't21-prices',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['gallery', 'prices', 'image'],
                ],
                't21-prices-section-3' => [
                    'title' => esc_html__('Kundalini Yoga
 - Prices', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't21-prices',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['content', 'prices', 'text', 'king addons price list'],
                ],
                't21-prices-section-4' => [
                    'title' => esc_html__('Our classes are designed - Prices', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't21-prices',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['cta', 'prices', 'text', 'button'],
                ],
                't21-the-power-of-yoga-section-1' => [
                    'title' => esc_html__('Our classes are designed - The Power Of Yoga', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't21-the-power-of-yoga',
                    'section_number' => 1,
                    'images_count' => 8,
                    'tags' => ['cta', 'the', 'power', 'yoga', 'image', 'king addons video popup', 'text', 'button', 'image box'],
                ],
                't21-the-power-of-yoga-section-2' => [
                    'title' => esc_html__('The Power Of Yoga - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't21-the-power-of-yoga',
                    'section_number' => 2,
                    'images_count' => 7,
                    'tags' => ['general', 'the', 'power', 'yoga', 'image carousel'],
                ],
                't21-the-power-of-yoga-section-3' => [
                    'title' => esc_html__('Our classes are designed - The Power Of Yoga', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't21-the-power-of-yoga',
                    'section_number' => 3,
                    'images_count' => 9,
                    'tags' => ['content', 'the', 'power', 'yoga', 'text', 'king addons video popup'],
                ],
                't21-the-power-of-yoga-section-4' => [
                    'title' => esc_html__('Our classes are designed - The Power Of Yoga', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't21-the-power-of-yoga',
                    'section_number' => 4,
                    'images_count' => 6,
                    'tags' => ['content', 'the', 'power', 'yoga', 'text', 'image box', 'image'],
                ],
                't21-the-power-of-yoga-section-5' => [
                    'title' => esc_html__('Yoga incorporates mindful breathing - The Power Of Yoga', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't21-the-power-of-yoga',
                    'section_number' => 5,
                    'images_count' => 4,
                    'tags' => ['cta', 'the', 'power', 'yoga', 'image', 'text', 'icon list', 'button'],
                ],
                't21-the-power-of-yoga-section-6' => [
                    'title' => esc_html__('The Power Of Yoga - General Section 6', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't21-the-power-of-yoga',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['general', 'the', 'power', 'yoga', 'king addons video popup'],
                ],
                't21-the-power-of-yoga-section-7' => [
                    'title' => esc_html__('Whether you\'re a beginner - The Power Of Yoga', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't21-the-power-of-yoga',
                    'section_number' => 7,
                    'images_count' => 8,
                    'tags' => ['cta', 'the', 'power', 'yoga', 'text', 'image', 'button', 'king addons auto scrolling text'],
                ],
                't21-the-power-of-yoga-section-8' => [
                    'title' => esc_html__('Our classes are designed - The Power Of Yoga', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't21-the-power-of-yoga',
                    'section_number' => 8,
                    'images_count' => 8,
                    'tags' => ['content', 'the', 'power', 'yoga', 'text', 'king addons card carousel', 'image'],
                ],
                't21-the-power-of-yoga-section-9' => [
                    'title' => esc_html__('Whether you\'re a beginner - The Power Of Yoga', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't21-the-power-of-yoga',
                    'section_number' => 9,
                    'images_count' => 3,
                    'tags' => ['cta', 'the', 'power', 'yoga', 'text', 'button', 'image'],
                ],
                't21-yoga-classes-section-1' => [
                    'title' => esc_html__('Our classes are designed - Yoga Classes', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't21-yoga-classes',
                    'section_number' => 1,
                    'images_count' => 5,
                    'tags' => ['cta', 'yoga', 'classes', 'text', 'button', 'image', 'image box', 'king addons video popup'],
                ],
                't21-yoga-classes-section-2' => [
                    'title' => esc_html__('Yoga Classes - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't21-yoga-classes',
                    'section_number' => 2,
                    'images_count' => 7,
                    'tags' => ['general', 'yoga', 'classes', 'image carousel'],
                ],
                't21-yoga-classes-section-3' => [
                    'title' => esc_html__('Whether you\'re a beginner - Yoga Classes', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't21-yoga-classes',
                    'section_number' => 3,
                    'images_count' => 8,
                    'tags' => ['cta', 'yoga', 'classes', 'text', 'image', 'button', 'king addons auto scrolling text'],
                ],
                't21-yoga-classes-section-4' => [
                    'title' => esc_html__('Our classes are designed - Yoga Classes', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't21-yoga-classes',
                    'section_number' => 4,
                    'images_count' => 6,
                    'tags' => ['content', 'yoga', 'classes', 'text', 'image box', 'image'],
                ],
                't21-yoga-classes-section-5' => [
                    'title' => esc_html__('Yoga incorporates mindful breathing - Yoga Classes', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't21-yoga-classes',
                    'section_number' => 5,
                    'images_count' => 4,
                    'tags' => ['cta', 'yoga', 'classes', 'image', 'text', 'icon list', 'button'],
                ],
                't21-yoga-classes-section-6' => [
                    'title' => esc_html__('Yoga Classes - General Section 6', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't21-yoga-classes',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['general', 'yoga', 'classes', 'king addons video popup'],
                ],
                't21-yoga-classes-section-7' => [
                    'title' => esc_html__('Our classes are designed - Yoga Classes', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't21-yoga-classes',
                    'section_number' => 7,
                    'images_count' => 9,
                    'tags' => ['content', 'yoga', 'classes', 'text', 'king addons video popup'],
                ],
                't21-yoga-classes-section-8' => [
                    'title' => esc_html__('Our classes are designed - Yoga Classes', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't21-yoga-classes',
                    'section_number' => 8,
                    'images_count' => 8,
                    'tags' => ['content', 'yoga', 'classes', 'text', 'king addons card carousel', 'image'],
                ],
                't21-yoga-classes-section-9' => [
                    'title' => esc_html__('Whether you\'re a beginner - Yoga Classes', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't21-yoga-classes',
                    'section_number' => 9,
                    'images_count' => 3,
                    'tags' => ['cta', 'yoga', 'classes', 'text', 'button', 'image'],
                ],
                't21-yoga-practice-section-1' => [
                    'title' => esc_html__('Our classes are designed - Yoga Practice', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't21-yoga-practice',
                    'section_number' => 1,
                    'images_count' => 15,
                    'tags' => ['hero', 'yoga', 'practice', 'text', 'image', 'heading', 'text path', 'button', 'king addons video popup', 'icon box', 'divider', 'image carousel'],
                ],
                't21-yoga-practice-section-2' => [
                    'title' => esc_html__('Our classes are designed - Yoga Practice', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't21-yoga-practice',
                    'section_number' => 2,
                    'images_count' => 6,
                    'tags' => ['content', 'yoga', 'practice', 'text', 'image box', 'image'],
                ],
                't21-yoga-practice-section-3' => [
                    'title' => esc_html__('Yoga incorporates mindful breathing - Yoga Practice', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't21-yoga-practice',
                    'section_number' => 3,
                    'images_count' => 8,
                    'tags' => ['cta', 'yoga', 'practice', 'image', 'text', 'icon list', 'king addons auto scrolling text', 'button'],
                ],
                't21-yoga-practice-section-4' => [
                    'title' => esc_html__('Yoga Practice - General Section 4', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't21-yoga-practice',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['general', 'yoga', 'practice', 'king addons video popup'],
                ],
                't21-yoga-practice-section-5' => [
                    'title' => esc_html__('Our classes are designed - Yoga Practice', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't21-yoga-practice',
                    'section_number' => 5,
                    'images_count' => 7,
                    'tags' => ['header', 'yoga', 'practice', 'text', 'image', 'heading'],
                ],
                't21-yoga-practice-section-6' => [
                    'title' => esc_html__('Our classes are designed - Yoga Practice', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't21-yoga-practice',
                    'section_number' => 6,
                    'images_count' => 8,
                    'tags' => ['content', 'yoga', 'practice', 'text', 'king addons card carousel', 'image'],
                ],
                't21-yoga-practice-section-7' => [
                    'title' => esc_html__('Yoga incorporates mindful breathing - Yoga Practice', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't21-yoga-practice',
                    'section_number' => 7,
                    'images_count' => 5,
                    'tags' => ['cta', 'yoga', 'practice', 'text', 'button', 'image'],
                ],
                't21-yoga-practice-section-8' => [
                    'title' => esc_html__('Our classes are designed - Yoga Practice', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't21-yoga-practice',
                    'section_number' => 8,
                    'images_count' => 1,
                    'tags' => ['cta', 'yoga', 'practice', 'text', 'button'],
                ],
                't21-yoga-studio-section-1' => [
                    'title' => esc_html__('Let us be your - Yoga Studio', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't21-yoga-studio',
                    'section_number' => 1,
                    'images_count' => 4,
                    'tags' => ['hero', 'yoga', 'studio', 'image', 'text path', 'text', 'button', 'heading'],
                ],
                't21-yoga-studio-section-2' => [
                    'title' => esc_html__('Yoga Studio - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't21-yoga-studio',
                    'section_number' => 2,
                    'images_count' => 7,
                    'tags' => ['general', 'yoga', 'studio', 'image carousel'],
                ],
                't21-yoga-studio-section-3' => [
                    'title' => esc_html__('Yoga incorporates mindful breathing - Yoga Studio', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't21-yoga-studio',
                    'section_number' => 3,
                    'images_count' => 8,
                    'tags' => ['cta', 'yoga', 'studio', 'image', 'text', 'icon list', 'king addons auto scrolling text', 'button'],
                ],
                't21-yoga-studio-section-4' => [
                    'title' => esc_html__('Yoga Studio - General Section 4', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't21-yoga-studio',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['general', 'yoga', 'studio', 'king addons video popup'],
                ],
                't21-yoga-studio-section-5' => [
                    'title' => esc_html__('Our classes are designed - Yoga Studio', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't21-yoga-studio',
                    'section_number' => 5,
                    'images_count' => 6,
                    'tags' => ['content', 'yoga', 'studio', 'text', 'image box', 'image'],
                ],
                't21-yoga-studio-section-6' => [
                    'title' => esc_html__('Our classes are designed - Yoga Studio', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't21-yoga-studio',
                    'section_number' => 6,
                    'images_count' => 9,
                    'tags' => ['content', 'yoga', 'studio', 'text', 'king addons video popup'],
                ],
                't21-yoga-studio-section-7' => [
                    'title' => esc_html__('Our classes are designed - Yoga Studio', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't21-yoga-studio',
                    'section_number' => 7,
                    'images_count' => 8,
                    'tags' => ['content', 'yoga', 'studio', 'text', 'king addons card carousel', 'image'],
                ],
                't21-yoga-studio-section-8' => [
                    'title' => esc_html__('Our classes are designed - Yoga Studio', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't21-yoga-studio',
                    'section_number' => 8,
                    'images_count' => 7,
                    'tags' => ['header', 'yoga', 'studio', 'text', 'image', 'heading'],
                ],
                't21-yoga-studio-section-9' => [
                    'title' => esc_html__('Our classes are designed - Yoga Studio', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't21-yoga-studio',
                    'section_number' => 9,
                    'images_count' => 1,
                    'tags' => ['cta', 'yoga', 'studio', 'text', 'button'],
                ],
                't22-about-us-section-1' => [
                    'title' => esc_html__('Unparalleled Auto and Tire - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't22-about-us',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['content', 'about', 'text'],
                ],
                't22-about-us-section-2' => [
                    'title' => esc_html__('About Us - Gallery Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'galleries',
                    'section_type' => 'gallery',
                    'parent_template' => 't22-about-us',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['gallery', 'about', 'image'],
                ],
                't22-about-us-section-3' => [
                    'title' => esc_html__('Our skilled technicians are - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't22-about-us',
                    'section_number' => 3,
                    'images_count' => 6,
                    'tags' => ['cta', 'about', 'image', 'text', 'button'],
                ],
                't22-about-us-section-4' => [
                    'title' => esc_html__('About Us - General Section 4', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't22-about-us',
                    'section_number' => 4,
                    'images_count' => 9,
                    'tags' => ['general', 'about', 'king addons image grid'],
                ],
                't22-about-us-section-5' => [
                    'title' => esc_html__(' Our commitment to - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't22-about-us',
                    'section_number' => 5,
                    'images_count' => 3,
                    'tags' => ['cta', 'about', 'text', 'button'],
                ],
                't22-contact-us-section-1' => [
                    'title' => esc_html__('Please feel free to - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't22-contact-us',
                    'section_number' => 1,
                    'images_count' => 7,
                    'tags' => ['header', 'contact', 'text', 'heading', 'shortcode', 'spacer'],
                ],
                't22-contact-us-section-2' => [
                    'title' => esc_html__('Contact Us - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't22-contact-us',
                    'section_number' => 2,
                    'images_count' => 0,
                    'tags' => ['general', 'contact', 'icon box'],
                ],
                't22-contact-us-section-3' => [
                    'title' => esc_html__('Our skilled technicians are - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't22-contact-us',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['header', 'contact', 'text', 'heading', 'google_maps'],
                ],
                't22-contact-us-section-4' => [
                    'title' => esc_html__(' Our commitment to - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't22-contact-us',
                    'section_number' => 4,
                    'images_count' => 3,
                    'tags' => ['cta', 'contact', 'text', 'button'],
                ],
                't22-expert-auto-service-section-1' => [
                    'title' => esc_html__('Our skilled technicians are - Expert Auto Service', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't22-expert-auto-service',
                    'section_number' => 1,
                    'images_count' => 5,
                    'tags' => ['cta', 'expert', 'auto', 'service', 'text', 'button', 'king addons video popup'],
                ],
                't22-expert-auto-service-section-2' => [
                    'title' => esc_html__('Our skilled technicians are - Expert Auto Service', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't22-expert-auto-service',
                    'section_number' => 2,
                    'images_count' => 6,
                    'tags' => ['cta', 'expert', 'auto', 'service', 'image', 'text', 'button'],
                ],
                't22-expert-auto-service-section-3' => [
                    'title' => esc_html__('Expert Auto Service - General Section 3', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't22-expert-auto-service',
                    'section_number' => 3,
                    'images_count' => 6,
                    'tags' => ['general', 'expert', 'auto', 'service', 'king addons auto scrolling text'],
                ],
                't22-expert-auto-service-section-4' => [
                    'title' => esc_html__('We believe that quality - Expert Auto Service', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't22-expert-auto-service',
                    'section_number' => 4,
                    'images_count' => 3,
                    'tags' => ['header', 'expert', 'auto', 'service', 'text', 'counter', 'heading'],
                ],
                't22-expert-auto-service-section-5' => [
                    'title' => esc_html__('We specialize in a - Expert Auto Service', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't22-expert-auto-service',
                    'section_number' => 5,
                    'images_count' => 8,
                    'tags' => ['content', 'expert', 'auto', 'service', 'text', 'image'],
                ],
                't22-expert-auto-service-section-6' => [
                    'title' => esc_html__('Demystifying Auto Repairs and - Expert Auto Service', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't22-expert-auto-service',
                    'section_number' => 6,
                    'images_count' => 2,
                    'tags' => ['content', 'expert', 'auto', 'service', 'text', 'king addons blog posts'],
                ],
                't22-expert-auto-service-section-7' => [
                    'title' => esc_html__('We\'ll have you back - Expert Auto Service', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't22-expert-auto-service',
                    'section_number' => 7,
                    'images_count' => 7,
                    'tags' => ['content', 'expert', 'auto', 'service', 'text', 'image', 'king addons card carousel'],
                ],
                't22-expert-auto-service-section-8' => [
                    'title' => esc_html__('Our commitment to quality - Expert Auto Service', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't22-expert-auto-service',
                    'section_number' => 8,
                    'images_count' => 1,
                    'tags' => ['cta', 'expert', 'auto', 'service', 'text', 'button'],
                ],
                't22-look-at-our-work-section-1' => [
                    'title' => esc_html__('Your One-Stop Destination for - Look At Our Work', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't22-look-at-our-work',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['content', 'look', 'our', 'work', 'text'],
                ],
                't22-look-at-our-work-section-2' => [
                    'title' => esc_html__('Look At Our Work - Gallery Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'galleries',
                    'section_type' => 'gallery',
                    'parent_template' => 't22-look-at-our-work',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['gallery', 'look', 'our', 'work', 'image'],
                ],
                't22-look-at-our-work-section-3' => [
                    'title' => esc_html__('Join the satisfied customers - Look At Our Work', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't22-look-at-our-work',
                    'section_number' => 3,
                    'images_count' => 10,
                    'tags' => ['content', 'look', 'our', 'work', 'text', 'king addons image grid'],
                ],
                't22-look-at-our-work-section-4' => [
                    'title' => esc_html__('Our commitment to quality - Look At Our Work', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't22-look-at-our-work',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['cta', 'look', 'our', 'work', 'text', 'button'],
                ],
                't22-our-services-section-1' => [
                    'title' => esc_html__('Your Vehicle Deserves the - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't22-our-services',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['content', 'our', 'services', 'text'],
                ],
                't22-our-services-section-2' => [
                    'title' => esc_html__('Our Services - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't22-our-services',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['general', 'our', 'services', 'king addons video popup'],
                ],
                't22-our-services-section-3' => [
                    'title' => esc_html__('Our skilled technicians are - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't22-our-services',
                    'section_number' => 3,
                    'images_count' => 10,
                    'tags' => ['cta', 'our', 'services', 'text', 'image', 'button'],
                ],
                't22-our-services-section-4' => [
                    'title' => esc_html__('Our Services - General Section 4', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't22-our-services',
                    'section_number' => 4,
                    'images_count' => 6,
                    'tags' => ['general', 'our', 'services', 'king addons auto scrolling text'],
                ],
                't22-our-services-section-5' => [
                    'title' => esc_html__('Our commitment to quality - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't22-our-services',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['cta', 'our', 'services', 'text', 'button'],
                ],
                't22-revitalize-your-vehicle-section-1' => [
                    'title' => esc_html__(' Our commitment to - Revitalize Your Vehicle', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't22-revitalize-your-vehicle',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['cta', 'revitalize', 'your', 'vehicle', 'text', 'button', 'king addons video popup'],
                ],
                't22-revitalize-your-vehicle-section-2' => [
                    'title' => esc_html__('Our skilled technicians are - Revitalize Your Vehicle', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't22-revitalize-your-vehicle',
                    'section_number' => 2,
                    'images_count' => 10,
                    'tags' => ['cta', 'revitalize', 'your', 'vehicle', 'image', 'text', 'button'],
                ],
                't22-revitalize-your-vehicle-section-3' => [
                    'title' => esc_html__('Revitalize Your Vehicle - General Section 3', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't22-revitalize-your-vehicle',
                    'section_number' => 3,
                    'images_count' => 6,
                    'tags' => ['general', 'revitalize', 'your', 'vehicle', 'king addons auto scrolling text'],
                ],
                't22-revitalize-your-vehicle-section-4' => [
                    'title' => esc_html__('We believe that quality - Revitalize Your Vehicle', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't22-revitalize-your-vehicle',
                    'section_number' => 4,
                    'images_count' => 3,
                    'tags' => ['header', 'revitalize', 'your', 'vehicle', 'text', 'counter', 'heading'],
                ],
                't22-revitalize-your-vehicle-section-5' => [
                    'title' => esc_html__('We\'ll have you back - Revitalize Your Vehicle', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't22-revitalize-your-vehicle',
                    'section_number' => 5,
                    'images_count' => 16,
                    'tags' => ['content', 'revitalize', 'your', 'vehicle', 'text', 'image', 'king addons card carousel', 'king addons image grid'],
                ],
                't22-revitalize-your-vehicle-section-6' => [
                    'title' => esc_html__('Demystifying Auto Repairs and - Revitalize Your Vehicle', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't22-revitalize-your-vehicle',
                    'section_number' => 6,
                    'images_count' => 2,
                    'tags' => ['content', 'revitalize', 'your', 'vehicle', 'text', 'king addons blog posts'],
                ],
                't22-revitalize-your-vehicle-section-7' => [
                    'title' => esc_html__('Our commitment to quality - Revitalize Your Vehicle', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't22-revitalize-your-vehicle',
                    'section_number' => 7,
                    'images_count' => 1,
                    'tags' => ['cta', 'revitalize', 'your', 'vehicle', 'text', 'button'],
                ],
                't22-revitalize-your-vehicle-section-8' => [
                    'title' => esc_html__('Revitalize Your Vehicle - General Section 8', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't22-revitalize-your-vehicle',
                    'section_number' => 8,
                    'images_count' => 0,
                    'tags' => ['general', 'revitalize', 'your', 'vehicle', 'google_maps'],
                ],
                't22-top-tier-auto-service-section-1' => [
                    'title' => esc_html__(' Our commitment to - Top Tier Auto Service', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't22-top-tier-auto-service',
                    'section_number' => 1,
                    'images_count' => 4,
                    'tags' => ['hero', 'top', 'tier', 'auto', 'service', 'text', 'button', 'heading', 'image', 'text path'],
                ],
                't22-top-tier-auto-service-section-2' => [
                    'title' => esc_html__('Our skilled technicians are - Top Tier Auto Service', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't22-top-tier-auto-service',
                    'section_number' => 2,
                    'images_count' => 12,
                    'tags' => ['cta', 'top', 'tier', 'auto', 'service', 'text', 'image', 'button'],
                ],
                't22-top-tier-auto-service-section-3' => [
                    'title' => esc_html__('Top Tier Auto Service - General Section 3', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't22-top-tier-auto-service',
                    'section_number' => 3,
                    'images_count' => 6,
                    'tags' => ['general', 'top', 'tier', 'auto', 'service', 'king addons auto scrolling text'],
                ],
                't22-top-tier-auto-service-section-4' => [
                    'title' => esc_html__('We believe that quality - Top Tier Auto Service', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't22-top-tier-auto-service',
                    'section_number' => 4,
                    'images_count' => 3,
                    'tags' => ['header', 'top', 'tier', 'auto', 'service', 'text', 'counter', 'heading'],
                ],
                't22-top-tier-auto-service-section-5' => [
                    'title' => esc_html__('Our skilled technicians are - Top Tier Auto Service', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't22-top-tier-auto-service',
                    'section_number' => 5,
                    'images_count' => 18,
                    'tags' => ['cta', 'top', 'tier', 'auto', 'service', 'text', 'image', 'king addons card carousel', 'king addons image grid', 'button'],
                ],
                't22-top-tier-auto-service-section-6' => [
                    'title' => esc_html__(' Our commitment to - Top Tier Auto Service', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't22-top-tier-auto-service',
                    'section_number' => 6,
                    'images_count' => 3,
                    'tags' => ['cta', 'top', 'tier', 'auto', 'service', 'text', 'button'],
                ],
                't22-unmatched-auto-service-section-1' => [
                    'title' => esc_html__('Our skilled technicians are - Unmatched Auto Service', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't22-unmatched-auto-service',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['cta', 'unmatched', 'auto', 'service', 'text', 'button', 'king addons video popup'],
                ],
                't22-unmatched-auto-service-section-2' => [
                    'title' => esc_html__('We believe that quality - Unmatched Auto Service', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't22-unmatched-auto-service',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['header', 'unmatched', 'auto', 'service', 'text', 'counter', 'heading'],
                ],
                't22-unmatched-auto-service-section-3' => [
                    'title' => esc_html__('We specialize in a - Unmatched Auto Service', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't22-unmatched-auto-service',
                    'section_number' => 3,
                    'images_count' => 8,
                    'tags' => ['content', 'unmatched', 'auto', 'service', 'text', 'image'],
                ],
                't22-unmatched-auto-service-section-4' => [
                    'title' => esc_html__('Unmatched Auto Service - General Section 4', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't22-unmatched-auto-service',
                    'section_number' => 4,
                    'images_count' => 6,
                    'tags' => ['general', 'unmatched', 'auto', 'service', 'king addons auto scrolling text'],
                ],
                't22-unmatched-auto-service-section-5' => [
                    'title' => esc_html__('Our commitment to quality - Unmatched Auto Service', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't22-unmatched-auto-service',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['cta', 'unmatched', 'auto', 'service', 'text', 'button'],
                ],
                't22-unmatched-auto-service-section-6' => [
                    'title' => esc_html__('Our skilled technicians are - Unmatched Auto Service', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't22-unmatched-auto-service',
                    'section_number' => 6,
                    'images_count' => 6,
                    'tags' => ['cta', 'unmatched', 'auto', 'service', 'image', 'text', 'button'],
                ],
                't22-unmatched-auto-service-section-7' => [
                    'title' => esc_html__('Demystifying Auto Repairs and - Unmatched Auto Service', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't22-unmatched-auto-service',
                    'section_number' => 7,
                    'images_count' => 2,
                    'tags' => ['content', 'unmatched', 'auto', 'service', 'text', 'king addons blog posts'],
                ],
                't22-unmatched-auto-service-section-8' => [
                    'title' => esc_html__('We\'ll have you back - Unmatched Auto Service', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't22-unmatched-auto-service',
                    'section_number' => 8,
                    'images_count' => 7,
                    'tags' => ['content', 'unmatched', 'auto', 'service', 'text', 'image', 'king addons card carousel'],
                ],
                't22-unmatched-auto-service-section-9' => [
                    'title' => esc_html__(' Our commitment to - Unmatched Auto Service', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't22-unmatched-auto-service',
                    'section_number' => 9,
                    'images_count' => 3,
                    'tags' => ['cta', 'unmatched', 'auto', 'service', 'text', 'button'],
                ],
                't23-contact-us-section-1' => [
                    'title' => esc_html__('Whether you\'re a seasoned - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't23-contact-us',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['header', 'contact', 'text', 'spacer', 'heading', 'shortcode'],
                ],
                't23-contact-us-section-2' => [
                    'title' => esc_html__('Contact Us - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't23-contact-us',
                    'section_number' => 2,
                    'images_count' => 0,
                    'tags' => ['general', 'contact', 'icon box'],
                ],
                't23-contact-us-section-3' => [
                    'title' => esc_html__('Whether you\'re a seasoned - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't23-contact-us',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['content', 'contact', 'text', 'google_maps'],
                ],
                't23-contact-us-section-4' => [
                    'title' => esc_html__('With well-cared-for horses and - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't23-contact-us',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['cta', 'contact', 'text', 'button'],
                ],
                't23-equestrian-enthusiasts-section-1' => [
                    'title' => esc_html__('Whether you\'re a seasoned - Equestrian Enthusiasts', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't23-equestrian-enthusiasts',
                    'section_number' => 1,
                    'images_count' => 5,
                    'tags' => ['content', 'equestrian', 'enthusiasts', 'text', 'image', 'text path', 'ucaddon_blox_play_button', 'icon box'],
                ],
                't23-equestrian-enthusiasts-section-2' => [
                    'title' => esc_html__('This pass includes two - Equestrian Enthusiasts', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't23-equestrian-enthusiasts',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['cta', 'equestrian', 'enthusiasts', 'text', 'image', 'button'],
                ],
                't23-equestrian-enthusiasts-section-3' => [
                    'title' => esc_html__(' With well-cared-for horses - Equestrian Enthusiasts', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't23-equestrian-enthusiasts',
                    'section_number' => 3,
                    'images_count' => 7,
                    'tags' => ['content', 'equestrian', 'enthusiasts', 'text', 'image box', 'image'],
                ],
                't23-equestrian-enthusiasts-section-4' => [
                    'title' => esc_html__('Whether you\'re looking to - Equestrian Enthusiasts', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't23-equestrian-enthusiasts',
                    'section_number' => 4,
                    'images_count' => 3,
                    'tags' => ['cta', 'equestrian', 'enthusiasts', 'image', 'text', 'button'],
                ],
                't23-equestrian-enthusiasts-section-5' => [
                    'title' => esc_html__('With well-cared-for horses and - Equestrian Enthusiasts', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't23-equestrian-enthusiasts',
                    'section_number' => 5,
                    'images_count' => 4,
                    'tags' => ['header', 'equestrian', 'enthusiasts', 'text', 'image', 'heading'],
                ],
                't23-equestrian-enthusiasts-section-6' => [
                    'title' => esc_html__('Whether you\'re looking to - Equestrian Enthusiasts', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't23-equestrian-enthusiasts',
                    'section_number' => 6,
                    'images_count' => 3,
                    'tags' => ['cta', 'equestrian', 'enthusiasts', 'image', 'counter', 'text', 'button'],
                ],
                't23-equestrian-enthusiasts-section-7' => [
                    'title' => esc_html__('With well-cared-for horses and - Equestrian Enthusiasts', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't23-equestrian-enthusiasts',
                    'section_number' => 7,
                    'images_count' => 1,
                    'tags' => ['content', 'equestrian', 'enthusiasts', 'text'],
                ],
                't23-equestrian-enthusiasts-section-8' => [
                    'title' => esc_html__('Unite with Horse Lovers - Equestrian Enthusiasts', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't23-equestrian-enthusiasts',
                    'section_number' => 8,
                    'images_count' => 2,
                    'tags' => ['content', 'equestrian', 'enthusiasts', 'text', 'king addons blog posts'],
                ],
                't23-equestrian-enthusiasts-section-9' => [
                    'title' => esc_html__('With well-cared-for horses and - Equestrian Enthusiasts', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't23-equestrian-enthusiasts',
                    'section_number' => 9,
                    'images_count' => 1,
                    'tags' => ['cta', 'equestrian', 'enthusiasts', 'text', 'button'],
                ],
                't23-horse-riding-club-section-1' => [
                    'title' => esc_html__('At our horse riding - Horse Riding Club', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't23-horse-riding-club',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['cta', 'horse', 'riding', 'club', 'text', 'button'],
                ],
                't23-horse-riding-club-section-2' => [
                    'title' => esc_html__('Whether you\'re looking to - Horse Riding Club', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't23-horse-riding-club',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['cta', 'horse', 'riding', 'club', 'image', 'counter', 'text', 'button'],
                ],
                't23-horse-riding-club-section-3' => [
                    'title' => esc_html__(' With well-cared-for horses - Horse Riding Club', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't23-horse-riding-club',
                    'section_number' => 3,
                    'images_count' => 7,
                    'tags' => ['content', 'horse', 'riding', 'club', 'text', 'image box', 'image'],
                ],
                't23-horse-riding-club-section-4' => [
                    'title' => esc_html__('Whether you\'re looking to - Horse Riding Club', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't23-horse-riding-club',
                    'section_number' => 4,
                    'images_count' => 3,
                    'tags' => ['cta', 'horse', 'riding', 'club', 'image', 'text', 'button'],
                ],
                't23-horse-riding-club-section-5' => [
                    'title' => esc_html__('With well-cared-for horses and - Horse Riding Club', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't23-horse-riding-club',
                    'section_number' => 5,
                    'images_count' => 4,
                    'tags' => ['header', 'horse', 'riding', 'club', 'text', 'image', 'heading'],
                ],
                't23-horse-riding-club-section-6' => [
                    'title' => esc_html__('With well-cared-for horses and - Horse Riding Club', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't23-horse-riding-club',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['content', 'horse', 'riding', 'club', 'text'],
                ],
                't23-horse-riding-club-section-7' => [
                    'title' => esc_html__('Whether you\'re a seasoned - Horse Riding Club', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't23-horse-riding-club',
                    'section_number' => 7,
                    'images_count' => 2,
                    'tags' => ['content', 'horse', 'riding', 'club', 'text', 'accordion', 'image'],
                ],
                't23-horse-riding-club-section-8' => [
                    'title' => esc_html__('This pass includes two - Horse Riding Club', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't23-horse-riding-club',
                    'section_number' => 8,
                    'images_count' => 3,
                    'tags' => ['cta', 'horse', 'riding', 'club', 'text', 'image', 'button'],
                ],
                't23-horse-riding-club-section-9' => [
                    'title' => esc_html__('With well-cared-for horses and - Horse Riding Club', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't23-horse-riding-club',
                    'section_number' => 9,
                    'images_count' => 1,
                    'tags' => ['cta', 'horse', 'riding', 'club', 'text', 'button'],
                ],
                't23-our-gallery-section-1' => [
                    'title' => esc_html__('Whether you\'re a seasoned - Our Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't23-our-gallery',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['content', 'our', 'gallery', 'text'],
                ],
                't23-our-gallery-section-2' => [
                    'title' => esc_html__('Our Gallery - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't23-our-gallery',
                    'section_number' => 2,
                    'images_count' => 12,
                    'tags' => ['general', 'our', 'gallery', 'king addons image grid'],
                ],
                't23-our-gallery-section-3' => [
                    'title' => esc_html__('With well-cared-for horses and - Our Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't23-our-gallery',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['cta', 'our', 'gallery', 'text', 'button'],
                ],
                't23-our-services-section-1' => [
                    'title' => esc_html__('Whether you\'re a seasoned - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't23-our-services',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['content', 'our', 'services', 'text'],
                ],
                't23-our-services-section-2' => [
                    'title' => esc_html__('Our Services - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't23-our-services',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['general', 'our', 'services', 'king addons video popup'],
                ],
                't23-our-services-section-3' => [
                    'title' => esc_html__('Whether you\'re looking to - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't23-our-services',
                    'section_number' => 3,
                    'images_count' => 3,
                    'tags' => ['cta', 'our', 'services', 'image', 'counter', 'text', 'button'],
                ],
                't23-our-services-section-4' => [
                    'title' => esc_html__(' With well-cared-for horses - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't23-our-services',
                    'section_number' => 4,
                    'images_count' => 7,
                    'tags' => ['content', 'our', 'services', 'text', 'image box', 'image'],
                ],
                't23-our-services-section-5' => [
                    'title' => esc_html__('This pass includes two - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't23-our-services',
                    'section_number' => 5,
                    'images_count' => 3,
                    'tags' => ['cta', 'our', 'services', 'text', 'image', 'button'],
                ],
                't23-our-services-section-6' => [
                    'title' => esc_html__('With well-cared-for horses and - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't23-our-services',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['cta', 'our', 'services', 'text', 'button'],
                ],
                't23-our-team-section-1' => [
                    'title' => esc_html__('Whether you\'re a seasoned - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't23-our-team',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['content', 'our', 'team', 'text'],
                ],
                't23-our-team-section-2' => [
                    'title' => esc_html__(' Jackson Marshall - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't23-our-team',
                    'section_number' => 2,
                    'images_count' => 11,
                    'tags' => ['header', 'our', 'team', 'image', 'heading', 'social icons'],
                ],
                't23-our-team-section-3' => [
                    'title' => esc_html__('With well-cared-for horses and - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't23-our-team',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['cta', 'our', 'team', 'text', 'button'],
                ],
                't23-the-thrill-of-horse-riding-section-1' => [
                    'title' => esc_html__('At our horse riding - The Thrill Of Horse Riding', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't23-the-thrill-of-horse-riding',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['cta', 'the', 'thrill', 'horse', 'riding', 'text', 'button'],
                ],
                't23-the-thrill-of-horse-riding-section-2' => [
                    'title' => esc_html__('Whether you\'re looking to - The Thrill Of Horse Riding', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't23-the-thrill-of-horse-riding',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['cta', 'the', 'thrill', 'horse', 'riding', 'image', 'counter', 'text', 'button'],
                ],
                't23-the-thrill-of-horse-riding-section-3' => [
                    'title' => esc_html__('With well-cared-for horses and - The Thrill Of Horse Riding', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't23-the-thrill-of-horse-riding',
                    'section_number' => 3,
                    'images_count' => 4,
                    'tags' => ['header', 'the', 'thrill', 'horse', 'riding', 'text', 'image', 'heading'],
                ],
                't23-the-thrill-of-horse-riding-section-4' => [
                    'title' => esc_html__('Whether you\'re looking to - The Thrill Of Horse Riding', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't23-the-thrill-of-horse-riding',
                    'section_number' => 4,
                    'images_count' => 3,
                    'tags' => ['cta', 'the', 'thrill', 'horse', 'riding', 'image', 'text', 'button'],
                ],
                't23-the-thrill-of-horse-riding-section-5' => [
                    'title' => esc_html__(' With well-cared-for horses - The Thrill Of Horse Riding', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't23-the-thrill-of-horse-riding',
                    'section_number' => 5,
                    'images_count' => 7,
                    'tags' => ['content', 'the', 'thrill', 'horse', 'riding', 'text', 'image box', 'image'],
                ],
                't23-the-thrill-of-horse-riding-section-6' => [
                    'title' => esc_html__('With well-cared-for horses and - The Thrill Of Horse Riding', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't23-the-thrill-of-horse-riding',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['content', 'the', 'thrill', 'horse', 'riding', 'text'],
                ],
                't23-the-thrill-of-horse-riding-section-7' => [
                    'title' => esc_html__('Whether you\'re a seasoned - The Thrill Of Horse Riding', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't23-the-thrill-of-horse-riding',
                    'section_number' => 7,
                    'images_count' => 2,
                    'tags' => ['content', 'the', 'thrill', 'horse', 'riding', 'text', 'accordion', 'image'],
                ],
                't23-the-thrill-of-horse-riding-section-8' => [
                    'title' => esc_html__('This pass includes two - The Thrill Of Horse Riding', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't23-the-thrill-of-horse-riding',
                    'section_number' => 8,
                    'images_count' => 3,
                    'tags' => ['cta', 'the', 'thrill', 'horse', 'riding', 'text', 'image', 'button'],
                ],
                't23-the-thrill-of-horse-riding-section-9' => [
                    'title' => esc_html__('With well-cared-for horses and - The Thrill Of Horse Riding', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't23-the-thrill-of-horse-riding',
                    'section_number' => 9,
                    'images_count' => 1,
                    'tags' => ['cta', 'the', 'thrill', 'horse', 'riding', 'text', 'button'],
                ],
                't23-unleash-your-inner-rider-section-1' => [
                    'title' => esc_html__('At our horse riding - Unleash Your Inner Rider', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't23-unleash-your-inner-rider',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['cta', 'unleash', 'your', 'inner', 'rider', 'text', 'button', 'image', 'king addons video popup', 'text path'],
                ],
                't23-unleash-your-inner-rider-section-2' => [
                    'title' => esc_html__('Whether you\'re looking to - Unleash Your Inner Rider', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't23-unleash-your-inner-rider',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['cta', 'unleash', 'your', 'inner', 'rider', 'image', 'text', 'button'],
                ],
                't23-unleash-your-inner-rider-section-3' => [
                    'title' => esc_html__(' With well-cared-for horses - Unleash Your Inner Rider', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't23-unleash-your-inner-rider',
                    'section_number' => 3,
                    'images_count' => 7,
                    'tags' => ['content', 'unleash', 'your', 'inner', 'rider', 'text', 'image box', 'image'],
                ],
                't23-unleash-your-inner-rider-section-4' => [
                    'title' => esc_html__('Whether you\'re looking to - Unleash Your Inner Rider', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't23-unleash-your-inner-rider',
                    'section_number' => 4,
                    'images_count' => 3,
                    'tags' => ['cta', 'unleash', 'your', 'inner', 'rider', 'image', 'counter', 'text', 'button'],
                ],
                't23-unleash-your-inner-rider-section-5' => [
                    'title' => esc_html__('With well-cared-for horses and - Unleash Your Inner Rider', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't23-unleash-your-inner-rider',
                    'section_number' => 5,
                    'images_count' => 4,
                    'tags' => ['header', 'unleash', 'your', 'inner', 'rider', 'text', 'image', 'heading'],
                ],
                't23-unleash-your-inner-rider-section-6' => [
                    'title' => esc_html__('With well-cared-for horses and - Unleash Your Inner Rider', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't23-unleash-your-inner-rider',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['content', 'unleash', 'your', 'inner', 'rider', 'text'],
                ],
                't23-unleash-your-inner-rider-section-7' => [
                    'title' => esc_html__('Whether you\'re a seasoned - Unleash Your Inner Rider', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't23-unleash-your-inner-rider',
                    'section_number' => 7,
                    'images_count' => 2,
                    'tags' => ['content', 'unleash', 'your', 'inner', 'rider', 'text', 'accordion', 'image'],
                ],
                't23-unleash-your-inner-rider-section-8' => [
                    'title' => esc_html__('This pass includes two - Unleash Your Inner Rider', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't23-unleash-your-inner-rider',
                    'section_number' => 8,
                    'images_count' => 3,
                    'tags' => ['cta', 'unleash', 'your', 'inner', 'rider', 'text', 'image', 'button'],
                ],
                't23-unleash-your-inner-rider-section-9' => [
                    'title' => esc_html__('With well-cared-for horses and - Unleash Your Inner Rider', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't23-unleash-your-inner-rider',
                    'section_number' => 9,
                    'images_count' => 3,
                    'tags' => ['cta', 'unleash', 'your', 'inner', 'rider', 'text', 'button'],
                ],
                't24-about-us-section-1' => [
                    'title' => esc_html__('Electrical Solutions, Always On - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't24-about-us',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['content', 'about', 'text'],
                ],
                't24-about-us-section-2' => [
                    'title' => esc_html__('About Us - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't24-about-us',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['general', 'about', 'king addons video popup'],
                ],
                't24-about-us-section-3' => [
                    'title' => esc_html__(' We believe that - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't24-about-us',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['cta', 'about', 'image', 'text', 'spacer', 'button'],
                ],
                't24-about-us-section-4' => [
                    'title' => esc_html__(' We believe that - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't24-about-us',
                    'section_number' => 4,
                    'images_count' => 9,
                    'tags' => ['cta', 'about', 'text', 'button', 'image', 'spacer', 'king addons card carousel'],
                ],
                't24-about-us-section-5' => [
                    'title' => esc_html__(' We believe that - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't24-about-us',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['cta', 'about', 'text', 'button'],
                ],
                't24-contact-us-section-1' => [
                    'title' => esc_html__('Call Us for Swift - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't24-contact-us',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['content', 'contact', 'text'],
                ],
                't24-contact-us-section-2' => [
                    'title' => esc_html__('Schedule an appointment for - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't24-contact-us',
                    'section_number' => 2,
                    'images_count' => 5,
                    'tags' => ['header', 'contact', 'heading', 'shortcode', 'spacer'],
                ],
                't24-contact-us-section-3' => [
                    'title' => esc_html__('Contact Us - General Section 3', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't24-contact-us',
                    'section_number' => 3,
                    'images_count' => 0,
                    'tags' => ['general', 'contact', 'icon box'],
                ],
                't24-contact-us-section-4' => [
                    'title' => esc_html__('Electrical emergencies can strike - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't24-contact-us',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['content', 'contact', 'text', 'google_maps'],
                ],
                't24-contact-us-section-5' => [
                    'title' => esc_html__('Don\'t Let Electrical Issues - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't24-contact-us',
                    'section_number' => 5,
                    'images_count' => 3,
                    'tags' => ['content', 'contact', 'text', 'accordion', 'image', 'spacer'],
                ],
                't24-contact-us-section-6' => [
                    'title' => esc_html__(' We believe that - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't24-contact-us',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['cta', 'contact', 'text', 'button'],
                ],
                't24-electrical-emergencies-section-1' => [
                    'title' => esc_html__('Our skilled team of - Electrical Emergencies', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't24-electrical-emergencies',
                    'section_number' => 1,
                    'images_count' => 6,
                    'tags' => ['cta', 'electrical', 'emergencies', 'text', 'button', 'king addons video popup'],
                ],
                't24-electrical-emergencies-section-2' => [
                    'title' => esc_html__('Electrical emergencies can strike - Electrical Emergencies', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't24-electrical-emergencies',
                    'section_number' => 2,
                    'images_count' => 8,
                    'tags' => ['cta', 'electrical', 'emergencies', 'image', 'text', 'spacer', 'button'],
                ],
                't24-electrical-emergencies-section-3' => [
                    'title' => esc_html__('We take pride in - Electrical Emergencies', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't24-electrical-emergencies',
                    'section_number' => 3,
                    'images_count' => 11,
                    'tags' => ['content', 'electrical', 'emergencies', 'text', 'image box', 'image carousel'],
                ],
                't24-electrical-emergencies-section-4' => [
                    'title' => esc_html__(' We believe that - Electrical Emergencies', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't24-electrical-emergencies',
                    'section_number' => 4,
                    'images_count' => 9,
                    'tags' => ['cta', 'electrical', 'emergencies', 'text', 'button', 'image', 'spacer', 'king addons card carousel'],
                ],
                't24-electrical-emergencies-section-5' => [
                    'title' => esc_html__(' We believe that - Electrical Emergencies', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't24-electrical-emergencies',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['cta', 'electrical', 'emergencies', 'text', 'button'],
                ],
                't24-electrician-repair-solutions-section-1' => [
                    'title' => esc_html__('Our skilled team of - Electrician Repair Solutions', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't24-electrician-repair-solutions',
                    'section_number' => 1,
                    'images_count' => 7,
                    'tags' => ['cta', 'electrician', 'repair', 'solutions', 'image', 'text', 'button'],
                ],
                't24-electrician-repair-solutions-section-2' => [
                    'title' => esc_html__('Electrical emergencies can strike - Electrician Repair Solutions', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't24-electrician-repair-solutions',
                    'section_number' => 2,
                    'images_count' => 8,
                    'tags' => ['cta', 'electrician', 'repair', 'solutions', 'image', 'text', 'spacer', 'button'],
                ],
                't24-electrician-repair-solutions-section-3' => [
                    'title' => esc_html__('Electrician Repair Solutions - General Section 3', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't24-electrician-repair-solutions',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['general', 'electrician', 'repair', 'solutions', 'king addons video popup'],
                ],
                't24-electrician-repair-solutions-section-4' => [
                    'title' => esc_html__('We take pride in - Electrician Repair Solutions', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't24-electrician-repair-solutions',
                    'section_number' => 4,
                    'images_count' => 11,
                    'tags' => ['content', 'electrician', 'repair', 'solutions', 'text', 'image box', 'image carousel'],
                ],
                't24-electrician-repair-solutions-section-5' => [
                    'title' => esc_html__(' We believe that - Electrician Repair Solutions', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't24-electrician-repair-solutions',
                    'section_number' => 5,
                    'images_count' => 9,
                    'tags' => ['cta', 'electrician', 'repair', 'solutions', 'text', 'button', 'image', 'spacer', 'king addons card carousel'],
                ],
                't24-electrician-repair-solutions-section-6' => [
                    'title' => esc_html__(' We believe that - Electrician Repair Solutions', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't24-electrician-repair-solutions',
                    'section_number' => 6,
                    'images_count' => 2,
                    'tags' => ['cta', 'electrician', 'repair', 'solutions', 'text', 'button'],
                ],
                't24-our-services-section-1' => [
                    'title' => esc_html__('Experience the Shockingly Good - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't24-our-services',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['content', 'our', 'services', 'text'],
                ],
                't24-our-services-section-2' => [
                    'title' => esc_html__('Our Services - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't24-our-services',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['general', 'our', 'services', 'king addons video popup'],
                ],
                't24-our-services-section-3' => [
                    'title' => esc_html__(' We believe that - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't24-our-services',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['cta', 'our', 'services', 'image', 'text', 'spacer', 'button'],
                ],
                't24-our-services-section-4' => [
                    'title' => esc_html__('Electrical emergencies can strike - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't24-our-services',
                    'section_number' => 4,
                    'images_count' => 7,
                    'tags' => ['content', 'our', 'services', 'text', 'image'],
                ],
                't24-our-services-section-5' => [
                    'title' => esc_html__(' We believe that - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't24-our-services',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['cta', 'our', 'services', 'text', 'button'],
                ],
                't24-skilled-electricians-section-1' => [
                    'title' => esc_html__('Our skilled team of - Skilled Electricians', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't24-skilled-electricians',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['cta', 'skilled', 'electricians', 'text', 'button'],
                ],
                't24-skilled-electricians-section-2' => [
                    'title' => esc_html__('Skilled Electricians - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't24-skilled-electricians',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['general', 'skilled', 'electricians', 'king addons video popup'],
                ],
                't24-skilled-electricians-section-3' => [
                    'title' => esc_html__('Electrical emergencies can strike - Skilled Electricians', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't24-skilled-electricians',
                    'section_number' => 3,
                    'images_count' => 8,
                    'tags' => ['cta', 'skilled', 'electricians', 'image', 'text', 'spacer', 'button'],
                ],
                't24-skilled-electricians-section-4' => [
                    'title' => esc_html__('We take pride in - Skilled Electricians', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't24-skilled-electricians',
                    'section_number' => 4,
                    'images_count' => 11,
                    'tags' => ['content', 'skilled', 'electricians', 'text', 'image box', 'image carousel'],
                ],
                't24-skilled-electricians-section-5' => [
                    'title' => esc_html__(' We believe that - Skilled Electricians', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't24-skilled-electricians',
                    'section_number' => 5,
                    'images_count' => 9,
                    'tags' => ['cta', 'skilled', 'electricians', 'text', 'button', 'image', 'spacer', 'king addons card carousel'],
                ],
                't24-skilled-electricians-section-6' => [
                    'title' => esc_html__(' We believe that - Skilled Electricians', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't24-skilled-electricians',
                    'section_number' => 6,
                    'images_count' => 3,
                    'tags' => ['cta', 'skilled', 'electricians', 'text', 'button'],
                ],
                't24-trusted-electrician-repair-section-1' => [
                    'title' => esc_html__('Our skilled team of - Trusted Electrician Repair', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't24-trusted-electrician-repair',
                    'section_number' => 1,
                    'images_count' => 7,
                    'tags' => ['cta', 'trusted', 'electrician', 'repair', 'text', 'button'],
                ],
                't24-trusted-electrician-repair-section-2' => [
                    'title' => esc_html__('Electrical emergencies can strike - Trusted Electrician Repair', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't24-trusted-electrician-repair',
                    'section_number' => 2,
                    'images_count' => 8,
                    'tags' => ['cta', 'trusted', 'electrician', 'repair', 'image', 'text', 'spacer', 'button'],
                ],
                't24-trusted-electrician-repair-section-3' => [
                    'title' => esc_html__('We take pride in - Trusted Electrician Repair', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't24-trusted-electrician-repair',
                    'section_number' => 3,
                    'images_count' => 11,
                    'tags' => ['content', 'trusted', 'electrician', 'repair', 'text', 'image box', 'image carousel'],
                ],
                't24-trusted-electrician-repair-section-4' => [
                    'title' => esc_html__(' We believe that - Trusted Electrician Repair', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't24-trusted-electrician-repair',
                    'section_number' => 4,
                    'images_count' => 9,
                    'tags' => ['cta', 'trusted', 'electrician', 'repair', 'text', 'button', 'image', 'spacer', 'king addons card carousel'],
                ],
                't24-trusted-electrician-repair-section-5' => [
                    'title' => esc_html__('Don\'t Let Electrical Issues - Trusted Electrician Repair', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't24-trusted-electrician-repair',
                    'section_number' => 5,
                    'images_count' => 3,
                    'tags' => ['content', 'trusted', 'electrician', 'repair', 'text', 'accordion', 'image', 'spacer'],
                ],
                't24-trusted-electrician-repair-section-6' => [
                    'title' => esc_html__(' We believe that - Trusted Electrician Repair', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't24-trusted-electrician-repair',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['cta', 'trusted', 'electrician', 'repair', 'text', 'button'],
                ],
                't25-contact-us-section-1' => [
                    'title' => esc_html__('— Contact Us — - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't25-contact-us',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['header', 'contact', 'text', 'spacer', 'heading', 'shortcode'],
                ],
                't25-contact-us-section-2' => [
                    'title' => esc_html__('Contact Us - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't25-contact-us',
                    'section_number' => 2,
                    'images_count' => 0,
                    'tags' => ['general', 'contact', 'icon box'],
                ],
                't25-contact-us-section-3' => [
                    'title' => esc_html__('Our team of skilled - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't25-contact-us',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['content', 'contact', 'text', 'google_maps'],
                ],
                't25-contact-us-section-4' => [
                    'title' => esc_html__('Expert Legal Advice, Tailored - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't25-contact-us',
                    'section_number' => 4,
                    'images_count' => 3,
                    'tags' => ['content', 'contact', 'text', 'accordion', 'image'],
                ],
                't25-contact-us-section-5' => [
                    'title' => esc_html__('Trust in our experience - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't25-contact-us',
                    'section_number' => 5,
                    'images_count' => 4,
                    'tags' => ['cta', 'contact', 'text', 'button'],
                ],
                't25-justice-prevails-section-1' => [
                    'title' => esc_html__('Our team of skilled - Justice Prevails', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't25-justice-prevails',
                    'section_number' => 1,
                    'images_count' => 5,
                    'tags' => ['cta', 'justice', 'prevails', 'text', 'image', 'king addons video popup', 'text path', 'button', 'divider'],
                ],
                't25-justice-prevails-section-2' => [
                    'title' => esc_html__('Our team of skilled - Justice Prevails', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't25-justice-prevails',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['cta', 'justice', 'prevails', 'text', 'image', 'button'],
                ],
                't25-justice-prevails-section-3' => [
                    'title' => esc_html__('We have in-depth knowledge - Justice Prevails', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't25-justice-prevails',
                    'section_number' => 3,
                    'images_count' => 8,
                    'tags' => ['header', 'justice', 'prevails', 'text', 'image', 'heading'],
                ],
                't25-justice-prevails-section-4' => [
                    'title' => esc_html__('Our team of skilled - Justice Prevails', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't25-justice-prevails',
                    'section_number' => 4,
                    'images_count' => 3,
                    'tags' => ['cta', 'justice', 'prevails', 'image', 'text', 'counter', 'button'],
                ],
                't25-justice-prevails-section-5' => [
                    'title' => esc_html__('We offer the highest - Justice Prevails', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't25-justice-prevails',
                    'section_number' => 5,
                    'images_count' => 11,
                    'tags' => ['content', 'justice', 'prevails', 'text', 'image box', 'king addons card carousel'],
                ],
                't25-justice-prevails-section-6' => [
                    'title' => esc_html__('You can trust us - Justice Prevails', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't25-justice-prevails',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['content', 'justice', 'prevails', 'text'],
                ],
                't25-justice-prevails-section-7' => [
                    'title' => esc_html__('Our team of skilled - Justice Prevails', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't25-justice-prevails',
                    'section_number' => 7,
                    'images_count' => 6,
                    'tags' => ['content', 'justice', 'prevails', 'text', 'king addons testimonial carousel'],
                ],
                't25-justice-prevails-section-8' => [
                    'title' => esc_html__('Expert Legal Advice, Tailored - Justice Prevails', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't25-justice-prevails',
                    'section_number' => 8,
                    'images_count' => 1,
                    'tags' => ['content', 'justice', 'prevails', 'text', 'king addons blog posts'],
                ],
                't25-our-pricing-section-1' => [
                    'title' => esc_html__('— Our Pricing — - Our Pricing', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't25-our-pricing',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['content', 'our', 'pricing', 'text'],
                ],
                't25-our-pricing-section-2' => [
                    'title' => esc_html__('Legal Excellence You Can - Our Pricing', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't25-our-pricing',
                    'section_number' => 2,
                    'images_count' => 2,
                    'tags' => ['content', 'our', 'pricing', 'text', 'king addons price list'],
                ],
                't25-our-pricing-section-3' => [
                    'title' => esc_html__('You can trust us - Our Pricing', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't25-our-pricing',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['content', 'our', 'pricing', 'text'],
                ],
                't25-our-pricing-section-4' => [
                    'title' => esc_html__('Trust in our experience - Our Pricing', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't25-our-pricing',
                    'section_number' => 4,
                    'images_count' => 4,
                    'tags' => ['cta', 'our', 'pricing', 'text', 'button'],
                ],
                't25-our-services-section-1' => [
                    'title' => esc_html__('— Our Services — - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't25-our-services',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['content', 'our', 'services', 'text'],
                ],
                't25-our-services-section-2' => [
                    'title' => esc_html__('Our team of skilled - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't25-our-services',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['cta', 'our', 'services', 'image', 'text', 'counter', 'button'],
                ],
                't25-our-services-section-3' => [
                    'title' => esc_html__('We offer the highest - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't25-our-services',
                    'section_number' => 3,
                    'images_count' => 11,
                    'tags' => ['content', 'our', 'services', 'text', 'image box', 'king addons card carousel'],
                ],
                't25-our-services-section-4' => [
                    'title' => esc_html__('You can trust us - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't25-our-services',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['content', 'our', 'services', 'text'],
                ],
                't25-our-services-section-5' => [
                    'title' => esc_html__('Trust in our experience - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't25-our-services',
                    'section_number' => 5,
                    'images_count' => 4,
                    'tags' => ['cta', 'our', 'services', 'text', 'button'],
                ],
                't25-our-team-section-1' => [
                    'title' => esc_html__('— Our Team — - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't25-our-team',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['content', 'our', 'team', 'text'],
                ],
                't25-our-team-section-2' => [
                    'title' => esc_html__('— Intellectual Property Lawyer— - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't25-our-team',
                    'section_number' => 2,
                    'images_count' => 8,
                    'tags' => ['header', 'our', 'team', 'image', 'heading'],
                ],
                't25-our-team-section-3' => [
                    'title' => esc_html__('Trust in our experience - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't25-our-team',
                    'section_number' => 3,
                    'images_count' => 4,
                    'tags' => ['cta', 'our', 'team', 'text', 'button'],
                ],
                't25-trusted-attorneys-section-1' => [
                    'title' => esc_html__('Our team of skilled - Trusted Attorneys', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't25-trusted-attorneys',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['cta', 'trusted', 'attorneys', 'king addons video popup', 'text', 'button', 'divider'],
                ],
                't25-trusted-attorneys-section-2' => [
                    'title' => esc_html__('Our team of skilled - Trusted Attorneys', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't25-trusted-attorneys',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['cta', 'trusted', 'attorneys', 'text', 'image', 'button'],
                ],
                't25-trusted-attorneys-section-3' => [
                    'title' => esc_html__('We offer the highest - Trusted Attorneys', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't25-trusted-attorneys',
                    'section_number' => 3,
                    'images_count' => 11,
                    'tags' => ['content', 'trusted', 'attorneys', 'text', 'image box', 'king addons card carousel'],
                ],
                't25-trusted-attorneys-section-4' => [
                    'title' => esc_html__('We have in-depth knowledge - Trusted Attorneys', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't25-trusted-attorneys',
                    'section_number' => 4,
                    'images_count' => 8,
                    'tags' => ['header', 'trusted', 'attorneys', 'text', 'image', 'heading'],
                ],
                't25-trusted-attorneys-section-5' => [
                    'title' => esc_html__('Our team of skilled - Trusted Attorneys', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't25-trusted-attorneys',
                    'section_number' => 5,
                    'images_count' => 3,
                    'tags' => ['cta', 'trusted', 'attorneys', 'image', 'text', 'counter', 'button'],
                ],
                't25-trusted-attorneys-section-6' => [
                    'title' => esc_html__('You can trust us - Trusted Attorneys', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't25-trusted-attorneys',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['content', 'trusted', 'attorneys', 'text'],
                ],
                't25-trusted-attorneys-section-7' => [
                    'title' => esc_html__('Our team of skilled - Trusted Attorneys', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't25-trusted-attorneys',
                    'section_number' => 7,
                    'images_count' => 6,
                    'tags' => ['content', 'trusted', 'attorneys', 'text', 'king addons testimonial carousel'],
                ],
                't25-trusted-attorneys-section-8' => [
                    'title' => esc_html__('Trust in our experience - Trusted Attorneys', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't25-trusted-attorneys',
                    'section_number' => 8,
                    'images_count' => 4,
                    'tags' => ['cta', 'trusted', 'attorneys', 'text', 'button'],
                ],
                't25-your-legal-allies-section-1' => [
                    'title' => esc_html__('Our team of skilled - Your Legal Allies', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't25-your-legal-allies',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['cta', 'your', 'legal', 'allies', 'text', 'button', 'divider', 'king addons video popup'],
                ],
                't25-your-legal-allies-section-2' => [
                    'title' => esc_html__('Our team of skilled - Your Legal Allies', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't25-your-legal-allies',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['cta', 'your', 'legal', 'allies', 'text', 'image', 'button'],
                ],
                't25-your-legal-allies-section-3' => [
                    'title' => esc_html__('We offer the highest - Your Legal Allies', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't25-your-legal-allies',
                    'section_number' => 3,
                    'images_count' => 11,
                    'tags' => ['content', 'your', 'legal', 'allies', 'text', 'image box', 'king addons card carousel'],
                ],
                't25-your-legal-allies-section-4' => [
                    'title' => esc_html__('You can trust us - Your Legal Allies', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't25-your-legal-allies',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['content', 'your', 'legal', 'allies', 'text'],
                ],
                't25-your-legal-allies-section-5' => [
                    'title' => esc_html__('Our team of skilled - Your Legal Allies', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't25-your-legal-allies',
                    'section_number' => 5,
                    'images_count' => 3,
                    'tags' => ['cta', 'your', 'legal', 'allies', 'image', 'text', 'counter', 'button'],
                ],
                't25-your-legal-allies-section-6' => [
                    'title' => esc_html__('We have in-depth knowledge - Your Legal Allies', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't25-your-legal-allies',
                    'section_number' => 6,
                    'images_count' => 8,
                    'tags' => ['header', 'your', 'legal', 'allies', 'text', 'image', 'heading'],
                ],
                't25-your-legal-allies-section-7' => [
                    'title' => esc_html__('Our team of skilled - Your Legal Allies', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't25-your-legal-allies',
                    'section_number' => 7,
                    'images_count' => 6,
                    'tags' => ['content', 'your', 'legal', 'allies', 'text', 'king addons testimonial carousel'],
                ],
                't25-your-legal-allies-section-8' => [
                    'title' => esc_html__('Trust in our experience - Your Legal Allies', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't25-your-legal-allies',
                    'section_number' => 8,
                    'images_count' => 1,
                    'tags' => ['cta', 'your', 'legal', 'allies', 'text', 'button'],
                ],
                't25-your-legal-solution-section-1' => [
                    'title' => esc_html__('Our team of skilled - Your Legal Solution', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't25-your-legal-solution',
                    'section_number' => 1,
                    'images_count' => 4,
                    'tags' => ['cta', 'your', 'legal', 'solution', 'text', 'button', 'divider', 'text path', 'image'],
                ],
                't25-your-legal-solution-section-2' => [
                    'title' => esc_html__('Our team of skilled - Your Legal Solution', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't25-your-legal-solution',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['cta', 'your', 'legal', 'solution', 'text', 'image', 'button'],
                ],
                't25-your-legal-solution-section-3' => [
                    'title' => esc_html__('We offer the highest - Your Legal Solution', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't25-your-legal-solution',
                    'section_number' => 3,
                    'images_count' => 11,
                    'tags' => ['content', 'your', 'legal', 'solution', 'text', 'image box', 'king addons card carousel'],
                ],
                't25-your-legal-solution-section-4' => [
                    'title' => esc_html__('Our team of skilled - Your Legal Solution', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't25-your-legal-solution',
                    'section_number' => 4,
                    'images_count' => 3,
                    'tags' => ['cta', 'your', 'legal', 'solution', 'image', 'text', 'counter', 'button'],
                ],
                't25-your-legal-solution-section-5' => [
                    'title' => esc_html__('You can trust us - Your Legal Solution', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't25-your-legal-solution',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['content', 'your', 'legal', 'solution', 'text'],
                ],
                't25-your-legal-solution-section-6' => [
                    'title' => esc_html__('Our team of skilled - Your Legal Solution', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't25-your-legal-solution',
                    'section_number' => 6,
                    'images_count' => 6,
                    'tags' => ['content', 'your', 'legal', 'solution', 'text', 'king addons testimonial carousel'],
                ],
                't25-your-legal-solution-section-7' => [
                    'title' => esc_html__('Expert Legal Advice, Tailored - Your Legal Solution', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't25-your-legal-solution',
                    'section_number' => 7,
                    'images_count' => 1,
                    'tags' => ['content', 'your', 'legal', 'solution', 'text', 'king addons blog posts'],
                ],
                't25-your-legal-solution-section-8' => [
                    'title' => esc_html__('Trust in our experience - Your Legal Solution', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't25-your-legal-solution',
                    'section_number' => 8,
                    'images_count' => 4,
                    'tags' => ['cta', 'your', 'legal', 'solution', 'text', 'button'],
                ],
                't26-confident-living-section-1' => [
                    'title' => esc_html__('With our team of - Confident Living', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't26-confident-living',
                    'section_number' => 1,
                    'images_count' => 4,
                    'tags' => ['cta', 'confident', 'living', 'text', 'button'],
                ],
                't26-confident-living-section-2' => [
                    'title' => esc_html__('Our commitment to research, - Confident Living', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't26-confident-living',
                    'section_number' => 2,
                    'images_count' => 5,
                    'tags' => ['cta', 'confident', 'living', 'text', 'image', 'button'],
                ],
                't26-confident-living-section-3' => [
                    'title' => esc_html__('When you choose Prosthetics - Confident Living', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't26-confident-living',
                    'section_number' => 3,
                    'images_count' => 3,
                    'tags' => ['cta', 'confident', 'living', 'text', 'image', 'button', 'king addons auto scrolling text'],
                ],
                't26-confident-living-section-4' => [
                    'title' => esc_html__('With our team of - Confident Living', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't26-confident-living',
                    'section_number' => 4,
                    'images_count' => 3,
                    'tags' => ['content', 'confident', 'living', 'text', 'image', 'text path'],
                ],
                't26-confident-living-section-5' => [
                    'title' => esc_html__('Our commitment to research, - Confident Living', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't26-confident-living',
                    'section_number' => 5,
                    'images_count' => 5,
                    'tags' => ['content', 'confident', 'living', 'text', 'image'],
                ],
                't26-confident-living-section-6' => [
                    'title' => esc_html__('With our team of - Confident Living', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't26-confident-living',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['content', 'confident', 'living', 'text', 'king addons blog posts'],
                ],
                't26-confident-living-section-7' => [
                    'title' => esc_html__('With our team of - Confident Living', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't26-confident-living',
                    'section_number' => 7,
                    'images_count' => 1,
                    'tags' => ['cta', 'confident', 'living', 'text', 'button'],
                ],
                't26-contact-us-section-1' => [
                    'title' => esc_html__('Leading the Way in - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't26-contact-us',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['content', 'contact', 'text'],
                ],
                't26-contact-us-section-2' => [
                    'title' => esc_html__('Do you need any - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't26-contact-us',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['content', 'contact', 'spacer', 'text', 'shortcode', 'icon box'],
                ],
                't26-contact-us-section-3' => [
                    'title' => esc_html__('With our team of - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't26-contact-us',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['content', 'contact', 'text', 'google_maps'],
                ],
                't26-contact-us-section-4' => [
                    'title' => esc_html__('With our team of - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't26-contact-us',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['cta', 'contact', 'text', 'button'],
                ],
                't26-gallery-section-1' => [
                    'title' => esc_html__('Inspiring Stories of Transformation - Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't26-gallery',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['content', 'gallery', 'text'],
                ],
                't26-gallery-section-2' => [
                    'title' => esc_html__('Gallery - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't26-gallery',
                    'section_number' => 2,
                    'images_count' => 13,
                    'tags' => ['general', 'gallery', 'king addons image grid'],
                ],
                't26-gallery-section-3' => [
                    'title' => esc_html__('With our team of - Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't26-gallery',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['cta', 'gallery', 'text', 'button'],
                ],
                't26-our-services-section-1' => [
                    'title' => esc_html__('Elevate Your Mobility: Prosthetics - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't26-our-services',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['content', 'our', 'services', 'text'],
                ],
                't26-our-services-section-2' => [
                    'title' => esc_html__('Our commitment to research, - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't26-our-services',
                    'section_number' => 2,
                    'images_count' => 5,
                    'tags' => ['cta', 'our', 'services', 'text', 'image', 'button'],
                ],
                't26-our-services-section-3' => [
                    'title' => esc_html__('Our commitment to research, - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't26-our-services',
                    'section_number' => 3,
                    'images_count' => 5,
                    'tags' => ['content', 'our', 'services', 'text', 'image'],
                ],
                't26-our-services-section-4' => [
                    'title' => esc_html__('Our Services - General Section 4', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't26-our-services',
                    'section_number' => 4,
                    'images_count' => 7,
                    'tags' => ['general', 'our', 'services', 'king addons image grid'],
                ],
                't26-our-services-section-5' => [
                    'title' => esc_html__('With our team of - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't26-our-services',
                    'section_number' => 5,
                    'images_count' => 2,
                    'tags' => ['cta', 'our', 'services', 'text', 'button'],
                ],
                't26-our-team-section-1' => [
                    'title' => esc_html__('Leading the Way in - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't26-our-team',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['content', 'our', 'team', 'text'],
                ],
                't26-our-team-section-2' => [
                    'title' => esc_html__('Prosthetic Fitting Specialist - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't26-our-team',
                    'section_number' => 2,
                    'images_count' => 11,
                    'tags' => ['header', 'our', 'team', 'image', 'text', 'heading', 'social icons'],
                ],
                't26-our-team-section-3' => [
                    'title' => esc_html__('With our team of - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't26-our-team',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['cta', 'our', 'team', 'text', 'button'],
                ],
                't26-prosthetic-care-section-1' => [
                    'title' => esc_html__('With our team of - Prosthetic Care', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't26-prosthetic-care',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['cta', 'prosthetic', 'care', 'king addons video popup', 'image', 'text', 'button', 'spacer'],
                ],
                't26-prosthetic-care-section-2' => [
                    'title' => esc_html__('Our commitment to research, - Prosthetic Care', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't26-prosthetic-care',
                    'section_number' => 2,
                    'images_count' => 5,
                    'tags' => ['cta', 'prosthetic', 'care', 'text', 'image', 'button'],
                ],
                't26-prosthetic-care-section-3' => [
                    'title' => esc_html__('When you choose Prosthetics - Prosthetic Care', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't26-prosthetic-care',
                    'section_number' => 3,
                    'images_count' => 3,
                    'tags' => ['cta', 'prosthetic', 'care', 'text', 'image', 'button', 'king addons auto scrolling text'],
                ],
                't26-prosthetic-care-section-4' => [
                    'title' => esc_html__('With our team of - Prosthetic Care', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't26-prosthetic-care',
                    'section_number' => 4,
                    'images_count' => 3,
                    'tags' => ['content', 'prosthetic', 'care', 'text', 'image', 'text path'],
                ],
                't26-prosthetic-care-section-5' => [
                    'title' => esc_html__('Our commitment to research, - Prosthetic Care', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't26-prosthetic-care',
                    'section_number' => 5,
                    'images_count' => 5,
                    'tags' => ['content', 'prosthetic', 'care', 'text', 'image'],
                ],
                't26-prosthetic-care-section-6' => [
                    'title' => esc_html__('With our team of - Prosthetic Care', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't26-prosthetic-care',
                    'section_number' => 6,
                    'images_count' => 6,
                    'tags' => ['content', 'prosthetic', 'care', 'text', 'king addons card carousel'],
                ],
                't26-prosthetic-care-section-7' => [
                    'title' => esc_html__('With our team of - Prosthetic Care', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't26-prosthetic-care',
                    'section_number' => 7,
                    'images_count' => 1,
                    'tags' => ['cta', 'prosthetic', 'care', 'text', 'button'],
                ],
                't26-step-into-possibility-section-1' => [
                    'title' => esc_html__('With our team of - Step Into Possibility', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't26-step-into-possibility',
                    'section_number' => 1,
                    'images_count' => 4,
                    'tags' => ['cta', 'step', 'into', 'possibility', 'image', 'text path', 'text', 'button'],
                ],
                't26-step-into-possibility-section-2' => [
                    'title' => esc_html__('With our team of - Step Into Possibility', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't26-step-into-possibility',
                    'section_number' => 2,
                    'images_count' => 2,
                    'tags' => ['content', 'step', 'into', 'possibility', 'text', 'image'],
                ],
                't26-step-into-possibility-section-3' => [
                    'title' => esc_html__('When you choose Prosthetics - Step Into Possibility', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't26-step-into-possibility',
                    'section_number' => 3,
                    'images_count' => 3,
                    'tags' => ['cta', 'step', 'into', 'possibility', 'text', 'image', 'button', 'king addons auto scrolling text'],
                ],
                't26-step-into-possibility-section-4' => [
                    'title' => esc_html__('Our commitment to research, - Step Into Possibility', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't26-step-into-possibility',
                    'section_number' => 4,
                    'images_count' => 5,
                    'tags' => ['cta', 'step', 'into', 'possibility', 'text', 'image', 'button'],
                ],
                't26-step-into-possibility-section-5' => [
                    'title' => esc_html__('Our commitment to research, - Step Into Possibility', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't26-step-into-possibility',
                    'section_number' => 5,
                    'images_count' => 5,
                    'tags' => ['content', 'step', 'into', 'possibility', 'text', 'image'],
                ],
                't26-step-into-possibility-section-6' => [
                    'title' => esc_html__('With our team of - Step Into Possibility', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't26-step-into-possibility',
                    'section_number' => 6,
                    'images_count' => 6,
                    'tags' => ['content', 'step', 'into', 'possibility', 'text', 'king addons card carousel'],
                ],
                't26-step-into-possibility-section-7' => [
                    'title' => esc_html__('Step Into Possibility - General Section 7', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't26-step-into-possibility',
                    'section_number' => 7,
                    'images_count' => 7,
                    'tags' => ['general', 'step', 'into', 'possibility', 'king addons image grid'],
                ],
                't26-step-into-possibility-section-8' => [
                    'title' => esc_html__('With our team of - Step Into Possibility', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't26-step-into-possibility',
                    'section_number' => 8,
                    'images_count' => 2,
                    'tags' => ['cta', 'step', 'into', 'possibility', 'text', 'button'],
                ],
                't26-your-mobility-our-mission-section-1' => [
                    'title' => esc_html__('Our compassionate staff will - Your Mobility Our Mission', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't26-your-mobility-our-mission',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['hero', 'your', 'mobility', 'our', 'mission', 'text', 'styled text', 'button'],
                ],
                't26-your-mobility-our-mission-section-2' => [
                    'title' => esc_html__('Your Mobility Our Mission - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't26-your-mobility-our-mission',
                    'section_number' => 2,
                    'images_count' => 2,
                    'tags' => ['general', 'your', 'mobility', 'our', 'mission', 'king addons video popup', 'text path'],
                ],
                't26-your-mobility-our-mission-section-3' => [
                    'title' => esc_html__('When you choose Prosthetics - Your Mobility Our Mission', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't26-your-mobility-our-mission',
                    'section_number' => 3,
                    'images_count' => 3,
                    'tags' => ['cta', 'your', 'mobility', 'our', 'mission', 'text', 'image', 'button', 'king addons auto scrolling text'],
                ],
                't26-your-mobility-our-mission-section-4' => [
                    'title' => esc_html__('With our team of - Your Mobility Our Mission', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't26-your-mobility-our-mission',
                    'section_number' => 4,
                    'images_count' => 2,
                    'tags' => ['content', 'your', 'mobility', 'our', 'mission', 'text', 'image'],
                ],
                't26-your-mobility-our-mission-section-5' => [
                    'title' => esc_html__('Our commitment to research, - Your Mobility Our Mission', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't26-your-mobility-our-mission',
                    'section_number' => 5,
                    'images_count' => 5,
                    'tags' => ['content', 'your', 'mobility', 'our', 'mission', 'text', 'image'],
                ],
                't26-your-mobility-our-mission-section-6' => [
                    'title' => esc_html__('Our commitment to research, - Your Mobility Our Mission', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't26-your-mobility-our-mission',
                    'section_number' => 6,
                    'images_count' => 5,
                    'tags' => ['cta', 'your', 'mobility', 'our', 'mission', 'text', 'image', 'button'],
                ],
                't26-your-mobility-our-mission-section-7' => [
                    'title' => esc_html__('Together, we\'ll celebrate your - Your Mobility Our Mission', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't26-your-mobility-our-mission',
                    'section_number' => 7,
                    'images_count' => 1,
                    'tags' => ['content', 'your', 'mobility', 'our', 'mission', 'text'],
                ],
                't26-your-mobility-our-mission-section-8' => [
                    'title' => esc_html__('With our team of - Your Mobility Our Mission', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't26-your-mobility-our-mission',
                    'section_number' => 8,
                    'images_count' => 6,
                    'tags' => ['content', 'your', 'mobility', 'our', 'mission', 'text', 'king addons card carousel'],
                ],
                't26-your-mobility-our-mission-section-9' => [
                    'title' => esc_html__('Your Mobility Our Mission - General Section 9', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't26-your-mobility-our-mission',
                    'section_number' => 9,
                    'images_count' => 7,
                    'tags' => ['general', 'your', 'mobility', 'our', 'mission', 'king addons image grid'],
                ],
                't26-your-mobility-our-mission-section-10' => [
                    'title' => esc_html__('With our team of - Your Mobility Our Mission', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't26-your-mobility-our-mission',
                    'section_number' => 10,
                    'images_count' => 2,
                    'tags' => ['cta', 'your', 'mobility', 'our', 'mission', 'text', 'button'],
                ],
                't27-contact-us-section-1' => [
                    'title' => esc_html__('We are here to - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't27-contact-us',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['header', 'contact', 'text', 'spacer', 'heading', 'shortcode'],
                ],
                't27-contact-us-section-2' => [
                    'title' => esc_html__('Contact Us - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't27-contact-us',
                    'section_number' => 2,
                    'images_count' => 0,
                    'tags' => ['general', 'contact', 'icon box'],
                ],
                't27-contact-us-section-3' => [
                    'title' => esc_html__('We believe in open - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't27-contact-us',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['content', 'contact', 'text', 'google_maps', 'image'],
                ],
                't27-contact-us-section-4' => [
                    'title' => esc_html__('We believe that when - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't27-contact-us',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['content', 'contact', 'text'],
                ],
                't27-contact-us-section-5' => [
                    'title' => esc_html__('We believe in open - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't27-contact-us',
                    'section_number' => 5,
                    'images_count' => 3,
                    'tags' => ['cta', 'contact', 'text', 'button'],
                ],
                't27-exceptional-nannies-section-1' => [
                    'title' => esc_html__('Our Nanny Services is - Exceptional Nannies', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't27-exceptional-nannies',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['cta', 'exceptional', 'nannies', 'text', 'button'],
                ],
                't27-exceptional-nannies-section-2' => [
                    'title' => esc_html__('Exceptional Nannies - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't27-exceptional-nannies',
                    'section_number' => 2,
                    'images_count' => 9,
                    'tags' => ['general', 'exceptional', 'nannies', 'image carousel'],
                ],
                't27-exceptional-nannies-section-3' => [
                    'title' => esc_html__('We believe in open - Exceptional Nannies', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't27-exceptional-nannies',
                    'section_number' => 3,
                    'images_count' => 10,
                    'tags' => ['content', 'exceptional', 'nannies', 'text', 'king addons card carousel'],
                ],
                't27-exceptional-nannies-section-4' => [
                    'title' => esc_html__('Our approach focuses on - Exceptional Nannies', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't27-exceptional-nannies',
                    'section_number' => 4,
                    'images_count' => 7,
                    'tags' => ['content', 'exceptional', 'nannies', 'image', 'text', 'image box'],
                ],
                't27-exceptional-nannies-section-5' => [
                    'title' => esc_html__('The safety and well-being - Exceptional Nannies', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't27-exceptional-nannies',
                    'section_number' => 5,
                    'images_count' => 5,
                    'tags' => ['content', 'exceptional', 'nannies', 'text', 'image box', 'image'],
                ],
                't27-exceptional-nannies-section-6' => [
                    'title' => esc_html__('We believe in open - Exceptional Nannies', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't27-exceptional-nannies',
                    'section_number' => 6,
                    'images_count' => 7,
                    'tags' => ['content', 'exceptional', 'nannies', 'text', 'king addons card carousel'],
                ],
                't27-exceptional-nannies-section-7' => [
                    'title' => esc_html__('Our staff is not - Exceptional Nannies', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't27-exceptional-nannies',
                    'section_number' => 7,
                    'images_count' => 6,
                    'tags' => ['cta', 'exceptional', 'nannies', 'text', 'image', 'button', 'king addons blog posts'],
                ],
                't27-exceptional-nannies-section-8' => [
                    'title' => esc_html__('We believe in open - Exceptional Nannies', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't27-exceptional-nannies',
                    'section_number' => 8,
                    'images_count' => 3,
                    'tags' => ['cta', 'exceptional', 'nannies', 'text', 'button'],
                ],
                't27-kindergarten-magic-section-1' => [
                    'title' => esc_html__('We believe in open - Kindergarten Magic', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't27-kindergarten-magic',
                    'section_number' => 1,
                    'images_count' => 6,
                    'tags' => ['cta', 'kindergarten', 'magic', 'text', 'button', 'image'],
                ],
                't27-kindergarten-magic-section-2' => [
                    'title' => esc_html__('Kindergarten Magic - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't27-kindergarten-magic',
                    'section_number' => 2,
                    'images_count' => 9,
                    'tags' => ['general', 'kindergarten', 'magic', 'image carousel'],
                ],
                't27-kindergarten-magic-section-3' => [
                    'title' => esc_html__('The safety and well-being - Kindergarten Magic', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't27-kindergarten-magic',
                    'section_number' => 3,
                    'images_count' => 5,
                    'tags' => ['content', 'kindergarten', 'magic', 'text', 'image box', 'image'],
                ],
                't27-kindergarten-magic-section-4' => [
                    'title' => esc_html__('This program is designed - Kindergarten Magic', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't27-kindergarten-magic',
                    'section_number' => 4,
                    'images_count' => 7,
                    'tags' => ['hero', 'kindergarten', 'magic', 'text', 'heading', 'button', 'counter'],
                ],
                't27-kindergarten-magic-section-5' => [
                    'title' => esc_html__('Our staff is not - Kindergarten Magic', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't27-kindergarten-magic',
                    'section_number' => 5,
                    'images_count' => 4,
                    'tags' => ['cta', 'kindergarten', 'magic', 'text', 'image', 'button'],
                ],
                't27-kindergarten-magic-section-6' => [
                    'title' => esc_html__('We believe in open - Kindergarten Magic', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't27-kindergarten-magic',
                    'section_number' => 6,
                    'images_count' => 6,
                    'tags' => ['content', 'kindergarten', 'magic', 'image', 'text', 'image box'],
                ],
                't27-kindergarten-magic-section-7' => [
                    'title' => esc_html__('We believe in open - Kindergarten Magic', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't27-kindergarten-magic',
                    'section_number' => 7,
                    'images_count' => 7,
                    'tags' => ['content', 'kindergarten', 'magic', 'text', 'king addons card carousel'],
                ],
                't27-kindergarten-magic-section-8' => [
                    'title' => esc_html__('We believe in open - Kindergarten Magic', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't27-kindergarten-magic',
                    'section_number' => 8,
                    'images_count' => 2,
                    'tags' => ['content', 'kindergarten', 'magic', 'text', 'king addons blog posts'],
                ],
                't27-kindergarten-magic-section-9' => [
                    'title' => esc_html__('We believe in open - Kindergarten Magic', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't27-kindergarten-magic',
                    'section_number' => 9,
                    'images_count' => 3,
                    'tags' => ['cta', 'kindergarten', 'magic', 'text', 'button'],
                ],
                't27-our-menu-section-1' => [
                    'title' => esc_html__('Because Every Child Deserves - Our Menu', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't27-our-menu',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['content', 'our', 'menu', 'text'],
                ],
                't27-our-menu-section-2' => [
                    'title' => esc_html__('Our Menu - Gallery Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'galleries',
                    'section_type' => 'gallery',
                    'parent_template' => 't27-our-menu',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['gallery', 'our', 'menu', 'image'],
                ],
                't27-our-menu-section-3' => [
                    'title' => esc_html__('We believe in open - Our Menu', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't27-our-menu',
                    'section_number' => 3,
                    'images_count' => 3,
                    'tags' => ['content', 'our', 'menu', 'text', 'image'],
                ],
                't27-our-menu-section-4' => [
                    'title' => esc_html__('We believe in open - Our Menu', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't27-our-menu',
                    'section_number' => 4,
                    'images_count' => 3,
                    'tags' => ['cta', 'our', 'menu', 'text', 'button'],
                ],
                't27-our-services-section-1' => [
                    'title' => esc_html__('Creating Safe and Loving - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't27-our-services',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['content', 'our', 'services', 'text'],
                ],
                't27-our-services-section-2' => [
                    'title' => esc_html__('Our Services - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't27-our-services',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['general', 'our', 'services', 'king addons video popup'],
                ],
                't27-our-services-section-3' => [
                    'title' => esc_html__('The safety and well-being - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't27-our-services',
                    'section_number' => 3,
                    'images_count' => 5,
                    'tags' => ['content', 'our', 'services', 'text', 'image box', 'image'],
                ],
                't27-our-services-section-4' => [
                    'title' => esc_html__('We believe in open - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't27-our-services',
                    'section_number' => 4,
                    'images_count' => 6,
                    'tags' => ['content', 'our', 'services', 'image', 'text', 'image box'],
                ],
                't27-our-services-section-5' => [
                    'title' => esc_html__('We believe that when - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't27-our-services',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['content', 'our', 'services', 'text'],
                ],
                't27-our-services-section-6' => [
                    'title' => esc_html__('We believe in open - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't27-our-services',
                    'section_number' => 6,
                    'images_count' => 3,
                    'tags' => ['cta', 'our', 'services', 'text', 'button'],
                ],
                't27-our-team-section-1' => [
                    'title' => esc_html__('Finding the Perfect Nanny - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't27-our-team',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['content', 'our', 'team', 'text'],
                ],
                't27-our-team-section-2' => [
                    'title' => esc_html__('Our Team - Gallery Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'galleries',
                    'section_type' => 'gallery',
                    'parent_template' => 't27-our-team',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['gallery', 'our', 'team', 'image'],
                ],
                't27-our-team-section-3' => [
                    'title' => esc_html__('Physical Education Teacher - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't27-our-team',
                    'section_number' => 3,
                    'images_count' => 11,
                    'tags' => ['header', 'our', 'team', 'image', 'text', 'heading', 'social icons', 'divider'],
                ],
                't27-our-team-section-4' => [
                    'title' => esc_html__('We believe in open - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't27-our-team',
                    'section_number' => 4,
                    'images_count' => 3,
                    'tags' => ['cta', 'our', 'team', 'text', 'button'],
                ],
                't27-preschool-adventures-section-1' => [
                    'title' => esc_html__('We believe in open - Preschool Adventures', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'education',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't27-preschool-adventures',
                    'section_number' => 1,
                    'images_count' => 6,
                    'tags' => ['cta', 'preschool', 'adventures', 'image', 'text', 'button'],
                ],
                't27-preschool-adventures-section-2' => [
                    'title' => esc_html__('Preschool Adventures - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'education',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't27-preschool-adventures',
                    'section_number' => 2,
                    'images_count' => 9,
                    'tags' => ['general', 'preschool', 'adventures', 'image carousel'],
                ],
                't27-preschool-adventures-section-3' => [
                    'title' => esc_html__('Our approach focuses on - Preschool Adventures', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'education',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't27-preschool-adventures',
                    'section_number' => 3,
                    'images_count' => 6,
                    'tags' => ['content', 'preschool', 'adventures', 'image', 'text', 'image box'],
                ],
                't27-preschool-adventures-section-4' => [
                    'title' => esc_html__('This program is designed - Preschool Adventures', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'education',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't27-preschool-adventures',
                    'section_number' => 4,
                    'images_count' => 7,
                    'tags' => ['hero', 'preschool', 'adventures', 'text', 'counter', 'heading', 'button'],
                ],
                't27-preschool-adventures-section-5' => [
                    'title' => esc_html__('The safety and well-being - Preschool Adventures', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'education',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't27-preschool-adventures',
                    'section_number' => 5,
                    'images_count' => 5,
                    'tags' => ['content', 'preschool', 'adventures', 'text', 'image box', 'image'],
                ],
                't27-preschool-adventures-section-6' => [
                    'title' => esc_html__('We believe in open - Preschool Adventures', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'education',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't27-preschool-adventures',
                    'section_number' => 6,
                    'images_count' => 11,
                    'tags' => ['content', 'preschool', 'adventures', 'image', 'text', 'king addons card carousel'],
                ],
                't27-preschool-adventures-section-7' => [
                    'title' => esc_html__('We believe in open - Preschool Adventures', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'education',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't27-preschool-adventures',
                    'section_number' => 7,
                    'images_count' => 2,
                    'tags' => ['content', 'preschool', 'adventures', 'text', 'king addons blog posts'],
                ],
                't27-preschool-adventures-section-8' => [
                    'title' => esc_html__('We believe in open - Preschool Adventures', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'education',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't27-preschool-adventures',
                    'section_number' => 8,
                    'images_count' => 8,
                    'tags' => ['content', 'preschool', 'adventures', 'text', 'king addons card carousel', 'image'],
                ],
                't27-preschool-adventures-section-9' => [
                    'title' => esc_html__('We believe in open - Preschool Adventures', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'education',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't27-preschool-adventures',
                    'section_number' => 9,
                    'images_count' => 4,
                    'tags' => ['cta', 'preschool', 'adventures', 'image', 'text', 'button'],
                ],
                't27-where-little-minds-blossom-section-1' => [
                    'title' => esc_html__('The safety and well-being - Where Little Minds Blossom', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't27-where-little-minds-blossom',
                    'section_number' => 1,
                    'images_count' => 4,
                    'tags' => ['cta', 'where', 'little', 'minds', 'blossom', 'text', 'button', 'image box'],
                ],
                't27-where-little-minds-blossom-section-2' => [
                    'title' => esc_html__('Where Little Minds Blossom - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't27-where-little-minds-blossom',
                    'section_number' => 2,
                    'images_count' => 9,
                    'tags' => ['general', 'where', 'little', 'minds', 'blossom', 'image carousel'],
                ],
                't27-where-little-minds-blossom-section-3' => [
                    'title' => esc_html__('The safety and well-being - Where Little Minds Blossom', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't27-where-little-minds-blossom',
                    'section_number' => 3,
                    'images_count' => 5,
                    'tags' => ['content', 'where', 'little', 'minds', 'blossom', 'text', 'image box', 'image'],
                ],
                't27-where-little-minds-blossom-section-4' => [
                    'title' => esc_html__('This program is designed - Where Little Minds Blossom', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't27-where-little-minds-blossom',
                    'section_number' => 4,
                    'images_count' => 7,
                    'tags' => ['hero', 'where', 'little', 'minds', 'blossom', 'text', 'heading', 'button', 'counter'],
                ],
                't27-where-little-minds-blossom-section-5' => [
                    'title' => esc_html__('We believe that when - Where Little Minds Blossom', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't27-where-little-minds-blossom',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['content', 'where', 'little', 'minds', 'blossom', 'text'],
                ],
                't27-where-little-minds-blossom-section-6' => [
                    'title' => esc_html__('Our staff is not - Where Little Minds Blossom', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't27-where-little-minds-blossom',
                    'section_number' => 6,
                    'images_count' => 4,
                    'tags' => ['cta', 'where', 'little', 'minds', 'blossom', 'text', 'image', 'button'],
                ],
                't27-where-little-minds-blossom-section-7' => [
                    'title' => esc_html__('We believe in open - Where Little Minds Blossom', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't27-where-little-minds-blossom',
                    'section_number' => 7,
                    'images_count' => 6,
                    'tags' => ['content', 'where', 'little', 'minds', 'blossom', 'image', 'text', 'image box'],
                ],
                't27-where-little-minds-blossom-section-8' => [
                    'title' => esc_html__('We believe in open - Where Little Minds Blossom', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't27-where-little-minds-blossom',
                    'section_number' => 8,
                    'images_count' => 7,
                    'tags' => ['content', 'where', 'little', 'minds', 'blossom', 'text', 'king addons card carousel'],
                ],
                't27-where-little-minds-blossom-section-9' => [
                    'title' => esc_html__('We believe in open - Where Little Minds Blossom', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't27-where-little-minds-blossom',
                    'section_number' => 9,
                    'images_count' => 2,
                    'tags' => ['content', 'where', 'little', 'minds', 'blossom', 'text', 'king addons blog posts'],
                ],
                't27-where-little-minds-blossom-section-10' => [
                    'title' => esc_html__('The safety and well-being - Where Little Minds Blossom', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't27-where-little-minds-blossom',
                    'section_number' => 10,
                    'images_count' => 1,
                    'tags' => ['cta', 'where', 'little', 'minds', 'blossom', 'text', 'button'],
                ],
                't28-about-us-section-1' => [
                    'title' => esc_html__('Your Trusted Source for - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't28-about-us',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['content', 'about', 'text'],
                ],
                't28-about-us-section-2' => [
                    'title' => esc_html__('About Us - Gallery Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'galleries',
                    'section_type' => 'gallery',
                    'parent_template' => 't28-about-us',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['gallery', 'about', 'image'],
                ],
                't28-about-us-section-3' => [
                    'title' => esc_html__('We adhere to the - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't28-about-us',
                    'section_number' => 3,
                    'images_count' => 8,
                    'tags' => ['content', 'about', 'text', 'image'],
                ],
                't28-about-us-section-4' => [
                    'title' => esc_html__('As industry leaders, we - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't28-about-us',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['header', 'about', 'text', 'counter', 'heading'],
                ],
                't28-about-us-section-5' => [
                    'title' => esc_html__('With a legacy of - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't28-about-us',
                    'section_number' => 5,
                    'images_count' => 8,
                    'tags' => ['content', 'about', 'image', 'text', 'image carousel'],
                ],
                't28-about-us-section-6' => [
                    'title' => esc_html__('When you work with - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't28-about-us',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['cta', 'about', 'text', 'button'],
                ],
                't28-certificates-section-1' => [
                    'title' => esc_html__('Certificates and Accreditations - Certificates', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't28-certificates',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['content', 'certificates', 'text'],
                ],
                't28-certificates-section-2' => [
                    'title' => esc_html__('Certificates - Gallery Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'galleries',
                    'section_type' => 'gallery',
                    'parent_template' => 't28-certificates',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['gallery', 'certificates', 'image'],
                ],
                't28-certificates-section-3' => [
                    'title' => esc_html__('We adhere to the - Certificates', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't28-certificates',
                    'section_number' => 3,
                    'images_count' => 8,
                    'tags' => ['content', 'certificates', 'text', 'image box'],
                ],
                't28-certificates-section-4' => [
                    'title' => esc_html__('When you work with - Certificates', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't28-certificates',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['cta', 'certificates', 'text', 'button'],
                ],
                't28-contact-us-section-1' => [
                    'title' => esc_html__('Contact Our Metallurgy Team - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't28-contact-us',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['content', 'contact', 'text'],
                ],
                't28-contact-us-section-2' => [
                    'title' => esc_html__('Contact Us - Gallery Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'galleries',
                    'section_type' => 'gallery',
                    'parent_template' => 't28-contact-us',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['gallery', 'contact', 'image'],
                ],
                't28-contact-us-section-3' => [
                    'title' => esc_html__('Ask Us a Question... - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't28-contact-us',
                    'section_number' => 3,
                    'images_count' => 6,
                    'tags' => ['content', 'contact', 'text', 'shortcode', 'spacer', 'eael info box'],
                ],
                't28-contact-us-section-4' => [
                    'title' => esc_html__('Our metallurgy careers section - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't28-contact-us',
                    'section_number' => 4,
                    'images_count' => 4,
                    'tags' => ['cta', 'contact', 'image', 'text path', 'text', 'button'],
                ],
                't28-contact-us-section-5' => [
                    'title' => esc_html__('Contact Us - General Section 5', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't28-contact-us',
                    'section_number' => 5,
                    'images_count' => 0,
                    'tags' => ['general', 'contact', 'google_maps'],
                ],
                't28-crafting-metals-section-1' => [
                    'title' => esc_html__('When you work with - Crafting Metals', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't28-crafting-metals',
                    'section_number' => 1,
                    'images_count' => 5,
                    'tags' => ['cta', 'crafting', 'metals', 'text', 'button', 'king addons video popup', 'image'],
                ],
                't28-crafting-metals-section-2' => [
                    'title' => esc_html__('Crafting Metals - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't28-crafting-metals',
                    'section_number' => 2,
                    'images_count' => 8,
                    'tags' => ['general', 'crafting', 'metals', 'image carousel'],
                ],
                't28-crafting-metals-section-3' => [
                    'title' => esc_html__('Our dedicated team of - Crafting Metals', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't28-crafting-metals',
                    'section_number' => 3,
                    'images_count' => 4,
                    'tags' => ['cta', 'crafting', 'metals', 'image', 'text path', 'text', 'button'],
                ],
                't28-crafting-metals-section-4' => [
                    'title' => esc_html__('Every step of our - Crafting Metals', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't28-crafting-metals',
                    'section_number' => 4,
                    'images_count' => 9,
                    'tags' => ['content', 'crafting', 'metals', 'text', 'image box', 'king addons auto scrolling text', 'king addons feature list', 'image'],
                ],
                't28-crafting-metals-section-5' => [
                    'title' => esc_html__('We adhere to the - Crafting Metals', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't28-crafting-metals',
                    'section_number' => 5,
                    'images_count' => 8,
                    'tags' => ['content', 'crafting', 'metals', 'text', 'image'],
                ],
                't28-crafting-metals-section-6' => [
                    'title' => esc_html__('Your success is our - Crafting Metals', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't28-crafting-metals',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['content', 'crafting', 'metals', 'text'],
                ],
                't28-crafting-metals-section-7' => [
                    'title' => esc_html__('Our metallurgy careers section - Crafting Metals', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't28-crafting-metals',
                    'section_number' => 7,
                    'images_count' => 4,
                    'tags' => ['cta', 'crafting', 'metals', 'image', 'text path', 'text', 'button'],
                ],
                't28-crafting-metals-section-8' => [
                    'title' => esc_html__('Your Trusted Source for - Crafting Metals', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't28-crafting-metals',
                    'section_number' => 8,
                    'images_count' => 2,
                    'tags' => ['content', 'crafting', 'metals', 'text', 'king addons blog posts'],
                ],
                't28-crafting-metals-section-9' => [
                    'title' => esc_html__('When you work with - Crafting Metals', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't28-crafting-metals',
                    'section_number' => 9,
                    'images_count' => 1,
                    'tags' => ['cta', 'crafting', 'metals', 'text', 'button'],
                ],
                't28-excellence-in-metal-section-1' => [
                    'title' => esc_html__('When you work with - Excellence In Metal', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't28-excellence-in-metal',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['hero', 'excellence', 'metal', 'text', 'button', 'heading'],
                ],
                't28-excellence-in-metal-section-2' => [
                    'title' => esc_html__('We adhere to the - Excellence In Metal', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't28-excellence-in-metal',
                    'section_number' => 2,
                    'images_count' => 8,
                    'tags' => ['content', 'excellence', 'metal', 'text', 'image'],
                ],
                't28-excellence-in-metal-section-3' => [
                    'title' => esc_html__('As industry leaders, we - Excellence In Metal', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't28-excellence-in-metal',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['header', 'excellence', 'metal', 'text', 'counter', 'heading'],
                ],
                't28-excellence-in-metal-section-4' => [
                    'title' => esc_html__('Our dedicated team of - Excellence In Metal', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't28-excellence-in-metal',
                    'section_number' => 4,
                    'images_count' => 4,
                    'tags' => ['cta', 'excellence', 'metal', 'image', 'text path', 'text', 'button'],
                ],
                't28-excellence-in-metal-section-5' => [
                    'title' => esc_html__('Every step of our - Excellence In Metal', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't28-excellence-in-metal',
                    'section_number' => 5,
                    'images_count' => 9,
                    'tags' => ['content', 'excellence', 'metal', 'text', 'image box', 'king addons auto scrolling text', 'king addons feature list', 'image'],
                ],
                't28-excellence-in-metal-section-6' => [
                    'title' => esc_html__('Your success is our - Excellence In Metal', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't28-excellence-in-metal',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['content', 'excellence', 'metal', 'text'],
                ],
                't28-excellence-in-metal-section-7' => [
                    'title' => esc_html__('With a legacy of - Excellence In Metal', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't28-excellence-in-metal',
                    'section_number' => 7,
                    'images_count' => 8,
                    'tags' => ['content', 'excellence', 'metal', 'image', 'text', 'image carousel'],
                ],
                't28-excellence-in-metal-section-8' => [
                    'title' => esc_html__('When you work with - Excellence In Metal', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't28-excellence-in-metal',
                    'section_number' => 8,
                    'images_count' => 1,
                    'tags' => ['cta', 'excellence', 'metal', 'text', 'button'],
                ],
                't28-future-in-metals-section-1' => [
                    'title' => esc_html__('Our dedicated team of - Future In Metals', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't28-future-in-metals',
                    'section_number' => 1,
                    'images_count' => 5,
                    'tags' => ['cta', 'future', 'metals', 'text', 'button', 'image', 'text path'],
                ],
                't28-future-in-metals-section-2' => [
                    'title' => esc_html__('Future In Metals - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't28-future-in-metals',
                    'section_number' => 2,
                    'images_count' => 8,
                    'tags' => ['general', 'future', 'metals', 'image carousel'],
                ],
                't28-future-in-metals-section-3' => [
                    'title' => esc_html__('Our dedicated team of - Future In Metals', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't28-future-in-metals',
                    'section_number' => 3,
                    'images_count' => 4,
                    'tags' => ['cta', 'future', 'metals', 'image', 'text path', 'text', 'button'],
                ],
                't28-future-in-metals-section-4' => [
                    'title' => esc_html__('Every step of our - Future In Metals', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't28-future-in-metals',
                    'section_number' => 4,
                    'images_count' => 8,
                    'tags' => ['content', 'future', 'metals', 'text', 'image box', 'king addons auto scrolling text'],
                ],
                't28-future-in-metals-section-5' => [
                    'title' => esc_html__('Your success is our - Future In Metals', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't28-future-in-metals',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['content', 'future', 'metals', 'text'],
                ],
                't28-future-in-metals-section-6' => [
                    'title' => esc_html__('We adhere to the - Future In Metals', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't28-future-in-metals',
                    'section_number' => 6,
                    'images_count' => 5,
                    'tags' => ['content', 'future', 'metals', 'text', 'image box'],
                ],
                't28-future-in-metals-section-7' => [
                    'title' => esc_html__('As industry leaders, we - Future In Metals', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't28-future-in-metals',
                    'section_number' => 7,
                    'images_count' => 1,
                    'tags' => ['header', 'future', 'metals', 'text', 'counter', 'heading'],
                ],
                't28-future-in-metals-section-8' => [
                    'title' => esc_html__('With a legacy of - Future In Metals', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't28-future-in-metals',
                    'section_number' => 8,
                    'images_count' => 8,
                    'tags' => ['content', 'future', 'metals', 'image', 'text', 'image carousel'],
                ],
                't28-future-in-metals-section-9' => [
                    'title' => esc_html__('When you work with - Future In Metals', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't28-future-in-metals',
                    'section_number' => 9,
                    'images_count' => 2,
                    'tags' => ['cta', 'future', 'metals', 'text', 'button'],
                ],
                't28-metal-solutions-section-1' => [
                    'title' => esc_html__('When you work with - Metal Solutions', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't28-metal-solutions',
                    'section_number' => 1,
                    'images_count' => 4,
                    'tags' => ['hero', 'metal', 'solutions', 'text', 'button', 'heading', 'image', 'text path'],
                ],
                't28-metal-solutions-section-2' => [
                    'title' => esc_html__('We adhere to the - Metal Solutions', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't28-metal-solutions',
                    'section_number' => 2,
                    'images_count' => 8,
                    'tags' => ['content', 'metal', 'solutions', 'text', 'image'],
                ],
                't28-metal-solutions-section-3' => [
                    'title' => esc_html__('As industry leaders, we - Metal Solutions', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't28-metal-solutions',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['header', 'metal', 'solutions', 'text', 'counter', 'heading'],
                ],
                't28-metal-solutions-section-4' => [
                    'title' => esc_html__('Our dedicated team of - Metal Solutions', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't28-metal-solutions',
                    'section_number' => 4,
                    'images_count' => 4,
                    'tags' => ['cta', 'metal', 'solutions', 'image', 'text path', 'text', 'button'],
                ],
                't28-metal-solutions-section-5' => [
                    'title' => esc_html__('Every step of our - Metal Solutions', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't28-metal-solutions',
                    'section_number' => 5,
                    'images_count' => 9,
                    'tags' => ['content', 'metal', 'solutions', 'text', 'image box', 'king addons auto scrolling text', 'king addons feature list', 'image'],
                ],
                't28-metal-solutions-section-6' => [
                    'title' => esc_html__('Your success is our - Metal Solutions', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't28-metal-solutions',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['content', 'metal', 'solutions', 'text'],
                ],
                't28-metal-solutions-section-7' => [
                    'title' => esc_html__('Your Trusted Source for - Metal Solutions', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't28-metal-solutions',
                    'section_number' => 7,
                    'images_count' => 2,
                    'tags' => ['content', 'metal', 'solutions', 'text', 'king addons blog posts'],
                ],
                't28-metal-solutions-section-8' => [
                    'title' => esc_html__('When you work with - Metal Solutions', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't28-metal-solutions',
                    'section_number' => 8,
                    'images_count' => 1,
                    'tags' => ['cta', 'metal', 'solutions', 'text', 'button'],
                ],
                't28-our-services-section-1' => [
                    'title' => esc_html__('Strength in Every Alloy, - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't28-our-services',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['content', 'our', 'services', 'text'],
                ],
                't28-our-services-section-2' => [
                    'title' => esc_html__('Our Services - Gallery Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'galleries',
                    'section_type' => 'gallery',
                    'parent_template' => 't28-our-services',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['gallery', 'our', 'services', 'image'],
                ],
                't28-our-services-section-3' => [
                    'title' => esc_html__('Our dedicated team of - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't28-our-services',
                    'section_number' => 3,
                    'images_count' => 4,
                    'tags' => ['cta', 'our', 'services', 'image', 'text path', 'text', 'button'],
                ],
                't28-our-services-section-4' => [
                    'title' => esc_html__('Every step of our - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't28-our-services',
                    'section_number' => 4,
                    'images_count' => 9,
                    'tags' => ['content', 'our', 'services', 'text', 'image box', 'king addons auto scrolling text', 'king addons feature list', 'image'],
                ],
                't28-our-services-section-5' => [
                    'title' => esc_html__('When you work with - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't28-our-services',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['cta', 'our', 'services', 'text', 'button'],
                ],
                't29-beekeeping-gallery-section-1' => [
                    'title' => esc_html__('Savor the Golden Moments - Beekeeping Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't29-beekeeping-gallery',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['content', 'beekeeping', 'gallery', 'text', 'image'],
                ],
                't29-beekeeping-gallery-section-2' => [
                    'title' => esc_html__('Beekeeping Gallery - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't29-beekeeping-gallery',
                    'section_number' => 2,
                    'images_count' => 12,
                    'tags' => ['general', 'beekeeping', 'gallery', 'king addons image grid'],
                ],
                't29-beekeeping-gallery-section-3' => [
                    'title' => esc_html__('Our honey is a - Beekeeping Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't29-beekeeping-gallery',
                    'section_number' => 3,
                    'images_count' => 3,
                    'tags' => ['cta', 'beekeeping', 'gallery', 'text', 'button', 'image'],
                ],
                't29-contact-us-section-1' => [
                    'title' => esc_html__('Join the Sweet Revolution - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't29-contact-us',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['content', 'contact', 'text', 'image'],
                ],
                't29-contact-us-section-2' => [
                    'title' => esc_html__('Contact Us - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't29-contact-us',
                    'section_number' => 2,
                    'images_count' => 0,
                    'tags' => ['general', 'contact', 'icon box'],
                ],
                't29-contact-us-section-3' => [
                    'title' => esc_html__('Our honey is a - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't29-contact-us',
                    'section_number' => 3,
                    'images_count' => 5,
                    'tags' => ['header', 'contact', 'spacer', 'heading', 'shortcode', 'text', 'image', 'google_maps'],
                ],
                't29-contact-us-section-4' => [
                    'title' => esc_html__('From breakfast to dessert, - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't29-contact-us',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['content', 'contact', 'text'],
                ],
                't29-contact-us-section-5' => [
                    'title' => esc_html__('Explore a world of - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't29-contact-us',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['cta', 'contact', 'text', 'button'],
                ],
                't29-from-hive-to-table-section-1' => [
                    'title' => esc_html__('Our honey is a - From Hive To Table', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't29-from-hive-to-table',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['cta', 'from', 'hive', 'table', 'text', 'button'],
                ],
                't29-from-hive-to-table-section-2' => [
                    'title' => esc_html__('Each jar of our - From Hive To Table', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't29-from-hive-to-table',
                    'section_number' => 2,
                    'images_count' => 7,
                    'tags' => ['cta', 'from', 'hive', 'table', 'image', 'text', 'button'],
                ],
                't29-from-hive-to-table-section-3' => [
                    'title' => esc_html__('From breakfast to dessert, - From Hive To Table', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't29-from-hive-to-table',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['content', 'from', 'hive', 'table', 'text'],
                ],
                't29-from-hive-to-table-section-4' => [
                    'title' => esc_html__('Our honey is a - From Hive To Table', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't29-from-hive-to-table',
                    'section_number' => 4,
                    'images_count' => 5,
                    'tags' => ['cta', 'from', 'hive', 'table', 'text', 'image', 'button'],
                ],
                't29-from-hive-to-table-section-5' => [
                    'title' => esc_html__('Our honey is a - From Hive To Table', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't29-from-hive-to-table',
                    'section_number' => 5,
                    'images_count' => 6,
                    'tags' => ['content', 'from', 'hive', 'table', 'text', 'image', 'image box'],
                ],
                't29-from-hive-to-table-section-6' => [
                    'title' => esc_html__('Whether you\'re gifting it - From Hive To Table', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't29-from-hive-to-table',
                    'section_number' => 6,
                    'images_count' => 7,
                    'tags' => ['cta', 'from', 'hive', 'table', 'text', 'button', 'image', 'text path'],
                ],
                't29-from-hive-to-table-section-7' => [
                    'title' => esc_html__('From Hive To Table - General Section 7', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't29-from-hive-to-table',
                    'section_number' => 7,
                    'images_count' => 1,
                    'tags' => ['general', 'from', 'hive', 'table', 'king addons video popup'],
                ],
                't29-from-hive-to-table-section-8' => [
                    'title' => esc_html__('Our honey is a - From Hive To Table', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't29-from-hive-to-table',
                    'section_number' => 8,
                    'images_count' => 3,
                    'tags' => ['cta', 'from', 'hive', 'table', 'text', 'button', 'image'],
                ],
                't29-natures-sweetness-section-1' => [
                    'title' => esc_html__('Our honey is a - Natures Sweetness', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't29-natures-sweetness',
                    'section_number' => 1,
                    'images_count' => 10,
                    'tags' => ['cta', 'natures', 'sweetness', 'image', 'text', 'button'],
                ],
                't29-natures-sweetness-section-2' => [
                    'title' => esc_html__('Natures Sweetness - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't29-natures-sweetness',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['general', 'natures', 'sweetness', 'image box'],
                ],
                't29-natures-sweetness-section-3' => [
                    'title' => esc_html__('Whether you\'re gifting it - Natures Sweetness', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't29-natures-sweetness',
                    'section_number' => 3,
                    'images_count' => 7,
                    'tags' => ['cta', 'natures', 'sweetness', 'text', 'button', 'image', 'text path'],
                ],
                't29-natures-sweetness-section-4' => [
                    'title' => esc_html__('Our honey is a - Natures Sweetness', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't29-natures-sweetness',
                    'section_number' => 4,
                    'images_count' => 6,
                    'tags' => ['content', 'natures', 'sweetness', 'text', 'image', 'image box'],
                ],
                't29-natures-sweetness-section-5' => [
                    'title' => esc_html__('Each jar of our - Natures Sweetness', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't29-natures-sweetness',
                    'section_number' => 5,
                    'images_count' => 7,
                    'tags' => ['cta', 'natures', 'sweetness', 'image', 'text', 'button'],
                ],
                't29-natures-sweetness-section-6' => [
                    'title' => esc_html__('From breakfast to dessert, - Natures Sweetness', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't29-natures-sweetness',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['content', 'natures', 'sweetness', 'text'],
                ],
                't29-natures-sweetness-section-7' => [
                    'title' => esc_html__('Our honey is a - Natures Sweetness', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't29-natures-sweetness',
                    'section_number' => 7,
                    'images_count' => 9,
                    'tags' => ['content', 'natures', 'sweetness', 'text', 'king addons card carousel'],
                ],
                't29-natures-sweetness-section-8' => [
                    'title' => esc_html__('Natures Sweetness - General Section 8', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't29-natures-sweetness',
                    'section_number' => 8,
                    'images_count' => 1,
                    'tags' => ['general', 'natures', 'sweetness', 'king addons video popup'],
                ],
                't29-natures-sweetness-section-9' => [
                    'title' => esc_html__('Our honey is a - Natures Sweetness', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't29-natures-sweetness',
                    'section_number' => 9,
                    'images_count' => 8,
                    'tags' => ['header', 'natures', 'sweetness', 'text', 'heading', 'king addons card carousel'],
                ],
                't29-natures-sweetness-section-10' => [
                    'title' => esc_html__('Explore a world of - Natures Sweetness', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't29-natures-sweetness',
                    'section_number' => 10,
                    'images_count' => 1,
                    'tags' => ['cta', 'natures', 'sweetness', 'text', 'button'],
                ],
                't29-our-services-section-1' => [
                    'title' => esc_html__('Sustainable Beekeeping Practices - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't29-our-services',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['content', 'our', 'services', 'text', 'image'],
                ],
                't29-our-services-section-2' => [
                    'title' => esc_html__(' You can trust - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't29-our-services',
                    'section_number' => 2,
                    'images_count' => 0,
                    'tags' => ['content', 'our', 'services', 'divider', 'text'],
                ],
                't29-our-services-section-3' => [
                    'title' => esc_html__('Our honey is a - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't29-our-services',
                    'section_number' => 3,
                    'images_count' => 5,
                    'tags' => ['cta', 'our', 'services', 'text', 'image', 'button'],
                ],
                't29-our-services-section-4' => [
                    'title' => esc_html__('Our honey is a - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't29-our-services',
                    'section_number' => 4,
                    'images_count' => 6,
                    'tags' => ['content', 'our', 'services', 'text', 'image', 'image box'],
                ],
                't29-our-services-section-5' => [
                    'title' => esc_html__('Our honey is a - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't29-our-services',
                    'section_number' => 5,
                    'images_count' => 3,
                    'tags' => ['cta', 'our', 'services', 'text', 'button', 'image'],
                ],
                't29-sweet-dreams-section-1' => [
                    'title' => esc_html__('Our honey is a - Sweet Dreams', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't29-sweet-dreams',
                    'section_number' => 1,
                    'images_count' => 6,
                    'tags' => ['cta', 'sweet', 'dreams', 'text', 'image', 'button'],
                ],
                't29-sweet-dreams-section-3' => [
                    'title' => esc_html__('Each jar of our - Sweet Dreams', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't29-sweet-dreams',
                    'section_number' => 3,
                    'images_count' => 7,
                    'tags' => ['cta', 'sweet', 'dreams', 'image', 'text', 'button'],
                ],
                't29-sweet-dreams-section-4' => [
                    'title' => esc_html__('From breakfast to dessert, - Sweet Dreams', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't29-sweet-dreams',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['content', 'sweet', 'dreams', 'text'],
                ],
                't29-sweet-dreams-section-5' => [
                    'title' => esc_html__('Our honey is a - Sweet Dreams', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't29-sweet-dreams',
                    'section_number' => 5,
                    'images_count' => 9,
                    'tags' => ['content', 'sweet', 'dreams', 'text', 'king addons card carousel'],
                ],
                't29-sweet-dreams-section-6' => [
                    'title' => esc_html__('Our honey is a - Sweet Dreams', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't29-sweet-dreams',
                    'section_number' => 6,
                    'images_count' => 6,
                    'tags' => ['content', 'sweet', 'dreams', 'text', 'image', 'image box'],
                ],
                't29-sweet-dreams-section-7' => [
                    'title' => esc_html__('Whether you\'re gifting it - Sweet Dreams', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't29-sweet-dreams',
                    'section_number' => 7,
                    'images_count' => 7,
                    'tags' => ['cta', 'sweet', 'dreams', 'text', 'button', 'image', 'text path'],
                ],
                't29-sweet-dreams-section-8' => [
                    'title' => esc_html__('Sweet Dreams - General Section 8', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't29-sweet-dreams',
                    'section_number' => 8,
                    'images_count' => 1,
                    'tags' => ['general', 'sweet', 'dreams', 'king addons video popup'],
                ],
                't29-sweet-dreams-section-9' => [
                    'title' => esc_html__('Our honey is a - Sweet Dreams', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't29-sweet-dreams',
                    'section_number' => 9,
                    'images_count' => 2,
                    'tags' => ['content', 'sweet', 'dreams', 'text', 'king addons blog posts'],
                ],
                't29-sweet-dreams-section-10' => [
                    'title' => esc_html__('Explore a world of - Sweet Dreams', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't29-sweet-dreams',
                    'section_number' => 10,
                    'images_count' => 1,
                    'tags' => ['cta', 'sweet', 'dreams', 'text', 'button'],
                ],
                't29-sweetness-in-a-jar-section-1' => [
                    'title' => esc_html__('Our honey is a - Sweetness In A Jar', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't29-sweetness-in-a-jar',
                    'section_number' => 1,
                    'images_count' => 11,
                    'tags' => ['cta', 'sweetness', 'jar', 'text', 'button', 'image', 'king addons video popup'],
                ],
                't29-sweetness-in-a-jar-section-2' => [
                    'title' => esc_html__('Sweetness In A Jar - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't29-sweetness-in-a-jar',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['general', 'sweetness', 'jar', 'image box'],
                ],
                't29-sweetness-in-a-jar-section-3' => [
                    'title' => esc_html__('Each jar of our - Sweetness In A Jar', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't29-sweetness-in-a-jar',
                    'section_number' => 3,
                    'images_count' => 7,
                    'tags' => ['cta', 'sweetness', 'jar', 'image', 'text', 'button'],
                ],
                't29-sweetness-in-a-jar-section-4' => [
                    'title' => esc_html__('From breakfast to dessert, - Sweetness In A Jar', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't29-sweetness-in-a-jar',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['content', 'sweetness', 'jar', 'text'],
                ],
                't29-sweetness-in-a-jar-section-5' => [
                    'title' => esc_html__('Our honey is a - Sweetness In A Jar', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't29-sweetness-in-a-jar',
                    'section_number' => 5,
                    'images_count' => 9,
                    'tags' => ['content', 'sweetness', 'jar', 'text', 'king addons card carousel'],
                ],
                't29-sweetness-in-a-jar-section-6' => [
                    'title' => esc_html__('Our honey is a - Sweetness In A Jar', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't29-sweetness-in-a-jar',
                    'section_number' => 6,
                    'images_count' => 6,
                    'tags' => ['content', 'sweetness', 'jar', 'text', 'image', 'image box'],
                ],
                't29-sweetness-in-a-jar-section-7' => [
                    'title' => esc_html__('Whether you\'re gifting it - Sweetness In A Jar', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't29-sweetness-in-a-jar',
                    'section_number' => 7,
                    'images_count' => 7,
                    'tags' => ['cta', 'sweetness', 'jar', 'text', 'button', 'image', 'text path'],
                ],
                't29-sweetness-in-a-jar-section-8' => [
                    'title' => esc_html__('Sweetness In A Jar - General Section 8', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't29-sweetness-in-a-jar',
                    'section_number' => 8,
                    'images_count' => 1,
                    'tags' => ['general', 'sweetness', 'jar', 'king addons video popup'],
                ],
                't29-sweetness-in-a-jar-section-9' => [
                    'title' => esc_html__('Our honey is a - Sweetness In A Jar', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't29-sweetness-in-a-jar',
                    'section_number' => 9,
                    'images_count' => 3,
                    'tags' => ['cta', 'sweetness', 'jar', 'text', 'button', 'image'],
                ],
                't3-about-us-dark-section-1' => [
                    'title' => esc_html__('Invest in Bitcoin, Ethereum, - About Us Dark', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't3-about-us-dark',
                    'section_number' => 1,
                    'images_count' => 4,
                    'tags' => ['header', 'about', 'dark', 'text', 'image', 'heading'],
                ],
                't3-about-us-dark-section-2' => [
                    'title' => esc_html__('Invest in Bitcoin, Ethereum, - About Us Dark', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-about-us-dark',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['cta', 'about', 'dark', 'king addons image grid', 'text', 'button', 'counter'],
                ],
                't3-about-us-dark-section-3' => [
                    'title' => esc_html__('Invest in Bitcoin, Ethereum, - About Us Dark', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-about-us-dark',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['cta', 'about', 'dark', 'king addons video popup', 'text', 'button'],
                ],
                't3-about-us-dark-section-4' => [
                    'title' => esc_html__('Our company was founded - About Us Dark', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-about-us-dark',
                    'section_number' => 4,
                    'images_count' => 3,
                    'tags' => ['hero', 'about', 'dark', 'text', 'heading', 'image', 'button'],
                ],
                't3-about-us-dark-section-5' => [
                    'title' => esc_html__('About Us Dark - General Section 5', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't3-about-us-dark',
                    'section_number' => 5,
                    'images_count' => 4,
                    'tags' => ['general', 'about', 'dark', 'image'],
                ],
                't3-about-us-dark-section-6' => [
                    'title' => esc_html__('Our company was founded - About Us Dark', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't3-about-us-dark',
                    'section_number' => 6,
                    'images_count' => 5,
                    'tags' => ['header', 'about', 'dark', 'text', 'heading', 'image carousel'],
                ],
                't3-about-us-section-1' => [
                    'title' => esc_html__('Invest in Bitcoin, Ethereum, - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't3-about-us',
                    'section_number' => 1,
                    'images_count' => 5,
                    'tags' => ['header', 'about', 'text', 'image', 'heading'],
                ],
                't3-about-us-section-2' => [
                    'title' => esc_html__('Invest in Bitcoin, Ethereum, - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-about-us',
                    'section_number' => 2,
                    'images_count' => 4,
                    'tags' => ['cta', 'about', 'king addons image grid', 'text', 'button', 'counter'],
                ],
                't3-about-us-section-3' => [
                    'title' => esc_html__('Invest in Bitcoin, Ethereum, - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-about-us',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['cta', 'about', 'king addons video popup', 'text', 'button'],
                ],
                't3-about-us-section-4' => [
                    'title' => esc_html__('Our company was founded - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-about-us',
                    'section_number' => 4,
                    'images_count' => 4,
                    'tags' => ['hero', 'about', 'text', 'heading', 'image', 'button'],
                ],
                't3-about-us-section-5' => [
                    'title' => esc_html__('About Us - General Section 5', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't3-about-us',
                    'section_number' => 5,
                    'images_count' => 4,
                    'tags' => ['general', 'about', 'image'],
                ],
                't3-about-us-section-6' => [
                    'title' => esc_html__('Our company was founded - About Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't3-about-us',
                    'section_number' => 6,
                    'images_count' => 7,
                    'tags' => ['header', 'about', 'text', 'heading', 'image carousel'],
                ],
                't3-blockchain-services-section-1' => [
                    'title' => esc_html__('We’ve worked with over - Blockchain Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-blockchain-services',
                    'section_number' => 1,
                    'images_count' => 4,
                    'tags' => ['cta', 'blockchain', 'services', 'text', 'button', 'icon list', 'image'],
                ],
                't3-blockchain-services-section-2' => [
                    'title' => esc_html__('We’ve worked with over - Blockchain Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-blockchain-services',
                    'section_number' => 2,
                    'images_count' => 8,
                    'tags' => ['hero', 'blockchain', 'services', 'image carousel', 'text', 'image', 'heading', 'button'],
                ],
                't3-blockchain-services-section-3' => [
                    'title' => esc_html__('Our team has created - Blockchain Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't3-blockchain-services',
                    'section_number' => 3,
                    'images_count' => 5,
                    'tags' => ['content', 'blockchain', 'services', 'image', 'text'],
                ],
                't3-blockchain-services-section-4' => [
                    'title' => esc_html__('We’ve worked with over - Blockchain Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-blockchain-services',
                    'section_number' => 4,
                    'images_count' => 3,
                    'tags' => ['hero', 'blockchain', 'services', 'text', 'heading', 'button', 'image', 'king addons video popup', 'star rating'],
                ],
                't3-blockchain-services-section-5' => [
                    'title' => esc_html__('We’ve worked with over - Blockchain Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-blockchain-services',
                    'section_number' => 5,
                    'images_count' => 2,
                    'tags' => ['cta', 'blockchain', 'services', 'text', 'toggle', 'image', 'button'],
                ],
                't3-contact-us-dark-section-1' => [
                    'title' => esc_html__('Monday: 8:00 – 17:00Tuesday: - Contact Us Dark', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't3-contact-us-dark',
                    'section_number' => 1,
                    'images_count' => 0,
                    'tags' => ['header', 'contact', 'dark', 'text', 'heading', 'icon list', 'shortcode'],
                ],
                't3-contact-us-dark-section-2' => [
                    'title' => esc_html__('Invest in Bitcoin, Ethereum, - Contact Us Dark', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-contact-us-dark',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['hero', 'contact', 'dark', 'text', 'image', 'heading', 'button'],
                ],
                't3-contact-us-dark-section-3' => [
                    'title' => esc_html__('Our company was founded - Contact Us Dark', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't3-contact-us-dark',
                    'section_number' => 3,
                    'images_count' => 8,
                    'tags' => ['header', 'contact', 'dark', 'text', 'heading', 'image carousel'],
                ],
                't3-contact-us-dark-section-4' => [
                    'title' => esc_html__('How to get to - Contact Us Dark', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't3-contact-us-dark',
                    'section_number' => 4,
                    'images_count' => 0,
                    'tags' => ['content', 'contact', 'dark', 'text', 'google_maps', 'html'],
                ],
                't3-contact-us-section-1' => [
                    'title' => esc_html__('Monday: 8:00 – 17:00Tuesday: - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't3-contact-us',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['header', 'contact', 'text', 'heading', 'icon list', 'shortcode'],
                ],
                't3-contact-us-section-2' => [
                    'title' => esc_html__('Invest in Bitcoin, Ethereum, - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-contact-us',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['hero', 'contact', 'text', 'image', 'heading', 'button'],
                ],
                't3-contact-us-section-3' => [
                    'title' => esc_html__('Our company was founded - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't3-contact-us',
                    'section_number' => 3,
                    'images_count' => 9,
                    'tags' => ['header', 'contact', 'text', 'heading', 'image carousel'],
                ],
                't3-contact-us-section-4' => [
                    'title' => esc_html__('How to get to - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't3-contact-us',
                    'section_number' => 4,
                    'images_count' => 0,
                    'tags' => ['content', 'contact', 'text', 'google_maps'],
                ],
                't3-crypto-app-section-1' => [
                    'title' => esc_html__('Trade Bitcoin, Ethereum, USDT - Crypto App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-crypto-app',
                    'section_number' => 1,
                    'images_count' => 5,
                    'tags' => ['hero', 'crypto', 'app', 'image', 'styled text', 'text', 'button', 'heading'],
                ],
                't3-crypto-app-section-2' => [
                    'title' => esc_html__('Crypto App - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't3-crypto-app',
                    'section_number' => 2,
                    'images_count' => 6,
                    'tags' => ['general', 'crypto', 'app', 'image carousel'],
                ],
                't3-crypto-app-section-3' => [
                    'title' => esc_html__('Invest in Bitcoin, Ethereum, - Crypto App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-crypto-app',
                    'section_number' => 3,
                    'images_count' => 5,
                    'tags' => ['cta', 'crypto', 'app', 'image', 'text', 'button'],
                ],
                't3-crypto-app-section-4' => [
                    'title' => esc_html__('Trade Bitcoin, Ethereum, USDT - Crypto App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't3-crypto-app',
                    'section_number' => 4,
                    'images_count' => 9,
                    'tags' => ['content', 'crypto', 'app', 'text', 'image'],
                ],
                't3-crypto-app-section-5' => [
                    'title' => esc_html__('Invest in Bitcoin, Ethereum, - Crypto App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't3-crypto-app',
                    'section_number' => 5,
                    'images_count' => 4,
                    'tags' => ['content', 'crypto', 'app', 'text', 'image'],
                ],
                't3-crypto-app-section-6' => [
                    'title' => esc_html__('Invest in Bitcoin, Ethereum, - Crypto App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-crypto-app',
                    'section_number' => 6,
                    'images_count' => 2,
                    'tags' => ['hero', 'crypto', 'app', 'image', 'text', 'heading', 'divider', 'icon list', 'button', 'star rating'],
                ],
                't3-crypto-app-section-7' => [
                    'title' => esc_html__('Do you want to - Crypto App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-crypto-app',
                    'section_number' => 7,
                    'images_count' => 2,
                    'tags' => ['cta', 'crypto', 'app', 'text', 'button'],
                ],
                't3-crypto-cards-section-1' => [
                    'title' => esc_html__('Make your life easier - Crypto Cards', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-crypto-cards',
                    'section_number' => 1,
                    'images_count' => 7,
                    'tags' => ['hero', 'crypto', 'cards', 'styled text', 'text', 'image', 'button', 'heading'],
                ],
                't3-crypto-cards-section-2' => [
                    'title' => esc_html__('Crypto Cards - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't3-crypto-cards',
                    'section_number' => 2,
                    'images_count' => 5,
                    'tags' => ['general', 'crypto', 'cards', 'image carousel'],
                ],
                't3-crypto-cards-section-3' => [
                    'title' => esc_html__('You can buy and - Crypto Cards', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't3-crypto-cards',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['header', 'crypto', 'cards', 'text', 'heading', 'image'],
                ],
                't3-crypto-cards-section-4' => [
                    'title' => esc_html__('You can buy and - Crypto Cards', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't3-crypto-cards',
                    'section_number' => 4,
                    'images_count' => 8,
                    'tags' => ['header', 'crypto', 'cards', 'text', 'heading', 'image', 'image box'],
                ],
                't3-crypto-cards-section-5' => [
                    'title' => esc_html__('You can buy and - Crypto Cards', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't3-crypto-cards',
                    'section_number' => 5,
                    'images_count' => 5,
                    'tags' => ['header', 'crypto', 'cards', 'text', 'heading', 'star rating', 'image'],
                ],
                't3-crypto-cards-section-6' => [
                    'title' => esc_html__('Let\'s start your crypto - Crypto Cards', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-crypto-cards',
                    'section_number' => 6,
                    'images_count' => 2,
                    'tags' => ['cta', 'crypto', 'cards', 'text', 'image', 'button'],
                ],
                't3-crypto-exchange-section-1' => [
                    'title' => esc_html__('Invest in Bitcoin, Ethereum, - Crypto Exchange', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-crypto-exchange',
                    'section_number' => 1,
                    'images_count' => 20,
                    'tags' => ['hero', 'crypto', 'exchange', 'styled text', 'text', 'button', 'image', 'heading', 'divider', 'html', 'image carousel'],
                ],
                't3-crypto-exchange-section-2' => [
                    'title' => esc_html__('Cryptocurrency markets have seen - Crypto Exchange', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't3-crypto-exchange',
                    'section_number' => 2,
                    'images_count' => 3,
                    'tags' => ['header', 'crypto', 'exchange', 'text', 'image', 'heading'],
                ],
                't3-crypto-exchange-section-3' => [
                    'title' => esc_html__('The Bitcoin and cryptocurrency - Crypto Exchange', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't3-crypto-exchange',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['content', 'crypto', 'exchange', 'text', 'icon list', 'image'],
                ],
                't3-crypto-exchange-section-4' => [
                    'title' => esc_html__('The Bitcoin and cryptocurrency - Crypto Exchange', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-crypto-exchange',
                    'section_number' => 4,
                    'images_count' => 6,
                    'tags' => ['hero', 'crypto', 'exchange', 'text', 'button', 'king addons video popup', 'heading', 'image'],
                ],
                't3-crypto-exchange-section-5' => [
                    'title' => esc_html__('Cryptocurrency markets have seen - Crypto Exchange', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-crypto-exchange',
                    'section_number' => 5,
                    'images_count' => 5,
                    'tags' => ['hero', 'crypto', 'exchange', 'text', 'button', 'image', 'star rating', 'heading', 'toggle'],
                ],
                't3-crypto-hardware-wallets-section-1' => [
                    'title' => esc_html__('Easiest crypto wallet for - Crypto Hardware Wallets', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't3-crypto-hardware-wallets',
                    'section_number' => 1,
                    'images_count' => 8,
                    'tags' => ['content', 'crypto', 'hardware', 'wallets', 'text', 'image'],
                ],
                't3-crypto-hardware-wallets-section-2' => [
                    'title' => esc_html__('The private keys are - Crypto Hardware Wallets', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't3-crypto-hardware-wallets',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['content', 'crypto', 'hardware', 'wallets', 'image box', 'text'],
                ],
                't3-crypto-hardware-wallets-section-3' => [
                    'title' => esc_html__('The private keys are - Crypto Hardware Wallets', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-crypto-hardware-wallets',
                    'section_number' => 3,
                    'images_count' => 10,
                    'tags' => ['hero', 'crypto', 'hardware', 'wallets', 'text', 'heading', 'image box', 'image', 'button'],
                ],
                't3-crypto-hardware-wallets-section-4' => [
                    'title' => esc_html__('Using Our Connect, you - Crypto Hardware Wallets', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't3-crypto-hardware-wallets',
                    'section_number' => 4,
                    'images_count' => 17,
                    'tags' => ['header', 'crypto', 'hardware', 'wallets', 'text', 'heading', 'image carousel'],
                ],
                't3-crypto-hardware-wallets-section-5' => [
                    'title' => esc_html__('Aliquam cursus faucibus nisl, - Crypto Hardware Wallets', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-crypto-hardware-wallets',
                    'section_number' => 5,
                    'images_count' => 8,
                    'tags' => ['hero', 'crypto', 'hardware', 'wallets', 'text', 'heading', 'image', 'star rating', 'toggle', 'button'],
                ],
                't3-crypto-startup-section-1' => [
                    'title' => esc_html__('Connect our AI to - Crypto Startup', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-crypto-startup',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['hero', 'crypto', 'startup', 'styled text', 'text', 'button', 'heading', 'image'],
                ],
                't3-crypto-startup-section-2' => [
                    'title' => esc_html__('Crypto Startup - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't3-crypto-startup',
                    'section_number' => 2,
                    'images_count' => 5,
                    'tags' => ['general', 'crypto', 'startup', 'image carousel'],
                ],
                't3-crypto-startup-section-3' => [
                    'title' => esc_html__('Invest in Bitcoin, Ethereum, - Crypto Startup', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-crypto-startup',
                    'section_number' => 3,
                    'images_count' => 4,
                    'tags' => ['hero', 'crypto', 'startup', 'image', 'styled text', 'text', 'button'],
                ],
                't3-crypto-startup-section-4' => [
                    'title' => esc_html__('Connect our AI to - Crypto Startup', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't3-crypto-startup',
                    'section_number' => 4,
                    'images_count' => 3,
                    'tags' => ['header', 'crypto', 'startup', 'styled text', 'text', 'image'],
                ],
                't3-crypto-startup-section-5' => [
                    'title' => esc_html__('Invest in Bitcoin, Ethereum, - Crypto Startup', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-crypto-startup',
                    'section_number' => 5,
                    'images_count' => 4,
                    'tags' => ['hero', 'crypto', 'startup', 'styled text', 'text', 'button', 'image'],
                ],
                't3-crypto-startup-section-6' => [
                    'title' => esc_html__('Register now and use - Crypto Startup', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-crypto-startup',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['hero', 'crypto', 'startup', 'styled text', 'text', 'button'],
                ],
                't3-crypto-startup-section-7' => [
                    'title' => esc_html__('Connect our AI to - Crypto Startup', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't3-crypto-startup',
                    'section_number' => 7,
                    'images_count' => 7,
                    'tags' => ['header', 'crypto', 'startup', 'image', 'styled text', 'text', 'star rating', 'heading'],
                ],
                't3-crypto-startup-section-8' => [
                    'title' => esc_html__('It is an exciting - Crypto Startup', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-crypto-startup',
                    'section_number' => 8,
                    'images_count' => 2,
                    'tags' => ['cta', 'crypto', 'startup', 'text', 'button', 'image'],
                ],
                't3-crypto-trading-app-section-1' => [
                    'title' => esc_html__('The Future of Crypto - Crypto Trading App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-crypto-trading-app',
                    'section_number' => 1,
                    'images_count' => 7,
                    'tags' => ['cta', 'crypto', 'trading', 'app', 'image', 'text', 'button'],
                ],
                't3-crypto-trading-app-section-2' => [
                    'title' => esc_html__('Crypto Trading App - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't3-crypto-trading-app',
                    'section_number' => 2,
                    'images_count' => 5,
                    'tags' => ['general', 'crypto', 'trading', 'app', 'image carousel'],
                ],
                't3-crypto-trading-app-section-3' => [
                    'title' => esc_html__('Connect our AI to - Crypto Trading App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-crypto-trading-app',
                    'section_number' => 3,
                    'images_count' => 4,
                    'tags' => ['cta', 'crypto', 'trading', 'app', 'image', 'text', 'button'],
                ],
                't3-crypto-trading-app-section-4' => [
                    'title' => esc_html__('Connect our AI to - Crypto Trading App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't3-crypto-trading-app',
                    'section_number' => 4,
                    'images_count' => 4,
                    'tags' => ['content', 'crypto', 'trading', 'app', 'text', 'image'],
                ],
                't3-crypto-trading-app-section-5' => [
                    'title' => esc_html__('The Bitcoin and cryptocurrency - Crypto Trading App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-crypto-trading-app',
                    'section_number' => 5,
                    'images_count' => 4,
                    'tags' => ['cta', 'crypto', 'trading', 'app', 'text', 'button', 'image'],
                ],
                't3-crypto-trading-app-section-6' => [
                    'title' => esc_html__('Try our auto trading - Crypto Trading App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-crypto-trading-app',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['hero', 'crypto', 'trading', 'app', 'styled text', 'text', 'button'],
                ],
                't3-crypto-trading-app-section-7' => [
                    'title' => esc_html__('The Bitcoin and cryptocurrency - Crypto Trading App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't3-crypto-trading-app',
                    'section_number' => 7,
                    'images_count' => 2,
                    'tags' => ['content', 'crypto', 'trading', 'app', 'image', 'text'],
                ],
                't3-crypto-trading-app-section-8' => [
                    'title' => esc_html__('Connect our AI to - Crypto Trading App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-crypto-trading-app',
                    'section_number' => 8,
                    'images_count' => 2,
                    'tags' => ['hero', 'crypto', 'trading', 'app', 'text', 'button', 'king addons video popup', 'heading'],
                ],
                't3-crypto-trading-app-section-9' => [
                    'title' => esc_html__('Connect our AI to - Crypto Trading App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't3-crypto-trading-app',
                    'section_number' => 9,
                    'images_count' => 4,
                    'tags' => ['header', 'crypto', 'trading', 'app', 'text', 'heading', 'star rating', 'image'],
                ],
                't3-crypto-trading-app-section-10' => [
                    'title' => esc_html__('Let’s start your crypto - Crypto Trading App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-crypto-trading-app',
                    'section_number' => 10,
                    'images_count' => 1,
                    'tags' => ['hero', 'crypto', 'trading', 'app', 'styled text', 'text', 'button'],
                ],
                't3-crypto-trading-section-1' => [
                    'title' => esc_html__('Invest in Bitcoin, Ethereum, - Crypto Trading', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-crypto-trading',
                    'section_number' => 1,
                    'images_count' => 22,
                    'tags' => ['hero', 'crypto', 'trading', 'styled text', 'text', 'button', 'image', 'heading', 'divider', 'html', 'image carousel'],
                ],
                't3-crypto-trading-section-2' => [
                    'title' => esc_html__('Cryptocurrency markets have seen - Crypto Trading', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't3-crypto-trading',
                    'section_number' => 2,
                    'images_count' => 8,
                    'tags' => ['header', 'crypto', 'trading', 'text', 'image', 'heading'],
                ],
                't3-crypto-trading-section-3' => [
                    'title' => esc_html__('The Bitcoin and cryptocurrency - Crypto Trading', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-crypto-trading',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['cta', 'crypto', 'trading', 'text', 'button', 'king addons video popup'],
                ],
                't3-crypto-trading-section-4' => [
                    'title' => esc_html__('The Bitcoin and cryptocurrency - Crypto Trading', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't3-crypto-trading',
                    'section_number' => 4,
                    'images_count' => 4,
                    'tags' => ['content', 'crypto', 'trading', 'text', 'icon list', 'image'],
                ],
                't3-crypto-trading-section-5' => [
                    'title' => esc_html__('\"Great! Compared to everything - Crypto Trading', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-crypto-trading',
                    'section_number' => 5,
                    'images_count' => 5,
                    'tags' => ['hero', 'crypto', 'trading', 'image', 'text', 'button', 'star rating', 'heading'],
                ],
                't3-crypto-trading-section-6' => [
                    'title' => esc_html__('Cryptocurrency markets have seen - Crypto Trading', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't3-crypto-trading',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['content', 'crypto', 'trading', 'text', 'toggle'],
                ],
                't3-crypto-wallet-app-section-1' => [
                    'title' => esc_html__('The Toka Wallet lets - Crypto Wallet App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-crypto-wallet-app',
                    'section_number' => 1,
                    'images_count' => 7,
                    'tags' => ['cta', 'crypto', 'wallet', 'app', 'text', 'button', 'image', 'text path'],
                ],
                't3-crypto-wallet-app-section-2' => [
                    'title' => esc_html__('Wallets allow you to - Crypto Wallet App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-crypto-wallet-app',
                    'section_number' => 2,
                    'images_count' => 8,
                    'tags' => ['cta', 'crypto', 'wallet', 'app', 'image', 'text', 'button'],
                ],
                't3-crypto-wallet-app-section-3' => [
                    'title' => esc_html__('The Toka Wallet lets - Crypto Wallet App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't3-crypto-wallet-app',
                    'section_number' => 3,
                    'images_count' => 9,
                    'tags' => ['header', 'crypto', 'wallet', 'app', 'text', 'heading', 'image box'],
                ],
                't3-crypto-wallet-app-section-4' => [
                    'title' => esc_html__('Wallets allow you to - Crypto Wallet App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-crypto-wallet-app',
                    'section_number' => 4,
                    'images_count' => 6,
                    'tags' => ['cta', 'crypto', 'wallet', 'app', 'image', 'text', 'button'],
                ],
                't3-crypto-wallet-app-section-5' => [
                    'title' => esc_html__('The Toka Wallet lets - Crypto Wallet App', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'technology',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-crypto-wallet-app',
                    'section_number' => 5,
                    'images_count' => 5,
                    'tags' => ['hero', 'crypto', 'wallet', 'app', 'text', 'heading', 'toggle', 'button'],
                ],
                't3-defi-project-landing-section-1' => [
                    'title' => esc_html__('Start harnessing the full - Defi Project Landing', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-defi-project-landing',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['cta', 'defi', 'project', 'landing', 'text', 'button', 'image', 'text path'],
                ],
                't3-defi-project-landing-section-2' => [
                    'title' => esc_html__('Total liquidity

 - Defi Project Landing', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't3-defi-project-landing',
                    'section_number' => 2,
                    'images_count' => 0,
                    'tags' => ['header', 'defi', 'project', 'landing', 'heading', 'text'],
                ],
                't3-defi-project-landing-section-3' => [
                    'title' => esc_html__('Start harnessing the full - Defi Project Landing', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-defi-project-landing',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['hero', 'defi', 'project', 'landing', 'text', 'heading', 'button', 'image'],
                ],
                't3-defi-project-landing-section-4' => [
                    'title' => esc_html__('Start harnessing the full - Defi Project Landing', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't3-defi-project-landing',
                    'section_number' => 4,
                    'images_count' => 4,
                    'tags' => ['header', 'defi', 'project', 'landing', 'text', 'heading', 'image'],
                ],
                't3-defi-project-landing-section-5' => [
                    'title' => esc_html__('Start harnessing the full - Defi Project Landing', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't3-defi-project-landing',
                    'section_number' => 5,
                    'images_count' => 2,
                    'tags' => ['header', 'defi', 'project', 'landing', 'text', 'heading', 'image'],
                ],
                't3-defi-project-landing-section-6' => [
                    'title' => esc_html__('Start harnessing the full - Defi Project Landing', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't3-defi-project-landing',
                    'section_number' => 6,
                    'images_count' => 2,
                    'tags' => ['content', 'defi', 'project', 'landing', 'image', 'text'],
                ],
                't3-defi-project-landing-section-7' => [
                    'title' => esc_html__('Start harnessing the full - Defi Project Landing', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't3-defi-project-landing',
                    'section_number' => 7,
                    'images_count' => 6,
                    'tags' => ['header', 'defi', 'project', 'landing', 'text', 'heading', 'star rating', 'image'],
                ],
                't3-defi-project-landing-section-8' => [
                    'title' => esc_html__('Let\'s build future together - Defi Project Landing', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-defi-project-landing',
                    'section_number' => 8,
                    'images_count' => 1,
                    'tags' => ['cta', 'defi', 'project', 'landing', 'text', 'button'],
                ],
                't3-metaverse-website-section-1' => [
                    'title' => esc_html__('No matter where you - Metaverse Website', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-metaverse-website',
                    'section_number' => 1,
                    'images_count' => 6,
                    'tags' => ['hero', 'metaverse', 'website', 'text', 'button', 'image', 'heading'],
                ],
                't3-metaverse-website-section-2' => [
                    'title' => esc_html__('Metaverse Website - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't3-metaverse-website',
                    'section_number' => 2,
                    'images_count' => 5,
                    'tags' => ['general', 'metaverse', 'website', 'image carousel'],
                ],
                't3-metaverse-website-section-3' => [
                    'title' => esc_html__('No matter where you - Metaverse Website', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-metaverse-website',
                    'section_number' => 3,
                    'images_count' => 3,
                    'tags' => ['cta', 'metaverse', 'website', 'image', 'text', 'button'],
                ],
                't3-metaverse-website-section-4' => [
                    'title' => esc_html__('Create, customize and share - Metaverse Website', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't3-metaverse-website',
                    'section_number' => 4,
                    'images_count' => 3,
                    'tags' => ['content', 'metaverse', 'website', 'text', 'image'],
                ],
                't3-metaverse-website-section-5' => [
                    'title' => esc_html__('No matter where you - Metaverse Website', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-metaverse-website',
                    'section_number' => 5,
                    'images_count' => 4,
                    'tags' => ['cta', 'metaverse', 'website', 'text', 'button', 'image'],
                ],
                't3-metaverse-website-section-6' => [
                    'title' => esc_html__('No matter where you - Metaverse Website', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't3-metaverse-website',
                    'section_number' => 6,
                    'images_count' => 7,
                    'tags' => ['content', 'metaverse', 'website', 'text', 'king addons image grid'],
                ],
                't3-metaverse-website-section-7' => [
                    'title' => esc_html__('No matter where you - Metaverse Website', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't3-metaverse-website',
                    'section_number' => 7,
                    'images_count' => 2,
                    'tags' => ['content', 'metaverse', 'website', 'image', 'text', 'toggle'],
                ],
                't3-metaverse-website-section-8' => [
                    'title' => esc_html__('No matter where you - Metaverse Website', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-metaverse-website',
                    'section_number' => 8,
                    'images_count' => 2,
                    'tags' => ['cta', 'metaverse', 'website', 'text', 'button', 'image'],
                ],
                't3-nft-collection-landing-section-1' => [
                    'title' => esc_html__('Buy the new super - Nft Collection Landing', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-nft-collection-landing',
                    'section_number' => 1,
                    'images_count' => 5,
                    'tags' => ['hero', 'nft', 'collection', 'landing', 'image', 'text', 'button', 'heading', 'text path'],
                ],
                't3-nft-collection-landing-section-2' => [
                    'title' => esc_html__('Nft Collection Landing - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't3-nft-collection-landing',
                    'section_number' => 2,
                    'images_count' => 5,
                    'tags' => ['general', 'nft', 'collection', 'landing', 'image carousel'],
                ],
                't3-nft-collection-landing-section-3' => [
                    'title' => esc_html__('A non-fungible token is - Nft Collection Landing', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-nft-collection-landing',
                    'section_number' => 3,
                    'images_count' => 6,
                    'tags' => ['cta', 'nft', 'collection', 'landing', 'king addons card carousel', 'image', 'text', 'button'],
                ],
                't3-nft-collection-landing-section-4' => [
                    'title' => esc_html__('A non-fungible token is - Nft Collection Landing', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-nft-collection-landing',
                    'section_number' => 4,
                    'images_count' => 3,
                    'tags' => ['hero', 'nft', 'collection', 'landing', 'text', 'styled text', 'button', 'image'],
                ],
                't3-nft-collection-landing-section-5' => [
                    'title' => esc_html__('Browse dozens of my - Nft Collection Landing', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-nft-collection-landing',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['hero', 'nft', 'collection', 'landing', 'styled text', 'text', 'button'],
                ],
                't3-nft-collection-landing-section-6' => [
                    'title' => esc_html__('A non-fungible token is - Nft Collection Landing', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-nft-collection-landing',
                    'section_number' => 6,
                    'images_count' => 4,
                    'tags' => ['cta', 'nft', 'collection', 'landing', 'text path', 'image', 'text', 'button'],
                ],
                't3-nft-collection-landing-section-7' => [
                    'title' => esc_html__('Discover other extremely popular - Nft Collection Landing', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-nft-collection-landing',
                    'section_number' => 7,
                    'images_count' => 7,
                    'tags' => ['hero', 'nft', 'collection', 'landing', 'text', 'styled text', 'image box', 'button'],
                ],
                't3-nft-collection-landing-section-8' => [
                    'title' => esc_html__('Browse dozens of my - Nft Collection Landing', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-nft-collection-landing',
                    'section_number' => 8,
                    'images_count' => 3,
                    'tags' => ['cta', 'nft', 'collection', 'landing', 'text', 'button', 'image'],
                ],
                't3-nft-dao-platform-section-1' => [
                    'title' => esc_html__('Start to earn more - Nft Dao Platform', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-nft-dao-platform',
                    'section_number' => 1,
                    'images_count' => 4,
                    'tags' => ['hero', 'nft', 'dao', 'platform', 'text', 'button', 'heading', 'image'],
                ],
                't3-nft-dao-platform-section-2' => [
                    'title' => esc_html__('Nft Dao Platform - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't3-nft-dao-platform',
                    'section_number' => 2,
                    'images_count' => 5,
                    'tags' => ['general', 'nft', 'dao', 'platform', 'image carousel'],
                ],
                't3-nft-dao-platform-section-3' => [
                    'title' => esc_html__('A non-fungible token is - Nft Dao Platform', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-nft-dao-platform',
                    'section_number' => 3,
                    'images_count' => 7,
                    'tags' => ['cta', 'nft', 'dao', 'platform', 'image', 'text', 'button', 'image box'],
                ],
                't3-nft-dao-platform-section-4' => [
                    'title' => esc_html__('A non-fungible token is - Nft Dao Platform', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-nft-dao-platform',
                    'section_number' => 4,
                    'images_count' => 3,
                    'tags' => ['hero', 'nft', 'dao', 'platform', 'styled text', 'text', 'button', 'image', 'text path'],
                ],
                't3-nft-dao-platform-section-5' => [
                    'title' => esc_html__('NFTs can be used - Nft Dao Platform', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't3-nft-dao-platform',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['header', 'nft', 'dao', 'platform', 'text', 'heading', 'king addons video popup', 'toggle'],
                ],
                't3-nft-game-section-1' => [
                    'title' => esc_html__('Discover over 200+ magical - Nft Game', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-nft-game',
                    'section_number' => 1,
                    'images_count' => 6,
                    'tags' => ['cta', 'nft', 'game', 'text', 'button', 'image'],
                ],
                't3-nft-game-section-2' => [
                    'title' => esc_html__('already earned - Nft Game', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't3-nft-game',
                    'section_number' => 2,
                    'images_count' => 0,
                    'tags' => ['header', 'nft', 'game', 'heading', 'text'],
                ],
                't3-nft-game-section-3' => [
                    'title' => esc_html__('Discover over 200+ magical - Nft Game', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-nft-game',
                    'section_number' => 3,
                    'images_count' => 5,
                    'tags' => ['hero', 'nft', 'game', 'image', 'text', 'heading', 'button'],
                ],
                't3-nft-game-section-4' => [
                    'title' => esc_html__('Discover over 200+ magical - Nft Game', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't3-nft-game',
                    'section_number' => 4,
                    'images_count' => 7,
                    'tags' => ['header', 'nft', 'game', 'text', 'heading', 'image'],
                ],
                't3-nft-game-section-5' => [
                    'title' => esc_html__('Discover over 200+ magical - Nft Game', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-nft-game',
                    'section_number' => 5,
                    'images_count' => 8,
                    'tags' => ['hero', 'nft', 'game', 'image', 'text', 'heading', 'button', 'king addons card carousel'],
                ],
                't3-nft-game-section-6' => [
                    'title' => esc_html__('Increase your power and - Nft Game', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-nft-game',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['hero', 'nft', 'game', 'styled text', 'text', 'button'],
                ],
                't3-nft-game-section-7' => [
                    'title' => esc_html__('\"Great! Compared to everything - Nft Game', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't3-nft-game',
                    'section_number' => 7,
                    'images_count' => 3,
                    'tags' => ['header', 'nft', 'game', 'text', 'heading', 'star rating', 'image', 'ucaddon_blox_play_button'],
                ],
                't3-nft-game-section-8' => [
                    'title' => esc_html__('Discover over 200+ magical - Nft Game', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-nft-game',
                    'section_number' => 8,
                    'images_count' => 2,
                    'tags' => ['cta', 'nft', 'game', 'text', 'button'],
                ],
                't3-nft-landing-page-section-1' => [
                    'title' => esc_html__('Buy the new super - Nft Landing Page', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-nft-landing-page',
                    'section_number' => 1,
                    'images_count' => 5,
                    'tags' => ['cta', 'nft', 'landing', 'page', 'image', 'text', 'button', 'icon list', 'image box'],
                ],
                't3-nft-landing-page-section-2' => [
                    'title' => esc_html__('Nft Landing Page - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't3-nft-landing-page',
                    'section_number' => 2,
                    'images_count' => 6,
                    'tags' => ['general', 'nft', 'landing', 'page', 'image carousel'],
                ],
                't3-nft-landing-page-section-3' => [
                    'title' => esc_html__('A non-fungible token is - Nft Landing Page', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-nft-landing-page',
                    'section_number' => 3,
                    'images_count' => 7,
                    'tags' => ['cta', 'nft', 'landing', 'page', 'image', 'image box', 'text', 'button'],
                ],
                't3-nft-landing-page-section-4' => [
                    'title' => esc_html__('An NFT is a - Nft Landing Page', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-nft-landing-page',
                    'section_number' => 4,
                    'images_count' => 4,
                    'tags' => ['cta', 'nft', 'landing', 'page', 'text', 'button', 'image'],
                ],
                't3-nft-landing-page-section-5' => [
                    'title' => esc_html__('A non-fungible token is - Nft Landing Page', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-nft-landing-page',
                    'section_number' => 5,
                    'images_count' => 4,
                    'tags' => ['cta', 'nft', 'landing', 'page', 'text path', 'image', 'text', 'button'],
                ],
                't3-nft-landing-page-section-6' => [
                    'title' => esc_html__('Check out my latest - Nft Landing Page', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-nft-landing-page',
                    'section_number' => 6,
                    'images_count' => 6,
                    'tags' => ['hero', 'nft', 'landing', 'page', 'text', 'heading', 'image box', 'button'],
                ],
                't3-nft-landing-page-section-7' => [
                    'title' => esc_html__('Browse dozens of my - Nft Landing Page', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-nft-landing-page',
                    'section_number' => 7,
                    'images_count' => 0,
                    'tags' => ['cta', 'nft', 'landing', 'page', 'text', 'button'],
                ],
                't3-nft-marketplace-section-1' => [
                    'title' => esc_html__('A non-fungible token is - Nft Marketplace', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-nft-marketplace',
                    'section_number' => 1,
                    'images_count' => 8,
                    'tags' => ['hero', 'nft', 'marketplace', 'image', 'text', 'heading', 'button', 'social icons'],
                ],
                't3-nft-marketplace-section-2' => [
                    'title' => esc_html__('Explore awesome artworks - Nft Marketplace', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-nft-marketplace',
                    'section_number' => 2,
                    'images_count' => 5,
                    'tags' => ['hero', 'nft', 'marketplace', 'image', 'text', 'heading', 'image box', 'button'],
                ],
                't3-nft-marketplace-section-3' => [
                    'title' => esc_html__('Browse dozens of my - Nft Marketplace', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-nft-marketplace',
                    'section_number' => 3,
                    'images_count' => 7,
                    'tags' => ['hero', 'nft', 'marketplace', 'text', 'heading', 'image', 'button'],
                ],
                't3-nft-marketplace-section-4' => [
                    'title' => esc_html__('A non-fungible token is - Nft Marketplace', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-nft-marketplace',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['cta', 'nft', 'marketplace', 'text', 'button', 'image'],
                ],
                't3-nft-marketplace-section-5' => [
                    'title' => esc_html__('A non-fungible token is - Nft Marketplace', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-nft-marketplace',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['cta', 'nft', 'marketplace', 'text path', 'image', 'text', 'button'],
                ],
                't3-nft-marketplace-section-6' => [
                    'title' => esc_html__('Enjoy the latest hot - Nft Marketplace', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-nft-marketplace',
                    'section_number' => 6,
                    'images_count' => 3,
                    'tags' => ['hero', 'nft', 'marketplace', 'text', 'heading', 'image box', 'button'],
                ],
                't3-nft-marketplace-section-7' => [
                    'title' => esc_html__('Browse dozens of my - Nft Marketplace', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't3-nft-marketplace',
                    'section_number' => 7,
                    'images_count' => 1,
                    'tags' => ['header', 'nft', 'marketplace', 'text', 'heading', 'king addons video popup'],
                ],
                't3-nft-marketplace-section-8' => [
                    'title' => esc_html__('Join our creative community - Nft Marketplace', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-nft-marketplace',
                    'section_number' => 8,
                    'images_count' => 8,
                    'tags' => ['hero', 'nft', 'marketplace', 'image', 'text', 'heading', 'button'],
                ],
                't3-nft-platform-section-1' => [
                    'title' => esc_html__('Buy and sell the - Nft Platform', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-nft-platform',
                    'section_number' => 1,
                    'images_count' => 8,
                    'tags' => ['cta', 'nft', 'platform', 'image box', 'image', 'text', 'button'],
                ],
                't3-nft-platform-section-2' => [
                    'title' => esc_html__('Nft Platform - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't3-nft-platform',
                    'section_number' => 2,
                    'images_count' => 6,
                    'tags' => ['general', 'nft', 'platform', 'image carousel'],
                ],
                't3-nft-platform-section-3' => [
                    'title' => esc_html__('NFTs can be used - Nft Platform', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-nft-platform',
                    'section_number' => 3,
                    'images_count' => 5,
                    'tags' => ['cta', 'nft', 'platform', 'image', 'image box', 'text', 'button'],
                ],
                't3-nft-platform-section-4' => [
                    'title' => esc_html__('The NFT can be - Nft Platform', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't3-nft-platform',
                    'section_number' => 4,
                    'images_count' => 4,
                    'tags' => ['content', 'nft', 'platform', 'text', 'image', 'text path'],
                ],
                't3-nft-platform-section-5' => [
                    'title' => esc_html__('Praesent vel metus erat. - Nft Platform', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-nft-platform',
                    'section_number' => 5,
                    'images_count' => 7,
                    'tags' => ['hero', 'nft', 'platform', 'text', 'image', 'heading', 'button'],
                ],
                't3-nft-platform-section-6' => [
                    'title' => esc_html__('A non-fungible token is - Nft Platform', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't3-nft-platform',
                    'section_number' => 6,
                    'images_count' => 3,
                    'tags' => ['header', 'nft', 'platform', 'text', 'heading', 'image', 'icon box'],
                ],
                't3-nft-platform-section-7' => [
                    'title' => esc_html__('NFTs can be used - Nft Platform', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-nft-platform',
                    'section_number' => 7,
                    'images_count' => 6,
                    'tags' => ['hero', 'nft', 'platform', 'text', 'heading', 'image box', 'button'],
                ],
                't3-nft-platform-section-8' => [
                    'title' => esc_html__('NFTs can be used - Nft Platform', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-nft-platform',
                    'section_number' => 8,
                    'images_count' => 3,
                    'tags' => ['cta', 'nft', 'platform', 'image', 'text', 'button'],
                ],
                't3-nft-platform-section-9' => [
                    'title' => esc_html__('Buy and sell the - Nft Platform', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-nft-platform',
                    'section_number' => 9,
                    'images_count' => 3,
                    'tags' => ['cta', 'nft', 'platform', 'text', 'button', 'image'],
                ],
                't3-nft-website-section-1' => [
                    'title' => esc_html__('Our marketplace has 2M+ - Nft Website', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-nft-website',
                    'section_number' => 1,
                    'images_count' => 5,
                    'tags' => ['hero', 'nft', 'website', 'styled text', 'text', 'button', 'heading', 'image'],
                ],
                't3-nft-website-section-2' => [
                    'title' => esc_html__('Nft Website - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't3-nft-website',
                    'section_number' => 2,
                    'images_count' => 6,
                    'tags' => ['general', 'nft', 'website', 'image carousel'],
                ],
                't3-nft-website-section-3' => [
                    'title' => esc_html__('Our marketplace has 2M+ - Nft Website', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-nft-website',
                    'section_number' => 3,
                    'images_count' => 10,
                    'tags' => ['hero', 'nft', 'website', 'styled text', 'text', 'button', 'image'],
                ],
                't3-nft-website-section-4' => [
                    'title' => esc_html__('We provide a secure - Nft Website', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't3-nft-website',
                    'section_number' => 4,
                    'images_count' => 5,
                    'tags' => ['header', 'nft', 'website', 'styled text', 'text', 'image'],
                ],
                't3-nft-website-section-5' => [
                    'title' => esc_html__('Our marketplace has 2M+ - Nft Website', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-nft-website',
                    'section_number' => 5,
                    'images_count' => 6,
                    'tags' => ['hero', 'nft', 'website', 'styled text', 'text', 'button', 'king addons card carousel'],
                ],
                't3-nft-website-section-6' => [
                    'title' => esc_html__('Our marketplace has 2M+ - Nft Website', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-nft-website',
                    'section_number' => 6,
                    'images_count' => 12,
                    'tags' => ['hero', 'nft', 'website', 'styled text', 'text', 'button', 'image'],
                ],
                't3-nft-website-section-7' => [
                    'title' => esc_html__('Or join our community - Nft Website', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'media & entertainment',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-nft-website',
                    'section_number' => 7,
                    'images_count' => 4,
                    'tags' => ['hero', 'nft', 'website', 'styled text', 'text', 'button'],
                ],
                't3-our-team-dark-section-1' => [
                    'title' => esc_html__('Our company was founded - Our Team Dark', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-our-team-dark',
                    'section_number' => 1,
                    'images_count' => 8,
                    'tags' => ['hero', 'our', 'team', 'dark', 'text', 'heading', 'image', 'social icons', 'button'],
                ],
                't3-our-team-section-1' => [
                    'title' => esc_html__('Our company was founded - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-our-team',
                    'section_number' => 1,
                    'images_count' => 10,
                    'tags' => ['hero', 'our', 'team', 'text', 'heading', 'image', 'social icons', 'button'],
                ],
                't3-payments-with-crypto-section-1' => [
                    'title' => esc_html__('Send invoices, collect payment, - Payments With Crypto', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-payments-with-crypto',
                    'section_number' => 1,
                    'images_count' => 5,
                    'tags' => ['cta', 'payments', 'with', 'crypto', 'text', 'button', 'image'],
                ],
                't3-payments-with-crypto-section-2' => [
                    'title' => esc_html__('supported contries - Payments With Crypto', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't3-payments-with-crypto',
                    'section_number' => 2,
                    'images_count' => 0,
                    'tags' => ['header', 'payments', 'with', 'crypto', 'heading', 'text'],
                ],
                't3-payments-with-crypto-section-3' => [
                    'title' => esc_html__('Send invoices, collect payment, - Payments With Crypto', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't3-payments-with-crypto',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['header', 'payments', 'with', 'crypto', 'text', 'heading', 'image'],
                ],
                't3-payments-with-crypto-section-4' => [
                    'title' => esc_html__('Send invoices, collect payment, - Payments With Crypto', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't3-payments-with-crypto',
                    'section_number' => 4,
                    'images_count' => 7,
                    'tags' => ['header', 'payments', 'with', 'crypto', 'text', 'heading', 'image', 'image box'],
                ],
                't3-payments-with-crypto-section-5' => [
                    'title' => esc_html__('Send invoices, collect payment, - Payments With Crypto', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't3-payments-with-crypto',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['hero', 'payments', 'with', 'crypto', 'text', 'heading', 'divider', 'icon list', 'button'],
                ],
                't3-payments-with-crypto-section-6' => [
                    'title' => esc_html__('\"Great! Compared to everything - Payments With Crypto', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't3-payments-with-crypto',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['header', 'payments', 'with', 'crypto', 'text', 'heading', 'star rating', 'image'],
                ],
                't3-payments-with-crypto-section-7' => [
                    'title' => esc_html__('Receive payments from anyone, - Payments With Crypto', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't3-payments-with-crypto',
                    'section_number' => 7,
                    'images_count' => 1,
                    'tags' => ['cta', 'payments', 'with', 'crypto', 'text', 'button'],
                ],
                't30-aging-with-dignity-section-1' => [
                    'title' => esc_html__('Seniors have unique needs, - Aging With Dignity', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't30-aging-with-dignity',
                    'section_number' => 1,
                    'images_count' => 4,
                    'tags' => ['cta', 'aging', 'with', 'dignity', 'text', 'button', 'king addons video popup', 'image'],
                ],
                't30-aging-with-dignity-section-2' => [
                    'title' => esc_html__('We go the extra - Aging With Dignity', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't30-aging-with-dignity',
                    'section_number' => 2,
                    'images_count' => 4,
                    'tags' => ['cta', 'aging', 'with', 'dignity', 'text', 'image', 'button'],
                ],
                't30-aging-with-dignity-section-3' => [
                    'title' => esc_html__('Regular check-ups and monitoring - Aging With Dignity', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't30-aging-with-dignity',
                    'section_number' => 3,
                    'images_count' => 5,
                    'tags' => ['content', 'aging', 'with', 'dignity', 'text', 'image'],
                ],
                't30-aging-with-dignity-section-4' => [
                    'title' => esc_html__('Our commitment to compassionate, - Aging With Dignity', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't30-aging-with-dignity',
                    'section_number' => 4,
                    'images_count' => 5,
                    'tags' => ['content', 'aging', 'with', 'dignity', 'text', 'divider', 'image box', 'image'],
                ],
                't30-aging-with-dignity-section-5' => [
                    'title' => esc_html__('The comfort, safety, and - Aging With Dignity', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't30-aging-with-dignity',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['content', 'aging', 'with', 'dignity', 'text'],
                ],
                't30-aging-with-dignity-section-6' => [
                    'title' => esc_html__(' We provide not - Aging With Dignity', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't30-aging-with-dignity',
                    'section_number' => 6,
                    'images_count' => 6,
                    'tags' => ['content', 'aging', 'with', 'dignity', 'text', 'king addons card carousel'],
                ],
                't30-aging-with-dignity-section-7' => [
                    'title' => esc_html__(' We provide not - Aging With Dignity', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't30-aging-with-dignity',
                    'section_number' => 7,
                    'images_count' => 1,
                    'tags' => ['content', 'aging', 'with', 'dignity', 'text', 'king addons blog posts'],
                ],
                't30-aging-with-dignity-section-8' => [
                    'title' => esc_html__('Seniors have unique needs, - Aging With Dignity', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't30-aging-with-dignity',
                    'section_number' => 8,
                    'images_count' => 1,
                    'tags' => ['cta', 'aging', 'with', 'dignity', 'text', 'button'],
                ],
                't30-contact-us-section-1' => [
                    'title' => esc_html__('Our commitment to compassionate, - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't30-contact-us',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['header', 'contact', 'text', 'spacer', 'heading', 'shortcode'],
                ],
                't30-contact-us-section-2' => [
                    'title' => esc_html__('Contact Us - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't30-contact-us',
                    'section_number' => 2,
                    'images_count' => 0,
                    'tags' => ['general', 'contact', 'icon box'],
                ],
                't30-contact-us-section-3' => [
                    'title' => esc_html__('We provide not just - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't30-contact-us',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['content', 'contact', 'text', 'google_maps'],
                ],
                't30-contact-us-section-4' => [
                    'title' => esc_html__('The comfort, safety, and - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't30-contact-us',
                    'section_number' => 4,
                    'images_count' => 1,
                    'tags' => ['content', 'contact', 'text'],
                ],
                't30-contact-us-section-5' => [
                    'title' => esc_html__('Our commitment to compassionate, - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't30-contact-us',
                    'section_number' => 5,
                    'images_count' => 2,
                    'tags' => ['cta', 'contact', 'text', 'button'],
                ],
                't30-exceptional-care-section-1' => [
                    'title' => esc_html__('Our commitment to compassionate, - Exceptional Care', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't30-exceptional-care',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['cta', 'exceptional', 'care', 'text', 'button'],
                ],
                't30-exceptional-care-section-2' => [
                    'title' => esc_html__('Exceptional Care - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't30-exceptional-care',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['general', 'exceptional', 'care', 'king addons video popup'],
                ],
                't30-exceptional-care-section-3' => [
                    'title' => esc_html__('We go the extra - Exceptional Care', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't30-exceptional-care',
                    'section_number' => 3,
                    'images_count' => 4,
                    'tags' => ['cta', 'exceptional', 'care', 'text', 'image', 'button'],
                ],
                't30-exceptional-care-section-4' => [
                    'title' => esc_html__('Regular check-ups and monitoring - Exceptional Care', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't30-exceptional-care',
                    'section_number' => 4,
                    'images_count' => 5,
                    'tags' => ['content', 'exceptional', 'care', 'text', 'image'],
                ],
                't30-exceptional-care-section-5' => [
                    'title' => esc_html__('Our commitment to compassionate, - Exceptional Care', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't30-exceptional-care',
                    'section_number' => 5,
                    'images_count' => 3,
                    'tags' => ['content', 'exceptional', 'care', 'image', 'text', 'icon list'],
                ],
                't30-exceptional-care-section-6' => [
                    'title' => esc_html__('The comfort, safety, and - Exceptional Care', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't30-exceptional-care',
                    'section_number' => 6,
                    'images_count' => 1,
                    'tags' => ['content', 'exceptional', 'care', 'text'],
                ],
                't30-exceptional-care-section-7' => [
                    'title' => esc_html__(' We provide not - Exceptional Care', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't30-exceptional-care',
                    'section_number' => 7,
                    'images_count' => 6,
                    'tags' => ['content', 'exceptional', 'care', 'text', 'king addons card carousel'],
                ],
                't30-exceptional-care-section-8' => [
                    'title' => esc_html__(' We provide not - Exceptional Care', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't30-exceptional-care',
                    'section_number' => 8,
                    'images_count' => 1,
                    'tags' => ['content', 'exceptional', 'care', 'text', 'king addons blog posts'],
                ],
                't30-exceptional-care-section-9' => [
                    'title' => esc_html__('Our commitment to compassionate, - Exceptional Care', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't30-exceptional-care',
                    'section_number' => 9,
                    'images_count' => 2,
                    'tags' => ['cta', 'exceptional', 'care', 'text', 'button'],
                ],
                't30-golden-years-shine-brightest-section-1' => [
                    'title' => esc_html__('Our caregivers provide meaningful - Golden Years Shine Brightest', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't30-golden-years-shine-brightest',
                    'section_number' => 1,
                    'images_count' => 4,
                    'tags' => ['cta', 'golden', 'years', 'shine', 'brightest', 'text', 'image', 'text path', 'button'],
                ],
                't30-golden-years-shine-brightest-section-2' => [
                    'title' => esc_html__('Golden Years Shine Brightest - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't30-golden-years-shine-brightest',
                    'section_number' => 2,
                    'images_count' => 9,
                    'tags' => ['general', 'golden', 'years', 'shine', 'brightest', 'image carousel'],
                ],
                't30-golden-years-shine-brightest-section-3' => [
                    'title' => esc_html__('We go the extra - Golden Years Shine Brightest', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't30-golden-years-shine-brightest',
                    'section_number' => 3,
                    'images_count' => 4,
                    'tags' => ['cta', 'golden', 'years', 'shine', 'brightest', 'text', 'image', 'button'],
                ],
                't30-golden-years-shine-brightest-section-4' => [
                    'title' => esc_html__('We go the extra - Golden Years Shine Brightest', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't30-golden-years-shine-brightest',
                    'section_number' => 4,
                    'images_count' => 5,
                    'tags' => ['content', 'golden', 'years', 'shine', 'brightest', 'text', 'image box'],
                ],
                't30-golden-years-shine-brightest-section-5' => [
                    'title' => esc_html__('The comfort, safety, and - Golden Years Shine Brightest', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't30-golden-years-shine-brightest',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['content', 'golden', 'years', 'shine', 'brightest', 'text'],
                ],
                't30-golden-years-shine-brightest-section-6' => [
                    'title' => esc_html__('Our commitment to compassionate, - Golden Years Shine Brightest', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't30-golden-years-shine-brightest',
                    'section_number' => 6,
                    'images_count' => 5,
                    'tags' => ['content', 'golden', 'years', 'shine', 'brightest', 'text', 'divider', 'image box', 'image'],
                ],
                't30-golden-years-shine-brightest-section-7' => [
                    'title' => esc_html__(' We provide not - Golden Years Shine Brightest', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't30-golden-years-shine-brightest',
                    'section_number' => 7,
                    'images_count' => 6,
                    'tags' => ['content', 'golden', 'years', 'shine', 'brightest', 'text', 'king addons card carousel'],
                ],
                't30-golden-years-shine-brightest-section-8' => [
                    'title' => esc_html__(' We provide not - Golden Years Shine Brightest', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't30-golden-years-shine-brightest',
                    'section_number' => 8,
                    'images_count' => 1,
                    'tags' => ['content', 'golden', 'years', 'shine', 'brightest', 'text', 'king addons blog posts'],
                ],
                't30-golden-years-shine-brightest-section-9' => [
                    'title' => esc_html__('Seniors have unique needs, - Golden Years Shine Brightest', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't30-golden-years-shine-brightest',
                    'section_number' => 9,
                    'images_count' => 1,
                    'tags' => ['cta', 'golden', 'years', 'shine', 'brightest', 'text', 'button'],
                ],
                't30-moments-of-care-section-1' => [
                    'title' => esc_html__('Our commitment to compassionate, - Moments Of Care', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't30-moments-of-care',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['content', 'moments', 'care', 'text'],
                ],
                't30-moments-of-care-section-2' => [
                    'title' => esc_html__('Moments Of Care - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't30-moments-of-care',
                    'section_number' => 2,
                    'images_count' => 12,
                    'tags' => ['general', 'moments', 'care', 'king addons image grid'],
                ],
                't30-moments-of-care-section-3' => [
                    'title' => esc_html__('Our commitment to compassionate, - Moments Of Care', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't30-moments-of-care',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['cta', 'moments', 'care', 'text', 'button'],
                ],
                't30-one-smile-at-a-time-section-1' => [
                    'title' => esc_html__('Rest assured, your loved - One Smile At A Time', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't30-one-smile-at-a-time',
                    'section_number' => 1,
                    'images_count' => 2,
                    'tags' => ['cta', 'one', 'smile', 'time', 'text', 'button', 'text path', 'image'],
                ],
                't30-one-smile-at-a-time-section-2' => [
                    'title' => esc_html__('One Smile At A Time - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't30-one-smile-at-a-time',
                    'section_number' => 2,
                    'images_count' => 9,
                    'tags' => ['general', 'one', 'smile', 'time', 'image carousel'],
                ],
                't30-one-smile-at-a-time-section-3' => [
                    'title' => esc_html__('Our commitment to compassionate, - One Smile At A Time', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't30-one-smile-at-a-time',
                    'section_number' => 3,
                    'images_count' => 5,
                    'tags' => ['content', 'one', 'smile', 'time', 'text', 'divider', 'image box', 'image'],
                ],
                't30-one-smile-at-a-time-section-4' => [
                    'title' => esc_html__('We go the extra - One Smile At A Time', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't30-one-smile-at-a-time',
                    'section_number' => 4,
                    'images_count' => 5,
                    'tags' => ['content', 'one', 'smile', 'time', 'text', 'image box'],
                ],
                't30-one-smile-at-a-time-section-5' => [
                    'title' => esc_html__('The comfort, safety, and - One Smile At A Time', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't30-one-smile-at-a-time',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['content', 'one', 'smile', 'time', 'text'],
                ],
                't30-one-smile-at-a-time-section-6' => [
                    'title' => esc_html__('We go the extra - One Smile At A Time', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't30-one-smile-at-a-time',
                    'section_number' => 6,
                    'images_count' => 4,
                    'tags' => ['cta', 'one', 'smile', 'time', 'text', 'image', 'button'],
                ],
                't30-one-smile-at-a-time-section-7' => [
                    'title' => esc_html__(' We provide not - One Smile At A Time', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't30-one-smile-at-a-time',
                    'section_number' => 7,
                    'images_count' => 6,
                    'tags' => ['content', 'one', 'smile', 'time', 'text', 'king addons card carousel'],
                ],
                't30-one-smile-at-a-time-section-8' => [
                    'title' => esc_html__(' We provide not - One Smile At A Time', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't30-one-smile-at-a-time',
                    'section_number' => 8,
                    'images_count' => 1,
                    'tags' => ['content', 'one', 'smile', 'time', 'text', 'king addons blog posts'],
                ],
                't30-one-smile-at-a-time-section-9' => [
                    'title' => esc_html__('Our commitment to compassionate, - One Smile At A Time', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't30-one-smile-at-a-time',
                    'section_number' => 9,
                    'images_count' => 2,
                    'tags' => ['cta', 'one', 'smile', 'time', 'text', 'button'],
                ],
                't30-our-services-section-1' => [
                    'title' => esc_html__('Our commitment to compassionate, - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't30-our-services',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['content', 'our', 'services', 'text'],
                ],
                't30-our-services-section-2' => [
                    'title' => esc_html__('Our Services - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't30-our-services',
                    'section_number' => 2,
                    'images_count' => 1,
                    'tags' => ['general', 'our', 'services', 'king addons video popup'],
                ],
                't30-our-services-section-3' => [
                    'title' => esc_html__('Our commitment to compassionate, - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't30-our-services',
                    'section_number' => 3,
                    'images_count' => 3,
                    'tags' => ['content', 'our', 'services', 'image', 'text', 'icon list'],
                ],
                't30-our-services-section-4' => [
                    'title' => esc_html__('Regular check-ups and monitoring - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't30-our-services',
                    'section_number' => 4,
                    'images_count' => 5,
                    'tags' => ['content', 'our', 'services', 'text', 'image'],
                ],
                't30-our-services-section-5' => [
                    'title' => esc_html__('The comfort, safety, and - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't30-our-services',
                    'section_number' => 5,
                    'images_count' => 1,
                    'tags' => ['content', 'our', 'services', 'text'],
                ],
                't30-our-services-section-6' => [
                    'title' => esc_html__('Our commitment to compassionate, - Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't30-our-services',
                    'section_number' => 6,
                    'images_count' => 2,
                    'tags' => ['cta', 'our', 'services', 'text', 'button'],
                ],
                't30-our-team-section-1' => [
                    'title' => esc_html__('Our commitment to compassionate, - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't30-our-team',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['content', 'our', 'team', 'text'],
                ],
                't30-our-team-section-2' => [
                    'title' => esc_html__('— Outreach Specialist - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't30-our-team',
                    'section_number' => 2,
                    'images_count' => 20,
                    'tags' => ['header', 'our', 'team', 'image', 'text', 'heading', 'social icons', 'divider'],
                ],
                't30-our-team-section-3' => [
                    'title' => esc_html__('Our commitment to compassionate, - Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't30-our-team',
                    'section_number' => 3,
                    'images_count' => 2,
                    'tags' => ['cta', 'our', 'team', 'text', 'button'],
                ],
                't31-contact-us-section-1' => [
                    'title' => esc_html__('
Our mission is to - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't31-contact-us',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['content', 'contact', 'text'],
                ],
                't31-contact-us-section-2' => [
                    'title' => esc_html__('We will receive your - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't31-contact-us',
                    'section_number' => 2,
                    'images_count' => 2,
                    'tags' => ['header', 'contact', 'heading', 'text', 'shortcode', 'spacer'],
                ],
                't31-contact-us-section-3' => [
                    'title' => esc_html__('Take your morning put-on - Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't31-contact-us',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['hero', 'contact', 'text', 'button', 'google_maps', 'heading', 'king addons business hours', 'social icons'],
                ],
                't31-gallery-section-1' => [
                    'title' => esc_html__('
Our mission is to - Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't31-gallery',
                    'section_number' => 1,
                    'images_count' => 1,
                    'tags' => ['content', 'gallery', 'text'],
                ],
                't31-gallery-section-2' => [
                    'title' => esc_html__('Gallery - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't31-gallery',
                    'section_number' => 2,
                    'images_count' => 15,
                    'tags' => ['general', 'gallery', 'king addons image grid'],
                ],
                't31-gallery-section-3' => [
                    'title' => esc_html__('Take your morning put-on - Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't31-gallery',
                    'section_number' => 3,
                    'images_count' => 1,
                    'tags' => ['cta', 'gallery', 'text', 'button'],
                ],
                't31-lash-dreams-section-1' => [
                    'title' => esc_html__('Our expert lash artists - Lash Dreams', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't31-lash-dreams',
                    'section_number' => 1,
                    'images_count' => 8,
                    'tags' => ['hero', 'lash', 'dreams', 'text', 'button', 'image', 'heading', 'text path'],
                ],
                't31-lash-dreams-section-2' => [
                    'title' => esc_html__('Lash Dreams - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't31-lash-dreams',
                    'section_number' => 2,
                    'images_count' => 11,
                    'tags' => ['general', 'lash', 'dreams', 'image carousel'],
                ],
                't31-lash-dreams-section-3' => [
                    'title' => esc_html__('Eyes are the windows - Lash Dreams', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't31-lash-dreams',
                    'section_number' => 3,
                    'images_count' => 11,
                    'tags' => ['cta', 'lash', 'dreams', 'text', 'button', 'image'],
                ],
                't31-lash-dreams-section-4' => [
                    'title' => esc_html__(' Transform your look - Lash Dreams', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't31-lash-dreams',
                    'section_number' => 4,
                    'images_count' => 5,
                    'tags' => ['content', 'lash', 'dreams', 'text', 'image box'],
                ],
                't31-lash-dreams-section-5' => [
                    'title' => esc_html__('Our expert lash artists - Lash Dreams', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't31-lash-dreams',
                    'section_number' => 5,
                    'images_count' => 7,
                    'tags' => ['content', 'lash', 'dreams', 'text', 'king addons price list'],
                ],
                't31-lash-dreams-section-6' => [
                    'title' => esc_html__('At the heart of - Lash Dreams', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't31-lash-dreams',
                    'section_number' => 6,
                    'images_count' => 5,
                    'tags' => ['content', 'lash', 'dreams', 'text', 'image'],
                ],
                't31-lash-dreams-section-7' => [
                    'title' => esc_html__('Take your morning put-on - Lash Dreams', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't31-lash-dreams',
                    'section_number' => 7,
                    'images_count' => 1,
                    'tags' => ['cta', 'lash', 'dreams', 'text', 'button'],
                ],
                't31-lash-dreams-section-8' => [
                    'title' => esc_html__('\"Ella and her team - Lash Dreams', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't31-lash-dreams',
                    'section_number' => 8,
                    'images_count' => 1,
                    'tags' => ['header', 'lash', 'dreams', 'text', 'star rating', 'heading'],
                ],
                't31-lash-dreams-section-9' => [
                    'title' => esc_html__('Take your morning put-on - Lash Dreams', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't31-lash-dreams',
                    'section_number' => 9,
                    'images_count' => 4,
                    'tags' => ['header', 'lash', 'dreams', 'text', 'king addons image comparison', 'heading'],
                ],
                't31-lash-dreams-section-10' => [
                    'title' => esc_html__('Take your morning put-on - Lash Dreams', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't31-lash-dreams',
                    'section_number' => 10,
                    'images_count' => 2,
                    'tags' => ['cta', 'lash', 'dreams', 'text', 'button', 'image'],
                ],
                't31-lash-elegance-section-1' => [
                    'title' => esc_html__('Take your morning put-on - Lash Elegance', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'hero sections',
                    'section_type' => 'hero',
                    'parent_template' => 't31-lash-elegance',
                    'section_number' => 1,
                    'images_count' => 4,
                    'tags' => ['hero', 'lash', 'elegance', 'image', 'text path', 'text', 'button', 'heading'],
                ],
                't31-lash-elegance-section-2' => [
                    'title' => esc_html__('Lash Elegance - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't31-lash-elegance',
                    'section_number' => 2,
                    'images_count' => 11,
                    'tags' => ['general', 'lash', 'elegance', 'image carousel'],
                ],
                't31-lash-elegance-section-3' => [
                    'title' => esc_html__('Would you like longer, - Lash Elegance', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't31-lash-elegance',
                    'section_number' => 3,
                    'images_count' => 6,
                    'tags' => ['cta', 'lash', 'elegance', 'text', 'button', 'image'],
                ],
                't31-lash-elegance-section-4' => [
                    'title' => esc_html__(' Transform your look - Lash Elegance', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't31-lash-elegance',
                    'section_number' => 4,
                    'images_count' => 5,
                    'tags' => ['content', 'lash', 'elegance', 'text', 'image box'],
                ],
                't31-lash-elegance-section-5' => [
                    'title' => esc_html__('Our expert lash artists - Lash Elegance', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't31-lash-elegance',
                    'section_number' => 5,
                    'images_count' => 7,
                    'tags' => ['content', 'lash', 'elegance', 'text', 'king addons price list'],
                ],
                't31-lash-elegance-section-6' => [
                    'title' => esc_html__('At the heart of - Lash Elegance', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't31-lash-elegance',
                    'section_number' => 6,
                    'images_count' => 5,
                    'tags' => ['content', 'lash', 'elegance', 'text', 'image'],
                ],
                't31-lash-elegance-section-7' => [
                    'title' => esc_html__('Take your morning put-on - Lash Elegance', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't31-lash-elegance',
                    'section_number' => 7,
                    'images_count' => 1,
                    'tags' => ['cta', 'lash', 'elegance', 'text', 'button'],
                ],
                't31-lash-elegance-section-8' => [
                    'title' => esc_html__('\"Ella and her team - Lash Elegance', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't31-lash-elegance',
                    'section_number' => 8,
                    'images_count' => 1,
                    'tags' => ['header', 'lash', 'elegance', 'text', 'star rating', 'heading'],
                ],
                't31-lash-elegance-section-9' => [
                    'title' => esc_html__('Lash Elegance - General Section 9', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't31-lash-elegance',
                    'section_number' => 9,
                    'images_count' => 8,
                    'tags' => ['general', 'lash', 'elegance', 'king addons image grid'],
                ],
                't31-lash-elegance-section-10' => [
                    'title' => esc_html__('Take your morning put-on - Lash Elegance', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't31-lash-elegance',
                    'section_number' => 10,
                    'images_count' => 3,
                    'tags' => ['cta', 'lash', 'elegance', 'text', 'button', 'image'],
                ],
                't31-lash-love-section-1' => [
                    'title' => esc_html__('Enjoy a semi-permanent curling - Lash Love', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't31-lash-love',
                    'section_number' => 1,
                    'images_count' => 3,
                    'tags' => ['cta', 'lash', 'love', 'text', 'button', 'image'],
                ],
                't31-lash-love-section-2' => [
                    'title' => esc_html__('Lash Love - General Section 2', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'general',
                    'section_type' => 'general',
                    'parent_template' => 't31-lash-love',
                    'section_number' => 2,
                    'images_count' => 11,
                    'tags' => ['general', 'lash', 'love', 'image carousel'],
                ],
                't31-lash-love-section-3' => [
                    'title' => esc_html__('Would you like longer, - Lash Love', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't31-lash-love',
                    'section_number' => 3,
                    'images_count' => 7,
                    'tags' => ['content', 'lash', 'love', 'image', 'text'],
                ],
                't31-lash-love-section-4' => [
                    'title' => esc_html__(' Transform your look - Lash Love', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't31-lash-love',
                    'section_number' => 4,
                    'images_count' => 5,
                    'tags' => ['content', 'lash', 'love', 'text', 'image box'],
                ],
                't31-lash-love-section-5' => [
                    'title' => esc_html__('Our expert lash artists - Lash Love', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't31-lash-love',
                    'section_number' => 5,
                    'images_count' => 7,
                    'tags' => ['content', 'lash', 'love', 'text', 'king addons card carousel'],
                ],
                't31-lash-love-section-6' => [
                    'title' => esc_html__('At the heart of - Lash Love', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't31-lash-love',
                    'section_number' => 6,
                    'images_count' => 5,
                    'tags' => ['content', 'lash', 'love', 'text', 'image'],
                ],
                't31-lash-love-section-7' => [
                    'title' => esc_html__('Take your morning put-on - Lash Love', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'call to action',
                    'section_type' => 'cta',
                    'parent_template' => 't31-lash-love',
                    'section_number' => 7,
                    'images_count' => 1,
                    'tags' => ['cta', 'lash', 'love', 'text', 'button'],
                ],
                't31-lash-love-section-8' => [
                    'title' => esc_html__('\"Ella and her team - Lash Love', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'headers',
                    'section_type' => 'header',
                    'parent_template' => 't31-lash-love',
                    'section_number' => 8,
                    'images_count' => 1,
                    'tags' => ['header', 'lash', 'love', 'text', 'star rating', 'heading'],
                ],
                't31-lash-love-section-9' => [
                    'title' => esc_html__('Our expert lash artists - Lash Love', 'king-addons'),
                    'plan' => 'premium',
                    'category' => 'business',
                    'subcategory' => 'content sections',
                    'section_type' => 'content',
                    'parent_template' => 't31-lash-love',
                    'section_number' => 9,
                    'images_count' => 8,
        