<?php if ( ! defined( 'ABSPATH' ) ) {
	die( 'Cheatin&#8217; uh?' );
}

if ( ! function_exists( 'sc_4_jsps' ) ) {

	/**
	 * Declare the JSPS Shortcode.
	 *
	 * @param (array) $atts The attributes of the shortcode.
	 * @return (void)
	 *
	 * @since  1.0
	 * @author Geoffrey Crofte
	 */
	function sc_4_jsps( $atts ) {
		
		$atts = shortcode_atts( array(
			'buttons' 	=> 'twitter,linkedin',
			'counters'	=> 0,
			'current'	=> 1,
			'url'		=> NULL
		), $atts );

		/**
		 * Filters the attributes of the shortcode `juiz_social` or `juiz_sps`
		 * 
		 * @hook juiz_sps_shortcode_atts
		 *
	 	 * @since  2.0.0 First version
	 	 *
	 	 * @param  {array}   atts                             The shortcode attributes.
	 	 * @param  {string}  atts.buttons="twitter,linkedin"  The list of network shortnames separated by a comma.
	 	 * @param  {int}     atts.counters=0                  `1` to activate counters.
	 	 * @param  {int}     atts.current=1                   `0` to share something else than the current URL.
	 	 * @param  {string}  atts.url=NULL                     The URL to share.
	 	 *
	 	 * @return {array}                                     The filtered shortcode attributes.
		 */
		$atts = apply_filters( 'juiz_sps_shortcode_atts', $atts );
		
		// Buttons become array
		// "digg,mail", "digg ,mail", "digg, mail", "digg , mail", are correct syntaxes
		$jsps_networks 		= preg_split( '#[\s+,\s+]#', $atts['buttons'] );
		$jsps_counters 		= intval( $atts['counters'] );
		$jsps_current_page 	= intval( $atts['current'] );
		$jsps_url 			= $atts['url'];

		if ( $jsps_current_page == 1 ) {
			jsps_enqueue_scripts();
		}
		
		ob_start();
		juiz_sps( $jsps_networks, $jsps_counters, $jsps_current_page, 1, $jsps_url ); //do an echo
		$jsps_sc_output = ob_get_contents();
		ob_end_clean();
		
		/**
		 * Filters content before returning the HTML generated by the `juiz_social` or `juiz_sps` Shortcode.
		 * 
		 * @hook juiz_sps_shortcode
		 *
	 	 * @since  2.0.0 First version
	 	 *
	 	 * @param  {string} $output  The original HTML output of the shortcode.
	 	 * @param  {array}  $atts    The shortcode attributes. Can be filtered {@link juiz_sps_shortcode_atts}
	 	 * 
	 	 * @return {string}          Return the filtered HTML content.
		 */
		return apply_filters_deprecated( 'juiz_sps_should_display_shortcode', array( $jsps_sc_output, $atts ), '2.0.0', 'juiz_sps_shortcode' );
	}

	add_shortcode( 'juiz_social','sc_4_jsps' );
	add_shortcode( 'juiz_sps'   ,'sc_4_jsps' );

}
