<?php if ( ! defined( 'ABSPATH' ) ) {
	die( 'Cheatin&#8217; uh?' );
}

if ( ! function_exists( 'add_juiz_sps_welcome_page' ) ) {
	/**
	 * Create a page for the Welcome.
	 *
	 * @since   2.0.0
	 * @author  Geoffrey Crofte
	 */
	function add_juiz_sps_welcome_page() {
		// The hidden Welcome page
		add_submenu_page(
			'options-general.php', // Passing null doesn't work anymore with PHP 8.2+
			__( 'Social Post Sharer', 'juiz-social-post-sharer' ),
			__( 'Social Post Sharer', 'juiz-social-post-sharer' ),
			'administrator',
			JUIZ_SPS_SLUG . '-welcome',
			'juiz_sps_welcome_page'
		);
	}
	add_action( 'admin_menu', 'add_juiz_sps_welcome_page' );

	/**
	 * Remove the welcome page as submenu file.
	 * Tip to replace the Null hack in add_juiz_sps_welcome_page() > add_submenu_page()
	 *
	 * @since   2.3.3
	 * @author  Geoffrey Crofte
	 */
	function remove_juiz_sps_welcome_page( $submenu_file ) {
		remove_submenu_page( 'options-general.php', JUIZ_SPS_SLUG . '-welcome' );
		return $submenu_file;
	}
	add_filter( 'submenu_file', 'remove_juiz_sps_welcome_page' );
}

if ( ! function_exists( 'juiz_sps_welcome_page' ) ) {

	function juiz_sps_welcome_page() {
	?>
	<div id="juiz-sps" class="wrap welcome-page">

		<div class="jsps-main-content">
			<div class="jsps-main-header">
				<h1>
					<img src="<?php echo JUIZ_SPS_PLUGIN_ASSETS . 'admin/nobs-logo-light.svg' ?>" width="249" height="48" alt="Nobs • Share Buttons">
					<small>v.&nbsp;<?php echo JUIZ_SPS_VERSION; ?></small>
				</h1>
			</div>

			<div class="jsps-main-body">
				
				<p class="juiz-sps-big">
					<?php printf( esc_html__( 'Welcome in version %s', 'juiz-social-post-sharer'), '<span class="jsps-version-number">' . JUIZ_SPS_VERSION . '</span>' ); ?>
				</p>

				<p class="juiz-sps-subtitle">
					<?php printf( esc_html__('The good way to make people share your content %swithout sacrificing%s your website performance!' , 'juiz-social-post-sharer'), '<strong>', '</strong>') ?>
				</p>


				<div class="jsps-welcome-grid">
					<div class="jsps-col">

						<p class="jsps-icon">
							<svg width="120" height="120" viewBox="0 0 120 120" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M76.8001 102H30C26.0232 102 22.8 98.7768 22.8 94.8V25.2C22.8 21.2232 26.0232 18 30 18H76.8001C80.7769 18 84 21.2232 84 25.2V94.8C84 98.7768 80.7769 102 76.8001 102Z" fill="#E3E8ED"/>
								<path d="M78.6001 87.6H28.2001C27.8689 87.6 27.6001 87.3312 27.6001 87V28.2C27.6001 27.8688 27.8689 27.6 28.2001 27.6H78.6001C78.9313 27.6 79.2001 27.8688 79.2001 28.2V87C79.2001 87.3312 78.9313 87.6 78.6001 87.6Z" fill="#CEEEF9"/>
								<path d="M58.2 24H48.6012C48.27 24 48.0012 23.7312 48.0012 23.4C48.0012 23.0688 48.27 22.8 48.6012 22.8H58.2C58.5312 22.8 58.8 23.0688 58.8 23.4C58.8 23.7312 58.5312 24 58.2 24Z" fill="#103744"/>
								<path d="M85.8001 36.6H84.6001V28.2H85.8001C86.4625 28.2 87.0001 28.7376 87.0001 29.4V35.4C87.0001 36.0624 86.4625 36.6 85.8001 36.6Z" fill="#20A0C9"/>
								<path d="M85.8 37.2H84.6C84.2688 37.2 84 36.9312 84 36.6V28.2C84 27.8688 84.2688 27.6 84.6 27.6H85.8C86.7924 27.6 87.6 28.4076 87.6 29.4V35.4C87.6 36.3924 86.7924 37.2 85.8 37.2ZM85.2 36H85.8C86.13 36 86.4 35.7312 86.4 35.4V29.4C86.4 29.0688 86.13 28.8 85.8 28.8H85.2V36Z" fill="#103744"/>
								<path d="M28.2001 78C27.8689 78 27.6001 77.7312 27.6001 77.4V75C27.6001 74.6688 27.8689 74.4 28.2001 74.4C28.5313 74.4 28.8001 74.6688 28.8001 75V77.4C28.8001 77.7312 28.5313 78 28.2001 78Z" fill="#103744"/>
								<path d="M28.2001 68.4C27.8689 68.4 27.6001 68.1312 27.6001 67.8V28.2C27.6001 27.8688 27.8689 27.6 28.2001 27.6H73.8001C74.1313 27.6 74.4001 27.8688 74.4001 28.2C74.4001 28.5312 74.1313 28.8 73.8001 28.8H28.8001V67.8C28.8001 68.1312 28.5313 68.4 28.2001 68.4Z" fill="#103744"/>
								<path d="M78.6 33.6C78.2688 33.6 78 33.3312 78 33V28.2C78 27.8688 78.2688 27.6 78.6 27.6C78.9312 27.6 79.2 27.8688 79.2 28.2V33C79.2 33.3312 78.9312 33.6 78.6 33.6Z" fill="#103744"/>
								<path d="M78.6 37.2C78.2688 37.2 78 36.9312 78 36.6V35.4C78 35.0688 78.2688 34.8 78.6 34.8C78.9312 34.8 79.2 35.0688 79.2 35.4V36.6C79.2 36.9312 78.9312 37.2 78.6 37.2Z" fill="#103744"/>
								<path d="M78.6001 42C78.2689 42 78.0001 42.2688 78.0001 42.6V86.4H28.8001V79.8C28.8001 79.4688 28.5313 79.2 28.2001 79.2C27.8689 79.2 27.6001 79.4688 27.6001 79.8V87C27.6001 87.3312 27.8689 87.6 28.2001 87.6H78.6001C78.9313 87.6 79.2001 87.3312 79.2001 87V42.6C79.2001 42.2688 78.9313 42 78.6001 42Z" fill="#103744"/>
								<path d="M53.4 97.8C55.3883 97.8 57 96.1882 57 94.2C57 92.2118 55.3883 90.6 53.4 90.6C51.4118 90.6 49.8 92.2118 49.8 94.2C49.8 96.1882 51.4118 97.8 53.4 97.8Z" fill="#20A0C9"/>
								<path d="M53.4 98.4C51.084 98.4 49.2 96.516 49.2 94.2C49.2 91.884 51.084 90 53.4 90C55.7159 90 57.5999 91.884 57.5999 94.2C57.5999 96.516 55.7159 98.4 53.4 98.4ZM53.4 91.2C51.7452 91.2 50.4 92.5464 50.4 94.2C50.4 95.8536 51.7452 97.2 53.4 97.2C55.0547 97.2 56.3999 95.8536 56.3999 94.2C56.3999 92.5464 55.0547 91.2 53.4 91.2Z" fill="#103744"/>
								<path d="M76.8001 16.8H30.0001C25.3609 16.8 21.6001 20.5608 21.6001 25.2V94.8C21.6001 99.4392 25.3609 103.2 30.0001 103.2H76.8001C81.4393 103.2 85.2001 99.4392 85.2001 94.8V25.2C85.2001 20.5608 81.4393 16.8 76.8001 16.8ZM82.8001 94.8C82.8001 98.1132 80.1133 100.8 76.8001 100.8H30.0001C26.6869 100.8 24.0001 98.1132 24.0001 94.8V25.2C24.0001 21.8868 26.6869 19.2 30.0001 19.2H76.8001C80.1133 19.2 82.8001 21.8868 82.8001 25.2V94.8Z" fill="#103744"/>
								<path d="M94.8 106.8H72C68.0232 106.8 64.8 103.577 64.8 99.6V50.4C64.8 46.4232 68.0232 43.2 72 43.2H94.8C98.7768 43.2 102 46.4232 102 50.4V99.6C102 103.577 98.7768 106.8 94.8 106.8Z" fill="#E3E8ED"/>
								<path d="M97.7999 94.8H68.9999C68.6687 94.8 68.3999 94.5312 68.3999 94.2V51C68.3999 50.6688 68.6687 50.4 68.9999 50.4H97.7999C98.1311 50.4 98.3999 50.6688 98.3999 51V94.2C98.3999 94.5312 98.1311 94.8 97.7999 94.8Z" fill="#CEEEF9"/>
								<path d="M85.7987 48H80.9999C80.6687 48 80.3999 47.7312 80.3999 47.4C80.3999 47.0688 80.6687 46.8 80.9999 46.8H85.7987C86.1299 46.8 86.3987 47.0688 86.3987 47.4C86.3987 47.7312 86.1299 48 85.7987 48Z" fill="#103744"/>
								<path d="M103.8 61.8H102.6V53.4H103.8C104.462 53.4 105 53.9376 105 54.6V60.6C105 61.2624 104.462 61.8 103.8 61.8Z" fill="#20A0C9"/>
								<path d="M103.8 62.4H102.6C102.269 62.4 102 62.1312 102 61.8V53.4C102 53.0688 102.269 52.8 102.6 52.8H103.8C104.792 52.8 105.6 53.6076 105.6 54.6V60.6C105.6 61.5924 104.792 62.4 103.8 62.4ZM103.2 61.2H103.8C104.13 61.2 104.4 60.9312 104.4 60.6V54.6C104.4 54.2688 104.13 54 103.8 54H103.2V61.2Z" fill="#103744"/>
								<path d="M68.9999 78C68.6687 78 68.3999 77.7312 68.3999 77.4V75C68.3999 74.6688 68.6687 74.4 68.9999 74.4C69.3311 74.4 69.5999 74.6688 69.5999 75V77.4C69.5999 77.7312 69.3311 78 68.9999 78Z" fill="#103744"/>
								<path d="M68.9999 68.4C68.6687 68.4 68.3999 68.1312 68.3999 67.8V51C68.3999 50.6688 68.6687 50.4 68.9999 50.4H92.9999C93.3311 50.4 93.5999 50.6688 93.5999 51C93.5999 51.3312 93.3311 51.6 92.9999 51.6H69.5999V67.8C69.5999 68.1312 69.3311 68.4 68.9999 68.4Z" fill="#103744"/>
								<path d="M97.8 56.4C97.4688 56.4 97.2 56.1312 97.2 55.8V51C97.2 50.6688 97.4688 50.4 97.8 50.4C98.1312 50.4 98.4 50.6688 98.4 51V55.8C98.4 56.1312 98.1312 56.4 97.8 56.4Z" fill="#103744"/>
								<path d="M97.8 60C97.4688 60 97.2 59.7312 97.2 59.4V58.2C97.2 57.8688 97.4688 57.6 97.8 57.6C98.1312 57.6 98.4 57.8688 98.4 58.2V59.4C98.4 59.7312 98.1312 60 97.8 60Z" fill="#103744"/>
								<path d="M97.7999 64.8C97.4687 64.8 97.1999 65.0688 97.1999 65.4V93.6H69.5999V79.8C69.5999 79.4688 69.3311 79.2 68.9999 79.2C68.6687 79.2 68.3999 79.4688 68.3999 79.8V94.2C68.3999 94.5312 68.6687 94.8 68.9999 94.8H97.7999C98.1311 94.8 98.3999 94.5312 98.3999 94.2V65.4C98.3999 65.0688 98.1311 64.8 97.7999 64.8Z" fill="#103744"/>
								<path d="M83.4 102.6C84.7255 102.6 85.8 101.525 85.8 100.2C85.8 98.8745 84.7255 97.8 83.4 97.8C82.0745 97.8 81 98.8745 81 100.2C81 101.525 82.0745 102.6 83.4 102.6Z" fill="#20A0C9"/>
								<path d="M83.3999 98.4C84.3923 98.4 85.1999 99.2076 85.1999 100.2C85.1999 101.192 84.3923 102 83.3999 102C82.4075 102 81.5999 101.192 81.5999 100.2C81.5999 99.2076 82.4075 98.4 83.3999 98.4ZM83.3999 97.2C81.7451 97.2 80.3999 98.5452 80.3999 100.2C80.3999 101.855 81.7451 103.2 83.3999 103.2C85.0547 103.2 86.3999 101.855 86.3999 100.2C86.3999 98.5452 85.0547 97.2 83.3999 97.2Z" fill="#103744"/>
								<path d="M96.0001 42H70.8001C66.8233 42 63.6001 45.2232 63.6001 49.2V100.8C63.6001 104.777 66.8233 108 70.8001 108H96.0001C99.9769 108 103.2 104.777 103.2 100.8V49.2C103.2 45.2232 99.9769 42 96.0001 42ZM100.8 100.8C100.8 103.451 98.6509 105.6 96.0001 105.6H70.8001C68.1493 105.6 66.0001 103.451 66.0001 100.8V49.2C66.0001 46.5492 68.1493 44.4 70.8001 44.4H96.0001C98.6509 44.4 100.8 46.5492 100.8 49.2V100.8Z" fill="#103744"/>
								<path d="M76.2001 60.6H73.8001C73.1377 60.6 72.6001 60.0624 72.6001 59.4V57C72.6001 56.3376 73.1377 55.8 73.8001 55.8H76.2001C76.8625 55.8 77.4001 56.3376 77.4001 57V59.4C77.4001 60.0624 76.8625 60.6 76.2001 60.6Z" fill="#A1D3A2"/>
								<path d="M76.2 61.2H73.8C72.8076 61.2 72 60.3924 72 59.4V57C72 56.0076 72.8076 55.2 73.8 55.2H76.2C77.1924 55.2 78 56.0076 78 57V59.4C78 60.3924 77.1924 61.2 76.2 61.2ZM73.8 56.4C73.47 56.4 73.2 56.6688 73.2 57V59.4C73.2 59.7312 73.47 60 73.8 60H76.2C76.53 60 76.8 59.7312 76.8 59.4V57C76.8 56.6688 76.53 56.4 76.2 56.4H73.8Z" fill="#103744"/>
								<path d="M92.9999 60.6H90.5999C89.9375 60.6 89.3999 60.0624 89.3999 59.4V57C89.3999 56.3376 89.9375 55.8 90.5999 55.8H92.9999C93.6623 55.8 94.1999 56.3376 94.1999 57V59.4C94.1999 60.0624 93.6623 60.6 92.9999 60.6Z" fill="#FEF6AA"/>
								<path d="M93 61.2H90.6C89.6076 61.2 88.8 60.3924 88.8 59.4V57C88.8 56.0076 89.6076 55.2 90.6 55.2H93C93.9924 55.2 94.8 56.0076 94.8 57V59.4C94.8 60.3924 93.9924 61.2 93 61.2ZM90.6 56.4C90.27 56.4 90 56.6688 90 57V59.4C90 59.7312 90.27 60 90.6 60H93C93.33 60 93.6 59.7312 93.6 59.4V57C93.6 56.6688 93.33 56.4 93 56.4H90.6Z" fill="#103744"/>
								<path d="M84.6 60.6H82.2C81.5376 60.6 81 60.0624 81 59.4V57C81 56.3376 81.5376 55.8 82.2 55.8H84.6C85.2624 55.8 85.8 56.3376 85.8 57V59.4C85.8 60.0624 85.2624 60.6 84.6 60.6Z" fill="#20A0C9"/>
								<path d="M84.5999 61.2H82.1999C81.2075 61.2 80.3999 60.3924 80.3999 59.4V57C80.3999 56.0076 81.2075 55.2 82.1999 55.2H84.5999C85.5923 55.2 86.3999 56.0076 86.3999 57V59.4C86.3999 60.3924 85.5923 61.2 84.5999 61.2ZM82.1999 56.4C81.8699 56.4 81.5999 56.6688 81.5999 57V59.4C81.5999 59.7312 81.8699 60 82.1999 60H84.5999C84.9299 60 85.1999 59.7312 85.1999 59.4V57C85.1999 56.6688 84.9299 56.4 84.5999 56.4H82.1999Z" fill="#103744"/>
								<path d="M76.2001 69H73.8001C73.1377 69 72.6001 68.4624 72.6001 67.8V65.4C72.6001 64.7376 73.1377 64.2 73.8001 64.2H76.2001C76.8625 64.2 77.4001 64.7376 77.4001 65.4V67.8C77.4001 68.4624 76.8625 69 76.2001 69Z" fill="#F69272"/>
								<path d="M76.2 69.6H73.8C72.8076 69.6 72 68.7924 72 67.8V65.4C72 64.4076 72.8076 63.6 73.8 63.6H76.2C77.1924 63.6 78 64.4076 78 65.4V67.8C78 68.7924 77.1924 69.6 76.2 69.6ZM73.8 64.8C73.47 64.8 73.2 65.0688 73.2 65.4V67.8C73.2 68.1312 73.47 68.4 73.8 68.4H76.2C76.53 68.4 76.8 68.1312 76.8 67.8V65.4C76.8 65.0688 76.53 64.8 76.2 64.8H73.8Z" fill="#103744"/>
								<path d="M92.9999 69H90.5999C89.9375 69 89.3999 68.4624 89.3999 67.8V65.4C89.3999 64.7376 89.9375 64.2 90.5999 64.2H92.9999C93.6623 64.2 94.1999 64.7376 94.1999 65.4V67.8C94.1999 68.4624 93.6623 69 92.9999 69Z" fill="#00AC9C"/>
								<path d="M93 69.6H90.6C89.6076 69.6 88.8 68.7924 88.8 67.8V65.4C88.8 64.4076 89.6076 63.6 90.6 63.6H93C93.9924 63.6 94.8 64.4076 94.8 65.4V67.8C94.8 68.7924 93.9924 69.6 93 69.6ZM90.6 64.8C90.27 64.8 90 65.0688 90 65.4V67.8C90 68.1312 90.27 68.4 90.6 68.4H93C93.33 68.4 93.6 68.1312 93.6 67.8V65.4C93.6 65.0688 93.33 64.8 93 64.8H90.6Z" fill="#103744"/>
								<path d="M84.6 69H82.2C81.5376 69 81 68.4624 81 67.8V65.4C81 64.7376 81.5376 64.2 82.2 64.2H84.6C85.2624 64.2 85.8 64.7376 85.8 65.4V67.8C85.8 68.4624 85.2624 69 84.6 69Z" fill="#F37E98"/>
								<path d="M84.5999 69.6H82.1999C81.2075 69.6 80.3999 68.7924 80.3999 67.8V65.4C80.3999 64.4076 81.2075 63.6 82.1999 63.6H84.5999C85.5923 63.6 86.3999 64.4076 86.3999 65.4V67.8C86.3999 68.7924 85.5923 69.6 84.5999 69.6ZM82.1999 64.8C81.8699 64.8 81.5999 65.0688 81.5999 65.4V67.8C81.5999 68.1312 81.8699 68.4 82.1999 68.4H84.5999C84.9299 68.4 85.1999 68.1312 85.1999 67.8V65.4C85.1999 65.0688 84.9299 64.8 84.5999 64.8H82.1999Z" fill="#103744"/>
							</svg>
						</p>

						<p class="jsps-h2" role="heading" aria-level="2"><?php esc_html_e('Responsive Skins' , 'juiz-social-post-sharer') ?></p>

						<p>
							<?php printf( esc_html__( 'The list of default skins proposed is growing up and the existing ones have being rebuilt with the %sfresh new brand colors%s.', 'juiz-social-post-sharer' ), '<strong>', '</strong>' ); ?>
						</p>
					</div>
					<div class="jsps-col">
						<p class="jsps-icon">
							<svg width="120" height="120" viewBox="0 0 120 120" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M99.5999 58.6H20.4C19.7376 58.6 19.2 58.0624 19.2 57.4V51.4C19.2 50.7376 19.7376 50.2 20.4 50.2H99.5999C100.262 50.2 100.8 50.7376 100.8 51.4V57.4C100.8 58.0624 100.262 58.6 99.5999 58.6Z" fill="#E3E8ED"/>
								<path d="M99.6 59.8H20.4C19.0764 59.8 18 58.7236 18 57.4V51.4C18 50.0764 19.0764 49 20.4 49H99.6C100.924 49 102 50.0764 102 51.4V57.4C102 58.7236 100.924 59.8 99.6 59.8ZM20.4 51.4V57.4H99.6012L99.6 51.4H20.4Z" fill="#103744"/>
								<path d="M99.5999 94.6H20.4C19.7376 94.6 19.2 94.0624 19.2 93.4V87.4C19.2 86.7376 19.7376 86.2 20.4 86.2H99.5999C100.262 86.2 100.8 86.7376 100.8 87.4V93.4C100.8 94.0624 100.262 94.6 99.5999 94.6Z" fill="#E3E8ED"/>
								<path d="M99.6 95.8H20.4C19.0764 95.8 18 94.7236 18 93.4V87.4C18 86.0764 19.0764 85 20.4 85H99.6C100.924 85 102 86.0764 102 87.4V93.4C102 94.7236 100.924 95.8 99.6 95.8ZM20.4 87.4V93.4H99.6012L99.6 87.4H20.4Z" fill="#103744"/>
								<path d="M99.5999 76.6H20.4C19.7376 76.6 19.2 76.0624 19.2 75.4V69.4C19.2 68.7376 19.7376 68.2 20.4 68.2H99.5999C100.262 68.2 100.8 68.7376 100.8 69.4V75.4C100.8 76.0624 100.262 76.6 99.5999 76.6Z" fill="#FEF6AA"/>
								<path d="M99.6 77.8H20.4C19.0764 77.8 18 76.7236 18 75.4V69.4C18 68.0764 19.0764 67 20.4 67H99.6C100.924 67 102 68.0764 102 69.4V75.4C102 76.7236 100.924 77.8 99.6 77.8ZM20.4 69.4V75.4H99.6012L99.6 69.4H20.4Z" fill="#103744"/>
								<path d="M100.06 34.9569L21.9629 48.1262C21.3097 48.2363 20.6902 47.7956 20.58 47.1424L19.5823 41.226C19.4722 40.5728 19.9129 39.9533 20.5661 39.8431L98.6635 26.6738C99.3167 26.5637 99.9362 27.0044 100.046 27.6576L101.044 33.574C101.154 34.2272 100.713 34.8467 100.06 34.9569Z" fill="#FEF6AA"/>
								<path d="M100.26 36.1401L22.1624 49.3095C20.8572 49.5296 19.6168 48.6471 19.3967 47.342L18.3991 41.4255C18.179 40.1203 19.0614 38.8799 20.3666 38.6598L98.464 25.4905C99.7692 25.2704 101.01 26.1528 101.23 27.458L102.227 33.3745C102.447 34.6797 101.565 35.9201 100.26 36.1401ZM20.7657 41.0264L21.7633 46.9429L99.862 33.7734L98.8631 27.8571L20.7657 41.0264Z" fill="#103744"/>
								<path d="M55.0686 39.7503L59.2821 54.9831L59.4941 55.7495L62.6405 67.1247C59.9487 67.8416 51.7935 62.6731 48.4968 64.5924C46.8149 65.5714 45.3363 67.473 45.9543 69.2695C46.5464 70.9909 67.3474 79.5765 68.6704 82.6714L72.4077 96.1827L101.328 88.1832L97.7095 75.1026L97.5613 74.5667L97.2998 73.6212L90.7838 50.0643C90.1512 47.7772 87.7516 46.3931 85.4674 47.0362C83.2764 47.6535 81.7981 48.8433 82.3789 50.9432L81.6602 48.4447C81.1122 46.4637 79.0427 45.291 77.0616 45.8389C75.0806 46.3869 73.9079 48.4564 74.4559 50.4374L74.1357 49.2798C73.6197 47.4145 71.8744 46.0414 69.9494 46.2418C67.9706 46.4475 66.6279 48.0963 66.5395 49.9558L63.1864 37.8335C62.6269 35.8107 60.514 34.6128 58.4905 35.1725L57.6815 35.3963C57.6815 35.3963 54.0352 36.4049 55.0686 39.7503Z" fill="white"/>
								<path d="M101.55 88.9866L72.6299 96.986C72.1865 97.1086 71.7273 96.8491 71.6044 96.4048L67.8846 82.9571C67.1326 81.4545 59.548 77.645 54.5126 75.1169C47.3379 71.514 45.4896 70.4816 45.1661 69.5402C44.3837 67.2651 46.1269 65.0067 48.0777 63.8712C50.311 62.572 53.8837 63.8392 57.3379 65.0656C58.8234 65.593 60.4594 66.1739 61.5551 66.324L54.2692 39.9835C53.9135 38.8228 53.9907 37.7637 54.4992 36.8352C55.4062 35.1773 57.3773 34.6156 57.4609 34.5925L58.2698 34.3687C60.7409 33.6852 63.3076 35.139 63.9911 37.61L66.6549 47.2404C67.4053 46.2329 68.5444 45.5486 69.8643 45.4118C71.4692 45.2455 73.0377 45.992 74.0387 47.2692C74.6102 46.2117 75.594 45.3792 76.8408 45.0343C79.1263 44.4022 81.4939 45.6299 82.326 47.8004C82.9073 47.1882 83.8267 46.6321 85.242 46.2337C85.25 46.2315 85.258 46.2293 85.2661 46.227C86.5667 45.8673 87.9381 46.0388 89.1307 46.7112C90.3467 47.3962 91.2188 48.5075 91.5877 49.8411L102.132 87.96C102.254 88.4045 101.993 88.8639 101.55 88.9866ZM72.9888 95.1571L100.302 87.6021L89.9804 50.2865C89.7307 49.3835 89.1382 48.6299 88.3125 48.1647C87.5063 47.7106 86.5823 47.5934 85.7099 47.8347C85.7051 47.8361 85.6995 47.8376 85.6938 47.8392C82.6243 48.7038 83.0298 50.1699 83.1823 50.721C83.3047 51.1636 83.0463 51.6208 82.6051 51.7454C82.6043 51.7456 82.6027 51.7461 82.6011 51.7465C82.1609 51.8683 81.7046 51.6131 81.5778 51.1734L80.859 48.6749C80.43 47.1237 78.827 46.2154 77.2838 46.6422C75.7406 47.0691 74.8323 48.672 75.2592 50.2152C75.3821 50.6595 75.1215 51.1181 74.6781 51.2408C74.2346 51.3634 73.7754 51.1039 73.6525 50.6596L73.3323 49.502C72.9073 47.9653 71.4898 46.9209 70.0354 47.0716C68.5613 47.2199 67.4449 48.4549 67.372 49.9953C67.3528 50.4045 67.0405 50.7417 66.6321 50.7846C66.2254 50.8305 65.8455 50.5732 65.7364 50.1788L62.3828 38.0549C61.9444 36.4699 60.2984 35.5372 58.7127 35.9759L57.9037 36.1996C57.8933 36.2025 56.5181 36.6054 55.9559 37.643C55.6703 38.1708 55.6406 38.7792 55.8647 39.505C55.8669 39.5131 55.8692 39.5211 55.8712 39.5283L63.4428 66.9019C63.5022 67.1164 63.4737 67.3448 63.363 67.5388C63.2522 67.7321 63.0492 67.8643 62.8545 67.9294C61.4633 68.2995 59.293 67.5283 56.7797 66.6366C53.9738 65.6407 50.4847 64.4006 48.9161 65.311C47.5145 66.1276 46.3261 67.6247 46.7218 68.9335C47.331 69.6445 51.7228 71.8499 55.2617 73.6263C63.2993 77.6633 68.6287 80.4509 69.4371 82.3417C69.4517 82.3757 69.4641 82.4112 69.4741 82.4474L72.9896 95.1569L72.9888 95.1571Z" fill="#103744"/>
								<path d="M96.666 74.3378L100.35 87.6547L72.8876 95.2508L69.2041 81.9339L96.666 74.3378Z" fill="#20A0C9"/>
								<path d="M100.863 87.9461L72.5981 95.7642L68.6924 81.644L96.9576 73.8257L100.863 87.9458L100.863 87.9461ZM73.1792 94.7386L99.8378 87.3647L96.3765 74.8512L69.7179 82.2251L73.1792 94.7386Z" fill="#103744"/>
								<path d="M90.7218 76.4153L69.0318 82.4149C68.8101 82.4762 68.5804 82.346 68.5191 82.1243C68.4577 81.9026 68.5879 81.6729 68.8096 81.6115L90.4996 75.612C90.7213 75.5506 90.9511 75.6808 91.0124 75.9025C91.0737 76.1243 90.9435 76.354 90.7218 76.4153ZM72.5186 76.2616C72.2969 76.323 72.0672 76.1928 72.0058 75.9711L67.5617 59.9044C67.5004 59.6827 67.6306 59.453 67.8523 59.3917C68.074 59.3303 68.3037 59.4605 68.365 59.6822L72.8092 75.7489C72.8705 75.9706 72.7403 76.2003 72.5186 76.2616ZM79.4409 70.0229C79.2192 70.0842 78.9895 69.9541 78.9281 69.7324L75.595 57.6824C75.5337 57.4606 75.6639 57.2309 75.8856 57.1696C76.1073 57.1083 76.337 57.2384 76.3984 57.4602L79.7315 69.5102C79.7928 69.7319 79.6626 69.9616 79.4409 70.0229ZM86.3632 63.7842C86.1415 63.8455 85.9118 63.7154 85.8504 63.4936L83.6284 55.4603C83.567 55.2386 83.6972 55.0089 83.9189 54.9475C84.1407 54.8862 84.3704 55.0164 84.4317 55.2381L86.6538 63.2714C86.7151 63.4931 86.5849 63.7229 86.3632 63.7842ZM93.4331 75.6654L91.8264 76.1098C91.6047 76.1711 91.375 76.0409 91.3136 75.8192C91.2523 75.5975 91.3825 75.3678 91.6042 75.3064L93.2109 74.862C93.4326 74.8007 93.6623 74.9309 93.7236 75.1526C93.785 75.3743 93.6548 75.604 93.4331 75.6654ZM94.7385 75.3043C94.6823 75.3198 94.6318 75.3251 94.577 75.3144C94.5241 75.3108 94.467 75.292 94.424 75.2615C94.3237 75.2115 94.2546 75.1181 94.2257 75.0137C94.1968 74.9093 94.2081 74.7937 94.2682 74.6984C94.3708 74.5066 94.6359 74.4333 94.8306 74.5429C94.9311 74.5938 95.0002 74.6871 95.0291 74.7915C95.0579 74.8959 95.0467 75.0115 94.9863 75.106C94.9354 75.2066 94.8502 75.2734 94.7385 75.3043ZM80.2464 72.935C80.0247 72.9963 79.795 72.8662 79.7336 72.6444L79.2892 71.0378C79.2279 70.816 79.3581 70.5863 79.5798 70.525C79.8015 70.4637 80.0312 70.5938 80.0926 70.8156L80.537 72.4222C80.5983 72.6439 80.4681 72.8737 80.2464 72.935ZM80.7741 74.8429C80.5524 74.9042 80.3227 74.7741 80.2614 74.5524L80.0392 73.749C79.9778 73.5273 80.108 73.2976 80.3297 73.2362C80.5514 73.1749 80.7812 73.3051 80.8425 73.5268L81.0647 74.3301C81.126 74.5519 80.9959 74.7816 80.7741 74.8429Z" fill="#103744"/>
								<path d="M93.149 80.5003C92.6163 80.6477 92.164 81.0006 91.8916 81.4814C91.6191 81.9622 91.5488 82.5315 91.6961 83.0642C91.8435 83.5968 92.1964 84.0491 92.6772 84.3216C93.158 84.594 93.7273 84.6643 94.26 84.517C94.7926 84.3697 95.2449 84.0168 95.5174 83.536C95.7898 83.0551 95.8601 82.4858 95.7128 81.9531C95.5655 81.4205 95.2126 80.9682 94.7318 80.6958C94.251 80.4233 93.6816 80.353 93.149 80.5003V80.5003Z" fill="#0073AA"/>
								<path d="M94.3709 84.9186C93.0422 85.2862 91.6618 84.504 91.2943 83.1753C90.9268 81.8466 91.709 80.4662 93.0377 80.0986C94.3664 79.7311 95.7468 80.5133 96.1143 81.842C96.4818 83.1707 95.6996 84.5511 94.3709 84.9186ZM93.2599 80.902C92.3738 81.1471 91.8526 82.067 92.0977 82.9531C92.3427 83.8391 93.2627 84.3604 94.1487 84.1153C95.0348 83.8702 95.5561 82.9503 95.311 82.0642C95.0659 81.1782 94.146 80.6569 93.2599 80.902ZM57.6649 31.9416C57.4432 32.0029 57.2135 31.8728 57.1521 31.651L55.3005 24.9569C55.2392 24.7352 55.3693 24.5054 55.5911 24.4441C55.8128 24.3828 56.0425 24.513 56.1038 24.7347L57.9555 31.4288C58.0168 31.6506 57.8866 31.8803 57.6649 31.9416ZM73.2792 34.541L67.0533 36.2631C66.8316 36.3244 66.6019 36.1942 66.5406 35.9725C66.4792 35.7508 66.6094 35.5211 66.8311 35.4598L73.0569 33.7377C73.2787 33.6763 73.5084 33.8065 73.5697 34.0282C73.631 34.2499 73.5009 34.4797 73.2792 34.541ZM51.0076 40.7014L44.7817 42.4235C44.56 42.4849 44.3303 42.3547 44.269 42.133C44.2076 41.9113 44.3378 41.6815 44.5595 41.6202L50.7854 39.8981C51.0071 39.8368 51.2368 39.9669 51.2981 40.1887C51.3594 40.4104 51.2293 40.6401 51.0076 40.7014ZM62.9915 32.8309C62.8855 32.8602 62.7679 32.8477 62.6663 32.7868C62.4692 32.6683 62.4044 32.4121 62.5237 32.2148L65.6301 27.0316C65.749 26.8361 66.0038 26.7691 66.2021 26.8889C66.3992 27.0074 66.464 27.2636 66.3447 27.4609L63.2383 32.6441C63.1806 32.7388 63.0912 32.8033 62.9915 32.8309ZM52.1819 35.8209C52.0823 35.8484 51.9725 35.839 51.8741 35.7867L46.5456 32.9366C46.3427 32.8284 46.2658 32.5755 46.374 32.3726C46.4838 32.1693 46.7363 32.0943 46.938 32.2011L52.2665 35.0511C52.4694 35.1593 52.5462 35.4122 52.438 35.6151C52.3824 35.7204 52.2879 35.7915 52.1819 35.8209Z" fill="#103744"/>
							</svg>
						</p>

						<p class="jsps-h2" role="heading" aria-level="2"><?php esc_html_e('Drag &amp; Drop Buttons' , 'juiz-social-post-sharer') ?></p>

						<p>
							<?php printf( esc_html__( 'You can now re-order your buttons by simply drag and drop those in the %ssettings page%s. %sClick on it to activate, drag to order%s!', 'juiz-social-post-sharer'), '<a href="' . jsps_get_settings_url() . '">', '</a>', '<strong>', '</strong>' ); ?>
						</p>
					</div>
					<div class="jsps-col">
						<p class="jsps-icon">
							<svg width="120" height="120" viewBox="0 0 120 120" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M60.0001 81.0504C71.0257 81.0504 80.9737 85.638 88.0597 93.0012C94.8001 85.9992 98.9521 76.4868 98.9521 66C98.9521 44.4876 81.5137 27.0492 60.0013 27.0492C38.4889 27.0492 21.0493 44.4888 21.0493 66C21.0493 76.4868 25.2013 85.998 31.9417 93.0012C39.0277 85.6392 48.9745 81.0504 60.0001 81.0504Z" fill="#20A0C9"/>
								<path d="M88.0595 94.2012C87.7343 94.2012 87.4211 94.068 87.1943 93.8328C80.0051 86.364 70.3475 82.2504 59.9999 82.2504C49.6523 82.2504 39.9947 86.364 32.8055 93.8328C32.5799 94.068 32.2667 94.2012 31.9403 94.2012C31.6151 94.2012 31.3019 94.068 31.0751 93.8328C23.8355 86.3112 19.8491 76.4256 19.8491 66C19.8491 43.86 37.8611 25.8492 59.9999 25.8492C82.1387 25.8492 100.151 43.8612 100.151 66C100.151 76.4256 96.1643 86.31 88.9247 93.8328C88.6979 94.068 88.3847 94.2012 88.0595 94.2012ZM59.9999 79.8504C70.5827 79.8504 80.4887 83.8968 88.0319 91.2696C94.3079 84.318 97.7507 75.3924 97.7507 66C97.7507 45.1836 80.8163 28.2492 59.9999 28.2492C39.1835 28.2492 22.2491 45.1848 22.2491 66C22.2491 75.3924 25.6907 84.318 31.9679 91.2696C39.5111 83.8968 49.4171 79.8504 59.9999 79.8504Z" fill="#103744"/>
								<path d="M66.4585 66.1368H93.1501C92.6689 47.5032 78.0169 32.5488 60.0001 32.5488C41.9833 32.5488 27.3313 47.5032 26.8501 66.1368H50.8585" fill="#FEF6AA"/>
								<path d="M93.1499 66.738L66.4763 66.588C66.1451 66.588 65.8571 66.4704 65.8571 66.138C65.8571 65.8056 66.1259 65.538 66.4571 65.538H92.5283C91.7543 47.3256 77.5775 33.1488 59.9999 33.1488C42.4223 33.1488 28.2443 47.3244 27.4715 65.5368H50.8583C51.1895 65.5368 51.4583 65.8056 51.4583 66.1368C51.4583 66.468 51.2459 66.5868 50.9147 66.5868L26.8499 66.7368C26.6879 66.7368 26.5331 66.6708 26.4203 66.5556C26.3075 66.4392 26.2463 66.2832 26.2499 66.1212C26.7443 46.9596 41.5691 31.9488 59.9999 31.9488C78.4295 31.9488 93.2543 46.9596 93.7499 66.1224C93.7535 66.2844 93.6923 66.4404 93.5795 66.5568C93.4667 66.672 93.3119 66.738 93.1499 66.738Z" fill="#103744"/>
								<path d="M60.8892 74.0904C58.3536 75.0036 56.3004 73.0128 56.2812 71.6244L51.8004 42.4296C51.5328 41.1576 52.1868 39.9336 53.2548 39.708C54.3228 39.4836 55.4148 40.3404 55.6824 41.6124L63.3528 70.1352C63.6216 71.406 63.1368 73.5132 60.8892 74.0904Z" fill="#F37E98"/>
								<path d="M59.6076 74.9136C58.7736 74.9136 57.9588 74.664 57.2544 74.1768C56.3148 73.5252 55.698 72.5268 55.686 71.6316L51.2112 42.5196C51.0588 41.7996 51.1596 41.034 51.5004 40.3944C51.8604 39.7212 52.4388 39.27 53.13 39.1248C54.5244 38.8356 55.9272 39.8928 56.2632 41.4876L63.9276 69.9792C64.2348 71.4408 63.7188 73.9608 61.062 74.6592C60.5832 74.8296 60.0912 74.9136 59.6076 74.9136ZM53.5944 40.2684C53.5212 40.2684 53.4492 40.2756 53.376 40.2912C53.0352 40.3632 52.7424 40.5996 52.5504 40.9572C52.3404 41.3496 52.2804 41.8296 52.3812 42.3072L56.868 71.5332C56.8812 72.03 57.2136 72.7008 57.9312 73.1988C58.3992 73.524 59.382 73.9992 60.6864 73.53C60.7044 73.524 60.7212 73.518 60.7404 73.5132C62.616 73.032 62.9808 71.2596 62.7696 70.2564L55.1052 41.766C54.9228 40.8924 54.2628 40.2684 53.5944 40.2684ZM60.4584 36.738C60.1272 36.738 59.8584 36.4692 59.8584 36.138V34.938C59.8584 34.6068 60.1272 34.338 60.4584 34.338C60.7896 34.338 61.0584 34.6068 61.0584 34.938V36.138C61.0584 36.4692 60.7896 36.738 60.4584 36.738ZM89.2584 63.138H88.0584C87.7272 63.138 87.4584 62.8692 87.4584 62.538C87.4584 62.2068 87.7272 61.938 88.0584 61.938H89.2584C89.5896 61.938 89.8584 62.2068 89.8584 62.538C89.8584 62.8692 89.5896 63.138 89.2584 63.138ZM31.6584 63.138H30.4584C30.1272 63.138 29.8584 62.8692 29.8584 62.538C29.8584 62.2068 30.1272 61.938 30.4584 61.938H31.6584C31.9896 61.938 32.2584 62.2068 32.2584 62.538C32.2584 62.8692 31.9896 63.138 31.6584 63.138Z" fill="#103744"/>
								<path d="M78.5484 44.5176L76.9956 45.8496Z" fill="#20A0C9"/>
								<path d="M76.9955 46.4496C76.8263 46.4496 76.6595 46.3788 76.5407 46.2408C76.3235 45.99 76.3535 45.6108 76.6043 45.3948L78.1571 44.0616C78.4103 43.8468 78.7883 43.8744 79.0031 44.1264C79.2203 44.3772 79.1903 44.7564 78.9395 44.9724L77.3867 46.3056C77.2739 46.4028 77.1335 46.4496 76.9955 46.4496Z" fill="#103744"/>
								<path d="M41.1709 44.55L42.4645 45.8436Z" fill="#20A0C9"/>
								<path d="M42.4645 46.4436C42.3109 46.4436 42.1573 46.3848 42.0397 46.2684L40.7461 44.9748C40.5121 44.7408 40.5121 44.3604 40.7461 44.1264C40.9801 43.8924 41.3605 43.8924 41.5945 44.1264L42.8881 45.42C43.1221 45.654 43.1221 46.0344 42.8881 46.2684C42.7717 46.3848 42.6181 46.4436 42.4645 46.4436Z" fill="#103744"/>
							</svg>
						</p>

						<p class="jsps-h2" role="heading" aria-level="2"><?php esc_html_e('Performant' , 'juiz-social-post-sharer') ?></p>

						<p>
							<?php printf( esc_html__( '%sNobs%s get rid of all those JavaScript loading and making your page slow. It helps %simprove accessibility and SEO%s.', 'juiz-social-post-sharer'), '<strong>', '</strong>', '<strong>', '</strong>' ); ?>
						</p>
					</div>

					<div class="jsps-col">
						<p class="jsps-icon">
							<svg width="120" height="120" viewBox="0 0 120 120" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M91.4113 94.392H30.8377C27.7573 94.392 25.2373 91.872 25.2373 88.7916V53.0172C25.2373 49.9368 27.7573 47.4168 30.8377 47.4168H91.4125C94.4929 47.4168 97.0129 49.9368 97.0129 53.0172V88.7916C97.0117 91.872 94.4917 94.392 91.4113 94.392ZM51.0589 68.2764L26.4745 50.8476L51.0589 68.2764ZM94.6417 50.8476L69.2089 68.2044L94.6417 50.8476Z" fill="#FEF6AA"/>
								<path d="M35.4187 33.0532C35.4187 29.1872 38.5527 26.0532 42.4187 26.0532H71.2167L85.6187 40.6783V53.0251V57.137L66.6277 69.8263L60.6344 66.2112C60.3092 66.0332 59.9945 66.0332 59.6831 66.2112L54.0703 69.8263L35.4187 56.7655V53.0251V33.0532Z" fill="#E3E8ED"/>
								<path d="M86.0737 41.4552H76.5673C72.4645 41.4552 69.1069 38.5248 69.1069 34.944V26.6472L69.3745 26.0532H70.9117L86.0737 41.4552Z" fill="#CEEEF9"/>
								<path d="M66.8579 46.1713V56.1541L69.3971 58.0021H78.4667V46.1713H66.8579Z" fill="#20A0C9"/>
								<path d="M91.5239 45.5532H86.3243V40.7256C86.3243 40.566 86.2607 40.4136 86.1491 40.3008L71.1767 25.3284C71.0639 25.2156 70.9115 25.1532 70.7519 25.1532H42.5399C38.2307 25.1532 34.7243 28.3188 34.7243 32.2104V45.5532H30.7247C26.9747 45.5532 23.9243 48.6036 23.9243 52.3536V87.9528C23.9243 91.7028 26.9747 94.7532 30.7247 94.7532H91.5239C95.2739 94.7532 98.3243 91.7028 98.3243 87.9528V52.3536C98.3243 48.6036 95.2739 45.5532 91.5239 45.5532ZM84.9035 40.7532H76.5611C72.6815 40.7532 69.5243 38.0316 69.5243 34.6872V26.3532H70.5035L84.9035 40.7532ZM30.7247 47.9532H34.7243V52.1532C34.7243 52.4844 34.9931 52.7532 35.3243 52.7532C35.6555 52.7532 35.9243 52.4844 35.9243 52.1532V32.2092C35.9243 28.98 38.8919 26.352 42.5399 26.352H68.3243V34.686C68.3243 38.6928 72.0191 41.952 76.5611 41.952H85.1243V53.352C85.1243 53.6832 85.3931 53.952 85.7243 53.952C86.0555 53.952 86.3243 53.6832 86.3243 53.352V47.952H91.5239C92.9291 47.952 94.1687 48.6264 94.9751 49.6548L69.1391 67.3368C68.8607 67.5276 68.7887 67.9104 68.9783 68.1912C69.0971 68.3652 69.2891 68.4588 69.4847 68.4588C69.6047 68.4588 69.7235 68.424 69.8303 68.352L95.6003 50.7156C95.8043 51.2232 95.9231 51.774 95.9231 52.3536V87.9528C95.9231 88.1148 95.8919 88.2696 95.8751 88.428L61.7027 66.2472C60.7067 65.6028 59.3831 65.6244 58.4111 66.3048L26.4071 88.7712C26.3567 88.5048 26.3243 88.2336 26.3243 87.9528V52.3536C26.3243 51.912 26.4095 51.4944 26.5307 51.0924L50.9747 68.4216C51.0803 68.496 51.2003 68.532 51.3215 68.532C51.5087 68.532 51.6947 68.4444 51.8111 68.2788C52.0019 68.0076 51.9383 67.6344 51.6683 67.4424L27.0839 50.0124C27.0659 50.0004 27.0455 49.998 27.0263 49.9872C27.8087 48.768 29.1695 47.9532 30.7247 47.9532ZM91.5239 92.3532H30.7247C29.0183 92.3532 27.5531 91.368 26.8235 89.9448L59.0999 67.2864C59.6639 66.8928 60.4667 66.876 61.0487 67.254L95.5787 89.664C94.9091 91.242 93.3443 92.3532 91.5239 92.3532Z" fill="#103744"/>
								<path d="M42.5243 56.3532H62.9243C63.2555 56.3532 63.5243 56.0844 63.5243 55.7532C63.5243 55.422 63.2555 55.1532 62.9243 55.1532H42.5243C42.1931 55.1532 41.9243 55.422 41.9243 55.7532C41.9243 56.0844 42.1931 56.3532 42.5243 56.3532ZM42.5243 51.5532H62.9243C63.2555 51.5532 63.5243 51.2844 63.5243 50.9532C63.5243 50.622 63.2555 50.3532 62.9243 50.3532H42.5243C42.1931 50.3532 41.9243 50.622 41.9243 50.9532C41.9243 51.2844 42.1931 51.5532 42.5243 51.5532ZM66.5243 56.3532C66.8555 56.3532 67.1243 56.0844 67.1243 55.7532V46.7532H77.9243V57.5532H68.9243C68.5931 57.5532 68.3243 57.822 68.3243 58.1532C68.3243 58.4844 68.5931 58.7532 68.9243 58.7532H78.5243C78.8555 58.7532 79.1243 58.4844 79.1243 58.1532V46.1532C79.1243 45.822 78.8555 45.5532 78.5243 45.5532H66.5243C66.1931 45.5532 65.9243 45.822 65.9243 46.1532V55.7532C65.9243 56.0844 66.1931 56.3532 66.5243 56.3532ZM42.5243 46.7532H62.9243C63.2555 46.7532 63.5243 46.4844 63.5243 46.1532C63.5243 45.822 63.2555 45.5532 62.9243 45.5532H42.5243C42.1931 45.5532 41.9243 45.822 41.9243 46.1532C41.9243 46.4844 42.1931 46.7532 42.5243 46.7532Z" fill="#103744"/>
							</svg>
						</p>

						<p class="jsps-h2" role="heading" aria-level="2"><?php esc_html_e('New Contact Modal' , 'juiz-social-post-sharer') ?></p>

						<p>
							<?php printf( esc_html__( 'When users want to share the blog post via email, they get a new pop-in that give the ability %sto share to multiple friends!%s', 'juiz-social-post-sharer'), '<strong>', '</strong>' ); ?>
						</p>
					</div>
					<div class="jsps-col">
						<p class="jsps-icon">
							<svg width="120" height="120" viewBox="0 0 120 120" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M60.6 91.2C55.4268 91.2 54.0852 87.354 54.03 87.1896C53.9256 86.8752 54.096 86.5356 54.4092 86.43C54.7248 86.3256 55.062 86.4948 55.1676 86.8068C55.2132 86.9376 56.3172 90 60.6 90C64.9176 90 66.0204 86.8416 66.03 86.8104C66.1368 86.496 66.4764 86.3268 66.7896 86.4312C67.104 86.5368 67.2732 86.8764 67.1688 87.1908C67.1148 87.354 65.7732 91.2 60.6 91.2Z" fill="#103744"/>
								<path d="M20.4 30H18C15.3492 30 13.2 32.1492 13.2 34.8V87.6C13.2 90.2508 15.3492 92.4 18 92.4H54C54 92.4 55.2 96 60.6 96C66 96 67.2 92.4 67.2 92.4H103.2C105.851 92.4 108 90.2508 108 87.6V34.8C108 32.1492 105.851 30 103.2 30H100.8H20.4Z" fill="#20A0C9"/>
								<path d="M102.6 33V87H18.6001V33L24.6001 23.4C51.0001 23.4 60.6001 30.6 60.6001 30.6C60.6001 30.6 70.2001 23.4 96.6001 23.4L102.6 33Z" fill="#CEEEF9"/>
								<path d="M18.6001 87H60.6001C60.6001 87 51.0001 79.8 24.6001 79.8L18.6001 87Z" fill="#CEEEF9"/>
								<path d="M24.6001 23.4C51.0001 23.4 60.6001 30.6 60.6001 30.6C60.6001 30.6 70.2001 23.4 96.6001 23.4V79.8C70.2001 79.8 60.6001 87 60.6001 87C60.6001 87 51.0001 79.8 24.6001 79.8V23.4Z" fill="white"/>
								<path d="M102.6 87.6H60.6001C60.3421 87.6 60.1129 87.4344 60.0301 87.1896C59.9497 86.9448 60.0325 86.6748 60.2401 86.5188C60.6385 86.22 70.3021 79.1988 96.6001 79.1988C96.7777 79.1988 96.9469 79.2768 97.0609 79.4148L103.061 86.6148C103.211 86.7936 103.242 87.042 103.144 87.2532C103.044 87.4656 102.833 87.6 102.6 87.6Z" fill="#CEEEF9"/>
								<path d="M24.1388 79.4233L18.1333 86.6183L19.0546 87.3872L25.0601 80.1922L24.1388 79.4233Z" fill="#103744"/>
								<path d="M103.2 28.8H99.9744L101.474 31.2H103.2C105.185 31.2 106.8 32.8152 106.8 34.8V87.6C106.8 89.5848 105.185 91.2 103.2 91.2H67.2C66.6948 91.2 66.2388 91.5312 66.0672 92.0064C66.0252 92.1204 64.9992 94.8 60.6 94.8C56.2008 94.8 55.1748 92.1204 55.1376 92.0208C54.9756 91.53 54.5172 91.2 54 91.2H18C16.0152 91.2 14.4 89.5848 14.4 87.6V34.8C14.4 32.8152 16.0152 31.2 18 31.2H19.7244L21.2244 28.8H18C14.6916 28.8 12 31.4916 12 34.8V87.6C12 90.9084 14.6916 93.6 18 93.6H53.2572C54.0144 94.8804 56.0196 97.2 60.6 97.2C65.1804 97.2 67.1856 94.8804 67.9428 93.6H103.2C106.508 93.6 109.2 90.9084 109.2 87.6V34.8C109.2 31.4916 106.508 28.8 103.2 28.8Z" fill="#103744"/>
								<path d="M60.5988 87.6C60.474 87.6 60.348 87.5616 60.2412 87.48C60.1452 87.4104 50.4288 80.4 24.6 80.4C24.2688 80.4 24 80.1312 24 79.8V23.4C24 23.0688 24.2688 22.8 24.6 22.8C48.4416 22.8 58.6116 28.572 60.6 29.8716C62.5884 28.572 72.7584 22.8 96.6 22.8C96.9312 22.8 97.2 23.0688 97.2 23.4V79.8C97.2 80.1312 96.9312 80.4 96.6 80.4C83.0436 80.4 74.0484 82.3428 68.8884 83.9724C68.5752 84.0744 68.2356 83.8968 68.136 83.5812C68.0364 83.2656 68.2116 82.9284 68.5272 82.8288C73.6908 81.198 82.6236 79.2576 96 79.2024V24.0024C70.6188 24.108 61.0536 31.0104 60.9588 31.08C60.7476 31.2396 60.4524 31.2396 60.2412 31.08C60.1464 31.0092 50.5812 24.1068 25.2 24.0012V79.2012C51.0456 79.3068 60.5652 86.2236 60.96 86.52C61.2252 86.7192 61.2792 87.0948 61.0812 87.3588C60.9624 87.5172 60.7812 87.6 60.5988 87.6Z" fill="#103744"/>
								<path d="M102.6 87.6H18.6C18.2688 87.6 18 87.3312 18 87V33C18 32.8872 18.0312 32.7768 18.0912 32.682L24.0912 23.082L25.1088 23.7168L19.2 33.1728V86.4H102V33.1728L96.0912 23.718L97.1088 23.0832L103.109 32.6832C103.169 32.7768 103.2 32.8872 103.2 33V87C103.2 87.3312 102.931 87.6 102.6 87.6Z" fill="#103744"/>
								<path d="M97.0591 79.4128L96.1372 80.181L102.137 87.3806L103.059 86.6124L97.0591 79.4128Z" fill="#103744"/>
								<path d="M51.3083 34.3308C51.2519 34.3308 51.1943 34.3224 51.1367 34.3056C49.9895 33.9648 48.7896 33.6444 47.568 33.3528C47.2452 33.276 47.0472 32.952 47.124 32.6292C47.2008 32.3064 47.5284 32.1108 47.8476 32.1852C49.0896 32.4816 50.3111 32.808 51.4787 33.1548C51.7967 33.2496 51.9779 33.5832 51.8831 33.9012C51.8063 34.1616 51.5675 34.3308 51.3083 34.3308Z" fill="#103744"/>
								<path d="M54.9083 35.5188C54.8399 35.5188 54.7703 35.5068 54.7019 35.4828C54.3275 35.346 53.9267 35.2056 53.5139 35.064C53.2007 34.9572 53.0339 34.6152 53.1407 34.302C53.2475 33.9888 53.5907 33.8232 53.9027 33.9288C54.3251 34.074 54.7319 34.2156 55.1147 34.3548C55.4255 34.4688 55.5863 34.8132 55.4723 35.1252C55.3835 35.3688 55.1531 35.5188 54.9083 35.5188Z" fill="#103744"/>
								<path d="M44.1096 32.6052C44.0736 32.6052 44.0352 32.6016 43.9992 32.5944C40.2624 31.896 36.252 31.4256 32.076 31.2C31.7448 31.182 31.4916 30.8988 31.5084 30.5688C31.5264 30.2376 31.824 29.9604 32.1396 30.0024C36.3672 30.2316 40.4316 30.7068 44.2176 31.416C44.5428 31.4772 44.7588 31.7904 44.6976 32.1156C44.6448 32.4036 44.3928 32.6052 44.1096 32.6052Z" fill="#103744"/>
								<path d="M51.3083 42.7308C51.2519 42.7308 51.1943 42.7224 51.1367 42.7056C49.9895 42.3648 48.7896 42.0444 47.568 41.7528C47.2452 41.676 47.0472 41.352 47.124 41.0292C47.2008 40.7064 47.5284 40.512 47.8476 40.5852C49.0896 40.8816 50.3111 41.208 51.4787 41.5548C51.7967 41.6496 51.9779 41.9832 51.8831 42.3012C51.8063 42.5616 51.5675 42.7308 51.3083 42.7308Z" fill="#103744"/>
								<path d="M54.9083 43.9188C54.8399 43.9188 54.7703 43.9068 54.7019 43.8828C54.3275 43.746 53.9267 43.6056 53.5139 43.464C53.2007 43.3572 53.0339 43.0152 53.1407 42.702C53.2475 42.3888 53.5907 42.2232 53.9027 42.3288C54.3251 42.474 54.7319 42.6156 55.1147 42.7548C55.4255 42.8688 55.5863 43.2132 55.4723 43.5252C55.3835 43.7688 55.1531 43.9188 54.9083 43.9188Z" fill="#103744"/>
								<path d="M44.1096 41.0052C44.0736 41.0052 44.0352 41.0016 43.9992 40.9944C40.2624 40.296 36.252 39.8256 32.076 39.6C31.7448 39.582 31.4916 39.2988 31.5084 38.9688C31.5264 38.6376 31.824 38.3724 32.1396 38.4024C36.3672 38.6316 40.4316 39.1068 44.2176 39.816C44.5428 39.8772 44.7588 40.1904 44.6976 40.5156C44.6448 40.8036 44.3928 41.0052 44.1096 41.0052Z" fill="#103744"/>
								<path d="M51.3083 51.1308C51.2519 51.1308 51.1943 51.1224 51.1367 51.1056C49.9895 50.7648 48.7896 50.4444 47.568 50.1528C47.2452 50.076 47.0472 49.752 47.124 49.4292C47.2008 49.1076 47.5284 48.9096 47.8476 48.9852C49.0896 49.2816 50.3111 49.608 51.4787 49.9548C51.7967 50.0496 51.9779 50.3832 51.8831 50.7012C51.8063 50.9616 51.5675 51.1308 51.3083 51.1308Z" fill="#103744"/>
								<path d="M54.9083 52.3188C54.8399 52.3188 54.7703 52.3068 54.7019 52.2828C54.3275 52.146 53.9267 52.0056 53.5139 51.864C53.2007 51.7572 53.0339 51.4152 53.1407 51.102C53.2475 50.7888 53.5907 50.6232 53.9027 50.7288C54.3251 50.874 54.7319 51.0156 55.1147 51.1548C55.4255 51.2688 55.5863 51.6132 55.4723 51.9252C55.3835 52.1688 55.1531 52.3188 54.9083 52.3188Z" fill="#103744"/>
								<path d="M44.1096 49.4052C44.0736 49.4052 44.0352 49.4016 43.9992 49.3944C40.2624 48.696 36.252 48.2256 32.076 48C31.7448 47.982 31.4916 47.6988 31.5084 47.3688C31.5264 47.0376 31.824 46.7688 32.1396 46.8024C36.3672 47.0316 40.4316 47.5068 44.2176 48.216C44.5428 48.2772 44.7588 48.5904 44.6976 48.9156C44.6448 49.2036 44.3928 49.4052 44.1096 49.4052Z" fill="#103744"/>
								<path d="M51.3083 59.5308C51.2519 59.5308 51.1943 59.5224 51.1367 59.5056C49.9895 59.1648 48.7896 58.8444 47.568 58.5528C47.2452 58.476 47.0472 58.152 47.124 57.8292C47.2008 57.5064 47.5284 57.312 47.8476 57.3852C49.0896 57.6816 50.3111 58.008 51.4787 58.3548C51.7967 58.4496 51.9779 58.7832 51.8831 59.1012C51.8063 59.3616 51.5675 59.5308 51.3083 59.5308Z" fill="#103744"/>
								<path d="M54.9083 60.7188C54.8399 60.7188 54.7703 60.7068 54.7019 60.6828C54.3275 60.546 53.9267 60.4056 53.5139 60.264C53.2007 60.1572 53.0339 59.8152 53.1407 59.502C53.2475 59.1888 53.5907 59.022 53.9027 59.1288C54.3251 59.274 54.7319 59.4156 55.1147 59.5548C55.4255 59.6688 55.5863 60.0132 55.4723 60.3252C55.3835 60.5688 55.1531 60.7188 54.9083 60.7188Z" fill="#103744"/>
								<path d="M44.1096 57.8052C44.0736 57.8052 44.0352 57.8016 43.9992 57.7944C40.2624 57.096 36.252 56.6256 32.076 56.4C31.7448 56.382 31.4916 56.0988 31.5084 55.7688C31.5264 55.4376 31.824 55.164 32.1396 55.2024C36.3672 55.4316 40.4316 55.9068 44.2176 56.616C44.5428 56.6772 44.7588 56.9904 44.6976 57.3156C44.6448 57.6036 44.3928 57.8052 44.1096 57.8052Z" fill="#103744"/>
								<path d="M51.3083 67.9308C51.2519 67.9308 51.1943 67.9224 51.1367 67.9056C49.9895 67.5648 48.7896 67.2444 47.568 66.9528C47.2452 66.876 47.0472 66.552 47.124 66.2292C47.2008 65.9076 47.5284 65.7096 47.8476 65.7852C49.0896 66.0816 50.3111 66.408 51.4787 66.7548C51.7967 66.8496 51.9779 67.1832 51.8831 67.5012C51.8063 67.7616 51.5675 67.9308 51.3083 67.9308Z" fill="#103744"/>
								<path d="M54.9083 69.1188C54.8399 69.1188 54.7703 69.1068 54.7019 69.0828C54.3275 68.946 53.9267 68.8056 53.5139 68.664C53.2007 68.5572 53.0339 68.2152 53.1407 67.902C53.2475 67.5888 53.5907 67.422 53.9027 67.5288C54.3251 67.674 54.7319 67.8156 55.1147 67.9548C55.4255 68.0688 55.5863 68.4132 55.4723 68.7252C55.3835 68.9688 55.1531 69.1188 54.9083 69.1188Z" fill="#103744"/>
								<path d="M44.1096 66.2052C44.0736 66.2052 44.0352 66.2016 43.9992 66.1944C40.2624 65.496 36.252 65.0256 32.076 64.8C31.7448 64.782 31.4916 64.4988 31.5084 64.1688C31.5264 63.8376 31.824 63.5592 32.1396 63.6024C36.3672 63.8316 40.4316 64.3068 44.2176 65.016C44.5428 65.0772 44.7588 65.3904 44.6976 65.7156C44.6448 66.0036 44.3928 66.2052 44.1096 66.2052Z" fill="#103744"/>
								<path d="M51.3083 76.3308C51.2519 76.3308 51.1943 76.3224 51.1367 76.3056C49.9895 75.9648 48.7896 75.6444 47.568 75.3528C47.2452 75.276 47.0472 74.952 47.124 74.6292C47.2008 74.3064 47.5284 74.1108 47.8476 74.1852C49.0896 74.4816 50.3111 74.808 51.4787 75.1548C51.7967 75.2496 51.9779 75.5832 51.8831 75.9012C51.8063 76.1616 51.5675 76.3308 51.3083 76.3308Z" fill="#103744"/>
								<path d="M54.9083 77.5188C54.8399 77.5188 54.7703 77.5068 54.7019 77.4828C54.3275 77.346 53.9267 77.2056 53.5139 77.064C53.2007 76.9572 53.0339 76.6152 53.1407 76.302C53.2475 75.9888 53.5907 75.822 53.9027 75.9288C54.3251 76.074 54.7319 76.2156 55.1147 76.3548C55.4255 76.4688 55.5863 76.8132 55.4723 77.1252C55.3835 77.3688 55.1531 77.5188 54.9083 77.5188Z" fill="#103744"/>
								<path d="M44.1096 74.6052C44.0736 74.6052 44.0352 74.6016 43.9992 74.5944C40.2624 73.896 36.252 73.4256 32.076 73.2C31.7448 73.182 31.4916 72.8988 31.5084 72.5688C31.5264 72.2376 31.824 71.9712 32.1396 72.0024C36.3672 72.2316 40.4316 72.7068 44.2176 73.416C44.5428 73.4772 44.7588 73.7904 44.6976 74.1156C44.6448 74.4036 44.3928 74.6052 44.1096 74.6052Z" fill="#103744"/>
								<path d="M66.9083 43.9188C66.6635 43.9188 66.4331 43.7688 66.3443 43.5252C66.2303 43.2144 66.3911 42.87 66.7019 42.7548C68.9783 41.922 71.4239 41.1924 73.9691 40.5852L77.4503 39.8724C77.7743 39.8052 78.0923 40.0152 78.1583 40.3404C78.2255 40.6656 78.0155 40.9824 77.6903 41.0484L74.2283 41.7564C71.7479 42.348 69.3479 43.0644 67.1147 43.8816C67.0475 43.9068 66.9767 43.9188 66.9083 43.9188Z" fill="#103744"/>
								<path d="M81.2124 40.4268C80.9184 40.4268 80.6616 40.2108 80.6184 39.9108C80.5716 39.5832 80.7996 39.2796 81.1284 39.2328C81.5544 39.1728 85.176 38.7588 85.176 38.7588L85.3116 39.9504C85.3116 39.9504 81.72 40.3608 81.2964 40.4208C81.2688 40.4256 81.2412 40.4268 81.2124 40.4268Z" fill="#103744"/>
								<path d="M88.1556 39.6972C87.8436 39.6972 87.5796 39.456 87.558 39.1392C87.534 38.8092 87.7836 38.5212 88.1136 38.4984C88.6248 38.4624 89.1456 38.4288 89.6748 38.4C90.0024 38.3688 90.288 38.6352 90.306 38.9664C90.324 39.2976 90.0708 39.5808 89.7396 39.5976C89.2164 39.6264 88.7028 39.6588 88.1964 39.6948C88.1844 39.6972 88.17 39.6972 88.1556 39.6972Z" fill="#103744"/>
								<path d="M66.9083 35.5188C66.6635 35.5188 66.4331 35.3688 66.3443 35.1252C66.2303 34.8144 66.3911 34.47 66.7019 34.3548C68.9783 33.522 71.4239 32.7924 73.9691 32.1852L77.4503 31.4724C77.7743 31.4052 78.0923 31.6152 78.1583 31.9404C78.2255 32.2656 78.0155 32.5824 77.6903 32.6484L74.2283 33.3564C71.7479 33.948 69.3479 34.6644 67.1147 35.4816C67.0475 35.5068 66.9767 35.5188 66.9083 35.5188Z" fill="#103744"/>
								<path d="M81.2124 32.0268C80.9184 32.0268 80.6616 31.8108 80.6184 31.5108C80.5716 31.1832 80.7996 30.8796 81.1284 30.8328C81.5544 30.7728 85.176 30.3588 85.176 30.3588L85.3116 31.5504C85.3116 31.5504 81.72 31.9608 81.2964 32.0208C81.2688 32.0256 81.2412 32.0268 81.2124 32.0268Z" fill="#103744"/>
								<path d="M88.1556 31.2972C87.8436 31.2972 87.5796 31.056 87.558 30.7392C87.534 30.4092 87.7836 30.1212 88.1136 30.0984C88.6248 30.0624 89.1456 30.0288 89.6748 30C90.0024 29.9556 90.288 30.2352 90.306 30.5664C90.324 30.8976 90.0708 31.1808 89.7396 31.1976C89.2164 31.2264 88.7028 31.2588 88.1964 31.2948C88.1844 31.2972 88.17 31.2972 88.1556 31.2972Z" fill="#103744"/>
								<path d="M66.9083 60.7188C66.6635 60.7188 66.4331 60.5688 66.3443 60.3252C66.2303 60.0144 66.3911 59.67 66.7019 59.5548C68.9783 58.722 71.4239 57.9924 73.9691 57.3852L77.4503 56.6724C77.7743 56.6052 78.0923 56.8152 78.1583 57.1404C78.2255 57.4656 78.0155 57.7824 77.6903 57.8484L74.2283 58.5564C71.7479 59.148 69.3479 59.8644 67.1147 60.6816C67.0475 60.7068 66.9767 60.7188 66.9083 60.7188Z" fill="#103744"/>
								<path d="M81.2124 57.2268C80.9184 57.2268 80.6616 57.0108 80.6184 56.7108C80.5716 56.3832 80.7996 56.0796 81.1284 56.0328C81.5544 55.9728 85.176 55.5588 85.176 55.5588L85.3116 56.7504C85.3116 56.7504 81.72 57.1608 81.2964 57.2208C81.2688 57.2256 81.2412 57.2268 81.2124 57.2268Z" fill="#103744"/>
								<path d="M88.1556 56.4972C87.8436 56.4972 87.5796 56.256 87.558 55.9392C87.534 55.6092 87.7836 55.3212 88.1136 55.2984C88.6248 55.2624 89.1456 55.2288 89.6748 55.2C90.0024 55.1592 90.288 55.4352 90.306 55.7664C90.324 56.0976 90.0708 56.3808 89.7396 56.3976C89.2164 56.4264 88.7028 56.4588 88.1964 56.4948C88.1844 56.4972 88.17 56.4972 88.1556 56.4972Z" fill="#103744"/>
								<path d="M66.9083 52.3188C66.6635 52.3188 66.4331 52.1688 66.3443 51.9252C66.2303 51.6144 66.3911 51.27 66.7019 51.1548C68.9783 50.322 71.4239 49.5924 73.9691 48.9852L77.4503 48.2724C77.7743 48.2052 78.0923 48.4152 78.1583 48.7404C78.2255 49.0656 78.0155 49.3824 77.6903 49.4484L74.2283 50.1564C71.7479 50.748 69.3479 51.4644 67.1147 52.2816C67.0475 52.3068 66.9767 52.3188 66.9083 52.3188Z" fill="#103744"/>
								<path d="M81.2124 48.8268C80.9184 48.8268 80.6616 48.6108 80.6184 48.3108C80.5716 47.9832 80.7996 47.6796 81.1284 47.6328C81.5544 47.5728 85.176 47.1588 85.176 47.1588L85.3116 48.3504C85.3116 48.3504 81.72 48.7608 81.2964 48.8208C81.2688 48.8256 81.2412 48.8268 81.2124 48.8268Z" fill="#103744"/>
								<path d="M88.1556 48.0972C87.8436 48.0972 87.5796 47.856 87.558 47.5392C87.534 47.2092 87.7836 46.9212 88.1136 46.8984C88.6248 46.8624 89.1456 46.8288 89.6748 46.8C90.0024 46.764 90.288 47.0352 90.306 47.3664C90.324 47.6976 90.0708 47.9808 89.7396 47.9976C89.2164 48.0264 88.7028 48.0588 88.1964 48.0948C88.1844 48.0972 88.17 48.0972 88.1556 48.0972Z" fill="#103744"/>
								<path d="M66.9083 77.5188C66.6635 77.5188 66.4331 77.3688 66.3443 77.1252C66.2303 76.8144 66.3911 76.47 66.7019 76.3548C68.9783 75.522 71.4239 74.7924 73.9691 74.1852L77.4503 73.4724C77.7743 73.4052 78.0923 73.6152 78.1583 73.9404C78.2255 74.2656 78.0155 74.5824 77.6903 74.6484L74.2283 75.3564C71.7479 75.948 69.3479 76.6644 67.1147 77.4816C67.0475 77.5068 66.9767 77.5188 66.9083 77.5188Z" fill="#103744"/>
								<path d="M81.2124 74.0268C80.9184 74.0268 80.6616 73.8108 80.6184 73.5108C80.5716 73.1832 80.7996 72.8796 81.1284 72.8328C81.5544 72.7728 85.176 72.3588 85.176 72.3588L85.3116 73.5504C85.3116 73.5504 81.72 73.9608 81.2964 74.0208C81.2688 74.0256 81.2412 74.0268 81.2124 74.0268Z" fill="#103744"/>
								<path d="M88.1556 73.2972C87.8436 73.2972 87.5796 73.056 87.558 72.7392C87.534 72.4092 87.7836 72.1212 88.1136 72.0984C88.6248 72.0624 89.1456 72.0288 89.6748 72C90.0024 71.9676 90.288 72.2352 90.306 72.5664C90.324 72.8976 90.0708 73.1808 89.7396 73.1976C89.2164 73.2264 88.7028 73.2588 88.1964 73.2948C88.1844 73.2972 88.17 73.2972 88.1556 73.2972Z" fill="#103744"/>
								<path d="M66.9083 69.1188C66.6635 69.1188 66.4331 68.9688 66.3443 68.7252C66.2303 68.4144 66.3911 68.07 66.7019 67.9548C68.9783 67.122 71.4239 66.3924 73.9691 65.7852L77.4503 65.0724C77.7743 65.0052 78.0923 65.2152 78.1583 65.5404C78.2255 65.8656 78.0155 66.1824 77.6903 66.2484L74.2283 66.9564C71.7479 67.548 69.3479 68.2644 67.1147 69.0816C67.0475 69.1068 66.9767 69.1188 66.9083 69.1188Z" fill="#103744"/>
								<path d="M81.2124 65.6268C80.9184 65.6268 80.6616 65.4108 80.6184 65.1108C80.5716 64.7832 80.7996 64.4796 81.1284 64.4328C81.5544 64.3728 85.176 63.9588 85.176 63.9588L85.3116 65.1504C85.3116 65.1504 81.72 65.5608 81.2964 65.6208C81.2688 65.6256 81.2412 65.6268 81.2124 65.6268Z" fill="#103744"/>
								<path d="M88.1556 64.8972C87.8436 64.8972 87.5796 64.656 87.558 64.3392C87.534 64.0092 87.7836 63.7212 88.1136 63.6984C88.6248 63.6624 89.1456 63.6288 89.6748 63.6C90.0024 63.5544 90.288 63.8352 90.306 64.1664C90.324 64.4976 90.0708 64.7808 89.7396 64.7976C89.2164 64.8264 88.7028 64.8588 88.1964 64.8948C88.1844 64.8972 88.17 64.8972 88.1556 64.8972Z" fill="#103744"/>
								<path d="M60.6 72C60.2688 72 60 71.7312 60 71.4V30.6C60 30.2688 60.2688 30 60.6 30C60.9312 30 61.2 30.2688 61.2 30.6V71.4C61.2 71.7312 60.9312 72 60.6 72Z" fill="#103744"/>
								<path d="M60.6 82.8C60.2688 82.8 60 82.5312 60 82.2V81C60 80.6688 60.2688 80.4 60.6 80.4C60.9312 80.4 61.2 80.6688 61.2 81V82.2C61.2 82.5312 60.9312 82.8 60.6 82.8Z" fill="#103744"/>
								<path d="M60.6 78C60.2688 78 60 77.7312 60 77.4V75C60 74.6688 60.2688 74.4 60.6 74.4C60.9312 74.4 61.2 74.6688 61.2 75V77.4C61.2 77.7312 60.9312 78 60.6 78Z" fill="#103744"/>
							</svg>

						</p>

						<p class="jsps-h2" role="heading" aria-level="2"><?php esc_html_e('Rebuilt Documentation' , 'juiz-social-post-sharer') ?></p>

						<p>
							<?php printf( esc_html__( 'The whole %sdocumentation%s has been rebuilt to better meet the developers expectations. %sFresh tutorials are here to help!%s', 'juiz-social-post-sharer'), '<a href="' . jsps_get_public_website( 'doc/', array('source' => 'wp-plugin', 'medium' => 'content', 'campaign' => 'welcome' ) ) . '">', '</a>', '<strong>', '</strong>' ); ?>
						</p>
					</div>
					<div class="jsps-col">
						<p class="jsps-icon">
							<svg width="120" height="120" viewBox="0 0 120 120" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M82.1999 46.8C81.3671 46.8 80.5655 46.6776 79.7999 46.4664V54.6C79.7999 58.5708 76.5707 61.8 72.5999 61.8H47.3999C44.6963 61.8 42.2087 62.7096 40.1999 64.2228V34.4664C39.4343 34.6776 38.6327 34.8 37.7999 34.8C36.9671 34.8 36.1655 34.6776 35.3999 34.4664V73.8V80.4V85.5336C36.1655 85.3224 36.9671 85.2 37.7999 85.2C38.6327 85.2 39.4343 85.3224 40.1999 85.5336V80.4V73.8C40.1999 69.8292 43.4291 66.6 47.3999 66.6H72.5999C79.2167 66.6 84.5999 61.2168 84.5999 54.6V46.4664C83.8343 46.6776 83.0327 46.8 82.1999 46.8Z" fill="#E3E8ED"/>
								<path d="M37.8 34.8C42.7706 34.8 46.8 30.7706 46.8 25.8C46.8 20.8294 42.7706 16.8 37.8 16.8C32.8295 16.8 28.8 20.8294 28.8 25.8C28.8 30.7706 32.8295 34.8 37.8 34.8Z" fill="#F37E98"/>
								<path d="M82.1999 46.8C87.1705 46.8 91.1999 42.7706 91.1999 37.8C91.1999 32.8294 87.1705 28.8 82.1999 28.8C77.2294 28.8 73.2 32.8294 73.2 37.8C73.2 42.7706 77.2294 46.8 82.1999 46.8Z" fill="#F37E98"/>
								<path d="M37.8 103.2C42.7706 103.2 46.8 99.1706 46.8 94.2C46.8 89.2295 42.7706 85.2 37.8 85.2C32.8295 85.2 28.8 89.2295 28.8 94.2C28.8 99.1706 32.8295 103.2 37.8 103.2Z" fill="#20A0C9"/>
								<path d="M37.8001 36C32.1757 36 27.6001 31.4244 27.6001 25.8C27.6001 20.1756 32.1757 15.6 37.8001 15.6C43.4245 15.6 48.0001 20.1756 48.0001 25.8C48.0001 31.4244 43.4245 36 37.8001 36ZM37.8001 18C33.4993 18 30.0001 21.4992 30.0001 25.8C30.0001 30.1008 33.4993 33.6 37.8001 33.6C42.1009 33.6 45.6001 30.1008 45.6001 25.8C45.6001 21.4992 42.1009 18 37.8001 18Z" fill="#103744"/>
								<path d="M82.2 48C76.5756 48 72 43.4244 72 37.8C72 32.1756 76.5756 27.6 82.2 27.6C87.8244 27.6 92.4 32.1756 92.4 37.8C92.4 43.4244 87.8244 48 82.2 48ZM82.2 30C77.8992 30 74.4 33.4992 74.4 37.8C74.4 42.1008 77.8992 45.6 82.2 45.6C86.5008 45.6 90 42.1008 90 37.8C90 33.4992 86.5008 30 82.2 30Z" fill="#103744"/>
								<path d="M37.8001 104.4C32.1757 104.4 27.6001 99.8244 27.6001 94.2C27.6001 88.5756 32.1757 84 37.8001 84C43.4245 84 48.0001 88.5756 48.0001 94.2C48.0001 99.8244 43.4245 104.4 37.8001 104.4ZM37.8001 86.4C33.4993 86.4 30.0001 89.8992 30.0001 94.2C30.0001 98.5008 33.4993 102 37.8001 102C42.1009 102 45.6001 98.5008 45.6001 94.2C45.6001 89.8992 42.1009 86.4 37.8001 86.4Z" fill="#103744"/>
								<path d="M40.2 86.1336C40.1472 86.1336 40.0932 86.1264 40.0392 86.1108C38.5452 85.698 37.0548 85.698 35.5608 86.1108C35.3772 86.1636 35.1852 86.124 35.0364 86.0112C34.8876 85.8984 34.8 85.722 34.8 85.5336V34.4664C34.8 34.2792 34.8876 34.1016 35.0364 33.9888C35.1864 33.876 35.3784 33.8388 35.5608 33.8892C37.0548 34.302 38.5452 34.302 40.0392 33.8892C40.2228 33.8376 40.4149 33.876 40.5637 33.9888C40.7125 34.1016 40.8 34.278 40.8 34.4664V63.0864C42.7896 61.848 45.0492 61.2 47.4 61.2H72.6C76.2396 61.2 79.2 58.2384 79.2 54.6V46.4664C79.2 46.2792 79.2876 46.1016 79.4364 45.9888C79.5864 45.8772 79.7796 45.8376 79.9608 45.8892C81.4548 46.302 82.9452 46.302 84.4392 45.8892C84.6216 45.8364 84.8148 45.876 84.9636 45.9888C85.1124 46.1016 85.2 46.278 85.2 46.4664V54.6C85.2 61.548 79.548 67.2 72.6 67.2H47.4C43.7604 67.2 40.8 70.1616 40.8 73.8V85.5336C40.8 85.7208 40.7125 85.8984 40.5637 86.0112C40.4581 86.0916 40.3296 86.1336 40.2 86.1336ZM36 35.2236V84.7776C37.2036 84.5436 38.3964 84.5436 39.6 84.7776V73.8C39.6 69.4992 43.0992 66 47.4 66H72.6C78.8856 66 84 60.8856 84 54.6V47.2236C82.7964 47.4576 81.6036 47.4576 80.4 47.2236V54.6C80.4 58.9008 76.9008 62.4 72.6 62.4H47.4C44.9244 62.4 42.5592 63.1956 40.5612 64.7028C40.3788 64.8384 40.1364 64.8612 39.9324 64.7604C39.7284 64.6596 39.6 64.4508 39.6 64.224V35.2236C38.3964 35.4576 37.2036 35.4576 36 35.2236Z" fill="#103744"/>
								<path d="M37.7999 99.6C34.8227 99.6 32.3999 97.1772 32.3999 94.2C32.3999 91.2228 34.8227 88.8 37.7999 88.8C40.7771 88.8 43.1999 91.2228 43.1999 94.2C43.1999 97.1772 40.7771 99.6 37.7999 99.6ZM37.7999 90C35.4839 90 33.5999 91.884 33.5999 94.2C33.5999 96.516 35.4839 98.4 37.7999 98.4C40.1159 98.4 41.9999 96.516 41.9999 94.2C41.9999 91.884 40.1159 90 37.7999 90Z" fill="#103744"/>
								<path d="M37.7999 31.2C34.8227 31.2 32.3999 28.7772 32.3999 25.8C32.3999 22.8228 34.8227 20.4 37.7999 20.4C38.1311 20.4 38.3999 20.6688 38.3999 21C38.3999 21.3312 38.1311 21.6 37.7999 21.6C35.4839 21.6 33.5999 23.484 33.5999 25.8C33.5999 28.116 35.4839 30 37.7999 30C39.7043 30 41.3687 28.7052 41.8499 26.85C41.9327 26.5284 42.2591 26.3364 42.5807 26.4192C42.9011 26.502 43.0943 26.8308 43.0103 27.15C42.3935 29.5344 40.2503 31.2 37.7999 31.2Z" fill="#103744"/>
								<path d="M42.4295 25.2C42.1619 25.2 41.9183 25.0212 41.8487 24.75C41.7563 24.3888 41.6099 24.036 41.4155 23.7012C41.2487 23.4156 41.3459 23.0484 41.6327 22.8804C41.9183 22.7136 42.2855 22.8108 42.4535 23.0988C42.7031 23.5272 42.8915 23.982 43.0115 24.45C43.0943 24.7716 42.9011 25.098 42.5795 25.1808C42.5291 25.194 42.4787 25.2 42.4295 25.2Z" fill="#103744"/>
								<path d="M82.2001 43.2C79.2229 43.2 76.8 40.7772 76.8 37.8C76.8 35.8992 77.8333 34.1172 79.4989 33.1476C79.7845 32.976 80.1528 33.0768 80.3196 33.3636C80.4864 33.6504 80.3892 34.0176 80.1024 34.1844C78.786 34.9512 78 36.3024 78 37.8C78 40.116 79.8841 42 82.2001 42C83.6989 42 85.0501 41.2152 85.8157 39.8976C85.9825 39.6132 86.3497 39.5148 86.6365 39.6804C86.9233 39.8484 87.0193 40.2144 86.8537 40.5024C85.8841 42.1668 84.1009 43.2 82.2001 43.2Z" fill="#103744"/>
								<path d="M87 38.4C86.6688 38.4 86.4 38.1312 86.4 37.8C86.4 37.4796 86.352 37.146 86.25 36.7512C86.1672 36.4296 86.3592 36.1032 86.6796 36.0192C87.0012 35.9376 87.3288 36.1284 87.4116 36.4488C87.54 36.9456 87.6 37.3752 87.6 37.8C87.6 38.1312 87.3312 38.4 87 38.4Z" fill="#103744"/>
							</svg>
						</p>

						<p class="jsps-h2" role="heading" aria-level="2"><?php esc_html_e('Roadmap &amp; Contribution' , 'juiz-social-post-sharer') ?></p>

						<p>
							<?php printf( esc_html__( 'This plugin is open-source, %sthe roadmap%s is public and available on Github.com. This makes it stronger and way safer!', 'juiz-social-post-sharer'), '<a href="' . jsps_get_roadmap_url() . '">', '</a>' ); ?>
						</p>
					</div>
				</div>

				<?php
				/**
				 * Decides if it displays promotion sections within the admin, or not.
				 * 
				 * @hook jsps_admin_show_promotion
				 * 
				 * @since  2.0.0 First version
				 * 
				 * @param  {boolean} $show_promo=true   `true` or `false` weither you want to display promo or not
				 * @return {boolean}                    Returns the value of `$show_promo`
				 *
				 */
				if ( apply_filters( 'jsps_admin_show_promotion', true ) ) {
				?>
				
				<div id="jsps-shop-promotion" class="jsps-shop-promotion">
					<p class="jsps-shop-promo-text">
						<span class="jsps-promo-big-text">
							<?php _e( 'New Skin Shop', 'juiz-social-post-sharer'); ?>
						</span>
						<span class="jsps-promo-text">
							<?php _e( 'Free &amp; Premium Button Skins', 'juiz-social-post-sharer' ); ?>
						</span>
					</p>
					<div class="jsps-shop-promo-form">
						<!-- Begin Mailchimp Signup Form -->
						<div id="mc_embed_signup">
							<form action="https://gmail.us10.list-manage.com/subscribe/post?u=5339b8dfa2b000a82251effc3&amp;id=c9c0f762f1" method="post" id="mc-embedded-subscribe-form" name="mc-embedded-subscribe-form" class="validate" target="_blank" novalidate>
								<div id="mc_embed_signup_scroll">
									<div class="mc-field-group">
										<label for="mce-EMAIL" form="mc-embedded-subscribe-form">
											<?php _e( 'Soon! Be the first to know', 'juiz-social-post-sharer' ); ?>
											<span><?php _e( 'Email Address', 'juiz-social-post-sharer' ); ?></span>
										</label>
										<input type="email" value="" name="EMAIL" class="required email" id="mce-EMAIL" form="mc-embedded-subscribe-form">
									</div>

									<!-- real people should not fill this in and expect good things - do not remove this or risk form bot signups-->
									<div style="position: absolute; left: -5000px;" aria-hidden="true"><input type="text" name="b_5339b8dfa2b000a82251effc3_c9c0f762f1" tabindex="-1" value=""></div>

									<div class="mc-submit">
										<input type="hidden" value="Admin-Skin-Shop" name="CAMPAIGN" id="mce-CAMPAIGN" form="mc-embedded-subscribe-form">
										
										<button form="mc-embedded-subscribe-form" type="submit" name="subscribe" id="mc-embedded-subscribe" class="button"><img src="<?php echo JUIZ_SPS_PLUGIN_ASSETS; ?>img/icon-send.svg" alt="<?php echo esc_attr( __('Subscribe', 'juiz-social-post-sharer') ); ?>" title="<?php echo esc_attr( __('Subscribe', 'juiz-social-post-sharer') ); ?>" width="24" height="24" /></button>
									</div>
								</div>
							</form>
							<!-- /form -->
						</div>
						<!--End mc_embed_signup-->

					</div>
				</div>

				<?php
				}
				?>

				<div class="jsps-welcome-grid jsps-bottom-margin">
					<div class="jsps-col jsps-text-left">
						<p class="jsps-h2" role="heading" aria-level="2"><?php printf( esc_html__('Plugin made for free %s by humans' , 'juiz-social-post-sharer'), '<span>' ); ?></span></p>

						<p>
							<?php printf( esc_html__( 'This plugin is totally free since 2012 and will stay %sfree forever%s. But you can always support people behind it with a donation.', 'juiz-social-post-sharer' ), '<strong>', '</strong>' ); ?>
						</p>

						<div class="juiz_btns_set">
							<a class="juiz_btn_link juiz_paypal juiz_full_width" target="_blank" href="<?php echo jsps_get_paypal_url(); ?>" aria-label="<?php printf( __( 'Donate with %s', 'juiz-social-post-sharer' ), 'Paypal' ); ?>">
								<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Paypal" x="0px" y="0px" viewBox="0 0 16 16" xml:space="preserve"><path d="M5.444 9.488a.714.714 0 0 1 .707-.6h1.47c2.889 0 5.15-1.164 5.811-4.531.02-.1.051-.292.051-.292.188-1.246-.001-2.091-.68-2.858C12.057.362 10.707 0 8.98 0H3.968a.717.717 0 0 0-.709.6L1.172 13.731a.428.428 0 0 0 .425.493h3.094l.777-4.89-.024.154z" fill="currentColor"></path><path d="M7.621 9.772H6.303L5.319 16h2.138a.626.626 0 0 0 .62-.526l.025-.132.492-3.091.032-.17a.626.626 0 0 1 .619-.526h.391c2.527 0 4.505-1.018 5.083-3.963.232-1.182.12-2.173-.453-2.889-.718 3.315-3.009 5.069-6.645 5.069z" fill="currentColor"></path></svg><?php _e( 'Paypal', 'juiz-social-post-sharer' ); ?>
							</a>

							<a class="juiz_btn_link juiz_flattr juiz_full_width" target="_blank" href="https://flattr.com/@geoffreycrofte" lang="en" hreflang="en" aria-label="<?php printf( __( 'Donate with %s', 'juiz-social-post-sharer' ), 'Flattr' ); ?>">
								<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Flattr" x="0px" y="0px" viewBox="0 0 20 20" xml:space="preserve"><path d="M5.598 8.541c0-1.637.434-2.678 1.889-2.912.508-.1 1.566-.064 2.239-.064v2.5c0 .024.003.064.009.084a.236.236 0 0 0 .228.175c.061 0 .118-.031.178-.09L16.377 2H7.548C3.874 2 2 4.115 2 8.066v8.287l3.598-3.602v-4.21zM14.4 7.248v4.209c0 1.637-.434 2.68-1.889 2.912-.508.1-1.566.065-2.238.065v-2.5a.48.48 0 0 0-.009-.084.242.242 0 0 0-.228-.176c-.062 0-.118.033-.179.092l-6.235 6.232L7.809 18h4.643C16.125 18 18 15.885 18 11.934V3.647l-3.6 3.601z" fill="currentColor"></path></svg><?php _e( 'Flattr', 'juiz-social-post-sharer' ); ?>
							</a>

							<a class="juiz_btn_link juiz_bmc juiz_full_width" target="_blank" href="https://www.buymeacoffee.com/geoffreycrofte" lang="en" hreflang="en" aria-label="<?php printf( __( 'Donate with %s', 'juiz-social-post-sharer' ), 'Buy Me a Coffee' ); ?>">
								<svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M32.5073 11.4925L32.3062 10.4779C32.1257 9.56757 31.716 8.70743 30.7816 8.37838C30.482 8.27315 30.1422 8.22791 29.9126 8.01005C29.6829 7.79219 29.615 7.45381 29.5619 7.14006C29.4635 6.56416 29.3711 5.98779 29.2703 5.41286C29.1832 4.9186 29.1144 4.36337 28.8877 3.90993C28.5926 3.30108 27.9803 2.94502 27.3715 2.70945C27.0595 2.59299 26.7411 2.49447 26.4179 2.41437C24.8967 2.01307 23.2974 1.86553 21.7325 1.78143C19.8542 1.67778 17.9709 1.70901 16.097 1.87487C14.7023 2.00175 13.2333 2.1552 11.9079 2.63765C11.4235 2.8142 10.9243 3.02617 10.5559 3.40043C10.104 3.86025 9.95642 4.57139 10.2864 5.14483C10.521 5.55204 10.9184 5.83972 11.3398 6.03007C11.8888 6.27531 12.4621 6.4619 13.0503 6.58678C14.688 6.94875 16.3842 7.09089 18.0573 7.15135C19.9117 7.22618 21.7691 7.16556 23.6146 6.96989C24.071 6.91972 24.5266 6.85958 24.9813 6.78939C25.5169 6.70727 25.8607 6.00697 25.7028 5.51909C25.5139 4.93581 25.0064 4.70959 24.4325 4.79762C24.3479 4.8109 24.2638 4.82319 24.1792 4.83549L24.1182 4.84434C23.9238 4.86893 23.7294 4.89188 23.5349 4.91319C23.1333 4.95647 22.7307 4.99188 22.3271 5.01942C21.4231 5.08237 20.5168 5.11139 19.6109 5.11286C18.7207 5.11286 17.8301 5.08778 16.9419 5.02926C16.5367 5.0027 16.1324 4.96893 15.7291 4.92795C15.5457 4.90877 15.3628 4.8886 15.1798 4.86598L15.0057 4.84385L14.9679 4.83844L14.7874 4.81237C14.4185 4.7568 14.0497 4.69287 13.6847 4.61566C13.6479 4.60749 13.615 4.587 13.5914 4.55758C13.5678 4.52816 13.5549 4.49157 13.5549 4.45386C13.5549 4.41613 13.5678 4.37955 13.5914 4.35013C13.615 4.32071 13.6479 4.30022 13.6847 4.29205H13.6916C14.0079 4.22467 14.3265 4.16714 14.6462 4.11698C14.7528 4.10025 14.8596 4.08386 14.9669 4.06779H14.9698C15.17 4.05452 15.3711 4.01861 15.5703 3.99501C17.3032 3.81475 19.0465 3.7533 20.7878 3.81108C21.6332 3.83567 22.4781 3.88534 23.3195 3.97091C23.5005 3.9896 23.6805 4.00927 23.8605 4.0314C23.9294 4.03976 23.9987 4.0496 24.068 4.05796L24.2077 4.07812C24.6149 4.13878 25.02 4.21238 25.4229 4.29894C26.02 4.42877 26.7867 4.47107 27.0523 5.12516C27.1369 5.33269 27.1752 5.56335 27.2219 5.78122L27.2814 6.0591C27.283 6.06406 27.2842 6.06915 27.2849 6.07431C27.4255 6.73005 27.5664 7.38578 27.7074 8.04152C27.7177 8.08997 27.7179 8.14002 27.7081 8.18855C27.6982 8.23708 27.6784 8.28308 27.65 8.32364C27.6216 8.3642 27.5851 8.39848 27.5428 8.4243C27.5006 8.45013 27.4535 8.46699 27.4044 8.47379H27.4004L27.3144 8.4856L27.2293 8.49694C26.9598 8.53201 26.69 8.5648 26.4198 8.59527C25.8877 8.65593 25.3548 8.70839 24.821 8.75267C23.7604 8.84084 22.6976 8.8987 21.6327 8.92624C21.0901 8.9407 20.5476 8.94739 20.0053 8.94642C17.8468 8.9447 15.6902 8.81926 13.546 8.57069C13.3139 8.54314 13.0818 8.51363 12.8497 8.48364C13.0297 8.50675 12.7188 8.46594 12.6559 8.4571C12.5084 8.43643 12.3608 8.41493 12.2133 8.39267C11.718 8.3184 11.2258 8.22691 10.7315 8.14675C10.134 8.04841 9.56249 8.09758 9.02201 8.39267C8.57835 8.63543 8.21927 9.00773 7.99268 9.45986C7.75957 9.94182 7.69022 10.4665 7.58596 10.9844C7.4817 11.5023 7.31941 12.0595 7.38088 12.5911C7.51318 13.7385 8.3153 14.6709 9.46905 14.8795C10.5544 15.0762 11.6457 15.2355 12.74 15.3713C17.0384 15.8977 21.381 15.9607 25.6929 15.5591C26.0441 15.5263 26.3947 15.4906 26.7449 15.4519C26.8543 15.4399 26.9649 15.4525 27.0688 15.4888C27.1727 15.5251 27.2671 15.5841 27.3452 15.6617C27.4233 15.7392 27.483 15.8332 27.5201 15.9368C27.5571 16.0404 27.5705 16.151 27.5593 16.2604L27.4501 17.3217C27.2302 19.4663 27.0101 21.6107 26.7902 23.7549C26.5606 26.0067 26.3297 28.2583 26.0972 30.5097C26.0316 31.1438 25.9661 31.7778 25.9005 32.4115C25.8375 33.0356 25.8287 33.6794 25.7102 34.2961C25.5233 35.2659 24.8667 35.8615 23.9087 36.0794C23.031 36.2791 22.1344 36.3839 21.2343 36.3922C20.2364 36.3976 19.2391 36.3533 18.2412 36.3587C17.176 36.3646 15.8713 36.2662 15.049 35.4735C14.3265 34.7771 14.2267 33.6868 14.1283 32.744C13.9972 31.4958 13.8672 30.2478 13.7383 28.9999L13.0154 22.0612L12.5477 17.5716C12.5398 17.4973 12.532 17.424 12.5246 17.3493C12.4685 16.8137 12.0893 16.2894 11.4918 16.3165C10.9803 16.3391 10.399 16.7739 10.459 17.3493L10.8058 20.6778L11.5228 27.5629C11.7271 29.5186 11.9308 31.4747 12.1341 33.431C12.1735 33.8058 12.2103 34.1815 12.2517 34.5562C12.4764 36.6041 14.0403 37.7077 15.977 38.0185C17.1082 38.2005 18.2668 38.2378 19.4147 38.2565C20.8861 38.2802 22.3723 38.3367 23.8197 38.0701C25.9644 37.6767 27.5736 36.2446 27.8032 34.0231C27.8688 33.3819 27.9344 32.7404 28 32.0987C28.218 29.9768 28.4357 27.8547 28.6531 25.7325L29.3642 18.7981L29.6903 15.6201C29.7065 15.4625 29.7731 15.3144 29.88 15.1975C29.9871 15.0807 30.1288 15.0014 30.2844 14.9714C30.8976 14.8519 31.4838 14.6478 31.9201 14.1811C32.6145 13.438 32.7527 12.4691 32.5073 11.4925ZM9.43758 12.178C9.44692 12.1736 9.42971 12.2538 9.42233 12.2911C9.42086 12.2346 9.42381 12.1844 9.43758 12.178ZM9.49709 12.6384C9.50201 12.6349 9.51676 12.6546 9.532 12.6782C9.50889 12.6565 9.49414 12.6403 9.4966 12.6384H9.49709ZM9.55561 12.7156C9.57676 12.7515 9.58807 12.7741 9.55561 12.7156V12.7156ZM9.67315 12.811H9.6761C9.6761 12.8144 9.68151 12.8179 9.68347 12.8213C9.68022 12.8175 9.67659 12.8141 9.67266 12.811H9.67315ZM30.2558 12.6683C30.0355 12.8778 29.7035 12.9752 29.3755 13.0239C25.6969 13.5698 21.9646 13.8462 18.2456 13.7242C15.5841 13.6332 12.9505 13.3377 10.3154 12.9654C10.0572 12.929 9.77741 12.8818 9.59987 12.6915C9.26545 12.3325 9.42971 11.6095 9.51676 11.1757C9.59643 10.7784 9.74888 10.2487 10.2215 10.1922C10.9592 10.1056 11.8159 10.4169 12.5457 10.5276C13.4244 10.6617 14.3064 10.769 15.1916 10.8497C18.9696 11.1939 22.811 11.1403 26.5723 10.6367C27.2578 10.5446 27.9409 10.4376 28.6216 10.3156C29.228 10.2069 29.9003 10.0028 30.2667 10.6308C30.518 11.0587 30.5514 11.6311 30.5126 12.1146C30.5006 12.3252 30.4086 12.5233 30.2553 12.6683H30.2558Z" fill="currentColor"/></svg>
								<?php _e( 'Buy me a Coffee', 'juiz-social-post-sharer' ); ?>
							</a>
						</div>

						<p>
							<?php printf( esc_html__( 'Big thanks to %sall the contributors%s.', 'juiz-social-post-sharer' ), '<a href="https://github.com/geoffreycrofte/juiz-social-post-sharer/graphs/contributors">', '</a>' ); ?>
						</p>

					</div>

					<div class="jsps-col">
						
						<svg class="jsps-donation" width="263" height="263" viewBox="0 0 263 263" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path d="M176.21 42.08C165.777 42.08 156.793 48.1684 152.54 56.9736C148.287 48.1684 139.303 42.08 128.87 42.08C114.345 42.08 102.57 53.8545 102.57 68.38C102.57 94.68 152.54 126.24 152.54 126.24C152.54 126.24 202.51 94.68 202.51 68.38C202.51 53.8545 190.736 42.08 176.21 42.08Z" fill="#F37E98"/>
							<path d="M31.5598 194.62L65.7498 181.47L149.702 219.729C151.44 220.525 153.305 220.92 155.17 220.92C157.187 220.92 159.202 220.457 161.05 219.531L224.17 187.971C230.667 184.723 233.299 176.825 230.051 170.329C227.697 165.619 222.895 162.939 217.961 163.06L217.979 163.099C217.753 161.984 217.435 160.877 216.901 159.809C214.027 154.06 207.512 151.354 201.552 153.055C201.405 152.677 201.305 152.29 201.121 151.919C197.873 145.421 189.97 142.788 183.479 146.039L150.951 159.983L150.896 159.933C150.588 159.744 150.27 159.567 149.944 159.399L101.407 134.469L100.858 134.201C93.0992 130.622 84.8331 128.799 76.2909 128.788C76.2619 128.788 76.2356 128.788 76.2067 128.788C68.7954 128.788 61.5418 130.164 54.6302 132.889L31.5598 142.002" fill="#EAD6C7"/>
							<path d="M176.21 42.08C165.777 42.08 156.793 48.1684 152.54 56.9736C148.287 48.1684 139.303 42.08 128.87 42.08C114.345 42.08 102.57 53.8545 102.57 68.38C102.57 94.68 152.54 126.24 152.54 126.24C152.54 126.24 202.51 94.68 202.51 68.38C202.51 53.8545 190.736 42.08 176.21 42.08Z" stroke="#103744" stroke-width="2" stroke-miterlimit="10" stroke-linejoin="round"/>
							<path d="M159.115 103.769C167.358 97.2417 175.421 89.7567 180.934 82.8451M186.167 74.9551C187.369 72.5486 188.045 70.3263 188.045 68.3801C188.045 65.9473 187.304 63.6881 186.041 61.8051L186.167 74.9551Z" stroke="#103744" stroke-miterlimit="10" stroke-linecap="round"/>
							<path d="M201.916 154.318C201.127 154.544 200.451 154.802 199.848 155.102L156.396 173.73" stroke="#103744" stroke-miterlimit="10"/>
							<path d="M144.834 157.618L101.407 134.469L100.858 134.201C93.0992 130.622 84.8331 128.799 76.2908 128.788C76.2619 128.788 76.2356 128.788 76.2067 128.788C68.7954 128.788 61.5418 130.164 54.6302 132.889L31.5598 142.002M31.5598 194.62L65.7498 181.47L149.702 219.729C151.44 220.525 153.305 220.92 155.17 220.92C157.187 220.92 159.202 220.457 161.05 219.531L224.17 187.971C230.667 184.723 233.299 176.825 230.051 170.329C227.697 165.619 222.895 162.939 217.961 163.06" stroke="#103744" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round"/>
							<path d="M217.98 163.1C217.753 161.984 217.435 160.877 216.901 159.809C214.027 154.06 207.512 151.354 201.553 153.056C201.405 152.677 201.305 152.29 201.121 151.919C197.873 145.421 189.97 142.788 183.479 146.039L150.951 159.983" stroke="#103744" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round"/>
							<path d="M218.009 164.414C216.204 164.454 214.519 164.862 212.998 165.624L160.33 188.203L151.264 182.764" stroke="#103744" stroke-miterlimit="10" stroke-linejoin="round"/>
							<path d="M114.405 172.681L137.307 183.953C139.208 184.928 141.226 185.418 143.324 185.418C148.282 185.418 152.769 182.68 155.033 178.275C158.16 172.186 156.04 164.622 150.212 161.053M103.885 167.502L109.145 170.09L103.885 167.502Z" stroke="#103744" stroke-miterlimit="10" stroke-linecap="round"/>
						</svg>

						<blockquote class="jsps-quote">
							<p>“Keep sharing!”</p>
							<cite>Geoffrey</cite>
						</blockquote>

					</div>

					<div class="jsps-col jsps-text-left">

						<p class="jsps-h2" role="heading" aria-level="2"><?php printf( esc_html__('You can also help %s by sharing' , 'juiz-social-post-sharer'), '<span>' ); ?></span></p>

						<p>
							<?php printf( esc_html__( 'Not everybody can help with money. You can give a good rating, a tweet or a bit of your time to help %simprove this plugin &amp; spread the word.%s', 'juiz-social-post-sharer' ), '<strong>', '</strong>' ); ?>
						</p>

						<div class="juiz_btns_set">
							<a class="juiz_btn_link juiz_twitter juiz_full_width" target="_blank" href="https://twitter.com/intent/tweet?source=webclient&amp;hastags=WordPress,Plugin&amp;text=Juiz%20Social%20Post%20Sharer%20is%20an%20awesome%20WordPress%20plugin%20to%20share%20content!%20Try%20it!&amp;url=http://wordpress.org/extend/plugins/juiz-social-post-sharer/&amp;related=geoffrey_crofte&amp;via=geoffrey_crofte"><i class="dashicons dashicons-twitter" aria-hidden="true"></i>&nbsp;<?php _e( 'Tweet it', 'juiz-social-post-sharer' ); ?></a>

							<a class="juiz_btn_link juiz_rate juiz_full_width" target="_blank" href="https://wordpress.org/support/plugin/juiz-social-post-sharer/reviews/?rate=5#new-post"><i class="dashicons dashicons-star-filled" aria-hidden="true"></i>&nbsp;<?php _e( 'Rate it', 'juiz-social-post-sharer' ); ?></a>

							<a class="juiz_btn_link juiz_translation juiz_full_width" target="_blank" href="https://translate.wordpress.org/projects/wp-plugins/juiz-social-post-sharer/"><i class="dashicons dashicons-translation" aria-hidden="true"></i>&nbsp;<?php _e( 'Translate it', 'juiz-social-post-sharer' ); ?></a>

							<a class="juiz_btn_link juiz_github juiz_full_width" target="_blank" href="https://wordpress.org/support/plugin/juiz-social-post-sharer/reviews/?rate=5#new-post"><i class="dashicons dashicons-rest-api" aria-hidden="true"></i>&nbsp;<?php _e( 'Contribute', 'juiz-social-post-sharer' ); ?></a>
						</div>
					</div>
				</div>

			</div>

		</div><!-- .jsps-main-content -->

		<div class="juiz_bottom_links">
			<div class="juiz_bottom_links_container">
				<div class="jsps-links-header">
					<p><i class="dashicons dashicons-admin-settings" aria-hidden="true"></i>&nbsp;<?php esc_html_e( 'Settings' ); ?></p>
				</div>
				<p class="juiz_bottom_links_p">
					<em class="jsps-emphasis"><?php _e( 'Read the news about your plugin or go back to the settings page to discover the new interface.', 'juiz-social-post-sharer' ); ?></em>
				</p>

				<div class="juiz_btns_set">
					<a class="juiz_btn_link juiz_full_width" href="<?php echo jsps_get_settings_url(); ?>">
						<i class="dashicons dashicons-admin-settings" aria-hidden="true"></i><?php _e( 'Settings Page', 'juiz-social-post-sharer' ); ?>
					</a>
				</div>

				<p class="juiz_bottom_links_p jsps-text-center"><a href="<?php echo jsps_get_public_website( null, array('source' => 'wp-plugin', 'medium' => 'sidebar', 'campaign' => 'welcome' ) ); ?>"><?php esc_html_e('Public Website', 'juiz-social-post-sharer'); ?></a></p>
			</div><!-- .juiz_bottom_links_container -->
		</div><!-- .juiz_bottom_links -->

		<script>
			document.querySelector('title').innerHTML = 'Welcome!';
		</script>
	</div><!-- .wrap -->

	<?php
	}
}