<?php if ( ! defined( 'ABSPATH' ) ) {
	die( 'Cheatin’ uh?' );
}

/**
 * Simply return a string for upgrade notice.
 * 
 * @return string
 */
function jsps_get_major_upgrade_notice() {
	return sprintf(
		__( 'Includes a lot of improvements. It has been tested on our side and should be ok. But WordPress is a big universe, it might be breaking changes for your specific website. If you can: double check on a safe (test) environment that everything is going to be ok for your website. Don’t forget to %sbackup your website%s.', 'juiz-social-post-sharer'),
		'<a style="color:var(--errorbg);" href="https://wordpress.org/plugins/updraftplus/" target="_blank">',
		'</a>'
	);
}

/**
 * The function to put upgrage notice into single site.
 *
 * @param  array $plugin_data The array of data from Readme (name, plugin_url, version, description, author, author_url, text_domain, domain_path, network, title, author_name, update)
 * @param  object $new_data Some other info about the plugin (id, slug, new_version, url, package)
 *
 * @return void
 *
 * @author Geoffrey Crofte
 * @since  1.4.11
 */
function jsps_plugin_update_message( $plugin_data, $new_data ) {

	if ( ! isset( $plugin_data['new_version'] ) && ! isset( $plugin_data['Version'] ) ) {
		return false;
	}

	$new  = explode( '.', $plugin_data['new_version'] );
	$curr = explode( '.', $plugin_data['Version'] );

	if ( isset( $plugin_data['update'] ) && $plugin_data['update'] && $new[0] > $curr[0] ) {
		printf(
			'<div style="background:var(--error);padding:8px 16px;" class="jsps-warning"><style>.jsps-warning p::before{content:none;}.jsps-warning+p:empty{display:none}.jsps-warning{margin:16px 0}</style><p style="color:var(--errorbg);font-weight:bold;"><strong>%s</strong>: %s</p></div>',
			$new_data -> new_version,
			jsps_get_major_upgrade_notice()
		);
	}

}
add_action( 'in_plugin_update_message-juiz-social-post-sharer/juiz-social-post-sharer.php', 'jsps_plugin_update_message', 10, 2 );

/**
 * The function to put upgrage notice into Multi-site.
 *
 * @param  array $file   The file path loading the plugin, from the plugin directory.
 * @param  array $plugin Seems to be the same as $plugin_data in in_plugin_update_message hook.
 *
 * @return void
 *
 * @author Geoffrey Crofte
 * @since  1.4.11
 */
function jsps_ms_plugin_update_message( $file, $plugin, $status ) {
	if ( ! is_multisite() ) {
		return false;
	}

	if ( $file !== 'juiz-social-post-sharer/juiz-social-post-sharer.php' ) {
		return false;
	}

	$new  = explode( '.', $plugin['new_version'] );
	$curr = explode( '.', $plugin['Version'] );

	if ( $new[0] > $curr[0] ) {
		$wp_list_table = _get_list_table( 'WP_Plugins_List_Table' );

		printf(
			'<tr class="plugin-update-tr"><td colspan="%s" class="plugin-update update-message notice inline notice-warning notice-alt"><div class="update-message"><h4 style="margin: 0; font-size: 14px;">%s</h4><p>%s</p></div></td></tr>',
			$wp_list_table->get_column_count(),
			$plugin['Name'],
			jsps_get_major_upgrade_notice()
		);
	}
}
add_action( 'after_plugin_row', 'jsps_ms_plugin_update_message', 10, 3 );

function jsps_admin_notice_after_update() {
	$screen = get_current_screen();

	// If you want to reset Nobs user options.
	// jsps_update_user_options(array());

	// If user doesn't has manage option rights
	if ( ! current_user_can('manage_options') ) {
		return;
	}

	// If we are on one of our plugin screens.
	if ( $screen->base === 'settings_page_' . JUIZ_SPS_SLUG || $screen->base === 'settings_page_' . JUIZ_SPS_SLUG . '-welcome' ) {
		return;
	}

	// If user asked to hide it.
	$user_options = jsps_get_user_options( 'notice-upgrade-2.0.0' );
	$user_removed_it = $user_options === false || $user_options === null ? false : true;

	if ( $user_removed_it ) {
		return;
	}

	$removal_action_name = 'juiz_sps_notice_removal';
	$removal_nonce = wp_create_nonce( $removal_action_name );
	?>
	<div class="notice notice-success is-dismissible juiz-sps-notice" data-notice="upgrade-2.0.0" data-nonce="<?php echo $removal_nonce; ?>">
		<div class="jsps-notice-header">
			<h1>
				<img src="<?php echo JUIZ_SPS_PLUGIN_ASSETS . 'admin/nobs-logo-light.svg' ?>" width="249" height="48" alt="Nobs • Share Buttons">
			</h1>
			<p>
				<?php _e( 'Congratulations! Your sharing buttons are now in version 2.0', 'juiz-social-post-sharer' ); ?>
			</p>
		</div>
		<div class="jsps-notice-content">
			<div class="jsps-col">
				<p class="jsps-icon">
					<svg width="58" height="58" viewBox="0 0 120 120" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M99.5999 58.6H20.4C19.7376 58.6 19.2 58.0624 19.2 57.4V51.4C19.2 50.7376 19.7376 50.2 20.4 50.2H99.5999C100.262 50.2 100.8 50.7376 100.8 51.4V57.4C100.8 58.0624 100.262 58.6 99.5999 58.6Z" fill="#E3E8ED"></path>
						<path d="M99.6 59.8H20.4C19.0764 59.8 18 58.7236 18 57.4V51.4C18 50.0764 19.0764 49 20.4 49H99.6C100.924 49 102 50.0764 102 51.4V57.4C102 58.7236 100.924 59.8 99.6 59.8ZM20.4 51.4V57.4H99.6012L99.6 51.4H20.4Z" fill="#103744"></path>
						<path d="M99.5999 94.6H20.4C19.7376 94.6 19.2 94.0624 19.2 93.4V87.4C19.2 86.7376 19.7376 86.2 20.4 86.2H99.5999C100.262 86.2 100.8 86.7376 100.8 87.4V93.4C100.8 94.0624 100.262 94.6 99.5999 94.6Z" fill="#E3E8ED"></path>
						<path d="M99.6 95.8H20.4C19.0764 95.8 18 94.7236 18 93.4V87.4C18 86.0764 19.0764 85 20.4 85H99.6C100.924 85 102 86.0764 102 87.4V93.4C102 94.7236 100.924 95.8 99.6 95.8ZM20.4 87.4V93.4H99.6012L99.6 87.4H20.4Z" fill="#103744"></path>
						<path d="M99.5999 76.6H20.4C19.7376 76.6 19.2 76.0624 19.2 75.4V69.4C19.2 68.7376 19.7376 68.2 20.4 68.2H99.5999C100.262 68.2 100.8 68.7376 100.8 69.4V75.4C100.8 76.0624 100.262 76.6 99.5999 76.6Z" fill="#FEF6AA"></path>
						<path d="M99.6 77.8H20.4C19.0764 77.8 18 76.7236 18 75.4V69.4C18 68.0764 19.0764 67 20.4 67H99.6C100.924 67 102 68.0764 102 69.4V75.4C102 76.7236 100.924 77.8 99.6 77.8ZM20.4 69.4V75.4H99.6012L99.6 69.4H20.4Z" fill="#103744"></path>
						<path d="M100.06 34.9569L21.9629 48.1262C21.3097 48.2363 20.6902 47.7956 20.58 47.1424L19.5823 41.226C19.4722 40.5728 19.9129 39.9533 20.5661 39.8431L98.6635 26.6738C99.3167 26.5637 99.9362 27.0044 100.046 27.6576L101.044 33.574C101.154 34.2272 100.713 34.8467 100.06 34.9569Z" fill="#FEF6AA"></path>
						<path d="M100.26 36.1401L22.1624 49.3095C20.8572 49.5296 19.6168 48.6471 19.3967 47.342L18.3991 41.4255C18.179 40.1203 19.0614 38.8799 20.3666 38.6598L98.464 25.4905C99.7692 25.2704 101.01 26.1528 101.23 27.458L102.227 33.3745C102.447 34.6797 101.565 35.9201 100.26 36.1401ZM20.7657 41.0264L21.7633 46.9429L99.862 33.7734L98.8631 27.8571L20.7657 41.0264Z" fill="#103744"></path>
						<path d="M55.0686 39.7503L59.2821 54.9831L59.4941 55.7495L62.6405 67.1247C59.9487 67.8416 51.7935 62.6731 48.4968 64.5924C46.8149 65.5714 45.3363 67.473 45.9543 69.2695C46.5464 70.9909 67.3474 79.5765 68.6704 82.6714L72.4077 96.1827L101.328 88.1832L97.7095 75.1026L97.5613 74.5667L97.2998 73.6212L90.7838 50.0643C90.1512 47.7772 87.7516 46.3931 85.4674 47.0362C83.2764 47.6535 81.7981 48.8433 82.3789 50.9432L81.6602 48.4447C81.1122 46.4637 79.0427 45.291 77.0616 45.8389C75.0806 46.3869 73.9079 48.4564 74.4559 50.4374L74.1357 49.2798C73.6197 47.4145 71.8744 46.0414 69.9494 46.2418C67.9706 46.4475 66.6279 48.0963 66.5395 49.9558L63.1864 37.8335C62.6269 35.8107 60.514 34.6128 58.4905 35.1725L57.6815 35.3963C57.6815 35.3963 54.0352 36.4049 55.0686 39.7503Z" fill="white"></path>
						<path d="M101.55 88.9866L72.6299 96.986C72.1865 97.1086 71.7273 96.8491 71.6044 96.4048L67.8846 82.9571C67.1326 81.4545 59.548 77.645 54.5126 75.1169C47.3379 71.514 45.4896 70.4816 45.1661 69.5402C44.3837 67.2651 46.1269 65.0067 48.0777 63.8712C50.311 62.572 53.8837 63.8392 57.3379 65.0656C58.8234 65.593 60.4594 66.1739 61.5551 66.324L54.2692 39.9835C53.9135 38.8228 53.9907 37.7637 54.4992 36.8352C55.4062 35.1773 57.3773 34.6156 57.4609 34.5925L58.2698 34.3687C60.7409 33.6852 63.3076 35.139 63.9911 37.61L66.6549 47.2404C67.4053 46.2329 68.5444 45.5486 69.8643 45.4118C71.4692 45.2455 73.0377 45.992 74.0387 47.2692C74.6102 46.2117 75.594 45.3792 76.8408 45.0343C79.1263 44.4022 81.4939 45.6299 82.326 47.8004C82.9073 47.1882 83.8267 46.6321 85.242 46.2337C85.25 46.2315 85.258 46.2293 85.2661 46.227C86.5667 45.8673 87.9381 46.0388 89.1307 46.7112C90.3467 47.3962 91.2188 48.5075 91.5877 49.8411L102.132 87.96C102.254 88.4045 101.993 88.8639 101.55 88.9866ZM72.9888 95.1571L100.302 87.6021L89.9804 50.2865C89.7307 49.3835 89.1382 48.6299 88.3125 48.1647C87.5063 47.7106 86.5823 47.5934 85.7099 47.8347C85.7051 47.8361 85.6995 47.8376 85.6938 47.8392C82.6243 48.7038 83.0298 50.1699 83.1823 50.721C83.3047 51.1636 83.0463 51.6208 82.6051 51.7454C82.6043 51.7456 82.6027 51.7461 82.6011 51.7465C82.1609 51.8683 81.7046 51.6131 81.5778 51.1734L80.859 48.6749C80.43 47.1237 78.827 46.2154 77.2838 46.6422C75.7406 47.0691 74.8323 48.672 75.2592 50.2152C75.3821 50.6595 75.1215 51.1181 74.6781 51.2408C74.2346 51.3634 73.7754 51.1039 73.6525 50.6596L73.3323 49.502C72.9073 47.9653 71.4898 46.9209 70.0354 47.0716C68.5613 47.2199 67.4449 48.4549 67.372 49.9953C67.3528 50.4045 67.0405 50.7417 66.6321 50.7846C66.2254 50.8305 65.8455 50.5732 65.7364 50.1788L62.3828 38.0549C61.9444 36.4699 60.2984 35.5372 58.7127 35.9759L57.9037 36.1996C57.8933 36.2025 56.5181 36.6054 55.9559 37.643C55.6703 38.1708 55.6406 38.7792 55.8647 39.505C55.8669 39.5131 55.8692 39.5211 55.8712 39.5283L63.4428 66.9019C63.5022 67.1164 63.4737 67.3448 63.363 67.5388C63.2522 67.7321 63.0492 67.8643 62.8545 67.9294C61.4633 68.2995 59.293 67.5283 56.7797 66.6366C53.9738 65.6407 50.4847 64.4006 48.9161 65.311C47.5145 66.1276 46.3261 67.6247 46.7218 68.9335C47.331 69.6445 51.7228 71.8499 55.2617 73.6263C63.2993 77.6633 68.6287 80.4509 69.4371 82.3417C69.4517 82.3757 69.4641 82.4112 69.4741 82.4474L72.9896 95.1569L72.9888 95.1571Z" fill="#103744"></path>
						<path d="M96.666 74.3378L100.35 87.6547L72.8876 95.2508L69.2041 81.9339L96.666 74.3378Z" fill="#20A0C9"></path>
						<path d="M100.863 87.9461L72.5981 95.7642L68.6924 81.644L96.9576 73.8257L100.863 87.9458L100.863 87.9461ZM73.1792 94.7386L99.8378 87.3647L96.3765 74.8512L69.7179 82.2251L73.1792 94.7386Z" fill="#103744"></path>
						<path d="M90.7218 76.4153L69.0318 82.4149C68.8101 82.4762 68.5804 82.346 68.5191 82.1243C68.4577 81.9026 68.5879 81.6729 68.8096 81.6115L90.4996 75.612C90.7213 75.5506 90.9511 75.6808 91.0124 75.9025C91.0737 76.1243 90.9435 76.354 90.7218 76.4153ZM72.5186 76.2616C72.2969 76.323 72.0672 76.1928 72.0058 75.9711L67.5617 59.9044C67.5004 59.6827 67.6306 59.453 67.8523 59.3917C68.074 59.3303 68.3037 59.4605 68.365 59.6822L72.8092 75.7489C72.8705 75.9706 72.7403 76.2003 72.5186 76.2616ZM79.4409 70.0229C79.2192 70.0842 78.9895 69.9541 78.9281 69.7324L75.595 57.6824C75.5337 57.4606 75.6639 57.2309 75.8856 57.1696C76.1073 57.1083 76.337 57.2384 76.3984 57.4602L79.7315 69.5102C79.7928 69.7319 79.6626 69.9616 79.4409 70.0229ZM86.3632 63.7842C86.1415 63.8455 85.9118 63.7154 85.8504 63.4936L83.6284 55.4603C83.567 55.2386 83.6972 55.0089 83.9189 54.9475C84.1407 54.8862 84.3704 55.0164 84.4317 55.2381L86.6538 63.2714C86.7151 63.4931 86.5849 63.7229 86.3632 63.7842ZM93.4331 75.6654L91.8264 76.1098C91.6047 76.1711 91.375 76.0409 91.3136 75.8192C91.2523 75.5975 91.3825 75.3678 91.6042 75.3064L93.2109 74.862C93.4326 74.8007 93.6623 74.9309 93.7236 75.1526C93.785 75.3743 93.6548 75.604 93.4331 75.6654ZM94.7385 75.3043C94.6823 75.3198 94.6318 75.3251 94.577 75.3144C94.5241 75.3108 94.467 75.292 94.424 75.2615C94.3237 75.2115 94.2546 75.1181 94.2257 75.0137C94.1968 74.9093 94.2081 74.7937 94.2682 74.6984C94.3708 74.5066 94.6359 74.4333 94.8306 74.5429C94.9311 74.5938 95.0002 74.6871 95.0291 74.7915C95.0579 74.8959 95.0467 75.0115 94.9863 75.106C94.9354 75.2066 94.8502 75.2734 94.7385 75.3043ZM80.2464 72.935C80.0247 72.9963 79.795 72.8662 79.7336 72.6444L79.2892 71.0378C79.2279 70.816 79.3581 70.5863 79.5798 70.525C79.8015 70.4637 80.0312 70.5938 80.0926 70.8156L80.537 72.4222C80.5983 72.6439 80.4681 72.8737 80.2464 72.935ZM80.7741 74.8429C80.5524 74.9042 80.3227 74.7741 80.2614 74.5524L80.0392 73.749C79.9778 73.5273 80.108 73.2976 80.3297 73.2362C80.5514 73.1749 80.7812 73.3051 80.8425 73.5268L81.0647 74.3301C81.126 74.5519 80.9959 74.7816 80.7741 74.8429Z" fill="#103744"></path>
						<path d="M93.149 80.5003C92.6163 80.6477 92.164 81.0006 91.8916 81.4814C91.6191 81.9622 91.5488 82.5315 91.6961 83.0642C91.8435 83.5968 92.1964 84.0491 92.6772 84.3216C93.158 84.594 93.7273 84.6643 94.26 84.517C94.7926 84.3697 95.2449 84.0168 95.5174 83.536C95.7898 83.0551 95.8601 82.4858 95.7128 81.9531C95.5655 81.4205 95.2126 80.9682 94.7318 80.6958C94.251 80.4233 93.6816 80.353 93.149 80.5003V80.5003Z" fill="#0073AA"></path>
						<path d="M94.3709 84.9186C93.0422 85.2862 91.6618 84.504 91.2943 83.1753C90.9268 81.8466 91.709 80.4662 93.0377 80.0986C94.3664 79.7311 95.7468 80.5133 96.1143 81.842C96.4818 83.1707 95.6996 84.5511 94.3709 84.9186ZM93.2599 80.902C92.3738 81.1471 91.8526 82.067 92.0977 82.9531C92.3427 83.8391 93.2627 84.3604 94.1487 84.1153C95.0348 83.8702 95.5561 82.9503 95.311 82.0642C95.0659 81.1782 94.146 80.6569 93.2599 80.902ZM57.6649 31.9416C57.4432 32.0029 57.2135 31.8728 57.1521 31.651L55.3005 24.9569C55.2392 24.7352 55.3693 24.5054 55.5911 24.4441C55.8128 24.3828 56.0425 24.513 56.1038 24.7347L57.9555 31.4288C58.0168 31.6506 57.8866 31.8803 57.6649 31.9416ZM73.2792 34.541L67.0533 36.2631C66.8316 36.3244 66.6019 36.1942 66.5406 35.9725C66.4792 35.7508 66.6094 35.5211 66.8311 35.4598L73.0569 33.7377C73.2787 33.6763 73.5084 33.8065 73.5697 34.0282C73.631 34.2499 73.5009 34.4797 73.2792 34.541ZM51.0076 40.7014L44.7817 42.4235C44.56 42.4849 44.3303 42.3547 44.269 42.133C44.2076 41.9113 44.3378 41.6815 44.5595 41.6202L50.7854 39.8981C51.0071 39.8368 51.2368 39.9669 51.2981 40.1887C51.3594 40.4104 51.2293 40.6401 51.0076 40.7014ZM62.9915 32.8309C62.8855 32.8602 62.7679 32.8477 62.6663 32.7868C62.4692 32.6683 62.4044 32.4121 62.5237 32.2148L65.6301 27.0316C65.749 26.8361 66.0038 26.7691 66.2021 26.8889C66.3992 27.0074 66.464 27.2636 66.3447 27.4609L63.2383 32.6441C63.1806 32.7388 63.0912 32.8033 62.9915 32.8309ZM52.1819 35.8209C52.0823 35.8484 51.9725 35.839 51.8741 35.7867L46.5456 32.9366C46.3427 32.8284 46.2658 32.5755 46.374 32.3726C46.4838 32.1693 46.7363 32.0943 46.938 32.2011L52.2665 35.0511C52.4694 35.1593 52.5462 35.4122 52.438 35.6151C52.3824 35.7204 52.2879 35.7915 52.1819 35.8209Z" fill="#103744"></path>
					</svg>
				</p>

				<p class="jsps-h2" role="heading" aria-level="2">
					<?php _e( 'New Settings', 'juiz-social-post-sharer' ); ?>
				</p>

				<p>
					<?php _e( 'You can now re-order your buttons and enjoy the new admin interface.', 'juiz-social-post-sharer' ); ?>
				</p>

				<p>
					<a href="<?php echo jsps_get_settings_url(); ?>" class="button jsps-button"><?php _e( 'See Settings Page', 'juiz-social-post-sharer' ); ?></a>
				</p>
			</div>

			<div class="jsps-col">
				<p class="jsps-icon">
					<svg width="58" height="58" viewBox="0 0 58 59" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M28.9999 10.62C18.7513 10.62 10.4399 19.0747 10.4399 29.5C10.4399 39.9253 18.7513 48.38 28.9999 48.38C39.2485 48.38 47.5599 39.9253 47.5599 29.5C47.5599 19.0747 39.2485 10.62 28.9999 10.62ZM28.9999 40.71C22.9157 40.71 17.9799 35.6891 17.9799 29.5C17.9799 23.3109 22.9157 18.29 28.9999 18.29C35.0841 18.29 40.0199 23.3109 40.0199 29.5C40.0199 35.6891 35.0841 40.71 28.9999 40.71Z" fill="#20A0C9"/>
						<path d="M49.3 29.5C49.3 30.8098 49.1782 32.1196 48.9404 33.3881C48.9114 33.5297 48.7954 33.63 48.6562 33.63H38.3786C38.28 33.63 38.1872 33.5828 38.135 33.5002C38.0828 33.4117 38.0712 33.3114 38.1118 33.217C38.6106 32.0429 38.86 30.7921 38.86 29.5C38.86 28.2079 38.6106 26.9571 38.1118 25.783C38.0712 25.6886 38.0828 25.5883 38.135 25.4998C38.1872 25.4172 38.28 25.37 38.3786 25.37H48.6562C48.7954 25.37 48.9114 25.4703 48.9404 25.6119C49.1782 26.8863 49.3 28.1902 49.3 29.5ZM8.69995 29.5C8.69995 30.8098 8.82175 32.1196 9.05955 33.3881C9.08855 33.5297 9.20455 33.63 9.34375 33.63H19.6214C19.72 33.63 19.8128 33.5828 19.865 33.5002C19.9172 33.4117 19.9288 33.3114 19.8882 33.217C19.3894 32.0429 19.14 30.7921 19.14 29.5C19.14 28.2079 19.3894 26.9571 19.8882 25.783C19.9288 25.6886 19.9172 25.5883 19.865 25.4998C19.8128 25.4172 19.72 25.37 19.6214 25.37H9.34375C9.20455 25.37 9.08855 25.4703 9.05955 25.6119C8.82175 26.8863 8.69995 28.1902 8.69995 29.5ZM29 8.85C30.2876 8.85 31.5752 8.9739 32.8222 9.2158C32.9614 9.2453 33.06 9.3633 33.06 9.5049V19.9597C33.06 20.06 33.0136 20.1544 32.9324 20.2075C32.8454 20.2606 32.7468 20.2724 32.654 20.2311C31.4998 19.7237 30.2702 19.47 29 19.47C27.7298 19.47 26.5002 19.7237 25.346 20.2311C25.2532 20.2724 25.1546 20.2606 25.0676 20.2075C24.9864 20.1544 24.94 20.06 24.94 19.9597V9.5049C24.94 9.3633 25.0386 9.2453 25.1778 9.2158C26.4306 8.9739 27.7124 8.85 29 8.85ZM29 50.15C30.2876 50.15 31.5752 50.0261 32.8222 49.7842C32.9614 49.7547 33.06 49.6367 33.06 49.4951V39.0403C33.06 38.94 33.0136 38.8456 32.9324 38.7925C32.8454 38.7394 32.7468 38.7276 32.654 38.7689C31.4998 39.2763 30.2702 39.53 29 39.53C27.7298 39.53 26.5002 39.2763 25.346 38.7689C25.2532 38.7276 25.1546 38.7394 25.0676 38.7925C24.9864 38.8456 24.94 38.94 24.94 39.0403V49.4951C24.94 49.6367 25.0386 49.7547 25.1778 49.7842C26.4306 50.0261 27.7124 50.15 29 50.15Z" fill="#FEF6AA"/>
						<path d="M48.9404 25.6095C48.9143 25.4709 48.7948 25.37 48.6556 25.37H47.6992C47.5588 24.7133 47.3831 24.0714 47.1795 23.4413C47.2282 23.4124 47.2694 23.3699 47.2949 23.3144C47.3227 23.2537 50.0197 17.2168 45.5474 12.6673C41.075 8.11781 35.141 10.8613 35.0807 10.8896C35.0262 10.9156 34.9879 10.9593 34.9595 11.0082C34.3389 10.8005 33.7067 10.6212 33.06 10.4784V9.5055C33.06 9.3639 32.9608 9.24236 32.8245 9.21581C32.4359 9.14029 32.0432 9.07716 31.6477 9.02406C31.4911 9.00577 31.3437 9.11669 31.3223 9.27894C31.302 9.44001 31.4133 9.5881 31.5728 9.60993C31.8773 9.65005 32.1801 9.69725 32.48 9.75153V12.685C32.48 12.8478 32.6099 12.98 32.77 12.98C32.93 12.98 33.06 12.8478 33.06 12.685V11.6914C39.7137 13.2591 44.9656 18.6015 46.5067 25.37H43.21C43.0499 25.37 42.92 25.5022 42.92 25.665C42.92 25.8278 43.0499 25.96 43.21 25.96H48.4143C48.6167 27.1217 48.72 28.3112 48.72 29.5C48.72 30.6894 48.6167 31.8789 48.4143 33.04H38.8083C39.2277 31.9119 39.44 30.7225 39.44 29.5C39.44 28.2775 39.2277 27.0887 38.8083 25.96H41.47C41.63 25.96 41.76 25.8278 41.76 25.665C41.76 25.5022 41.63 25.37 41.47 25.37H39.8587C38.6894 22.1811 36.1949 19.6435 33.06 18.454V14.455C33.06 14.2922 32.93 14.16 32.77 14.16C32.6099 14.16 32.48 14.2922 32.48 14.455V19.5225C30.262 18.67 27.739 18.67 25.52 19.5225V9.75094C26.9421 9.4937 28.4159 9.39457 29.8578 9.45888C30.0068 9.45888 30.153 9.33912 30.16 9.17628C30.1669 9.01403 30.0428 8.87596 29.8821 8.86888C28.319 8.80162 26.7153 8.91727 25.1754 9.21581C25.0386 9.24236 24.94 9.3639 24.94 9.5055V10.4784C24.2933 10.6212 23.6611 10.8005 23.0405 11.0082C23.012 10.9593 22.9738 10.9156 22.9187 10.8896C22.8595 10.8613 16.9249 8.11722 12.4526 12.6673C7.98017 17.2168 10.6772 23.2537 10.705 23.3144C10.7305 23.3705 10.7723 23.4124 10.8204 23.4413C10.6169 24.0714 10.4411 24.7133 10.3008 25.37H9.34433C9.20513 25.37 9.08565 25.4709 9.05955 25.6095C8.82059 26.8834 8.69995 28.192 8.69995 29.5C8.69995 30.808 8.82059 32.1167 9.05955 33.3905C9.08565 33.5291 9.20513 33.63 9.34433 33.63H10.3008C10.4411 34.2879 10.618 34.9315 10.8216 35.5628C10.7735 35.5918 10.7305 35.6307 10.705 35.6862C10.6772 35.7469 7.97959 41.7838 12.4526 46.3333C14.475 48.3906 16.7962 48.9564 18.738 48.9564C21.0905 48.9564 22.8862 48.1263 22.9187 48.1104C22.9732 48.0844 23.0115 48.0408 23.0405 47.9918C23.6611 48.1995 24.2933 48.3788 24.94 48.5216V49.4945C24.94 49.6361 25.0386 49.7577 25.1754 49.7842C26.4271 50.0267 27.7141 50.15 29 50.15C29.2958 50.15 29.5904 50.1435 29.8821 50.1311C30.0422 50.1235 30.1663 49.986 30.16 49.8237C30.1524 49.6615 30.0057 49.5376 29.8578 49.5411C28.4159 49.6054 26.9427 49.5057 25.52 49.2491V39.4775C27.739 40.33 30.262 40.33 32.48 39.4775V49.2491C32.1795 49.3034 31.8773 49.3506 31.5728 49.3907C31.4139 49.4119 31.302 49.56 31.3223 49.7217C31.3432 49.8833 31.4905 50.0001 31.6477 49.9765C32.0438 49.9234 32.4359 49.8603 32.8245 49.7848C32.9608 49.7577 33.06 49.6361 33.06 49.4945V48.5216C33.7067 48.3788 34.3389 48.1995 34.9595 47.9918C34.9879 48.0408 35.0262 48.0844 35.0807 48.1104C35.1137 48.1257 36.9083 48.9564 39.2613 48.9564C41.2032 48.9564 43.5255 48.39 45.5474 46.3333C50.0197 41.7838 47.3227 35.7469 47.2949 35.6862C47.2694 35.6307 47.2259 35.5918 47.1783 35.5628C47.3825 34.9315 47.5588 34.2879 47.6992 33.63H48.6556C48.7948 33.63 48.9143 33.5291 48.9404 33.3905C49.1787 32.1172 49.3 30.8086 49.3 29.5C49.3 28.192 49.1787 26.8834 48.9404 25.6095ZM35.7088 11.2702C37.0399 10.7775 41.5894 9.47541 45.1373 13.0844C48.6857 16.6941 47.4057 21.322 46.9214 22.6761C44.9813 17.4203 40.8755 13.2437 35.7088 11.2702ZM12.8626 13.0844C16.4105 9.47599 20.96 10.7775 22.2911 11.2702C17.125 13.2437 13.0192 17.4203 11.0791 22.6761C10.5942 21.322 9.31417 16.6941 12.8626 13.0844ZM24.94 11.6914V18.4534C21.8051 19.6435 19.3105 22.1811 18.1412 25.37H11.4932C13.0343 18.6015 18.2862 13.2591 24.94 11.6914ZM12.8626 45.9156C9.31475 42.306 10.5942 37.678 11.0785 36.3239C13.0186 41.5797 17.1245 45.7563 22.2911 47.7298C20.9612 48.2237 16.4111 49.5258 12.8626 45.9156ZM11.4932 33.63H13.05C13.21 33.63 13.34 33.4978 13.34 33.335C13.34 33.1722 13.21 33.04 13.05 33.04H9.58619C9.38261 31.8783 9.27995 30.6889 9.27995 29.5C9.27995 28.3112 9.38261 27.1217 9.58619 25.96H19.1922C18.7722 27.0893 18.56 28.2787 18.56 29.5C18.56 30.7219 18.7722 31.9107 19.1916 33.04H17.11C16.9499 33.04 16.82 33.1722 16.82 33.335C16.82 33.4978 16.9499 33.63 17.11 33.63H18.1412C19.3111 36.819 21.8051 39.3565 24.94 40.546V47.308C18.2862 45.7409 13.0343 40.3985 11.4932 33.63ZM25.3442 38.7695C25.2537 38.73 25.1511 38.7394 25.0705 38.7937C24.9887 38.8486 24.94 38.9412 24.94 39.0403V39.2675C22.4454 38.1907 20.4513 36.1629 19.3981 33.63H19.6214C19.7188 33.63 19.8099 33.5804 19.8632 33.4973C19.9166 33.4141 19.9259 33.3096 19.8876 33.2182C19.3917 32.0423 19.14 30.7909 19.14 29.5C19.14 28.2091 19.3917 26.9583 19.8876 25.7812C19.9259 25.6904 19.9166 25.5854 19.8632 25.5022C19.8093 25.4196 19.7188 25.37 19.6214 25.37H19.3981C20.4519 22.8371 22.4454 20.8093 24.94 19.7326V19.9597C24.94 20.0588 24.9887 20.1515 25.0705 20.2063C25.1522 20.2606 25.2543 20.27 25.3442 20.2305C27.6555 19.221 30.3444 19.221 32.6551 20.2305C32.6917 20.2464 32.7305 20.2547 32.7694 20.2547C32.8256 20.2547 32.8807 20.2382 32.9289 20.2063C33.0107 20.1515 33.06 20.0588 33.06 19.9597V19.7326C35.5493 20.8093 37.5428 22.8371 38.6013 25.3694H38.3786C38.2811 25.3694 38.1901 25.4196 38.1361 25.5022C38.0828 25.5854 38.0741 25.6898 38.1123 25.7812C38.6082 26.9571 38.86 28.2091 38.86 29.5C38.86 30.7915 38.6082 32.0435 38.1123 33.2188C38.0741 33.3096 38.0828 33.4147 38.1361 33.4978C38.1901 33.5799 38.2811 33.63 38.3786 33.63H38.6013C37.5428 36.1623 35.5493 38.1901 33.06 39.2669V39.0403C33.06 38.9412 33.0107 38.8486 32.9295 38.7937C32.8477 38.7394 32.7444 38.7306 32.6551 38.7695C30.3444 39.779 27.6561 39.779 25.3442 38.7695ZM45.1373 45.9156C41.5906 49.524 37.0399 48.2231 35.7088 47.7298C40.8755 45.7563 44.9813 41.5797 46.9214 36.3239C47.4063 37.678 48.6857 42.306 45.1373 45.9156ZM33.06 47.3086V40.546C36.1949 39.356 38.6894 36.819 39.8587 33.63H46.5061C44.9656 40.3985 39.7137 45.7409 33.06 47.3086Z" fill="#103744"/>
						<path d="M15.95 33.04H14.79C14.6299 33.04 14.5 33.1722 14.5 33.335C14.5 33.4978 14.6299 33.63 14.79 33.63H15.95C16.1101 33.63 16.24 33.4978 16.24 33.335C16.24 33.1722 16.1101 33.04 15.95 33.04Z" fill="#103744"/>
					</svg>
				</p>

				<p class="jsps-h2" role="heading" aria-level="2">
					<?php _e( 'Documentation', 'juiz-social-post-sharer' ); ?>
				</p>

				<p>
					<?php
					printf(
						__( 'You are a developer or you have questions, visit the %sFAQ%s or doc. ', 'juiz-social-post-sharer' ),
						'<a href="' . jsps_get_public_website(
								'faq.html',
								array(
									'source'   => 'wp-plugin',
									'medium'   => 'notice',
									'campaign' => 'upgrade'
								)
							) . '">',
						'</a>'
					);
					?>
				</p>

				<p>
					<a href="<?php echo jsps_get_public_website( 'doc/', array('source' => 'wp-plugin', 'medium' => 'notice', 'campaign' => 'upgrade' ) ); ?>" class="button jsps-button"><?php _e( 'See the doc.', 'juiz-social-post-sharer' ); ?></a>
				</p>
			</div>

			<div class="jsps-col">
				<p class="jsps-icon">
					<svg width="58" height="58" viewBox="0 0 120 120" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M60.6 91.2C55.4268 91.2 54.0852 87.354 54.03 87.1896C53.9256 86.8752 54.096 86.5356 54.4092 86.43C54.7248 86.3256 55.062 86.4948 55.1676 86.8068C55.2132 86.9376 56.3172 90 60.6 90C64.9176 90 66.0204 86.8416 66.03 86.8104C66.1368 86.496 66.4764 86.3268 66.7896 86.4312C67.104 86.5368 67.2732 86.8764 67.1688 87.1908C67.1148 87.354 65.7732 91.2 60.6 91.2Z" fill="#103744"></path>
						<path d="M20.4 30H18C15.3492 30 13.2 32.1492 13.2 34.8V87.6C13.2 90.2508 15.3492 92.4 18 92.4H54C54 92.4 55.2 96 60.6 96C66 96 67.2 92.4 67.2 92.4H103.2C105.851 92.4 108 90.2508 108 87.6V34.8C108 32.1492 105.851 30 103.2 30H100.8H20.4Z" fill="#20A0C9"></path>
						<path d="M102.6 33V87H18.6001V33L24.6001 23.4C51.0001 23.4 60.6001 30.6 60.6001 30.6C60.6001 30.6 70.2001 23.4 96.6001 23.4L102.6 33Z" fill="#CEEEF9"></path>
						<path d="M18.6001 87H60.6001C60.6001 87 51.0001 79.8 24.6001 79.8L18.6001 87Z" fill="#CEEEF9"></path>
						<path d="M24.6001 23.4C51.0001 23.4 60.6001 30.6 60.6001 30.6C60.6001 30.6 70.2001 23.4 96.6001 23.4V79.8C70.2001 79.8 60.6001 87 60.6001 87C60.6001 87 51.0001 79.8 24.6001 79.8V23.4Z" fill="white"></path>
						<path d="M102.6 87.6H60.6001C60.3421 87.6 60.1129 87.4344 60.0301 87.1896C59.9497 86.9448 60.0325 86.6748 60.2401 86.5188C60.6385 86.22 70.3021 79.1988 96.6001 79.1988C96.7777 79.1988 96.9469 79.2768 97.0609 79.4148L103.061 86.6148C103.211 86.7936 103.242 87.042 103.144 87.2532C103.044 87.4656 102.833 87.6 102.6 87.6Z" fill="#CEEEF9"></path>
						<path d="M24.1388 79.4233L18.1333 86.6183L19.0546 87.3872L25.0601 80.1922L24.1388 79.4233Z" fill="#103744"></path>
						<path d="M103.2 28.8H99.9744L101.474 31.2H103.2C105.185 31.2 106.8 32.8152 106.8 34.8V87.6C106.8 89.5848 105.185 91.2 103.2 91.2H67.2C66.6948 91.2 66.2388 91.5312 66.0672 92.0064C66.0252 92.1204 64.9992 94.8 60.6 94.8C56.2008 94.8 55.1748 92.1204 55.1376 92.0208C54.9756 91.53 54.5172 91.2 54 91.2H18C16.0152 91.2 14.4 89.5848 14.4 87.6V34.8C14.4 32.8152 16.0152 31.2 18 31.2H19.7244L21.2244 28.8H18C14.6916 28.8 12 31.4916 12 34.8V87.6C12 90.9084 14.6916 93.6 18 93.6H53.2572C54.0144 94.8804 56.0196 97.2 60.6 97.2C65.1804 97.2 67.1856 94.8804 67.9428 93.6H103.2C106.508 93.6 109.2 90.9084 109.2 87.6V34.8C109.2 31.4916 106.508 28.8 103.2 28.8Z" fill="#103744"></path>
						<path d="M60.5988 87.6C60.474 87.6 60.348 87.5616 60.2412 87.48C60.1452 87.4104 50.4288 80.4 24.6 80.4C24.2688 80.4 24 80.1312 24 79.8V23.4C24 23.0688 24.2688 22.8 24.6 22.8C48.4416 22.8 58.6116 28.572 60.6 29.8716C62.5884 28.572 72.7584 22.8 96.6 22.8C96.9312 22.8 97.2 23.0688 97.2 23.4V79.8C97.2 80.1312 96.9312 80.4 96.6 80.4C83.0436 80.4 74.0484 82.3428 68.8884 83.9724C68.5752 84.0744 68.2356 83.8968 68.136 83.5812C68.0364 83.2656 68.2116 82.9284 68.5272 82.8288C73.6908 81.198 82.6236 79.2576 96 79.2024V24.0024C70.6188 24.108 61.0536 31.0104 60.9588 31.08C60.7476 31.2396 60.4524 31.2396 60.2412 31.08C60.1464 31.0092 50.5812 24.1068 25.2 24.0012V79.2012C51.0456 79.3068 60.5652 86.2236 60.96 86.52C61.2252 86.7192 61.2792 87.0948 61.0812 87.3588C60.9624 87.5172 60.7812 87.6 60.5988 87.6Z" fill="#103744"></path>
						<path d="M102.6 87.6H18.6C18.2688 87.6 18 87.3312 18 87V33C18 32.8872 18.0312 32.7768 18.0912 32.682L24.0912 23.082L25.1088 23.7168L19.2 33.1728V86.4H102V33.1728L96.0912 23.718L97.1088 23.0832L103.109 32.6832C103.169 32.7768 103.2 32.8872 103.2 33V87C103.2 87.3312 102.931 87.6 102.6 87.6Z" fill="#103744"></path>
						<path d="M97.0591 79.4128L96.1372 80.181L102.137 87.3806L103.059 86.6124L97.0591 79.4128Z" fill="#103744"></path>
						<path d="M51.3083 34.3308C51.2519 34.3308 51.1943 34.3224 51.1367 34.3056C49.9895 33.9648 48.7896 33.6444 47.568 33.3528C47.2452 33.276 47.0472 32.952 47.124 32.6292C47.2008 32.3064 47.5284 32.1108 47.8476 32.1852C49.0896 32.4816 50.3111 32.808 51.4787 33.1548C51.7967 33.2496 51.9779 33.5832 51.8831 33.9012C51.8063 34.1616 51.5675 34.3308 51.3083 34.3308Z" fill="#103744"></path>
						<path d="M54.9083 35.5188C54.8399 35.5188 54.7703 35.5068 54.7019 35.4828C54.3275 35.346 53.9267 35.2056 53.5139 35.064C53.2007 34.9572 53.0339 34.6152 53.1407 34.302C53.2475 33.9888 53.5907 33.8232 53.9027 33.9288C54.3251 34.074 54.7319 34.2156 55.1147 34.3548C55.4255 34.4688 55.5863 34.8132 55.4723 35.1252C55.3835 35.3688 55.1531 35.5188 54.9083 35.5188Z" fill="#103744"></path>
						<path d="M44.1096 32.6052C44.0736 32.6052 44.0352 32.6016 43.9992 32.5944C40.2624 31.896 36.252 31.4256 32.076 31.2C31.7448 31.182 31.4916 30.8988 31.5084 30.5688C31.5264 30.2376 31.824 29.9604 32.1396 30.0024C36.3672 30.2316 40.4316 30.7068 44.2176 31.416C44.5428 31.4772 44.7588 31.7904 44.6976 32.1156C44.6448 32.4036 44.3928 32.6052 44.1096 32.6052Z" fill="#103744"></path>
						<path d="M51.3083 42.7308C51.2519 42.7308 51.1943 42.7224 51.1367 42.7056C49.9895 42.3648 48.7896 42.0444 47.568 41.7528C47.2452 41.676 47.0472 41.352 47.124 41.0292C47.2008 40.7064 47.5284 40.512 47.8476 40.5852C49.0896 40.8816 50.3111 41.208 51.4787 41.5548C51.7967 41.6496 51.9779 41.9832 51.8831 42.3012C51.8063 42.5616 51.5675 42.7308 51.3083 42.7308Z" fill="#103744"></path>
						<path d="M54.9083 43.9188C54.8399 43.9188 54.7703 43.9068 54.7019 43.8828C54.3275 43.746 53.9267 43.6056 53.5139 43.464C53.2007 43.3572 53.0339 43.0152 53.1407 42.702C53.2475 42.3888 53.5907 42.2232 53.9027 42.3288C54.3251 42.474 54.7319 42.6156 55.1147 42.7548C55.4255 42.8688 55.5863 43.2132 55.4723 43.5252C55.3835 43.7688 55.1531 43.9188 54.9083 43.9188Z" fill="#103744"></path>
						<path d="M44.1096 41.0052C44.0736 41.0052 44.0352 41.0016 43.9992 40.9944C40.2624 40.296 36.252 39.8256 32.076 39.6C31.7448 39.582 31.4916 39.2988 31.5084 38.9688C31.5264 38.6376 31.824 38.3724 32.1396 38.4024C36.3672 38.6316 40.4316 39.1068 44.2176 39.816C44.5428 39.8772 44.7588 40.1904 44.6976 40.5156C44.6448 40.8036 44.3928 41.0052 44.1096 41.0052Z" fill="#103744"></path>
						<path d="M51.3083 51.1308C51.2519 51.1308 51.1943 51.1224 51.1367 51.1056C49.9895 50.7648 48.7896 50.4444 47.568 50.1528C47.2452 50.076 47.0472 49.752 47.124 49.4292C47.2008 49.1076 47.5284 48.9096 47.8476 48.9852C49.0896 49.2816 50.3111 49.608 51.4787 49.9548C51.7967 50.0496 51.9779 50.3832 51.8831 50.7012C51.8063 50.9616 51.5675 51.1308 51.3083 51.1308Z" fill="#103744"></path>
						<path d="M54.9083 52.3188C54.8399 52.3188 54.7703 52.3068 54.7019 52.2828C54.3275 52.146 53.9267 52.0056 53.5139 51.864C53.2007 51.7572 53.0339 51.4152 53.1407 51.102C53.2475 50.7888 53.5907 50.6232 53.9027 50.7288C54.3251 50.874 54.7319 51.0156 55.1147 51.1548C55.4255 51.2688 55.5863 51.6132 55.4723 51.9252C55.3835 52.1688 55.1531 52.3188 54.9083 52.3188Z" fill="#103744"></path>
						<path d="M44.1096 49.4052C44.0736 49.4052 44.0352 49.4016 43.9992 49.3944C40.2624 48.696 36.252 48.2256 32.076 48C31.7448 47.982 31.4916 47.6988 31.5084 47.3688C31.5264 47.0376 31.824 46.7688 32.1396 46.8024C36.3672 47.0316 40.4316 47.5068 44.2176 48.216C44.5428 48.2772 44.7588 48.5904 44.6976 48.9156C44.6448 49.2036 44.3928 49.4052 44.1096 49.4052Z" fill="#103744"></path>
						<path d="M51.3083 59.5308C51.2519 59.5308 51.1943 59.5224 51.1367 59.5056C49.9895 59.1648 48.7896 58.8444 47.568 58.5528C47.2452 58.476 47.0472 58.152 47.124 57.8292C47.2008 57.5064 47.5284 57.312 47.8476 57.3852C49.0896 57.6816 50.3111 58.008 51.4787 58.3548C51.7967 58.4496 51.9779 58.7832 51.8831 59.1012C51.8063 59.3616 51.5675 59.5308 51.3083 59.5308Z" fill="#103744"></path>
						<path d="M54.9083 60.7188C54.8399 60.7188 54.7703 60.7068 54.7019 60.6828C54.3275 60.546 53.9267 60.4056 53.5139 60.264C53.2007 60.1572 53.0339 59.8152 53.1407 59.502C53.2475 59.1888 53.5907 59.022 53.9027 59.1288C54.3251 59.274 54.7319 59.4156 55.1147 59.5548C55.4255 59.6688 55.5863 60.0132 55.4723 60.3252C55.3835 60.5688 55.1531 60.7188 54.9083 60.7188Z" fill="#103744"></path>
						<path d="M44.1096 57.8052C44.0736 57.8052 44.0352 57.8016 43.9992 57.7944C40.2624 57.096 36.252 56.6256 32.076 56.4C31.7448 56.382 31.4916 56.0988 31.5084 55.7688C31.5264 55.4376 31.824 55.164 32.1396 55.2024C36.3672 55.4316 40.4316 55.9068 44.2176 56.616C44.5428 56.6772 44.7588 56.9904 44.6976 57.3156C44.6448 57.6036 44.3928 57.8052 44.1096 57.8052Z" fill="#103744"></path>
						<path d="M51.3083 67.9308C51.2519 67.9308 51.1943 67.9224 51.1367 67.9056C49.9895 67.5648 48.7896 67.2444 47.568 66.9528C47.2452 66.876 47.0472 66.552 47.124 66.2292C47.2008 65.9076 47.5284 65.7096 47.8476 65.7852C49.0896 66.0816 50.3111 66.408 51.4787 66.7548C51.7967 66.8496 51.9779 67.1832 51.8831 67.5012C51.8063 67.7616 51.5675 67.9308 51.3083 67.9308Z" fill="#103744"></path>
						<path d="M54.9083 69.1188C54.8399 69.1188 54.7703 69.1068 54.7019 69.0828C54.3275 68.946 53.9267 68.8056 53.5139 68.664C53.2007 68.5572 53.0339 68.2152 53.1407 67.902C53.2475 67.5888 53.5907 67.422 53.9027 67.5288C54.3251 67.674 54.7319 67.8156 55.1147 67.9548C55.4255 68.0688 55.5863 68.4132 55.4723 68.7252C55.3835 68.9688 55.1531 69.1188 54.9083 69.1188Z" fill="#103744"></path>
						<path d="M44.1096 66.2052C44.0736 66.2052 44.0352 66.2016 43.9992 66.1944C40.2624 65.496 36.252 65.0256 32.076 64.8C31.7448 64.782 31.4916 64.4988 31.5084 64.1688C31.5264 63.8376 31.824 63.5592 32.1396 63.6024C36.3672 63.8316 40.4316 64.3068 44.2176 65.016C44.5428 65.0772 44.7588 65.3904 44.6976 65.7156C44.6448 66.0036 44.3928 66.2052 44.1096 66.2052Z" fill="#103744"></path>
						<path d="M51.3083 76.3308C51.2519 76.3308 51.1943 76.3224 51.1367 76.3056C49.9895 75.9648 48.7896 75.6444 47.568 75.3528C47.2452 75.276 47.0472 74.952 47.124 74.6292C47.2008 74.3064 47.5284 74.1108 47.8476 74.1852C49.0896 74.4816 50.3111 74.808 51.4787 75.1548C51.7967 75.2496 51.9779 75.5832 51.8831 75.9012C51.8063 76.1616 51.5675 76.3308 51.3083 76.3308Z" fill="#103744"></path>
						<path d="M54.9083 77.5188C54.8399 77.5188 54.7703 77.5068 54.7019 77.4828C54.3275 77.346 53.9267 77.2056 53.5139 77.064C53.2007 76.9572 53.0339 76.6152 53.1407 76.302C53.2475 75.9888 53.5907 75.822 53.9027 75.9288C54.3251 76.074 54.7319 76.2156 55.1147 76.3548C55.4255 76.4688 55.5863 76.8132 55.4723 77.1252C55.3835 77.3688 55.1531 77.5188 54.9083 77.5188Z" fill="#103744"></path>
						<path d="M44.1096 74.6052C44.0736 74.6052 44.0352 74.6016 43.9992 74.5944C40.2624 73.896 36.252 73.4256 32.076 73.2C31.7448 73.182 31.4916 72.8988 31.5084 72.5688C31.5264 72.2376 31.824 71.9712 32.1396 72.0024C36.3672 72.2316 40.4316 72.7068 44.2176 73.416C44.5428 73.4772 44.7588 73.7904 44.6976 74.1156C44.6448 74.4036 44.3928 74.6052 44.1096 74.6052Z" fill="#103744"></path>
						<path d="M66.9083 43.9188C66.6635 43.9188 66.4331 43.7688 66.3443 43.5252C66.2303 43.2144 66.3911 42.87 66.7019 42.7548C68.9783 41.922 71.4239 41.1924 73.9691 40.5852L77.4503 39.8724C77.7743 39.8052 78.0923 40.0152 78.1583 40.3404C78.2255 40.6656 78.0155 40.9824 77.6903 41.0484L74.2283 41.7564C71.7479 42.348 69.3479 43.0644 67.1147 43.8816C67.0475 43.9068 66.9767 43.9188 66.9083 43.9188Z" fill="#103744"></path>
						<path d="M81.2124 40.4268C80.9184 40.4268 80.6616 40.2108 80.6184 39.9108C80.5716 39.5832 80.7996 39.2796 81.1284 39.2328C81.5544 39.1728 85.176 38.7588 85.176 38.7588L85.3116 39.9504C85.3116 39.9504 81.72 40.3608 81.2964 40.4208C81.2688 40.4256 81.2412 40.4268 81.2124 40.4268Z" fill="#103744"></path>
						<path d="M88.1556 39.6972C87.8436 39.6972 87.5796 39.456 87.558 39.1392C87.534 38.8092 87.7836 38.5212 88.1136 38.4984C88.6248 38.4624 89.1456 38.4288 89.6748 38.4C90.0024 38.3688 90.288 38.6352 90.306 38.9664C90.324 39.2976 90.0708 39.5808 89.7396 39.5976C89.2164 39.6264 88.7028 39.6588 88.1964 39.6948C88.1844 39.6972 88.17 39.6972 88.1556 39.6972Z" fill="#103744"></path>
						<path d="M66.9083 35.5188C66.6635 35.5188 66.4331 35.3688 66.3443 35.1252C66.2303 34.8144 66.3911 34.47 66.7019 34.3548C68.9783 33.522 71.4239 32.7924 73.9691 32.1852L77.4503 31.4724C77.7743 31.4052 78.0923 31.6152 78.1583 31.9404C78.2255 32.2656 78.0155 32.5824 77.6903 32.6484L74.2283 33.3564C71.7479 33.948 69.3479 34.6644 67.1147 35.4816C67.0475 35.5068 66.9767 35.5188 66.9083 35.5188Z" fill="#103744"></path>
						<path d="M81.2124 32.0268C80.9184 32.0268 80.6616 31.8108 80.6184 31.5108C80.5716 31.1832 80.7996 30.8796 81.1284 30.8328C81.5544 30.7728 85.176 30.3588 85.176 30.3588L85.3116 31.5504C85.3116 31.5504 81.72 31.9608 81.2964 32.0208C81.2688 32.0256 81.2412 32.0268 81.2124 32.0268Z" fill="#103744"></path>
						<path d="M88.1556 31.2972C87.8436 31.2972 87.5796 31.056 87.558 30.7392C87.534 30.4092 87.7836 30.1212 88.1136 30.0984C88.6248 30.0624 89.1456 30.0288 89.6748 30C90.0024 29.9556 90.288 30.2352 90.306 30.5664C90.324 30.8976 90.0708 31.1808 89.7396 31.1976C89.2164 31.2264 88.7028 31.2588 88.1964 31.2948C88.1844 31.2972 88.17 31.2972 88.1556 31.2972Z" fill="#103744"></path>
						<path d="M66.9083 60.7188C66.6635 60.7188 66.4331 60.5688 66.3443 60.3252C66.2303 60.0144 66.3911 59.67 66.7019 59.5548C68.9783 58.722 71.4239 57.9924 73.9691 57.3852L77.4503 56.6724C77.7743 56.6052 78.0923 56.8152 78.1583 57.1404C78.2255 57.4656 78.0155 57.7824 77.6903 57.8484L74.2283 58.5564C71.7479 59.148 69.3479 59.8644 67.1147 60.6816C67.0475 60.7068 66.9767 60.7188 66.9083 60.7188Z" fill="#103744"></path>
						<path d="M81.2124 57.2268C80.9184 57.2268 80.6616 57.0108 80.6184 56.7108C80.5716 56.3832 80.7996 56.0796 81.1284 56.0328C81.5544 55.9728 85.176 55.5588 85.176 55.5588L85.3116 56.7504C85.3116 56.7504 81.72 57.1608 81.2964 57.2208C81.2688 57.2256 81.2412 57.2268 81.2124 57.2268Z" fill="#103744"></path>
						<path d="M88.1556 56.4972C87.8436 56.4972 87.5796 56.256 87.558 55.9392C87.534 55.6092 87.7836 55.3212 88.1136 55.2984C88.6248 55.2624 89.1456 55.2288 89.6748 55.2C90.0024 55.1592 90.288 55.4352 90.306 55.7664C90.324 56.0976 90.0708 56.3808 89.7396 56.3976C89.2164 56.4264 88.7028 56.4588 88.1964 56.4948C88.1844 56.4972 88.17 56.4972 88.1556 56.4972Z" fill="#103744"></path>
						<path d="M66.9083 52.3188C66.6635 52.3188 66.4331 52.1688 66.3443 51.9252C66.2303 51.6144 66.3911 51.27 66.7019 51.1548C68.9783 50.322 71.4239 49.5924 73.9691 48.9852L77.4503 48.2724C77.7743 48.2052 78.0923 48.4152 78.1583 48.7404C78.2255 49.0656 78.0155 49.3824 77.6903 49.4484L74.2283 50.1564C71.7479 50.748 69.3479 51.4644 67.1147 52.2816C67.0475 52.3068 66.9767 52.3188 66.9083 52.3188Z" fill="#103744"></path>
						<path d="M81.2124 48.8268C80.9184 48.8268 80.6616 48.6108 80.6184 48.3108C80.5716 47.9832 80.7996 47.6796 81.1284 47.6328C81.5544 47.5728 85.176 47.1588 85.176 47.1588L85.3116 48.3504C85.3116 48.3504 81.72 48.7608 81.2964 48.8208C81.2688 48.8256 81.2412 48.8268 81.2124 48.8268Z" fill="#103744"></path>
						<path d="M88.1556 48.0972C87.8436 48.0972 87.5796 47.856 87.558 47.5392C87.534 47.2092 87.7836 46.9212 88.1136 46.8984C88.6248 46.8624 89.1456 46.8288 89.6748 46.8C90.0024 46.764 90.288 47.0352 90.306 47.3664C90.324 47.6976 90.0708 47.9808 89.7396 47.9976C89.2164 48.0264 88.7028 48.0588 88.1964 48.0948C88.1844 48.0972 88.17 48.0972 88.1556 48.0972Z" fill="#103744"></path>
						<path d="M66.9083 77.5188C66.6635 77.5188 66.4331 77.3688 66.3443 77.1252C66.2303 76.8144 66.3911 76.47 66.7019 76.3548C68.9783 75.522 71.4239 74.7924 73.9691 74.1852L77.4503 73.4724C77.7743 73.4052 78.0923 73.6152 78.1583 73.9404C78.2255 74.2656 78.0155 74.5824 77.6903 74.6484L74.2283 75.3564C71.7479 75.948 69.3479 76.6644 67.1147 77.4816C67.0475 77.5068 66.9767 77.5188 66.9083 77.5188Z" fill="#103744"></path>
						<path d="M81.2124 74.0268C80.9184 74.0268 80.6616 73.8108 80.6184 73.5108C80.5716 73.1832 80.7996 72.8796 81.1284 72.8328C81.5544 72.7728 85.176 72.3588 85.176 72.3588L85.3116 73.5504C85.3116 73.5504 81.72 73.9608 81.2964 74.0208C81.2688 74.0256 81.2412 74.0268 81.2124 74.0268Z" fill="#103744"></path>
						<path d="M88.1556 73.2972C87.8436 73.2972 87.5796 73.056 87.558 72.7392C87.534 72.4092 87.7836 72.1212 88.1136 72.0984C88.6248 72.0624 89.1456 72.0288 89.6748 72C90.0024 71.9676 90.288 72.2352 90.306 72.5664C90.324 72.8976 90.0708 73.1808 89.7396 73.1976C89.2164 73.2264 88.7028 73.2588 88.1964 73.2948C88.1844 73.2972 88.17 73.2972 88.1556 73.2972Z" fill="#103744"></path>
						<path d="M66.9083 69.1188C66.6635 69.1188 66.4331 68.9688 66.3443 68.7252C66.2303 68.4144 66.3911 68.07 66.7019 67.9548C68.9783 67.122 71.4239 66.3924 73.9691 65.7852L77.4503 65.0724C77.7743 65.0052 78.0923 65.2152 78.1583 65.5404C78.2255 65.8656 78.0155 66.1824 77.6903 66.2484L74.2283 66.9564C71.7479 67.548 69.3479 68.2644 67.1147 69.0816C67.0475 69.1068 66.9767 69.1188 66.9083 69.1188Z" fill="#103744"></path>
						<path d="M81.2124 65.6268C80.9184 65.6268 80.6616 65.4108 80.6184 65.1108C80.5716 64.7832 80.7996 64.4796 81.1284 64.4328C81.5544 64.3728 85.176 63.9588 85.176 63.9588L85.3116 65.1504C85.3116 65.1504 81.72 65.5608 81.2964 65.6208C81.2688 65.6256 81.2412 65.6268 81.2124 65.6268Z" fill="#103744"></path>
						<path d="M88.1556 64.8972C87.8436 64.8972 87.5796 64.656 87.558 64.3392C87.534 64.0092 87.7836 63.7212 88.1136 63.6984C88.6248 63.6624 89.1456 63.6288 89.6748 63.6C90.0024 63.5544 90.288 63.8352 90.306 64.1664C90.324 64.4976 90.0708 64.7808 89.7396 64.7976C89.2164 64.8264 88.7028 64.8588 88.1964 64.8948C88.1844 64.8972 88.17 64.8972 88.1556 64.8972Z" fill="#103744"></path>
						<path d="M60.6 72C60.2688 72 60 71.7312 60 71.4V30.6C60 30.2688 60.2688 30 60.6 30C60.9312 30 61.2 30.2688 61.2 30.6V71.4C61.2 71.7312 60.9312 72 60.6 72Z" fill="#103744"></path>
						<path d="M60.6 82.8C60.2688 82.8 60 82.5312 60 82.2V81C60 80.6688 60.2688 80.4 60.6 80.4C60.9312 80.4 61.2 80.6688 61.2 81V82.2C61.2 82.5312 60.9312 82.8 60.6 82.8Z" fill="#103744"></path>
						<path d="M60.6 78C60.2688 78 60 77.7312 60 77.4V75C60 74.6688 60.2688 74.4 60.6 74.4C60.9312 74.4 61.2 74.6688 61.2 75V77.4C61.2 77.7312 60.9312 78 60.6 78Z" fill="#103744"></path>
					</svg>
				</p>

				<p class="jsps-h2" role="heading" aria-level="2">
					<?php _e( 'What’s New?', 'juiz-social-post-sharer' ); ?>
				</p>

				<p><?php _e( 'I gathered some information in the welcome page, stay tuned of news!', 'juiz-social-post-sharer' ); ?></p>

				<p>
					<a href="<?php echo jsps_get_welcome_url(); ?>" class="button jsps-button"><?php _e( 'Visit Welcome Page', 'juiz-social-post-sharer' ); ?></a>
				</p>
			</div>

			<div class="jsps-col jsps-col-promo">
				<?php
				/**
				 * Decides if it displays promotion sections within the admin, or not.
				 * 
				 * @hook jsps_admin_show_promotion
				 * 
				 * @since  2.0.0 First version
				 * 
				 * @param  {boolean} $show_promo=true   `true` or `false` weither you want to display promo or not
				 * @return {boolean}                    Returns the value of `$show_promo`
				 *
				 */
				if ( apply_filters( 'jsps_admin_show_promotion', true ) ) {
				?>
				
				<div id="jsps-shop-promotion" class="jsps-shop-promotion">
					<p class="jsps-shop-promo-text">
						<span class="jsps-promo-big-text">
							<?php _e( 'New Skin Shop', 'juiz-social-post-sharer'); ?>
						</span>
						<span class="jsps-promo-text">
							<?php _e( 'Free &amp; Premium Button Skins', 'juiz-social-post-sharer' ); ?>
						</span>
					</p>
					<div class="jsps-shop-promo-form">
						<!-- Begin Mailchimp Signup Form -->
						<div id="mc_embed_signup">
							<form action="https://gmail.us10.list-manage.com/subscribe/post?u=5339b8dfa2b000a82251effc3&amp;id=c9c0f762f1" method="post" id="mc-embedded-subscribe-form" name="mc-embedded-subscribe-form" class="validate" target="_blank" novalidate>
								<div id="mc_embed_signup_scroll">
									<div class="mc-field-group">
										<label for="mce-EMAIL" form="mc-embedded-subscribe-form">
											<?php _e( 'Soon! Be the first to know', 'juiz-social-post-sharer' ); ?>
										</label>
										<input type="email" value="" name="EMAIL" class="required email" id="mce-EMAIL" form="mc-embedded-subscribe-form" placeholder="<?php echo esc_attr( __( 'Email Address', 'juiz-social-post-sharer' ) ); ?>">
									</div>

									<!-- real people should not fill this in and expect good things - do not remove this or risk form bot signups-->
									<div style="position: absolute; left: -5000px;" aria-hidden="true"><input type="text" name="b_5339b8dfa2b000a82251effc3_c9c0f762f1" tabindex="-1" value=""></div>

									<div class="mc-submit">
										<input type="hidden" value="Admin-Skin-Shop" name="CAMPAIGN" id="mce-CAMPAIGN" form="mc-embedded-subscribe-form">
										
										<button form="mc-embedded-subscribe-form" type="submit" name="subscribe" id="mc-embedded-subscribe" class="button"><img src="<?php echo JUIZ_SPS_PLUGIN_ASSETS; ?>img/icon-send.svg" alt="<?php echo esc_attr( __('Subscribe', 'juiz-social-post-sharer') ); ?>" title="<?php echo esc_attr( __('Subscribe', 'juiz-social-post-sharer') ); ?>" width="24" height="24" /></button>
									</div>
								</div>
							</form>
							<!-- /form -->
						</div>
						<!--End mc_embed_signup-->

					</div>
				</div>

				<?php
				}
				?>
			</div>
		</div>
		
		<style type="text/css">
			.juiz-sps-notice.juiz-sps-notice {
				padding: 0;
				border: 0;
			}

			.juiz-sps-notice.juiz-sps-notice.is-dismissible {
				padding-right: 0;
			}

			.juiz-sps-notice .notice-dismiss {
				top: 9px;
				right: 8px;
			}

			.juiz-sps-notice .notice-dismiss::before {
				color: #FFF;
			}

			.jsps-notice-header {
				display: flex;
				align-items: center;
				padding: 3px 16px;
				background: #0A2933;
				color: #618C9A;
				font-size: 18px;
			}

			.jsps-notice-header p {
				margin: 0;
				flex-basis: 100%;
				padding-right: 180px;
				text-align: center;
				font-size: 16px;
			}

			.jsps-notice-header img {
				height: 32px;
				width: auto;
			}

			.jsps-notice-content {
				display: grid;
				padding: 8px 16px 16px 16px;
				gap: 24px;
				grid-template-columns: 1fr 1fr 1fr 1fr;
				text-align: center;
				line-height: 1.55;
			}

			.jsps-notice-content .jsps-col > * {
				margin: 6px 0;
			}

			.jsps-notice-content .jsps-col > p:first-child {
				margin-top: 0;
				margin-bottom: 0;
			}

			.jsps-notice-content .jsps-col > p:last-child {
				margin-bottom: 0;
			}

			.jsps-notice-content .jsps-col [role='heading'] {
				margin-top: 0;
				font-weight: bold;
				color: #0073AA;
				font-size: 15px;
			}

			.jsps-notice-content .jsps-button {
				padding: 6px 14px;
				border: 0 none;
				font-size: 14px;
				font-weight: 600;
				color: #0073AA;
				text-shadow: none;
				box-shadow: 0px 4px 6px rgba(10, 102, 194, 0.1), 0px 1px 2px rgba(10, 102, 194, 0.1);
				border-radius: 6px;
				background: #E9F8FD;
				transition: all .275s;
			}

			.jsps-notice-content .jsps-button:hover,
			.jsps-notice-content .jsps-button:focus {
				background: #0073AA;
				color: #FFF;
			}

			.jsps-shop-promotion.jsps-shop-promotion {
				margin-top: -8px;
				margin-right: -16px;
				padding-bottom: 6px;
				background: #103744 url(<?php echo JUIZ_SPS_PLUGIN_ASSETS . 'img/promo-buttons.png'; ?>);
				background-size: 200px;
				background-repeat: no-repeat;
				background-position: right -135px bottom;
				border-radius: 73% 21% 0% 100% / 56% 0% 21% 67%;
			}

			.jsps-shop-promotion p {
				margin: 0;
				color: #E3E8ED;
			}

			.jsps-promo-big-text {
				display: block;
				padding-top: 30px;
				font-weight: bold;
				font-size: 20px;
				text-transform: uppercase;
				letter-spacing: 2.4px;
			}

			.jsps-promo-text {
				margin-top: -2px;
				margin-bottom: 24px;
				font-size: 14px;
				font-weight: bold;
				color: #20A0C9;
			}

			.jsps-shop-promo-form {
				position: relative;
				width: 208px;
				margin: 16px auto;
				text-align: left;
			}

			.jsps-shop-promo-form label {
				display: block;
				margin-bottom: 4px;
				font-weight: bold;
				color: rgba(255, 255, 255, .75);
				font-size: 14px;
			}

			.jsps-shop-promo-form input {
				width: 100%;
				padding: 8px 24px 8px 16px;
				height: 48px;
				border: 0;
			}

			.jsps-shop-promo-form .button {
				display: flex;
				place-items: center;
				position: absolute;
				bottom: 0;
				right: -24px;
				width: 48px;
				height: 48px;
				background: #20A0C9;
				border: 0;
				text-shadow: 0;
				border-radius: 100px;
				transition: .275s all;
			}

			.jsps-shop-promo-form .button:hover {
				background: #0073AA;
			}

			.jsps-shop-promo-form .button img {
				position: relative;
				left: 4px;
			}

			@media (min-width: 1620px) {
				.jsps-notice-content {
					gap: 80px;
				}
			}

			@media (max-width: 1220px) {
				.jsps-col-promo {
					display: none;
				}
				.jsps-notice-content {
					grid-template-columns: 1fr 1fr 1fr;
				}
			}

			@media (max-width: 790px) {
				.jsps-notice-header p {
					display: none;
				}
				.jsps-col-promo {
					display: block;
				}
				.jsps-notice-content {
					grid-template-columns: 1fr 1fr;
				}	
			}

			@media (max-width: 524px) {
				.jsps-notice-content {
					grid-template-columns: 1fr;
				}	
			}
		</style>

		<script>
			jQuery( document ).ready( function( $ ){
				/**
				 * Handle Notices
				 */
				$('.juiz-sps-notice').on('click', '.notice-dismiss', function(){
					let notice = this.closest('.juiz-sps-notice');
					let noticedata = {
						'action': 'juiz_sps_notice_removal',
						'nonce' : notice.dataset.nonce,
						'notice_id' : notice.dataset.notice,
					};

					$.post( ajaxurl, noticedata, function(response) {
						console.log(response);
					});

					return false;
				});
			});
		</script>
	</div>
	<?php
}
add_action( 'admin_notices', 'jsps_admin_notice_after_update' );
