const defaultTheme = {
  properties: [
    {
      prop: 'themePrimaryColor',
      type: 'style',
      value: '#01105C'
    },
    {
      prop: 'themeSecondaryColor',
      type: 'style',
      value: '#0066C3'
    },
    {
      prop: 'pageBackgroundStart',
      type: 'style',
      value: '#F3F3FE'
    },
    {
      prop: 'pageBackgroundEnd',
      type: 'style',
      value: '#F3F3FE'
    },
    {
      prop: 'agentBackgroundStart',
      type: 'style',
      value: '#6C73A8'
    },
    {
      prop: 'agentBackgroundEnd',
      type: 'style',
      value: '#6C73A8'
    },
    {
      prop: 'chatBackground',
      type: 'style',
      value: '#FFFFFF'
    },
    {
      prop: 'inputBackground',
      type: 'style',
      value: '#01105C1A'
    },
    {
      prop: 'inputTextColor',
      type: 'style',
      value: '#01105C'
    },
    {
      prop: 'sendButtonBackground',
      type: 'style',
      value: '#0066C3'
    },
    {
      prop: 'sendButtonIconColor',
      type: 'style',
      value: '#FFFFFF'
    },
    {
      prop: 'chatRightFormTitleColor',
      type: 'style',
      value: '#FFFFFF'
    },
    {
      prop: 'activeTheme',
      type: 'style',
      value: 'default'
    }
  ]
};

const oceanic = {
  properties: [
    {
      prop: 'themePrimaryColor',
      type: 'style',
      value: '#00433A'
    },
    {
      prop: 'themeSecondaryColor',
      type: 'style',
      value: '#7D328E'
    },
    {
      prop: 'pageBackgroundStart',
      type: 'style',
      value: '#6DB8BD'
    },
    {
      prop: 'pageBackgroundEnd',
      type: 'style',
      value: '#6DB8BD'
    },
    {
      prop: 'agentBackgroundStart',
      type: 'style',
      value: '#035C5F'
    },
    {
      prop: 'agentBackgroundEnd',
      type: 'style',
      value: '#035C5F'
    },
    {
      prop: 'chatBackground',
      type: 'style',
      value: '#F4FEFF'
    },
    {
      prop: 'inputBackground',
      type: 'style',
      value: '#004A4E1A'
    },
    {
      prop: 'inputTextColor',
      type: 'style',
      value: '#00433A'
    },
    {
      prop: 'sendButtonBackground',
      type: 'style',
      value: '#8E1CA8'
    },
    {
      prop: 'sendButtonIconColor',
      type: 'style',
      value: '#FFFFFF'
    },
    {
      prop: 'chatRightFormTitleColor',
      type: 'style',
      value: '#F4FEFF'
    },
    {
      prop: 'activeTheme',
      type: 'style',
      value: 'oceanic'
    }
  ]
};

const savannah = {
  properties: [
    {
      prop: 'themePrimaryColor',
      type: 'style',
      value: '#481414'
    },
    {
      prop: 'themeSecondaryColor',
      type: 'style',
      value: '#051258'
    },
    {
      prop: 'pageBackgroundStart',
      type: 'style',
      value: '#F36718'
    },
    {
      prop: 'pageBackgroundEnd',
      type: 'style',
      value: '#F36718'
    },
    {
      prop: 'agentBackgroundStart',
      type: 'style',
      value: '#0E408A'
    },
    {
      prop: 'agentBackgroundEnd',
      type: 'style',
      value: '#0E408A'
    },
    {
      prop: 'chatBackground',
      type: 'style',
      value: '#FFF4E8'
    },
    {
      prop: 'inputBackground',
      type: 'style',
      value: '#4814141A'
    },
    {
      prop: 'inputTextColor',
      type: 'style',
      value: '#481414'
    },
    {
      prop: 'sendButtonBackground',
      type: 'style',
      value: '#051258'
    },
    {
      prop: 'sendButtonIconColor',
      type: 'style',
      value: '#FFFFFF'
    },
    {
      prop: 'chatRightFormTitleColor',
      type: 'style',
      value: '#FFF4E8'
    },
    {
      prop: 'activeTheme',
      type: 'style',
      value: 'savannah'
    }
  ]
};

const caffeine = {
  properties: [
    {
      prop: 'themePrimaryColor',
      type: 'style',
      value: '#FFFBE7'
    },
    {
      prop: 'themeSecondaryColor',
      type: 'style',
      value: '#2AE283'
    },
    {
      prop: 'pageBackgroundStart',
      type: 'style',
      value: '#E5DECD'
    },
    {
      prop: 'pageBackgroundEnd',
      type: 'style',
      value: '#E5DECD'
    },
    {
      prop: 'agentBackgroundStart',
      type: 'style',
      value: '#FF8DB9'
    },
    {
      prop: 'agentBackgroundEnd',
      type: 'style',
      value: '#FF8DB9'
    },
    {
      prop: 'chatBackground',
      type: 'style',
      value: '#342123'
    },
    {
      prop: 'inputBackground',
      type: 'style',
      value: '#FFFBE71A'
    },
    {
      prop: 'inputTextColor',
      type: 'style',
      value: '#FFFBE7'
    },
    {
      prop: 'sendButtonBackground',
      type: 'style',
      value: '#2AE283'
    },
    {
      prop: 'sendButtonIconColor',
      type: 'style',
      value: '#150D0E'
    },
    {
      prop: 'chatRightFormTitleColor',
      type: 'style',
      value: '#342123'
    },
    {
      prop: 'activeTheme',
      type: 'style',
      value: 'caffeine'
    }
  ]
};

const detox = {
  properties: [
    {
      prop: 'themePrimaryColor',
      type: 'style',
      value: '#1F2A09'
    },
    {
      prop: 'themeSecondaryColor',
      type: 'style',
      value: '#004BB6'
    },
    {
      prop: 'pageBackgroundStart',
      type: 'style',
      value: '#1F2A09'
    },
    {
      prop: 'pageBackgroundEnd',
      type: 'style',
      value: '#1F2A09'
    },
    {
      prop: 'agentBackgroundStart',
      type: 'style',
      value: '#3A5800'
    },
    {
      prop: 'agentBackgroundEnd',
      type: 'style',
      value: '#3A5800'
    },
    {
      prop: 'chatBackground',
      type: 'style',
      value: '#F3FFDE'
    },
    {
      prop: 'inputBackground',
      type: 'style',
      value: '#1F2A091A'
    },
    {
      prop: 'inputTextColor',
      type: 'style',
      value: '#1F2A09'
    },
    {
      prop: 'sendButtonBackground',
      type: 'style',
      value: '#004BB6'
    },
    {
      prop: 'sendButtonIconColor',
      type: 'style',
      value: '#F8FEEC'
    },
    {
      prop: 'chatRightFormTitleColor',
      type: 'style',
      value: '#F3FFDE'
    },
    {
      prop: 'activeTheme',
      type: 'style',
      value: 'detox'
    }
  ]
};

const shadow = {
  properties: [
    {
      prop: 'themePrimaryColor',
      type: 'style',
      value: '#EAE9FF'
    },
    {
      prop: 'themeSecondaryColor',
      type: 'style',
      value: '#8797FF'
    },
    {
      prop: 'pageBackgroundStart',
      type: 'style',
      value: '#1E165F'
    },
    {
      prop: 'pageBackgroundEnd',
      type: 'style',
      value: '#1E165F'
    },
    {
      prop: 'agentBackgroundStart',
      type: 'style',
      value: '#D3CBF4'
    },
    {
      prop: 'agentBackgroundEnd',
      type: 'style',
      value: '#D3CBF4'
    },
    {
      prop: 'chatBackground',
      type: 'style',
      value: '#01091B'
    },
    {
      prop: 'inputBackground',
      type: 'style',
      value: '#EAE9FF1A'
    },
    {
      prop: 'inputTextColor',
      type: 'style',
      value: '#EAE9FF'
    },
    {
      prop: 'sendButtonBackground',
      type: 'style',
      value: '#8797FF'
    },
    {
      prop: 'sendButtonIconColor',
      type: 'style',
      value: '#01091B'
    },
    {
      prop: 'chatRightFormTitleColor',
      type: 'style',
      value: '#01091B'
    },
    {
      prop: 'activeTheme',
      type: 'style',
      value: 'shadow'
    }
  ]
};

const sakura = {
  properties: [
    {
      prop: 'themePrimaryColor',
      type: 'style',
      value: '#6E0739'
    },
    {
      prop: 'themeSecondaryColor',
      type: 'style',
      value: '#04569D'
    },
    {
      prop: 'pageBackgroundStart',
      type: 'style',
      value: '#750039'
    },
    {
      prop: 'pageBackgroundEnd',
      type: 'style',
      value: '#750039'
    },
    {
      prop: 'agentBackgroundStart',
      type: 'style',
      value: '#910E3E'
    },
    {
      prop: 'agentBackgroundEnd',
      type: 'style',
      value: '#910E3E'
    },
    {
      prop: 'chatBackground',
      type: 'style',
      value: '#FFD9E7'
    },
    {
      prop: 'inputBackground',
      type: 'style',
      value: '#6E07391A'
    },
    {
      prop: 'inputTextColor',
      type: 'style',
      value: '#6E0739'
    },
    {
      prop: 'sendButtonBackground',
      type: 'style',
      value: '#04569D'
    },
    {
      prop: 'sendButtonIconColor',
      type: 'style',
      value: '#F7FFE9'
    },
    {
      prop: 'chatRightFormTitleColor',
      type: 'style',
      value: '#FFD9E7'
    },
    {
      prop: 'activeTheme',
      type: 'style',
      value: 'sakura'
    }
  ]
};

const parliament = {
  properties: [
    {
      prop: 'themePrimaryColor',
      type: 'style',
      value: '#06367E'
    },
    {
      prop: 'themeSecondaryColor',
      type: 'style',
      value: '#246506'
    },
    {
      prop: 'pageBackgroundStart',
      type: 'style',
      value: '#06367E'
    },
    {
      prop: 'pageBackgroundEnd',
      type: 'style',
      value: '#06367E'
    },
    {
      prop: 'agentBackgroundStart',
      type: 'style',
      value: '#0F53B4'
    },
    {
      prop: 'agentBackgroundEnd',
      type: 'style',
      value: '#0F53B4'
    },
    {
      prop: 'chatBackground',
      type: 'style',
      value: '#FFFFFF'
    },
    {
      prop: 'inputBackground',
      type: 'style',
      value: '#0A15511A'
    },
    {
      prop: 'inputTextColor',
      type: 'style',
      value: '#06367E'
    },
    {
      prop: 'sendButtonBackground',
      type: 'style',
      value: '#246506'
    },
    {
      prop: 'sendButtonIconColor',
      type: 'style',
      value: '#FFFFFF'
    },
    {
      prop: 'chatRightFormTitleColor',
      type: 'style',
      value: '#FFFFFF'
    },
    {
      prop: 'activeTheme',
      type: 'style',
      value: 'parliament'
    }
  ]
};

const sax = {
  properties: [
    {
      prop: 'themePrimaryColor',
      type: 'style',
      value: '#2E073F'
    },
    {
      prop: 'themeSecondaryColor',
      type: 'style',
      value: '#246506'
    },
    {
      prop: 'pageBackgroundStart',
      type: 'style',
      value: '#2E073F'
    },
    {
      prop: 'pageBackgroundEnd',
      type: 'style',
      value: '#2E073F'
    },
    {
      prop: 'agentBackgroundStart',
      type: 'style',
      value: '#642CC7'
    },
    {
      prop: 'agentBackgroundEnd',
      type: 'style',
      value: '#642CC7'
    },
    {
      prop: 'chatBackground',
      type: 'style',
      value: '#FFFFFF'
    },
    {
      prop: 'inputBackground',
      type: 'style',
      value: '#2E073F1A'
    },
    {
      prop: 'inputTextColor',
      type: 'style',
      value: '#2E073F'
    },
    {
      prop: 'sendButtonBackground',
      type: 'style',
      value: '#672000'
    },
    {
      prop: 'sendButtonIconColor',
      type: 'style',
      value: '#FFFFFF'
    },
    {
      prop: 'chatRightFormTitleColor',
      type: 'style',
      value: '#FFFFFF'
    },
    {
      prop: 'activeTheme',
      type: 'style',
      value: 'sax'
    }
  ]
};

export const THEME_MAP = {
  default: defaultTheme, oceanic, savannah, caffeine, detox, shadow, sakura, parliament, sax
};

export const THEMES = [
  { id: 1, name: 'default' },
  { id: 2, name: 'oceanic' },
  { id: 3, name: 'savannah' },
  { id: 4, name: 'caffeine' },
  { id: 5, name: 'detox' },
  { id: 6, name: 'shadow' },
  { id: 7, name: 'sakura' },
  { id: 8, name: 'parliament' },
  { id: 9, name: 'sax' }
];
