/* eslint-disable max-len */

const unicodeEncode = input => String(input)
  .replace(/\\/g, '\\\\')
  .replace(/"/g, '\\"')
  .replace(/'/g, "\\'")
  .replace(/</g, '\\u003C')
  .replace(/>/g, '\\u003E')
  .replace(/&/g, '\\u0026')
  .replace(/\//g, '\\/');

const renderJotformLogo = (rootSelector) => () => {
  const root = document.querySelector(`.${rootSelector} .wrap`);
  if (!root) return;

  const oldTitle = root.querySelector('h1');
  if (!oldTitle) return;

  const titleText = oldTitle.textContent.trim();
  const sanitizedTitle = unicodeEncode(titleText);
  oldTitle.remove(); // We’ll recreate it properly

  // Create header container
  const headerEl = document.createElement('header');
  headerEl.className = 'jotform-ai-chatbot-header';

  // Create logo container
  const logo = document.createElement('div');
  logo.className = 'jotform-ai-chatbot-logo';
  logo.innerHTML = `
      <svg aria-hidden='true' width="148" height="28" fill=none viewBox="0 0 148 28"xmlns=http://www.w3.org/2000/svg><g id=jotform-logomark><path d="M19.294 3.934a3.341 3.341 0 0 1 4.727 0 3.344 3.344 0 0 1 0 4.728l-11.817 11.82a3.341 3.341 0 0 1-4.726 0 3.344 3.344 0 0 1 0-4.727l11.816-11.82Z"fill=#FF6100 id=jotform-logomark-first></path><path d="M9.25.98a3.344 3.344 0 0 1 4.727 4.728l-8.271 8.274a3.342 3.342 0 0 1-4.727 0 3.344 3.344 0 0 1 0-4.729L9.25.98Z"fill=#0099FF id=jotform-logomark-second></path><path d="M18.704 17.527a3.344 3.344 0 0 1 4.726 4.728l-4.726 4.729a3.342 3.342 0 1 1-4.727-4.728l4.727-4.729Z"fill=#FFB629 id=jotform-logomark-third></path><path d="M1.671 28h4.667c.745 0 1.118-.9.591-1.427L1.426 21.07C.9 20.542 0 20.915 0 21.659v4.67C0 27.251.748 28 1.671 28Z"fill=#0A1551 id=jotform-logomark-fourth></path></g><g id=jotform-wordmark><path d="m91.25 6.02.257.076V2.37l-.118-.055c-.18-.086-.471-.164-.807-.22A7.085 7.085 0 0 0 89.432 2c-1.592 0-3.382.549-4.309 1.538-.926.989-1.437 2.398-1.437 4.083v.787h-2.327v4.277h2.327v13h4.67v-13h3.151V8.408h-3.15v-.727c0-.758.254-1.194.58-1.448.335-.262.775-.354 1.177-.354.604 0 .954.086 1.137.14Z"fill=#0A1551 id=jotform-wordmark-j></path><path d="M37.847 17.628H33l.003.186c.038 2.363.896 4.309 2.332 5.672 1.47 1.395 3.567 2.199 6.068 2.199 5.005 0 8.511-3.708 8.511-8.142V3.692h-5.24V17.4c0 .99-.3 1.862-.873 2.492-.577.633-1.413.997-2.435.997-.837 0-1.64-.239-2.261-.753-.625-.515-1.042-1.29-1.136-2.317a.222.222 0 0 0-.067-.14l-.055-.052Z"fill=#0A1551 id=jotform-wordmark-0></path><path d="M128.34 25.685h-4.865V9.16h4.674v1.329c1.077-1.137 2.787-1.722 4.264-1.722 2.026 0 3.74.806 4.679 2.33.579-.771 1.244-1.33 1.994-1.706.882-.442 1.865-.624 2.934-.624 1.509 0 3.007.457 4.132 1.487C147.281 11.29 148 12.871 148 15.05v10.635h-4.738v-9.773c0-.8-.196-1.459-.581-1.914-.378-.446-.974-.737-1.87-.737-.818 0-1.454.314-1.889.806-.439.497-.688 1.193-.688 1.973v9.645H133.4v-9.773c0-.796-.202-1.457-.592-1.913-.383-.447-.98-.738-1.858-.738-.839 0-1.482.309-1.919.796-.441.491-.691 1.186-.691 1.982v9.646Z"fill=#0A1551 id=jotform-wordmark-t></path><path d="M100.934 8.767c-4.812 0-8.457 3.542-8.457 8.459 0 4.885 3.644 8.459 8.457 8.459 4.813 0 8.457-3.574 8.457-8.459 0-4.917-3.645-8.459-8.457-8.459Zm0 12.512c-.948 0-1.85-.346-2.515-1.014-.664-.667-1.112-1.675-1.112-3.039 0-1.38.449-2.388 1.111-3.05.664-.664 1.567-1.003 2.516-1.003.949 0 1.852.339 2.516 1.003.662.662 1.111 1.67 1.111 3.05s-.449 2.388-1.111 3.05c-.664.664-1.567 1.003-2.516 1.003Z"fill=#0A1551 id=jotform-wordmark-f clip-rule=evenodd fill-rule=evenodd></path><path d="M60.242 8.767c-4.813 0-8.457 3.542-8.457 8.459 0 4.885 3.644 8.459 8.457 8.459 4.813 0 8.457-3.574 8.457-8.459 0-4.917-3.645-8.459-8.457-8.459Zm0 12.512c-.948 0-1.85-.346-2.516-1.014-.663-.667-1.11-1.675-1.11-3.039 0-1.38.447-2.388 1.11-3.05.664-.664 1.566-1.003 2.516-1.003s1.851.339 2.516 1.003c.662.662 1.11 1.67 1.11 3.05s-.448 2.388-1.11 3.05c-.665.664-1.567 1.003-2.516 1.003Z"fill=#0A1551 id=jotform-wordmark-o clip-rule=evenodd fill-rule=evenodd></path><path d="M121.601 8.863v5.043l-.379-.078a5.9 5.9 0 0 0-1.206-.124c-1.032 0-1.949.257-2.607.88-.653.62-1.104 1.652-1.104 3.317v7.784h-4.852V8.849h4.725v1.625c1.169-1.43 2.984-1.707 4.123-1.707.365 0 .695.034 1.009.066l.291.03Z"fill=#0A1551 id=jotform-wordmark-r></path><path d="m79.956 21.587-.257.076c-.182.054-.533.14-1.138.14-.402 0-.843-.092-1.178-.354-.326-.254-.58-.69-.58-1.448v-7.464h3.153V8.295h-3.153V3.692h-4.666v4.603h-2.33v4.242h2.33v7.523c0 1.687.511 3.097 1.439 4.086.928.99 2.71 1.539 4.304 1.539a7.1 7.1 0 0 0 1.15-.095c.336-.057.627-.134.808-.22l.118-.056v-3.727Z"fill=#0A1551 id=jotform-wordmark-m></path></g></svg>
      <h1 class='sr-only'>${sanitizedTitle}</h1>
    `;

  // Create button wrapper
  const btnWrapper = document.createElement('div');
  btnWrapper.id = 'button-wrapper-root';

  // Assemble header
  headerEl.append(logo, btnWrapper);

  // Insert header at the top
  root.prepend(headerEl);
};

renderJotformLogo('toplevel_page_jotform_ai_chatbot')();
renderJotformLogo('jotform-ai-chatbot_page_jotform_ai_chatbot_conversations')();
renderJotformLogo('jotform-ai-chatbot_page_jotform_ai_chatbot_settings')();
