/*!
 * Transition Name: Luminance Melt
 */
!function(e){(function(e){"use strict";var o={name:"LuminanceMelt",effect:function(e,o){this.viewer=o;this.shader={uniforms:{texture1:{value:null},texture2:{value:null},progress:{value:0},time:{value:0},timeDelta:{value:0},resolution:{value:new THREE.Vector2},direction:{value:1},l_threshold:{value:.8},above:{value:false}},vertexShader:["varying vec2 vUv;","void main() {","vUv = uv;","gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);","}"].join("\n"),fragmentShader:["varying vec2 vUv;","uniform sampler2D texture1;","uniform sampler2D texture2;","uniform float progress;","uniform float time;","uniform float timeDelta;","uniform vec2 resolution;","const float PI = 3.141592653589793;","vec4 getFromColor(vec2 uv) {","return texture2D(texture1, uv);","}","vec4 getToColor(vec2 uv) {","return texture2D(texture2, uv);","}","uniform bool direction;","uniform float l_threshold;","uniform bool above;","float rand(vec2 co) {","return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);","}","vec3 mod289(vec3 x) {","return x - floor(x * (1.0 / 289.0)) * 289.0;","}","vec2 mod289(vec2 x) {","return x - floor(x * (1.0 / 289.0)) * 289.0;","}","vec3 permute(vec3 x) {","return mod289(((x*34.0)+1.0)*x);","}","float snoise(vec2 v) {","const vec4 C = vec4(","0.211324865405187,","0.366025403784439,","-0.577350269189626,","0.024390243902439",");","vec2 i  = floor(v + dot(v, C.yy) );","vec2 x0 = v -   i + dot(i, C.xx);","vec2 i1;","i1 = (x0.x > x0.y) ? vec2(1.0, 0.0) : vec2(0.0, 1.0);","vec4 x12 = x0.xyxy + C.xxzz;","x12.xy -= i1;","i = mod289(i);","vec3 p = permute( permute( i.y + vec3(0.0, i1.y, 1.0 )) + i.x + vec3(0.0, i1.x, 1.0 ));","vec3 m = max(0.5 - vec3(dot(x0,x0), dot(x12.xy,x12.xy), dot(x12.zw,x12.zw)), 0.0);","m = m*m;","m = m*m;","vec3 x = 2.0 * fract(p * C.www) - 1.0;","vec3 h = abs(x) - 0.5;","vec3 ox = floor(x + 0.5);","vec3 a0 = x - ox;","m *= 1.79284291400159 - 0.85373472095314 * ( a0*a0 + h*h );","vec3 g;","g.x  = a0.x  * x0.x  + h.x  * x0.y;","g.yz = a0.yz * x12.xz + h.yz * x12.yw;","return 130.0 * dot(m, g);","}","float luminance(vec4 color) {","return color.r*0.299+color.g*0.587+color.b*0.114;","}","void main() {","vec2 uv = vUv;","vec2 center = vec2(1.0, direction);","vec2 p = uv.xy / vec2(1.0).xy;","if (progress == 0.0) {","gl_FragColor = getFromColor(p);","} else if (progress == 1.0) {","gl_FragColor = getToColor(p);","} else {","float x = progress;","float dist = distance(center, p)- progress*exp(snoise(vec2(p.x, 0.0)));","float r = x - rand(vec2(p.x, 0.1));","float m;","if(above) {","m = dist <= r && luminance(getFromColor(p))>l_threshold ? 1.0 : (progress*progress*progress);","} else{","m = dist <= r && luminance(getFromColor(p))<l_threshold ? 1.0 : (progress*progress*progress);","}","vec4 fromColor = getFromColor(p);","vec4 toColor = getToColor(p);","gl_FragColor = mix(fromColor, toColor, m);","}","}"].join("\n"),side:THREE.DoubleSide};this.material=new THREE.ShaderMaterial(this.shader);this.init(e)}};o.effect.prototype={init:function(e){},getMaterial:function(){return this.material},destroy:function(){this.material.dispose()},onStart:function(e,o,r){},onUpdate:function(e,o,r){},onComplete:function(e,o){}},e.SceneTransitionEffect=e.SceneTransitionEffect||{},e.SceneTransitionEffect.LuminanceMelt=o})((e=e||self).IPANORAMA=e.IPANORAMA||{})}(this);