/*!
 * Transition Name: Hexagonalize
 */
!function(e){(function(e){"use strict";var o={name:"Hexagonalize",effect:function(e,o){this.viewer=o;this.shader={uniforms:{texture1:{value:null},texture2:{value:null},progress:{value:0},time:{value:0},timeDelta:{value:0},resolution:{value:new THREE.Vector2},steps:{value:50},horizontalHexagons:{value:20}},vertexShader:["varying vec2 vUv;","void main() {","vUv = uv;","gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);","}"].join("\n"),fragmentShader:["varying vec2 vUv;","uniform sampler2D texture1;","uniform sampler2D texture2;","uniform float progress;","uniform float time;","uniform float timeDelta;","uniform vec2 resolution;","const float PI = 3.141592653589793;","vec4 getFromColor(vec2 uv) {","return texture2D(texture1, uv);","}","vec4 getToColor(vec2 uv) {","return texture2D(texture2, uv);","}","uniform int steps;","uniform float horizontalHexagons;","struct Hexagon {","float q;","float r;","float s;","};","Hexagon createHexagon(float q, float r) {","Hexagon hex;","hex.q = q;","hex.r = r;","hex.s = -q - r;","return hex;","}","Hexagon roundHexagon(Hexagon hex) {","float q = floor(hex.q + 0.5);","float r = floor(hex.r + 0.5);","float s = floor(hex.s + 0.5);","float deltaQ = abs(q - hex.q);","float deltaR = abs(r - hex.r);","float deltaS = abs(s - hex.s);","if (deltaQ > deltaR && deltaQ > deltaS) {","q = -r - s;","} else if (deltaR > deltaS) {","r = -q - s;","} else {","s = -q - r;","}","return createHexagon(q, r);","}","Hexagon hexagonFromPoint(vec2 point, float size) {","float ratio = resolution.x / resolution.y;","point.y /= ratio;","point = (point - 0.5) / size;","float q = (sqrt(3.0) / 3.0) * point.x + (-1.0 / 3.0) * point.y;","float r = 0.0 * point.x + 2.0 / 3.0 * point.y;","Hexagon hex = createHexagon(q, r);","return roundHexagon(hex);","}","vec2 pointFromHexagon(Hexagon hex, float size) {","float ratio = resolution.x / resolution.y;","float x = (sqrt(3.0) * hex.q + (sqrt(3.0) / 2.0) * hex.r) * size + 0.5;","float y = (0.0 * hex.q + (3.0 / 2.0) * hex.r) * size + 0.5;","return vec2(x, y * ratio);","}","void main() {","vec2 uv = vUv;","float dist = 2.0 * min(progress, 1.0 - progress);","dist = steps > 0 ? ceil(dist * float(steps)) / float(steps) : dist;","float size = (sqrt(3.0) / 3.0) * dist / horizontalHexagons;","vec2 point = dist > 0.0 ? pointFromHexagon(hexagonFromPoint(uv, size), size) : uv;","vec4 fromColor = getFromColor(point);","vec4 toColor = getToColor(point);","gl_FragColor = mix(fromColor, toColor, progress);","}"].join("\n"),side:THREE.DoubleSide};this.material=new THREE.ShaderMaterial(this.shader);this.init(e)}};o.effect.prototype={init:function(e){},getMaterial:function(){return this.material},destroy:function(){this.material.dispose()},onStart:function(e,o,t){},onUpdate:function(e,o,t){},onComplete:function(e,o){}},e.SceneTransitionEffect=e.SceneTransitionEffect||{},e.SceneTransitionEffect.Hexagonalize=o})((e=e||self).IPANORAMA=e.IPANORAMA||{})}(this);