/*!
 * Transition Name: Doom Screen Transition
 */
!function(e){(function(e){"use strict";var t={name:"DoomScreenTransition",effect:function(e,t){this.viewer=t;this.shader={uniforms:{texture1:{value:null},texture2:{value:null},progress:{value:0},time:{value:0},timeDelta:{value:0},resolution:{value:new THREE.Vector2},bars:{value:30},amplitude:{value:2},noise:{value:.1},frequency:{value:.5},dripScale:{value:.5}},vertexShader:["varying vec2 vUv;","void main() {","vUv = uv;","gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);","}"].join("\n"),fragmentShader:["varying vec2 vUv;","uniform sampler2D texture1;","uniform sampler2D texture2;","uniform float progress;","uniform float time;","uniform float timeDelta;","uniform vec2 resolution;","const float PI = 3.141592653589793;","vec4 getFromColor(vec2 uv) {","return texture2D(texture1, uv);","}","vec4 getToColor(vec2 uv) {","return texture2D(texture2, uv);","}","uniform int bars;","uniform float amplitude;","uniform float noise;","uniform float frequency;","uniform float dripScale;","float rand(int num) {","return fract(mod(float(num) * 67123.313, 12.0) * sin(float(num) * 10.3) * cos(float(num)));","}","float wave(int num) {","float fn = float(num) * frequency * 0.1 * float(bars);","return cos(fn * 0.5) * cos(fn * 0.13) * sin((fn+10.0) * 0.3) / 2.0 + 0.5;","}","float drip(int num) {","return sin(float(num) / float(bars - 1) * 3.141592) * dripScale;","}","float pos(int num) {","return (noise == 0.0 ? wave(num) : mix(wave(num), rand(num), noise)) + (dripScale == 0.0 ? 0.0 : drip(num));","}","void main() {","vec2 uv = vUv;","int bar = int(uv.x * (float(bars)));","float scale = 1.0 + pos(bar) * amplitude;","float phase = progress * scale;","float posY = uv.y / vec2(1.0).y;","vec2 p;","vec4 c;","if (phase + posY < 1.0) {","p = vec2(uv.x, uv.y + mix(0.0, vec2(1.0).y, phase)) / vec2(1.0).xy;","c = getFromColor(p);","} else {","p = uv.xy / vec2(1.0).xy;","c = getToColor(p);","}","gl_FragColor = c;","}"].join("\n"),side:THREE.DoubleSide};this.material=new THREE.ShaderMaterial(this.shader);this.init(e)}};t.effect.prototype={init:function(e){},getMaterial:function(){return this.material},destroy:function(){this.material.dispose()},onStart:function(e,t,n){},onUpdate:function(e,t,n){},onComplete:function(e,t){}},e.SceneTransitionEffect=e.SceneTransitionEffect||{},e.SceneTransitionEffect.DoomScreenTransition=t})((e=e||self).IPANORAMA=e.IPANORAMA||{})}(this);