/*!
 * Transition Name: Cross Zoom
 */
!function(e){(function(e){"use strict";var t={name:"CrossZoom",effect:function(e,t){this.viewer=t;this.shader={uniforms:{texture1:{value:null},texture2:{value:null},progress:{value:0},time:{value:0},timeDelta:{value:0},resolution:{value:new THREE.Vector2},strength:{value:.4}},vertexShader:["varying vec2 vUv;","void main() {","vUv = uv;","gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);","}"].join("\n"),fragmentShader:["varying vec2 vUv;","uniform sampler2D texture1;","uniform sampler2D texture2;","uniform float progress;","uniform float time;","uniform float timeDelta;","uniform vec2 resolution;","const float PI = 3.141592653589793;","vec4 getFromColor(vec2 uv) {","return texture2D(texture1, uv);","}","vec4 getToColor(vec2 uv) {","return texture2D(texture2, uv);","}","uniform float strength;","float linearEase(in float begin, in float change, in float duration, in float time) {","return change * time / duration + begin;","}","float exponentialEaseInOut(in float begin, in float change, in float duration, in float time) {","if (time == 0.0)","return begin;","else if (time == duration)","return begin + change;","time = time / (duration / 2.0);","if (time < 1.0)","return change / 2.0 * pow(2.0, 10.0 * (time - 1.0)) + begin;","return change / 2.0 * (-pow(2.0, -10.0 * (time - 1.0)) + 2.0) + begin;","}","float sinusoidalEaseInOut(in float begin, in float change, in float duration, in float time) {","return -change / 2.0 * (cos(PI * time / duration) - 1.0) + begin;","}","float rand (vec2 co) {","return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);","}","vec3 crossFade(in vec2 uv, in float dissolve) {","return mix(getFromColor(uv).rgb, getToColor(uv).rgb, dissolve);","}","void main() {","vec2 uv = vUv;","vec2 texCoord = uv.xy / vec2(1.0).xy;","vec2 center = vec2(linearEase(0.25, 0.5, 1.0, progress), 0.5);","float dissolve = exponentialEaseInOut(0.0, 1.0, 1.0, progress);","float strength = sinusoidalEaseInOut(0.0, strength, 0.5, progress);","vec3 color = vec3(0.0);","float total = 0.0;","vec2 toCenter = center - texCoord;","float offset = rand(uv);","for (float t = 0.0; t <= 40.0; t++) {","float percent = (t + offset) / 40.0;","float weight = 4.0 * (percent - percent * percent);","color += crossFade(texCoord + toCenter * percent * strength, dissolve) * weight;","total += weight;","}","gl_FragColor = vec4(color / total, 1.0);","}"].join("\n"),side:THREE.DoubleSide};this.material=new THREE.ShaderMaterial(this.shader);this.init(e)}};t.effect.prototype={init:function(e){},getMaterial:function(){return this.material},destroy:function(){this.material.dispose()},onStart:function(e,t,o){},onUpdate:function(e,t,o){},onComplete:function(e,t){}},e.SceneTransitionEffect=e.SceneTransitionEffect||{},e.SceneTransitionEffect.CrossZoom=t})((e=e||self).IPANORAMA=e.IPANORAMA||{})}(this);