/*!
  iPanorama 360 - jQuery Virtual Tour Builder
  @name jquery.ipanorama.js
  @description jQuery plugin for creating a 360 degrees panorama viewer and virtual tours
  @author Max Lawrence
  @site https://avirtum.com
  @twitter https://x.com/mxventure
  @copyright (c) Max Lawrence
*/
!function(x,a,i,r){"use strict";var b={getBaseUrl:function(){for(var e=null,o=i.getElementsByTagName("script"),t=0;t<o.length;t++)if(/jquery.ipanorama/.test(o[t].src)){e=o[t].src.substring(o[t].src.lastIndexOf("/")),e=o[t].src.replace(e,"");break}return e},extendSceneCfg:function(e){null==(e=x.extend(!0,{},c.prototype.defaultScene,e)).id&&(e.id=b.uuid(10)),e.camera&&e.camera.pos&&delete e.camera.pos,null==e.pointEditor.image&&h&&(e.pointEditor.image=h+"/images/point-editor.png"),null==e.planeEditor.image&&h&&(e.planeEditor.image=h+"/images/plane-editor.png");for(var o=0;o<e.markers.length;o++){var t=x.extend(!0,{},c.prototype.defaultMarker,e.markers[o]);t.tooltip=x.extend(!0,{},c.prototype.defaultTooltip,t.tooltip),t.popover=x.extend(!0,{},c.prototype.defaultPopover,t.popover),null==t.id&&(t.id=b.uuid(10)),t.sprite?(t.point=x.extend(!0,{},c.prototype.defaultPoint,t.sprite),delete t.sprite):t.point=x.extend(!0,{},c.prototype.defaultPoint,t.point),t.tooltip.hasOwnProperty("active")&&(t.tooltip.enabled=t.tooltip.active,delete t.tooltip.active),t.popover.hasOwnProperty("active")&&(t.popover.enabled=t.popover.active,delete t.popover.active),t.point.yaw=t.yaw,t.point.pitch=t.pitch,null==t.point.image&&h&&(t.point.image=h+"/images/point-blank.png"),e.markers[o]=t}for(o=0;o<e.shapes.length;o++){var i=x.extend(!0,{},c.prototype.defaultShape,e.shapes[o]);null==i.id&&(i.id=b.uuid(10)),e.shapes[o]=i}return e},extendTrackCfg:function(e){return null==(e=x.extend(!0,{},c.prototype.defaultTrack,e)).id&&(e.id=b.uuid(10)),e},changeProtocol:function(e){try{if(e&&"function"==typeof URL){var o=new URL(a.location.href),t="https:";if(o.protocol==t)return(o=new URL(e)).protocol=t,o.href}}catch(e){}return e},isMobile:function(){return/Mobi|Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)},animationEvent:function(){var e,o=i.createElement("fakeelement"),t={animation:"animationend",MSAnimationEnd:"msAnimationEnd",OAnimation:"oAnimationEnd",MozAnimation:"mozAnimationEnd",WebkitAnimation:"webkitAnimationEnd"};for(e in t)if(o.style[e]!==r)return t[e];return null},uuid:function(e){var o=THREE.Math.generateUUID(),o=e?o.replaceAll("-",""):o;return e?o.substring(0,e):o}},l="ipanorama-instance",h=b.getBaseUrl();function c(e,o){this.$container=null,this.$sceneActive=null,this.dom={},this.config=null,this.viewer=null,this.widget=null,this.theme=null,this.scenes=[],this.sceneIndex=0,this.tooltipZindex=[],this.tooltipEnterStack=[],this.tooltipEnterTimerId=null,this.mouse={clientX:0,clientY:0},this.bodyClick=!1,this.inboxMarker=null,this.lightboxMarker=null,this.isFullscreen=!1,this.preloadTimerId=null,this.ready=!1,this.handlers={onWindowResize:x.proxy(this._onWindowResize,this),onWindowClickTooltip:x.proxy(this._onWindowClickTooltip,this),onWindowMouseMoveTooltipEnter:x.proxy(this._onWindowMouseMoveTooltipEnter,this)},this.share={sphere:{},littleplanet:{},flat:{}},this._init(e,o)}c.prototype={VERSION:IPANORAMA.VERSION,defaultConfig:{width:null,height:null,imagePreview:null,theme:"default",viewerMode:"normal",crossOrigin:"anonymous",widget:{name:"default",config:null},sceneTransition:{name:"default",config:null,duration:1500},autoLoad:!0,startSceneId:null,scenes:[],audio:{enabled:!0,autoplay:!1,html5:!0,loop:!1,mute:!1,volume:.6,tracks:[]},preload:{image:null,timeout:1e3,noProgressEvent:!1},tooltip:{hideDelay:500},class:null,onPreInit:null,onLoad:null},defaultScene:{id:null,title:null,type:"sphere",image:null,imageThumb:null,imagePreload:null,noZoom:!1,noRotate:!1,noKeys:!1,noGyroscope:!0,compass:{enabled:!1,northOffset:0},camera:{lookAt:{yaw:0,pitch:0},zoom:null,save:!0,shared:!1},markers:[],shapes:[],pointEditor:{enabled:!1,image:null,width:48,height:48,opacity:1},planeEditor:{enabled:!1,image:null,width:128,height:128,opacity:1,billboard:!1},autoRotate:{enabled:!1,startDelay:3e3,inactivityDelay:3e3,speedX:.5,speedY:0,speedZ:0},audio:{enabled:!0,src:null,autoPlay:!1,loop:!1,stopPrevious:!0,volume:.5}},defaultTrack:{id:null,src:null,title:null,loop:!1,autoplay:!0,sceneId:null},defaultMarker:{id:null,title:null,yaw:0,pitch:0,autoWidth:!0,width:null,autoHeight:!0,height:null,angle:null,image:null,link:null,linkNewWindow:!1,linkSceneId:null,autoFocus:{enabled:!1,duration:700,easing:null},noevents:!1,tooltip:null,popover:null,data:null,dataSelector:null,class:null},defaultPoint:{pos:null,yaw:0,pitch:0,radius:1e3,image:null,width:32,height:32,opacity:1},defaultShape:{id:null,title:null,plane:{pos:{x:0,y:0,z:0},rotate:{x:0,y:0,z:0},width:48,height:48,image:null,opacity:1,billboard:!1}},defaultTooltip:{enabled:!1,placement:"top",offset:{x:0,y:0},autoWidth:!1,width:null,trigger:"hover",followCursor:!1,interactive:!0,showOnInit:!1,showAnimation:null,hideAnimation:null,duration:500,data:null,dataSelector:null,class:null},defaultPopover:{enabled:!1,type:"lightbox",mobileType:"lightbox",trigger:"hover",showOnInit:!1,closeOutside:!0,showAnimation:null,hideAnimation:null,duration:300,data:null,dataSelector:null,class:null},_init:function(e,o){o.wp_plugin_url=b.changeProtocol(o.wp_plugin_url),this.$container=e,this.config=o,this.ready=!1,this._create()},_create:function(){this._buildDOM(),this._bind(),this._buildViewer(),this._ready()},_buildDOM:function(){this.$container.addClass("ipnrm").addClass(this.config.class),null!=this.config.width&&this.$container.css({width:this.config.width}),null!=this.config.height&&this.$container.css({height:this.config.height}),this.dom.$preview=x("<div>").addClass("ipnrm-preview"),this.config.imagePreview&&this.dom.$preview.css({"background-image":"url("+this.config.imagePreview+")"}),this.dom.$canvas=x("<canvas>").addClass("ipnrm-canvas").attr({tabindex:0}),this.dom.$scenes=x("<div>").addClass("ipnrm-scenes"),this.dom.inbox={},this.dom.inbox.$inbox=x("<div>").addClass("ipnrm-inbox").addClass("ipnrm-hide").attr("tabindex",1),this.dom.inbox.$inboxInner=x("<div>").addClass("ipnrm-inner"),this.dom.inbox.$inboxForm=x("<div>").addClass("ipnrm-form"),this.dom.inbox.$inboxBody=x("<div>").addClass("ipnrm-body"),this.dom.inbox.$inboxClose=x("<div>").addClass("ipnrm-close"),this.dom.inbox.$inbox.append(this.dom.inbox.$inboxInner.append(this.dom.inbox.$inboxForm.append(this.dom.inbox.$inboxBody,this.dom.inbox.$inboxClose))),this.dom.lightbox={},this.dom.lightbox.$lightbox=x("<div>").addClass("ipnrm-lightbox").addClass("ipnrm-hide").attr("tabindex",1),this.dom.lightbox.$lightboxInner=x("<div>").addClass("ipnrm-inner"),this.dom.lightbox.$lightboxForm=x("<div>").addClass("ipnrm-form"),this.dom.lightbox.$lightboxBody=x("<div>").addClass("ipnrm-body"),this.dom.lightbox.$lightboxClose=x("<div>").addClass("ipnrm-close"),this.dom.lightbox.$lightbox.append(this.dom.lightbox.$lightboxInner.append(this.dom.lightbox.$lightboxForm.append(this.dom.lightbox.$lightboxBody,this.dom.lightbox.$lightboxClose))),x("body").append(this.dom.lightbox.$lightbox),this.$container.prepend(this.dom.$preview,this.dom.$canvas,this.dom.$scenes,this.dom.inbox.$inbox)},_bind:function(){x(a).get(0).addEventListener("click",this.handlers.onWindowClickTooltip,!0),x(a).get(0).addEventListener("resize",this.handlers.onWindowResize,!0),this.$container.on("fullscreenchange mozfullscreenchange webkitfullscreenchange msfullscreenchange",x.proxy(this._onFullScreenChange,this)),this.$container.on("ipanorama:scene-error",x.proxy(this._onSceneError,this)),this.$container.on("ipanorama:scene-show-start",x.proxy(this._onSceneShowStart,this)),this.$container.on("ipanorama:scene-show-complete",x.proxy(this._onSceneShowComplete,this)),this.$container.on("ipanorama:scene-hide-start",x.proxy(this._onSceneHideStart,this)),this.$container.on("ipanorama:scene-hide-complete",x.proxy(this._onSceneHideComplete,this)),this.$container.on("ipanorama:scene-point-show",x.proxy(this._onScenePointShow,this)),this.$container.on("ipanorama:scene-point-change",x.proxy(this._onScenePointChange,this)),this.$container.on("ipanorama:scene-point-hide",x.proxy(this._onScenePointHide,this)),this.$container.on("ipanorama:config",x.proxy(this._onConfig,this)),this.$container.on("ipanorama:fullscreen",x.proxy(this._onFullscreen,this)),this.$container.on("ipanorama:mode",x.proxy(this._onMode,this)),this.$container.on("ipanorama:set-scene",x.proxy(this._onSetScene,this)),this.$container.on("ipanorama:scene-before-load",x.proxy(this._onSceneBeforeLoad,this)),this.$container.on("ipanorama:scene-after-load",x.proxy(this._onSceneAfterLoad,this)),this.$container.on("ipanorama:prev-scene",x.proxy(this._onPrevScene,this)),this.$container.on("ipanorama:next-scene",x.proxy(this._onNextScene,this)),this.dom.inbox.$inbox.on("keydown",x.proxy(this._onInboxKeyboard,this)),this.dom.inbox.$inbox.on("click",x.proxy(this._onInboxCloseOutsideClick,this)),this.dom.inbox.$inboxClose.on("click",x.proxy(this._onInboxCloseClick,this)),this.dom.lightbox.$lightbox.on("keydown",x.proxy(this._onLightboxKeyboard,this)),this.dom.lightbox.$lightbox.on("click",x.proxy(this._onLightboxCloseOutsideClick,this)),this.dom.lightbox.$lightboxClose.on("click",x.proxy(this._onLightboxCloseClick,this))},_unbind:function(){x(a).get(0).removeEventListener("click",this.handlers.onWindowClickTooltip,!0),x(a).get(0).removeEventListener("resize",this.handlers.onWindowResize,!0),this.$container.off("fullscreenchange mozfullscreenchange webkitfullscreenchange msfullscreenchange",x.proxy(this._onFullScreenChange,this)),this.$container.off("ipanorama:scene-error",x.proxy(this._onSceneError,this)),this.$container.off("ipanorama:scene-show-start",x.proxy(this._onSceneShowStart,this)),this.$container.off("ipanorama:scene-show-complete",x.proxy(this._onSceneShowComplete,this)),this.$container.off("ipanorama:scene-hide-start",x.proxy(this._onSceneHideStart,this)),this.$container.off("ipanorama:scene-hide-complete",x.proxy(this._onSceneHideComplete,this)),this.$container.off("ipanorama:scene-point-show",x.proxy(this._onScenePointShow,this)),this.$container.off("ipanorama:scene-point-change",x.proxy(this._onScenePointChange,this)),this.$container.off("ipanorama:scene-point-hide",x.proxy(this._onScenePointHide,this)),this.$container.off("ipanorama:config",x.proxy(this._onConfig,this)),this.$container.off("ipanorama:fullscreen",x.proxy(this._onFullscreen,this)),this.$container.off("ipanorama:mode",x.proxy(this._onMode,this)),this.$container.off("ipanorama:set-scene",x.proxy(this._onSetScene,this)),this.$container.off("ipanorama:prev-scene",x.proxy(this._onPrevScene,this)),this.$container.off("ipanorama:next-scene",x.proxy(this._onNextScene,this)),this.dom.inbox.$inbox.off("keydown",x.proxy(this._onInboxKeyboard,this)),this.dom.inbox.$inbox.off("click",x.proxy(this._onInboxCloseOutsideClick,this)),this.dom.inbox.$inboxClose.off("click",x.proxy(this._onInboxCloseClick,this)),this.dom.lightbox.$lightbox.off("keydown",x.proxy(this._onLightboxKeyboard,this)),this.dom.lightbox.$lightbox.off("click",x.proxy(this._onLightboxCloseOutsideClick,this)),this.dom.lightbox.$lightboxClose.off("click",x.proxy(this._onLightboxCloseClick,this))},_buildViewer:function(){this.smartRequest=new IPANORAMA.SmartRequest,this.viewer=new IPANORAMA.Viewer({$canvas:this.dom.$canvas,$listener:this.$container},this.smartRequest),this.setWidget(this.config.widget.name,this.config.widget.config),this.setTheme(this.config.theme),this.setViewerMode(this.config.viewerMode),this.setSceneTransitionEffect(this.config.sceneTransition.name,this.config.sceneTransition.config,this.config.sceneTransition.duration)},_ready:function(){this.$container.is(":hidden")&&(this.$container.css("display","block"),this._onWindowResize());var e=this.getQueryParameters().sceneid;if(e){for(var o=!0,t=0;t<this.config.scenes.length;t++)if(this.config.scenes[t].id===e){o=!1;break}o?console.warn("IPANORAMA: Can't find the scene \""+e+'" from URL param'):this.config.startSceneId=e}if(this.config.startSceneId=this.config.startSceneId||this.$container.data("scene-id"),"undefined"!=typeof ipanorama_globals&&ipanorama_globals.settings&&ipanorama_globals.settings.onLoad){var i=null;if("string"==typeof ipanorama_globals.settings.onLoad)try{i=new Function(ipanorama_globals.settings.onLoad)}catch(e){console.error('Can not compile the global "onLoad" function: '+e.message)}else"function"==typeof ipanorama_globals.settings.onLoad&&(i=ipanorama_globals.settings.onLoad);i&&i.call(this)}if(this.config.onLoad){i=null;if("string"==typeof this.config.onLoad)try{i=new Function(this.config.onLoad)}catch(e){console.error('Can not compile the "onLoad" function: '+e.message)}else"function"==typeof this.config.onLoad&&(i=this.config.onLoad);i&&i.call(this)}this.$container.addClass("ipnrm-ready"),this.ready=!0,this.$container.trigger("ipanorama:ready",{instance:this,master:!0});var n=this;setTimeout(function(){if(n.config.autoLoad){const e=new IntersectionObserver((e,o)=>{e.forEach(e=>{e.isIntersecting&&(n._loadStartScene(),o.unobserve(e.target))})},{root:null,rootMargin:"0px",threshold:.1});e.observe(n.$container.get(0))}},200)},_loadStartScene:function(){if(0!=this.config.scenes.length){var e=this.config.scenes[0],o=this.config.startSceneId;if(o){for(var t=!0,i=0;i<this.config.scenes.length;i++)if(this.config.scenes[i].id===o){e=this.config.scenes[i],t=!1;break}t&&console.warn("IPANORAMA: Can't find the start scene \""+o+'"')}this.setScene(e)}},_loadScene:function(e){var o;"gsv"==e.cfg.type?e.load(e.cfg.location):!(o=e.cfg.imagePreload||this.config.preload.image)||e.loaded&&o!=e.image?e.cfg.image&&e.load(e.cfg.image):e.load(o)},_initMarkers:function(e,o){e.ext.dom={},e.ext.dom.$scene=x("<div>").addClass("ipnrm-scene").attr({"data-scene-id":o.id}),e.ext.dom.$markers=x("<div>").addClass("ipnrm-markers"),e.ext.dom.$tooltips=x("<div>").addClass("ipnrm-tooltips"),e.ext.dom.$popovers=x("<div>").addClass("ipnrm-popovers"),this.dom.$scenes.append(e.ext.dom.$scene.append(e.ext.dom.$markers,e.ext.dom.$tooltips,e.ext.dom.$popovers)),e.ext.markers=[];for(var t=0;t<o.markers.length;t++){var i=o.markers[t];this._addMarker(i,e)}this.$container.find(".ipnrm-store").find('[data-scene-id="'+e.cfg.id+'"]').remove()},_addMarker:function(e,o){var t=x("<div>").addClass("ipnrm-marker").addClass(e.class).attr({"data-marker-id":e.id}),i=x("<div>").addClass("ipnrm-pos"),n=x("<div>").addClass("ipnrm-zoom"),s=x("<div>").addClass("ipnrm-offset"),r=x("<div>").addClass("ipnrm-body");e.noevents&&t.addClass("ipnrm-noevents"),e.link&&t.addClass("ipnrm-link"),e.linkSceneId&&t.addClass("ipnrm-link-scene"),"focus"!=e.tooltip.trigger&&!b.isMobile()||t.attr("tabindex",1),e.autoWidth||null==e.width||r.css({width:e.width}),e.autoHeight||null==e.height||r.css({height:e.height}),null!=e.angle&&r.css({transform:"rotate("+e.angle+"deg)"}),e.image&&(v=x("<img>").attr({loading:"lazy",src:e.image}),r.append(v),t.addClass("ipnrm-custom")),e.data?r.html(e.data):e.dataSelector?(f=x(e.dataSelector)).length&&(f.detach(),r.append(f)):(f=this.$container.find('.ipnrm-store [data-scene-id="'+o.cfg.id+'"] .ipnrm-markers-data [data-marker-id="'+e.id+'"]')).length&&((u=f.children()).detach(),r.append(u),t.addClass("ipnrm-custom"),f.remove()),t.append(i.append(n.append(s.append(r)))),o.ext.dom.$markers.append(t);var a=x("<div>").addClass("ipnrm-tooltip").addClass("ipnrm-hide").addClass(e.tooltip.class).attr({"data-marker-id":e.id}),l=x("<div>").addClass("ipnrm-pos"),h=x("<div>").addClass("ipnrm-zoom"),c=x("<div>").addClass("ipnrm-offset"),d=x("<div>").addClass("ipnrm-form"),p=x("<div>").addClass("ipnrm-arrow"),m=x("<div>").addClass("ipnrm-body"),g=x("<div>").addClass("ipnrm-data");(e.tooltip.showAnimation||e.tooltip.hideAnimation)&&e.tooltip.duration&&d.css({"animation-duration":e.tooltip.duration+"ms","-webkit-animation-duration":e.tooltip.duration+"ms"}),e.tooltip.data?g.html(e.tooltip.data):e.tooltip.dataSelector?(f=x(e.tooltip.dataSelector)).length&&(f.detach(),g.append(f)):(f=this.$container.find('.ipnrm-store [data-scene-id="'+o.cfg.id+'"] .ipnrm-tooltips-data [data-marker-id="'+e.id+'"]')).length&&((u=f.contents()).detach(),g.append(u),f.remove()),a.append(l.append(h.append(c.append(d.append(m.append(g),p))))),o.ext.dom.$tooltips.append(a);var f,u,v=x("<div>").addClass("ipnrm-popover").attr({"data-marker-id":e.id}),p=x("<div>").addClass("ipnrm-data");e.popover.data?p.html(e.popover.data):e.popover.dataSelector?(f=x(e.popover.dataSelector)).length&&(f.detach(),p.append(f)):(f=this.$container.find('.ipnrm-store [data-scene-id="'+o.cfg.id+'"] .ipnrm-popovers-data [data-marker-id="'+e.id+'"]')).length&&((u=f.contents()).detach(),p.append(u),f.remove()),v.append(p),o.ext.dom.$popovers.append(v);e={$marker:t,$markerPos:i,$markerZoom:n,$markerOffset:s,$markerBody:r,$tooltip:a,$tooltipPos:l,$tooltipZoom:h,$tooltipOffset:c,$tooltipForm:d,$tooltipBody:m,$tooltipData:g,tooltipVisible:!1,$popoverData:p,popoverVisible:!1,cfg:e};this._bindMarker(e),o.ext.markers.push(e);p=new IPANORAMA.Point(e.cfg.point);p.ext={},p.ext.marker=e,o.addPoint(p),this._updateBodyClick(o)},_initShapes:function(e,o){e.ext.shapes=[];for(var t=0;t<o.shapes.length;t++){var i=o.shapes[t];this._addShape(i,e)}},_addShape:function(e,o){var e={cfg:e},t=new IPANORAMA.Plane(e.cfg.plane);t.ext={},t.ext.shape=e,o.addPlane(t)},_bindMarker:function(e){switch(e.$marker.on("click",x.proxy(this._onMarkerClick,this,e)),e.cfg.tooltip.trigger){case"hover":e.$marker.on("mouseenter",x.proxy(this._onMarkerEnterTooltip,this,e)),e.$marker.on("mouseleave",x.proxy(this._onMarkerLeaveTooltip,this,e)),b.isMobile()&&(e.$marker.on("focus",x.proxy(this._onMarkerFocusTooltip,this,e)),e.$marker.on("blur",x.proxy(this._onMarkerBlurTooltip,this,e)));break;case"enter":e.$marker.on("mouseenter",x.proxy(this._onMarkerEnterTooltip,this,e)),b.isMobile()&&(e.$marker.on("focus",x.proxy(this._onMarkerFocusTooltip,this,e)),e.$marker.on("blur",x.proxy(this._onMarkerBlurTooltip,this,e)));break;case"focus":e.$marker.on("focus",x.proxy(this._onMarkerFocusTooltip,this,e)),e.$marker.on("blur",x.proxy(this._onMarkerBlurTooltip,this,e));break;case"click":case"clickbody":e.$marker.on("click",x.proxy(this._onMarkerClickTooltip,this,e))}switch(e.cfg.popover.trigger){case"hover":e.$marker.on("mouseenter",x.proxy(this._onMarkerEnterPopover,this,e)),e.$marker.on("mouseleave",x.proxy(this._onMarkerLeavePopover,this,e)),b.isMobile()&&(e.$marker.on("focus",x.proxy(this._onMarkerFocusPopover,this,e)),e.$marker.on("blur",x.proxy(this._onMarkerBlurPopover,this,e)));break;case"focus":e.$marker.on("focus",x.proxy(this._onMarkerFocusPopover,this,e)),e.$marker.on("blur",x.proxy(this._onMarkerBlurPopover,this,e));break;case"click":e.$marker.on("click",x.proxy(this._onMarkerClickPopover,this,e));break;case"dblclick":e.$marker.on("dblclick",x.proxy(this._onMarkerClickPopover,this,e))}},_updateBodyClick:function(e){for(var o=0;o<e.ext.markers.length;o++){var t=e.ext.markers[o];if("clickbody"==t.cfg.tooltip.trigger||"focus"==t.cfg.tooltip.trigger){this.bodyClick=!0;break}}},_updateTooltipEnter:function(){x(a).get(0).removeEventListener("mousemove",this.handlers.onWindowMouseMoveTooltipEnter,!0),this.tooltipEnterTimerId=null;for(var e=[],o=0;o<this.tooltipEnterStack.length;o++){var t=this.tooltipEnterStack[o],i=t.$markerBody.get(0).getBoundingClientRect();this.mouse.clientX<i.left||this.mouse.clientX>i.right||this.mouse.clientY<i.top||this.mouse.clientY>i.bottom?t.cfg.tooltip.interactive?(i=t.$tooltipBody.get(0).getBoundingClientRect(),this.mouse.clientX<i.left||this.mouse.clientX>i.right||this.mouse.clientY<i.top||this.mouse.clientY>i.bottom?this._hideTooltip(t):e.push(t)):this._hideTooltip(t):e.push(t)}this.tooltipEnterStack=e,this.tooltipEnterStack.length&&x(a).get(0).addEventListener("mousemove",this.handlers.onWindowMouseMoveTooltipEnter,!0)},_pauseAudioVideo:function(e){e.find("audio").each(function(){x(this).get(0).pause()}),e.find("video").each(function(){x(this).get(0).pause()})},_showTooltip:function(e,o,t){if(e&&e.cfg.tooltip.enabled){var i=e.cfg.tooltip.offset.y,n=e.cfg.tooltip.offset.x,s="hover"==e.cfg.tooltip.trigger&&e.cfg.tooltip.followCursor?5:e.$markerBody.outerHeight()/2,r="hover"==e.cfg.tooltip.trigger&&e.cfg.tooltip.followCursor?5:e.$markerBody.outerWidth()/2;switch(o=o||!1,t=t||e.cfg.tooltip.placement,e.$tooltip.removeClass(e.$tooltip.data("placement")),e.$tooltip.addClass("ipnrm-"+t).data("placement","ipnrm-"+t),t){case"top-left":s=-s,r=-r,i=-i;break;case"top":s=-s,i=-i,n=r=0;break;case"top-right":s=-s,i=-i,n=-n;break;case"right-top":s=-s;break;case"right":i=s=0;break;case"right-bottom":i=-i;break;case"bottom-right":n=-n;break;case"bottom":n=r=0;break;case"bottom-left":r=-r;break;case"left-bottom":r=-r,i=-i,n=-n;break;case"left":r=-r,i=s=0,n=-n;break;case"left-top":s=-s,r=-r,n=-n;break;default:s=r=e.cfg.tooltip.followCursor?5:0}e.$tooltipOffset.css({"margin-top":s,"margin-left":r}),e.cfg.tooltip.followCursor&&"hover"==e.cfg.tooltip.trigger&&(e.$markerBody.on("mousemove",x.proxy(this._onMarkerMouseMoveTooltip,this,e)),e.$tooltip.addClass("ipnrm-noevents-hard")),e.$tooltipPos.css({"margin-top":i,"margin-left":n}),e.tooltipVisible||(e.tooltipVisible=!0,e.$tooltip.addClass("ipnrm-show").removeClass("ipnrm-hide"),t=0<this.tooltipZindex.length?Math.max.apply(null,this.tooltipZindex)+1:1,this.tooltipZindex.push(t),e.$tooltipPos.css("z-index",t),o&&e.cfg.tooltip.showAnimation&&(e.$tooltipForm.removeClass(e.cfg.tooltip.showAnimation).removeClass(e.cfg.tooltip.hideAnimation),e.$tooltipForm.addClass(e.cfg.tooltip.showAnimation),e.$tooltipForm.one(b.animationEvent(),x.proxy(function(e,o){x(o.target).removeClass(e.cfg.tooltip.showAnimation)},this,e))),"enter"==e.cfg.tooltip.trigger&&(this.tooltipEnterStack.push(e),a.addEventListener("mousemove",this.handlers.onWindowMouseMoveTooltipEnter,!0)),this.$container.trigger("ipanorama:tooltip-show",{marker:e}))}},_hideTooltip:function(e){e.$markerBody.off("mousemove",x.proxy(this._onMarkerMouseMoveTooltip,e,this)),e.$tooltip.removeClass("ipnrm-noevents-hard"),e.tooltipVisible&&(e.tooltipVisible=!1,e.cfg.tooltip.hideAnimation?(e.$tooltipForm.removeClass(e.cfg.tooltip.showAnimation).removeClass(e.cfg.tooltip.hideAnimation),e.$tooltipForm.addClass(e.cfg.tooltip.hideAnimation),e.$tooltipForm.one(b.animationEvent(),x.proxy(function(e,o){x(o.target).removeClass(e.cfg.tooltip.hideAnimation),e.tooltipVisible||this.__hideTooltip(e)},this,e))):this.__hideTooltip(e))},__hideTooltip:function(e){e.$tooltip.addClass("ipnrm-hide").removeClass("ipnrm-show");var o=this.tooltipZindex.indexOf(parseInt(e.$tooltipPos.css("z-index"),10));-1<o&&this.tooltipZindex.splice(o,1),e.$tooltipPos.css("z-index",""),e.$tooltipData.detach(),e.$tooltipData.get(0).offsetHeight,this._pauseAudioVideo(e.$tooltipData),e.$tooltipData.appendTo(e.$tooltipBody),this.$container.trigger("ipanorama:tooltip-hide",{marker:e})},_showPopover:function(e,o){if(e&&e.cfg.popover.enabled){var t=b.isMobile()?e.cfg.popover.mobileType:e.cfg.popover.type;switch(t=this.isFullscreen?"inbox":t){case"inbox":this._showPopoverInbox(e,o);break;case"lightbox":this._showPopoverLightbox(e,o)}}},_hidePopover:function(e){if(e)switch(b.isMobile()?e.cfg.popover.mobileType:e.cfg.popover.type){case"inbox":this._hidePopoverInbox();break;case"lightbox":this._hidePopoverLightbox()}},_showPopoverInbox:function(e,o){this.inboxMarker&&this._hidePopover(this.inboxMarker),this.inboxMarker=e,this.inboxMarker.$popoverData.detach();var t=this.inboxMarker.$popoverData.attr("style");this.inboxMarker.$popoverData.data("style",t),this.inboxMarker.$popoverData.attr("style",""),this.dom.inbox.$inbox.addClass(this.inboxMarker.cfg.popover.class),this.dom.inbox.$inboxBody.append(e.$popoverData),this.dom.inbox.$inboxBody.get(0).offsetHeight,this.dom.inbox.$inbox.addClass("ipnrm-show").removeClass("ipnrm-hide").focus(),o&&e.cfg.popover.showAnimation&&(this.dom.inbox.$inboxForm.removeClass(e.cfg.popover.showAnimation).removeClass(e.cfg.popover.hideAnimation),this.dom.inbox.$inboxForm.addClass(e.cfg.popover.showAnimation),this.dom.inbox.$inboxForm.one(b.animationEvent(),x.proxy(function(e,o){x(o.target).removeClass(e.cfg.popover.showAnimation)},this,e))),this.$container.trigger("ipanorama:popover-show",{marker:e})},_hidePopoverInbox:function(){var e=this.inboxMarker;e&&(e.cfg.popover.hideAnimation?(this.dom.inbox.$inboxForm.removeClass(e.cfg.popover.showAnimation).removeClass(e.cfg.popover.hideAnimation),this.dom.inbox.$inboxForm.addClass(e.cfg.popover.hideAnimation),this.dom.inbox.$inboxForm.one(b.animationEvent(),x.proxy(function(e,o){x(o.target).removeClass(e.cfg.popover.hideAnimation),this.__hidePopoverInbox(e)},this,e))):this.__hidePopoverInbox(e)),this.inboxMarker=null},__hidePopoverInbox:function(e){e.$popoverData.detach(),e.$popoverData.get(0).offsetHeight,this._pauseAudioVideo(e.$popoverData);var o=e.$popoverData.data("style");e.$popoverData.attr("style",o),e.$popoverData.data("style",""),this.$sceneActive&&this.$sceneActive.find('.ipnrm-popover[data-marker-id="'+e.cfg.id+'"]').append(e.$popoverData),this.dom.inbox.$inbox.removeClass(e.cfg.popover.class),this.dom.inbox.$inbox.addClass("ipnrm-hide").removeClass("ipnrm-show"),this.$container.trigger("ipanorama:popover-hide",{marker:e})},_showPopoverLightbox:function(e,o){this.lightboxMarker&&this._hidePopover(this.lightboxMarker),this.lightboxMarker=e,this.lightboxMarker.$popoverData.detach();var t=this.lightboxMarker.$popoverData.attr("style");this.lightboxMarker.$popoverData.data("style",t),this.lightboxMarker.$popoverData.attr("style",""),this.dom.lightbox.$lightbox.addClass(this.lightboxMarker.cfg.popover.class),this.dom.lightbox.$lightboxBody.append(e.$popoverData),this.dom.lightbox.$lightboxBody.get(0).offsetHeight,this.dom.lightbox.$lightbox.detach(),x("body").append(this.dom.lightbox.$lightbox),this.dom.lightbox.$lightbox.addClass("ipnrm-show").removeClass("ipnrm-hide").focus(),o&&e.cfg.popover.showAnimation&&(this.dom.lightbox.$lightboxForm.removeClass(e.cfg.popover.showAnimation).removeClass(e.cfg.popover.hideAnimation),this.dom.lightbox.$lightboxForm.addClass(e.cfg.popover.showAnimation),this.dom.lightbox.$lightboxForm.one(b.animationEvent(),x.proxy(function(e,o){x(o.target).removeClass(e.cfg.popover.showAnimation)},this,e))),this.$container.trigger("ipanorama:popover-show",{marker:e})},_hidePopoverLightbox:function(){var e=this.lightboxMarker;e&&(e.cfg.popover.hideAnimation?(this.dom.lightbox.$lightboxForm.removeClass(e.cfg.popover.showAnimation).removeClass(e.cfg.popover.hideAnimation),this.dom.lightbox.$lightboxForm.addClass(e.cfg.popover.hideAnimation),this.dom.lightbox.$lightboxForm.one(b.animationEvent(),x.proxy(function(e,o){x(o.target).removeClass(e.cfg.popover.hideAnimation),this.__hidePopoverLightbox(e)},this,e))):this.__hidePopoverLightbox(e)),this.lightboxMarker=null},__hidePopoverLightbox:function(e){e.$popoverData.detach(),e.$popoverData.get(0).offsetHeight,this._pauseAudioVideo(e.$popoverData);var o=e.$popoverData.data("style");e.$popoverData.attr("style",o),e.$popoverData.data("style",""),this.$sceneActive&&this.$sceneActive.find('.ipnrm-popover[data-marker-id="'+e.cfg.id+'"]').append(e.$popoverData),this.dom.lightbox.$lightbox.removeClass(e.cfg.popover.class),this.dom.lightbox.$lightbox.addClass("ipnrm-hide").removeClass("ipnrm-show"),this.$container.trigger("ipanorama:popover-hide",{marker:e})},_lookAtMarker:function(e){var o=x.Deferred(),t=this.viewer.sceneActive;return e.cfg.autoFocus.enabled&&t&&t.control&&t.control.lookAt?t.control.lookAt(e.cfg.point.pos||{yaw:e.cfg.point.yaw,pitch:e.cfg.point.pitch},e.cfg.autoFocus.duration,e.cfg.autoFocus.easing).then(function(){o.resolve()},function(){o.reject()}):o.resolve(),o.promise()},_onMarkerClick:function(e,o){var t=this;t._lookAtMarker(e).then(function(){e.cfg.link&&a.open(e.cfg.link,e.cfg.linkNewWindow?"_blank":"_self"),e.cfg.linkSceneId&&t.setScene({id:e.cfg.linkSceneId})})},_onMarkerEnterTooltip:function(e,o){this._showTooltip(e,!0)},_onMarkerLeaveTooltip:function(e,o){o=o.target||o.relatedTarget||o.toElement;e.cfg.tooltip.interactive&&(0!==e.$tooltip.has(o).length||e.$tooltip.is(o))||e.$markerBody.is(o)?e.$tooltip.one("mouseleave",x.proxy(this._onMarkerLeaveTooltip,this,e)):this._hideTooltip(e)},_onMarkerFocusTooltip:function(e,o){},_onMarkerBlurTooltip:function(e,o){},_onMarkerClickTooltip:function(e,o){e.tooltipVisible?this._hideTooltip(e):this._showTooltip(e,!0)},_onMarkerMouseMoveTooltip:function(e,o){},_onWindowClickTooltip:function(e){if(this.bodyClick&&0<=this.sceneIndex&&this.sceneIndex<this.scenes.length)for(var o=this.scenes[this.sceneIndex],t=e.target||e.relatedTarget||e.toElement,i=0;i<o.ext.markers.length;i++){var n=o.ext.markers[i];0<n.$marker.has(t).length||n.$marker.is(t)||n.tooltipVisible&&("clickbody"==n.cfg.tooltip.trigger||"focus"==n.cfg.tooltip.trigger&&!n.$marker.is(":focus"))&&(!n.tooltipVisible||n.cfg.tooltip.interactive&&(0!==n.$tooltip.has(t).length||n.$tooltip.is(t))||this._hideTooltip(n))}},_onWindowMouseMoveTooltipEnter:function(e){this.mouse.clientX=e.clientX,this.mouse.clientY=e.clientY,this.tooltipEnterTimerId||(this.tooltipEnterTimerId=setTimeout(x.proxy(this._updateTooltipEnter,this),this.config.tooltip.hideDelay))},_onMarkerEnterPopover:function(e,o){this._showPopover(e,!0)},_onMarkerLeavePopover:function(e,o){},_onMarkerFocusPopover:function(e,o){},_onMarkerBlurPopover:function(e,o){},_onMarkerClickPopover:function(e,o){e.popoverVisible?this._hidePopover(e):this._showPopover(e,!0)},_onInboxCloseOutsideClick:function(e){var o=this.inboxMarker;o&&o.cfg.popover.closeOutside&&(e=e.target||e.relatedTarget||e.toElement,0!==this.dom.inbox.$inboxForm.has(e).length||this.dom.inbox.$inboxForm.is(e)||this._hidePopoverInbox())},_onInboxCloseClick:function(e){this._hidePopoverInbox()},_onInboxKeyboard:function(e){27===e.keyCode&&this._hidePopoverInbox()},_onLightboxCloseOutsideClick:function(e){var o=this.lightboxMarker;o&&o.cfg.popover.closeOutside&&(e=e.target||e.relatedTarget||e.toElement,0!==this.dom.lightbox.$lightboxForm.has(e).length||this.dom.lightbox.$lightboxForm.is(e)||this._hidePopoverLightbox())},_onLightboxCloseClick:function(e){this._hidePopoverLightbox()},_onLightboxKeyboard:function(e){27===e.keyCode&&this._hidePopoverLightbox()},_onWindowResize:function(){var e=this.$container.width(),o=this.$container.height();this.viewer.onWindowResize(e,o);for(var t=0;t<this.scenes.length;t++)this.scenes[t].onWindowResize(e,o)},_onSceneError:function(){this.$container.removeClass("ipnrm-scene-active")},_onSceneShowStart:function(e,o){this.$container.addClass("ipnrm-scene-active");for(var t=0;t<this.config.scenes.length;t++)if(this.config.scenes[t].id==o.scene.cfg.id){this.$container.trigger("ipanorama:scene-index",{scene:o.scene,index:t,len:this.config.scenes.length,first:0==t,last:t==this.config.scenes.length-1,config:this.config,master:!0});break}},_onSceneShowComplete:function(e,o){if(this.dom.$scenes.find('[data-scene-id="'+o.scene.cfg.id+'"]').addClass("ipnrm-active"),o.scene){for(var t=null,i=0;i<o.scene.ext.markers.length;i++){var n=o.scene.ext.markers[i];!n.cfg.tooltip.showOnInit&&"sticky"!=n.cfg.tooltip.trigger||this._showTooltip(n),n.cfg.popover.showOnInit&&(t=n)}t&&this._showPopover(t)}},_onSceneHideStart:function(e,o){this.dom.$scenes.find('[data-scene-id="'+o.scene.cfg.id+'"]').removeClass("ipnrm-active")},_onSceneHideComplete:function(e,o){},_onScenePointShow:function(e,o){o.point&&o.point.ext&&(o.point.ext.marker.$markerPos.css({left:o.point.screenPos.x+"px",top:o.point.screenPos.y+"px"}),o.point.ext.marker.$tooltipPos.css({left:o.point.screenPos.x+"px",top:o.point.screenPos.y+"px"}),o.point.ext.marker.$marker.addClass("ipnrm-active"),o.point.ext.marker.$tooltip.addClass("ipnrm-active"))},_onScenePointChange:function(e,o){o.point&&o.point.ext&&(o.point.ext.marker.$markerPos.css({left:o.point.screenPos.x+"px",top:o.point.screenPos.y+"px"}),o.point.ext.marker.$tooltipPos.css({left:o.point.screenPos.x+"px",top:o.point.screenPos.y+"px"}))},_onScenePointHide:function(e,o){o.point&&o.point.ext&&(o.point.ext.marker.$marker.removeClass("ipnrm-active"),o.point.ext.marker.$tooltip.removeClass("ipnrm-active"))},_onConfig:function(e,o){o||this.$container.trigger("ipanorama:config",{config:this.config,master:!0})},_onFullscreen:function(e,o){if(!o)if(this.$container.hasClass("ipnrm-fullscreen"))try{i.exitFullscreen?i.exitFullscreen():i.mozCancelFullScreen?i.mozCancelFullScreen():i.webkitCancelFullScreen?i.webkitCancelFullScreen():i.msExitFullscreen&&i.msExitFullscreen()}catch(e){console.error("The browser does not support the fullscreen API")}else try{var t=this.$container.get(0);t.requestFullscreen?t.requestFullscreen():t.mozRequestFullScreen?t.mozRequestFullScreen():t.webkitRequestFullscreen?t.webkitRequestFullscreen():t.msRequestFullscreen&&t.msRequestFullscreen()}catch(e){console.error("The browser does not support the fullscreen API")}},_onFullScreenChange:function(e){i.fullscreen||i.mozFullScreen||i.webkitIsFullScreen||i.msFullscreenElement?(this.$container.addClass("ipnrm-fullscreen"),this.isFullscreen=!0):(this.$container.removeClass("ipnrm-fullscreen"),this.isFullscreen=!1),this.$container.get(0).offsetHeight,this._onWindowResize(),this.$container.trigger("ipanorama:fullscreen",{fullscreen:this.$container.hasClass("ipnrm-fullscreen"),master:!0})},_onMode:function(e,o){o&&o.master||this.setViewerMode(o.mode)},_onSetScene:function(e,o){o&&o.id&&this.setScene({id:o.id})},_onSceneBeforeLoad:function(e,o){clearTimeout(this.preloadTimerId)},_onSceneAfterLoad:function(e,o){var t=this,i=o.scene,n=(n=i.cfg.imagePreload||t.config.preload.image)&&n.replace(/(^\w+:|^)\/\//,""),o=i.image&&"string"==typeof i.image?i.image.replace(/(^\w+:|^)\/\//,""):i.image;!n||o&&n!=o||(t.preloadTimerId=setTimeout(function(){i.load(i.cfg.image,t.config.preload.noProgressEvent)},t.config.preload.timeout))},_onPrevScene:function(e){this.prevScene()},_onNextScene:function(e){this.nextScene()},getQueryParameters:function(){var e=location.search.slice(1),i={};return e.replace(/([^=]*)=([^&]*)&*/g,function(e,o,t){i[o]=t}),i},loadStartScene:function(){this._loadStartScene()},setWidget:function(e,o){var t=null;if(e){for(var i in IPANORAMA.Widget)if(IPANORAMA.Widget.hasOwnProperty(i)){i=IPANORAMA.Widget[i];if(i.name.toLowerCase()==e.toLowerCase()){t=i;break}}if(null==t)return void console.warn("IPANORAMA: Can't find a widget \""+e+'"')}this.widget&&(this.widget.destroy(),this.widget=null),t&&(this.widget=new t.widget(this,o),this.widget.init())},setTheme:function(e){this.theme&&this.$container.removeClass(this.theme),this.theme&&this.dom.lightbox.$lightbox.removeClass(this.theme),this.theme="ipnrm-theme-"+e,this.$container.addClass(this.theme),this.dom.lightbox.$lightbox.addClass(this.theme)},setViewerMode:function(e){this.viewer.setMode(e),"stereo"==e?this.$container.addClass("ipnrm-mode-stereo"):this.$container.removeClass("ipnrm-mode-stereo"),this._onWindowResize(),this.$container.trigger("ipanorama:mode",{mode:e,master:!0})},setScene:function(e,o){if(!e)return this.viewer.setScene(null),this.$container.removeClass("ipnrm-scene-active"),this.$sceneActive=null;o=o===r||o;for(var e=b.extendSceneCfg(e),t=null,i=!1,n=0;n<this.config.scenes.length;n++)if((t=this.config.scenes[n]).id==e.id){e=t,i=!0;break}if(i||(this.config.scenes.push(e),n++),this.sceneIndex=n,this.viewer.sceneActive&&(t=this.viewer.sceneActive).cfg.camera.shared&&t.control)switch(t.cfg.type){case"sphere":case"cube":case"gsv":this.share.sphere.camera={lookAt:t.control.getLookAt(),zoom:t.control.getZoom()};break;case"littleplanet":this.share.littleplanet.camera={lookAt:t.control.getLookAt(),zoom:t.control.getZoom()};break;case"flat":this.share.flat.camera={lookAt:t.control.getLookAt(),zoom:t.control.getZoom()}}t=null;for(n=0;n<this.scenes.length;n++)if((t=this.scenes[n]).cfg.id==e.id){if(t.control)if(t.cfg.camera.shared)switch(t.cfg.type){case"sphere":case"cube":case"gsv":t.control.setZoom(this.share.sphere.camera.zoom),t.control.lookAt(this.share.sphere.camera.lookAt);break;case"littleplanet":t.control.setZoom(this.share.littleplanet.camera.zoom),t.control.lookAt(this.share.littleplanet.camera.lookAt);break;case"flat":t.control.setZoom(this.share.flat.camera.zoom),t.control.lookAt(this.share.flat.camera.lookAt)}else t.cfg.camera.save||(t.control.setZoom(e.camera.zoom),t.control.lookAt(e.camera.lookAt));return this.viewer.setScene(t,!1),o&&this._loadScene(t),t}switch(e.type){case"sphere":t=new IPANORAMA.Scene.Sphere(e,this.viewer,this.smartRequest);break;case"cube":t=new IPANORAMA.Scene.Cube(e,this.viewer,this.smartRequest);break;case"gsv":t=new IPANORAMA.Scene.GoogleStreetView(e,this.viewer,this.smartRequest);break;case"littleplanet":t=new IPANORAMA.Scene.LittlePlanet(e,this.viewer,this.smartRequest);break;case"flat":t=new IPANORAMA.Scene.Flat(e,this.viewer,this.smartRequest)}if(t){t.ext={},this._initMarkers(t,e),this._initShapes(t,e),this.$sceneActive=t.ext.dom.$scene,this.scenes.push(t);var s=null;if(e.camera.shared)switch(t.cfg.type){case"sphere":case"cube":case"gsv":this.share.sphere.camera&&(s=this.share.sphere.camera);break;case"littleplanet":this.share.littleplanet.camera&&(s=this.share.littleplanet.camera);break;case"flat":this.share.flat.camera&&(s=this.share.flat.camera)}return t.control&&(t.control.setZoom((s||e.camera).zoom),t.control.lookAt({yaw:(s||e.camera).lookAt.yaw,pitch:(s||e.camera).lookAt.pitch}),t.control.noZoom=e.noZoom,t.control.noRotate=e.noRotate,t.control.noKeys=e.noKeys,t.control.noGyroscope=e.noGyroscope),this.viewer.setScene(t,!1),o&&this._loadScene(t),t}return console.warn("IPANORAMA: can't find a scene type \""+e.type+'"'),null},getSceneById:function(e){for(var o=0;o<this.scenes.length;o++){var t=this.scenes[o];if(t.cfg.id==e)return t}return null},removeSceneById:function(e){for(var o=null,t=this.scenes.length,i=0;i<t;i++)if(this.scenes[i].cfg.id==e){o=i;break}return null!=o&&(0<=o&&o<t&&(this.scenes[o].destroy(),this.scenes.splice(o,1),!0))},prevScene:function(e){if(this.sceneIndex=Math.max(0,Math.min(this.config.scenes.length-1,this.sceneIndex)),this.sceneIndex=this.sceneIndex-1,this.sceneIndex<0&&e)this.sceneIndex=this.config.scenes.length-1;else if(this.sceneIndex<0)return;e=this.config.scenes[this.sceneIndex];this.setScene(e)},nextScene:function(e){if(this.sceneIndex=Math.max(0,Math.min(this.config.scenes.length-1,this.sceneIndex)),this.sceneIndex=this.sceneIndex+1,this.sceneIndex>=this.config.scenes.length&&e)this.sceneIndex=0;else if(this.sceneIndex>=this.config.scenes.length)return;e=this.config.scenes[this.sceneIndex];this.setScene(e)},setSceneTransitionEffect:function(e,o,t){this.viewer.setSceneTransitionEffect(e,o),this.viewer.setSceneTransitionDuration(t)},lookAt:function(e,o,t){var i=x.Deferred(),n=this.viewer.sceneActive;return n&&n.control&&n.control.lookAt?n.control.lookAt(e,o,t).then(function(){i.resolve()},function(){i.reject()}):i.resolve(),i.promise()}},x.fn.ipanorama=function(t,e){if("instance"!=t)return this.each(function(){var i=x(this),n=i.data(l),e=i.data("json-src"),s=x.isPlainObject(t)?t:e?null:{};if("destroy"==t)return n?(i.removeData(l),void n._destroy()):void console.error('Calling "destroy" method on not initialized instance is forbidden');function o(){var e=x.extend(!0,{},c.prototype.defaultConfig,s);e.baseUrl&&(h=e.baseUrl);for(var o=0;o<e.scenes.length;o++)e.scenes[o]=b.extendSceneCfg(e.scenes[o]);for(o=0;o<e.audio.tracks.length;o++)e.audio.tracks[o]=b.extendTrackCfg(e.audio.tracks[o]);if(e.onPreInit){var t=null;if("string"==typeof e.onPreInit)try{t=new Function("config",e.onPreInit)}catch(e){console.error('Can not compile "onPreInit" function: '+e.message)}else"function"==typeof e.onPreInit&&(t=e.onPreInit);t&&t.call(this,e)}n=new c(i,e),i.data(l,n)}n&&(i.removeData(l),n._destroy(),n=null),null==s?(e=b.changeProtocol(e),x.ajax({url:e,type:"GET",dataType:"json"}).done(function(e){s=x.isPlainObject(e)?e:{}}).fail(function(){s={}}).always(function(){o()})):o()});var o=x(this).data(l);return o||void console.error('Calling "instance" method on not initialized instance is forbidden')},x(".ipanorama").ipanorama()}(jQuery,window,document);