/*!
  iPanorama 360 - Virtual Tour Builder
  @name ipanorama.js
  @description the plugin for creating a 360 degrees panorama viewer and virtual tours
  @author Max Lawrence
  @site https://avirtum.com
  @twitter https://x.com/mxventure
  @copyright (c) Max Lawrence
*/
!function(e){(function(j){"use strict";var a="1.8.0",ie=jQuery,ae=1e-7,oe=1e-4,re=Math.PI/180,se=180/Math.PI,W=function(){"use strict";var e=function(){this.init()};e.prototype={init:function(){var e=this||E;e._counter=1e3;e._html5AudioPool=[];e.html5PoolSize=10;e._codecs={};e._howls=[];e._muted=false;e._volume=1;e._canPlayEvent="canplaythrough";e._navigator=typeof window!=="undefined"&&window.navigator?window.navigator:null;e.masterGain=null;e.noAudio=false;e.usingWebAudio=true;e.autoSuspend=true;e.ctx=null;e.autoUnlock=true;e._setup();return e},volume:function(e){var t=this||E;e=parseFloat(e);if(!t.ctx)d();if(typeof e!=="undefined"&&e>=0&&e<=1){t._volume=e;if(t._muted)return t;if(t.usingWebAudio)t.masterGain.gain.setValueAtTime(e,E.ctx.currentTime);for(var n=0;n<t._howls.length;n++)if(!t._howls[n]._webAudio){var i=t._howls[n]._getSoundIds();for(var a=0;a<i.length;a++){var o=t._howls[n]._soundById(i[a]);if(o&&o._node)o._node.volume=o._volume*e}}return t}return t._volume},mute:function(e){var t=this||E;if(!t.ctx)d();t._muted=e;if(t.usingWebAudio)t.masterGain.gain.setValueAtTime(e?0:t._volume,E.ctx.currentTime);for(var n=0;n<t._howls.length;n++)if(!t._howls[n]._webAudio){var i=t._howls[n]._getSoundIds();for(var a=0;a<i.length;a++){var o=t._howls[n]._soundById(i[a]);if(o&&o._node)o._node.muted=e?true:o._muted}}return t},stop:function(){var e=this||E;for(var t=0;t<e._howls.length;t++)e._howls[t].stop();return e},unload:function(){var e=this||E;for(var t=e._howls.length-1;t>=0;t--)e._howls[t].unload();if(e.usingWebAudio&&e.ctx&&typeof e.ctx.close!=="undefined"){e.ctx.close();e.ctx=null;d()}return e},codecs:function(e){return(this||E)._codecs[e.replace(/^x-/,"")]},_setup:function(){var t=this||E;t.state=t.ctx?t.ctx.state||"suspended":"suspended";t._autoSuspend();if(!t.usingWebAudio)if(typeof Audio!=="undefined")try{var e=new Audio;if(typeof e.oncanplaythrough==="undefined")t._canPlayEvent="canplay"}catch(e){t.noAudio=true}else t.noAudio=true;try{var e=new Audio;if(e.muted)t.noAudio=true}catch(e){}if(!t.noAudio)t._setupCodecs();return t},_setupCodecs:function(){var t=this||E;var e=null;try{e=typeof Audio!=="undefined"?new Audio:null}catch(e){return t}if(!e||typeof e.canPlayType!=="function")return t;var n=e.canPlayType("audio/mpeg;").replace(/^no$/,"");var i=t._navigator&&t._navigator.userAgent.match(/OPR\/([0-6].)/g);var a=i&&parseInt(i[0].split("/")[1],10)<33;t._codecs={mp3:!!(!a&&(n||e.canPlayType("audio/mp3;").replace(/^no$/,""))),mpeg:!!n,opus:!!e.canPlayType('audio/ogg; codecs="opus"').replace(/^no$/,""),ogg:!!e.canPlayType('audio/ogg; codecs="vorbis"').replace(/^no$/,""),oga:!!e.canPlayType('audio/ogg; codecs="vorbis"').replace(/^no$/,""),wav:!!(e.canPlayType('audio/wav; codecs="1"')||e.canPlayType("audio/wav")).replace(/^no$/,""),aac:!!e.canPlayType("audio/aac;").replace(/^no$/,""),caf:!!e.canPlayType("audio/x-caf;").replace(/^no$/,""),m4a:!!(e.canPlayType("audio/x-m4a;")||e.canPlayType("audio/m4a;")||e.canPlayType("audio/aac;")).replace(/^no$/,""),m4b:!!(e.canPlayType("audio/x-m4b;")||e.canPlayType("audio/m4b;")||e.canPlayType("audio/aac;")).replace(/^no$/,""),mp4:!!(e.canPlayType("audio/x-mp4;")||e.canPlayType("audio/mp4;")||e.canPlayType("audio/aac;")).replace(/^no$/,""),weba:!!e.canPlayType('audio/webm; codecs="vorbis"').replace(/^no$/,""),webm:!!e.canPlayType('audio/webm; codecs="vorbis"').replace(/^no$/,""),dolby:!!e.canPlayType('audio/mp4; codecs="ec-3"').replace(/^no$/,""),flac:!!(e.canPlayType("audio/x-flac;")||e.canPlayType("audio/flac;")).replace(/^no$/,"")};return t},_unlockAudio:function(){var s=this||E;if(s._audioUnlocked||!s.ctx)return;s._audioUnlocked=false;s.autoUnlock=false;if(!s._mobileUnloaded&&s.ctx.sampleRate!==44100){s._mobileUnloaded=true;s.unload()}s._scratchBuffer=s.ctx.createBuffer(1,1,22050);var l=function(e){while(s._html5AudioPool.length<s.html5PoolSize)try{var t=new Audio;t._unlocked=true;s._releaseHtml5Audio(t)}catch(e){s.noAudio=true;break}for(var n=0;n<s._howls.length;n++)if(!s._howls[n]._webAudio){var i=s._howls[n]._getSoundIds();for(var a=0;a<i.length;a++){var o=s._howls[n]._soundById(i[a]);if(o&&o._node&&!o._node._unlocked){o._node._unlocked=true;o._node.load()}}}s._autoResume();var r=s.ctx.createBufferSource();r.buffer=s._scratchBuffer;r.connect(s.ctx.destination);if(typeof r.start==="undefined")r.noteOn(0);else r.start(0);if(typeof s.ctx.resume==="function")s.ctx.resume();r.onended=function(){r.disconnect(0);s._audioUnlocked=true;document.removeEventListener("touchstart",l,true);document.removeEventListener("touchend",l,true);document.removeEventListener("click",l,true);for(var e=0;e<s._howls.length;e++)s._howls[e]._emit("unlock")}};document.addEventListener("touchstart",l,true);document.addEventListener("touchend",l,true);document.addEventListener("click",l,true);return s},_obtainHtml5Audio:function(){var e=this||E;if(e._html5AudioPool.length)return e._html5AudioPool.pop();var t=(new Audio).play();if(t&&typeof Promise!=="undefined"&&(t instanceof Promise||typeof t.then==="function"))t.catch(function(){console.warn("HTML5 Audio pool exhausted, returning potentially locked audio object.")});return new Audio},_releaseHtml5Audio:function(e){var t=this||E;if(e._unlocked)t._html5AudioPool.push(e);return t},_autoSuspend:function(){var t=this;if(!t.autoSuspend||!t.ctx||typeof t.ctx.suspend==="undefined"||!E.usingWebAudio)return;for(var e=0;e<t._howls.length;e++)if(t._howls[e]._webAudio)for(var n=0;n<t._howls[e]._sounds.length;n++)if(!t._howls[e]._sounds[n]._paused)return t;if(t._suspendTimer)clearTimeout(t._suspendTimer);t._suspendTimer=setTimeout(function(){if(!t.autoSuspend)return;t._suspendTimer=null;t.state="suspending";var e=function(){t.state="suspended";if(t._resumeAfterSuspend){delete t._resumeAfterSuspend;t._autoResume()}};t.ctx.suspend().then(e,e)},3e4);return t},_autoResume:function(){var t=this;if(!t.ctx||typeof t.ctx.resume==="undefined"||!E.usingWebAudio)return;if(t.state==="running"&&t.ctx.state!=="interrupted"&&t._suspendTimer){clearTimeout(t._suspendTimer);t._suspendTimer=null}else if(t.state==="suspended"||t.state==="running"&&t.ctx.state==="interrupted"){t.ctx.resume().then(function(){t.state="running";for(var e=0;e<t._howls.length;e++)t._howls[e]._emit("resume")});if(t._suspendTimer){clearTimeout(t._suspendTimer);t._suspendTimer=null}}else if(t.state==="suspending")t._resumeAfterSuspend=true;return t}};var E=new e;var t=function(e){var t=this;if(!e.src||e.src.length===0){console.error("An array of source files must be passed with any new Howl.");return}t.init(e)};t.prototype={init:function(e){var t=this;if(!E.ctx)d();t._autoplay=e.autoplay||false;t._format=typeof e.format!=="string"?e.format:[e.format];t._html5=e.html5||false;t._muted=e.mute||false;t._loop=e.loop||false;t._pool=e.pool||5;t._preload=typeof e.preload==="boolean"||e.preload==="metadata"?e.preload:true;t._rate=e.rate||1;t._sprite=e.sprite||{};t._src=typeof e.src!=="string"?e.src:[e.src];t._volume=e.volume!==undefined?e.volume:1;t._xhr={method:e.xhr&&e.xhr.method?e.xhr.method:"GET",headers:e.xhr&&e.xhr.headers?e.xhr.headers:null,withCredentials:e.xhr&&e.xhr.withCredentials?e.xhr.withCredentials:false};t._duration=0;t._state="unloaded";t._sounds=[];t._endTimers={};t._queue=[];t._playLock=false;t._onend=e.onend?[{fn:e.onend}]:[];t._onfade=e.onfade?[{fn:e.onfade}]:[];t._onload=e.onload?[{fn:e.onload}]:[];t._onloaderror=e.onloaderror?[{fn:e.onloaderror}]:[];t._onplayerror=e.onplayerror?[{fn:e.onplayerror}]:[];t._onpause=e.onpause?[{fn:e.onpause}]:[];t._onplay=e.onplay?[{fn:e.onplay}]:[];t._onstop=e.onstop?[{fn:e.onstop}]:[];t._onmute=e.onmute?[{fn:e.onmute}]:[];t._onvolume=e.onvolume?[{fn:e.onvolume}]:[];t._onrate=e.onrate?[{fn:e.onrate}]:[];t._onseek=e.onseek?[{fn:e.onseek}]:[];t._onunlock=e.onunlock?[{fn:e.onunlock}]:[];t._onresume=[];t._webAudio=E.usingWebAudio&&!t._html5;if(typeof E.ctx!=="undefined"&&E.ctx&&E.autoUnlock)E._unlockAudio();E._howls.push(t);if(t._autoplay)t._queue.push({event:"play",action:function(){t.play()}});if(t._preload&&t._preload!=="none")t.load();return t},load:function(){var e=this;var t=null;if(E.noAudio){e._emit("loaderror",null,"No audio support.");return}if(typeof e._src==="string")e._src=[e._src];for(var n=0;n<e._src.length;n++){var i,a;if(e._format&&e._format[n])i=e._format[n];else{a=e._src[n];if(typeof a!=="string"){e._emit("loaderror",null,"Non-string found in selected audio sources - ignoring.");continue}i=/^data:audio\/([^;,]+);/i.exec(a);if(!i)i=/\.([^.]+)$/.exec(a.split("?",1)[0]);if(i)i=i[1].toLowerCase()}if(!i)console.warn('No file extension was found. Consider using the "format" property or specify an extension.');if(i&&E.codecs(i)){t=e._src[n];break}}if(!t){e._emit("loaderror",null,"No codec support for selected audio sources.");return}e._src=t;e._state="loading";if(window.location.protocol==="https:"&&t.slice(0,5)==="http:"){e._html5=true;e._webAudio=false}new o(e);if(e._webAudio)s(e);return e},play:function(t,n){var i=this;var e=null;if(typeof t==="number"){e=t;t=null}else if(typeof t==="string"&&i._state==="loaded"&&!i._sprite[t])return null;else if(typeof t==="undefined"){t="__default";if(!i._playLock){var a=0;for(var o=0;o<i._sounds.length;o++)if(i._sounds[o]._paused&&!i._sounds[o]._ended){a++;e=i._sounds[o]._id}if(a===1)t=null;else e=null}}var r=e?i._soundById(e):i._inactiveSound();if(!r)return null;if(e&&!t)t=r._sprite||"__default";if(i._state!=="loaded"){r._sprite=t;r._ended=false;var s=r._id;i._queue.push({event:"play",action:function(){i.play(s)}});return s}if(e&&!r._paused){if(!n)i._loadQueue("play");return r._id}if(i._webAudio)E._autoResume();var l=Math.max(0,r._seek>0?r._seek:i._sprite[t][0]/1e3);var c=Math.max(0,(i._sprite[t][0]+i._sprite[t][1])/1e3-l);var u=c*1e3/Math.abs(r._rate);var d=i._sprite[t][0]/1e3;var h=(i._sprite[t][0]+i._sprite[t][1])/1e3;r._sprite=t;r._ended=false;var f=function(){r._paused=false;r._seek=l;r._start=d;r._stop=h;r._loop=!!(r._loop||i._sprite[t][2])};if(l>=h){i._ended(r);return}var m=r._node;if(i._webAudio){var p=function(){i._playLock=false;f();i._refreshBuffer(r);var e=r._muted||i._muted?0:r._volume;m.gain.setValueAtTime(e,E.ctx.currentTime);r._playStart=E.ctx.currentTime;if(typeof m.bufferSource.start==="undefined")r._loop?m.bufferSource.noteGrainOn(0,l,86400):m.bufferSource.noteGrainOn(0,l,c);else r._loop?m.bufferSource.start(0,l,86400):m.bufferSource.start(0,l,c);if(u!==Infinity)i._endTimers[r._id]=setTimeout(i._ended.bind(i,r),u);if(!n)setTimeout(function(){i._emit("play",r._id);i._loadQueue()},0)};if(E.state==="running"&&E.ctx.state!=="interrupted")p();else{i._playLock=true;i.once("resume",p);i._clearTimer(r._id)}}else{var v=function(){m.currentTime=l;m.muted=r._muted||i._muted||E._muted||m.muted;m.volume=r._volume*E.volume();m.playbackRate=r._rate;try{var e=m.play();if(e&&typeof Promise!=="undefined"&&(e instanceof Promise||typeof e.then==="function")){i._playLock=true;f();e.then(function(){i._playLock=false;m._unlocked=true;if(!n){i._emit("play",r._id);i._loadQueue()}}).catch(function(){i._playLock=false;i._emit("playerror",r._id,"Playback was unable to start. This is most commonly an issue on mobile devices and Chrome where playback was not within a user interaction.");r._ended=true;r._paused=true})}else if(!n){i._playLock=false;f();i._emit("play",r._id);i._loadQueue()}m.playbackRate=r._rate;if(m.paused){i._emit("playerror",r._id,"Playback was unable to start. This is most commonly an issue on mobile devices and Chrome where playback was not within a user interaction.");return}if(t!=="__default"||r._loop)i._endTimers[r._id]=setTimeout(i._ended.bind(i,r),u);else{i._endTimers[r._id]=function(){i._ended(r);m.removeEventListener("ended",i._endTimers[r._id],false)};m.addEventListener("ended",i._endTimers[r._id],false)}}catch(e){i._emit("playerror",r._id,e)}};if(m.src==="data:audio/wav;base64,UklGRigAAABXQVZFZm10IBIAAAABAAEARKwAAIhYAQACABAAAABkYXRhAgAAAAEA"){m.src=i._src;m.load()}var g=window&&window.ejecta||!m.readyState&&E._navigator.isCocoonJS;if(m.readyState>=3||g)v();else{i._playLock=true;var w=function(){v();m.removeEventListener(E._canPlayEvent,w,false)};m.addEventListener(E._canPlayEvent,w,false);i._clearTimer(r._id)}}return r._id},pause:function(e){var t=this;if(t._state!=="loaded"||t._playLock){t._queue.push({event:"pause",action:function(){t.pause(e)}});return t}var n=t._getSoundIds(e);for(var i=0;i<n.length;i++){t._clearTimer(n[i]);var a=t._soundById(n[i]);if(a&&!a._paused){a._seek=t.seek(n[i]);a._rateSeek=0;a._paused=true;t._stopFade(n[i]);if(a._node)if(t._webAudio){if(!a._node.bufferSource)continue;if(typeof a._node.bufferSource.stop==="undefined")a._node.bufferSource.noteOff(0);else a._node.bufferSource.stop(0);t._cleanBuffer(a._node)}else if(!isNaN(a._node.duration)||a._node.duration===Infinity)a._node.pause()}if(!arguments[1])t._emit("pause",a?a._id:null)}return t},stop:function(e,t){var n=this;if(n._state!=="loaded"||n._playLock){n._queue.push({event:"stop",action:function(){n.stop(e)}});return n}var i=n._getSoundIds(e);for(var a=0;a<i.length;a++){n._clearTimer(i[a]);var o=n._soundById(i[a]);if(o){o._seek=o._start||0;o._rateSeek=0;o._paused=true;o._ended=true;n._stopFade(i[a]);if(o._node)if(n._webAudio){if(o._node.bufferSource){if(typeof o._node.bufferSource.stop==="undefined")o._node.bufferSource.noteOff(0);else o._node.bufferSource.stop(0);n._cleanBuffer(o._node)}}else if(!isNaN(o._node.duration)||o._node.duration===Infinity){o._node.currentTime=o._start||0;o._node.pause();if(o._node.duration===Infinity)n._clearSound(o._node)}if(!t)n._emit("stop",o._id)}}return n},mute:function(e,t){var n=this;if(n._state!=="loaded"||n._playLock){n._queue.push({event:"mute",action:function(){n.mute(e,t)}});return n}if(typeof t==="undefined")if(typeof e==="boolean")n._muted=e;else return n._muted;var i=n._getSoundIds(t);for(var a=0;a<i.length;a++){var o=n._soundById(i[a]);if(o){o._muted=e;if(o._interval)n._stopFade(o._id);if(n._webAudio&&o._node)o._node.gain.setValueAtTime(e?0:o._volume,E.ctx.currentTime);else if(o._node)o._node.muted=E._muted?true:e;n._emit("mute",o._id)}}return n},volume:function(){var e=this;var t=arguments;var n,i;if(t.length===0)return e._volume;else if(t.length===1||t.length===2&&typeof t[1]==="undefined"){var a=e._getSoundIds();var o=a.indexOf(t[0]);if(o>=0)i=parseInt(t[0],10);else n=parseFloat(t[0])}else if(t.length>=2){n=parseFloat(t[0]);i=parseInt(t[1],10)}var r;if(typeof n!=="undefined"&&n>=0&&n<=1){if(e._state!=="loaded"||e._playLock){e._queue.push({event:"volume",action:function(){e.volume.apply(e,t)}});return e}if(typeof i==="undefined")e._volume=n;i=e._getSoundIds(i);for(var s=0;s<i.length;s++){r=e._soundById(i[s]);if(r){r._volume=n;if(!t[2])e._stopFade(i[s]);if(e._webAudio&&r._node&&!r._muted)r._node.gain.setValueAtTime(n,E.ctx.currentTime);else if(r._node&&!r._muted)r._node.volume=n*E.volume();e._emit("volume",r._id)}}}else{r=i?e._soundById(i):e._sounds[0];return r?r._volume:0}return e},fade:function(e,t,n,i){var a=this;if(a._state!=="loaded"||a._playLock){a._queue.push({event:"fade",action:function(){a.fade(e,t,n,i)}});return a}e=Math.min(Math.max(0,parseFloat(e)),1);t=Math.min(Math.max(0,parseFloat(t)),1);n=parseFloat(n);a.volume(e,i);var o=a._getSoundIds(i);for(var r=0;r<o.length;r++){var s=a._soundById(o[r]);if(s){if(!i)a._stopFade(o[r]);if(a._webAudio&&!s._muted){var l=E.ctx.currentTime;var c=l+n/1e3;s._volume=e;s._node.gain.setValueAtTime(e,l);s._node.gain.linearRampToValueAtTime(t,c)}a._startFadeInterval(s,e,t,n,o[r],typeof i==="undefined")}}return a},_startFadeInterval:function(t,n,i,a,e,o){var r=this;var s=n;var l=i-n;var c=Math.abs(l/.01);var u=Math.max(4,c>0?a/c:a);var d=Date.now();t._fadeTo=i;t._interval=setInterval(function(){var e=(Date.now()-d)/a;d=Date.now();s+=l*e;s=Math.round(s*100)/100;if(l<0)s=Math.max(i,s);else s=Math.min(i,s);if(r._webAudio)t._volume=s;else r.volume(s,t._id,true);if(o)r._volume=s;if(i<n&&s<=i||i>n&&s>=i){clearInterval(t._interval);t._interval=null;t._fadeTo=null;r.volume(i,t._id);r._emit("fade",t._id)}},u)},_stopFade:function(e){var t=this;var n=t._soundById(e);if(n&&n._interval){if(t._webAudio)n._node.gain.cancelScheduledValues(E.ctx.currentTime);clearInterval(n._interval);n._interval=null;t.volume(n._fadeTo,e);n._fadeTo=null;t._emit("fade",e)}return t},loop:function(){var e=this;var t=arguments;var n,i,a;if(t.length===0)return e._loop;else if(t.length===1)if(typeof t[0]==="boolean"){n=t[0];e._loop=n}else{a=e._soundById(parseInt(t[0],10));return a?a._loop:false}else if(t.length===2){n=t[0];i=parseInt(t[1],10)}var o=e._getSoundIds(i);for(var r=0;r<o.length;r++){a=e._soundById(o[r]);if(a){a._loop=n;if(e._webAudio&&a._node&&a._node.bufferSource){a._node.bufferSource.loop=n;if(n){a._node.bufferSource.loopStart=a._start||0;a._node.bufferSource.loopEnd=a._stop}}}}return e},rate:function(){var e=this;var t=arguments;var n,i;if(t.length===0)i=e._sounds[0]._id;else if(t.length===1){var a=e._getSoundIds();var o=a.indexOf(t[0]);if(o>=0)i=parseInt(t[0],10);else n=parseFloat(t[0])}else if(t.length===2){n=parseFloat(t[0]);i=parseInt(t[1],10)}var r;if(typeof n==="number"){if(e._state!=="loaded"||e._playLock){e._queue.push({event:"rate",action:function(){e.rate.apply(e,t)}});return e}if(typeof i==="undefined")e._rate=n;i=e._getSoundIds(i);for(var s=0;s<i.length;s++){r=e._soundById(i[s]);if(r){if(e.playing(i[s])){r._rateSeek=e.seek(i[s]);r._playStart=e._webAudio?E.ctx.currentTime:r._playStart}r._rate=n;if(e._webAudio&&r._node&&r._node.bufferSource)r._node.bufferSource.playbackRate.setValueAtTime(n,E.ctx.currentTime);else if(r._node)r._node.playbackRate=n;var l=e.seek(i[s]);var c=(e._sprite[r._sprite][0]+e._sprite[r._sprite][1])/1e3-l;var u=c*1e3/Math.abs(r._rate);if(e._endTimers[i[s]]||!r._paused){e._clearTimer(i[s]);e._endTimers[i[s]]=setTimeout(e._ended.bind(e,r),u)}e._emit("rate",r._id)}}}else{r=e._soundById(i);return r?r._rate:e._rate}return e},seek:function(){var e=this;var t=arguments;var n,i;if(t.length===0)i=e._sounds[0]._id;else if(t.length===1){var a=e._getSoundIds();var o=a.indexOf(t[0]);if(o>=0)i=parseInt(t[0],10);else if(e._sounds.length){i=e._sounds[0]._id;n=parseFloat(t[0])}}else if(t.length===2){n=parseFloat(t[0]);i=parseInt(t[1],10)}if(typeof i==="undefined")return e;if(typeof n==="number"&&(e._state!=="loaded"||e._playLock)){e._queue.push({event:"seek",action:function(){e.seek.apply(e,t)}});return e}var r=e._soundById(i);if(r)if(typeof n==="number"&&n>=0){var s=e.playing(i);if(s)e.pause(i,true);r._seek=n;r._ended=false;e._clearTimer(i);if(!e._webAudio&&r._node&&!isNaN(r._node.duration))r._node.currentTime=n;var l=function(){e._emit("seek",i);if(s)e.play(i,true)};if(s&&!e._webAudio){var c=function(){if(!e._playLock)l();else setTimeout(c,0)};setTimeout(c,0)}else l()}else if(e._webAudio){var u=e.playing(i)?E.ctx.currentTime-r._playStart:0;var d=r._rateSeek?r._rateSeek-r._seek:0;return r._seek+(d+u*Math.abs(r._rate))}else return r._node.currentTime;return e},playing:function(e){var t=this;if(typeof e==="number"){var n=t._soundById(e);return n?!n._paused:false}for(var i=0;i<t._sounds.length;i++)if(!t._sounds[i]._paused)return true;return false},duration:function(e){var t=this;var n=t._duration;var i=t._soundById(e);if(i)n=t._sprite[i._sprite][1]/1e3;return n},state:function(){return this._state},unload:function(){var e=this;var t=e._sounds;for(var n=0;n<t.length;n++){if(!t[n]._paused)e.stop(t[n]._id);if(!e._webAudio){e._clearSound(t[n]._node);t[n]._node.removeEventListener("error",t[n]._errorFn,false);t[n]._node.removeEventListener(E._canPlayEvent,t[n]._loadFn,false);t[n]._node.removeEventListener("ended",t[n]._endFn,false);E._releaseHtml5Audio(t[n]._node)}delete t[n]._node;e._clearTimer(t[n]._id)}var i=E._howls.indexOf(e);if(i>=0)E._howls.splice(i,1);var a=true;for(n=0;n<E._howls.length;n++)if(E._howls[n]._src===e._src||e._src.indexOf(E._howls[n]._src)>=0){a=false;break}if(r&&a)delete r[e._src];E.noAudio=false;e._state="unloaded";e._sounds=[];e=null;return null},on:function(e,t,n,i){var a=this;var o=a["_on"+e];if(typeof t==="function")o.push(i?{id:n,fn:t,once:i}:{id:n,fn:t});return a},off:function(e,t,n){var i=this;var a=i["_on"+e];var o=0;if(typeof t==="number"){n=t;t=null}if(t||n)for(o=0;o<a.length;o++){var r=n===a[o].id;if(t===a[o].fn&&r||!t&&r){a.splice(o,1);break}}else if(e)i["_on"+e]=[];else{var s=Object.keys(i);for(o=0;o<s.length;o++)if(s[o].indexOf("_on")===0&&Array.isArray(i[s[o]]))i[s[o]]=[]}return i},once:function(e,t,n){var i=this;i.on(e,t,n,1);return i},_emit:function(e,t,n){var i=this;var a=i["_on"+e];for(var o=a.length-1;o>=0;o--)if(!a[o].id||a[o].id===t||e==="load"){setTimeout(function(e){e.call(this,t,n)}.bind(i,a[o].fn),0);if(a[o].once)i.off(e,a[o].fn,a[o].id)}i._loadQueue(e);return i},_loadQueue:function(e){var t=this;if(t._queue.length>0){var n=t._queue[0];if(n.event===e){t._queue.shift();t._loadQueue()}if(!e)n.action()}return t},_ended:function(e){var t=this;var n=e._sprite;if(!t._webAudio&&e._node&&!e._node.paused&&!e._node.ended&&e._node.currentTime<e._stop){setTimeout(t._ended.bind(t,e),100);return t}var i=!!(e._loop||t._sprite[n][2]);t._emit("end",e._id);if(!t._webAudio&&i)t.stop(e._id,true).play(e._id);if(t._webAudio&&i){t._emit("play",e._id);e._seek=e._start||0;e._rateSeek=0;e._playStart=E.ctx.currentTime;var a=(e._stop-e._start)*1e3/Math.abs(e._rate);t._endTimers[e._id]=setTimeout(t._ended.bind(t,e),a)}if(t._webAudio&&!i){e._paused=true;e._ended=true;e._seek=e._start||0;e._rateSeek=0;t._clearTimer(e._id);t._cleanBuffer(e._node);E._autoSuspend()}if(!t._webAudio&&!i)t.stop(e._id,true);return t},_clearTimer:function(e){var t=this;if(t._endTimers[e]){if(typeof t._endTimers[e]!=="function")clearTimeout(t._endTimers[e]);else{var n=t._soundById(e);if(n&&n._node)n._node.removeEventListener("ended",t._endTimers[e],false)}delete t._endTimers[e]}return t},_soundById:function(e){var t=this;for(var n=0;n<t._sounds.length;n++)if(e===t._sounds[n]._id)return t._sounds[n];return null},_inactiveSound:function(){var e=this;e._drain();for(var t=0;t<e._sounds.length;t++)if(e._sounds[t]._ended)return e._sounds[t].reset();return new o(e)},_drain:function(){var e=this;var t=e._pool;var n=0;var i=0;if(e._sounds.length<t)return;for(i=0;i<e._sounds.length;i++)if(e._sounds[i]._ended)n++;for(i=e._sounds.length-1;i>=0;i--){if(n<=t)return;if(e._sounds[i]._ended){if(e._webAudio&&e._sounds[i]._node)e._sounds[i]._node.disconnect(0);e._sounds.splice(i,1);n--}}},_getSoundIds:function(e){var t=this;if(typeof e==="undefined"){var n=[];for(var i=0;i<t._sounds.length;i++)n.push(t._sounds[i]._id);return n}else return[e]},_refreshBuffer:function(e){var t=this;e._node.bufferSource=E.ctx.createBufferSource();e._node.bufferSource.buffer=r[t._src];if(e._panner)e._node.bufferSource.connect(e._panner);else e._node.bufferSource.connect(e._node);e._node.bufferSource.loop=e._loop;if(e._loop){e._node.bufferSource.loopStart=e._start||0;e._node.bufferSource.loopEnd=e._stop||0}e._node.bufferSource.playbackRate.setValueAtTime(e._rate,E.ctx.currentTime);return t},_cleanBuffer:function(e){var t=this;var n=E._navigator&&E._navigator.vendor.indexOf("Apple")>=0;if(E._scratchBuffer&&e.bufferSource){e.bufferSource.onended=null;e.bufferSource.disconnect(0);if(n)try{e.bufferSource.buffer=E._scratchBuffer}catch(e){}}e.bufferSource=null;return t},_clearSound:function(e){var t=/MSIE |Trident\//.test(E._navigator&&E._navigator.userAgent);if(!t)e.src="data:audio/wav;base64,UklGRigAAABXQVZFZm10IBIAAAABAAEARKwAAIhYAQACABAAAABkYXRhAgAAAAEA"}};var o=function(e){this._parent=e;this.init()};o.prototype={init:function(){var e=this;var t=e._parent;e._muted=t._muted;e._loop=t._loop;e._volume=t._volume;e._rate=t._rate;e._seek=0;e._paused=true;e._ended=true;e._sprite="__default";e._id=++E._counter;t._sounds.push(e);e.create();return e},create:function(){var e=this;var t=e._parent;var n=E._muted||e._muted||e._parent._muted?0:e._volume;if(t._webAudio){e._node=typeof E.ctx.createGain==="undefined"?E.ctx.createGainNode():E.ctx.createGain();e._node.gain.setValueAtTime(n,E.ctx.currentTime);e._node.paused=true;e._node.connect(E.masterGain)}else if(!E.noAudio){e._node=E._obtainHtml5Audio();e._errorFn=e._errorListener.bind(e);e._node.addEventListener("error",e._errorFn,false);e._loadFn=e._loadListener.bind(e);e._node.addEventListener(E._canPlayEvent,e._loadFn,false);e._endFn=e._endListener.bind(e);e._node.addEventListener("ended",e._endFn,false);e._node.src=t._src;e._node.preload=t._preload===true?"auto":t._preload;e._node.volume=n*E.volume();e._node.load()}return e},reset:function(){var e=this;var t=e._parent;e._muted=t._muted;e._loop=t._loop;e._volume=t._volume;e._rate=t._rate;e._seek=0;e._rateSeek=0;e._paused=true;e._ended=true;e._sprite="__default";e._id=++E._counter;return e},_errorListener:function(){var e=this;e._parent._emit("loaderror",e._id,e._node.error?e._node.error.code:0);e._node.removeEventListener("error",e._errorFn,false)},_loadListener:function(){var e=this;var t=e._parent;t._duration=e._node.duration;if(Object.keys(t._sprite).length===0)t._sprite={__default:[0,t._duration*1e3]};if(t._state!=="loaded"){t._state="loaded";t._emit("load");t._loadQueue()}e._node.removeEventListener(E._canPlayEvent,e._loadFn,false)},_endListener:function(){var e=this;var t=e._parent;if(t._duration===Infinity){t._duration=e._node.duration;if(t._sprite.__default[1]===Infinity)t._sprite.__default[1]=t._duration*1e3;t._ended(e)}e._node.removeEventListener("ended",e._endFn,false)}};var r={};var s=function(t){var e=t._src;if(r[e]){t._duration=r[e].duration;u(t);return}if(/^data:[^;]+;base64,/.test(e)){var n=atob(e.split(",")[1]);var i=new Uint8Array(n.length);for(var a=0;a<n.length;++a)i[a]=n.charCodeAt(a);c(i.buffer,t)}else{var o=new XMLHttpRequest;o.open(t._xhr.method,e,true);o.withCredentials=t._xhr.withCredentials;o.responseType="arraybuffer";if(t._xhr.headers)Object.keys(t._xhr.headers).forEach(function(e){o.setRequestHeader(e,t._xhr.headers[e])});o.onload=function(){var e=(o.status+"")[0];if(e!=="0"&&e!=="2"&&e!=="3"){t._emit("loaderror",null,"Failed loading audio file with status: "+o.status+".");return}c(o.response,t)};o.onerror=function(){if(t._webAudio){t._html5=true;t._webAudio=false;t._sounds=[];delete r[e];t.load()}};l(o)}};var l=function(t){try{t.send()}catch(e){t.onerror()}};var c=function(e,t){var n=function(){t._emit("loaderror",null,"Decoding audio data failed.")};var i=function(e){if(e&&t._sounds.length>0){r[t._src]=e;u(t,e)}else n()};if(typeof Promise!=="undefined"&&E.ctx.decodeAudioData.length===1)E.ctx.decodeAudioData(e).then(i).catch(n);else E.ctx.decodeAudioData(e,i,n)};var u=function(e,t){if(t&&!e._duration)e._duration=t.duration;if(Object.keys(e._sprite).length===0)e._sprite={__default:[0,e._duration*1e3]};if(e._state!=="loaded"){e._state="loaded";e._emit("load");e._loadQueue()}};var d=function(){if(!E.usingWebAudio)return;try{if(typeof AudioContext!=="undefined")E.ctx=new AudioContext;else if(typeof webkitAudioContext!=="undefined")E.ctx=new webkitAudioContext;else E.usingWebAudio=false}catch(e){E.usingWebAudio=false}if(!E.ctx)E.usingWebAudio=false;var e=/iP(hone|od|ad)/.test(E._navigator&&E._navigator.platform);var t=E._navigator&&E._navigator.appVersion.match(/OS (\d+)_(\d+)_?(\d+)?/);var n=t?parseInt(t[1],10):null;if(e&&n&&n<9){var i=/safari/.test(E._navigator&&E._navigator.userAgent.toLowerCase());if(E._navigator&&!i)E.usingWebAudio=false}if(E.usingWebAudio){E.masterGain=typeof E.ctx.createGain==="undefined"?E.ctx.createGainNode():E.ctx.createGain();E.masterGain.gain.setValueAtTime(E._muted?0:E._volume,E.ctx.currentTime);E.masterGain.connect(E.ctx.destination)}E._setup()};return{Howler:E,Howl:t}}(),le=function(){var i=[];return{getAll:function(){return i},removeAll:function(){i=[]},add:function(e){i.push(e)},remove:function(e){var t=i.indexOf(e);if(t!==-1)i.splice(t,1)},update:function(e,t){if(i.length===0)return false;var n=0;e=e!==undefined?e:le.now();while(n<i.length)if(i[n].update(e)||t)n++;else i.splice(n,1);return true}}}();if(typeof window==="undefined"&&typeof process!=="undefined")le.now=function(){var e=process.hrtime();return e[0]*1e3+e[1]/1e6};else if(typeof window!=="undefined"&&window.performance!==undefined&&window.performance.now!==undefined)le.now=window.performance.now.bind(window.performance);else if(Date.now!==undefined)le.now=Date.now;else le.now=function(){return(new Date).getTime()};le.Tween=function(e){var c=e;var u={};var d={};var h={};var f=1e3;var m=0;var p;var v=false;var n=false;var g=false;var w=0;var E=null;var i=false;var t=null;var y=le.Easing.Linear.None;var b=le.Interpolation.Linear;var _=[];var T=null;var x=false;var R=null;var M=null;var a=null;this.isPlaying=function e(){return n};this.isPaused=function e(){return i};this.to=function(e,t){d=e;if(t!==undefined)f=t;return this};this.start=function(e){le.add(this);n=true;i=false;x=false;E=e!==undefined?e:le.now();E+=w;for(var t in d){if(d[t]instanceof Array){if(d[t].length===0)continue;d[t]=[c[t]].concat(d[t])}if(c[t]===undefined)continue;u[t]=c[t];if(u[t]instanceof Array===false)u[t]*=1;h[t]=u[t]||0}return this};this.stop=function(){if(!n)return this;le.remove(this);n=false;i=false;if(a!==null)a.call(c,c);this.stopChainedTweens();return this};this.end=function(){this.update(E+f);return this};this.stopChainedTweens=function(){for(var e=0,t=_.length;e<t;e++)_[e].stop()};this.delay=function(e){w=e;return this};this.pause=function(){if(i)return;i=true;t=(new Date).getTime();le.remove(this)};this.play=function(){if(!i)return;i=false;var e=(new Date).getTime();E+=e-t;le.add(this)};this.repeat=function(e){m=e;return this};this.repeatDelay=function(e){p=e;return this};this.yoyo=function(e){v=e;return this};this.easing=function(e){y=e;return this};this.interpolation=function(e){b=e;return this};this.chain=function(){_=arguments;return this};this.onStart=function(e){T=e;return this};this.onUpdate=function(e){R=e;return this};this.onComplete=function(e){M=e;return this};this.onStop=function(e){a=e;return this};this.update=function(e){var t;var n;var i;if(e<E)return true;if(x===false){if(T!==null)T.call(c,c);x=true}n=(e-E)/f;n=n>1?1:n;i=y(n);for(t in d){if(u[t]===undefined)continue;var a=u[t]||0;var o=d[t];if(o instanceof Array)c[t]=b(o,i);else{if(typeof o==="string")if(o.charAt(0)==="+"||o.charAt(0)==="-")o=a+parseFloat(o);else o=parseFloat(o);if(typeof o==="number")c[t]=a+(o-a)*i}}if(R!==null)R.call(c,i);if(n===1)if(m>0){if(isFinite(m))m--;for(t in h){if(typeof d[t]==="string")h[t]=h[t]+parseFloat(d[t]);if(v){var r=h[t];h[t]=d[t];d[t]=r}u[t]=h[t]}if(v)g=!g;if(p!==undefined)E=e+p;else E=e+w;return true}else{if(M!==null)M.call(c,c);for(var s=0,l=_.length;s<l;s++)_[s].start(E+f);return false}return true}},le.Easing={Linear:{None:function(e){return e}},Quadratic:{In:function(e){return e*e},Out:function(e){return e*(2-e)},InOut:function(e){if((e*=2)<1)return.5*e*e;return-.5*(--e*(e-2)-1)}},Cubic:{In:function(e){return e*e*e},Out:function(e){return--e*e*e+1},InOut:function(e){if((e*=2)<1)return.5*e*e*e;return.5*((e-=2)*e*e+2)}},Quartic:{In:function(e){return e*e*e*e},Out:function(e){return 1- --e*e*e*e},InOut:function(e){if((e*=2)<1)return.5*e*e*e*e;return-.5*((e-=2)*e*e*e-2)}},Quintic:{In:function(e){return e*e*e*e*e},Out:function(e){return--e*e*e*e*e+1},InOut:function(e){if((e*=2)<1)return.5*e*e*e*e*e;return.5*((e-=2)*e*e*e*e+2)}},Sinusoidal:{In:function(e){return 1-Math.cos(e*Math.PI/2)},Out:function(e){return Math.sin(e*Math.PI/2)},InOut:function(e){return.5*(1-Math.cos(Math.PI*e))}},Exponential:{In:function(e){return e===0?0:Math.pow(1024,e-1)},Out:function(e){return e===1?1:1-Math.pow(2,-10*e)},InOut:function(e){if(e===0)return 0;if(e===1)return 1;if((e*=2)<1)return.5*Math.pow(1024,e-1);return.5*(-Math.pow(2,-10*(e-1))+2)}},Circular:{In:function(e){return 1-Math.sqrt(1-e*e)},Out:function(e){return Math.sqrt(1- --e*e)},InOut:function(e){if((e*=2)<1)return-.5*(Math.sqrt(1-e*e)-1);return.5*(Math.sqrt(1-(e-=2)*e)+1)}},Elastic:{In:function(e){if(e===0)return 0;if(e===1)return 1;return-Math.pow(2,10*(e-1))*Math.sin((e-1.1)*5*Math.PI)},Out:function(e){if(e===0)return 0;if(e===1)return 1;return Math.pow(2,-10*e)*Math.sin((e-.1)*5*Math.PI)+1},InOut:function(e){if(e===0)return 0;if(e===1)return 1;e*=2;if(e<1)return-.5*Math.pow(2,10*(e-1))*Math.sin((e-1.1)*5*Math.PI);return.5*Math.pow(2,-10*(e-1))*Math.sin((e-1.1)*5*Math.PI)+1}},Back:{In:function(e){var t=1.70158;return e*e*((t+1)*e-t)},Out:function(e){var t=1.70158;return--e*e*((t+1)*e+t)+1},InOut:function(e){var t=1.70158*1.525;if((e*=2)<1)return.5*(e*e*((t+1)*e-t));return.5*((e-=2)*e*((t+1)*e+t)+2)}},Bounce:{In:function(e){return 1-le.Easing.Bounce.Out(1-e)},Out:function(e){if(e<1/2.75)return 7.5625*e*e;else if(e<2/2.75)return 7.5625*(e-=1.5/2.75)*e+.75;else if(e<2.5/2.75)return 7.5625*(e-=2.25/2.75)*e+.9375;else return 7.5625*(e-=2.625/2.75)*e+.984375},InOut:function(e){if(e<.5)return le.Easing.Bounce.In(e*2)*.5;return le.Easing.Bounce.Out(e*2-1)*.5+.5}}},le.Interpolation={Linear:function(e,t){var n=e.length-1;var i=n*t;var a=Math.floor(i);var o=le.Interpolation.Utils.Linear;if(t<0)return o(e[0],e[1],i);if(t>1)return o(e[n],e[n-1],n-i);return o(e[a],e[a+1>n?n:a+1],i-a)},Bezier:function(e,t){var n=0;var i=e.length-1;var a=Math.pow;var o=le.Interpolation.Utils.Bernstein;for(var r=0;r<=i;r++)n+=a(1-t,i-r)*a(t,r)*e[r]*o(i,r);return n},CatmullRom:function(e,t){var n=e.length-1;var i=n*t;var a=Math.floor(i);var o=le.Interpolation.Utils.CatmullRom;if(e[0]===e[n]){if(t<0)a=Math.floor(i=n*(1+t));return o(e[(a-1+n)%n],e[a],e[(a+1)%n],e[(a+2)%n],i-a)}else{if(t<0)return e[0]-(o(e[0],e[0],e[1],e[1],-i)-e[0]);if(t>1)return e[n]-(o(e[n],e[n],e[n-1],e[n-1],i-n)-e[n]);return o(e[a?a-1:0],e[a],e[n<a+1?n:a+1],e[n<a+2?n:a+2],i-a)}},Utils:{Linear:function(e,t,n){return(t-e)*n+e},Bernstein:function(e,t){var n=le.Interpolation.Utils.Factorial;return n(e)/n(t)/n(e-t)},Factorial:function(){var i=[1];return function(e){var t=1;if(i[e])return i[e];for(var n=e;n>1;n--)t*=n;i[e]=t;return t}}(),CatmullRom:function(e,t,n,i,a){var o=(n-e)*.5;var r=(i-t)*.5;var s=a*a;var l=a*s;return(2*t-2*n+o+r)*l+(-3*t+3*n-2*o-r)*s+o*a+t}}};var d=0,e=function(){this.requests=[];var n=this;this.push=function(e){n.requests.push(e)};this.remove=function(e){let t=n.requests.map(e=>e.id).indexOf(e);n.requests.splice(t,1)};this.abort=function(){for(var e=0;e<n.requests.length;e++)n.requests[e].abort();n.requests=[]}},Y={checkTouch:function(){return window?"ontouchstart"in window||window.navigator.msMaxTouchPoints:false},checkMobile:function(){return/Mobi|Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)},checkWebgl:function(){try{var e=document.createElement("canvas");return!!(window.WebGLRenderingContext&&(e.getContext("webgl")||e.getContext("experimental-webgl")))}catch(e){return false}},extend:function(e,t){if(!t)t={};for(var n in e)if(e.hasOwnProperty(n)&&!t.hasOwnProperty(n))t[n]=e[n];return t},changeProtocol:function(e){try{if(e&&typeof URL==="function"){var t=new URL(window.location.href),n="https:";if(t.protocol==n){t=new URL(e);t.protocol=n;return t.href}}}catch(e){}return e},ImageLoader:{load:function(t,e,n,i,a,o){if(!t){console.warn("IPANORAMA.Utils.ImageLoader: image source undefined");i&&i();return}t=Y.changeProtocol(t);var r,s,l,c;r=THREE.Cache.get(t);if(r!==undefined){if(e)setTimeout(function(){if(n)n({loaded:1,total:1});e(r,t)},0);return}c=document.createElementNS("http://www.w3.org/1999/xhtml","img");function u(){e&&e(c)}if(t.indexOf("data:")===0){c.addEventListener("load",u,false);c.src=t;return c}c.crossOrigin=o!==undefined?o:"anonymous";c.addEventListener("load",u,false);c.src=t;s=new XMLHttpRequest;s.id=d++;a&&a.push(s);try{s.open("GET",t,true);s.onprogress=function(e){if(e.lengthComputable)n&&n({loaded:e.loaded,total:e.total})};s.onload=function(e){if(this.status==200){THREE.Cache.add(t,c);a&&a.remove(s.id)}else i&&i()};s.onloadend=function(e){if(this.status!=200&&this.status!==0)i&&i()};s.send(null)}catch(e){console.warn("IPANORAMA.Utils.ImageLoader: image loading error");i&&i()}}},TextureLoader:{load:function(e,s,t,n,i,l){Y.ImageLoader.load(e,function(e,t){var n=new THREE.Texture;n.imageOriginalSize={width:e.width,height:e.height};if(l&&(!THREE.Math.isPowerOfTwo(e.width)||!THREE.Math.isPowerOfTwo(e.height))){var i=THREE.Math.ceilPowerOfTwo(e.width),a=THREE.Math.ceilPowerOfTwo(e.height),o=document.createElementNS("http://www.w3.org/1999/xhtml","canvas");o.width=i;o.height=a;var r=o.getContext("2d");r.drawImage(e,0,0,e.width,e.height);r.drawImage(e,e.width-1,0,1,e.height,e.width,0,i-e.width,e.height);e=o}n.image=e;n.needsUpdate=true;s&&s(n,t)},t,n,i)}},CubeOneTextureLoader:{load:function(s,l,e,t,n){Y.ImageLoader.load(s,function(e){var t=new THREE.CubeTexture([]);t.images=new Array(6);for(var n=0;n<6;n++){var i=document.createElementNS("http://www.w3.org/1999/xhtml","canvas"),a=i.getContext("2d"),o=e.width/6,r=e.height;i.width=o;i.height=r;if(n==4||n==5){a.translate(o/2,r/2);a.rotate(180*Math.PI/180);a.translate(-o/2,-r/2)}a.drawImage(e,o*n,0,o,r,0,0,o,r);switch(n){case 0:t.images[0]=i;break;case 1:t.images[5]=i;break;case 2:t.images[1]=i;break;case 3:t.images[4]=i;break;case 4:t.images[2]=i;break;case 5:t.images[3]=i;break}}t.needsUpdate=true;l&&l(t,s)},e,t,n)}},CubeSixTextureLoader:{load:function(e,r,n,t,i){var s,l,a,c,u,d;s=new THREE.CubeTexture([]);l=0;a=false;c={};u={};function o(e,o){Y.ImageLoader.load(e,function(e){var t,n;if(o==4||o==5){t=document.createElementNS("http://www.w3.org/1999/xhtml","canvas"),n=t.getContext("2d");var i=e.width,a=e.height;t.width=i;t.height=a;n.translate(i/2,a/2);n.rotate(180*Math.PI/180);n.translate(-i/2,-a/2);n.drawImage(e,0,0,i,a,0,0,i,a)}switch(o){case 0:s.images[5]=e;break;case 1:s.images[4]=e;break;case 2:s.images[0]=e;break;case 3:s.images[1]=e;break;case 4:s.images[2]=t;break;case 5:s.images[3]=t;break}l++;if(l===6){s.needsUpdate=true;r&&r(s)}},function(e){c[o]={loaded:e.loaded,total:e.total};u.loaded=0;u.total=0;d=0;for(var t in c){d++;u.loaded+=c[t].loaded;u.total+=c[t].total}if(d<6)u.total=u.total/d*6;n&&n(u)},function(){a=true;t&&t()},i)}if(ie.isArray(e))for(var h=0;h<e.length;h++){o(e[h],h);if(a){s&&s.dispose();return}}else{!a&&o(e.front,0);!a&&o(e.back,1);!a&&o(e.left,2);!a&&o(e.right,3);!a&&o(e.top,4);!a&&o(e.bottom,5);if(a)s&&s.dispose()}}},Matrix:function(){this.reset()}};Y.Matrix.prototype={reset:function(){this.m=[1,0,0,1,0,0];return this},multiply:function(e){var t=this.m[0]*e.m[0]+this.m[2]*e.m[1],n=this.m[1]*e.m[0]+this.m[3]*e.m[1],i=this.m[0]*e.m[2]+this.m[2]*e.m[3],a=this.m[1]*e.m[2]+this.m[3]*e.m[3];var o=this.m[0]*e.m[4]+this.m[2]*e.m[5]+this.m[4],r=this.m[1]*e.m[4]+this.m[3]*e.m[5]+this.m[5];this.m[0]=t;this.m[1]=n;this.m[2]=i;this.m[3]=a;this.m[4]=o;this.m[5]=r;return this},inverse:function(){var e=new Y.Matrix;e.m=this.m.slice(0);var t=1/(e.m[0]*e.m[3]-e.m[1]*e.m[2]),n=e.m[3]*t,i=-e.m[1]*t,a=-e.m[2]*t,o=e.m[0]*t,r=t*(e.m[2]*e.m[5]-e.m[3]*e.m[4]),s=t*(e.m[1]*e.m[4]-e.m[0]*e.m[5]);e.m[0]=n;e.m[1]=i;e.m[2]=a;e.m[3]=o;e.m[4]=r;e.m[5]=s;return e},rotate:function(e){var t=Math.cos(e),n=Math.sin(e),i=this.m[0]*t+this.m[2]*n,a=this.m[1]*t+this.m[3]*n,o=this.m[0]*-n+this.m[2]*t,r=this.m[1]*-n+this.m[3]*t;this.m[0]=i;this.m[1]=a;this.m[2]=o;this.m[3]=r;return this},translate:function(e,t){this.m[4]+=this.m[0]*e+this.m[2]*t;this.m[5]+=this.m[1]*e+this.m[3]*t;return this},scale:function(e,t){this.m[0]*=e;this.m[1]*=e;this.m[2]*=t;this.m[3]*=t;return this},transformPoint:function(e,t){var n=e,i=t;e=n*this.m[0]+i*this.m[2]+this.m[4];t=n*this.m[1]+i*this.m[3]+this.m[5];return[e,t]},transformVector:function(e,t){var n=e,i=t;e=n*this.m[0]+i*this.m[2];t=n*this.m[1]+i*this.m[3];return[e,t]},copy:function(){var e=new Matrix;e.m=this.m.slice(0)}};var i=i||{};i.PanoLoader=function(e){"use strict";var r=e||{},t,s,l,n=new google.maps.StreetViewService,c=0,u=0,d=[],h=[],f=0,m=0,i=null,a=0,o="",p=null,v=null;var g=[1,2,4,7,13,26],w=[1,1,2,4,7,13];var E=[416,832,1664,3328,6656,13312],y=[416,416,832,1664,3328,6656];var b=null;try{var _=document.createElement("canvas");b=_.getContext("experimental-webgl");if(b==null)b=_.getContext("webgl")}catch(e){}var T=1024,x=1024;if(b){var R=Math.max(b.getParameter(b.MAX_TEXTURE_SIZE),6656);T=x=R}this.setProgress=function(e,t){if(this.onProgress)this.onProgress({loaded:e,total:t})};this.throwError=function(e){if(this.onError)this.onError(e);else console.error(e)};this.adaptTextureToZoom=function(){var e=g[s]*416,t=w[s]*416;e=E[s];t=y[s];f=Math.ceil(e/T);m=Math.ceil(t/x);d=[];h=[];var n=0;for(var i=0;i<m;i++)for(var a=0;a<f;a++){var o=document.createElement("canvas");if(a<f-1)o.width=T;else o.width=e-T*a;if(i<m-1)o.height=x;else o.height=t-x*i;d.push(o);h.push(o.getContext("2d"));n++}};this.composeFromTile=function(e,t,n){e*=512;t*=512;var i=Math.floor(e/T),a=Math.floor(t/x);e-=i*T;t-=a*x;h[a*f+i].drawImage(n,0,0,n.width,n.height,e,t,512,512);this.progress()};this.progress=function(){c++;var e=Math.round(c*100/u);this.setProgress(c,u);if(c===u){this.canvas=d;this.panoId=l;this.zoom=s;if(this.onPanoramaLoad)this.onPanoramaLoad(d[0])}};this.composePanorama=function(){this.setProgress(0,1);var e=g[s],t=w[s],a=this,o,n,i;c=0;u=e*t;var a=this;for(var i=0;i<t;i++)for(var n=0;n<e;n++){var o="https://geo0.ggpht.com/cbk?cb_client=maps_sv.tactile&authuser=0&hl=en&output=tile&zoom="+s+"&x="+n+"&y="+i+"&panoid="+l+"&nbt&fover=2";(function(e,t){if(r.useWebGL)var n=THREE.ImageUtils.loadTexture(o,null,function(){a.composeFromTile(e,t,n)});else{var i=new Image;i.addEventListener("load",function(){a.composeFromTile(e,t,this)});i.crossOrigin="";i.src=o}})(n,i)}};var M=function(e,t){if(t===google.maps.StreetViewStatus.OK){this.result=e;if(this.onPanoramaData)this.onPanoramaData(e);o=e.copyright;this.copyright=e.copyright;l=e.location.pano;this.location=location;this.rotation=a;this.composePanorama()}else{if(this.onNoPanoramaData)this.onNoPanoramaData(t);this.throwError("Could not retrieve panorama for the following reason: "+t)}};this.loadById=function(e){n.getPanoramaById(e,M.bind(this))};this.loadByLocation=function(e){n.getPanoramaByLocation(e,50,M.bind(this))};this.setZoom=function(e){s=e;this.adaptTextureToZoom()};this.setZoom(r.zoom||1)};var r=function(r){this.scene=r;this.scene.control=this;this.canvas=r.viewer.$canvas.get(0);this.enabled=true;this.target=new THREE.Vector3;this.noZoom=false;this.zoomSpeed=1;this.minZoom=0;this.maxZoom=Infinity;this.noDolly=true;this.minDistance=1;this.maxDistance=Infinity;this.noRotate=false;this.rotateSpeed=-.15;this.noPan=true;this.keyPanSpeed=7;this.autoRotate=false;this.autoRotateSpeedX=2;this.autoRotateSpeedY=0;this.autoRotateSpeedZ=0;this.momentumDampingFactor=.9;this.momentumScalingFactor=-.005;this.momentumKeydownFactor=20;this.minFov=10;this.maxFov=120;this.minPolarAngle=0;this.maxPolarAngle=Math.PI;this.minAzimuthAngle=-Infinity;this.maxAzimuthAngle=Infinity;this.noKeys=false;this.keys={LEFT:37,UP:38,RIGHT:39,BOTTOM:40};this.mouseButtons={ORBIT:THREE.MOUSE.LEFT,DOLLY:THREE.MOUSE.MIDDLE,PAN:THREE.MOUSE.RIGHT};this.noGyroscope=false;this.gyroscopeSpeed=.02;var s=this;var l=null;var c=null;var u=0;var d=0;var h=new THREE.Vector2;var f=new THREE.Vector2;var m=new THREE.Vector2;var p=new THREE.Vector2;var v=new THREE.Vector2;var g=new THREE.Vector2;var n=new THREE.Vector3;var o=new THREE.Vector3;var i=new THREE.Vector2;var a=new THREE.Vector2;var w=new THREE.Vector2;var E=0;var y=0;var b=0;var _;var T;var x=0;var R=0;var M=1;var P=new THREE.Vector3;var H=new THREE.Vector3;var S=new THREE.Quaternion;var A=false;var C=0,L=0;var e=null;var k=null;var t,$,O,I;var D={NONE:-1,ROTATE:0,DOLLY:1,PAN:2,TOUCH_ROTATE:3,TOUCH_ZOOM:4,TOUCH_PAN:5};var F=D.NONE;this.target0=s.target.clone();this.position0=s.scene.camera.position.clone();this.zoom0=s.scene.camera.zoom;var B=(new THREE.Quaternion).setFromUnitVectors(s.scene.camera.up,new THREE.Vector3(0,1,0));var z=B.clone().invert();var j={type:"change"};var Y={type:"start"};var V={type:"end"};this.setLastQuaternion=function(e){S.copy(e);s.scene.camera.quaternion.copy(e)};this.getLastPosition=function(){return H};this.rotateLeft=function(e){if(e)R+=e};this.rotateUp=function(e){if(e)x+=e};this.panLeft=function(e){var t=s.scene.camera.matrix.elements;n.set(t[0],t[1],t[2]);n.multiplyScalar(-e);P.add(n)};this.panUp=function(e){var t=s.scene.camera.matrix.elements;n.set(t[4],t[5],t[6]);n.multiplyScalar(e);P.add(n)};this.pan=function(e,t){var n=s.canvas===document?s.canvas.body:s.canvas;if(s.scene.camera instanceof THREE.PerspectiveCamera){var i=s.scene.camera.position;var a=i.clone().sub(s.target);var o=a.length();o*=Math.tan(s.scene.camera.fov/2*Math.PI/180);s.panLeft(2*e*o/n.clientHeight);s.panUp(2*t*o/n.clientHeight)}else if(s.scene.camera instanceof THREE.OrthographicCamera){s.panLeft(e*(s.scene.camera.right-s.scene.camera.left)/n.clientWidth);s.panUp(t*(s.scene.camera.top-s.scene.camera.bottom)/n.clientHeight)}else console.warn("IPANORAMA.OrbitControls: encountered an unknown camera type - pan disabled.")};this.momentum=function(){if(!A)return;if(Math.abs(C)<oe&&Math.abs(L)<oe){A=false;return}L*=s.momentumDampingFactor;C*=s.momentumDampingFactor;R-=s.momentumScalingFactor*C;x-=s.momentumScalingFactor*L};this.dollyIn=function(e){if(e===undefined)e=U();if(s.scene.camera instanceof THREE.PerspectiveCamera)M/=e;else if(s.scene.camera instanceof THREE.OrthographicCamera){s.scene.camera.zoom=Math.max(s.minZoom,Math.min(s.maxZoom,s.scene.camera.zoom*e));s.scene.camera.updateProjectionMatrix();s.dispatchEvent(j);s.scene&&s.scene.viewer.$listener.trigger("ipanorama:scene-camera-change",{scene:s.scene})}else console.warn("IPANORAMA.OrbitControls: encountered an unknown camera type - dolly/zoom disabled.")};this.dollyOut=function(e){if(e===undefined)e=U();if(s.scene.camera instanceof THREE.PerspectiveCamera)M*=e;else if(s.scene.camera instanceof THREE.OrthographicCamera){s.scene.camera.zoom=Math.max(s.minZoom,Math.min(s.maxZoom,s.scene.camera.zoom/e));s.scene.camera.updateProjectionMatrix();s.dispatchEvent(j);s.scene&&s.scene.viewer.$listener.trigger("ipanorama:scene-camera-change",{scene:s.scene})}else console.warn("IPANORAMA.OrbitControls: encountered an unknown camera type - dolly/zoom disabled.")};this.update=function(e){var t=s.scene.camera.position;o.copy(t).sub(s.target);o.applyQuaternion(B);_=Math.atan2(o.x,o.z);T=Math.atan2(Math.sqrt(o.x*o.x+o.z*o.z),o.y);if(s.autoRotate&&F===D.NONE){var n=q(s.autoRotateSpeedX),i=q(s.autoRotateSpeedY);s.rotateLeft(n);if(T<=s.minPolarAngle+ae||T>=s.maxPolarAngle-ae){s.rotateUp(-i);s.rotateLeft(Math.PI);s.autoRotateSpeedY=-s.autoRotateSpeedY}else s.rotateUp(i)}s.momentum();_+=R;T+=x;_=Math.max(s.minAzimuthAngle,Math.min(s.maxAzimuthAngle,_));T=Math.max(s.minPolarAngle,Math.min(s.maxPolarAngle,T));T=Math.max(ae,Math.min(Math.PI-ae,T));var a=o.length()*M;a=Math.max(s.minDistance,Math.min(s.maxDistance,a));s.target.add(P);o.x=a*Math.sin(T)*Math.sin(_);o.y=a*Math.cos(T);o.z=a*Math.sin(T)*Math.cos(_);o.applyQuaternion(z);t.copy(s.target).add(o);s.scene.camera.lookAt(s.target);R=0;x=0;M=1;P.set(0,0,0);if(H.distanceToSquared(s.scene.camera.position)>ae||8*(1-S.dot(s.scene.camera.quaternion))>ae){if(e!==true){s.dispatchEvent(j);s.scene&&s.scene.viewer.$listener.trigger("ipanorama:scene-camera-change",{scene:s.scene})}H.copy(s.scene.camera.position);S.copy(s.scene.camera.quaternion);return}};this.bind=function(){s.canvas.addEventListener("mousedown",Z,false);s.canvas.addEventListener("mousewheel",W,false);s.canvas.addEventListener("DOMMouseScroll",W,false);s.canvas.addEventListener("touchstart",J,false);s.canvas.addEventListener("touchend",te,false);s.canvas.addEventListener("touchmove",ee,false);s.canvas.addEventListener("keyup",Q,false);s.canvas.addEventListener("keydown",K,false);window.addEventListener("deviceorientation",ne,false)};this.unbind=function(){s.canvas.removeEventListener("mousedown",Z,false);s.canvas.removeEventListener("mousewheel",W,false);s.canvas.removeEventListener("DOMMouseScroll",W,false);s.canvas.removeEventListener("touchstart",J,false);s.canvas.removeEventListener("touchend",te,false);s.canvas.removeEventListener("touchmove",ee,false);s.canvas.removeEventListener("keyup",Q,false);s.canvas.removeEventListener("keydown",K,false);window.removeEventListener("deviceorientation",ne,false);document.removeEventListener("mousemove",N,false);document.removeEventListener("mouseup",G,false)};this.reset=function(){F=D.NONE;s.target.copy(s.target0);s.scene.camera.position.copy(s.position0);s.scene.camera.zoom=s.zoom0;s.scene.camera.updateProjectionMatrix();s.dispatchEvent(j);s.scene&&s.scene.viewer.$listener.trigger("ipanorama:scene-camera-change",{scene:s.scene});s.update()};this.yawPitchToCoord=function(e,t,n){var i=(180-e)*re,a=t*re;n=n>0?n:1;return{x:n*Math.cos(a)*Math.sin(i),y:n*Math.sin(a),z:n*Math.cos(a)*Math.cos(i)}};this.coordToYawPitch=function(e){var t=Math.atan2(e.x,-e.z),n=Math.sqrt(e.x*e.x+e.z*e.z),i=Math.atan2(e.y,n),a=Math.sqrt(n*n+e.y*e.y),o=t*se,r=i*se;o=o%360;o=o<0?o+360:o;return{yaw:o,pitch:r,radius:a}};this.setYawPitch=function(e,t){s.tweenAnimation&&s.tweenAnimation.stop();var n=s.yawPitchToCoord(e,t);var i=new THREE.Vector3(n.x,n.y,n.z);i.normalize();s.scene.camera.position.copy(i);r.afterRender=true};this.getYawPitch=function(){var e=s.coordToYawPitch(s.scene.camera.position),t=e.yaw,n=e.pitch;t=t%360;t=t<0?t+360:t;return{yaw:t,pitch:n}};this.lookAt=function(e,t,n){var i=new ie.Deferred;if(e.hasOwnProperty("yaw")&&e.hasOwnProperty("pitch"))e=s.yawPitchToCoord(e.yaw,e.pitch);if(t){n=n||le.Easing.Exponential.Out;var a=new THREE.Vector3(0,0,1);a.applyQuaternion(s.scene.camera.quaternion);var o=new THREE.Vector3(e.x,e.y,e.z);o.normalize().negate();if(a.distanceTo(o)<ae)i.resolve();else{s.tweenAnimation&&s.tweenAnimation.stop();s.tweenAnimation=new le.Tween(a).to(o,t).easing(n).onStart(function(){}).onUpdate(function(e){s.scene.camera.position.copy(a)}).onComplete(function(){i.resolve();s.tweenAnimation.stop()}).onStop(function(){i.reject()}).start()}}else{var o=new THREE.Vector3(e.x,e.y,e.z);o.normalize().negate();s.scene.camera.position.copy(o);r.afterRender=true;i.resolve()}return i.promise()};this.getLookAt=function(){var e=s.coordToYawPitch(s.scene.camera.position),t=e.yaw,n=e.pitch;t=t-180;t=t%360;t=t<0?t+360:t;n=n==0?n:-n;return{yaw:t,pitch:n}};this.getZoom=function(){return s.scene.camera.fov},this.setZoom=function(e){if(!e)return;e=Math.max(s.minFov,Math.min(s.maxFov,e));s.scene.camera.fov=e;s.scene.camera.updateProjectionMatrix();s.dispatchEvent(j);s.scene&&s.scene.viewer.$listener.trigger("ipanorama:scene-camera-change",{scene:s.scene})},this.destroy=function(){s.unbind();s.tweenAnimation&&s.tweenAnimation.stop()};function X(e){var t,n,i,a=Math.cos(e.yaw),o=Math.sin(e.yaw),r=Math.cos(e.pitch),s=Math.sin(e.pitch),l=Math.cos(e.roll),c=Math.sin(e.roll);var u=new Array(o*c-a*s*l,-a*r,a*s*c+o*l,r*l,-s,-r*c,o*s*l+a*c,o*r,-o*s*c+a*l);if(u[3]>.9999){t=Math.atan2(u[2],u[8]);i=Math.PI/2;n=0}else if(u[3]<-.9999){t=Math.atan2(u[2],u[8]);i=-Math.PI/2;n=0}else{t=Math.atan2(-u[6],u[0]);n=Math.atan2(-u[5],u[4]);i=Math.asin(u[3])}return new Object({yaw:t,pitch:i,roll:n})}function q(e){return 2*Math.PI/60/60*e}function U(){return Math.pow(.95,s.zoomSpeed)}function Z(e){A=false;C=L=0;if(s.enabled===false)return;if(e.button===s.mouseButtons.ORBIT){if(s.noRotate===true)return;F=D.ROTATE;h.set(e.clientX,e.clientY)}else if(e.button===s.mouseButtons.DOLLY){if(s.noDolly===true)return;F=D.DOLLY;i.set(e.clientX,e.clientY)}else if(e.button===s.mouseButtons.PAN){if(s.noPan===true)return;F=D.PAN;p.set(e.clientX,e.clientY)}if(F!==D.NONE){s.tweenAnimation&&s.tweenAnimation.stop();document.addEventListener("mousemove",N,false);document.addEventListener("mouseup",G,false);s.dispatchEvent(Y);s.scene&&s.scene.viewer.$listener.trigger("ipanorama:scene-camera-start",{scene:s.scene})}s.update()}function N(e){if(s.enabled===false)return;e.preventDefault();var t=s.canvas===document?s.canvas.body:s.canvas;if(F===D.ROTATE){if(s.noRotate===true)return;f.set(e.clientX,e.clientY);m.subVectors(f,h);s.rotateLeft(-2*Math.PI*m.x/t.clientWidth*s.rotateSpeed);s.rotateUp(-2*Math.PI*m.y/t.clientHeight*s.rotateSpeed);h.copy(f);if(k){C=e.clientX-k.clientX;L=e.clientY-k.clientY}k=e}else if(F===D.DOLLY){if(s.noDolly===true)return;a.set(e.clientX,e.clientY);w.subVectors(a,i);if(w.y>0)s.dollyIn();else if(w.y<0)s.dollyOut();i.copy(a)}else if(F===D.PAN){if(s.noPan===true)return;v.set(e.clientX,e.clientY);g.subVectors(v,p);s.pan(g.x,g.y);p.copy(v)}if(F!==D.NONE)s.update()}function G(e){A=true;k=null;if(s.enabled===false)return;document.removeEventListener("mousemove",N,false);document.removeEventListener("mouseup",G,false);s.dispatchEvent(V);s.scene&&s.scene.viewer.$listener.trigger("ipanorama:scene-camera-end",{scene:s.scene});F=D.NONE}function W(e){if(s.enabled===false||s.noZoom===true||F!==D.NONE)return;e.preventDefault();e.stopPropagation();var t=0;if(e.wheelDelta!==undefined)t=e.wheelDelta;else if(e.detail!==undefined)t=-e.detail;if(t>0){s.scene.camera.fov=s.scene.camera.fov>s.minFov?s.scene.camera.fov-1:s.minFov;s.scene.camera.updateProjectionMatrix()}else if(t<0){s.scene.camera.fov=s.scene.camera.fov<s.maxFov?s.scene.camera.fov+1:s.maxFov;s.scene.camera.updateProjectionMatrix()}s.update();s.dispatchEvent(Y);s.scene&&s.scene.viewer.$listener.trigger("ipanorama:scene-camera-start",{scene:s.scene});s.dispatchEvent(j);s.scene&&s.scene.viewer.$listener.trigger("ipanorama:scene-camera-change",{scene:s.scene});s.dispatchEvent(V);s.scene&&s.scene.viewer.$listener.trigger("ipanorama:scene-camera-end",{scene:s.scene})}function Q(e){switch(e.keyCode){case s.keys.UP:t=false;break;case s.keys.BOTTOM:$=false;break;case s.keys.LEFT:O=false;break;case s.keys.RIGHT:I=false;break}}function K(e){if(s.enabled===false||s.noKeys===true)return;switch(e.keyCode){case s.keys.UP:t=true;break;case s.keys.BOTTOM:$=true;break;case s.keys.LEFT:O=true;break;case s.keys.RIGHT:I=true;break}if(t||$||O||I){s.tweenAnimation&&s.tweenAnimation.stop();A=true;if(t)L=-s.rotateSpeed*s.momentumKeydownFactor;if($)L=s.rotateSpeed*s.momentumKeydownFactor;if(O)C=-s.rotateSpeed*s.momentumKeydownFactor;if(I)C=s.rotateSpeed*s.momentumKeydownFactor}}function J(e){A=false;C=L=0;s.tweenAnimation&&s.tweenAnimation.stop();if(s.enabled===false)return;switch(e.touches.length){case 1:{if(s.noRotate===true)return;F=D.TOUCH_ROTATE;h.set(e.touches[0].pageX,e.touches[0].pageY)}break;case 2:{if(s.noZoom===true)return;F=D.TOUCH_ZOOM;var t=e.touches[0].pageX-e.touches[1].pageX;var n=e.touches[0].pageY-e.touches[1].pageY;var i=Math.sqrt(t*t+n*n);E=i;b=s.scene.camera.fov}break;case 3:{if(s.noPan===true)return;F=D.TOUCH_PAN;p.set(e.touches[0].pageX,e.touches[0].pageY)}break;default:F=D.NONE}if(F!==D.NONE){s.tweenAnimation&&s.tweenAnimation.stop();s.dispatchEvent(Y);s.scene&&s.scene.viewer.$listener.trigger("ipanorama:scene-camera-start",{scene:s.scene})}}function ee(e){if(s.enabled===false)return;e.preventDefault();e.stopPropagation();var t=s.canvas===document?s.canvas.body:s.canvas;switch(e.touches.length){case 1:if(s.noRotate===true)return;if(F!==D.TOUCH_ROTATE)return;f.set(e.touches[0].pageX,e.touches[0].pageY);m.subVectors(f,h);s.rotateLeft(-2*Math.PI*m.x/t.clientWidth*s.rotateSpeed);s.rotateUp(-2*Math.PI*m.y/t.clientHeight*s.rotateSpeed);h.copy(f);if(k){C=e.touches[0].pageX-k.pageX;L=e.touches[0].pageY-k.pageY}k={pageX:e.touches[0].pageX,pageY:e.touches[0].pageY};s.update();break;case 2:if(s.noZoom===true)return;if(F!==D.TOUCH_ZOOM)return;var n=e.touches[0].pageX-e.touches[1].pageX;var i=e.touches[0].pageY-e.touches[1].pageY;var a=Math.sqrt(n*n+i*i);y=a;var o=E-y;var r=Math.max(s.minFov,Math.min(s.maxFov,b+o*.1));s.scene.camera.fov=r;s.scene.camera.updateProjectionMatrix();s.update();s.dispatchEvent(j);s.scene&&s.scene.viewer.$listener.trigger("ipanorama:scene-camera-change",{scene:s.scene});break;case 3:if(s.noPan===true)return;if(F!==D.TOUCH_PAN)return;v.set(e.touches[0].pageX,e.touches[0].pageY);g.subVectors(v,p);s.pan(g.x,g.y);p.copy(v);s.update();break;default:F=D.NONE}}function te(e){A=true;k=null;if(s.enabled===false)return;s.dispatchEvent(V);s.scene&&s.scene.viewer.$listener.trigger("ipanorama:scene-camera-end",{scene:s.scene});F=D.NONE}function ne(e){if(s.enabled===false||s.noGyroscope===true)return;var t=X(new Object({yaw:e["alpha"]*re,pitch:e["beta"]*re,roll:e["gamma"]*re})),n=t.yaw/re,i=t.pitch/re,a=n,o;if(Math.abs(i)>70){a=e.alpha;switch(window.orientation){case 0:if(i>0)a+=180;break;case 90:a+=90;break;case-90:a+=-90;break;case 180:if(i<0)a+=180;break}a=a%360;if(Math.abs(a-n)>180)a+=a<n?360:-360;o=Math.min(1,(Math.abs(i)-70)/10);n=n*(1-o)+a*o}if(l!==null&&c!==null){if(l<=0&&n<=0||l>=0&&n>=0){u=l-n;s.rotateLeft(u*-s.gyroscopeSpeed)}d=c-i;s.rotateUp(d*s.gyroscopeSpeed)}l=n;c=i}this.update()};(r.prototype=Object.create(THREE.EventDispatcher.prototype)).constructor=r;var f=function(i,e){THREE.Object3D.call(this);i=i!==undefined?i:document;this.visible=false;var a=new Z;this.add(a);var h=new N;this.add(h);var o=this;j("camera",e);j("object",undefined);j("enabled",true);j("axis",null);j("mode","translate");j("translationSnap",null);j("rotationSnap",null);j("space","world");j("size",1);j("dragging",false);j("showX",true);j("showY",true);j("showZ",true);var f={type:"change"};var r={type:"mouseDown"};var t={type:"mouseUp",mode:o.mode};var m={type:"objectChange"};var p=new THREE.Raycaster;var v=new THREE.Vector3;var n=new THREE.Vector3;var g=new THREE.Quaternion;var w={X:new THREE.Vector3(1,0,0),Y:new THREE.Vector3(0,1,0),Z:new THREE.Vector3(0,0,1)};var s=new THREE.Quaternion;var l=new THREE.Vector3;var E=new THREE.Vector3;var y=new THREE.Vector3;var b=new THREE.Vector3;var _=new THREE.Vector3;var T=new THREE.Vector3;var x=new THREE.Vector3;var R=0;var c=new THREE.Vector3;var u=new THREE.Quaternion;var d=new THREE.Vector3;var M=new THREE.Vector3;var P=new THREE.Quaternion;var H=new THREE.Quaternion;var S=new THREE.Vector3;var A=new THREE.Vector3;var C=new THREE.Quaternion;var L=new THREE.Vector3;var k=new THREE.Vector3;var $=new THREE.Quaternion;var O=new THREE.Quaternion;var I=new THREE.Vector3;var D=new THREE.Vector3;var F=new THREE.Vector3;var B=new THREE.Quaternion;var z=new THREE.Vector3;j("worldPosition",k);j("worldPositionStart",A);j("worldQuaternion",$);j("worldQuaternionStart",C);j("cameraPosition",c);j("cameraQuaternion",u);j("pointStart",E);j("pointEnd",y);j("rotationAxis",_);j("rotationAngle",R);j("eye",D);{i.addEventListener("mousedown",X,false);i.addEventListener("touchstart",X,false);i.addEventListener("mousemove",V,false);i.addEventListener("touchmove",V,false);i.addEventListener("touchmove",q,false);document.addEventListener("mouseup",U,false);i.addEventListener("touchend",U,false);i.addEventListener("touchcancel",U,false);i.addEventListener("touchleave",U,false)}this.dispose=function(){i.removeEventListener("mousedown",X);i.removeEventListener("touchstart",X);i.removeEventListener("mousemove",V);i.removeEventListener("touchmove",V);i.removeEventListener("touchmove",q);document.removeEventListener("mouseup",U);i.removeEventListener("touchend",U);i.removeEventListener("touchcancel",U);i.removeEventListener("touchleave",U)};this.attach=function(e){this.object=e;this.visible=true};this.detach=function(){this.object=undefined;this.visible=false;this.axis=null};function j(t,e){var n=e;Object.defineProperty(o,t,{get:function(){return n!==undefined?n:e},set:function(e){if(n!==e){n=e;h[t]=e;a[t]=e;o.dispatchEvent({type:t+"-changed",value:e});o.dispatchEvent(f)}}});o[t]=e;h[t]=e;a[t]=e}this.updateMatrixWorld=function(){if(this.object!==undefined){this.object.updateMatrixWorld();this.object.parent.matrixWorld.decompose(M,P,S);this.object.matrixWorld.decompose(k,$,I);H.copy(P).invert();O.copy($).invert()}this.camera.updateMatrixWorld();this.camera.matrixWorld.decompose(c,u,d);if(this.camera instanceof THREE.PerspectiveCamera)D.copy(c).sub(k).normalize();else if(this.camera instanceof THREE.OrthographicCamera)D.copy(c).normalize();THREE.Object3D.prototype.updateMatrixWorld.call(this)};this.pointerHover=function(e){if(this.object===undefined||this.dragging===true||e.button!==undefined&&e.button!==0)return;p.setFromCamera(e,this.camera);var t=p.intersectObjects(a.picker[this.mode].children,true)[0]||false;if(t)this.axis=t.object.name;else this.axis=null};this.pointerDown=function(e){if(this.object===undefined||this.dragging===true||e.button!==undefined&&e.button!==0)return;if((e.button===0||e.button===undefined)&&this.axis!==null){p.setFromCamera(e,this.camera);var t=p.intersectObjects([h],true)[0]||false;if(t){var n=this.space;if(this.mode==="scale")n="local";else if(this.axis==="E"||this.axis==="XYZE"||this.axis==="XYZ")n="world";if(n==="local"&&this.mode==="rotate"){var i=this.rotationSnap;if(this.axis==="X"&&i)this.object.rotation.x=Math.round(this.object.rotation.x/i)*i;if(this.axis==="Y"&&i)this.object.rotation.y=Math.round(this.object.rotation.y/i)*i;if(this.axis==="Z"&&i)this.object.rotation.z=Math.round(this.object.rotation.z/i)*i}this.object.updateMatrixWorld();this.object.parent.updateMatrixWorld();F.copy(this.object.position);B.copy(this.object.quaternion);z.copy(this.object.scale);this.object.matrixWorld.decompose(A,C,L);E.copy(t.point).sub(A)}this.dragging=true;r.mode=this.mode;this.dispatchEvent(r)}};this.pointerMove=function(e){var t=this.axis;var n=this.mode;var i=this.object;var a=this.space;if(n==="scale")a="local";else if(t==="E"||t==="XYZE"||t==="XYZ")a="world";if(i===undefined||t===null||this.dragging===false||e.button!==undefined&&e.button!==0)return;p.setFromCamera(e,this.camera);var o=p.intersectObjects([h],true)[0]||false;if(o===false)return;y.copy(o.point).sub(A);if(n==="translate"){b.copy(y).sub(E);if(a==="local"&&t!=="XYZ")b.applyQuaternion(O);if(t.indexOf("X")===-1)b.x=0;if(t.indexOf("Y")===-1)b.y=0;if(t.indexOf("Z")===-1)b.z=0;if(a==="local"&&t!=="XYZ")b.applyQuaternion(B).divide(S);else b.applyQuaternion(H).divide(S);i.position.copy(b).add(F);if(this.translationSnap){if(a==="local"){i.position.applyQuaternion(g.copy(B).invert());if(t.search("X")!==-1)i.position.x=Math.round(i.position.x/this.translationSnap)*this.translationSnap;if(t.search("Y")!==-1)i.position.y=Math.round(i.position.y/this.translationSnap)*this.translationSnap;if(t.search("Z")!==-1)i.position.z=Math.round(i.position.z/this.translationSnap)*this.translationSnap;i.position.applyQuaternion(B)}if(a==="world"){if(i.parent)i.position.add(v.setFromMatrixPosition(i.parent.matrixWorld));if(t.search("X")!==-1)i.position.x=Math.round(i.position.x/this.translationSnap)*this.translationSnap;if(t.search("Y")!==-1)i.position.y=Math.round(i.position.y/this.translationSnap)*this.translationSnap;if(t.search("Z")!==-1)i.position.z=Math.round(i.position.z/this.translationSnap)*this.translationSnap;if(i.parent)i.position.sub(v.setFromMatrixPosition(i.parent.matrixWorld))}}}else if(n==="scale"){if(t.search("XYZ")!==-1){var r=y.length()/E.length();if(y.dot(E)<0)r*=-1;v.set(r,r,r)}else{v.copy(y).divide(E);if(t.search("X")===-1)v.x=1;if(t.search("Y")===-1)v.y=1;if(t.search("Z")===-1)v.z=1}i.scale.copy(z).multiply(v)}else if(n==="rotate"){b.copy(y).sub(E);var s=20/k.distanceTo(v.setFromMatrixPosition(this.camera.matrixWorld));if(t==="E"){_.copy(D);R=y.angleTo(E);T.copy(E).normalize();x.copy(y).normalize();R*=x.cross(T).dot(D)<0?1:-1}else if(t==="XYZE"){_.copy(b).cross(D).normalize();R=b.dot(v.copy(_).cross(this.eye))*s}else if(t==="X"||t==="Y"||t==="Z"){_.copy(w[t]);v.copy(w[t]);if(a==="local")v.applyQuaternion($);R=b.dot(v.cross(D).normalize())*s}if(this.rotationSnap)R=Math.round(R/this.rotationSnap)*this.rotationSnap;this.rotationAngle=R;if(a==="local"&&t!=="E"&&t!=="XYZE"){i.quaternion.copy(B);i.quaternion.multiply(g.setFromAxisAngle(_,R)).normalize()}else{_.applyQuaternion(H);i.quaternion.copy(g.setFromAxisAngle(_,R));i.quaternion.multiply(B).normalize()}}else if(n==="orbit"){b.copy(y).sub(E);if(a==="local"&&t!=="XYZ")b.applyQuaternion(O);if(t.indexOf("X")===-1)b.x=0;if(t.indexOf("Y")===-1)b.y=0;if(t.indexOf("Z")===-1)b.z=0;if(a==="local"&&t!=="XYZ")b.applyQuaternion(B).divide(S);else b.applyQuaternion(H).divide(S);i.position.copy(b).add(F);var l=new THREE.Vector3,c=i.position.clone(),u=l.distanceTo(c),d=new THREE.Vector3;d.addVectors(l,c.normalize().multiplyScalar(500));i.position.copy(d);if(this.translationSnap){if(a==="local"){i.position.applyQuaternion(g.copy(B).invert());if(t.search("X")!==-1)i.position.x=Math.round(i.position.x/this.translationSnap)*this.translationSnap;if(t.search("Y")!==-1)i.position.y=Math.round(i.position.y/this.translationSnap)*this.translationSnap;if(t.search("Z")!==-1)i.position.z=Math.round(i.position.z/this.translationSnap)*this.translationSnap;i.position.applyQuaternion(B)}if(a==="world"){if(i.parent)i.position.add(v.setFromMatrixPosition(i.parent.matrixWorld));if(t.search("X")!==-1)i.position.x=Math.round(i.position.x/this.translationSnap)*this.translationSnap;if(t.search("Y")!==-1)i.position.y=Math.round(i.position.y/this.translationSnap)*this.translationSnap;if(t.search("Z")!==-1)i.position.z=Math.round(i.position.z/this.translationSnap)*this.translationSnap;if(i.parent)i.position.sub(v.setFromMatrixPosition(i.parent.matrixWorld))}}}this.dispatchEvent(f);this.dispatchEvent(m)};this.pointerUp=function(e){if(e.button!==undefined&&e.button!==0)return;if(this.dragging&&this.axis!==null){t.mode=this.mode;this.dispatchEvent(t)}this.dragging=false;if(e.button===undefined)this.axis=null};function Y(e){var t=e.changedTouches?e.changedTouches[0]:e;var n=i.getBoundingClientRect();return{x:(t.clientX-n.left)/n.width*2-1,y:-(t.clientY-n.top)/n.height*2+1,button:e.button}}function V(e){if(!o.enabled)return;o.pointerHover(Y(e))}function X(e){if(!o.enabled)return;document.addEventListener("mousemove",q,false);o.pointerHover(Y(e));o.pointerDown(Y(e))}function q(e){if(!o.enabled)return;o.pointerMove(Y(e))}function U(e){if(!o.enabled)return;document.removeEventListener("mousemove",q,false);o.pointerUp(Y(e))}};f.prototype=Object.assign(Object.create(THREE.Object3D.prototype),{constructor:f,isTransformControls:true});var Z=function(){THREE.Object3D.call(this);this.type="TransformControlsGizmo";var e=new THREE.MeshBasicMaterial({depthTest:false,depthWrite:false,transparent:true,side:THREE.DoubleSide,fog:false});var t=new THREE.LineBasicMaterial({depthTest:false,depthWrite:false,transparent:true,linewidth:1,fog:false});var n=e.clone();n.opacity=.15;var i=e.clone();i.opacity=.33;var a=e.clone();a.color.set(16711680);var o=e.clone();o.color.set(65280);var r=e.clone();r.color.set(255);var s=e.clone();s.opacity=.25;var l=s.clone();l.color.set(16776960);var c=s.clone();c.color.set(65535);var u=s.clone();u.color.set(16711935);var d=e.clone();d.color.set(16776960);var h=t.clone();h.color.set(16711680);var f=t.clone();f.color.set(65280);var m=t.clone();m.color.set(255);var p=t.clone();p.color.set(65535);var v=t.clone();v.color.set(16711935);var g=t.clone();g.color.set(16776960);var w=t.clone();w.color.set(7895160);var E=g.clone();E.opacity=.25;var y=new THREE.CylinderBufferGeometry(0,.05,.2,12,1,false);var b=new THREE.BoxBufferGeometry(.125,.125,.125);var _=new THREE.BufferGeometry;_.setAttribute("position",new THREE.Float32BufferAttribute([0,0,0,1,0,0],3));var T=function(e,t){var n=new THREE.BufferGeometry;var i=[];for(var a=0;a<=64*t;++a)i.push(0,Math.cos(a/32*Math.PI)*e,Math.sin(a/32*Math.PI)*e);n.setAttribute("position",new THREE.Float32BufferAttribute(i,3));return n};var x=function(e,t){var n=new THREE.BufferGeometry;n.setAttribute("position",new THREE.Float32BufferAttribute([0,0,0,1,1,1],3));return n};var R={X:[[new THREE.Mesh(y,a),[1,0,0],[0,0,-Math.PI/2],null,"fwd"],[new THREE.Mesh(y,a),[1,0,0],[0,0,Math.PI/2],null,"bwd"],[new THREE.Line(_,h)]],Y:[[new THREE.Mesh(y,o),[0,1,0],null,null,"fwd"],[new THREE.Mesh(y,o),[0,1,0],[Math.PI,0,0],null,"bwd"],[new THREE.Line(_,f),null,[0,0,Math.PI/2]]],Z:[[new THREE.Mesh(y,r),[0,0,1],[Math.PI/2,0,0],null,"fwd"],[new THREE.Mesh(y,r),[0,0,1],[-Math.PI/2,0,0],null,"bwd"],[new THREE.Line(_,m),null,[0,-Math.PI/2,0]]],XYZ:[[new THREE.Mesh(new THREE.OctahedronBufferGeometry(.1,0),s),[0,0,0],[0,0,0]]],XY:[[new THREE.Mesh(new THREE.PlaneBufferGeometry(.295,.295),l),[.15,.15,0]],[new THREE.Line(_,g),[.18,.3,0],null,[.125,1,1]],[new THREE.Line(_,g),[.3,.18,0],[0,0,Math.PI/2],[.125,1,1]]],YZ:[[new THREE.Mesh(new THREE.PlaneBufferGeometry(.295,.295),c),[0,.15,.15],[0,Math.PI/2,0]],[new THREE.Line(_,p),[0,.18,.3],[0,0,Math.PI/2],[.125,1,1]],[new THREE.Line(_,p),[0,.3,.18],[0,-Math.PI/2,0],[.125,1,1]]],XZ:[[new THREE.Mesh(new THREE.PlaneBufferGeometry(.295,.295),u),[.15,0,.15],[-Math.PI/2,0,0]],[new THREE.Line(_,v),[.18,0,.3],null,[.125,1,1]],[new THREE.Line(_,v),[.3,0,.18],[0,-Math.PI/2,0],[.125,1,1]]]};var M={X:[[new THREE.Mesh(new THREE.CylinderBufferGeometry(.2,0,1,4,1,false),n),[.6,0,0],[0,0,-Math.PI/2]]],Y:[[new THREE.Mesh(new THREE.CylinderBufferGeometry(.2,0,1,4,1,false),n),[0,.6,0]]],Z:[[new THREE.Mesh(new THREE.CylinderBufferGeometry(.2,0,1,4,1,false),n),[0,0,.6],[Math.PI/2,0,0]]],XYZ:[[new THREE.Mesh(new THREE.OctahedronBufferGeometry(.2,0),n)]],XY:[[new THREE.Mesh(new THREE.PlaneBufferGeometry(.4,.4),n),[.2,.2,0]]],YZ:[[new THREE.Mesh(new THREE.PlaneBufferGeometry(.4,.4),n),[0,.2,.2],[0,Math.PI/2,0]]],XZ:[[new THREE.Mesh(new THREE.PlaneBufferGeometry(.4,.4),n),[.2,0,.2],[-Math.PI/2,0,0]]]};var P={START:[[new THREE.Mesh(new THREE.OctahedronBufferGeometry(.01,2),i),null,null,null,"helper"]],END:[[new THREE.Mesh(new THREE.OctahedronBufferGeometry(.01,2),i),null,null,null,"helper"]],DELTA:[[new THREE.Line(x(),i),null,null,null,"helper"]],X:[[new THREE.Line(_,i.clone()),[-1e3,0,0],null,[1e6,1,1],"helper"]],Y:[[new THREE.Line(_,i.clone()),[0,-1e3,0],[0,0,Math.PI/2],[1e6,1,1],"helper"]],Z:[[new THREE.Line(_,i.clone()),[0,0,-1e3],[0,-Math.PI/2,0],[1e6,1,1],"helper"]]};var H={X:[[new THREE.Line(T(1,.5),h)],[new THREE.Mesh(new THREE.OctahedronBufferGeometry(.04,0),a),[0,0,.99],null,[1,3,1]]],Y:[[new THREE.Line(T(1,.5),f),null,[0,0,-Math.PI/2]],[new THREE.Mesh(new THREE.OctahedronBufferGeometry(.04,0),o),[0,0,.99],null,[3,1,1]]],Z:[[new THREE.Line(T(1,.5),m),null,[0,Math.PI/2,0]],[new THREE.Mesh(new THREE.OctahedronBufferGeometry(.04,0),r),[.99,0,0],null,[1,3,1]]],E:[[new THREE.Line(T(1.25,1),E),null,[0,Math.PI/2,0]],[new THREE.Mesh(new THREE.CylinderBufferGeometry(.03,0,.15,4,1,false),E),[1.17,0,0],[0,0,-Math.PI/2],[1,1,.001]],[new THREE.Mesh(new THREE.CylinderBufferGeometry(.03,0,.15,4,1,false),E),[-1.17,0,0],[0,0,Math.PI/2],[1,1,.001]],[new THREE.Mesh(new THREE.CylinderBufferGeometry(.03,0,.15,4,1,false),E),[0,-1.17,0],[Math.PI,0,0],[1,1,.001]],[new THREE.Mesh(new THREE.CylinderBufferGeometry(.03,0,.15,4,1,false),E),[0,1.17,0],[0,0,0],[1,1,.001]]],XYZE:[[new THREE.Line(T(1,1),w),null,[0,Math.PI/2,0]]]};var S={AXIS:[[new THREE.Line(_,i.clone()),[-1e3,0,0],null,[1e6,1,1],"helper"]]};var A={X:[[new THREE.Mesh(new THREE.TorusBufferGeometry(1,.1,4,24),n),[0,0,0],[0,-Math.PI/2,-Math.PI/2]]],Y:[[new THREE.Mesh(new THREE.TorusBufferGeometry(1,.1,4,24),n),[0,0,0],[Math.PI/2,0,0]]],Z:[[new THREE.Mesh(new THREE.TorusBufferGeometry(1,.1,4,24),n),[0,0,0],[0,0,-Math.PI/2]]],E:[[new THREE.Mesh(new THREE.TorusBufferGeometry(1.25,.1,2,24),n)]],XYZE:[[new THREE.Mesh(new THREE.SphereBufferGeometry(.7,10,8),n)]]};var C={X:[[new THREE.Mesh(b,a),[.8,0,0],[0,0,-Math.PI/2]],[new THREE.Line(_,h),null,null,[.8,1,1]]],Y:[[new THREE.Mesh(b,o),[0,.8,0]],[new THREE.Line(_,f),null,[0,0,Math.PI/2],[.8,1,1]]],Z:[[new THREE.Mesh(b,r),[0,0,.8],[Math.PI/2,0,0]],[new THREE.Line(_,m),null,[0,-Math.PI/2,0],[.8,1,1]]],XY:[[new THREE.Mesh(b,l),[.85,.85,0],null,[2,2,.2]],[new THREE.Line(_,g),[.855,.98,0],null,[.125,1,1]],[new THREE.Line(_,g),[.98,.855,0],[0,0,Math.PI/2],[.125,1,1]]],YZ:[[new THREE.Mesh(b,c),[0,.85,.85],null,[.2,2,2]],[new THREE.Line(_,p),[0,.855,.98],[0,0,Math.PI/2],[.125,1,1]],[new THREE.Line(_,p),[0,.98,.855],[0,-Math.PI/2,0],[.125,1,1]]],XZ:[[new THREE.Mesh(b,u),[.85,0,.85],null,[2,.2,2]],[new THREE.Line(_,v),[.855,0,.98],null,[.125,1,1]],[new THREE.Line(_,v),[.98,0,.855],[0,-Math.PI/2,0],[.125,1,1]]],XYZX:[[new THREE.Mesh(new THREE.BoxBufferGeometry(.125,.125,.125),s),[1.1,0,0]]],XYZY:[[new THREE.Mesh(new THREE.BoxBufferGeometry(.125,.125,.125),s),[0,1.1,0]]],XYZZ:[[new THREE.Mesh(new THREE.BoxBufferGeometry(.125,.125,.125),s),[0,0,1.1]]]};var L={X:[[new THREE.Mesh(new THREE.CylinderBufferGeometry(.2,0,.8,4,1,false),n),[.5,0,0],[0,0,-Math.PI/2]]],Y:[[new THREE.Mesh(new THREE.CylinderBufferGeometry(.2,0,.8,4,1,false),n),[0,.5,0]]],Z:[[new THREE.Mesh(new THREE.CylinderBufferGeometry(.2,0,.8,4,1,false),n),[0,0,.5],[Math.PI/2,0,0]]],XY:[[new THREE.Mesh(b,n),[.85,.85,0],null,[3,3,.2]]],YZ:[[new THREE.Mesh(b,n),[0,.85,.85],null,[.2,3,3]]],XZ:[[new THREE.Mesh(b,n),[.85,0,.85],null,[3,.2,3]]],XYZX:[[new THREE.Mesh(new THREE.BoxBufferGeometry(.2,.2,.2),n),[1.1,0,0]]],XYZY:[[new THREE.Mesh(new THREE.BoxBufferGeometry(.2,.2,.2),n),[0,1.1,0]]],XYZZ:[[new THREE.Mesh(new THREE.BoxBufferGeometry(.2,.2,.2),n),[0,0,1.1]]]};var k={X:[[new THREE.Line(_,i.clone()),[-1e3,0,0],null,[1e6,1,1],"helper"]],Y:[[new THREE.Line(_,i.clone()),[0,-1e3,0],[0,0,Math.PI/2],[1e6,1,1],"helper"]],Z:[[new THREE.Line(_,i.clone()),[0,0,-1e3],[0,-Math.PI/2,0],[1e6,1,1],"helper"]]};var $={X:[[new THREE.Mesh(y,a),[1,0,0],[0,0,-Math.PI/2],null,"fwd"],[new THREE.Mesh(y,a),[1,0,0],[0,0,Math.PI/2],null,"bwd"],[new THREE.Line(_,h)]],Y:[[new THREE.Mesh(y,o),[0,1,0],null,null,"fwd"],[new THREE.Mesh(y,o),[0,1,0],[Math.PI,0,0],null,"bwd"],[new THREE.Line(_,f),null,[0,0,Math.PI/2]]],Z:[[new THREE.Mesh(y,r),[0,0,1],[Math.PI/2,0,0],null,"fwd"],[new THREE.Mesh(y,r),[0,0,1],[-Math.PI/2,0,0],null,"bwd"],[new THREE.Line(_,m),null,[0,-Math.PI/2,0]]],XYZ:[[new THREE.Mesh(new THREE.OctahedronBufferGeometry(.1,0),s),[0,0,0],[0,0,0]]]};var O={X:[[new THREE.Mesh(new THREE.CylinderBufferGeometry(.2,0,1,4,1,false),n),[.6,0,0],[0,0,-Math.PI/2]]],Y:[[new THREE.Mesh(new THREE.CylinderBufferGeometry(.2,0,1,4,1,false),n),[0,.6,0]]],Z:[[new THREE.Mesh(new THREE.CylinderBufferGeometry(.2,0,1,4,1,false),n),[0,0,.6],[Math.PI/2,0,0]]],XYZ:[[new THREE.Mesh(new THREE.OctahedronBufferGeometry(.2,0),n)]]};var I={START:[[new THREE.Mesh(new THREE.OctahedronBufferGeometry(.01,2),i),null,null,null,"helper"]],END:[[new THREE.Mesh(new THREE.OctahedronBufferGeometry(.01,2),i),null,null,null,"helper"]],DELTA:[[new THREE.Line(x(),i),null,null,null,"helper"]]};var D=function(e){var t=new THREE.Object3D;for(var n in e)for(var i=e[n].length;i--;){var a=e[n][i][0].clone();var o=e[n][i][1];var r=e[n][i][2];var s=e[n][i][3];var l=e[n][i][4];a.name=n;a.tag=l;if(o)a.position.set(o[0],o[1],o[2]);if(r)a.rotation.set(r[0],r[1],r[2]);if(s)a.scale.set(s[0],s[1],s[2]);a.updateMatrix();var c=a.geometry.clone();c.applyMatrix4(a.matrix);a.geometry=c;a.position.set(0,0,0);a.rotation.set(0,0,0);a.scale.set(1,1,1);t.add(a)}return t};var F=new THREE.Vector3(0,0,0);var B=new THREE.Euler;var z=new THREE.Vector3(0,1,0);var j=new THREE.Vector3(0,0,0);var Y=new THREE.Matrix4;var V=new THREE.Quaternion;var X=new THREE.Quaternion;var q=new THREE.Quaternion;var U=new THREE.Vector3(1,0,0);var Z=new THREE.Vector3(0,1,0);var N=new THREE.Vector3(0,0,1);this.gizmo={};this.picker={};this.helper={};this.add(this.gizmo["translate"]=D(R));this.add(this.gizmo["rotate"]=D(H));this.add(this.gizmo["scale"]=D(C));this.add(this.gizmo["orbit"]=D($));this.add(this.picker["translate"]=D(M));this.add(this.picker["rotate"]=D(A));this.add(this.picker["scale"]=D(L));this.add(this.picker["orbit"]=D(O));this.add(this.helper["translate"]=D(P));this.add(this.helper["rotate"]=D(S));this.add(this.helper["scale"]=D(k));this.add(this.helper["orbit"]=D(I));this.picker["translate"].visible=false;this.picker["rotate"].visible=false;this.picker["scale"].visible=false;this.picker["orbit"].visible=false;this.updateMatrixWorld=function(){var e=this.space;if(this.mode==="scale")e="local";var t=e==="local"?this.worldQuaternion:q;this.gizmo["translate"].visible=this.mode==="translate";this.gizmo["rotate"].visible=this.mode==="rotate";this.gizmo["scale"].visible=this.mode==="scale";this.gizmo["orbit"].visible=this.mode==="orbit";this.helper["translate"].visible=this.mode==="translate";this.helper["rotate"].visible=this.mode==="rotate";this.helper["scale"].visible=this.mode==="scale";this.helper["orbit"].visible=this.mode==="orbit";var n=[];n=n.concat(this.picker[this.mode].children);n=n.concat(this.gizmo[this.mode].children);n=n.concat(this.helper[this.mode].children);for(var i=0;i<n.length;i++){var a=n[i];a.visible=true;a.rotation.set(0,0,0);a.position.copy(this.worldPosition);var o=this.worldPosition.distanceTo(this.cameraPosition);a.scale.set(1,1,1).multiplyScalar(o*this.size/7);if(a.tag==="helper"){a.visible=false;if(a.name==="AXIS"){a.position.copy(this.worldPositionStart);a.visible=!!this.axis;if(this.axis==="X"){V.setFromEuler(B.set(0,0,0));a.quaternion.copy(t).multiply(V);if(Math.abs(z.copy(U).applyQuaternion(t).dot(this.eye))>.9)a.visible=false}if(this.axis==="Y"){V.setFromEuler(B.set(0,0,Math.PI/2));a.quaternion.copy(t).multiply(V);if(Math.abs(z.copy(Z).applyQuaternion(t).dot(this.eye))>.9)a.visible=false}if(this.axis==="Z"){V.setFromEuler(B.set(0,Math.PI/2,0));a.quaternion.copy(t).multiply(V);if(Math.abs(z.copy(N).applyQuaternion(t).dot(this.eye))>.9)a.visible=false}if(this.axis==="XYZE"){V.setFromEuler(B.set(0,Math.PI/2,0));z.copy(this.rotationAxis);a.quaternion.setFromRotationMatrix(Y.lookAt(j,z,Z));a.quaternion.multiply(V);a.visible=this.dragging}if(this.axis==="E")a.visible=false}else if(a.name==="START"){a.position.copy(this.worldPositionStart);a.visible=this.dragging}else if(a.name==="END"){a.position.copy(this.worldPosition);a.visible=this.dragging}else if(a.name==="DELTA"){a.position.copy(this.worldPositionStart);a.quaternion.copy(this.worldQuaternionStart);F.set(1e-10,1e-10,1e-10).add(this.worldPositionStart).sub(this.worldPosition).multiplyScalar(-1);F.applyQuaternion(this.worldQuaternionStart.clone().invert());a.scale.copy(F);a.visible=this.dragging}else{a.quaternion.copy(t);if(this.dragging)a.position.copy(this.worldPositionStart);else a.position.copy(this.worldPosition);if(this.axis)a.visible=this.axis.search(a.name)!==-1}continue}a.quaternion.copy(t);if(this.mode==="translate"||this.mode==="scale"||this.mode==="orbit"){var r=.99;var s=.2;var l=-.4;if(a.name==="X"||a.name==="XYZX")if(Math.abs(z.copy(U).applyQuaternion(t).dot(this.eye))>r){a.scale.set(1e-10,1e-10,1e-10);a.visible=false}if(a.name==="Y"||a.name==="XYZY")if(Math.abs(z.copy(Z).applyQuaternion(t).dot(this.eye))>r){a.scale.set(1e-10,1e-10,1e-10);a.visible=false}if(a.name==="Z"||a.name==="XYZZ")if(Math.abs(z.copy(N).applyQuaternion(t).dot(this.eye))>r){a.scale.set(1e-10,1e-10,1e-10);a.visible=false}if(a.name==="XY")if(Math.abs(z.copy(N).applyQuaternion(t).dot(this.eye))<s){a.scale.set(1e-10,1e-10,1e-10);a.visible=false}if(a.name==="YZ")if(Math.abs(z.copy(U).applyQuaternion(t).dot(this.eye))<s){a.scale.set(1e-10,1e-10,1e-10);a.visible=false}if(a.name==="XZ")if(Math.abs(z.copy(Z).applyQuaternion(t).dot(this.eye))<s){a.scale.set(1e-10,1e-10,1e-10);a.visible=false}if(a.name.search("X")!==-1)if(z.copy(U).applyQuaternion(t).dot(this.eye)<l)if(a.tag==="fwd")a.visible=false;else a.scale.x*=-1;else if(a.tag==="bwd")a.visible=false;if(a.name.search("Y")!==-1)if(z.copy(Z).applyQuaternion(t).dot(this.eye)<l)if(a.tag==="fwd")a.visible=false;else a.scale.y*=-1;else if(a.tag==="bwd")a.visible=false;if(a.name.search("Z")!==-1)if(z.copy(N).applyQuaternion(t).dot(this.eye)<l)if(a.tag==="fwd")a.visible=false;else a.scale.z*=-1;else if(a.tag==="bwd")a.visible=false}else if(this.mode==="rotate"){X.copy(t);z.copy(this.eye).applyQuaternion(V.copy(t).invert());if(a.name.search("E")!==-1)a.quaternion.setFromRotationMatrix(Y.lookAt(this.eye,j,Z));if(a.name==="X"){V.setFromAxisAngle(U,Math.atan2(-z.y,z.z));V.multiplyQuaternions(X,V);a.quaternion.copy(V)}if(a.name==="Y"){V.setFromAxisAngle(Z,Math.atan2(z.x,z.z));V.multiplyQuaternions(X,V);a.quaternion.copy(V)}if(a.name==="Z"){V.setFromAxisAngle(N,Math.atan2(z.y,z.x));V.multiplyQuaternions(X,V);a.quaternion.copy(V)}}a.visible=a.visible&&(a.name.indexOf("X")===-1||this.showX);a.visible=a.visible&&(a.name.indexOf("Y")===-1||this.showY);a.visible=a.visible&&(a.name.indexOf("Z")===-1||this.showZ);a.visible=a.visible&&(a.name.indexOf("E")===-1||this.showX&&this.showY&&this.showZ);a.material._opacity=a.material._opacity||a.material.opacity;a.material._color=a.material._color||a.material.color.clone();a.material.color.copy(a.material._color);a.material.opacity=a.material._opacity;if(!this.enabled){a.material.opacity*=.5;a.material.color.lerp(new THREE.Color(1,1,1),.5)}else if(this.axis)if(a.name===this.axis){a.material.opacity=1;a.material.color.lerp(new THREE.Color(1,1,1),.5)}else if(this.axis.split("").some(function(e){return a.name===e})){a.material.opacity=1;a.material.color.lerp(new THREE.Color(1,1,1),.5)}else{a.material.opacity*=.25;a.material.color.lerp(new THREE.Color(1,1,1),.5)}}THREE.Object3D.prototype.updateMatrixWorld.call(this)}};Z.prototype=Object.assign(Object.create(THREE.Object3D.prototype),{constructor:Z,isTransformControlsGizmo:true});var N=function(){THREE.Mesh.call(this,new THREE.PlaneBufferGeometry(1e5,1e5,2,2),new THREE.MeshBasicMaterial({visible:true,wireframe:true,side:THREE.DoubleSide,transparent:true,opacity:.1}));this.type="TransformControlsPlane";var t=new THREE.Vector3(1,0,0);var n=new THREE.Vector3(0,1,0);var i=new THREE.Vector3(0,0,1);var a=new THREE.Vector3;var o=new THREE.Vector3;var r=new THREE.Vector3;var s=new THREE.Matrix4;var l=new THREE.Quaternion;this.updateMatrixWorld=function(){var e=this.space;this.position.copy(this.worldPosition);if(this.mode==="scale")e="local";t.set(1,0,0).applyQuaternion(e==="local"?this.worldQuaternion:l);n.set(0,1,0).applyQuaternion(e==="local"?this.worldQuaternion:l);i.set(0,0,1).applyQuaternion(e==="local"?this.worldQuaternion:l);r.copy(n);switch(this.mode){case"translate":case"scale":switch(this.axis){case"X":r.copy(this.eye).cross(t);o.copy(t).cross(r);break;case"Y":r.copy(this.eye).cross(n);o.copy(n).cross(r);break;case"Z":r.copy(this.eye).cross(i);o.copy(i).cross(r);break;case"XY":o.copy(i);break;case"YZ":o.copy(t);break;case"XZ":r.copy(i);o.copy(n);break;case"XYZ":case"E":o.set(0,0,0);break}break;case"rotate":case"orbit":default:o.set(0,0,0)}if(o.length()===0)this.quaternion.copy(this.cameraQuaternion);else{s.lookAt(a.set(0,0,0),o,r);this.quaternion.setFromRotationMatrix(s)}THREE.Object3D.prototype.updateMatrixWorld.call(this)}};N.prototype=Object.assign(Object.create(THREE.Mesh.prototype),{constructor:N,isTransformControlsPlane:true});var s=function(l,e){this.cfg=e;this.enabled=e.enabled;this.defaultPoint={image:e.image,width:e.width,height:e.height,opacity:e.opacity};this.transformControl=new f(l.viewer.$canvas.get(0),l.camera);this.transformControl.mode="orbit";l.scene.add(this.transformControl);var c=this;var n={ESCAPE:27,LEFT:37,UP:38,RIGHT:39,DOWN:40,DELETE:46};var s=new THREE.Raycaster;var a=this.transformControl;this.bind=function(){l.viewer.$canvas.on("keydown",t);l.viewer.$canvas.on("keyup",i);l.viewer.$canvas.on("click",o);l.viewer.$canvas.on("dblclick",r);a.addEventListener("dragging-changed",u);a.addEventListener("mode-changed",d)};this.unbind=function(){l.viewer.$canvas.off("keydown",t);l.viewer.$canvas.off("keyup",i);l.viewer.$canvas.off("click",o);l.viewer.$canvas.off("dblclick",r);a.removeEventListener("dragging-changed",u);a.removeEventListener("mode-changed",d)};this.detach=function(){a.detach()};this.attach=function(e){e&&a.attach(e.mesh)};this.getSceneIntersectPoint=function(e,t){var n=l.viewer.$canvas.get(0).getBoundingClientRect(),i=new THREE.Vector2;i.x=(e-n.left)/n.width*2-1;i.y=-((t-n.top)/n.height)*2+1;s.setFromCamera(i,l.camera);var a=s.intersectObjects([l.mesh],false);if(a.length){var o=a[0].point,r=new THREE.Vector3;l.mesh.getWorldPosition(r);return new THREE.Vector3(parseFloat((o.x-r.x).toFixed(2)),parseFloat((o.y-r.y).toFixed(2)),parseFloat((o.z-r.z).toFixed(2)))}return null};this.addPointToCenter=function(e){var t=l.viewer.$canvas.get(0).getBoundingClientRect(),n=t.left+t.width/2,i=t.top+t.height/2;var a=l.scene.position.clone(),o=c.getSceneIntersectPoint(n,i),r=a.distanceTo(o),s=new THREE.Vector3;s.addVectors(a,o.normalize().multiplyScalar(500));return l.addPoint(c.createPoint(s),e)};this.createPoint=function(e){var t=new h({pos:e,image:c.defaultPoint.image,width:c.defaultPoint.width,height:c.defaultPoint.height,opacity:c.defaultPoint.opacity});return t};var t=function(e){if(c.enabled===false)return};var i=function(e){if(c.enabled===false||!a.object)return;switch(e.keyCode){case n.DELETE:if(a.object.userData.type=="point"){var t=l.findPointByMesh(a.object);a.detach();l.removePoint(t)}break;case n.ESCAPE:a.object&&l.deselectPoint(a.object.userData.point);a.detach();break}};var o=function(e){if(c.enabled===false)return;var t=l.viewer.$canvas.get(0).getBoundingClientRect(),n=new THREE.Vector2;n.x=(e.clientX-t.left)/t.width*2-1;n.y=-((e.clientY-t.top)/t.height)*2+1;s.setFromCamera(n,l.camera);var i=s.intersectObjects(l.scene.children);if(i.length)if(i[0].object.userData.type==="point"){if(a.object!==i[0].object){a.attach(i[0].object);l.selectPoint(a.object.userData.point)}return}a.object&&l.deselectPoint(a.object.userData.point);a.detach()};var r=function(e){if(c.enabled===false)return;var t=l.scene.position.clone(),n=c.getSceneIntersectPoint(e.clientX,e.clientY),i=t.distanceTo(n),a=new THREE.Vector3;a.addVectors(t,n.normalize().multiplyScalar(500));l.addPoint(c.createPoint(a))};var u=function(e){if(e.value)l.dragstartPoint(e.target.object.userData.point);else l.dragendPoint(e.target.object.userData.point);l.control.enabled=!e.value};var d=function(e){l.transformModeChanged(e.value)}},l=function(a){var o=this;var n=new THREE.Frustum;var r=null;this.bind=function(){a.control.addEventListener("change",e);a.control.addEventListener("start",t);a.control.addEventListener("end",c)};this.unbind=function(){a.control.removeEventListener("change",e);a.control.removeEventListener("start",t);a.control.removeEventListener("end",c)};this.update=function(){n.setFromProjectionMatrix((new THREE.Matrix4).multiplyMatrices(a.camera.projectionMatrix,a.camera.matrixWorldInverse));var e=null;for(var t=0;t<a.points.length;t++){e=a.points[t];s(n,e,true)}};this.show=function(){n.setFromProjectionMatrix((new THREE.Matrix4).multiplyMatrices(a.camera.projectionMatrix,a.camera.matrixWorldInverse));var e=null;for(var t=0;t<a.points.length;t++){var e=a.points[t];e.mesh.visible=true;s(n,e,false)}};this.hide=function(){for(var e=0;e<a.points.length;e++){var t=a.points[e];i(t)}};this.getScreenCoord=function(e){e.project(a.camera);e.x=Math.round((.5+e.x/2)*a.viewer.$canvas.get(0).clientWidth);//!!!window.devicePixelRatio
e.y=Math.round((.5-e.y/2)*a.viewer.$canvas.get(0).clientHeight);//!!!window.devicePixelRatio
return{x:e.x,y:e.y}};var i=function(e){e.mesh.visible=false;if(e.visible){e.visible=false;a.viewer.$listener.trigger("ipanorama:scene-point-hide",{scene:a,point:e})}};var s=function(e,t,n){if(e.containsPoint(t.mesh.position)){l(t);if(!t.visible){t.visible=true;a.viewer.$listener.trigger("ipanorama:scene-point-show",{scene:a,point:t})}n&&a.viewer.$listener.trigger("ipanorama:scene-point-change",{scene:a,point:t})}else if(t.visible){t.visible=false;a.viewer.$listener.trigger("ipanorama:scene-point-hide",{scene:a,point:t})}};var l=function(i){i.mesh.quaternion.copy(a.camera.quaternion);var e=i.mesh.position.clone();i.screenPos=o.getScreenCoord(e);if(r!=a.camera.fov){i.mesh.updateMatrixWorld();let e=new THREE.Vector3,t=new THREE.Vector3,n=new THREE.Vector3;e.fromBufferAttribute(i.mesh.geometry.attributes.position,0);t.fromBufferAttribute(i.mesh.geometry.attributes.position,1);n.fromBufferAttribute(i.mesh.geometry.attributes.position,2);e.applyMatrix4(i.mesh.matrixWorld);t.applyMatrix4(i.mesh.matrixWorld);n.applyMatrix4(i.mesh.matrixWorld);e=o.getScreenCoord(e);t=o.getScreenCoord(t);n=o.getScreenCoord(n);i.screenWidth=t.x-e.x;i.screenHeight=n.y-e.y;r=a.camera.fov}};var e=function(){o.update()};var t=function(){};var c=function(){}},h=function(t){this.cfg=t;this.loaded=false;this.yaw=null;this.pitch=null;this.radius=null;this.texture=null;this.geometry=new THREE.PlaneGeometry(t.width,t.height),this.material=new THREE.ShaderMaterial({uniforms:{tex:{value:null},opacity:{value:t.opacity}},vertexShader:["varying vec2 vUv;","void main() {","vUv = uv;","gl_Position = projectionMatrix * (modelViewMatrix * vec4(0.0, 0.0, 0.0, 1.0) + vec4(position.x, position.y, 0.0, 0.0));","}"].join("\n"),fragmentShader:["varying vec2 vUv;","uniform sampler2D tex;","uniform float opacity;","void main() {","vec2 uv = vUv;","vec4 fragColor = texture2D(tex, uv);","fragColor.a *= opacity;","if (fragColor.a < 0.3 ) discard;","gl_FragColor = fragColor;","}"].join("\n"),side:THREE.DoubleSide,transparent:true,depthTest:false,depthWrite:false});this.mesh=new THREE.Mesh(this.geometry,this.material);this.mesh.userData.point=this;this.mesh.userData.type="point";this.mesh.visible=false;var a=this;function o(e,t,n){var i=(180-e)*re,a=t*re;n=n>0?n:1;return{x:n*Math.cos(a)*Math.sin(i),y:n*Math.sin(a),z:n*Math.cos(a)*Math.cos(i)}}function e(e){var t=Math.atan2(e.x,-e.z),n=Math.sqrt(e.x*e.x+e.z*e.z),i=Math.atan2(e.y,n),a=Math.sqrt(n*n+e.y*e.y),o=t*se,r=i*se;o=o%360;o=o<0?o+360:o;return{yaw:o,pitch:r,radius:a}}this.load=function(e){e=e||t.image;if(!e){console.warn("IPANORAMA.Point: image source undefined");return}else if(typeof e==="string")Y.TextureLoader.load(e,n,i,r,false);else if(e instanceof HTMLImageElement)n(new THREE.Texture(e))};this.setYawPitch=function(e,t,n){n=n>0?n:1;a.yaw=e;a.pitch=t;a.radius=n;var i=o(e,t,n);a.mesh.position.set(i.x,i.y,i.z)};this.getYawPitch=function(){return e(a.mesh.position)};this.setTexture=function(e){a.texture&&a.texture.dispose();a.texture=e;a.material.uniforms.tex.value=a.texture;a.material.needsUpdate=true};this.setOpacity=function(e){a.material.uniforms.opacity.value=e;a.material.needsUpdate=true};this.destroy=function(){a.geometry&&a.geometry.dispose();a.material&&a.material.dispose();a.texture&&a.texture.dispose()};var n=function(e){a.loaded=true;a.setTexture(e)};var i=function(e){};var r=function(){console.warn("IPANORAMA.Point: undefined error while loading")};var s=t.pos;if(s)a.mesh.position.set(s.x,s.y,s.z);else if(t.hasOwnProperty("yaw")&&t.hasOwnProperty("pitch"))a.setYawPitch(t.yaw,t.pitch,t.radius)},c=function(c,e){this.cfg=e;this.enabled=e.enabled;this.defaultPlane={image:e.image,width:e.width,height:e.height,opacity:e.opacity,billboard:e.billboard};this.transformControl=new f(c.viewer.$canvas.get(0),c.camera);this.transformControl.mode="translate";c.scene.add(this.transformControl);var u=this;var i={ESCAPE:27,LEFT:37,UP:38,RIGHT:39,DOWN:40,DELETE:46,TAB:9};var a=["translate","rotate"];var s=new THREE.Raycaster;var o=this.transformControl;this.bind=function(){c.viewer.$canvas.on("keydown",t);c.viewer.$canvas.on("keyup",n);c.viewer.$canvas.on("click",r);c.viewer.$canvas.on("dblclick",l);o.addEventListener("dragging-changed",d);o.addEventListener("mode-changed",h)};this.unbind=function(){c.viewer.$canvas.off("keydown",t);c.viewer.$canvas.off("keyup",n);c.viewer.$canvas.off("click",r);c.viewer.$canvas.off("dblclick",l);o.removeEventListener("dragging-changed",d);o.removeEventListener("mode-changed",h)};this.detach=function(){o.detach()};this.attach=function(e){e&&o.attach(e.mesh)};this.getSceneIntersectPoint=function(e,t){var n=c.viewer.$canvas.get(0).getBoundingClientRect(),i=new THREE.Vector2;i.x=(e-n.left)/n.width*2-1;i.y=-((t-n.top)/n.height)*2+1;s.setFromCamera(i,c.camera);var a=s.intersectObjects([c.mesh],false);if(a.length){var o=a[0].point,r=new THREE.Vector3;c.mesh.getWorldPosition(r);return new THREE.Vector3(parseFloat((o.x-r.x).toFixed(2)),parseFloat((o.y-r.y).toFixed(2)),parseFloat((o.z-r.z).toFixed(2)))}return null};this.addPlaneToCenter=function(e){var t=c.viewer.$canvas.get(0).getBoundingClientRect(),n=t.left+t.width/2,i=t.top+t.height/2;var a=c.scene.position.clone(),o=u.getSceneIntersectPoint(n,i),r=a.distanceTo(o),s=new THREE.Vector3,l={x:THREE.Math.radToDeg(c.camera.rotation.x),y:THREE.Math.radToDeg(c.camera.rotation.y),z:THREE.Math.radToDeg(c.camera.rotation.z)};s.addVectors(a,o.normalize().multiplyScalar(500));return c.addPlane(u.createPlane(s,l),e)};this.createPlane=function(e,t){var n=new m({pos:e,rotate:t,image:u.defaultPlane.image,width:u.defaultPlane.width,height:u.defaultPlane.height,opacity:u.defaultPlane.opacity,billboard:u.defaultPlane.billboard});return n};var t=function(e){if(u.enabled===false)return;if(o.object)return false};var n=function(e){if(u.enabled===false||!o.object)return;switch(e.keyCode){case i.DELETE:if(o.object.userData.type=="plane"){var t=c.findPlaneByMesh(o.object);o.detach();c.removePlane(t)}break;case i.ESCAPE:o.object&&c.deselectPlane(o.object.userData.plane);o.detach();break;case i.TAB:for(var n=0;n<a.length;n++)if(a[n]==o.mode)break;o.mode=a[n<a.length-1?n+1:0];break}};var r=function(e){if(u.enabled===false)return;var t=c.viewer.$canvas.get(0).getBoundingClientRect(),n=new THREE.Vector2;n.x=(e.clientX-t.left)/t.width*2-1;n.y=-((e.clientY-t.top)/t.height)*2+1;s.setFromCamera(n,c.camera);var i=s.intersectObjects(c.scene.children);if(i.length)if(i[0].object.userData.type==="plane"){if(o.object!==i[0].object){o.attach(i[0].object);c.selectPlane(o.object.userData.plane)}return}o.object&&c.deselectPlane(o.object.userData.plane);o.detach()};var l=function(e){if(u.enabled===false)return;var t=c.scene.position.clone(),n=u.getSceneIntersectPoint(e.clientX,e.clientY),i=t.distanceTo(n),a=new THREE.Vector3,o={x:THREE.Math.radToDeg(c.camera.rotation.x),y:THREE.Math.radToDeg(c.camera.rotation.y),z:THREE.Math.radToDeg(c.camera.rotation.z)};a.addVectors(t,n.normalize().multiplyScalar(500));c.addPlane(u.createPlane(a,o))};var d=function(e){if(e.value)c.dragstartPlane(e.target.object.userData.plane);else c.dragendPlane(e.target.object.userData.plane);c.control.enabled=!e.value};var h=function(e){c.transformModeChanged(e.value)}},m=function(t){this.cfg=t;this.loaded=false;this.texture=null;this.geometry=new THREE.PlaneGeometry(t.width,t.height),this.material=new THREE.ShaderMaterial({uniforms:{tex:{value:null},opacity:{value:t.opacity},billboard:{value:t.billboard}},vertexShader:["varying vec2 vUv;","uniform bool billboard;","void main() {","vUv = uv;","if(billboard) {","gl_Position = projectionMatrix * (modelViewMatrix * vec4(0.0, 0.0, 0.0, 1.0) + vec4(position.x, position.y, 0.0, 0.0));","} else {","gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );","}","}"].join("\n"),fragmentShader:["varying vec2 vUv;","uniform sampler2D tex;","uniform vec3 color;","uniform float opacity;","void main() {","vec2 uv = vUv;","vec4 fragColor = texture2D(tex, uv);","fragColor.a *= opacity;","if (fragColor.a < 0.3 ) discard;","gl_FragColor = fragColor;","}"].join("\n"),side:THREE.DoubleSide,transparent:true});this.mesh=new THREE.Mesh(this.geometry,this.material);this.mesh.userData.plane=this;this.mesh.userData.type="plane";this.mesh.visible=true;this.mesh.position.set(t.pos.x,t.pos.y,t.pos.z);this.mesh.rotation.x=THREE.Math.degToRad(t.rotate.x);this.mesh.rotation.y=THREE.Math.degToRad(t.rotate.y);this.mesh.rotation.z=THREE.Math.degToRad(t.rotate.z);var n=this;this.load=function(e){e=e||t.image;if(!e){console.warn("IPANORAMA.Plane: image source undefined");return}else if(typeof e==="string")Y.TextureLoader.load(e,i,a,o,false);else if(e instanceof HTMLImageElement)i(new THREE.Texture(e))};this.setTexture=function(e){n.texture&&n.texture.dispose();n.texture=e;n.material.uniforms.tex.value=n.texture;n.material.needsUpdate=true};this.setOpacity=function(e){n.material.uniforms.opacity.value=e;n.material.needsUpdate=true};this.setBillboard=function(e){n.material.uniforms.billboard.value=e;n.material.needsUpdate=true};this.destroy=function(){n.geometry&&n.geometry.dispose();n.material&&n.material.dispose();n.texture&&n.texture.dispose()};var i=function(e){n.loaded=true;n.setTexture(e)};var a=function(e){};var o=function(){console.warn("IPANORAMA.Plane: undefined error while loading")}},u=function(e,t){this.cfg=t;this.enabled=t.enabled;this.speedX=t.speedX;this.speedY=t.speedY;this.speedZ=t.speedZ;this.startDelay=t.startDelay;this.inactivityDelay=t.inactivityDelay;var n=this;var i=false;var a=null;var o=null;this.bind=function(){e.control.addEventListener("end",r);n.start()};this.unbind=function(){e.control.removeEventListener("end",r);n.stop()};this.start=function(){if(i&&a){if(n.enabled){e.control.autoRotate=true;e.control.autoRotateSpeedX=n.speedX;e.control.autoRotateSpeedY=n.speedY;e.control.autoRotateSpeedZ=n.speedZ}}else{clearTimeout(a);a=setTimeout(l,n.startDelay)}};this.stop=function(){clearTimeout(o);o=setTimeout(s,n.inactivityDelay);e.control.autoRotate=false};var r=function(){n.stop()};var s=function(){n.start()};var l=function(){i=true;n.start()}},p=function(e,t,n){var i=t.$canvas.get(0).clientWidth,a=t.$canvas.get(0).clientHeight,o=1,r=1e5,s={minFilter:THREE.LinearFilter,magFilter:THREE.LinearFilter,format:THREE.RGBFormat,stencilBuffer:false};this.cfg=e;this.viewer=t;this.smartRequest=n;this.loaded=false;this.afterRender=true;this.raycaster=new THREE.Raycaster;this.fbo=new THREE.WebGLRenderTarget(i,a,s);this.camera=new THREE.PerspectiveCamera(e.cameraFov,i/a,o,r);this.camera.position.z=1;this.camera.updateProjectionMatrix();this.sceneDfd=null;this.scene=null;this.mesh=null};Object.assign(p.prototype,{update:function(){},render:function(e,t){if(!this.loaded)return;e.setClearColor(0);if(t){e.setRenderTarget(this.fbo);e.clear();e.render(this.scene,this.camera)}else{e.setRenderTarget(null);e.render(this.scene,this.camera)}if(this.afterRender){this.pointControl&&this.pointControl.update();this.afterRender=false}},load:function(){this.viewer.$listener.trigger("ipanorama:scene-before-load",{scene:this})},onLoad:function(){this.loaded=true;this.afterRender=true;this.viewer.$listener.trigger("ipanorama:scene-after-load",{scene:this});this.onReady()},onReady:function(){this.sceneDfd&&this.sceneDfd.resolve()},onProgress:function(e){this.viewer.$listener.trigger("ipanorama:scene-progress",{scene:this,progress:e})},onError:function(){this.loaded=false;this.sceneDfd&&this.sceneDfd.reject();this.viewer.$listener.trigger("ipanorama:scene-error",{scene:this})},onShowStart:function(){this.viewer.$listener.trigger("ipanorama:scene-show-start",{scene:this})},onShowUpdate:function(e){},onShowComplete:function(){this.viewer.$listener.trigger("ipanorama:scene-show-complete",{scene:this})},onHideStart:function(){this.viewer.$listener.trigger("ipanorama:scene-hide-start",{scene:this})},onHideUpdate:function(e){},onHideComplete:function(){this.viewer.$listener.trigger("ipanorama:scene-hide-complete",{scene:this})},onWindowResize:function(e,t){if(this.camera instanceof THREE.PerspectiveCamera){this.camera.aspect=e/t;this.camera.updateProjectionMatrix()}this.fbo.setSize(e,t);if(this.pointControl)this.pointControl.update()},get:function(){this.sceneDfd&&this.sceneDfd.reject();this.sceneDfd=new ie.Deferred;return this.sceneDfd.promise()},destroy:function(){this.control&&this.control.destroy();this.control=null},addPoint:function(e,t){if(this.points&&e){e.load();this.points.push(e);this.scene.add(e.mesh);!t&&this.viewer.$listener.trigger("ipanorama:scene-point-add",{scene:this,point:e});if(this.loaded)this.pointControl.show();return e}return null},removePoint:function(e,t){if(this.points&&e){var n=null;for(var i=0;i<this.points.length;i++)if(Object.is(e,this.points[i]))n=i;if(n!=null){this.pointEditor&&this.pointEditor.detach();e=this.points[n];this.scene.remove(e.mesh);e.destroy();this.points.splice(n,1);!t&&this.viewer.$listener.trigger("ipanorama:scene-point-remove",{scene:this,point:e})}}},removePoints:function(e){if(this.points){this.pointEditor&&this.pointEditor.detach();for(var t=0;t<this.points.length;t++){var n=this.points[t];this.scene.remove(n.mesh);n.destroy();!e&&this.viewer.$listener.trigger("ipanorama:scene-point-remove",{scene:this,point:n})}this.points=[]}},dragstartPoint:function(e){if(this.points&&e)this.viewer.$listener.trigger("ipanorama:scene-point-dragstart",{scene:this,point:e})},dragendPoint:function(e){if(this.points&&e)this.viewer.$listener.trigger("ipanorama:scene-point-dragend",{scene:this,point:e})},selectPoint:function(e){if(this.points&&e)this.viewer.$listener.trigger("ipanorama:scene-point-select",{scene:this,point:e})},deselectPoint:function(e){if(this.points&&e)this.viewer.$listener.trigger("ipanorama:scene-point-deselect",{scene:this,point:e})},findPointByMesh:function(e){for(var t=0;t<this.points.length;t++)if(Object.is(e,this.points[t].mesh))return this.points[t];return null},addPlane:function(e,t){if(this.planes&&e){e.load();this.planes.push(e);this.scene.add(e.mesh);!t&&this.viewer.$listener.trigger("ipanorama:scene-plane-add",{scene:this,plane:e});return e}return null},removePlane:function(e,t){if(this.planes&&e){var n=null;for(var i=0;i<this.planes.length;i++)if(Object.is(e,this.planes[i]))n=i;if(n!=null){this.planeEditor&&this.planeEditor.detach();e=this.planes[n];this.scene.remove(e.mesh);e.destroy();this.planes.splice(n,1);!t&&this.viewer.$listener.trigger("ipanorama:scene-plane-remove",{scene:this,plane:e})}}},removePlanes:function(e){if(this.planes){this.planeEditor&&this.planeEditor.detach();for(var t=0;t<this.planes.length;t++){var n=this.planes[t];this.scene.remove(n.mesh);n.destroy();!e&&this.viewer.$listener.trigger("ipanorama:scene-plane-remove",{scene:this,plane:n})}this.planes=[]}},dragstartPlane:function(e){if(this.planes&&e)this.viewer.$listener.trigger("ipanorama:scene-plane-dragstart",{scene:this,plane:e})},dragendPlane:function(e){if(this.planes&&e)this.viewer.$listener.trigger("ipanorama:scene-plane-dragend",{scene:this,plane:e})},selectPlane:function(e){if(this.planes&&e)this.viewer.$listener.trigger("ipanorama:scene-plane-select",{scene:this,plane:e})},deselectPlane:function(e){if(this.planes&&e)this.viewer.$listener.trigger("ipanorama:scene-plane-deselect",{scene:this,plane:e})},findPlaneByMesh:function(e){for(var t=0;t<this.planes.length;t++)if(Object.is(e,this.planes[t].mesh))return this.planes[t];return null},transformModeChanged:function(e){this.viewer.$listener.trigger("ipanorama:transform-mode-changed",{scene:this,mode:e})},lookAt:function(e,t,n){this.control&&this.control.lookAt(e,t,n)},setProperty:function(e,t){return false}});var t=function(e,t,n){p.call(this,e,t,n);this.image=null;this.texture=null;this.radius=5e3;this.geometry=new THREE.BoxGeometry(this.radius*2,this.radius*2,this.radius*2,18,18,18);for(var i in this.geometry.vertices){var a=this.geometry.vertices[i];a.normalize().multiplyScalar(this.radius)}function o(e){var t=new THREE.ShaderMaterial({uniforms:{tex:{value:null},backgroundColor:{value:new THREE.Color(0)},haov:{value:360},vaov:{value:180},vOffset:{value:0}},vertexShader:["varying vec2 vUv;","void main() {","vUv = uv;","gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);","}"].join("\n"),fragmentShader:["varying vec2 vUv;","uniform sampler2D tex;","uniform vec3 backgroundColor;","uniform float haov;","uniform float vaov;","uniform float vOffset;","const float PI = 3.14159265359;","const float PI2 = PI * 2.0;","const float PI_DIV_2 = PI / 2.0;","const int RIGHT  = 0;","const int LEFT   = 1;","const int UP     = 2;","const int DOWN   = 3;","const int FRONT  = 4;","const int BACK   = 5;","vec3 uvToXYZ(vec2 uv, int faceIndex) {","float a = 2.0 * uv.x;","float b = 2.0 * uv.y;","vec3 result;","if(faceIndex == RIGHT) {","result = vec3(a - 1.0, -1.0, 1.0 - b);","} else if(faceIndex == LEFT) {","result = vec3(1.0 - a, 1.0, 1.0 - b);","} else if(faceIndex == UP) {","result = vec3(1.0 - b, a - 1.0, -1.0);","} else if(faceIndex == DOWN) {","result = vec3(b - 1.0, a - 1.0, 1.0);","} else if(faceIndex == FRONT) {","result = vec3(1.0, a - 1.0, 1.0 - b);","} else if(faceIndex == BACK) {","result = vec3(-1.0, 1.0 - a, 1.0 - b);","}","return result;","}","void main() {","vec2 uv = vUv;","uv.x = 1.0 - uv.x;","vec3 xyz = uvToXYZ(uv, "+e+");","float x = xyz.x;","float y = xyz.y;","float z = xyz.z;","float theta = atan(y, x);","float r = pow(x * x + y * y, 0.5);","float phi = PI_DIV_2 - atan(z, r);","float yaw = theta * 180.0 / PI + 180.0;","float pitch = phi * 180.0 / PI - 90.0;","if(yaw > 180.0) {","yaw -= 360.0;","}","if(yaw > -(haov/2.0) && yaw < (haov/2.0) && (pitch > (-vaov/2.0 + vOffset) && pitch < (vaov/2.0 + vOffset))) {","float uf = (yaw + haov/2.0)/haov;","float vf = (pitch - vOffset + vaov/2.0)/vaov;","gl_FragColor = texture2D(tex, vec2(uf, vf));","} else {","gl_FragColor = vec4(backgroundColor, 0);","}","}"].join("\n"),side:THREE.DoubleSide});return t}this.materials=[o(0),o(1),o(2),o(3),o(4),o(5)];this.mesh=new THREE.Mesh(this.geometry,this.materials);this.scene=new THREE.Scene;this.scene.add(this.mesh);this.control=new r(this);this.autoRotateControl=new u(this,e.autoRotate);this.points=[];this.pointEditor=new s(this,e.pointEditor);this.pointControl=new l(this);this.planes=[];this.planeEditor=new c(this,e.planeEditor)};(t.prototype=Object.create(p.prototype)).constructor=t,Object.assign(t.prototype,{update:function(){this.control.update();p.prototype.update.call(this)},load:function(e,t){p.prototype.load.call(this);if(!e){console.warn("IPANORAMA.SceneSphere: image source undefined");this.onError();return}else if(typeof e==="string"){this.smartRequest&&this.smartRequest.abort();Y.TextureLoader.load(e,this.onLoad.bind(this),t?null:this.onProgress.bind(this),this.onError.bind(this),this.smartRequest)}else if(e instanceof HTMLImageElement)this.onLoad(new THREE.Texture(e),e)},onLoad:function(e,t){this.image=t;this.texture&&this.texture.dispose();this.texture=e;this.texture.minFilter=THREE.LinearFilter;this.texture.needsUpdate=true;for(var n=0;n<this.materials.length;n++)this.materials[n].uniforms.tex.value=this.texture;window.requestAnimationFrame(function(){window.requestAnimationFrame(function(){p.prototype.onLoad.call(this)}.bind(this))}.bind(this))},onShowStart:function(){this.bind();this.pointControl.show();p.prototype.onShowStart.call(this)},onHideStart:function(){this.unbind();this.pointControl.hide();p.prototype.onHideStart.call(this)},get:function(e){if(e)this.load(this.image);return p.prototype.get.call(this)},destroy:function(){this.control.destroy();this.scene.remove(this.mesh);this.geometry&&this.geometry.dispose();this.material&&this.material.dispose();this.texture&&this.texture.dispose();this.mesh=undefined;p.prototype.destroy.call(this)},bind:function(){this.control.bind();this.autoRotateControl.bind();this.pointEditor.bind();this.pointControl.bind();this.planeEditor.bind()},unbind:function(){this.control.unbind();this.autoRotateControl.unbind();this.pointEditor.unbind();this.pointControl.unbind();this.planeEditor.unbind()}});var n=function(e,t,n){p.call(this,e,t,n);this.image=e.image;this.size=5e3;this.texture=null;this.geometry=new THREE.BoxGeometry(this.size,this.size,this.size),this.material=new THREE.ShaderMaterial({uniforms:{tex:{value:new THREE.Texture},flip:{value:-1}},vertexShader:["varying vec3 vWorldDirection;","void main() {","vWorldDirection = normalize((modelMatrix * vec4(position, 0.0)).xyz);","vec4 vPosition = modelViewMatrix * vec4( position, 1.0 );","gl_Position = projectionMatrix * vPosition;","}"].join("\n"),fragmentShader:["varying vec3 vWorldDirection;","uniform samplerCube tex;","uniform float flip;","void main() {","gl_FragColor = textureCube(tex, vec3( flip * vWorldDirection.x, vWorldDirection.yz ));","}"].join("\n"),side:THREE.DoubleSide});this.mesh=new THREE.Mesh(this.geometry,this.material);this.scene=new THREE.Scene;this.scene.add(this.mesh);this.control=new r(this);this.autoRotateControl=new u(this,e.autoRotate);this.points=[];this.pointEditor=new s(this,e.pointEditor);this.pointControl=new l(this);this.planes=[];this.planeEditor=new c(this,e.planeEditor)};(n.prototype=Object.create(p.prototype)).constructor=n,Object.assign(n.prototype,{update:function(){this.control.update();p.prototype.update.call(this)},load:function(e){p.prototype.load.call(this);this.image=e||this.image;if(!e){console.warn("IPANORAMA.SceneCube: the image source is undefined");this.onError();return}else if(typeof e==="string"){this.smartRequest&&this.smartRequest.abort();IPANORAMA.Utils.CubeOneTextureLoader.load(this.image,this.onLoad.bind(this),this.onProgress.bind(this),this.onError.bind(this),this.smartRequest)}else if(ie.isArray(e))if(e.length==6){this.smartRequest&&this.smartRequest.abort();IPANORAMA.Utils.CubeSixTextureLoader.load(this.image,this.onLoad.bind(this),this.onProgress.bind(this),this.onError.bind(this),this.smartRequest)}else{console.warn("IPANORAMA.SceneCube: the image source should be an array of 6 images");this.onError();return}else if(e.front&&e.back&&e.left&&e.right&&e.top&&e.bottom){this.smartRequest&&this.smartRequest.abort();IPANORAMA.Utils.CubeSixTextureLoader.load(this.image,this.onLoad.bind(this),this.onProgress.bind(this),this.onError.bind(this),this.smartRequest)}else{console.warn("IPANORAMA.SceneCube: the image source is unknown");this.onError();return}},onLoad:function(e){this.texture&&this.texture.dispose();this.texture=e;this.texture.minFilter=this.texture.magFilter=THREE.LinearFilter;this.texture.needsUpdate=true;this.material.uniforms.tex.value=this.texture;window.requestAnimationFrame(function(){window.requestAnimationFrame(function(){p.prototype.onLoad.call(this)}.bind(this))}.bind(this))},onShowStart:function(){this.bind();this.pointControl.show();p.prototype.onShowStart.call(this)},onHideStart:function(){this.unbind();this.pointControl.hide();p.prototype.onHideStart.call(this)},get:function(e){if(e)this.load(this.image);return p.prototype.get.call(this)},destroy:function(){this.scene.remove(this.mesh);this.geometry&&this.geometry.dispose();this.material&&this.material.dispose();this.texture&&this.texture.dispose();this.mesh=undefined;p.prototype.destroy.call(this)},bind:function(){this.control.bind();this.autoRotateControl.bind();this.pointEditor.bind();this.pointControl.bind();this.planeEditor.bind()},unbind:function(){this.control.unbind();this.autoRotateControl.unbind();this.pointEditor.unbind();this.pointControl.unbind();this.planeEditor.unbind()}});var o=function(e,t,n){p.call(this,e,t,n);this.panoId=e.panoId;this.location=e.location;this.zoom=2;this.gsvLoader=new i.PanoLoader;this.texture=null;this.geometry=new THREE.SphereGeometry(5e3,60,40),this.material=new THREE.ShaderMaterial({uniforms:{tex:{value:null}},vertexShader:["varying vec2 vUv;","void main() {","vUv = uv;","gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );","}"].join("\n"),fragmentShader:["varying vec2 vUv;","uniform sampler2D tex;","void main() {","vec2 uv = vUv;","uv.x = 1.0 - uv.x;","gl_FragColor = texture2D(tex, uv);","}"].join("\n"),side:THREE.DoubleSide});this.mesh=new THREE.Mesh(this.geometry,this.material);this.scene=new THREE.Scene;this.scene.add(this.mesh);this.control=new r(this);this.autoRotateControl=new u(this,e.autoRotate);this.points=[];this.pointEditor=new s(this,e.pointEditor);this.pointControl=new l(this);this.planes=[];this.planeEditor=new c(this,e.planeEditor)};(o.prototype=Object.create(p.prototype)).constructor=o,Object.assign(o.prototype,{update:function(){this.control.update()},load:function(e){p.prototype.load.call(this);var t=this;if(!e){console.warn("IPANORAMA.SceneGoogleStreetView: location source undefined");this.onError();return}else if(typeof e==="string"){this.panoId=e;this.gsvLoader.onPanoramaLoad=this.onPanoramaLoad.bind(this);this.gsvLoader.onProgress=this.onProgress.bind(this);this.gsvLoader.onError=function(){console.warn("IPANORAMA.SceneGoogleStreetView: location source is wrong");t.onError()};this.gsvLoader.setZoom(this.zoom);this.gsvLoader.loadById(this.panoId)}else if(e.hasOwnProperty("lat")&&e.hasOwnProperty("lng")){this.location=e;this.gsvLoader.onPanoramaLoad=this.onPanoramaLoad.bind(this);this.gsvLoader.onProgress=this.onProgress.bind(this);this.gsvLoader.onError=function(){console.warn("IPANORAMA.SceneGoogleStreetView: location source is wrong");t.onError()};this.gsvLoader.setZoom(this.zoom);this.gsvLoader.loadByLocation(new google.maps.LatLng(this.location.lat,this.location.lng))}else{console.warn("IPANORAMA.SceneGoogleStreetView: location source should contain lat & lng parameters");this.onError();return}},onPanoramaLoad:function(e){this.onLoad(new THREE.Texture(e))},onLoad:function(e){this.texture&&this.texture.dispose();this.texture=e;this.texture.minFilter=this.texture.magFilter=THREE.LinearFilter;this.texture.needsUpdate=true;this.material.uniforms.tex.value=this.texture;window.requestAnimationFrame(function(){window.requestAnimationFrame(function(){p.prototype.onLoad.call(this)}.bind(this))}.bind(this))},onShowStart:function(){this.bind();this.pointControl.show();p.prototype.onShowStart.call(this)},onHideStart:function(){this.unbind();this.pointControl.hide();p.prototype.onHideStart.call(this)},get:function(e){if(e)this.load(this.panoId||this.location);return p.prototype.get.call(this)},destroy:function(){this.scene.remove(this.mesh);this.geometry&&this.geometry.dispose();this.material&&this.material.dispose();this.texture&&this.texture.dispose();this.mesh=undefined;p.prototype.destroy.call(this)},bind:function(){this.control.bind();this.autoRotateControl.bind();this.pointEditor.bind();this.pointControl.bind();this.planeEditor.bind()},unbind:function(){this.control.unbind();this.autoRotateControl.unbind();this.pointEditor.unbind();this.pointControl.unbind();this.planeEditor.unbind()}});var v=function(e,t,n){this.canvas=e;this.material=t;this.scene=n;this.scene.control=this;this.enabled=true;this.noZoom=false;this.zoomSpeed=1;this.minZoom=0;this.maxZoom=Infinity;this.noRotate=false;this.rotateSpeedX=.3;this.rotateSpeedY=.3;this.autoRotate=false;this.autoRotateSpeedX=.3;this.autoRotateSpeedY=0;this.autoRotateSpeedZ=0;this.noKeys=false;this.keySpeed=.3;this.keys={LEFT:37,UP:38,RIGHT:39,BOTTOM:40};var c=this;var i=1e-6;var u=false;var d=new THREE.Vector2;var a=new THREE.Vector3(1,0,0);var o=new THREE.Vector3(0,1,0);var r=new THREE.Vector3(0,0,1);var s={yaw:0,pitch:0,roll:0};var l=new THREE.Quaternion;var h=new THREE.Quaternion;var f=new THREE.Quaternion;l.setFromAxisAngle(o,-90*re);h.setFromAxisAngle(r,90*re);f.multiply(l).multiply(h);var m={type:"change"};var p={type:"start"};var v={type:"end"};var g,w,E,y;this.rotateLeft=function(e){if(e)c.rotate(e,0,0)};this.rotateUp=function(e){if(e)c.rotate(0,e,0)};this.update=function(){if(c.autoRotate&&!u){var e=false;if(c.autoRotateSpeedX||c.autoRotateSpeedY||c.autoRotateSpeedZ){var t=THREE.Math.degToRad(-c.autoRotateSpeedX/10);var n=THREE.Math.degToRad(c.autoRotateSpeedY/10);var i=THREE.Math.degToRad(-c.autoRotateSpeedZ/10);c.rotate(t,n,i);e=true}if(e){c.material.uniforms.transform.value.makeRotationFromQuaternion(f);c.dispatchEvent(m)}}else c.material.uniforms.transform.value.makeRotationFromQuaternion(f)};this.bind=function(){c.canvas.addEventListener("mousedown",T,false);c.canvas.addEventListener("mousemove",x,false);c.canvas.addEventListener("mouseup",R,false);c.canvas.addEventListener("touchstart",T,false);c.canvas.addEventListener("touchmove",x,false);c.canvas.addEventListener("touchend",R,false);c.canvas.addEventListener("keydown",H,false);c.canvas.addEventListener("keyup",P,false);c.canvas.addEventListener("mousewheel",M,false);c.canvas.addEventListener("DOMMouseScroll",M,false)};this.unbind=function(){u=false;c.canvas.removeEventListener("mousedown",T,false);c.canvas.removeEventListener("mousemove",x,false);c.canvas.removeEventListener("mouseup",R,false);c.canvas.removeEventListener("touchstart",T,false);c.canvas.removeEventListener("touchmove",x,false);c.canvas.removeEventListener("touchend",R,false);c.canvas.removeEventListener("keydown",H,false);c.canvas.removeEventListener("keyup",P,false);c.canvas.removeEventListener("mousewheel",M,false);c.canvas.removeEventListener("DOMMouseScroll",M,false)};this.yawPitchToCoord=function(e,t,n){var i=(180-e)*re,a=t*re;n=n>0?n:1;return{x:n*Math.cos(a)*Math.sin(i),y:n*Math.sin(a),z:n*Math.cos(a)*Math.cos(i)}};this.coordToYawPitch=function(e){var t=Math.atan2(e.x,-e.z),n=Math.sqrt(e.x*e.x+e.z*e.z),i=Math.atan2(e.y,n),a=Math.sqrt(n*n+e.y*e.y),o=t*se,r=i*se;o=o%360;o=o<0?o+360:o;return{yaw:o,pitch:r,radius:a}};this.setYawPitch=function(e,t){c.tweenAnimation&&c.tweenAnimation.stop();e=e+180;e=e%360;e=e<0?e+360:e;t=t==0?t:-t;b(e,t)};this.getYawPitch=function(){var e=s.yaw,t=s.pitch;e=e%360;e=e<0?e+360:e;return{yaw:s.yaw,pitch:s.pitch}};this.lookAt=function(e,t,n){var i=new ie.Deferred;if(!(e.hasOwnProperty("yaw")&&e.hasOwnProperty("pitch")))e=c.coordToYawPitch(e);if(t){n=n||le.Easing.Exponential.Out;var a=s;var o={yaw:e.yaw,pitch:e.pitch};c.tweenAnimation&&c.tweenAnimation.stop();c.tweenAnimation=new le.Tween(a).to(o,t).easing(n).onStart(function(){}).onUpdate(function(e){b(a.yaw,a.pitch)}).onComplete(function(){i.resolve();c.tweenAnimation.stop()}).onStop(function(){i.reject()}).start()}else{b(e.yaw,e.pitch);i.resolve()}return i.promise()};this.getLookAt=function(){var e=s.yaw,t=s.pitch;e=e%360;e=e<0?e+360:e;return{yaw:e,pitch:t}};this.getZoom=function(){return c.material.uniforms.zoom.value},this.setZoom=function(e){if(!e)return;e=Math.max(c.minZoom,Math.min(c.maxZoom,e));c.material.uniforms.zoom.value=e;c.update()},this.rotate=function(e,t,n){s.yaw+=e*se;s.pitch+=t*se;s.roll+=n*se;var e=s.yaw*re;var t=s.pitch*re;var n=s.roll*re;l=new THREE.Quaternion;h=new THREE.Quaternion;f=new THREE.Quaternion;l.setFromAxisAngle(o,-90*re);h.setFromAxisAngle(r,90*re);f.multiply(l).multiply(h);l.setFromAxisAngle(o,-e);h.setFromAxisAngle(a,-t);f.multiply(l).multiply(h);l.setFromAxisAngle(r,n);h.setFromAxisAngle(r,n);f.multiply(l).multiply(h)};this.destroy=function(){this.unbind()};function b(e,t){s.yaw=e;s.pitch=t;var n=s.yaw*re;var i=s.pitch*re;l=new THREE.Quaternion;h=new THREE.Quaternion;f=new THREE.Quaternion;l.setFromAxisAngle(o,-90*re);h.setFromAxisAngle(r,90*re);f.multiply(l).multiply(h);l.setFromAxisAngle(o,-n);h.setFromAxisAngle(a,-i);f.multiply(l).multiply(h);c.update()}function _(e){c.material.uniforms.zoom.value-=e*c.zoomSpeed;c.material.uniforms.zoom.value=Math.max(c.minZoom,Math.min(c.maxZoom,c.material.uniforms.zoom.value))}function T(e){if(c.enabled===false)return;c.tweenAnimation&&c.tweenAnimation.stop();var t=e.clientX>=0?e.clientX:e.touches[0].clientX,n=e.clientY>=0?e.clientY:e.touches[0].clientY,i=e.touches&&e.touches.length||1;switch(i){case 1:{u=true;d.set(t,n)}break;case 2:{var a=e.touches[0].pageX-e.touches[1].pageX,o=e.touches[0].pageY-e.touches[1].pageY,r=Math.sqrt(a*a+o*o);d.pinchDistance=r}break}c.dispatchEvent(p);c.update();e.preventDefault()}function x(e){if(c.enabled===false||!u)return;var t=e.clientX>=0?e.clientX:e.touches[0].clientX,n=e.clientY>=0?e.clientY:e.touches[0].clientY,i=e.touches&&e.touches.length||1;switch(i){case 1:{if(c.noRotate===true)return;var a=-THREE.Math.degToRad((t-d.x)*c.rotateSpeedX);var o=THREE.Math.degToRad((n-d.y)*c.rotateSpeedY);if(u){c.rotate(a,o,0);d.set(t,n);c.update();c.dispatchEvent(m)}}break;case 2:{var r=e.touches[0].pageX-e.touches[1].pageX,s=e.touches[0].pageY-e.touches[1].pageY,l=Math.sqrt(r*r+s*s);_(-d.pinchDistance+l);c.update();c.dispatchEvent(m)}break}e.preventDefault()}function R(e){u=false;c.dispatchEvent(v)}function M(e){if(c.enabled===false||c.noZoom===true)return;e.preventDefault();e.stopPropagation();var t=0;if(e.wheelDelta!==undefined)t=e.wheelDelta;else if(e.detail!==undefined)t=-e.detail;_(t);c.update()}function P(e){switch(e.keyCode){case c.keys.UP:g=false;break;case c.keys.BOTTOM:w=false;break;case c.keys.LEFT:E=false;break;case c.keys.RIGHT:y=false;break}}function H(e){if(c.enabled===false||c.noKeys===true)return;switch(e.keyCode){case c.keys.UP:g=true;break;case c.keys.BOTTOM:w=true;break;case c.keys.LEFT:E=true;break;case c.keys.RIGHT:y=true;break}if(g||w||E||y){c.tweenAnimation&&c.tweenAnimation.stop();if(g)c.rotate(0,c.keySpeed,0);if(w)c.rotate(0,-c.keySpeed,0);if(E)c.rotate(c.keySpeed,0,0);if(y)c.rotate(-c.keySpeed,0,0)}}};(v.prototype=Object.create(THREE.EventDispatcher.prototype)).constructor=v;var g=function(e,t,n){p.call(this,e,t,n);this.image=e.image;this.size=1e4;this.ratio=.5;this.texture=null;this.geometry=new THREE.PlaneGeometry(this.size,this.size*this.ratio);this.material=new THREE.ShaderMaterial({uniforms:{tex:{value:new THREE.Texture},resolution:{value:1},transform:{value:new THREE.Matrix4},zoom:{value:this.size}},vertexShader:["varying vec2 vUv;","void main() {","vUv = uv;","gl_Position = vec4( position, 1.0 );","}"].join("\n"),fragmentShader:["varying vec2 vUv;","const float PI = 3.141592653589793;","uniform sampler2D tex;","uniform float resolution;","uniform mat4 transform;","uniform float zoom;","void main() {","vec2 uv = vUv;","uv.y = 1.0 - uv.y;","vec2 position = -1.0 +  2.0 * uv;","position *= vec2(zoom * resolution, zoom * 0.5);","float x2y2 = position.x * position.x + position.y * position.y;","vec3 sphere_pnt = vec3(2.0 * position, x2y2 - 1.0) / (x2y2 + 1.0);","sphere_pnt = vec3(transform * vec4(sphere_pnt, 1.0));","vec2 sampleUV = vec2(","(atan(sphere_pnt.y, sphere_pnt.x) / PI + 1.0) * 0.5,","(asin(sphere_pnt.z) / PI + 0.5)",");","gl_FragColor = texture2D(tex, sampleUV);","}"].join("\n"),side:THREE.DoubleSide});this.material.uniforms.resolution.value=this.viewer.$canvas.get(0).clientWidth/this.viewer.$canvas.get(0).clientHeight;this.mesh=new THREE.Mesh(this.geometry,this.material);this.scene=new THREE.Scene;this.scene.add(this.mesh);this.control=new v(this.viewer.$canvas.get(0),this.material,this);this.autoRotateControl=new u(this,e.autoRotate)};(g.prototype=Object.create(p.prototype)).constructor=g,Object.assign(g.prototype,{update:function(){this.control.update();p.prototype.update.call(this)},load:function(e){p.prototype.load.call(this);this.image=e||this.image;if(!e){console.warn("IPANORAMA.SceneLittlePlanet: image source undefined");this.onError;return}else if(typeof e==="string"){this.smartRequest&&this.smartRequest.abort();Y.TextureLoader.load(e,this.onLoad.bind(this),this.onProgress.bind(this),this.onError.bind(this),this.smartRequest)}else if(e instanceof HTMLImageElement)this.onLoad(new THREE.Texture(e))},onLoad:function(e){this.texture&&this.texture.dispose();this.texture=e;this.texture.minFilter=this.texture.magFilter=THREE.LinearFilter;this.texture.needsUpdate=true;this.material.uniforms.tex.value=this.texture;window.requestAnimationFrame(function(){window.requestAnimationFrame(function(){p.prototype.onLoad.call(this)}.bind(this))}.bind(this))},onShowStart:function(){this.bind();p.prototype.onShowStart.call(this)},onHideStart:function(){this.unbind();p.prototype.onHideStart.call(this)},onWindowResize:function(e,t){this.material.uniforms.resolution.value=e/t;p.prototype.onWindowResize.call(this,e,t)},get:function(e){if(e)this.load(this.image);return p.prototype.get.call(this)},destroy:function(){this.control.destroy();this.scene.remove(this.mesh);this.geometry&&this.geometry.dispose();this.material&&this.material.dispose();this.texture&&this.texture.dispose();this.mesh=undefined;p.prototype.destroy.call(this)},bind:function(){this.control.bind();this.autoRotateControl.bind()},unbind:function(){this.control.unbind();this.autoRotateControl.unbind()}});var w=function(e,t,n){this.canvas=e;this.camera=t;this.scene=n;this.scene.control=this;this.imageSize={width:0,height:0};this.enabled=true;this.momentumThreshold=2;this.momentumDampingFactor=.5;this.noZoom=false;this.noRotate=false;this.autoRotate=false;this.autoRotateSpeedX=.5;this.noKeys=false;this.keyPanSpeed=7;this.keys={LEFT:37,UP:38,RIGHT:39,BOTTOM:40};var h=this;var i=ie(e);var s=new THREE.Vector2;var l=new THREE.Vector2;var c=new THREE.Vector2;var f=new Y.Matrix;var a={yaw:0,pitch:0};var o=null;var r=1e-4;var u=false;var d=Date.now();var m=0;var p=0;var v=0;var g=0;var w=0;var E=0;var y=0;var b=null;var _,T,x,R;var M={NONE:-1,PAN:2,TOUCH_PAN:3,ZOOM:4,TOUCH_ZOOM:5};var P=M.NONE;var H={type:"change"};var S={type:"start"};var A={type:"end"};this.rotateLeft=function(e){if(e)this.setDeltaPosition(e,0)};this.rotateUp=function(e){if(e)this.setDeltaPosition(0,-e)};this.update=function(){if(h.autoRotate&&P===M.NONE)h.setDeltaPosition(h.autoRotateSpeedX,0);L()};this.bind=function(){i.on("mousedown",k);i.on("touchstart",B);i.on("touchmove",z);i.on("touchend",j);i.on("mousewheel",I);i.on("DOMMouseScroll",I);i.on("keydown",D);i.on("keyup",F)};this.unbind=function(){i.off("mousedown",k);i.off("touchstart",B);i.off("touchmove",z);i.off("touchend",j);i.off("mousewheel",I);i.off("DOMMouseScroll",I);ie(document).off("mousemove",$);ie(document).off("mouseup",O)};this.setYawPitch=function(e,t){h.tweenAnimation&&h.tweenAnimation.stop();a.yaw=-e;a.pitch=-t;h.setPosition(-e,-t)};this.getYawPitch=function(){var e=h.getPosition();return{yaw:e.x==0?0:-e.x,pitch:e.y==0?0:-e.y}};this.lookAt=function(e,t,n){var i=new ie.Deferred;if(e.hasOwnProperty("yaw")&&e.hasOwnProperty("pitch"))e={x:-e.yaw,y:-e.pitch};if(t){n=n||le.Easing.Exponential.Out;var a=h.getPosition();var o=e;var r=h.getZoom();o.x=o.x*r;o.y=o.y*r;h.tweenAnimation&&h.tweenAnimation.stop();h.tweenAnimation=new le.Tween(a).to(o,t).easing(n).onStart(function(){}).onUpdate(function(e){h.setPosition(a.x,a.y)}).onComplete(function(){i.resolve();h.tweenAnimation.stop()}).onStop(function(){i.reject()}).start()}else{h.setPosition(e.x,e.y);i.resolve()}return i.promise()};this.getLookAt=function(){var e=h.getZoom();var t=h.getYawPitch();t.yaw=t.yaw/e;t.pitch=t.pitch/e;return t};this.getPosition=function(){return{x:f.m[4],y:f.m[5]}};this.setPosition=function(e,t){f.m[4]=e;f.m[5]=t;C()};this.setDeltaPosition=function(e,t){var n=f.inverse().transformPoint(e,t),i=f.inverse().transformPoint(0,0),a=n[0]-i[0],o=n[1]-i[1];f.translate(a,o);C()};this.getMinZoom=function(){var e=h.canvas.clientWidth/h.imageSize.width,t=h.canvas.clientHeight/h.imageSize.height;return e<t?t:e};this.getZoom=function(){return f.m[0]};this.setZoom=function(e){if(e)o=e;e=e||1e-6;var t=h.getPosition();f.reset().translate(t.x,t.y).scale(e,e);C()};this.setDeltaZoom=function(e,t){var t=t||{x:f.m[4],y:f.m[5]},n=f.inverse().transformPoint(t.x,t.y),i=n[0],a=n[1];f.translate(i,a).scale(e,e).translate(-i,-a);C()};this.getFocalPoint=function(e,t){var n=h.canvas.getBoundingClientRect(),i=new THREE.Vector2;i.x=e-n.left-n.width/2;i.y=-(t-n.top-n.height/2);return i};this.resize=function(){h.setZoom(h.getZoom())};this.reinit=function(){h.setZoom(o);(a.yaw||a.pitch)&&h.setPosition(a.yaw,a.pitch)};this.save=function(){o=f.m[0];a.yaw=f.m[4];a.pitch=f.m[5]};var C=function(){var e=h.getPosition(),t=h.getZoom(),n=h.canvas.clientWidth,i=h.canvas.clientHeight,a=h.imageSize.width,o=h.imageSize.height,r=a*t,s=o*t;if(r<n||s<i){var l=n/a,c=i/o;if(l<c)t=c;else t=l;f.reset().translate(e.x,e.y).scale(t,t);r=a*t;s=o*t}var u=r,d=(s-i)/2;if(e.x<-u||e.x>u)e.x=0;if(e.y<-d)e.y=-d;else if(e.y>d)e.y=d;e.x=isNaN(e.x)?0:e.x,e.y=isNaN(e.y)?0:e.y,f.m[4]=e.x;f.m[5]=e.y;h.camera.zoom=t;h.camera.position.set(-e.x/t,-e.y/t,1e-9);h.camera.updateProjectionMatrix();h.dispatchEvent(H);h.scene&&h.scene.viewer.$listener.trigger("ipanorama:scene-camera-change",{scene:h.scene})};var L=function(){if(!u)return;if(Math.abs(m)<r&&Math.abs(p)<r){u=false;n.afterRender=true;return}var e=Date.now()-d;d=Date.now();v*=h.momentumDampingFactor;g*=h.momentumDampingFactor;m=v*e;p=g*e;c.x+=m;c.y+=p;h.setDeltaPosition(c.x,-c.y)};var k=function(e){if(h.enabled===false)return;h.tweenAnimation&&h.tweenAnimation.stop();u=false;m=p=0;d=Date.now();P=M.PAN;s.set(e.clientX,e.clientY);h.dispatchEvent(S);h.scene&&h.scene.viewer.$listener.trigger("ipanorama:scene-camera-start",{scene:h.scene});ie(document).on("mousemove",$);ie(document).on("mouseup",O)};var $=function(e){if(h.enabled===false||h.noRotate===true)return;e.preventDefault();if(b){m=e.clientX-b.clientX;p=e.clientY-b.clientY;var t=Date.now()-d;v=m/t;g=p/t;d=Date.now()}b=e;l.set(e.clientX,e.clientY);c.subVectors(l,s);h.setDeltaPosition(c.x,-c.y);s.copy(l)};var O=function(e){if(h.enabled===false)return;if(Math.abs(m)<h.momentumThreshold&&Math.abs(p)<h.momentumThreshold)u=false;else u=true;b=null;ie(document).off("mousemove",$);ie(document).off("mouseup",O);h.dispatchEvent(A);h.scene&&h.scene.viewer.$listener.trigger("ipanorama:scene-camera-end",{scene:h.scene});P=M.NONE;n.afterRender=true};var I=function(e){if(h.enabled===false||h.noZoom===true||P!==M.NONE)return;e.preventDefault();e.stopPropagation();var t=0,n=1,i=h.getMinZoom(),a=h.getFocalPoint(e.clientX,e.clientY);if(e.originalEvent.wheelDelta!==undefined)t=e.originalEvent.wheelDelta;else if(e.originalEvent.detail!==undefined)t=-e.originalEvent.detail;t=Math.max(-1,Math.min(1,t));n=1+t*.05;if(h.getZoom()*n<i)n=i/h.getZoom();h.setDeltaZoom(n,a);clearTimeout(h.updateTimerId);h.updateTimerId=setTimeout(function(){C()},1)};var D=function(e){if(h.enabled===false||h.noKeys===true)return;switch(e.keyCode){case h.keys.UP:_=true;break;case h.keys.BOTTOM:T=true;break;case h.keys.LEFT:x=true;break;case h.keys.RIGHT:R=true;break}if(_||T||x||R){h.tweenAnimation&&h.tweenAnimation.stop();if(_)h.setDeltaPosition(0,-h.keyPanSpeed);if(T)h.setDeltaPosition(0,h.keyPanSpeed);if(x)h.setDeltaPosition(h.keyPanSpeed,0);if(R)h.setDeltaPosition(-h.keyPanSpeed,0)}};var F=function(e){switch(e.keyCode){case h.keys.UP:_=false;break;case h.keys.BOTTOM:T=false;break;case h.keys.LEFT:x=false;break;case h.keys.RIGHT:R=false;break}};var B=function(e){u=false;m=p=0;d=Date.now();h.tweenAnimation&&h.tweenAnimation.stop();if(h.enabled===false)return;switch(e.touches.length){case 1:{if(h.noRotate===true)return;P=M.TOUCH_PAN;s.set(e.touches[0].pageX,e.touches[0].pageY)}break;case 2:{if(h.noZoom===true)return;P=M.TOUCH_ZOOM;var t=e.touches[0].pageX-e.touches[1].pageX;var n=e.touches[0].pageY-e.touches[1].pageY;var i=Math.sqrt(t*t+n*n);w=i;y=h.getZoom()}break;default:P=M.NONE}if(P!==M.NONE){h.dispatchEvent(S);h.scene&&h.scene.viewer.$listener.trigger("ipanorama:scene-camera-start",{scene:h.scene})}};var z=function(e){if(h.enabled===false)return;e.preventDefault();e.stopPropagation();switch(e.touches.length){case 1:{if(h.noRotate===true)return;if(P!==M.TOUCH_PAN)return;if(b){m=e.touches[0].pageX-b.pageX;p=e.touches[0].pageY-b.pageY;var t=Date.now()-d;v=m/t;g=p/t;d=Date.now()}b={pageX:e.touches[0].pageX,pageY:e.touches[0].pageY};l.set(e.touches[0].pageX,e.touches[0].pageY);c.subVectors(l,s);h.setDeltaPosition(c.x,-c.y);s.copy(l)}break;case 2:{if(h.noZoom===true)return;if(P!==M.TOUCH_ZOOM)return;var n=e.touches[0].pageX-e.touches[1].pageX;var i=e.touches[0].pageY-e.touches[1].pageY;var a=Math.sqrt(n*n+i*i);E=a;var o=(E-w)/w;var r=Math.max(h.getMinZoom(),y+o);h.setZoom(r);h.setDeltaPosition(0,0)}break}};var j=function(e){if(h.enabled===false)return;if(Math.abs(m)<h.momentumThreshold&&Math.abs(p)<h.momentumThreshold)u=false;else u=true;b=undefined;h.dispatchEvent(A);h.scene&&h.scene.viewer.$listener.trigger("ipanorama:scene-camera-end",{scene:h.scene});P=M.NONE};this.update()};(w.prototype=Object.create(THREE.EventDispatcher.prototype)).constructor=w;var E=function(s,e){this.cfg=e;this.enabled=e.enabled;this.defaultPoint={image:e.image,width:e.width,height:e.height,opacity:e.opacity};this.transformControl=new f(s.viewer.$canvas.get(0),s.camera);s.scene.add(this.transformControl);var r=this;var n={ESCAPE:27,LEFT:37,UP:38,RIGHT:39,DOWN:40,DELETE:46};var l=new THREE.Raycaster;var i=this.transformControl;this.bind=function(){s.viewer.$canvas.on("keydown",t);s.viewer.$canvas.on("keyup",a);s.viewer.$canvas.on("click",o);s.viewer.$canvas.on("dblclick",c);i.addEventListener("dragging-changed",u)};this.unbind=function(){s.viewer.$canvas.off("keydown",t);s.viewer.$canvas.off("keyup",a);s.viewer.$canvas.off("click",o);s.viewer.$canvas.off("dblclick",c);i.removeEventListener("dragging-changed",u)};this.detach=function(){i.detach()};this.attach=function(e){e&&i.attach(e.mesh)};this.getSceneIntersectPoint=function(e,t){var n=s.viewer.$canvas.get(0).getBoundingClientRect(),i=new THREE.Vector2;i.x=(e-n.left)/n.width*2-1;i.y=-((t-n.top)/n.height)*2+1;l.setFromCamera(i,s.camera);var a=l.intersectObjects([s.mesh],false);if(a.length){var o=a[0].point,r=new THREE.Vector3;if(o.x<-s.imageSize.width/2)o.x+=s.imageSize.width;else if(o.x>s.imageSize.width/2)o.x-=s.imageSize.width;o.z=0;s.mesh.getWorldPosition(r);return new THREE.Vector3(parseFloat((o.x-r.x).toFixed(2)),parseFloat((o.y-r.y).toFixed(2)),parseFloat((o.z-r.z).toFixed(2)))}return null};this.addPointToCenter=function(e){var t={x:0,y:0,z:0},n=s.viewer.$canvas.get(0).getBoundingClientRect(),i=n.left+n.width/2,a=n.top+n.height/2,o=r.getSceneIntersectPoint(i,a);if(o){t.x=o.x;t.y=o.y}return s.addPoint(r.createPoint(t),e)};this.createPoint=function(e){var t=new h({pos:e,image:r.defaultPoint.image,width:r.defaultPoint.width,height:r.defaultPoint.height,opacity:r.defaultPoint.opacity});return t};var t=function(e){if(r.enabled===false)return};var a=function(e){if(r.enabled===false||!i.object)return;switch(e.keyCode){case n.DELETE:if(i.object.userData.type=="point"){var t=s.findPointByMesh(i.object);i.detach();s.removePoint(t)}break;case n.ESCAPE:i.detach();break}};var o=function(e){if(r.enabled===false)return;var t=r.getSceneIntersectPoint(e.clientX,e.clientY);l.set(t,new THREE.Vector3(0,0,1));var n=l.intersectObjects(s.scene.children);if(n.length>1)if(n[1].object.userData.type==="point"){i.attach(n[1].object);s.selectPoint(i.object.userData.point);return}i.object&&s.deselectPoint(i.object.userData.point);i.detach()};var c=function(e){if(r.enabled===false)return;var t=r.getSceneIntersectPoint(e.clientX,e.clientY);s.addPoint(r.createPoint(t))};var u=function(e){if(e.value)s.dragstartPoint(e.target.object.userData.point);else s.dragendPoint(e.target.object.userData.point);s.control.enabled=!e.value;s.updatePointPos()}},y=function(a){var o=this;var r=new THREE.Frustum;var s=null;this.bind=function(){a.control.addEventListener("change",e);a.control.addEventListener("start",t);a.control.addEventListener("end",i)};this.unbind=function(){a.control.removeEventListener("change",e);a.control.removeEventListener("start",t);a.control.removeEventListener("end",i)};this.update=function(){r.setFromProjectionMatrix((new THREE.Matrix4).multiplyMatrices(a.camera.projectionMatrix,a.camera.matrixWorldInverse));var e=null;for(var t=0;t<a.points.length;t++){var n=[0,0,0];e=a.pointsLeft[t];n[0]=l(r,e,true);e=a.pointsRight[t];n[1]=l(r,e,true);e=a.points[t];n[2]=l(r,e,true);var i=n[0]+n[1]+n[2];if(i==1){e=n[0]==1?a.pointsLeft[t]:n[1]==1?a.pointsRight[t]:e;a.viewer.$listener.trigger("ipanorama:scene-point-show",{scene:a,point:e})}else if(i==2){e=n[0]==1?a.pointsLeft[t]:n[1]==1?a.pointsRight[t]:e;a.viewer.$listener.trigger("ipanorama:scene-point-hide",{scene:a,point:e})}}};this.show=function(){r.setFromProjectionMatrix((new THREE.Matrix4).multiplyMatrices(a.camera.projectionMatrix,a.camera.matrixWorldInverse));var e=null;for(var t=0;t<a.points.length;t++){var n=[0,0,0];e=a.pointsLeft[t];e.mesh.visible=true;n[0]=l(r,e,false);e=a.pointsRight[t];e.mesh.visible=true;n[1]=l(r,e,false);e=a.points[t];e.mesh.visible=true;n[2]=l(r,e,false);var i=n[0]+n[1]+n[2];if(i==1){e=n[0]==1?a.pointsLeft[t]:n[1]==1?a.pointsRight[t]:e;a.viewer.$listener.trigger("ipanorama:scene-point-show",{scene:a,point:e})}else if(i==2){e=n[0]==1?a.pointsLeft[t]:n[1]==1?a.pointsRight[t]:e;a.viewer.$listener.trigger("ipanorama:scene-point-hide",{scene:a,point:e})}}};this.hide=function(){for(var e=0;e<a.points.length;e++){var t=a.points[e];n(t);t=a.pointsLeft[e];n(t);t=a.pointsRight[e];n(t)}};this.getScreenCoord=function(e){e.project(a.camera);e.x=Math.round((.5+e.x/2)*a.viewer.$canvas.get(0).clientWidth);//!!!window.devicePixelRatio
e.y=Math.round((.5-e.y/2)*a.viewer.$canvas.get(0).clientHeight);//!!!window.devicePixelRatio
return{x:e.x,y:e.y}};var n=function(e){e.mesh.visible=false;if(e.visible){e.visible=false;a.viewer.$listener.trigger("ipanorama:scene-point-hide",{scene:a,point:e})}};var l=function(e,t,n){var i=0;if(e.containsPoint(t.mesh.position)){c(t);if(!t.visible){t.visible=true;i=1}n&&a.viewer.$listener.trigger("ipanorama:scene-point-change",{scene:a,point:t})}else if(t.visible){t.visible=false;i=2}return i};var c=function(i){i.mesh.quaternion.copy(a.camera.quaternion);var e=i.mesh.position.clone();i.screenPos=o.getScreenCoord(e);if(s!=a.camera.zoom){i.mesh.updateMatrixWorld();let e=new THREE.Vector3,t=new THREE.Vector3,n=new THREE.Vector3;e.fromBufferAttribute(i.mesh.geometry.attributes.position,0);t.fromBufferAttribute(i.mesh.geometry.attributes.position,1);n.fromBufferAttribute(i.mesh.geometry.attributes.position,2);e.applyMatrix4(i.mesh.matrixWorld);t.applyMatrix4(i.mesh.matrixWorld);n.applyMatrix4(i.mesh.matrixWorld);e=o.getScreenCoord(e);t=o.getScreenCoord(t);n=o.getScreenCoord(n);i.screenWidth=t.x-e.x;i.screenHeight=n.y-e.y;s=a.camera.zoom}};var e=function(){o.update()};var t=function(){};var i=function(){}},b=function(e,t,n){p.call(this,e,t,n);this.image=e.image;this.imageSize={width:0,height:0};this.texture=null;this.geometry=new THREE.PlaneBufferGeometry(1,1,3,1);this.material=new THREE.ShaderMaterial({uniforms:{tex:{value:null},imageSize:{value:new THREE.Vector2},imageOriginalSize:{value:new THREE.Vector2}},vertexShader:["varying vec2 vUv;","void main() {","vUv = uv;","gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );","}"].join("\n"),fragmentShader:["varying vec2 vUv;","uniform sampler2D tex;","uniform vec2 imageSize;","uniform vec2 imageOriginalSize;","void main() {","vec2 uv = vUv;","float ratio_x = imageOriginalSize.x / imageSize.x;","float ratio_y = imageOriginalSize.y / imageSize.y;","float blocks = 3.0;","if(uv.x >= (2.0/blocks)) {","uv = vec2((uv.x - 2.0/blocks) * ratio_x * blocks, 1.0 - (1.0 - uv.y) * ratio_y);","} else if(uv.x >= (1.0/blocks)) {","uv = vec2((uv.x - 1.0/blocks) * ratio_x * blocks, 1.0 - (1.0 - uv.y) * ratio_y);","} else if(uv.x >= (0.0/blocks)) {","uv = vec2((uv.x - 0.0/blocks) * ratio_x * blocks, 1.0 - (1.0 - uv.y) * ratio_y);","}","gl_FragColor = texture2D(tex, uv);","}"].join("\n"),side:THREE.DoubleSide,transparent:true});this.mesh=new THREE.Mesh(this.geometry,this.material);this.scene=new THREE.Scene;this.scene.add(this.mesh);var i=this.viewer.$canvas.get(0).clientWidth/2,a=this.viewer.$canvas.get(0).clientHeight/2;this.camera=new THREE.OrthographicCamera(-i,i,a,-a,-1e4,1e4);this.control=new w(this.viewer.$canvas.get(0),this.camera,this);this.autoRotateControl=new u(this,e.autoRotate);this.points=[];this.pointsLeft=[];this.pointsRight=[];this.pointEditor=new E(this,e.pointEditor);this.pointControl=new y(this)};(b.prototype=Object.create(p.prototype)).constructor=b,Object.assign(b.prototype,{update:function(){this.control.update();p.prototype.update.call(this)},load:function(e){p.prototype.load.call(this);this.image=e||this.image;if(!e){console.warn("IPANORAMA.SceneFlat: image source undefined");this.onError();return}else if(typeof e==="string"){this.smartRequest&&this.smartRequest.abort();Y.TextureLoader.load(e,this.onLoad.bind(this),this.onProgress.bind(this),this.onError.bind(this),this.smartRequest,true)}else if(e instanceof HTMLImageElement)this.onLoad(new THREE.Texture(e))},onLoad:function(e){this.texture&&this.texture.dispose();this.texture=e;this.texture.minFilter=this.texture.magFilter=THREE.LinearFilter;this.texture.wrapS=this.texture.wrapT=THREE.RepeatWrapping;this.texture.needsUpdate=true;this.material.uniforms.tex.value=this.texture;this.material.uniforms.imageSize.value.width=this.texture.image.width;this.material.uniforms.imageSize.value.height=this.texture.image.height;this.material.uniforms.imageOriginalSize.value.width=this.texture.imageOriginalSize.width;this.material.uniforms.imageOriginalSize.value.height=this.texture.imageOriginalSize.height;this.mesh.scale.set(this.texture.imageOriginalSize.width*3,this.texture.imageOriginalSize.height,1);this.control.imageSize.width=this.imageSize.width=this.texture.imageOriginalSize.width;this.control.imageSize.height=this.imageSize.height=this.texture.imageOriginalSize.height;this.control.reinit();this.updatePointPos();this.pointControl.show();window.requestAnimationFrame(function(){window.requestAnimationFrame(function(){p.prototype.onLoad.call(this)}.bind(this))}.bind(this))},onShowStart:function(){this.bind();this.pointControl.show();p.prototype.onShowStart.call(this)},onHideStart:function(){this.unbind();this.pointControl.hide();this.control.save();p.prototype.onHideStart.call(this)},onWindowResize:function(e,t){this.camera.left=-e/2;this.camera.right=e/2;this.camera.top=t/2;this.camera.bottom=-t/2;this.camera.updateProjectionMatrix();this.control.resize();p.prototype.onWindowResize.call(this,e,t)},get:function(e){if(e)this.load(this.image);return p.prototype.get.call(this)},destroy:function(){this.scene.remove(this.mesh);this.geometry&&this.geometry.dispose();this.material&&this.material.dispose();this.texture&&this.texture.dispose();this.mesh=undefined;p.prototype.destroy.call(this)},updatePointPos:function(){var e=null,t=null;for(var n=0;n<this.points.length;n++){e=this.points[n];if(e.hasOwnProperty("yaw")&&e.hasOwnProperty("pitch")){t={x:e.yaw,y:e.pitch,z:0};e.mesh.position.set(t.x,t.y,t.z)}t=e.mesh.position;e=this.pointsLeft[n];e.mesh.position.set(t.x-this.imageSize.width,t.y,t.z);e=this.pointsRight[n];e.mesh.position.set(t.x+this.imageSize.width,t.y,t.z)}},addPoint:function(e,t){if(!e)return null;var n=new IPANORAMA.Point(e.cfg),i=new IPANORAMA.Point(e.cfg);e.mesh.userData.type="point";n.mesh.userData.type="pointLeft";i.mesh.userData.type="pointRight";if(e.ext){n.ext=e.ext;i.ext=e.ext}n.load();this.pointsLeft.push(n);this.scene.add(n.mesh);i.load();this.pointsRight.push(i);this.scene.add(i.mesh);e.load();this.points.push(e);this.scene.add(e.mesh);!t&&this.viewer.$listener.trigger("ipanorama:scene-point-add",{scene:this,point:e});if(this.loaded){this.updatePointPos();this.pointControl.show()}return e},removePoint:function(e,t){if(!e)return;var n=null;for(var i=0;i<this.points.length;i++)if(Object.is(e,this.points[i]))n=i;if(n!=null){this.pointEditor&&this.pointEditor.detach();e=this.pointsLeft[n];this.scene.remove(e.mesh);e.destroy();e=this.pointsRight[n];this.scene.remove(e.mesh);e.destroy();e=this.points[n];this.scene.remove(e.mesh);e.destroy();this.pointsLeft.splice(n,1);this.pointsRight.splice(n,1);this.points.splice(n,1);!t&&this.viewer.$listener.trigger("ipanorama:scene-point-remove",{scene:this,point:e})}},removePoints:function(e){this.pointEditor&&this.pointEditor.detach();var t=null;for(var n=0;n<this.points.length;n++){t=this.pointsLeft[n];this.scene.remove(t.mesh);t.destroy();t=this.pointsRight[n];this.scene.remove(t.mesh);t.destroy();t=this.points[n];this.scene.remove(t.mesh);t.destroy();!e&&this.viewer.$listener.trigger("ipanorama:scene-point-remove",{scene:this,point:t})}this.pointsLeft=[];this.pointsRight=[];this.points=[]},bind:function(){this.control.bind();this.autoRotateControl.bind();this.pointEditor.bind();this.pointControl.bind()},unbind:function(){this.control.unbind();this.autoRotateControl.unbind();this.pointEditor.unbind();this.pointControl.unbind()}});var _={name:"default",effect:function(e,t){this.viewer=t;this.shader={uniforms:{texture1:{value:null},texture2:{value:null},progress:{value:0},time:{value:0},timeDelta:{value:0},resolution:{value:new THREE.Vector2}},vertexShader:["varying vec2 vUv;","void main() {","vUv = uv;","gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);","}"].join("\n"),fragmentShader:["varying vec2 vUv;","uniform sampler2D texture1;","uniform sampler2D texture2;","uniform float progress;","uniform float time;","uniform float timeDelta;","uniform vec2 resolution;","void main() {","vec2 uv = vUv;","vec4 texel1 = texture2D( texture1, uv );","vec4 texel2 = texture2D( texture2, uv );","gl_FragColor = mix(texel1, texel2, progress);","}"].join("\n"),side:THREE.DoubleSide};this.material=new THREE.ShaderMaterial(this.shader);this.init(e)}};_.effect.prototype={init:function(e){},getMaterial:function(){return this.material},destroy:function(){this.material.dispose()},onStart:function(e,t,n){},onUpdate:function(e,t,n){},onComplete:function(e,t){}};var T={name:"none",effect:function(e,t){this.viewer=t;this.shader={uniforms:{texture1:{value:null},texture2:{value:null},progress:{value:0},time:{value:0},timeDelta:{value:0},resolution:{value:new THREE.Vector2}},vertexShader:["varying vec2 vUv;","void main() {","vUv = uv;","gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);","}"].join("\n"),fragmentShader:["varying vec2 vUv;","uniform sampler2D texture1;","uniform sampler2D texture2;","uniform float progress;","uniform float time;","uniform float timeDelta;","uniform vec2 resolution;","void main() {","vec2 uv = vUv;","vec4 texel1 = texture2D( texture1, uv );","vec4 texel2 = texture2D( texture2, uv );","gl_FragColor = texel2;","}"].join("\n"),side:THREE.DoubleSide};this.material=new THREE.ShaderMaterial(this.shader);this.init(e)}};T.effect.prototype={init:function(e){},getMaterial:function(){return this.material},destroy:function(){this.material.dispose()},onStart:function(e,t,n){},onUpdate:function(e,t,n){},onComplete:function(e,t){}};var x={NORMAL:1,STEREO:2},R=function(e,t){console.log("IPANORAMA",a);THREE.Cache.enabled=true;this.cfg=e;this.smartRequest=t;this.$canvas=e.$canvas;this.$listener=e.$listener?e.$listener:e.$canvas;this.visible=this.$canvas.get(0).offsetParent==null?false:true;this.enabled=true;var n=this.$canvas.get(0).clientWidth,i=this.$canvas.get(0).clientHeight;this.updateCallbacks=[];this.requestAnimationId=null;this.mode=x.NORMAL;this.clock=new THREE.Clock;this.scene=new THREE.Scene;this.sceneDfd=null;this.sceneToLoad=null;this.sceneActive=null;this.sceneTransition=null;this.sceneTransitionDuration=1500;this.sceneTransitionEffect=null;this.camera=new THREE.OrthographicCamera(n/-2,n/2,i/2,i/-2,-10,10);this.quadGeometry=new THREE.PlaneBufferGeometry(1,1);this.quadMaterial=new THREE.MeshBasicMaterial({color:0,side:THREE.DoubleSide,opacity:.5});this.quad=new THREE.Mesh(this.quadGeometry,this.quadMaterial);this.quad.scale.set(n,i,1);this.scene.add(this.quad);this.renderer=new THREE.WebGLRenderer({canvas:this.$canvas.get(0),alpha:false,antialias:false,preserveDrawingBuffer:false});
//!!!this.renderer.setPixelRatio(window.devicePixelRatio);
this.renderer.setSize(n,i,false);this.renderer.setClearColor(0,1);this.renderer.sortObjects=false;this.initSceneTransition();this.setSceneTransitionEffect("default");this.animate()};R.prototype={initSceneTransition:function(){this.sceneTransition=new le.Tween(this).easing(le.Easing.Linear.None).onStart(this.onSceneShowStart.bind(this)).onUpdate(this.onSceneShowUpdate.bind(this)).onComplete(this.onSceneShowComplete.bind(this))},animate:function(){this.requestAnimationId=window.requestAnimationFrame(this.animate.bind(this));if(this.enabled)this.onChange()},update:function(){le.update(undefined,true);this.sceneActive&&this.sceneActive.update();this.sceneToLoad&&this.sceneToLoad.update();this.updateCallbacks.forEach(function(e){e()})},render:function(){var e=this.$canvas.get(0).offsetParent==null?false:true;if(!e){this.visible=e;return}else if(e!=this.visible){this.visible=e;window.dispatchEvent(new Event("resize"))}if(!this.sceneActive&&!this.sceneToLoad)return;this.sceneActive&&this.sceneActive.render(this.renderer,true);this.sceneToLoad&&this.sceneToLoad.render(this.renderer,true);switch(this.mode){case x.NORMAL:{this.renderer.setRenderTarget(null);this.renderer.clear();this.renderer.render(this.scene,this.camera)}break;case x.STEREO:{var t=new THREE.Vector2;this.renderer.getSize(t);this.renderer.setRenderTarget(null);this.renderer.clear();this.renderer.setScissorTest(true);this.renderer.setScissor(0,0,t.width/2,t.height);this.renderer.setViewport(0,0,t.width/2,t.height);this.renderer.render(this.scene,this.camera);this.renderer.setScissor(t.width/2,0,t.width/2,t.height);this.renderer.setViewport(t.width/2,0,t.width/2,t.height);this.renderer.render(this.scene,this.camera);this.renderer.setScissorTest(false)}break}},onChange:function(){this.update();this.render()},onWindowResize:function(e,t){this.renderer.setSize(e,t,false);this.quad.scale.set(e,t,1);this.camera.left=-e/2;this.camera.right=e/2;this.camera.top=t/2;this.camera.bottom=-t/2;this.camera.updateProjectionMatrix();if(this.quadMaterial.uniforms){this.quadMaterial.uniforms.resolution.value.x=e;this.quadMaterial.uniforms.resolution.value.y=t}},onSceneReadyToShow:function(e){this.sceneToLoad=e;this.sceneTransition.to({},this.sceneTransitionDuration).stop().start()},onSceneError:function(e){},onSceneShowStart:function(){var e=this.sceneActive,t=this.sceneToLoad;this.sceneActive=t;this.sceneToLoad=e;if(this.quadMaterial.uniforms){this.quadMaterial.uniforms.texture1.value=e?e.fbo.texture:null;this.quadMaterial.uniforms.texture2.value=t?t.fbo.texture:null}this.sceneTransitionEffect.onStart(e,t,this.sceneTransitionDuration);e&&e.onHideStart();t&&t.onShowStart()},onSceneShowUpdate:function(e){var t=this.sceneToLoad,n=this.sceneActive;if(this.quadMaterial.uniforms){this.quadMaterial.uniforms.progress.value=e;this.quadMaterial.uniforms.time.value=this.clock.getElapsedTime();this.quadMaterial.uniforms.timeDelta.value=this.clock.getDelta()}this.sceneTransitionEffect.onUpdate(t,n,e);t&&t.onHideUpdate(e);n&&n.onShowUpdate(e)},onSceneShowComplete:function(){var e=this.sceneToLoad,t=this.sceneActive;this.sceneToLoad=null;this.sceneTransition.stop();this.sceneTransitionEffect.onComplete(e,t);e&&e.onHideComplete();t&&t.onShowComplete()},setMode:function(e){switch(e){case"normal":e=x.NORMAL;break;case"stereo":e=x.STEREO;break;default:e=x.NORMAL;break}this.mode=e},setScene:function(e,t){t=t===undefined?true:t;this.sceneDfd&&this.sceneDfd.reject();this.sceneDfd=null;if(e){e.get(t).then(this.onSceneReadyToShow.bind(this,e)).fail(this.onSceneError.bind(this,e));this.sceneDfd=e.sceneDfd}else this.clearScene()},clearScene:function(){this.smartRequest&&this.smartRequest.abort();this.sceneActive&&this.sceneActive.onHideStart()&&this.sceneActive.onHideComplete();this.sceneActive=null;this.sceneToLoad=null;this.sceneDfd=null;this.renderer.setRenderTarget(null);this.renderer.clear(0,0);this.$listener.trigger("ipanorama:scene-clear")},setSceneTransitionDuration:function(e){this.sceneTransitionDuration=e===undefined?0:e},setSceneTransitionEffect:function(e,t){var n=null;if(e)for(var i in j.SceneTransitionEffect){if(!j.SceneTransitionEffect.hasOwnProperty(i))continue;var a=j.SceneTransitionEffect[i];if(a.name.toLowerCase()==e.toLowerCase()){n=a;break}}else n=T;if(n==null){console.warn("IPANORAMA.Viewer: can't find the scene transition effect \""+e+'"');return}var o=this.$canvas.get(0).clientWidth,r=this.$canvas.get(0).clientHeight;this.scene.remove(this.quad);this.sceneTransitionEffect&&this.sceneTransitionEffect.destroy();this.sceneTransitionEffect=new n.effect(t,this);this.quadMaterial&&this.quadMaterial.dispose();this.quadMaterial=this.sceneTransitionEffect.getMaterial();this.quad=undefined;this.quad=new THREE.Mesh(this.quadGeometry,this.quadMaterial);this.quad.scale.set(o,r,1);this.scene.add(this.quad)},addUpdateCallback:function(e){if(e)this.updateCallbacks.push(e)},removeUpdateCallback:function(e){var t=this.updateCallbacks.indexOf(e);if(e&&t>=0)this.updateCallbacks.splice(t,1)},destroy:function(){this.scene.remove(this.quad);this.sceneTransitionEffect&&this.sceneTransitionEffect.destroy();this.sceneTransitionEffect=null;this.quadGeometry&&this.quadGeometry.dispose();this.quadMaterial&&this.quadMaterial.dispose();this.quad=undefined;if(THREE.Cache&&THREE.Cache.enabled)THREE.Cache.clear();this.render();window.cancelAnimationFrame(this.requestAnimationId)}};var M=function(e){var t=["click","contextmenu","auxclick","dblclick","mousedown","mouseup","pointerup","touchend","keydown","keyup"];this.controls={};var a=this;var n=[];if(e&&Array.isArray(e.tracks))for(var i=0;i<e.tracks.length;i++)n.push({id:e.tracks[i].id?e.tracks[i].id:THREE.Math.generateUUID(),src:e.tracks[i].src});var o={track:null,mute:e&&typeof e.mute==="boolean"?e.mute:false,loop:e&&typeof e.loop==="boolean"?e.loop:false,html5:e&&typeof e.html5==="boolean"?e.html5:true,autoplay:e&&typeof e.autoplay==="boolean"?e.autoplay:true,volume:e&&typeof e.volume==="number"?e.volume:.5};var r=null;var s=false;var l=false;var c={clientX:0,clientY:0};var u=500;var d=o.volume;var h=false;var f=null;this.init=function(){m();p();n.length&&a.setTrack(n[0].id);_();T()};this.getWidget=function(){return a.controls.$widget};this.addTrack=function(e){var e={id:e.id?e.id:THREE.Math.generateUUID(),src:e.src};n.push(e);return e.id};this.setTrack=function(e){var t=a.getTrack(e);if(t)if(!(o.track&&o.track.id==t.id)){o.track=t;d=o.volume;r&&r.unload();r=new W.Howl({src:[o.track.src],onload:j,onplay:Y,onpause:V,onend:X,onstop:q,onseek:U,loaderror:Z,playerror:N,html5:o.html5,loop:o.loop,preload:"metadata",autoplay:false});return true}return false};this.getTrack=function(e){for(var t=0;t<n.length;t++)if(n[t].id==e)return n[t];return null};this.deleteTrack=function(e){for(var t=0;t<n.length;t++)if(n[t].id==e){n.slice(t,1);return true}return false};this.isPlaying=function(){if(!s&&r)return r.playing();return false};this.skip=function(e){if(o.track&&n.length){for(var t=0;t<n.length;t++)if(o.track.id==n[t].id)break;switch(e){case"prev":t=t-1<0?n.length-1:t-1;break;case"next":t=t+1<n.length?t+1:0;break}a.setTrack(n[t].id);a.play()}};this.play=function(){l=true;if(!s&&r&&!r.playing())r.play()};this.pause=function(){if(!s&&r&&r.playing())r.pause()};this.stop=function(){if(!s&&r)r.stop()};this.loop=function(e){if(arguments.length==0)return o.loop;o.loop=e;r&&r.loop(e);_()};this.volume=function(e){if(arguments.length==0)return o.volume;if(o.mute&&e>0)o.mute=false;o.volume=e;W.Howler.volume(e);_()};this.mute=function(e){if(arguments.length==0)return o.mute;o.mute=e;if(e){d=o.volume;a.volume(0)}else a.volume(d)};this.autoplay=function(e){if(arguments.length==0)return o.autoplay;o.autoplay=e};this.seek=function(e){r&&r.seek(r.duration()*e)};this.destroy=function(){r&&r.unload();r=null;v();this.controls={}};var m=function(){a.controls.$widget=ie("<div>").addClass("ipnrm-audio-player");a.controls.$container=ie("<div>").addClass("ipnrm-container");a.controls.$toolbar=ie("<div>").addClass("ipnrm-toolbar");a.controls.$btnPlay=ie("<div>").addClass("ipnrm-btn-play");a.controls.$btnPrev=ie("<div>").addClass("ipnrm-btn-prev");a.controls.$btnNext=ie("<div>").addClass("ipnrm-btn-next");a.controls.$btnLoop=ie("<div>").addClass("ipnrm-btn-loop");a.controls.$btnVolume=ie("<div>").addClass("ipnrm-btn-volume");a.controls.$volume=ie("<div>").addClass("ipnrm-volume");a.controls.$volumeBar=ie("<div>").addClass("ipnrm-volume-bar");a.controls.$volumeProgress=ie("<div>").addClass("ipnrm-volume-progress");a.controls.$meta=ie("<div>").addClass("ipnrm-meta");a.controls.$timeline=ie("<div>").addClass("ipnrm-timeline");a.controls.$timelineBar=ie("<div>").addClass("ipnrm-timeline-bar");a.controls.$timelineLoaded=ie("<div>").addClass("ipnrm-timeline-loaded");a.controls.$timelineProgress=ie("<div>").addClass("ipnrm-timeline-progress");a.controls.$toolbar.append(a.controls.$btnPlay,a.controls.$btnPrev,a.controls.$btnNext,a.controls.$btnLoop,a.controls.$btnVolume);a.controls.$timeline.append(a.controls.$timelineBar.append(a.controls.$timelineLoaded,a.controls.$timelineProgress));a.controls.$volume.append(a.controls.$volumeBar.append(a.controls.$volumeProgress));a.controls.$container.append(a.controls.$toolbar,a.controls.$meta,a.controls.$timeline,a.controls.$volume);a.controls.$widget.append(a.controls.$container)};var p=function(){a.controls.$btnPlay.on("click",x);a.controls.$btnPrev.on("click",R);a.controls.$btnNext.on("click",M);a.controls.$btnLoop.on("click",P);a.controls.$btnVolume.on("click",H);a.controls.$btnVolume.on("mouseenter",S);a.controls.$volumeBar.on("click",L);a.controls.$volumeBar.on("mousedown",k);a.controls.$timelineBar.on("mousedown",I);s=y();if(s)t.forEach(function(e){document.addEventListener(e,G)})};var v=function(){a.controls.$btnPlay.off("click",x);a.controls.$btnPrev.off("click",R);a.controls.$btnNext.off("click",M);a.controls.$btnLoop.off("click",P);a.controls.$btnVolume.off("click",H);a.controls.$btnVolume.off("mouseenter",S);a.controls.$volumeBar.off("click",L);a.controls.$volumeBar.off("mousedown",k);a.controls.$timelineBar.off("mousedown",I);window.removeEventListener("mousemove",A,true)};var g=function(e,t){var n=t.getBoundingClientRect(),i=1-(e.clientY-n.top)/n.height;i=i<0?0:i>1?1:i;return i};var w=function(e,t){var n=t.getBoundingClientRect(),i=(e.clientX-n.left)/n.width;i=i<0?0:i>1?1:i;return i};var E=function(e,t){var n=e.getBoundingClientRect();if(t.clientX<n.left||t.clientX>n.right||t.clientY<n.top||t.clientY>n.bottom)return false;return true};var y=function(){try{var e=new(window.AudioContext||window.webkitAudioContext);return e.state==="suspended"}catch(e){var t=new Audio;try{t.play();return false}catch(e){return true}}};var b=function(e){var t=Math.floor(e/60)||0,e=e-t*60||0;return t+":"+(e<10?"0":"")+e};var _=function(){a.controls.$btnPlay.toggleClass("ipnrm-play",!a.isPlaying());a.controls.$btnPlay.toggleClass("ipnrm-pause",a.isPlaying());a.controls.$btnLoop.toggleClass("ipnrm-on",o.loop);a.controls.$btnLoop.toggleClass("ipnrm-off",!o.loop);a.controls.$btnPrev.toggleClass("ipnrm-off",n.length<=1);a.controls.$btnNext.toggleClass("ipnrm-off",n.length<=1);a.controls.$btnVolume.toggleClass("ipnrm-mute",o.mute);a.controls.$btnVolume.toggleClass("ipnrm-off",!o.mute&&o.volume==0);a.controls.$btnVolume.toggleClass("ipnrm-min",!o.mute&&o.volume>0&&o.volume<.5);a.controls.$btnVolume.toggleClass("ipnrm-max",!o.mute&&o.volume>=.5);a.controls.$volume.toggleClass("ipnrm-mute",o.mute);a.controls.$volumeProgress.css({height:o.volume*100+"%"})};var T=function(){if(r&&r._html5){var e=r._sounds.length&&r._sounds[0]._node.buffered.length?r._sounds[0]._node.buffered.end(0):0;a.controls.$timelineLoaded.css({width:(e/r.duration()*100||0)+"%"})}try{var t=r.seek()||0;a.controls.$timelineProgress.css({width:(t/r.duration()*100||0)+"%"})}catch(e){a.controls.$timelineProgress.css({width:0+"%"})}};var x=function(e){a.isPlaying()?a.pause():a.play()};var R=function(e){a.skip("prev")};var M=function(e){a.skip("next")};var P=function(e){a.loop(!a.loop())};var H=function(e){a.mute(!a.mute())};var S=function(e){a.controls.$volume.addClass("ipnrm-active");window.addEventListener("mousemove",A,true);setTimeout(C,u)};var A=function(e){c.clientX=e.clientX;c.clientY=e.clientY};var C=function(){if(E(a.controls.$volume.get(0),c)||E(a.controls.$btnVolume.get(0),c))setTimeout(C,u);else{a.controls.$volume.removeClass("ipnrm-active");window.removeEventListener("mousemove",A,true)}};var L=function(e){var t=g(e,a.controls.$volumeBar.get(0));a.volume(t)};var k=function(e){e.preventDefault();window.addEventListener("mousemove",$);window.addEventListener("mouseup",O);var t=g(e,a.controls.$volumeBar.get(0));a.volume(t)};var $=function(e){var t=g(e,a.controls.$volumeBar.get(0));a.volume(t)};var O=function(e){window.removeEventListener("mousemove",$);window.removeEventListener("mouseup",O);var t=g(e,a.controls.$volumeBar.get(0));a.volume(t)};var I=function(e){if(s||!r)return;e.preventDefault();window.addEventListener("mousemove",D);window.addEventListener("mouseup",F);cancelAnimationFrame(f);h=a.isPlaying();h&&r.pause();var t=w(e,a.controls.$timelineBar.get(0));setTimeout(function(){a.controls.$timelineProgress.css({width:t*100+"%"})},100)};var D=function(e){var t=w(e,a.controls.$timelineBar.get(0));a.controls.$timelineProgress.css({width:t*100+"%"})};var F=function(e){window.removeEventListener("mousemove",D);window.removeEventListener("mouseup",F);var t=w(e,a.controls.$timelineBar.get(0));if(r._html5){var n=r._sounds.length&&r._sounds[0]._node.buffered.length?r._sounds[0]._node.buffered.end(0):0,i=n/r.duration();t=t<i?t:i}a.controls.$timelineProgress.css({width:t*100+"%"});a.seek(t);h&&a.play()};var B=function(e){T();if(r.playing())f=requestAnimationFrame(B)};var z=function(){T()};var j=function(){var e=o.mute;a.volume(o.volume);a.mute(e);a.loop(o.loop);o.autoplay&&a.play();if(r._html5)r._sounds.length&&r._sounds[0]._node.addEventListener("progress",z)};var Y=function(){_();f=requestAnimationFrame(B)};var V=function(){_()};var X=function(){if(!o.loop)o.autoplay?a.skip("next"):a.stop()};var q=function(){_()};var U=function(){f=requestAnimationFrame(B)};var Z=function(){_()};var N=function(){_()};var G=function(){s=false;l&&a.play();t.forEach(function(e){document.removeEventListener(e,G)})};a.init()},V={name:"default",defaultConfig:{titleControl:true,audioControl:true,prevSceneControl:true,nextSceneControl:true,fullscreenControl:true,thumbnailControl:false,viewerModeControl:false,moveToNextScene:true},widget:function(i,a){a=j.Utils.extend(V.defaultConfig,a);this.audioPlayer=new j.AudioPlayer(i.config.audio);var o=this;var n=i.$container;var r=ie("<div>").addClass("ipnrm-placeholder").css({display:"none"});var s={};var l=null;var c=null;var u=null;var d=[];var h=null;var e=null;var f=false;var m=null;this.init=function(){t();v()};this.setAudio=function(e){s.$audioPlayer.toggleClass("ipnrm-active",i.config.audio.tracks.length>0&&i.config.audio.enabled);if(!i.config.audio.enabled)return;for(var t=0;t<i.config.audio.tracks.length;t++){var n=i.config.audio.tracks[t];if(n.sceneId==e.cfg.id){o.audioPlayer.setTrack(n.id);n.autoplay&&o.audioPlayer.play();o.audioPlayer.loop(n.loop);break}}};this.destroy=function(){g();s.$widget.remove();s={};n.removeClass("ipnrm-widget-default");o.audioPlayer.destroy()};var t=function(){n.addClass("ipnrm-widget-default");s.$widget=ie("<div>").addClass("ipnrm-widget");s.$firstLoad=ie("<div>").addClass("ipnrm-first-load");s.$ts=ie("<div>").addClass("ipnrm-ts");s.$bs=ie("<div>").addClass("ipnrm-bs");s.$tlBar=ie("<div>").addClass("ipnrm-tl-bar");s.$trBar=ie("<div>").addClass("ipnrm-tr-bar");s.$brBar=ie("<div>").addClass("ipnrm-br-bar");s.$blBar=ie("<div>").addClass("ipnrm-bl-bar");s.$progress=ie("<div>").addClass("ipnrm-progress");s.$progressBar=ie("<div>").addClass("ipnrm-progress-bar").appendTo(s.$progress);s.$audioPlayer=o.audioPlayer.getWidget();s.$prevScene=ie("<div>").addClass("ipnrm-btn ipnrm-prev-scene");s.$nextScene=ie("<div>").addClass("ipnrm-btn ipnrm-next-scene");s.$stereoMode=ie("<div>").addClass("ipnrm-btn ipnrm-stereo-mode");s.$thumbs=ie("<div>").addClass("ipnrm-btn ipnrm-thumbs");s.$fullscreen=ie("<div>").addClass("ipnrm-btn ipnrm-fullscreen");s.$title=ie("<div>").addClass("ipnrm-title");s.$ts.append(s.$tlBar,s.$trBar);s.$bs.append(s.$blBar,s.$brBar);s.$tlBar.append(s.$audioPlayer);s.$trBar.append(s.$prevScene,s.$nextScene);s.$brBar.append(s.$stereoMode,s.$thumbs,s.$fullscreen);s.$blBar.append(s.$title);s.$thumbsWrap=ie("<div>").addClass("ipnrm-thumbs-wrap");s.$thumbsList=ie("<div>").addClass("ipnrm-thumbs-list");s.$thumbsClose=ie("<div>").addClass("ipnrm-thumbs-close");s.$thumbsWrap.append(s.$thumbsList,s.$thumbsClose);s.$widget.append(s.$progress,s.$firstLoad,s.$ts,s.$bs,s.$thumbsWrap);n.append(s.$widget);E();n.on("ipanorama:config",H).trigger("ipanorama:config")};var p=function(e){for(var t=0;t<e.scenes.length;t++){var n=e.scenes[t];if(n.imageThumb){var i=ie("<div>").addClass("ipnrm-thumb").attr({"data-scene-id":n.id}),a=ie("<img>").attr({src:n.imageThumb});s.$thumbsList.append(i.append(a))}}};var v=function(){n.on("ipanorama:ready",B);n.on("fullscreenchange mozfullscreenchange webkitfullscreenchange msfullscreenchange",z);n.on("ipanorama:scene-before-load",C);n.on("ipanorama:scene-after-load",L);n.on("ipanorama:scene-progress",A);n.on("ipanorama:scene-error",k);n.on("ipanorama:scene-hide-start",$);n.on("ipanorama:scene-hide-complete",O);n.on("ipanorama:scene-show-start",I);n.on("ipanorama:scene-show-complete",D);n.on("ipanorama:scene-index",F);n.on("ipanorama:mode",S);s.$prevScene.on("click",y);s.$nextScene.on("click",b);s.$stereoMode.on("click",_);s.$fullscreen.on("click",M);s.$thumbs.on("click",T);s.$thumbsList.on("click",".ipnrm-thumb",x);s.$thumbsClose.on("click",R);s.$firstLoad.on("click",P)};var g=function(){n.off("ipanorama:ready",B);n.off("fullscreenchange mozfullscreenchange webkitfullscreenchange msfullscreenchange",z);n.off("ipanorama:scene-before-load",C);n.off("ipanorama:scene-after-load",L);n.off("ipanorama:scene-progress",A);n.off("ipanorama:scene-error",k);n.off("ipanorama:scene-hide-start",$);n.off("ipanorama:scene-hide-complete",O);n.off("ipanorama:scene-show-start",I);n.off("ipanorama:scene-show-complete",D);n.off("ipanorama:scene-index",F);n.off("ipanorama:mode",S);s.$prevScene.off("click",y);s.$nextScene.off("click",b);s.$stereoMode.off("click",_);s.$fullscreen.off("click",M);s.$thumbs.off("click",T);s.$thumbsList.off("click",".ipnrm-thumb",x);s.$thumbsClose.off("click",R);s.$firstLoad.on("click",P)};var w=function(){s.$firstLoad.addClass("ipnrm-hide");a.titleControl&&s.$title.removeClass("ipnrm-hide");a.audioControl&&s.$audioPlayer.removeClass("ipnrm-hide");a.prevSceneControl&&s.$prevScene.removeClass("ipnrm-hide");a.nextSceneControl&&s.$nextScene.removeClass("ipnrm-hide");a.fullscreenControl&&s.$fullscreen.removeClass("ipnrm-hide");a.thumbnailControl&&s.$thumbs.removeClass("ipnrm-hide");a.viewerModeControl&&s.$stereoMode.removeClass("ipnrm-hide");s.$thumbsWrap.removeClass("ipnrm-hide")};var E=function(){s.$firstLoad.addClass("ipnrm-hide");s.$title.addClass("ipnrm-hide");s.$audioPlayer.addClass("ipnrm-hide");s.$prevScene.addClass("ipnrm-hide");s.$nextScene.addClass("ipnrm-hide");s.$fullscreen.addClass("ipnrm-hide");s.$thumbs.addClass("ipnrm-hide");s.$stereoMode.addClass("ipnrm-hide");s.$thumbsWrap.addClass("ipnrm-hide")};var y=function(e){h=h-1;if(h<0)h=null;else n.trigger("ipanorama:set-scene",{id:d[h]})};var b=function(e){h=h+1;if(h>=d.length){h=d.length-1;n.trigger("ipanorama:next-scene")}else n.trigger("ipanorama:set-scene",{id:d[h]})};var _=function(e){var t=l;switch(t){case"normal":t="stereo";break;case"stereo":t="normal";break}n.trigger("ipanorama:mode",{mode:t})};var T=function(e){var t=s.$thumbsList.find(".ipnrm-thumb.ipnrm-active");t.removeClass("ipnrm-active");t=s.$thumbsList.find('[data-scene-id="'+c+'"]');t.addClass("ipnrm-active");s.$thumbsWrap.addClass("ipnrm-active")};var x=function(e){n.trigger("ipanorama:set-scene",{id:ie(this).data("scene-id")});s.$thumbsWrap.removeClass("ipnrm-active")};var R=function(e){s.$thumbsWrap.removeClass("ipnrm-active")};var M=function(e){if(document.fullscreenEnabled||document.webkitFullscreenEnabled)if(s.$fullscreen.hasClass("ipnrm-active"))try{if(document.exitFullscreen)document.exitFullscreen();else if(document.mozCancelFullScreen)document.mozCancelFullScreen();else if(document.webkitExitFullscreen)document.webkitExitFullscreen();else if(document.msExitFullscreen)document.msExitFullscreen()}catch(e){}else try{var t=n.get(0);if(t.requestFullscreen)t.requestFullscreen();else if(t.mozRequestFullScreen)t.mozRequestFullScreen();else if(t.webkitRequestFullscreen)t.webkitRequestFullscreen();else if(t.msRequestFullscreen)t.msRequestFullscreen()}catch(e){}else{n.toggleClass("ipnrm-fullscreen-mode");if(n.hasClass("ipnrm-fullscreen-mode")){s.$fullscreen.addClass("ipnrm-active");r.insertBefore(n);n.detach();ie("body").append(n)}else{s.$fullscreen.removeClass("ipnrm-active");n.detach();n.insertAfter(r);r.remove()}m._onWindowResize()}};var P=function(e){if(u){s.$firstLoad.addClass("ipnrm-hide");n.trigger("ipanorama:set-scene",{id:u})}};var H=function(e,t){if(!t||!t.config)return;n.off("ipanorama:config",H);if(!t.config.autoLoad&&t.config.scenes.length>0){s.$firstLoad.removeClass("ipnrm-hide");u=t.config.scenes[0].id}p(t.config)};var S=function(e,t){if(!t||!t.master)return;l=t.mode;switch(l){case"normal":s.$stereoMode.removeClass("ipnrm-active");break;case"stereo":s.$stereoMode.addClass("ipnrm-active");break}};var A=function(e,t){if(t.progress.loaded<t.progress.total){if(!f){s.$progress.addClass("ipnrm-active");f=true}s.$progressBar.css({width:t.progress.loaded/t.progress.total*100+"%"})}else{if(f){s.$progress.removeClass("ipnrm-active");f=false}s.$progressBar.css({width:0})}};var C=function(e,t){};var L=function(e,t){s.$progress.removeClass("ipnrm-active");f=false;w()};var k=function(e,t){s.$progress.removeClass("ipnrm-active");f=false;E()};var $=function(e,t){};var O=function(e,t){};var I=function(e,t){o.setAudio(t.scene);if(t.scene.cfg.title){s.$title.get(0).innerHTML=t.scene.cfg.title;s.$title.addClass("ipnrm-active")}else{s.$title.get(0).innerHTML=null;s.$title.removeClass("ipnrm-active")}};var D=function(e,t){};var F=function(e,t){if(!t)return;c=t.scene.cfg.id;if(h==null){d.push(c);h=0}else if(d[h]!=c){h=h+1;d=d.slice(0,h);d.push(c)}if(h>0)s.$prevScene.addClass("ipnrm-active");else s.$prevScene.removeClass("ipnrm-active");if(h<d.length-1)s.$nextScene.addClass("ipnrm-active");else{s.$nextScene.removeClass("ipnrm-active");if(a.moveToNextScene){for(var n=0;n<t.config.scenes.length;n++){var i=t.config.scenes[n];if(i.id==c)break}if(n<t.config.scenes.length-1)s.$nextScene.addClass("ipnrm-active")}}};var B=function(e,t){m=t.instance};var z=function(e){if(document.fullscreen||document.mozFullScreen||document.webkitIsFullScreen||document.msFullscreenElement)s.$fullscreen.addClass("ipnrm-active");else s.$fullscreen.removeClass("ipnrm-active");setTimeout(function(){m._onWindowResize()},100)}}},P={name:"simple",defaultConfig:{},widget:function(e,t){t=j.Utils.extend(P.defaultConfig,t);var n=this;var i=e.$container;var a={};var o=false;this.init=function(){r();s()};this.destroy=function(){l();a.$widget.remove();a={};i.removeClass("ipnrm-widget-simple")};var r=function(){i.addClass("ipnrm-widget-simple");a.$widget=ie("<div>").addClass("ipnrm-widget-simple");a.$progress=ie("<div>").addClass("ipnrm-progress");a.$progressBar=ie("<div>").addClass("ipnrm-progress-bar").appendTo(a.$progress);a.$widget.append(a.$progress);i.append(a.$widget)};var s=function(){i.on("ipanorama:scene-before-load",c);i.on("ipanorama:scene-after-load",u);i.on("ipanorama:scene-progress",d);i.on("ipanorama:scene-clear",h);i.on("ipanorama:scene-hide-start",f);i.on("ipanorama:scene-hide-complete",m);i.on("ipanorama:scene-show-start",p);i.on("ipanorama:scene-show-complete",v)};var l=function(){i.off("ipanorama:scene-before-load",c);i.off("ipanorama:scene-after-load",u);i.off("ipanorama:scene-progress",d);i.off("ipanorama:scene-clear",h);i.off("ipanorama:scene-hide-start",f);i.off("ipanorama:scene-hide-complete",m);i.off("ipanorama:scene-show-start",p);i.off("ipanorama:scene-show-complete",v)};var c=function(e,t){};var u=function(e,t){a.$progress.removeClass("ipnrm-active");o=false};var d=function(e,t){if(t.progress.loaded<t.progress.total){if(!o){a.$progress.addClass("ipnrm-active");o=true}a.$progressBar.css({width:t.progress.loaded/t.progress.total*100+"%"})}else{if(o){a.$progress.removeClass("ipnrm-active");o=false}a.$progressBar.css({width:0})}};var h=function(e,t){a.$progress.removeClass("ipnrm-active");o=false};var f=function(e,t){};var m=function(e,t){};var p=function(e,t){};var v=function(e,t){}}};j.VERSION=a,j.TWEEN=le,j.HOWLER=W,j.GSVPANO=i,j.SmartRequest=e,j.Utils=Y,j.OrbitControls=r,j.TransformControls=f,j.Scene=j.Scene||{},j.Scene.Base=p,j.Scene.Sphere=t,j.Scene.Cube=n,j.Scene.GoogleStreetView=o,j.Scene.LittlePlanet=g,j.Scene.Flat=b,j.SceneTransitionEffect=j.SceneTransitionEffect||{},j.SceneTransitionEffect.None=T,j.SceneTransitionEffect.Default=_,j.Point=h,j.Plane=m,j.Viewer=R,j.AudioPlayer=M,j.Widget=j.Widget||{},j.Widget.Default=V,j.Widget.Simple=P})((e=e||self).IPANORAMA=e.IPANORAMA||{})}(this);