<?php
/**
 * States
 *
 * Returns an array of country states.
 * States should be defined in English and translated native through localisation files.
 * Country codes and states (or province) names should follow the Unicode CLDR recommendation (http://cldr.unicode.org/translation/country-names).
 * Countries defined with empty arrays have no states.
 *
 * @package Invoicing\data
 * @version 1.0.14
 */

defined( 'ABSPATH' ) || exit;

return array(
	'AF' => array(),
	'AO' => array( // Angola states.
		'BGO' => __( 'Bengo', 'invoicing' ),
		'BLU' => __( 'Benguela', 'invoicing' ),
		'BIE' => __( 'Bié', 'invoicing' ),
		'CAB' => __( 'Cabinda', 'invoicing' ),
		'CNN' => __( 'Cunene', 'invoicing' ),
		'HUA' => __( 'Huambo', 'invoicing' ),
		'HUI' => __( 'Huíla', 'invoicing' ),
		'CCU' => __( 'Kuando Kubango', 'invoicing' ),
		'CNO' => __( 'Kwanza-Norte', 'invoicing' ),
		'CUS' => __( 'Kwanza-Sul', 'invoicing' ),
		'LUA' => __( 'Luanda', 'invoicing' ),
		'LNO' => __( 'Lunda-Norte', 'invoicing' ),
		'LSU' => __( 'Lunda-Sul', 'invoicing' ),
		'MAL' => __( 'Malanje', 'invoicing' ),
		'MOX' => __( 'Moxico', 'invoicing' ),
		'NAM' => __( 'Namibe', 'invoicing' ),
		'UIG' => __( 'Uíge', 'invoicing' ),
		'ZAI' => __( 'Zaire', 'invoicing' ),
	),
	'AR' => array( // Argentinian provinces.
		'C' => __( 'Ciudad Aut&oacute;noma de Buenos Aires', 'invoicing' ),
		'B' => __( 'Buenos Aires', 'invoicing' ),
		'K' => __( 'Catamarca', 'invoicing' ),
		'H' => __( 'Chaco', 'invoicing' ),
		'U' => __( 'Chubut', 'invoicing' ),
		'X' => __( 'C&oacute;rdoba', 'invoicing' ),
		'W' => __( 'Corrientes', 'invoicing' ),
		'E' => __( 'Entre R&iacute;os', 'invoicing' ),
		'P' => __( 'Formosa', 'invoicing' ),
		'Y' => __( 'Jujuy', 'invoicing' ),
		'L' => __( 'La Pampa', 'invoicing' ),
		'F' => __( 'La Rioja', 'invoicing' ),
		'M' => __( 'Mendoza', 'invoicing' ),
		'N' => __( 'Misiones', 'invoicing' ),
		'Q' => __( 'Neuqu&eacute;n', 'invoicing' ),
		'R' => __( 'R&iacute;o Negro', 'invoicing' ),
		'A' => __( 'Salta', 'invoicing' ),
		'J' => __( 'San Juan', 'invoicing' ),
		'D' => __( 'San Luis', 'invoicing' ),
		'Z' => __( 'Santa Cruz', 'invoicing' ),
		'S' => __( 'Santa Fe', 'invoicing' ),
		'G' => __( 'Santiago del Estero', 'invoicing' ),
		'V' => __( 'Tierra del Fuego', 'invoicing' ),
		'T' => __( 'Tucum&aacute;n', 'invoicing' ),
	),
	'AT' => array(),
	'AU' => array( // Australian states.
		'ACT' => __( 'Australian Capital Territory', 'invoicing' ),
		'NSW' => __( 'New South Wales', 'invoicing' ),
		'NT'  => __( 'Northern Territory', 'invoicing' ),
		'QLD' => __( 'Queensland', 'invoicing' ),
		'SA'  => __( 'South Australia', 'invoicing' ),
		'TAS' => __( 'Tasmania', 'invoicing' ),
		'VIC' => __( 'Victoria', 'invoicing' ),
		'WA'  => __( 'Western Australia', 'invoicing' ),
	),
	'AX' => array(),
	'BD' => array( // Bangladeshi states (districts).
		'BD-05' => __( 'Bagerhat', 'invoicing' ),
		'BD-01' => __( 'Bandarban', 'invoicing' ),
		'BD-02' => __( 'Barguna', 'invoicing' ),
		'BD-06' => __( 'Barishal', 'invoicing' ),
		'BD-07' => __( 'Bhola', 'invoicing' ),
		'BD-03' => __( 'Bogura', 'invoicing' ),
		'BD-04' => __( 'Brahmanbaria', 'invoicing' ),
		'BD-09' => __( 'Chandpur', 'invoicing' ),
		'BD-10' => __( 'Chattogram', 'invoicing' ),
		'BD-12' => __( 'Chuadanga', 'invoicing' ),
		'BD-11' => __( "Cox's Bazar", 'invoicing' ),
		'BD-08' => __( 'Cumilla', 'invoicing' ),
		'BD-13' => __( 'Dhaka', 'invoicing' ),
		'BD-14' => __( 'Dinajpur', 'invoicing' ),
		'BD-15' => __( 'Faridpur ', 'invoicing' ),
		'BD-16' => __( 'Feni', 'invoicing' ),
		'BD-19' => __( 'Gaibandha', 'invoicing' ),
		'BD-18' => __( 'Gazipur', 'invoicing' ),
		'BD-17' => __( 'Gopalganj', 'invoicing' ),
		'BD-20' => __( 'Habiganj', 'invoicing' ),
		'BD-21' => __( 'Jamalpur', 'invoicing' ),
		'BD-22' => __( 'Jashore', 'invoicing' ),
		'BD-25' => __( 'Jhalokati', 'invoicing' ),
		'BD-23' => __( 'Jhenaidah', 'invoicing' ),
		'BD-24' => __( 'Joypurhat', 'invoicing' ),
		'BD-29' => __( 'Khagrachhari', 'invoicing' ),
		'BD-27' => __( 'Khulna', 'invoicing' ),
		'BD-26' => __( 'Kishoreganj', 'invoicing' ),
		'BD-28' => __( 'Kurigram', 'invoicing' ),
		'BD-30' => __( 'Kushtia', 'invoicing' ),
		'BD-31' => __( 'Lakshmipur', 'invoicing' ),
		'BD-32' => __( 'Lalmonirhat', 'invoicing' ),
		'BD-36' => __( 'Madaripur', 'invoicing' ),
		'BD-37' => __( 'Magura', 'invoicing' ),
		'BD-33' => __( 'Manikganj ', 'invoicing' ),
		'BD-39' => __( 'Meherpur', 'invoicing' ),
		'BD-38' => __( 'Moulvibazar', 'invoicing' ),
		'BD-35' => __( 'Munshiganj', 'invoicing' ),
		'BD-34' => __( 'Mymensingh', 'invoicing' ),
		'BD-48' => __( 'Naogaon', 'invoicing' ),
		'BD-43' => __( 'Narail', 'invoicing' ),
		'BD-40' => __( 'Narayanganj', 'invoicing' ),
		'BD-42' => __( 'Narsingdi', 'invoicing' ),
		'BD-44' => __( 'Natore', 'invoicing' ),
		'BD-45' => __( 'Nawabganj', 'invoicing' ),
		'BD-41' => __( 'Netrakona', 'invoicing' ),
		'BD-46' => __( 'Nilphamari', 'invoicing' ),
		'BD-47' => __( 'Noakhali', 'invoicing' ),
		'BD-49' => __( 'Pabna', 'invoicing' ),
		'BD-52' => __( 'Panchagarh', 'invoicing' ),
		'BD-51' => __( 'Patuakhali', 'invoicing' ),
		'BD-50' => __( 'Pirojpur', 'invoicing' ),
		'BD-53' => __( 'Rajbari', 'invoicing' ),
		'BD-54' => __( 'Rajshahi', 'invoicing' ),
		'BD-56' => __( 'Rangamati', 'invoicing' ),
		'BD-55' => __( 'Rangpur', 'invoicing' ),
		'BD-58' => __( 'Satkhira', 'invoicing' ),
		'BD-62' => __( 'Shariatpur', 'invoicing' ),
		'BD-57' => __( 'Sherpur', 'invoicing' ),
		'BD-59' => __( 'Sirajganj', 'invoicing' ),
		'BD-61' => __( 'Sunamganj', 'invoicing' ),
		'BD-60' => __( 'Sylhet', 'invoicing' ),
		'BD-63' => __( 'Tangail', 'invoicing' ),
		'BD-64' => __( 'Thakurgaon', 'invoicing' ),
	),
	'BE' => array(),
	'BG' => array( // Bulgarian states.
		'BG-01' => __( 'Blagoevgrad', 'invoicing' ),
		'BG-02' => __( 'Burgas', 'invoicing' ),
		'BG-08' => __( 'Dobrich', 'invoicing' ),
		'BG-07' => __( 'Gabrovo', 'invoicing' ),
		'BG-26' => __( 'Haskovo', 'invoicing' ),
		'BG-09' => __( 'Kardzhali', 'invoicing' ),
		'BG-10' => __( 'Kyustendil', 'invoicing' ),
		'BG-11' => __( 'Lovech', 'invoicing' ),
		'BG-12' => __( 'Montana', 'invoicing' ),
		'BG-13' => __( 'Pazardzhik', 'invoicing' ),
		'BG-14' => __( 'Pernik', 'invoicing' ),
		'BG-15' => __( 'Pleven', 'invoicing' ),
		'BG-16' => __( 'Plovdiv', 'invoicing' ),
		'BG-17' => __( 'Razgrad', 'invoicing' ),
		'BG-18' => __( 'Ruse', 'invoicing' ),
		'BG-27' => __( 'Shumen', 'invoicing' ),
		'BG-19' => __( 'Silistra', 'invoicing' ),
		'BG-20' => __( 'Sliven', 'invoicing' ),
		'BG-21' => __( 'Smolyan', 'invoicing' ),
		'BG-23' => __( 'Sofia', 'invoicing' ),
		'BG-22' => __( 'Sofia-Grad', 'invoicing' ),
		'BG-24' => __( 'Stara Zagora', 'invoicing' ),
		'BG-25' => __( 'Targovishte', 'invoicing' ),
		'BG-03' => __( 'Varna', 'invoicing' ),
		'BG-04' => __( 'Veliko Tarnovo', 'invoicing' ),
		'BG-05' => __( 'Vidin', 'invoicing' ),
		'BG-06' => __( 'Vratsa', 'invoicing' ),
		'BG-28' => __( 'Yambol', 'invoicing' ),
	),
	'BH' => array(),
	'BI' => array(),
	'BO' => array( // Bolivian states.
		'B' => __( 'Chuquisaca', 'invoicing' ),
		'H' => __( 'Beni', 'invoicing' ),
		'C' => __( 'Cochabamba', 'invoicing' ),
		'L' => __( 'La Paz', 'invoicing' ),
		'O' => __( 'Oruro', 'invoicing' ),
		'N' => __( 'Pando', 'invoicing' ),
		'P' => __( 'Potosí', 'invoicing' ),
		'S' => __( 'Santa Cruz', 'invoicing' ),
		'T' => __( 'Tarija', 'invoicing' ),
	),
	'BR' => array( // Brazillian states.
		'AC' => __( 'Acre', 'invoicing' ),
		'AL' => __( 'Alagoas', 'invoicing' ),
		'AP' => __( 'Amap&aacute;', 'invoicing' ),
		'AM' => __( 'Amazonas', 'invoicing' ),
		'BA' => __( 'Bahia', 'invoicing' ),
		'CE' => __( 'Cear&aacute;', 'invoicing' ),
		'DF' => __( 'Distrito Federal', 'invoicing' ),
		'ES' => __( 'Esp&iacute;rito Santo', 'invoicing' ),
		'GO' => __( 'Goi&aacute;s', 'invoicing' ),
		'MA' => __( 'Maranh&atilde;o', 'invoicing' ),
		'MT' => __( 'Mato Grosso', 'invoicing' ),
		'MS' => __( 'Mato Grosso do Sul', 'invoicing' ),
		'MG' => __( 'Minas Gerais', 'invoicing' ),
		'PA' => __( 'Par&aacute;', 'invoicing' ),
		'PB' => __( 'Para&iacute;ba', 'invoicing' ),
		'PR' => __( 'Paran&aacute;', 'invoicing' ),
		'PE' => __( 'Pernambuco', 'invoicing' ),
		'PI' => __( 'Piau&iacute;', 'invoicing' ),
		'RJ' => __( 'Rio de Janeiro', 'invoicing' ),
		'RN' => __( 'Rio Grande do Norte', 'invoicing' ),
		'RS' => __( 'Rio Grande do Sul', 'invoicing' ),
		'RO' => __( 'Rond&ocirc;nia', 'invoicing' ),
		'RR' => __( 'Roraima', 'invoicing' ),
		'SC' => __( 'Santa Catarina', 'invoicing' ),
		'SP' => __( 'S&atilde;o Paulo', 'invoicing' ),
		'SE' => __( 'Sergipe', 'invoicing' ),
		'TO' => __( 'Tocantins', 'invoicing' ),
	),
	'CA' => array( // Canadian states.
		'AB' => __( 'Alberta', 'invoicing' ),
		'BC' => __( 'British Columbia', 'invoicing' ),
		'MB' => __( 'Manitoba', 'invoicing' ),
		'NB' => __( 'New Brunswick', 'invoicing' ),
		'NL' => __( 'Newfoundland and Labrador', 'invoicing' ),
		'NT' => __( 'Northwest Territories', 'invoicing' ),
		'NS' => __( 'Nova Scotia', 'invoicing' ),
		'NU' => __( 'Nunavut', 'invoicing' ),
		'ON' => __( 'Ontario', 'invoicing' ),
		'PE' => __( 'Prince Edward Island', 'invoicing' ),
		'QC' => __( 'Quebec', 'invoicing' ),
		'SK' => __( 'Saskatchewan', 'invoicing' ),
		'YT' => __( 'Yukon Territory', 'invoicing' ),
	),
	'CH' => array( // Cantons of Switzerland.
		'AG' => __( 'Aargau', 'invoicing' ),
		'AR' => __( 'Appenzell Ausserrhoden', 'invoicing' ),
		'AI' => __( 'Appenzell Innerrhoden', 'invoicing' ),
		'BL' => __( 'Basel-Landschaft', 'invoicing' ),
		'BS' => __( 'Basel-Stadt', 'invoicing' ),
		'BE' => __( 'Bern', 'invoicing' ),
		'FR' => __( 'Fribourg', 'invoicing' ),
		'GE' => __( 'Geneva', 'invoicing' ),
		'GL' => __( 'Glarus', 'invoicing' ),
		'GR' => __( 'Graub&uuml;nden', 'invoicing' ),
		'JU' => __( 'Jura', 'invoicing' ),
		'LU' => __( 'Luzern', 'invoicing' ),
		'NE' => __( 'Neuch&acirc;tel', 'invoicing' ),
		'NW' => __( 'Nidwalden', 'invoicing' ),
		'OW' => __( 'Obwalden', 'invoicing' ),
		'SH' => __( 'Schaffhausen', 'invoicing' ),
		'SZ' => __( 'Schwyz', 'invoicing' ),
		'SO' => __( 'Solothurn', 'invoicing' ),
		'SG' => __( 'St. Gallen', 'invoicing' ),
		'TG' => __( 'Thurgau', 'invoicing' ),
		'TI' => __( 'Ticino', 'invoicing' ),
		'UR' => __( 'Uri', 'invoicing' ),
		'VS' => __( 'Valais', 'invoicing' ),
		'VD' => __( 'Vaud', 'invoicing' ),
		'ZG' => __( 'Zug', 'invoicing' ),
		'ZH' => __( 'Z&uuml;rich', 'invoicing' ),
	),
	'CN' => array( // Chinese states.
		'CN1'  => __( 'Yunnan / &#20113;&#21335;', 'invoicing' ),
		'CN2'  => __( 'Beijing / &#21271;&#20140;', 'invoicing' ),
		'CN3'  => __( 'Tianjin / &#22825;&#27941;', 'invoicing' ),
		'CN4'  => __( 'Hebei / &#27827;&#21271;', 'invoicing' ),
		'CN5'  => __( 'Shanxi / &#23665;&#35199;', 'invoicing' ),
		'CN6'  => __( 'Inner Mongolia / &#20839;&#33945;&#21476;', 'invoicing' ),
		'CN7'  => __( 'Liaoning / &#36797;&#23425;', 'invoicing' ),
		'CN8'  => __( 'Jilin / &#21513;&#26519;', 'invoicing' ),
		'CN9'  => __( 'Heilongjiang / &#40657;&#40857;&#27743;', 'invoicing' ),
		'CN10' => __( 'Shanghai / &#19978;&#28023;', 'invoicing' ),
		'CN11' => __( 'Jiangsu / &#27743;&#33487;', 'invoicing' ),
		'CN12' => __( 'Zhejiang / &#27993;&#27743;', 'invoicing' ),
		'CN13' => __( 'Anhui / &#23433;&#24509;', 'invoicing' ),
		'CN14' => __( 'Fujian / &#31119;&#24314;', 'invoicing' ),
		'CN15' => __( 'Jiangxi / &#27743;&#35199;', 'invoicing' ),
		'CN16' => __( 'Shandong / &#23665;&#19996;', 'invoicing' ),
		'CN17' => __( 'Henan / &#27827;&#21335;', 'invoicing' ),
		'CN18' => __( 'Hubei / &#28246;&#21271;', 'invoicing' ),
		'CN19' => __( 'Hunan / &#28246;&#21335;', 'invoicing' ),
		'CN20' => __( 'Guangdong / &#24191;&#19996;', 'invoicing' ),
		'CN21' => __( 'Guangxi Zhuang / &#24191;&#35199;&#22766;&#26063;', 'invoicing' ),
		'CN22' => __( 'Hainan / &#28023;&#21335;', 'invoicing' ),
		'CN23' => __( 'Chongqing / &#37325;&#24198;', 'invoicing' ),
		'CN24' => __( 'Sichuan / &#22235;&#24029;', 'invoicing' ),
		'CN25' => __( 'Guizhou / &#36149;&#24030;', 'invoicing' ),
		'CN26' => __( 'Shaanxi / &#38485;&#35199;', 'invoicing' ),
		'CN27' => __( 'Gansu / &#29976;&#32899;', 'invoicing' ),
		'CN28' => __( 'Qinghai / &#38738;&#28023;', 'invoicing' ),
		'CN29' => __( 'Ningxia Hui / &#23425;&#22799;', 'invoicing' ),
		'CN30' => __( 'Macao / &#28595;&#38376;', 'invoicing' ),
		'CN31' => __( 'Tibet / &#35199;&#34255;', 'invoicing' ),
		'CN32' => __( 'Xinjiang / &#26032;&#30086;', 'invoicing' ),
	),
	'CZ' => array(),
	'DE' => array(),
	'DK' => array(),
	'EE' => array(),
	'ES' => array( // Spanish states.
		'C'  => __( 'A Coru&ntilde;a', 'invoicing' ),
		'VI' => __( 'Araba/&Aacute;lava', 'invoicing' ),
		'AB' => __( 'Albacete', 'invoicing' ),
		'A'  => __( 'Alicante', 'invoicing' ),
		'AL' => __( 'Almer&iacute;a', 'invoicing' ),
		'O'  => __( 'Asturias', 'invoicing' ),
		'AV' => __( '&Aacute;vila', 'invoicing' ),
		'BA' => __( 'Badajoz', 'invoicing' ),
		'PM' => __( 'Baleares', 'invoicing' ),
		'B'  => __( 'Barcelona', 'invoicing' ),
		'BU' => __( 'Burgos', 'invoicing' ),
		'CC' => __( 'C&aacute;ceres', 'invoicing' ),
		'CA' => __( 'C&aacute;diz', 'invoicing' ),
		'S'  => __( 'Cantabria', 'invoicing' ),
		'CS' => __( 'Castell&oacute;n', 'invoicing' ),
		'CE' => __( 'Ceuta', 'invoicing' ),
		'CR' => __( 'Ciudad Real', 'invoicing' ),
		'CO' => __( 'C&oacute;rdoba', 'invoicing' ),
		'CU' => __( 'Cuenca', 'invoicing' ),
		'GI' => __( 'Girona', 'invoicing' ),
		'GR' => __( 'Granada', 'invoicing' ),
		'GU' => __( 'Guadalajara', 'invoicing' ),
		'SS' => __( 'Gipuzkoa', 'invoicing' ),
		'H'  => __( 'Huelva', 'invoicing' ),
		'HU' => __( 'Huesca', 'invoicing' ),
		'J'  => __( 'Ja&eacute;n', 'invoicing' ),
		'LO' => __( 'La Rioja', 'invoicing' ),
		'GC' => __( 'Las Palmas', 'invoicing' ),
		'LE' => __( 'Le&oacute;n', 'invoicing' ),
		'L'  => __( 'Lleida', 'invoicing' ),
		'LU' => __( 'Lugo', 'invoicing' ),
		'M'  => __( 'Madrid', 'invoicing' ),
		'MA' => __( 'M&aacute;laga', 'invoicing' ),
		'ML' => __( 'Melilla', 'invoicing' ),
		'MU' => __( 'Murcia', 'invoicing' ),
		'NA' => __( 'Navarra', 'invoicing' ),
		'OR' => __( 'Ourense', 'invoicing' ),
		'P'  => __( 'Palencia', 'invoicing' ),
		'PO' => __( 'Pontevedra', 'invoicing' ),
		'SA' => __( 'Salamanca', 'invoicing' ),
		'TF' => __( 'Santa Cruz de Tenerife', 'invoicing' ),
		'SG' => __( 'Segovia', 'invoicing' ),
		'SE' => __( 'Sevilla', 'invoicing' ),
		'SO' => __( 'Soria', 'invoicing' ),
		'T'  => __( 'Tarragona', 'invoicing' ),
		'TE' => __( 'Teruel', 'invoicing' ),
		'TO' => __( 'Toledo', 'invoicing' ),
		'V'  => __( 'Valencia', 'invoicing' ),
		'VA' => __( 'Valladolid', 'invoicing' ),
		'BI' => __( 'Bizkaia', 'invoicing' ),
		'ZA' => __( 'Zamora', 'invoicing' ),
		'Z'  => __( 'Zaragoza', 'invoicing' ),
	),
	'FI' => array(),
	'FR' => array(),
	'GP' => array(),
	'GR' => array( // Greek Regions.
		'I' => __( 'Αττική', 'invoicing' ),
		'A' => __( 'Ανατολική Μακεδονία και Θράκη', 'invoicing' ),
		'B' => __( 'Κεντρική Μακεδονία', 'invoicing' ),
		'C' => __( 'Δυτική Μακεδονία', 'invoicing' ),
		'D' => __( 'Ήπειρος', 'invoicing' ),
		'E' => __( 'Θεσσαλία', 'invoicing' ),
		'F' => __( 'Ιόνιοι Νήσοι', 'invoicing' ),
		'G' => __( 'Δυτική Ελλάδα', 'invoicing' ),
		'H' => __( 'Στερεά Ελλάδα', 'invoicing' ),
		'J' => __( 'Πελοπόννησος', 'invoicing' ),
		'K' => __( 'Βόρειο Αιγαίο', 'invoicing' ),
		'L' => __( 'Νότιο Αιγαίο', 'invoicing' ),
		'M' => __( 'Κρήτη', 'invoicing' ),
	),
	'GF' => array(),
	'HK' => array( // Hong Kong states.
		'HONG KONG'       => __( 'Hong Kong Island', 'invoicing' ),
		'KOWLOON'         => __( 'Kowloon', 'invoicing' ),
		'NEW TERRITORIES' => __( 'New Territories', 'invoicing' ),
	),
	'HU' => array( // Hungary states.
		'BK' => __( 'Bács-Kiskun', 'invoicing' ),
		'BE' => __( 'Békés', 'invoicing' ),
		'BA' => __( 'Baranya', 'invoicing' ),
		'BZ' => __( 'Borsod-Abaúj-Zemplén', 'invoicing' ),
		'BU' => __( 'Budapest', 'invoicing' ),
		'CS' => __( 'Csongrád', 'invoicing' ),
		'FE' => __( 'Fejér', 'invoicing' ),
		'GS' => __( 'Győr-Moson-Sopron', 'invoicing' ),
		'HB' => __( 'Hajdú-Bihar', 'invoicing' ),
		'HE' => __( 'Heves', 'invoicing' ),
		'JN' => __( 'Jász-Nagykun-Szolnok', 'invoicing' ),
		'KE' => __( 'Komárom-Esztergom', 'invoicing' ),
		'NO' => __( 'Nógrád', 'invoicing' ),
		'PE' => __( 'Pest', 'invoicing' ),
		'SO' => __( 'Somogy', 'invoicing' ),
		'SZ' => __( 'Szabolcs-Szatmár-Bereg', 'invoicing' ),
		'TO' => __( 'Tolna', 'invoicing' ),
		'VA' => __( 'Vas', 'invoicing' ),
		'VE' => __( 'Veszprém', 'invoicing' ),
		'ZA' => __( 'Zala', 'invoicing' ),
	),
	'ID' => array( // Indonesia Provinces.
		'AC' => __( 'Daerah Istimewa Aceh', 'invoicing' ),
		'SU' => __( 'Sumatera Utara', 'invoicing' ),
		'SB' => __( 'Sumatera Barat', 'invoicing' ),
		'RI' => __( 'Riau', 'invoicing' ),
		'KR' => __( 'Kepulauan Riau', 'invoicing' ),
		'JA' => __( 'Jambi', 'invoicing' ),
		'SS' => __( 'Sumatera Selatan', 'invoicing' ),
		'BB' => __( 'Bangka Belitung', 'invoicing' ),
		'BE' => __( 'Bengkulu', 'invoicing' ),
		'LA' => __( 'Lampung', 'invoicing' ),
		'JK' => __( 'DKI Jakarta', 'invoicing' ),
		'JB' => __( 'Jawa Barat', 'invoicing' ),
		'BT' => __( 'Banten', 'invoicing' ),
		'JT' => __( 'Jawa Tengah', 'invoicing' ),
		'JI' => __( 'Jawa Timur', 'invoicing' ),
		'YO' => __( 'Daerah Istimewa Yogyakarta', 'invoicing' ),
		'BA' => __( 'Bali', 'invoicing' ),
		'NB' => __( 'Nusa Tenggara Barat', 'invoicing' ),
		'NT' => __( 'Nusa Tenggara Timur', 'invoicing' ),
		'KB' => __( 'Kalimantan Barat', 'invoicing' ),
		'KT' => __( 'Kalimantan Tengah', 'invoicing' ),
		'KI' => __( 'Kalimantan Timur', 'invoicing' ),
		'KS' => __( 'Kalimantan Selatan', 'invoicing' ),
		'KU' => __( 'Kalimantan Utara', 'invoicing' ),
		'SA' => __( 'Sulawesi Utara', 'invoicing' ),
		'ST' => __( 'Sulawesi Tengah', 'invoicing' ),
		'SG' => __( 'Sulawesi Tenggara', 'invoicing' ),
		'SR' => __( 'Sulawesi Barat', 'invoicing' ),
		'SN' => __( 'Sulawesi Selatan', 'invoicing' ),
		'GO' => __( 'Gorontalo', 'invoicing' ),
		'MA' => __( 'Maluku', 'invoicing' ),
		'MU' => __( 'Maluku Utara', 'invoicing' ),
		'PA' => __( 'Papua', 'invoicing' ),
		'PB' => __( 'Papua Barat', 'invoicing' ),
	),
	'IE' => array( // Republic of Ireland.
		'CW' => __( 'Carlow', 'invoicing' ),
		'CN' => __( 'Cavan', 'invoicing' ),
		'CE' => __( 'Clare', 'invoicing' ),
		'CO' => __( 'Cork', 'invoicing' ),
		'DL' => __( 'Donegal', 'invoicing' ),
		'D'  => __( 'Dublin', 'invoicing' ),
		'G'  => __( 'Galway', 'invoicing' ),
		'KY' => __( 'Kerry', 'invoicing' ),
		'KE' => __( 'Kildare', 'invoicing' ),
		'KK' => __( 'Kilkenny', 'invoicing' ),
		'LS' => __( 'Laois', 'invoicing' ),
		'LM' => __( 'Leitrim', 'invoicing' ),
		'LK' => __( 'Limerick', 'invoicing' ),
		'LD' => __( 'Longford', 'invoicing' ),
		'LH' => __( 'Louth', 'invoicing' ),
		'MO' => __( 'Mayo', 'invoicing' ),
		'MH' => __( 'Meath', 'invoicing' ),
		'MN' => __( 'Monaghan', 'invoicing' ),
		'OY' => __( 'Offaly', 'invoicing' ),
		'RN' => __( 'Roscommon', 'invoicing' ),
		'SO' => __( 'Sligo', 'invoicing' ),
		'TA' => __( 'Tipperary', 'invoicing' ),
		'WD' => __( 'Waterford', 'invoicing' ),
		'WH' => __( 'Westmeath', 'invoicing' ),
		'WX' => __( 'Wexford', 'invoicing' ),
		'WW' => __( 'Wicklow', 'invoicing' ),
	),
	'IN' => array( // Indian states.
		'AP' => __( 'Andhra Pradesh', 'invoicing' ),
		'AR' => __( 'Arunachal Pradesh', 'invoicing' ),
		'AS' => __( 'Assam', 'invoicing' ),
		'BR' => __( 'Bihar', 'invoicing' ),
		'CT' => __( 'Chhattisgarh', 'invoicing' ),
		'GA' => __( 'Goa', 'invoicing' ),
		'GJ' => __( 'Gujarat', 'invoicing' ),
		'HR' => __( 'Haryana', 'invoicing' ),
		'HP' => __( 'Himachal Pradesh', 'invoicing' ),
		'JK' => __( 'Jammu and Kashmir', 'invoicing' ),
		'JH' => __( 'Jharkhand', 'invoicing' ),
		'KA' => __( 'Karnataka', 'invoicing' ),
		'KL' => __( 'Kerala', 'invoicing' ),
		'MP' => __( 'Madhya Pradesh', 'invoicing' ),
		'MH' => __( 'Maharashtra', 'invoicing' ),
		'MN' => __( 'Manipur', 'invoicing' ),
		'ML' => __( 'Meghalaya', 'invoicing' ),
		'MZ' => __( 'Mizoram', 'invoicing' ),
		'NL' => __( 'Nagaland', 'invoicing' ),
		'OR' => __( 'Orissa', 'invoicing' ),
		'PB' => __( 'Punjab', 'invoicing' ),
		'RJ' => __( 'Rajasthan', 'invoicing' ),
		'SK' => __( 'Sikkim', 'invoicing' ),
		'TN' => __( 'Tamil Nadu', 'invoicing' ),
		'TS' => __( 'Telangana', 'invoicing' ),
		'TR' => __( 'Tripura', 'invoicing' ),
		'UK' => __( 'Uttarakhand', 'invoicing' ),
		'UP' => __( 'Uttar Pradesh', 'invoicing' ),
		'WB' => __( 'West Bengal', 'invoicing' ),
		'AN' => __( 'Andaman and Nicobar Islands', 'invoicing' ),
		'CH' => __( 'Chandigarh', 'invoicing' ),
		'DN' => __( 'Dadra and Nagar Haveli', 'invoicing' ),
		'DD' => __( 'Daman and Diu', 'invoicing' ),
		'DL' => __( 'Delhi', 'invoicing' ),
		'LD' => __( 'Lakshadeep', 'invoicing' ),
		'PY' => __( 'Pondicherry (Puducherry)', 'invoicing' ),
	),
	'IR' => array( // Iran States.
		'KHZ' => __( 'Khuzestan  (خوزستان)', 'invoicing' ),
		'THR' => __( 'Tehran  (تهران)', 'invoicing' ),
		'ILM' => __( 'Ilaam (ایلام)', 'invoicing' ),
		'BHR' => __( 'Bushehr (بوشهر)', 'invoicing' ),
		'ADL' => __( 'Ardabil (اردبیل)', 'invoicing' ),
		'ESF' => __( 'Isfahan (اصفهان)', 'invoicing' ),
		'YZD' => __( 'Yazd (یزد)', 'invoicing' ),
		'KRH' => __( 'Kermanshah (کرمانشاه)', 'invoicing' ),
		'KRN' => __( 'Kerman (کرمان)', 'invoicing' ),
		'HDN' => __( 'Hamadan (همدان)', 'invoicing' ),
		'GZN' => __( 'Ghazvin (قزوین)', 'invoicing' ),
		'ZJN' => __( 'Zanjan (زنجان)', 'invoicing' ),
		'LRS' => __( 'Luristan (لرستان)', 'invoicing' ),
		'ABZ' => __( 'Alborz (البرز)', 'invoicing' ),
		'EAZ' => __( 'East Azarbaijan (آذربایجان شرقی)', 'invoicing' ),
		'WAZ' => __( 'West Azarbaijan (آذربایجان غربی)', 'invoicing' ),
		'CHB' => __( 'Chaharmahal and Bakhtiari (چهارمحال و بختیاری)', 'invoicing' ),
		'SKH' => __( 'South Khorasan (خراسان جنوبی)', 'invoicing' ),
		'RKH' => __( 'Razavi Khorasan (خراسان رضوی)', 'invoicing' ),
		'NKH' => __( 'North Khorasan (خراسان شمالی)', 'invoicing' ),
		'SMN' => __( 'Semnan (سمنان)', 'invoicing' ),
		'FRS' => __( 'Fars (فارس)', 'invoicing' ),
		'QHM' => __( 'Qom (قم)', 'invoicing' ),
		'KRD' => __( 'Kurdistan / کردستان)', 'invoicing' ),
		'KBD' => __( 'Kohgiluyeh and BoyerAhmad (کهگیلوییه و بویراحمد)', 'invoicing' ),
		'GLS' => __( 'Golestan (گلستان)', 'invoicing' ),
		'GIL' => __( 'Gilan (گیلان)', 'invoicing' ),
		'MZN' => __( 'Mazandaran (مازندران)', 'invoicing' ),
		'MKZ' => __( 'Markazi (مرکزی)', 'invoicing' ),
		'HRZ' => __( 'Hormozgan (هرمزگان)', 'invoicing' ),
		'SBN' => __( 'Sistan and Baluchestan (سیستان و بلوچستان)', 'invoicing' ),
	),
	'IS' => array(),
	'IT' => array( // Italy Provinces.
		'AG' => __( 'Agrigento', 'invoicing' ),
		'AL' => __( 'Alessandria', 'invoicing' ),
		'AN' => __( 'Ancona', 'invoicing' ),
		'AO' => __( 'Aosta', 'invoicing' ),
		'AR' => __( 'Arezzo', 'invoicing' ),
		'AP' => __( 'Ascoli Piceno', 'invoicing' ),
		'AT' => __( 'Asti', 'invoicing' ),
		'AV' => __( 'Avellino', 'invoicing' ),
		'BA' => __( 'Bari', 'invoicing' ),
		'BT' => __( 'Barletta-Andria-Trani', 'invoicing' ),
		'BL' => __( 'Belluno', 'invoicing' ),
		'BN' => __( 'Benevento', 'invoicing' ),
		'BG' => __( 'Bergamo', 'invoicing' ),
		'BI' => __( 'Biella', 'invoicing' ),
		'BO' => __( 'Bologna', 'invoicing' ),
		'BZ' => __( 'Bolzano', 'invoicing' ),
		'BS' => __( 'Brescia', 'invoicing' ),
		'BR' => __( 'Brindisi', 'invoicing' ),
		'CA' => __( 'Cagliari', 'invoicing' ),
		'CL' => __( 'Caltanissetta', 'invoicing' ),
		'CB' => __( 'Campobasso', 'invoicing' ),
		'CE' => __( 'Caserta', 'invoicing' ),
		'CT' => __( 'Catania', 'invoicing' ),
		'CZ' => __( 'Catanzaro', 'invoicing' ),
		'CH' => __( 'Chieti', 'invoicing' ),
		'CO' => __( 'Como', 'invoicing' ),
		'CS' => __( 'Cosenza', 'invoicing' ),
		'CR' => __( 'Cremona', 'invoicing' ),
		'KR' => __( 'Crotone', 'invoicing' ),
		'CN' => __( 'Cuneo', 'invoicing' ),
		'EN' => __( 'Enna', 'invoicing' ),
		'FM' => __( 'Fermo', 'invoicing' ),
		'FE' => __( 'Ferrara', 'invoicing' ),
		'FI' => __( 'Firenze', 'invoicing' ),
		'FG' => __( 'Foggia', 'invoicing' ),
		'FC' => __( 'Forlì-Cesena', 'invoicing' ),
		'FR' => __( 'Frosinone', 'invoicing' ),
		'GE' => __( 'Genova', 'invoicing' ),
		'GO' => __( 'Gorizia', 'invoicing' ),
		'GR' => __( 'Grosseto', 'invoicing' ),
		'IM' => __( 'Imperia', 'invoicing' ),
		'IS' => __( 'Isernia', 'invoicing' ),
		'SP' => __( 'La Spezia', 'invoicing' ),
		'AQ' => __( "L'Aquila", 'invoicing' ),
		'LT' => __( 'Latina', 'invoicing' ),
		'LE' => __( 'Lecce', 'invoicing' ),
		'LC' => __( 'Lecco', 'invoicing' ),
		'LI' => __( 'Livorno', 'invoicing' ),
		'LO' => __( 'Lodi', 'invoicing' ),
		'LU' => __( 'Lucca', 'invoicing' ),
		'MC' => __( 'Macerata', 'invoicing' ),
		'MN' => __( 'Mantova', 'invoicing' ),
		'MS' => __( 'Massa-Carrara', 'invoicing' ),
		'MT' => __( 'Matera', 'invoicing' ),
		'ME' => __( 'Messina', 'invoicing' ),
		'MI' => __( 'Milano', 'invoicing' ),
		'MO' => __( 'Modena', 'invoicing' ),
		'MB' => __( 'Monza e della Brianza', 'invoicing' ),
		'NA' => __( 'Napoli', 'invoicing' ),
		'NO' => __( 'Novara', 'invoicing' ),
		'NU' => __( 'Nuoro', 'invoicing' ),
		'OR' => __( 'Oristano', 'invoicing' ),
		'PD' => __( 'Padova', 'invoicing' ),
		'PA' => __( 'Palermo', 'invoicing' ),
		'PR' => __( 'Parma', 'invoicing' ),
		'PV' => __( 'Pavia', 'invoicing' ),
		'PG' => __( 'Perugia', 'invoicing' ),
		'PU' => __( 'Pesaro e Urbino', 'invoicing' ),
		'PE' => __( 'Pescara', 'invoicing' ),
		'PC' => __( 'Piacenza', 'invoicing' ),
		'PI' => __( 'Pisa', 'invoicing' ),
		'PT' => __( 'Pistoia', 'invoicing' ),
		'PN' => __( 'Pordenone', 'invoicing' ),
		'PZ' => __( 'Potenza', 'invoicing' ),
		'PO' => __( 'Prato', 'invoicing' ),
		'RG' => __( 'Ragusa', 'invoicing' ),
		'RA' => __( 'Ravenna', 'invoicing' ),
		'RC' => __( 'Reggio Calabria', 'invoicing' ),
		'RE' => __( 'Reggio Emilia', 'invoicing' ),
		'RI' => __( 'Rieti', 'invoicing' ),
		'RN' => __( 'Rimini', 'invoicing' ),
		'RM' => __( 'Roma', 'invoicing' ),
		'RO' => __( 'Rovigo', 'invoicing' ),
		'SA' => __( 'Salerno', 'invoicing' ),
		'SS' => __( 'Sassari', 'invoicing' ),
		'SV' => __( 'Savona', 'invoicing' ),
		'SI' => __( 'Siena', 'invoicing' ),
		'SR' => __( 'Siracusa', 'invoicing' ),
		'SO' => __( 'Sondrio', 'invoicing' ),
		'SU' => __( 'Sud Sardegna', 'invoicing' ),
		'TA' => __( 'Taranto', 'invoicing' ),
		'TE' => __( 'Teramo', 'invoicing' ),
		'TR' => __( 'Terni', 'invoicing' ),
		'TO' => __( 'Torino', 'invoicing' ),
		'TP' => __( 'Trapani', 'invoicing' ),
		'TN' => __( 'Trento', 'invoicing' ),
		'TV' => __( 'Treviso', 'invoicing' ),
		'TS' => __( 'Trieste', 'invoicing' ),
		'UD' => __( 'Udine', 'invoicing' ),
		'VA' => __( 'Varese', 'invoicing' ),
		'VE' => __( 'Venezia', 'invoicing' ),
		'VB' => __( 'Verbano-Cusio-Ossola', 'invoicing' ),
		'VC' => __( 'Vercelli', 'invoicing' ),
		'VR' => __( 'Verona', 'invoicing' ),
		'VV' => __( 'Vibo Valentia', 'invoicing' ),
		'VI' => __( 'Vicenza', 'invoicing' ),
		'VT' => __( 'Viterbo', 'invoicing' ),
	),
	'IL' => array(),
	'IM' => array(),

	/**
	 * Japan States.
	 *
	 * English notation of prefectures conform to the notation of Japan Post.
	 * The suffix corresponds with the Japanese translation file.
	 */
	'JP' => array(
		'JP01' => __( 'Hokkaido', 'invoicing' ),
		'JP02' => __( 'Aomori', 'invoicing' ),
		'JP03' => __( 'Iwate', 'invoicing' ),
		'JP04' => __( 'Miyagi', 'invoicing' ),
		'JP05' => __( 'Akita', 'invoicing' ),
		'JP06' => __( 'Yamagata', 'invoicing' ),
		'JP07' => __( 'Fukushima', 'invoicing' ),
		'JP08' => __( 'Ibaraki', 'invoicing' ),
		'JP09' => __( 'Tochigi', 'invoicing' ),
		'JP10' => __( 'Gunma', 'invoicing' ),
		'JP11' => __( 'Saitama', 'invoicing' ),
		'JP12' => __( 'Chiba', 'invoicing' ),
		'JP13' => __( 'Tokyo', 'invoicing' ),
		'JP14' => __( 'Kanagawa', 'invoicing' ),
		'JP15' => __( 'Niigata', 'invoicing' ),
		'JP16' => __( 'Toyama', 'invoicing' ),
		'JP17' => __( 'Ishikawa', 'invoicing' ),
		'JP18' => __( 'Fukui', 'invoicing' ),
		'JP19' => __( 'Yamanashi', 'invoicing' ),
		'JP20' => __( 'Nagano', 'invoicing' ),
		'JP21' => __( 'Gifu', 'invoicing' ),
		'JP22' => __( 'Shizuoka', 'invoicing' ),
		'JP23' => __( 'Aichi', 'invoicing' ),
		'JP24' => __( 'Mie', 'invoicing' ),
		'JP25' => __( 'Shiga', 'invoicing' ),
		'JP26' => __( 'Kyoto', 'invoicing' ),
		'JP27' => __( 'Osaka', 'invoicing' ),
		'JP28' => __( 'Hyogo', 'invoicing' ),
		'JP29' => __( 'Nara', 'invoicing' ),
		'JP30' => __( 'Wakayama', 'invoicing' ),
		'JP31' => __( 'Tottori', 'invoicing' ),
		'JP32' => __( 'Shimane', 'invoicing' ),
		'JP33' => __( 'Okayama', 'invoicing' ),
		'JP34' => __( 'Hiroshima', 'invoicing' ),
		'JP35' => __( 'Yamaguchi', 'invoicing' ),
		'JP36' => __( 'Tokushima', 'invoicing' ),
		'JP37' => __( 'Kagawa', 'invoicing' ),
		'JP38' => __( 'Ehime', 'invoicing' ),
		'JP39' => __( 'Kochi', 'invoicing' ),
		'JP40' => __( 'Fukuoka', 'invoicing' ),
		'JP41' => __( 'Saga', 'invoicing' ),
		'JP42' => __( 'Nagasaki', 'invoicing' ),
		'JP43' => __( 'Kumamoto', 'invoicing' ),
		'JP44' => __( 'Oita', 'invoicing' ),
		'JP45' => __( 'Miyazaki', 'invoicing' ),
		'JP46' => __( 'Kagoshima', 'invoicing' ),
		'JP47' => __( 'Okinawa', 'invoicing' ),
	),
	'KE' => array( // Kenya Counties.
		'1'  => __( 'Mombasa', 'invoicing' ),
		'2'  => __( 'Kwale', 'invoicing' ),
		'3'  => __( 'Kilifi', 'invoicing' ),
		'4'  => __( 'Tana River', 'invoicing' ),
		'5'  => __( 'Lamu', 'invoicing' ),
		'6'  => __( 'Taita-Taveta', 'invoicing' ),
		'7'  => __( 'Garissa', 'invoicing' ),
		'8'  => __( 'Wajir', 'invoicing' ),
		'9'  => __( 'Mandera', 'invoicing' ),
		'10' => __( 'Marsabit', 'invoicing' ),
		'11' => __( 'Isiolo', 'invoicing' ),
		'12' => __( 'Meru', 'invoicing' ),
		'13' => __( 'Tharaka-Nithi', 'invoicing' ),
		'14' => __( 'Embu', 'invoicing' ),
		'15' => __( 'Kitui', 'invoicing' ),
		'16' => __( 'Machakos', 'invoicing' ),
		'17' => __( 'Makueni', 'invoicing' ),
		'18' => __( 'Nyandarua', 'invoicing' ),
		'19' => __( 'Nyeri', 'invoicing' ),
		'20' => __( 'Kirinyaga', 'invoicing' ),
		'21' => __( "Murang'a", 'invoicing' ),
		'22' => __( 'Kiambu', 'invoicing' ),
		'23' => __( 'Turkana', 'invoicing' ),
		'24' => __( 'West Pokot', 'invoicing' ),
		'25' => __( 'Samburu', 'invoicing' ),
		'26' => __( 'Trans-Nzoia', 'invoicing' ),
		'27' => __( 'Uasin Gishu', 'invoicing' ),
		'28' => __( 'Elgeyo-Marakwet', 'invoicing' ),
		'29' => __( 'Nandi', 'invoicing' ),
		'30' => __( 'Baringo', 'invoicing' ),
		'31' => __( 'Laikipia', 'invoicing' ),
		'32' => __( 'Nakuru', 'invoicing' ),
		'33' => __( 'Narok', 'invoicing' ),
		'34' => __( 'Kajiado', 'invoicing' ),
		'35' => __( 'Kericho', 'invoicing' ),
		'36' => __( 'Bomet', 'invoicing' ),
		'37' => __( 'Kakamega', 'invoicing' ),
		'38' => __( 'Vihiga', 'invoicing' ),
		'39' => __( 'Bungoma', 'invoicing' ),
		'40' => __( 'Busia', 'invoicing' ),
		'41' => __( 'Siaya', 'invoicing' ),
		'42' => __( 'Kisumu', 'invoicing' ),
		'43' => __( 'Homa bay', 'invoicing' ),
		'44' => __( 'Migori', 'invoicing' ),
		'45' => __( 'Kisii', 'invoicing' ),
		'46' => __( 'Nyamira', 'invoicing' ),
		'47' => __( 'Nairobi', 'invoicing' ),
	),
	'KR' => array(),
	'KW' => array(),
	'LB' => array(),
	'LR' => array( // Liberia provinces.
		'BM' => __( 'Bomi', 'invoicing' ),
		'BN' => __( 'Bong', 'invoicing' ),
		'GA' => __( 'Gbarpolu', 'invoicing' ),
		'GB' => __( 'Grand Bassa', 'invoicing' ),
		'GC' => __( 'Grand Cape Mount', 'invoicing' ),
		'GG' => __( 'Grand Gedeh', 'invoicing' ),
		'GK' => __( 'Grand Kru', 'invoicing' ),
		'LO' => __( 'Lofa', 'invoicing' ),
		'MA' => __( 'Margibi', 'invoicing' ),
		'MY' => __( 'Maryland', 'invoicing' ),
		'MO' => __( 'Montserrado', 'invoicing' ),
		'NM' => __( 'Nimba', 'invoicing' ),
		'RV' => __( 'Rivercess', 'invoicing' ),
		'RG' => __( 'River Gee', 'invoicing' ),
		'SN' => __( 'Sinoe', 'invoicing' ),
	),
	'LU' => array(),
	'MD' => array( // Moldova states.
		'C'  => __( 'Chi&#537;in&#259;u', 'invoicing' ),
		'BL' => __( 'B&#259;l&#539;i', 'invoicing' ),
		'AN' => __( 'Anenii Noi', 'invoicing' ),
		'BS' => __( 'Basarabeasca', 'invoicing' ),
		'BR' => __( 'Briceni', 'invoicing' ),
		'CH' => __( 'Cahul', 'invoicing' ),
		'CT' => __( 'Cantemir', 'invoicing' ),
		'CL' => __( 'C&#259;l&#259;ra&#537;i', 'invoicing' ),
		'CS' => __( 'C&#259;u&#537;eni', 'invoicing' ),
		'CM' => __( 'Cimi&#537;lia', 'invoicing' ),
		'CR' => __( 'Criuleni', 'invoicing' ),
		'DN' => __( 'Dondu&#537;eni', 'invoicing' ),
		'DR' => __( 'Drochia', 'invoicing' ),
		'DB' => __( 'Dub&#259;sari', 'invoicing' ),
		'ED' => __( 'Edine&#539;', 'invoicing' ),
		'FL' => __( 'F&#259;le&#537;ti', 'invoicing' ),
		'FR' => __( 'Flore&#537;ti', 'invoicing' ),
		'GE' => __( 'UTA G&#259;g&#259;uzia', 'invoicing' ),
		'GL' => __( 'Glodeni', 'invoicing' ),
		'HN' => __( 'H&icirc;nce&#537;ti', 'invoicing' ),
		'IL' => __( 'Ialoveni', 'invoicing' ),
		'LV' => __( 'Leova', 'invoicing' ),
		'NS' => __( 'Nisporeni', 'invoicing' ),
		'OC' => __( 'Ocni&#539;a', 'invoicing' ),
		'OR' => __( 'Orhei', 'invoicing' ),
		'RZ' => __( 'Rezina', 'invoicing' ),
		'RS' => __( 'R&icirc;&#537;cani', 'invoicing' ),
		'SG' => __( 'S&icirc;ngerei', 'invoicing' ),
		'SR' => __( 'Soroca', 'invoicing' ),
		'ST' => __( 'Str&#259;&#537;eni', 'invoicing' ),
		'SD' => __( '&#536;old&#259;ne&#537;ti', 'invoicing' ),
		'SV' => __( '&#536;tefan Vod&#259;', 'invoicing' ),
		'TR' => __( 'Taraclia', 'invoicing' ),
		'TL' => __( 'Telene&#537;ti', 'invoicing' ),
		'UN' => __( 'Ungheni', 'invoicing' ),
	),
	'MQ' => array(),
	'MT' => array(),
	'MX' => array( // Mexico States.
		'DF' => __( 'Ciudad de M&eacute;xico', 'invoicing' ),
		'JA' => __( 'Jalisco', 'invoicing' ),
		'NL' => __( 'Nuevo Le&oacute;n', 'invoicing' ),
		'AG' => __( 'Aguascalientes', 'invoicing' ),
		'BC' => __( 'Baja California', 'invoicing' ),
		'BS' => __( 'Baja California Sur', 'invoicing' ),
		'CM' => __( 'Campeche', 'invoicing' ),
		'CS' => __( 'Chiapas', 'invoicing' ),
		'CH' => __( 'Chihuahua', 'invoicing' ),
		'CO' => __( 'Coahuila', 'invoicing' ),
		'CL' => __( 'Colima', 'invoicing' ),
		'DG' => __( 'Durango', 'invoicing' ),
		'GT' => __( 'Guanajuato', 'invoicing' ),
		'GR' => __( 'Guerrero', 'invoicing' ),
		'HG' => __( 'Hidalgo', 'invoicing' ),
		'MX' => __( 'Estado de M&eacute;xico', 'invoicing' ),
		'MI' => __( 'Michoac&aacute;n', 'invoicing' ),
		'MO' => __( 'Morelos', 'invoicing' ),
		'NA' => __( 'Nayarit', 'invoicing' ),
		'OA' => __( 'Oaxaca', 'invoicing' ),
		'PU' => __( 'Puebla', 'invoicing' ),
		'QT' => __( 'Quer&eacute;taro', 'invoicing' ),
		'QR' => __( 'Quintana Roo', 'invoicing' ),
		'SL' => __( 'San Luis Potos&iacute;', 'invoicing' ),
		'SI' => __( 'Sinaloa', 'invoicing' ),
		'SO' => __( 'Sonora', 'invoicing' ),
		'TB' => __( 'Tabasco', 'invoicing' ),
		'TM' => __( 'Tamaulipas', 'invoicing' ),
		'TL' => __( 'Tlaxcala', 'invoicing' ),
		'VE' => __( 'Veracruz', 'invoicing' ),
		'YU' => __( 'Yucat&aacute;n', 'invoicing' ),
		'ZA' => __( 'Zacatecas', 'invoicing' ),
	),
	'MY' => array( // Malaysian states.
		'JHR' => __( 'Johor', 'invoicing' ),
		'KDH' => __( 'Kedah', 'invoicing' ),
		'KTN' => __( 'Kelantan', 'invoicing' ),
		'LBN' => __( 'Labuan', 'invoicing' ),
		'MLK' => __( 'Malacca (Melaka)', 'invoicing' ),
		'NSN' => __( 'Negeri Sembilan', 'invoicing' ),
		'PHG' => __( 'Pahang', 'invoicing' ),
		'PNG' => __( 'Penang (Pulau Pinang)', 'invoicing' ),
		'PRK' => __( 'Perak', 'invoicing' ),
		'PLS' => __( 'Perlis', 'invoicing' ),
		'SBH' => __( 'Sabah', 'invoicing' ),
		'SWK' => __( 'Sarawak', 'invoicing' ),
		'SGR' => __( 'Selangor', 'invoicing' ),
		'TRG' => __( 'Terengganu', 'invoicing' ),
		'PJY' => __( 'Putrajaya', 'invoicing' ),
		'KUL' => __( 'Kuala Lumpur', 'invoicing' ),
	),
	'NG' => array( // Nigerian provinces.
		'AB' => __( 'Abia', 'invoicing' ),
		'FC' => __( 'Abuja', 'invoicing' ),
		'AD' => __( 'Adamawa', 'invoicing' ),
		'AK' => __( 'Akwa Ibom', 'invoicing' ),
		'AN' => __( 'Anambra', 'invoicing' ),
		'BA' => __( 'Bauchi', 'invoicing' ),
		'BY' => __( 'Bayelsa', 'invoicing' ),
		'BE' => __( 'Benue', 'invoicing' ),
		'BO' => __( 'Borno', 'invoicing' ),
		'CR' => __( 'Cross River', 'invoicing' ),
		'DE' => __( 'Delta', 'invoicing' ),
		'EB' => __( 'Ebonyi', 'invoicing' ),
		'ED' => __( 'Edo', 'invoicing' ),
		'EK' => __( 'Ekiti', 'invoicing' ),
		'EN' => __( 'Enugu', 'invoicing' ),
		'GO' => __( 'Gombe', 'invoicing' ),
		'IM' => __( 'Imo', 'invoicing' ),
		'JI' => __( 'Jigawa', 'invoicing' ),
		'KD' => __( 'Kaduna', 'invoicing' ),
		'KN' => __( 'Kano', 'invoicing' ),
		'KT' => __( 'Katsina', 'invoicing' ),
		'KE' => __( 'Kebbi', 'invoicing' ),
		'KO' => __( 'Kogi', 'invoicing' ),
		'KW' => __( 'Kwara', 'invoicing' ),
		'LA' => __( 'Lagos', 'invoicing' ),
		'NA' => __( 'Nasarawa', 'invoicing' ),
		'NI' => __( 'Niger', 'invoicing' ),
		'OG' => __( 'Ogun', 'invoicing' ),
		'ON' => __( 'Ondo', 'invoicing' ),
		'OS' => __( 'Osun', 'invoicing' ),
		'OY' => __( 'Oyo', 'invoicing' ),
		'PL' => __( 'Plateau', 'invoicing' ),
		'RI' => __( 'Rivers', 'invoicing' ),
		'SO' => __( 'Sokoto', 'invoicing' ),
		'TA' => __( 'Taraba', 'invoicing' ),
		'YO' => __( 'Yobe', 'invoicing' ),
		'ZA' => __( 'Zamfara', 'invoicing' ),
	),
	'NL' => array(),
	'NO' => array(),
	'NP' => array( // Nepal states (Zones).
		'BAG' => __( 'Bagmati', 'invoicing' ),
		'BHE' => __( 'Bheri', 'invoicing' ),
		'DHA' => __( 'Dhaulagiri', 'invoicing' ),
		'GAN' => __( 'Gandaki', 'invoicing' ),
		'JAN' => __( 'Janakpur', 'invoicing' ),
		'KAR' => __( 'Karnali', 'invoicing' ),
		'KOS' => __( 'Koshi', 'invoicing' ),
		'LUM' => __( 'Lumbini', 'invoicing' ),
		'MAH' => __( 'Mahakali', 'invoicing' ),
		'MEC' => __( 'Mechi', 'invoicing' ),
		'NAR' => __( 'Narayani', 'invoicing' ),
		'RAP' => __( 'Rapti', 'invoicing' ),
		'SAG' => __( 'Sagarmatha', 'invoicing' ),
		'SET' => __( 'Seti', 'invoicing' ),
	),
	'NZ' => array( // New Zealand States.
		'NL' => __( 'Northland', 'invoicing' ),
		'AK' => __( 'Auckland', 'invoicing' ),
		'WA' => __( 'Waikato', 'invoicing' ),
		'BP' => __( 'Bay of Plenty', 'invoicing' ),
		'TK' => __( 'Taranaki', 'invoicing' ),
		'GI' => __( 'Gisborne', 'invoicing' ),
		'HB' => __( 'Hawke&rsquo;s Bay', 'invoicing' ),
		'MW' => __( 'Manawatu-Wanganui', 'invoicing' ),
		'WE' => __( 'Wellington', 'invoicing' ),
		'NS' => __( 'Nelson', 'invoicing' ),
		'MB' => __( 'Marlborough', 'invoicing' ),
		'TM' => __( 'Tasman', 'invoicing' ),
		'WC' => __( 'West Coast', 'invoicing' ),
		'CT' => __( 'Canterbury', 'invoicing' ),
		'OT' => __( 'Otago', 'invoicing' ),
		'SL' => __( 'Southland', 'invoicing' ),
	),
	'PE' => array( // Peru states.
		'CAL' => __( 'El Callao', 'invoicing' ),
		'LMA' => __( 'Municipalidad Metropolitana de Lima', 'invoicing' ),
		'AMA' => __( 'Amazonas', 'invoicing' ),
		'ANC' => __( 'Ancash', 'invoicing' ),
		'APU' => __( 'Apur&iacute;mac', 'invoicing' ),
		'ARE' => __( 'Arequipa', 'invoicing' ),
		'AYA' => __( 'Ayacucho', 'invoicing' ),
		'CAJ' => __( 'Cajamarca', 'invoicing' ),
		'CUS' => __( 'Cusco', 'invoicing' ),
		'HUV' => __( 'Huancavelica', 'invoicing' ),
		'HUC' => __( 'Hu&aacute;nuco', 'invoicing' ),
		'ICA' => __( 'Ica', 'invoicing' ),
		'JUN' => __( 'Jun&iacute;n', 'invoicing' ),
		'LAL' => __( 'La Libertad', 'invoicing' ),
		'LAM' => __( 'Lambayeque', 'invoicing' ),
		'LIM' => __( 'Lima', 'invoicing' ),
		'LOR' => __( 'Loreto', 'invoicing' ),
		'MDD' => __( 'Madre de Dios', 'invoicing' ),
		'MOQ' => __( 'Moquegua', 'invoicing' ),
		'PAS' => __( 'Pasco', 'invoicing' ),
		'PIU' => __( 'Piura', 'invoicing' ),
		'PUN' => __( 'Puno', 'invoicing' ),
		'SAM' => __( 'San Mart&iacute;n', 'invoicing' ),
		'TAC' => __( 'Tacna', 'invoicing' ),
		'TUM' => __( 'Tumbes', 'invoicing' ),
		'UCA' => __( 'Ucayali', 'invoicing' ),
	),

	/**
	 * Philippine Provinces.
	 */
	'PH' => array(
		'ABR' => __( 'Abra', 'invoicing' ),
		'AGN' => __( 'Agusan del Norte', 'invoicing' ),
		'AGS' => __( 'Agusan del Sur', 'invoicing' ),
		'AKL' => __( 'Aklan', 'invoicing' ),
		'ALB' => __( 'Albay', 'invoicing' ),
		'ANT' => __( 'Antique', 'invoicing' ),
		'APA' => __( 'Apayao', 'invoicing' ),
		'AUR' => __( 'Aurora', 'invoicing' ),
		'BAS' => __( 'Basilan', 'invoicing' ),
		'BAN' => __( 'Bataan', 'invoicing' ),
		'BTN' => __( 'Batanes', 'invoicing' ),
		'BTG' => __( 'Batangas', 'invoicing' ),
		'BEN' => __( 'Benguet', 'invoicing' ),
		'BIL' => __( 'Biliran', 'invoicing' ),
		'BOH' => __( 'Bohol', 'invoicing' ),
		'BUK' => __( 'Bukidnon', 'invoicing' ),
		'BUL' => __( 'Bulacan', 'invoicing' ),
		'CAG' => __( 'Cagayan', 'invoicing' ),
		'CAN' => __( 'Camarines Norte', 'invoicing' ),
		'CAS' => __( 'Camarines Sur', 'invoicing' ),
		'CAM' => __( 'Camiguin', 'invoicing' ),
		'CAP' => __( 'Capiz', 'invoicing' ),
		'CAT' => __( 'Catanduanes', 'invoicing' ),
		'CAV' => __( 'Cavite', 'invoicing' ),
		'CEB' => __( 'Cebu', 'invoicing' ),
		'COM' => __( 'Compostela Valley', 'invoicing' ),
		'NCO' => __( 'Cotabato', 'invoicing' ),
		'DAV' => __( 'Davao del Norte', 'invoicing' ),
		'DAS' => __( 'Davao del Sur', 'invoicing' ),
		'DAC' => __( 'Davao Occidental', 'invoicing' ),
		'DAO' => __( 'Davao Oriental', 'invoicing' ),
		'DIN' => __( 'Dinagat Islands', 'invoicing' ),
		'EAS' => __( 'Eastern Samar', 'invoicing' ),
		'GUI' => __( 'Guimaras', 'invoicing' ),
		'IFU' => __( 'Ifugao', 'invoicing' ),
		'ILN' => __( 'Ilocos Norte', 'invoicing' ),
		'ILS' => __( 'Ilocos Sur', 'invoicing' ),
		'ILI' => __( 'Iloilo', 'invoicing' ),
		'ISA' => __( 'Isabela', 'invoicing' ),
		'KAL' => __( 'Kalinga', 'invoicing' ),
		'LUN' => __( 'La Union', 'invoicing' ),
		'LAG' => __( 'Laguna', 'invoicing' ),
		'LAN' => __( 'Lanao del Norte', 'invoicing' ),
		'LAS' => __( 'Lanao del Sur', 'invoicing' ),
		'LEY' => __( 'Leyte', 'invoicing' ),
		'MAG' => __( 'Maguindanao', 'invoicing' ),
		'MAD' => __( 'Marinduque', 'invoicing' ),
		'MAS' => __( 'Masbate', 'invoicing' ),
		'MSC' => __( 'Misamis Occidental', 'invoicing' ),
		'MSR' => __( 'Misamis Oriental', 'invoicing' ),
		'MOU' => __( 'Mountain Province', 'invoicing' ),
		'NEC' => __( 'Negros Occidental', 'invoicing' ),
		'NER' => __( 'Negros Oriental', 'invoicing' ),
		'NSA' => __( 'Northern Samar', 'invoicing' ),
		'NUE' => __( 'Nueva Ecija', 'invoicing' ),
		'NUV' => __( 'Nueva Vizcaya', 'invoicing' ),
		'MDC' => __( 'Occidental Mindoro', 'invoicing' ),
		'MDR' => __( 'Oriental Mindoro', 'invoicing' ),
		'PLW' => __( 'Palawan', 'invoicing' ),
		'PAM' => __( 'Pampanga', 'invoicing' ),
		'PAN' => __( 'Pangasinan', 'invoicing' ),
		'QUE' => __( 'Quezon', 'invoicing' ),
		'QUI' => __( 'Quirino', 'invoicing' ),
		'RIZ' => __( 'Rizal', 'invoicing' ),
		'ROM' => __( 'Romblon', 'invoicing' ),
		'WSA' => __( 'Samar', 'invoicing' ),
		'SAR' => __( 'Sarangani', 'invoicing' ),
		'SIQ' => __( 'Siquijor', 'invoicing' ),
		'SOR' => __( 'Sorsogon', 'invoicing' ),
		'SCO' => __( 'South Cotabato', 'invoicing' ),
		'SLE' => __( 'Southern Leyte', 'invoicing' ),
		'SUK' => __( 'Sultan Kudarat', 'invoicing' ),
		'SLU' => __( 'Sulu', 'invoicing' ),
		'SUN' => __( 'Surigao del Norte', 'invoicing' ),
		'SUR' => __( 'Surigao del Sur', 'invoicing' ),
		'TAR' => __( 'Tarlac', 'invoicing' ),
		'TAW' => __( 'Tawi-Tawi', 'invoicing' ),
		'ZMB' => __( 'Zambales', 'invoicing' ),
		'ZAN' => __( 'Zamboanga del Norte', 'invoicing' ),
		'ZAS' => __( 'Zamboanga del Sur', 'invoicing' ),
		'ZSI' => __( 'Zamboanga Sibugay', 'invoicing' ),
		'00'  => __( 'Metro Manila', 'invoicing' ),
	),
	'PK' => array( // Pakistan's states.
		'JK' => __( 'Azad Kashmir', 'invoicing' ),
		'BA' => __( 'Balochistan', 'invoicing' ),
		'TA' => __( 'FATA', 'invoicing' ),
		'GB' => __( 'Gilgit Baltistan', 'invoicing' ),
		'IS' => __( 'Islamabad Capital Territory', 'invoicing' ),
		'KP' => __( 'Khyber Pakhtunkhwa', 'invoicing' ),
		'PB' => __( 'Punjab', 'invoicing' ),
		'SD' => __( 'Sindh', 'invoicing' ),
	),
	'PL' => array(),
	'PT' => array(),
	'PY' => array( // Paraguay states.
		'PY-ASU' => __( 'Asunci&oacute;n', 'invoicing' ),
		'PY-1'   => __( 'Concepci&oacute;n', 'invoicing' ),
		'PY-2'   => __( 'San Pedro', 'invoicing' ),
		'PY-3'   => __( 'Cordillera', 'invoicing' ),
		'PY-4'   => __( 'Guair&aacute;', 'invoicing' ),
		'PY-5'   => __( 'Caaguaz&uacute;', 'invoicing' ),
		'PY-6'   => __( 'Caazap&aacute;', 'invoicing' ),
		'PY-7'   => __( 'Itap&uacute;a', 'invoicing' ),
		'PY-8'   => __( 'Misiones', 'invoicing' ),
		'PY-9'   => __( 'Paraguar&iacute;', 'invoicing' ),
		'PY-10'  => __( 'Alto Paran&aacute;', 'invoicing' ),
		'PY-11'  => __( 'Central', 'invoicing' ),
		'PY-12'  => __( '&Ntilde;eembuc&uacute;', 'invoicing' ),
		'PY-13'  => __( 'Amambay', 'invoicing' ),
		'PY-14'  => __( 'Canindey&uacute;', 'invoicing' ),
		'PY-15'  => __( 'Presidente Hayes', 'invoicing' ),
		'PY-16'  => __( 'Alto Paraguay', 'invoicing' ),
		'PY-17'  => __( 'Boquer&oacute;n', 'invoicing' ),
	),
	'RE' => array(),
	'RO' => array( // Romania states.
		'AB' => __( 'Alba', 'invoicing' ),
		'AR' => __( 'Arad', 'invoicing' ),
		'AG' => __( 'Arge&#537;', 'invoicing' ),
		'BC' => __( 'Bac&#259;u', 'invoicing' ),
		'BH' => __( 'Bihor', 'invoicing' ),
		'BN' => __( 'Bistri&#539;a-N&#259;s&#259;ud', 'invoicing' ),
		'BT' => __( 'Boto&#537;ani', 'invoicing' ),
		'BR' => __( 'Br&#259;ila', 'invoicing' ),
		'BV' => __( 'Bra&#537;ov', 'invoicing' ),
		'B'  => __( 'Bucure&#537;ti', 'invoicing' ),
		'BZ' => __( 'Buz&#259;u', 'invoicing' ),
		'CL' => __( 'C&#259;l&#259;ra&#537;i', 'invoicing' ),
		'CS' => __( 'Cara&#537;-Severin', 'invoicing' ),
		'CJ' => __( 'Cluj', 'invoicing' ),
		'CT' => __( 'Constan&#539;a', 'invoicing' ),
		'CV' => __( 'Covasna', 'invoicing' ),
		'DB' => __( 'D&acirc;mbovi&#539;a', 'invoicing' ),
		'DJ' => __( 'Dolj', 'invoicing' ),
		'GL' => __( 'Gala&#539;i', 'invoicing' ),
		'GR' => __( 'Giurgiu', 'invoicing' ),
		'GJ' => __( 'Gorj', 'invoicing' ),
		'HR' => __( 'Harghita', 'invoicing' ),
		'HD' => __( 'Hunedoara', 'invoicing' ),
		'IL' => __( 'Ialomi&#539;a', 'invoicing' ),
		'IS' => __( 'Ia&#537;i', 'invoicing' ),
		'IF' => __( 'Ilfov', 'invoicing' ),
		'MM' => __( 'Maramure&#537;', 'invoicing' ),
		'MH' => __( 'Mehedin&#539;i', 'invoicing' ),
		'MS' => __( 'Mure&#537;', 'invoicing' ),
		'NT' => __( 'Neam&#539;', 'invoicing' ),
		'OT' => __( 'Olt', 'invoicing' ),
		'PH' => __( 'Prahova', 'invoicing' ),
		'SJ' => __( 'S&#259;laj', 'invoicing' ),
		'SM' => __( 'Satu Mare', 'invoicing' ),
		'SB' => __( 'Sibiu', 'invoicing' ),
		'SV' => __( 'Suceava', 'invoicing' ),
		'TR' => __( 'Teleorman', 'invoicing' ),
		'TM' => __( 'Timi&#537;', 'invoicing' ),
		'TL' => __( 'Tulcea', 'invoicing' ),
		'VL' => __( 'V&acirc;lcea', 'invoicing' ),
		'VS' => __( 'Vaslui', 'invoicing' ),
		'VN' => __( 'Vrancea', 'invoicing' ),
	),
	'RS' => array(),
	'SG' => array(),
	'SK' => array(),
	'SI' => array(),
	'TH' => array( // Thailand states.
		'TH-37' => __( 'Amnat Charoen', 'invoicing' ),
		'TH-15' => __( 'Ang Thong', 'invoicing' ),
		'TH-14' => __( 'Ayutthaya', 'invoicing' ),
		'TH-10' => __( 'Bangkok', 'invoicing' ),
		'TH-38' => __( 'Bueng Kan', 'invoicing' ),
		'TH-31' => __( 'Buri Ram', 'invoicing' ),
		'TH-24' => __( 'Chachoengsao', 'invoicing' ),
		'TH-18' => __( 'Chai Nat', 'invoicing' ),
		'TH-36' => __( 'Chaiyaphum', 'invoicing' ),
		'TH-22' => __( 'Chanthaburi', 'invoicing' ),
		'TH-50' => __( 'Chiang Mai', 'invoicing' ),
		'TH-57' => __( 'Chiang Rai', 'invoicing' ),
		'TH-20' => __( 'Chonburi', 'invoicing' ),
		'TH-86' => __( 'Chumphon', 'invoicing' ),
		'TH-46' => __( 'Kalasin', 'invoicing' ),
		'TH-62' => __( 'Kamphaeng Phet', 'invoicing' ),
		'TH-71' => __( 'Kanchanaburi', 'invoicing' ),
		'TH-40' => __( 'Khon Kaen', 'invoicing' ),
		'TH-81' => __( 'Krabi', 'invoicing' ),
		'TH-52' => __( 'Lampang', 'invoicing' ),
		'TH-51' => __( 'Lamphun', 'invoicing' ),
		'TH-42' => __( 'Loei', 'invoicing' ),
		'TH-16' => __( 'Lopburi', 'invoicing' ),
		'TH-58' => __( 'Mae Hong Son', 'invoicing' ),
		'TH-44' => __( 'Maha Sarakham', 'invoicing' ),
		'TH-49' => __( 'Mukdahan', 'invoicing' ),
		'TH-26' => __( 'Nakhon Nayok', 'invoicing' ),
		'TH-73' => __( 'Nakhon Pathom', 'invoicing' ),
		'TH-48' => __( 'Nakhon Phanom', 'invoicing' ),
		'TH-30' => __( 'Nakhon Ratchasima', 'invoicing' ),
		'TH-60' => __( 'Nakhon Sawan', 'invoicing' ),
		'TH-80' => __( 'Nakhon Si Thammarat', 'invoicing' ),
		'TH-55' => __( 'Nan', 'invoicing' ),
		'TH-96' => __( 'Narathiwat', 'invoicing' ),
		'TH-39' => __( 'Nong Bua Lam Phu', 'invoicing' ),
		'TH-43' => __( 'Nong Khai', 'invoicing' ),
		'TH-12' => __( 'Nonthaburi', 'invoicing' ),
		'TH-13' => __( 'Pathum Thani', 'invoicing' ),
		'TH-94' => __( 'Pattani', 'invoicing' ),
		'TH-82' => __( 'Phang Nga', 'invoicing' ),
		'TH-93' => __( 'Phatthalung', 'invoicing' ),
		'TH-56' => __( 'Phayao', 'invoicing' ),
		'TH-67' => __( 'Phetchabun', 'invoicing' ),
		'TH-76' => __( 'Phetchaburi', 'invoicing' ),
		'TH-66' => __( 'Phichit', 'invoicing' ),
		'TH-65' => __( 'Phitsanulok', 'invoicing' ),
		'TH-54' => __( 'Phrae', 'invoicing' ),
		'TH-83' => __( 'Phuket', 'invoicing' ),
		'TH-25' => __( 'Prachin Buri', 'invoicing' ),
		'TH-77' => __( 'Prachuap Khiri Khan', 'invoicing' ),
		'TH-85' => __( 'Ranong', 'invoicing' ),
		'TH-70' => __( 'Ratchaburi', 'invoicing' ),
		'TH-21' => __( 'Rayong', 'invoicing' ),
		'TH-45' => __( 'Roi Et', 'invoicing' ),
		'TH-27' => __( 'Sa Kaeo', 'invoicing' ),
		'TH-47' => __( 'Sakon Nakhon', 'invoicing' ),
		'TH-11' => __( 'Samut Prakan', 'invoicing' ),
		'TH-74' => __( 'Samut Sakhon', 'invoicing' ),
		'TH-75' => __( 'Samut Songkhram', 'invoicing' ),
		'TH-19' => __( 'Saraburi', 'invoicing' ),
		'TH-91' => __( 'Satun', 'invoicing' ),
		'TH-17' => __( 'Sing Buri', 'invoicing' ),
		'TH-33' => __( 'Sisaket', 'invoicing' ),
		'TH-90' => __( 'Songkhla', 'invoicing' ),
		'TH-64' => __( 'Sukhothai', 'invoicing' ),
		'TH-72' => __( 'Suphan Buri', 'invoicing' ),
		'TH-84' => __( 'Surat Thani', 'invoicing' ),
		'TH-32' => __( 'Surin', 'invoicing' ),
		'TH-63' => __( 'Tak', 'invoicing' ),
		'TH-92' => __( 'Trang', 'invoicing' ),
		'TH-23' => __( 'Trat', 'invoicing' ),
		'TH-34' => __( 'Ubon Ratchathani', 'invoicing' ),
		'TH-41' => __( 'Udon Thani', 'invoicing' ),
		'TH-61' => __( 'Uthai Thani', 'invoicing' ),
		'TH-53' => __( 'Uttaradit', 'invoicing' ),
		'TH-95' => __( 'Yala', 'invoicing' ),
		'TH-35' => __( 'Yasothon', 'invoicing' ),
	),
	'TR' => array( // Turkey States.
		'TR01' => __( 'Adana', 'invoicing' ),
		'TR02' => __( 'Ad&#305;yaman', 'invoicing' ),
		'TR03' => __( 'Afyon', 'invoicing' ),
		'TR04' => __( 'A&#287;r&#305;', 'invoicing' ),
		'TR05' => __( 'Amasya', 'invoicing' ),
		'TR06' => __( 'Ankara', 'invoicing' ),
		'TR07' => __( 'Antalya', 'invoicing' ),
		'TR08' => __( 'Artvin', 'invoicing' ),
		'TR09' => __( 'Ayd&#305;n', 'invoicing' ),
		'TR10' => __( 'Bal&#305;kesir', 'invoicing' ),
		'TR11' => __( 'Bilecik', 'invoicing' ),
		'TR12' => __( 'Bing&#246;l', 'invoicing' ),
		'TR13' => __( 'Bitlis', 'invoicing' ),
		'TR14' => __( 'Bolu', 'invoicing' ),
		'TR15' => __( 'Burdur', 'invoicing' ),
		'TR16' => __( 'Bursa', 'invoicing' ),
		'TR17' => __( '&#199;anakkale', 'invoicing' ),
		'TR18' => __( '&#199;ank&#305;r&#305;', 'invoicing' ),
		'TR19' => __( '&#199;orum', 'invoicing' ),
		'TR20' => __( 'Denizli', 'invoicing' ),
		'TR21' => __( 'Diyarbak&#305;r', 'invoicing' ),
		'TR22' => __( 'Edirne', 'invoicing' ),
		'TR23' => __( 'Elaz&#305;&#287;', 'invoicing' ),
		'TR24' => __( 'Erzincan', 'invoicing' ),
		'TR25' => __( 'Erzurum', 'invoicing' ),
		'TR26' => __( 'Eski&#351;ehir', 'invoicing' ),
		'TR27' => __( 'Gaziantep', 'invoicing' ),
		'TR28' => __( 'Giresun', 'invoicing' ),
		'TR29' => __( 'G&#252;m&#252;&#351;hane', 'invoicing' ),
		'TR30' => __( 'Hakkari', 'invoicing' ),
		'TR31' => __( 'Hatay', 'invoicing' ),
		'TR32' => __( 'Isparta', 'invoicing' ),
		'TR33' => __( '&#304;&#231;el', 'invoicing' ),
		'TR34' => __( '&#304;stanbul', 'invoicing' ),
		'TR35' => __( '&#304;zmir', 'invoicing' ),
		'TR36' => __( 'Kars', 'invoicing' ),
		'TR37' => __( 'Kastamonu', 'invoicing' ),
		'TR38' => __( 'Kayseri', 'invoicing' ),
		'TR39' => __( 'K&#305;rklareli', 'invoicing' ),
		'TR40' => __( 'K&#305;r&#351;ehir', 'invoicing' ),
		'TR41' => __( 'Kocaeli', 'invoicing' ),
		'TR42' => __( 'Konya', 'invoicing' ),
		'TR43' => __( 'K&#252;tahya', 'invoicing' ),
		'TR44' => __( 'Malatya', 'invoicing' ),
		'TR45' => __( 'Manisa', 'invoicing' ),
		'TR46' => __( 'Kahramanmara&#351;', 'invoicing' ),
		'TR47' => __( 'Mardin', 'invoicing' ),
		'TR48' => __( 'Mu&#287;la', 'invoicing' ),
		'TR49' => __( 'Mu&#351;', 'invoicing' ),
		'TR50' => __( 'Nev&#351;ehir', 'invoicing' ),
		'TR51' => __( 'Ni&#287;de', 'invoicing' ),
		'TR52' => __( 'Ordu', 'invoicing' ),
		'TR53' => __( 'Rize', 'invoicing' ),
		'TR54' => __( 'Sakarya', 'invoicing' ),
		'TR55' => __( 'Samsun', 'invoicing' ),
		'TR56' => __( 'Siirt', 'invoicing' ),
		'TR57' => __( 'Sinop', 'invoicing' ),
		'TR58' => __( 'Sivas', 'invoicing' ),
		'TR59' => __( 'Tekirda&#287;', 'invoicing' ),
		'TR60' => __( 'Tokat', 'invoicing' ),
		'TR61' => __( 'Trabzon', 'invoicing' ),
		'TR62' => __( 'Tunceli', 'invoicing' ),
		'TR63' => __( '&#350;anl&#305;urfa', 'invoicing' ),
		'TR64' => __( 'U&#351;ak', 'invoicing' ),
		'TR65' => __( 'Van', 'invoicing' ),
		'TR66' => __( 'Yozgat', 'invoicing' ),
		'TR67' => __( 'Zonguldak', 'invoicing' ),
		'TR68' => __( 'Aksaray', 'invoicing' ),
		'TR69' => __( 'Bayburt', 'invoicing' ),
		'TR70' => __( 'Karaman', 'invoicing' ),
		'TR71' => __( 'K&#305;r&#305;kkale', 'invoicing' ),
		'TR72' => __( 'Batman', 'invoicing' ),
		'TR73' => __( '&#350;&#305;rnak', 'invoicing' ),
		'TR74' => __( 'Bart&#305;n', 'invoicing' ),
		'TR75' => __( 'Ardahan', 'invoicing' ),
		'TR76' => __( 'I&#287;d&#305;r', 'invoicing' ),
		'TR77' => __( 'Yalova', 'invoicing' ),
		'TR78' => __( 'Karab&#252;k', 'invoicing' ),
		'TR79' => __( 'Kilis', 'invoicing' ),
		'TR80' => __( 'Osmaniye', 'invoicing' ),
		'TR81' => __( 'D&#252;zce', 'invoicing' ),
	),
	'TZ' => array( // Tanzania States.
		'TZ01' => __( 'Arusha', 'invoicing' ),
		'TZ02' => __( 'Dar es Salaam', 'invoicing' ),
		'TZ03' => __( 'Dodoma', 'invoicing' ),
		'TZ04' => __( 'Iringa', 'invoicing' ),
		'TZ05' => __( 'Kagera', 'invoicing' ),
		'TZ06' => __( 'Pemba North', 'invoicing' ),
		'TZ07' => __( 'Zanzibar North', 'invoicing' ),
		'TZ08' => __( 'Kigoma', 'invoicing' ),
		'TZ09' => __( 'Kilimanjaro', 'invoicing' ),
		'TZ10' => __( 'Pemba South', 'invoicing' ),
		'TZ11' => __( 'Zanzibar South', 'invoicing' ),
		'TZ12' => __( 'Lindi', 'invoicing' ),
		'TZ13' => __( 'Mara', 'invoicing' ),
		'TZ14' => __( 'Mbeya', 'invoicing' ),
		'TZ15' => __( 'Zanzibar West', 'invoicing' ),
		'TZ16' => __( 'Morogoro', 'invoicing' ),
		'TZ17' => __( 'Mtwara', 'invoicing' ),
		'TZ18' => __( 'Mwanza', 'invoicing' ),
		'TZ19' => __( 'Coast', 'invoicing' ),
		'TZ20' => __( 'Rukwa', 'invoicing' ),
		'TZ21' => __( 'Ruvuma', 'invoicing' ),
		'TZ22' => __( 'Shinyanga', 'invoicing' ),
		'TZ23' => __( 'Singida', 'invoicing' ),
		'TZ24' => __( 'Tabora', 'invoicing' ),
		'TZ25' => __( 'Tanga', 'invoicing' ),
		'TZ26' => __( 'Manyara', 'invoicing' ),
		'TZ27' => __( 'Geita', 'invoicing' ),
		'TZ28' => __( 'Katavi', 'invoicing' ),
		'TZ29' => __( 'Njombe', 'invoicing' ),
		'TZ30' => __( 'Simiyu', 'invoicing' ),
	),
	'LK' => array(),
	'SE' => array(),
	'UG' => array( // Uganda districts. Ref: https://en.wikipedia.org/wiki/ISO_3166-2:UG.
		'UG314' => __( 'Abim', 'invoicing' ),
		'UG301' => __( 'Adjumani', 'invoicing' ),
		'UG322' => __( 'Agago', 'invoicing' ),
		'UG323' => __( 'Alebtong', 'invoicing' ),
		'UG315' => __( 'Amolatar', 'invoicing' ),
		'UG324' => __( 'Amudat', 'invoicing' ),
		'UG216' => __( 'Amuria', 'invoicing' ),
		'UG316' => __( 'Amuru', 'invoicing' ),
		'UG302' => __( 'Apac', 'invoicing' ),
		'UG303' => __( 'Arua', 'invoicing' ),
		'UG217' => __( 'Budaka', 'invoicing' ),
		'UG218' => __( 'Bududa', 'invoicing' ),
		'UG201' => __( 'Bugiri', 'invoicing' ),
		'UG235' => __( 'Bugweri', 'invoicing' ),
		'UG420' => __( 'Buhweju', 'invoicing' ),
		'UG117' => __( 'Buikwe', 'invoicing' ),
		'UG219' => __( 'Bukedea', 'invoicing' ),
		'UG118' => __( 'Bukomansimbi', 'invoicing' ),
		'UG220' => __( 'Bukwa', 'invoicing' ),
		'UG225' => __( 'Bulambuli', 'invoicing' ),
		'UG416' => __( 'Buliisa', 'invoicing' ),
		'UG401' => __( 'Bundibugyo', 'invoicing' ),
		'UG430' => __( 'Bunyangabu', 'invoicing' ),
		'UG402' => __( 'Bushenyi', 'invoicing' ),
		'UG202' => __( 'Busia', 'invoicing' ),
		'UG221' => __( 'Butaleja', 'invoicing' ),
		'UG119' => __( 'Butambala', 'invoicing' ),
		'UG233' => __( 'Butebo', 'invoicing' ),
		'UG120' => __( 'Buvuma', 'invoicing' ),
		'UG226' => __( 'Buyende', 'invoicing' ),
		'UG317' => __( 'Dokolo', 'invoicing' ),
		'UG121' => __( 'Gomba', 'invoicing' ),
		'UG304' => __( 'Gulu', 'invoicing' ),
		'UG403' => __( 'Hoima', 'invoicing' ),
		'UG417' => __( 'Ibanda', 'invoicing' ),
		'UG203' => __( 'Iganga', 'invoicing' ),
		'UG418' => __( 'Isingiro', 'invoicing' ),
		'UG204' => __( 'Jinja', 'invoicing' ),
		'UG318' => __( 'Kaabong', 'invoicing' ),
		'UG404' => __( 'Kabale', 'invoicing' ),
		'UG405' => __( 'Kabarole', 'invoicing' ),
		'UG213' => __( 'Kaberamaido', 'invoicing' ),
		'UG427' => __( 'Kagadi', 'invoicing' ),
		'UG428' => __( 'Kakumiro', 'invoicing' ),
		'UG101' => __( 'Kalangala', 'invoicing' ),
		'UG222' => __( 'Kaliro', 'invoicing' ),
		'UG122' => __( 'Kalungu', 'invoicing' ),
		'UG102' => __( 'Kampala', 'invoicing' ),
		'UG205' => __( 'Kamuli', 'invoicing' ),
		'UG413' => __( 'Kamwenge', 'invoicing' ),
		'UG414' => __( 'Kanungu', 'invoicing' ),
		'UG206' => __( 'Kapchorwa', 'invoicing' ),
		'UG236' => __( 'Kapelebyong', 'invoicing' ),
		'UG126' => __( 'Kasanda', 'invoicing' ),
		'UG406' => __( 'Kasese', 'invoicing' ),
		'UG207' => __( 'Katakwi', 'invoicing' ),
		'UG112' => __( 'Kayunga', 'invoicing' ),
		'UG407' => __( 'Kibaale', 'invoicing' ),
		'UG103' => __( 'Kiboga', 'invoicing' ),
		'UG227' => __( 'Kibuku', 'invoicing' ),
		'UG432' => __( 'Kikuube', 'invoicing' ),
		'UG419' => __( 'Kiruhura', 'invoicing' ),
		'UG421' => __( 'Kiryandongo', 'invoicing' ),
		'UG408' => __( 'Kisoro', 'invoicing' ),
		'UG305' => __( 'Kitgum', 'invoicing' ),
		'UG319' => __( 'Koboko', 'invoicing' ),
		'UG325' => __( 'Kole', 'invoicing' ),
		'UG306' => __( 'Kotido', 'invoicing' ),
		'UG208' => __( 'Kumi', 'invoicing' ),
		'UG333' => __( 'Kwania', 'invoicing' ),
		'UG228' => __( 'Kween', 'invoicing' ),
		'UG123' => __( 'Kyankwanzi', 'invoicing' ),
		'UG422' => __( 'Kyegegwa', 'invoicing' ),
		'UG415' => __( 'Kyenjojo', 'invoicing' ),
		'UG125' => __( 'Kyotera', 'invoicing' ),
		'UG326' => __( 'Lamwo', 'invoicing' ),
		'UG307' => __( 'Lira', 'invoicing' ),
		'UG229' => __( 'Luuka', 'invoicing' ),
		'UG104' => __( 'Luwero', 'invoicing' ),
		'UG124' => __( 'Lwengo', 'invoicing' ),
		'UG114' => __( 'Lyantonde', 'invoicing' ),
		'UG223' => __( 'Manafwa', 'invoicing' ),
		'UG320' => __( 'Maracha', 'invoicing' ),
		'UG105' => __( 'Masaka', 'invoicing' ),
		'UG409' => __( 'Masindi', 'invoicing' ),
		'UG214' => __( 'Mayuge', 'invoicing' ),
		'UG209' => __( 'Mbale', 'invoicing' ),
		'UG410' => __( 'Mbarara', 'invoicing' ),
		'UG423' => __( 'Mitooma', 'invoicing' ),
		'UG115' => __( 'Mityana', 'invoicing' ),
		'UG308' => __( 'Moroto', 'invoicing' ),
		'UG309' => __( 'Moyo', 'invoicing' ),
		'UG106' => __( 'Mpigi', 'invoicing' ),
		'UG107' => __( 'Mubende', 'invoicing' ),
		'UG108' => __( 'Mukono', 'invoicing' ),
		'UG334' => __( 'Nabilatuk', 'invoicing' ),
		'UG311' => __( 'Nakapiripirit', 'invoicing' ),
		'UG116' => __( 'Nakaseke', 'invoicing' ),
		'UG109' => __( 'Nakasongola', 'invoicing' ),
		'UG230' => __( 'Namayingo', 'invoicing' ),
		'UG234' => __( 'Namisindwa', 'invoicing' ),
		'UG224' => __( 'Namutumba', 'invoicing' ),
		'UG327' => __( 'Napak', 'invoicing' ),
		'UG310' => __( 'Nebbi', 'invoicing' ),
		'UG231' => __( 'Ngora', 'invoicing' ),
		'UG424' => __( 'Ntoroko', 'invoicing' ),
		'UG411' => __( 'Ntungamo', 'invoicing' ),
		'UG328' => __( 'Nwoya', 'invoicing' ),
		'UG331' => __( 'Omoro', 'invoicing' ),
		'UG329' => __( 'Otuke', 'invoicing' ),
		'UG321' => __( 'Oyam', 'invoicing' ),
		'UG312' => __( 'Pader', 'invoicing' ),
		'UG332' => __( 'Pakwach', 'invoicing' ),
		'UG210' => __( 'Pallisa', 'invoicing' ),
		'UG110' => __( 'Rakai', 'invoicing' ),
		'UG429' => __( 'Rubanda', 'invoicing' ),
		'UG425' => __( 'Rubirizi', 'invoicing' ),
		'UG431' => __( 'Rukiga', 'invoicing' ),
		'UG412' => __( 'Rukungiri', 'invoicing' ),
		'UG111' => __( 'Sembabule', 'invoicing' ),
		'UG232' => __( 'Serere', 'invoicing' ),
		'UG426' => __( 'Sheema', 'invoicing' ),
		'UG215' => __( 'Sironko', 'invoicing' ),
		'UG211' => __( 'Soroti', 'invoicing' ),
		'UG212' => __( 'Tororo', 'invoicing' ),
		'UG113' => __( 'Wakiso', 'invoicing' ),
		'UG313' => __( 'Yumbe', 'invoicing' ),
		'UG330' => __( 'Zombo', 'invoicing' ),
	),
	'UM' => array(
		'81' => __( 'Baker Island', 'invoicing' ),
		'84' => __( 'Howland Island', 'invoicing' ),
		'86' => __( 'Jarvis Island', 'invoicing' ),
		'67' => __( 'Johnston Atoll', 'invoicing' ),
		'89' => __( 'Kingman Reef', 'invoicing' ),
		'71' => __( 'Midway Atoll', 'invoicing' ),
		'76' => __( 'Navassa Island', 'invoicing' ),
		'95' => __( 'Palmyra Atoll', 'invoicing' ),
		'79' => __( 'Wake Island', 'invoicing' ),
	),
	'US' => array( // United States.
		'AL' => __( 'Alabama', 'invoicing' ),
		'AK' => __( 'Alaska', 'invoicing' ),
		'AZ' => __( 'Arizona', 'invoicing' ),
		'AR' => __( 'Arkansas', 'invoicing' ),
		'CA' => __( 'California', 'invoicing' ),
		'CO' => __( 'Colorado', 'invoicing' ),
		'CT' => __( 'Connecticut', 'invoicing' ),
		'DE' => __( 'Delaware', 'invoicing' ),
		'DC' => __( 'District Of Columbia', 'invoicing' ),
		'FL' => __( 'Florida', 'invoicing' ),
		'GA' => _x( 'Georgia', 'US state of Georgia', 'invoicing' ),
		'HI' => __( 'Hawaii', 'invoicing' ),
		'ID' => __( 'Idaho', 'invoicing' ),
		'IL' => __( 'Illinois', 'invoicing' ),
		'IN' => __( 'Indiana', 'invoicing' ),
		'IA' => __( 'Iowa', 'invoicing' ),
		'KS' => __( 'Kansas', 'invoicing' ),
		'KY' => __( 'Kentucky', 'invoicing' ),
		'LA' => __( 'Louisiana', 'invoicing' ),
		'ME' => __( 'Maine', 'invoicing' ),
		'MD' => __( 'Maryland', 'invoicing' ),
		'MA' => __( 'Massachusetts', 'invoicing' ),
		'MI' => __( 'Michigan', 'invoicing' ),
		'MN' => __( 'Minnesota', 'invoicing' ),
		'MS' => __( 'Mississippi', 'invoicing' ),
		'MO' => __( 'Missouri', 'invoicing' ),
		'MT' => __( 'Montana', 'invoicing' ),
		'NE' => __( 'Nebraska', 'invoicing' ),
		'NV' => __( 'Nevada', 'invoicing' ),
		'NH' => __( 'New Hampshire', 'invoicing' ),
		'NJ' => __( 'New Jersey', 'invoicing' ),
		'NM' => __( 'New Mexico', 'invoicing' ),
		'NY' => __( 'New York', 'invoicing' ),
		'NC' => __( 'North Carolina', 'invoicing' ),
		'ND' => __( 'North Dakota', 'invoicing' ),
		'OH' => __( 'Ohio', 'invoicing' ),
		'OK' => __( 'Oklahoma', 'invoicing' ),
		'OR' => __( 'Oregon', 'invoicing' ),
		'PA' => __( 'Pennsylvania', 'invoicing' ),
		'RI' => __( 'Rhode Island', 'invoicing' ),
		'SC' => __( 'South Carolina', 'invoicing' ),
		'SD' => __( 'South Dakota', 'invoicing' ),
		'TN' => __( 'Tennessee', 'invoicing' ),
		'TX' => __( 'Texas', 'invoicing' ),
		'UT' => __( 'Utah', 'invoicing' ),
		'VT' => __( 'Vermont', 'invoicing' ),
		'VA' => __( 'Virginia', 'invoicing' ),
		'WA' => __( 'Washington', 'invoicing' ),
		'WV' => __( 'West Virginia', 'invoicing' ),
		'WI' => __( 'Wisconsin', 'invoicing' ),
		'WY' => __( 'Wyoming', 'invoicing' ),
		'AA' => __( 'Armed Forces (AA)', 'invoicing' ),
		'AE' => __( 'Armed Forces (AE)', 'invoicing' ),
		'AP' => __( 'Armed Forces (AP)', 'invoicing' ),
	),
	'VN' => array(),
	'YT' => array(),
	'ZA' => array( // South African states.
		'EC'  => __( 'Eastern Cape', 'invoicing' ),
		'FS'  => __( 'Free State', 'invoicing' ),
		'GP'  => __( 'Gauteng', 'invoicing' ),
		'KZN' => __( 'KwaZulu-Natal', 'invoicing' ),
		'LP'  => __( 'Limpopo', 'invoicing' ),
		'MP'  => __( 'Mpumalanga', 'invoicing' ),
		'NC'  => __( 'Northern Cape', 'invoicing' ),
		'NW'  => __( 'North West', 'invoicing' ),
		'WC'  => __( 'Western Cape', 'invoicing' ),
	),
	'ZM' => array( // Zambia's Provinces. Ref: https://en.wikipedia.org/wiki/ISO_3166-2:ZM.
		'ZM-01' => __( 'Western', 'invoicing' ),
		'ZM-02' => __( 'Central', 'invoicing' ),
		'ZM-03' => __( 'Eastern', 'invoicing' ),
		'ZM-04' => __( 'Luapula', 'invoicing' ),
		'ZM-05' => __( 'Northern', 'invoicing' ),
		'ZM-06' => __( 'North-Western', 'invoicing' ),
		'ZM-07' => __( 'Southern', 'invoicing' ),
		'ZM-08' => __( 'Copperbelt', 'invoicing' ),
		'ZM-09' => __( 'Lusaka', 'invoicing' ),
		'ZM-10' => __( 'Muchinga', 'invoicing' ),
	),
);
