import SearchBar from "../SearchBar";

export default function SearchPlaceholder({isSearchResults, searchBoxText}) {
    return (
        <div className={`igd-root-placeholder search-placeholder ${isSearchResults ? 'empty-placeholder' : ''}`}>

            {isSearchResults &&
                <svg
                    width={100}
                    height={100}
                    className={`igd-placeholder-svg`}
                    xmlns="http://www.w3.org/2000/svg"
                    viewBox="0 0 259 223" fill="none">
                    <g clipPath="url(#clip0_1110_10155)">
                        <path
                            d="M127.836 80.9443C127.836 103.828 127.836 126.64 127.836 149.523C127.836 157.696 124.072 161.391 115.905 161.391C81.2469 161.391 46.5181 161.391 11.8603 161.391C3.97712 161.391 0.07102 157.553 0.07102 149.665C0.07102 116.264 0.14204 82.8631 0 49.462C0 46.4062 1.0653 46.0509 3.62202 46.1219C12.4995 46.2641 21.377 46.193 30.2545 46.193C40.4104 46.193 46.092 40.4367 46.163 30.4164C46.163 21.3199 46.234 12.1524 46.092 3.05595C46.092 0.923972 46.3761 0.000114277 48.8618 0.0711803C71.5882 0.213312 94.3146 0.142246 117.041 0.142246C123.788 0.142246 127.836 4.19301 127.836 11.0153C127.907 34.2539 127.836 57.6346 127.836 80.9443ZM65.6935 103.046C76.9147 103.046 88.2069 103.046 99.428 103.046C103.689 103.046 105.891 101.34 105.891 98.2133C105.891 95.2285 103.689 93.4519 99.6411 93.4519C77.2698 93.4519 54.8985 93.4519 32.5272 93.4519C28.479 93.4519 26.2774 95.1575 26.2064 98.1423C26.1354 101.198 28.479 103.046 32.5982 103.046C43.6773 103.046 54.6854 103.046 65.6935 103.046ZM66.1196 67.6549C55.0405 67.6549 43.8904 67.6549 32.8112 67.6549C28.6211 67.6549 26.2774 69.3605 26.2774 72.4164C26.2774 75.4722 28.55 77.3199 32.7402 77.3199C54.9695 77.3199 77.1277 77.3199 99.357 77.3199C103.618 77.3199 105.891 75.6143 105.891 72.5585C105.891 69.4316 103.618 67.726 99.428 67.726C88.2779 67.6549 77.1988 67.6549 66.1196 67.6549ZM48.6487 117.756C43.1091 117.756 37.5696 117.685 32.03 117.756C28.266 117.756 26.2064 119.533 26.2774 122.518C26.2774 125.361 28.55 127.208 32.101 127.208C43.0381 127.208 54.0462 127.208 64.9833 127.208C68.5343 127.208 70.807 125.218 70.807 122.447C70.807 119.604 68.5343 117.828 64.9123 117.756C59.5148 117.756 54.0462 117.756 48.6487 117.756Z"
                            fill="#C1E9C9"/>
                        <path
                            d="M148.999 101.482C148.999 124.081 148.999 146.751 148.999 169.35C148.999 178.376 145.377 182 136.287 182C101.984 182 67.6104 182 33.3077 182C24.6433 182 20.4531 177.452 21.1633 168.924C21.3053 167.574 21.5894 166.934 23.0098 167.076C23.72 167.147 24.4302 167.076 25.1404 167.076C55.3239 167.076 85.5074 167.076 115.691 167.076C127.409 167.076 133.588 160.894 133.588 149.097C133.588 107.523 133.659 65.9494 133.517 24.3758C133.517 21.2489 134.298 20.4672 137.352 20.5383C145.164 20.8225 148.999 24.518 148.999 32.4774C148.999 55.5027 148.999 78.5281 148.999 101.482Z"
                            fill="#C1E9C9"/>
                        <path
                            d="M40.4817 18.6906C40.4817 22.9545 40.5527 27.2185 40.4817 31.4825C40.4106 36.9545 37.0727 40.4368 31.6752 40.5078C22.9397 40.5789 14.1332 40.5078 5.39776 40.5078C3.19614 40.5078 1.42064 39.8682 0.568403 37.6652C-0.212817 35.6043 0.710443 34.0408 2.13084 32.5484C12.2157 22.4571 22.3005 12.3657 32.4564 2.27433C33.9478 0.781945 35.5813 -0.355111 37.7829 0.639812C39.9135 1.56367 40.4817 3.34032 40.4817 5.54337C40.4106 9.87839 40.4817 14.2845 40.4817 18.6906Z"
                            fill="#C1E9C9"/>
                    </g>
                    <g clipPath="url(#clip1_1110_10155)">
                        <path
                            d="M148.9 79.6302C120.227 79.6302 91.6528 79.6302 62.9789 79.6302C51.4894 79.6302 46.8936 84.6083 48.4922 96.058C53.3877 132.199 58.4831 168.241 63.5784 204.382C64.5775 211.252 69.1733 214.935 76.9662 214.935C99.4456 215.035 121.925 214.935 144.405 214.935C169.382 214.935 194.359 214.935 219.336 214.935C221.035 214.935 222.633 214.935 224.332 215.234C226.33 215.632 227.529 217.026 227.529 219.117C227.429 221.208 226.23 222.502 224.232 222.801C222.733 223 221.234 222.9 219.736 222.9C172.779 222.9 125.822 222.9 78.8644 222.9C64.2778 222.9 57.484 217.126 55.4858 202.789C50.1906 166.747 45.1952 130.606 40.1997 94.5646C38.801 84.3096 44.4958 75.5482 54.5866 72.4617C56.2851 71.9639 57.2841 71.6652 57.7837 69.5744C59.682 62.3064 63.6783 59.6182 71.7709 59.5186C95.2495 59.5186 118.728 59.4191 142.207 59.6182C145.603 59.6182 147.801 58.8217 149.2 55.6357C150.199 53.2462 151.698 50.9563 153.097 48.7659C156.094 43.8873 160.49 41.0996 166.285 41.0996C187.465 41 208.546 40.9005 229.727 41.0996C236.62 41.1991 241.116 46.0777 241.416 52.8479C241.516 55.1379 241.516 57.5274 241.416 59.8173C241.216 66.3884 240.417 72.163 249.409 75.1499C256.902 77.639 259.799 85.7035 258.8 93.7681C255.203 121.347 251.207 148.926 247.411 176.504C247.011 179.292 245.912 181.582 242.915 181.283C239.418 180.985 239.018 178.197 239.418 175.31C241.916 157.588 244.413 139.865 246.811 122.143C248.21 112.486 249.609 102.828 250.807 93.0711C251.607 86.4005 247.411 80.9245 240.817 79.9289C238.818 79.6302 236.82 79.6302 234.822 79.6302C206.248 79.6302 177.574 79.6302 148.9 79.6302Z"
                            fill="#2FB44B"/>
                        <path
                            d="M225.431 149.025C225.331 153.904 223.632 161.072 219.536 167.444C218.037 169.834 218.237 171.228 220.235 173.219C230.126 182.777 239.818 192.634 249.509 202.391C253.205 206.074 253.705 209.659 251.007 212.347C248.31 215.035 244.813 214.537 241.116 210.853C231.525 201.395 222.034 191.937 212.542 182.379C210.444 180.188 209.046 179.491 206.048 181.383C190.962 191.14 171.48 190.144 157.593 179.292C143.605 168.34 138.11 150.22 143.506 133.394C148.901 116.667 164.486 105.118 182.57 104.521C205.549 103.724 225.431 123.039 225.431 149.025ZM183.569 176.106C200.254 176.007 213.542 162.566 213.342 145.939C213.242 129.71 199.454 116.269 183.269 116.468C166.684 116.568 153.297 130.208 153.496 146.735C153.596 163.063 167.084 176.206 183.569 176.106Z"
                            fill="#2FB44B"/>
                        <path
                            d="M107.738 171.427C112.933 171.427 118.029 171.228 123.224 171.427C128.519 171.626 131.316 174.613 131.516 179.89C131.616 182.18 131.616 184.569 131.516 186.859C131.316 191.937 128.519 195.023 123.524 195.222C112.933 195.421 102.243 195.421 91.6526 195.222C86.6572 195.123 83.8598 191.937 83.56 186.959C83.4601 184.967 83.56 182.976 83.56 180.985C83.6599 174.215 86.3575 171.526 93.3511 171.427C98.0468 171.327 102.842 171.327 107.738 171.427Z"
                            fill="#2FB44B"/>
                        <circle cx="183" cy="146" r="30" fill="white"/>

                        <rect width="26.9682" height="2.81029"
                              transform="matrix(0.708463 0.705748 0.708463 -0.705748 172.83 137.269)"
                              fill="#2FB44B"/>
                        <rect width="27.6664" height="2.81029"
                              transform="matrix(-0.708463 0.705748 0.708463 0.705748 191.885 135.286)"
                              fill="#2FB44B"/>

                    </g>
                    <defs>
                        <clipPath id="clip0_1110_10155">
                            <rect width="149" height="182" fill="white"/>
                        </clipPath>
                        <clipPath id="clip1_1110_10155">
                            <rect width="219" height="182" fill="white" transform="translate(40 41)"/>
                        </clipPath>
                    </defs>
                </svg>
            }


            {isSearchResults ?
                <h3 className="igd-root-placeholder-title">{wp.i18n.__('No results found!', 'integrate-google-drive')}</h3>
                :
                <h3 className="igd-root-placeholder-title">{searchBoxText}</h3>}

            {!isSearchResults && <SearchBar/>}

        </div>
    )
}