<?php

defined( 'ABSPATH' ) || exit;

?>

<div class="igd-getting-started">
    <div class="getting-started-header">

        <div class="header-logo">
            <img src="<?php echo esc_url( IGD_ASSETS . '/images/integrate-google-drive-logo.png' ); ?>"
                 alt="Integrate Google Drive">
            <span><?php esc_html_e( 'Integrate Google Drive', 'integrate-google-drive' ); ?></span>
        </div>

        <p><?php esc_html_e( 'The ultimate solution to manage, share and showcase your Google Drive files, documents and media directly from your website.', 'integrate-google-drive' ); ?></p>


    </div>

    <div class="getting-started-main">

        <div class="getting-started-menu">
            <div class="menu-item active" data-target="introduction">
                <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd"
                          d="M19.6004 9.9999C19.6004 12.546 18.589 14.9878 16.7886 16.7881C14.9883 18.5885 12.5465 19.5999 10.0004 19.5999C7.45431 19.5999 5.01252 18.5885 3.21217 16.7881C1.41182 14.9878 0.400391 12.546 0.400391 9.9999C0.400391 7.45382 1.41182 5.01203 3.21217 3.21168C5.01252 1.41133 7.45431 0.399902 10.0004 0.399902C12.5465 0.399902 14.9883 1.41133 16.7886 3.21168C18.589 5.01203 19.6004 7.45382 19.6004 9.9999V9.9999ZM11.2004 5.1999C11.2004 5.51816 11.074 5.82339 10.8489 6.04843C10.6239 6.27347 10.3187 6.3999 10.0004 6.3999C9.68213 6.3999 9.37691 6.27347 9.15186 6.04843C8.92682 5.82339 8.80039 5.51816 8.80039 5.1999C8.80039 4.88164 8.92682 4.57642 9.15186 4.35137C9.37691 4.12633 9.68213 3.9999 10.0004 3.9999C10.3187 3.9999 10.6239 4.12633 10.8489 4.35137C11.074 4.57642 11.2004 4.88164 11.2004 5.1999ZM8.80039 8.7999C8.48213 8.7999 8.17691 8.92633 7.95186 9.15137C7.72682 9.37642 7.60039 9.68164 7.60039 9.9999C7.60039 10.3182 7.72682 10.6234 7.95186 10.8484C8.17691 11.0735 8.48213 11.1999 8.80039 11.1999V14.7999C8.80039 15.1182 8.92682 15.4234 9.15186 15.6484C9.37691 15.8735 9.68213 15.9999 10.0004 15.9999H11.2004C11.5187 15.9999 11.8239 15.8735 12.0489 15.6484C12.274 15.4234 12.4004 15.1182 12.4004 14.7999C12.4004 14.4816 12.274 14.1764 12.0489 13.9514C11.8239 13.7263 11.5187 13.5999 11.2004 13.5999V9.9999C11.2004 9.68164 11.074 9.37642 10.8489 9.15137C10.6239 8.92633 10.3187 8.7999 10.0004 8.7999H8.80039Z"
                          fill="#4D4D4D"/>
                </svg>
                <span><?php esc_html_e( 'Introduction', 'integrate-google-drive' ); ?></span>
            </div>

            <div class="menu-item" data-target="data-privacy">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M19.4868 18.0155C20.0229 16.0082 20.347 14.0384 20.347 12.0062C20.347 10.1236 19.2748 9.00148 17.3797 8.91421C16.0706 8.85187 14.8613 8.42798 13.7766 7.71733C12.4426 6.83213 11.121 6.81966 9.77455 7.70486C8.59013 8.47785 7.28104 8.88927 5.85974 8.93914C4.16416 9.00148 3.00468 10.2233 3.02961 11.9314C3.05455 13.8389 3.29143 15.734 3.81506 17.5791C3.91481 17.9532 3.85247 18.0654 3.47844 18.028C3.00468 17.9906 2.53091 18.0654 2.05714 17.9282C0.81039 17.5542 0.0124675 16.5568 0 15.2727C0 11.6197 0 7.96668 0 4.30122C0 2.75525 1.20935 1.57083 2.76779 1.55837C4.2639 1.5459 5.76 1.57083 7.2561 1.5459C7.75481 1.5459 8.22857 1.64564 8.57766 1.98226C10.0488 3.36616 11.7818 3.70278 13.7642 3.57811C15.9958 3.44096 18.2525 3.5407 20.4966 3.5407C22.267 3.5407 23.4265 4.68772 23.4265 6.44564C23.4265 9.33811 23.4265 12.2181 23.4265 15.1106C23.4265 16.8311 22.267 18.003 20.5465 18.003C20.2348 18.0155 19.8982 18.0155 19.4868 18.0155Z"
                          fill="#4D4D4D"/>
                    <path d="M18.8633 12.7918C18.776 14.7866 18.5017 16.744 17.7288 18.6017C16.7064 21.0703 14.8862 22.7284 12.5049 23.8256C11.9438 24.0874 11.3952 24.0251 10.8342 23.7633C7.53031 22.2297 5.68512 19.6116 4.9994 16.0833C4.73758 14.7118 4.63784 13.3279 4.5381 11.944C4.47577 11.0339 5.01187 10.4355 5.93447 10.4105C7.60512 10.3482 9.15109 9.86195 10.535 8.93936C11.3329 8.40325 12.0934 8.41572 12.9038 8.95182C14.3002 9.87442 15.8337 10.3607 17.5168 10.4105C18.4643 10.4355 18.988 11.0214 18.9381 11.9814C18.9132 12.2557 18.8758 12.53 18.8633 12.7918ZM9.87421 15.1482C9.53758 15.1108 9.31317 15.2978 9.17603 15.5721C9.02641 15.8838 9.10122 16.183 9.3381 16.4199C9.762 16.8438 10.2108 17.2552 10.6347 17.6666C11.0586 18.0656 11.4701 18.0656 11.8815 17.6542C12.6046 16.9435 13.3277 16.2204 14.0508 15.5097C14.4124 15.1482 14.4997 14.7492 14.1256 14.3752C13.7391 13.9887 13.3402 14.1009 12.9786 14.45C12.4924 14.9362 11.9937 15.3975 11.5199 15.8962C11.2706 16.1581 11.1334 16.1331 10.8841 15.8962C10.5973 15.5846 10.3729 15.1731 9.87421 15.1482Z"
                          fill="#4D4D4D"/>
                </svg>
                <span><?php esc_html_e( 'Data Privacy', 'integrate-google-drive' ); ?></span>
            </div>

            <div class="menu-item" data-target="help">

                <svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <g clip-path="url(#clip0_1447_16453)">
                        <path d="M11.9885 0C17.5481 0.028766 22.387 3.87191 23.6682 9.30868C25.2068 15.8271 21.2431 22.3109 14.7454 23.8643C12.2631 24.4569 9.82075 24.2555 7.45278 23.2832C7.25259 23.2027 7.07528 23.1797 6.85221 23.2429C5.09625 23.732 3.34029 24.198 1.58433 24.6697C0.857928 24.8711 0.228757 24.5086 0.074324 23.7722C0.0342858 23.5709 0.074324 23.335 0.131521 23.1279C0.560501 21.4767 1.00092 19.8313 1.4299 18.1801C1.46422 18.0536 1.45278 17.8925 1.39558 17.7774C0.663457 16.3909 0.200158 14.9181 0.0571648 13.3647C-0.251701 9.97606 0.646297 6.94412 2.83124 4.32641C4.70731 2.08266 7.1096 0.71915 9.97518 0.207115C10.6387 0.0920513 11.3193 0.0690385 11.9885 0ZM2.47089 22.3052C4.0095 21.8852 5.47375 21.494 6.93228 21.0912C7.21827 21.0107 7.4585 21.0337 7.72733 21.166C9.83219 22.1671 12.0343 22.3972 14.2879 21.8679C19.4699 20.6483 22.7473 15.5509 21.7807 10.2522C20.8084 4.89022 15.6206 1.28296 10.2783 2.25526C7.63581 2.73277 5.51379 4.07327 3.94086 6.24798C2.30502 8.50324 1.75021 11.0462 2.18491 13.8019C2.3851 15.0561 2.83124 16.2355 3.49472 17.3229C3.632 17.5473 3.67204 17.7716 3.59768 18.0305C3.34601 18.9395 3.1115 19.8543 2.87127 20.7691C2.73972 21.2581 2.61389 21.7529 2.47089 22.3052Z"
                              fill="#4D4D4D"/>
                        <path d="M9.79738 9.80903C9.09386 9.72273 8.41893 9.63643 7.6582 9.53863C7.76116 9.14741 7.81264 8.74469 7.96707 8.39374C8.53332 7.11078 9.54572 6.36861 10.907 6.11547C11.9423 5.91986 12.9776 5.96014 13.9613 6.35135C15.1511 6.82887 15.9976 7.64583 16.255 8.95756C16.438 9.91259 16.152 10.7468 15.4828 11.4257C14.9509 11.9722 14.3732 12.4728 13.8069 12.9848C13.3779 13.3703 13.0062 13.7787 12.989 14.4001C12.9833 14.6187 12.9718 14.8373 12.9604 15.0732C12.274 15.0732 11.6048 15.0732 10.9013 15.0732C10.8384 14.0491 10.8784 13.0481 11.6449 12.2656C12.2569 11.6385 12.949 11.092 13.5838 10.4879C14.2416 9.86081 14.2416 8.92304 13.5724 8.30744C12.9432 7.72637 12.1882 7.68034 11.4046 7.87595C10.5867 8.08307 10.1463 8.68716 9.90034 9.45233C9.8603 9.55589 9.83742 9.67095 9.79738 9.80903Z"
                              fill="#4D4D4D"/>
                        <path d="M10.9199 15.9077C11.6864 15.9077 12.4242 15.9077 13.1792 15.9077C13.1792 16.6614 13.1792 17.4093 13.1792 18.1745C12.4357 18.1745 11.6921 18.1745 10.9199 18.1745C10.9199 17.4323 10.9199 16.6786 10.9199 15.9077Z"
                              fill="#4D4D4D"/>
                    </g>
                    <defs>
                        <clipPath id="clip0_1447_16453">
                            <rect width="24" height="24.7273" fill="white"/>
                        </clipPath>
                    </defs>
                </svg>

                <span><?php esc_html_e( 'Help', 'integrate-google-drive' ); ?></span>
            </div>

            <!-- Changelog -->
            <div class="menu-item" data-target="what-new">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M4.09836 20.4924C3.37761 20.4719 2.78595 20.2061 2.31261 19.6845C1.36595 18.621 0.645201 17.4349 0.161114 16.1259C-0.172369 15.2261 -0.0217641 14.3671 0.752776 13.7536C1.94686 12.8026 1.9361 11.1869 0.752776 10.2461C-0.0217641 9.6121 -0.172369 8.73268 0.171871 7.82258C0.655959 6.53413 1.38747 5.35816 2.32337 4.31513C2.95807 3.60954 3.79715 3.30277 4.73305 3.61977C6.38971 4.17197 7.7344 3.21074 7.99258 1.82003C8.15394 0.940606 8.79939 0.388412 9.7353 0.214573C11.2306 -0.0717499 12.7259 -0.0717499 14.2212 0.204347C15.1894 0.388412 15.781 0.981509 16.0392 1.88138C16.491 3.48684 17.5345 4.05948 19.2234 3.59932C20.2024 3.33345 21.0307 3.58909 21.6869 4.31513C22.6443 5.36839 23.3651 6.56481 23.8384 7.87371C24.1719 8.77358 23.9782 9.58142 23.2467 10.2563C22.0096 11.4016 22.0096 12.5674 23.2575 13.7433C23.9782 14.4182 24.1719 15.2261 23.8491 16.1362C23.3651 17.4655 22.612 18.662 21.6439 19.7254C21.0092 20.4106 20.2024 20.6458 19.2664 20.4003C17.5452 19.9402 16.5018 20.5026 16.0392 22.1387C15.781 23.0488 15.1894 23.6215 14.2212 23.8055C12.7474 24.0714 11.2629 24.0816 9.78908 23.8055C8.82091 23.6215 8.21849 23.0386 7.97106 22.1387C7.53001 20.5333 6.48653 19.9606 4.7976 20.4106C4.56093 20.4515 4.34578 20.5026 4.09836 20.4924ZM16.5233 12.5674C16.5018 12.7412 16.5018 12.8537 16.4803 12.9662C15.8671 15.4715 13.1992 16.9133 10.5959 16.1566C9.76757 15.9214 9.1759 16.1566 8.95 16.8315C8.7456 17.4553 9.1006 18.0075 9.89666 18.2325C12.3063 18.9176 14.5009 18.5086 16.4372 16.9951C18.5887 15.3181 19.4386 12.3731 18.5242 9.91888C18.2122 9.09058 17.3409 8.76336 16.7062 9.2951C15.9424 9.9291 15.2324 10.6347 14.5439 11.3505C14.1674 11.7493 14.2427 12.3628 14.63 12.7412C15.0172 13.1196 15.6304 13.1809 16.1037 12.8844C16.2328 12.8026 16.3512 12.7003 16.5233 12.5674ZM7.47622 11.4221C7.48698 11.2789 7.48698 11.1971 7.49773 11.1153C8.05712 8.60997 10.7357 7.09655 13.3175 7.81236C13.5219 7.87371 13.7263 7.94529 13.9415 7.94529C14.4901 7.96574 14.9742 7.57716 15.0818 7.04542C15.1894 6.51368 14.8559 6.01261 14.2319 5.79787C11.7147 4.90822 8.61651 5.67516 6.82001 7.69987C5.14184 9.59165 4.69002 11.7391 5.48608 14.1012C5.76577 14.9295 6.66941 15.2363 7.3041 14.6943C8.05712 14.0603 8.7456 13.3752 9.43408 12.6798C9.8106 12.2913 9.76757 11.7084 9.42333 11.3198C9.06833 10.921 8.48742 10.8085 8.01409 11.0539C7.85273 11.1357 7.70213 11.2687 7.47622 11.4221Z"
                          fill="#4D4D4D"/>
                </svg>
                <span><?php esc_html_e( 'Changelog', 'integrate-google-drive' ); ?></span>
            </div>

            <div class="menu-item" data-target="get-pro">
                <svg width="24" height="22" viewBox="0 0 24 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <g clip-path="url(#clip0_612_63900)">
                        <path d="M12.6797 22C13.5901 19.4547 14.5006 16.9094 15.411 14.3735C16.0211 12.6797 16.6406 10.9953 17.2413 9.30157C17.3445 9.01148 17.4572 8.88983 17.7857 8.88983C19.7567 8.90855 21.7278 8.89919 23.8115 8.89919L12.6797 22Z"
                              fill="#4D4D4D"/>
                        <path d="M0.195312 8.88982C2.33532 8.88982 4.34392 8.89918 6.36191 8.88046C6.68104 8.88046 6.69042 9.07697 6.76551 9.28284C7.91999 12.4925 9.06508 15.6929 10.2196 18.9026C10.5856 19.9226 10.9517 20.9519 11.3177 21.9719C7.62902 17.6393 3.94971 13.3067 0.195312 8.88982Z"
                              fill="#4D4D4D"/>
                        <path d="M12.0028 19.3518C10.7263 15.7958 9.49676 12.3615 8.25781 8.90854C10.7639 8.90854 13.2136 8.90854 15.7572 8.90854C14.5089 12.3615 13.2887 15.7771 12.0028 19.3518Z"
                              fill="#4D4D4D"/>
                        <path d="M3.69651 0.720551C4.51309 2.98512 5.29213 5.16547 6.08994 7.37389C4.06256 7.37389 2.07273 7.37389 0.0078125 7.37389C1.22799 5.15611 2.43879 2.97576 3.69651 0.720551Z"
                              fill="#4D4D4D"/>
                        <path d="M20.3215 0.720581C21.5699 2.97579 22.7807 5.14678 24.0009 7.3552C21.9829 7.3552 19.993 7.3552 17.9375 7.3552C18.7259 5.1655 19.5143 2.98515 20.3215 0.720581Z"
                              fill="#4D4D4D"/>
                        <path d="M16.7252 6.22288C15.8617 4.97831 15.0451 3.80859 14.2285 2.63888C13.8719 2.1242 13.5152 1.61889 13.1679 1.10421C13.0834 0.982561 12.999 0.832837 13.0365 0.645683C13.1022 0.374309 13.2618 0 13.7123 0.00935772C15.3549 0.00935772 16.988 0 18.6306 0C18.9685 0 18.8746 0.196512 18.8183 0.364951C18.1331 2.29264 17.4479 4.21097 16.7252 6.22288Z"
                              fill="#4D4D4D"/>
                        <path d="M5.05469 0.00941951C6.8568 0.00941951 8.6026 6.17881e-05 10.3484 0.0187772C10.7614 0.0187772 11.1368 0.720606 10.8646 1.08556C9.75707 2.67637 8.64953 4.26718 7.54198 5.86735C7.47628 5.96093 7.3918 6.05451 7.27917 6.20423C6.53768 4.1081 5.80557 2.08683 5.05469 0.00941951Z"
                              fill="#4D4D4D"/>
                        <path d="M15.6468 7.36455C13.1971 7.36455 10.813 7.36455 8.36328 7.36455C8.87013 6.644 9.34881 5.96089 9.81811 5.27778C10.4845 4.32329 11.1509 3.35945 11.8079 2.3956C11.9581 2.18037 12.0426 2.17102 12.1928 2.3956C13.3285 4.0332 14.4642 5.6708 15.6468 7.36455Z"
                              fill="#4D4D4D"/>
                    </g>
                    <defs>
                        <clipPath id="clip0_612_63900">
                            <rect width="24" height="22" fill="white"/>
                        </clipPath>
                    </defs>
                </svg>
                <span><?php esc_html_e( 'Get PRO', 'integrate-google-drive' ); ?></span>
            </div>

        </div>

		<?php include_once IGD_INCLUDES . '/views/getting-started/introduction.php'; ?>
		<?php include_once IGD_INCLUDES . '/views/getting-started/what-new.php'; ?>
		<?php include_once IGD_INCLUDES . '/views/getting-started/data-privacy.php'; ?>
		<?php include_once IGD_INCLUDES . '/views/getting-started/help.php'; ?>
		<?php
		include_once IGD_INCLUDES . '/views/getting-started/get-pro.php';
		?>

    </div>

</div>