<?php

defined( 'ABSPATH' ) || exit();

$features = [
	[
		'title' => __( 'Easy setup', 'integrate-google-drive' ),
		'pro'   => 0,
	],
	[
		'title' => __( 'Google Drive Files Management', 'integrate-google-drive' ),
		'pro'   => 0,
	],
	[
		'title' => __( 'Embed Documents', 'integrate-google-drive' ),
		'pro'   => 0,
	],
	[
		'title' => __( 'Module Builder', 'integrate-google-drive' ),
		'pro'   => 0,
	],
	[
		'title' => __( 'File Browser - Module', 'integrate-google-drive' ),
		'pro'   => true,
	],
	[
		'title' => __( 'Review & Approve - Module', 'integrate-google-drive' ),
		'pro'   => true,
	],
	[
		'title' => __( 'File Uploader - Module', 'integrate-google-drive' ),
		'pro'   => true,
	],
	[
		'title' => __( 'Media Player - Module', 'integrate-google-drive' ),
		'pro'   => true,
	],
	[
		'title' => __( 'Gallery - Module', 'integrate-google-drive' ),
		'pro'   => 0,
	],
	[
		'title' => __( 'List Files - Module', 'integrate-google-drive' ),
	],
	[
		'title' => __( 'File Search - Module', 'integrate-google-drive' ),
		'pro'   => true,
	],
	[
		'title' => __( 'Import to Media Library', 'integrate-google-drive' ),
		'pro'   => true,
	],
	[
		'title' => __( 'User Private Files & Folders', 'integrate-google-drive' ),
		'pro'   => true,
	],
	[
		'title' => __( 'Multiple Google Accounts', 'integrate-google-drive' ),
		'pro'   => true,
	],
	[
		'title' => __( 'Use Own Google App', 'integrate-google-drive' ),
		'pro'   => true,
	],
	[
		'title' => __( 'Statistics', 'integrate-google-drive' ),
		'pro'   => true,
	],
	[
		'title' => __( 'Email Notification', 'integrate-google-drive' ),
		'pro'   => true,
	],
	[
		'title' => __( 'Classic Editor Integration', 'integrate-google-drive' ),
		'pro'   => 0,
	],
	[
		'title' => __( 'Gutenberg Integration', 'integrate-google-drive' ),
		'pro'   => 0,
	],
	[
		'title' => __( 'Elementor Integration', 'integrate-google-drive' ),
		'pro'   => 0,
	],
	[
		'title' => __( 'Media Library Integration', 'integrate-google-drive' ),
		'pro'   => true,
	],
	[
		'title' => __( 'WooCommerce Integration', 'integrate-google-drive' ),
		'pro'   => true,
	],
	[
		'title' => __( 'Tutor LMS Integration', 'integrate-google-drive' ),
		'pro'   => true,
	],
	[
		'title' => __( 'Easy Digital Downloads Integration', 'integrate-google-drive' ),
		'pro'   => true,
	],
	[
		'title' => __( 'Contact Form 7 Integration', 'integrate-google-drive' ),
		'pro'   => false,
	],
	[
		'title' => __( 'WPForms Integration', 'integrate-google-drive' ),
		'pro'   => true,
	],
	[
		'title' => __( 'Gravity Forms Integration', 'integrate-google-drive' ),
		'pro'   => true,
	],
	[
		'title' => __( 'Fluent Forms Integration', 'integrate-google-drive' ),
		'pro'   => true,
	],
	[
		'title' => __( 'Ninja Forms Integration', 'integrate-google-drive' ),
		'pro'   => true,
	],
	[
		'title' => __( 'Formidable Forms Integration', 'integrate-google-drive' ),
		'pro'   => true,
	],
	[
		'title' => __( 'Usage Limits Control', 'integrate-google-drive' ),
		'pro'   => true,
	],
];

?>

<div id="get-pro" class="getting-started-content content-get-pro">

    <div class="content-heading">
        <h2><mark>Maximize Google Drive</mark> with WordPress</h2>
        <p><?php esc_html_e( 'Unlock powerful PRO features designed to enhance and streamline your Google Drive integration, making it more efficient and easier to manage than ever before.', 'integrate-google-drive' ) ?>.</p>

        <a href="https://softlabbd.com/integrate-google-drive-pricing" class="igd-btn btn-primary get-pro-btn"
              target="_blank"
        >
            <svg width="24" height="22" viewBox="0 0 24 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                <g clip-path="url(#clip0_612_63900)">
                    <path d="M12.6797 22C13.5901 19.4547 14.5006 16.9094 15.411 14.3735C16.0211 12.6797 16.6406 10.9953 17.2413 9.30157C17.3445 9.01148 17.4572 8.88983 17.7857 8.88983C19.7567 8.90855 21.7278 8.89919 23.8115 8.89919L12.6797 22Z"
                          fill="#4D4D4D"/>
                    <path d="M0.195312 8.88982C2.33532 8.88982 4.34392 8.89918 6.36191 8.88046C6.68104 8.88046 6.69042 9.07697 6.76551 9.28284C7.91999 12.4925 9.06508 15.6929 10.2196 18.9026C10.5856 19.9226 10.9517 20.9519 11.3177 21.9719C7.62902 17.6393 3.94971 13.3067 0.195312 8.88982Z"
                          fill="#4D4D4D"/>
                    <path d="M12.0028 19.3518C10.7263 15.7958 9.49676 12.3615 8.25781 8.90854C10.7639 8.90854 13.2136 8.90854 15.7572 8.90854C14.5089 12.3615 13.2887 15.7771 12.0028 19.3518Z"
                          fill="#4D4D4D"/>
                    <path d="M3.69651 0.720551C4.51309 2.98512 5.29213 5.16547 6.08994 7.37389C4.06256 7.37389 2.07273 7.37389 0.0078125 7.37389C1.22799 5.15611 2.43879 2.97576 3.69651 0.720551Z"
                          fill="#4D4D4D"/>
                    <path d="M20.3215 0.720581C21.5699 2.97579 22.7807 5.14678 24.0009 7.3552C21.9829 7.3552 19.993 7.3552 17.9375 7.3552C18.7259 5.1655 19.5143 2.98515 20.3215 0.720581Z"
                          fill="#4D4D4D"/>
                    <path d="M16.7252 6.22288C15.8617 4.97831 15.0451 3.80859 14.2285 2.63888C13.8719 2.1242 13.5152 1.61889 13.1679 1.10421C13.0834 0.982561 12.999 0.832837 13.0365 0.645683C13.1022 0.374309 13.2618 0 13.7123 0.00935772C15.3549 0.00935772 16.988 0 18.6306 0C18.9685 0 18.8746 0.196512 18.8183 0.364951C18.1331 2.29264 17.4479 4.21097 16.7252 6.22288Z"
                          fill="#4D4D4D"/>
                    <path d="M5.05469 0.00941951C6.8568 0.00941951 8.6026 6.17881e-05 10.3484 0.0187772C10.7614 0.0187772 11.1368 0.720606 10.8646 1.08556C9.75707 2.67637 8.64953 4.26718 7.54198 5.86735C7.47628 5.96093 7.3918 6.05451 7.27917 6.20423C6.53768 4.1081 5.80557 2.08683 5.05469 0.00941951Z"
                          fill="#4D4D4D"/>
                    <path d="M15.6468 7.36455C13.1971 7.36455 10.813 7.36455 8.36328 7.36455C8.87013 6.644 9.34881 5.96089 9.81811 5.27778C10.4845 4.32329 11.1509 3.35945 11.8079 2.3956C11.9581 2.18037 12.0426 2.17102 12.1928 2.3956C13.3285 4.0332 14.4642 5.6708 15.6468 7.36455Z"
                          fill="#4D4D4D"/>
                </g>
                <defs>
                    <clipPath id="clip0_612_63900">
                        <rect width="24" height="22" fill="white"/>
                    </clipPath>
                </defs>
            </svg>
			<?php esc_html_e( 'Get PRO Now', 'integrate-google-drive' ); ?>
        </a>

    </div>

    <div class="content-heading free-vs-pro">
        <h2><?php esc_html_e( 'Compare Plans', 'integrate-google-drive' ); ?></h2>

        <div class="free-vs-pro-wrap">
            <span><?php esc_html_e( 'FREE', 'integrate-google-drive' ); ?></span>
			<?php esc_html_e( 'vs', 'integrate-google-drive' ); ?>
            <span><?php esc_html_e( 'PRO', 'integrate-google-drive' ); ?></span>
        </div>

        <p><?php esc_html_e( 'The PRO version unlocks advanced features and functionalities beyond the free version. Explore and compare to fully understand its enhanced capabilities and benefits.', 'integrate-google-drive' ); ?></p>

    </div>

    <div class="features-list">
        <div class="list-header">
            <div class="feature-title"><?php esc_html_e( 'Feature List', 'integrate-google-drive' ); ?></div>
            <div class="feature-free"><?php esc_html_e( 'Free', 'integrate-google-drive' ); ?></div>
            <div class="feature-pro"><?php esc_html_e( 'Pro', 'integrate-google-drive' ); ?></div>
        </div>

		<?php foreach ( $features as $feature ) : ?>
            <div class="feature">
                <div class="feature-title"><?php echo esc_html($feature['title']); ?></div>
                <div class="feature-free">
					<?php if ( empty( $feature['pro'] ) ) { ?>
                        <i class="dashicons dashicons-no-alt"></i>
					<?php } else { ?>
                        <i class="dashicons dashicons-saved"></i>
					<?php } ?>
                </div>
                <div class="feature-pro">
                    <i class="dashicons dashicons-saved"></i>
                </div>
            </div>
		<?php endforeach; ?>

    </div>

    <div class="get-pro-cta">

        <div class="cta-content">
            <h2><mark>Don\'t waste time, get the %s PRO version %s now!</mark></h2>
            <p><?php esc_html_e( 'Upgrade to the PRO version of the plugin and unlock all the amazing Google Drive Integration features for
                your website.', 'integrate-google-drive' ); ?></p>
        </div>

        <div class="cta-btn">
            <a href="https://softlabbd.com/integrate-google-drive-pricing"
               class="igd-btn btn-primary"
            target="_blank">
                <i class="dashicons dashicons-cart"></i>
				<?php esc_html_e( 'Upgrade Now', 'integrate-google-drive' ); ?>
            </a>
        </div>

    </div>

    <div class="demo-cta">
        <div class="cta-content">
            <h2><?php esc_html_e( 'Want to try live demo, before purchase?', 'integrate-google-drive' ); ?></h2>
            <p><?php esc_html_e( 'Try our instant ready-made demo to explore all plugin features on both Front-End and Back-End. Experiment freely to discover its full capabilities and see if it meets your needs!', 'integrate-google-drive' ); ?></p>
        </div>

        <div class="cta-btn">
            <a href="https://demo.softlabbd.com/?product=integrate-google-drive" class="igd-btn btn-primary"
               target="_blank"
            >
                <i class="dashicons dashicons-visibility"></i>
				<?php esc_html_e( 'Try Live Demo', 'integrate-google-drive' ); ?>
            </a>
        </div>

    </div>

</div>