<?php

if( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

?>

<div id="data-privacy" class="getting-started-content content-data-privacy">
    <div class="content-heading heading-privacy">
        <h2><mark><?php esc_html_e('Data Privacy','integrate-google-drive'); ?></mark></h2>
        <p><?php esc_html_e('Information about the Data and Privacy','integrate-google-drive'); ?></p>
    </div>


    <section class="section-data-privacy section-half">
        <div class="col-description">
            <h2><?php esc_html_e( 'Plugin Authorization Flow (OAuth)', 'integrate-google-drive' ); ?></h2>

            <p>
		        <?php esc_html_e( 'For technical reasons, a short-lived authorization code generated by the OAuth flow is sent from your browser to our server as part of the authentication process. This code allows the plugin to access the Google Drive API on your behalf.', 'integrate-google-drive' ); ?>
            </p>

            <h4>
		        <?php esc_html_e( 'The plugin obtains the following information when you use the built-in app for authentication:', 'integrate-google-drive' ); ?>
            </h4>

            <ol>
                <li><?php esc_html_e( 'Your WordPress website URL.', 'integrate-google-drive'  ); ?></li>
                <li><?php esc_html_e( 'A short-lived OAuth authorization code.', 'integrate-google-drive' ); ?></li>
            </ol>

            <p>
		        <?php
		        printf(
			        wp_kses_post( 'This information is collected only after you grant the requested access via the Google OAuth consent screen. After granting consent, you are redirected through SoftLab’s server (<code>%s</code>), which then redirects you back to your site to complete the authorization process. This redirection simplifies setup by allowing the plugin to function without requiring you to create your own Google App or configure your own Authorized redirect URI. See SoftLab Privacy Policy for details.' ),
			        esc_url( 'https://softlabbd.com/integrate-google-drive-oauth.php' )
		        );
		        ?>
            </p>

            <p>
		        <?php
		        printf(
			        esc_html__( 'On your server, the authorization code is exchanged for an access token and a refresh token, which are securely encrypted and stored locally. The authorization code can only be used once and expires immediately after exchange or within minutes if unused.' , 'integrate-google-drive' )
		        );
		        ?>
            </p>

            <p>
                <strong><?php esc_html_e( 'Important:', 'integrate-google-drive' ); ?></strong> <?php esc_html_e( 'After authorization, all communication occurs directly between your server and the cloud storage service servers. This communication is encrypted and does not pass through our servers. We do not collect, store, or have access to your files.', 'integrate-google-drive' ); ?>
            </p>

        </div>
    </section>

    <section class="section-data-privacy section-half">
        <div class="col-description">
            <h2><?php esc_html_e( 'Google Permissions for OAuth', 'integrate-google-drive' ); ?></h2>

            <p>
		        <?php esc_html_e( 'To ensure seamless functionality, users grant Google Drive permissions during the standard OAuth authorization process. For more information, please refer to Google’s privacy policies.', 'integrate-google-drive' ); ?>
            </p>

            <p>
		        <?php
		        printf(
			        wp_kses_post(
				        'The plugin requires these permissions to <strong>view</strong>, <strong>create</strong>, <strong>edit</strong>, and <strong>delete</strong> your Google Drive files directly from your WordPress site. This access is essential for smooth integration between Google Drive and WordPress. Specifically:'
			        )
		        );
		        ?>
            </p>

            <ul>
                <li><?php esc_html_e( 'View permission allows the plugin to list your files.', 'integrate-google-drive' ); ?></li>
                <li><?php esc_html_e( 'Create permission enables uploading new content to your Google Drive.', 'integrate-google-drive' ); ?></li>
                <li><?php esc_html_e( 'Additional permissions allow renaming, editing, deleting, and sharing your files.', 'integrate-google-drive' ); ?></li>
            </ul>

            <p>
		        <?php
		        printf(
			        wp_kses_post(
				        'For full details, see the <a href="https://policies.google.com/privacy" target="_blank" rel="noopener noreferrer">Google Drive Privacy Policy</a> and <a href="https://policies.google.com/terms" target="_blank" rel="noopener noreferrer">Terms of Use</a>.'
			        )
		        );
		        ?>
            </p>


        </div>
    </section>


</div>