<?php
if ( ! defined( 'ABSPATH' ) )
    exit;


function xyz_ips_network_install($networkwide) {
    global $wpdb;
    if (function_exists('is_multisite') && is_multisite()) {
        // check if it is a network activation - if so, run the activation function for each blog id
        if ($networkwide) {
            $old_blog = $wpdb->blogid;
            // Get all blog ids
            $blogids = $wpdb->get_col("SELECT blog_id FROM $wpdb->blogs");
            foreach ($blogids as $blog_id) {
                switch_to_blog($blog_id);
                xyz_ips_install();
            }
            switch_to_blog($old_blog);
            return;
        }
    }
    xyz_ips_install();
}


function xyz_ips_install(){
    global $wpdb;

    $plugin_name = 'xyz-wp-insert-code-snippet/xyz-wp-insert-code-snippet.php';
    if ( is_plugin_active( $plugin_name ) ) {
    
        wp_die(
            sprintf(
                /* translators: 1: Plugin name, 2: Deactivate target, 3: Link to plugins page */
                esc_html__( 'The plugin %1$s cannot be activated unless the %2$s is deactivated. Back to %3$s.', 'insert-php-code-snippet' ),
                '<strong>Insert PHP Code Snippet</strong>',
                '<strong>premium version</strong>',
                sprintf(
                    '<a href="%s">%s</a>',
                    esc_url( admin_url( 'plugins.php' ) ),
                    esc_html__( 'Plugin Installation', 'insert-php-code-snippet' )
                )
            )
        );
    }
if ( version_compare( PHP_VERSION, '7.0.0', '<' ) ) {
    wp_die(
        sprintf(
            'This plugin requires PHP version 7.0 or higher. You are using PHP %s. <a href="%s">Go back to Plugins page</a>.',
            PHP_VERSION,
            esc_url( admin_url( 'plugins.php' ) )
        )
    );
}
    if(get_option('xyz_ips_sort_order')==''){
        add_option('xyz_ips_sort_order','desc');
    }

    if(get_option('xyz_ips_sort_field_name')==''){
        add_option('xyz_ips_sort_field_name','id');
    }

    if(get_option('xyz_credit_link') == ""){
        add_option("xyz_credit_link",0);
    }

    if(get_option('xyz_ips_credit_dismiss') == ""){
        add_option("xyz_ips_credit_dismiss",0);
    }

    if(get_option('xyz_ips_premium_version_ads')==""){
        add_option('xyz_ips_premium_version_ads',1);
    }

    if(get_option('xyz_ips_auto_insert')==""){
        add_option('xyz_ips_auto_insert',1);
    }

    if(get_option('xyz_ips_auto_exception')==""){
        add_option('xyz_ips_auto_exception',1);
    }

    $xyz_ips_installed_date = get_option('xyz_ips_installed_date');
    if ($xyz_ips_installed_date=="") {
        $xyz_ips_installed_date = time();
        update_option('xyz_ips_installed_date', $xyz_ips_installed_date);
    }
    add_option('xyz_ips_limit',20);
    add_option('xyz_ips_exception_email',"0");
    add_option('xyz_ips_exec_in_editor','0');
    $charset_collate = $wpdb->get_charset_collate();
    $queryInsertPhp = "CREATE TABLE IF NOT EXISTS  ".$wpdb->prefix."xyz_ips_short_code (
`id` int NOT NULL AUTO_INCREMENT,
`title` varchar(1000) NOT NULL,
        `description` TEXT NULL ,
`content` longtext  NOT NULL,
`short_code` varchar(2000) NOT NULL,
`status` int NOT NULL,
PRIMARY KEY (`id`)
) ENGINE=InnoDB ".$charset_collate." AUTO_INCREMENT=1";
    $wpdb->query($queryInsertPhp);


	$tblcolums = $wpdb->get_col("SHOW COLUMNS FROM  ".$wpdb->prefix."xyz_ips_short_code");
    if(!(in_array("insertionMethod", $tblcolums)))
	$wpdb->query("ALTER TABLE ".$wpdb->prefix."xyz_ips_short_code ADD insertionMethod int NOT NULL default 2");
    if(!(in_array("insertionLocation", $tblcolums)))
	$wpdb->query("ALTER TABLE ".$wpdb->prefix."xyz_ips_short_code ADD insertionLocation int NOT NULL default 0");
	if(!(in_array("insertionLocationType", $tblcolums)))
	$wpdb->query("ALTER TABLE ".$wpdb->prefix."xyz_ips_short_code ADD insertionLocationType int NOT NULL default 0");
    if(!(in_array("description", $tblcolums)))
	$wpdb->query("ALTER TABLE ".$wpdb->prefix."xyz_ips_short_code ADD description TEXT NULL ");
    //preview page
    $user_ID = get_current_user_id();
  	$slug = 'xyz-ics-preview-page';
  	$title = 'Snippet Preview';
  	$content = '';
  	// Cheks if doen't exists a post with slug "wordpress-post-created-with-code".
  	if( !xyz_ips_page_exists_by_slug( $slug ) ) {
  		// Set the post ID
  		$post_id = wp_insert_post(
  									array(
  											'post_author'       =>   $user_ID,
  											'post_name'         =>   $slug,
  											'post_title'        =>   $title,
  											'post_content'      =>  $content,
  											'post_status'       =>   'draft',
  											'post_type'         =>   'page'
  									)
  		);
  	}
}
register_activation_hook( XYZ_INSERT_PHP_PLUGIN_FILE ,'xyz_ips_network_install');
?>
