# Import Eventbrite Events

> Import Eventbrite Events into WordPress website and/or Event Calendar. Nice Display with shortcode & Event widget.

[![Release Version](https://img.shields.io/github/v/release/xylusthemes/import-eventbrite-events.svg)](https://github.com/xylusthemes/import-eventbrite-events/releases/latest)
![WordPress tested up to version](https://img.shields.io/badge/WordPress-v5.8%20tested-success.svg)
[![GPLv2.0 License](https://img.shields.io/github/license/xylusthemes/import-eventbrite-events.svg)](https://github.com/xylusthemes/import-eventbrite-events/blob/master/LICENSE.txt)

## Description

### Import Eventbrite Events into WordPress :
Import Eventbrite Events allows you to import eventbrite events into your WordPress site automatically. Automate your Event Marketing using Import Eventbrite Events plug-in. You can schedule event import so it will be imported/syncronized automatically [Pro]
 
* [Check Documentation](http://docs.xylusthemes.com/docs/import-eventbrite-events-plugin/)
* [Try Now (Admin Demo)](http://testdrive.xylusthemes.com/)
* [Pro] Add-on.
 

#### Features
* Easy and seemless Event import from Eventbrite to WordPres.
* Import Eventbrite event by Event ID using Eventbrite API
* Import Eventbrite events by Eventbrite organiser ID ([Pro]).
* Import Eventbrite events from your Eventbrite account ([Pro]).
* Import Eventbrite events into all WordPress leading Events plugins.
* Import multiple events using multiple event IDs at one time ([Pro]).
* Auto Scheduled event import (Automatic import). Import Hourly, Once a Day, Twice a day, Weekly, Monthly from account, IDs  ([Pro]).
* Edit schedule import later on ([Pro]).
* Advanced Synchronization with Eventbrite Organiser Profile ([Pro]).
* Simple and Effective in-built Event Management.
* Powerful shortcode for render Event listing (`[eventbrite_events]`)
* Responsive and impresive event listing design
* Impresive design of event detail page.
* Upcoming Events widget ([Pro]).
* Event registration widget on single event page.
* It support One Time Import only or schedule import on regular interval from Event IDs or Organizer's page. 
* Each Event Import can be imported in different categories. 
* Auto Publish, Draft Imported Events 
* Get Event details like Event Title, Event Description, Event Images, Event Start Date, Event End date, Event Location (vanue), Event Organizer etc in to WordPress Database.
* Event Import History Logs when & which Events Imported
* Option to update existing Events (Syncronize Events)
* Works with leading WordPress Event Calendar Plug-ins
* Import Event using latest Eventbrite API
 
 

 ### Import Eventbrite Events into:
* [ The Events Calendar ](https://wordpress.org/plugins/the-events-calendar/)
* [ Events manager ](https://wordpress.org/plugins/events-manager/)
* [ All-in-One Event Calendar ](https://wordpress.org/plugins/all-in-one-event-calendar/)
* [ Event Organiser ](https://wordpress.org/plugins/event-organiser/)
* [ EventON ](https://codecanyon.net/item/eventon-wordpress-event-calendar-plugin/1211017)
* [ My Calendar ](https://wordpress.org/plugins/my-calendar/)
* In-built Events

### Short-code examples:
* `[eventbrite_events]`  to show full events 
* `[eventbrite_events col="2"]` shows events in 2 column 
* `[eventbrite_events category="cat1,cat2"]` Shows events from mentioned categories 

Using This plugin you can import eventbrite event into below listed leading Event Management Plug-ins, which allows you to run imports from Eventbrite right from your dashboard.  Import Eventbrite Events bridges the gap between your website and your Eventbrite events making event management easier.


[Pro]: https://xylusthemes.com/plugins/import-eventbrite-events/?utm_source=githubrepo&utm_campaign=EventbriteEvents&utm_medium=readme&utm_content=githubrepo-readme


> ***New All in one Event Import Tool!***
>We’ve developed bulk event imports tool. This add-on service for The Events Calendar allows you import events from your favorite sources like Facebook, Meetup, Eventbrite, iCalendar, and ICS.
>
>[Check out WP Event Aggregator now](https://wordpress.org/plugins/wp-event-aggregator/).
>

 
### Our Other Plugins:
* [WP Event Aggregator](https://wordpress.org/plugins/wp-event-aggregator/)
* [Import Facebook Events](https://wordpress.org/plugins/import-facebook-events/)
* [Import Meetup Events](https://wordpress.org/plugins/import-meetup-events/)
* [WP Bulk Delete](https://wordpress.org/plugins/wp-bulk-delete/)

## Issues
If you identify any errors or have an idea for improving the plugin, please [open an issue](https://github.com/xylusthemes/import-eventbrite-events/issues?state=open). We're excited to see what the community thinks of this project, and we would love your input!

## Changelog

A complete listing of all notable changes to "Import Eventbrite Events" are documented in [CHANGELOG.md](https://github.com/xylusthemes/import-eventbrite-events/blob/develop/CHANGELOG.md).
