<?php

namespace OXI_IMAGE_HOVER_PLUGINS\Modules\General\Admin;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Description of Effects1
 *
 * @author biplo
 */
use OXI_IMAGE_HOVER_PLUGINS\Modules\General\Modules;
use OXI_IMAGE_HOVER_PLUGINS\Classes\Controls;

class Effects32 extends Modules {

    public function register_content_settings() {

        $this->start_controls_section(
            'oxi-image-hover', [
				'label' => esc_html__( 'General Settings', 'image-hover-effects-ultimate' ),
				'showing' => true,
			]
        );
        $this->add_control(
            'oxi-image-hover-background-color', $this->style, [
				'label' => esc_html__( 'Background', 'image-hover-effects-ultimate' ),
				'type' => Controls::GRADIENT,
				'default' => 'rgba(255, 116, 3, 1)',
				'oparetor' => true,
				'selector' => [
					'{{WRAPPER}} .oxi-image-hover-caption-tab' => 'background: {{VALUE}};',
				],
				'simpledescription' => 'Customize Hover Background with transparent options.',
				'description' => 'Customize Hover Background with Color or Gradient or Image properties.',
			]
        );
        $this->add_control(
            'oxi-image-hover-content-alignment', $this->style, [
				'label' => esc_html__( 'Content Alignment', 'image-hover-effects-ultimate' ),
				'type' => Controls::SELECT,
				'default' => 'image-hover-align-center-center',
				'options' => [
					'image-hover-align-top-left' => esc_html__( 'Top Left', 'image-hover-effects-ultimate' ),
					'image-hover-align-top-center' => esc_html__( 'Top Center', 'image-hover-effects-ultimate' ),
					'image-hover-align-top-right' => esc_html__( 'Top Right', 'image-hover-effects-ultimate' ),
					'image-hover-align-center-left' => esc_html__( 'Center Left', 'image-hover-effects-ultimate' ),
					'image-hover-align-center-center' => esc_html__( 'Center Center', 'image-hover-effects-ultimate' ),
					'image-hover-align-center-right' => esc_html__( 'Center Right', 'image-hover-effects-ultimate' ),
					'image-hover-align-bottom-left' => esc_html__( 'Bottom Left', 'image-hover-effects-ultimate' ),
					'image-hover-align-bottom-center' => esc_html__( 'Bottom Center', 'image-hover-effects-ultimate' ),
					'image-hover-align-bottom-right' => esc_html__( 'Bottom Right', 'image-hover-effects-ultimate' ),
				],
				'selector' => [
					'{{WRAPPER}} .oxi-image-hover-caption-tab' => '',
				],
				'simpledescription' => 'Customize Content Aginment as Top, Bottom, Left or Center.',
				'description' => 'Customize Content Aginment as Top, Bottom, Left or Center.',
			]
        );
        $this->start_controls_tabs(
            'image-hover-content-start-tabs',
            [
				'options' => [
					'normal' => esc_html__( 'Normal ', 'image-hover-effects-ultimate' ),
					'hover' => esc_html__( 'Hover ', 'image-hover-effects-ultimate' ),
				],
			]
        );
        $this->start_controls_tab();
        $this->add_responsive_control(
            'oxi-image-hover-border-radius', $this->style, [
				'label' => esc_html__( 'Border Radius', 'image-hover-effects-ultimate' ),
				'type' => Controls::DIMENSIONS,
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 50,
						'step' => 1,
					],
					'em' => [
						'min' => 0,
						'max' => 100,
						'step' => .1,
					],
				],
				'selector' => [
					'{{WRAPPER}} .oxi-image-hover-figure,'
					. '{{WRAPPER}} .oxi-image-hover-figure:before,'
					. '{{WRAPPER}} .oxi-image-hover-image,'
					. '{{WRAPPER}} .oxi-image-hover-image:before,'
					. '{{WRAPPER}} .oxi-image-hover-image img,'
					. '{{WRAPPER}} .oxi-image-hover-figure-caption,'
					. '{{WRAPPER}} .oxi-image-hover-figure-caption:before,'
					. '{{WRAPPER}} .oxi-image-hover-figure-caption:after,'
					. '{{WRAPPER}} .oxi-image-hover-figure-caption .oxi-image-hover-caption-tab' => 'border-radius:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'simpledescription' => 'Allows you to add rounded corners to Image with options.',
				'description' => 'Allows you to add rounded corners to Image with options.',
			]
        );
        $this->add_group_control(
            'oxi-image-hover-boxshadow', $this->style, [
				'type' => Controls::BOXSHADOW,
				'selector' => [
					'{{WRAPPER}} .oxi-image-hover-image:before' => '',
				],
				'description' => 'Box Shadow property attaches one or more shadows into Image shape.',
			]
        );
        $this->end_controls_tab();
        $this->start_controls_tab();
        $this->add_responsive_control(
            'oxi-image-hover-hover-border-radius', $this->style, [
				'label' => esc_html__( 'Border Radius', 'image-hover-effects-ultimate' ),
				'type' => Controls::DIMENSIONS,
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 50,
						'step' => 1,
					],
					'em' => [
						'min' => 0,
						'max' => 100,
						'step' => .1,
					],
				],
				'selector' => [
					'{{WRAPPER}} .oxi-image-hover:hover .oxi-image-hover-figure,'
					. '{{WRAPPER}} .oxi-image-hover.oxi-touch .oxi-image-hover-figure,'
					. '{{WRAPPER}} .oxi-image-hover:hover .oxi-image-hover-figure:before,'
					. '{{WRAPPER}} .oxi-image-hover.oxi-touch .oxi-image-hover-figure:before,'
					. '{{WRAPPER}} .oxi-image-hover:hover .oxi-image-hover-figure .oxi-image-hover-image,'
					. '{{WRAPPER}} .oxi-image-hover.oxi-touch .oxi-image-hover-figure .oxi-image-hover-image,'
					. '{{WRAPPER}} .oxi-image-hover:hover .oxi-image-hover-figure .oxi-image-hover-image:before,'
					. '{{WRAPPER}} .oxi-image-hover.oxi-touch .oxi-image-hover-figure .oxi-image-hover-image:before,'
					. '{{WRAPPER}} .oxi-image-hover:hover .oxi-image-hover-figure .oxi-image-hover-image img,'
					. '{{WRAPPER}} .oxi-image-hover.oxi-touch .oxi-image-hover-figure .oxi-image-hover-image img,'
					. '{{WRAPPER}} .oxi-image-hover:hover .oxi-image-hover-figure .oxi-image-hover-figure-caption,'
					. '{{WRAPPER}} .oxi-image-hover.oxi-touch .oxi-image-hover-figure .oxi-image-hover-figure-caption,'
					. '{{WRAPPER}} .oxi-image-hover:hover .oxi-image-hover-figure .oxi-image-hover-figure-caption:before,'
					. '{{WRAPPER}} .oxi-image-hover.oxi-touch .oxi-image-hover-figure .oxi-image-hover-figure-caption:before,'
					. '{{WRAPPER}} .oxi-image-hover:hover .oxi-image-hover-figure .oxi-image-hover-figure-caption:after,'
					. '{{WRAPPER}} .oxi-image-hover.oxi-touch .oxi-image-hover-figure .oxi-image-hover-figure-caption:after,'
					. '{{WRAPPER}} .oxi-image-hover:hover .oxi-image-hover-figure .oxi-image-hover-figure-caption .oxi-image-hover-caption-tab,'
					. '{{WRAPPER}} .oxi-image-hover.oxi-touch .oxi-image-hover-figure .oxi-image-hover-figure-caption .oxi-image-hover-caption-tab' => 'border-radius:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'simpledescription' => 'Allows you to add rounded corners at Hover to Image with options.',
				'description' => 'Allows you to add rounded corners at Hover to Image with options.',
			]
        );
        $this->add_group_control(
            'oxi-image-hover-hover-boxshadow', $this->style, [
				'type' => Controls::BOXSHADOW,
				'selector' => [
					'{{WRAPPER}} .oxi-image-hover-figure .oxi-image-hover-caption-tab' => '',
				],
				'description' => 'Allows you at hover to attaches one or more shadows into Image shape.',
			]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_responsive_control(
            'oxi-image-hover-padding', $this->style, [
				'label' => esc_html__( 'Padding', 'image-hover-effects-ultimate' ),
				'type' => Controls::DIMENSIONS,
				'simpledimensions' => 'double',
				'separator' => true,
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 500,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
					'em' => [
						'min' => 0,
						'max' => 100,
						'step' => .1,
					],
				],
				'selector' => [
					'{{WRAPPER}} .oxi-image-hover-figure .oxi-image-hover-caption-tab' => 'padding:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'simpledescription' => 'Padding used to generate space around content.',
				'description' => 'Padding used to generate space around content.',
			]
        );
        $this->add_responsive_control(
            'oxi-image-hover-content-margin', $this->style, [
				'label' => esc_html__( 'Margin', 'image-hover-effects-ultimate' ),
				'type' => Controls::DIMENSIONS,
				'simpledimensions' => 'double',
				'separator' => true,
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
					'em' => [
						'min' => 0,
						'max' => 100,
						'step' => .1,
					],
				],
				'selector' => [
					'{{WRAPPER}} .oxi-image-hover-figure .oxi-image-hover-caption-tab' => 'margin:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'simpledescription' => 'Margin used to generate space around to Outside content.',
				'description' => 'Margin used to generate space around to Outside content.',
			]
        );
        $this->end_controls_section();
    }
}
