<?php

namespace OXI_IMAGE_HOVER_PLUGINS\Modules\Flipbox\Admin;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Description of Effects24
 *
 * @author biplo
 */
use OXI_IMAGE_HOVER_PLUGINS\Modules\Flipbox\Modules;
use OXI_IMAGE_HOVER_PLUGINS\Classes\Controls;

class Effects24 extends Modules {

    public function register_frontend_tabs() {
        $this->start_section_tabs(
            'oxi-image-hover-start-tabs', [
				'condition' => [
					'oxi-image-hover-start-tabs' => 'frontend',
				],
			]
        );
        $this->start_section_devider();
        $this->register_front_content_settings();
        $this->end_section_devider();
        $this->start_section_devider();
        $this->register_front_heading_settings();

        $this->register_front_image_settings();
        $this->end_section_devider();
        $this->end_section_tabs();
    }

    public function register_front_image_settings() {
        $this->start_controls_section(
            'oxi-image-hover', [
				'label' => esc_html__( 'Image Settings', 'image-hover-effects-ultimate' ),
				'showing' => true,
			]
        );
        $this->add_responsive_control(
            'oxi-image-flip-front-image-Height', $this->style, [
				'label' => esc_html__( 'Height', 'image-hover-effects-ultimate' ),
				'type' => Controls::SLIDER,
				'default' => [
					'unit' => 'px',
					'size' => 200,
				],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 2000,
						'step' => 1,
					],
					'%' => [
						'min' => 1,
						'max' => 200,
						'step' => 1,
					],
					'em' => [
						'min' => 1,
						'max' => 200,
						'step' => 0.1,
					],
				],
				'selector' => [
					'{{WRAPPER}} .oxi-image-flipbox-hover-style-24 .oxi-image-hover-figure-front-section-image-body' => 'height:{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .oxi-image-flipbox-hover-style-24 .oxi-image-hover-figure-front-section-heading-body' => 'height: calc(100% - {{SIZE}}{{UNIT}});',
				],
				'description' => 'Set Image Height with multiple options. Preparable percent value.',
			]
        );

        $this->end_controls_section();
    }

    public function register_front_content_settings() {
        $this->start_controls_section(
            'oxi-image-hover', [
				'label' => esc_html__( 'Content Settings', 'image-hover-effects-ultimate' ),
				'showing' => true,
			]
        );
        $this->add_group_control(
            'oxi-image-flip-front-background', $this->style, [
				'type' => Controls::BACKGROUND,
				'selector' => [
					'{{WRAPPER}} .oxi-image-hover-figure-frontend' => '',
				],
				'description' => 'Customize Hover Background with Color or Gradient or Image properties.',
			]
        );

        $this->add_group_control(
            'oxi-image-flip-front-border', $this->style, [
				'type' => Controls::BORDER,
				'selector' => [
					'{{WRAPPER}} .oxi-image-hover-figure-front-section' => '',
				],
				'description' => 'Border property is used to set the Hover Border of the Flipbox.',
			]
        );

        $this->add_responsive_control(
            'oxi-image-flip-front-border-radius', $this->style, [
				'label' => esc_html__( 'Border Radius', 'image-hover-effects-ultimate' ),
				'type' => Controls::DIMENSIONS,
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 50,
						'step' => 1,
					],
					'em' => [
						'min' => 0,
						'max' => 100,
						'step' => .1,
					],
				],
				'selector' => [
					'{{WRAPPER}} .oxi-image-hover-figure-frontend, '
					. '{{WRAPPER}} .oxi-image-hover-figure-frontend:before, '
					. '{{WRAPPER}} .oxi-image-hover-figure-frontend:after, '
					. '{{WRAPPER}} .oxi-image-hover-figure-front-section, '
					. '{{WRAPPER}} .oxi-image-hover-figure-front-section-body, '
					. '{{WRAPPER}} .oxi-image-hover-figure-backend, '
					. '{{WRAPPER}} .oxi-image-hover-figure-backend:before, '
					. '{{WRAPPER}} .oxi-image-hover-figure-backend:after, '
					. '{{WRAPPER}} .oxi-image-hover-figure-back-section ' => 'border-radius:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'description' => 'Allows you to add rounded corners to Flipbox with options.',
			]
        );
        $this->add_group_control(
            'oxi-image-flip-front-boxshadow', $this->style, [
				'type' => Controls::BOXSHADOW,
				'selector' => [
					'{{WRAPPER}} .oxi-image-hover-figure-frontend:before' => '',
					'{{WRAPPER}} .oxi-image-hover-figure-backend:before' => '',
				],
				'description' => 'Allows you at hover to attaches one or more shadows into Button.',
			]
        );
        $this->add_responsive_control(
            'oxi-image-flip-front-padding', $this->style, [
				'label' => esc_html__( 'Padding', 'image-hover-effects-ultimate' ),
				'type' => Controls::DIMENSIONS,
				'separator' => true,
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
					'em' => [
						'min' => 0,
						'max' => 100,
						'step' => .1,
					],
				],
				'selector' => [
					'{{WRAPPER}} .oxi-image-hover-figure-front-section-body' => 'margin:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'description' => 'Generate space around a Flipbox, inside of any defined borders or Background.',
			]
        );
        $this->add_responsive_control(
            'oxi-image-flip-front-margin', $this->style, [
				'label' => esc_html__( 'Margin', 'image-hover-effects-ultimate' ),
				'type' => Controls::DIMENSIONS,
				'separator' => true,
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
					'em' => [
						'min' => 0,
						'max' => 100,
						'step' => .1,
					],
				],
				'selector' => [
					'{{WRAPPER}} .oxi-image-hover-figure-front-section' => 'margin:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'description' => 'Generate space outside a Flipbox.',
			]
        );
        $this->end_controls_section();
    }

    public function register_backend_tabs() {
        $this->start_section_tabs(
            'oxi-image-hover-start-tabs', [
				'condition' => [
					'oxi-image-hover-start-tabs' => 'backend',
				],
			]
        );
        $this->start_section_devider();
        $this->register_back_content_settings();
        $this->register_back_description_settings();
        $this->end_section_devider();

        $this->start_section_devider();
        $this->register_back_heading_settings();
        $this->register_back_button_settings();
        $this->end_section_devider();

        $this->end_section_tabs();
    }

    public function modal_form_data() {
        ?><div class="modal-header">
            <h4 class="modal-title">Image Hover Form</h4>
            <button type="button" class="close" data-dismiss="modal">&times;</button>
        </div>
        <div class="modal-body">
            <?php
            $this->add_control(
                'image_hover_front_heading', $this->style, [
					'label' => esc_html__( 'Front Title', 'image-hover-effects-ultimate' ),
					'type' => Controls::TEXT,
					'default' => '',
					'placeholder' => 'Heading',
					'description' => 'Add Your Flipbox Front Title.',
				]
            );
            $this->add_control(
                'image_hover_back_heading', $this->style, [
					'label' => esc_html__( 'Backend Title', 'image-hover-effects-ultimate' ),
					'type' => Controls::TEXT,
					'default' => '',
					'placeholder' => 'Heading',
					'description' => 'Add Your Flipbox Backend Title.',
				]
            );

            $this->add_control(
                'image_hover_back_description', $this->style, [
					'label' => esc_html__( 'Short Description', 'image-hover-effects-ultimate' ),
					'type' => Controls::TEXTAREA,
					'description' => 'Add Your Description Unless make it blank.',
				]
            );
            $this->start_controls_tabs(
                'image_hover-start-tabs', [
					'separator' => true,
					'options' => [
						'frontend' => esc_html__( 'Front Image', 'image-hover-effects-ultimate' ),
						'backend' => esc_html__( 'Backend Image', 'image-hover-effects-ultimate' ),
					],
				]
            );
            $this->start_controls_tab();

            $this->add_group_control(
                'image_hover_front_image', $this->style, [
					'label' => esc_html__( 'Image', 'image-hover-effects-ultimate' ),
					'type' => Controls::MEDIA,
					'description' => 'Add or Modify Your Front Image.',
				]
            );

            $this->end_controls_tab();

            $this->start_controls_tab();
            $this->add_group_control(
                'image_hover_back_image', $this->style, [
					'label' => esc_html__( 'Feature Image', 'image-hover-effects-ultimate' ),
					'type' => Controls::MEDIA,
					'description' => 'Add or Modify Your Backend Image. Adjust Backend background to get better design.',
				]
            );
            $this->end_controls_tab();
            $this->end_controls_tabs();

            $this->add_group_control(
                'image_hover_button_link', $this->style, [
					'label' => esc_html__( 'URL', 'image-hover-effects-ultimate' ),
					'type' => Controls::URL,
					'separator' => true,
					'default' => '',
					'placeholder' => 'https://www.yoururl.com',
					'description' => 'Add Your Desire Link or Url Unless make it blank',
				]
            );
            $this->add_control(
                'image_hover_button_text', $this->style, [
					'label' => esc_html__( 'Button Text', 'image-hover-effects-ultimate' ),
					'type' => Controls::TEXT,
					'default' => '',
					'description' => 'Customize your button text. Button will only view while Url given',
				]
            );
            ?>
        </div>
        <?php
    }

    /**
     * Template Parent Item Data Rearrange
     *
     * @since 2.0.0
     */
    public function Rearrange() {
        return '<li class="list-group-item" id="{{id}}">{{image_hover_front_heading}}</li>';
    }
}
