<?php

namespace OXI_IMAGE_HOVER_PLUGINS\Modules\Flipbox\Admin;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Description of Effects18
 *
 * @author biplo
 */
use OXI_IMAGE_HOVER_PLUGINS\Modules\Flipbox\Modules;
use OXI_IMAGE_HOVER_PLUGINS\Classes\Controls;

class Effects18 extends Modules {

    public function register_frontend_tabs() {
        $this->start_section_tabs(
            'oxi-image-hover-start-tabs', [
				'condition' => [
					'oxi-image-hover-start-tabs' => 'frontend',
				],
			]
        );
        $this->start_section_devider();
        $this->register_front_content_settings();
        $this->register_front_description_settings();
        $this->end_section_devider();
        $this->start_section_devider();
        $this->register_front_heading_settings();
        $this->register_front_icon_settings();
        $this->end_section_devider();
        $this->end_section_tabs();
    }

    public function register_front_icon_settings() {
        $this->start_controls_section(
            'imahe-hover', [
				'label' => esc_html__( 'Icon Settings', 'image-hover-effects-ultimate' ),
				'showing' => false,
			]
        );
        $this->add_control(
            'oxi-image-flip-front-icon-position', $this->style, [
				'label' => esc_html__( 'Position', 'image-hover-effects-ultimate' ),
				'type' => Controls::CHOOSE,
				'operator' => Controls::OPERATOR_ICON,
				'default' => 'center',
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'image-hover-effects-ultimate' ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'image-hover-effects-ultimate' ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'image-hover-effects-ultimate' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'selector' => [
					'{{WRAPPER}} .oxi-image-hover-figure-front-section .oxi-image-hover-icon' => 'text-align:{{VALUE}};',
				],
				'description' => 'Allows you to set Icon Position.',
			]
        );
        $this->add_responsive_control(
            'oxi-image-flip-front-icon-width', $this->style, [
				'label' => esc_html__( 'Width & Height', 'image-hover-effects-ultimate' ),
				'type' => Controls::SLIDER,
				'default' => [
					'unit' => 'px',
					'size' => 60,
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 2000,
						'step' => 1,
					],
					'em' => [
						'min' => 0,
						'max' => 200,
						'step' => .1,
					],
					'rem' => [
						'min' => 0,
						'max' => 200,
						'step' => 0.1,
					],
				],
				'selector' => [
					'{{WRAPPER}} .oxi-image-hover-figure-front-section .oxi-image-hover-icon .oxi-icons' => 'width:{{SIZE}}{{UNIT}}; height:{{SIZE}}{{UNIT}};',
				],
				'description' => 'Allows you to Set Icon Width Height.',
			]
        );
        $this->add_responsive_control(
            'oxi-image-flip-front-icon-size', $this->style, [
				'label' => esc_html__( 'Icon Size', 'image-hover-effects-ultimate' ),
				'type' => Controls::SLIDER,
				'default' => [
					'unit' => 'px',
					'size' => 20,
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
					'em' => [
						'min' => 0,
						'max' => 100,
						'step' => .1,
					],
				],
				'selector' => [
					'{{WRAPPER}} .oxi-image-hover-figure-front-section .oxi-image-hover-icon .oxi-icons' => 'font-size:{{SIZE}}{{UNIT}};',
				],
				'description' => 'Allows you to Set Icon Size.',
			]
        );
        $this->add_control(
            'oxi-image-flip-front-icon-color', $this->style, [
				'label' => esc_html__( 'Color', 'image-hover-effects-ultimate' ),
				'type' => Controls::COLOR,
				'default' => '#b414c9',
				'selector' => [
					'{{WRAPPER}} .oxi-image-hover-figure-front-section .oxi-image-hover-icon .oxi-icons' => 'color: {{VALUE}};',
				],
				'description' => 'Color property is used to set the color of the Icon.',
			]
        );
        $this->add_group_control(
            'oxi-image-flip-front-icon-background', $this->style, [
				'type' => Controls::BACKGROUND,
				'selector' => [
					'{{WRAPPER}} .oxi-image-hover-figure-front-section .oxi-image-hover-icon .oxi-icons' => '',
				],
				'description' => 'Customize Icon Background with Color or Gradient or Image properties.',
			]
        );

        $this->add_group_control(
            'oxi-image-flip-front-icon-border', $this->style, [
				'type' => Controls::BORDER,
				'selector' => [
					'{{WRAPPER}} .oxi-image-hover-figure-front-section .oxi-image-hover-icon' => '',
				],
				'description' => 'Border property is used to set the Border of the Icon.',
			]
        );

        $this->add_responsive_control(
            'oxi-image-flip-front-icon-border-radius', $this->style, [
				'label' => esc_html__( 'Border Radius', 'image-hover-effects-ultimate' ),
				'type' => Controls::DIMENSIONS,
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 50,
						'step' => .1,
					],
					'px' => [
						'min' => -200,
						'max' => 200,
						'step' => 1,
					],
					'em' => [
						'min' => 0,
						'max' => 10,
						'step' => .1,
					],
				],
				'selector' => [
					'{{WRAPPER}} .oxi-image-hover-figure-front-section .oxi-image-hover-icon .oxi-icons,' .
					'{{WRAPPER}} .oxi-image-hover-figure-front-section  .oxi-image-hover-icon'
					=> 'border-radius:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'description' => 'Allows you to add rounded corners to Icon with 4 values.',
			]
        );
        $this->add_responsive_control(
            'oxi-image-flip-front-icon-padding', $this->style, [
				'label' => esc_html__( 'Padding', 'image-hover-effects-ultimate' ),
				'type' => Controls::DIMENSIONS,
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
					'em' => [
						'min' => 0,
						'max' => 100,
						'step' => .1,
					],
				],
				'selector' => [
					'{{WRAPPER}} .oxi-image-hover-figure-front-section .oxi-image-hover-icon ' => 'padding:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'description' => 'Padding properties are used to create space around Icon.',
			]
        );
        $this->add_responsive_control(
            'oxi-image-flip-front-icon-margin', $this->style, [
				'label' => esc_html__( 'Margin', 'image-hover-effects-ultimate' ),
				'type' => Controls::DIMENSIONS,
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
					'em' => [
						'min' => 0,
						'max' => 100,
						'step' => .1,
					],
				],
				'selector' => [
					'{{WRAPPER}} .oxi-image-hover-figure-front-section .oxi-image-hover-icon-section ' => 'padding:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'description' => 'Margin properties are used to create space outside Icon.',
			]
        );
        $this->end_controls_section();
    }

    public function register_backend_tabs() {
        $this->start_section_tabs(
            'oxi-image-hover-start-tabs', [
				'condition' => [
					'oxi-image-hover-start-tabs' => 'backend',
				],
			]
        );
        $this->start_section_devider();
        $this->register_back_content_settings();
        $this->register_back_description_settings();
        $this->end_section_devider();

        $this->start_section_devider();
        $this->register_back_heading_settings();
        $this->register_back_button_settings();
        $this->end_section_devider();

        $this->end_section_tabs();
    }

    public function modal_form_data() {
        ?>
        <div class="modal-header">
            <h4 class="modal-title">Image Hover Form</h4>
            <button type="button" class="close" data-dismiss="modal">&times;</button>
        </div>
        <div class="modal-body">
            <?php
            $this->add_control(
                'image_hover_front_heading', $this->style, [
					'label' => esc_html__( 'Front Title', 'image-hover-effects-ultimate' ),
					'type' => Controls::TEXT,
					'default' => '',
					'placeholder' => 'Heading',
					'description' => 'Add Your Flipbox Front Title.',
				]
            );
            $this->add_control(
                'image_hover_back_heading', $this->style, [
					'label' => esc_html__( 'Backend Title', 'image-hover-effects-ultimate' ),
					'type' => Controls::TEXT,
					'default' => '',
					'placeholder' => 'Heading',
					'description' => 'Add Your Flipbox Backend Title.',
				]
            );
            $this->add_control(
                'image_hover_front_icon', $this->style, [
					'label' => esc_html__( 'Front Icon', 'image-hover-effects-ultimate' ),
					'type' => Controls::ICON,
					'description' => 'Add Your Flipbox Front Icon.',
				]
            );

            $this->add_control(
                'image_hover_front_description', $this->style, [
					'label' => esc_html__( 'Front Description', 'image-hover-effects-ultimate' ),
					'type' => Controls::TEXTAREA,
					'description' => 'Add Your Front Description Unless make it blank.',
				]
            );
            $this->add_control(
                'image_hover_back_description', $this->style, [
					'label' => esc_html__( 'Backend Description', 'image-hover-effects-ultimate' ),
					'type' => Controls::TEXTAREA,
					'description' => 'Add Your Backend Description Unless make it blank.',
				]
            );

            $this->start_controls_tabs(
                'image_hover-start-tabs', [
					'separator' => true,
					'options' => [
						'frontend' => esc_html__( 'Front Image', 'image-hover-effects-ultimate' ),
						'backend' => esc_html__( 'Backend Image', 'image-hover-effects-ultimate' ),
					],
				]
            );
            $this->start_controls_tab();

            $this->add_group_control(
                'image_hover_front_image', $this->style, [
					'label' => esc_html__( 'Image', 'image-hover-effects-ultimate' ),
					'type' => Controls::MEDIA,
					'description' => 'Add or Modify Your Front Image. Adjust Front background to get better design.',
				]
            );

            $this->end_controls_tab();

            $this->start_controls_tab();
            $this->add_group_control(
                'image_hover_back_image', $this->style, [
					'label' => esc_html__( 'Feature Image', 'image-hover-effects-ultimate' ),
					'type' => Controls::MEDIA,
					'description' => 'Add or Modify Your Backend Image. Adjust Backend background to get better design.',
				]
            );
            $this->end_controls_tab();
            $this->end_controls_tabs();

            $this->add_group_control(
                'image_hover_button_link', $this->style, [
					'label' => esc_html__( 'URL', 'image-hover-effects-ultimate' ),
					'type' => Controls::URL,
					'separator' => true,
					'default' => '',
					'placeholder' => 'https://www.yoururl.com',
					'description' => 'Add Your Desire Link or Url Unless make it blank',
				]
            );
            $this->add_control(
                'image_hover_button_text', $this->style, [
					'label' => esc_html__( 'Button Text', 'image-hover-effects-ultimate' ),
					'type' => Controls::TEXT,
					'default' => '',
					'description' => 'Customize your button text. Button will only view while Url given',
				]
            );
            ?>
        </div>
        <?php
    }

    /**
     * Template Parent Item Data Rearrange
     *
     * @since 2.0.0
     */
    public function Rearrange() {
        return '<li class="list-group-item" id="{{id}}">{{image_hover_front_heading}}</li>';
    }
}
