<?php

namespace OXI_IMAGE_HOVER_PLUGINS\Modules\Caption\Admin;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Description of Effects26
 *
 * @author biplo
 */
use OXI_IMAGE_HOVER_PLUGINS\Modules\Caption\Modules;
use OXI_IMAGE_HOVER_PLUGINS\Classes\Controls;

class Effects26 extends Modules {

    public function register_effects() {
        return $this->add_control(
            'image_hover_effects', $this->style, [
				'label' => esc_html__( 'Effects Direction', 'image-hover-effects-ultimate' ),
				'type' => Controls::SELECT,
				'default' => '',
				'options' => [
					'oxi-image-splash-up' => esc_html__( 'Splash Up', 'image-hover-effects-ultimate' ),
					'oxi-image-splash-down' => esc_html__( 'Splash Down', 'image-hover-effects-ultimate' ),
					'oxi-image-splash-left' => esc_html__( 'Splash Left', 'image-hover-effects-ultimate' ),
					'oxi-image-splash-right' => esc_html__( 'Splash Right', 'image-hover-effects-ultimate' ),
				],
				'selector' => [
					'{{WRAPPER}} .oxi-image-caption-hover' => '',
				],
				'simpledescription' => 'Allows you to Set Effects Direction.',
				'description' => 'Allows you to Set Effects Direction.',
			]
        );
    }
}
