<?php

namespace OXI_IMAGE_HOVER_PLUGINS\Modules\Caption\Admin;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Description of Effects2
 *
 * @author biplo
 */
use OXI_IMAGE_HOVER_PLUGINS\Modules\Caption\Modules;
use OXI_IMAGE_HOVER_PLUGINS\Classes\Controls;

class Effects11 extends Modules {

    public function register_effects() {
        return $this->add_control(
            'image_hover_effects', $this->style, [
				'label' => esc_html__( 'Effects Direction', 'image-hover-effects-ultimate' ),
				'type' => Controls::SELECT,
				'default' => '',
				'options' => [
					'oxi-image-flash-top-left' => esc_html__( 'Flash Top Left', 'image-hover-effects-ultimate' ),
					'oxi-image-flash-top-right' => esc_html__( 'Flash Top Right', 'image-hover-effects-ultimate' ),
					'oxi-image-flash-bottom-left' => esc_html__( 'Flash Bottom Left', 'image-hover-effects-ultimate' ),
					'oxi-image-flash-bottom-right' => esc_html__( 'Flash Bottom Right', 'image-hover-effects-ultimate' ),
				],
				'selector' => [
					'{{WRAPPER}} .oxi-image-caption-hover' => '',
				],
				'simpledescription' => 'Allows you to Set Effects Direction.',
				'description' => 'Allows you to Set Effects Direction.',
			]
        );
    }
}
