<?php

namespace OXI_IMAGE_HOVER_PLUGINS\Modules\Caption\Admin;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Description of Effects2
 *
 * @author biplo
 */
use OXI_IMAGE_HOVER_PLUGINS\Modules\Caption\Modules;
use OXI_IMAGE_HOVER_PLUGINS\Classes\Controls;

class Effects10 extends Modules {

    public function register_effects() {
        return $this->add_control(
            'image_hover_effects', $this->style, [
				'label' => esc_html__( 'Effects Direction', 'image-hover-effects-ultimate' ),
				'type' => Controls::SELECT,
				'default' => '',
				'options' => [
					'oxi-image-fall-away-horizontal' => esc_html__( 'Fall Away Horizontal', 'image-hover-effects-ultimate' ),
					'oxi-image-fall-away-vertical' => esc_html__( 'Fall Away Vertical', 'image-hover-effects-ultimate' ),
					'oxi-image-fall-away-cc' => esc_html__( 'Fall Away CC', 'image-hover-effects-ultimate' ),
					'oxi-image-fall-away-ccc' => esc_html__( 'Fall Away CCC', 'image-hover-effects-ultimate' ),
				],
				'selector' => [
					'{{WRAPPER}} .oxi-image-caption-hover' => '',
				],
				'simpledescription' => 'Allows you to Set Effects Direction.',
				'description' => 'Allows you to Set Effects Direction.',
			]
        );
    }
}
