<?php

/**
 * Mux PHP - Copyright 2019 Mux Inc.
 * NOTE: This file is auto generated. Do not edit this file manually.
 */

namespace MediaCloud\Vendor\MuxPhp\Models;

use \ArrayAccess;
use \MediaCloud\Vendor\MuxPhp\ObjectSerializer;

/**
 * VideoView Class Doc Comment
 *
 * @category Class
 * @package  MuxPhp
 */
class VideoView implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static $openAPIModelName = 'VideoView';

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @var string[]
     */
    protected static $openAPITypes = [
        'view_total_upscaling' => 'string',
        'preroll_ad_asset_hostname' => 'string',
        'player_source_domain' => 'string',
        'region' => 'string',
        'viewer_user_agent' => 'string',
        'preroll_requested' => 'bool',
        'page_type' => 'string',
        'startup_score' => 'string',
        'view_seek_duration' => 'int',
        'country_name' => 'string',
        'player_source_height' => 'int',
        'longitude' => 'string',
        'buffering_count' => 'int',
        'video_duration' => 'int',
        'player_source_type' => 'string',
        'city' => 'string',
        'view_id' => 'string',
        'platform_description' => 'string',
        'video_startup_preroll_request_time' => 'int',
        'viewer_device_name' => 'string',
        'video_series' => 'string',
        'viewer_application_name' => 'string',
        'updated_at' => 'string',
        'view_total_content_playback_time' => 'int',
        'cdn' => 'string',
        'player_instance_id' => 'string',
        'video_language' => 'string',
        'player_source_width' => 'int',
        'player_error_message' => 'string',
        'player_mux_plugin_version' => 'string',
        'watched' => 'bool',
        'playback_score' => 'string',
        'page_url' => 'string',
        'metro' => 'string',
        'view_max_request_latency' => 'int',
        'requests_for_first_preroll' => 'int',
        'view_total_downscaling' => 'string',
        'latitude' => 'string',
        'player_source_host_name' => 'string',
        'inserted_at' => 'string',
        'view_end' => 'string',
        'mux_embed_version' => 'string',
        'player_language' => 'string',
        'page_load_time' => 'int',
        'viewer_device_category' => 'string',
        'video_startup_preroll_load_time' => 'int',
        'player_version' => 'string',
        'watch_time' => 'int',
        'player_source_stream_type' => 'string',
        'preroll_ad_tag_hostname' => 'string',
        'viewer_device_manufacturer' => 'string',
        'rebuffering_score' => 'string',
        'experiment_name' => 'string',
        'viewer_os_version' => 'string',
        'player_preload' => 'bool',
        'buffering_duration' => 'int',
        'player_view_count' => 'int',
        'player_software' => 'string',
        'player_load_time' => 'int',
        'platform_summary' => 'string',
        'video_encoding_variant' => 'string',
        'player_width' => 'int',
        'view_seek_count' => 'int',
        'viewer_experience_score' => 'string',
        'view_error_id' => 'int',
        'video_variant_name' => 'string',
        'preroll_played' => 'bool',
        'viewer_application_engine' => 'string',
        'viewer_os_architecture' => 'string',
        'player_error_code' => 'string',
        'buffering_rate' => 'string',
        'events' => '\MediaCloud\Vendor\MuxPhp\Models\VideoViewEvent[]',
        'player_name' => 'string',
        'view_start' => 'string',
        'view_average_request_throughput' => 'int',
        'video_producer' => 'string',
        'error_type_id' => 'int',
        'mux_viewer_id' => 'string',
        'video_id' => 'string',
        'continent_code' => 'string',
        'session_id' => 'string',
        'exit_before_video_start' => 'bool',
        'video_content_type' => 'string',
        'viewer_os_family' => 'string',
        'player_poster' => 'string',
        'view_average_request_latency' => 'int',
        'video_variant_id' => 'string',
        'player_source_duration' => 'int',
        'player_source_url' => 'string',
        'mux_api_version' => 'string',
        'video_title' => 'string',
        'id' => 'string',
        'short_time' => 'string',
        'rebuffer_percentage' => 'string',
        'time_to_first_frame' => 'int',
        'viewer_user_id' => 'string',
        'video_stream_type' => 'string',
        'player_startup_time' => 'int',
        'viewer_application_version' => 'string',
        'view_max_downscale_percentage' => 'string',
        'view_max_upscale_percentage' => 'string',
        'country_code' => 'string',
        'used_fullscreen' => 'bool',
        'isp' => 'string',
        'property_id' => 'int',
        'player_autoplay' => 'bool',
        'player_height' => 'int',
        'asn' => 'int',
        'asn_name' => 'string',
        'quality_score' => 'string',
        'player_software_version' => 'string',
        'player_mux_plugin_name' => 'string'
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @var string[]
     */
    protected static $openAPIFormats = [
        'view_total_upscaling' => null,
        'preroll_ad_asset_hostname' => null,
        'player_source_domain' => null,
        'region' => null,
        'viewer_user_agent' => null,
        'preroll_requested' => null,
        'page_type' => null,
        'startup_score' => null,
        'view_seek_duration' => 'int64',
        'country_name' => null,
        'player_source_height' => 'int32',
        'longitude' => null,
        'buffering_count' => 'int64',
        'video_duration' => 'int64',
        'player_source_type' => null,
        'city' => null,
        'view_id' => null,
        'platform_description' => null,
        'video_startup_preroll_request_time' => 'int64',
        'viewer_device_name' => null,
        'video_series' => null,
        'viewer_application_name' => null,
        'updated_at' => null,
        'view_total_content_playback_time' => 'int64',
        'cdn' => null,
        'player_instance_id' => null,
        'video_language' => null,
        'player_source_width' => 'int32',
        'player_error_message' => null,
        'player_mux_plugin_version' => null,
        'watched' => null,
        'playback_score' => null,
        'page_url' => null,
        'metro' => null,
        'view_max_request_latency' => 'int64',
        'requests_for_first_preroll' => 'int64',
        'view_total_downscaling' => null,
        'latitude' => null,
        'player_source_host_name' => null,
        'inserted_at' => null,
        'view_end' => null,
        'mux_embed_version' => null,
        'player_language' => null,
        'page_load_time' => 'int64',
        'viewer_device_category' => null,
        'video_startup_preroll_load_time' => 'int64',
        'player_version' => null,
        'watch_time' => 'int64',
        'player_source_stream_type' => null,
        'preroll_ad_tag_hostname' => null,
        'viewer_device_manufacturer' => null,
        'rebuffering_score' => null,
        'experiment_name' => null,
        'viewer_os_version' => null,
        'player_preload' => null,
        'buffering_duration' => 'int64',
        'player_view_count' => 'int64',
        'player_software' => null,
        'player_load_time' => 'int64',
        'platform_summary' => null,
        'video_encoding_variant' => null,
        'player_width' => 'int32',
        'view_seek_count' => 'int64',
        'viewer_experience_score' => null,
        'view_error_id' => 'int32',
        'video_variant_name' => null,
        'preroll_played' => null,
        'viewer_application_engine' => null,
        'viewer_os_architecture' => null,
        'player_error_code' => null,
        'buffering_rate' => null,
        'events' => null,
        'player_name' => null,
        'view_start' => null,
        'view_average_request_throughput' => 'int64',
        'video_producer' => null,
        'error_type_id' => 'int32',
        'mux_viewer_id' => null,
        'video_id' => null,
        'continent_code' => null,
        'session_id' => null,
        'exit_before_video_start' => null,
        'video_content_type' => null,
        'viewer_os_family' => null,
        'player_poster' => null,
        'view_average_request_latency' => 'int64',
        'video_variant_id' => null,
        'player_source_duration' => 'int64',
        'player_source_url' => null,
        'mux_api_version' => null,
        'video_title' => null,
        'id' => null,
        'short_time' => null,
        'rebuffer_percentage' => null,
        'time_to_first_frame' => 'int64',
        'viewer_user_id' => null,
        'video_stream_type' => null,
        'player_startup_time' => 'int64',
        'viewer_application_version' => null,
        'view_max_downscale_percentage' => null,
        'view_max_upscale_percentage' => null,
        'country_code' => null,
        'used_fullscreen' => null,
        'isp' => null,
        'property_id' => 'int64',
        'player_autoplay' => null,
        'player_height' => 'int32',
        'asn' => 'int64',
        'asn_name' => null,
        'quality_score' => null,
        'player_software_version' => null,
        'player_mux_plugin_name' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'view_total_upscaling' => 'view_total_upscaling',
        'preroll_ad_asset_hostname' => 'preroll_ad_asset_hostname',
        'player_source_domain' => 'player_source_domain',
        'region' => 'region',
        'viewer_user_agent' => 'viewer_user_agent',
        'preroll_requested' => 'preroll_requested',
        'page_type' => 'page_type',
        'startup_score' => 'startup_score',
        'view_seek_duration' => 'view_seek_duration',
        'country_name' => 'country_name',
        'player_source_height' => 'player_source_height',
        'longitude' => 'longitude',
        'buffering_count' => 'buffering_count',
        'video_duration' => 'video_duration',
        'player_source_type' => 'player_source_type',
        'city' => 'city',
        'view_id' => 'view_id',
        'platform_description' => 'platform_description',
        'video_startup_preroll_request_time' => 'video_startup_preroll_request_time',
        'viewer_device_name' => 'viewer_device_name',
        'video_series' => 'video_series',
        'viewer_application_name' => 'viewer_application_name',
        'updated_at' => 'updated_at',
        'view_total_content_playback_time' => 'view_total_content_playback_time',
        'cdn' => 'cdn',
        'player_instance_id' => 'player_instance_id',
        'video_language' => 'video_language',
        'player_source_width' => 'player_source_width',
        'player_error_message' => 'player_error_message',
        'player_mux_plugin_version' => 'player_mux_plugin_version',
        'watched' => 'watched',
        'playback_score' => 'playback_score',
        'page_url' => 'page_url',
        'metro' => 'metro',
        'view_max_request_latency' => 'view_max_request_latency',
        'requests_for_first_preroll' => 'requests_for_first_preroll',
        'view_total_downscaling' => 'view_total_downscaling',
        'latitude' => 'latitude',
        'player_source_host_name' => 'player_source_host_name',
        'inserted_at' => 'inserted_at',
        'view_end' => 'view_end',
        'mux_embed_version' => 'mux_embed_version',
        'player_language' => 'player_language',
        'page_load_time' => 'page_load_time',
        'viewer_device_category' => 'viewer_device_category',
        'video_startup_preroll_load_time' => 'video_startup_preroll_load_time',
        'player_version' => 'player_version',
        'watch_time' => 'watch_time',
        'player_source_stream_type' => 'player_source_stream_type',
        'preroll_ad_tag_hostname' => 'preroll_ad_tag_hostname',
        'viewer_device_manufacturer' => 'viewer_device_manufacturer',
        'rebuffering_score' => 'rebuffering_score',
        'experiment_name' => 'experiment_name',
        'viewer_os_version' => 'viewer_os_version',
        'player_preload' => 'player_preload',
        'buffering_duration' => 'buffering_duration',
        'player_view_count' => 'player_view_count',
        'player_software' => 'player_software',
        'player_load_time' => 'player_load_time',
        'platform_summary' => 'platform_summary',
        'video_encoding_variant' => 'video_encoding_variant',
        'player_width' => 'player_width',
        'view_seek_count' => 'view_seek_count',
        'viewer_experience_score' => 'viewer_experience_score',
        'view_error_id' => 'view_error_id',
        'video_variant_name' => 'video_variant_name',
        'preroll_played' => 'preroll_played',
        'viewer_application_engine' => 'viewer_application_engine',
        'viewer_os_architecture' => 'viewer_os_architecture',
        'player_error_code' => 'player_error_code',
        'buffering_rate' => 'buffering_rate',
        'events' => 'events',
        'player_name' => 'player_name',
        'view_start' => 'view_start',
        'view_average_request_throughput' => 'view_average_request_throughput',
        'video_producer' => 'video_producer',
        'error_type_id' => 'error_type_id',
        'mux_viewer_id' => 'mux_viewer_id',
        'video_id' => 'video_id',
        'continent_code' => 'continent_code',
        'session_id' => 'session_id',
        'exit_before_video_start' => 'exit_before_video_start',
        'video_content_type' => 'video_content_type',
        'viewer_os_family' => 'viewer_os_family',
        'player_poster' => 'player_poster',
        'view_average_request_latency' => 'view_average_request_latency',
        'video_variant_id' => 'video_variant_id',
        'player_source_duration' => 'player_source_duration',
        'player_source_url' => 'player_source_url',
        'mux_api_version' => 'mux_api_version',
        'video_title' => 'video_title',
        'id' => 'id',
        'short_time' => 'short_time',
        'rebuffer_percentage' => 'rebuffer_percentage',
        'time_to_first_frame' => 'time_to_first_frame',
        'viewer_user_id' => 'viewer_user_id',
        'video_stream_type' => 'video_stream_type',
        'player_startup_time' => 'player_startup_time',
        'viewer_application_version' => 'viewer_application_version',
        'view_max_downscale_percentage' => 'view_max_downscale_percentage',
        'view_max_upscale_percentage' => 'view_max_upscale_percentage',
        'country_code' => 'country_code',
        'used_fullscreen' => 'used_fullscreen',
        'isp' => 'isp',
        'property_id' => 'property_id',
        'player_autoplay' => 'player_autoplay',
        'player_height' => 'player_height',
        'asn' => 'asn',
        'asn_name' => 'asn_name',
        'quality_score' => 'quality_score',
        'player_software_version' => 'player_software_version',
        'player_mux_plugin_name' => 'player_mux_plugin_name'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'view_total_upscaling' => 'setViewTotalUpscaling',
        'preroll_ad_asset_hostname' => 'setPrerollAdAssetHostname',
        'player_source_domain' => 'setPlayerSourceDomain',
        'region' => 'setRegion',
        'viewer_user_agent' => 'setViewerUserAgent',
        'preroll_requested' => 'setPrerollRequested',
        'page_type' => 'setPageType',
        'startup_score' => 'setStartupScore',
        'view_seek_duration' => 'setViewSeekDuration',
        'country_name' => 'setCountryName',
        'player_source_height' => 'setPlayerSourceHeight',
        'longitude' => 'setLongitude',
        'buffering_count' => 'setBufferingCount',
        'video_duration' => 'setVideoDuration',
        'player_source_type' => 'setPlayerSourceType',
        'city' => 'setCity',
        'view_id' => 'setViewId',
        'platform_description' => 'setPlatformDescription',
        'video_startup_preroll_request_time' => 'setVideoStartupPrerollRequestTime',
        'viewer_device_name' => 'setViewerDeviceName',
        'video_series' => 'setVideoSeries',
        'viewer_application_name' => 'setViewerApplicationName',
        'updated_at' => 'setUpdatedAt',
        'view_total_content_playback_time' => 'setViewTotalContentPlaybackTime',
        'cdn' => 'setCdn',
        'player_instance_id' => 'setPlayerInstanceId',
        'video_language' => 'setVideoLanguage',
        'player_source_width' => 'setPlayerSourceWidth',
        'player_error_message' => 'setPlayerErrorMessage',
        'player_mux_plugin_version' => 'setPlayerMuxPluginVersion',
        'watched' => 'setWatched',
        'playback_score' => 'setPlaybackScore',
        'page_url' => 'setPageUrl',
        'metro' => 'setMetro',
        'view_max_request_latency' => 'setViewMaxRequestLatency',
        'requests_for_first_preroll' => 'setRequestsForFirstPreroll',
        'view_total_downscaling' => 'setViewTotalDownscaling',
        'latitude' => 'setLatitude',
        'player_source_host_name' => 'setPlayerSourceHostName',
        'inserted_at' => 'setInsertedAt',
        'view_end' => 'setViewEnd',
        'mux_embed_version' => 'setMuxEmbedVersion',
        'player_language' => 'setPlayerLanguage',
        'page_load_time' => 'setPageLoadTime',
        'viewer_device_category' => 'setViewerDeviceCategory',
        'video_startup_preroll_load_time' => 'setVideoStartupPrerollLoadTime',
        'player_version' => 'setPlayerVersion',
        'watch_time' => 'setWatchTime',
        'player_source_stream_type' => 'setPlayerSourceStreamType',
        'preroll_ad_tag_hostname' => 'setPrerollAdTagHostname',
        'viewer_device_manufacturer' => 'setViewerDeviceManufacturer',
        'rebuffering_score' => 'setRebufferingScore',
        'experiment_name' => 'setExperimentName',
        'viewer_os_version' => 'setViewerOsVersion',
        'player_preload' => 'setPlayerPreload',
        'buffering_duration' => 'setBufferingDuration',
        'player_view_count' => 'setPlayerViewCount',
        'player_software' => 'setPlayerSoftware',
        'player_load_time' => 'setPlayerLoadTime',
        'platform_summary' => 'setPlatformSummary',
        'video_encoding_variant' => 'setVideoEncodingVariant',
        'player_width' => 'setPlayerWidth',
        'view_seek_count' => 'setViewSeekCount',
        'viewer_experience_score' => 'setViewerExperienceScore',
        'view_error_id' => 'setViewErrorId',
        'video_variant_name' => 'setVideoVariantName',
        'preroll_played' => 'setPrerollPlayed',
        'viewer_application_engine' => 'setViewerApplicationEngine',
        'viewer_os_architecture' => 'setViewerOsArchitecture',
        'player_error_code' => 'setPlayerErrorCode',
        'buffering_rate' => 'setBufferingRate',
        'events' => 'setEvents',
        'player_name' => 'setPlayerName',
        'view_start' => 'setViewStart',
        'view_average_request_throughput' => 'setViewAverageRequestThroughput',
        'video_producer' => 'setVideoProducer',
        'error_type_id' => 'setErrorTypeId',
        'mux_viewer_id' => 'setMuxViewerId',
        'video_id' => 'setVideoId',
        'continent_code' => 'setContinentCode',
        'session_id' => 'setSessionId',
        'exit_before_video_start' => 'setExitBeforeVideoStart',
        'video_content_type' => 'setVideoContentType',
        'viewer_os_family' => 'setViewerOsFamily',
        'player_poster' => 'setPlayerPoster',
        'view_average_request_latency' => 'setViewAverageRequestLatency',
        'video_variant_id' => 'setVideoVariantId',
        'player_source_duration' => 'setPlayerSourceDuration',
        'player_source_url' => 'setPlayerSourceUrl',
        'mux_api_version' => 'setMuxApiVersion',
        'video_title' => 'setVideoTitle',
        'id' => 'setId',
        'short_time' => 'setShortTime',
        'rebuffer_percentage' => 'setRebufferPercentage',
        'time_to_first_frame' => 'setTimeToFirstFrame',
        'viewer_user_id' => 'setViewerUserId',
        'video_stream_type' => 'setVideoStreamType',
        'player_startup_time' => 'setPlayerStartupTime',
        'viewer_application_version' => 'setViewerApplicationVersion',
        'view_max_downscale_percentage' => 'setViewMaxDownscalePercentage',
        'view_max_upscale_percentage' => 'setViewMaxUpscalePercentage',
        'country_code' => 'setCountryCode',
        'used_fullscreen' => 'setUsedFullscreen',
        'isp' => 'setIsp',
        'property_id' => 'setPropertyId',
        'player_autoplay' => 'setPlayerAutoplay',
        'player_height' => 'setPlayerHeight',
        'asn' => 'setAsn',
        'asn_name' => 'setAsnName',
        'quality_score' => 'setQualityScore',
        'player_software_version' => 'setPlayerSoftwareVersion',
        'player_mux_plugin_name' => 'setPlayerMuxPluginName'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'view_total_upscaling' => 'getViewTotalUpscaling',
        'preroll_ad_asset_hostname' => 'getPrerollAdAssetHostname',
        'player_source_domain' => 'getPlayerSourceDomain',
        'region' => 'getRegion',
        'viewer_user_agent' => 'getViewerUserAgent',
        'preroll_requested' => 'getPrerollRequested',
        'page_type' => 'getPageType',
        'startup_score' => 'getStartupScore',
        'view_seek_duration' => 'getViewSeekDuration',
        'country_name' => 'getCountryName',
        'player_source_height' => 'getPlayerSourceHeight',
        'longitude' => 'getLongitude',
        'buffering_count' => 'getBufferingCount',
        'video_duration' => 'getVideoDuration',
        'player_source_type' => 'getPlayerSourceType',
        'city' => 'getCity',
        'view_id' => 'getViewId',
        'platform_description' => 'getPlatformDescription',
        'video_startup_preroll_request_time' => 'getVideoStartupPrerollRequestTime',
        'viewer_device_name' => 'getViewerDeviceName',
        'video_series' => 'getVideoSeries',
        'viewer_application_name' => 'getViewerApplicationName',
        'updated_at' => 'getUpdatedAt',
        'view_total_content_playback_time' => 'getViewTotalContentPlaybackTime',
        'cdn' => 'getCdn',
        'player_instance_id' => 'getPlayerInstanceId',
        'video_language' => 'getVideoLanguage',
        'player_source_width' => 'getPlayerSourceWidth',
        'player_error_message' => 'getPlayerErrorMessage',
        'player_mux_plugin_version' => 'getPlayerMuxPluginVersion',
        'watched' => 'getWatched',
        'playback_score' => 'getPlaybackScore',
        'page_url' => 'getPageUrl',
        'metro' => 'getMetro',
        'view_max_request_latency' => 'getViewMaxRequestLatency',
        'requests_for_first_preroll' => 'getRequestsForFirstPreroll',
        'view_total_downscaling' => 'getViewTotalDownscaling',
        'latitude' => 'getLatitude',
        'player_source_host_name' => 'getPlayerSourceHostName',
        'inserted_at' => 'getInsertedAt',
        'view_end' => 'getViewEnd',
        'mux_embed_version' => 'getMuxEmbedVersion',
        'player_language' => 'getPlayerLanguage',
        'page_load_time' => 'getPageLoadTime',
        'viewer_device_category' => 'getViewerDeviceCategory',
        'video_startup_preroll_load_time' => 'getVideoStartupPrerollLoadTime',
        'player_version' => 'getPlayerVersion',
        'watch_time' => 'getWatchTime',
        'player_source_stream_type' => 'getPlayerSourceStreamType',
        'preroll_ad_tag_hostname' => 'getPrerollAdTagHostname',
        'viewer_device_manufacturer' => 'getViewerDeviceManufacturer',
        'rebuffering_score' => 'getRebufferingScore',
        'experiment_name' => 'getExperimentName',
        'viewer_os_version' => 'getViewerOsVersion',
        'player_preload' => 'getPlayerPreload',
        'buffering_duration' => 'getBufferingDuration',
        'player_view_count' => 'getPlayerViewCount',
        'player_software' => 'getPlayerSoftware',
        'player_load_time' => 'getPlayerLoadTime',
        'platform_summary' => 'getPlatformSummary',
        'video_encoding_variant' => 'getVideoEncodingVariant',
        'player_width' => 'getPlayerWidth',
        'view_seek_count' => 'getViewSeekCount',
        'viewer_experience_score' => 'getViewerExperienceScore',
        'view_error_id' => 'getViewErrorId',
        'video_variant_name' => 'getVideoVariantName',
        'preroll_played' => 'getPrerollPlayed',
        'viewer_application_engine' => 'getViewerApplicationEngine',
        'viewer_os_architecture' => 'getViewerOsArchitecture',
        'player_error_code' => 'getPlayerErrorCode',
        'buffering_rate' => 'getBufferingRate',
        'events' => 'getEvents',
        'player_name' => 'getPlayerName',
        'view_start' => 'getViewStart',
        'view_average_request_throughput' => 'getViewAverageRequestThroughput',
        'video_producer' => 'getVideoProducer',
        'error_type_id' => 'getErrorTypeId',
        'mux_viewer_id' => 'getMuxViewerId',
        'video_id' => 'getVideoId',
        'continent_code' => 'getContinentCode',
        'session_id' => 'getSessionId',
        'exit_before_video_start' => 'getExitBeforeVideoStart',
        'video_content_type' => 'getVideoContentType',
        'viewer_os_family' => 'getViewerOsFamily',
        'player_poster' => 'getPlayerPoster',
        'view_average_request_latency' => 'getViewAverageRequestLatency',
        'video_variant_id' => 'getVideoVariantId',
        'player_source_duration' => 'getPlayerSourceDuration',
        'player_source_url' => 'getPlayerSourceUrl',
        'mux_api_version' => 'getMuxApiVersion',
        'video_title' => 'getVideoTitle',
        'id' => 'getId',
        'short_time' => 'getShortTime',
        'rebuffer_percentage' => 'getRebufferPercentage',
        'time_to_first_frame' => 'getTimeToFirstFrame',
        'viewer_user_id' => 'getViewerUserId',
        'video_stream_type' => 'getVideoStreamType',
        'player_startup_time' => 'getPlayerStartupTime',
        'viewer_application_version' => 'getViewerApplicationVersion',
        'view_max_downscale_percentage' => 'getViewMaxDownscalePercentage',
        'view_max_upscale_percentage' => 'getViewMaxUpscalePercentage',
        'country_code' => 'getCountryCode',
        'used_fullscreen' => 'getUsedFullscreen',
        'isp' => 'getIsp',
        'property_id' => 'getPropertyId',
        'player_autoplay' => 'getPlayerAutoplay',
        'player_height' => 'getPlayerHeight',
        'asn' => 'getAsn',
        'asn_name' => 'getAsnName',
        'quality_score' => 'getQualityScore',
        'player_software_version' => 'getPlayerSoftwareVersion',
        'player_mux_plugin_name' => 'getPlayerMuxPluginName'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['view_total_upscaling'] = isset($data['view_total_upscaling']) ? $data['view_total_upscaling'] : null;
        $this->container['preroll_ad_asset_hostname'] = isset($data['preroll_ad_asset_hostname']) ? $data['preroll_ad_asset_hostname'] : null;
        $this->container['player_source_domain'] = isset($data['player_source_domain']) ? $data['player_source_domain'] : null;
        $this->container['region'] = isset($data['region']) ? $data['region'] : null;
        $this->container['viewer_user_agent'] = isset($data['viewer_user_agent']) ? $data['viewer_user_agent'] : null;
        $this->container['preroll_requested'] = isset($data['preroll_requested']) ? $data['preroll_requested'] : null;
        $this->container['page_type'] = isset($data['page_type']) ? $data['page_type'] : null;
        $this->container['startup_score'] = isset($data['startup_score']) ? $data['startup_score'] : null;
        $this->container['view_seek_duration'] = isset($data['view_seek_duration']) ? $data['view_seek_duration'] : null;
        $this->container['country_name'] = isset($data['country_name']) ? $data['country_name'] : null;
        $this->container['player_source_height'] = isset($data['player_source_height']) ? $data['player_source_height'] : null;
        $this->container['longitude'] = isset($data['longitude']) ? $data['longitude'] : null;
        $this->container['buffering_count'] = isset($data['buffering_count']) ? $data['buffering_count'] : null;
        $this->container['video_duration'] = isset($data['video_duration']) ? $data['video_duration'] : null;
        $this->container['player_source_type'] = isset($data['player_source_type']) ? $data['player_source_type'] : null;
        $this->container['city'] = isset($data['city']) ? $data['city'] : null;
        $this->container['view_id'] = isset($data['view_id']) ? $data['view_id'] : null;
        $this->container['platform_description'] = isset($data['platform_description']) ? $data['platform_description'] : null;
        $this->container['video_startup_preroll_request_time'] = isset($data['video_startup_preroll_request_time']) ? $data['video_startup_preroll_request_time'] : null;
        $this->container['viewer_device_name'] = isset($data['viewer_device_name']) ? $data['viewer_device_name'] : null;
        $this->container['video_series'] = isset($data['video_series']) ? $data['video_series'] : null;
        $this->container['viewer_application_name'] = isset($data['viewer_application_name']) ? $data['viewer_application_name'] : null;
        $this->container['updated_at'] = isset($data['updated_at']) ? $data['updated_at'] : null;
        $this->container['view_total_content_playback_time'] = isset($data['view_total_content_playback_time']) ? $data['view_total_content_playback_time'] : null;
        $this->container['cdn'] = isset($data['cdn']) ? $data['cdn'] : null;
        $this->container['player_instance_id'] = isset($data['player_instance_id']) ? $data['player_instance_id'] : null;
        $this->container['video_language'] = isset($data['video_language']) ? $data['video_language'] : null;
        $this->container['player_source_width'] = isset($data['player_source_width']) ? $data['player_source_width'] : null;
        $this->container['player_error_message'] = isset($data['player_error_message']) ? $data['player_error_message'] : null;
        $this->container['player_mux_plugin_version'] = isset($data['player_mux_plugin_version']) ? $data['player_mux_plugin_version'] : null;
        $this->container['watched'] = isset($data['watched']) ? $data['watched'] : null;
        $this->container['playback_score'] = isset($data['playback_score']) ? $data['playback_score'] : null;
        $this->container['page_url'] = isset($data['page_url']) ? $data['page_url'] : null;
        $this->container['metro'] = isset($data['metro']) ? $data['metro'] : null;
        $this->container['view_max_request_latency'] = isset($data['view_max_request_latency']) ? $data['view_max_request_latency'] : null;
        $this->container['requests_for_first_preroll'] = isset($data['requests_for_first_preroll']) ? $data['requests_for_first_preroll'] : null;
        $this->container['view_total_downscaling'] = isset($data['view_total_downscaling']) ? $data['view_total_downscaling'] : null;
        $this->container['latitude'] = isset($data['latitude']) ? $data['latitude'] : null;
        $this->container['player_source_host_name'] = isset($data['player_source_host_name']) ? $data['player_source_host_name'] : null;
        $this->container['inserted_at'] = isset($data['inserted_at']) ? $data['inserted_at'] : null;
        $this->container['view_end'] = isset($data['view_end']) ? $data['view_end'] : null;
        $this->container['mux_embed_version'] = isset($data['mux_embed_version']) ? $data['mux_embed_version'] : null;
        $this->container['player_language'] = isset($data['player_language']) ? $data['player_language'] : null;
        $this->container['page_load_time'] = isset($data['page_load_time']) ? $data['page_load_time'] : null;
        $this->container['viewer_device_category'] = isset($data['viewer_device_category']) ? $data['viewer_device_category'] : null;
        $this->container['video_startup_preroll_load_time'] = isset($data['video_startup_preroll_load_time']) ? $data['video_startup_preroll_load_time'] : null;
        $this->container['player_version'] = isset($data['player_version']) ? $data['player_version'] : null;
        $this->container['watch_time'] = isset($data['watch_time']) ? $data['watch_time'] : null;
        $this->container['player_source_stream_type'] = isset($data['player_source_stream_type']) ? $data['player_source_stream_type'] : null;
        $this->container['preroll_ad_tag_hostname'] = isset($data['preroll_ad_tag_hostname']) ? $data['preroll_ad_tag_hostname'] : null;
        $this->container['viewer_device_manufacturer'] = isset($data['viewer_device_manufacturer']) ? $data['viewer_device_manufacturer'] : null;
        $this->container['rebuffering_score'] = isset($data['rebuffering_score']) ? $data['rebuffering_score'] : null;
        $this->container['experiment_name'] = isset($data['experiment_name']) ? $data['experiment_name'] : null;
        $this->container['viewer_os_version'] = isset($data['viewer_os_version']) ? $data['viewer_os_version'] : null;
        $this->container['player_preload'] = isset($data['player_preload']) ? $data['player_preload'] : null;
        $this->container['buffering_duration'] = isset($data['buffering_duration']) ? $data['buffering_duration'] : null;
        $this->container['player_view_count'] = isset($data['player_view_count']) ? $data['player_view_count'] : null;
        $this->container['player_software'] = isset($data['player_software']) ? $data['player_software'] : null;
        $this->container['player_load_time'] = isset($data['player_load_time']) ? $data['player_load_time'] : null;
        $this->container['platform_summary'] = isset($data['platform_summary']) ? $data['platform_summary'] : null;
        $this->container['video_encoding_variant'] = isset($data['video_encoding_variant']) ? $data['video_encoding_variant'] : null;
        $this->container['player_width'] = isset($data['player_width']) ? $data['player_width'] : null;
        $this->container['view_seek_count'] = isset($data['view_seek_count']) ? $data['view_seek_count'] : null;
        $this->container['viewer_experience_score'] = isset($data['viewer_experience_score']) ? $data['viewer_experience_score'] : null;
        $this->container['view_error_id'] = isset($data['view_error_id']) ? $data['view_error_id'] : null;
        $this->container['video_variant_name'] = isset($data['video_variant_name']) ? $data['video_variant_name'] : null;
        $this->container['preroll_played'] = isset($data['preroll_played']) ? $data['preroll_played'] : null;
        $this->container['viewer_application_engine'] = isset($data['viewer_application_engine']) ? $data['viewer_application_engine'] : null;
        $this->container['viewer_os_architecture'] = isset($data['viewer_os_architecture']) ? $data['viewer_os_architecture'] : null;
        $this->container['player_error_code'] = isset($data['player_error_code']) ? $data['player_error_code'] : null;
        $this->container['buffering_rate'] = isset($data['buffering_rate']) ? $data['buffering_rate'] : null;
        $this->container['events'] = isset($data['events']) ? $data['events'] : null;
        $this->container['player_name'] = isset($data['player_name']) ? $data['player_name'] : null;
        $this->container['view_start'] = isset($data['view_start']) ? $data['view_start'] : null;
        $this->container['view_average_request_throughput'] = isset($data['view_average_request_throughput']) ? $data['view_average_request_throughput'] : null;
        $this->container['video_producer'] = isset($data['video_producer']) ? $data['video_producer'] : null;
        $this->container['error_type_id'] = isset($data['error_type_id']) ? $data['error_type_id'] : null;
        $this->container['mux_viewer_id'] = isset($data['mux_viewer_id']) ? $data['mux_viewer_id'] : null;
        $this->container['video_id'] = isset($data['video_id']) ? $data['video_id'] : null;
        $this->container['continent_code'] = isset($data['continent_code']) ? $data['continent_code'] : null;
        $this->container['session_id'] = isset($data['session_id']) ? $data['session_id'] : null;
        $this->container['exit_before_video_start'] = isset($data['exit_before_video_start']) ? $data['exit_before_video_start'] : null;
        $this->container['video_content_type'] = isset($data['video_content_type']) ? $data['video_content_type'] : null;
        $this->container['viewer_os_family'] = isset($data['viewer_os_family']) ? $data['viewer_os_family'] : null;
        $this->container['player_poster'] = isset($data['player_poster']) ? $data['player_poster'] : null;
        $this->container['view_average_request_latency'] = isset($data['view_average_request_latency']) ? $data['view_average_request_latency'] : null;
        $this->container['video_variant_id'] = isset($data['video_variant_id']) ? $data['video_variant_id'] : null;
        $this->container['player_source_duration'] = isset($data['player_source_duration']) ? $data['player_source_duration'] : null;
        $this->container['player_source_url'] = isset($data['player_source_url']) ? $data['player_source_url'] : null;
        $this->container['mux_api_version'] = isset($data['mux_api_version']) ? $data['mux_api_version'] : null;
        $this->container['video_title'] = isset($data['video_title']) ? $data['video_title'] : null;
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['short_time'] = isset($data['short_time']) ? $data['short_time'] : null;
        $this->container['rebuffer_percentage'] = isset($data['rebuffer_percentage']) ? $data['rebuffer_percentage'] : null;
        $this->container['time_to_first_frame'] = isset($data['time_to_first_frame']) ? $data['time_to_first_frame'] : null;
        $this->container['viewer_user_id'] = isset($data['viewer_user_id']) ? $data['viewer_user_id'] : null;
        $this->container['video_stream_type'] = isset($data['video_stream_type']) ? $data['video_stream_type'] : null;
        $this->container['player_startup_time'] = isset($data['player_startup_time']) ? $data['player_startup_time'] : null;
        $this->container['viewer_application_version'] = isset($data['viewer_application_version']) ? $data['viewer_application_version'] : null;
        $this->container['view_max_downscale_percentage'] = isset($data['view_max_downscale_percentage']) ? $data['view_max_downscale_percentage'] : null;
        $this->container['view_max_upscale_percentage'] = isset($data['view_max_upscale_percentage']) ? $data['view_max_upscale_percentage'] : null;
        $this->container['country_code'] = isset($data['country_code']) ? $data['country_code'] : null;
        $this->container['used_fullscreen'] = isset($data['used_fullscreen']) ? $data['used_fullscreen'] : null;
        $this->container['isp'] = isset($data['isp']) ? $data['isp'] : null;
        $this->container['property_id'] = isset($data['property_id']) ? $data['property_id'] : null;
        $this->container['player_autoplay'] = isset($data['player_autoplay']) ? $data['player_autoplay'] : null;
        $this->container['player_height'] = isset($data['player_height']) ? $data['player_height'] : null;
        $this->container['asn'] = isset($data['asn']) ? $data['asn'] : null;
        $this->container['asn_name'] = isset($data['asn_name']) ? $data['asn_name'] : null;
        $this->container['quality_score'] = isset($data['quality_score']) ? $data['quality_score'] : null;
        $this->container['player_software_version'] = isset($data['player_software_version']) ? $data['player_software_version'] : null;
        $this->container['player_mux_plugin_name'] = isset($data['player_mux_plugin_name']) ? $data['player_mux_plugin_name'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets view_total_upscaling
     *
     * @return string|null
     */
    public function getViewTotalUpscaling()
    {
        return $this->container['view_total_upscaling'];
    }

    /**
     * Sets view_total_upscaling
     *
     * @param string|null $view_total_upscaling view_total_upscaling
     *
     * @return $this
     */
    public function setViewTotalUpscaling($view_total_upscaling)
    {
        $this->container['view_total_upscaling'] = $view_total_upscaling;

        return $this;
    }

    /**
     * Gets preroll_ad_asset_hostname
     *
     * @return string|null
     */
    public function getPrerollAdAssetHostname()
    {
        return $this->container['preroll_ad_asset_hostname'];
    }

    /**
     * Sets preroll_ad_asset_hostname
     *
     * @param string|null $preroll_ad_asset_hostname preroll_ad_asset_hostname
     *
     * @return $this
     */
    public function setPrerollAdAssetHostname($preroll_ad_asset_hostname)
    {
        $this->container['preroll_ad_asset_hostname'] = $preroll_ad_asset_hostname;

        return $this;
    }

    /**
     * Gets player_source_domain
     *
     * @return string|null
     */
    public function getPlayerSourceDomain()
    {
        return $this->container['player_source_domain'];
    }

    /**
     * Sets player_source_domain
     *
     * @param string|null $player_source_domain player_source_domain
     *
     * @return $this
     */
    public function setPlayerSourceDomain($player_source_domain)
    {
        $this->container['player_source_domain'] = $player_source_domain;

        return $this;
    }

    /**
     * Gets region
     *
     * @return string|null
     */
    public function getRegion()
    {
        return $this->container['region'];
    }

    /**
     * Sets region
     *
     * @param string|null $region region
     *
     * @return $this
     */
    public function setRegion($region)
    {
        $this->container['region'] = $region;

        return $this;
    }

    /**
     * Gets viewer_user_agent
     *
     * @return string|null
     */
    public function getViewerUserAgent()
    {
        return $this->container['viewer_user_agent'];
    }

    /**
     * Sets viewer_user_agent
     *
     * @param string|null $viewer_user_agent viewer_user_agent
     *
     * @return $this
     */
    public function setViewerUserAgent($viewer_user_agent)
    {
        $this->container['viewer_user_agent'] = $viewer_user_agent;

        return $this;
    }

    /**
     * Gets preroll_requested
     *
     * @return bool|null
     */
    public function getPrerollRequested()
    {
        return $this->container['preroll_requested'];
    }

    /**
     * Sets preroll_requested
     *
     * @param bool|null $preroll_requested preroll_requested
     *
     * @return $this
     */
    public function setPrerollRequested($preroll_requested)
    {
        $this->container['preroll_requested'] = $preroll_requested;

        return $this;
    }

    /**
     * Gets page_type
     *
     * @return string|null
     */
    public function getPageType()
    {
        return $this->container['page_type'];
    }

    /**
     * Sets page_type
     *
     * @param string|null $page_type page_type
     *
     * @return $this
     */
    public function setPageType($page_type)
    {
        $this->container['page_type'] = $page_type;

        return $this;
    }

    /**
     * Gets startup_score
     *
     * @return string|null
     */
    public function getStartupScore()
    {
        return $this->container['startup_score'];
    }

    /**
     * Sets startup_score
     *
     * @param string|null $startup_score startup_score
     *
     * @return $this
     */
    public function setStartupScore($startup_score)
    {
        $this->container['startup_score'] = $startup_score;

        return $this;
    }

    /**
     * Gets view_seek_duration
     *
     * @return int|null
     */
    public function getViewSeekDuration()
    {
        return $this->container['view_seek_duration'];
    }

    /**
     * Sets view_seek_duration
     *
     * @param int|null $view_seek_duration view_seek_duration
     *
     * @return $this
     */
    public function setViewSeekDuration($view_seek_duration)
    {
        $this->container['view_seek_duration'] = $view_seek_duration;

        return $this;
    }

    /**
     * Gets country_name
     *
     * @return string|null
     */
    public function getCountryName()
    {
        return $this->container['country_name'];
    }

    /**
     * Sets country_name
     *
     * @param string|null $country_name country_name
     *
     * @return $this
     */
    public function setCountryName($country_name)
    {
        $this->container['country_name'] = $country_name;

        return $this;
    }

    /**
     * Gets player_source_height
     *
     * @return int|null
     */
    public function getPlayerSourceHeight()
    {
        return $this->container['player_source_height'];
    }

    /**
     * Sets player_source_height
     *
     * @param int|null $player_source_height player_source_height
     *
     * @return $this
     */
    public function setPlayerSourceHeight($player_source_height)
    {
        $this->container['player_source_height'] = $player_source_height;

        return $this;
    }

    /**
     * Gets longitude
     *
     * @return string|null
     */
    public function getLongitude()
    {
        return $this->container['longitude'];
    }

    /**
     * Sets longitude
     *
     * @param string|null $longitude longitude
     *
     * @return $this
     */
    public function setLongitude($longitude)
    {
        $this->container['longitude'] = $longitude;

        return $this;
    }

    /**
     * Gets buffering_count
     *
     * @return int|null
     */
    public function getBufferingCount()
    {
        return $this->container['buffering_count'];
    }

    /**
     * Sets buffering_count
     *
     * @param int|null $buffering_count buffering_count
     *
     * @return $this
     */
    public function setBufferingCount($buffering_count)
    {
        $this->container['buffering_count'] = $buffering_count;

        return $this;
    }

    /**
     * Gets video_duration
     *
     * @return int|null
     */
    public function getVideoDuration()
    {
        return $this->container['video_duration'];
    }

    /**
     * Sets video_duration
     *
     * @param int|null $video_duration video_duration
     *
     * @return $this
     */
    public function setVideoDuration($video_duration)
    {
        $this->container['video_duration'] = $video_duration;

        return $this;
    }

    /**
     * Gets player_source_type
     *
     * @return string|null
     */
    public function getPlayerSourceType()
    {
        return $this->container['player_source_type'];
    }

    /**
     * Sets player_source_type
     *
     * @param string|null $player_source_type player_source_type
     *
     * @return $this
     */
    public function setPlayerSourceType($player_source_type)
    {
        $this->container['player_source_type'] = $player_source_type;

        return $this;
    }

    /**
     * Gets city
     *
     * @return string|null
     */
    public function getCity()
    {
        return $this->container['city'];
    }

    /**
     * Sets city
     *
     * @param string|null $city city
     *
     * @return $this
     */
    public function setCity($city)
    {
        $this->container['city'] = $city;

        return $this;
    }

    /**
     * Gets view_id
     *
     * @return string|null
     */
    public function getViewId()
    {
        return $this->container['view_id'];
    }

    /**
     * Sets view_id
     *
     * @param string|null $view_id view_id
     *
     * @return $this
     */
    public function setViewId($view_id)
    {
        $this->container['view_id'] = $view_id;

        return $this;
    }

    /**
     * Gets platform_description
     *
     * @return string|null
     */
    public function getPlatformDescription()
    {
        return $this->container['platform_description'];
    }

    /**
     * Sets platform_description
     *
     * @param string|null $platform_description platform_description
     *
     * @return $this
     */
    public function setPlatformDescription($platform_description)
    {
        $this->container['platform_description'] = $platform_description;

        return $this;
    }

    /**
     * Gets video_startup_preroll_request_time
     *
     * @return int|null
     */
    public function getVideoStartupPrerollRequestTime()
    {
        return $this->container['video_startup_preroll_request_time'];
    }

    /**
     * Sets video_startup_preroll_request_time
     *
     * @param int|null $video_startup_preroll_request_time video_startup_preroll_request_time
     *
     * @return $this
     */
    public function setVideoStartupPrerollRequestTime($video_startup_preroll_request_time)
    {
        $this->container['video_startup_preroll_request_time'] = $video_startup_preroll_request_time;

        return $this;
    }

    /**
     * Gets viewer_device_name
     *
     * @return string|null
     */
    public function getViewerDeviceName()
    {
        return $this->container['viewer_device_name'];
    }

    /**
     * Sets viewer_device_name
     *
     * @param string|null $viewer_device_name viewer_device_name
     *
     * @return $this
     */
    public function setViewerDeviceName($viewer_device_name)
    {
        $this->container['viewer_device_name'] = $viewer_device_name;

        return $this;
    }

    /**
     * Gets video_series
     *
     * @return string|null
     */
    public function getVideoSeries()
    {
        return $this->container['video_series'];
    }

    /**
     * Sets video_series
     *
     * @param string|null $video_series video_series
     *
     * @return $this
     */
    public function setVideoSeries($video_series)
    {
        $this->container['video_series'] = $video_series;

        return $this;
    }

    /**
     * Gets viewer_application_name
     *
     * @return string|null
     */
    public function getViewerApplicationName()
    {
        return $this->container['viewer_application_name'];
    }

    /**
     * Sets viewer_application_name
     *
     * @param string|null $viewer_application_name viewer_application_name
     *
     * @return $this
     */
    public function setViewerApplicationName($viewer_application_name)
    {
        $this->container['viewer_application_name'] = $viewer_application_name;

        return $this;
    }

    /**
     * Gets updated_at
     *
     * @return string|null
     */
    public function getUpdatedAt()
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at
     *
     * @param string|null $updated_at updated_at
     *
     * @return $this
     */
    public function setUpdatedAt($updated_at)
    {
        $this->container['updated_at'] = $updated_at;

        return $this;
    }

    /**
     * Gets view_total_content_playback_time
     *
     * @return int|null
     */
    public function getViewTotalContentPlaybackTime()
    {
        return $this->container['view_total_content_playback_time'];
    }

    /**
     * Sets view_total_content_playback_time
     *
     * @param int|null $view_total_content_playback_time view_total_content_playback_time
     *
     * @return $this
     */
    public function setViewTotalContentPlaybackTime($view_total_content_playback_time)
    {
        $this->container['view_total_content_playback_time'] = $view_total_content_playback_time;

        return $this;
    }

    /**
     * Gets cdn
     *
     * @return string|null
     */
    public function getCdn()
    {
        return $this->container['cdn'];
    }

    /**
     * Sets cdn
     *
     * @param string|null $cdn cdn
     *
     * @return $this
     */
    public function setCdn($cdn)
    {
        $this->container['cdn'] = $cdn;

        return $this;
    }

    /**
     * Gets player_instance_id
     *
     * @return string|null
     */
    public function getPlayerInstanceId()
    {
        return $this->container['player_instance_id'];
    }

    /**
     * Sets player_instance_id
     *
     * @param string|null $player_instance_id player_instance_id
     *
     * @return $this
     */
    public function setPlayerInstanceId($player_instance_id)
    {
        $this->container['player_instance_id'] = $player_instance_id;

        return $this;
    }

    /**
     * Gets video_language
     *
     * @return string|null
     */
    public function getVideoLanguage()
    {
        return $this->container['video_language'];
    }

    /**
     * Sets video_language
     *
     * @param string|null $video_language video_language
     *
     * @return $this
     */
    public function setVideoLanguage($video_language)
    {
        $this->container['video_language'] = $video_language;

        return $this;
    }

    /**
     * Gets player_source_width
     *
     * @return int|null
     */
    public function getPlayerSourceWidth()
    {
        return $this->container['player_source_width'];
    }

    /**
     * Sets player_source_width
     *
     * @param int|null $player_source_width player_source_width
     *
     * @return $this
     */
    public function setPlayerSourceWidth($player_source_width)
    {
        $this->container['player_source_width'] = $player_source_width;

        return $this;
    }

    /**
     * Gets player_error_message
     *
     * @return string|null
     */
    public function getPlayerErrorMessage()
    {
        return $this->container['player_error_message'];
    }

    /**
     * Sets player_error_message
     *
     * @param string|null $player_error_message player_error_message
     *
     * @return $this
     */
    public function setPlayerErrorMessage($player_error_message)
    {
        $this->container['player_error_message'] = $player_error_message;

        return $this;
    }

    /**
     * Gets player_mux_plugin_version
     *
     * @return string|null
     */
    public function getPlayerMuxPluginVersion()
    {
        return $this->container['player_mux_plugin_version'];
    }

    /**
     * Sets player_mux_plugin_version
     *
     * @param string|null $player_mux_plugin_version player_mux_plugin_version
     *
     * @return $this
     */
    public function setPlayerMuxPluginVersion($player_mux_plugin_version)
    {
        $this->container['player_mux_plugin_version'] = $player_mux_plugin_version;

        return $this;
    }

    /**
     * Gets watched
     *
     * @return bool|null
     */
    public function getWatched()
    {
        return $this->container['watched'];
    }

    /**
     * Sets watched
     *
     * @param bool|null $watched watched
     *
     * @return $this
     */
    public function setWatched($watched)
    {
        $this->container['watched'] = $watched;

        return $this;
    }

    /**
     * Gets playback_score
     *
     * @return string|null
     */
    public function getPlaybackScore()
    {
        return $this->container['playback_score'];
    }

    /**
     * Sets playback_score
     *
     * @param string|null $playback_score playback_score
     *
     * @return $this
     */
    public function setPlaybackScore($playback_score)
    {
        $this->container['playback_score'] = $playback_score;

        return $this;
    }

    /**
     * Gets page_url
     *
     * @return string|null
     */
    public function getPageUrl()
    {
        return $this->container['page_url'];
    }

    /**
     * Sets page_url
     *
     * @param string|null $page_url page_url
     *
     * @return $this
     */
    public function setPageUrl($page_url)
    {
        $this->container['page_url'] = $page_url;

        return $this;
    }

    /**
     * Gets metro
     *
     * @return string|null
     */
    public function getMetro()
    {
        return $this->container['metro'];
    }

    /**
     * Sets metro
     *
     * @param string|null $metro metro
     *
     * @return $this
     */
    public function setMetro($metro)
    {
        $this->container['metro'] = $metro;

        return $this;
    }

    /**
     * Gets view_max_request_latency
     *
     * @return int|null
     */
    public function getViewMaxRequestLatency()
    {
        return $this->container['view_max_request_latency'];
    }

    /**
     * Sets view_max_request_latency
     *
     * @param int|null $view_max_request_latency view_max_request_latency
     *
     * @return $this
     */
    public function setViewMaxRequestLatency($view_max_request_latency)
    {
        $this->container['view_max_request_latency'] = $view_max_request_latency;

        return $this;
    }

    /**
     * Gets requests_for_first_preroll
     *
     * @return int|null
     */
    public function getRequestsForFirstPreroll()
    {
        return $this->container['requests_for_first_preroll'];
    }

    /**
     * Sets requests_for_first_preroll
     *
     * @param int|null $requests_for_first_preroll requests_for_first_preroll
     *
     * @return $this
     */
    public function setRequestsForFirstPreroll($requests_for_first_preroll)
    {
        $this->container['requests_for_first_preroll'] = $requests_for_first_preroll;

        return $this;
    }

    /**
     * Gets view_total_downscaling
     *
     * @return string|null
     */
    public function getViewTotalDownscaling()
    {
        return $this->container['view_total_downscaling'];
    }

    /**
     * Sets view_total_downscaling
     *
     * @param string|null $view_total_downscaling view_total_downscaling
     *
     * @return $this
     */
    public function setViewTotalDownscaling($view_total_downscaling)
    {
        $this->container['view_total_downscaling'] = $view_total_downscaling;

        return $this;
    }

    /**
     * Gets latitude
     *
     * @return string|null
     */
    public function getLatitude()
    {
        return $this->container['latitude'];
    }

    /**
     * Sets latitude
     *
     * @param string|null $latitude latitude
     *
     * @return $this
     */
    public function setLatitude($latitude)
    {
        $this->container['latitude'] = $latitude;

        return $this;
    }

    /**
     * Gets player_source_host_name
     *
     * @return string|null
     */
    public function getPlayerSourceHostName()
    {
        return $this->container['player_source_host_name'];
    }

    /**
     * Sets player_source_host_name
     *
     * @param string|null $player_source_host_name player_source_host_name
     *
     * @return $this
     */
    public function setPlayerSourceHostName($player_source_host_name)
    {
        $this->container['player_source_host_name'] = $player_source_host_name;

        return $this;
    }

    /**
     * Gets inserted_at
     *
     * @return string|null
     */
    public function getInsertedAt()
    {
        return $this->container['inserted_at'];
    }

    /**
     * Sets inserted_at
     *
     * @param string|null $inserted_at inserted_at
     *
     * @return $this
     */
    public function setInsertedAt($inserted_at)
    {
        $this->container['inserted_at'] = $inserted_at;

        return $this;
    }

    /**
     * Gets view_end
     *
     * @return string|null
     */
    public function getViewEnd()
    {
        return $this->container['view_end'];
    }

    /**
     * Sets view_end
     *
     * @param string|null $view_end view_end
     *
     * @return $this
     */
    public function setViewEnd($view_end)
    {
        $this->container['view_end'] = $view_end;

        return $this;
    }

    /**
     * Gets mux_embed_version
     *
     * @return string|null
     */
    public function getMuxEmbedVersion()
    {
        return $this->container['mux_embed_version'];
    }

    /**
     * Sets mux_embed_version
     *
     * @param string|null $mux_embed_version mux_embed_version
     *
     * @return $this
     */
    public function setMuxEmbedVersion($mux_embed_version)
    {
        $this->container['mux_embed_version'] = $mux_embed_version;

        return $this;
    }

    /**
     * Gets player_language
     *
     * @return string|null
     */
    public function getPlayerLanguage()
    {
        return $this->container['player_language'];
    }

    /**
     * Sets player_language
     *
     * @param string|null $player_language player_language
     *
     * @return $this
     */
    public function setPlayerLanguage($player_language)
    {
        $this->container['player_language'] = $player_language;

        return $this;
    }

    /**
     * Gets page_load_time
     *
     * @return int|null
     */
    public function getPageLoadTime()
    {
        return $this->container['page_load_time'];
    }

    /**
     * Sets page_load_time
     *
     * @param int|null $page_load_time page_load_time
     *
     * @return $this
     */
    public function setPageLoadTime($page_load_time)
    {
        $this->container['page_load_time'] = $page_load_time;

        return $this;
    }

    /**
     * Gets viewer_device_category
     *
     * @return string|null
     */
    public function getViewerDeviceCategory()
    {
        return $this->container['viewer_device_category'];
    }

    /**
     * Sets viewer_device_category
     *
     * @param string|null $viewer_device_category viewer_device_category
     *
     * @return $this
     */
    public function setViewerDeviceCategory($viewer_device_category)
    {
        $this->container['viewer_device_category'] = $viewer_device_category;

        return $this;
    }

    /**
     * Gets video_startup_preroll_load_time
     *
     * @return int|null
     */
    public function getVideoStartupPrerollLoadTime()
    {
        return $this->container['video_startup_preroll_load_time'];
    }

    /**
     * Sets video_startup_preroll_load_time
     *
     * @param int|null $video_startup_preroll_load_time video_startup_preroll_load_time
     *
     * @return $this
     */
    public function setVideoStartupPrerollLoadTime($video_startup_preroll_load_time)
    {
        $this->container['video_startup_preroll_load_time'] = $video_startup_preroll_load_time;

        return $this;
    }

    /**
     * Gets player_version
     *
     * @return string|null
     */
    public function getPlayerVersion()
    {
        return $this->container['player_version'];
    }

    /**
     * Sets player_version
     *
     * @param string|null $player_version player_version
     *
     * @return $this
     */
    public function setPlayerVersion($player_version)
    {
        $this->container['player_version'] = $player_version;

        return $this;
    }

    /**
     * Gets watch_time
     *
     * @return int|null
     */
    public function getWatchTime()
    {
        return $this->container['watch_time'];
    }

    /**
     * Sets watch_time
     *
     * @param int|null $watch_time watch_time
     *
     * @return $this
     */
    public function setWatchTime($watch_time)
    {
        $this->container['watch_time'] = $watch_time;

        return $this;
    }

    /**
     * Gets player_source_stream_type
     *
     * @return string|null
     */
    public function getPlayerSourceStreamType()
    {
        return $this->container['player_source_stream_type'];
    }

    /**
     * Sets player_source_stream_type
     *
     * @param string|null $player_source_stream_type player_source_stream_type
     *
     * @return $this
     */
    public function setPlayerSourceStreamType($player_source_stream_type)
    {
        $this->container['player_source_stream_type'] = $player_source_stream_type;

        return $this;
    }

    /**
     * Gets preroll_ad_tag_hostname
     *
     * @return string|null
     */
    public function getPrerollAdTagHostname()
    {
        return $this->container['preroll_ad_tag_hostname'];
    }

    /**
     * Sets preroll_ad_tag_hostname
     *
     * @param string|null $preroll_ad_tag_hostname preroll_ad_tag_hostname
     *
     * @return $this
     */
    public function setPrerollAdTagHostname($preroll_ad_tag_hostname)
    {
        $this->container['preroll_ad_tag_hostname'] = $preroll_ad_tag_hostname;

        return $this;
    }

    /**
     * Gets viewer_device_manufacturer
     *
     * @return string|null
     */
    public function getViewerDeviceManufacturer()
    {
        return $this->container['viewer_device_manufacturer'];
    }

    /**
     * Sets viewer_device_manufacturer
     *
     * @param string|null $viewer_device_manufacturer viewer_device_manufacturer
     *
     * @return $this
     */
    public function setViewerDeviceManufacturer($viewer_device_manufacturer)
    {
        $this->container['viewer_device_manufacturer'] = $viewer_device_manufacturer;

        return $this;
    }

    /**
     * Gets rebuffering_score
     *
     * @return string|null
     */
    public function getRebufferingScore()
    {
        return $this->container['rebuffering_score'];
    }

    /**
     * Sets rebuffering_score
     *
     * @param string|null $rebuffering_score rebuffering_score
     *
     * @return $this
     */
    public function setRebufferingScore($rebuffering_score)
    {
        $this->container['rebuffering_score'] = $rebuffering_score;

        return $this;
    }

    /**
     * Gets experiment_name
     *
     * @return string|null
     */
    public function getExperimentName()
    {
        return $this->container['experiment_name'];
    }

    /**
     * Sets experiment_name
     *
     * @param string|null $experiment_name experiment_name
     *
     * @return $this
     */
    public function setExperimentName($experiment_name)
    {
        $this->container['experiment_name'] = $experiment_name;

        return $this;
    }

    /**
     * Gets viewer_os_version
     *
     * @return string|null
     */
    public function getViewerOsVersion()
    {
        return $this->container['viewer_os_version'];
    }

    /**
     * Sets viewer_os_version
     *
     * @param string|null $viewer_os_version viewer_os_version
     *
     * @return $this
     */
    public function setViewerOsVersion($viewer_os_version)
    {
        $this->container['viewer_os_version'] = $viewer_os_version;

        return $this;
    }

    /**
     * Gets player_preload
     *
     * @return bool|null
     */
    public function getPlayerPreload()
    {
        return $this->container['player_preload'];
    }

    /**
     * Sets player_preload
     *
     * @param bool|null $player_preload player_preload
     *
     * @return $this
     */
    public function setPlayerPreload($player_preload)
    {
        $this->container['player_preload'] = $player_preload;

        return $this;
    }

    /**
     * Gets buffering_duration
     *
     * @return int|null
     */
    public function getBufferingDuration()
    {
        return $this->container['buffering_duration'];
    }

    /**
     * Sets buffering_duration
     *
     * @param int|null $buffering_duration buffering_duration
     *
     * @return $this
     */
    public function setBufferingDuration($buffering_duration)
    {
        $this->container['buffering_duration'] = $buffering_duration;

        return $this;
    }

    /**
     * Gets player_view_count
     *
     * @return int|null
     */
    public function getPlayerViewCount()
    {
        return $this->container['player_view_count'];
    }

    /**
     * Sets player_view_count
     *
     * @param int|null $player_view_count player_view_count
     *
     * @return $this
     */
    public function setPlayerViewCount($player_view_count)
    {
        $this->container['player_view_count'] = $player_view_count;

        return $this;
    }

    /**
     * Gets player_software
     *
     * @return string|null
     */
    public function getPlayerSoftware()
    {
        return $this->container['player_software'];
    }

    /**
     * Sets player_software
     *
     * @param string|null $player_software player_software
     *
     * @return $this
     */
    public function setPlayerSoftware($player_software)
    {
        $this->container['player_software'] = $player_software;

        return $this;
    }

    /**
     * Gets player_load_time
     *
     * @return int|null
     */
    public function getPlayerLoadTime()
    {
        return $this->container['player_load_time'];
    }

    /**
     * Sets player_load_time
     *
     * @param int|null $player_load_time player_load_time
     *
     * @return $this
     */
    public function setPlayerLoadTime($player_load_time)
    {
        $this->container['player_load_time'] = $player_load_time;

        return $this;
    }

    /**
     * Gets platform_summary
     *
     * @return string|null
     */
    public function getPlatformSummary()
    {
        return $this->container['platform_summary'];
    }

    /**
     * Sets platform_summary
     *
     * @param string|null $platform_summary platform_summary
     *
     * @return $this
     */
    public function setPlatformSummary($platform_summary)
    {
        $this->container['platform_summary'] = $platform_summary;

        return $this;
    }

    /**
     * Gets video_encoding_variant
     *
     * @return string|null
     */
    public function getVideoEncodingVariant()
    {
        return $this->container['video_encoding_variant'];
    }

    /**
     * Sets video_encoding_variant
     *
     * @param string|null $video_encoding_variant video_encoding_variant
     *
     * @return $this
     */
    public function setVideoEncodingVariant($video_encoding_variant)
    {
        $this->container['video_encoding_variant'] = $video_encoding_variant;

        return $this;
    }

    /**
     * Gets player_width
     *
     * @return int|null
     */
    public function getPlayerWidth()
    {
        return $this->container['player_width'];
    }

    /**
     * Sets player_width
     *
     * @param int|null $player_width player_width
     *
     * @return $this
     */
    public function setPlayerWidth($player_width)
    {
        $this->container['player_width'] = $player_width;

        return $this;
    }

    /**
     * Gets view_seek_count
     *
     * @return int|null
     */
    public function getViewSeekCount()
    {
        return $this->container['view_seek_count'];
    }

    /**
     * Sets view_seek_count
     *
     * @param int|null $view_seek_count view_seek_count
     *
     * @return $this
     */
    public function setViewSeekCount($view_seek_count)
    {
        $this->container['view_seek_count'] = $view_seek_count;

        return $this;
    }

    /**
     * Gets viewer_experience_score
     *
     * @return string|null
     */
    public function getViewerExperienceScore()
    {
        return $this->container['viewer_experience_score'];
    }

    /**
     * Sets viewer_experience_score
     *
     * @param string|null $viewer_experience_score viewer_experience_score
     *
     * @return $this
     */
    public function setViewerExperienceScore($viewer_experience_score)
    {
        $this->container['viewer_experience_score'] = $viewer_experience_score;

        return $this;
    }

    /**
     * Gets view_error_id
     *
     * @return int|null
     */
    public function getViewErrorId()
    {
        return $this->container['view_error_id'];
    }

    /**
     * Sets view_error_id
     *
     * @param int|null $view_error_id view_error_id
     *
     * @return $this
     */
    public function setViewErrorId($view_error_id)
    {
        $this->container['view_error_id'] = $view_error_id;

        return $this;
    }

    /**
     * Gets video_variant_name
     *
     * @return string|null
     */
    public function getVideoVariantName()
    {
        return $this->container['video_variant_name'];
    }

    /**
     * Sets video_variant_name
     *
     * @param string|null $video_variant_name video_variant_name
     *
     * @return $this
     */
    public function setVideoVariantName($video_variant_name)
    {
        $this->container['video_variant_name'] = $video_variant_name;

        return $this;
    }

    /**
     * Gets preroll_played
     *
     * @return bool|null
     */
    public function getPrerollPlayed()
    {
        return $this->container['preroll_played'];
    }

    /**
     * Sets preroll_played
     *
     * @param bool|null $preroll_played preroll_played
     *
     * @return $this
     */
    public function setPrerollPlayed($preroll_played)
    {
        $this->container['preroll_played'] = $preroll_played;

        return $this;
    }

    /**
     * Gets viewer_application_engine
     *
     * @return string|null
     */
    public function getViewerApplicationEngine()
    {
        return $this->container['viewer_application_engine'];
    }

    /**
     * Sets viewer_application_engine
     *
     * @param string|null $viewer_application_engine viewer_application_engine
     *
     * @return $this
     */
    public function setViewerApplicationEngine($viewer_application_engine)
    {
        $this->container['viewer_application_engine'] = $viewer_application_engine;

        return $this;
    }

    /**
     * Gets viewer_os_architecture
     *
     * @return string|null
     */
    public function getViewerOsArchitecture()
    {
        return $this->container['viewer_os_architecture'];
    }

    /**
     * Sets viewer_os_architecture
     *
     * @param string|null $viewer_os_architecture viewer_os_architecture
     *
     * @return $this
     */
    public function setViewerOsArchitecture($viewer_os_architecture)
    {
        $this->container['viewer_os_architecture'] = $viewer_os_architecture;

        return $this;
    }

    /**
     * Gets player_error_code
     *
     * @return string|null
     */
    public function getPlayerErrorCode()
    {
        return $this->container['player_error_code'];
    }

    /**
     * Sets player_error_code
     *
     * @param string|null $player_error_code player_error_code
     *
     * @return $this
     */
    public function setPlayerErrorCode($player_error_code)
    {
        $this->container['player_error_code'] = $player_error_code;

        return $this;
    }

    /**
     * Gets buffering_rate
     *
     * @return string|null
     */
    public function getBufferingRate()
    {
        return $this->container['buffering_rate'];
    }

    /**
     * Sets buffering_rate
     *
     * @param string|null $buffering_rate buffering_rate
     *
     * @return $this
     */
    public function setBufferingRate($buffering_rate)
    {
        $this->container['buffering_rate'] = $buffering_rate;

        return $this;
    }

    /**
     * Gets events
     *
     * @return \MediaCloud\Vendor\MuxPhp\Models\VideoViewEvent[]|null
     */
    public function getEvents()
    {
        return $this->container['events'];
    }

    /**
     * Sets events
     *
     * @param \MediaCloud\Vendor\MuxPhp\Models\VideoViewEvent[]|null $events events
     *
     * @return $this
     */
    public function setEvents($events)
    {
        $this->container['events'] = $events;

        return $this;
    }

    /**
     * Gets player_name
     *
     * @return string|null
     */
    public function getPlayerName()
    {
        return $this->container['player_name'];
    }

    /**
     * Sets player_name
     *
     * @param string|null $player_name player_name
     *
     * @return $this
     */
    public function setPlayerName($player_name)
    {
        $this->container['player_name'] = $player_name;

        return $this;
    }

    /**
     * Gets view_start
     *
     * @return string|null
     */
    public function getViewStart()
    {
        return $this->container['view_start'];
    }

    /**
     * Sets view_start
     *
     * @param string|null $view_start view_start
     *
     * @return $this
     */
    public function setViewStart($view_start)
    {
        $this->container['view_start'] = $view_start;

        return $this;
    }

    /**
     * Gets view_average_request_throughput
     *
     * @return int|null
     */
    public function getViewAverageRequestThroughput()
    {
        return $this->container['view_average_request_throughput'];
    }

    /**
     * Sets view_average_request_throughput
     *
     * @param int|null $view_average_request_throughput view_average_request_throughput
     *
     * @return $this
     */
    public function setViewAverageRequestThroughput($view_average_request_throughput)
    {
        $this->container['view_average_request_throughput'] = $view_average_request_throughput;

        return $this;
    }

    /**
     * Gets video_producer
     *
     * @return string|null
     */
    public function getVideoProducer()
    {
        return $this->container['video_producer'];
    }

    /**
     * Sets video_producer
     *
     * @param string|null $video_producer video_producer
     *
     * @return $this
     */
    public function setVideoProducer($video_producer)
    {
        $this->container['video_producer'] = $video_producer;

        return $this;
    }

    /**
     * Gets error_type_id
     *
     * @return int|null
     */
    public function getErrorTypeId()
    {
        return $this->container['error_type_id'];
    }

    /**
     * Sets error_type_id
     *
     * @param int|null $error_type_id error_type_id
     *
     * @return $this
     */
    public function setErrorTypeId($error_type_id)
    {
        $this->container['error_type_id'] = $error_type_id;

        return $this;
    }

    /**
     * Gets mux_viewer_id
     *
     * @return string|null
     */
    public function getMuxViewerId()
    {
        return $this->container['mux_viewer_id'];
    }

    /**
     * Sets mux_viewer_id
     *
     * @param string|null $mux_viewer_id mux_viewer_id
     *
     * @return $this
     */
    public function setMuxViewerId($mux_viewer_id)
    {
        $this->container['mux_viewer_id'] = $mux_viewer_id;

        return $this;
    }

    /**
     * Gets video_id
     *
     * @return string|null
     */
    public function getVideoId()
    {
        return $this->container['video_id'];
    }

    /**
     * Sets video_id
     *
     * @param string|null $video_id video_id
     *
     * @return $this
     */
    public function setVideoId($video_id)
    {
        $this->container['video_id'] = $video_id;

        return $this;
    }

    /**
     * Gets continent_code
     *
     * @return string|null
     */
    public function getContinentCode()
    {
        return $this->container['continent_code'];
    }

    /**
     * Sets continent_code
     *
     * @param string|null $continent_code continent_code
     *
     * @return $this
     */
    public function setContinentCode($continent_code)
    {
        $this->container['continent_code'] = $continent_code;

        return $this;
    }

    /**
     * Gets session_id
     *
     * @return string|null
     */
    public function getSessionId()
    {
        return $this->container['session_id'];
    }

    /**
     * Sets session_id
     *
     * @param string|null $session_id session_id
     *
     * @return $this
     */
    public function setSessionId($session_id)
    {
        $this->container['session_id'] = $session_id;

        return $this;
    }

    /**
     * Gets exit_before_video_start
     *
     * @return bool|null
     */
    public function getExitBeforeVideoStart()
    {
        return $this->container['exit_before_video_start'];
    }

    /**
     * Sets exit_before_video_start
     *
     * @param bool|null $exit_before_video_start exit_before_video_start
     *
     * @return $this
     */
    public function setExitBeforeVideoStart($exit_before_video_start)
    {
        $this->container['exit_before_video_start'] = $exit_before_video_start;

        return $this;
    }

    /**
     * Gets video_content_type
     *
     * @return string|null
     */
    public function getVideoContentType()
    {
        return $this->container['video_content_type'];
    }

    /**
     * Sets video_content_type
     *
     * @param string|null $video_content_type video_content_type
     *
     * @return $this
     */
    public function setVideoContentType($video_content_type)
    {
        $this->container['video_content_type'] = $video_content_type;

        return $this;
    }

    /**
     * Gets viewer_os_family
     *
     * @return string|null
     */
    public function getViewerOsFamily()
    {
        return $this->container['viewer_os_family'];
    }

    /**
     * Sets viewer_os_family
     *
     * @param string|null $viewer_os_family viewer_os_family
     *
     * @return $this
     */
    public function setViewerOsFamily($viewer_os_family)
    {
        $this->container['viewer_os_family'] = $viewer_os_family;

        return $this;
    }

    /**
     * Gets player_poster
     *
     * @return string|null
     */
    public function getPlayerPoster()
    {
        return $this->container['player_poster'];
    }

    /**
     * Sets player_poster
     *
     * @param string|null $player_poster player_poster
     *
     * @return $this
     */
    public function setPlayerPoster($player_poster)
    {
        $this->container['player_poster'] = $player_poster;

        return $this;
    }

    /**
     * Gets view_average_request_latency
     *
     * @return int|null
     */
    public function getViewAverageRequestLatency()
    {
        return $this->container['view_average_request_latency'];
    }

    /**
     * Sets view_average_request_latency
     *
     * @param int|null $view_average_request_latency view_average_request_latency
     *
     * @return $this
     */
    public function setViewAverageRequestLatency($view_average_request_latency)
    {
        $this->container['view_average_request_latency'] = $view_average_request_latency;

        return $this;
    }

    /**
     * Gets video_variant_id
     *
     * @return string|null
     */
    public function getVideoVariantId()
    {
        return $this->container['video_variant_id'];
    }

    /**
     * Sets video_variant_id
     *
     * @param string|null $video_variant_id video_variant_id
     *
     * @return $this
     */
    public function setVideoVariantId($video_variant_id)
    {
        $this->container['video_variant_id'] = $video_variant_id;

        return $this;
    }

    /**
     * Gets player_source_duration
     *
     * @return int|null
     */
    public function getPlayerSourceDuration()
    {
        return $this->container['player_source_duration'];
    }

    /**
     * Sets player_source_duration
     *
     * @param int|null $player_source_duration player_source_duration
     *
     * @return $this
     */
    public function setPlayerSourceDuration($player_source_duration)
    {
        $this->container['player_source_duration'] = $player_source_duration;

        return $this;
    }

    /**
     * Gets player_source_url
     *
     * @return string|null
     */
    public function getPlayerSourceUrl()
    {
        return $this->container['player_source_url'];
    }

    /**
     * Sets player_source_url
     *
     * @param string|null $player_source_url player_source_url
     *
     * @return $this
     */
    public function setPlayerSourceUrl($player_source_url)
    {
        $this->container['player_source_url'] = $player_source_url;

        return $this;
    }

    /**
     * Gets mux_api_version
     *
     * @return string|null
     */
    public function getMuxApiVersion()
    {
        return $this->container['mux_api_version'];
    }

    /**
     * Sets mux_api_version
     *
     * @param string|null $mux_api_version mux_api_version
     *
     * @return $this
     */
    public function setMuxApiVersion($mux_api_version)
    {
        $this->container['mux_api_version'] = $mux_api_version;

        return $this;
    }

    /**
     * Gets video_title
     *
     * @return string|null
     */
    public function getVideoTitle()
    {
        return $this->container['video_title'];
    }

    /**
     * Sets video_title
     *
     * @param string|null $video_title video_title
     *
     * @return $this
     */
    public function setVideoTitle($video_title)
    {
        $this->container['video_title'] = $video_title;

        return $this;
    }

    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id id
     *
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets short_time
     *
     * @return string|null
     */
    public function getShortTime()
    {
        return $this->container['short_time'];
    }

    /**
     * Sets short_time
     *
     * @param string|null $short_time short_time
     *
     * @return $this
     */
    public function setShortTime($short_time)
    {
        $this->container['short_time'] = $short_time;

        return $this;
    }

    /**
     * Gets rebuffer_percentage
     *
     * @return string|null
     */
    public function getRebufferPercentage()
    {
        return $this->container['rebuffer_percentage'];
    }

    /**
     * Sets rebuffer_percentage
     *
     * @param string|null $rebuffer_percentage rebuffer_percentage
     *
     * @return $this
     */
    public function setRebufferPercentage($rebuffer_percentage)
    {
        $this->container['rebuffer_percentage'] = $rebuffer_percentage;

        return $this;
    }

    /**
     * Gets time_to_first_frame
     *
     * @return int|null
     */
    public function getTimeToFirstFrame()
    {
        return $this->container['time_to_first_frame'];
    }

    /**
     * Sets time_to_first_frame
     *
     * @param int|null $time_to_first_frame time_to_first_frame
     *
     * @return $this
     */
    public function setTimeToFirstFrame($time_to_first_frame)
    {
        $this->container['time_to_first_frame'] = $time_to_first_frame;

        return $this;
    }

    /**
     * Gets viewer_user_id
     *
     * @return string|null
     */
    public function getViewerUserId()
    {
        return $this->container['viewer_user_id'];
    }

    /**
     * Sets viewer_user_id
     *
     * @param string|null $viewer_user_id viewer_user_id
     *
     * @return $this
     */
    public function setViewerUserId($viewer_user_id)
    {
        $this->container['viewer_user_id'] = $viewer_user_id;

        return $this;
    }

    /**
     * Gets video_stream_type
     *
     * @return string|null
     */
    public function getVideoStreamType()
    {
        return $this->container['video_stream_type'];
    }

    /**
     * Sets video_stream_type
     *
     * @param string|null $video_stream_type video_stream_type
     *
     * @return $this
     */
    public function setVideoStreamType($video_stream_type)
    {
        $this->container['video_stream_type'] = $video_stream_type;

        return $this;
    }

    /**
     * Gets player_startup_time
     *
     * @return int|null
     */
    public function getPlayerStartupTime()
    {
        return $this->container['player_startup_time'];
    }

    /**
     * Sets player_startup_time
     *
     * @param int|null $player_startup_time player_startup_time
     *
     * @return $this
     */
    public function setPlayerStartupTime($player_startup_time)
    {
        $this->container['player_startup_time'] = $player_startup_time;

        return $this;
    }

    /**
     * Gets viewer_application_version
     *
     * @return string|null
     */
    public function getViewerApplicationVersion()
    {
        return $this->container['viewer_application_version'];
    }

    /**
     * Sets viewer_application_version
     *
     * @param string|null $viewer_application_version viewer_application_version
     *
     * @return $this
     */
    public function setViewerApplicationVersion($viewer_application_version)
    {
        $this->container['viewer_application_version'] = $viewer_application_version;

        return $this;
    }

    /**
     * Gets view_max_downscale_percentage
     *
     * @return string|null
     */
    public function getViewMaxDownscalePercentage()
    {
        return $this->container['view_max_downscale_percentage'];
    }

    /**
     * Sets view_max_downscale_percentage
     *
     * @param string|null $view_max_downscale_percentage view_max_downscale_percentage
     *
     * @return $this
     */
    public function setViewMaxDownscalePercentage($view_max_downscale_percentage)
    {
        $this->container['view_max_downscale_percentage'] = $view_max_downscale_percentage;

        return $this;
    }

    /**
     * Gets view_max_upscale_percentage
     *
     * @return string|null
     */
    public function getViewMaxUpscalePercentage()
    {
        return $this->container['view_max_upscale_percentage'];
    }

    /**
     * Sets view_max_upscale_percentage
     *
     * @param string|null $view_max_upscale_percentage view_max_upscale_percentage
     *
     * @return $this
     */
    public function setViewMaxUpscalePercentage($view_max_upscale_percentage)
    {
        $this->container['view_max_upscale_percentage'] = $view_max_upscale_percentage;

        return $this;
    }

    /**
     * Gets country_code
     *
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->container['country_code'];
    }

    /**
     * Sets country_code
     *
     * @param string|null $country_code country_code
     *
     * @return $this
     */
    public function setCountryCode($country_code)
    {
        $this->container['country_code'] = $country_code;

        return $this;
    }

    /**
     * Gets used_fullscreen
     *
     * @return bool|null
     */
    public function getUsedFullscreen()
    {
        return $this->container['used_fullscreen'];
    }

    /**
     * Sets used_fullscreen
     *
     * @param bool|null $used_fullscreen used_fullscreen
     *
     * @return $this
     */
    public function setUsedFullscreen($used_fullscreen)
    {
        $this->container['used_fullscreen'] = $used_fullscreen;

        return $this;
    }

    /**
     * Gets isp
     *
     * @return string|null
     */
    public function getIsp()
    {
        return $this->container['isp'];
    }

    /**
     * Sets isp
     *
     * @param string|null $isp isp
     *
     * @return $this
     */
    public function setIsp($isp)
    {
        $this->container['isp'] = $isp;

        return $this;
    }

    /**
     * Gets property_id
     *
     * @return int|null
     */
    public function getPropertyId()
    {
        return $this->container['property_id'];
    }

    /**
     * Sets property_id
     *
     * @param int|null $property_id property_id
     *
     * @return $this
     */
    public function setPropertyId($property_id)
    {
        $this->container['property_id'] = $property_id;

        return $this;
    }

    /**
     * Gets player_autoplay
     *
     * @return bool|null
     */
    public function getPlayerAutoplay()
    {
        return $this->container['player_autoplay'];
    }

    /**
     * Sets player_autoplay
     *
     * @param bool|null $player_autoplay player_autoplay
     *
     * @return $this
     */
    public function setPlayerAutoplay($player_autoplay)
    {
        $this->container['player_autoplay'] = $player_autoplay;

        return $this;
    }

    /**
     * Gets player_height
     *
     * @return int|null
     */
    public function getPlayerHeight()
    {
        return $this->container['player_height'];
    }

    /**
     * Sets player_height
     *
     * @param int|null $player_height player_height
     *
     * @return $this
     */
    public function setPlayerHeight($player_height)
    {
        $this->container['player_height'] = $player_height;

        return $this;
    }

    /**
     * Gets asn
     *
     * @return int|null
     */
    public function getAsn()
    {
        return $this->container['asn'];
    }

    /**
     * Sets asn
     *
     * @param int|null $asn asn
     *
     * @return $this
     */
    public function setAsn($asn)
    {
        $this->container['asn'] = $asn;

        return $this;
    }

    /**
     * Gets asn_name
     *
     * @return string|null
     */
    public function getAsnName()
    {
        return $this->container['asn_name'];
    }

    /**
     * Sets asn_name
     *
     * @param string|null $asn_name asn_name
     *
     * @return $this
     */
    public function setAsnName($asn_name)
    {
        $this->container['asn_name'] = $asn_name;

        return $this;
    }

    /**
     * Gets quality_score
     *
     * @return string|null
     */
    public function getQualityScore()
    {
        return $this->container['quality_score'];
    }

    /**
     * Sets quality_score
     *
     * @param string|null $quality_score quality_score
     *
     * @return $this
     */
    public function setQualityScore($quality_score)
    {
        $this->container['quality_score'] = $quality_score;

        return $this;
    }

    /**
     * Gets player_software_version
     *
     * @return string|null
     */
    public function getPlayerSoftwareVersion()
    {
        return $this->container['player_software_version'];
    }

    /**
     * Sets player_software_version
     *
     * @param string|null $player_software_version player_software_version
     *
     * @return $this
     */
    public function setPlayerSoftwareVersion($player_software_version)
    {
        $this->container['player_software_version'] = $player_software_version;

        return $this;
    }

    /**
     * Gets player_mux_plugin_name
     *
     * @return string|null
     */
    public function getPlayerMuxPluginName()
    {
        return $this->container['player_mux_plugin_name'];
    }

    /**
     * Sets player_mux_plugin_name
     *
     * @param string|null $player_mux_plugin_name player_mux_plugin_name
     *
     * @return $this
     */
    public function setPlayerMuxPluginName($player_mux_plugin_name)
    {
        $this->container['player_mux_plugin_name'] = $player_mux_plugin_name;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }
}


