<?php

// Protocol Buffers - Google's data interchange format
// Copyright 2017 Google Inc.  All rights reserved.
// https://developers.google.com/protocol-buffers/
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//     * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
//     * Neither the name of Google Inc. nor the names of its
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

namespace MediaCloud\Vendor\Google\Protobuf;

class DescriptorPool
{
    private static $pool;

    private $internal_pool;

    /**
     * @return DescriptorPool
     */
    public static function getGeneratedPool()
    {
        if (!isset(self::$pool)) {
            self::$pool = new DescriptorPool(\MediaCloud\Vendor\Google\Protobuf\Internal\DescriptorPool::getGeneratedPool());
        }
        return self::$pool;
    }

    private function __construct($internal_pool)
    {
        $this->internal_pool = $internal_pool;
    }

    /**
     * @param string $className A fully qualified protobuf class name
     * @return Descriptor
     */
    public function getDescriptorByClassName($className)
    {
        $desc = $this->internal_pool->getDescriptorByClassName($className);
        return is_null($desc) ? null : $desc->getPublicDescriptor();
    }

    /**
     * @param string $className A fully qualified protobuf class name
     * @return EnumDescriptor
     */
    public function getEnumDescriptorByClassName($className)
    {
        $desc = $this->internal_pool->getEnumDescriptorByClassName($className);
        return is_null($desc) ? null : $desc->getPublicDescriptor();
    }
}
