<?php

namespace MediaCloud\Vendor\Aws\SageMaker;
use MediaCloud\Vendor\Aws\AwsClient;

/**
 * This client is used to interact with the **Amazon SageMaker Service** service.
 * @method \MediaCloud\Vendor\Aws\Result addAssociation(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise addAssociationAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result addTags(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise addTagsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result associateTrialComponent(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise associateTrialComponentAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result batchDescribeModelPackage(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise batchDescribeModelPackageAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createAction(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createActionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createAlgorithm(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createAlgorithmAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createApp(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createAppAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createAppImageConfig(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createAppImageConfigAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createArtifact(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createArtifactAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createAutoMLJob(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createAutoMLJobAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createCodeRepository(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createCodeRepositoryAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createCompilationJob(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createCompilationJobAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createContext(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createContextAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createDataQualityJobDefinition(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createDataQualityJobDefinitionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createDeviceFleet(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createDeviceFleetAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createDomain(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createDomainAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createEdgePackagingJob(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createEdgePackagingJobAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createEndpoint(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createEndpointAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createEndpointConfig(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createEndpointConfigAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createExperiment(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createExperimentAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createFeatureGroup(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createFeatureGroupAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createFlowDefinition(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createFlowDefinitionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createHumanTaskUi(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createHumanTaskUiAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createHyperParameterTuningJob(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createHyperParameterTuningJobAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createImage(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createImageAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createImageVersion(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createImageVersionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createInferenceRecommendationsJob(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createInferenceRecommendationsJobAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createLabelingJob(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createLabelingJobAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createModel(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createModelAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createModelBiasJobDefinition(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createModelBiasJobDefinitionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createModelExplainabilityJobDefinition(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createModelExplainabilityJobDefinitionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createModelPackage(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createModelPackageAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createModelPackageGroup(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createModelPackageGroupAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createModelQualityJobDefinition(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createModelQualityJobDefinitionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createMonitoringSchedule(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createMonitoringScheduleAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createNotebookInstance(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createNotebookInstanceAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createNotebookInstanceLifecycleConfig(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createNotebookInstanceLifecycleConfigAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createPipeline(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createPipelineAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createPresignedDomainUrl(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createPresignedDomainUrlAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createPresignedNotebookInstanceUrl(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createPresignedNotebookInstanceUrlAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createProcessingJob(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createProcessingJobAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createProject(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createProjectAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createStudioLifecycleConfig(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createStudioLifecycleConfigAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createTrainingJob(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createTrainingJobAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createTransformJob(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createTransformJobAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createTrial(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createTrialAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createTrialComponent(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createTrialComponentAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createUserProfile(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createUserProfileAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createWorkforce(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createWorkforceAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createWorkteam(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createWorkteamAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteAction(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteActionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteAlgorithm(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteAlgorithmAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteApp(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteAppAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteAppImageConfig(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteAppImageConfigAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteArtifact(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteArtifactAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteAssociation(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteAssociationAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteCodeRepository(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteCodeRepositoryAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteContext(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteContextAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteDataQualityJobDefinition(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteDataQualityJobDefinitionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteDeviceFleet(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteDeviceFleetAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteDomain(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteDomainAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteEndpoint(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteEndpointAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteEndpointConfig(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteEndpointConfigAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteExperiment(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteExperimentAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteFeatureGroup(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteFeatureGroupAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteFlowDefinition(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteFlowDefinitionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteHumanTaskUi(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteHumanTaskUiAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteImage(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteImageAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteImageVersion(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteImageVersionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteModel(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteModelAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteModelBiasJobDefinition(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteModelBiasJobDefinitionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteModelExplainabilityJobDefinition(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteModelExplainabilityJobDefinitionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteModelPackage(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteModelPackageAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteModelPackageGroup(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteModelPackageGroupAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteModelPackageGroupPolicy(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteModelPackageGroupPolicyAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteModelQualityJobDefinition(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteModelQualityJobDefinitionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteMonitoringSchedule(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteMonitoringScheduleAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteNotebookInstance(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteNotebookInstanceAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteNotebookInstanceLifecycleConfig(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteNotebookInstanceLifecycleConfigAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deletePipeline(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deletePipelineAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteProject(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteProjectAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteStudioLifecycleConfig(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteStudioLifecycleConfigAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteTags(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteTagsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteTrial(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteTrialAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteTrialComponent(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteTrialComponentAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteUserProfile(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteUserProfileAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteWorkforce(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteWorkforceAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteWorkteam(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteWorkteamAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deregisterDevices(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deregisterDevicesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeAction(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeActionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeAlgorithm(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeAlgorithmAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeApp(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeAppAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeAppImageConfig(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeAppImageConfigAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeArtifact(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeArtifactAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeAutoMLJob(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeAutoMLJobAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeCodeRepository(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeCodeRepositoryAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeCompilationJob(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeCompilationJobAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeContext(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeContextAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeDataQualityJobDefinition(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeDataQualityJobDefinitionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeDevice(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeDeviceAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeDeviceFleet(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeDeviceFleetAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeDomain(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeDomainAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeEdgePackagingJob(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeEdgePackagingJobAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeEndpoint(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeEndpointAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeEndpointConfig(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeEndpointConfigAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeExperiment(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeExperimentAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeFeatureGroup(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeFeatureGroupAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeFlowDefinition(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeFlowDefinitionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeHumanTaskUi(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeHumanTaskUiAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeHyperParameterTuningJob(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeHyperParameterTuningJobAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeImage(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeImageAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeImageVersion(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeImageVersionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeInferenceRecommendationsJob(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeInferenceRecommendationsJobAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeLabelingJob(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeLabelingJobAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeLineageGroup(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeLineageGroupAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeModel(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeModelAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeModelBiasJobDefinition(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeModelBiasJobDefinitionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeModelExplainabilityJobDefinition(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeModelExplainabilityJobDefinitionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeModelPackage(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeModelPackageAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeModelPackageGroup(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeModelPackageGroupAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeModelQualityJobDefinition(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeModelQualityJobDefinitionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeMonitoringSchedule(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeMonitoringScheduleAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeNotebookInstance(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeNotebookInstanceAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeNotebookInstanceLifecycleConfig(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeNotebookInstanceLifecycleConfigAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describePipeline(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describePipelineAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describePipelineDefinitionForExecution(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describePipelineDefinitionForExecutionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describePipelineExecution(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describePipelineExecutionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeProcessingJob(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeProcessingJobAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeProject(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeProjectAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeStudioLifecycleConfig(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeStudioLifecycleConfigAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeSubscribedWorkteam(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeSubscribedWorkteamAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeTrainingJob(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeTrainingJobAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeTransformJob(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeTransformJobAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeTrial(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeTrialAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeTrialComponent(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeTrialComponentAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeUserProfile(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeUserProfileAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeWorkforce(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeWorkforceAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeWorkteam(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeWorkteamAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result disableSagemakerServicecatalogPortfolio(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise disableSagemakerServicecatalogPortfolioAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result disassociateTrialComponent(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise disassociateTrialComponentAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result enableSagemakerServicecatalogPortfolio(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise enableSagemakerServicecatalogPortfolioAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getDeviceFleetReport(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getDeviceFleetReportAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getLineageGroupPolicy(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getLineageGroupPolicyAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getModelPackageGroupPolicy(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getModelPackageGroupPolicyAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getSagemakerServicecatalogPortfolioStatus(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getSagemakerServicecatalogPortfolioStatusAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getSearchSuggestions(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getSearchSuggestionsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listActions(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listActionsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listAlgorithms(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listAlgorithmsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listAppImageConfigs(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listAppImageConfigsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listApps(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listAppsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listArtifacts(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listArtifactsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listAssociations(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listAssociationsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listAutoMLJobs(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listAutoMLJobsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listCandidatesForAutoMLJob(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listCandidatesForAutoMLJobAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listCodeRepositories(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listCodeRepositoriesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listCompilationJobs(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listCompilationJobsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listContexts(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listContextsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listDataQualityJobDefinitions(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listDataQualityJobDefinitionsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listDeviceFleets(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listDeviceFleetsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listDevices(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listDevicesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listDomains(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listDomainsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listEdgePackagingJobs(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listEdgePackagingJobsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listEndpointConfigs(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listEndpointConfigsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listEndpoints(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listEndpointsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listExperiments(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listExperimentsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listFeatureGroups(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listFeatureGroupsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listFlowDefinitions(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listFlowDefinitionsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listHumanTaskUis(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listHumanTaskUisAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listHyperParameterTuningJobs(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listHyperParameterTuningJobsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listImageVersions(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listImageVersionsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listImages(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listImagesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listInferenceRecommendationsJobs(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listInferenceRecommendationsJobsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listLabelingJobs(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listLabelingJobsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listLabelingJobsForWorkteam(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listLabelingJobsForWorkteamAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listLineageGroups(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listLineageGroupsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listModelBiasJobDefinitions(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listModelBiasJobDefinitionsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listModelExplainabilityJobDefinitions(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listModelExplainabilityJobDefinitionsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listModelMetadata(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listModelMetadataAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listModelPackageGroups(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listModelPackageGroupsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listModelPackages(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listModelPackagesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listModelQualityJobDefinitions(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listModelQualityJobDefinitionsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listModels(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listModelsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listMonitoringExecutions(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listMonitoringExecutionsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listMonitoringSchedules(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listMonitoringSchedulesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listNotebookInstanceLifecycleConfigs(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listNotebookInstanceLifecycleConfigsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listNotebookInstances(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listNotebookInstancesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listPipelineExecutionSteps(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listPipelineExecutionStepsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listPipelineExecutions(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listPipelineExecutionsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listPipelineParametersForExecution(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listPipelineParametersForExecutionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listPipelines(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listPipelinesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listProcessingJobs(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listProcessingJobsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listProjects(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listProjectsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listStudioLifecycleConfigs(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listStudioLifecycleConfigsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listSubscribedWorkteams(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listSubscribedWorkteamsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listTags(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listTagsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listTrainingJobs(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listTrainingJobsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listTrainingJobsForHyperParameterTuningJob(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listTrainingJobsForHyperParameterTuningJobAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listTransformJobs(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listTransformJobsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listTrialComponents(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listTrialComponentsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listTrials(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listTrialsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listUserProfiles(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listUserProfilesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listWorkforces(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listWorkforcesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listWorkteams(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listWorkteamsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result putModelPackageGroupPolicy(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise putModelPackageGroupPolicyAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result queryLineage(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise queryLineageAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result registerDevices(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise registerDevicesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result renderUiTemplate(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise renderUiTemplateAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result retryPipelineExecution(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise retryPipelineExecutionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result search(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise searchAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result sendPipelineExecutionStepFailure(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise sendPipelineExecutionStepFailureAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result sendPipelineExecutionStepSuccess(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise sendPipelineExecutionStepSuccessAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result startMonitoringSchedule(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise startMonitoringScheduleAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result startNotebookInstance(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise startNotebookInstanceAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result startPipelineExecution(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise startPipelineExecutionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result stopAutoMLJob(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise stopAutoMLJobAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result stopCompilationJob(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise stopCompilationJobAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result stopEdgePackagingJob(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise stopEdgePackagingJobAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result stopHyperParameterTuningJob(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise stopHyperParameterTuningJobAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result stopInferenceRecommendationsJob(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise stopInferenceRecommendationsJobAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result stopLabelingJob(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise stopLabelingJobAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result stopMonitoringSchedule(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise stopMonitoringScheduleAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result stopNotebookInstance(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise stopNotebookInstanceAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result stopPipelineExecution(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise stopPipelineExecutionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result stopProcessingJob(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise stopProcessingJobAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result stopTrainingJob(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise stopTrainingJobAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result stopTransformJob(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise stopTransformJobAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateAction(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateActionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateAppImageConfig(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateAppImageConfigAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateArtifact(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateArtifactAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateCodeRepository(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateCodeRepositoryAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateContext(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateContextAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateDeviceFleet(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateDeviceFleetAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateDevices(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateDevicesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateDomain(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateDomainAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateEndpoint(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateEndpointAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateEndpointWeightsAndCapacities(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateEndpointWeightsAndCapacitiesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateExperiment(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateExperimentAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateImage(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateImageAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateModelPackage(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateModelPackageAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateMonitoringSchedule(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateMonitoringScheduleAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateNotebookInstance(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateNotebookInstanceAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateNotebookInstanceLifecycleConfig(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateNotebookInstanceLifecycleConfigAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updatePipeline(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updatePipelineAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updatePipelineExecution(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updatePipelineExecutionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateProject(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateProjectAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateTrainingJob(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateTrainingJobAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateTrial(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateTrialAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateTrialComponent(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateTrialComponentAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateUserProfile(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateUserProfileAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateWorkforce(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateWorkforceAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateWorkteam(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateWorkteamAsync(array $args = [])
 */
class SageMakerClient extends AwsClient {}
