<?php


namespace MediaCloud\Plugin\Tools\Debugging;

use MediaCloud\Plugin\Tools\ToolSettings;
use MediaCloud\Plugin\Utilities\Environment;

/**
 * Class UploadToolSettings
 *
 * @property string $debugLoggingLevel
 * @property bool $debugContentFiltering
 * @property int $maxDatabaseEntries
 * @property string $debugRemoteUrl
 * @property int $debugRemotePort
 * @property string[] $debugRegexFilters
 * @property bool $useRay
 */
class DebuggingToolSettings extends ToolSettings {
	private $_debugRegexFilters = null;

	protected $settingsMap = [
		"debugLoggingLevel" => ['mcloud-debug-logging-level', null, 'info'],
		"debugContentFiltering" => ['mcloud-debug-content-filtering', null, false],
		"maxDatabaseEntries" => ['mcloud-debug-max-database-entries', null, 1000],
		"debugRemoteUrl" => ['mcloud-debug-remote-url', null, null],
		"debugRemotePort" => ['mcloud-debug-remote-url-port', null, true],
		"useRay" => ['mcloud-debug-use-ray', null, true],
	];

	public function __get($name) {
		if ($name === 'debugRegexFilters') {
			if ($this->_debugRegexFilters === null) {
				$this->_debugRegexFilters = [];

				$filters = Environment::Option('mcloud-debug-ignored-regex', null, '');
				$filter_lines = explode("\n", $filters);

				foreach($filter_lines as $d) {
					if(!empty($d)) {
						$this->_debugRegexFilters[] = '/'.trim($d).'/m';
					}
				}
			}

			return $this->_debugRegexFilters;
		}

		return parent::__get($name); // TODO: Change the autogenerated stub
	}

	public function __isset($name) {
		if (in_array($name, ['debugRegexFilters'])) {
			return true;
		}

		return parent::__isset($name); // TODO: Change the autogenerated stub
	}

	public function matchesFilter($message) {
		foreach($this->debugRegexFilters as $filter) {
			if (preg_match($filter, $message)) {
				return true;
			}
		}

		return false;
	}
}