# IMPress for IDX Broker #
Author: IDX, LLC
**Contributors:** idxco
Author URL: https://idxbroker.com
**Tags:** IDX, MLS, multiple listing service, impress, idx impress, impress for idx broker, IDX plugin, idx broker, idxbroker, idx broker platinum, idx wordpress, idx wordpress plugin, integrated idx, real estate, real estate wordpress, RETS, wordpress idx, wordpress mls, WordPress Plugin, platinum, realtor, idx broker lite, idx lite, idxbroker lite, crm
**Requires at least:** 5.3
**Tested up to:** 6.6.2
**Stable tag:** 3.2.5
**Minimum PHP:** 7.1.8
**License:** GPLv2 or later
**License URI:** http://www.gnu.org/licenses/gpl-2.0.html

## Description ##
IMPress for IDX Broker is now the IMPress family of plugins all-in-one. <a href="https://wordpress.org/plugins/wp-listings/" target="_blank">IMPress Listings</a> and <a href="https://wordpress.org/plugins/impress-agents/" target="_blank">IMPress Agents</a> have been consolidated with this already powerful plugin.

Your IDX Broker-enabled account provides this plugin with access to your MLS data feed. The IMPress for IDX Broker plugin allows you to display that data on your WordPress site using widgets and shortcodes while seamlessly matching your brand.

<h3>IMPress for IDX Broker</h3>

<h4>Manage Your Leads</h4>
No more going between browser windows with the Lead Management interface. Now you can see and manage your leads right within the WordPress dashboard. Plus, you can use powerful lead capture tools to generate new leads. Go beyond and customize your lead capture settings with IDX Broker Platinum.

<h4>Form Integration</h4>
With IMPress for IDX Broker you can create forms within WordPress and capture lead information straight into IDX Broker. At launch, the integration includes several popular form plugins.

<h4>Native WordPress Widgets</h4>
Take advantage of powerful widgets to deliver the best experience, and style them to match the design of your site! You can add lead login, signup, city links, showcase, carousel and even map widgets. Easily add new widgets to pages and posts with built-in shortcodes.

<h4>Map Search Widget</h4>
Add a full-sized map search widget to ANY page on your domain. Create your own custom polygon searches with your IDX Broker Platinum account and allow visitors the ability to search within popular neighborhoods in your area.

<h4>Omnibar Search Widget</h4>
This widget allows you to add an Omnibar Search Widget to your home page. Visitors can then search by city, county, postal code, address, or listing ID. Custom Fields such as School or Subdivision can also be added. No other IDX solution offers this many options in a search widget for your home page.

<h4>Import Your Listings</h4>
You no longer have to manually enter your properties! Import all your IDX properties into WordPress without wasting time on tedious data entry. Plus, have them updated as the MLS changes – directly from your IDX Broker feed!

Control how your featured listings are presented on your real estate website. IMPress automatically creates individual listings pages for your imported properties that can be managed in your WordPress dashboard. These pages can be linked, shared or searched from anywhere else on your site.

<h4>Developer Themes</h4>
Only IMPress for IDX Broker gives you the ability to choose from a <a href="https://idxbroker.com/wordpress-idx-themes" target="_blank">gallery of premium WordPress themes</a> created by our developer partners, designed specifically around use with your IDX Broker account. Choose any theme and IMPress for IDX Broker will seamlessly integrate into your IDX pages. 

<h4>Google My Business</h4>
Connect IMPress for IDX Broker to your verified Google My Business profile to generate and schedule timely posts, photos of your listings, and more. The automatic scheduler can be used to create and share posts to highlight featured listings, open house announcements, recent sales, local expertise, and more.

Posts have the potential to bring leads and clients directly to your IDX-enabled website for more home search opportunities. Google My Business posts are archived on a weekly basis, so automating the process with the scheduler is an easy way to maintain your real estate business’s online presence.

*Automatic posting requires a verified Google My Business account with a verified location.*

<h4>Agent Directory</h4>
IMPress provides you with a full employee directory, that is ideal for Real Estate teams and offices. You can add a custom post type for employees with post meta fields for contact info and add taxonomies for Offices and Job Types to show employees by location and/or job title.

<h4>Optimized for IDX Broker</h4>
Your IDX Broker account provides this plugin with access to your MLS data feed - meaning you can effortlessly integrate IDX Broker features into your WordPress site.

IDX Broker Lite plans offer the essential features and functionality needed for home search. Platinum plans include all the features of Lite plus map search widgets, Market Reports, Sold Data, Polygon Searching and much more.

<a href="https://idxbroker.com/take-a-tour/" target="_blank">Take a tour of IDX Broker today!</a>

<h4>General Terms of Use</h4>
IMPress for IDX Broker uses the MLS/IDX feeds provided by your IDX Broker account. This means your MLS governs the display and disclaimers on your IDX results and details pages. IDX, LLC manages all the necessary MLS paperwork. The IMPress for IDX Broker plugin will automatically display the correct MLS/IDX disclaimers to ensure compliance with the MLS(s) & Board(s) that provides you with your IDX feed.


## Installation ##

1. Install and activate directly by going to your WP Admin Dashboard and then Plugins > Add New. Search for 'IMPress for IDX Broker' under new plugins and click install. Or manually install by downloading and extracting the IMPress for IDX Broker plugin.
2. Upload the uncompressed folder to your `/wp-content/plugins/` directory.
3. Activate the plugin through the Plugins menu in WordPress.
4. Confirm you are using a version of PHP later than 7.0. You will also need to have an active IDX Broker account for the plugin to work. If you have an account, simply go to the IMPress for IDX Broker plugin page within WordPress, enter the API key provided via your setup email, and click the 'Save' button.
5. Your plugin will now pull your IDX Broker account information into Wordpress.

## Frequently Asked Questions ##

### What is IDX? ###
Internet Data Exchange, or IDX, is a type of data feed provided by your MLS. This data feed typically (but not always) mirrors the data available on your MLS's website. IMPress for IDX Broker connects to this data feed automatically, maps the necessary fields, and then adds forms, scripts, etc, giving you a way to add html links and widgets to your website(s).

### How does IDX Broker connect with the IMPress for IDX Broker plugin? ###
An IDX Broker API key (IDX Broker Account Required) provides the IMPress plugin with access to preset Widgets, search forms, an xml sitemap file, and much more.

### How is the IDX content hosted/updated? ###
IDX Broker hosts your IDX data on a subdomain (e.g., search.yoursite.com). This allows IDX Broker to update quickly, and offers a lightning-fast, co-brandable search engine for real estate professionals and WordPress designers regardless of the quality of the hosting solution that you are using for your website. Low quality, inexpensive hosting solutions often cannot process or manage the amount of data provided by an IDX feed.

### Why is IDX Broker hosted in the cloud? ###
All IDX feeds are hosted on high-quality GCP (Google Cloud Platform) servers with multiple layers of redundancy. This ensures that even if your hosted website (mysite.com) goes down, your IDX Broker pages (search.mysite.com) will almost always be available to visitors.

### What is a Wrapper and why does IDX Broker need to create a Wrapper page on my WordPress site? ###
The IMPress plugin offers an easy one-button option to create a Wrapper for IDX pages. This wrapper page is then used to magically update your IDX pages every hour, or whenever you modify/refresh your IDX Broker plugin page. This means less work for you or your website developer.

### Do I need an IDX Broker Lite or Platinum account in order to use this plugin? ###
Yes. All IDX feeds require approval from a local board or MLS. If you (or your client if a designer) are not a member of a local board or MLS, or the MLS does not provide an IDX data feed, then you will be unable to add IMPress for IDX Broker plugin functionality to your WordPress site.

### Is my service area available? ###
<a href="https://idxbroker.com/idx_mls_coverage" target="_blank">Read more about our MLS coverage.</a> Note that some MLS's may charge you a separate fee for access to your IDX feed.

### Does IDX Broker require a long-term contract like other IDX services? ###
No. IDX Broker requires a month-to-month agreement only.

### What is the pricing for IDX Broker services? ###
For updated pricing, please <a href="https://idxbroker.com/idx_broker" target="_blank">visit our website</a> to compare the available account types.

### What can I expect if I decide to get my IDX feed through IDX Broker? ###
When you sign up for a new account our MLS team will send you a Docusign email (or PDF). Simply add your signature to the Docusign file or PDF in order to proceed. If you are not a Principal Broker, and have provided us with your Broker name and contact information, we will then forward the same paperwork to your Broker for approval. Once we receive the paperwork from your Broker, we will send it to the MLS for data approval. MLS approval can take anywhere from 3-10 days. Once approved, we will activate your account, integrate your site's design into IDX pages, and send you IDX Broker login credentials so that you can use this plugin to add links and Widgets to your site or blog.

### How many blogs/websites can I integrate with IDX Broker? ###
Features provided by this Plugin - Widgets, links, and custom links may be placed onto any WordPress website or blog. The reason for this is because all Widgets, links, and custom links point back to the original IDX-approved website. Note that using iframes to display this same content is prohibited and may result in account termination due to MLS rules.

### What are Other Requirements for this Plugin? ###
This plugin requires PHP 7.0 or higher. For security reasons, we recommend updating to the latest stable version of PHP your web host provides. We also recommend using the latest production version of WordPress. See <a href="https://support.idxbroker.com/s/article/wordpress-plugin" target="_blank">this article</a> for more information.

### If I currently have IMPress Listings and/or IMPress Agents - what does the new plugin consolidation mean for me? ###
For users with IMPress 3.0+ who have legacy versions of IMPress Listings and/or IMPress Agents already installed, the plugins will continue to work as-is. However, if the user selects ‘Enable Listings’ or ‘Enable Agents’ in the new IMPress for IDX dashboard, the legacy IMPress Listings/Agents will be deactivated and the new consolidated version of the plugin will be used. Any existing data for Listings/Agents will be unaffected.

## Changelog ##
### 3.2.5 ###
* Update: Handle for sold price being displayed for sold listings instead of the listing price.
* Fix : Handle for 0 legacy or 0 new widgets.
* Fix : Handle subscription type name change Platinum -> Enagage.

### 3.2.4 ###
* Fix: Changed Sanitization method
* Fix: Paginate widgets API method
* Update: Handle for 3 character postal codes

### 3.2.3 ###
* Fix: Sanitized shortcode input

### 3.2.2 ###
* Hotfix: Page errors when account has 0 non-legacy widgets when using API v1.8.0

### 3.2.1 ###
* Update: Added a button to log out of Google My Business
* Fix: Custom cron schedule calculations
* Fix: "New" Widgets not displaying when using API v1.8.0

### 3.2.0 ###
* Update: IMPress Showcase and Carousel widgets display 'Coming Soon' prior to MLS approval, but only when required by MLS rules
* Update: Omnibar Advanced Fields searching optimized to use exact search parameters instead of wild text
* Update: Default to use IDX Broker API v1.8.0
* Update: Off Market listings will now be updated to the proper status of 'unknown' to not misrepresent non-active listings and respect the sold listings update settings
* Fix: Imported listings not always imported with MLS disclaimers
* Fix: Changes to the Omnibar settings trigger the location data refresh cron properly
* Fix: Omnibar accurately searches city and county data for non-US states
* Fix: Resolve PHP 8 deprecated features regarding required parameters followed by optional parameters in functions
* Fix: Resolve PHP 8.3 deprecated features and update Carbon dependency
* Fix: Resolve PHP 8 Errors with Gravity Forms and Contact Form 7 and compatibility updates
* Fix: Submission errors from Gravity Forms, CF7, Ninja Forms with lead import enabled attempting to creating a note on an existing leads account
* Fix: Social Pro articles may not be syndicated properly
* Fix: Resolve PHP errors when enabling Listings and Agents addons for the first time
* Fix: Listings import not respecting update-excluding-images setting
* Fix: IMPress Carousel widget possibly duplicating a single listing if multiple carousels exist on the page.

### 3.1.0 ###
* New: Supplemental Listings can now be targeted by Active, Sold, or Both within all IMPress Property widgets under the Properties to Feature dropdown
* Update: IMPress plugin now compatible with WordPress subdirectory installs
* Update: Accessibility adjustments for IMPress Widgets
* Fix: Update Frequency changes removing some cron events
* Fix: Omnibar not always searching for closed status listings
* Fix: Apply Wrapper To IDX Pages dropdown for Wrappers not accurately updating the IDX Account wrapper settings
* Fix: CF7 and IMPress PHP 8 Errors on form submission
* Fix: Unable to create, edit, delete leads in some cases
* Fix: Unable to delete lead saved search
* Fix: Editing a lead saved property will empty the Name field
* Fix: Traffic history table display issue viewing individual leads
* Fix: IMPress GMB page not accessible after saving a post
* Fix: Accurate sort order by timestamp when viewing Leads
* Fix: Re-ordering Custom Taxonomies deletes all custom taxonomies in WP 6.0+
* Fix: Creating saved link from plugin using incorrect bath field
* Fix: Various bug fixes and middleware link updates

### 3.0.10 ###
* Fix: CF7 Captcha Conflict
* Update: Readme file updates

### 3.0.9 ###
* Fix: Legacy IMPress Widgets display issues
* Fix: 3rd Party Form integrations not sending leads to IDX Broker
* Fix: Missing Font Awesome files
* Fix: MLS name trademark display issues
* Update: Omnibar custom fields - blacklisted core fields
* Update: IDX Broker Map Search Widget - Removed duplicate leaflet dependencies in relation to Azure migration

### 3.0.8 ###
* Fix: Some additional sanitization and escaping added that was missed in 3.0.7
* Update: Moved externally hosted CSS file into the plugin
* Update: Bootstrap.js version used for the listing templates "Solid" and "Classical" was bumped from 3.1.1 to 5.1.3

### 3.0.7 ###
* Fix: Large scale security overhaul including sanitization/escaping and removal of any PHP eval() usage
* Fix: Previously externally hosted scripts, styles, and images have now been moved into the plugin
* Fix: Resolves missing index warning on IMPress widgets when displaying sold supplemental listings

### 3.0.6 ###
* Fix: Additional escaping added to Lead Management page

### 3.0.5 ###
* Fix: Resolves potential security issue on the Lead Management page
* Fix: Duplicate entries in IMPress Carousel widget when there are too few items to display

### 3.0.4 ###
* New: IDX Map Search Widget provider changed to Azure maps
* Fix: IMPress block widgets updated for WordPress 5.8 to prevent error log entries about enqueuing resources
* Fix: Missing shortcode options for the legacy IMPress Listings and Agents widgets, the 'impress-listings-search' button and the imported 'impress-agent' list, have been added

### 3.0.3 ###
* Fix: Listings auto-import scheduled task not disabling correctly
* Fix: Missing closing tag on IMPress Showcase widgets when only one listing is displayed
* Fix: Listing post archive page no longer requires visiting the permalinks settings page after enabling

### 3.0.2 ###
* Fix: Resolves multiple IMPress Showcase/Carousel/Omnibar widget display issues
* Fix: Prevents menu conflicts with some 3rd party plugins

### 3.0.1 ###
* Fix: Omnibar not setting a property type for some searches
* Fix: Resolves missing option issue for the IMPress Lead Login widget

### 3.0.0 ###
* New: Now includes both IMPress Agents and IMPress Listings
* New: Revamped wp-admin UI
* New: Social Pro integration

### 2.6.7 ###
* Fix: Issues with the Omnibar widget not creating the required locationlist.js file
* Fix: IMPress Showcase widget not correctly filtering by agent
* Fix: Market Report and Virtual Tour IDX Broker widgets now load correctly
* New: Option to include a developer partner API key (field appears by adding '&idxdev' to the URL on the IDX IMPress > Initial Settings page)

### 2.6.6 ###
* New: Omnibar step control increments increased
* Fix: Gutenberg block menu padding
* Fix: Resolves bug that caused some cron scheduling issues
* Fix: Resolves rest route registration warnings 

### 2.6.5 ###
* New: Pricing information changes

### 2.6.4 ###
* Fix: Resolves issue with IDX Broker API that prevented supplemental listings from importing when using IMPress Listings.

### 2.6.3 ###
* New: reCAPTCHA v3 support added to the IMPress Lead Signup widget.
* Fix: Add IDX Shortcode button blocks other buttons when using the classic editor.
* Fix: Resolves omnibar issues that could prevent the default property type from saving.
* Fix: Resolves issue where addresses used for omnibar searches would not save correctly.
* Fix: Sold supplemental listings being included with active results for IMPress Carousel and Showcase widgets.

### 2.6.2 ###
* Fix: Resolves potential security issues in settings forms and adds additional capability checks.

### 2.6.1 ###
* Fix: Resolves issue with supplemental listings.

### 2.6.0 ###
* New: Gutenberg blocks added for IMPress and IDX Broker widgets.
* New: Updated to use IDX Broker API v1.7.0.
* Fix: Sizing of 'Add IDX Shortcode' when using the classic editor.
* Fix: IMPress Carousel/Showcase widget shortcodes correctly save agent ID when set.
* Fix: IE 11 compatibility issue with IMPress Carousel widgets.
* Fix: Issue preventing all leads from appearing in the Leads section of the dashboard.

### 2.5.12 ###
* Fix: Resolves potential security issue in settings form.

### 2.5.11 ###
* Fix: Font Awesome 5 support.

### 2.5.10 ###
* Fix: IMPress Carousel and Showcase widgets no longer show duplicate entries.
* Fix: Admin panel widget no longer throws a PHP error if an API call fails.
* Fix: Required reCAPTCHA version specified in plugin settings.
* Fix: jQuery dependancy issue for IMPress Carousel widgets.
* Fix: Cron jobs no longer duplicated upon plugin refresh.

### 2.5.9 ###
* Fix: IDX Broker HOME and Platinum accounts now show the correct plugin options.

### 2.5.8 ###
* Fix: IDX Broker HOME accounts now have access to Platinum features.
* Fix: Carousel and Showcase widgets/shortcodes now show street direction in the correct place.

### 2.5.7 ###
* Fix: Leads not tracking correctly with the new 1.6.0 api.
* Fix: Added support to set custom intervals for cron jobs.

### 2.5.6 ###
* Fix: Now uses IDX api version 1.6.0.

### 2.5.5 ###
* Fix: Dev feature impress_showcase_property_html filter fixed
* Fix: Cache option names updated so changes made on Leads and Searches page display immediately.
* Fix: Option set when API limit exceeded to prevent additional API calls until limit is reset.

### 2.5.4 ###
* Fix: Property widgets and shortcodes now have a default sort option that respects a saved link's sorting method.
* Fix: Fatal error on API exhaustion.

### 2.5.3 ###
* Fix: Javascript error with map search widget when using IMPress - IDX Middleware widget.
* Fix: Invalid regex in omnibar autocomplete API.

### 2.5.2 ###
* Fix: Fatal error on PHP < 5.5. Minimum required PHP version increased to 5.6.

### 2.5.1 ###
* New: Omnibar now supports address autocomplete by default.
* New: Middleware widgets are no longer individually imported. A single IMPress - IDX Dashboard Widget is available to use instead. Migration script will replace any old widgets in use upon upgrade.
* Fix: Gravity forms lead push failing when default labels of required fields are changed.
* Fix: Deprecated warning on PHP 7.2+ for Middlware widgets.

### 2.5.0 ###
* New: Display saved links in property showcase and carousel widgets and shortcodes!
* Fix: City links widget with property count uses single API call per MLS to get count.
* Fix: Uninstall hook moved to separate uninstall.php file and cleanup routines more thorough.

### 2.4.5 ###
* Fix: Yoast SEO noindex detection

### 2.4.4 ###
* New: Can now add password field to lead sign up widget and shortcode
* New: Now notifies you if Yoast SEO is causing your pages to not be indexed by search engines
* Fix: No longer loads multiple versions of Font Awesome
* Fix: City Links now show 0 when there are no properties in those cities
* Fix: Error when using Carousel shortcode with impress_carousel_property_html filter

### 2.4.3 ###
* New: Lead Sign Up widget button text is now customizable
* New: Lead Login widget can now have a password field
* New: Agent routing now possible with Gravity Forms
* Fix: Adding custom fields to Omnibar in Firefox no longer errors
* Fix: Removed cURL dependency

### 2.4.2 ###
* Fix: Permissions issue with adding/editing/deleting wrappers
* Fix: Update Carousel script to v2 for compatibility issues

### 2.4.1 ###
* New: For multi-user IDX accounts, now you can filter property widgets by agent.
* New: Multisite feature: Assign agents to sites on a network to have their agentHeaderID added to widgets and IDX url's for lead tracking.
* New: Developer feature: Added filters (impress_carousel_property_html and impress_carousel_property_html) to modify property widget/shortcode HTML output.
* Fix: Default photo URL updated to HTTPS.

### 2.4.0 ###
* New: Added option to display listing counts to city list widget and shortcode. Max 50 cities.
* New: Added signup date to lead management table.
* Fix: Resolved issued when searching for multi-part addresses.
* Fix: Omnibar scripts explicitly enqueued in footer.
* Fix: Issue with property carousel or showcase widgets displaying zeroes when there are no results.
* Fix: Add Shortcode button on non-standard wp_editor instances removed for compatibility issues.
* Fix: Wrapper CSS specificity increased so only intended elements are targeted to hide.
* Fix: Widget code cleanup.

### 2.3.5 ###
* Fix: Update additional deprecated URLs for SSL compatibility
* Fix: Improved messaging for API status codes

### 2.3.4 ###
* Fix: Cron schedule filter modified to prevent interference with other scheduled cron jobs
* Fix: Broken knowledge base links on settings page
* Fix: Load select2 script in footer to prevent conflict with custom select2 script packaged with Avada theme
* Fix: Deprecated URLs causing console errors in Admin Dashboard Edit pages

### 2.3.3 ###
* New: Added reCaptcha to lead signup widget to prevent spam signups
* Fix: Alignment of IDX logo icon

### 2.3.2 ###
* Fix: Omnibar with extra fields failing due to missing sort order

### 2.3.1 ###
* Fix: Omnibar extra fields UX enhancement reverted due to issues with form submission

### 2.3.0 ###
* New: Added interface for creating saved searches and lead saved searches
* New: Added option for omnibar default results sorting
* New: Implemented material design dialogs instead of browser native dialogs
* New: Added idx-wrapper-tags shortcode to shortcode UI
* New: Added filter for developers to modify IDX meta tags added to wrapper (h/t imforza)
* Fix: Multisite compatibility - Omnibar location list moved to site uploads folder
* Fix: Omnibar extra fields UX enhancement - fields names distinguished from values
* Fix: Gravity Forms lead import tooltip instruction clarified

### 2.2.1 ###
* Fix: Square feet showing truncated values in widgets and shortcodes
* Fix: Added email validation for lead management
* Fix: Lead management times are now offset based on WP timezone settings
* Fix: PHP notice in lead management UI
* Notice: Dropped support for PHP < 5.4

### 2.2.0 ###
* New: Added Lead Management interface so you can manage leads directly in WordPress
* New: Capture leads with integration with popular WordPress form plugins (Gravity Forms, Ninja Forms, Contact Form 7)
* New: Widgets updated to use selective refresh in WP > 4.5
* Tweak: Refactored plugin to remove IoC container that caused conflicts on some hosting platforms
* Tweak: Limit use of eval that caused false positive security warnings in some scanners
* Tweak: Removed historical as an option for property widgets as its no longer available in the API
* Tweak: Removed disallowed fields from Omnibar search
* Tweak: Removed ineffective Equity IP blacklist functionality

### 2.1.5 ###
* Added compatibility with custom user roles for IDX Pages.
* Removed protocol from widget src for SSL compatibility.
* Fixed error with Dashboard widget when lead has no last name.

### 2.1.4 ###
* Fixed issue with API URL in WP 4.6+
* Refactored register widget function to use core functions
* Added screen-reader-text CSS for themes without it

### 2.1.3 ###
* Fixed the warning issue for showcase shortcodes as well.
* Fixed disclaimer markup so it only displays if required.
* Fixed issue with saved links with no results in shortcodes and widgets.

### 2.1.2 ###
* An issue where warnings were displayed for some showcases and carousels has been fixed.

### 2.1.1 ###
* IDX Pages are now automatically updated when their URLs change allowing more seamless domain/subdomain changes for IDX accounts.
* Error handling has been added to the IMPress Lead Signup widget for duplicate accounts, blank fields, and invalid email addresses.
* An issue has been fixed where IMPress Carousel widgets and shortcodes displayed listing count was not being followed on smaller screens.
* Verbiage for the min price field has been updated for the omnibar to clarify Extra Fields must be enabled to display it.
* The styling was updated for the IDX icon where it was misaligned in the admin bar on the front end.
* Courtesies are now displayed on IMPress Showcases and Carousels when required by MLS rules.

### 2.1.0 ###
* Adds Min Price option for the IMPress Omnibar Widget and Shortcode.
* IMPress Showcase and Carousels now use the address for the image title attribute for better SEO.
* The Omnibar main input has been updated for better accessibility with screen readers.
* A Shortcode has been added to make regular WP pages a wrapper for incompatible plugins.
* A bug has been fixed where the omnibar was not updating properly from the Omnibar Settings page.
* The Omnibar Settings page has been updated for a better UX.
* A wrapper can now be applied to a specific IDX Page when editing IDX Pages.
* Wrappers are now more compatible with other plugins.
* Wrapper styling has been updated to hide common irrelevant meta data from IDX pages.
* A new Dashboard widget has been added for a convenient overview of Leads and Listings.
* Fixed an issue where IDX pages were not imported at all and caused slow downs on slower servers.

### 2.0.3 ###
* Fixed an issue where plugin review prompt could not be dismissed.

### 2.0.2 ###
* Fixed an issue where a saved links field was incorrectly displaying on Carousel and Showcase shortcodes for Lite accounts (This only works for Platinum accounts).
* Fixed a similar issue where saved links were displaying a UI to apply page level wrappers to them for Lite accounts.
* Incorporated an IoC Container into the plugin for a cleaner coding structure.
* Equity accounts now have ip blacklisting protection against scrapers stealing website content.
* Added option to open several IMPress widgets and shortcodes in a new window.
* Disable the IDX Broker Origin plugin if active to prevent conflicts.

### 2.0.1 ###
* Fixed a minor issue where a notice was displaying for users with error reporting enabled.

### 2.0.0 ###
* The IDX Broker plugin has been renamed as the IMPress plugin.
* Five new WordPress native IMPress widgets and shortcodes have been added to the plugin: lead login and signup widgets, a city links widget, and showcase and carousel widgets have been added. Take advantage of these new widgets to deliver the best experience for your website visitors.
* Each of these widgets has customization options right within WordPress including the ability to disable styling. Designers can use this to gain more control of the appearance of these widgets.
* IDX Pages can now have excerpts and thumbnails applied through the new IDX Pages link in the admin menu.
* Included several Customization Options for the Omnibar.
* The IDX Shortcode UI has been modified to have a better UX.
* The WordPress Help button is now available for learning about the plugin features.
* Lite accounts will have an Upgrade Account link available for easy upgrading to Platinum.
* Plugin links have been added to the admin bar at the top giving easy access to common pages for admins.
* Added composer, npm, and gulp support.

### 1.3.2 ###
* Fix an issue where upgrading resulted in a 500 error for clients with many saved links.
* Fix an issue with unexpected results with IDX pages switching between older and newer versions of the plugin.

### 1.3.1 ###
* Fixed an issue with duplicate start and stop tags for dynamic wrappers when Equity is installed.
* Fixed a bug where errors were being reported.
* Fixed an issue where the omnibar would not load or update on servers with strict restrictions.

### 1.3.0 ###
* Improved compatability with WP caching plugins fixing a bug that caused an API overage.
* Simplified the Admin UI.
* The IDX Shortcode UI has been redesigned and is now independent of the visual editor allowing shortcodes to be added in the text view of a page or post in addition to the visual view.
* IDX Pages and Wrappers are now stored as custom post types no longer cluttering the Pages section of WordPress. You can still link to IDX pages as before through Appearance > Menus or via shortcodes.
* Copying and Pasting the URL into Designs > Wrappers is no longer required for global wrappers. Creating a Global Wrapper page now automatically updates your IDX pages to use the new Global Wrapper Page via the API. Wrappers can also now be applied to a specific IDX page by editing a Wrapper and setting the Apply Wrapper to IDX Pages metabox before saving.
* Map Search Widget scripts are now only loaded when a map search widget is on the page speeding up the rest of your website.
* This plugin now has its own Top Menu. Say goodbye to searching for plugin preferences in the Settings Menu.
* The Admin page is now fully responsive allowing you easily to make WordPress changes from your mobile device.

### 1.2.4 ###
* Fixed bug where a Parse Error was displayed instead of a notification to upgrade the PHP version to higher than 5.2 when activating.
* Fixed an issue with shortcodes and widgets not working properly for some users.
* Added backwards compatability with legacy dynamic wrapper usage in themes.

### 1.2.3 ###
* Fixed bug with omnibar data not updating properly.

### 1.2.2 ###
* Restructured code and made it more WP4.3 and PSR compliant.
* Fixed bug with widgets not being cached properly.
* Fixed display issue with extra fields displaying on the regular Omnibar for a split second on load.
* Automatically update omnibar data once a day.
* Dropped support for PHP 5.2 as it is deprecated. For more information, see PHP supported versions: http://php.net/supported-versions.php

### 1.2.1 ###
* Updated code for compatibility with WP4.3 release.
* Improved acceptable Omnibar values.

### 1.2.0 ###
* Added two types of Omnibar Widgets to the plugin under Appearance > Widgets and as shortcodes. To refresh the cities, counties, and zipcodes for this widget, hit the Refresh Plugin Options button under the Settings tab of the IMPress for IDX Broker plugin. Cities, Counties, and Zipcodes are all active ones on the account.

### 1.1.7 ###
* Fix savedLink page tile issue.

### 1.1.6 ###
* Updated API calls to use the newest version of the IDX Broker API
* Fully tested to be compatible with WordPress v4.1

### 1.1.5 ###
* Fixed widget drag and drop bug
* Update plugin settings labels.

### 1.1.4 ###
* Fixed can't add tons of savelinks and systemlinks pages issue.

### 1.1.3 ###
* Added create dynamic wrapper page, clients can create a page for dynamic wrapper on the setting page.
* Fixed idx button on Multi site WP.

### 1.1.2 ###
* Fixed minor bug causing some Shortcodes to disappear

### 1.1.1 ###
* Changed MapQuest API version to v1.0
* Updated Leaflet version to v0.7.2

### 1.1.0 ###
* Fully tested to be compatible with WP v3.8.
* Fixed small bugs with certain characters in widget titles causing an error within the plugin.
* Added MapQuest map search library, clients now have the option between Bing or MapQuest for their map search widget.
* Added ability to hide IDX Broker widget titles by using keyword '!%hide_title!%' as the widget title inside the WordPress dashboard. This functionality will be extended by adding additional keywords in future revisions.
* Small bug fixes to IDX Broker shortcodes causing issues with multi-site installations.
* More detailed responses from the IDX Broker API if an error occurs.

### 1.0.9 ###
* Added helpful links to plugin. Fully tested to 3.6.1. Added Bing Map search library for users who add the map widget.

### 1.0.8 ###
* Remove Beta image from control panel. Remaining Beta text from readme.

### 1.0.7 ###
* Added support for php start and stop tags. Some users migrating from the original IDX Broker may have used an older method of adding the dynamic wrapper tags to their theme that was dependant on our original plugin. This update prevents errors when those users disable our original plugin.

### 1.0.6 ###
* Added shortcode functionality. The plugin now adds an IDX button to the Visual editor which allows you to add shortcodes for the various page links and widgets IDX Broker provides.

### 1.0.5 ###
* Cleaned up naming convention inconsistencies.

### 1.0.4 ###
* Additional CSS clean up; specific to certain installations/WP versions.

### 1.0.3 ###
* Cleaned up various CSS issues and removed excess button options from spec.

## Upgrade Notice ##

### 1.3.0 ###
Version 1.2.2 and higher drop support for PHP 5.2 as it is deprecated and no longer receives security updates. Before updating, please contact your host to upgrade to the latest stable version of PHP (we recommend a minimum of 5.5 for security reasons): http://php.net/supported-versions.php
See this article for more information: http://support.idxbroker.com/customer/en/portal/articles/1917460-wordpress-plugin
