<?php

/*
 * Plugin Name: Html5 Audio Player
 * Plugin URI:  https://bplugins.com/products/html5-audio-player/
 * Description: You can easily integrate html5 audio player in your WordPress website using this plugin.
 * Version: 2.5.1
 * Author: bPlugins
 * Author URI: http://bPlugins.com
 * License: GPLv3
 * Text Domain: h5ap
 */
if ( function_exists( 'h5ap_fs' ) ) {
    h5ap_fs()->set_basename( false, __FILE__ );
} else {
    /*Some Set-up*/
    define( 'H5AP_PRO_PLUGIN_DIR', plugin_dir_url( __FILE__ ) );
    define( 'H5AP_PRO_FILE_BASENAME', plugin_basename( __FILE__ ) );
    define( 'H5AP_PRO_DIR_BASENAME', plugin_basename( __DIR__ ) );
    define('H5AP_PRO_VERSION', isset($_SERVER['HTTP_HOST']) && $_SERVER['HTTP_HOST'] === 'dev.local' ? time() : '2.5.1');
    defined( 'H5AP_PRO_PATH' ) or define( 'H5AP_PRO_PATH', plugin_dir_path( __FILE__ ) );
    if ( file_exists( dirname( __FILE__ ) . '/vendor/autoload.php' ) ) {
        require_once dirname( __FILE__ ) . '/vendor/autoload.php';
    }
    if ( file_exists( dirname( __FILE__ ) . '/inc/functions.php' ) ) {
        require_once dirname( __FILE__ ) . '/inc/functions.php';
    }
    // DO NOT REMOVE THIS IF, IT IS ESSENTIAL FOR THE `function_exists` CALL ABOVE TO PROPERLY WORK.
    if ( !function_exists( 'h5ap_fs' ) ) {
        if ( !function_exists( 'h5ap_fs' ) ) {
            // Create a helper function for easy SDK access.
            function h5ap_fs() {
                global $h5ap_fs;
                if ( !isset( $h5ap_fs ) ) {
                    // Include Freemius SDK.
                    $h5ap_fs = fs_dynamic_init( array(
                        'id'              => '14260',
                        'slug'            => 'html5-audio-player',
                        'premium_slug'    => 'html5-audio-player-pro',
                        'type'            => 'plugin',
                        'public_key'      => 'pk_ea4da01be073820a5edf59346b675',
                        'is_premium'      => false,
                        'premium_suffix'  => 'Pro',
                        'has_addons'      => false,
                        'has_paid_plans'  => true,
                        'has_affiliation' => 'selected',
                        'menu'            => array(
                            'slug'        => 'html5-audio-player',
                            'support'     => false,
                            'contact'     => false,
                            'affiliation' => false,
                        ),
                        'is_live'         => true,
                    ) );
                }
                return $h5ap_fs;
            }

            // Init Freemius.
            h5ap_fs();
            // Signal that SDK was initiated.
            do_action( 'h5ap_fs_loaded' );
        }
    }
    if ( !class_exists( 'CSF' ) ) {
        require_once 'admin/codestar-framework/codestar-framework.php';
    }
    if ( class_exists( 'H5APPlayer\\Init' ) ) {
        H5APPlayer\Init::register_services();
    }
    add_action( 'plugins_loaded', function () {
        require_once 'shortcode/player.php';
        require_once 'inc/admin.php';
        require_once 'tinymce/ewic-tinymce.php';
        require_once __DIR__ . '/blocks.php';
        require_once __DIR__ . '/blocks/init.php';
        if ( file_exists( __DIR__ . '/audio-player-block-pro/plugin.php' ) ) {
            require_once __DIR__ . '/audio-player-block-pro/plugin.php';
        }
        if ( h5ap_fs()->can_use_premium_code() ) {
            if ( file_exists( __DIR__ . '/inc/Widget/widget.php' ) ) {
                require_once __DIR__ . '/inc/Widget/widget.php';
            }
            if ( file_exists( __DIR__ . '/inc/Widget/SearchForm.php' ) ) {
                require_once __DIR__ . '/inc/Widget/SearchForm.php';
            }
        }
        add_filter( 'template_include', 'h5ap_search_template' );
        function h5ap_search_template(  $template  ) {
            if ( !isset( $_GET['bps'] ) ) {
                return $template;
            }
            return dirname( __FILE__ ) . '/inc/Template/search.php';
        }

        /*UPDATE: there was a missing ";" after $template*/
    } );
}
// add_action('wp_footer', function () {
// 	require ABSPATH . 'wp-admin/includes/plugin-install.php';
// 	echo 'loading...';
// 	$plugin_information  = plugins_api('plugin_information', array('slug' => 'horizontal-slider-with-scroll'));
// 	unset($plugin_information->sections);
// 	// echo wp_json_encode($hot_tags);
// 	echo '<pre>';
// 	print_r($plugin_information);
// 	echo '</pre>';
// });
