<?php
/**
 * Contains the Courier_Trendyol_Express class.
 * 
 * @package Hezarfen\ManualShipmentTracking
 */

namespace Hezarfen\ManualShipmentTracking;

defined( 'ABSPATH' ) || exit;

/**
 * Courier_Trendyol_Express class.
 */
class Courier_Trendyol_Express extends Courier_Company {
	/**
	 * ID.
	 * 
	 * @var string
	 */
	public static $id = 'trendyol-express';

	/**
	 * Filename of the logo.
	 * 
	 * @var string
	 */
	public static $logo = 'trendyol-express-logo.png';

	/**
	 * Returns the title.
	 * 
	 * @param int|string $order_id Order ID.
	 * 
	 * @return string
	 */
	public static function get_title( $order_id = '' ) {
		return __( 'Trendyol Express', 'hezarfen-for-woocommerce' );
	}

	/**
	 * Creates tracking URL.
	 * 
	 * @param string $tracking_number Tracking number.
	 * 
	 * @return string
	 */
	public static function create_tracking_url( $tracking_number ) {
		if ( ! $tracking_number ) {
			return '';
		}

		return 'https://kargotakip.trendyol.com/?orderNumber=' . $tracking_number;
	}
}
