<?php

namespace HashElements\Modules\PersonalInformation\Widgets;

// Elementor Classes
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
use HashElements\Group_Control_Header;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class PersonalInformation extends Widget_Base {

    /** Widget Name */
    public function get_name() {
        return 'he-personal-information';
    }

    /** Widget Title */
    public function get_title() {
        return esc_html__('Personal Information', 'hash-elements');
    }

    /** Icon */
    public function get_icon() {
        return 'he-personal-information he-news-modules';
    }

    /** Category */
    public function get_categories() {
        return ['he-magazine-elements'];
    }

    /** Controls */
    protected function register_controls() {


        $this->start_controls_section(
            'header', [
                'label' => esc_html__('Title', 'hash-elements'),
            ]
        );

        $this->add_group_control(
            Group_Control_Header::get_type(), [
                'name' => 'header',
                'label' => esc_html__('Header', 'hash-elements'),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_section', [
                'label' => esc_html__('Content', 'hash-elements'),
            ]
        );

        $this->add_control(
            'name', [
                'label' => esc_html__('Name', 'hash-elements'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('John Doe', 'hash-elements'),
                'label_block' => true
            ]
        );

        $this->add_control(
            'image', [
                'label' => esc_html__('Choose Image', 'hash-elements'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'short_intro', [
                'label' => esc_html__('Short Intro', 'hash-elements'),
                'type' => Controls_Manager::TEXTAREA,
                'rows' => 5,
                'default' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.'
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'additional Settings', [
                'label' => esc_html__('Additional Settings', 'hash-elements'),
            ]
        );

        $this->add_control(
            'content_alignment', [
                'label' => esc_html__('Content Alignment', 'hash-elements'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'left' => esc_html__('Left', 'hash-elements'),
                    'center' => esc_html__('Center', 'hash-elements'),
                    'right' => esc_html__('Right', 'hash-elements'),
                ],
                'default' => 'center',
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(), [
                'name' => 'thumbnail',
                'exclude' => ['custom'],
                'include' => [],
                'default' => 'full',
            ]
        );

        $this->add_control(
            'image_dimension', [
                'label' => esc_html__('Image Dimension (px)', 'hash-elements'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 50,
                        'max' => 300,
                        'step' => 1
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 150,
                ],
                'selectors' => [
                    '{{WRAPPER}} .he-personal-information .he-pi-image img' => 'height: {{SIZE}}{{UNIT}};width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'header_title_style', [
                'label' => esc_html__('Header Title', 'hash-elements'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'header_color', [
                'label' => esc_html__('Color', 'hash-elements'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .he-block-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'header_short_border_color', [
                'label' => esc_html__('Short Border Color', 'hash-elements'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .he-title-style3.he-block-title' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .he-title-style2.he-block-title span:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'header_long_border_color', [
                'label' => esc_html__('Long Border Color', 'hash-elements'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .he-title-style3.he-block-title:after, {{WRAPPER}} .he-title-style4.he-block-title:after' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .he-title-style2.he-block-title' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'header_typography',
                'label' => esc_html__('Typography', 'hash-elements'),
                'selector' => '{{WRAPPER}} .he-block-title'
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'name_style', [
                'label' => esc_html__('Name', 'hash-elements'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'name_color', [
                'label' => esc_html__('Color', 'hash-elements'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .he-personal-information .he-pi-name' => 'color: {{VALUE}}'
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'name_typography',
                'label' => esc_html__('Typography', 'hash-elements'),
                'selector' => '{{WRAPPER}} .he-personal-information .he-pi-name'
            ]
        );

        $this->add_control(
            'name_margin', [
                'label' => esc_html__('Margin', 'hash-elements'),
                'type' => Controls_Manager::DIMENSIONS,
                'allowed_dimensions' => 'vertical',
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .he-personal-information .he-pi-name' => 'margin: {{TOP}}{{UNIT}} 0 {{BOTTOM}}{{UNIT}} 0;',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'intro_style', [
                'label' => esc_html__('Intro', 'hash-elements'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'intro_color', [
                'label' => esc_html__('Color', 'hash-elements'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .he-personal-information .he-pi-intro' => 'color: {{VALUE}}'
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'intro_typography',
                'label' => esc_html__('Typography', 'hash-elements'),
                'selector' => '{{WRAPPER}} .he-personal-information .he-pi-intro'
            ]
        );

        $this->end_controls_section();
    }

    /** Render Layout */
    protected function render() {
        $settings = $this->get_settings_for_display();

        $this->render_header();
        ?>
        <div class="he-personal-information he-align-<?php echo esc_attr($settings['content_alignment']); ?>">
            <div class="he-pi-image">
                <?php
                echo Group_Control_Image_Size::get_attachment_image_html($settings, 'thumbnail', 'image');
                ?>
            </div>

            <?php
            if (!empty($settings['name'])):
                echo '<div class="he-pi-name"><span>' . esc_html($settings['name']) . '</span></div>';
            endif;

            if (!empty($settings['short_intro'])):
                echo '<div class="he-pi-intro">' . esc_html($settings['short_intro']) . '</div>';
            endif;
            ?>
        </div>
        <?php
    }

    /** Render Header */
    protected function render_header
    (
    ) {
        $settings = $this->get_settings();

        $this->add_render_attribute(
            'header_attr', 'class', [
                'he-block-title',
                $settings['header_style']
            ]
        );

        $link_open = $link_close = "";
        $target = $settings['header_link']['is_external'] ? ' target="_blank"' : '';
        $nofollow = $settings['header_link']['nofollow'] ? ' rel="nofollow"' : '';

        if ($settings['header_link']['url']) {
            $link_open = '<a href="' . esc_url($settings['header_link']['url']) . '"' . $target . $nofollow . '>';
            $link_close = '</a>';
        }

        if ($settings['header_title']) {
            ?>
            <h2 <?php echo $this->get_render_attribute_string('header_attr'); ?>>
                <?php
                echo $link_open;
                echo '<span>';
                echo wp_kses_post($settings['header_title']);
                echo '</span>';
                echo $link_close;
                ?>
            </h2>
            <?php
        }
    }

}
