import { registerBlockType } from '@wordpress/blocks';
import './style.scss';

/**
 * Internal dependencies
 */
import Edit from './edit';
import save from './save';
import metadata from './block.json';

registerBlockType( metadata.name, {
	/**
	 * @see ./edit.js
	 */
	edit: Edit,

	/**
	 * Block icon
	 */
	icon: {
		src: (
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 42.665 44.55">
				<g transform="translate(-364.283 -1125.403)">
					<path
						d="M397.6,1149.716"
						transform="translate(2.46 1.79)"
						fill="#3e77fc"
						stroke="#3e77fc"
						strokeWidth="0.5"
					></path>
					<path
						d="M397.6,1142.5"
						transform="translate(2.46 1.254)"
						fill="#3e77fc"
						stroke="#3e77fc"
						strokeWidth="0.5"
					></path>
					<path
						d="M400.625,1165.108h-2.984a.537.537,0,0,1,0-1.074h2.984a2.578,2.578,0,0,0,2.575-2.575V1133.3a2.578,2.578,0,0,0-2.575-2.574.537.537,0,0,1,0-1.074,3.653,3.653,0,0,1,3.65,3.649v28.157A3.654,3.654,0,0,1,400.625,1165.108Z"
						transform="translate(2.423 0.298)"
						fill="#3e77fc"
						stroke="#3e77fc"
						strokeWidth="0.5"
					></path>
					<path
						d="M376.217,1135.622"
						transform="translate(0.869 0.742)"
						fill="#3e77fc"
						stroke="#3e77fc"
						strokeWidth="0.5"
					></path>
					<path
						d="M395.613,1169.7H369.52a4.993,4.993,0,0,1-4.987-4.988v-34.074a4.993,4.993,0,0,1,4.987-4.988h26.093a4.994,4.994,0,0,1,4.988,4.988v13.116a.537.537,0,0,1-1.074,0v-13.116a3.918,3.918,0,0,0-3.914-3.913H369.52a3.917,3.917,0,0,0-3.913,3.913v34.074a3.918,3.918,0,0,0,3.913,3.914h26.093a3.919,3.919,0,0,0,3.914-3.914v-13.209a.537.537,0,1,1,1.074,0v13.209A4.994,4.994,0,0,1,395.613,1169.7Z"
						fill="#3e77fc"
						stroke="#3e77fc"
						strokeWidth="0.5"
					></path>
					<rect
						width="2.301"
						height="0.929"
						transform="translate(371.727 1146.793)"
						fill="#3e77fc"
						stroke="#3e77fc"
						strokeWidth="0.5"
					></rect>
					<path
						d="M374.528,1138.575l-.664.664,1.615,1.549.664-.664Z"
						transform="translate(0.694 0.961)"
						fill="#3e77fc"
						stroke="#3e77fc"
						strokeWidth="0.5"
					></path>
					<rect
						width="0.929"
						height="2.212"
						transform="translate(382.102 1136.837)"
						fill="#3e77fc"
						stroke="#3e77fc"
						strokeWidth="0.5"
					></rect>
					<path
						d="M386.631,1140.146l.664.641,1.615-1.549-.664-.664Z"
						transform="translate(1.644 0.961)"
						fill="#3e77fc"
						stroke="#3e77fc"
						strokeWidth="0.5"
					></path>
					<rect
						width="2.301"
						height="0.929"
						transform="translate(391.107 1146.793)"
						fill="#3e77fc"
						stroke="#3e77fc"
						strokeWidth="0.5"
					></rect>
					<path
						d="M387.382,1143a5.882,5.882,0,0,0-1.327-1.88,6.4,6.4,0,0,0-1.947-1.261,6.059,6.059,0,0,0-2.368-.464,5.77,5.77,0,0,0-2.279.442,6.283,6.283,0,0,0-1.825,1.117,6.043,6.043,0,0,0-1.294,1.627,5.921,5.921,0,0,0-.641,1.9,5.6,5.6,0,0,0,.232,2.544,6.109,6.109,0,0,0,1.295,2.212,5.66,5.66,0,0,1,1.183,1.891,6.13,6.13,0,0,1,.409,2.2v2.412a1.679,1.679,0,0,0,.52,1.228,1.73,1.73,0,0,0,1.272.519h2.3a1.734,1.734,0,0,0,1.272-.519,1.683,1.683,0,0,0,.52-1.228v-2.412a6.294,6.294,0,0,1,.387-2.212,4.944,4.944,0,0,1,1.139-1.792,5.991,5.991,0,0,0,1.217-1.869,5.642,5.642,0,0,0,.42-2.157A5.552,5.552,0,0,0,387.382,1143Zm-3.816,13.318a.851.851,0,0,1-.608.244h-2.3a.851.851,0,0,1-.608-.244.769.769,0,0,1-.255-.575v-1.063h4v1.063h.023A.769.769,0,0,1,383.565,1156.323Zm3.02-9.2a5.156,5.156,0,0,1-1.017,1.571,5.8,5.8,0,0,0-1.339,2.091,7.182,7.182,0,0,0-.453,2.555v.42h-4v-.42a6.5,6.5,0,0,0-.509-2.511,7.458,7.458,0,0,0-1.372-2.179,4.638,4.638,0,0,1-1.106-1.88,5.245,5.245,0,0,1-.177-2.147,4.98,4.98,0,0,1,.553-1.592,5.376,5.376,0,0,1,1.117-1.372,5.658,5.658,0,0,1,1.559-.974,5.074,5.074,0,0,1,1.9-.354,5.222,5.222,0,0,1,2.036.4,5.467,5.467,0,0,1,1.636,1.073,4.852,4.852,0,0,1,1.107,1.581,4.52,4.52,0,0,1,.42,1.924A4.744,4.744,0,0,1,386.585,1147.12Z"
						transform="translate(0.827 1.023)"
						fill="#3e77fc"
						stroke="#3e77fc"
						strokeWidth="0.5"
					></path>
				</g>
			</svg>
		),
	},

	/**
	 * @see ./save.js
	 */
	save,
} );
