<?php
/**
 * Script registration - Auto-generated by build process.
 * Do not edit this file manually.
 *
 * @package gutenberg
 */

if ( ! function_exists( 'gutenberg_override_script' ) ) {
	/**
	 * Registers a script according to `wp_register_script`. Honors this request by
	 * reassigning internal dependency properties of any script handle already
	 * registered by that name. It does not deregister the original script, to
	 * avoid losing inline scripts which may have been attached.
	 *
	 * @param WP_Scripts       $scripts   WP_Scripts instance.
	 * @param string           $handle    Name of the script. Should be unique.
	 * @param string           $src       Full URL of the script, or path of the script relative to the WordPress root directory.
	 * @param array            $deps      Optional. An array of registered script handles this script depends on. Default empty array.
	 * @param string|bool|null $ver       Optional. String specifying script version number, if it has one, which is added to the URL
	 *                                    as a query string for cache busting purposes. If version is set to false, a version
	 *                                    number is automatically added equal to current installed WordPress version.
	 *                                    If set to null, no version is added.
	 * @param bool             $in_footer Optional. Whether to enqueue the script before </body> instead of in the <head>.
	 *                                    Default 'false'.
	 */
	function gutenberg_override_script( $scripts, $handle, $src, $deps = array(), $ver = false, $in_footer = false ) {
		$script = $scripts->query( $handle, 'registered' );
		if ( $script ) {
			/*
			 * In many ways, this is a reimplementation of `wp_register_script` but
			 * bypassing consideration of whether a script by the given handle had
			 * already been registered.
			 */

			// See: `_WP_Dependency::__construct` .
			$script->src  = $src;
			$script->deps = $deps;
			$script->ver  = $ver;
			$script->args = $in_footer ? 1 : null;
		} else {
			$scripts->add( $handle, $src, $deps, $ver, ( $in_footer ? 1 : null ) );
		}

		if ( in_array( 'wp-i18n', $deps, true ) ) {
			$scripts->set_translations( $handle );
		}
	}
}

if ( ! function_exists( 'gutenberg_register_package_scripts' ) ) {
	/**
	 * Register all package scripts.
	 */
	function gutenberg_register_package_scripts( $scripts ) {
		$default_version = defined( 'GUTENBERG_VERSION' ) && ! SCRIPT_DEBUG ? GUTENBERG_VERSION : time();
		$extension       = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '.js' : '.min.js';

		$scripts_dir  = __DIR__ . '/scripts';
		$scripts_file = $scripts_dir . '/index.php';

		if ( ! file_exists( $scripts_file ) ) {
			return;
		}

		$scripts_data = require $scripts_file;
		$plugin_dir   = dirname( __FILE__ );

		foreach ( $scripts_data as $script_data ) {
			$asset_file   = $scripts_dir . '/' . $script_data['asset'];
			$asset        = file_exists( $asset_file ) ? require $asset_file : array();
			$dependencies = $asset['dependencies'] ?? array();
			$version      = $asset['version'] ?? $default_version;

			gutenberg_override_script(
				$scripts,
				$script_data['handle'],
				plugins_url( 'build/scripts/' . $script_data['path'] . $extension, $plugin_dir ),
				$dependencies,
				$version,
				true
			);
		}
	}

	add_action( 'wp_default_scripts', 'gutenberg_register_package_scripts' );
}
