<?php
/**
 * Page: gutenberg-boot (wp-admin integrated)
 * Auto-generated by build process.
 * Do not edit this file manually.
 *
 * This version integrates with the standard WordPress admin interface,
 * keeping the wp-admin sidebar and scripts/styles intact.
 *
 * @package gutenberg
 */

// Global storage for gutenberg-boot routes and menu items
global $gutenberg_gutenberg_boot_wp_admin_routes, $gutenberg_gutenberg_boot_wp_admin_menu_items;
$gutenberg_gutenberg_boot_wp_admin_routes = array();
$gutenberg_gutenberg_boot_wp_admin_menu_items = array();

if ( ! function_exists( 'register_gutenberg_boot_wp_admin_route' ) ) {
	/**
	 * Register a route for the gutenberg-boot-wp-admin page.
	 *
	 * @param string      $path           Route path (e.g., '/types/$type/edit/$id').
	 * @param string|null $content_module Script module ID for content (stage/inspector).
	 * @param string|null $route_module   Script module ID for route lifecycle hooks.
	 */
	function register_gutenberg_boot_wp_admin_route( $path, $content_module = null, $route_module = null ) {
		global $gutenberg_gutenberg_boot_wp_admin_routes;

		$route = array( 'path' => $path );
		if ( ! empty( $content_module ) ) {
			$route['content_module'] = $content_module;
		}
		if ( ! empty( $route_module ) ) {
			$route['route_module'] = $route_module;
		}

		$gutenberg_gutenberg_boot_wp_admin_routes[] = $route;
	}
}

if ( ! function_exists( 'register_gutenberg_boot_wp_admin_menu_item' ) ) {
	/**
	 * Register a menu item for the gutenberg-boot-wp-admin page.
	 * Note: Menu items are registered but not displayed in single-page mode.
	 *
	 * @param string $id        Menu item ID.
	 * @param string $label     Display label.
	 * @param string $to        Route path to navigate to.
	 * @param string $parent_id Optional. Parent menu item ID.
	 */
	function register_gutenberg_boot_wp_admin_menu_item( $id, $label, $to, $parent_id = '' ) {
		global $gutenberg_gutenberg_boot_wp_admin_menu_items;

		$menu_item = array(
			'id'    => $id,
			'label' => $label,
			'to'    => $to,
		);

		if ( ! empty( $parent_id ) ) {
			$menu_item['parent'] = $parent_id;
		}

		$gutenberg_gutenberg_boot_wp_admin_menu_items[] = $menu_item;
	}
}

if ( ! function_exists( 'get_gutenberg_boot_wp_admin_routes' ) ) {
	/**
	 * Get all registered routes for the gutenberg-boot-wp-admin page.
	 *
	 * @return array Array of route objects.
	 */
	function get_gutenberg_boot_wp_admin_routes() {
		global $gutenberg_gutenberg_boot_wp_admin_routes;
		return $gutenberg_gutenberg_boot_wp_admin_routes ?? array();
	}
}

if ( ! function_exists( 'get_gutenberg_boot_wp_admin_menu_items' ) ) {
	/**
	 * Get all registered menu items for the gutenberg-boot-wp-admin page.
	 *
	 * @return array Array of menu item objects.
	 */
	function get_gutenberg_boot_wp_admin_menu_items() {
		global $gutenberg_gutenberg_boot_wp_admin_menu_items;
		return $gutenberg_gutenberg_boot_wp_admin_menu_items ?? array();
	}
}

if ( ! function_exists( 'gutenberg_boot_wp_admin_preload_data' ) ) {
	/**
	 * Preload REST API data for the gutenberg-boot-wp-admin page.
	 * Automatically called during page rendering.
	 */
	function gutenberg_boot_wp_admin_preload_data() {
		// Define paths to preload - same for all pages
		$preload_paths = array(
			'/?_fields=description,gmt_offset,home,name,site_icon,site_icon_url,site_logo,timezone_string,url,page_for_posts,page_on_front,show_on_front',
			array( '/wp/v2/settings', 'OPTIONS' ),
		);

		// Use rest_preload_api_request to gather the preloaded data
		$preload_data = array_reduce(
			$preload_paths,
			'rest_preload_api_request',
			array()
		);

		// Register the preloading middleware with wp-api-fetch
		wp_add_inline_script(
			'wp-api-fetch',
			sprintf(
				'wp.apiFetch.use( wp.apiFetch.createPreloadingMiddleware( %s ) );',
				wp_json_encode( $preload_data )
			),
			'after'
		);
	}
}

if ( ! function_exists( 'gutenberg_boot_wp_admin_enqueue_scripts' ) ) {
	/**
	 * Enqueue scripts and styles for the gutenberg-boot-wp-admin page.
	 * Hooked to admin_enqueue_scripts.
	 *
	 * @param string $hook_suffix The current admin page.
	 */
	function gutenberg_boot_wp_admin_enqueue_scripts( $hook_suffix ) {
		// Only enqueue on our page
		if ( ! isset( $_GET['page'] ) || 'gutenberg-boot-wp-admin' !== $_GET['page'] ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
			return;
		}

		// Fire init action for extensions to register routes and menu items
		do_action( 'gutenberg-boot-wp-admin_init' );

		// Preload REST API data
		gutenberg_boot_wp_admin_preload_data();

		// Get all registered routes
		$routes = get_gutenberg_boot_wp_admin_routes();

		// Get boot module asset file for dependencies
		$asset_file = plugin_dir_path( __FILE__ ) . '../../modules/boot/index.min.asset.php';
		if ( file_exists( $asset_file ) ) {
			$asset = require $asset_file;

			// This script serves two purposes:
			// 1. It ensures all the globals that are made available to the modules are loaded.
			// 2. It initializes the boot module as an inline script.
			wp_register_script( 'gutenberg-boot-wp-admin-prerequisites', '', $asset['dependencies'], $asset['version'], true );

			// Add inline script to initialize the app using initSinglePage (no menuItems)
			wp_add_inline_script(
				'gutenberg-boot-wp-admin-prerequisites',
				sprintf(
					'import("@wordpress/boot").then(mod => mod.initSinglePage({mountId: "%s", routes: %s}));',
					'gutenberg-boot-wp-admin-app',
					wp_json_encode( $routes, JSON_HEX_TAG | JSON_UNESCAPED_SLASHES )
				)
			);

			// Register prerequisites style by filtering script dependencies to find registered styles
			$style_dependencies = array_filter(
				$asset['dependencies'],
				function ( $handle ) {
					return wp_style_is( $handle, 'registered' );
				}
			);
			wp_register_style( 'gutenberg-boot-wp-admin-prerequisites', false, $style_dependencies, $asset['version'] );

			// Build dependencies for gutenberg-boot-wp-admin module
			$boot_dependencies = array(
				array(
					'import' => 'static',
					'id'     => '@wordpress/boot',
				),
			);

			// Add all registered routes as dependencies
			foreach ( $routes as $route ) {
				if ( isset( $route['route_module'] ) ) {
					$boot_dependencies[] = array(
						'import' => 'static',
						'id'     => $route['route_module'],
					);
				}
				if ( isset( $route['content_module'] ) ) {
					$boot_dependencies[] = array(
						'import' => 'dynamic',
						'id'     => $route['content_module'],
					);
				}
			}

			// Dummy script module to ensure dependencies are loaded
			wp_register_script_module(
				'gutenberg-boot-wp-admin',
				plugin_dir_url( __FILE__ ) . 'loader.js',
				$boot_dependencies
			);

			// Enqueue the boot scripts and styles
			wp_enqueue_script( 'gutenberg-boot-wp-admin-prerequisites' );
			wp_enqueue_script_module( 'gutenberg-boot-wp-admin' );
			wp_enqueue_style( 'gutenberg-boot-wp-admin-prerequisites' );
		}
	}
}

if ( ! function_exists( 'gutenberg_boot_wp_admin_render_page' ) ) {
	/**
	 * Render the gutenberg-boot-wp-admin page.
	 * Call this function from add_menu_page or add_submenu_page.
	 * This renders within the normal WordPress admin interface.
	 */
	function gutenberg_boot_wp_admin_render_page() {
		?>
		<div id="gutenberg-boot-wp-admin-app" class="boot-layout-container"></div>
		<?php
	}
}

// Hook the enqueue function to admin_enqueue_scripts
add_action( 'admin_enqueue_scripts', 'gutenberg_boot_wp_admin_enqueue_scripts' );

if ( ! function_exists( 'gutenberg_boot_wp_admin_register_page' ) ) {
	/**
	 * Register the gutenberg-boot-wp-admin base page handler.
	 * This is hidden from the menu but provides the page callback for URL routing.
	 * Visible menu items should use the full URL pattern with query parameters.
	 *
	 * Example:
	 * $url = admin_url( 'admin.php?page=gutenberg-boot-wp-admin&p=' . urlencode( '/your/route' ) );
	 * add_menu_page( 'Title', 'Menu', 'capability', $url, '', 'icon', 10 );
	 */
	function gutenberg_boot_wp_admin_register_page() {
		add_submenu_page(
			'nothing-gutenberg-boot',                        // Hidden page (no parent)
			__( 'gutenberg-boot (WP Admin)', 'gutenberg' ), // Page title
			__( 'gutenberg-boot (WP Admin)', 'gutenberg' ), // Menu title (not visible)
			'read',                                          // Minimum capability
			'gutenberg-boot-wp-admin',                       // Menu slug for URL routing
			'gutenberg_boot_wp_admin_render_page' // Callback function
		);
	}
}

// Hook the registration to admin_menu
add_action( 'admin_menu', 'gutenberg_boot_wp_admin_register_page' );
