const fs = require('fs');

fs.readdir('./src/blocks/icon/svg', (err, files) => {
  if (err) {
    console.error(err);
    return;
  }

  const icons = [];

  files.forEach(file => {
    icons.push(file.replace('.svg', ''));
  });

  const contents = `
    /** 
    * DO NOT EDIT THIS FILE DIRECTLY
    * RUN "yarn generate-icons" INSTEAD 
    * (see "scripts" in package.json) 
    **/
    const icons = ${JSON.stringify(icons)};
    export default icons;
  `;

  fs.writeFile('./src/blocks/icon/icons.js', contents, error => {
    if (error) {
      console.error(error);
      return;
    }

    console.log('Icons generated!');
  });
});
