(()=>{"use strict";const e=window.wp.element,t=window.wp.blocks,r=window.wp.components,o=JSON.parse('{"$schema":"https://schemas.wp.org/trunk/block.json","apiVersion":2,"name":"gutena/existing-forms","version":"1.0.0","title":"Existing Forms","category":"gutena","icon":"feedback","description":"Display a list of existing forms created with Gutena Forms.","keywords":["gutena","forms","existing","list"],"textdomain":"gutena-forms","editorScript":"file:./index.js","editorStyle":"file:./index.css","style":"file:./style-index.css","supports":{"html":false},"attributes":{"formId":{"type":"number","default":0}}}'),n=window.wp.blockEditor,a=window.wp.i18n,i=window.wp.data,s=new Map,l=new Map;(0,t.registerBlockType)(o,{icon:(0,e.createElement)(r.Icon,{icon:()=>(0,e.createElement)("svg",{width:"24",height:"24",viewBox:"0 0 24 24",fill:"none",xmlns:"http://www.w3.org/2000/svg"},(0,e.createElement)("path",{d:"M12 2L2 22h20L12 2Z",stroke:"black",strokeWidth:"2",strokeLinecap:"round",strokeLinejoin:"round"}))}),edit:({attributes:t,setAttributes:o,clientId:c})=>{const{formId:m}=t,[d,f]=(0,e.useState)({forms:[],formContent:null,loading:!0,isEditing:!1,error:null,saving:!1}),{replaceInnerBlocks:g}=(0,i.useDispatch)("core/block-editor"),{getBlocks:u}=(0,i.useSelect)(e=>e("core/block-editor")),p=(0,e.useMemo)(()=>[{label:(0,a.__)("Select a form","gutena-forms"),value:""},...d.forms.map(e=>({label:e.title,value:e.id}))],[d.forms]),E=(0,e.useCallback)(async()=>{if(s.has("forms"))f(e=>({...e,forms:s.get("forms"),loading:!1}));else try{const e=await fetch("/wp-json/gutena-forms/v1/forms",{headers:{"X-WP-Nonce":wpApiSettings.nonce}});if(!e.ok)throw new Error("Failed to fetch forms");{const t=await e.json();s.set("forms",t),f(e=>({...e,forms:t,loading:!1}))}}catch(e){console.error("Error fetching forms:",e),f(e=>({...e,loading:!1,error:(0,a.__)("Failed to load forms. Please try again.","gutena-forms")}))}},[]),h=(0,e.useCallback)(async e=>{if(l.has(e))f(t=>({...t,formContent:l.get(e)}));else try{const t=await fetch(`/wp-json/gutena-forms/v1/forms/${e}`,{headers:{"X-WP-Nonce":wpApiSettings.nonce}});if(!t.ok)throw new Error("Failed to fetch form content");{const r=await t.json();l.set(e,r),f(e=>({...e,formContent:r}))}}catch(e){console.error("Error fetching form content:",e),f(e=>({...e,error:(0,a.__)("Failed to load form content. Please try again.","gutena-forms")}))}},[]);(0,e.useEffect)(()=>{E()},[E]),(0,e.useEffect)(()=>{m?h(m):f(e=>({...e,formContent:null}))},[m,h]);const w=(0,e.useCallback)(()=>{const e=!d.isEditing;if(e&&d.formContent?.content)try{const e=wp.blocks.parse(d.formContent.content);let t=e.find(e=>"gutena/forms"===e.name);if(t?.innerBlocks&&t.innerBlocks.length>0){const e=t.innerBlocks.filter(e=>"gutena/existing-forms"!==e.name);g(c,e)}else if(e.find(e=>"gutena/existing-forms"===e.name))g(c,[]);else{const t=e.filter(e=>e.name&&"gutena/existing-forms"!==e.name&&"core/freeform"!==e.name&&("core/paragraph"!==e.name||"core/paragraph"===e.name&&e.attributes?.content));t.length>0?g(c,t):g(c,[])}}catch(e){return console.error("Error parsing form content:",e),void f(e=>({...e,error:(0,a.__)("Failed to load form for editing. Please try again.","gutena-forms")}))}f(t=>({...t,isEditing:e}))},[d.isEditing,d.formContent,c,g]),v=(0,e.useCallback)(async()=>{if(m&&!d.saving){f(e=>({...e,saving:!0,error:null}));try{const e=u(c).filter(e=>"gutena/existing-forms"!==e.name),t={name:"gutena/forms",attributes:d.formContent?.attributes||{},innerBlocks:e},r=wp.blocks.serialize([t]),o=await fetch(`/wp-json/gutena-forms/v1/forms/${m}/update`,{method:"POST",headers:{"Content-Type":"application/json","X-WP-Nonce":wpApiSettings.nonce},body:JSON.stringify({content:r})});if(!o.ok)throw new Error("Failed to update form");{const e=await o.json();l.set(m,e),f(t=>({...t,formContent:e,isEditing:!1,saving:!1})),wp.data.dispatch("core/notices").createNotice("success",(0,a.__)("Form updated successfully!","gutena-forms"),{isDismissible:!0})}}catch(e){console.error("Error saving form:",e),f(e=>({...e,saving:!1,error:(0,a.__)("Failed to update form. Please try again.","gutena-forms")}))}}},[m,d.saving,d.formContent,c,u]),_=(0,e.useMemo)(()=>{if(!d.formContent?.content)return(0,e.createElement)("div",{style:{padding:"20px",textAlign:"center",color:"#666"}},(0,e.createElement)("p",null,(0,a.__)("No form content available.","gutena-forms")));try{const t=wp.blocks.parse(d.formContent.content).find(e=>"gutena/forms"===e.name);if(t?.innerBlocks&&t.innerBlocks.length>0)return(0,e.createElement)("div",{style:{background:"white",padding:"16px",border:"1px solid #ddd",borderRadius:"4px",textAlign:"left"}},(0,e.createElement)("div",{style:{fontSize:"14px",color:"#666",marginBottom:"12px",fontWeight:"500"}},(0,a.__)("Form Preview:","gutena-forms")),(0,e.createElement)("div",{dangerouslySetInnerHTML:{__html:wp.blocks.serialize(t.innerBlocks)}}))}catch(e){console.error("Error parsing form content for preview:",e)}return(0,e.createElement)("div",{style:{background:"white",padding:"16px",border:"1px solid #ddd",borderRadius:"4px",textAlign:"left"}},(0,e.createElement)("div",{style:{fontSize:"14px",color:"#666",marginBottom:"12px",fontWeight:"500"}},(0,a.__)("Form Preview:","gutena-forms")),(0,e.createElement)("div",{style:{fontSize:"13px",color:"#888",lineHeight:"1.4"}},(0,a.__)('This form contains form fields and will be displayed on the frontend. Click "Edit Form" to modify the structure.',"gutena-forms")))},[d.formContent]),b=(0,n.useBlockProps)();return d.loading?(0,e.createElement)("div",b,(0,e.createElement)(r.Placeholder,null,(0,e.createElement)(r.Spinner,null),(0,e.createElement)("p",null,(0,a.__)("Loading forms...","gutena-forms")))):d.error?(0,e.createElement)("div",b,(0,e.createElement)(r.Notice,{status:"error",isDismissible:!1},d.error)):m?(0,e.createElement)("div",b,(0,e.createElement)(n.InspectorControls,null,(0,e.createElement)(r.PanelBody,{title:(0,a.__)("Form Settings","gutena-forms")},(0,e.createElement)(r.SelectControl,{label:(0,a.__)("Select Form","gutena-forms"),value:m,options:p,onChange:e=>o({formId:parseInt(e)})}),m&&(0,e.createElement)("div",{style:{marginTop:"16px"}},(0,e.createElement)(r.Button,{variant:d.isEditing?"primary":"secondary",onClick:w,disabled:d.saving},d.isEditing?(0,a.__)("Cancel Editing","gutena-forms"):(0,a.__)("Edit Form","gutena-forms")),d.isEditing&&(0,e.createElement)(r.Button,{variant:"primary",onClick:v,disabled:d.saving,style:{marginLeft:"8px"}},d.saving?(0,a.__)("Saving...","gutena-forms"):(0,a.__)("Save Changes","gutena-forms"))))),(0,e.createElement)("div",{className:"gutena-forms-existing-form"},m&&(0,e.createElement)("div",{style:{marginBottom:"16px",padding:"12px",background:"#f0f0f1",borderRadius:"4px"}},(0,e.createElement)("strong",null,(0,a.__)("Selected Form:","gutena-forms"))," ",d.formContent?.title||(0,a.__)("Loading...","gutena-forms"),d.isEditing&&(0,e.createElement)("p",{style:{margin:"8px 0 0 0",fontSize:"13px",color:"#666"}},(0,a.__)('You are now editing this form. Make your changes and click "Save Changes" to update the form.',"gutena-forms"))),d.isEditing?(0,e.createElement)(n.InnerBlocks,{allowedBlocks:["core/columns","core/group","core/image","core/paragraph","gutena/field-group","core/buttons","core/heading","core/spacer","core/separator","core/list","core/quote","core/table","core/code","core/preformatted","core/verse","core/pullquote","core/audio","core/video","core/file","core/gallery","core/embed","core/shortcode","core/html","gutena/form-field","gutena/form-error-msg","gutena/form-confirm-msg"],templateLock:!1}):(0,e.createElement)("div",{style:{padding:"20px",textAlign:"center",background:"#f9f9f9",border:"1px dashed #ccc",borderRadius:"4px"}},(0,e.createElement)("div",{style:{marginBottom:"16px"}},(0,e.createElement)("strong",null,(0,a.__)("Form Preview","gutena-forms"))),(0,e.createElement)("p",{style:{marginBottom:"16px"}},(0,a.__)('This form will be displayed on the frontend. Click "Edit Form" to modify the form structure.',"gutena-forms")),_))):(0,e.createElement)("div",b,(0,e.createElement)(n.InspectorControls,null,(0,e.createElement)(r.PanelBody,{title:(0,a.__)("Form Settings","gutena-forms")},(0,e.createElement)(r.SelectControl,{label:(0,a.__)("Select Form","gutena-forms"),value:m,options:p,onChange:e=>o({formId:parseInt(e)})}))),(0,e.createElement)(r.Placeholder,null,(0,e.createElement)("p",null,(0,a.__)("Please select a form from the sidebar.","gutena-forms"))))},save:({attributes:t})=>{const{formId:r}=t,o=n.useBlockProps.save();return r?(0,e.createElement)("div",o,(0,e.createElement)("div",{className:"gutena-forms-existing-form","data-form-id":r})):(0,e.createElement)("div",o)}})})();