(function($) {

window.gspeechDash = function(options) {

    var $this = this,
        thisPage = this;

    var wp_ajax_url = wpgsp_ajax_obj_1.ajax_url;
    var wp_ajax_nonce = wpgsp_ajax_obj_1.nonce;

    this.initVars = function() {

        console.clear();

        // get options
        this.options = options;
        this.is_touch_devise = 'ontouchstart' in window ? true : false;
        this.timeouts = {};
        this.options.root_request = false;
        this.preview_audios = {};
        this.options.tts_url = 'https://gspeech.io';
        this.options.token = '';
        this.options.messages_hide_delay = 2000;
        this.options.widget_id = $('#gsp_widget_id_val').html();
        this.options.shortcodes_loaded = $('#gsp_load_shortcode_widgets').html();
        this.options.sh_ = $('#gsp_sh_').html();

        var user_email_written = $("#gsp_useremail_written").html();
        this.options.user_email_written = user_email_written;

        this.options.gspeech_widget_id = "01aebff6acdd3f736ddf1cb93a0c0a66";
        this.texts_str = 'Playback Speed,Audio Language,Audio Voice,Plays,Audio plays count,Download audio,Downloaded,Open text,Open context player,Close context player,Loading,Play,Pause,Options,Select and listen,Close,Select any text and click on the icon to listen!';

        var svg_inner = 'role="img" xmlns="http://www.w3.org/2000/svg"';
        this.svgs = {
            'lang': '<svg class="ss_svg_globe" '+svg_inner+' viewBox="0 0 512 512"><path fill="currentColor" d="M504 256C504 118.815 392.705 8 256 8 119.371 8 8 118.74 8 256c0 136.938 111.041 248 248 248 136.886 0 248-110.987 248-248zm-41.625 64h-99.434c6.872-42.895 6.6-86.714.055-128h99.38c12.841 41.399 12.843 86.598-.001 128zM256.001 470.391c-30.732-27.728-54.128-69.513-67.459-118.391h134.917c-13.332 48.887-36.73 90.675-67.458 118.391zM181.442 320c-7.171-41.387-7.349-85.537.025-128h149.067c7.371 42.453 7.197 86.6.025 128H181.442zM256 41.617c33.557 30.295 55.554 74.948 67.418 118.383H188.582c11.922-43.649 33.98-88.195 67.418-118.383zM449.544 160h-93.009c-10.928-44.152-29.361-83.705-53.893-114.956C366.825 59.165 420.744 101.964 449.544 160zM209.357 45.044C184.826 76.293 166.393 115.847 155.464 160H62.456C91.25 101.975 145.162 59.169 209.357 45.044zM49.625 192h99.38c-6.544 41.28-6.818 85.1.055 128H49.625c-12.842-41.399-12.844-86.598 0-128zm12.831 160h93.122c11.002 44.176 29.481 83.824 53.833 114.968C144.875 452.786 91.108 409.738 62.456 352zm240.139 114.966c24.347-31.138 42.825-70.787 53.827-114.966h93.121c-28.695 57.827-82.504 100.802-146.948 114.966z"></path></svg>',
            'back': '<svg class="ss_svg_back" '+svg_inner+' viewBox="0 0 512 512"><path fill="currentColor" d="M11.5 280.6l192 160c20.6 17.2 52.5 2.8 52.5-24.6V96c0-27.4-31.9-41.8-52.5-24.6l-192 160c-15.3 12.8-15.3 36.4 0 49.2zm256 0l192 160c20.6 17.2 52.5 2.8 52.5-24.6V96c0-27.4-31.9-41.8-52.5-24.6l-192 160c-15.3 12.8-15.3 36.4 0 49.2z"></path></svg>',
            'forw': '<svg class="ss_svg_forw" '+svg_inner+' viewBox="0 0 512 512"><path fill="currentColor" d="M500.5 231.4l-192-160C287.9 54.3 256 68.6 256 96v320c0 27.4 31.9 41.8 52.5 24.6l192-160c15.3-12.8 15.3-36.4 0-49.2zm-256 0l-192-160C31.9 54.3 0 68.6 0 96v320c0 27.4 31.9 41.8 52.5 24.6l192-160c15.3-12.8 15.3-36.4 0-49.2z"></path></svg>',
            'loading': '<svg class="ss_svg_loading" '+svg_inner+' viewBox="0 0 512 512"><path fill="currentColor" d="M456.433 371.72l-27.79-16.045c-7.192-4.152-10.052-13.136-6.487-20.636 25.82-54.328 23.566-118.602-6.768-171.03-30.265-52.529-84.802-86.621-144.76-91.424C262.35 71.922 256 64.953 256 56.649V24.56c0-9.31 7.916-16.609 17.204-15.96 81.795 5.717 156.412 51.902 197.611 123.408 41.301 71.385 43.99 159.096 8.042 232.792-4.082 8.369-14.361 11.575-22.424 6.92z"></path></svg>',
            'users': '<svg class="ss_svg_users" '+svg_inner+' viewBox="0 0 640 512"><path fill="currentColor" d="M352 128c0 70.7-57.3 128-128 128s-128-57.3-128-128S153.3 0 224 0s128 57.3 128 128zM0 482.3C0 383.8 79.8 304 178.3 304h91.4C368.2 304 448 383.8 448 482.3c0 16.4-13.3 29.7-29.7 29.7H29.7C13.3 512 0 498.7 0 482.3zM609.3 512H471.4c5.4-9.4 8.6-20.3 8.6-32v-8c0-60.7-27.1-115.2-69.8-151.8c2.4-.1 4.7-.2 7.1-.2h61.4C567.8 320 640 392.2 640 481.3c0 17-13.8 30.7-30.7 30.7zM432 256c-31 0-59-12.6-79.3-32.9C372.4 196.5 384 163.6 384 128c0-26.8-6.6-52.1-18.3-74.3C384.3 40.1 407.2 32 432 32c61.9 0 112 50.1 112 112s-50.1 112-112 112z"></path></svg>',
            't': '<svg class="ss_svg_t" '+svg_inner+' viewBox="0 0 384 512"><path fill="currentColor" d="M32 32C14.3 32 0 46.3 0 64S14.3 96 32 96H160V448c0 17.7 14.3 32 32 32s32-14.3 32-32V96H352c17.7 0 32-14.3 32-32s-14.3-32-32-32H192 32z"></path></svg>',
            'download': '<svg class="ss_svg_download" '+svg_inner+' viewBox="0 0 512 512"><path fill="currentColor" d="M216 0h80c13.3 0 24 10.7 24 24v168h87.7c17.8 0 26.7 21.5 14.1 34.1L269.7 378.3c-7.5 7.5-19.8 7.5-27.3 0L90.1 226.1c-12.6-12.6-3.7-34.1 14.1-34.1H192V24c0-13.3 10.7-24 24-24zm296 376v112c0 13.3-10.7 24-24 24H24c-13.3 0-24-10.7-24-24V376c0-13.3 10.7-24 24-24h146.7l49 49c20.1 20.1 52.5 20.1 72.6 0l49-49H488c13.3 0 24 10.7 24 24zm-124 88c0-11-9-20-20-20s-20 9-20 20 9 20 20 20 20-9 20-20zm64 0c0-11-9-20-20-20s-20 9-20 20 9 20 20 20 20-9 20-20z"></path></svg>',
            'group': '<svg class="ss_svg_group" '+svg_inner+' viewBox="0 0 576 512"><path fill="currentColor" d="M32 119.4C12.9 108.4 0 87.7 0 64C0 28.7 28.7 0 64 0c23.7 0 44.4 12.9 55.4 32H456.6C467.6 12.9 488.3 0 512 0c35.3 0 64 28.7 64 64c0 23.7-12.9 44.4-32 55.4V392.6c19.1 11.1 32 31.7 32 55.4c0 35.3-28.7 64-64 64c-23.7 0-44.4-12.9-55.4-32H119.4c-11.1 19.1-31.7 32-55.4 32c-35.3 0-64-28.7-64-64c0-23.7 12.9-44.4 32-55.4V119.4zM456.6 96H119.4c-5.6 9.7-13.7 17.8-23.4 23.4V392.6c9.7 5.6 17.8 13.7 23.4 23.4H456.6c5.6-9.7 13.7-17.8 23.4-23.4V119.4c-9.7-5.6-17.8-13.7-23.4-23.4zM128 160c0-17.7 14.3-32 32-32H288c17.7 0 32 14.3 32 32v96c0 17.7-14.3 32-32 32H160c-17.7 0-32-14.3-32-32V160zM256 320h32c35.3 0 64-28.7 64-64V224h64c17.7 0 32 14.3 32 32v96c0 17.7-14.3 32-32 32H288c-17.7 0-32-14.3-32-32V320z"></path></svg>',
            'ungroup': '<svg class="ss_svg_ungroup" '+svg_inner+' viewBox="0 0 640 512"><path fill="currentColor" d="M32 119.4C12.9 108.4 0 87.7 0 64C0 28.7 28.7 0 64 0c23.7 0 44.4 12.9 55.4 32H328.6C339.6 12.9 360.3 0 384 0c35.3 0 64 28.7 64 64c0 23.7-12.9 44.4-32 55.4V232.6c19.1 11.1 32 31.7 32 55.4c0 35.3-28.7 64-64 64c-23.7 0-44.4-12.9-55.4-32H119.4c-11.1 19.1-31.7 32-55.4 32c-35.3 0-64-28.7-64-64c0-23.7 12.9-44.4 32-55.4V119.4zM119.4 96c-5.6 9.7-13.7 17.8-23.4 23.4V232.6c9.7 5.6 17.8 13.7 23.4 23.4H328.6c5.6-9.7 13.7-17.8 23.4-23.4V119.4c-9.7-5.6-17.8-13.7-23.4-23.4H119.4zm192 384c-11.1 19.1-31.7 32-55.4 32c-35.3 0-64-28.7-64-64c0-23.7 12.9-44.4 32-55.4V352h64v40.6c9.7 5.6 17.8 13.7 23.4 23.4H520.6c5.6-9.7 13.7-17.8 23.4-23.4V279.4c-9.7-5.6-17.8-13.7-23.4-23.4h-46c-5.4-15.4-14.6-28.9-26.5-39.6V192h72.6c11.1-19.1 31.7-32 55.4-32c35.3 0 64 28.7 64 64c0 23.7-12.9 44.4-32 55.4V392.6c19.1 11.1 32 31.7 32 55.4c0 35.3-28.7 64-64 64c-23.7 0-44.4-12.9-55.4-32H311.4z"></path></svg>',
            'speaker': '<svg class="ss_svg_speaker" '+svg_inner+' viewBox="0 0 576 512"><path fill="currentColor" d="M256 88.017v335.964c0 21.438-25.943 31.998-40.971 16.971L126.059 352H24c-13.255 0-24-10.745-24-24V184c0-13.255 10.745-24 24-24h102.059l88.971-88.954c15.01-15.01 40.97-4.49 40.97 16.971zm182.056-77.876C422.982.92 403.283 5.668 394.061 20.745c-9.221 15.077-4.473 34.774 10.604 43.995C468.967 104.063 512 174.983 512 256c0 73.431-36.077 142.292-96.507 184.206-14.522 10.072-18.129 30.01-8.057 44.532 10.076 14.528 30.016 18.126 44.531 8.057C529.633 438.927 576 350.406 576 256c0-103.244-54.579-194.877-137.944-245.859zM480 256c0-68.547-36.15-129.777-91.957-163.901-15.076-9.22-34.774-4.471-43.994 10.607-9.22 15.078-4.471 34.774 10.607 43.994C393.067 170.188 416 211.048 416 256c0 41.964-20.62 81.319-55.158 105.276-14.521 10.073-18.128 30.01-8.056 44.532 6.216 8.96 16.185 13.765 26.322 13.765a31.862 31.862 0 0 0 18.21-5.709C449.091 377.953 480 318.938 480 256zm-96 0c0-33.717-17.186-64.35-45.972-81.944-15.079-9.214-34.775-4.463-43.992 10.616s-4.464 34.775 10.615 43.992C314.263 234.538 320 244.757 320 256a32.056 32.056 0 0 1-13.802 26.332c-14.524 10.069-18.136 30.006-8.067 44.53 10.07 14.525 30.008 18.136 44.53 8.067C368.546 316.983 384 287.478 384 256z"></path></svg>',
            'speaker_empty': '<svg class="ss_svg_speaker_empty" '+svg_inner+' viewBox="0 0 576 512"><path fill="currentColor" d="M576 256c0 100.586-53.229 189.576-134.123 239.04-7.532 4.606-17.385 2.241-21.997-5.304-4.609-7.539-2.235-17.388 5.304-21.997C496.549 424.101 544 345.467 544 256c0-89.468-47.452-168.101-118.816-211.739-7.539-4.609-9.913-14.458-5.304-21.997 4.608-7.539 14.456-9.914 21.997-5.304C522.77 66.424 576 155.413 576 256zm-96 0c0-66.099-34.976-124.572-88.133-157.079-7.538-4.611-17.388-2.235-21.997 5.302-4.61 7.539-2.236 17.388 5.302 21.998C418.902 152.963 448 201.134 448 256c0 54.872-29.103 103.04-72.828 129.779-7.538 4.61-9.912 14.459-5.302 21.998 4.611 7.541 14.462 9.911 21.997 5.302C445.024 380.572 480 322.099 480 256zm-138.14-75.117c-7.538-4.615-17.388-2.239-21.998 5.297-4.612 7.537-2.241 17.387 5.297 21.998C341.966 218.462 352 236.34 352 256s-10.034 37.538-26.841 47.822c-7.538 4.611-9.909 14.461-5.297 21.998 4.611 7.538 14.463 9.909 21.998 5.297C368.247 314.972 384 286.891 384 256s-15.753-58.972-42.14-75.117zM256 88.017v335.964c0 21.436-25.942 31.999-40.971 16.971L126.059 352H24c-13.255 0-24-10.745-24-24V184c0-13.255 10.745-24 24-24h102.059l88.971-88.954C230.037 56.038 256 66.551 256 88.017zm-32 19.311l-77.659 77.644A24.001 24.001 0 0 1 129.372 192H32v128h97.372a24.001 24.001 0 0 1 16.969 7.028L224 404.67V107.328z"></path></svg>',
            'muted': '<svg class="ss_svg_muted" '+svg_inner+' viewBox="0 0 640 512"><path fill="currentColor" d="M219.845 98.213l27.184-27.167C262.04 56.036 288 66.556 288 88.017v62.623l-68.155-52.427zm195.889 150.684c-2.233-30.88-18.956-58.492-45.706-74.842-13.987-8.547-31.941-5.071-41.824 7.51l87.53 67.332zM436.665 64.74C500.967 104.063 544 174.983 544 256a223.67 223.67 0 0 1-14.854 80.137l52.417 40.321C598.735 339.19 608 298.184 608 256c0-103.244-54.579-194.877-137.944-245.859-15.074-9.221-34.773-4.473-43.995 10.604-9.221 15.077-4.473 34.774 10.604 43.995zm-50.009 81.961C425.067 170.188 448 211.048 448 256c0 5.676-.39 11.301-1.128 16.849l55.604 42.772A191.69 191.69 0 0 0 512 256c0-68.547-36.15-129.777-91.957-163.901-15.076-9.22-34.774-4.471-43.994 10.607-9.22 15.078-4.471 34.775 10.607 43.995zM90.232 160H56c-13.255 0-24 10.745-24 24v144c0 13.255 10.745 24 24 24h102.059l88.97 88.951c15.028 15.028 40.971 4.467 40.971-16.97V312.129L90.232 160zm360.889 277.607c-1.205.871-2.403 1.75-3.627 2.599-14.522 10.072-18.129 30.01-8.057 44.532 10.076 14.528 30.016 18.125 44.531 8.057a289.026 289.026 0 0 0 19.578-14.861l-52.425-40.327zm-71.629-55.099c-1.263 7.875.389 16.229 5.294 23.3 6.216 8.96 16.185 13.765 26.322 13.765 4.387 0 8.8-.923 12.959-2.776l-44.575-34.289zm255.53 107.442c8.071-10.493 6.123-25.54-4.356-33.63L48.389 4.978c-10.506-8.082-25.574-6.116-33.656 4.39L4.978 22.05c-8.082 10.506-6.116 25.574 4.39 33.656l582.208 451.29c10.505 8.111 25.598 6.156 33.69-4.364l9.756-12.682z"></path></svg>',
            'close': '<svg class="ss_svg_close" '+svg_inner+' viewBox="0 0 512 512"><path fill="currentColor" d="M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm0 448c-110.5 0-200-89.5-200-200S145.5 56 256 56s200 89.5 200 200-89.5 200-200 200zm101.8-262.2L295.6 256l62.2 62.2c4.7 4.7 4.7 12.3 0 17l-22.6 22.6c-4.7 4.7-12.3 4.7-17 0L256 295.6l-62.2 62.2c-4.7 4.7-12.3 4.7-17 0l-22.6-22.6c-4.7-4.7-4.7-12.3 0-17l62.2-62.2-62.2-62.2c-4.7-4.7-4.7-12.3 0-17l22.6-22.6c4.7-4.7 12.3-4.7 17 0l62.2 62.2 62.2-62.2c4.7-4.7 12.3-4.7 17 0l22.6 22.6c4.7 4.7 4.7 12.3 0 17z"></path></svg>',
            'lines': '<svg class="ss_svg_lines" '+svg_inner+' viewBox="0 0 448 512"><path fill="currentColor" d="M0 84V44c0-8.837 7.163-16 16-16h416c8.837 0 16 7.163 16 16v40c0 8.837-7.163 16-16 16H16c-8.837 0-16-7.163-16-16zm16 144h416c8.837 0 16-7.163 16-16v-40c0-8.837-7.163-16-16-16H16c-8.837 0-16 7.163-16 16v40c0 8.837 7.163 16 16 16zm0 256h416c8.837 0 16-7.163 16-16v-40c0-8.837-7.163-16-16-16H16c-8.837 0-16 7.163-16 16v40c0 8.837 7.163 16 16 16zm0-128h416c8.837 0 16-7.163 16-16v-40c0-8.837-7.163-16-16-16H16c-8.837 0-16 7.163-16 16v40c0 8.837 7.163 16 16 16z"></path></svg>',
            'dots': '<svg class="ss_svg_dots" '+svg_inner+' viewBox="0 0 448 512"><path fill="currentColor" d="M120 256c0 30.9-25.1 56-56 56s-56-25.1-56-56s25.1-56 56-56s56 25.1 56 56zm160 0c0 30.9-25.1 56-56 56s-56-25.1-56-56s25.1-56 56-56s56 25.1 56 56zm104 56c-30.9 0-56-25.1-56-56s25.1-56 56-56s56 25.1 56 56s-25.1 56-56 56z"/></svg>',
            'hand': '<svg class="ss_svg_hand" '+svg_inner+' viewBox="0 0 448 512"><path fill="currentColor" d="M208 288C199.2 288 192 295.2 192 304v96C192 408.8 199.2 416 208 416s16-7.164 16-16v-96C224 295.2 216.8 288 208 288zM272 288C263.2 288 256 295.2 256 304v96c0 8.836 7.162 16 15.1 16S288 408.8 288 400l-.0013-96C287.1 295.2 280.8 288 272 288zM376.9 201.2c-13.74-17.12-34.8-27.45-56.92-27.45h-13.72c-3.713 0-7.412 .291-11.07 .8652C282.7 165.1 267.4 160 251.4 160h-11.44V72c0-39.7-32.31-72-72.01-72c-39.7 0-71.98 32.3-71.98 72v168.5C84.85 235.1 75.19 235.4 69.83 235.4c-44.35 0-69.83 37.23-69.83 69.85c0 14.99 4.821 29.51 13.99 41.69l78.14 104.2C120.7 489.3 166.2 512 213.7 512h109.7c6.309 0 12.83-.957 18.14-2.645c28.59-5.447 53.87-19.41 73.17-40.44C436.1 446.3 448 416.2 448 384.2V274.3C448 234.6 416.3 202.3 376.9 201.2zM400 384.2c0 19.62-7.219 38.06-20.44 52.06c-12.53 13.66-29.03 22.67-49.69 26.56C327.4 463.6 325.3 464 323.4 464H213.7c-32.56 0-63.65-15.55-83.18-41.59L52.36 318.2C49.52 314.4 48.02 309.8 48.02 305.2c0-16.32 14.5-21.75 21.72-21.75c4.454 0 12.01 1.55 17.34 8.703l28.12 37.5c3.093 4.105 7.865 6.419 12.8 6.419c11.94 0 16.01-10.7 16.01-16.01V72c0-13.23 10.78-24 23.1-24c13.22 0 24 10.77 24 24v130.7c0 6.938 5.451 16.01 16.03 16.01C219.5 218.7 220.1 208 237.7 208h13.72c21.5 0 18.56 19.21 34.7 19.21c8.063 0 9.805-5.487 20.15-5.487h13.72c26.96 0 17.37 27.43 40.77 27.43l14.07-.0037c13.88 0 25.16 11.28 25.16 25.14V384.2zM336 288C327.2 288 320 295.2 320 304v96c0 8.836 7.164 16 16 16s16-7.164 16-16v-96C352 295.2 344.8 288 336 288z"/></svg>',
            'house': '<svg class="ss_svg_hause" '+svg_inner+' viewBox="0 0 576 512"><path fill="currentColor" d="M543.8 287.6c17 0 32-14 32-32.1c1-9-3-17-11-24L512 185V64c0-17.7-14.3-32-32-32H448c-17.7 0-32 14.3-32 32v36.7L309.5 7c-6-5-14-7-21-7s-15 1-22 8L10 231.5c-7 7-10 15-10 24c0 18 14 32.1 32 32.1h32v69.7c-.1 .9-.1 1.8-.1 2.8V472c0 22.1 17.9 40 40 40h16c1.2 0 2.4-.1 3.6-.2c1.5 .1 3 .2 4.5 .2H160h24c22.1 0 40-17.9 40-40V448 384c0-17.7 14.3-32 32-32h64c17.7 0 32 14.3 32 32v64 24c0 22.1 17.9 40 40 40h24 32.5c1.4 0 2.8 0 4.2-.1c1.1 .1 2.2 .1 3.3 .1h16c22.1 0 40-17.9 40-40V455.8c.3-2.6 .5-5.3 .5-8.1l-.7-160.2h32z"/></svg>',
            'check_double': '<svg class="ss_svg_check_double" '+svg_inner+' viewBox="0 0 512 512"><path fill="currentColor" d="M374.6 86.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L192 178.7l-57.4-57.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l80 80c12.5 12.5 32.8 12.5 45.3 0l160-160zm96 128c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L192 402.7 86.6 297.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l128 128c12.5 12.5 32.8 12.5 45.3 0l256-256z"/></svg>',
            'circle_play': '<svg class="ss_svg_circle_play" '+svg_inner+' viewBox="0 0 512 512"><path fill="currentColor" d="M188.3 147.1C195.8 142.8 205.1 142.1 212.5 147.5L356.5 235.5C363.6 239.9 368 247.6 368 256C368 264.4 363.6 272.1 356.5 276.5L212.5 364.5C205.1 369 195.8 369.2 188.3 364.9C180.7 360.7 176 352.7 176 344V167.1C176 159.3 180.7 151.3 188.3 147.1V147.1zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 48C141.1 48 48 141.1 48 256C48 370.9 141.1 464 256 464C370.9 464 464 370.9 464 256C464 141.1 370.9 48 256 48z"/></svg>',
            'play': '<svg class="ss_svg_play" '+svg_inner+' viewBox="0 0 384 512"><path fill="currentColor" d="M73 39c-14.8-9.1-33.4-9.4-48.5-.9S0 62.6 0 80V432c0 17.4 9.4 33.4 24.5 41.9s33.7 8.1 48.5-.9L361 297c14.3-8.7 23-24.2 23-41s-8.7-32.2-23-41L73 39z"/></svg>',
            'email': '<svg class="ss_svg_email" '+svg_inner+' viewBox="0 0 640 512"><path fill="currentColor" d="M48 64C21.5 64 0 85.5 0 112c0 15.1 7.1 29.3 19.2 38.4L236.8 313.6c11.4 8.5 27 8.5 38.4 0l57.4-43c23.9-59.8 79.7-103.3 146.3-109.8l13.9-10.4c12.1-9.1 19.2-23.3 19.2-38.4c0-26.5-21.5-48-48-48H48zM294.4 339.2c-22.8 17.1-54 17.1-76.8 0L0 176V384c0 35.3 28.7 64 64 64H360.2C335.1 417.6 320 378.5 320 336c0-5.6 .3-11.1 .8-16.6l-26.4 19.8zM640 336a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-76.7-43.3c6.2 6.2 6.2 16.4 0 22.6l-72 72c-6.2 6.2-16.4 6.2-22.6 0l-40-40c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L480 353.4l60.7-60.7c6.2-6.2 16.4-6.2 22.6 0z"/></svg>',
            'video': '<svg class="ss_svg_video" '+svg_inner+' viewBox="0 0 576 512"><path fill="currentColor" d="M0 128C0 92.7 28.7 64 64 64H320c35.3 0 64 28.7 64 64V384c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V128zM559.1 99.8c10.4 5.6 16.9 16.4 16.9 28.2V384c0 11.8-6.5 22.6-16.9 28.2s-23 5-32.9-1.6l-96-64L416 337.1V320 192 174.9l14.2-9.5 96-64c9.8-6.5 22.4-7.2 32.9-1.6z"/></svg>',
            'users_g': '<svg class="ss_svg_users_g" '+svg_inner+' viewBox="0 0 640 512"><path fill="currentColor" d="M144 160c-44.2 0-80-35.8-80-80S99.8 0 144 0s80 35.8 80 80s-35.8 80-80 80zm368 0c-44.2 0-80-35.8-80-80s35.8-80 80-80s80 35.8 80 80s-35.8 80-80 80zM0 298.7C0 239.8 47.8 192 106.7 192h42.7c15.9 0 31 3.5 44.6 9.7c-1.3 7.2-1.9 14.7-1.9 22.3c0 38.2 16.8 72.5 43.3 96c-.2 0-.4 0-.7 0H21.3C9.6 320 0 310.4 0 298.7zM405.3 320c-.2 0-.4 0-.7 0c26.6-23.5 43.3-57.8 43.3-96c0-7.6-.7-15-1.9-22.3c13.6-6.3 28.7-9.7 44.6-9.7h42.7C592.2 192 640 239.8 640 298.7c0 11.8-9.6 21.3-21.3 21.3H405.3zM416 224c0 53-43 96-96 96s-96-43-96-96s43-96 96-96s96 43 96 96zM128 485.3C128 411.7 187.7 352 261.3 352H378.7C452.3 352 512 411.7 512 485.3c0 14.7-11.9 26.7-26.7 26.7H154.7c-14.7 0-26.7-11.9-26.7-26.7z"/></svg>',
            'chart_line': '<svg class="ss_svg_chart_line" '+svg_inner+' viewBox="0 0 512 512"><path fill="currentColor" d="M64 64c0-17.7-14.3-32-32-32S0 46.3 0 64V400c0 44.2 35.8 80 80 80H480c17.7 0 32-14.3 32-32s-14.3-32-32-32H80c-8.8 0-16-7.2-16-16V64zm406.6 86.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L320 210.7l-57.4-57.4c-12.5-12.5-32.8-12.5-45.3 0l-112 112c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L240 221.3l57.4 57.4c12.5 12.5 32.8 12.5 45.3 0l128-128z"/></svg>',
            'table': '<svg class="ss_svg_table" '+svg_inner+' viewBox="0 0 512 512"><path fill="currentColor" d="M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H448c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm88 64v64H64V96h88zm56 0h88v64H208V96zm240 0v64H360V96h88zM64 224h88v64H64V224zm232 0v64H208V224h88zm64 0h88v64H360V224zM152 352v64H64V352h88zm56 0h88v64H208V352zm240 0v64H360V352h88z"/></svg>',
            'heart': '<svg class="ss_svg_heart" '+svg_inner+' viewBox="0 0 512 512"><path fill="currentColor" d="M47.6 300.4L228.3 469.1c7.5 7 17.4 10.9 27.7 10.9s20.2-3.9 27.7-10.9L464.4 300.4c30.4-28.3 47.6-68 47.6-109.5v-5.8c0-69.9-50.5-129.5-119.4-141C347 36.5 300.6 51.4 268 84L256 96 244 84c-32.6-32.6-79-47.5-124.6-39.9C50.5 55.6 0 115.2 0 185.1v5.8c0 41.5 17.2 81.2 47.6 109.5z"/></svg>',
            'cloud': '<svg class="ss_svg_cloud" '+svg_inner+' viewBox="0 0 640 512"><path fill="currentColor" d="M0 336c0 79.5 64.5 144 144 144H512c70.7 0 128-57.3 128-128c0-61.9-44-113.6-102.4-125.4c4.1-10.7 6.4-22.4 6.4-34.6c0-53-43-96-96-96c-19.7 0-38.1 6-53.3 16.2C367 64.2 315.3 32 256 32C167.6 32 96 103.6 96 192c0 2.7 .1 5.4 .2 8.1C40.2 219.8 0 273.2 0 336z"/></svg>',
            'microphone': '<svg class="ss_svg_microphone" '+svg_inner+' viewBox="0 0 384 512"><path fill="currentColor" d="M96 96V256c0 53 43 96 96 96s96-43 96-96H208c-8.8 0-16-7.2-16-16s7.2-16 16-16h80V192H208c-8.8 0-16-7.2-16-16s7.2-16 16-16h80V128H208c-8.8 0-16-7.2-16-16s7.2-16 16-16h80c0-53-43-96-96-96S96 43 96 96zM320 240v16c0 70.7-57.3 128-128 128s-128-57.3-128-128V216c0-13.3-10.7-24-24-24s-24 10.7-24 24v40c0 89.1 66.2 162.7 152 174.4V464H120c-13.3 0-24 10.7-24 24s10.7 24 24 24h72 72c13.3 0 24-10.7 24-24s-10.7-24-24-24H216V430.4c85.8-11.7 152-85.3 152-174.4V216c0-13.3-10.7-24-24-24s-24 10.7-24 24v24z"/></svg>',
            'user_c': '<svg class="ss_svg_user_c" '+svg_inner+' viewBox="0 0 640 512"><path fill="currentColor" d="M352 128c0 70.7-57.3 128-128 128s-128-57.3-128-128S153.3 0 224 0s128 57.3 128 128zM0 482.3C0 383.8 79.8 304 178.3 304h91.4C368.2 304 448 383.8 448 482.3c0 16.4-13.3 29.7-29.7 29.7H29.7C13.3 512 0 498.7 0 482.3zM625 177L497 305c-9.4 9.4-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l47 47L591 143c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9z"/></svg>',
            'user_x': '<svg class="ss_svg_user_x" '+svg_inner+' viewBox="0 0 640 512"><path fill="currentColor" d="M352 128c0 70.7-57.3 128-128 128s-128-57.3-128-128S153.3 0 224 0s128 57.3 128 128zM0 482.3C0 383.8 79.8 304 178.3 304h91.4C368.2 304 448 383.8 448 482.3c0 16.4-13.3 29.7-29.7 29.7H29.7C13.3 512 0 498.7 0 482.3zM471 143c9.4-9.4 24.6-9.4 33.9 0l47 47 47-47c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-47 47 47 47c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-47-47-47 47c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l47-47-47-47c-9.4-9.4-9.4-24.6 0-33.9z"/></svg>',
            'paint': '<svg class="ss_svg_paint" '+svg_inner+' viewBox="0 0 576 512"><path fill="currentColor" d="M371.3 367.1c27.3-3.9 51.9-19.4 67.2-42.9L600.2 74.1c12.6-19.5 9.4-45.3-7.6-61.2S549.7-4.4 531.1 9.6L294.4 187.2c-24 18-38.2 46.1-38.4 76.1L371.3 367.1zm-19.6 25.4l-116-104.4C175.9 290.3 128 339.6 128 400c0 3.9 .2 7.8 .6 11.6c1.8 17.5-10.2 36.4-27.8 36.4H96c-17.7 0-32 14.3-32 32s14.3 32 32 32H240c61.9 0 112-50.1 112-112c0-2.5-.1-5-.2-7.5z"/></svg>',
            'images': '<svg class="ss_svg_images" '+svg_inner+' viewBox="0 0 576 512"><path fill="currentColor" d="M160 32c-35.3 0-64 28.7-64 64V320c0 35.3 28.7 64 64 64H512c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H160zM396 138.7l96 144c4.9 7.4 5.4 16.8 1.2 24.6S480.9 320 472 320H328 280 200c-9.2 0-17.6-5.3-21.6-13.6s-2.9-18.2 2.9-25.4l64-80c4.6-5.7 11.4-9 18.7-9s14.2 3.3 18.7 9l17.3 21.6 56-84C360.5 132 368 128 376 128s15.5 4 20 10.7zM256 128c0 17.7-14.3 32-32 32s-32-14.3-32-32s14.3-32 32-32s32 14.3 32 32zM48 120c0-13.3-10.7-24-24-24S0 106.7 0 120V344c0 75.1 60.9 136 136 136H456c13.3 0 24-10.7 24-24s-10.7-24-24-24H136c-48.6 0-88-39.4-88-88V120z"/></svg>',
            'dice': '<svg class="ss_svg_dice" '+svg_inner+' viewBox="0 0 448 512"><path fill="currentColor" d="M216.3 2c4.8-2.6 10.5-2.6 15.3 0L422.3 106c5.1 2.8 8.3 8.2 8.3 14s-3.2 11.2-8.3 14L231.7 238c-4.8 2.6-10.5 2.6-15.3 0L25.7 134c-5.1-2.8-8.3-8.2-8.3-14s3.2-11.2 8.3-14L216.3 2zM23.7 170l176 96c5.1 2.8 8.3 8.2 8.3 14V496c0 5.6-3 10.9-7.8 13.8s-10.9 3-15.8 .3L8.3 414C3.2 411.2 0 405.9 0 400V184c0-5.6 3-10.9 7.8-13.8s10.9-3 15.8-.3zm400.7 0c5-2.7 11-2.6 15.8 .3s7.8 8.1 7.8 13.8V400c0 5.9-3.2 11.2-8.3 14l-176 96c-5 2.7-11 2.6-15.8-.3s-7.8-8.1-7.8-13.8V280c0-5.9 3.2-11.2 8.3-14l176-96z"/></svg>',
            'blog': '<svg class="ss_svg_dice" '+svg_inner+' viewBox="0 0 448 512"><path fill="currentColor" d="M192 32c0 17.7 14.3 32 32 32c123.7 0 224 100.3 224 224c0 17.7 14.3 32 32 32s32-14.3 32-32C512 128.9 383.1 0 224 0c-17.7 0-32 14.3-32 32zm0 96c0 17.7 14.3 32 32 32c70.7 0 128 57.3 128 128c0 17.7 14.3 32 32 32s32-14.3 32-32c0-106-86-192-192-192c-17.7 0-32 14.3-32 32zM96 144c0-26.5-21.5-48-48-48S0 117.5 0 144V368c0 79.5 64.5 144 144 144s144-64.5 144-144s-64.5-144-144-144H128v96h16c26.5 0 48 21.5 48 48s-21.5 48-48 48s-48-21.5-48-48V144z"/></svg>',
            'case': '<svg class="ss_svg_dice" '+svg_inner+' viewBox="0 0 512 512"><path fill="currentColor" d="M184 48H328c4.4 0 8 3.6 8 8V96H176V56c0-4.4 3.6-8 8-8zm-56 8V96H64C28.7 96 0 124.7 0 160v96H192 320 512V160c0-35.3-28.7-64-64-64H384V56c0-30.9-25.1-56-56-56H184c-30.9 0-56 25.1-56 56zM512 288H320v32c0 17.7-14.3 32-32 32H224c-17.7 0-32-14.3-32-32V288H0V416c0 35.3 28.7 64 64 64H448c35.3 0 64-28.7 64-64V288z"/></svg>',
            'arrow_right': '<svg class="ss_svg_dice" '+svg_inner+' viewBox="0 0 512 512"><path fill="currentColor" d="M502.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-128-128c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L402.7 224 32 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l370.7 0-73.4 73.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l128-128z"/></svg>',
            'grip': '<svg class="ss_svg_grip" '+svg_inner+' viewBox="0 0 448 512"><path fill="currentColor" d="M128 136c0-22.1-17.9-40-40-40L40 96C17.9 96 0 113.9 0 136l0 48c0 22.1 17.9 40 40 40H88c22.1 0 40-17.9 40-40V136zm0 192c0-22.1-17.9-40-40-40H40c-22.1 0-40 17.9-40 40v48c0 22.1 17.9 40 40 40H88c22.1 0 40-17.9 40-40V328zm32-192v48c0 22.1 17.9 40 40 40h48c22.1 0 40-17.9 40-40V136c0-22.1-17.9-40-40-40l-48 0c-22.1 0-40 17.9-40 40zM288 328c0-22.1-17.9-40-40-40H200c-22.1 0-40 17.9-40 40l0 48c0 22.1 17.9 40 40 40h48c22.1 0 40-17.9 40-40V328zm32-192v48c0 22.1 17.9 40 40 40h48c22.1 0 40-17.9 40-40V136c0-22.1-17.9-40-40-40l-48 0c-22.1 0-40 17.9-40 40zM448 328c0-22.1-17.9-40-40-40H360c-22.1 0-40 17.9-40 40v48c0 22.1 17.9 40 40 40h48c22.1 0 40-17.9 40-40V328z"/></svg>'
        };

        this.langsObj = [
            {
                "name": "Afrikaans (South Africa)",
                "value": "af-ZA",
                "voice_data": "A:0,A:1,A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Albanian (Albania)",
                "value": "sq",
                "voice_data": "A:0,A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Arabic",
                "value": "ar-XA",
                "voice_data": "A:0,A:2,B:2,C:2,D:2,A:20,B:20,C:20,D:20,E:20,F:20,G:20,H:20,I:20"
            },
            {
                "name": "Armenian",
                "value": "hy",
                "voice_data": "A:20,B:20,C:20,D:20,E:20,F:20,G:20,H:20,I:20"
            },
            {
                "name": "Belarusian",
                "value": "be",
                "voice_data": "A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Basque (Spain)",
                "value": "eu-ES",
                "voice_data": "A:1"
            },
            {
                "name": "Bengali (India)",
                "value": "bn-IN",
                "voice_data": "A:0,A:2,B:2,A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Bosnian (Bosnia and Herzegovina)",
                "value": "bs",
                "voice_data": "A:0,A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Bulgarian (Bulgaria)",
                "value": "bg-BG",
                "voice_data": "A:0,A:1,A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Catalan (Spain)",
                "value": "ca-ES",
                "voice_data": "A:0,A:1,A:20,B:20,C:20,D:20,E:20,F:20,G:20,H:20,I:20"
            },
            {
                "name": "Cantonese",
                "value": "yue",
                "voice_data": "A:0,A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Chinese (Simplified)",
                "value": "cmn-CN",
                "voice_data": "A:0,A:2,B:2,C:2,D:2,A:20,B:20,C:20,D:20,E:20,F:20,G:20,H:20,I:20"
            },
            {
                "name": "Chinese (Traditional)",
                "value": "cmn-TW",
                "voice_data": "A:0,A:2,B:2,C:2,A:20,B:20,C:20,D:20,E:20,F:20,G:20,H:20,I:20"
            },
            {
                "name": "Croatian (Croatia)",
                "value": "hr",
                "voice_data": "A:0,A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Czech (Czech Republic)",
                "value": "cs-CZ",
                "voice_data": "A:0,A:2,A:20,B:20,C:20,D:20,E:20,F:20,G:20,H:20,I:20"
            },
            {
                "name": "Danish (Denmark)",
                "value": "da-DK",
                "voice_data": "A:0,C:2,D:2,E:2,A:2,A:20,B:20,C:20,D:20,E:20,F:20,G:20,H:20,I:20"
            },
            {
                "name": "Dutch (Netherlands)",
                "value": "nl-NL",
                "voice_data": "A:0,B:2,C:2,D:2,A:2,E:2,A:20,B:20,C:20,D:20,E:20,F:20,G:20,H:20,I:20"
            },
            {
                "name": "English (Australia)",
                "value": "en-AU",
                "voice_data": "A:0,A:2,B:2,C:2,D:2"
            },
            {
                "name": "English (UK)",
                "value": "en-GB",
                "voice_data": "A:0,A:2,B:2,C:2,D:2,F:2,G:5,H:5,I:5,J:5,K:5,L:5,M:5"
            },
            {
                "name": "English (India)",
                "value": "en-IN",
                "voice_data": "A:0,D:2,A:2,B:2,C:2"
            },
            {
                "name": "English (United States)",
                "value": "en-US",
                "voice_data": "A:0,G:2,H:2,I:2,J:2,A:2,B:2,C:2,D:2,E:2,F:2,K:5,L:5,M:5,N:5,1:7,A:20,B:20,C:20,D:20,E:20,F:20,G:20,H:20,I:20"
            },
            {
                "name": "Estonian (Estonia)",
                "value": "et",
                "voice_data": "A:0,A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Filipino (Philippines)",
                "value": "fil-PH",
                "voice_data": "A:0,A:2,B:2,C:2,D:2,A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Finnish (Finland)",
                "value": "fi-FI",
                "voice_data": "A:0,A:2,A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "French (Canada)",
                "value": "fr-CA",
                "voice_data": "A:0,A:2,B:2,C:2,D:2"
            },
            {
                "name": "French (France)",
                "value": "fr-FR",
                "voice_data": "A:0,E:2,A:2,B:2,C:2,D:2,1:7,A:20,B:20,C:20,D:20,E:20,F:20,G:20,H:20,I:20"
            },
            {
                "name": "Galician (Spain)",
                "value": "gl-ES",
                "voice_data": "A:1"
            },
            {
                "name": "German (Germany)",
                "value": "de-DE",
                "voice_data": "A:0,F:2,A:2,B:2,C:2,D:2,E:2,1:7,A:20,B:20,C:20,D:20,E:20,F:20,G:20,H:20,I:20"
            },
            {
                "name": "Greek (Greece)",
                "value": "el-GR",
                "voice_data": "A:0,A:2,A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Gujarati (India)",
                "value": "gu-IN",
                "voice_data": "A:0,A:2,B:2,A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Hebrew",
                "value": "iw",
                "voice_data": "A:0,A:20,B:20,C:20,D:20,E:20,F:20,G:20,H:20,I:20"
            },
            {
                "name": "Hindi (India)",
                "value": "hi-IN",
                "voice_data": "A:0,D:2,A:2,B:2,C:2,A:20,B:20,C:20,D:20,E:20,F:20,G:20,H:20,I:20"
            },
            {
                "name": "Hungarian (Hungary)",
                "value": "hu-HU",
                "voice_data": "A:0,A:2,A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Icelandic (Iceland)",
                "value": "is-IS",
                "voice_data": "A:0,A:1,A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Indonesian (Indonesia)",
                "value": "id-ID",
                "voice_data": "A:0,D:2,A:2,B:2,C:2,A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Italian (Italy)",
                "value": "it-IT",
                "voice_data": "A:0,A:2,B:2,C:2,D:2,A:20,B:20,C:20,D:20,E:20,F:20,G:20,H:20,I:20"
            },
            {
                "name": "Japanese (Japan)",
                "value": "ja-JP",
                "voice_data": "A:0,B:2,C:2,D:2,A:2,A:20,B:20,C:20,D:20,E:20,F:20,G:20,H:20,I:20"
            },
            {
                "name": "Javanese (Indonesia)",
                "value": "jw",
                "voice_data": "A:0,A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Kannada (India)",
                "value": "kn-IN",
                "voice_data": "A:0,A:2,B:2,A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Kazakh",
                "value": "kk",
                "voice_data": "A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Khmer (Cambodia)",
                "value": "km",
                "voice_data": "A:0,A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Korean (South Korea)",
                "value": "ko-KR",
                "voice_data": "A:0,A:2,B:2,C:2,D:2,A:20,B:20,C:20,D:20,E:20,F:20,G:20,H:20,I:20"
            },
            {
                "name": "Latin",
                "value": "la",
                "voice_data": "A:0,A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Latvian (Latvia)",
                "value": "lv-LV",
                "voice_data": "A:0,A:1,A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Lithuanian (Lithuania)",
                "value": "lt-LT",
                "voice_data": "A:1"
            },
            {
                "name": "Macedonian",
                "value": "mk",
                "voice_data": "A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Malay (Malaysia)",
                "value": "ms-MY",
                "voice_data": "A:0,A:2,B:2,C:2,D:2"
            },
            {
                "name": "Malayalam (India)",
                "value": "ml-IN",
                "voice_data": "A:0,A:2,B:2,C:2,D:2"
            },
            {
                "name": "Marathi (India)",
                "value": "mr-IN",
                "voice_data": "A:0,A:2,B:2,C:2"
            },
            {
                "name": "Maori",
                "value": "mi",
                "voice_data": "A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Myanmar (Burmese)",
                "value": "my",
                "voice_data": "A:0,A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Nepali (Nepali)",
                "value": "ne",
                "voice_data": "A:0,A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Norwegian (Norway)",
                "value": "nb-NO",
                "voice_data": "A:0,A:2,B:2,C:2,D:2,E:2,A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Persian",
                "value": "fa",
                "voice_data": "A:20,B:20,C:20,D:20,E:20,F:20,G:20,H:20,I:20"
            },
            {
                "name": "Polish (Poland)",
                "value": "pl-PL",
                "voice_data": "A:0,A:2,B:2,C:2,E:2,D:2,A:20,B:20,C:20,D:20,E:20,F:20,G:20,H:20,I:20"
            },
            {
                "name": "Portuguese (Brazil)",
                "value": "pt-BR",
                "voice_data": "A:0,A:2,B:2,C:2"
            },
            {
                "name": "Portuguese (Portugal)",
                "value": "pt-PT",
                "voice_data": "A:0,A:2,B:2,C:2,D:2,A:20,B:20,C:20,D:20,E:20,F:20,G:20,H:20,I:20"
            },
            {
                "name": "Punjabi (Gurmukhi)",
                "value": "pa",
                "voice_data": "A:0,A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Punjabi (Shahmukhi)",
                "value": "pa-Arab",
                "voice_data": "A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Romanian (Romania)",
                "value": "ro-RO",
                "voice_data": "A:0,A:2,A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Russian (Russia)",
                "value": "ru-RU",
                "voice_data": "A:0,E:2,A:2,B:2,C:2,D:2,A:20,B:20,C:20,D:20,E:20,F:20,G:20,H:20,I:20"
            },
            {
                "name": "Serbian (Serbia)",
                "value": "sr-RS",
                "voice_data": "A:0,A:1,A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Sinhala (Sri Lanka)",
                "value": "si",
                "voice_data": "A:0,A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Slovak (Slovakia)",
                "value": "sk-SK",
                "voice_data": "A:0,A:2,A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Slovenian",
                "value": "sl",
                "voice_data": "A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Spanish (Spain)",
                "value": "es-ES",
                "voice_data": "A:0,C:2,D:2,B:2,A:3,E:3,F:3,1:7,A:20,B:20,C:20,D:20,E:20,F:20,G:20,H:20,I:20"
            },
            {
                "name": "Spanish (United States)",
                "value": "es-US",
                "voice_data": "A:0,A:2,B:2,C:2,G:5,F:5,E:5,D:5,A:20,B:20,C:20,D:20,E:20,F:20,G:20,H:20,I:20"
            },
            {
                "name": "Sundanese (Indonesia)",
                "value": "su",
                "voice_data": "A:0,A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Swahili",
                "value": "sw",
                "voice_data": "A:0,A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Swedish (Sweden)",
                "value": "sv-SE",
                "voice_data": "A:0,A:2,B:2,C:2,D:2,E:2"
            },
            {
                "name": "Tamil (India)",
                "value": "ta-IN",
                "voice_data": "A:0,A:2,B:2,C:2,D:2"
            },
            {
                "name": "Telugu (India)",
                "value": "te-IN",
                "voice_data": "A:0,A:1,B:1"
            },
            {
                "name": "Thai (Thailand)",
                "value": "th-TH",
                "voice_data": "A:0,A:1,A:20,B:20,C:20,D:20,E:20,F:20,G:20,H:20,I:20"
            },
            {
                "name": "Turkish (Turkey)",
                "value": "tr-TR",
                "voice_data": "A:0,B:2,C:2,D:2,E:2,A:2"
            },
            {
                "name": "Ukrainian (Ukraine)",
                "value": "uk-UA",
                "voice_data": "A:0,A:2,A:20,B:20,C:20,D:20,E:20,F:20,G:20,H:20,I:20"
            },
            {
                "name": "Urdu",
                "value": "ur",
                "voice_data": "A:0,A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Vietnamese (Vietnam)",
                "value": "vi-VN",
                "voice_data": "A:0,A:2,B:2,C:2,D:2"
            },
            {
                "name": "Yue Chinese (Hong Kong)",
                "value": "yue-HK",
                "voice_data": "A:1,B:1,C:1,D:1,A:20,B:20,C:20,D:20,E:20,F:20"
            },
            {
                "name": "Welsh",
                "value": "cy",
                "voice_data": "A:0,A:20,B:20,C:20,D:20,E:20,F:20"
            }
        ];
    };

    this.runFunctions = function() {

        this.applyPageFunctions();

        this.applyCookies();

        this.applyFunctions();

        this.applyOldPlugin();

        this.detectState();
    };

    this.init = function() {

        this.initVars();

        this.runFunctions();
    };

    this.applyFunctions = function() {

        var add_gspeech_link = function() {

            var gsp_h = '<span style="margin-left: 35px;">Thanks for using <a href="https://gspeech.io" target="_blank">GSpeech</a>.</span>';

            $("#footer-thankyou").append(gsp_h);

        };

        add_gspeech_link();

        $("#gsp_form").on("submit", function(e) {

            if($("#gsp_form").hasClass("submit_disabled")) {
                
                e.preventDefault();
            }
        });

        // trigger upgrade
        $("body").on("click", ".gsp_activate_upgrade", function(e) {

            e.preventDefault();

            $('.gsp_tab_upgrade').trigger("click");

        });

        $("body").on("click", ".gsp_left_menu_analytics", function(e) {

            setTimeout(function() {
                window.location.reload();
            }, 800);

        });

        // Dynamic height textarea
        $("body").on("focus", ".ss_textarea_dynamic_height", function() {
            $(this).addClass("ss_textarea_active");

            setTimeout(function() {
                thisPage.generateWrapperHeight();
            }, 400);
        });
        $("body").on("blur", ".ss_textarea_dynamic_height", function() {
            $(this).removeClass("ss_textarea_active");

            setTimeout(function() {
                thisPage.generateWrapperHeight();
            }, 400);
        });

        if($("#gsp_add_w_title").length) {

            var website_title = $("#gsp_site_name").html();

            website_title = website_title == '' ? 'My website' : website_title;
            $("#gsp_add_w_title").val(website_title);
        }

        if($(".gsp_register_wrapper").length) {

            var user_name = $("#gsp_realname").html();
            var user_email = $("#gsp_useremail").html();

            $("#gsp_reg_name").val(user_name);
            $("#gsp_reg_email").val(user_email);
        }

        if($(".gsp_login_wrapper_element").length) {

            var user_email = $("#gsp_useremail").html();
            var gsp_useremail_written = $("#gsp_useremail_written").html();

            user_email = gsp_useremail_written != "" ? gsp_useremail_written : user_email;

            $(".gsp_login_email_uni").val(user_email);
        }

        if($("#gsp_add_w_url").length) {
            
            var website_url = window.location.href;
            var u_p = website_url.split('/wp-admin');
            var website_host = u_p[0];

            $("#gsp_add_w_url").val(website_host);
        }

        // plan switcher
        $('body').on('click', '.switcher_small', function(e){

            var $el = $(this);
            if(!$el.hasClass("switcher_small"))
                $el = $(e.target).parents('.switcher_small');

            if(!$el.hasClass('switcher_small_button_on'))
                $el.addClass('switcher_small_button_on');
            else
                $el.removeClass('switcher_small_button_on');
        });

        $('body').on('click', '.switcher_small', function(e){

            var $el = $(this);
            if(!$el.hasClass("switcher_small"))
                $el = $(e.target).parents('.switcher_small');

            setTimeout(function() {

                if(!$el.hasClass('switcher_small_button_on')) {

                    if($el.hasClass("switcher_chars_count")) {

                        $('.gsp_package_personal .icon_ai_voice').removeClass("icon_hidden");
                        $('.gsp_package_personal .icon_mach_voice').addClass("icon_hidden");

                        $('.gsp_package_personal .feature_text_ai').removeClass("txt_hidden");
                        $('.gsp_package_personal .feature_text_machine').addClass("txt_hidden");

                        $(".switcher_voice_type").addClass("switcher_small_button_on");

                        $(".pers_vt_ic_plus").removeClass("icon_hidden");
                        $(".pers_vt_ic_minus").addClass("icon_hidden");

                        $(".pers_22_v_plus").removeClass("icon_hidden");
                        $(".pers_22_v_minus").addClass("icon_hidden");

                        $(".pers_l_67").removeClass("icon_hidden");
                        $(".pers_l_50").addClass("icon_hidden");

                        $('.product_button_personal').addClass('icon_hidden');
                        $('.product_button_personal_2').removeClass('icon_hidden');
                    }

                    if($el.hasClass("switcher_voice_type")) {

                        $('.gsp_package_personal .icon_ai_voice').addClass("icon_hidden");
                        $('.gsp_package_personal .icon_mach_voice').removeClass("icon_hidden");

                        $('.gsp_package_personal .feature_text_ai').addClass("txt_hidden");
                        $('.gsp_package_personal .feature_text_machine').removeClass("txt_hidden");

                        $(".switcher_chars_count").addClass("switcher_small_button_on");

                        $(".pers_vt_ic_plus").addClass("icon_hidden");
                        $(".pers_vt_ic_minus").removeClass("icon_hidden");

                        $(".pers_22_v_plus").addClass("icon_hidden");
                        $(".pers_22_v_minus").removeClass("icon_hidden");

                        $(".pers_l_67").addClass("icon_hidden");
                        $(".pers_l_50").removeClass("icon_hidden");

                        $('.product_button_personal').removeClass('icon_hidden');
                        $('.product_button_personal_2').addClass('icon_hidden');
                    }
                }
                else {

                    if($el.hasClass("switcher_chars_count")) {

                        $('.gsp_package_personal .icon_ai_voice').addClass("icon_hidden");
                        $('.gsp_package_personal .icon_mach_voice').removeClass("icon_hidden");

                        $('.gsp_package_personal .feature_text_ai').addClass("txt_hidden");
                        $('.gsp_package_personal .feature_text_machine').removeClass("txt_hidden");

                        $(".switcher_voice_type").removeClass("switcher_small_button_on");

                        $(".pers_vt_ic_plus").addClass("icon_hidden");
                        $(".pers_vt_ic_minus").removeClass("icon_hidden");

                        $(".pers_22_v_plus").addClass("icon_hidden");
                        $(".pers_22_v_minus").removeClass("icon_hidden");

                        $(".pers_l_67").addClass("icon_hidden");
                        $(".pers_l_50").removeClass("icon_hidden");

                        $('.product_button_personal').removeClass('icon_hidden');
                        $('.product_button_personal_2').addClass('icon_hidden');
                    }

                    if($el.hasClass("switcher_voice_type")) {
                       

                        $('.gsp_package_personal .icon_ai_voice').removeClass("icon_hidden");
                        $('.gsp_package_personal .icon_mach_voice').addClass("icon_hidden");

                        $('.gsp_package_personal .feature_text_ai').removeClass("txt_hidden");
                        $('.gsp_package_personal .feature_text_machine').addClass("txt_hidden");

                        $(".switcher_chars_count").removeClass("switcher_small_button_on");

                        $(".pers_vt_ic_plus").removeClass("icon_hidden");
                        $(".pers_vt_ic_minus").addClass("icon_hidden");

                        $(".pers_22_v_plus").removeClass("icon_hidden");
                        $(".pers_22_v_minus").addClass("icon_hidden");

                        $(".pers_l_67").removeClass("icon_hidden");
                        $(".pers_l_50").addClass("icon_hidden");

                        $('.product_button_personal').addClass('icon_hidden');
                        $('.product_button_personal_2').removeClass('icon_hidden');
                    }
                }
            }, 1);
        });

        // switcher small
        $('body').on('click', '.plan_switcher', function(e){

            var pay_path = 'https://gspeech.io/subscribe/';

            var $el = $(e.target).parents('.plan_switcher');
            if(!$el.hasClass('plan_switcher_button_on')) {
                $el.addClass('plan_switcher_button_on');

                $('.gspeech_packages_wrapper').addClass('yearly_plans');

                $('.product_button').each(function() {

                    var $button = $(this);

                    var y_p = $button.data("y_p");
                    var url = pay_path + y_p;

                    $button.attr("href", url);
                });
            }
            else {
                $el.removeClass('plan_switcher_button_on');

                $('.gspeech_packages_wrapper').removeClass('yearly_plans');

                $('.product_button').each(function() {

                    var $button = $(this);

                    var m_p = $button.data("m_p");
                    var url = pay_path + m_p;

                    $button.attr("href", url);
                });
            }
        });

        // gs switcher
        $('body').on('click', '.gs_switcher', function(e){

            if(!$(this).hasClass('gs_switcher_button_on')) {

                $(this).addClass('gs_switcher_button_on');

                // check radio on
                $(this).parents('.gs_checkbox_wrapper').find(".gs_checkbox").eq(0).prop("checked", false);
                $(this).parents('.gs_checkbox_wrapper').find(".gs_checkbox").eq(1).prop("checked", true);
            }
            else {

                $(this).removeClass('gs_switcher_button_on');

                // check radio off
                $(this).parents('.gs_checkbox_wrapper').find(".gs_checkbox").eq(0).prop("checked", true);
                $(this).parents('.gs_checkbox_wrapper').find(".gs_checkbox").eq(1).prop("checked", false);
            }
        });

        // gs mono switcher
        $('body').on('click', '.gs_mono_checkbox_wrapper', function(e){

            if($(this).hasClass("ss_disabled"))
                return;

            if(!$(this).hasClass('gs_mono_switcher_button_on')) {

                $(this).addClass('gs_mono_switcher_button_on');
                $(this).find(".gs_mono_checkbox").prop("checked", true);
            }
            else {

                $(this).removeClass('gs_mono_switcher_button_on');
                $(this).find(".gs_mono_checkbox").prop("checked", false);
            }
        });

        // ss checkbox
        $('body').on('click', '.ss_checkbox_wrapper', function(e) {

            if($(this).hasClass("ss_disabled")) {
                thisPage.shake($(this));

                return false;
            }

            if($(this).hasClass("ss_checked")) {

                $(this).find(".ss_checkbox_line1").addClass("ss_tr_d_150");
                $(this).find(".ss_checkbox_line2").addClass("ss_tr_d_0");
                $(this).addClass("ss_apply_ripple").removeClass("ss_checked");
            }
            else {

                $(this).find(".ss_checkbox_line1").removeClass("ss_tr_d_150");
                $(this).find(".ss_checkbox_line2").removeClass("ss_tr_d_0");
                $(this).removeClass("gsp_error").removeClass("ss_apply_ripple").addClass("ss_checked");
            }
        });

        $('body').on('mouseenter', '.ss_checkbox_label', function(e) {

            $(this).prev(".ss_checkbox_wrapper").addClass("ss_ch_hovered");
        });

        $('body').on('mouseleave', '.ss_checkbox_label', function(e) {

            $(this).prev(".ss_checkbox_wrapper").removeClass("ss_ch_hovered");
        });

        $('body').on('click', '.ss_checkbox_label', function(e) {

            var $target = $(e.target);

            if($target.hasClass('ss_label_link') || $target.parents('.ss_label_link').length)
                return;

            $(this).prev(".ss_checkbox_wrapper").trigger("click");
        });

        function make_vertical_titles() {

            var timeout_1 = 0;
            var timeout_2 = 0;

            $('body').on('mouseenter', '.title_holder_vertical', function() {

                var $target = $(this);
                var $title = $target.find('.gs_title_vertical');
                $title.addClass("ss_do_not_hide_title");
                $(".gs_title_vertical:not(.ss_do_not_hide_title)").removeClass("visible");
                $title.removeClass("ss_do_not_hide_title");
                // $title.removeClass("visible");

                if(timeout_1 != 0)
                    clearTimeout(timeout_1);

                if(timeout_2 != 0)
                    clearTimeout(timeout_2);

                timeout_2 = setTimeout(function() {
                    $title.addClass("visible");
                }, 400);
            });
            $('body').on('mouseleave', '.title_holder_vertical', function() {

                if(timeout_2 != 0)
                    clearTimeout(timeout_2);

                var $target = $(this);
                var $title = $target.find('.gs_title_vertical');

                timeout_1 = setTimeout(function() {
                    $title.removeClass("visible");
                }, 400);
            });
        };

        make_vertical_titles();

        // tabs
        $("body").on("click", ".gsp_tab", function() {

            if($(this).hasClass("gsp_tab_selected") || $(this).hasClass("gsp_tab_link"))
                return;

            $("#gsp_tabs_wrapper").find(".gsp_tab.gsp_tab_selected").removeClass("gsp_tab_selected");
            $(this).addClass("gsp_tab_selected");

            var tab_ident = $(this).data("tab_ident");

            $(".gsp_tab_active").removeClass("gsp_tab_active");
            $(".gsp_tab_c_" + tab_ident).addClass("gsp_tab_active");

            if(tab_ident == "old_basic") {

                $(".gsp_tab_old_basic").addClass("gsp_tab_old_basic_pos_2");
                $(".gsp_tab_old_styles").removeClass("gsp_hidden");
            }

            if(tab_ident != "old_basic" && tab_ident != "old_styles") {

                $(".gsp_tab_old_basic").removeClass("gsp_tab_old_basic_pos_2");
                $(".gsp_tab_old_styles").addClass("gsp_hidden");
            }

            if(tab_ident == "old_basic" || tab_ident == "old_styles") {

                $(".gsp_submit_button").removeClass("gsp_hidden");
                $("#gsp_form").removeClass("submit_disabled");
            }
            else {
                $(".gsp_submit_button").addClass("gsp_hidden");
                $("#gsp_form").addClass("submit_disabled");
            }

            if(tab_ident == "widget_id") {

                $(".gsp_submit_button").removeClass("gsp_hidden");
                $("#gsp_form").removeClass("submit_disabled");
            }

            if(tab_ident == "sign_up") {

                var old_p_lang = $("#gsp_old_p_lang").html();

                thisPage.createLangsListReg(old_p_lang);
            }

            if(tab_ident == 'website_settings') {
                thisPage.loadCloudData();
            }

            thisPage.generateWrapperHeight();
        });

        // left menus
        $("body").on("click", ".gsp_left_menu", function() {

            var widget_id = thisPage.options.widget_id;

            var link_sel = false;
            if($(this).hasClass("gsp_left_m_selected"))
                link_sel = true;

            var tab_ident = $(this).data("tab_ident");

            var hash = window.location.hash;
            hash = hash == '' ? '#settings' : hash;
            hash = hash.replace('#','');

            var hash_pieces = hash.split('-');
            var hash_0 = hash_pieces[0];
            var hash_1 = hash_pieces[1] != undefined ? parseInt(hash_pieces[1]) : 0;

            if(!link_sel) {

                $(".gsp_dash_col_1").find(".gsp_left_menu.gsp_left_m_selected").removeClass("gsp_left_m_selected");
                $(this).addClass("gsp_left_m_selected");

                $(".gsp_left_m_c_active").removeClass("gsp_left_m_c_active");
                $(".gsp_left_m_c_" + tab_ident).addClass("gsp_left_m_c_active");

                window.location.hash = tab_ident;
            }

            if(tab_ident == "settings") {

                $('.gsp_left_m_c_active .opts_input').val('');

                // show general tab
                $('.gsp_left_m_c_active .dashboard_tab.ss_selected').removeClass('ss_selected');
                $('.gsp_left_m_c_active .dashboard_tab.ss_tab_link_general').addClass('ss_selected');

                $('.gsp_left_m_c_active .ss_tab_wrapper.ss_tab_active').removeClass('ss_tab_active');
                $('.gsp_left_m_c_active .ss_tab_wrapper.ss_tab_general').addClass('ss_tab_active');

                thisPage.getWebsiteData(widget_id);
            }
            else if(tab_ident == "widgets") {

                if(hash_1 == 0) {

                    thisPage.getWidgetsData(widget_id);
                }
                else {

                    window.location.hash = tab_ident;

                    $('.gsp_left_m_c_widget').removeClass('gsp_left_m_c_active');
                    $('.gsp_left_m_c_widgets').addClass('gsp_left_m_c_active');

                    if($.trim($('.gsp_widgets_table .items_inner_wrapper').html()) == '' || $('.gsp_left_menu_widgets').hasClass('gsp_reload_widgets')) {

                        thisPage.getWidgetsData(widget_id);
                    }
                }
            }
            else if(tab_ident == "audios") {

                if(hash_1 == 0) {

                    thisPage.getAudiosData(widget_id);
                }
                else {

                    window.location.hash = tab_ident;

                    $('.gsp_left_m_c_audio').removeClass('gsp_left_m_c_active');
                    $('.gsp_left_m_c_audios').addClass('gsp_left_m_c_active');

                    if($.trim($('.gsp_audios_table .items_inner_wrapper').html()) == '' || $('.gsp_left_menu_audios').hasClass('gsp_reload_audios')) {

                        thisPage.getAudiosData(widget_id);
                    }
                }
            }
            else if(tab_ident == "analytics") {

                thisPage.getWebsiteAnalyticsData(widget_id);
            }
        });

        // shortcode
        $('.gsp_shortcode_html').focus(function() {

            this.select();
        }).mouseup(function() {

            return false;
        });

        $('.gsp_shortcode_html_1').focus(function() {

            this.select();
        }).mouseup(function() {
            return false;
        });

        // login
        // email
        $('body').on('blur', '.gsp_login_email_uni', function(e) {

            var gsp_login_email = $.trim($(this).val());

            // trim value
            $(this).val(gsp_login_email);

            if(!thisPage.validateEmail(gsp_login_email)) {
                $(this).addClass('gsp_error');
                $this.shake($(this), {'shakes': 2,'distance': 10,'duration': 300});
            }
            else {
                $(this).removeClass('gsp_error');
            }
        });

        // password
        $('body').on('blur', '.gsp_login_password_uni', function(e) {

            var gsp_login_password = $.trim($(this).val());

            // trim value
            $(this).val(gsp_login_password);

            if(gsp_login_password.length < 4) {
                $(this).addClass('gsp_error');
                $this.shake($(this), {'shakes': 2,'distance': 10,'duration': 300});
            }
            else {
                $(this).removeClass('gsp_error');
            }
        });

        $("body").on("click", '.activate_activate_tab', function(e) {

            $('.gsp_tab_sign_up').trigger("click");

            e.preventDefault();

        });

        $("body").on("click", '.activate_login_tab', function(e) {

            $('.gsp_tab_sign_in').trigger("click");

            e.preventDefault();

        });

        $("body").on("click", '.activate_logout_tab', function(e) {

            $('.gsp_tab_sign_out').trigger("click");

            e.preventDefault();

        });

        $("body").on("click", '.gsp_input_cw_wrapper', function(e) {

            $('.gsp_login_custom_widget').removeClass("gsp_hidden");

        });

        // login button
        $('body').on('click', '.gsp_login_button_uni', function(e) {

            e.preventDefault();

            var $login_form_email = $(this).parents('.gsp_login_wrapper').find(".gsp_login_email_uni");
            var $login_form_psw = $(this).parents('.gsp_login_wrapper').find(".gsp_login_password_uni");
            var login_form_psw_val = $login_form_psw.val();
            var login_form_email_val = $login_form_email.val();

            var sh_ = thisPage.options.sh_;
            var shortcodes_loaded = thisPage.options.shortcodes_loaded;

            sh_ = shortcodes_loaded == '1' ? 0 : sh_;

            var form_validated = true;

            var widget_id = $("#gsp_widget_id_val").html();
            var widget_id_custom = $(".gsp_login_custom_widget").val();

            if(widget_id_custom != "") {
                widget_id = widget_id_custom;
            }

            var page  = $(this).data("page");
            var refresh_login = $(this).hasClass("gsp_refresh_login") ? true : false;

            var return_data = refresh_login ? 0 : 1;

            var hash = window.location.hash;
            hash = hash == '' ? '#settings' : hash;
            hash = hash.replace('#','');

            var hash_pieces = hash.split('-');
            var hash_0 = hash_pieces[0];
            var hash_1 = hash_pieces[1] != undefined ? parseInt(hash_pieces[1]) : 0;

            // validate email
            if(!thisPage.validateEmail(login_form_email_val)) {
                form_validated = false;
                $login_form_email.addClass('gsp_error');
            }
            else {
                $login_form_email.removeClass('gsp_error');
            }

            // password
            if(login_form_psw_val.length < 4) {
                $login_form_psw.addClass('gsp_error');
                form_validated = false;
            }
            else {
                $login_form_psw.removeClass('gsp_error');
            }

            if(form_validated) {

                var tts_url = thisPage.options.tts_url;

                var make_login = function() {

                    var ajax_id = 'make_login_connection';

                    var website_url = window.location.href;
                    var u_p = website_url.split('/wp-admin');
                    var website_host = u_p[0];

                    console.log("widget_id: " + widget_id);

                    var post_data = {
                        'ajax_id':ajax_id,
                        'email':login_form_email_val,
                        'password':login_form_psw_val,
                        'return_data':return_data,
                        'host':website_host,
                        'sh_':sh_,
                        'widget':widget_id
                    };

                    thisPage.showOverlay();
                    thisPage.showLoading();

                    setTimeout(function() {

                        $.ajax({
                            type: 'POST',
                            url: tts_url + '/ajax',
                            crossDomain: true,
                            data: post_data,
                            dataType: 'json',
                            success: function(responseData, textStatus, jqXHR) {

                                thisPage.hideLoading();

                                var success = responseData.success;

                                if(success == "true") {

                                    thisPage.hideOverlay();

                                    var token = responseData.token;
                                    var email = responseData.email;
                                    var sh_put = responseData.sh_put;
                                    var plan_id = responseData.user_plan;
                                    var appsumo = responseData.appsumo;

                                    $("#gsp_plan").html(plan_id);
                                    $("#gsp_appsumo").html(appsumo);

                                    thisPage.processPlanCorrection();

                                    $('.gsp_login_email').html(email);

                                    $(".gsp_link_cloud_loged_in_as").removeClass('ss_hidden');
                                    $(".gsp_link_cloud_loged_in_email").removeClass('ss_hidden');
                                    $(".gsp_link_cloud_activate").addClass('ss_hidden');
                                    $(".gsp_link_cloud_login").addClass('ss_hidden');
                                    $('.gsp_link_cloud_logout').removeClass('ss_hidden');

                                    var post_data_inner = {

                                        action: 'wpgsp_apply_ajax_save',
                                        _ajax_nonce: wp_ajax_nonce,
                                        type: 'save_data',
                                        field: "email,sh_w_loaded,widget_id,plan,appsumo",
                                        val: email + ':' + sh_put + ':' + widget_id + ':' + plan_id + ':' + appsumo
                                    };

                                    thisPage.options.shortcodes_loaded = sh_put;
                                    thisPage.options.widget_id = widget_id;
                                    $('#gsp_widget_id_val').html(widget_id);

                                    if(sh_put == 1) {
                                        
                                        $('.add_shortcode_widgets_event_holder').addClass('ss_hidden');
                                    }

                                    $.ajax
                                    ({
                                        url: wp_ajax_url,
                                        type: "post",
                                        data: post_data_inner,
                                        dataType: "json",
                                        success: function(data) {
                                            
                                        },
                                        error: function(xhr, status, error) {
                                            
                                        }
                                    });

                                    thisPage.registerToken(token);

                                    if(!refresh_login) {

                                        var website_data = responseData.website_data;

                                        if(website_data.name != undefined) {

                                            thisPage.makeLoginSetData();
                                        }
                                        else {

                                            thisPage.makeLoginShowAddWebsite();
                                        }
                                    }
                                    else {

                                        thisPage.hideMessage();

                                        if(page == "website_data") {

                                            thisPage.getWebsiteData(widget_id);
                                        }
                                        else if(page == "update_website_data") {

                                            setTimeout(function() {

                                                $("#ss_website_settings_submit").trigger("click");
                                            }, 300);
                                        }
                                        else if(page == "widgets_data") {

                                            setTimeout(function() {

                                                thisPage.getWidgetsData(widget_id);
                                            }, 300);
                                        }
                                        else if(page == "widget_data") {

                                            setTimeout(function() {

                                                thisPage.getWidgetData(widget_id, hash_1);
                                            }, 300);
                                        }
                                    }
                                }
                                else {

                                    if(refresh_login) {

                                        thisPage.shake($(".gsp_login_wrapper"), {'shakes': 2,'distance': 10,'duration': 300});

                                    }
                                    else {

                                        thisPage.shake($(".gsp_login_wrapper"), {'shakes': 2,'distance': 10,'duration': 300});
                                        thisPage.showMessage("error","Wrong data", false);
                                    }
                                }
                            },
                            error: function (responseData, textStatus, errorThrown) {

                                thisPage.hideOverlay();
                                thisPage.hideLoading();
                            }
                        });

                    }, 400);
                };

                make_login();
            }
            else {
                thisPage.shake($(".gsp_login_wrapper"), {'shakes': 2,'distance': 10,'duration': 300});
            }
        });

        // register
        // name
        $('body').on('blur', '#gsp_reg_name', function(e) {

            var gsp_reg_name = $.trim($(this).val());

            // trim value
            $(this).val(gsp_reg_name);

            if(gsp_reg_name == "") {
                $(this).addClass('gsp_error');
                $this.shake($(this), {'shakes': 2,'distance': 10,'duration': 300});
            }
            else {
                $(this).removeClass('gsp_error');
            }
        });

        // email
        $('body').on('blur', '#gsp_reg_email', function(e) {

            var gsp_reg_email = $.trim($(this).val());

            // trim value
            $(this).val(gsp_reg_email);

            if(!thisPage.validateEmail(gsp_reg_email)) {
                $(this).addClass('gsp_error');
                $this.shake($(this), {'shakes': 2,'distance': 10,'duration': 300});
            }
            else {
                $(this).removeClass('gsp_error');
            }
        });

        // password
        $('body').on('blur', '#gsp_reg_password', function(e) {

            var gsp_reg_pas = $.trim($(this).val());

            // trim value
            $(this).val(gsp_reg_pas);

            if(gsp_reg_pas.length < 4) {
                $(this).addClass('gsp_error');
                $this.shake($(this), {'shakes': 2,'distance': 10,'duration': 300});
            }
            else {
                $(this).removeClass('gsp_error');
            }
        });

        // password retype
        $('body').on('blur', '#gsp_reg_password_retype', function(e) {

            var gsp_reg_pas = $.trim($(this).val());

            // trim value
            $(this).val(gsp_reg_pas);

            if(gsp_reg_pas.length < 4 || gsp_reg_pas != $("#gsp_reg_password").val()) {
                $(this).addClass('gsp_error');
                $this.shake($(this), {'shakes': 2,'distance': 10,'duration': 300});
            }
            else {
                $(this).removeClass('gsp_error');
            }
        });

        // register button
        $('body').on('click', '#gsp_reg_button', function(e) {

            var $reg_form_name = $("#gsp_reg_name"),
                $reg_form_email = $("#gsp_reg_email"),
                $reg_form_psw = $("#gsp_reg_password"),
                $reg_form_psw_retype = $("#gsp_reg_password_retype"),
                reg_form_name_val = $reg_form_name.val(),
                reg_form_email_val = $reg_form_email.val(),
                reg_form_psw_val = $reg_form_psw.val(),
                reg_form_psw_retype_val = $reg_form_psw_retype.val();

            var form_validated = true;

            var widget_id = "";

            // validate name
            if(reg_form_name_val == "") {
                form_validated = false;
                $reg_form_name.addClass('gsp_error');
            }
            else {
                $reg_form_name.removeClass('gsp_error');
            }

            // validate email
            if(!thisPage.validateEmail(reg_form_email_val)) {
                form_validated = false;
                $reg_form_email.addClass('gsp_error');
            }
            else {
                $reg_form_email.removeClass('gsp_error');
            }

            // password
            if(reg_form_psw_val.length < 4) {
                $reg_form_psw.addClass('gsp_error');
                form_validated = false;
            }
            else {
                $reg_form_psw.removeClass('gsp_error');
            }

            // password retype
            if(reg_form_psw_retype_val.length < 4 || reg_form_psw_retype_val != reg_form_psw_val) {
                $reg_form_psw_retype.addClass('gsp_error');
                form_validated = false;
            }
            else {
                $reg_form_psw_retype.removeClass('gsp_error');
            }

            // website lang
            var website_lang = $("#reg_website_lang").find('.li_selected').data("val");

            // terms
            if(!$("#gsp_agree_terms").hasClass("ss_checked")) {

                form_validated = false;
                $("#gsp_agree_terms").addClass('gsp_error');

                $this.shake($("#gsp_agree_terms"), {'shakes': 2,'distance': 10,'duration': 300});
            }

            if(form_validated) {

                var tts_url = thisPage.options.tts_url;

                var make_register = function() {

                    var ajax_id = 'make_register_connection';

                    var site_name = $("#gsp_site_name").html();

                    var website_url = window.location.href;
                    var u_p = website_url.split('/wp-admin');
                    var website_host = u_p[0];

                    var post_data = {
                        'ajax_id':ajax_id,
                        'name':reg_form_name_val,
                        'email':reg_form_email_val,
                        'password':reg_form_psw_val,
                        'lang':website_lang,
                        'site_name':site_name,
                        'host':website_host
                    };

                    thisPage.showOverlay();
                    thisPage.showLoading();

                    setTimeout(function() {

                        $.ajax({
                            type: 'POST',
                            url: tts_url + '/ajax',
                            crossDomain: true,
                            data: post_data,
                            dataType: 'json',
                            success: function(responseData, textStatus, jqXHR) {

                                thisPage.hideLoading();

                                var success = responseData.success;

                                if(success == "true") {

                                    thisPage.hideOverlay();

                                    var token = responseData.token;
                                    var widget_id = responseData.widget_id;
                                    var crypto = responseData.crypto;
                                    var email = responseData.email;

                                    $('.gsp_login_email').html(email);

                                    $(".gsp_link_cloud_loged_in_as").removeClass('ss_hidden');
                                    $(".gsp_link_cloud_loged_in_email").removeClass('ss_hidden');
                                    $(".gsp_link_cloud_activate").addClass('ss_hidden');
                                    $(".gsp_link_cloud_login").addClass('ss_hidden');
                                    $(".gsp_link_cloud_logout").removeClass('ss_hidden');

                                    thisPage.registerToken(token);

                                    $("#gsp_widget_id_val").html(widget_id);
                                    thisPage.options.widget_id = widget_id;

                                    thisPage.makeLoginSetData();

                                    var post_data_inner = {
                                        action: 'wpgsp_apply_ajax_save',
                                        _ajax_nonce: wp_ajax_nonce,
                                        type: 'save_data',
                                        field: "widget_id,crypto,email,sh_w_loaded",
                                        val: widget_id + ':' + crypto + ':' + email + ':' + '1'
                                    };
                                    $.ajax
                                    ({
                                        url: wp_ajax_url,
                                        type: "post",
                                        data: post_data_inner,
                                        dataType: "json",
                                        success: function(data) {
                                            
                                        },
                                        error: function(xhr, status, error) {
                                            
                                        }
                                    });

                                    thisPage.options.shortcodes_loaded = 1;
                                    $('.add_shortcode_widgets_event_holder').addClass('ss_hidden');

                                }
                                else if(success == "email_registered") {

                                    thisPage.shake($(".gsp_login_wrapper"), {'shakes': 2,'distance': 10,'duration': 300});
                                    thisPage.showMessage("error","Email already registered", false);
                                }
                                else {

                                    thisPage.shake($(".gsp_login_wrapper"), {'shakes': 2,'distance': 10,'duration': 300});
                                    thisPage.showMessage("error","Error", false);
                                }

                            },
                            error: function (responseData, textStatus, errorThrown) {

                                thisPage.hideOverlay();
                                thisPage.hideLoading();
                            }
                        });

                    }, 400);
                };

                make_register();
            }
            else {
                thisPage.shake($(".gsp_login_wrapper"), {'shakes': 2,'distance': 10,'duration': 300});
            }
        });

        // add website
        // validate title
        $('body').on('blur', '#gsp_add_w_title', function(e) {
            var site_title = $.trim($(this).val());

            // trim value
            $(this).val(site_title);

            if(site_title.length < 2) {
                $(this).addClass('gsp_error');
                thisPage.shake($(this), {'shakes': 2,'distance': 10,'duration': 300});
            }
            else {
                $(this).removeClass('gsp_error');
            }
        });

        $('body').on('click', '#add_website_lang .search_li', function(e) {

            $(this).parents(".items_select_filter_wrapper").removeClass("gsp_error");
        });

        // validate url
        $('body').on('blur', '#gsp_add_w_url', function(e){

            var site_url = $.trim($(this).val());

            // trim value
            $(this).val(site_url);

            // disabled url validation, to allow local values
            
            // if((!thisPage.validateUrl(site_url) && site_url != 'http://localhost') || site_url.indexOf(',') !== -1) {
            if(site_url == '' || site_url.indexOf(',') !== -1) {

                $(this).addClass('gsp_error');
                thisPage.shake($(this), {'shakes': 2,'distance': 10,'duration': 300});
            }
            else {
                $(this).removeClass('gsp_error');
            }
        });

        // submit form
        $('body').on('click', '#gsp_create_website_button', function(e) {

            var $site_title = $("#gsp_add_w_title"),
                $site_url = $("#gsp_add_w_url"),
                site_title_val = $site_title.val(),
                site_url_val = $site_url.val(),
                $language_selector = $("#add_website_lang"),
                language_selector_val = $("#add_website_lang").find(".li_selected").data("val"),
                form_validated = true;

            // validate title
            if(site_title_val.length < 2) {
                form_validated = false;
                $site_title.addClass('gsp_error');
                $site_title.focus();
            }
            else {
                $site_title.removeClass('gsp_error');
            }

            // validate url
            
            // if((!thisPage.validateUrl(site_url_val) && site_url_val != 'http://localhost') || site_url_val.indexOf(',') !== -1) {
            if(site_url_val == '' || site_url_val.indexOf(',') !== -1) {

                $site_url.addClass('gsp_error');
                form_validated = false;
            }
            else {
                $site_url.removeClass('gsp_error');
            }

            //validate language
            if(language_selector_val == undefined) {
                $language_selector.addClass('gsp_error');
                thisPage.shake($language_selector, {'shakes': 2,'distance': 10,'duration': 300});
                form_validated = false;
            }
            else {
                $language_selector.removeClass('gsp_error');
            }

            if(form_validated) {

                var tts_url = thisPage.options.tts_url;
                var gspeech_token = thisPage.getCookie('gspeech_token');
                var lang_code = language_selector_val;

                var add_site = function() {

                    var ajax_id = 'add_website_connection';

                    var post_data = {
                        'ajax_id':ajax_id,
                        'token':gspeech_token,
                        'website_url':site_url_val,
                        'website_name':site_title_val,
                        'language_code':lang_code
                    };

                    thisPage.showOverlay();
                    thisPage.showLoading();

                    $.ajax({
                        type: 'POST',
                        url: tts_url + '/ajax',
                        crossDomain: true,
                        data: post_data,
                        dataType: 'json',
                        success: function(responseData, textStatus, jqXHR) {

                            var result = responseData.success;
                            if(result == 'true') {

                                var widget_id = responseData.widget_id;
                                var crypto = responseData.crypto;

                                thisPage.hideOverlay();
                                thisPage.hideLoading();
                                thisPage.showMessage('success','Website has been created successfully!');

                                // store data
                                var post_data_inner = {
                                    action: 'wpgsp_apply_ajax_save',
                                    _ajax_nonce: wp_ajax_nonce,
                                    type: 'save_data',
                                    field: "widget_id,crypto",
                                    val: widget_id + ':' + crypto
                                };
                                $.ajax
                                ({
                                    url: wp_ajax_url,
                                    type: "post",
                                    data: post_data_inner,
                                    dataType: "json",
                                    success: function(data) {
                                        setTimeout(function() {
                                            window.location.reload();
                                        }, 400);
                                    },
                                    error: function(xhr, status, error) {
                                        
                                    }
                                });
                            }
                            else if(result == 'auth_failed') {

                                thisPage.hideOverlay();
                                thisPage.hideLoading();

                                thisPage.makeLogout();
                            }
                            else {
                                thisPage.hideOverlay();
                                thisPage.hideLoading();

                                var message = result == 'limit_exceeded' ? 'Sites count exceeded!' : 'Error adding website!'
                                thisPage.showMessage('error', message);
                            }
                        },
                        error: function (responseData, textStatus, errorThrown) {

                            thisPage.hideOverlay();
                            thisPage.hideLoading();
                            thisPage.showMessage('error','Error adding website!');
                        }
                    });
                };

                add_site();
            }
            else {
                thisPage.shake($(".gsp_add_website_wrapper"), {'shakes': 2,'distance': 10,'duration': 300});
            }
        });

        // logout
        $('body').on('click', '#gsp_sign_out_button', function(e){

            thisPage.makeLogout();
        });

        $("body").on("click", ".dashboard_tab", function() {

            if($(this).hasClass("ss_selected"))
                return;

            $(this).parents(".dashboard_tabs_wrapper").find(".dashboard_tab.ss_selected").removeClass("ss_selected");
            $(this).addClass("ss_selected");

            var tab_ident = $(this).data("tab_ident");

            $(".ss_tab_active").removeClass("ss_tab_active");
            $(".ss_tab_" + tab_ident).addClass("ss_tab_active");

            thisPage.generateWrapperHeight();
        });

        //////////////////////////// Dashboard events ///////////////////////////////////////////////////////////////

        // tables
        $('body').on('click', '.itm_has_ord', function(e) {

            var $el = $(e.target);

            if(!$el.hasClass('itm_has_ord'))
                $el = $el.parents('.itm_has_ord');

            $itms_header = $el.parents('.items_body_header');

            if($el.hasClass('itm_ord_active')) {
                if($el.hasClass('item_ord_asc')) {
                    $el.removeClass('item_ord_asc');
                    $el.addClass('item_ord_desc');
                }
                else {
                    $el.addClass('item_ord_asc');
                    $el.removeClass('item_ord_desc');
                }
            }
            else {
                $itms_header.find('.itm_ord_active')
                    .removeClass('item_ord_desc')
                    .removeClass('item_ord_asc')
                    .removeClass('itm_ord_active');

                $el.addClass('itm_ord_active');
                $el.addClass('item_ord_desc');
            }

            // make table filter
            thisPage.makeTableFilter();
        });

        // search
        $('body').on('click', '.search_items_wrapper', function(e) {
            var $el = $(e.target);

            if(!$el.hasClass('search_items_wrapper')) {
                return;
                $el = $el.parents('.search_items_wrapper');
            }

            $el.find('.search_input').focus();
        });

        $('body').on('focus', '.search_input', function(e) {
            var $el = $(e.target);

            if(!$el.hasClass('search_input'))
                $el = $el.parents('.search_input');

            $el.parent('.search_items_wrapper').addClass('search_items_wrapper_focused');
        });

        $('body').on('blur', '.search_input', function(e) {
            var $el = $(e.target);

            if(!$el.hasClass('search_input'))
                $el = $el.parents('.search_input');

            $el.parent('.search_items_wrapper').removeClass('search_items_wrapper_focused');

            var old_val = $el.data('search_val');
            var new_val = $el.val();

            if(old_val != new_val) {
                // set active page to 1
                $('.itms_p_sel').removeClass('itms_p_sel');
                $('.items_pagination_itms_holder').find('.itms_p_i:first-child').addClass('itms_p_sel');

                thisPage.makeTableFilter();
            }
        });

        var search_timeout = 0;
        $('body').on('keydown', '.search_input', function(e) {

            // if processing, stop
            if($('#items_wrapper_overlay').hasClass('items_wrapper_overlay_visible')) {
                return false;
            }
        });
        $('body').on('keyup', '.search_input', function(e) {

            var $el = $(e.target);

            if(!$el.hasClass('search_input'))
                $el = $el.parents('.search_input');

            var val = $el.val();
            if(val == '') {
                $el.prev('.search_icon_holder').addClass('search_icon_pasive');
                $el.next('.reset_search').removeClass('reset_search_visible');
            }
            else {
                $el.prev('.search_icon_holder').removeClass('search_icon_pasive');
                $el.next('.reset_search').addClass('reset_search_visible');
            }

            var old_val = $el.data('search_val');
            var new_val = $el.val();

            clearTimeout(search_timeout);
            search_timeout = setTimeout(function() {
                if(old_val != new_val) {
                    // set active page to 1
                    $('.itms_p_sel').removeClass('itms_p_sel');
                    $('.items_pagination_itms_holder').find('.itms_p_i:first-child').addClass('itms_p_sel');
                    thisPage.makeTableFilter();
                }
            }, 800);

            if(old_val != new_val) {
                if (e.key === 'Enter' || e.keyCode === 13) {
                    clearTimeout(search_timeout);

                    // set active page to 1
                    $('.itms_p_sel').removeClass('itms_p_sel');
                    $('.items_pagination_itms_holder').find('.itms_p_i:first-child').addClass('itms_p_sel');
                    thisPage.makeTableFilter();
                }
            }
        });

        $('body').on('click', '.reset_search', function(e) {
            var $el = $(e.target);

            if(!$el.hasClass('reset_search'))
                $el = $el.parents('.reset_search');

            var $search_input = $el.prev('.search_input');
            
            var $search_icon = $el.parents('.search_items_wrapper').find('.search_icon_holder');

            $search_input.val('');

            $el.removeClass('reset_search_visible');
            $search_icon.addClass('search_icon_pasive');

            // set active page to 1
            $('.itms_p_sel').removeClass('itms_p_sel');
            $('.items_pagination_itms_holder').find('.itms_p_i:first-child').addClass('itms_p_sel');

            thisPage.makeTableFilter();
        });

        $('body').on('click', '.search_icon_holder', function(e) {
            var $el = $(e.target);

            if(!$el.hasClass('search_icon_holder'))
                $el = $el.parents('.search_icon_holder');

            if($el.hasClass('.search_icon_pasive'))
                return;

            var $search_input = $el.next('.search_input');

            var old_val = $search_input.data('search_val');
            var new_val = $search_input.val();

            if(old_val != new_val)
                thisPage.makeTableFilter();
        });

        // pages
        $('body').on('click', ".itms_p_i:not(.itms_p_sel)", function(e) {

            var $el = $(e.target);

            if(!$el.hasClass('itms_p_i'))
                $el = $el.parents('.itms_p_i');

            $('.itms_p_sel').removeClass('itms_p_sel');
            $el.addClass('itms_p_sel');

            thisPage.makeTableFilter();
        });

        // left tabs-menus
        $('body').on('click', '.gsp_left_menu', function(e) {
        });

        // Website settings section /////////////////////////////////////////////////////

        $('body').on('click', '#wbs_plan li', function() {

            var $target = $(this);

            if(!$target.hasClass('li_selected')) {

                var plan_val = $target.data('val');

                if(plan_val == 0) {

                    $("#wbs_voice").find(".ss_voice_type_1").addClass("ss_disabled");
                    $("#wbs_voice").find(".ss_voice_type_2").addClass("ss_disabled");
                    $("#wbs_voice").find(".ss_voice_type_3").addClass("ss_disabled");
                    $("#wbs_voice").find(".ss_voice_type_4").addClass("ss_disabled");
                    $("#wbs_voice").find(".ss_voice_type_5").addClass("ss_disabled");

                    $(".ss_commercial_switcher").removeClass("gs_mono_switcher_button_on").addClass("ss_disabled");
                    $(".ss_commercial_switcher").find(".gs_mono_checkbox").prop("checked",false);

                    $('.ss_commercial_switcher').parent('div').find('.ss_locked_icon').removeClass("ss_display_none").addClass('ss_vis_par');

                    $(".gsp_option_disable_switcher").addClass("gsp_option_disabled");

                    if(!$("#wbs_voice").find('.ss_voice_type_0').length) {

                        $("#wbs_voice").find(".li_selected").removeClass("li_selected");
                        $("#wbs_voice").find(".items_select_filter_content span").html($("#wbs_voice").data("def_txt"));
                    }
                    else {
                        $("#wbs_voice").find('.li_selected').removeClass("li_selected").removeClass("ss_ul_li_act");
                        $("#wbs_voice").find('.ss_voice_type_0').addClass("li_selected").addClass("ss_ul_li_act");
                        $("#wbs_voice").find(".items_select_filter_content span").html($("#wbs_voice").find(".li_selected span").html());

                        thisPage.resetPlayerWebsiteSettings();
                    }

                    $("#wbs_multiple_voices").addClass("ss_disabled");
                    $("#wbs_multiple_voices").find(".items_select_filter_content span").html($("#wbs_multiple_voices").data("def_txt"));
                    $("#wbs_multiple_voices").find(".items_select_ul").html();

                    $("#ss_translation_options").addClass("ss_display_none");
                }
                else {
                    $("#wbs_voice").find(".ss_disabled").removeClass("ss_disabled");
                    $("#wbs_multiple_voices").removeClass("ss_disabled");
                    $("#ss_translation_options .items_select_filter_wrapper .search_li").removeClass("ss_disabled");

                    var m_v_title = $("#wbs_voice").find(".li_selected").length ? $("#wbs_voice").find(".li_selected span").html() : $("#wbs_multiple_voices").data("def_txt");
                    $("#wbs_multiple_voices").find(".items_select_filter_content span").html(m_v_title);
                    $("#wbs_multiple_voices").find(".items_select_ul").html($("#wbs_voice").find(".items_select_ul").html());

                    // 3.11.0
                    $(".ss_commercial_switcher").removeClass("ss_disabled");

                    $(".ss_commercial_switcher").each(function() {

                        var $switcher = $(this);

                        if(!$switcher.hasClass("ss_commercial_turnon_dis")) {

                            $switcher.addClass("gs_mono_switcher_button_on");
                            $switcher.find(".gs_mono_checkbox").prop("checked",true);
                        }
                    })

                    $('.ss_commercial_switcher').parent('div').find('.ss_locked_icon').addClass("ss_display_none").removeClass('ss_vis_par');

                    $("#ss_translation_options").removeClass("ss_display_none");

                    var $gsLanguageSelector = $("#lng_sel"),
                        $gsVoiceSelector = $("#wbs_voice"),
                        $gsMultipleVoiceSelector = $("#wbs_multiple_voices");

                    // setTimeout(function() {

                    //     var lang_code = $gsLanguageSelector.find("li.li_selected").data('val');

                    //     $gsMultipleVoiceSelector.find(".search_li").each(function() {
                    
                    //         $(this).data("name_hash", $this.preview_audios[lang_code][$(this).data("val")]);
                    //     });
                    // }, 800);
                }
            }
        });

        $('body').on('click', '#wbs_voice li', function(e) {

            if(!$("#dashboard_content").hasClass("ss_dash_webs_set"))
                return;

            var $target = $(this);
            var $target_inner = $(e.target);

            if($target.hasClass('li_selected') || $target_inner.hasClass('play_voice_preview') || $target_inner.parents('.play_voice_preview').length)
                return;

            // sync multiple voices
            var sel_val = $target.data("val");
            if($('#wbs_voice_enabled').find(".gs_mono_checkbox").prop("checked") == true) {

                $gsMultipleVoiceSelector = $("#wbs_multiple_voices");

                $gsMultipleVoiceSelector.find('.li_selected').removeClass("li_selected").removeClass("ss_ul_li_act");
                $gsMultipleVoiceSelector.find('.ss_option_hardcoded').removeClass("ss_option_hardcoded");
                $gsMultipleVoiceSelector.find('.option-' + sel_val).addClass("ss_option_hardcoded").addClass("li_selected").addClass("ss_ul_li_act");

                var voice_cont_val = $target.find("span").html();

                $gsMultipleVoiceSelector.find(".items_select_filter_content span").html(voice_cont_val);
            }
            // sync languages blovk
            $(".ss_tr_block_hardcoded").find('.li_selected').removeClass("li_selected").removeClass("ss_ul_li_act");
            $(".ss_tr_block_hardcoded").find('.option-' + sel_val).addClass("li_selected").addClass("ss_option_hardcoded").addClass("ss_ul_li_act");
            var voice_cont_val = $target.find("span").html();
            $(".ss_tr_block_hardcoded").find(".items_select_filter_content span").html(voice_cont_val);

            setTimeout(function() {

                thisPage.resetPlayerWebsiteSettings();

                if(!$target.hasClass("ss_voice_type_2") && !$target.hasClass("ss_voice_type_5") && !$target.hasClass("ss_voice_type_7"))
                    $(".gsp_option_disable_switcher").addClass("gsp_option_disabled");
                else
                    if(!$target.hasClass("ss_disabled"))
                        $(".gsp_option_disable_switcher").removeClass("gsp_option_disabled");

            },400);
        });

        $('body').on('click', '#wbs_multiple_voices li', function(e) {

            if(!$("#dashboard_content").hasClass("ss_dash_webs_set"))
                return;

            setTimeout(function() {

                var c_val = $(this).parents(".items_select_filter_wrapper").find('.items_select_filter_content span').html(),
                    ul_htm = $(this).parents(".items_select_ul").html();

                $(".ss_tr_block_hardcoded").find(".items_select_filter_content span").html(c_val);
                $(".ss_tr_block_hardcoded").find(".items_select_ul").html(ul_htm);

            }.bind(this), 1);
        });

        $('body').on('click', '.ss_tr_block_hardcoded .search_li', function(e) {

            if(!$("#dashboard_content").hasClass("ss_dash_webs_set"))
                return;

            if($('#wbs_voice_enabled').find(".gs_mono_checkbox").prop("checked")) {
                setTimeout(function() {

                    var c_val = $(this).parents(".items_select_filter_wrapper").find('.items_select_filter_content span').html(),
                        ul_htm = $(this).parents(".items_select_ul").html();

                    $("#wbs_multiple_voices").find(".items_select_filter_content span").html(c_val);
                    $("#wbs_multiple_voices").find(".items_select_ul").html(ul_htm);

                }.bind(this), 1);
            }
        });

        $('body').on('click', '#lng_sel li', function() {

            if(!$("#dashboard_content").hasClass("ss_dash_webs_set"))
                return;

            var $target = $(this);

            if($target.hasClass('li_selected'))
                return;

            setTimeout(function() {

                thisPage.processVoiceWebsiteSettings();

                // make preview text translation
                var $active_lang_selector = $target.parents('.items_select_filter_wrapper');
                var lang = $active_lang_selector.find('.li_selected').data('val');

                var lang_p = lang.split('-');
                var lang_to = lang_p[0];

                lang_to = lang_to == 'yue' ? 'zh' : lang_to;

                var $voice_preview_data = $("#voice_preview_data");
                var preview_txt_def = $voice_preview_data.data('preview_txt_def');
                var preview_txt_ready = preview_txt_def;

                var translate_callback = function(translated) {
                    var tr_item = translated["0"];
                    $voice_preview_data.data('preview_txt_ready', tr_item);

                    thisPage.processVoiceWebsiteSettings();
                };

                if(lang_to != 'en')
                    window.gspeech.doSmartTranslate('en', lang_to, [preview_txt_def], translate_callback);
                else {
                    $voice_preview_data.data('preview_txt_ready', preview_txt_def);
                    thisPage.processVoiceWebsiteSettings();
                }

            },400);
        });

        $('body').on('click', '#wbs_voice_enabled', function() {

            if(!$("#dashboard_content").hasClass("ss_dash_webs_set"))
                return;

            if($(this).hasClass("gs_mono_switcher_button_on")) {

                var m_voice_sel = $("#wbs_voice").find(".items_select_filter_content span").html();
                $("#wbs_multiple_voices").find(".items_select_ul").html($("#wbs_voice").find(".items_select_ul").html());
                $("#wbs_multiple_voices").find(".items_select_filter_content span").html(m_voice_sel);
                $("#wbs_multiple_voices").removeClass("ss_disabled");
                $("#wbs_multiple_voices").find(".li_selected").addClass("ss_option_hardcoded");

                var ul_htm = $("#wbs_multiple_voices").find(".items_select_ul").html();

                $(".ss_tr_block_hardcoded").find(".items_select_filter_content span").html(m_voice_sel);
                $(".ss_tr_block_hardcoded").find(".items_select_ul").html(ul_htm);

                var $gsLanguageSelector = $("#lng_sel"),
                    $gsVoiceSelector = $("#wbs_voice"),
                    $gsMultipleVoiceSelector = $("#wbs_multiple_voices");

                // setTimeout(function() {

                //     var lang_code = $gsLanguageSelector.find("li.li_selected").data('val');

                //     $gsMultipleVoiceSelector.find(".search_li").each(function() {
                
                //         $(this).data("name_hash", $this.preview_audios[lang_code][$(this).data("val")]);
                //     });
                // }, 800);
            }
            else {
                $("#wbs_multiple_voices").find(".items_select_ul").html("");
                $("#wbs_multiple_voices").find(".items_select_filter_content span").html($("#wbs_multiple_voices").data("def_txt"));
                $("#wbs_multiple_voices").addClass("ss_disabled");
            }
        });

        $('body').on('click', '#wbs_lang_enabled', function() {

            if(!$("#dashboard_content").hasClass("ss_dash_webs_set"))
                return;

            if($(this).hasClass("gs_mono_switcher_button_on")) {
                $("#ss_translation_options").removeClass("ss_display_none");
                // thisPage.generateWrapperHeight();
            }
            else {
                $("#ss_translation_options").addClass("ss_display_none");
                // thisPage.generateWrapperHeight();
            }
        });

        $('body').on('click', '.play_voice_preview', function() {

            var $target = $(this);

            var name_hash = $target.parents('li').data('name_hash');

            window.gspeech.hidden_audio_holder = $target;
            // window.gspeech.load_from_cache = name_hash;

            if(!$target.hasClass('play_voice_preview'))
                $target = $target.parents('.play_voice_preview');

            // pause if playing
            if($target.parents(".items_select_ul").find('.stop_visible').length) {

                var itm_md5 = $target.parents(".items_select_ul").find('.stop_visible').data('md5');
                var $audioG = $('.gsp_speech_md5_' + itm_md5).get(0);
                $audioG.pause();
                $audioG.currentTime = 0;
            }

            $target.addClass('self_t');

            // set all icons to play status
            $target.parents('.items_select_ul').find(".play_voice_preview:not(.self_t)").removeClass('stop_visible').addClass('play_visible');

            if($target.hasClass("play_visible")) {
                $target.removeClass("play_visible");
                $target.addClass("stop_visible");
            }
            else {
                $target.addClass("play_visible");
                $target.removeClass("stop_visible");

                // reset voice
                var md5 = $target.data('md5');
                var $audio = $('.gsp_speech_md5_' + md5);
                var $audioG = $audio.get(0);

                $audioG.pause();
                $audioG.currentTime = 0;

                window.gspeech.load_from_cache = 0;

                return false;
            }

            $target.removeClass('self_t');

            // make preview play
            var voice = $target.parents('.search_li').data('val');
            var $lng_sel = $("#lng_sel");

            var lang = $lng_sel.find('.li_selected').data('val');
            var speed = '1.00';
            var pitch = '0.00';
            
            var preview_txt_ready = $("#voice_preview_data").data('preview_txt_ready');

            var is_on_translation_block = false;
            var $tr_bl = $target.parents('.ss_translation_item');
            if($tr_bl.length) {

                is_on_translation_block = true;
            }

            if(is_on_translation_block && $tr_bl.hasClass('preview_txt_processed')) {

                lang = $tr_bl.data('val');
                preview_txt_ready = $tr_bl.data('prev_txt');
            }

            var speech_data = lang + ',' + voice + ',' + speed + ',' + pitch;

            var ended_callback = function() {
                $target.removeClass("stop_visible").addClass("play_visible");
            };

            window.gspeech.doSmartSpeech(preview_txt_ready, speech_data, '', true, '', null, 0, ended_callback);

            // this.doSmartSpeech = function(str, voice_data = '', uniq = '', play_instantly = true, id_player = '', callback = null, id_block = 0, ended_callback = null) {
        });

        // translate preview txt
        $('body').on('click', '.ss_translation_item', function() {

            var $target = $(this);

            if(!$target.hasClass('ss_translation_item')) {

                $target = $target.parents('.ss_translation_item');
            }

            var v =  $target.data('prev_txt');

            if($target.hasClass("preview_txt_processed")) {
                return;
            }

            if($target.hasClass("click_fired")) {
                return;
            }

            $target.addClass("click_fired");

            thisPage.createTranslationBlockPreviewTxt($target);
        });

        // translation ss checkbox
        var ss_ch_t = 0;
        var ss_wh_t = 0;
        $('body').on('click', '#ss_translation_options .ss_checkbox_wrapper', function(e) {

            var $ch = $(this);
            var $l2 = $ch.parents(".ss_translation_item").find(".ss_tr_line2");

            if(ss_ch_t != 0)
                clearTimeout(ss_ch_t);

            if(ss_wh_t != 0)
                clearTimeout(ss_ch_t);

            if($ch.hasClass("ss_checked")) {
                $l2.addClass("ss_tr_line2_v");
                ss_ch_t = setTimeout(function() {
                    $l2.addClass("ss_ov_v");
                }, 300);
            }
            else {
                $l2.removeClass("ss_ov_v");
                $l2.removeClass("ss_tr_line2_v");
            }

            ss_wh_t = setTimeout(function() {
                thisPage.generateWrapperHeight();
            }, 300);
        });
        var ss_ch_t = 0;
        var ss_wh_t = 0;
        $('body').on('click', '#ss_w_translation_options .ss_checkbox_wrapper', function(e) {

            var $ch = $(this);
            var $l2 = $ch.parents(".ss_translation_item").find(".ss_tr_line2");

            if(ss_ch_t != 0)
                clearTimeout(ss_ch_t);

            if(ss_wh_t != 0)
                clearTimeout(ss_ch_t);

            if($ch.hasClass("ss_checked")) {
                $l2.addClass("ss_tr_line2_v");
                ss_ch_t = setTimeout(function() {
                    $l2.addClass("ss_ov_v");
                }, 300);
            }
            else {
                $l2.removeClass("ss_ov_v");
                $l2.removeClass("ss_tr_line2_v");
            }

            ss_wh_t = setTimeout(function() {
                thisPage.generateWrapperHeight();
            }, 300);
        });

        // stop preview audio, when hiding wrapper
        $("body").on("click", function(e) {

            var $target = $(e.target);
            if($target.hasClass("search_li") || $target.parents(".search_li").length)
                return;

            if($(".ss_audio_holder.isfw_opened").length) {

                $(".ss_audio_holder.isfw_opened").each(function() {

                    if($(this).find('.stop_visible').length) {

                        var itm_md5 = $(this).find('.stop_visible').data('md5');
                            $audioG = $('.gsp_speech_md5_' + itm_md5).get(0);

                        if($audioG == undefined)
                            return;

                        $audioG.pause();
                        $audioG.currentTime = 0;

                        $(this).find('.stop_visible').removeClass("stop_visible").addClass("play_visible");
                    }
                });
            }
        });

        // save website settings
        $('body').on('click', '#ss_website_settings_submit', function() {

            var $ss_website_title = $("#ss_website_title");
            var ss_website_title = $.trim($ss_website_title.val());
            $ss_website_title.val(ss_website_title);

            var $ss_website_url = $("#ss_website_url");
            var ss_website_url = $.trim($ss_website_url.val());
            $ss_website_url.val(ss_website_url);

            var form_validated = true;

            // title
            if(ss_website_title.length < 2) {

                $ss_website_title.addClass('ss_error');
                form_validated = false;
                $ss_website_title.focus();
                thisPage.shake($ss_website_title);
            }
            else {
                $ss_website_title.removeClass('ss_error');
            }

            // url
            if(ss_website_url == "" || ss_website_url.indexOf(',') !== -1) {

                $ss_website_url.addClass('ss_error');
                form_validated = false;
                $ss_website_url.focus();
                thisPage.shake($ss_website_url);
            }
            else {
                $ss_website_url.removeClass('ss_error');
            }

            // get lang
            var ss_website_lang = $("#lng_sel").find(".li_selected").data("val");

            // get voice
            var ss_website_voice = "";
            if(!$("#wbs_voice").find(".li_selected").length) {
                form_validated = false;
                $("#wbs_voice").addClass("ss_error");
                thisPage.shake($("#wbs_voice"));
            }
            else {
                $("#wbs_voice").removeClass("ss_error");
                ss_website_voice = $("#wbs_voice").find(".li_selected").data("val");
            }

            var ss_website_plan = $("#wbs_plan").find(".li_selected").data("val");

            // get pitch,speed
            var ss_website_speed = $("#gsp_slider_speed").find('.gsp_value_label').val();
            var ss_website_pitch = $("#gsp_slider_pitch").find('.gsp_value_label').val();

            // voice enabled
            var voice_enabled = $("#wbs_voice_enabled").hasClass("gs_mono_switcher_button_on") ? 1 : 0;

             // voice enabled
            var website_status = $("#wbs_status").hasClass("gs_mono_switcher_button_on") ? 1 : 0;

            var website_custom_js = $.trim($("#ss_custom_js").val());
            $("#ss_custom_js").val(website_custom_js);

            var website_custom_css = $.trim($("#ss_custom_css").val());
            $("#ss_custom_css").val(website_custom_css);

            var website_aliases = $.trim($("#ss_aliases").val());
            $("#ss_aliases").val(website_aliases);

            // multiple voices
            var ss_website_multiple_voice = '';
            if(voice_enabled == 1 && !$("#wbs_multiple_voices").find(".li_selected").length) {
                form_validated = false;
                $("#wbs_multiple_voices").addClass("ss_error");
                thisPage.shake($("#wbs_multiple_voices"));
            }
            else {
                $("#wbs_multiple_voices").removeClass("ss_error");

                $("#wbs_multiple_voices").find(".li_selected").each(function() {

                    ss_website_multiple_voice += $(this).data("val") + ',';

                });
                ss_website_multiple_voice = ss_website_multiple_voice.slice(0, -1);
            }

            // appear class
            var ss_website_appear_class = $("#wbs_appear_class").find(".li_selected").data("val");

            // speed enabled
            var speed_enabled = $("#wbs_speed_enabled").hasClass("gs_mono_switcher_button_on") ? 1 : 0;

            // volume enabled
            var volume_enabled = $("#wbs_volume_enabled").hasClass("gs_mono_switcher_button_on") ? 1 : 0;

            // text enabled
            var text_enabled = $("#wbs_text_enabled").hasClass("gs_mono_switcher_button_on") ? 1 : 0;

            // download enabled
            var download_enabled = $("#wbs_download_enabled").hasClass("gs_mono_switcher_button_on") ? 1 : 0;

            // context enabled
            var context_enabled = $("#wbs_context_enabled").hasClass("gs_mono_switcher_button_on") ? 1 : 0;

            // plays enabled
            var plays_enabled = $("#wbs_plays_enabled").hasClass("gs_mono_switcher_button_on") ? 1 : 0;

            // lang enabled
            var lang_enabled = $("#wbs_lang_enabled").hasClass("gs_mono_switcher_button_on") ? 1 : 0;

            // lazy load
            var wbs_lazy_load = $("#wbs_lazy_load").hasClass("gs_mono_switcher_button_on") ? 1 : 0;

            // reload session
            var wbs_reload_session = $("#wbs_reload_session").hasClass("gs_mono_switcher_button_on") ? 1 : 0;

            // 3.9.0

            // wbs_auto_enable
            var wbs_auto_enable = $("#wbs_auto_enable").hasClass("gs_mono_switcher_button_on") ? 1 : 0;

            // wbs_show_on_homepage
            var wbs_show_on_homepage = $("#wbs_show_on_homepage").hasClass("gs_mono_switcher_button_on") ? 1 : 0;

            // wbs_multilang_website
            var wbs_multilang_website = $("#wbs_multilang_website").hasClass("gs_mono_switcher_button_on") ? 1 : 0;

            // wbs_read_titles
            var wbs_read_titles = $("#wbs_read_titles").hasClass("gs_mono_switcher_button_on") ? 1 : 0;

            // wbs_read_titles
            var wbs_affiliate = $("#wbs_affiliate").hasClass("gs_mono_switcher_button_on") ? 1 : 0;

            // wbs_onfly
            var wbs_onfly = $("#wbs_onfly").hasClass("gs_mono_switcher_button_on") ? 1 : 0;

            var wbs_post_types = "";
            $("#gsp_post_types").find(".li_selected").each(function() {

                if(wbs_post_types != "") {
                    wbs_post_types += ",";
                }
                var piece_v = $(this).data("val");
                wbs_post_types += piece_v;
            });
            wbs_post_types = wbs_post_types == '' ? 'all' : wbs_post_types;

            var wbs_categories = "";
            $("#gsp_categories").find(".li_selected").each(function() {

                if(wbs_categories != "") {
                    wbs_categories += ",";
                }
                var piece_v = $(this).data("val");
                wbs_categories += piece_v;
            });
            wbs_categories = wbs_categories == '' ? 'all' : wbs_categories;

            var wbs_exclude_list = $.trim($('#ss_website_exclude_list').val());
            var wbs_allowed_urls = $.trim($('#ss_wbs_allowed_urls').val());
            var wbs_blocked_urls = $.trim($('#ss_wbs_blocked_urls').val());

            var ss_website_langs = "";
            if(lang_enabled == 1) {

                $("#ss_translation_options").find(".ss_checked").each(function() {

                    // website_options["sel_langs"] = "en-US|C-2,D-2,E-2,M-5;ru-RU|E-2,B-2,D-2";

                    var $lang_item = $(this).parents(".ss_translation_item");
                    var lang_val = $lang_item.data("val");
                    var lang_sel_voices = "";
                    var $voice_wrapper = $lang_item.find(".items_select_filter_wrapper");

                    var lang_bl = lang_val + '|';

                    if(!$voice_wrapper.find(".li_selected").length) {

                        form_validated = false;
                        $voice_wrapper.addClass("ss_error");
                        thisPage.shake($voice_wrapper);
                    }
                    else {

                        $voice_wrapper.find(".li_selected").each(function() {

                            lang_bl += $(this).data("val") + ',';
                        });

                        lang_bl = lang_bl.slice(0, -1);
                    }

                    ss_website_langs += lang_bl + ';';
                });

                ss_website_langs = ss_website_langs.slice(0, -1);
            }

            if(form_validated) {

                var form_data = "ss_website_title=" + encodeURIComponent(ss_website_title);
                form_data += "&ss_website_url=" + ss_website_url;
                form_data += "&ss_website_plan=" + ss_website_plan;
                form_data += "&ss_website_plan=" + ss_website_plan;
                form_data += "&ss_website_lang=" + ss_website_lang;
                form_data += "&ss_website_voice=" + ss_website_voice;
                form_data += "&ss_website_speed=" + ss_website_speed;
                form_data += "&ss_website_pitch=" + ss_website_pitch;
                form_data += "&voice_enabled=" + voice_enabled;
                form_data += "&sel_voices=" + ss_website_multiple_voice;
                form_data += "&appear_class=" + ss_website_appear_class;
                form_data += "&speed_enabled=" + speed_enabled;
                form_data += "&volume_enabled=" + volume_enabled;
                form_data += "&text_enabled=" + text_enabled;
                form_data += "&download_enabled=" + download_enabled;
                form_data += "&context_enabled=" + context_enabled;
                form_data += "&plays_enabled=" + plays_enabled;
                form_data += "&lang_enabled=" + lang_enabled;
                form_data += "&sel_langs=" + ss_website_langs;
                form_data += "&state=" + website_status;
                form_data += "&lazy_load=" + wbs_lazy_load;
                form_data += "&reload_session=" + wbs_reload_session;

                form_data += "&auto_enable=" + wbs_auto_enable;
                form_data += "&show_on_homepage=" + wbs_show_on_homepage;
                form_data += "&multilang_website=" + wbs_multilang_website;
                form_data += "&read_titles=" + wbs_read_titles;
                form_data += "&post_types=" + wbs_post_types;
                form_data += "&categories=" + wbs_categories;
                form_data += "&affiliate=" + wbs_affiliate;
                form_data += "&onfly=" + wbs_onfly;

                form_data += "&exclude_list=" + wbs_exclude_list;
                form_data += "&allowed_urls=" + encodeURIComponent(wbs_allowed_urls);
                form_data += "&blocked_urls=" + encodeURIComponent(wbs_blocked_urls);

                form_data += "&aliases=" + encodeURIComponent(website_aliases);
                form_data += "&js=" + encodeURIComponent(website_custom_js);
                form_data += "&css=" + encodeURIComponent(website_custom_css);

                var tts_url = thisPage.options.tts_url,
                    ajax_id = 'update_website_settings_connection';

                var gspeech_token = thisPage.getCookie('gspeech_token');
                var widget_id = thisPage.options.widget_id;

                var post_data = {
                    'ajax_id':ajax_id,
                    'token':gspeech_token,
                    'widget_id':widget_id,
                    'form_data':form_data
                };

                thisPage.showLoading();
                thisPage.showOverlay();

                $.ajax({
                    type: 'POST',
                    url: tts_url + '/ajax',
                    crossDomain: true,
                    data: post_data,
                    dataType: 'json',
                    success: function(responseData, textStatus, jqXHR) {

                        thisPage.hideOverlay();
                        thisPage.hideLoading();

                        var result = responseData['success'];
                        var message = responseData['message'];
                        if(result == 'true') {

                            thisPage.showMessage('success','Settings have been updated successfully.');

                            // if(window.gspeech != undefined)
                                // window.gspeech.doSmartSpeech('Settings have been updated successfully.', 'en-US');
                        }
                        else if(result == "auth_failed") {

                            thisPage.refreshLogin("update_website_data");
                        }
                        else {
                            thisPage.showMessage('error','Error!');

                            // if(window.gspeech != undefined)
                                // window.gspeech.doSmartSpeech('Error!', 'en-US');

                            thisPage.shake($("#dashboard_content"), {'shakes': 2,'distance': 10,'duration': 300});
                        }
                    },
                    error: function (responseData, textStatus, errorThrown) {

                        thisPage.hideOverlay();
                        thisPage.hideLoading();

                        thisPage.showMessage('error','Error saving settings!');

                        // if(window.gspeech != undefined)
                            // window.gspeech.doSmartSpeech('Error saving settings!', 'en-US');
                    }
                });

                // store lazy_load parameter to

                var post_data_inner = {
                    action: 'wpgsp_apply_ajax_save',
                    _ajax_nonce: wp_ajax_nonce,
                    type: 'save_data',
                    field: "lazy_load,reload_session",
                    val: wbs_lazy_load + ':' + wbs_reload_session
                };
                $.ajax
                ({
                    url: wp_ajax_url,
                    type: "post",
                    data: post_data_inner,
                    dataType: "json",
                    success: function(data) {
                        
                    },
                    error: function(xhr, status, error) {
                        
                    }
                });

                // increase version index
                var post_data_inner = {
                    action: 'wpgsp_apply_ajax_save',
                    _ajax_nonce: wp_ajax_nonce,
                    type: 'increase_index'
                };
                $.ajax
                ({
                    url: wp_ajax_url,
                    type: "post",
                    data: post_data_inner,
                    dataType: "json",
                    success: function(data) {
                        
                    },
                    error: function(xhr, status, error) {
                        
                    }
                });
            }
            else {

                thisPage.shake($(this));
            }
        });

        // Widget settings section /////////////////////////////////////////////////////

        $('body').on('click', '#voice_sel_wdg li', function(e) {

            var $target = $(this);
            var $target_inner = $(e.target);

            if($target.hasClass('li_selected') || $target_inner.hasClass('play_voice_preview') || $target_inner.parents('.play_voice_preview').length)
                return;

            // sync multiple voices
            var sel_val = $target.data("val");
            if($('#wbs_w_voice_enabled').find(".li_selected").data("val") == 1) {

                $gsMultipleVoiceSelector = $("#wbs_w_multiple_voices");

                $gsMultipleVoiceSelector.find('.li_selected').removeClass("li_selected").removeClass("ss_ul_li_act");
                $gsMultipleVoiceSelector.find('.ss_option_hardcoded').removeClass("ss_option_hardcoded");
                $gsMultipleVoiceSelector.find('.option-' + sel_val).addClass("ss_option_hardcoded").addClass("li_selected").addClass("ss_ul_li_act");

                var voice_cont_val = $target.find("span").html();

                $gsMultipleVoiceSelector.find(".items_select_filter_content span").html(voice_cont_val);
            }
            // sync languages block
            $(".gsp_left_m_c_active .ss_tr_block_hardcoded").find('.li_selected').removeClass("li_selected").removeClass("ss_ul_li_act");
            $(".gsp_left_m_c_active .ss_tr_block_hardcoded").find('.option-' + sel_val).addClass("li_selected").addClass("ss_option_hardcoded").addClass("ss_ul_li_act");
            var voice_cont_val = $target.find("span").html();
            $(".gsp_left_m_c_active .ss_tr_block_hardcoded").find(".items_select_filter_content span").html(voice_cont_val);

            setTimeout(function() {

                thisPage.resetPlayerWidgetSettings();

                if(!$target.hasClass("ss_voice_type_2") && !$target.hasClass("ss_voice_type_5") && !$target.hasClass("ss_voice_type_7"))
                    $(".gsp_left_m_c_active .gsp_option_disable_switcher").addClass("gsp_option_disabled");
                else
                    $(".gsp_left_m_c_active .gsp_option_disable_switcher").removeClass("gsp_option_disabled");

            },400);
        });

        $('body').on('click', '#wbs_w_multiple_voices li', function(e) {

            setTimeout(function() {

                var c_val = $(this).parents(".items_select_filter_wrapper").find('.items_select_filter_content span').html(),
                    ul_htm = $(this).parents(".items_select_ul").html();

                $(".gsp_left_m_c_active .ss_tr_block_hardcoded").find(".items_select_filter_content span").html(c_val);
                $(".gsp_left_m_c_active .ss_tr_block_hardcoded").find(".items_select_ul").html(ul_htm);

            }.bind(this), 1);
        });

        $('body').on('click', '.gsp_left_m_c_active .ss_tr_block_hardcoded .search_li', function(e) {

            if($('#wbs_w_voice_enabled').find(".li_selected").data("val") == 1) {
                setTimeout(function() {

                    var c_val = $(this).parents(".items_select_filter_wrapper").find('.items_select_filter_content span').html(),
                        ul_htm = $(this).parents(".items_select_ul").html();

                    $("#wbs_w_multiple_voices").find(".items_select_filter_content span").html(c_val);
                    $("#wbs_w_multiple_voices").find(".items_select_ul").html(ul_htm);

                }.bind(this), 1);
            }
        });

        // translate texts
        $('body').on('mousedown', '#lng_sel_wdg li', function() {

            var $target = $(this);

            if($target.hasClass('li_selected'))
                return;

            var block_type = $("#ss_widget_type").data("widget_type");

            var lang_to = $target.data("val").split('-')[0];
            lang_to = lang_to == 'yue' ? 'zh' : lang_to;

            // make preview text translation
            var lang = $("#lng_sel_wdg").find('.li_selected').data('val');
            var lang_p = lang.split('-');
            var lang_from = lang_p[0];

            lang_from = lang_from == 'yue' ? 'zh' : lang_from;

            var translate_callback = function(translated) {

                $("#ss_speed_text").val(translated[0]);
                $("#ss_lang_text").val(translated[1]);
                $("#ss_voice_text").val(translated[2]);
                $("#ss_plays_text").val(translated[3]);
                $("#ss_plays_title_text").val(translated[4]);
                $("#ss_download_text").val(translated[5]);
                $("#ss_downloaded_text").val(translated[6]);
                $("#ss_open_text_text").val(translated[7]);
                $("#ss_open_context_text").val(translated[8]);
                $("#ss_close_context_text").val(translated[9]);
                $("#ss_loading_text").val(translated[10]);
                $("#ss_play_text").val(translated[11]);
                $("#ss_pause_text").val(translated[12]);
                $("#ss_options_text").val(translated[13]);
                $("#ss_listen_text").val(translated[14]);
                $("#ss_close_text").val(translated[15]);
                $("#ss_listen_text_desc").val(translated[16]);

                if(block_type == 3 || block_type == 4)
                    $("#ss_player_title_text").val(translated[17]);
            };

            if(lang_from != lang_to) {
                var player_title_text = $("#ss_player_title_text").val();
                player_title_text = player_title_text == "" ? "Read text" : player_title_text;
                var texts_array = [$("#ss_speed_text").val(),$("#ss_lang_text").val(),$("#ss_voice_text").val(),$("#ss_plays_text").val(),$("#ss_plays_title_text").val(),$("#ss_download_text").val(),$("#ss_downloaded_text").val(),$("#ss_open_text_text").val(),$("#ss_open_context_text").val(),$("#ss_close_context_text").val(),$("#ss_loading_text").val(),$("#ss_play_text").val(),$("#ss_pause_text").val(),$("#ss_options_text").val(),$("#ss_listen_text").val(),$("#ss_close_text").val(),$("#ss_listen_text_desc").val(),player_title_text];
                window.gspeech.doSmartTranslate(lang_from, lang_to, texts_array, translate_callback);
            }
        });

        $('body').on('click', '#lng_sel_wdg li', function() {

            var $target = $(this);

            if($target.hasClass('li_selected'))
                return;

            setTimeout(function() {

                thisPage.processVoiceWidgetSettings();

                // make preview text translation
                var $active_lang_selector = $target.parents('.items_select_filter_wrapper');
                var lang = $active_lang_selector.find('.li_selected').data('val');

                var lang_p = lang.split('-');
                var lang_to = lang_p[0];

                lang_to = lang_to == 'yue' ? 'zh' : lang_to;

                var $voice_preview_data = $(".voice_preview_data");
                var preview_txt_def = $voice_preview_data.data('preview_txt_def');
                var preview_txt_ready = preview_txt_def;

                var translate_callback = function(translated) {
                    var tr_item = translated[0];
                    $voice_preview_data.data('preview_txt_ready', tr_item);

                    thisPage.processVoiceWidgetSettings();
                };

                if(lang_to != 'en')
                    window.gspeech.doSmartTranslate('en', lang_to, [preview_txt_def], translate_callback);
                else {
                    $voice_preview_data.data('preview_txt_ready', preview_txt_def);
                    thisPage.processVoiceWidgetSettings();
                }

            },400);
        });

        $('body').on('click', '#wbs_w_voice_enabled .search_li', function() {

            if($(this).data("val") == 1) {

                var m_voice_sel = $("#voice_sel_wdg").find(".items_select_filter_content span").html();
                $("#wbs_w_multiple_voices").find(".items_select_ul").html($("#voice_sel_wdg").find(".items_select_ul").html());
                $("#wbs_w_multiple_voices").find(".items_select_filter_content span").html(m_voice_sel);
                $("#wbs_w_multiple_voices").removeClass("ss_disabled");
                $("#wbs_w_multiple_voices").find(".li_selected").addClass("ss_option_hardcoded");

                var ul_htm = $("#wbs_w_multiple_voices").find(".items_select_ul").html();

                $(".gsp_left_m_c_active .ss_tr_block_hardcoded").find(".items_select_filter_content span").html(m_voice_sel);
                $(".gsp_left_m_c_active .ss_tr_block_hardcoded").find(".items_select_ul").html(ul_htm);

                var lang_code = $("#lng_sel_wdg").find('.li_selected').data('val');

                // $("#wbs_w_multiple_voices").find(".search_li").each(function() {
            
                //     $(this).data("name_hash", $this.preview_audios[lang_code][$(this).data("val")]);
                // });
            }
            else {
                $("#wbs_w_multiple_voices").find(".items_select_ul").html("");
                $("#wbs_w_multiple_voices").find(".items_select_filter_content span").html($("#wbs_w_multiple_voices").data("def_txt"));
                $("#wbs_w_multiple_voices").addClass("ss_disabled");
            }
        });

        $('body').on('click', '#wbs_custom_val', function() {

            var website_plan = $("#ss_widget_page_data").data("website_plan");

            if($(this).hasClass("gs_mono_switcher_button_on")) {

                $(".ss_custom_values").removeClass("ss_display_none");

                var voice_en = $("#wbs_w_voice_enabled").find(".li_selected").data("val");
                if(voice_en == -1) { // global

                    var new_val = website_plan == 0 ? 0 : 1,
                        cont_val = "";

                    $("#wbs_w_voice_enabled").find(".li_selected").removeClass("li_selected").removeClass("ss_ul_li_act");
                    $("#wbs_w_voice_enabled").find(".search_li").each(function() {
                        var val = $(this).data("val");
                        if(val == new_val) {
                            cont_val = $(this).find("span").html();
                            $(this).addClass("li_selected").addClass("ss_ul_li_act").trigger("click");
                            return;
                        }
                    });
                    $("#wbs_w_voice_enabled").find('.items_select_filter_content span').html(cont_val);
                }

                var lang_en = $("#wbs_w_langs_enabled").find(".li_selected").data("val");
                if(lang_en == -1) { // global

                    var new_val = website_plan == 0 ? 0 : 1,
                        cont_val = "";

                    $("#wbs_w_langs_enabled").find(".li_selected").removeClass("li_selected").removeClass("ss_ul_li_act");
                    $("#wbs_w_langs_enabled").find(".search_li").each(function() {
                        var val = $(this).data("val");
                        if(val == new_val) {
                            cont_val = $(this).find("span").html();
                            $(this).addClass("li_selected").addClass("ss_ul_li_act").trigger("click");
                            return;
                        }
                    });

                    $("#wbs_w_langs_enabled").find('.items_select_filter_content span').html(cont_val);
                }

                $(".gsp_left_m_c_active .ss_li_donotglobal").addClass("ss_disabled");
            }
            else {
                $(".gsp_left_m_c_active .ss_custom_values").addClass("ss_display_none");
                $(".gsp_left_m_c_active .ss_li_donotglobal").removeClass("ss_disabled");
            }

            thisPage.generateWrapperHeight();
        });

        $('body').on('click', '#wbs_w_langs_enabled .search_li', function() {

            if($(this).hasClass("ss_disabled"))
                return;

            if($(this).data("val") == 1) {
                $("#ss_w_translation_options").removeClass("ss_display_none");
                thisPage.generateWrapperHeight();
            }
            else {
                $("#ss_w_translation_options").addClass("ss_display_none");
                thisPage.generateWrapperHeight();
            }
        });

        $('body').on("click", ".ss_tab_link_general", function() {

            thisPage.resetPlayerWidgetSettings();
        });

        $('body').on("blur", "#ss_width", function() {

            thisPage.resetPlayerWidgetPreview();

            thisPage.generateWrapperHeight();
        });

        $('body').on("click", "#wbs_template .search_li", function() {

            if($(this).hasClass("li_selected"))
                return;

            var template_val = $(this).data("val");

            $("#ss_template_blocks_wrapper").find(".ss_tmp_selected").removeClass("ss_tmp_selected");
            $("#ss_template_blocks_wrapper").find(".ss_tmp_block").each(function() {
                if($(this).data("block_id") == template_val) {
                    $(this).addClass("ss_tmp_selected");

                    return false;
                }
            });

            setTimeout(function(){
                thisPage.resetPlayerWidgetPreview();
            }, 11);
        });

        $('body').on("click", ".ss_tmp_block", function() {

            if($(this).hasClass("ss_tmp_selected")) {
                thisPage.shake($(this));
                return;
            }

            var template_val = $(this).data("block_id");

            $("#ss_template_blocks_wrapper").find(".ss_tmp_selected").removeClass("ss_tmp_selected");
            $(this).addClass("ss_tmp_selected");

            $("#wbs_template").find(".li_selected").removeClass("li_selected").removeClass("ss_ul_li_act");
            var l_val = "";
            $("#wbs_template").find(".search_li").each(function() {
                if($(this).data("val") == template_val) {
                    $(this).addClass("li_selected").addClass("ss_ul_li_act");
                    l_val = $(this).find("span").html();
                    return false;
                }
            });
            $("#wbs_template").find(".items_select_filter_content span").html(l_val);

            setTimeout(function(){
                thisPage.resetPlayerWidgetPreview();
            }, 11);
        });

        $('body').on("click", "#wbs_bg_class .search_li", function() {

            if($(this).hasClass("li_selected"))
                return;

            setTimeout(function(){
                thisPage.resetPlayerWidgetPreview();
            }, 11);
        });

        // 3.7.0
        $("body").on("click", "#ss_plr0_soundcloud_enabled", function() {

            var $this_mono = $(this);

            $("#ss_plr0_newyork_enabled").removeClass("gs_mono_switcher_button_on");

            setTimeout(function() {

                var mono_checked = $this_mono.hasClass("gs_mono_switcher_button_on") ? true : false;

                if(mono_checked) {
                    $('.ss_full_player_preview').find('.ssplayer_wrapper').removeClass("ss_gsp_newyork");
                    $('.ss_full_player_preview').find('.ssplayer_wrapper').addClass("ss_HHdeJah3hKe3Drjp");
                }
                else {
                    $('.ss_full_player_preview').find('.ssplayer_wrapper').removeClass("ss_HHdeJah3hKe3Drjp");
                }

                setTimeout(function() {

                    thisPage.regeneratePlayerBar();

                }, 10);

            }, 20);

            thisPage.generateWrapperHeight();

        });

        // 3.9.0
        $("body").on("click", "#ss_plr0_newyork_enabled", function() {

            var $this_mono = $(this);

            $("#ss_plr0_soundcloud_enabled").removeClass("gs_mono_switcher_button_on");

            $("#ss_plr0_hide_header").removeClass("gs_mono_switcher_button_on");
            $('.ss_full_player_preview').find('.ssplayer_wrapper').removeClass("ss_no_header");

            setTimeout(function() {

                var mono_checked = $this_mono.hasClass("gs_mono_switcher_button_on") ? true : false;

                if(mono_checked) {
                    $('.ss_full_player_preview').find('.ssplayer_wrapper').removeClass("ss_HHdeJah3hKe3Drjp");
                    $('.ss_full_player_preview').find('.ssplayer_wrapper').addClass("ss_gsp_newyork");
                }
                else {
                    $('.ss_full_player_preview').find('.ssplayer_wrapper').removeClass("ss_gsp_newyork");
                }

                setTimeout(function() {

                    thisPage.regeneratePlayerBar();

                }, 10);

            }, 20);

            thisPage.generateWrapperHeight();

        });

        // 3.9.0
        $("body").on("click", "#ss_plr0_np_hidden", function() {

            var $this_mono = $(this);

            setTimeout(function() {

                var mono_checked = $this_mono.hasClass("gs_mono_switcher_button_on") ? true : false;

                if(mono_checked) {
                    $('.ss_full_player_preview').find('.ssplayer_wrapper').addClass("ss_no_np");
                }
                else {
                    $('.ss_full_player_preview').find('.ssplayer_wrapper').removeClass("ss_no_np");
                }

            }, 20);
        });

        // 3.7.0
        $("body").on("click", "#ss_plr0_play_style", function() {

            var $this_mono = $(this);

            setTimeout(function() {

                var mono_checked = $this_mono.hasClass("gs_mono_switcher_button_on") ? true : false;

                if(mono_checked) {
                    $('.ss_full_player_preview').find('.ssplayer_wrapper').addClass("ss_play_style_1");
                }
                else {
                    $('.ss_full_player_preview').find('.ssplayer_wrapper').removeClass("ss_play_style_1");
                }

            }, 20);
        });

        // 3.7.0
        $("body").on("click", "#ss_plr0_rounded_icons", function() {

            var $this_mono = $(this);

            setTimeout(function() {

                var mono_checked = $this_mono.hasClass("gs_mono_switcher_button_on") ? true : false;

                if(mono_checked) {
                    $('.ss_full_player_preview').find('.ssplayer_wrapper').addClass("ss_rounded_icons");
                }
                else {
                    $('.ss_full_player_preview').find('.ssplayer_wrapper').removeClass("ss_rounded_icons");
                }

            }, 20);
        });

        // 3.7.0
        $("body").on("click", "#ss_plr0_hide_header", function() {

            var $this_mono = $(this);

            setTimeout(function() {

                var mono_checked = $this_mono.hasClass("gs_mono_switcher_button_on") ? true : false;

                if(mono_checked) {
                    $('.ss_full_player_preview').find('.ssplayer_wrapper').addClass("ss_no_header");
                }
                else {
                    $('.ss_full_player_preview').find('.ssplayer_wrapper').removeClass("ss_no_header");
                }

                thisPage.generateWrapperHeight();

            }, 20);
        });

        // 3.7.0
        $("body").on("click", "#ss_plr0_no_bg", function() {

            var $this_mono = $(this);

            setTimeout(function() {

                var mono_checked = $this_mono.hasClass("gs_mono_switcher_button_on") ? true : false;

                if(mono_checked) {
                    $('.ss_full_player_preview').find('.ssplayer_wrapper').addClass("ss_no_bg");
                }
                else {
                    $('.ss_full_player_preview').find('.ssplayer_wrapper').removeClass("ss_no_bg");
                }

            }, 20);
        });

        // 3.7.0
        $("body").on("click", "#ss_plr0_np_style", function() {

            var $this_mono = $(this);

            setTimeout(function() {

                var mono_checked = $this_mono.hasClass("gs_mono_switcher_button_on") ? true : false;

                if(mono_checked) {
                    $('.ss_full_player_preview').find('.ssplayer_wrapper').addClass("ss_np_style_1");
                }
                else {
                    $('.ss_full_player_preview').find('.ssplayer_wrapper').removeClass("ss_np_style_1");
                }

            }, 20);
        });

        // 3.7.0
        $("body").on("click", "#ss_plr0_icons_bg", function() {

            var $this_mono = $(this);

            $("#ss_plr0_rounded_icons").addClass("gs_mono_switcher_button_on");
            $('.ss_full_player_preview').find('.ssplayer_wrapper').addClass("ss_rounded_icons");

            setTimeout(function() {

                var mono_checked = $this_mono.hasClass("gs_mono_switcher_button_on") ? true : false;

                if(mono_checked) {
                    $('.ss_full_player_preview').find('.ssplayer_wrapper').addClass("ss_bg_style_1");
                }
                else {
                    $('.ss_full_player_preview').find('.ssplayer_wrapper').removeClass("ss_bg_style_1");
                }

            }, 20);
        });

        $('body').on("click", ".ss_tab_link_design", function() {

            thisPage.makeStylesTabClick(true);

            
        });

        $('body').on("click", "#wbs_block_sub_type .search_li", function() {

            if($(this).hasClass("li_selected"))
                return;

            if(window.gspeech == undefined)
                return;

            var block_sub_type = $(this).data("val");
            var widget_id = 253;

            window.gspeech.options.ssblocks['ssblock_' + widget_id]["block_sub_type"] = block_sub_type;

            // run smart speech
            $(".ssblock").each(function(i) {
                var ssblock_id = $(this).data("id");
                $(".gsp_htm_processed_" + ssblock_id).removeClass("gsp_htm_processed_" + ssblock_id);
                $(this).remove();
            });
            $('.gsp_content_wrapper_set').removeClass("gsp_htm_processed").removeClass("gsp_content_wrapper_set");
            $(".sscontext_player").remove();
            $(".rht_banner_wrapper").remove();
            $(".ssplayer_rht").remove();
            $("#sscustom_rht").remove();
            window.gspeech.prepareSSBlocks();

            setTimeout(function(){
                thisPage.resetPlayerWidgetPreview();
            }, 11);

            var website_plan = parseInt($("#ss_widget_page_data").data("website_plan"));

            if(website_plan == 0 && (block_sub_type == 1 || block_sub_type == 2)) {

                setTimeout(function() {

                    thisPage.showMessage('error','To use this type, you should have translation and text panel enabled, which is available in commercial plans!', true, false);

                }, 600);
            }
        });

        $('body').on("click", "#wbs_show_rht", function() {

            var v = $(this).hasClass("gs_mono_switcher_button_on") ? 1 : 0;

            if(v == 1)
                $(".ss_rht_banner_info").removeClass("ss_display_none");
            else
                $(".ss_rht_banner_info").addClass("ss_display_none");

            thisPage.generateWrapperHeight();
        });

        $('body').on("click", "#wbs_rht_hide_size .search_li", function() {

            if($(this).hasClass("li_selected"))
                return;

            var v = $(this).data("val");

            if(v == 1)
                $(".ss_rht_custom_val_info").removeClass("ss_display_none");
            else
                $(".ss_rht_custom_val_info").addClass("ss_display_none");

            thisPage.generateWrapperHeight();
        });

        $('body').on("click", "#welcome_repeat_interval .search_li", function() {

            if($(this).hasClass("li_selected"))
                return;

            var v = $(this).data("val");

            if(v == 1)
                $(".ss_welcome_m_custom_info").removeClass("ss_display_none");
            else
                $(".ss_welcome_m_custom_info").addClass("ss_display_none");

            thisPage.generateWrapperHeight();
        });

        $('body').on("click", ".gsp_widgets_table .gsp_row", function() {

            var block_id = $(this).data("block_id");

            var new_hash = "#widgets-" + block_id;

            window.location.hash = new_hash;

            $(".gsp_left_m_c_widgets").removeClass("gsp_left_m_c_active");
            $(".gsp_left_m_c_widget").addClass("gsp_left_m_c_active");

            $('.gsp_left_m_c_active .opts_input').val('');

            // show general tab
            $('.gsp_left_m_c_active .dashboard_tab.ss_selected').removeClass('ss_selected');
            $('.gsp_left_m_c_active .dashboard_tab.ss_tab_link_general').addClass('ss_selected');

            $('.gsp_left_m_c_active .ss_tab_wrapper.ss_tab_active').removeClass('ss_tab_active');
            $('.gsp_left_m_c_active .ss_tab_wrapper.ss_tab_general').addClass('ss_tab_active');

            // set custom val to 0
            $("#wbs_custom_val").removeClass("gs_mono_switcher_button_on");
            $(".ss_custom_values").addClass("ss_display_none");

            var widget_id = thisPage.options.widget_id;

            thisPage.getWidgetData(widget_id, block_id);

            $('.gsp_left_menu_widgets').removeClass("gsp_reload_widgets");
        });

        $('body').on("click", ".gsp_audios_table .gsp_row", function() {

            thisPage.options.root_request = false;

            var audio_id = $(this).data("audio_id");

            var new_hash = "#audios-" + audio_id;

            window.location.hash = new_hash;

            $(".gsp_left_m_c_audios").removeClass("gsp_left_m_c_active");
            $(".gsp_left_m_c_audio").addClass("gsp_left_m_c_active");

            $('.gsp_left_m_c_active .opts_input').val('');

            var widget_id = thisPage.options.widget_id;

            thisPage.getAudioData(widget_id, audio_id);

            $('.gsp_left_menu_audios').removeClass("gsp_reload_audios");

            $("#ss_dash_audio_player").html('');
            $("#gsp_player_loading").removeClass("gsp_hidden");
        });

        // save widget settings
        $('body').on('click', '#ss_widget_settings_submit', function() {

            var widget_id = thisPage.options.widget_id;
            var gspeech_token = thisPage.getCookie('gspeech_token');

            var $ss_widget_title = $("#ss_widget_title");
            var ss_widget_title = $.trim($ss_widget_title.val());
            $ss_widget_title.val(ss_widget_title);

            var website_plan = parseInt($("#ss_widget_page_data").data("website_plan"));

            var form_validated = true;

            // title
            if(ss_widget_title.length < 2) {

                $ss_widget_title.addClass('ss_error');
                form_validated = false;
                $ss_widget_title.focus();
                thisPage.shake($ss_widget_title);
            }
            else {
                $ss_widget_title.removeClass('ss_error');
            }

            // get use_cutom
            var widget_use_custom = $("#wbs_custom_val").hasClass("gs_mono_switcher_button_on") ? 1 : 0;

            var banner_pos = $("#banner_pos").hasClass("gs_mono_switcher_button_on") ? 1 : 0,
                play_timeout = parseInt($("#ss_play_timeout").val()),
                welcome_repeat_interval = $("#welcome_repeat_interval").find(".li_selected").data("val"),
                welcome_repeat_interval_custom = parseInt($("#welcome_repeat_interval_custom").val());

            play_timeout = isNaN(play_timeout) ? 0 : play_timeout;
            welcome_repeat_interval_custom = isNaN(welcome_repeat_interval_custom) ? 2 : welcome_repeat_interval_custom;

            // get status
            var widget_status = $("#wbs_w_status").hasClass("gs_mono_switcher_button_on") ? 1 : 0;

            // get lang
            var ss_website_lang = $("#lng_sel_wdg").find(".li_selected").data("val");

            // get voice
            var ss_website_voice = "";
            if(!$("#voice_sel_wdg").find(".li_selected").length) {
                form_validated = false;
                $("#voice_sel_wdg").addClass("ss_error");
                thisPage.shake($("#voice_sel_wdg"));
            }
            else {
                $("#voice_sel_wdg").removeClass("ss_error");
                ss_website_voice = $("#voice_sel_wdg").find(".li_selected").data("val");
            }

            var ss_website_plan = $("#ss_widget_page_data").data("website_plan");

            // get pitch,speed
            var ss_website_speed = $("#gsp_w_slider_speed").find('.gsp_value_label').val();
            var ss_website_pitch = $("#gsp_w_slider_pitch").find('.gsp_value_label').val();

            // voice enabled
            var voice_enabled = $("#wbs_w_voice_enabled").find(".li_selected").data("val");

            // multiple voices
            var ss_website_multiple_voice = '';
            if(voice_enabled == 1 && !$("#wbs_w_multiple_voices").find(".li_selected").length) {
                form_validated = false;
                $("#wbs_w_multiple_voices").addClass("ss_error");
                thisPage.shake($("#wbs_w_multiple_voices"));
            }
            else {
                $("#wbs_w_multiple_voices").removeClass("ss_error");

                $("#wbs_w_multiple_voices").find(".li_selected").each(function() {

                    ss_website_multiple_voice += $(this).data("val") + ',';

                });
                ss_website_multiple_voice = ss_website_multiple_voice.slice(0, -1);
            }

            // appear class
            var ss_website_appear_class = $("#wbs_w_appear_class").find(".li_selected").data("val");

            // speed enabled
            var speed_enabled = $("#wbs_w_speed_enabled").find(".li_selected").data("val");

            // volume enabled
            var volume_enabled = $("#wbs_w_volume_enabled").find(".li_selected").data("val");

            // text enabled
            var text_enabled = $("#wbs_w_text_enabled").find(".li_selected").data("val");

            // download enabled
            var download_enabled = $("#wbs_w_download_enabled").find(".li_selected").data("val");

            // context enabled
            var context_enabled = $("#wbs_w_context_enabled").find(".li_selected").data("val");

            // plays enabled
            var plays_enabled = $("#wbs_w_plays_enabled").find(".li_selected").data("val");

            // lang enabled
            var lang_enabled = $("#wbs_w_langs_enabled").find(".li_selected").data("val");

            var ss_website_langs = "";
            if(lang_enabled == 1) {

                $("#ss_w_translation_options").find(".ss_checked").each(function() {

                    // website_options["sel_langs"] = "en-US|C-2,D-2,E-2,M-5;ru-RU|E-2,B-2,D-2";

                    var $lang_item = $(this).parents(".ss_translation_item");
                    var lang_val = $lang_item.data("val");
                    var lang_sel_voices = "";
                    var $voice_wrapper = $lang_item.find(".items_select_filter_wrapper");

                    var lang_bl = lang_val + '|';

                    if(!$voice_wrapper.find(".li_selected").length) {

                        form_validated = false;
                        $voice_wrapper.addClass("ss_error");
                        thisPage.shake($voice_wrapper);
                    }
                    else {

                        $voice_wrapper.find(".li_selected").each(function() {

                            lang_bl += $(this).data("val") + ',';
                        });

                        lang_bl = lang_bl.slice(0, -1);
                    }

                    ss_website_langs += lang_bl + ';';
                });

                ss_website_langs = ss_website_langs.slice(0, -1);
            }

            // Content section from TABS
            var content_selector = $.trim($("#ss_content_selector").val());
            $("#ss_content_selector").val(content_selector);

            var render_element = $.trim($("#ss_render_element").val());
            $("#ss_render_element").val(render_element);

            var render_pos = $("#wbs_render_pos").hasClass("gs_mono_switcher_button_on") ? 1 : 0;

            var auto_load = $("#wbs_auto_load").hasClass("gs_mono_switcher_button_on") ? 1 : 0;

            var soundcloud_enabled = $("#ss_plr0_soundcloud_enabled").hasClass("gs_mono_switcher_button_on") ? 1 : 0;
            var play_style = $("#ss_plr0_play_style").hasClass("gs_mono_switcher_button_on") ? 1 : 0;
            var np_style = $("#ss_plr0_np_style").hasClass("gs_mono_switcher_button_on") ? 1 : 0;
            var rounded_icons = $("#ss_plr0_rounded_icons").hasClass("gs_mono_switcher_button_on") ? 1 : 0;
            var rounded_icons_bg = $("#ss_plr0_icons_bg").hasClass("gs_mono_switcher_button_on") ? 1 : 0;
            var hide_header = $("#ss_plr0_hide_header").hasClass("gs_mono_switcher_button_on") ? 1 : 0;
            var no_bg = $("#ss_plr0_no_bg").hasClass("gs_mono_switcher_button_on") ? 1 : 0;

            // 3.9.0
            var newyork_enabled = $("#ss_plr0_newyork_enabled").hasClass("gs_mono_switcher_button_on") ? 1 : 0;
            var np_hidden = $("#ss_plr0_np_hidden").hasClass("gs_mono_switcher_button_on") ? 1 : 0;

            var exclude_list = $.trim($("#ss_exclude_list").val());
            $("#ss_exclude_list").val(exclude_list);

            var title_selector = $.trim($("#ss_player_title_selector").val());
            $("#ss_player_title_selector").val(title_selector);

            var title_text = $.trim($("#ss_player_title_text").val());
            $("#ss_player_title_text").val(title_text);

            var content_text = $("#ss_content_text").val().toLowerCase();
            $("#ss_content_text").val(content_text);

            var allowed_urls = $.trim($("#ss_allowed_urls").val());
            $("#ss_allowed_urls").val(allowed_urls);

            var blocked_urls = $.trim($("#ss_blocked_urls").val());
            $("#ss_blocked_urls").val(blocked_urls);

            var widget_width = $.trim($("#ss_width").val());
            $("#ss_width").val(widget_width);

            var widget_margin_top = $.trim($("#ss_margin_top").val());
            $("#ss_margin_top").val(widget_margin_top);

            var widget_margin_bottom = $.trim($("#ss_margin_bottom").val());
            $("#ss_margin_bottom").val(widget_margin_bottom);

            var widget_aliases = $.trim($("#ss_w_aliases").val());
            $("#ss_w_aliases").val(widget_aliases);

            //  block_sub_type
            var block_sub_type = parseInt($("#wbs_block_sub_type").find(".li_selected").data("val"));

            block_sub_type = website_plan == 0 ? 0 : block_sub_type;

            //  template
            var template = $("#wbs_template").find(".li_selected").data("val");

            //  template
            var bg_class = $("#wbs_bg_class").find(".li_selected").data("val");

            // texts
            var texts = '';
            texts += encodeURIComponent($("#ss_speed_text").val()) + ',';
            texts += encodeURIComponent($("#ss_lang_text").val()) + ',';
            texts += encodeURIComponent($("#ss_voice_text").val()) + ',';
            texts += encodeURIComponent($("#ss_plays_text").val()) + ',';
            texts += encodeURIComponent($("#ss_plays_title_text").val()) + ',';
            texts += encodeURIComponent($("#ss_download_text").val()) + ',';
            texts += encodeURIComponent($("#ss_downloaded_text").val()) + ',';
            texts += encodeURIComponent($("#ss_open_text_text").val()) + ',';
            texts += encodeURIComponent($("#ss_open_context_text").val()) + ',';
            texts += encodeURIComponent($("#ss_close_context_text").val()) + ',';
            texts += encodeURIComponent($("#ss_loading_text").val()) + ',';
            texts += encodeURIComponent($("#ss_play_text").val()) + ',';
            texts += encodeURIComponent($("#ss_pause_text").val()) + ',';
            texts += encodeURIComponent($("#ss_options_text").val()) + ',';
            texts += encodeURIComponent($("#ss_listen_text").val()) + ',';
            texts += encodeURIComponent($("#ss_close_text").val()) + ',';
            texts += encodeURIComponent($("#ss_listen_text_desc").val());

            // get rht banner info
            var show_rht = $("#wbs_show_rht").hasClass("gs_mono_switcher_button_on") ? 1 : 0,
                rht_pos_class = $("#wbs_rht_pos_class").find(".li_selected").data("val"),
                rht_hide_size = $("#wbs_rht_hide_size").find(".li_selected").data("val"),
                rht_hide_size_custom = $("#wbs_rht_hide_size_custom").val(),
                rht_ic_pos = $("#wbs_rht_icon_pos").hasClass("gs_mono_switcher_button_on") ? 1 : 0;

            var $ss_rht_icon_top_offset = $("#ss_rht_icon_top_offset");
            var ss_rht_icon_top_offset = $.trim($ss_rht_icon_top_offset.val());
            ss_rht_icon_top_offset = ss_rht_icon_top_offset == '' ? '15%' : ss_rht_icon_top_offset;
            $ss_rht_icon_top_offset.val(ss_rht_icon_top_offset);

            if(form_validated) {

                var form_data = "ss_widget_title=" + encodeURIComponent(ss_widget_title);
                form_data += "&widget_use_custom=" + widget_use_custom;
                form_data += "&lang=" + ss_website_lang;
                form_data += "&voice=" + ss_website_voice;
                form_data += "&speed=" + ss_website_speed;
                form_data += "&pitch=" + ss_website_pitch;
                form_data += "&voice_enabled=" + voice_enabled;
                form_data += "&sel_voices=" + ss_website_multiple_voice;
                form_data += "&appear_class=" + ss_website_appear_class;
                form_data += "&speed_enabled=" + speed_enabled;
                form_data += "&volume_enabled=" + volume_enabled;
                form_data += "&text_enabled=" + text_enabled;
                form_data += "&download_enabled=" + download_enabled;
                form_data += "&context_enabled=" + context_enabled;
                form_data += "&plays_enabled=" + plays_enabled;
                form_data += "&lang_enabled=" + lang_enabled;
                form_data += "&sel_langs=" + ss_website_langs;
                form_data += "&status=" + widget_status;

                form_data += "&content_selector=" + content_selector;
                form_data += "&render_element=" + render_element;
                form_data += "&render_pos=" + render_pos;
                form_data += "&exclude_list=" + exclude_list;
                form_data += "&title_selector=" + title_selector;
                form_data += "&title_text=" + encodeURIComponent(title_text);
                form_data += "&content_text=" + encodeURIComponent(content_text);
                form_data += "&allowed_urls=" + encodeURIComponent(allowed_urls);
                form_data += "&blocked_urls=" + encodeURIComponent(blocked_urls);

                form_data += "&texts=" + texts;
                form_data += "&aliases=" + encodeURIComponent(widget_aliases);

                form_data += "&width=" + widget_width;
                form_data += "&margin_top=" + widget_margin_top;
                form_data += "&margin_bottom=" + widget_margin_bottom;

                form_data += "&block_sub_type=" + block_sub_type;
                form_data += "&template=" + template;
                form_data += "&bg_class=" + bg_class;

                form_data += "&auto_load=" + auto_load;

                form_data += "&soundcloud_enabled=" + soundcloud_enabled;
                form_data += "&play_style=" + play_style;
                form_data += "&np_style=" + np_style;
                form_data += "&rounded_icons=" + rounded_icons;
                form_data += "&rounded_icons_bg=" + rounded_icons_bg;
                form_data += "&hide_header=" + hide_header;
                form_data += "&no_bg=" + no_bg;

                form_data += "&newyork_enabled=" + newyork_enabled;
                form_data += "&np_hidden=" + np_hidden;

                form_data += "&show_rht=" + show_rht;
                form_data += "&rht_pos_class=" + rht_pos_class;
                form_data += "&rht_hide_size=" + rht_hide_size;
                form_data += "&rht_hide_size_custom=" + rht_hide_size_custom;

                form_data += "&banner_pos=" + banner_pos;
                form_data += "&play_timeout=" + play_timeout;
                form_data += "&welcome_repeat_interval=" + welcome_repeat_interval;
                form_data += "&welcome_repeat_interval_custom=" + welcome_repeat_interval_custom;

                form_data += "&rht_ic_pos=" + rht_ic_pos;
                form_data += "&rht_ic_to=" + encodeURIComponent(ss_rht_icon_top_offset);

                var tts_url = thisPage.options.tts_url,
                    ajax_id = 'update_widget_settings_connection';

                var hash = window.location.hash;
                hash = hash == '' ? '#settings' : hash;

                var hash_pieces = hash.split('-');
                var hash_0 = hash_pieces[0];
                var hash_1 = hash_pieces[1] != undefined ? parseInt(hash_pieces[1]) : 0;

                var post_data = {
                    'ajax_id':ajax_id,
                    'token':gspeech_token,
                    'widget_id':widget_id,
                    'block_id':hash_1,
                    'form_data':form_data
                };

                thisPage.showLoading();
                thisPage.showOverlay();

                $.ajax({
                    type: 'POST',
                    url: tts_url + '/ajax',
                    crossDomain: true,
                    data: post_data,
                    dataType: 'json',
                    success: function(responseData, textStatus, jqXHR) {

                        thisPage.hideOverlay();
                        thisPage.hideLoading();

                        var result = responseData['success'];
                        var message = responseData['message'];
                        if(result == 'true') {

                            thisPage.showMessage('success','Settings have been updated successfully.');

                            // if(window.gspeech != undefined)
                                // window.gspeech.doSmartSpeech('Settings have been updated successfully.', 'en-US');
                        }
                        else {
                            thisPage.showMessage('error','Error!');

                            // if(window.gspeech != undefined)
                                // window.gspeech.doSmartSpeech('Error!', 'en-US');

                            thisPage.shake($("#dashboard_content"), {'shakes': 2,'distance': 10,'duration': 300});
                        }
                    },
                    error: function (responseData, textStatus, errorThrown) {

                        thisPage.hideOverlay();
                        thisPage.hideLoading();

                        thisPage.showMessage('error','Error saving settings!');

                        // if(window.gspeech != undefined)
                            // window.gspeech.doSmartSpeech('Error saving settings!', 'en-US');
                    }
                });

                // increase version index
                var post_data_inner = {
                    action: 'wpgsp_apply_ajax_save',
                    _ajax_nonce: wp_ajax_nonce,
                    type: 'increase_index'
                };
                $.ajax
                ({
                    url: wp_ajax_url,
                    type: "post",
                    data: post_data_inner,
                    dataType: "json",
                    success: function(data) {
                        
                    },
                    error: function(xhr, status, error) {
                        
                    }
                });
            }
            else {

                thisPage.shake($(this));
            }
        });

        // delete widget
        $('body').on('click', '#ss_widget_delete', function(e){

            var widget_id = thisPage.options.widget_id;
            var gspeech_token = thisPage.getCookie('gspeech_token');
            var tts_url = thisPage.options.tts_url;

            var hash = window.location.hash;
            hash = hash == '' ? '#settings' : hash;
            hash = hash.replace('#','');

            var hash_pieces = hash.split('-');
            var hash_0 = hash_pieces[0];
            var hash_1 = hash_pieces[1] != undefined ? parseInt(hash_pieces[1]) : 0;

            var deleteWidget = function(block_id) {

                thisPage.hideMessage(true);
            
                setTimeout(function() {

                    thisPage.showLoading();
                    thisPage.showOverlay();

                    var ajax_id = 'delete_widget_connection';

                    var post_data = {
                        'ajax_id':ajax_id,
                        'widget_id':widget_id,
                        'block_id':block_id,
                        'token':gspeech_token
                    };

                    $.ajax({
                        type: 'POST',
                        url: tts_url + '/ajax',
                        crossDomain: true,
                        data: post_data,
                        dataType: 'json',
                        success: function(responseData, textStatus, jqXHR) {

                            // thisPage.hideOverlay();
                            thisPage.hideLoading();

                            thisPage.showMessage('success','Widget has been deleted successfully!', false, true);

                            // if(window.gspeech != undefined)
                                // window.gspeech.doSmartSpeech('Widget has been deleted successfully.', 'en-US');

                            setTimeout(function() {

                                thisPage.resetTable();

                                // show widgetс page
                                $('.gsp_left_m_c_widget').removeClass('gsp_left_m_c_active');
                                $('.gsp_left_m_c_widgets').addClass('gsp_left_m_c_active');

                                thisPage.getWidgetsData(widget_id);

                                $('.gsp_left_menu_widgets').removeClass('gsp_reload_widgets');

                                window.location.hash = '#widgets';

                            }, 2000);
                        },
                        error: function (responseData, textStatus, errorThrown) {

                            thisPage.hideOverlay();
                            thisPage.hideLoading();

                            thisPage.showMessage('error','Error deleting widget!');
                        }
                    });
                },300);
            };

            var options = {
                'sub_title': '<div style="margin-top: 7px;">Are you sure you want to delete widget?</div><div style="margin-top: 10px;font-size: 13px;">This will delete all data associated to it!</div>',
                'button_1_txt': 'CANCEL',
                'button_2_txt': 'DELETE',
                'button_2_class': 'cmf-red',
                'item_id': hash_1,
                'callback_function': deleteWidget
            };
            thisPage.showMessage('','Delete Widget',true,true,true,options);

            return;
        });

        // Add Widget Section /////////////////////////////////////////////////////

        var $add_widget_popup = $(".add_new_widget_popup_wrapper");
        $add_widget_popup.addClass('moved_to_top');
        $('body').append($add_widget_popup);

        // validate title
        $('body').on('blur', '.add_new_widget_title', function(e) {
            var widget_title = $.trim($(this).val());

            // trim value
            $(this).val(widget_title);

            if(widget_title.length < 2) {
                $(this).addClass('error');
                thisPage.shake($(this));
            }
            else {
                $(this).removeClass('error');
            }
        });

        // submit form
        $('body').on('click', '.add_new_widget_button', function(e){

            var $widget_title = $(".add_new_widget_title"),
                widget_title_val = $widget_title.val(),
                $block_type = $("#add_widget_type"),
                block_type_val = $("#add_widget_type").find(".li_selected").data("val"),
                form_validated = true;

            // validate title
            if(widget_title_val.length < 2) {
                form_validated = false;
                $widget_title.addClass('error');
                $widget_title.focus();
            }
            else {
                $widget_title.removeClass('error');
            }

            // validate block type
            if(block_type_val == undefined) {
                $block_type.addClass('ss_error');
                thisPage.shake($block_type);
                form_validated = false;
            }

            if(form_validated) {

                var tts_url = thisPage.options.tts_url;
                var options = '';

                var gspeech_token = thisPage.getCookie('gspeech_token');
                var widget_id = thisPage.options.widget_id;

                var add_widget = function() {

                    var ajax_id = 'add_widget_connection';

                    var post_data = {
                        'ajax_id':ajax_id,
                        'token':gspeech_token,
                        'widget_name':widget_title_val,
                        'block_type':block_type_val,
                        'widget_id':widget_id
                    };

                    $(".add_new_widget_popup_wrapper").addClass('z_index_low');
                    thisPage.showLoading();

                    $.ajax({
                        type: 'POST',
                        url: tts_url + '/ajax',
                        crossDomain: true,
                        data: post_data,
                        dataType: 'json',
                        success: function(responseData, textStatus, jqXHR) {

                            var result = responseData.success;
                            if(result == 'true') {

                                hide_add_widget_popup(false);

                                thisPage.hideOverlay();
                                thisPage.hideLoading();

                                setTimeout(function() {
                                    $(".add_new_widget_popup_wrapper").removeClass('z_index_low');
                                }, 300);

                                var block_id = responseData.widget_id;

                                var new_hash = "#widgets-" + block_id;
                                window.location.hash = new_hash;

                                // show widget page
                                $('.gsp_left_m_c_widgets').removeClass('gsp_left_m_c_active');
                                $('.gsp_left_m_c_widget').addClass('gsp_left_m_c_active');

                                // clear vals
                                $('.gsp_left_m_c_active .opts_input').val('');

                                // show general tab
                                $('.gsp_left_m_c_active .dashboard_tab.ss_selected').removeClass('ss_selected');
                                $('.gsp_left_m_c_active .dashboard_tab.ss_tab_link_general').addClass('ss_selected');

                                $('.gsp_left_m_c_active .ss_tab_wrapper.ss_tab_active').removeClass('ss_tab_active');
                                $('.gsp_left_m_c_active .ss_tab_wrapper.ss_tab_general').addClass('ss_tab_active');

                                // set custom val to 0
                                $("#wbs_custom_val").removeClass("gs_mono_switcher_button_on");
                                $(".ss_custom_values").addClass("ss_display_none");

                                thisPage.getWidgetData(widget_id, block_id);

                                $('.gsp_left_menu_widgets').addClass('gsp_reload_widgets');
                            }
                            else {

                                thisPage.hideOverlay();
                                thisPage.hideLoading();
                                thisPage.showMessage('error','Error adding widget!');
                            }
                        },
                        error: function (responseData, textStatus, errorThrown) {

                            thisPage.hideOverlay();
                            thisPage.hideLoading();
                            thisPage.showMessage('error','Error adding widget!');
                        }
                    });
                };

                add_widget();
            }
            else {
                thisPage.shake($("#add_new_widget_popup_inner"), {'shakes': 2,'distance': 10,'duration': 300});
            }
        });

        function show_add_widget_popup() {

            $(".add_new_widget_popup_wrapper").addClass('vis');

            setTimeout(function() {
                $(".add_new_widget_popup_wrapper").addClass('visible');
                $(".add_new_widget_popup_wrapper").removeClass('vis');
            }, 20);

            $('.add_new_widget_title').focus();

            thisPage.showOverlay();
        };

        function hide_add_widget_popup(hideOverlay) {

            if($('.add_new_widget_popup_wrapper').hasClass('visible')) {

                $('.add_new_widget_popup_wrapper').addClass('vis');
                $('.add_new_widget_popup_wrapper').removeClass('visible');

                setTimeout(function() {
                    $('.add_new_widget_popup_wrapper').removeClass('vis');

                    // reset inputs
                    $('.add_new_widget_title').removeClass('error').val('');

                    if(hideOverlay)
                        thisPage.hideOverlay();

                },300);
            }
        };

        // events
        $('body').on("click", ".add_widget_event_holder", function() {

            var widgets_count = parseInt($('.add_new_widget_popup_wrapper').data('widgets_count'));
            if(widgets_count >= 1000) {

                var w_message = '<div style="margin-top: 8px;text-align: center;color: #090909;margin-bottom: 20px;font-size: 22px;">Info</div>';
                    w_message += '<div style="font-size: 16px;text-align: center;margin-bottom: 5px;">Each website can have up to 1000 widgets!</div>';
                thisPage.showMessage('',w_message, true, true);

                return false;
            }

            show_add_widget_popup();
        });

        $('body').on('click', '.add_shortcode_widgets_event_holder', function(e){

            var widget_id = thisPage.options.widget_id;
            var gspeech_token = thisPage.getCookie('gspeech_token');
            var tts_url = thisPage.options.tts_url;

            var hash = window.location.hash;
            hash = hash == '' ? '#settings' : hash;
            hash = hash.replace('#','');

            var hash_pieces = hash.split('-');
            var hash_0 = hash_pieces[0];
            var hash_1 = hash_pieces[1] != undefined ? parseInt(hash_pieces[1]) : 0;

            var addWidgets = function(widget_id) {

                thisPage.registerShortcodeWisgets(widget_id, 1);
            };

            var options = {
                'sub_title': '<div style="margin-top: 7px;">This will load 3 widgets!</div><div style="margin-top: 10px;font-size: 13px;">Just yse [gspeech] shortcode.</div>',
                'button_1_txt': 'CANCEL',
                'button_2_txt': 'LOAD',
                'button_2_class': 'cmf-green',
                'item_id': widget_id,
                'callback_function': addWidgets
            };
            thisPage.showMessage('','Load Shortcode Widgets',true,true,true,options);

            return;
        });

        $('body').on("click", "#close_add_new_widget_wrapper", function() {
            hide_add_widget_popup(true);
        });
        $('body').on("click", ".cancel_new_widget_button", function() {
            hide_add_widget_popup(true);
        });

        $('body').on('click', '.gsp_body_overlay', function() {
            hide_add_widget_popup(true);
        });

        // init left submenуs
        thisPage.initLeftSubMenus('toplevel_page_gspeech');

        // faq
        $('body').on('click', '.gsp_tab_faq', function() {

            if($(this).hasClass("faq_ninited"))
                return;

            thisPage.initFaq();

            $(this).addClass("faq_ninited");
        });

        $("body").on("click", ".gsp_tab_website_settings", function() {

            
        });

    };

    // back,forward functionality
    window.onpopstate = function() {

       thisPage.makeBackForward();
    };

    // naviagte menus/tabs
    $("body").on("click", ".gsp_naviagte_item", function() {

        if($(this).hasClass("gsp_tab_selected"))
            return;
        
        var menu_ident = $(this).data("menu_ident");

        if(menu_ident == '' || menu_ident == undefined)
            return;

        var $left_menu_a = $('.gsp_submenu_' + menu_ident);

        $('.gsp_left_menus_wrapper').find('li.current').removeClass('current');

        $left_menu_a.parent('li').addClass("current");

        var href = window.location.href;
        var href_id = "page=";
        var href_0 = href.split(href_id)[0];
        var href_new = href_0 + href_id + menu_ident;

        window.history.pushState({}, '', href_new);

        var page_title = thisPage.getTitle(menu_ident);

        $(document).prop('title',page_title);

    });

    this.makeStylesTabClick = function(checkLoaded) {

        if(!$('.ss_tab_link_design').hasClass("ss_selected"))
            return;

        if(checkLoaded)
            if(window.gspeech == undefined)
                    return;

        var block_sub_type = $("#wbs_block_sub_type").find(".li_selected").data("val");
        var widget_id = 253;

        window.gspeech.options.ssblocks['ssblock_' + widget_id]["block_sub_type"] = block_sub_type;

        // run smart speech
        $(".ssblock").each(function(i) {
            var ssblock_id = $(this).data("id");
            $(".gsp_htm_processed_" + ssblock_id).removeClass("gsp_htm_processed_" + ssblock_id);
            $(this).remove();
        });
        $('.gsp_content_wrapper_set').removeClass("gsp_htm_processed").removeClass("gsp_content_wrapper_set");
        $(".sscontext_player").remove();
        $(".rht_banner_wrapper").remove();
        $(".ssplayer_rht").remove();
        $("#sscustom_rht").remove();

        window.gspeech.prepareSSBlocks();

        setTimeout(function(){
            thisPage.resetPlayerWidgetPreview();
        }, 11);

        // 3.7.0
        setTimeout(function() {

            if($("#ss_plr0_newyork_enabled").hasClass("gs_mono_switcher_button_on")) {

                $('.ss_full_player_preview').find('.ssplayer_wrapper').addClass("ss_gsp_newyork");

                thisPage.generateWrapperHeight();
            }
            else {

                if($("#ss_plr0_soundcloud_enabled").hasClass("gs_mono_switcher_button_on")) {

                    $('.ss_full_player_preview').find('.ssplayer_wrapper').addClass("ss_HHdeJah3hKe3Drjp");

                    setTimeout(function() {

                        thisPage.regeneratePlayerBar();

                    }, 10);

                    thisPage.generateWrapperHeight();
                }
            }

            if($("#ss_plr0_play_style").hasClass("gs_mono_switcher_button_on"))
                $('.ss_full_player_preview').find('.ssplayer_wrapper').addClass("ss_play_style_1");

            if($("#ss_plr0_rounded_icons").hasClass("gs_mono_switcher_button_on"))
                $('.ss_full_player_preview').find('.ssplayer_wrapper').addClass("ss_rounded_icons");

            if($("#ss_plr0_hide_header").hasClass("gs_mono_switcher_button_on")) {
                $('.ss_full_player_preview').find('.ssplayer_wrapper').addClass("ss_no_header");

                thisPage.generateWrapperHeight();
            }

            if($("#ss_plr0_np_hidden").hasClass("gs_mono_switcher_button_on"))
                $('.ss_full_player_preview').find('.ssplayer_wrapper').addClass("ss_no_np");

            if($("#ss_plr0_no_bg").hasClass("gs_mono_switcher_button_on"))
                $('.ss_full_player_preview').find('.ssplayer_wrapper').addClass("ss_no_bg");

            if($("#ss_plr0_np_style").hasClass("gs_mono_switcher_button_on"))
                $('.ss_full_player_preview').find('.ssplayer_wrapper').addClass("ss_np_style_1");

            if($("#ss_plr0_icons_bg").hasClass("gs_mono_switcher_button_on"))
                $('.ss_full_player_preview').find('.ssplayer_wrapper').addClass("ss_bg_style_1");

            thisPage.initSSCarousel();

        }, 800);

    };

    this.getTitle = function(ident) {

        var title_start = 'GSpeech - ';
        var site_name = $("#gsp_site_name").html();
        var title_end = ' - ' + site_name + ' - WordPress';
        var title_middle = '';
        switch(ident) {
            case 'gspeech':
                title_middle = 'Dashboard';
                break;
            case 'gspeech_2x':
                title_middle = '2.X';
                break;
            case 'gspeech_faq':
                title_middle = 'FAQ';
                break;
            case 'gspeech_upgrade':
                title_middle = 'Upgrade';
                break;
            case 'gspeech_cloud_console':
                title_middle = 'Cloud Console';
                break;
        }

        var title = title_start + title_middle + title_end;

        return title;
    };

    this.initLeftSubMenus = function(menu_ident) {

        $("#" + menu_ident).addClass('gsp_left_menus_wrapper').find('a').each(function() {

            // e.preventDefault();

            var href = $(this).attr("href");

            var page_ = href.split('page=')[1];

            $(this).addClass("gsp_left_submenu").addClass("gsp_submenu_" + page_).data("page",page_);
        });

        $('.gsp_left_submenu').on("click", function(e) {

            // e.preventDefault();

            var page_ = $(this).data("page");

            if(page_ == 'gspeech_contact_us')
                return;
        });
    };

    this.makeBackForward = function() {

        var href = window.location.href;
        var href_id = "page=";
        var menu_ident = href.split(href_id)[1];

        var $left_menu_a = $('.gsp_submenu_' + menu_ident);

        $('.gsp_left_menus_wrapper').find('li.current').removeClass('current');

        $left_menu_a.parent('li').addClass("current");

        var page_title = thisPage.getTitle(menu_ident);

        $(document).prop('title',page_title);

        $tab_item = $('.menu_ident_' + menu_ident);

        if($tab_item.length) {

            var tab_ident = $tab_item.data("tab_ident");

            if(tab_ident != '' && tab_ident != undefined) {

                $(".gsp_tab_selected").removeClass("gsp_tab_selected");
                $(".gsp_tab_" + tab_ident).addClass("gsp_tab_selected");

                $(".gsp_tab_c.gsp_tab_active").removeClass("gsp_tab_active");
                $(".gsp_tab_c_" + tab_ident).addClass("gsp_tab_active");

                if(tab_ident == 'old_basic') {
                    $(".gsp_submit_button").removeClass("gsp_hidden");
                    $("#gsp_form").removeClass("submit_disabled");
                }
                else {
                    $(".gsp_submit_button").addClass("gsp_hidden")
                    $("#gsp_form").addClass("submit_disabled");
                }
            }
        }
    };

    this.initFaq = function() {

        setTimeout(function() {

            $(".gsp_faq_item").each(function() {

                var $b = $(this).find('.gsp_faq_body_inner');
                var h = parseInt($b.css('height'));

                $b.data('h', h);
            });
        }, 600);

        $('body').on('click', '.gsp_faq_header', function() {

            var $faq_wrapper = $(this).parents('.gsp_faq_items_wrapper');
            var $faq_li = $(this).parents('.gsp_faq_item');
            var h = $faq_li.find('.gsp_faq_body_inner').data('h');

            if($faq_li.hasClass("gsp_faq_opened")) {

                $faq_li.removeClass("gsp_faq_opened");
                $faq_li.find('.gsp_faq_body').height("0px");
            }
            else {

                $faq_wrapper.find('.gsp_faq_opened').removeClass('gsp_faq_opened').find('.gsp_faq_body').height("0px");
                $faq_li.addClass("gsp_faq_opened");
                $faq_li.find('.gsp_faq_body').height(h);
            }
        });
    };

    // 3.7.0
    this.initSSCarousel = function() {

        if(!$('.ss_carousel_wrapper').length)
            return;

        $('.ss_carousel_wrapper').each(function() {

            $carousel = $(this);

            init_carousel($carousel);
        });

        function init_carousel($car) {

            if($car.data("processed") == "1")
                return;

            var $inner = $car.find(".ss_carousel_inner");
            var $left = $car.find(".ss_carousel_arrow_left");
            var $right = $car.find(".ss_carousel_arrow_right");

            // connect to ss select
            var connection_id = $car.data("connection_id");
            var $ss_select = $("#" + connection_id);

            var car_sel_item_order = 0;
            var sel_index = '';
            if($ss_select.length) {
                sel_index = $ss_select.find(".li_selected").data("val");

                $ss_select.find(".search_li").each(function() {

                    var val = $(this).data("val");
                    var val_cl = 'ss_sel_val_' + val;
                    $(this).addClass(val_cl);

                });
            }

            // set carousel processed
            $car.data("processed","1");

            // calculate margin
            var inner_w = $inner.width();

            var items_count = parseInt($inner.find(".ss_carousel_item").length);

            var item_w = parseInt($inner.find(".ss_carousel_item").width());
            item_w += 2;

            var visible_items = parseInt(inner_w / item_w);
            var visible_items_m1 = visible_items - 1;
            var visible_w = visible_items * item_w;
            var w_delta = inner_w - visible_w;
            var item_margin = w_delta / visible_items_m1;

            $inner.find(".ss_carousel_item").css("margin-right", item_margin);

            // make orders
            $inner.find(".ss_carousel_item").each(function(i) {

                var item_order = i;
                var item_class = "ss_item_" + item_order;

                var item = $(this).data("item");
                var item_class_par = 'ss_item_par_' + item;

                $(this).addClass(item_class);
                $(this).addClass(item_class_par);
                $(this).data("item_order", item_order);

                if(sel_index != '' && item == sel_index) {
                    $car.find(".ss_carousel_selected").removeClass("ss_carousel_selected");
                    $(this).addClass("ss_carousel_selected");

                    car_sel_item_order = item_order;
                }
            });

            var pages_count = Math.ceil(items_count / visible_items) - 1;

            var current_page = 0;

            $car.data("w", inner_w);
            $car.data("current_page", current_page);
            $car.data("pages_count", pages_count);
            $car.data("visible_items", visible_items);
            $car.data("items_count", items_count);
            $car.data("items_count", items_count);
            $car.data("item_w", item_w);
            $car.data("item_margin", item_margin);

            $right.on("click", function() {

                move_carousel($car, 'right');
            });

            $left.on("click", function() {

                move_carousel($car, 'left');
            });

            // move to right page
            move_carousel_page($car, car_sel_item_order);

            // click event
            $car.find(".ss_carousel_item").on("click", function() {

                if($(this).hasClass("ss_carousel_selected"))
                    return;

                $car.find(".ss_carousel_selected").removeClass("ss_carousel_selected");
                $(this).addClass("ss_carousel_selected");

                var item = $(this).data("item");

                if($ss_select.length) {

                    $ss_select.find(".li_selected").removeClass("li_selected").removeClass("ss_ul_li_act");

                    $ss_select.find(".ss_sel_val_" + item).addClass("li_selected").addClass("ss_ul_li_act")
                    var l_val = $ss_select.find(".ss_sel_val_" + item).find("span").html();
                    $ss_select.find(".items_select_filter_content span").html(l_val);

                    setTimeout(function(){
                        thisPage.resetPlayerWidgetPreview();
                    }, 11);
                }

            });

            // ss select chamnge connection to carousel
            if($ss_select.length) {

                $ss_select.find(".search_li").on("click", function() {

                    if($(this).hasClass("li_selected"))
                        return;

                    var item = $(this).data("val");

                    var $car_item = $car.find(".ss_item_par_" + item);

                    if($car_item.length) {

                        var item_order = $car_item.data("item_order");

                        $car_item.find('.ss_carousel_selected').removeClass("ss_carousel_selected");
                        $car_item.addClass("ss_carousel_selected");

                        move_carousel_page($car, item_order);
                    }

                });
            }

        }

        function move_carousel_page($car, active_item) {

            var $inner_row = $car.find(".ss_carousel_inner_row");
            var $left = $car.find(".ss_carousel_arrow_left");
            var $right = $car.find(".ss_carousel_arrow_right");

            var w = $car.data("w");
            var current_page = $car.data("current_page");
            var pages_count = $car.data("pages_count");
            var visible_items = $car.data("visible_items");
            var items_count = $car.data("items_count");
            var item_margin = $car.data("item_margin");
            var item_w = $car.data("item_w");

            active_item += 1;

            var new_page = Math.ceil(active_item / visible_items) - 1;

            if(new_page == current_page) {
                return;
            }

            if(new_page == 0) {
                $left.addClass("ss_arrow_disabled");
            }
            else {
                $left.removeClass("ss_arrow_disabled");
            }

            if(new_page == pages_count) {
                $right.addClass("ss_arrow_disabled");
            }
            else {
                $right.removeClass("ss_arrow_disabled");
            }

            $car.data("current_page", new_page);

            // for last page. ,ake correctioon to not scroll not needed size
            var ratio_w = 0;
            if(new_page == pages_count) {

                var max_items = (pages_count + 1) * visible_items;
                var ratio_items_count = max_items - items_count;

                ratio_w = ratio_items_count * (item_w + item_margin);
            }

            var translate_size = new_page * w * -1 - new_page * item_margin + ratio_w;

            $inner_row.css('transform', 'translateX(' + translate_size + 'px)');

        }

        function move_carousel($car, dir) {

            var $inner_row = $car.find(".ss_carousel_inner_row");
            var $left = $car.find(".ss_carousel_arrow_left");
            var $right = $car.find(".ss_carousel_arrow_right");

            var w = $car.data("w");
            var current_page = $car.data("current_page");
            var pages_count = $car.data("pages_count");
            var visible_items = $car.data("visible_items");
            var items_count = $car.data("items_count");
            var item_margin = $car.data("item_margin");
            var item_w = $car.data("item_w");

            var new_page = 0;

            if(dir == 'left') {
                if(current_page == 0) {
                    return;
                }
                else {
                    new_page = current_page - 1;
                }
            }
            else {
                if(current_page == pages_count) {
                    return;
                }
                else {
                    new_page = current_page + 1;
                }
            }

            if(new_page == 0) {
                $left.addClass("ss_arrow_disabled");
            }
            else {
                $left.removeClass("ss_arrow_disabled");
            }

            if(new_page == pages_count) {
                $right.addClass("ss_arrow_disabled");
            }
            else {
                $right.removeClass("ss_arrow_disabled");
            }

            $car.data("current_page", new_page);

            // for last page. ,ake correctioon to not scroll not needed size
            var ratio_w = 0;
            if(new_page == pages_count) {

                var max_items = (pages_count + 1) * visible_items;
                var ratio_items_count = max_items - items_count;

                ratio_w = ratio_items_count * (item_w + item_margin);
            }

            var translate_size = new_page * w * -1 - new_page * item_margin + ratio_w;

            $inner_row.css('transform', 'translateX(' + translate_size + 'px)');
        }
    };

    // 3.7.0
    this.regeneratePlayerBar = function() {

        var $player = $(".ss_full_player_preview").find(".ssplayer_wrapper");

        if(!$player.length)
            return;

        var $this = thisPage,
            $eq = $player.find('.ss_equalizer'),
            $lines_wrapper = $eq.find(".ss_ss_bar-lines-wrapper"),
            ssbar_items_count = $lines_wrapper.find('.ssbar_item').length,
            total_dur = 0, // total duration of audio
            step_size = 10, // amount of time for back/forward buttons
            back_f_int = 0,
            rand_index = $player.attr("id"),
            player_options_str = $player.data("options"),
            player_options = {},
            $playerEl = undefined,
            $playerElG = undefined,
            $context_player = undefined,
            plays_count = 0,
            downloads_count = 0;


        var setBars = function() {

            var $verical_item = $lines_wrapper.find('.ssbar_item').eq(0),
                item_w = $verical_item.width(),
                item_m = parseInt($verical_item.css('margin-right')),
                bars_total_w = $lines_wrapper.width(),
                bars_count = Math.round(bars_total_w / (item_w + item_m)),
                bars_html = '',
                bar_html = '<span class="ssbar_item"></span>';

            for(var t = 0; t <= bars_count; t++) {
                 
                 bars_html += bar_html;
            }

            $eq.find(".ss_bar-lines").html(bars_html);
            ssbar_items_count = $lines_wrapper.find('.ssbar_item').length;
        };

        var setBarsWave = function() {

            var $lines_wrapper = $eq.find(".ss_ss_bar-lines-wrapper"),
                $verical_item = $lines_wrapper.find('.ssbar_item:first-child'),
                item_w = $verical_item.width(),
                item_m = parseInt($verical_item.css('margin-right')),
                item_w_t = item_w + item_m,
                bars_total_w = $lines_wrapper.width(),
                ssbar_items_count = $lines_wrapper.find('.ssbar_item').length;

            // set period classes
            var short_period_w_perc = 5,
                short_period_w_perc_2 = 25;

            var short_period_w = bars_total_w * short_period_w_perc / 100,
                short_period_w_2 = bars_total_w * short_period_w_perc_2 / 100,
                short_elements_c = Math.round(short_period_w / item_w_t),
                middle_elements_c = Math.round(short_period_w_2 / item_w_t);

             // last short period
            var last_sh_start = ssbar_items_count - short_elements_c,
                last_sh_2_start = Math.round((bars_total_w - short_period_w) / item_w_t)

            // middle period
            var middle_range_start = short_elements_c,
                middle_range_end = ssbar_items_count - short_elements_c - middle_elements_c,
                middle_start = $this.getRundBetween(middle_range_start, middle_range_end),
                middle_end = middle_start + middle_elements_c;

            // midle short periods
            var middle_short_range_start = short_elements_c,
                middle_short_range_end = ssbar_items_count - short_elements_c * 2,
                middle_short_start = $this.getRundBetween(middle_short_range_start, middle_short_range_end),
                middle_short_start_2 = $this.getRundBetween(middle_short_range_start, middle_short_range_end),
                middle_short_end = middle_short_start + short_elements_c,
                middle_short_end_2 = middle_short_start_2 + short_elements_c;

            $lines_wrapper.find('.ssbar_item').removeClass('ss_short_item').removeClass('ss_middle_short_item').removeClass('ss_middle_item');
            $lines_wrapper.find('.ssbar_item').each(function(i) {
                 
                 $ssbar_item = $(this);

                // first short period
                if(i >= 0 && i <= short_elements_c)
                    $ssbar_item.addClass('ss_short_item');
                // last short period
                else if(i >= last_sh_start && i <= ssbar_items_count)
                    $ssbar_item.addClass('ss_short_item');
                // middle short periods
                else if((i >= middle_short_start && i <= middle_short_end) || (i >= middle_short_start_2 && i <= middle_short_end_2))
                    $ssbar_item.addClass('ss_middle_short_item');
                // middle period
                else if(i >= middle_start && i <= middle_end)
                    $ssbar_item.addClass('ss_middle_item');

                // set vals
                var h_p_start = 50,
                    h_p_end = 100;

                if($ssbar_item.hasClass('ss_short_item')) {
                    h_p_start = 15;
                    h_p_end = 50;
                }
                else if($ssbar_item.hasClass('ss_middle_short_item')) {
                    h_p_start = 25;
                    h_p_end = 50;
                }
                else if($ssbar_item.hasClass('ss_middle_item')) {
                    h_p_start = 30;
                    h_p_end = 70;
                }

                var h_val = $this.getRundBetween(h_p_start, h_p_end);
                $ssbar_item.height(h_val + '%');
            });
        };

        var setActivePeriod = function(n_second, removeHover) {

            removeHover = removeHover == undefined ? false : removeHover;

            n_second = n_second == undefined ? $player.data('cur_s') : n_second;
            n_second = isNaN(n_second) ? 0 : n_second;

            var active_el_c = Math.round(n_second * ssbar_items_count / total_dur);

            var cur_s_h = $player.data('cur_s_h');
            cur_s_h = cur_s_h == undefined ? -1 : cur_s_h;
            cur_s_h = parseInt(cur_s_h);

            if(removeHover) 
                $lines_wrapper.find('.ssbar_item').removeClass('ssbar_item_hovered');

            $lines_wrapper.find('.ssbar_item_active').addClass('was_active');           
            $lines_wrapper.find('.ssbar_item').removeClass('ssbar_item_active').each(function(i) {

                if(i >= active_el_c)
                    return false;

                // hovered magic
                if(cur_s_h != -1) {
                    if(cur_s_h >= n_second)
                        $(this).removeClass('ssbar_item_hovered');
                    else {
                        if(!$(this).hasClass('was_active') && !$(this).hasClass('ssbar_item_hovered'))
                            $(this).addClass('ssbar_item_hovered');
                    }
                }

                $(this).addClass('ssbar_item_active');
            });
            $lines_wrapper.find('.was_active').removeClass('was_active');

            if(cur_s_h == -1) {
                var time_start_formated = $this.formatTime(n_second);
                $player.find('.sstimeline_time_start').html(time_start_formated);
            }
        };

        setBars();
        setBarsWave();
        // setActivePeriod();
    };

    this.createTranslationBlockPreviewTxt = function($target) {

        var lang_item = $target.data('val');
        var lang_p = lang_item.split('-');
        var lang_to = lang_p[0];

        var $voice_preview_data = $("#voice_preview_data");
        var preview_txt_def = $voice_preview_data.data('preview_txt_def');

        if(lang_to == 'en') {

            $target.data('prev_txt', preview_txt_def);
            $target.addClass("preview_txt_processed");
        }
        else {

            lang_to = lang_to == 'yue' ? 'zh' : lang_to;

            var translate_callback = function(translated) {

                var tr_item = translated[0];
                $target.data('prev_txt', tr_item);
                $target.addClass("preview_txt_processed");
            };

            var interval_counter = 0;
            var check_int = setInterval(function() {

                if(window.gspeech != undefined) {
                    
                    clearInterval(check_int);

                    setTimeout(function() {

                         window.gspeech.doSmartTranslate('en', lang_to, [preview_txt_def], translate_callback);

                    }, 200);
                }

                if(interval_counter > 1000) {
                    clearInterval(check_int);
                }

                interval_counter ++;
            }, 25);
        }
    };

    this.registerToken = function(token) {

        this.options.token = token;

        this.eraseCookie('gspeech_token');
        this.setCookie('gspeech_token', token, -1);
    };

    this.makeLoginShowAddWebsite = function() {

        this.createLangsListAddWebsite();

        $(".gsp_tab_sign_in").addClass("gsp_hidden");
        $(".gsp_tab_sign_up").addClass("gsp_hidden");
        $(".gsp_tab_add_website").removeClass("gsp_hidden").addClass("gsp_tab_selected");
        $(".gsp_tab_sign_out").removeClass("gsp_hidden");

        $(".gsp_tab_c.gsp_tab_active").removeClass("gsp_tab_active");
        $(".gsp_tab_c_add_website").addClass("gsp_tab_active");
    };

    this.makeLoginSetData = function() {

        $(".gsp_tab_sign_in").addClass("gsp_hidden");
        $(".gsp_tab_sign_up").addClass("gsp_hidden");
        $(".gsp_tab_website_settings").removeClass("gsp_hidden").addClass("gsp_tab_selected");
        $(".gsp_tab_sign_out").removeClass("gsp_hidden");

        $(".gsp_tab_c.gsp_tab_active").removeClass("gsp_tab_active");
        $(".gsp_tab_c_website_settings").addClass("gsp_tab_active");

        var widget_id = thisPage.options.widget_id;
        thisPage.getWebsiteData(widget_id);
    };

    this.makeLogout = function() {

        this.eraseCookie('gspeech_token');

        $(".gsp_tab_sign_in").removeClass("gsp_hidden").addClass("gsp_tab_selected");
        $(".gsp_tab_sign_up").removeClass("gsp_hidden");
        $(".gsp_tab_add_website").addClass("gsp_hidden");
        $(".gsp_tab_sign_out").addClass("gsp_hidden");
        $(".gsp_tab_website_settings").addClass("gsp_hidden");

        $(".gsp_tab_c.gsp_tab_active").removeClass("gsp_tab_active");
        $(".gsp_tab_c_sign_in").addClass("gsp_tab_active");

        window.location.hash = '';

        // show settings tab
        $('.gsp_left_menu.gsp_left_m_selected').removeClass('gsp_left_m_selected');
        $('.gsp_left_menu.gsp_left_menu_settings').addClass('gsp_left_m_selected');

        $('.gsp_left_m_c.gsp_left_m_c_active').removeClass('gsp_left_m_c_active');
        $('.gsp_left_m_c.gsp_left_m_c_settings').addClass('gsp_left_m_c_active');


        $(".gsp_link_cloud_login").removeClass('ss_hidden');

        user_email_written = this.options.user_email_written;

        if(user_email_written != "") {

            $(".gsp_link_cloud_activate").addClass('ss_hidden');
            $(".gsp_link_cloud_loged_in_as").removeClass('ss_hidden');
            $(".gsp_link_cloud_loged_in_email").removeClass('ss_hidden');
            $(".gsp_login_email").html(user_email_written);

            $(".gsp_login_email_uni").val(user_email_written);
        }

        $('.gsp_link_cloud_logout').addClass('ss_hidden');
    };

    this.loadCloudData = function() {

        var widget_id = this.options.widget_id;
        var gspeech_token = this.getCookie('gspeech_token');

        var hash = window.location.hash;

        hash = hash == '' ? '#settings' : hash;

        if(hash != '') {

            var hash_striped = hash.replace('#','');

            var hash_pieces = hash_striped.split('-');
            var hash_0 = hash_pieces[0];
            var hash_1 = hash_pieces[1] != undefined ? parseInt(hash_pieces[1]) : 0;

            $('.gsp_left_m_selected').removeClass('gsp_left_m_selected');
            $('.gsp_left_menu_' + hash_0).addClass('gsp_left_m_selected');

            if(hash_0 == 'settings') {

                this.getWebsiteData(widget_id);
            }
            else if(hash_0 == 'widgets') {

                if(hash_1 == 0)
                    this.getWidgetsData(widget_id);
                else
                    this.getWidgetData(widget_id, hash_1);
            }
            else if(hash_0 == 'audios') {

                if(hash_1 == 0)
                    this.getAudiosData(widget_id);
                else {
                    this.options.root_request = true;
                    this.getAudioData(widget_id, hash_1);
                }
            }
            else if(hash_0 == 'analytics') {

                this.getWebsiteAnalyticsData(widget_id);
            }

            var page_ident = hash_0;
            page_ident = hash_0 == 'widgets' && hash_1 != 0 ? 'widget' : page_ident;
            page_ident = hash_0 == 'audios' && hash_1 != 0 ? 'audio' : page_ident;

            $(".gsp_left_m_c_active").removeClass("gsp_left_m_c_active");
            $(".gsp_left_m_c_" + page_ident).addClass("gsp_left_m_c_active");

            $('.ss_tab_general').addClass("ss_tab_active");
        }

    };

    this.processPlanCorrection_ = function() {

        var plan_id = parseInt($("#gsp_plan").html());
        var is_appsumo = parseInt($("#gsp_appsumo").html());
        is_appsumo = is_appsumo ?? 0;

        is_appsumo = 1;

        if(is_appsumo == 0)
            var plans_obj = {
                "plan_0": "Free",
                "plan_1": "Personal",
                "plan_2": "PRO",
                "plan_3": "Business",
                "plan_4": "Enterprise",
                "plan_5": "Personal-2"
            };
        else
            var plans_obj = {
                "plan_0": "Free",
                "plan_1": "AppSumo Tier 1",
                "plan_2": "AppSumo Tier 2",
                "plan_3": "AppSumo Tier 3",
                "plan_4": "AppSumo Tier 4",
                "plan_5": "Personal-2"
            };

        var plan_name = plans_obj["plan_" + plan_id];

        if(plan_id != 0) {

            $('.plan_title').html(plan_name);

            $(".ss_upgrade_info_top").addClass("ss_hidden");
            $(".ss_upgrade_info").addClass("ss_hidden");
            // $(".gsp_upgrade_wrapper").addClass("ss_hidden");

            $(".gsp_upg_link").addClass("ss_hidden");

            $(".gsp_package_free .product_button").html("-");

            var plan_id_ident = plan_id == 5 ? 1 : plan_id;

            var plan_ident_name = plans_obj["plan_" + plan_id_ident].toLowerCase();

            $(".gsp_package_" + plan_ident_name + " .product_button").html("Active");
        }

        var plg_v = $('#gsp_version').html();

        var v_ht = '(Version ' + plg_v + ') - ' + plan_name;     
        $('.gsp_v_i').html(v_ht);

        v_ht = plg_v + ' - ' + plan_name;       
        $('.gsp_link_info_plg_v').html(v_ht);

    };

    this.processPlanCorrection = function () {

        // Fetch and sanitize plan ID and AppSumo status
        const planId = parseInt($("#gsp_plan").html(), 10) || 0;
        let isAppSumo = parseInt($("#gsp_appsumo").html(), 10) || 0;

        // Define plan mappings based on AppSumo status
        const plansObj = isAppSumo
            ? {
                  plan_0: "Free",
                  plan_1: "AppSumo Tier 1",
                  plan_2: "AppSumo Tier 2",
                  plan_3: "AppSumo Tier 3",
                  plan_4: "AppSumo Tier 4",
                  plan_5: "AppSumo Tier 5",
              }
            : {
                  plan_0: "Free",
                  plan_1: "Personal",
                  plan_2: "PRO",
                  plan_3: "Business",
                  plan_4: "Enterprise",
                  plan_5: "Personal-2",
              };

        // Get plan name with fallback
        const planName = plansObj[`plan_${planId}`] || "Unknown Plan";

        // Update UI for non-Free plans
        if (planId !== 0) {
            $(".plan_title").html(planName);
            $(".ss_upgrade_info_top, .ss_upgrade_info, .gsp_upg_link").addClass(
                "ss_hidden"
            );
            // $(".gsp_upgrade_wrapper").addClass("ss_hidden"); // Uncomment if needed
            $(".gsp_package_free .product_button").html("-");

            // Map plan 5 to 1 for identifier (e.g., Personal-2 uses Personal styling)
            const planIdIdent = planId == 5 && isAppSumo == 0 ? 1 : planId;
            const planIdentName = plansObj[`plan_${planIdIdent}`].toLowerCase();

            $(`.gsp_package_${planIdentName} .product_button`).html("Active");
        }

        // Update version info
        const pluginVersion = $("#gsp_version").html() || "N/A";
        const versionText = `(Version ${pluginVersion}) - ${planName}`;
        $(".gsp_v_i").html(versionText);

        const linkVersionText = `${pluginVersion} - ${planName}`;
        $(".gsp_link_info_plg_v").html(linkVersionText);

        // set active class
        if(isAppSumo) {
            let $btn = $(`.product_button_plan_${planId}`);
            $btn.addClass("gsp_plan_active").html("Current Tier");

            $btn.on('click', function(event) { // Prevent any remaining/default behavior
                event.preventDefault();
                return false;
            });
        }
    };

    this.detectState = function() {

        // console.log("detect state");

        // this.eraseCookie('gspeech_token');

        var widget_id = this.options.widget_id;
        var gspeech_token = this.getCookie('gspeech_token');

        var active_tab_ident = $("#gsp_tabs_wrapper").data('active_tab');

        // console.log("active_tab_ident: " + active_tab_ident);

        this.processPlanCorrection();

        var sh_ = this.options.sh_;
        var shortcodes_loaded = this.options.shortcodes_loaded;

        sh_ = shortcodes_loaded == '1' ? '0' : sh_;

        if(sh_ == '0') {
            $(".add_shortcode_widgets_event_holder").addClass('ss_hidden');
        }

        var old_p_lang = $("#gsp_old_p_lang").html();
        var old_p_speak_any_text = $("#gsp_old_p_speak_any_text").html();

        var user_email = $("#gsp_useremail").html();

        if(gspeech_token != "" && gspeech_token != null) { // logged in

            $('.gsp_link_cloud_logout').removeClass('ss_hidden');

            $('.gsp_login_email').html(user_email);

            // hide loged out items
            $(".gsp_tab_sign_in").addClass("gsp_hidden");
            $(".gsp_tab_sign_up").addClass("gsp_hidden");
            $(".gsp_tab_sign_out").removeClass("gsp_hidden");

            if(widget_id != "") { // we have a website

                if(sh_ == '1') {
                    this.registerShortcodeWisgets(widget_id, 0);
                }

                $(".gsp_link_cloud_loged_in_as").removeClass('ss_hidden');
                $(".gsp_link_cloud_loged_in_email").removeClass('ss_hidden');

                $(".gsp_link_cloud_activate").addClass('ss_hidden');
                $(".gsp_link_cloud_login").addClass('ss_hidden');

                var hash = window.location.hash;

                if(active_tab_ident == 'cloud')
                    hash = hash == '' ? '#settings' : hash;

                if(hash != '') {

                    var hash_striped = hash.replace('#','');

                    var hash_pieces = hash_striped.split('-');
                    var hash_0 = hash_pieces[0];
                    var hash_1 = hash_pieces[1] != undefined ? parseInt(hash_pieces[1]) : 0;

                    $('.gsp_left_m_selected').removeClass('gsp_left_m_selected');
                    $('.gsp_left_menu_' + hash_0).addClass('gsp_left_m_selected');


                    // $(".ss_tab_active").removeClass("ss_tab_active");
                    // $(".ss_tab_" + hash_striped).addClass("ss_tab_active");

                    if(hash_0 == 'settings') {

                        this.getWebsiteData(widget_id);
                    }
                    else if(hash_0 == 'widgets') {

                        if(hash_1 == 0)
                            this.getWidgetsData(widget_id);
                        else
                            this.getWidgetData(widget_id, hash_1);
                    }
                    else if(hash_0 == 'audios') {

                        if(hash_1 == 0)
                            this.getAudiosData(widget_id);
                        else {
                            this.options.root_request = true;
                            this.getAudioData(widget_id, hash_1);
                        }
                    }
                    else if(hash_0 == 'analytics') {

                        this.getWebsiteAnalyticsData(widget_id);
                    }

                    var page_ident = hash_0;
                    page_ident = hash_0 == 'widgets' && hash_1 != 0 ? 'widget' : page_ident;
                    page_ident = hash_0 == 'audios' && hash_1 != 0 ? 'audio' : page_ident;

                    $(".gsp_tab_selected").removeClass("gsp_tab_selected");
                    $(".gsp_tab_website_settings").removeClass("gsp_hidden").addClass("gsp_tab_selected");

                    $(".gsp_tab_c.gsp_tab_active").removeClass("gsp_tab_active");
                    $(".gsp_tab_c_website_settings").addClass("gsp_tab_active");

                    $(".gsp_left_m_c_active").removeClass("gsp_left_m_c_active");
                    $(".gsp_left_m_c_" + page_ident).addClass("gsp_left_m_c_active");
                }

                $(".gsp_tab_website_settings").removeClass("gsp_hidden");

            }
            else {

                $('.gsp_link_cloud_logout').addClass('ss_hidden');

                $(".gsp_link_cloud_loged_in_as").addClass('ss_hidden');
                $(".gsp_link_cloud_loged_in_email").addClass('ss_hidden');
                $(".gsp_link_cloud_activate").removeClass('ss_hidden');
                $(".gsp_link_cloud_login").removeClass('ss_hidden');

                this.createLangsListAddWebsite();

                $(".gsp_tab.gsp_tab_selected").removeClass("gsp_tab_selected");
                $(".gsp_tab_add_website").removeClass("gsp_hidden").addClass("gsp_tab_selected");

                $(".gsp_tab_c.gsp_tab_active").removeClass("gsp_tab_active");
                $(".gsp_tab_c_add_website").addClass("gsp_tab_active");
            }
        }
        else {

            $(".gsp_link_cloud_login").removeClass('ss_hidden');

            if(widget_id == "") {

                this.createLangsListReg(old_p_lang);

                $(".gsp_tab_selected").removeClass("gsp_tab_selected");
                $(".gsp_tab_video_demo").removeClass("gsp_hidden").addClass("gsp_tab_selected");

                $(".gsp_tab_c.gsp_tab_active").removeClass("gsp_tab_active");
                $(".gsp_tab_c_video_demo").addClass("gsp_tab_active");

            }
            else {

                user_email_written = this.options.user_email_written;

                if(user_email_written != '') {

                    $(".gsp_link_cloud_activate").addClass('ss_hidden');

                    $(".gsp_link_cloud_loged_in_email").removeClass("ss_hidden");
                    $(".gsp_link_cloud_loged_in_as").removeClass("ss_hidden");
                    $(".gsp_login_email").html(user_email_written);
                }
            }
        }

        // tab navigation
        if(active_tab_ident == 'upgrade') {

            $(".gsp_tab.gsp_tab_selected").removeClass("gsp_tab_selected");
            $(".gsp_tab_upgrade").removeClass("gsp_hidden").addClass("gsp_tab_selected");

            $(".gsp_tab_c.gsp_tab_active").removeClass("gsp_tab_active");
            $(".gsp_tab_c_upgrade").addClass("gsp_tab_active");

            
        }
        else if(active_tab_ident == 'cloud') {

            if(widget_id == "") {

                $(".gsp_tab_selected").removeClass("gsp_tab_selected");
                $(".gsp_tab_sign_up").removeClass("gsp_hidden").addClass("gsp_tab_selected");

                $(".gsp_tab_c.gsp_tab_active").removeClass("gsp_tab_active");
                $(".gsp_tab_c_sign_up").addClass("gsp_tab_active");

            }
            else {

                if(gspeech_token != "" && gspeech_token != null) { 

                }
                else {

                    $(".gsp_tab_selected").removeClass("gsp_tab_selected");
                    $(".gsp_tab_sign_in").removeClass("gsp_hidden").addClass("gsp_tab_selected");

                    $(".gsp_tab_c.gsp_tab_active").removeClass("gsp_tab_active");
                    $(".gsp_tab_c_sign_in").addClass("gsp_tab_active");
                }
            }
        }
        else if(active_tab_ident == 'gspeech_2x') {

            $(".gsp_tab.gsp_tab_selected").removeClass("gsp_tab_selected");
            $(".gsp_tab_old_basic").removeClass("gsp_hidden").addClass("gsp_tab_selected").addClass("gsp_tab_old_basic_pos_2");
            $(".gsp_tab_old_styles").removeClass("gsp_hidden");

            $(".gsp_tab_c.gsp_tab_active").removeClass("gsp_tab_active");
            $(".gsp_tab_c_old_basic").addClass("gsp_tab_active");

            $(".gsp_submit_button").removeClass("gsp_hidden");
            $("#gsp_form").removeClass("submit_disabled");
        }
        else if(active_tab_ident == 'faq') {

            $(".gsp_tab.gsp_tab_selected").removeClass("gsp_tab_selected");
            $(".gsp_tab_faq").removeClass("gsp_hidden").addClass("gsp_tab_selected").addClass("faq_ninited");

            $(".gsp_tab_c.gsp_tab_active").removeClass("gsp_tab_active");
            $(".gsp_tab_c_faq").addClass("gsp_tab_active");

            thisPage.initFaq();
        }

        this.makeUi();
    };

    this.makeUi = function() {

        // checked icons
        $('.gsp_icon_checked').html(this.svgs['check_double']);

        // links icons
        $('.gsp_link_info_demos .gsp_link_icon').html(this.svgs['play']);
        $('.gsp_link_info_docs .gsp_link_icon').html(this.svgs['dice']);
        $('.gsp_link_info_contact .gsp_link_icon').html(this.svgs['email']);
        $('.gsp_link_info_reviews .gsp_link_icon').html(this.svgs['users_g']);

        // tabs icons
        $('.gsp_tab_video_demo').find('.ss_top_menu_icon').html(this.svgs['house']);
        $('.gsp_tab_sign_up').find('.ss_top_menu_icon').html(this.svgs['check_double']);
        $('.gsp_tab_sign_in').find('.ss_top_menu_icon').html(this.svgs['user_c']);
        $('.gsp_tab_sign_out').find('.ss_top_menu_icon').html(this.svgs['user_x']);
        $('.gsp_tab_website_settings').find('.ss_top_menu_icon').html(this.svgs['cloud']);
        $('.gsp_tab_add_website').find('.ss_top_menu_icon').html(this.svgs['check_double']);
        $('.gsp_tab_old_basic').find('.ss_top_menu_icon').html(this.svgs['grip']);
        $('.gsp_tab_old_styles').find('.ss_top_menu_icon').html(this.svgs['paint']);
        $('.gsp_tab_contact_us').find('.ss_top_menu_icon').html(this.svgs['email']);
        $('.gsp_tab_rate_us').find('.ss_top_menu_icon').html(this.svgs['heart']);
        $('.gsp_tab_faq').find('.ss_top_menu_icon').html(this.svgs['dice']);
        $('.gsp_tab_upgrade').find('.ss_top_menu_icon').html(this.svgs['check_double']);

        $('.gsp_info_sep').html(this.svgs['arrow_right']);

        // dashboard link icons
        $('.gsp_link_list_1').find('.gsp_link_icon').html(this.svgs['house']);
        $('.gsp_link_list_2').find('.gsp_link_icon').html(this.svgs['play']);
        $('.gsp_link_list_3').find('.gsp_link_icon').html(this.svgs['video']);
        $('.gsp_link_list_4').find('.gsp_link_icon').html(this.svgs['email']);
        $('.gsp_link_list_5').find('.gsp_link_icon').html(this.svgs['users_g']);
        $('.gsp_link_list_6').find('.gsp_link_icon').html(this.svgs['heart']);
        $('.gsp_link_list_7').find('.gsp_link_icon').html(this.svgs['cloud']);
        $('.gsp_link_list_8').find('.gsp_link_icon').html(this.svgs['images']);
        $('.gsp_link_list_9').find('.gsp_link_icon').html(this.svgs['dice']);
        $('.gsp_link_list_10').find('.gsp_link_icon').html(this.svgs['blog']);
        $('.gsp_link_list_11').find('.gsp_link_icon').html(this.svgs['case']);
        $('.gsp_link_list_20').find('.gsp_link_icon').html(this.svgs['check_double']);

        // hide loader
        $(".gsp_magic_wrapper").addClass("ss_bg_ff");

        $(".gsp_gspeech_info_wrapper").addClass("ss_flex");
        $(".gsp_videos_wrapper").addClass("ss_flex");

        setTimeout(function() {

            $(".ss_dash_loader").addClass("ss_hidden");

            if($('.gsp_tab_video_demo').hasClass("gsp_tab_selected"))
                thisPage.setVideos();

        }, 400);

        $("body").on("click", ".gsp_tab_video_demo", function() {

            thisPage.setVideos();

        });
    };

    this.setVideos = function() {

        setTimeout(function() {

            $('.ss_video_item_holder').each(function() {

                var $v_w = $(this);

                if($v_w.hasClass('gsp_video_processed'))
                    return;

                $v_w.addClass('gsp_video_processed');

                var video_id = $v_w.data('video_id');
                var video_htm = '<iframe width="100%" height="480px" src="https://www.youtube.com/embed/'+video_id+'" title="" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>';

                $v_w.html(video_htm);
            });

        }, 1500);
    };

    this.getWebsiteData = function(widget_id) {

        var gspeech_token = this.getCookie('gspeech_token');
        var tts_url = thisPage.options.tts_url;

        var user_email_written = this.options.user_email_written;

        var request_email = user_email_written == "" ? 1 : 0;

        var get_website_data = function() {

            var ajax_id = 'get_website_data_connection';

            var post_data = {
                'token':gspeech_token,
                'ajax_id':ajax_id,
                'request_email':request_email,
                'widget_id':widget_id
            };

            thisPage.showOverlay();
            thisPage.showLoading();

            setTimeout(function() {

                $.ajax({
                    type: 'POST',
                    url: tts_url + '/ajax',
                    crossDomain: true,
                    data: post_data,
                    dataType: 'json',
                    success: function(responseData, textStatus, jqXHR) {

                        thisPage.hideLoading();

                        $('.gsp_link_cloud_logout').removeClass('ss_hidden');

                        var success = responseData.success;
                        var em_ret = responseData.em_ret;
                        var website_data = responseData.website_data;
                        var plan_id = -1;
                        var appsumo = 0;

                        if(success == "true") {
                            plan_id = website_data.user_plan;
                            appsumo = website_data.appsumo;
                        }

                        if(request_email == 1 && em_ret != "") {

                            $('.gsp_login_email').html(em_ret);

                            if(plan_id != -1)
                                var post_data_inner = {
                                    action: 'wpgsp_apply_ajax_save',
                                    _ajax_nonce: wp_ajax_nonce,
                                    type: 'save_data',
                                    field: "email,plan,appsumo",
                                    val: em_ret + ':' + plan_id + ':' + appsumo
                                };
                            else
                                var post_data_inner = {
                                    action: 'wpgsp_apply_ajax_save',
                                    _ajax_nonce: wp_ajax_nonce,
                                    type: 'save_data',
                                    field: "email",
                                    val: em_ret
                                };

                            $.ajax
                            ({
                                url: wp_ajax_url,
                                type: "post",
                                data: post_data_inner,
                                dataType: "json",
                                success: function(data) {
                                    
                                },
                                error: function(xhr, status, error) {
                                    
                                }
                            });
                        }
                        else if(plan_id != -1) {
                            
                            // update plan
                            var post_data_inner = {
                                action: 'wpgsp_apply_ajax_save',
                                _ajax_nonce: wp_ajax_nonce,
                                type: 'save_data',
                                field: "plan,appsumo",
                                val: plan_id + ':' + appsumo
                            };
                            $.ajax
                            ({
                                url: wp_ajax_url,
                                type: "post",
                                data: post_data_inner,
                                dataType: "json",
                                success: function(data) {
                                    
                                },
                                error: function(xhr, status, error) {
                                    
                                }
                            });
                        }

                        if(success == "true") {

                            thisPage.hideOverlay();

                            thisPage.generateWrapperHeight();

                            thisPage.setValsWebsiteSettings(website_data);

                            $("#gsp_plan").html(plan_id);
                            $("#gsp_appsumo").html(appsumo);

                            thisPage.processPlanCorrection();
                        }
                        else if(success == "auth_failed") {

                            thisPage.refreshLogin("website_data");
                        }
                        else {

                            thisPage.showMessage("error","Error", false);
                        }

                    },
                    error: function (responseData, textStatus, errorThrown) {

                        thisPage.hideOverlay();
                        thisPage.hideLoading();
                    }
                });

            }, 400);
        };

        get_website_data();
    };

    this.registerShortcodeWisgets = function(widget_id, after_action) {

        var gspeech_token = this.getCookie('gspeech_token');
        var tts_url = thisPage.options.tts_url;

        var get_website_data = function() {

            var ajax_id = 'add_shortcode_widgets_connection';

            var post_data = {
                'token':gspeech_token,
                'ajax_id':ajax_id,
                'widget_id':widget_id
            };

            thisPage.showOverlay();
            thisPage.showLoading();

            setTimeout(function() {

                $.ajax({
                    type: 'POST',
                    url: tts_url + '/ajax',
                    crossDomain: true,
                    data: post_data,
                    dataType: 'json',
                    success: function(responseData, textStatus, jqXHR) {

                        thisPage.hideLoading();

                        var success = responseData.success;

                        if(success == "true") {

                            thisPage.hideOverlay();
                            thisPage.hideMessage(true);

                            $('.add_shortcode_widgets_event_holder').addClass("ss_hidden");

                            var post_data_inner = {
                                action: 'wpgsp_apply_ajax_save',
                                _ajax_nonce: wp_ajax_nonce,
                                type: 'save_data',
                                field: "sh_w_loaded",
                                val: '1'
                            };
                            $.ajax
                            ({
                                url: wp_ajax_url,
                                type: "post",
                                data: post_data_inner,
                                dataType: "json",
                                success: function(data) {
                                    thisPage.options.shortcodes_loaded = 1;
                                },
                                error: function(xhr, status, error) {
                                    
                                }
                            });

                            if(after_action == 1) {
                                thisPage.getWidgetsData(widget_id);
                            }

                        }
                        else if(success == "auth_failed") {

                            thisPage.refreshLogin("website_data");
                        }
                        else {

                            thisPage.showMessage("error","Error", false);
                        }

                    },
                    error: function (responseData, textStatus, errorThrown) {

                        thisPage.hideOverlay();
                        thisPage.hideLoading();
                    }
                });

            }, 400);
        };

        get_website_data();
    };

    this.getWebsiteAnalyticsData = function(widget_id) {

        var gspeech_token = this.getCookie('gspeech_token');
        var tts_url = thisPage.options.tts_url;

        var get_website_analytics_data = function() {

            var ajax_id = 'get_website_analytics_data_connection';

            var post_data = {
                'token':gspeech_token,
                'ajax_id':ajax_id,
                'widget_id':widget_id
            };

            thisPage.showOverlay();
            thisPage.showLoading();

            setTimeout(function() {

                $.ajax({
                    type: 'POST',
                    url: tts_url + '/ajax',
                    crossDomain: true,
                    data: post_data,
                    dataType: 'json',
                    success: function(responseData, textStatus, jqXHR) {

                        thisPage.hideLoading();

                        var success = responseData.success;

                        if(success == "true") {

                            thisPage.hideOverlay();

                            analytics_data = responseData.analytics_data;

                            thisPage.generateWrapperHeight();

                            thisPage.setValsWebsiteAnalytics(analytics_data);
                        }
                        else if(success == "auth_failed") {

                            thisPage.refreshLogin("website_analytics_data");
                        }
                        else {

                            thisPage.showMessage("error","Error", false);
                        }

                    },
                    error: function (responseData, textStatus, errorThrown) {

                        thisPage.hideOverlay();
                        thisPage.hideLoading();
                    }
                });

            }, 400);
        };

        get_website_analytics_data();
    };

    this.resetTable = function() {

        var $table = $('.gsp_left_m_c_active .items_filter_table');

        if(!$table.length)
            return;

        // $table.find('.items_count').html('');
        $table.find('.search_items_wrapper .search_input').val('');
        $table.find('.itm_ord_active').removeClass('item_ord_asc').removeClass('item_ord_desc').removeClass('itm_ord_active');
        // $table.find('.items_pagination_itms_holder').html('');

        $table.find('.gsp_default_order').addClass('item_ord_desc').addClass('itm_ord_active');

        $table.find('.items_select_filter_wrapper').each(function(e) {

            var $ss_select = $(this);
            var filter_id = $ss_select.data('filter_id');
            var sel_index = filter_id == 'limit' ? 2 : 0;
            var $active_li = $ss_select.find('.search_li').eq(sel_index);
            var act_txt = $active_li.find('span').html();

            if(!$active_li.hasClass('li_selected')) {

                $ss_select.find('.li_selected').removeClass('li_selected').removeClass('ss_ul_li_act');
                $active_li.addClass('li_selected').addClass('ss_ul_li_act');

                $ss_select.find('.items_select_filter_content span').html(act_txt);
                $ss_select.find('.items_select_filter_content .li_search_input').attr('placeholder', act_txt);
            }
        });

    };

    this.getWidgetsData = function(widget_id) {

        var gspeech_token = this.getCookie('gspeech_token');
        var tts_url = thisPage.options.tts_url;

        // reset table
        this.resetTable();

        var get_website_data = function() {

            var ajax_id = 'get_widgets_data_connection';

            var post_data = {
                'token':gspeech_token,
                'ajax_id':ajax_id,
                'widget_id':widget_id
            };

            thisPage.showOverlay();
            thisPage.showLoading();

            setTimeout(function() {

                $.ajax({
                    type: 'POST',
                    url: tts_url + '/ajax',
                    crossDomain: true,
                    data: post_data,
                    dataType: 'json',
                    success: function(responseData, textStatus, jqXHR) {

                        thisPage.hideLoading();

                        var success = responseData.success;

                        if(success == "true") {

                            thisPage.hideOverlay();

                            var htm = decodeURIComponent(responseData.html);
                            var pages = decodeURIComponent(responseData.pages);
                            var count_txt = decodeURIComponent(responseData.count_txt);
                            var pages_state = parseInt(responseData.pages_state);

                            $('.gsp_left_m_c.gsp_left_m_c_active').find('.items_inner_wrapper').html(htm);
                            $('.gsp_left_m_c.gsp_left_m_c_active').find('.items_pagination_itms_holder').html(pages);
                            $('.gsp_left_m_c.gsp_left_m_c_active').find('.items_count').html(count_txt);

                            if(pages_state == 1) {

                                $('.gsp_left_m_c.gsp_left_m_c_active').find('.items_pagination_itms_holder').addClass("p_hid");
                            }
                            else {

                                $('.gsp_left_m_c.gsp_left_m_c_active').find('.items_pagination_itms_holder').removeClass("p_hid");
                            }

                            thisPage.generateWrapperHeight();

                            thisPage.setValsWidgets();
                        }
                        else if(success == "auth_failed") {

                            thisPage.refreshLogin("widgets_data");
                        }
                        else {

                            thisPage.showMessage("error","Error", false);
                        }

                    },
                    error: function (responseData, textStatus, errorThrown) {

                        thisPage.hideOverlay();
                        thisPage.hideLoading();
                    }
                });

            }, 400);
        };

        get_website_data();
    };

    this.getAudiosData = function(widget_id) {

        var gspeech_token = this.getCookie('gspeech_token');
        var tts_url = thisPage.options.tts_url;

        // reset table
        this.resetTable();

        var get_audios_data = function() {

            var ajax_id = 'get_audios_data_connection';

            var post_data = {
                'token':gspeech_token,
                'ajax_id':ajax_id,
                'widget_id':widget_id
            };

            thisPage.showOverlay();
            thisPage.showLoading();

            setTimeout(function() {

                $.ajax({
                    type: 'POST',
                    url: tts_url + '/ajax',
                    crossDomain: true,
                    data: post_data,
                    dataType: 'json',
                    success: function(responseData, textStatus, jqXHR) {

                        thisPage.hideLoading();

                        var success = responseData.success;

                        if(success == "true") {

                            thisPage.hideOverlay();

                            var htm = decodeURIComponent(responseData.html);
                            var pages = decodeURIComponent(responseData.pages);
                            var count_txt = decodeURIComponent(responseData.count_txt);
                            var widgets_lis = decodeURIComponent(responseData.widgets_lis);
                            var pages_state = parseInt(responseData.pages_state);

                            $('.gsp_left_m_c.gsp_left_m_c_active').find('.items_inner_wrapper').html(htm);
                            $('.gsp_left_m_c.gsp_left_m_c_active').find('.items_pagination_itms_holder').html(pages);
                            $('.gsp_left_m_c.gsp_left_m_c_active').find('.items_count').html(count_txt);
                            $("#gsp_widget_filter").find('.items_select_ul').html(widgets_lis);

                            if(pages_state == 1) {

                                $('.gsp_left_m_c.gsp_left_m_c_active').find('.items_pagination_itms_holder').addClass("p_hid");
                            }
                            else {

                                $('.gsp_left_m_c.gsp_left_m_c_active').find('.items_pagination_itms_holder').removeClass("p_hid");
                            }

                            thisPage.generateWrapperHeight();

                            thisPage.setValsAudios();
                        }
                        else if(success == "auth_failed") {

                            thisPage.refreshLogin("widgets_data");
                        }
                        else {

                            thisPage.showMessage("error","Error", false);
                        }

                    },
                    error: function (responseData, textStatus, errorThrown) {

                        thisPage.hideOverlay();
                        thisPage.hideLoading();
                    }
                });

            }, 400);
        };

        get_audios_data();
    };

    this.getWidgetData = function(widget_id, block_id) {

        var gspeech_token = this.getCookie('gspeech_token');
        var tts_url = thisPage.options.tts_url;

        var get_widgets_data = function() {

            var ajax_id = 'get_widget_data_connection';

            var post_data = {
                'token':gspeech_token,
                'ajax_id':ajax_id,
                'widget_id':widget_id,
                'block_id':block_id
            };

            thisPage.showOverlay();
            thisPage.showLoading();

            setTimeout(function() {

                $.ajax({
                    type: 'POST',
                    url: tts_url + '/ajax',
                    crossDomain: true,
                    data: post_data,
                    dataType: 'json',
                    success: function(responseData, textStatus, jqXHR) {

                        thisPage.hideLoading();

                        var success = responseData.success;

                        if(success == "true") {

                            thisPage.hideOverlay();

                            var widget_data = responseData.widget_data;
                            var website_options = widget_data.website_options;

                            thisPage.setValsWidget(block_id, widget_data, website_options);
                        }
                        else if(success == "auth_failed") {

                            thisPage.refreshLogin("widget_data");
                        }
                        else {

                            thisPage.showMessage("error","Error", false);
                        }

                    },
                    error: function (responseData, textStatus, errorThrown) {

                        thisPage.hideOverlay();
                        thisPage.hideLoading();
                    }
                });

            }, 400);
        };

        get_widgets_data();
    };

    this.getAudioData = function(widget_id, audio_id) {

        var gspeech_token = this.getCookie('gspeech_token');
        var tts_url = thisPage.options.tts_url;

        var get_audio_data = function() {

            var ajax_id = 'get_audio_data_connection';

            var post_data = {
                'token':gspeech_token,
                'ajax_id':ajax_id,
                'widget_id':widget_id,
                'audio_id':audio_id
            };

            thisPage.showOverlay();
            thisPage.showLoading();

            setTimeout(function() {

                $.ajax({
                    type: 'POST',
                    url: tts_url + '/ajax',
                    crossDomain: true,
                    data: post_data,
                    dataType: 'json',
                    success: function(responseData, textStatus, jqXHR) {

                        thisPage.hideLoading();

                        var success = responseData.success;

                        if(success == "true") {

                            thisPage.hideOverlay();

                            var audio_data = responseData.audio_data;

                            thisPage.setValsAudio(audio_id, audio_data);
                        }
                        else if(success == "auth_failed") {

                            thisPage.refreshLogin("audio_data");
                        }
                        else {

                            thisPage.showMessage("error","Error", false);
                        }
                    },
                    error: function (responseData, textStatus, errorThrown) {

                        thisPage.hideOverlay();
                        thisPage.hideLoading();
                    }
                });

            }, 400);
        };

        get_audio_data();
    };

    this.process_lang_change = function() {

        var lang_change_page = "";
        if($(".gsp_left_m_c_active #lng_sel").length)
            lang_change_page = "website_settings";
        else if($(".gsp_left_m_c_active #lng_sel_wdg").length)
            lang_change_page = "widget_settings";

        if(lang_change_page == "")
            return;

        var $active_lang_selector = lang_change_page == "website_settings" ? $('#lng_sel') : $('#lng_sel_wdg');
        var lang = $active_lang_selector.find('.li_selected').data('val');

        var lang_p = lang.split('-');
        var lang_to = lang_p[0];

        lang_to = lang_to == 'yue' ? 'zh' : lang_to;

        var $voice_preview_data = lang_change_page == "website_settings" ? $("#voice_preview_data") : $(".voice_preview_data");
        var preview_txt_def = $voice_preview_data.data('preview_txt_def');
        var preview_txt_ready = preview_txt_def;

        var translate_callback = function(translated) {
            var tr_item = translated[0];
            $voice_preview_data.data('preview_txt_ready', tr_item);

            if(lang_change_page == "website_settings")
                thisPage.resetPlayerWebsiteSettings();
            else
                thisPage.resetPlayerWidgetSettings();
        };

        if(lang_to != 'en')
            window.gspeech.doSmartTranslate('en', lang_to, [preview_txt_def], translate_callback);
        else {
            $voice_preview_data.data('preview_txt_ready', preview_txt_def);

            if(lang_change_page == "website_settings")
                thisPage.resetPlayerWebsiteSettings();
            else
                thisPage.resetPlayerWidgetSettings();
        }
    };

    this.setValsWidget = function(block_id, widget_data, website_options) {

        var $this = this;

        var widget_id = block_id;
        var widget_options = widget_data.options;
        var widget_type_txt = widget_data.block_type_txt;
        var render_element = widget_data.render_element;
        var content_selector = widget_data.content_selector;
        var player_title_text = decodeURIComponent(widget_data.player_title_text);
        var content_txt = decodeURIComponent(widget_data.content_txt);
        var player_title_selector = decodeURIComponent(widget_data.player_title_selector);
        var widget_aliases = decodeURIComponent(widget_data.aliases);
        var exclude_list = decodeURIComponent(widget_data.exclude_list);
        var widget_texts = decodeURIComponent(widget_data.texts);
        var widget_type = parseInt(widget_data.block_type);
        var user_plan = parseInt(widget_data.user_plan);
        var website_plan = parseInt(widget_data.plan);
        var margin_top = parseInt(widget_data.margin_top);
        var margin_bottom = parseInt(widget_data.margin_bottom);

        widget_options = decodeURIComponent(widget_options);
        website_options = decodeURIComponent(website_options);

        // shortcode section
        var short_detected = false;
        var new_c = '';
        var new_c_1 = '';
        if(render_element == '.gsp_full_player') {

            short_detected = true;
            new_c = 'gsp_full_player';
            new_c_1 = 'full';

        }
        else if(render_element == '.gsp_circle_player') {

            short_detected = true;
            new_c = 'gsp_circle_player'; 
            new_c_1 = 'circle';
        }
        else if(render_element == '.gsp_button_player') {

            short_detected = true;
            new_c = 'gsp_button_player'; 
            new_c_1 = 'button';
        }

        if(short_detected) {

            $('.gsp_opts_sh_wrapper').removeClass('ss_hidden');
            $('.gsp_opts_ch_wrapper').removeClass('ss_hidden');

            var sh_v = '[gspeech type=ss_class]';
            sh_v = sh_v.replace('ss_class', new_c_1);
            $('.gsp_opts_sh').html(sh_v);

            var ch_v = '<div class="ss_class"></div>';
            ch_v = ch_v.replace('ss_class', new_c);
            $('.gsp_opts_ch').html(ch_v);

        }
        else {

            $('.gsp_opts_sh_wrapper').addClass('ss_hidden');
            $('.gsp_opts_ch_wrapper').addClass('ss_hidden');

        }

        // set website options
        $(".gsp_left_m_c_active .wbs_website_options").data("val", website_options);

        // set type class
        $('.gsp_left_m_c_active .dashboard_content').removeClass("ss_dash_page_type_0").removeClass("ss_dash_page_type_1").removeClass("ss_dash_page_type_2").removeClass("ss_dash_page_type_3").removeClass("ss_dash_page_type_4").removeClass("ss_dash_page_type_5").addClass("ss_dash_page_type_" + widget_type);
        $('.gsp_left_m_c_active .dashcontwrapper').removeClass("ss_dash_page_type_0").removeClass("ss_dash_page_type_1").removeClass("ss_dash_page_type_2").removeClass("ss_dash_page_type_3").removeClass("ss_dash_page_type_4").removeClass("ss_dash_page_type_5").addClass("ss_dash_page_type_" + widget_type).addClass("ss_user_plan_" + website_plan);
        $('.gsp_left_m_c_active .dashcontwrapper').data("plan_id", user_plan);
        $('#ss_widget_page_data').data("website_plan", website_plan).data("options", widget_options);

        var options_data_array = website_options.split('&');
        var website_options_array = {};
        for(var t = 0;t < options_data_array.length;t ++) {

            var opt_b = options_data_array[t].split('=');
            website_options_array[opt_b[0]] = opt_b[1];
        }

        var options_data_array = widget_options.split('&');
        var widget_options_array = {};
        for(var t = 0;t < options_data_array.length;t ++) {

            var opt_b = options_data_array[t].split('=');
            widget_options_array[opt_b[0]] = opt_b[1];
        }

        var ss_website_lang = website_options_array["ss_website_lang"],
            ss_website_voice = website_options_array["ss_website_voice"],
            ss_website_speed = website_options_array["ss_website_speed"],
            ss_website_pitch = website_options_array["ss_website_pitch"],
            ss_website_plan = website_options_array["ss_website_plan"],
            ss_website_sel_voices = website_options_array["sel_voices"],
            ss_website_sel_langs = website_options_array["sel_langs"];

        var widget_use_custom = widget_options_array["widget_use_custom"] != undefined ? widget_options_array["widget_use_custom"] : 0,
            widget_title = widget_options_array["ss_widget_title"] != undefined ? decodeURIComponent(widget_options_array["ss_widget_title"]) : '',
            widget_appear_class = widget_options_array["appear_class"] != undefined ? widget_options_array["appear_class"] : -1,
            widget_lang = widget_options_array["lang"] != undefined ? widget_options_array["lang"] : "",
            widget_voice = widget_options_array["voice"] != undefined ? widget_options_array["voice"] : "",
            widget_speed = widget_options_array["speed"] != undefined ? widget_options_array["speed"] : "",
            widget_pitch = widget_options_array["pitch"] != undefined ? widget_options_array["pitch"] : "",
            widget_sel_voices = widget_options_array["sel_voices"] != undefined ? widget_options_array["sel_voices"] : -1,
            widget_sel_langs = widget_options_array["sel_langs"] != undefined ? widget_options_array["sel_langs"] : -1,
            widget_speed_enabled = widget_options_array["speed_enabled"] != undefined ? widget_options_array["speed_enabled"] : -1,
            widget_volume_enabled = widget_options_array["volume_enabled"] != undefined ? widget_options_array["volume_enabled"] : -1,
            widget_text_enabled = widget_options_array["text_enabled"] != undefined ? widget_options_array["text_enabled"] : -1,
            widget_context_enabled = widget_options_array["context_enabled"] != undefined ? widget_options_array["context_enabled"] : -1,
            widget_download_enabled = widget_options_array["download_enabled"] != undefined ? widget_options_array["download_enabled"] : -1,
            widget_plays_enabled = widget_options_array["plays_enabled"] != undefined ? widget_options_array["plays_enabled"] : -1,
            widget_voice_enabled = widget_options_array["voice_enabled"] != undefined ? widget_options_array["voice_enabled"] : -1,
            widget_lang_enabled = widget_options_array["lang_enabled"] != undefined ? widget_options_array["lang_enabled"] : -1,
            widget_status = widget_options_array["status"] != undefined ? widget_options_array["status"] : 1;
            render_pos = widget_options_array["render_pos"] != undefined ? widget_options_array["render_pos"] : 0;
            block_sub_type = widget_options_array["block_sub_type"] != undefined ? widget_options_array["block_sub_type"] : 0;
            widget_template = widget_options_array["template"] != undefined ? widget_options_array["template"] : (widget_type == 0 ? "sstemplate_8" : "sstemplate_1");
            widget_bg_class = widget_options_array["bg_class"] != undefined ? widget_options_array["bg_class"] : "ss_bg_19";
            widget_auto_load = widget_options_array["auto_load"] != undefined ? widget_options_array["auto_load"] : 0,

            soundcloud_enabled = widget_options_array["soundcloud_enabled"] != undefined ? widget_options_array["soundcloud_enabled"] : 0,
            newyork_enabled = widget_options_array["newyork_enabled"] != undefined ? widget_options_array["newyork_enabled"] : 0,
            np_hidden = widget_options_array["np_hidden"] != undefined ? widget_options_array["np_hidden"] : 0,
            play_style = widget_options_array["play_style"] != undefined ? widget_options_array["play_style"] : 0,
            np_style = widget_options_array["np_style"] != undefined ? widget_options_array["np_style"] : 0,
            rounded_icons = widget_options_array["rounded_icons"] != undefined ? widget_options_array["rounded_icons"] : 0,
            rounded_icons_bg = widget_options_array["rounded_icons_bg"] != undefined ? widget_options_array["rounded_icons_bg"] : 0,
            hide_header = widget_options_array["hide_header"] != undefined ? widget_options_array["hide_header"] : 0,
            no_bg = widget_options_array["no_bg"] != undefined ? widget_options_array["no_bg"] : 0,

            show_rht = widget_options_array["show_rht"] != undefined ? widget_options_array["show_rht"] : 1,
            rht_pos_class = widget_options_array["rht_pos_class"] != undefined ? widget_options_array["rht_pos_class"] : "ss_b_r",
            rht_hide_size = widget_options_array["rht_hide_size"] != undefined ? widget_options_array["rht_hide_size"] : -1,
            rht_hide_size_custom = widget_options_array["rht_hide_size_custom"] != undefined ? widget_options_array["rht_hide_size_custom"] : 1,
            welcome_repeat_interval_custom = widget_options_array["welcome_repeat_interval_custom"] != undefined ? widget_options_array["welcome_repeat_interval_custom"] : 1,
            banner_pos = widget_options_array["banner_pos"] != undefined ? widget_options_array["banner_pos"] : 0,
            welcome_repeat_interval = widget_options_array["welcome_repeat_interval"] != undefined ? widget_options_array["welcome_repeat_interval"] : 0,
            allowed_urls = widget_options_array["allowed_urls"] != undefined ? decodeURIComponent(widget_options_array["allowed_urls"]) : '',
            blocked_urls = widget_options_array["allowed_urls"] != undefined ? decodeURIComponent(widget_options_array["blocked_urls"]) : '',
            widget_width = widget_options_array["width"] != undefined ? widget_options_array["width"] : '',
            play_timeout = widget_options_array["play_timeout"] != undefined ? decodeURIComponent(widget_options_array["play_timeout"]) : '',
            rht_ic_pos = widget_options_array["rht_ic_pos"] != undefined ? widget_options_array["rht_ic_pos"] : 0;
            rht_ic_to = widget_options_array["rht_ic_to"] != undefined ? decodeURIComponent(widget_options_array["rht_ic_to"]) : '15%';

        if(widget_use_custom == 0) {
            widget_lang = ss_website_lang;
            widget_voice = ss_website_voice;
            widget_speed = ss_website_speed;
            widget_pitch = ss_website_pitch;
        }
        else {
            widget_lang = widget_lang == "" ? ss_website_lang : widget_lang;
            widget_voice = widget_voice == "" ? ss_website_voice : widget_voice;
            widget_speed = widget_speed == "" ? ss_website_speed : widget_speed;
            widget_pitch = widget_pitch == "" ? ss_website_pitch : widget_pitch;
            widget_sel_voices = widget_sel_voices == "" ? ss_website_sel_voices : widget_sel_voices;
        }

        widget_sel_langs = widget_sel_langs == -1 ? ss_website_sel_langs : widget_sel_langs;

        widget_voice_enabled = (ss_website_plan == 0 && widget_voice_enabled == 1) ? 0 : widget_voice_enabled;
        widget_lang_enabled = (ss_website_plan == 0 && widget_lang_enabled == 1) ? 0 : widget_lang_enabled;
        widget_text_enabled = (ss_website_plan == 0 && widget_text_enabled == 1) ? 0 : widget_text_enabled;
        widget_context_enabled = (ss_website_plan == 0 && widget_context_enabled == 1) ? 0 : widget_context_enabled;
        widget_download_enabled = (ss_website_plan == 0 && widget_download_enabled == 1) ? 0 : widget_download_enabled;
        widget_plays_enabled = (ss_website_plan == 0 && widget_plays_enabled == 1) ? 0 : widget_plays_enabled;

        // set sliders disabled
        var voice_type = parseInt(widget_voice.split('-')[1]);
        if(voice_type != 2 && voice_type != 5 && voice_type != 7) {
            $('.gsp_left_m_c_active .ss_slider_element_wrapper').addClass('gsp_option_disabled');
        }

        if(ss_website_plan == 0)
            $(".gsp_left_m_c_active .ss_premium_feature_li").addClass("ss_disabled");

        if(ss_website_plan == 0) {
            
            $(".ss_commercial_switcher").removeClass("gs_mono_switcher_button_on").addClass("ss_disabled");
            $(".ss_commercial_switcher").find(".gs_mono_checkbox").prop("checked",false);

            $(".ss_commercial_switcher.opts_input").attr("readonly", true);
        }

        // set widget title
        $("#ss_widget_title").val(widget_title);

         // set block type txt
        $("#ss_widget_type").data('widget_type', widget_type).val(widget_type_txt);

        // set data
        $("#lng_sel_wdg").data('val', widget_lang);
        $("#voice_sel_wdg").data('sel_voice', widget_voice);
        $("#wbs_w_voice_enabled").data('sel_voice', widget_sel_voices);
        $("#gsp_w_slider_speed .gsp_slider_wrapper").data('start_value', widget_speed);
        $("#gsp_w_slider_pitch .gsp_slider_wrapper").data('start_value', widget_pitch);

        $("#wbs_w_multiple_voices").data("sel_voice", widget_sel_voices);
        $("#ss_w_translation_options").data("sel_langs", widget_sel_langs);

        thisPage.createLangsListWidget();

        // set language
        var l_val = "";
        $("#lng_sel_wdg").find(".search_li").each(function() {
            if($(this).data("val") == widget_lang) {
                $(this).addClass("li_selected").addClass("ss_ul_li_act");
                l_val = $(this).find("span").html();

                return false;
            }
        });
        $("#lng_sel_wdg").find(".items_select_filter_content span").html(l_val);

        // set data
        if(content_selector != "")
            $("#ss_content_selector").val(content_selector);
        if(render_element != "")
            $("#ss_render_element").val(render_element);
        if(exclude_list != "")
            $("#ss_exclude_list").val(exclude_list);
        if(player_title_text != "")
            $("#ss_player_title_text").val(player_title_text);
        if(content_txt != "")
            $("#ss_content_text").val(content_txt);
        if(player_title_selector != "")
            $("#ss_player_title_selector").val(player_title_selector);
        if(allowed_urls != "")
            $("#ss_allowed_urls").val(allowed_urls);
        if(blocked_urls != "")
            $("#ss_blocked_urls").val(blocked_urls);
        if(widget_aliases != "")
            $("#ss_w_aliases").val(widget_aliases);
        if(margin_top !== "")
            $("#ss_margin_top").val(margin_top);
        if(margin_bottom !== "")
            $("#ss_margin_bottom").val(margin_bottom);
        if(widget_width != "")
            $("#ss_width").val(widget_width);
        if(rht_hide_size_custom != "")
            $("#wbs_rht_hide_size_custom").val(rht_hide_size_custom);
        if(play_timeout != "")
            $("#ss_play_timeout").val(play_timeout);
        $("#welcome_repeat_interval_custom").val(welcome_repeat_interval_custom);
        $("#ss_rht_icon_top_offset").val(rht_ic_to);

        // set texts
        if(widget_texts != '') {

            var widget_texts_arr = widget_texts.split('GSPEECH_DELIMETER');

            $("#ss_speed_text").val($this.escapeHTML(widget_texts_arr[0]));
            $("#ss_lang_text").val($this.escapeHTML(widget_texts_arr[1]));
            $("#ss_voice_text").val($this.escapeHTML(widget_texts_arr[2]));
            $("#ss_plays_text").val($this.escapeHTML(widget_texts_arr[3]));
            $("#ss_plays_title_text").val($this.escapeHTML(widget_texts_arr[4]));
            $("#ss_download_text").val($this.escapeHTML(widget_texts_arr[5]));
            $("#ss_downloaded_text").val($this.escapeHTML(widget_texts_arr[6]));
            $("#ss_open_text_text").val($this.escapeHTML(widget_texts_arr[7]));
            $("#ss_open_context_text").val($this.escapeHTML(widget_texts_arr[8]));
            $("#ss_close_context_text").val($this.escapeHTML(widget_texts_arr[9]));
            $("#ss_loading_text").val($this.escapeHTML(widget_texts_arr[10]));
            $("#ss_play_text").val($this.escapeHTML(widget_texts_arr[11]));
            $("#ss_pause_text").val($this.escapeHTML(widget_texts_arr[12]));
            $("#ss_options_text").val($this.escapeHTML(widget_texts_arr[13]));
            $("#ss_listen_text").val($this.escapeHTML(widget_texts_arr[14]));
            $("#ss_close_text").val($this.escapeHTML(widget_texts_arr[15]));
            $("#ss_listen_text_desc").val($this.escapeHTML(widget_texts_arr[16]));

        }

        if(widget_type == 3 && $("#ss_render_element").val() == "")
            $("#ss_render_element").val("body");

        if(widget_type == 4 && $("#ss_render_element").val() == "")
            $("#ss_render_element").val("body");

        if(show_rht == 1) {
            $("#wbs_show_rht").addClass("gs_mono_switcher_button_on");
            $("#wbs_show_rht").find(".gs_mono_checkbox").prop("checked", true);

            $(".ss_rht_banner_info").removeClass("ss_display_none");
            thisPage.generateWrapperHeight();
        }

        // set status
        if(widget_status == 1) {
            $("#wbs_w_status").addClass("gs_mono_switcher_button_on");
            $("#wbs_w_status").find(".gs_mono_checkbox").prop("checked", true);
        }
        else {
            $("#wbs_w_status").removeClass("gs_mono_switcher_button_on");
            $("#wbs_w_status").find(".gs_mono_checkbox").prop("checked", false);
        }

        // set icon pos
        if(rht_ic_pos == 1) {
            $("#wbs_rht_icon_pos").addClass("gs_mono_switcher_button_on");
            $("#wbs_rht_icon_pos").find(".gs_mono_checkbox").prop("checked", true);
        }
        else {
            $("#wbs_rht_icon_pos").removeClass("gs_mono_switcher_button_on");
            $("#wbs_rht_icon_pos").find(".gs_mono_checkbox").prop("checked", false);
        }

        // set render_pos
        if(render_pos == 1) {
            $("#wbs_render_pos").addClass("gs_mono_switcher_button_on");
            $("#wbs_render_pos").find(".gs_mono_checkbox").prop("checked", true);
        }
        else {
            $("#wbs_render_pos").removeClass("gs_mono_switcher_button_on");
            $("#wbs_render_pos").find(".gs_mono_checkbox").prop("checked", false);
        }

        // set auto load
        if(widget_auto_load == 1) {
            $("#wbs_auto_load").addClass("gs_mono_switcher_button_on");
            $("#wbs_auto_load").find(".gs_mono_checkbox").prop("checked", true);
        }
        else {
            $("#wbs_auto_load").removeClass("gs_mono_switcher_button_on");
            $("#wbs_auto_load").find(".gs_mono_checkbox").prop("checked", false);
        }

        // set soundcloud_enabled
        if(soundcloud_enabled == 1) {
            $("#ss_plr0_soundcloud_enabled").addClass("gs_mono_switcher_button_on");
            $("#ss_plr0_soundcloud_enabled").find(".gs_mono_checkbox").prop("checked", true);
        }
        else {
            $("#ss_plr0_soundcloud_enabled").removeClass("gs_mono_switcher_button_on");
            $("#ss_plr0_soundcloud_enabled").find(".gs_mono_checkbox").prop("checked", false);
        }

        // set newyork_enabled
        if(newyork_enabled == 1) {
            $("#ss_plr0_newyork_enabled").addClass("gs_mono_switcher_button_on");
            $("#ss_plr0_newyork_enabled").find(".gs_mono_checkbox").prop("checked", true);
        }
        else {
            $("#ss_plr0_newyork_enabled").removeClass("gs_mono_switcher_button_on");
            $("#ss_plr0_newyork_enabled").find(".gs_mono_checkbox").prop("checked", false);
        }

        // set np_hidden
        if(np_hidden == 1) {
            $("#ss_plr0_np_hidden").addClass("gs_mono_switcher_button_on");
            $("#ss_plr0_np_hidden").find(".gs_mono_checkbox").prop("checked", true);
        }
        else {
            $("#ss_plr0_np_hidden").removeClass("gs_mono_switcher_button_on");
            $("#ss_plr0_np_hidden").find(".gs_mono_checkbox").prop("checked", false);
        }

        // set play_style
        if(play_style == 1) {
            $("#ss_plr0_play_style").addClass("gs_mono_switcher_button_on");
            $("#ss_plr0_play_style").find(".gs_mono_checkbox").prop("checked", true);
        }
        else {
            $("#ss_plr0_play_style").removeClass("gs_mono_switcher_button_on");
            $("#ss_plr0_play_style").find(".gs_mono_checkbox").prop("checked", false);
        }

        // set np_style
        if(np_style == 1) {
            $("#ss_plr0_np_style").addClass("gs_mono_switcher_button_on");
            $("#ss_plr0_np_style").find(".gs_mono_checkbox").prop("checked", true);
        }
        else {
            $("#ss_plr0_np_style").removeClass("gs_mono_switcher_button_on");
            $("#ss_plr0_np_style").find(".gs_mono_checkbox").prop("checked", false);
        }

        // set rounded_icons
        if(rounded_icons == 1) {
            $("#ss_plr0_rounded_icons").addClass("gs_mono_switcher_button_on");
            $("#ss_plr0_rounded_icons").find(".gs_mono_checkbox").prop("checked", true);
        }
        else {
            $("#ss_plr0_rounded_icons").removeClass("gs_mono_switcher_button_on");
            $("#ss_plr0_rounded_icons").find(".gs_mono_checkbox").prop("checked", false);
        }

        // set rounded_icons_bg
        if(rounded_icons_bg == 1) {
            $("#ss_plr0_icons_bg").addClass("gs_mono_switcher_button_on");
            $("#ss_plr0_icons_bg").find(".gs_mono_checkbox").prop("checked", true);
        }
        else {
            $("#ss_plr0_icons_bg").removeClass("gs_mono_switcher_button_on");
            $("#ss_plr0_icons_bg").find(".gs_mono_checkbox").prop("checked", false);
        }

        // set hide_header
        if(hide_header == 1) {
            $("#ss_plr0_hide_header").addClass("gs_mono_switcher_button_on");
            $("#ss_plr0_hide_header").find(".gs_mono_checkbox").prop("checked", true);
        }
        else {
            $("#ss_plr0_hide_header").removeClass("gs_mono_switcher_button_on");
            $("#ss_plr0_hide_header").find(".gs_mono_checkbox").prop("checked", false);
        }

        // set no_bg
        if(no_bg == 1) {
            $("#ss_plr0_no_bg").addClass("gs_mono_switcher_button_on");
            $("#ss_plr0_no_bg").find(".gs_mono_checkbox").prop("checked", true);
        }
        else {
            $("#ss_plr0_no_bg").removeClass("gs_mono_switcher_button_on");
            $("#ss_plr0_no_bg").find(".gs_mono_checkbox").prop("checked", false);
        }

        // set widget_use_custom
        if(widget_use_custom == 1) {
            $("#wbs_custom_val").addClass("gs_mono_switcher_button_on");
            $("#wbs_custom_val").find(".gs_mono_checkbox").prop("checked", true);

            $(".ss_custom_values").removeClass("ss_display_none");
            thisPage.generateWrapperHeight();
        }
        else {
            $("#wbs_custom_val").removeClass("gs_mono_switcher_button_on");
            $("#wbs_custom_val").find(".gs_mono_checkbox").prop("checked", false);

            $(".ss_custom_values").addClass("ss_display_none");
            thisPage.generateWrapperHeight();
        }

        // set voice enabled
        $("#wbs_w_voice_enabled").find(".li_selected").removeClass("li_selected").removeClass("ss_ul_li_act");
        $("#wbs_w_voice_enabled").find(".search_li").each(function() {
            if($(this).data("val") == widget_voice_enabled) {
                $(this).addClass("li_selected").addClass("ss_ul_li_act").trigger("click");
                l_val = $(this).find("span").html();

                return false;
            }
        });
        $("#wbs_w_voice_enabled").find(".items_select_filter_content span").html(l_val);
        if(widget_voice_enabled == 1) {
            $("#wbs_w_multiple_voices").removeClass("ss_disabled");
        }

        // set wbs_appear_class 
        $("#wbs_w_appear_class").find(".li_selected").removeClass("li_selected").removeClass("ss_ul_li_act");
        $("#wbs_w_appear_class").find(".search_li").each(function() {
            if($(this).data("val") == widget_appear_class) {
                $(this).addClass("li_selected").addClass("ss_ul_li_act");
                l_val = $(this).find("span").html();

                return false;
            }
        });
        $("#wbs_w_appear_class").find(".items_select_filter_content span").html(l_val);

        // set langs enabled
        $("#wbs_w_langs_enabled").find(".li_selected").removeClass("li_selected").removeClass("ss_ul_li_act");
        $("#wbs_w_langs_enabled").find(".search_li").each(function() {
            if($(this).data("val") == widget_lang_enabled) {
                $(this).addClass("li_selected").addClass("ss_ul_li_act").trigger("click");;
                l_val = $(this).find("span").html();

                return false;
            }
        });
        $("#wbs_w_langs_enabled").find(".items_select_filter_content span").html(l_val);

        // set speed enabled
        $("#wbs_w_speed_enabled").find(".li_selected").removeClass("li_selected").removeClass("ss_ul_li_act");
        $("#wbs_w_speed_enabled").find(".search_li").each(function() {
            if($(this).data("val") == widget_speed_enabled) {
                $(this).addClass("li_selected").addClass("ss_ul_li_act");
                l_val = $(this).find("span").html();

                return false;
            }
        });
        $("#wbs_w_speed_enabled").find(".items_select_filter_content span").html(l_val);

        // set volume enabled
        $("#wbs_w_volume_enabled").find(".li_selected").removeClass("li_selected").removeClass("ss_ul_li_act");
        $("#wbs_w_volume_enabled").find(".search_li").each(function() {
            if($(this).data("val") == widget_volume_enabled) {
                $(this).addClass("li_selected").addClass("ss_ul_li_act");
                l_val = $(this).find("span").html();

                return false;
            }
        });
        $("#wbs_w_volume_enabled").find(".items_select_filter_content span").html(l_val);

        // set text enabled
        $("#wbs_w_text_enabled").find(".li_selected").removeClass("li_selected").removeClass("ss_ul_li_act");
        $("#wbs_w_text_enabled").find(".search_li").each(function() {
            if($(this).data("val") == widget_text_enabled) {
                $(this).addClass("li_selected").addClass("ss_ul_li_act");
                l_val = $(this).find("span").html();

                return false;
            }
        });
        $("#wbs_w_text_enabled").find(".items_select_filter_content span").html(l_val);

        // set context enabled
        $("#wbs_w_context_enabled").find(".li_selected").removeClass("li_selected").removeClass("ss_ul_li_act");
        $("#wbs_w_context_enabled").find(".search_li").each(function() {
            if($(this).data("val") == widget_context_enabled) {
                $(this).addClass("li_selected").addClass("ss_ul_li_act");
                l_val = $(this).find("span").html();

                return false;
            }
        });
        $("#wbs_w_context_enabled").find(".items_select_filter_content span").html(l_val);

        // set download enabled
        $("#wbs_w_download_enabled").find(".li_selected").removeClass("li_selected").removeClass("ss_ul_li_act");
        $("#wbs_w_download_enabled").find(".search_li").each(function() {
            if($(this).data("val") == widget_download_enabled) {
                $(this).addClass("li_selected").addClass("ss_ul_li_act");
                l_val = $(this).find("span").html();

                return false;
            }
        });
        $("#wbs_w_download_enabled").find(".items_select_filter_content span").html(l_val);

        // set plays enabled
        $("#wbs_w_plays_enabled").find(".li_selected").removeClass("li_selected").removeClass("ss_ul_li_act");
        $("#wbs_w_plays_enabled").find(".search_li").each(function() {
            if($(this).data("val") == widget_plays_enabled) {
                $(this).addClass("li_selected").addClass("ss_ul_li_act");
                l_val = $(this).find("span").html();

                return false;
            }
        });
        $("#wbs_w_plays_enabled").find(".items_select_filter_content span").html(l_val);

        // set banner info
        var l_val = "";
        $("#wbs_rht_pos_class").find(".li_selected").removeClass("li_selected").removeClass("ss_ul_li_act");
        $("#wbs_rht_pos_class").data("val", rht_pos_class).find(".search_li").each(function() {
            if($(this).data("val") == rht_pos_class) {
                $(this).addClass("li_selected").addClass("ss_ul_li_act");
                l_val = $(this).find("span").html();

                return false;
            }
        });
        $("#wbs_rht_pos_class").find(".items_select_filter_content span").html(l_val);

        var l_val = "";
        $("#wbs_rht_hide_size").find(".li_selected").removeClass("li_selected").removeClass("ss_ul_li_act");
        $("#wbs_rht_hide_size").data("val", rht_hide_size).find(".search_li").each(function() {
            if($(this).data("val") == rht_hide_size) {
                $(this).addClass("li_selected").addClass("ss_ul_li_act");
                l_val = $(this).find("span").html();

                return false;
            }
        });
        $("#wbs_rht_hide_size").find(".items_select_filter_content span").html(l_val);
        if(rht_hide_size == 1) {
            $('.ss_rht_custom_val_info').removeClass("ss_display_none");

            thisPage.generateWrapperHeight();
        }

        // set block sub type
        var l_val = "";
        $("#wbs_block_sub_type").find(".li_selected").removeClass("li_selected").removeClass("ss_ul_li_act");
        $("#wbs_block_sub_type").data("val", block_sub_type).find(".search_li").each(function() {
            if($(this).data("val") == block_sub_type) {
                $(this).addClass("li_selected").addClass("ss_ul_li_act");
                l_val = $(this).find("span").html();

                return false;
            }
        });
        $("#wbs_block_sub_type").find(".items_select_filter_content span").html(l_val);

        // set template
        var l_val = "";
        $("#wbs_template").find(".li_selected").removeClass("li_selected").removeClass("ss_ul_li_act");
        $("#wbs_template").data("val", widget_template).find(".search_li").each(function() {
            if($(this).data("val") == widget_template) {
                $(this).addClass("li_selected").addClass("ss_ul_li_act");
                l_val = $(this).find("span").html();

                return false;
            }
        });
        $("#wbs_template").find(".items_select_filter_content span").html(l_val);

        // template preview
        $("#ss_template_blocks_wrapper").find(".ss_tmp_selected").removeClass("ss_tmp_selected")
        $("#ss_template_blocks_wrapper").find(".ss_tmp_block").each(function() {
            if($(this).data("block_id") == widget_template) {
                $(this).addClass("ss_tmp_selected");

                return false;
            }
        });

        var l_val = "";
        $("#wbs_bg_class").find(".li_selected").removeClass("li_selected").removeClass("ss_ul_li_act");
        $("#wbs_bg_class").data("val", widget_bg_class).find(".search_li").each(function() {
            if($(this).data("val") == widget_bg_class) {
                $(this).addClass("li_selected").addClass("ss_ul_li_act");
                l_val = $(this).find("span").html();

                return false;
            }
        });
        $("#wbs_bg_class").find(".items_select_filter_content span").html(l_val);

        // welcome message
        if(banner_pos == 1) {
            $("#banner_pos").addClass("gs_mono_switcher_button_on");
            $("#banner_pos").find(".gs_mono_checkbox").prop("checked", true);
        }

        var l_val = "";
        $("#welcome_repeat_interval").find(".li_selected").removeClass("li_selected").removeClass("ss_ul_li_act");
        $("#welcome_repeat_interval").data("val", welcome_repeat_interval).find(".search_li").each(function() {
            if($(this).data("val") == welcome_repeat_interval) {
                $(this).addClass("li_selected").addClass("ss_ul_li_act");
                l_val = $(this).find("span").html();

                return false;
            }
        });
        $("#welcome_repeat_interval").find(".items_select_filter_content span").html(l_val);

        if(welcome_repeat_interval == 1) {
            $('.ss_welcome_m_custom_info').removeClass("ss_display_none");

             thisPage.generateWrapperHeight();
        }

        // create translation
        this.createTranslationListWidget();
        
        // voice tuning sliders
        var slider_callback = function() {
            $this.resetPlayerWidgetSettings();
        };
        this.applySliderFunctionality('.gsp_left_m_c_active .ss_slider_element_wrapper', slider_callback);

        // process voice
        this.processVoiceWidgetSettings();

        var lang = $("#lng_sel_wdg").find('.li_selected').data('val'),
            lang_p = lang.split('-');
            lang_to = lang_p[0];

        lang_to = lang_to == 'yue' ? 'zh' : lang_to;

        var set_vals_txts = function() {

            // set title text
            if(widget_type == 3 && $("#ss_player_title_text").val() == "") {

                var title_txt = "Read text";
                
                $("#ss_player_title_text").val(title_txt);
            }

            // title for welcome message
            if(widget_type == 4 && $("#ss_player_title_text").val() == "") {

                var title_txt = "This page wants to play audio";

                $("#ss_player_title_text").val(title_txt);
            }

            // set texts
            if($("#ss_speed_text").val() == "") {

                var texts = thisPage.texts_str.split(',');

                $("#ss_speed_text").val(texts[0]);
                $("#ss_lang_text").val(texts[1]);
                $("#ss_voice_text").val(texts[2]);
                $("#ss_plays_text").val(texts[3]);
                $("#ss_plays_title_text").val(texts[4]);
                $("#ss_download_text").val(texts[5]);
                $("#ss_downloaded_text").val(texts[6]);
                $("#ss_open_text_text").val(texts[7]);
                $("#ss_open_context_text").val(texts[8]);
                $("#ss_close_context_text").val(texts[9]);
                $("#ss_loading_text").val(texts[10]);
                $("#ss_play_text").val(texts[11]);
                $("#ss_pause_text").val(texts[12]);
                $("#ss_options_text").val(texts[13]);
                $("#ss_listen_text").val(texts[14]);
                $("#ss_close_text").val(texts[15]);
                $("#ss_close_text").val(texts[15]);
                $("#ss_listen_text_desc").val(texts[16]);
            }
        };

        if(lang_to == "en")
            set_vals_txts();

        var run_translations_block = function() {

            // set title text
            if(widget_type == 3 && $("#ss_player_title_text").val() == "") {

                var title_txt = "Read text";

                var translate_callback = function(translated) {

                    $("#ss_player_title_text").val(translated[0]);
                };

                if(lang_to != 'en')
                    window.gspeech.doSmartTranslate('en', lang_to, [title_txt], translate_callback);
            }

            // title for welcome message
            if(widget_type == 4 && $("#ss_player_title_text").val() == "") {

                var title_txt = "This page wants to play audio";

                var translate_callback = function(translated) {

                    $("#ss_player_title_text").val(translated[0]);
                };

                if(lang_to != 'en')
                    window.gspeech.doSmartTranslate('en', lang_to, [title_txt], translate_callback);
            }

            // set texts
            if($("#ss_speed_text").val() == "") {

                var texts = thisPage.texts_str.split(',');

                var translate_callback = function(translated) {

                    $("#ss_speed_text").val(translated[0]);
                    $("#ss_lang_text").val(translated[1]);
                    $("#ss_voice_text").val(translated[2]);
                    $("#ss_plays_text").val(translated[3]);
                    $("#ss_plays_title_text").val(translated[4]);
                    $("#ss_download_text").val(translated[5]);
                    $("#ss_downloaded_text").val(translated[6]);
                    $("#ss_open_text_text").val(translated[7]);
                    $("#ss_open_context_text").val(translated[8]);
                    $("#ss_close_context_text").val(translated[9]);
                    $("#ss_loading_text").val(translated[10]);
                    $("#ss_play_text").val(translated[11]);
                    $("#ss_pause_text").val(translated[12]);
                    $("#ss_options_text").val(translated[13]);
                    $("#ss_listen_text").val(translated[14]);
                    $("#ss_close_text").val(translated[15]);
                    $("#ss_listen_text_desc").val(translated[16]);
                };

                if(lang_to != 'en')
                    window.gspeech.doSmartTranslate('en', lang_to, [texts[0],texts[1],texts[2],texts[3],texts[4],texts[5],texts[6],texts[7],texts[8],texts[9],texts[10],texts[11],texts[12],texts[13],texts[14],texts[15],texts[16]], translate_callback);
            }
        };

        // run gspeech
        if(!$("#gspeech_js").length) {

            var id_script = "gspeech_js";
            var js_path = "https://widget.gspeech.io/" + this.options.gspeech_widget_id;

            $('<script>').appendTo('head').attr({type: 'text/javascript', id: id_script, src: js_path});
        }

        var interval_counter = 0;
        var check_int = setInterval(function() {

            if(window.gspeech != undefined) {
                
                clearInterval(check_int);

                setTimeout(function() {

                    thisPage.resetPlayerWidgetSettings();

                    thisPage.makeStylesTabClick(false);

                    thisPage.process_lang_change();

                    if(lang_to != "en")
                        run_translations_block();

                }, 200);
            }

            if(interval_counter > 50000) {
                clearInterval(check_int);
            }

            interval_counter ++;

        }, 25);
    };

    this.setValsAudio = function(audio_id, audio_data) {

        var $this = this;

        var audio_url = audio_data.audio_url;
        var audio_content = audio_data.audio_content;
        var audio_content_length = audio_data.audio_content_length;
        var audio_content_length = audio_data.audio_content_length;
        var audio_lang = audio_data.audio_lang;
        var audio_voice = audio_data.audio_voice;
        var audio_speed = audio_data.audio_speed;
        var audio_pitch = audio_data.audio_pitch;
        var widget_type_title = audio_data.widget_type_title;
        var plays_html = audio_data.plays_html;
        var countries_html = audio_data.countries_html;
        var cities_html = audio_data.cities_html;
        var devices_html = audio_data.devices_html;

        // set vals
        $('.ss_audio_url_holder a').html(audio_url).attr('href', audio_url);
        $('#ss_audio_content').html(audio_content);
        $('#ss_audio_c_l').html(audio_content_length);
        $('#ss_audio_plays_wrapper').html(plays_html);
        $('#ss_audio_countries_wrapper').html(countries_html);
        $('#ss_audio_cities_wrapper').html(cities_html);
        $('#ss_audio_devices_wrapper').html(devices_html);

        this.generateCharts('audio_analytics');

        // run gspeech
        if(!$("#gspeech_js").length) {

            var id_script = "gspeech_js";
            var js_path = "https://widget.gspeech.io/" + this.options.gspeech_widget_id;

            $('<script>').appendTo('head').attr({type: 'text/javascript', id: id_script, src: js_path});
        }

        var reset_ss_prv = function() {

            if(!thisPage.options.root_request) {

                $(".ssblock").each(function(i) {
                    var ssblock_id = $(this).data("id");
                    $(".gsp_htm_processed_" + ssblock_id).removeClass("gsp_htm_processed_" + ssblock_id);
                    $(this).remove();
                });
                $('.gsp_content_wrapper_set').removeClass("gsp_htm_processed").removeClass("gsp_content_wrapper_set");
                $(".sscontext_player").remove();
                $(".rht_banner_wrapper").remove();
                $(".ssplayer_rht").remove();
                $("#sscustom_rht").remove();

                window.gspeech.prepareSSBlocks();
            }

            $("#gsp_player_loading").addClass("gsp_hidden");

            var $player = $("#ss_dash_audio_player").find(".ssplayer_wrapper");

            $player.data("lang", audio_lang);
            $player.data("voice", audio_voice);
            $player.data("speed", audio_speed);
            $player.data("pitch", audio_pitch);
        };

        var interval_counter = 0;
        var check_int = setInterval(function() {

            if(window.gspeech != undefined) {
                
                clearInterval(check_int);

                setTimeout(function() {

                    reset_ss_prv();

                }, 200);
            }

            if(interval_counter > 1000) {
                clearInterval(check_int);
            }

            interval_counter ++;

        }, 25);
    };

    this.setValsWebsiteAnalytics = function(analytics_data) {

        var $this = this;

        var plays_html = analytics_data.plays_html;
        var countries_html = analytics_data.countries_html;
        var cities_html = analytics_data.cities_html;
        var devices_html = analytics_data.devices_html;

        // set vals
        $('#ss_web_an_plays_wrapper').html(plays_html);
        $('#ss_web_an_countries_wrapper').html(countries_html);
        $('#ss_web_an_cities_wrapper').html(cities_html);
        $('#ss_web_an_devices_wrapper').html(devices_html);

        this.generateCharts('website_analytics');
    };

    this.generateCharts = function(type) {

        this.generateStatChart(type);

        this.generatePieChartCountries(type);

        this.generatePieChartCities(type);

        this.generatePieChartDevices(type);
    }

    this.generateStatChart = function(type) {

        var $active_element = '',
            element_id = '';
        if(type == 'audio_analytics') {

            $active_element = $("#ss_audio_plays_wrapper");
            element_id = 'graph_container1';
        }
        else if(type == 'website_analytics') {

            $active_element = $("#ss_web_an_plays_wrapper");
            element_id = 'graph_container1_wa';
        }

        var data_array = [];
        var points_count = $active_element.find(".ss_play_item").length;

        if(points_count < 2 || points_count == undefined) {

            $("#" + element_id).html('<div class="graph_no_data_wrapper">No data available for plays statistics.</div>');
            return;
        }

        $active_element.find(".ss_play_item").each(function(i) {

            var $date_item = $(this);

            var point_date = $date_item.data("date"),
                point_val = $date_item.data("plays");

            var date_pieces = point_date.split('-'),
                date_y = date_pieces[0],
                date_m = date_pieces[1],
                date_d = date_pieces[2];

            date_m = parseInt(date_m);
            date_m --;
            date_m = date_m < 10 ? "0" + date_m : date_m;
            date_m = date_m == "00" ? "0" : date_m;

            var date_key = Date.UTC(date_y, date_m, date_d),
                d_array_item = [date_key, point_val];

            data_array.push(d_array_item);
        });

        Highcharts.theme = {
           // scroll charts
           rangeSelector: {
              buttonTheme: {
                 fill: {
                    linearGradient: { x1: 0, y1: 0, x2: 0, y2: 1 },
                    stops: [
                       [0.4, '#333'],
                       [0.6, '#000']
                    ]
                 },
                 stroke: '#000000',
                 style: {
                    color: '#888',
                    fontWeight: 'bold'
                 },
                 states: {
                    hover: {
                       fill: {
                          linearGradient: { x1: 0, y1: 0, x2: 0, y2: 1 },
                          stops: [
                             [0.4, '#555'],
                             [0.6, '#111']
                          ]
                       },
                       stroke: '#000000',
                       style: {
                          color: 'white'
                       }
                    },
                    select: {
                       fill: {
                          linearGradient: { x1: 0, y1: 0, x2: 0, y2: 1 },
                          stops: [
                             [0.1, '#000'],
                             [0.3, '#333']
                          ]
                       },
                       stroke: '#000000',
                       style: {
                          color: 'yellow'
                       }
                    }
                 }
              },
              inputStyle: {
                 backgroundColor: '#333',
                 color: 'silver'
              },
              labelStyle: {
                 color: 'silver'
              }
           },
        };

        window.chart = new Highcharts.StockChart({
            colors: ["#9765bb", "#55BF3B", "#DF5353", "#9765bb", "#aaeeee", "#ff0066", "#eeaaee",
                    "#55BF3B", "#DF5353", "#9765bb", "#aaeeee"],
                    
            chart : {
                renderTo : element_id,
                backgroundColor:'rgba(0, 0, 0, 0.2)',
                color: "#fff",
                marginRight: 10,
                marginBottom: 0,
                backgroundColor: {
                     linearGradient: { x1: 0, y1: 0, x2: 1, y2: 1 },
                     stops: [
                        [0, '#ffffff'],
                        [1, '#ffffff']
                     ]
                },
                borderColor: '#d2d2d2',
                borderWidth: 1,
                className: 'dark-container',
                plotBackgroundColor: 'rgba(255, 255, 255, 0.05)',
                plotBorderColor: '#d2d2d2',
                plotBorderRadius: 3,
                plotBorderWidth: 1
            },

        title : {
            text : 'Audio Plays Chart',
             style: {
                    fontSize: "16px", 
                    fontWeight: "bold",
                    color: "#999",
                    shadow : true
             }
        },

        scrollbar: {
            barBackgroundColor: '#d2d2d2',
            barBorderRadius: 3,
            barBorderWidth: 1,
            buttonBackgroundColor: '#d2d2d2',
            buttonBorderWidth: 1,
            buttonBorderRadius: 3,
            trackBackgroundColor: '#d2d2d2',
            trackBorderWidth: 1,
            trackBorderRadius: 8,
            trackBorderColor: '#222',
              barBackgroundColor: {
                    linearGradient: { x1: 0, y1: 0, x2: 0, y2: 1 },
                    stops: [
                       [0.4, '#d2d2d2'],
                       [0.6, '#d2d2d2']
                    ]
                 },
              barBorderColor: '#d2d2d2',
              buttonArrowColor: '#d2d2d2',
              buttonBackgroundColor: {
                    linearGradient: { x1: 0, y1: 0, x2: 0, y2: 1 },
                    stops: [
                       [0.4, '#d2d2d2'],
                       [0.6, '#d2d2d2']
                    ]
                 },
              buttonBorderColor: '#d2d2d2',
              rifleColor: '#fff',
              rifleBackgroundColor: '#fff',
              trackBackgroundColor: {
                 linearGradient: { x1: 0, y1: 0, x2: 0, y2: 1 },
                 stops: [
                    [0, '#fff'],
                    [1, '#fff']
                 ]
              },
              trackBorderColor: '#d2d2d2'
           },

           xAxis: {
                  gridLineColor: '#ededed',
                  gridLineWidth: 1,
                  labels: {
                     style: {
                        color: '#555'
                     }
                  },
                  lineColor: '#999',
                  tickColor: '#222',
                  title: {
                     style: {
                        color: '#222',
                        fontWeight: 'bold',
                        fontSize: '12px',
                        fontFamily: 'Trebuchet MS, Verdana, sans-serif'

                     }
                  }
               },

         yAxis: {
             gridLineColor: '#ededed',
              labels: {
                 style: {
                    color: '#777'
                 }
              },
              lineColor: '#000',
              tickColor: '#000',
              title: {
                 style: {
                    color: '#000',
                    fontWeight: 'bold',
                    fontSize: '12px'
                 }
              },
              minPadding: 0, 
              maxPadding: 0.1,         
              min: 0
            }, 

            tooltip: {
                  backgroundColor: 'rgba(0, 0, 0, 0.75)',
                  style: {
                     color: '#F0F0F0'
                  }
               },
               toolbar: {
                  itemStyle: {
                     color: 'silver'
                  }
               },
               plotOptions: {
                  line: {
                     dataLabels: {
                        color: '#CCC'
                     },
                     marker: {
                        lineColor: '#333'
                     }
                  },
                  spline: {
                     marker: {
                        lineColor: '#333'
                     }
                  },
                  scatter: {
                     marker: {
                        lineColor: '#333'
                     }
                  },
                  candlestick: {
                     lineColor: 'white'
                  }
               },
               legend: {
                  itemStyle: {
                     font: '9pt Trebuchet MS, Verdana, sans-serif',
                     color: '#A0A0A0'
                  },
                  itemHoverStyle: {
                     color: '#FFF'
                  },
                  itemHiddenStyle: {
                     color: '#444'
                  }
               },
               credits: {
                  style: {
                     color: '#666'
                  }
               },
               labels: {
                  style: {
                     color: '#CCC'
                  }
               },

               navigation: {
                  buttonOptions: {
                    align: 'right',
                     symbolStroke: '#888',
                     hoverSymbolStroke: '#555',
                     theme: {
                        fill: {
                           linearGradient: { x1: 0, y1: 0, x2: 0, y2: 1 },
                           stops: [
                              [0.4, '#606060'],
                              [0.6, '#333333']
                           ]
                        },
                        stroke: '#000000'
                     }
                  },
                  handles: {
                     backgroundColor: '#666',
                     borderColor: '#AAA'
                  },
                  outlineColor: '#CCC',
                  maskFill: 'rgba(0, 0, 0, 0.5)',
                  series: {
                     color: '#a770ce',
                     lineColor: '#a770ce'
                  }
               },

                // scroll charts
               rangeSelector: {
                  selected : 0,
                  buttonTheme: {
                     fill: {
                        linearGradient: { x1: 0, y1: 0, x2: 0, y2: 1 },
                        stops: [
                           [0.4, '#ededed'],
                           [0.6, '#ededed']
                        ]
                     },
                     stroke: '#fff',
                     style: {
                        color: '#999',
                        fontWeight: 'bold'
                     },
                     states: {
                        hover: {
                           fill: {
                              linearGradient: { x1: 0, y1: 0, x2: 0, y2: 1 },
                              stops: [
                                 [0.4, '#ededed'],
                                 [0.6, '#ededed']
                              ]
                           },
                           stroke: '#fff',
                           style: {
                              color: '#555'
                           }
                        },
                        select: {
                           fill: {
                              linearGradient: { x1: 0, y1: 0, x2: 0, y2: 1 },
                              stops: [
                                 [0.1, '#000'],
                                 [0.3, '#333']
                              ]
                           },
                           stroke: '#000000',
                           style: {
                              color: '#a770ce'
                           }
                        }
                     }
                  },
                  inputStyle: {
                     backgroundColor: '#333',
                     color: 'silver'
                  },
                  labelStyle: {
                     color: 'silver'
                  }
               },

                series : [
                {
                    name : 'Plays',
                    type: 'areaspline',
                    data :
                        data_array,
                    marker : {
                        enabled : true,
                        color: "#fff",
                        radius : 2
                    },
                    shadow : true,
                    tooltip : {
                        valueDecimals : 0
                    },
                    fillColor : {
                        linearGradient : {
                            x1: 0, 
                            y1: 0, 
                            x2: 0, 
                            y2: 1
                        },
                        // stops : [[0, Highcharts.getOptions().colors[1]], [1, "rgba(0,0,0,0)"]]
                        stops : [[0, "#5e367b"], [1, "#3a0c5b52"]]
                    }
                }
            ]
        });
    };

    this.generatePieChartDevices = function(type) {

        var $active_element = '',
            element_id = '';
        if(type == 'audio_analytics') {

            $active_element = $("#ss_audio_devices_wrapper");
            element_id = 'graph_container3';
        }
        else if(type == 'website_analytics') {

            $active_element = $("#ss_web_an_devices_wrapper");
            element_id = 'graph_container3_wa';
        }

        var data_array = [];
        var points_count = $active_element.find(".ss_device_item").length;

        if(points_count == undefined) {

            $("#" + element_id).html('<div class="graph_no_data_wrapper">No data available for device statistics.</div>');
            return;
        }

        $active_element.find(".ss_device_item").each(function(i) {

            var $device_item = $(this);

            var device = $device_item.data("device"),
                point_val = $device_item.data("val");

            var c_array_item = [device, point_val];

            data_array.push(c_array_item);
        });

        var chart;
        chart = new Highcharts.Chart({
            colors: ["#9765bb", "#55BF3B", "#DF5353", "#9765bb", "#aaeeee", "#ff0066", "#eeaaee",
                    "#55BF3B", "#DF5353", "#9765bb", "#aaeeee"],
            chart: {
                renderTo: element_id,
                plotBackgroundColor: null,
                plotBorderWidth: null,
                plotShadow: false
            },
            title: {
                text: 'Device Statistics',
                style: {
                    fontSize: "16px", 
                    fontWeight: "bold",
                    color: "#999",
                    shadow : true
                 }
            },
            tooltip: {
                formatter: function() {
                    return '<b>'+ this.point.name +'</b>: '+ this.percentage.toFixed(2) +' %';
                }
            },
            plotOptions: {
                pie: {
                    allowPointSelect: true,
                    cursor: 'pointer',
                    dataLabels: {
                        enabled: true,
                        color: '#444444',
                        connectorColor: '#555555',
                        formatter: function() {
                            return '<b>'+ this.point.name +'</b>: '+ this.percentage.toFixed(2) +' %';
                        }
                    },
                    showInLegend: true
                }
            },
            series: [{
                type: 'pie',
                name: '',
                data: data_array
            }]
        });
    };

    this.generatePieChartCountries = function(type) {

        var $active_element = '',
            element_id = '';
        if(type == 'audio_analytics') {

            $active_element = $("#ss_audio_countries_wrapper");
            element_id = 'graph_container2';
        }
        else if(type == 'website_analytics') {

            $active_element = $("#ss_web_an_countries_wrapper");
            element_id = 'graph_container2_wa';
        }

        var data_array = [];
        var points_count = $active_element.find(".ss_country_item").length;

        if(points_count == undefined) {

            $("#" + element_id).html('<div class="graph_no_data_wrapper">No data available for country statistics.</div>');
            return;
        }

        $active_element.find(".ss_country_item").each(function(i) {

            var $country_item = $(this);

            var country = $country_item.data("country"),
                point_val = $country_item.data("val");

            var c_array_item = [country, point_val];

            data_array.push(c_array_item);
        });

        var chart;
        chart = new Highcharts.Chart({
            colors: ["#9765bb", "#55BF3B", "#DF5353", "#aaeeee", "#ff0066", "#eeaaee",
                    "#55BF3B", "#DF5353", "#9765bb", "#aaeeee"],
            chart: {
                renderTo: element_id,
                plotBackgroundColor: null,
                plotBorderWidth: null,
                plotShadow: false
            },
            title: {
                text: 'Country Statistics',
                style: {
                    fontSize: "16px", 
                    fontWeight: "bold",
                    color: "#999",
                    shadow : true
                 }
            },
            tooltip: {
                formatter: function() {
                    return '<b>'+ this.point.name +'</b>: '+ this.percentage.toFixed(2) +' %';
                }
            },
            plotOptions: {
                pie: {
                    allowPointSelect: true,
                    cursor: 'pointer',
                    dataLabels: {
                        enabled: true,
                        color: '#444444',
                        connectorColor: '#555555',
                        formatter: function() {
                            return '<b>'+ this.point.name +'</b>: '+ this.percentage.toFixed(2) +' %';
                        }
                    },
                    showInLegend: true
                }
            },
            series: [{
                type: 'pie',
                name: '',
                data: data_array
            }]
        });
    };

    this.generatePieChartCities = function(type) {

        var $active_element = '',
            element_id = '';
        if(type == 'audio_analytics') {

            $active_element = $("#ss_audio_cities_wrapper");
            element_id = 'graph_container4';
        }
        else if(type == 'website_analytics') {

            $active_element = $("#ss_web_an_cities_wrapper");
            element_id = 'graph_container4_wa';
        }

        var data_array = [];
        var points_count = $active_element.find(".ss_city_item").length;

        if(points_count == undefined) {

            $("#" + element_id).html('<div class="graph_no_data_wrapper">No data available for cities statistics.</div>');
            return;
        }

        $active_element.find(".ss_city_item").each(function(i) {

            var $city_item = $(this);

            var city = $city_item.data("city"),
                point_val = $city_item.data("val");

            var c_array_item = [city, point_val];

            data_array.push(c_array_item);
        });


        var chart;
        chart = new Highcharts.Chart({
            colors: ["#9765bb", "#55BF3B", "#DF5353", "#aaeeee", "#ff0066", "#eeaaee",
                    "#55BF3B", "#DF5353", "#9765bb", "#aaeeee"],
            chart: {
                renderTo: element_id,
                plotBackgroundColor: null,
                plotBorderWidth: null,
                plotShadow: false
            },
            title: {
                text: 'City Statistics',
                style: {
                    fontSize: "16px", 
                    fontWeight: "bold",
                    color: "#999",
                    shadow : true
                 }
            },
            tooltip: {
                formatter: function() {
                    return '<b>'+ this.point.name +'</b>: '+ this.percentage.toFixed(2) +' %';
                }
            },
            plotOptions: {
                pie: {
                    allowPointSelect: true,
                    cursor: 'pointer',
                    dataLabels: {
                        enabled: true,
                        color: '#444444',
                        connectorColor: '#555555',
                        formatter: function() {
                            return '<b>'+ this.point.name +'</b>: '+ this.percentage.toFixed(2) +' %';
                        }
                    },
                    showInLegend: true
                }
            },
            series: [{
                type: 'pie',
                name: '',
                data: data_array
            }]
        });
    };

    this.resetPlayerWidgetSettings = function() {

        var $player = $(".ss_voice_preview_widget_wrapper").find(".ssplayer_wrapper");

        var $gsLanguageSelector = $("#lng_sel_wdg"),
            $gsVoiceSelector = $("#voice_sel_wdg");

        var player_lang = $gsLanguageSelector.find("li.li_selected").data('val');
        var player_voice = $gsVoiceSelector.find('.li_selected').data('val');

        var player_speed = $("#gsp_w_slider_speed").find('.gsp_value_label').val();
        var player_pitch = $("#gsp_w_slider_pitch").find('.gsp_value_label').val();
        var player_html = $(".voice_preview_data").data("preview_txt_ready");

        if(player_lang == -1 || player_voice == undefined) {
            player_lang = "en-US";
            player_html = player_lang == -1 ? "Please choose language" : "Please choose voice";
            player_voice = "C-2";
            player_speed = 1;
            player_pitch = 0;
        }

        $player.data("lang", player_lang);
        $player.data("voice", player_voice);
        $player.data("speed", player_speed);
        $player.data("pitch", player_pitch);
        $player.find(".ssplayer_audio_content").html(player_html);

        if($player.find(".ssplayer_icon_bg").hasClass("ssplayer_loading")) {
            window.gspeech.showeAbortMessage = false;
            window.gspeech.request.abort();
        }

        $player.find(".ssplayer_icon_bg").removeClass("ssplayer_play").removeClass("ssplayer_pause").removeClass("ssplayer_loading").addClass("ssplayer_speaker");
        $player.find(".ssplayer_txt_wrapper").removeClass("ssplayer_play").removeClass("ssplayer_pause").removeClass("ssplayer_loading").addClass("ssplayer_speaker");

        $player.data('once_loaded', false);
        $player.data('cur_s', 0);
        $player.find('.sstimeline_active').width('0%');
        $player.find('.ss_time_start').html('0:00');
        $player.find('.ss_time_end').html('0:00');

        var name_hash = $player.data("name_hash");
        if(name_hash != undefined) {
            var $playerElG = $('.' + name_hash).get(0);
            $playerElG.pause();
            $playerElG.currentTime = 0;
        }
    };

    this.resetPlayerWidgetPreview = function() {

        setTimeout(function() {

            var $player;
            if($(".gsp_left_m_c_active .dashboard_content").hasClass("ss_dash_page_type_0"))
                $player = $(".ss_full_player_preview").find(".ssplayer_wrapper");
            else if($(".gsp_left_m_c_active .dashboard_content").hasClass("ss_dash_page_type_1"))
                $player = $(".ss_button_player_preview").find(".ssplayer_wrapper");
            else if($(".gsp_left_m_c_active .dashboard_content").hasClass("ss_dash_page_type_2"))
                $player = $(".ss_circle_player_preview").find(".ssplayer_wrapper");
            else if($(".gsp_left_m_c_active .dashboard_content").hasClass("ss_dash_page_type_3")) {

                $player = $(".ssplayer_rht");
                $player.removeClass("ssplayer_display_none").addClass("rht_visible").addClass("ss_opacity_1").css({'top': 0,'left': 0});
                $(".ss_rht_player_preview").html($player);

                // create languages object
                if($player.find(".ssplayer_lang_block").length) {
                    
                }
            }

            var $gsLanguageSelector = $("#lng_sel_wdg"),
                $gsVoiceSelector = $("#voice_sel_wdg");

            var player_lang = $gsLanguageSelector.find("li.li_selected").data('val'),
                player_voice = $gsVoiceSelector.find('.li_selected').data('val'),
                player_speed = $("#gsp_w_slider_speed").find('.gsp_value_label').val(),
                player_pitch = $("#gsp_w_slider_pitch").find('.gsp_value_label').val(),
                player_html = $(".voice_preview_data").data("preview_txt_ready");

            var voice_unknown = false;
            if(player_voice == undefined) {
                player_lang = "en-US";
                player_html = "Please choose voice";
                player_voice = "C-2";
                player_speed = 1;
                player_pitch = 0;
                voice_unknown = true;
            }

            $player.data("lang", player_lang);
            $player.data("voice", player_voice);
            $player.data("speed", player_speed);
            $player.data("pitch", player_pitch);
            $player.find(".ssplayer_audio_content").html(player_html);

            if($(".gsp_left_m_c_active .dashboard_content").hasClass("ss_dash_page_type_3")) {

                $player.find(".ssplayer_txt_c span").html(player_html);
                var pl_id = $player.attr("id");
                $("#content_" + player_lang.split('-')[0] + "_" + pl_id).html(player_html);

                $player.find('.ssplayer_volume_block').data('volume',100);
                $player.find('.ssplayer_speed_block').data('speed',1);

                if($player.find(".ssplayer_lang_block").length) {

                    var lang_code = $gsLanguageSelector.find(".li_selected").data("val");
                    var voices_data = $gsLanguageSelector.find(".li_selected").data("voices_data");

                    var sel_langs = lang_code + '|' + voices_data;
                    sel_langs = sel_langs.replace(/:/g, '-');

                    if(voice_unknown && lang_code != 'en-US') {

                        lang_code =  player_lang;

                        sel_langs += ';' + player_lang + '|A-2';
                    }

                    var langsUl = window.gspeech.createLangsList(lang_code, sel_langs);
                    $player.find('.ssplayer_lang_options').html(langsUl);

                    // $player.find(".ssplayer_lang_block").find('.sslang_sel').removeClass("sslang_sel").removeClass("ss_li_act");
                    // $player.find(".ssplayer_lang_block").find('.option-' + player_lang).addClass("sslang_sel").addClass("ss_li_act");
                }
            }

            // $player.data('once_loaded', false);
            // $player.data('cur_s', 0);


            // update classes
            var tmp_class = $("#wbs_template").find(".li_selected").data("val");
            var bg_class = $("#wbs_bg_class").find(".li_selected").data("val");
            var player_class = $player.attr("class");

            //3.7.0
            var bg_icons_class = "";
            if($(".gsp_left_m_c_active .dashboard_content").hasClass("ss_dash_page_type_0")) {
                if(thisPage.inArray(bg_class,['ss_bg_19','ss_bg_20','ss_bg_21','ss_bg_22','ss_bg_23','ss_bg_24','ss_bg_25','ss_bg_26','ss_bg_27','ss_bg_28','ss_bg_29','ss_bg_30','ss_bg_31','ss_bg_32','ss_bg_33','ss_bg_34','ss_bg_35','ss_bg_36','ss_bg_37','ss_bg_38']))
                    bg_icons_class = 'ss_bg_scheme_gray';
                else if(thisPage.inArray(bg_class,['ss_bg_18','ss_bg_39','ss_bg_40','ss_bg_41','ss_bg_42','ss_bg_43','ss_bg_44']))
                    bg_icons_class = 'ss_bg_scheme_violet';
                else if(thisPage.inArray(bg_class,['ss_bg_45','ss_bg_46','ss_bg_47','ss_bg_48','ss_bg_49','ss_bg_50','ss_bg_51']))
                    bg_icons_class = 'ss_bg_scheme_pink';
                else if(thisPage.inArray(bg_class,['ss_bg_52','ss_bg_53','ss_bg_54','ss_bg_55','ss_bg_56','ss_bg_57']))
                    bg_icons_class = 'ss_bg_scheme_red';
                else if(thisPage.inArray(bg_class,['ss_bg_58','ss_bg_59','ss_bg_60','ss_bg_61','ss_bg_62','ss_bg_63','ss_bg_64','ss_bg_65','ss_bg_66','ss_bg_67']))
                    bg_icons_class = 'ss_bg_scheme_blue';
                else if(thisPage.inArray(bg_class,['ss_bg_68','ss_bg_69','ss_bg_70','ss_bg_71']))
                    bg_icons_class = 'ss_bg_scheme_brown';
                else if(thisPage.inArray(bg_class,['ss_bg_72','ss_bg_73','ss_bg_74','ss_bg_75']))
                    bg_icons_class = 'ss_bg_scheme_green';
                else if(thisPage.inArray(bg_class,['ss_bg_76','ss_bg_77','ss_bg_78']))
                    bg_icons_class = 'ss_bg_scheme_yellow';
                else if(thisPage.inArray(bg_class,['ss_bg_79','ss_bg_80','ss_bg_81','ss_bg_82','ss_bg_83','ss_bg_84','ss_bg_85']))
                    bg_icons_class = 'ss_bg_scheme_wood';

                player_class = player_class.replace(/ss_bg_scheme_[a-z]+/, bg_icons_class);
            }

            player_class = player_class.replace(/sstemplate_[0-9]+/, tmp_class);
            player_class = player_class.replace(/ss_bg_[0-9]+/, bg_class);

            $player.attr("class", player_class);

            if(bg_icons_class != "") {
                if(!$player.hasClass(bg_icons_class))
                    $player.addClass(bg_icons_class);
            }

            // update width/height if needed
            var width = $("#ss_width").val();
            if(!$(".gsp_left_m_c_active .dashboard_content").hasClass("ss_dash_page_type_3"))
                $player.width(width);
            if($(".gsp_left_m_c_active .dashboard_content").hasClass("ss_dash_page_type_2"))
                $player.height(width);

        }, 200);
    };

    this.processVoiceWidgetSettings = function() {

        this.updateVoiceWidgetSettings();

        setTimeout(function(){

            this.resetPlayerWidgetSettings();
        }.bind(this), 400);
    };

    this.updateVoiceWidgetSettings = function() {

        var $this = this;

        var $gsLanguageSelector = $("#lng_sel_wdg"),
            $gsVoiceSelector = $("#voice_sel_wdg"),
            $gsMultipleVoiceSelector = $("#wbs_w_multiple_voices");

        var lang_code = $gsLanguageSelector.find("li.li_selected").data('val'),
            voices_data = $gsLanguageSelector.find("li.li_selected").data('voices_data'),
            plan_id = $("#ss_widget_page_data").data("website_plan"),
            voice_code_sel = $gsVoiceSelector.data('sel_voice'),
            voice_code_sel_multiple = $gsMultipleVoiceSelector.data('sel_voice'),
            def_txt_voice = $gsVoiceSelector.data("def_txt"),
            def_txt_m_voices = $gsMultipleVoiceSelector.data("def_txt"),
            saved_language = $gsLanguageSelector.data('val');

        voice_code_sel = saved_language == lang_code ? voice_code_sel : '';
        voice_code_sel_multiple = saved_language == lang_code ? voice_code_sel_multiple : '';

        var voice_options = $this.generateVoices(voices_data, lang_code);

        $gsVoiceSelector.find('.items_select_ul').html(voice_options);

        // set selection
        if(voice_code_sel != '') {
            $gsVoiceSelector.find('.option-' + voice_code_sel).addClass("li_selected").addClass("ss_ul_li_act");
            var voice_cont_val = $gsVoiceSelector.find(".li_selected span").html();

            var sel_voice_data = $gsVoiceSelector.find(".li_selected").data("val");
            var sel_voice_data_p = sel_voice_data.split('-');
            var sel_voice_type = sel_voice_data_p[1] != undefined ? sel_voice_data_p[1] : 0;
        }
        else {
            var voice_cont_val = def_txt_voice;
            var sel_voice_type = 0;
        }
        $gsVoiceSelector.find('.items_select_filter_content span').html(voice_cont_val);

        if(sel_voice_type != 2 && sel_voice_type != 5 && sel_voice_type != 7)
            $(".gsp_left_m_c_active .gsp_option_disable_switcher").addClass("gsp_option_disabled");
        else
            $(".gsp_left_m_c_active .gsp_option_disable_switcher").removeClass("gsp_option_disabled");
       
        // multiple voices
        if(plan_id != 0 && $('#wbs_w_voice_enabled').find(".li_selected").data("val") == 1) {

            $gsMultipleVoiceSelector.find('.items_select_ul').html(voice_options);
            
            if(voice_code_sel != "")
                $gsMultipleVoiceSelector.find('.option-' + voice_code_sel).addClass("li_selected").addClass("ss_option_hardcoded").addClass("ss_ul_li_act");

            var voice_cont_val = '';

            if(voice_code_sel_multiple != '' && voice_code_sel_multiple != -1) {

                var sel_codes_array = voice_code_sel_multiple.split(',');

                $gsMultipleVoiceSelector.find('.search_li').each(function() {

                    var d_val = $(this).data("val"),
                        d_name = $(this).find("span").html();

                    if(thisPage.inArray(d_val,sel_codes_array)) {

                        $(this).addClass("li_selected").addClass("ss_ul_li_act");
                        voice_cont_val += voice_cont_val == '' ? d_name : ', ' + d_name;
                    }
                });
            }
            else{

                if(!$gsMultipleVoiceSelector.find('.li_selected').length)
                    voice_cont_val = def_txt_m_voices;
                else
                    voice_cont_val = $gsMultipleVoiceSelector.find('.li_selected span').html();
            }

            $gsMultipleVoiceSelector.find('.items_select_filter_content span').html(voice_cont_val);
        }

        // set preview audios
        // $gsVoiceSelector.find(".search_li").each(function() {

        //     $(this).data("name_hash", $this.preview_audios[lang_code][$(this).data("val")]);
        // });
        // $gsMultipleVoiceSelector.find(".search_li").each(function() {
            
        //     $(this).data("name_hash", $this.preview_audios[lang_code][$(this).data("val")]);
        // });

        // make languages corrections
        $('.gsp_left_m_c_active .ss_tr_block_hardcoded').find('.ss_option_hardcoded').removeClass("ss_option_hardcoded");
        $('.gsp_left_m_c_active .ss_tr_block_hardcoded').removeClass("ss_tr_block_hardcoded").find('.ss_checkbox_wrapper').removeClass("ss_disabled");
        $(".gsp_left_m_c_active .ss_lang_holder_" + lang_code).addClass("ss_tr_block_hardcoded").find('.ss_checkbox_wrapper').addClass("ss_checked").addClass("ss_disabled");
        $(".gsp_left_m_c_active .ss_lang_holder_" + lang_code).find(".ss_tr_line2").addClass("ss_tr_line2_v").addClass("ss_ov_v");

        // sync voice with translation block
        if(voice_code_sel != "") {
            $(".gsp_left_m_c_active .ss_lang_holder_" + lang_code).find('.li_selected').removeClass("li_selected").removeClass("ss_ul_li_act");
            $(".gsp_left_m_c_active .ss_lang_holder_" + lang_code).find('.option-' + voice_code_sel).addClass("li_selected").addClass("ss_option_hardcoded").addClass("ss_ul_li_act");
        }
        var voice_cont_val = '';
        if(voice_code_sel_multiple != '' && voice_code_sel_multiple != -1) {

            var sel_codes_array = voice_code_sel_multiple.split(',');

            $(".gsp_left_m_c_active .ss_lang_holder_" + lang_code).find('.search_li').each(function() {

                var d_val = $(this).data("val"),
                    d_name = $(this).find("span").html();

                if(thisPage.inArray(d_val,sel_codes_array)) {

                    $(this).addClass("li_selected").addClass("ss_ul_li_act");
                    voice_cont_val += voice_cont_val == '' ? d_name : ', ' + d_name;
                }
            });
        }
        else {
            voice_cont_val = $(".ss_lang_holder_" + lang_code).find("li_selected span").html();
        }
        $(".gsp_left_m_c_active .ss_lang_holder_" + lang_code).find('.items_select_filter_content span').html(voice_cont_val);

        thisPage.generateWrapperHeight();

        // add disabled class
        if(plan_id == 0) {
            $("#voice_sel_wdg").find(".ss_voice_type_1").addClass("ss_disabled");
            $("#voice_sel_wdg").find(".ss_voice_type_2").addClass("ss_disabled");
            $("#voice_sel_wdg").find(".ss_voice_type_3").addClass("ss_disabled");
            $("#voice_sel_wdg").find(".ss_voice_type_4").addClass("ss_disabled");
            $("#voice_sel_wdg").find(".ss_voice_type_5").addClass("ss_disabled");
        }
    };

    this.createTranslationListWidget = function() {

        var $this = this;

        var $lng_sel = $("#ss_w_translation_options");

        if(!$lng_sel.length)
            return;

        var appsumo = 0;
        const $appsumoElement = $("#gsp_appsumo");
        if ($appsumoElement.length) {
            appsumo = parseInt($appsumoElement.html(), 10) || 0;
        }

        var sel_lang_code = $lng_sel.data("val"),
            langs = this.langsObj,
            langs_html = '<div class="ss_langs_opt">',
            l_c = langs.length,
            p_s = parseInt(l_c / 4) + 1;
        for(var t = 0;t < langs.length;t++) {

            var k1 = langs[t],
                l_name = k1["name"];

            var voice_options = this.generateVoices(k1["voice_data"], k1["value"], appsumo);

            var l_item = '<div class="ss_translation_item ss_lang_holder_'+k1["value"]+'" data-voices_data="'+k1["voice_data"]+'" data-val="'+k1["value"]+'">';
            l_item += '<div class="ss_tr_line1">';
            l_item += '<span class="ss_checkbox_wrapper"><span class="ss_checkbox_line1"></span><span class="ss_checkbox_line2"></span><span class="ss_checkbox_ripple"></span><span class="ss_checkbox_bg"></span></span>';
            l_item += '<span class="ss_checkbox_label">'+l_name+'</span>';
            l_item += '</div>';
            l_item += '<div class="ss_tr_line2">';
            l_item += 
                        `
                            <div class="items_select_filter_wrapper ss_select_multiple ss_audio_holder" data-sel_voice="" data-def_txt="Select voices">
                                <div class="items_select_filter">
                                    <div class="items_select_filter_content"><span>Select voices</span></div>
                                    <div class="items_select_filter_icon_wrapper">
                                        <div class="items_select_filter_icon_holder">
                                            <div class="items_select_filter_icon_inner">
                                                <span class="items_select_filter_icon">
                                                    <svg class="" aria-hidden="true" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path fill="currentColor" d="M424.4 214.7L72.4 6.6C43.8-10.3 0 6.1 0 47.9V464c0 37.5 40.7 60.1 72.4 41.3l352-208c31.4-18.5 31.5-64.1 0-82.6z"></path></svg>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="items_select_ul_wrapper">
                                        <div class="items_select_ul_holder">
                                            <div class="items_select_ul_inner">
                                                <ul class="items_select_ul">`+voice_options+`</ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        `;
            l_item += '</div>';
            l_item += '</div>';

            if(voice_options != "")
                langs_html += l_item;

            if(t != 0 && t % p_s == 0)
                langs_html += '</div><div class="ss_langs_opt">';
        }
        langs_html += '</div>';

        $lng_sel.html(langs_html);

        // set preview audios
        $(".ss_translation_item").each(function() {

            var lng_val = $(this).data("val");

            // $(this).find(".search_li").each(function() {

            //     var voice_val = $(this).data("val"),
            //         audio_hash = $this.preview_audios[lng_val][voice_val];

            //     $(this).data('name_hash',audio_hash);
            // });
        });

        // set selection
        var sel_langs = $("#ss_w_translation_options").data("sel_langs");
        var sel_lang_global = $("#lng_sel_wdg").data("val");
        if(sel_langs == '')
            sel_langs = sel_lang_global;

        var sel_langs_array = sel_langs.split(';');
        for(let t=0;t<sel_langs_array.length;t++) {

            let sel_l_itm = sel_langs_array[t],
                sel_l_data = sel_l_itm.split('|'),
                s_l = sel_l_data[0],
                s_v_data = sel_l_data.length > 1 ? sel_l_data[1] : '';

            let $s_item = $('.ss_lang_holder_' + s_l);
            $s_item.find(".ss_tr_line2").addClass("ss_tr_line2_v").addClass("ss_ov_v");
            $s_item.find(".ss_checkbox_wrapper").addClass("ss_checked");

            // correction
            thisPage.createTranslationBlockPreviewTxt($s_item);

            // set voices
            if(s_v_data != '') {

                let s_v_array = s_v_data.split(','),
                    v_c_val = '';
                for(let q=0;q<s_v_array.length;q++) {

                    let v_item = s_v_array[q];
                    $s_item.find('.option-' + v_item).addClass("li_selected").addClass("ss_ul_li_act");

                    v_c_val += $s_item.find('.option-' + v_item).find("span").html() + ', ';
                }
                v_c_val = v_c_val.slice(0, -2);
                $s_item.find('.items_select_filter_content span').addClass("ss_processed74").html(v_c_val);
            }
        }

        // set disabled classes
        $(".ss_lang_holder_" + sel_lang_global).addClass("ss_tr_block_hardcoded").find(".ss_checkbox_wrapper").addClass("ss_disabled");
        
        // set voice
        let sel_v = $("#wbs_w_multiple_voices").data("sel_voice");
        if(sel_v != "" && sel_v != undefined) {
            $(".ss_lang_holder_" + sel_lang_global).find('.option-' + sel_v).addClass("li_selected").addClass("ss_ul_li_act").addClass("ss_option_hardcoded");

            let $c_c = $(".ss_lang_holder_" + sel_lang_global).find('.items_select_filter_content span');
            let v_c = $(".ss_lang_holder_" + sel_lang_global).find('.li_selected span').html();

            if(!$c_c.hasClass("ss_processed74"))
                $c_c.html(v_c);
        }

        this.generateWrapperHeight();
    };

    this.createLangsListWidget = function() {

        var appsumo = 0;
        var user_plan = 0;
        const $gsp_appsumo = $("#gsp_appsumo");
        const $gsp_plan = $("#gsp_plan");
        if ($gsp_appsumo.length) {
            appsumo = parseInt($gsp_appsumo.html(), 10) || 0;
        }
        if ($gsp_plan.length) {
            user_plan = parseInt($gsp_plan.html(), 10) || 0;
        }

        var appsumo_blocked_langs = ['hy','be','kk','mk','mi','fa','pa-Arab','sl'];
        var appsumo_tier1_blocked_langs = ['eu-ES','gl-ES','lt-LT','yue-HK'];
        var free_plan_blocked_langs = ['hy','be','eu-ES','gl-ES','kk','lt-LT','mk','mi','fa','pa-Arab','sl','yue-HK'];

        var $lng_sel = $("#lng_sel_wdg");

        if(!$lng_sel.length || $lng_sel.data("lng_processed") == 1)
            return;

        $lng_sel.data("lng_processed", 1);

        var langs = this.langsObj;

        var langs_html = '';
        for(var t = 0;t < langs.length;t++) {

            var k1 = langs[t],
                l_name = k1["name"],
                voice_data = k1["voice_data"],
                audios_obj = k1["audios"];

            var lang_restricted = false;
            if(appsumo == 1 && thisPage.inArray(k1["value"],appsumo_blocked_langs)) {
                lang_restricted = true;
            }

            if(appsumo == 1 && user_plan == 1 && thisPage.inArray(k1["value"],appsumo_tier1_blocked_langs)) {
                lang_restricted = true;
            }

            if(user_plan == 0 && thisPage.inArray(k1["value"],free_plan_blocked_langs))
                lang_restricted = true;

            this.preview_audios[k1["value"]] = audios_obj;

            if(!lang_restricted)
                langs_html += '<li class="search_li" data-val="'+k1["value"]+'" data-voices_data="'+voice_data+'"><span>'+l_name+'</span></li>';
        }

        $lng_sel.find(".items_select_ul").html(langs_html);
    };

    this.setValsWidgets = function() {

        var $langs = this.langsObj;

        $(".gsp_left_m_c_active .item_row_item_lang").each(function() {
            var val = $(this).html();

            var s_lang = "";
            for(var t = 0;t<$langs.length - 1;t++) {

                var itm_val = $langs[t]["value"],
                    itm_name = $langs[t]["name"];

                if(itm_val == val)
                    s_lang = itm_name;
            }

            // Update lang_val to lang_name
            $(this).html(s_lang);

            var $voice_item = $(this).parents(".item_item").find('.item_row_item_voice'),
                voice_val = $voice_item.html(),
                voice_name = thisPage.generateVoiceName(voice_val.split('-')[0],val,voice_val.split('-')[1]);

            // Update voice val to name
            $voice_item.html(voice_name);
        });
    };

    this.setValsAudios = function() {

        var $langs = this.langsObj;

        $(".gsp_left_m_c_active .item_row_item_lang").each(function() {
            var val = $(this).html();

            var s_lang = "";
            for(var t = 0;t<$langs.length - 1;t++) {

                var itm_val = $langs[t]["value"],
                    itm_name = $langs[t]["name"];

                if(itm_val == val)
                    s_lang = itm_name;
            }

            // Update lang_val to lang_name
            $(this).html(s_lang);

            var $voice_item = $(this).parents(".item_item").find('.item_row_item_voice'),
                voice_val = $voice_item.html(),
                voice_name = thisPage.generateVoiceName(voice_val.split('-')[0],val,voice_val.split('-')[1]);

            // Update voice val to name
            $voice_item.html(voice_name);
        });
    };

    this.setValsWebsiteSettings = function(website_data) {

        var website_title = decodeURIComponent(website_data.name);
        var website_css = website_data.css;
        var website_js = website_data.js;
        var website_aliases = website_data.aliases;
        var website_url = decodeURIComponent(website_data.url);
        var website_options_str = decodeURIComponent(website_data.options);
        var plan_commercial_option = decodeURIComponent(website_data.plan_commercial_option);
        var website_state = parseInt(website_data.state);
        var website_lang = website_data.language;
        var website_voice = website_data.voice;
        var website_plan = parseInt(website_data.plan);
        var user_plan = parseInt(website_data.user_plan);
        var speed = website_data.speed;
        var pitch = website_data.pitch;
        var widget_id = this.options.widget_id;

        // chars info
        var chars_info = website_data.chars_info;
        var chars_info_spl = chars_info.split(':');
        var char_info_0 = chars_info_spl[0];
        var char_info_1 = chars_info_spl[1] != undefined ? chars_info_spl[1] : '';
        var char_info_2 = chars_info_spl[2] != undefined ? chars_info_spl[2] : '';
        var char_info_3 = chars_info_spl[3] != undefined ? chars_info_spl[3] : '';
        var char_info_4 = chars_info_spl[4] != undefined ? chars_info_spl[4] : '';
        var char_info_5 = chars_info_spl[5] != undefined ? chars_info_spl[5] : '';
        var char_info_6 = chars_info_spl[6] != undefined ? chars_info_spl[6] : '';
        var char_info_7 = chars_info_spl[7] != undefined ? chars_info_spl[7] : '';
        var char_info_8 = chars_info_spl[8] != undefined ? chars_info_spl[8] : '';

        $('.gsp_chars_plan_title').html(char_info_0);
        $('.gsp_chars_itm_1').html(char_info_1);
        $('.gsp_chars_itm_2').html(char_info_8);
        $('.gsp_chars_itm_3').html(char_info_3);
        $('.gsp_chars_itm_4').html(char_info_5);
        $('.gsp_chars_itm_5').html(char_info_6);
        $('.gsp_chars_itm_6').html(char_info_7);
        $('.gsp_chars_count_progress').width(char_info_4 + '%');

        $("#dashboard_content").addClass('ss_user_plan_' + website_plan);

        $("#ss_website_title").val(website_title);
        $("#ss_website_url").val(website_url);
        $("#ss_website_widget_id").val(widget_id);

        var website_options = {};
        if(website_options_str != "") {

            var website_options_array = website_options_str.split("&");
            website_options_array.forEach(function(option_item, i) {
                var opt_data = option_item.split("=");
                website_options[opt_data[0]] = opt_data[1];
            });

            if(website_options["auto_enable"] == undefined)
                website_options["auto_enable"] = 1;
            if(website_options["show_on_homepage"] == undefined)
                website_options["show_on_homepage"] = 0;
            if(website_options["multilang_website"] == undefined)
                website_options["multilang_website"] = 0;
            if(website_options["read_titles"] == undefined)
                website_options["read_titles"] = 1;
            if(website_options["affiliate"] == undefined)
                website_options["affiliate"] = 1;
            if(website_options["onfly"] == undefined)
                website_options["onfly"] = 0;

            if(website_options["post_types"] == undefined)
                website_options["post_types"] = "all";
            if(website_options["categories"] == undefined)
                website_options["categories"] = "all";

            if(website_options["exclude_list"] == undefined)
                website_options["exclude_list"] = "";
            if(website_options["allowed_urls"] == undefined)
                website_options["allowed_urls"] = "";
            if(website_options["blocked_urls"] == undefined)
                website_options["blocked_urls"] = "";
        }
        else {
            website_options["speed_enabled"] = 1;
            website_options["volume_enabled"] = 1;
            website_options["voice_enabled"] = website_plan == 0 ? 0 : 1;
            website_options["lang_enabled"] = website_plan == 0 ? 0 : 1;
            website_options["text_enabled"] = website_plan == 0 ? 0 : 1;
            website_options["download_enabled"] = website_plan == 0 ? 0 : 1;
            website_options["context_enabled"] = website_plan == 0 ? 0 : 1;
            website_options["plays_enabled"] = website_plan == 0 ? 0 : 1;
            website_options["appear_class"] = "ss_fade";
            website_options["sel_langs"] = "";
            website_options["sel_voices"] = "";
            website_options["lazy_load"] = 1;

            website_options["auto_enable"] = 1;
            website_options["show_on_homepage"] = 0;
            website_options["multilang_website"] = 0;
            website_options["read_titles"] = 1;
            website_options["affiliate"] = 1;
            website_options["onfly"] = 0;

            website_options["post_types"] = "all";
            website_options["categories"] = "all";

            website_options["exclude_list"] = "";
            website_options["allowed_urls"] = "";
            website_options["blocked_urls"] = "";
        }

        $("#wbs_appear_class").find(".ss_li_" + website_options["appear_class"]).addClass("li_selected").addClass("ss_ul_li_act");
        $("#wbs_appear_class").find(".items_select_filter_content span").html($("#wbs_appear_class").find(".li_selected span").html());

        $("#wbs_voice").data("sel_voice", website_options["sel_voices"]);
        $("#wbs_voice").data("val", website_voice);
        $("#wbs_multiple_voices").data("sel_voice", website_options["sel_voices"]);
        $("#ss_translation_options").data("sel_langs", website_options["sel_langs"]);

        if(website_state == 1) {
            $("#wbs_status").addClass("gs_mono_switcher_button_on");
            $("#wbs_status").find(".gs_mono_checkbox").prop("checked",true);
        }
        if(website_state == 2) {
            $("#wbs_status").addClass("ss_disabled");
        }
        if(website_options["speed_enabled"] == 1) {
            $("#wbs_speed_enabled").addClass("gs_mono_switcher_button_on");
            $("#wbs_speed_enabled").find(".gs_mono_checkbox").prop("checked",true);
        }
        if(website_options["volume_enabled"] == 1) {
            $("#wbs_volume_enabled").addClass("gs_mono_switcher_button_on");
            $("#wbs_volume_enabled").find(".gs_mono_checkbox").prop("checked",true);
        }
        if(website_options["lang_enabled"] == 1) {
            $("#wbs_lang_enabled").addClass("gs_mono_switcher_button_on");
            $("#wbs_lang_enabled").find(".gs_mono_checkbox").prop("checked",true);

            $("#ss_translation_options").removeClass("ss_display_none");
            thisPage.generateWrapperHeight();
        }
        else {
            $("#wbs_lang_enabled").removeClass("gs_mono_switcher_button_on");
            $("#wbs_lang_enabled").find(".gs_mono_checkbox").prop("checked",false);

            $("#ss_translation_options").addClass("ss_display_none").addClass("gago");
            // thisPage.generateWrapperHeight();
        }
        if(website_options["voice_enabled"] == 1) {
            $("#wbs_voice_enabled").addClass("gs_mono_switcher_button_on");
            $("#wbs_voice_enabled").find(".gs_mono_checkbox").prop("checked",true);

            $("#wbs_multiple_voices").removeClass("ss_disabled");
        }
        if(website_options["text_enabled"] == 1) {
            $("#wbs_text_enabled").addClass("gs_mono_switcher_button_on");
            $("#wbs_text_enabled").find(".gs_mono_checkbox").prop("checked",true);
        }
        if(website_options["download_enabled"] == 1) {
            $("#wbs_download_enabled").addClass("gs_mono_switcher_button_on");
            $("#wbs_download_enabled").find(".gs_mono_checkbox").prop("checked",true);
        }
        if(website_options["context_enabled"] == 1) {
            $("#wbs_context_enabled").addClass("gs_mono_switcher_button_on");
            $("#wbs_context_enabled").find(".gs_mono_checkbox").prop("checked",true);
        }
        if(website_options["plays_enabled"] == 1) {
            $("#wbs_plays_enabled").addClass("gs_mono_switcher_button_on");
            $("#wbs_plays_enabled").find(".gs_mono_checkbox").prop("checked",true);
        }
        if(website_options["lazy_load"] == 1 || website_options["lazy_load"] == undefined) {
            $("#wbs_lazy_load").addClass("gs_mono_switcher_button_on");
            $("#wbs_lazy_load").find(".gs_mono_checkbox").prop("checked",true);
        }
        if(website_options["reload_session"] == 1) {
            $("#wbs_reload_session").addClass("gs_mono_switcher_button_on");
            $("#wbs_reload_session").find(".gs_mono_checkbox").prop("checked",true);
        }

        // 3.9.0
        if(website_options["auto_enable"] == 1) {
            $("#wbs_auto_enable").addClass("gs_mono_switcher_button_on");
            $("#wbs_auto_enable").find(".gs_mono_checkbox").prop("checked",true);
        }
        else {
            $("#wbs_auto_enable").removeClass("gs_mono_switcher_button_on");
            $("#wbs_auto_enable").find(".gs_mono_checkbox").prop("checked",false);
        }

        if(website_options["show_on_homepage"] == 1) {
            $("#wbs_show_on_homepage").addClass("gs_mono_switcher_button_on");
            $("#wbs_show_on_homepage").find(".gs_mono_checkbox").prop("checked",true);
        }
        else {
            $("#wbs_show_on_homepage").removeClass("gs_mono_switcher_button_on");
            $("#wbs_show_on_homepage").find(".gs_mono_checkbox").prop("checked",false);
        }

        if(website_options["multilang_website"] == 1) {
            $("#wbs_multilang_website").addClass("gs_mono_switcher_button_on");
            $("#wbs_multilang_website").find(".gs_mono_checkbox").prop("checked",true);
        }
        else {
            $("#wbs_multilang_website").removeClass("gs_mono_switcher_button_on");
            $("#wbs_multilang_website").find(".gs_mono_checkbox").prop("checked",false);
        }

        if(website_options["read_titles"] == 1) {
            $("#wbs_read_titles").addClass("gs_mono_switcher_button_on");
            $("#wbs_read_titles").find(".gs_mono_checkbox").prop("checked",true);
        }
        else {
            $("#wbs_read_titles").removeClass("gs_mono_switcher_button_on");
            $("#wbs_read_titles").find(".gs_mono_checkbox").prop("checked",false);
        }

        if(website_options["affiliate"] == 1) {
            $("#wbs_affiliate").addClass("gs_mono_switcher_button_on");
            $("#wbs_affiliate").find(".gs_mono_checkbox").prop("checked",true);
        }
        else {
            $("#wbs_affiliate").removeClass("gs_mono_switcher_button_on");
            $("#wbs_affiliate").find(".gs_mono_checkbox").prop("checked",false);
        }

        if(website_options["onfly"] == 1) {
            $("#wbs_onfly").addClass("gs_mono_switcher_button_on");
            $("#wbs_onfly").find(".gs_mono_checkbox").prop("checked",true);
        }
        else {
            $("#wbs_onfly").removeClass("gs_mono_switcher_button_on");
            $("#wbs_onfly").find(".gs_mono_checkbox").prop("checked",false);
        }

        if(website_options["post_types"] != "") {

            // remove selection
            $("#gsp_post_types").find(".li_selected").removeClass("li_selected");

            // set selection
            var post_types_arr = website_options["post_types"].split(',');

            var sel_htm = '';

            for(var q=0;q<post_types_arr.length;q++) {

                var val = post_types_arr[q];

                $("#gsp_post_types").find(".search_li").each(function() {

                    if($(this).data("val") == val) {

                        if(sel_htm != "") {
                            sel_htm += ", ";
                        }
                        var piece_v = $(this).find("span").html();
                        sel_htm += piece_v;

                        $(this).addClass("li_selected");
                    }

                });
            }
            $("#gsp_post_types").find(".items_select_filter_content span").html(sel_htm);
        }

        if(website_options["categories"] != "") {

            // remove selection
            $("#gsp_categories").find(".li_selected").removeClass("li_selected");

            // set selection
            var post_types_arr = website_options["categories"].split(',');

            var sel_htm = '';

            for(var q=0;q<post_types_arr.length;q++) {

                var val = post_types_arr[q];

                $("#gsp_categories").find(".search_li").each(function() {

                    if($(this).data("val") == val) {

                        if(sel_htm != "") {
                            sel_htm += ", ";
                        }
                        var piece_v = $(this).find("span").html();
                        sel_htm += piece_v;

                        $(this).addClass("li_selected");
                    }

                });
            }
            $("#gsp_categories").find(".items_select_filter_content span").html(sel_htm);
        }

        if(website_options["exclude_list"] != "") {
            $("#ss_website_exclude_list").val(website_options["exclude_list"]);
        }

        if(website_options["allowed_urls"] != "") {
            $("#ss_wbs_allowed_urls").val(decodeURIComponent(website_options["allowed_urls"]));
        }

        if(website_options["blocked_urls"] != "") {
            $("#ss_wbs_blocked_urls").val(decodeURIComponent(website_options["blocked_urls"]));
        }

        if(website_js != "")
            $("#ss_custom_js").val(website_js);

        if(website_css != "")
            $("#ss_custom_css").val(website_css);

        if(website_aliases != "")
            $("#ss_aliases").val(website_aliases);

        if(website_plan == 0) {

            $(".ss_commercial_switcher").removeClass("gs_mono_switcher_button_on").addClass("ss_disabled");
            $(".ss_commercial_switcher").find(".gs_mono_checkbox").prop("checked",false);

            $(".ss_commercial_switcher.opts_input").attr("readonly", true);
        }

        // website plan
        if(plan_commercial_option != "") {

            $("#wbs_plan").find('.items_select_ul').html(plan_commercial_option);

            $("#wbs_plan").find(".li_selected").removeClass("li_selected").removeClass("ss_ul_li_act");
            $("#wbs_plan").find(".search_li.user_plan_" + website_plan).addClass("li_selected").addClass("ss_ul_li_act");
            
            var op_v = $("#wbs_plan").find(".li_selected span").html();
            $("#wbs_plan").find(".items_select_filter_content span").html(op_v);
        }

        if(website_plan != 0) {

            $("#wbs_voice").find(".ss_disabled").removeClass("ss_disabled");
            $("#wbs_multiple_voices").removeClass("ss_disabled");
            $("#ss_translation_options .items_select_filter_wrapper .search_li").removeClass("ss_disabled");

            var m_v_title = $("#wbs_voice").find(".li_selected").length ? $("#wbs_voice").find(".li_selected span").html() : $("#wbs_multiple_voices").data("def_txt");
            $("#wbs_multiple_voices").find(".items_select_filter_content span").html(m_v_title);
            $("#wbs_multiple_voices").find(".items_select_ul").html($("#wbs_voice").find(".items_select_ul").html());

            $(".ss_commercial_switcher").removeClass("ss_disabled");
            $(".ss_locked_icon").addClass("ss_display_none");

            // $("#ss_translation_options").removeClass("ss_display_none");

            var $gsLanguageSelector = $("#lng_sel"),
                $gsVoiceSelector = $("#wbs_voice"),
                $gsMultipleVoiceSelector = $("#wbs_multiple_voices");

            // setTimeout(function() {

            //     var lang_code = $gsLanguageSelector.find("li.li_selected").data('val');

            //     $gsMultipleVoiceSelector.find(".search_li").each(function() {
            
            //         $(this).data("name_hash", $this.preview_audios[lang_code][$(this).data("val")]);
            //     });
            // }, 800);
        }

        // create langs
        this.createLangsListWebsiteSettings(website_lang);

        $("#lng_sel").data("val", website_lang);

        // process voice
        this.processVoiceWebsiteSettings(website_voice);

        this.createTranslationListWebsiteSettings();

        speed = speed + '.00';
        pitch = pitch + '.00';

        var slider_callback = function() {

            thisPage.resetPlayerWebsiteSettings();
        };

        $('#gsp_slider_speed').find('.gsp_value_label').val(speed);
        $('#gsp_slider_speed').find('.gsp_slider_wrapper').data('start_value', speed);

        $('#gsp_slider_pitch').find('.gsp_value_label').val(pitch);
        $('#gsp_slider_pitch').find('.gsp_slider_wrapper').data('start_value', pitch);

        this.applySliderFunctionality('.ss_slider_element_wrapper', slider_callback);

        // run gspeech
        if(!$("#gspeech_js").length) {

            var id_script = "gspeech_js";
            var js_path = "https://widget.gspeech.io/" + this.options.gspeech_widget_id;

            $('<script>').appendTo('head').attr({type: 'text/javascript', id: id_script, src: js_path});
        }

        var interval_counter = 0;
        var check_int = setInterval(function() {

            if(window.gspeech != undefined) {
                
                clearInterval(check_int);

                setTimeout(function() {

                    thisPage.resetPlayerWebsiteSettings();

                    thisPage.process_lang_change();

                }, 200);
            }

            if(interval_counter > 1000) {
                clearInterval(check_int);
            }

            interval_counter ++;

        }, 25);
    };

    this.processVoiceWebsiteSettings = function(website_voice) {

        this.updateVoiceWebsiteSettings(website_voice);

        setTimeout(function(){

            // this.generateVoicesObject();
            this.resetPlayerWebsiteSettings();

        }.bind(this), 400);
    };

    this.updateVoiceWebsiteSettings = function(website_voice) {

        var $this = this;

        var $gsLanguageSelector = $("#lng_sel"),
            $gsVoiceSelector = $("#wbs_voice"),
            $gsMultipleVoiceSelector = $("#wbs_multiple_voices");

        var lang_code = $gsLanguageSelector.find("li.li_selected").data('val'),
            voices_data = $gsLanguageSelector.find("li.li_selected").data('voices_data'),
            plan_id = $("#wbs_plan").find(".li_selected").data("val"),
            voice_code_sel = website_voice,
            voice_code_sel_multiple = $gsMultipleVoiceSelector.data('sel_voice'),
            def_txt_voice = $gsVoiceSelector.data("def_txt"),
            def_txt_m_voices = $gsMultipleVoiceSelector.data("def_txt"),
            saved_language = $gsLanguageSelector.data('val');

        voice_code_sel = saved_language == lang_code ? voice_code_sel : '';
        voice_code_sel_multiple = saved_language == lang_code ? voice_code_sel_multiple : '';

        var voice_options = $this.generateVoices(voices_data, lang_code);

        $gsVoiceSelector.find('.items_select_ul').html(voice_options);

        // set selection
        if(voice_code_sel != '') {
            $gsVoiceSelector.find('.option-' + voice_code_sel).addClass("li_selected").addClass("ss_ul_li_act");
            var voice_cont_val = $gsVoiceSelector.find(".li_selected span").html();

            var sel_voice_data = $gsVoiceSelector.find(".li_selected").data("val");
            var sel_voice_data_p = sel_voice_data.split('-');
            var sel_voice_type = sel_voice_data_p[1] != undefined ? sel_voice_data_p[1] : 0;
        }
        else {
            var voice_cont_val = def_txt_voice;
            var sel_voice_type = 0;
        }
        $gsVoiceSelector.find('.items_select_filter_content span').html(voice_cont_val);

        if(sel_voice_type != 2 && sel_voice_type != 5 && sel_voice_type != 7)
            $(".gsp_option_disable_switcher").addClass("gsp_option_disabled");
        else
            $(".gsp_option_disable_switcher").removeClass("gsp_option_disabled");
       
        // multiple voices
        if(plan_id != 0 && $('#wbs_voice_enabled').find(".gs_mono_checkbox").prop("checked")) {

            $gsMultipleVoiceSelector.find('.items_select_ul').html(voice_options);
            
            if(voice_code_sel != "")
                $gsMultipleVoiceSelector.find('.option-' + voice_code_sel).addClass("li_selected").addClass("ss_option_hardcoded").addClass("ss_ul_li_act");

            var voice_cont_val = '';

            if(voice_code_sel_multiple != '') {

                var sel_codes_array = voice_code_sel_multiple.split(',');

                $gsMultipleVoiceSelector.find('.search_li').each(function() {

                    var d_val = $(this).data("val"),
                        d_name = $(this).find("span").html();

                    if(thisPage.inArray(d_val,sel_codes_array)) {

                        $(this).addClass("li_selected").addClass("ss_ul_li_act");
                        voice_cont_val += voice_cont_val == '' ? d_name : ', ' + d_name;
                    }
                });
            }
            else{

                if(!$gsMultipleVoiceSelector.find('.li_selected').length)
                    voice_cont_val = def_txt_m_voices;
                else
                    voice_cont_val = $gsMultipleVoiceSelector.find('.li_selected span').html();

            }

            $gsMultipleVoiceSelector.find('.items_select_filter_content span').html(voice_cont_val);
        }

        // set preview audios
        // $gsVoiceSelector.find(".search_li").each(function() {

        //     $(this).data("name_hash", $this.preview_audios[lang_code][$(this).data("val")]);
        // });
        // $gsMultipleVoiceSelector.find(".search_li").each(function() {
            
        //     $(this).data("name_hash", $this.preview_audios[lang_code][$(this).data("val")]);
        // });

        // make languages corrections
        $('.ss_tr_block_hardcoded').find('.ss_option_hardcoded').removeClass("ss_option_hardcoded");
        $('.ss_tr_block_hardcoded').removeClass("ss_tr_block_hardcoded").find('.ss_checkbox_wrapper').removeClass("ss_disabled");
        $(".ss_lang_holder_" + lang_code).addClass("ss_tr_block_hardcoded").find('.ss_checkbox_wrapper').addClass("ss_checked").addClass("ss_disabled");
        $(".ss_lang_holder_" + lang_code).find(".ss_tr_line2").addClass("ss_tr_line2_v").addClass("ss_ov_v");

        // sync voice with translation block
        if(voice_code_sel != "") {
            $(".ss_lang_holder_" + lang_code).find('.li_selected').removeClass("li_selected").removeClass("ss_ul_li_act");
            $(".ss_lang_holder_" + lang_code).find('.option-' + voice_code_sel).addClass("li_selected").addClass("ss_option_hardcoded").addClass("ss_ul_li_act");
        }
        var voice_cont_val = '';
        if(voice_code_sel_multiple != '' && voice_code_sel_multiple != undefined) {

            var sel_codes_array = voice_code_sel_multiple.split(',');

            $(".ss_lang_holder_" + lang_code).find('.search_li').each(function() {

                var d_val = $(this).data("val"),
                    d_name = $(this).find("span").html();

                if(thisPage.inArray(d_val,sel_codes_array)) {

                    $(this).addClass("li_selected").addClass("ss_ul_li_act");
                    voice_cont_val += voice_cont_val == '' ? d_name : ', ' + d_name;
                }
            });
        }
        else {
            voice_cont_val = $(".ss_lang_holder_" + lang_code).find("li_selected span").html();
        }
        $(".ss_lang_holder_" + lang_code).find('.items_select_filter_content span').html(voice_cont_val);

        // add disabled class
        if(plan_id == 0) {
            $("#wbs_voice").find(".ss_voice_type_1").addClass("ss_disabled");
            $("#wbs_voice").find(".ss_voice_type_2").addClass("ss_disabled");
            $("#wbs_voice").find(".ss_voice_type_3").addClass("ss_disabled");
            $("#wbs_voice").find(".ss_voice_type_4").addClass("ss_disabled");
            $("#wbs_voice").find(".ss_voice_type_5").addClass("ss_disabled");
        }
    };

    this.generateVoices = function(voices_data, lang_code, appsumo = 0) {

        if(voices_data == "" || voices_data == undefined)
            return;

        var appsumo = 0;
        var user_plan = 0;
        const $gsp_plan = $("#gsp_plan");
        const $gsp_appsumo = $("#gsp_appsumo");
        if ($gsp_appsumo.length) {
            appsumo = parseInt($gsp_appsumo.html(), 10) || 0;
        }
        if ($gsp_plan.length) {
            user_plan = parseInt($gsp_plan.html(), 10) || 0;
        }

        var play_icon = '<svg class="icon_play" aria-hidden="true" data-icon="play" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path fill="currentColor" d="M424.4 214.7L72.4 6.6C43.8-10.3 0 6.1 0 47.9V464c0 37.5 40.7 60.1 72.4 41.3l352-208c31.4-18.5 31.5-64.1 0-82.6z"></path></svg>';
        var stop_icon = '<svg class="icon_stop" aria-hidden="true" data-icon="stop" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path fill="currentColor" d="M400 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48z"></path></svg>';
        
        var plan_id = 0;
        if($(".gsp_left_m_c_active #wbs_plan").length)
            plan_id = parseInt($("#wbs_plan").find(".li_selected").data("val"));
        else if($(".gsp_left_m_c_active #ss_widget_page_data").length)
            plan_id = parseInt($("#ss_widget_page_data").data("website_plan"));

        var voicesArray = voices_data.split(',');
        var voicesOptons = '';

        for(var q=0;q<voicesArray.length;q++) {

            var voiceIdent = voicesArray[q].split(':')[0];
            var voiceType = voicesArray[q].split(':')[1];
            var voiceVal = voiceIdent + '-' + voiceType;

            if(appsumo == 1 && (voiceType != "0" && voiceType != "1" && voiceType != "2"))
                continue;

            var voiceName = this.generateVoiceName(voiceIdent,lang_code,voiceType);
            var typeClass = 'ss_voice_type_' + voiceType;
            var disabled_class = plan_id == 0 && voiceType != 0 ? "ss_disabled" : "";
            disabled_class = plan_id == 1 && voiceType != 0 ? "ss_disabled" : disabled_class;

            var voice_premium_htm = '<div class="ss_premium_txt">Premium voice</div><div class="ss_premium_icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path fill="currentColor" d="M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z"/></svg></div>';
            var voice_machine_htm = '<div class="ss_machine_txt">Basic voice</div><div class="ss_machine_icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path fill="currentColor" d="M320 0c17.7 0 32 14.3 32 32V96H480c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H160c-35.3 0-64-28.7-64-64V160c0-35.3 28.7-64 64-64H288V32c0-17.7 14.3-32 32-32zM208 384c-8.8 0-16 7.2-16 16s7.2 16 16 16h32c8.8 0 16-7.2 16-16s-7.2-16-16-16H208zm96 0c-8.8 0-16 7.2-16 16s7.2 16 16 16h32c8.8 0 16-7.2 16-16s-7.2-16-16-16H304zm96 0c-8.8 0-16 7.2-16 16s7.2 16 16 16h32c8.8 0 16-7.2 16-16s-7.2-16-16-16H400zM264 256c0-22.1-17.9-40-40-40s-40 17.9-40 40s17.9 40 40 40s40-17.9 40-40zm152 40c22.1 0 40-17.9 40-40s-17.9-40-40-40s-40 17.9-40 40s17.9 40 40 40zM48 224H64V416H48c-26.5 0-48-21.5-48-48V272c0-26.5 21.5-48 48-48zm544 0c26.5 0 48 21.5 48 48v96c0 26.5-21.5 48-48 48H576V224h16z"/></svg></div>';
            var voice_info_htm = voiceType == 0 ? voice_machine_htm : voice_premium_htm;
            
            var voiceOpton = '<li class="option-'+voiceVal+' search_li '+typeClass+' '+disabled_class+'" data-val="' + voiceVal + '"><div class="play_voice_preview play_visible">'+play_icon+stop_icon+'</div><span>' + voiceName + '</span>'+voice_info_htm+'</li>';

            voicesOptons += voiceOpton;
        };

        return voicesOptons;
    };

    this.generateVoiceName = function(voice_code, lang_code, voice_type) {

        var voice_name = 'Voice - ' + voice_code;

        var voice_data = voice_code + ':' + voice_type;

        if(lang_code == 'en-US')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Samantha[F';
                    break;
                case 'A:2':
                    voice_name = 'Declan[M';
                    break;
                case 'B:2':
                    voice_name = 'Brandon[M';
                    break;
                case 'C:2':
                    voice_name = 'Jessica[F';
                    break;
                case 'D:2':
                    voice_name = 'Alexander[M';
                    break;
                case 'E:2':
                    voice_name = 'Alina[F';
                    break;
                case 'F:2':
                    voice_name = 'Lucy[F';
                    break;
                case 'G:2':
                    voice_name = 'Emily[F';
                    break;
                case 'H:2':
                    voice_name = 'Caroline[F';
                    break;
                case 'I:2':
                    voice_name = 'Thomas[M';
                    break;
                case 'J:2':
                    voice_name = 'Kristopher[M';
                    break;
                case 'M:4':
                    voice_name = 'Miles[M';
                    break;
                case 'O:4':
                    voice_name = 'Eleanor[F';
                    break;
                case 'K:5':
                    voice_name = 'Madison[F';
                    break;
                case 'L:5':
                    voice_name = 'Hazel[F';
                    break;
                case 'M:5':
                    voice_name = 'Chuk[M';
                    break;
                case 'N:5':
                    voice_name = 'Harrison[M';
                    break;
                case 'D:6':
                    voice_name = 'Lucas[M';
                    break;
                case '1:7':
                    voice_name = 'John[M';
                    break;
                case 'F:6':
                    voice_name = 'Amelia[F';
                    break;
                case 'O:6':
                    voice_name = 'Evelyn[F';
                    break;
                case 'A:20':
                    voice_name = 'Sophia[F';
                    break;
                case 'B:20':
                    voice_name = 'Andrew[M';
                    break;
                case 'C:20':
                    voice_name = 'James[M';
                    break;
                case 'D:20':
                    voice_name = 'Bertha[F';
                    break;
                case 'E:20':
                    voice_name = 'Aleana[F';
                    break;
                case 'F:20':
                    voice_name = 'Maya[F';
                    break;
                case 'G:20':
                    voice_name = 'Simon[M';
                    break;
                case 'H:20':
                    voice_name = 'Chloe[F';
                    break;
                case 'I:20':
                    voice_name = 'Jennifer[F';
                    break;
            }
        else if(lang_code == 'en-IN')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Kiara[F';
                    break;
                case 'D:2':
                    voice_name = 'Nisha[F';
                    break;
                case 'A:2':
                    voice_name = 'Riya[F';
                    break;
                case 'B:2':
                    voice_name = 'Arjun[M';
                    break;
                case 'C:2':
                    voice_name = 'Jay[M';
                    break;
            }
        else if(lang_code == 'en-GB')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Rose[F';
                    break;
                case 'A:2':
                    voice_name = 'Catherine[F';
                    break;
                case 'B:2':
                    voice_name = 'Benjamin[M';
                    break;
                case 'C:2':
                    voice_name = 'Victoria[F';
                    break;
                case 'D:2':
                    voice_name = 'Richard[M';
                    break;
                case 'F:2':
                    voice_name = 'Jane[F';
                    break;
                case 'G:5':
                    voice_name = 'Olivia[F';
                    break;
                case 'H:5':
                    voice_name = 'Amelia[F';
                    break;
                case 'I:5':
                    voice_name = 'Ava[F';
                    break;
                case 'J:5':
                    voice_name = 'Oliver[M';
                    break;
                case 'K:5':
                    voice_name = 'George[M';
                    break;
                case 'L:5':
                    voice_name = 'William[M';
                    break;
                case 'M:5':
                    voice_name = 'Jack[M';
                    break;
            }
        else if(lang_code == 'en-AU')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Grace[F';
                    break;
                case 'A:2':
                    voice_name = 'Amelia[F';
                    break;
                case 'B:2':
                    voice_name = 'Cooper[M';
                    break;
                case 'C:2':
                    voice_name = 'Zoe[F';
                    break;
                case 'D:2':
                    voice_name = 'Matthew[M';
                    break;
            }
        else if(lang_code == 'nl-NL')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Sara[F';
                    break;
                case 'B:2':
                    voice_name = 'Lars[M';
                    break;
                case 'C:2':
                    voice_name = 'Bram[M';
                    break;
                case 'D:2':
                    voice_name = 'Lotte[F';
                    break;
                case 'A:2':
                    voice_name = 'Nora[F';
                    break;
                case 'E:2':
                    voice_name = 'Evi[F';
                    break;

                case 'A:20':
                    voice_name = 'Sophie[F';
                    break;
                case 'B:20':
                    voice_name = 'Sem[M';
                    break;
                case 'C:20':
                    voice_name = 'Milan[M';
                    break;
                case 'D:20':
                    voice_name = 'Julia[F';
                    break;
                case 'E:20':
                    voice_name = 'Tess[F';
                    break;
                case 'F:20':
                    voice_name = 'Mila[F';
                    break;
                    
                case 'G:20':
                    voice_name = 'Milan[M';
                    break;
                case 'H:20':
                    voice_name = 'Saar[F';
                    break;
                case 'I:20':
                    voice_name = 'Lotte[F';
                    break;
            }
        else if(lang_code == 'da-DK')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Alma[F';
                    break;
                case 'C:2':
                    voice_name = 'Oscar[M';
                    break;
                case 'D:2':
                    voice_name = 'Karla[F';
                    break;
                case 'E:2':
                    voice_name = 'Victoria[F';
                    break;
                case 'A:2':
                    voice_name = 'Josefine[F';
                    break;

                case 'A:20':
                    voice_name = 'Sofia[F';
                    break;
                case 'B:20':
                    voice_name = 'Oscar[M';
                    break;
                case 'C:20':
                    voice_name = 'Oliver[M';
                    break;
                case 'D:20':
                    voice_name = 'Clara[F';
                    break;
                case 'E:20':
                    voice_name = 'Freja[F';
                    break;
                case 'F:20':
                    voice_name = 'Emma[F';
                    break;
                    
                case 'G:20':
                    voice_name = 'Christian[M';
                    break;
                case 'H:20':
                    voice_name = 'Olivia[F';
                    break;
                case 'I:20':
                    voice_name = 'Alma[F';
                    break;
            }
        else if(lang_code == 'cs-CZ')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Andrea[F';
                    break;
                case 'A:2':
                    voice_name = 'Lucie[F';
                    break;

                case 'A:20':
                    voice_name = 'Tereza[F';
                    break;
                case 'B:20':
                    voice_name = 'Martin[M';
                    break;
                case 'C:20':
                    voice_name = 'Jakub[M';
                    break;
                case 'D:20':
                    voice_name = 'Anna[F';
                    break;
                case 'E:20':
                    voice_name = 'Eliska[F';
                    break;
                case 'F:20':
                    voice_name = 'Karolina[F';
                    break;
                    
                case 'G:20':
                    voice_name = 'Michal[M';
                    break;
                case 'H:20':
                    voice_name = 'Jana[F';
                    break;
                case 'I:20':
                    voice_name = 'Adrla[F';
                    break;
            }
        else if(lang_code == 'hr')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Vito[M';
                    break;

                case 'A:20':
                    voice_name = 'Ana[F';
                    break;
                case 'B:20':
                    voice_name = 'Marko[M';
                    break;
                case 'C:20':
                    voice_name = 'Luka[M';
                    break;
                case 'D:20':
                    voice_name = 'Katarina[F';
                    break;
                case 'E:20':
                    voice_name = 'Marija[F';
                    break;
                case 'F:20':
                    voice_name = 'Petra[F';
                    break;
            }
        else if(lang_code == 'hy')
            switch(voice_data) {
                case 'A:20':
                    voice_name = 'Anahit[F';
                    break;
                case 'B:20':
                    voice_name = 'Aram[M';
                    break;
                case 'C:20':
                    voice_name = 'Levon[M';
                    break;
                case 'D:20':
                    voice_name = 'Mariam[F';
                    break;
                case 'E:20':
                    voice_name = 'Lilit[F';
                    break;
                case 'F:20':
                    voice_name = 'Naira[F';
                    break;
                    
                case 'G:20':
                    voice_name = 'Samvel[M';
                    break;
                case 'H:20':
                    voice_name = 'Hasmik[F';
                    break;
                case 'I:20':
                    voice_name = 'Tatevik[F';
                    break;
            }
        else if(lang_code == 'cy')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Gwen[F';
                    break;
                case 'A:20':
                    voice_name = 'Catrin[F';
                    break;
                case 'B:20':
                    voice_name = 'Ieuan[M';
                    break;
                case 'C:20':
                    voice_name = 'Rhys[M';
                    break;
                case 'D:20':
                    voice_name = 'Rhiannon[F';
                    break;
                case 'E:20':
                    voice_name = 'Branwen[F';
                    break;
                case 'F:20':
                    voice_name = 'Angharad[F';
                    break;
            }
        else if(lang_code == 'sl')
            switch(voice_data) {
                case 'A:20':
                    voice_name = 'Katarina[F';
                    break;
                case 'B:20':
                    voice_name = 'Janez[M';
                    break;
                case 'C:20':
                    voice_name = 'Matej[M';
                    break;
                case 'D:20':
                    voice_name = 'Lucija[F';
                    break;
                case 'E:20':
                    voice_name = 'Tina[F';
                    break;
                case 'F:20':
                    voice_name = 'Sara[F';
                    break;
            }
        else if(lang_code == 'kk')
            switch(voice_data) {
                case 'A:20':
                    voice_name = 'Ainur[F';
                    break;
                case 'B:20':
                    voice_name = 'Askar[M';
                    break;
                case 'C:20':
                    voice_name = 'Dauren[M';
                    break;
                case 'D:20':
                    voice_name = 'Gulzhaz[F';
                    break;
                case 'E:20':
                    voice_name = 'Marzhan[F';
                    break;
                case 'F:20':
                    voice_name = 'Ainurkhan[F';
                    break;
            }
        else if(lang_code == 'mk')
            switch(voice_data) {
                case 'A:20':
                    voice_name = 'Marija[F';
                    break;
                case 'B:20':
                    voice_name = 'Luka[M';
                    break;
                case 'C:20':
                    voice_name = 'Goran[M';
                    break;
                case 'D:20':
                    voice_name = 'Biljana[F';
                    break;
                case 'E:20':
                    voice_name = 'Katica[F';
                    break;
                case 'F:20':
                    voice_name = 'Vesna[F';
                    break;
            }
        else if(lang_code == 'mi')
            switch(voice_data) {
                case 'A:20':
                    voice_name = 'Hinemoa[F';
                    break;
                case 'B:20':
                    voice_name = 'Tama[M';
                    break;
                case 'C:20':
                    voice_name = 'Rongo[M';
                    break;
                case 'D:20':
                    voice_name = 'Hinemoa[F';
                    break;
                case 'E:20':
                    voice_name = 'Hinewai[F';
                    break;
                case 'F:20':
                    voice_name = 'Whetu[F';
                    break;
            }
        else if(lang_code == 'be')
            switch(voice_data) {
                case 'A:20':
                    voice_name = 'Alena[F';
                    break;
                case 'B:20':
                    voice_name = 'Maksim[M';
                    break;
                case 'C:20':
                    voice_name = 'Mikolaj[M';
                    break;
                case 'D:20':
                    voice_name = 'Ludmila[F';
                    break;
                case 'E:20':
                    voice_name = 'Victoria[F';
                    break;
                case 'F:20':
                    voice_name = 'Natalia[F';
                    break;
            }
        else if(lang_code == 'fa')
            switch(voice_data) {
                case 'A:20':
                    voice_name = 'Fatima[F';
                    break;
                case 'B:20':
                    voice_name = 'Amir[M';
                    break;
                case 'C:20':
                    voice_name = 'Ali[M';
                    break;
                case 'D:20':
                    voice_name = 'Mahsa[F';
                    break;
                case 'E:20':
                    voice_name = 'Zahra[F';
                    break;
                case 'F:20':
                    voice_name = 'Maryam[F';
                    break;
                    
                case 'G:20':
                    voice_name = 'Omid[M';
                    break;
                case 'H:20':
                    voice_name = 'Setareh[F';
                    break;
                case 'I:20':
                    voice_name = 'Mitra[F';
                    break;
            }
        else if(lang_code == 'pa')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Preeti[F';
                    break;
                case 'A:20':
                    voice_name = 'Harleen[F';
                    break;
                case 'B:20':
                    voice_name = 'Sarabjeet[M';
                    break;
                case 'C:20':
                    voice_name = 'Rajinder[M';
                    break;
                case 'D:20':
                    voice_name = 'Navjot[F';
                    break;
                case 'E:20':
                    voice_name = 'Jasleen[F';
                    break;
                case 'F:20':
                    voice_name = 'Amritpal[F';
                    break;
            }
        else if(lang_code == 'pa-Arab')
            switch(voice_data) {
                case 'A:20':
                    voice_name = 'Harleen[F';
                    break;
                case 'B:20':
                    voice_name = 'Sarabjeet[M';
                    break;
                case 'C:20':
                    voice_name = 'Rajinder[M';
                    break;
                case 'D:20':
                    voice_name = 'Navjot[F';
                    break;
                case 'E:20':
                    voice_name = 'Jasleen[F';
                    break;
                case 'F:20':
                    voice_name = 'Amritpal[F';
                    break;
            }
        else if(lang_code == 'iw')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Sarah[F';
                    break;
                case 'A:20':
                    voice_name = 'Lior[F';
                    break;
                case 'B:20':
                    voice_name = 'Avraham[M';
                    break;
                case 'C:20':
                    voice_name = 'Ami[M';
                    break;
                case 'D:20':
                    voice_name = 'Tamar[F';
                    break;
                case 'E:20':
                    voice_name = 'Noa[F';
                    break;
                case 'F:20':
                    voice_name = 'Noga[F';
                    break;
                    
                case 'G:20':
                    voice_name = 'Oren[M';
                    break;
                case 'H:20':
                    voice_name = 'Avigail[F';
                    break;
                case 'I:20':
                    voice_name = 'Esther[F';
                    break;
            }
        else if(lang_code == 'cmn-TW')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Qian[F';
                    break;
                case 'A:2':
                    voice_name = 'Sijia[F';
                    break;
                case 'B:2':
                    voice_name = 'Xiong[M';
                    break;
                case 'C:2':
                    voice_name = 'Liang[M';
                    break;

                case 'A:20':
                    voice_name = 'Jingyi[F';
                    break;
                case 'B:20':
                    voice_name = 'Zhihao[M';
                    break;
                case 'C:20':
                    voice_name = 'Haoyu[M';
                    break;
                case 'D:20':
                    voice_name = 'Peiru[F';
                    break;
                case 'E:20':
                    voice_name = 'Shihan[F';
                    break;
                case 'F:20':
                    voice_name = 'Fenglin[F';
                    break;
                    
                case 'G:20':
                    voice_name = 'Cheng[M';
                    break;
                case 'H:20':
                    voice_name = 'Xiao[F';
                    break;
                case 'I:20':
                    voice_name = 'Hua[F';
                    break;

            }
        else if(lang_code == 'cmn-CN')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Qian[F';
                    break;
                case 'A:2':
                    voice_name = 'Lan[F';
                    break;
                case 'B:2':
                    voice_name = 'Ze[M';
                    break;
                case 'C:2':
                    voice_name = 'Jing[M';
                    break;
                case 'D:2':
                    voice_name = 'Xin[F';
                    break;

                case 'A:20':
                    voice_name = 'Lili[F';
                    break;
                case 'B:20':
                    voice_name = 'Wei[M';
                    break;
                case 'C:20':
                    voice_name = 'Jianguo[M';
                    break;
                case 'D:20':
                    voice_name = 'Meili[F';
                    break;
                case 'E:20':
                    voice_name = 'Xia[F';
                    break;
                case 'F:20':
                    voice_name = 'Yun[F';
                    break;
                    
                case 'G:20':
                    voice_name = 'Lei[M';
                    break;
                case 'H:20':
                    voice_name = 'Lan[F';
                    break;
                case 'I:20':
                    voice_name = 'Xue[F';
                    break;
            }
        else if(lang_code == 'ca-ES')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Berta[F';
                    break;
                case 'A:1':
                    voice_name = 'Ariadna[F';
                    break;

                case 'A:20':
                    voice_name = 'Marta[F';
                    break;
                case 'B:20':
                    voice_name = 'Roger[M';
                    break;
                case 'C:20':
                    voice_name = 'Pol[M';
                    break;
                case 'D:20':
                    voice_name = 'Laia[F';
                    break;
                case 'E:20':
                    voice_name = 'Clara[F';
                    break;
                case 'F:20':
                    voice_name = 'Paula[F';
                    break;
                    
                case 'G:20':
                    voice_name = 'Ferran[M';
                    break;
                case 'H:20':
                    voice_name = 'Irene[F';
                    break;
                case 'I:20':
                    voice_name = 'Aina[F';
                    break;
            }
        else if(lang_code == 'yue')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Mei[F';
                    break;

                case 'A:20':
                    voice_name = 'Ling[F';
                    break;
                case 'B:20':
                    voice_name = 'Chi[M';
                    break;
                case 'C:20':
                    voice_name = 'Lok[M';
                    break;
                case 'D:20':
                    voice_name = 'Sum[F';
                    break;
                case 'E:20':
                    voice_name = 'Yee[F';
                    break;
                case 'F:20':
                    voice_name = 'Ting[F';
                    break;
            }
        else if(lang_code == 'bg-BG')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Sofia[F';
                    break;
                case 'A:1':
                    voice_name = 'Maya[F';
                    break;

                case 'A:20':
                    voice_name = 'Maria[F';
                    break;
                case 'B:20':
                    voice_name = 'Ivan[M';
                    break;
                case 'C:20':
                    voice_name = 'Nikolay[M';
                    break;
                case 'D:20':
                    voice_name = 'Elena[F';
                    break;
                case 'E:20':
                    voice_name = 'Ivanka[F';
                    break;
                case 'F:20':
                    voice_name = 'Desislava[F';
                    break;
            }
        else if(lang_code == 'bs')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Emir[M';
                    break;

                case 'A:20':
                    voice_name = 'Amina[F';
                    break;
                case 'B:20':
                    voice_name = 'Emir[M';
                    break;
                case 'C:20':
                    voice_name = 'Nermin[M';
                    break;
                case 'D:20':
                    voice_name = 'Lejla[F';
                    break;
                case 'E:20':
                    voice_name = 'Selma[F';
                    break;
                case 'F:20':
                    voice_name = 'Esma[F';
                    break;
            }
        else if(lang_code == 'bn-IN')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Preeti[F';
                    break;
                case 'A:2':
                    voice_name = 'Puja[F';
                    break;
                case 'B:2':
                    voice_name = 'Arnab[M';
                    break;

                case 'A:20':
                    voice_name = 'Riya[F';
                    break;
                case 'B:20':
                    voice_name = 'Arif[M';
                    break;
                case 'C:20':
                    voice_name = 'Imran[M';
                    break;
                case 'D:20':
                    voice_name = 'Shila[F';
                    break;
                case 'E:20':
                    voice_name = 'Tania[F';
                    break;
                case 'F:20':
                    voice_name = 'Farzana[F';
                    break;
            }
        else if(lang_code == 'eu-ES')
            switch(voice_data) {
                case 'A:1':
                    voice_name = 'Eider[F';
                    break;
            }
        else if(lang_code == 'ar-XA')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Aisha[F';
                    break;
                case 'A:2':
                    voice_name = 'Muna[F';
                    break;
                case 'B:2':
                    voice_name = 'Samir[M';
                    break;
                case 'C:2':
                    voice_name = 'Faris[M';
                    break;
                case 'D:2':
                    voice_name = 'Lina[F';
                    break;

                case 'A:20':
                    voice_name = 'Layla[F';
                    break;
                case 'B:20':
                    voice_name = 'Khalid[M';
                    break;
                case 'C:20':
                    voice_name = 'Omar[M';
                    break;
                case 'D:20':
                    voice_name = 'Noor[F';
                    break;
                case 'E:20':
                    voice_name = 'Yasmin[F';
                    break;
                case 'F:20':
                    voice_name = 'Zainab[F';
                    break;

                case 'G:20':
                    voice_name = 'Youssef[M';
                    break;
                case 'H:20':
                    voice_name = 'Rania[F';
                    break;
                case 'I:20':
                    voice_name = 'Lubna[F';
                    break;
            }
        else if(lang_code == 'sq')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Mentor[M';
                    break;

                case 'A:20':
                    voice_name = 'Albana[F';
                    break;
                case 'B:20':
                    voice_name = 'Arben[M';
                    break;
                case 'C:20':
                    voice_name = 'Besnik[M';
                    break;
                case 'D:20':
                    voice_name = 'Blerina[F';
                    break;
                case 'E:20':
                    voice_name = 'Drita[F';
                    break;
                case 'F:20':
                    voice_name = 'Elira[F';
                    break;
            }
        else if(lang_code == 'af-ZA')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Marlene[F';
                    break;
                case 'A:1':
                    voice_name = 'Magdalena[F';
                    break;
                case 'A:20':
                    voice_name = 'Annelize[F';
                    break;
                case 'B:20':
                    voice_name = 'Hendrik[M';
                    break;
                case 'C:20':
                    voice_name = 'Jacques[M';
                    break;
                case 'D:20':
                    voice_name = 'Marietjie[F';
                    break;
                case 'E:20':
                    voice_name = 'Sonja[F';
                    break;
                case 'F:20':
                    voice_name = 'Nadine[F';
                    break;
            }
        else if(lang_code == 'et')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Marko[M';
                    break;

                case 'A:20':
                    voice_name = 'Sofia[F';
                    break;
                case 'B:20':
                    voice_name = 'Martin[M';
                    break;
                case 'C:20':
                    voice_name = 'Rasmus[M';
                    break;
                case 'D:20':
                    voice_name = 'Laura[F';
                    break;
                case 'E:20':
                    voice_name = 'Mia[F';
                    break;
                case 'F:20':
                    voice_name = 'Anna[F';
                    break;
            }
        else if(lang_code == 'fil-PH')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Maria[F';
                    break;
                case 'A:2':
                    voice_name = 'Angelica[F';
                    break;
                case 'B:2':
                    voice_name = 'Sharon[F';
                    break;
                case 'C:2':
                    voice_name = 'Carlos[M';
                    break;
                case 'D:2':
                    voice_name = 'Francisco[M';
                    break;

                case 'A:20':
                    voice_name = 'Maria[F';
                    break;
                case 'B:20':
                    voice_name = 'Jose[M';
                    break;
                case 'C:20':
                    voice_name = 'Carlo[M';
                    break;
                case 'D:20':
                    voice_name = 'Christine[F';
                    break;
                case 'E:20':
                    voice_name = 'Jasmine[F';
                    break;
                case 'F:20':
                    voice_name = 'Angela[F';
                    break;
            }
        else if(lang_code == 'fi-FI')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Tiina[F';
                    break;
                case 'A:2':
                    voice_name = 'Johanna[F';
                    break;
                    
                case 'A:20':
                    voice_name = 'Aino[F';
                    break;
                case 'B:20':
                    voice_name = 'Eino[M';
                    break;
                case 'C:20':
                    voice_name = 'Leo[M';
                    break;
                case 'D:20':
                    voice_name = 'Sofia[F';
                    break;
                case 'E:20':
                    voice_name = 'Lilja[F';
                    break;
                case 'F:20':
                    voice_name = 'Ella[F';
                    break;
            }
        else if(lang_code == 'fr-CA')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Olivia[F';
                    break;
                case 'A:2':
                    voice_name = 'Emma[F';
                    break;
                case 'B:2':
                    voice_name = 'Louis[M';
                    break;
                case 'C:2':
                    voice_name = 'Rosalie[F';
                    break;
                case 'D:2':
                    voice_name = 'Mathieu[M';
                    break;
            }
        else if(lang_code == 'fr-FR')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Alice[F';
                    break;
                case 'E:2':
                    voice_name = 'Manon[F';
                    break;
                case 'A:2':
                    voice_name = 'Clara[F';
                    break;
                case 'B:2':
                    voice_name = 'Arthur[M';
                    break;
                case 'C:2':
                    voice_name = 'Juliette[F';
                    break;
                case 'D:2':
                    voice_name = 'Lucas[M';
                    break;
                case '1:7':
                    voice_name = 'Gabriel[M';
                    break;

                case 'A:20':
                    voice_name = 'Jeanne[F';
                    break;
                case 'B:20':
                    voice_name = 'Maxime[M';
                    break;
                case 'C:20':
                    voice_name = 'Theo[M';
                    break;
                case 'D:20':
                    voice_name = 'Camille[F';
                    break;
                case 'E:20':
                    voice_name = 'Chloe[F';
                    break;
                case 'F:20':
                    voice_name = 'Elodie[F';
                    break;
                    
                case 'G:20':
                    voice_name = 'Mathis[M';
                    break;
                case 'H:20':
                    voice_name = 'Sophie[F';
                    break;
                case 'I:20':
                    voice_name = 'Julia[F';
                    break;
            }
        else if(lang_code == 'gl-ES')
            switch(voice_data) {
                case 'A:1':
                    voice_name = 'Marta[F';
                    break;
            }
        else if(lang_code == 'de-DE')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Lina[F';
                    break;
                case 'F:2':
                    voice_name = 'Marie[F';
                    break;
                case 'A:2':
                    voice_name = 'Anna[F';
                    break;
                case 'B:2':
                    voice_name = 'Felix[M';
                    break;
                case 'C:2':
                    voice_name = 'Hannah[F';
                    break;
                case 'D:2':
                    voice_name = 'Paul[M';
                    break;
                case 'E:2':
                    voice_name = 'Ben[M';
                    break;
                case '1:7':
                    voice_name = 'Elias[M';
                    break;

                case 'A:20':
                    voice_name = 'Mia[F';
                    break;
                case 'B:20':
                    voice_name = 'Maximilian[M';
                    break;
                case 'C:20':
                    voice_name = 'Jonas[M';
                    break;
                case 'D:20':
                    voice_name = 'Emilia[F';
                    break;
                case 'E:20':
                    voice_name = 'Sophia[F';
                    break;
                case 'F:20':
                    voice_name = 'Emma[F';
                    break;
                    
                case 'G:20':
                    voice_name = 'Benjamin[M';
                    break;
                case 'H:20':
                    voice_name = 'Marie[F';
                    break;
                case 'I:20':
                    voice_name = 'Amelie[F';
                    break;
            }
        else if(lang_code == 'el-GR')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Despina[F';
                    break;
                case 'A:2':
                    voice_name = 'Ioanna[F';
                    break;
                    
                case 'A:20':
                    voice_name = 'Maria[F';
                    break;
                case 'B:20':
                    voice_name = 'George[M';
                    break;
                case 'C:20':
                    voice_name = 'Dimitris[M';
                    break;
                case 'D:20':
                    voice_name = 'Eleni[F';
                    break;
                case 'E:20':
                    voice_name = 'Katerina[F';
                    break;
                case 'F:20':
                    voice_name = 'Sophia[F';
                    break;
            }
        else if(lang_code == 'gu-IN')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Aashi[F';
                    break;
                case 'A:2':
                    voice_name = 'Khushi[F';
                    break;
                case 'B:2':
                    voice_name = 'Jigar[M';
                    break;
                    
                case 'A:20':
                    voice_name = 'Aditi[F';
                    break;
                case 'B:20':
                    voice_name = 'Harsh[M';
                    break;
                case 'C:20':
                    voice_name = 'Dhruv[M';
                    break;
                case 'D:20':
                    voice_name = 'Riya[F';
                    break;
                case 'E:20':
                    voice_name = 'Pooja[F';
                    break;
                case 'F:20':
                    voice_name = 'Sneha[F';
                    break;
            }
        else if(lang_code == 'hi-IN')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Riya[F';
                    break;
                case 'D:2':
                    voice_name = 'Prisha[F';
                    break;
                case 'A:2':
                    voice_name = 'Kavya[F';
                    break;
                case 'B:2':
                    voice_name = 'Rohit[M';
                    break;
                case 'C:2':
                    voice_name = 'Aditya[M';
                    break;
                    
                case 'A:20':
                    voice_name = 'Aarohi[F';
                    break;
                case 'B:20':
                    voice_name = 'Aarav[M';
                    break;
                case 'C:20':
                    voice_name = 'Ananya[M';
                    break;
                case 'D:20':
                    voice_name = 'Kavya[F';
                    break;
                case 'E:20':
                    voice_name = 'Saanvi[F';
                    break;
                case 'F:20':
                    voice_name = 'Nisha[F';
                    break;
                    
                case 'G:20':
                    voice_name = 'Aditya[M';
                    break;
                case 'H:20':
                    voice_name = 'Nandini[F';
                    break;
                case 'I:20':
                    voice_name = 'Tanya[F';
                    break;
            }
        else if(lang_code == 'hu-HU')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Dora[F';
                    break;
                case 'A:2':
                    voice_name = 'Kinga[F';
                    break;
                    
                case 'A:20':
                    voice_name = 'Hanna[F';
                    break;
                case 'B:20':
                    voice_name = 'Bence[M';
                    break;
                case 'C:20':
                    voice_name = 'Levente[M';
                    break;
                case 'D:20':
                    voice_name = 'Reka[F';
                    break;
                case 'E:20':
                    voice_name = 'Eszter[F';
                    break;
                case 'F:20':
                    voice_name = 'Zsofia[F';
                    break;
            }
        else if(lang_code == 'is-IS')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Helga[F';
                    break;
                case 'A:1':
                    voice_name = 'Halla[F';
                    break;
                    
                case 'A:20':
                    voice_name = 'Guorun[F';
                    break;
                case 'B:20':
                    voice_name = 'Arni[M';
                    break;
                case 'C:20':
                    voice_name = 'Gunnar[M';
                    break;
                case 'D:20':
                    voice_name = 'Katrin[F';
                    break;
                case 'E:20':
                    voice_name = 'Elin[F';
                    break;
                case 'F:20':
                    voice_name = 'Bjork[F';
                    break;
            }
        else if(lang_code == 'id-ID')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Ani[F';
                    break;
                case 'D:2':
                    voice_name = 'Eka[F';
                    break;
                case 'A:2':
                    voice_name = 'Mega[F';
                    break;
                case 'B:2':
                    voice_name = 'Joko[M';
                    break;
                case 'C:2':
                    voice_name = 'Ahmad[M';
                    break;
                    
                case 'A:20':
                    voice_name = 'Siti[F';
                    break;
                case 'B:20':
                    voice_name = 'Budi[M';
                    break;
                case 'C:20':
                    voice_name = 'Agus[M';
                    break;
                case 'D:20':
                    voice_name = 'Putri[F';
                    break;
                case 'E:20':
                    voice_name = 'Wulan[F';
                    break;
                case 'F:20':
                    voice_name = 'Intan[F';
                    break;
            }
        else if(lang_code == 'it-IT')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Francesco[M';
                    break;
                case 'A:2':
                    voice_name = 'Alessia[F';
                    break;
                case 'B:2':
                    voice_name = 'Federica[F';
                    break;
                case 'C:2':
                    voice_name = 'Simone[M';
                    break;
                case 'D:2':
                    voice_name = 'Riccardo[M';
                    break;

                case 'A:20':
                    voice_name = 'Sofia[F';
                    break;
                case 'B:20':
                    voice_name = 'Alessandro[M';
                    break;
                case 'C:20':
                    voice_name = 'Lorenzo[M';
                    break;
                case 'D:20':
                    voice_name = 'Chiara[F';
                    break;
                case 'E:20':
                    voice_name = 'Aurora[F';
                    break;
                case 'F:20':
                    voice_name = 'Valentina[F';
                    break;
                    
                case 'G:20':
                    voice_name = 'Antonio[M';
                    break;
                case 'H:20':
                    voice_name = 'Martina[F';
                    break;
                case 'I:20':
                    voice_name = 'Chiara[F';
                    break;
            }
        else if(lang_code == 'ja-JP')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Nana[F';
                    break;
                case 'B:2':
                    voice_name = 'Miyu[F';
                    break;
                case 'C:2':
                    voice_name = 'Kento[M';
                    break;
                case 'D:2':
                    voice_name = 'Hiroto[M';
                    break;
                case 'A:2':
                    voice_name = 'Kanon[F';
                    break;

                case 'A:20':
                    voice_name = 'Sakura[F';
                    break;
                case 'B:20':
                    voice_name = 'Riku[M';
                    break;
                case 'C:20':
                    voice_name = 'Kaito[M';
                    break;
                case 'D:20':
                    voice_name = 'Hina[F';
                    break;
                case 'E:20':
                    voice_name = 'Yui[F';
                    break;
                case 'F:20':
                    voice_name = 'Aoi[F';
                    break;
                    
                case 'G:20':
                    voice_name = 'Kaito[M';
                    break;
                case 'H:20':
                    voice_name = 'Akari[F';
                    break;
                case 'I:20':
                    voice_name = 'Chihiro[F';
                    break;
            }
        else if(lang_code == 'jw')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Fitri[F';
                    break;
                    
                case 'A:20':
                    voice_name = 'Kartini[F';
                    break;
                case 'B:20':
                    voice_name = 'Wibowo[M';
                    break;
                case 'C:20':
                    voice_name = 'Sukarno[M';
                    break;
                case 'D:20':
                    voice_name = 'Sari[F';
                    break;
                case 'E:20':
                    voice_name = 'Putri[F';
                    break;
                case 'F:20':
                    voice_name = 'Lestari[F';
                    break;
            }
        else if(lang_code == 'kn-IN')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Amrutha[F';
                    break;
                case 'A:2':
                    voice_name = 'Nisha[F';
                    break;
                case 'B:2':
                    voice_name = 'Pradeep[M';
                    break;
                    
                case 'A:20':
                    voice_name = 'Lakshmi[F';
                    break;
                case 'B:20':
                    voice_name = 'Shankar[M';
                    break;
                case 'C:20':
                    voice_name = 'Mahesh[M';
                    break;
                case 'D:20':
                    voice_name = 'Meghana[F';
                    break;
                case 'E:20':
                    voice_name = 'Nandini[F';
                    break;
                case 'F:20':
                    voice_name = 'Shwetha[F';
                    break;
            }
        else if(lang_code == 'km')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Chanthy[F';
                    break;
                    
                case 'A:20':
                    voice_name = 'Srey[F';
                    break;
                case 'B:20':
                    voice_name = 'Sok[M';
                    break;
                case 'C:20':
                    voice_name = 'Visal[M';
                    break;
                case 'D:20':
                    voice_name = 'Bopha[F';
                    break;
                case 'E:20':
                    voice_name = 'Kunthea[F';
                    break;
                case 'F:20':
                    voice_name = 'Malis[F';
                    break;
            }
        else if(lang_code == 'ko-KR')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Minho[M';
                    break;
                case 'A:2':
                    voice_name = 'Jiyeon[F';
                    break;
                case 'B:2':
                    voice_name = 'Sohyun[F';
                    break;
                case 'C:2':
                    voice_name = 'Jaewon[M';
                    break;
                case 'D:2':
                    voice_name = 'Sangmin[M';
                    break;
                    
                case 'A:20':
                    voice_name = 'Jiwoo[F';
                    break;
                case 'B:20':
                    voice_name = 'Hyunwoo[M';
                    break;
                case 'C:20':
                    voice_name = 'Junseo[M';
                    break;
                case 'D:20':
                    voice_name = 'Yuna[F';
                    break;
                case 'E:20':
                    voice_name = 'Jimin[F';
                    break;
                case 'F:20':
                    voice_name = 'Minseo[F';
                    break;
                    
                case 'G:20':
                    voice_name = 'Sungwoo[M';
                    break;
                case 'H:20':
                    voice_name = 'Sumin[F';
                    break;
                case 'I:20':
                    voice_name = 'Soojin[F';
                    break;
            }
        else if(lang_code == 'la')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Marcus[M';
                    break;
                    
                case 'A:20':
                    voice_name = 'Claudia[F';
                    break;
                case 'B:20':
                    voice_name = 'Lucius[M';
                    break;
                case 'C:20':
                    voice_name = 'Maximus[M';
                    break;
                case 'D:20':
                    voice_name = 'Lucia[F';
                    break;
                case 'E:20':
                    voice_name = 'Marcia[F';
                    break;
                case 'F:20':
                    voice_name = 'Livia[F';
                    break;
            }
        else if(lang_code == 'lv-LV')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Raimonds[M';
                    break;
                case 'A:1':
                    voice_name = 'Andris[M';
                    break;
                    
                case 'A:20':
                    voice_name = 'Anete[F';
                    break;
                case 'B:20':
                    voice_name = 'Rihards[M';
                    break;
                case 'C:20':
                    voice_name = 'Andris[M';
                    break;
                case 'D:20':
                    voice_name = 'Dace[F';
                    break;
                case 'E:20':
                    voice_name = 'Inese[F';
                    break;
                case 'F:20':
                    voice_name = 'Zane[F';
                    break;
            }
        else if(lang_code == 'lt-LT')
            switch(voice_data) {
                case 'A:1':
                    voice_name = 'Tadas[M';
                    break;
            }
        else if(lang_code == 'ms-MY')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Fatimah[F';
                    break;
                case 'A:2':
                    voice_name = 'Farah[F';
                    break;
                case 'B:2':
                    voice_name = 'Azman[M';
                    break;
                case 'C:2':
                    voice_name = 'Siti[F';
                    break;
                case 'D:2':
                    voice_name = 'Syed[M';
                    break;
            }
        else if(lang_code == 'ml-IN')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Anjali[F';
                    break;
                case 'A:2':
                    voice_name = 'Sangeetha[F';
                    break;
                case 'B:2':
                    voice_name = 'Anoop[M';
                    break;
                case 'C:2':
                    voice_name = 'Radhika[F';
                    break;
                case 'D:2':
                    voice_name = 'Manoj[M';
                    break;
            }
        else if(lang_code == 'mr-IN')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Archana[F';
                    break;
                case 'A:2':
                    voice_name = 'Manisha[F';
                    break;
                case 'B:2':
                    voice_name = 'Suresh[M';
                    break;
                case 'C:2':
                    voice_name = 'Neha[F';
                    break;
            }
        else if(lang_code == 'my')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Khin[F';
                    break;
                    
                case 'A:20':
                    voice_name = 'Thiri[F';
                    break;
                case 'B:20':
                    voice_name = 'Min[M';
                    break;
                case 'C:20':
                    voice_name = 'Kyaw[M';
                    break;
                case 'D:20':
                    voice_name = 'Nandar[F';
                    break;
                case 'E:20':
                    voice_name = 'Su[F';
                    break;
                case 'F:20':
                    voice_name = 'Hla[F';
                    break;
            }
        else if(lang_code == 'ne')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Nisha[F';
                    break;
                    
                case 'A:20':
                    voice_name = 'Sita[F';
                    break;
                case 'B:20':
                    voice_name = 'Suman[M';
                    break;
                case 'C:20':
                    voice_name = 'Ramesh[M';
                    break;
                case 'D:20':
                    voice_name = 'Laxmi[F';
                    break;
                case 'E:20':
                    voice_name = 'Rupa[F';
                    break;
                case 'F:20':
                    voice_name = 'Anjali[F';
                    break;
            }
        else if(lang_code == 'nb-NO')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Eline[F';
                    break;
                case 'A:2':
                    voice_name = 'Ingrid[F';
                    break;
                case 'B:2':
                    voice_name = 'Andreas[M';
                    break;
                case 'C:2':
                    voice_name = 'Sofie[F';
                    break;
                case 'D:2':
                    voice_name = 'Henrik[M';
                    break;
                case 'E:2':
                    voice_name = 'Kari[F';
                    break;
                    
                case 'A:20':
                    voice_name = 'Linnea[F';
                    break;
                case 'B:20':
                    voice_name = 'Magnus[M';
                    break;
                case 'C:20':
                    voice_name = 'Sander[M';
                    break;
                case 'D:20':
                    voice_name = 'Nora[F';
                    break;
                case 'E:20':
                    voice_name = 'Emma[F';
                    break;
                case 'F:20':
                    voice_name = 'Thea[F';
                    break;
            }
        else if(lang_code == 'pl-PL')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Kacper[M';
                    break;
                case 'A:2':
                    voice_name = 'Ewa[F';
                    break;
                case 'B:2':
                    voice_name = 'Szymon[M';
                    break;
                case 'C:2':
                    voice_name = 'Marek[M';
                    break;
                case 'E:2':
                    voice_name = 'Beata[F';
                    break;
                case 'D:2':
                    voice_name = 'Katarzyna[F';
                    break;
                    
                case 'A:20':
                    voice_name = 'Zofia[F';
                    break;
                case 'B:20':
                    voice_name = 'Szymon[M';
                    break;
                case 'C:20':
                    voice_name = 'Antoni[M';
                    break;
                case 'D:20':
                    voice_name = 'Julia[F';
                    break;
                case 'E:20':
                    voice_name = 'Aleksandra[F';
                    break;
                case 'F:20':
                    voice_name = 'Natalia[F';
                    break;
                    
                case 'G:20':
                    voice_name = 'Wojciech[M';
                    break;
                case 'H:20':
                    voice_name = 'Aleksandra[F';
                    break;
                case 'I:20':
                    voice_name = 'Karolina[F';
                    break;
            }
        else if(lang_code == 'pt-BR')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Camila[F';
                    break;
                case 'A:2':
                    voice_name = 'Isabela[F';
                    break;
                case 'B:2':
                    voice_name = 'Eduardo[M';
                    break;
                case 'C:2':
                    voice_name = 'Priscila[F';
                    break;
            }
        else if(lang_code == 'pt-PT')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Catarina[F';
                    break;
                case 'A:2':
                    voice_name = 'Leonor[F';
                    break;
                case 'B:2':
                    voice_name = 'Diogo[M';
                    break;
                case 'C:2':
                    voice_name = 'Afonso[M';
                    break;
                case 'D:2':
                    voice_name = 'Maria[F';
                    break;
                    
                case 'A:20':
                    voice_name = 'Beatriz[F';
                    break;
                case 'B:20':
                    voice_name = 'Miguel[M';
                    break;
                case 'C:20':
                    voice_name = 'Pedro[M';
                    break;
                case 'D:20':
                    voice_name = 'Sofia[F';
                    break;
                case 'E:20':
                    voice_name = 'Matilde[F';
                    break;
                case 'F:20':
                    voice_name = 'Maria[F';
                    break;
                    
                case 'G:20':
                    voice_name = 'Bruno[M';
                    break;
                case 'H:20':
                    voice_name = 'Mariana[F';
                    break;
                case 'I:20':
                    voice_name = 'Gabriela[F';
                    break;
            }
        else if(lang_code == 'ro-RO')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Cristina[F';
                    break;
                case 'A:2':
                    voice_name = 'Simona[F';
                    break;
                    
                case 'A:20':
                    voice_name = 'Maria[F';
                    break;
                case 'B:20':
                    voice_name = 'Bogdan[M';
                    break;
                case 'C:20':
                    voice_name = 'Radu[M';
                    break;
                case 'D:20':
                    voice_name = 'Ioana[F';
                    break;
                case 'E:20':
                    voice_name = 'Alina[F';
                    break;
                case 'F:20':
                    voice_name = 'Roxana[F';
                    break;
            }
        else if(lang_code == 'ru-RU')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Elena[F';
                    break;
                case 'E:2':
                    voice_name = 'Anastasia[F';
                    break;
                case 'A:2':
                    voice_name = 'Olga[F';
                    break;
                case 'B:2':
                    voice_name = 'Sergey[M';
                    break;
                case 'C:2':
                    voice_name = 'Svetlana[F';
                    break;
                case 'D:2':
                    voice_name = 'Boris[M';
                    break;

                case 'A:20':
                    voice_name = 'Ekaterina[F';
                    break;
                case 'B:20':
                    voice_name = 'Vladimir[M';
                    break;
                case 'C:20':
                    voice_name = 'Ivan[M';
                    break;
                case 'D:20':
                    voice_name = 'Natalia[F';
                    break;
                case 'E:20':
                    voice_name = 'Maria[F';
                    break;
                case 'F:20':
                    voice_name = 'Lera[F';
                    break;
                    
                case 'G:20':
                    voice_name = 'Roman[M';
                    break;
                case 'H:20':
                    voice_name = 'Irina[F';
                    break;
                case 'I:20':
                    voice_name = 'Vera[F';
                    break;
            }
        else if(lang_code == 'sr-RS')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Ivana[F';
                    break;
                case 'A:1':
                    voice_name = 'Jelena[F';
                    break;

                case 'A:20':
                    voice_name = 'Milica[F';
                    break;
                case 'B:20':
                    voice_name = 'Lazar[M';
                    break;
                case 'C:20':
                    voice_name = 'Vuk[M';
                    break;
                case 'D:20':
                    voice_name = 'Teodora[F';
                    break;
                case 'E:20':
                    voice_name = 'Jovana[F';
                    break;
                case 'F:20':
                    voice_name = 'Katarina[F';
                    break;
            }
        else if(lang_code == 'si')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Geethika[F';
                    break;

                case 'A:20':
                    voice_name = 'Sanduni[F';
                    break;
                case 'B:20':
                    voice_name = 'Kasun[M';
                    break;
                case 'C:20':
                    voice_name = 'Ruwan[M';
                    break;
                case 'D:20':
                    voice_name = 'Thilini[F';
                    break;
                case 'E:20':
                    voice_name = 'Chamari[F';
                    break;
                case 'F:20':
                    voice_name = 'Kanchana[F';
                    break;
            }
        else if(lang_code == 'sk-SK')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Barbora[F';
                    break;
                case 'A:2':
                    voice_name = 'Michaela[F';
                    break;

                case 'A:20':
                    voice_name = 'Lucia[F';
                    break;
                case 'B:20':
                    voice_name = 'Andrej[M';
                    break;
                case 'C:20':
                    voice_name = 'Peter[M';
                    break;
                case 'D:20':
                    voice_name = 'Anna[F';
                    break;
                case 'E:20':
                    voice_name = 'Petra[F';
                    break;
                case 'F:20':
                    voice_name = 'Jana[F';
                    break;
            }
        else if(lang_code == 'es-ES')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Carmen[F';
                    break;
                case 'C:2':
                    voice_name = 'Laura[F';
                    break;
                case 'D:2':
                    voice_name = 'Nuria[F';
                    break;
                case 'B:2':
                    voice_name = 'Miguel[M';
                    break;
                case 'A:3':
                    voice_name = 'Isabel[F';
                    break;
                case 'E:3':
                    voice_name = 'Sara[F';
                    break;
                case 'F:3':
                    voice_name = 'Francisco[M';
                    break;
                case '1:7':
                    voice_name = 'Mateo[M';
                    break;

                case 'A:20':
                    voice_name = 'Sofía[F';
                    break;
                case 'B:20':
                    voice_name = 'Juan[M';
                    break;
                case 'C:20':
                    voice_name = 'Luis[M';
                    break;
                case 'D:20':
                    voice_name = 'Maria[F';
                    break;
                case 'E:20':
                    voice_name = 'Laura[F';
                    break;
                case 'F:20':
                    voice_name = 'Ana[F';
                    break;
                    
                case 'G:20':
                    voice_name = 'Diego[M';
                    break;
                case 'H:20':
                    voice_name = 'Paula[F';
                    break;
                case 'I:20':
                    voice_name = 'Andrea[F';
                    break;
            }
        else if(lang_code == 'es-US')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Rosa[F';
                    break;
                case 'A:2':
                    voice_name = 'Maria[F';
                    break;
                case 'B:2':
                    voice_name = 'Luis[M';
                    break;
                case 'C:2':
                    voice_name = 'Javier[M';
                    break;
                case 'G:5':
                    voice_name = 'Ana[F';
                    break;
                case 'F:5':
                    voice_name = 'Isabel[F';
                    break;
                case 'E:5':
                    voice_name = 'David[M';
                    break;
                case 'D:5':
                    voice_name = 'Carlos[M';
                    break;

                case 'A:20':
                    voice_name = 'Marta[F';
                    break;
                case 'B:20':
                    voice_name = 'Manuel[M';
                    break;
                case 'C:20':
                    voice_name = 'Francisco[M';
                    break;
                case 'D:20':
                    voice_name = 'Alicia[F';
                    break;
                case 'E:20':
                    voice_name = 'Paula[F';
                    break;
                case 'F:20':
                    voice_name = 'Gabriela[F';
                    break;
                    
                case 'G:20':
                    voice_name = 'Javier[M';
                    break;
                case 'H:20':
                    voice_name = 'Isabel[F';
                    break;
                case 'I:20':
                    voice_name = 'Alba[F';
                    break;
            }
        else if(lang_code == 'su')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Dewi[F';
                    break;

                case 'A:20':
                    voice_name = 'Teti[F';
                    break;
                case 'B:20':
                    voice_name = 'Iwan[M';
                    break;
                case 'C:20':
                    voice_name = 'Edi[M';
                    break;
                case 'D:20':
                    voice_name = 'Rina[F';
                    break;
                case 'E:20':
                    voice_name = 'Yani[F';
                    break;
                case 'F:20':
                    voice_name = 'Wulan[F';
                    break;
            }
        else if(lang_code == 'sw')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Ali[M';
                    break;

                case 'A:20':
                    voice_name = 'Amani[F';
                    break;
                case 'B:20':
                    voice_name = 'Hamisi[M';
                    break;
                case 'C:20':
                    voice_name = 'Faraji[M';
                    break;
                case 'D:20':
                    voice_name = 'Zuri[F';
                    break;
                case 'E:20':
                    voice_name = 'Siti[F';
                    break;
                case 'F:20':
                    voice_name = 'Pendo[F';
                    break;
            }
        else if(lang_code == 'sv-SE')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Emma[F';
                    break;
                case 'A:2':
                    voice_name = 'Elin[F';
                    break;
                case 'B:2':
                    voice_name = 'Ingrid[F';
                    break;
                case 'C:2':
                    voice_name = 'Gustav[M';
                    break;
                case 'D:2':
                    voice_name = 'Katarina[F';
                    break;
                case 'E:2':
                    voice_name = 'Oskar[M';
                    break;
            }
        else if(lang_code == 'ta-IN')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Deepika[F';
                    break;
                case 'A:2':
                    voice_name = 'Kavya[F';
                    break;
                case 'B:2':
                    voice_name = 'Arjun[M';
                    break;
                case 'C:2':
                    voice_name = 'Nandhini[F';
                    break;
                case 'D:2':
                    voice_name = 'Vijay[M';
                    break;
            }
        else if(lang_code == 'te-IN')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Anusha[F';
                    break;
                case 'A:1':
                    voice_name = 'Lakshmi[F';
                    break;
                case 'B:1':
                    voice_name = 'Venkat[M';
                    break;
            }
        else if(lang_code == 'th-TH')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Suchada[F';
                    break;
                case 'A:1':
                    voice_name = 'Siritida[F';
                    break;

                case 'A:20':
                    voice_name = 'Supatra[F';
                    break;
                case 'B:20':
                    voice_name = 'Anurak[M';
                    break;
                case 'C:20':
                    voice_name = 'Chaiwat[M';
                    break;
                case 'D:20':
                    voice_name = 'Malai[F';
                    break;
                case 'E:20':
                    voice_name = 'Thip[F';
                    break;
                case 'F:20':
                    voice_name = 'Wanee[F';
                    break;
                    
                case 'G:20':
                    voice_name = 'Rattana[M';
                    break;
                case 'H:20':
                    voice_name = 'Suthida[F';
                    break;
                case 'I:20':
                    voice_name = 'Wanee[F';
                    break;
            }
        else if(lang_code == 'tr-TR')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Fatma[F';
                    break;
                case 'B:2':
                    voice_name = 'Ahmet[M';
                    break;
                case 'C:2':
                    voice_name = 'Selma[F';
                    break;
                case 'D:2':
                    voice_name = 'Gamze[F';
                    break;
                case 'E:2':
                    voice_name = 'Hasan[M';
                    break;
                case 'A:2':
                    voice_name = 'Zeynep[F';
                    break;
            }
        else if(lang_code == 'uk-UA')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Oksana[F';
                    break;
                case 'A:2':
                    voice_name = 'Nataliya[F';
                    break;

                case 'A:20':
                    voice_name = 'Kateryna[F';
                    break;
                case 'B:20':
                    voice_name = 'Oleksandr[M';
                    break;
                case 'C:20':
                    voice_name = 'Ivan[M';
                    break;
                case 'D:20':
                    voice_name = 'Maria[F';
                    break;
                case 'E:20':
                    voice_name = 'Yuliya[F';
                    break;
                case 'F:20':
                    voice_name = 'Anastasiya[F';
                    break;
                    
                case 'G:20':
                    voice_name = 'Roman[M';
                    break;
                case 'H:20':
                    voice_name = 'Iryna[F';
                    break;
                case 'I:20':
                    voice_name = 'Lesya[F';
                    break;
            }
        else if(lang_code == 'ur')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Ayesha[F';
                    break;
                case 'A:20':
                    voice_name = 'Fatima[F';
                    break;
                case 'B:20':
                    voice_name = 'Muhammad[M';
                    break;
                case 'C:20':
                    voice_name = 'Hassan[M';
                    break;
                case 'D:20':
                    voice_name = 'Hina[F';
                    break;
                case 'E:20':
                    voice_name = 'Sana[F';
                    break;
                case 'F:20':
                    voice_name = 'Zara[F';
                    break;
            }
        else if(lang_code == 'vi-VN')
            switch(voice_data) {
                case 'A:0':
                    voice_name = 'Kim[F';
                    break;
                case 'A:2':
                    voice_name = 'Linh[F';
                    break;
                case 'B:2':
                    voice_name = 'Hieu[M';
                    break;
                case 'C:2':
                    voice_name = 'Hoa[F';
                    break;
                case 'D:2':
                    voice_name = 'Tuan[M';
                    break;
            }
        else if(lang_code == 'yue-HK')
            switch(voice_data) {
                case 'A:1':
                    voice_name = 'Wing[F';
                    break;
                case 'B:1':
                    voice_name = 'Chan[M';
                    break;
                case 'C:1':
                    voice_name = 'Yee[F';
                    break;
                case 'D:1':
                    voice_name = 'Lau[M';
                    break;

                case 'A:20':
                    voice_name = 'Mei[F';
                    break;
                case 'B:20':
                    voice_name = 'Chun[M';
                    break;
                case 'C:20':
                    voice_name = 'Ming[M';
                    break;
                case 'D:20':
                    voice_name = 'Yuet[F';
                    break;
                case 'E:20':
                    voice_name = 'Ting[F';
                    break;
                case 'F:20':
                    voice_name = 'Sze[F';
                    break;
            }

        voice_name = voice_name.replace('[M', ' (Male)');
        voice_name = voice_name.replace('[F', ' (Female)');
        
        return voice_name;
    };

    this.refreshLogin = function(page) {

        var l_html = `<div class="gsp_login_wrapper refresh_login_wrapper">
                        <div class="gsp_login_title">Sign in again!</div>
                        <div class="gsp_login_subtitle">Enter your credentials to sign in</div>
                        <input type="text" class="gsp_login_input gsp_login_email_uni" id="" placeholder="Email" />
                        <input type="password" class="gsp_login_input gsp_login_password_uni" id="" placeholder="Password" />
                        <div class="gsp_login_button gsp_login_button_uni gsp_refresh_login" id="">Sign In</div>
                </div>`;

        this.showMessage('', l_html, true, true);

        var email_val = $("#gsp_useremail").html();
        $(".gsp_login_email_uni").val(email_val);
        $(".gsp_login_button_uni").data('page', page);
    };

    this.createLangsListWebsiteSettings = function(sel_lang_code) {

        var appsumo = 0;
        var user_plan = 0;
        const $gsp_appsumo = $("#gsp_appsumo");
        const $gsp_plan = $("#gsp_plan");
        if ($gsp_appsumo.length) {
            appsumo = parseInt($gsp_appsumo.html(), 10) || 0;
        }
        if ($gsp_plan.length) {
            user_plan = parseInt($gsp_plan.html(), 10) || 0;
        }

        var appsumo_blocked_langs = ['hy','be','kk','mk','mi','fa','pa-Arab','sl'];
        var appsumo_tier1_blocked_langs = ['eu-ES','gl-ES','lt-LT','yue-HK'];
        var free_plan_blocked_langs = ['hy','be','eu-ES','gl-ES','kk','lt-LT','mk','mi','fa','pa-Arab','sl','yue-HK'];

        var $lng_sel = $("#lng_sel");

        if(!$lng_sel.length)
            return;

        var langs = this.langsObj;

        var langs_html = '';
        for(var t = 0;t < langs.length;t++) {

            var k1 = langs[t],
                l_name = k1["name"],
                audios_obj = k1["audios"];

            var lang_restricted = false;
            if(appsumo == 1 && thisPage.inArray(k1["value"],appsumo_blocked_langs)) {
                lang_restricted = true;
            }

            if(appsumo == 1 && user_plan == 1 && thisPage.inArray(k1["value"],appsumo_tier1_blocked_langs)) {
                lang_restricted = true;
            }

            if(user_plan == 0 && thisPage.inArray(k1["value"],free_plan_blocked_langs))
                lang_restricted = true;

            this.preview_audios[k1["value"]] = audios_obj;

            var selected = k1["value"] == sel_lang_code ? 'li_selected ss_ul_li_act' : '',
                sel_title = k1["value"] == sel_lang_code ? l_name : sel_title;

            if(!lang_restricted)
                langs_html += '<li class="search_li '+selected+'" data-voices_data="'+k1["voice_data"]+'" data-val="'+k1["value"]+'"><span>'+l_name+'</span></li>';
        }

        if(sel_lang_code != -1) {
            $lng_sel.find(".items_select_filter_content span").html(sel_title);
            $lng_sel.find(".li_selected").removeClass("li_selected");
        }

        $lng_sel.find(".items_select_ul").html(langs_html);
    };

    this.createLangsListReg = function(sel_lang_code) {

        var appsumo = 0;
        var user_plan = 0;
        const $gsp_appsumo = $("#gsp_appsumo");
        const $gsp_plan = $("#gsp_plan");
        if ($gsp_appsumo.length) {
            appsumo = parseInt($gsp_appsumo.html(), 10) || 0;
        }
        if ($gsp_plan.length) {
            user_plan = parseInt($gsp_plan.html(), 10) || 0;
        }

        var appsumo_blocked_langs = ['hy','be','kk','mk','mi','fa','pa-Arab','sl'];
        var appsumo_tier1_blocked_langs = ['eu-ES','gl-ES','lt-LT','yue-HK'];
        var free_plan_blocked_langs = ['hy','be','eu-ES','gl-ES','kk','lt-LT','mk','mi','fa','pa-Arab','sl','yue-HK'];

        var $lng_sel = $("#reg_website_lang");

        sel_lang_code = sel_lang_code == '' ? 'en' : sel_lang_code;

        if(!$lng_sel.length)
            return;

        var langs = this.langsObj;

        var langs_html = '';
        for(var t = 0;t < langs.length;t++) {

            var k1 = langs[t],
                l_name = k1["name"],
                l_val = k1["value"],
                l_val_0 = l_val.split('-')[0],
                audios_obj = k1["audios"];

            var lang_restricted = false;
            if(appsumo == 1 && thisPage.inArray(k1["value"],appsumo_blocked_langs)) {
                lang_restricted = true;
            }

            if(appsumo == 1 && user_plan == 1 && thisPage.inArray(k1["value"],appsumo_tier1_blocked_langs)) {
                lang_restricted = true;
            }

            if(user_plan == 0 && thisPage.inArray(k1["value"],free_plan_blocked_langs))
                lang_restricted = true;


            // this.preview_audios[k1["value"]] = audios_obj;

            var selected = sel_lang_code == 'en' ? (l_val == 'en-US' ? 'li_selected ss_ul_li_act' : '')  : (l_val_0 == sel_lang_code ?  'li_selected ss_ul_li_act' : ''),
                sel_title = sel_lang_code == 'en' ? (l_val == 'en-US' ? l_name : sel_title)  : (l_val_0 == sel_lang_code ?  l_name : sel_title);

            if(!lang_restricted)
                langs_html += '<li class="search_li '+selected+'" data-voices_data="'+k1["voice_data"]+'" data-val="'+l_val+'"><span>'+l_name+'</span></li>';
        }

        if(sel_lang_code != -1) {
            $lng_sel.find(".items_select_filter_content span").html(sel_title);
            $lng_sel.find(".li_selected").removeClass("li_selected");
        }

        $lng_sel.find(".items_select_ul").append(langs_html);
    };

    this.createLangsListAddWebsite = function() {

        var appsumo = 0;
        var user_plan = 0;
        const $gsp_appsumo = $("#gsp_appsumo");
        const $gsp_plan = $("#gsp_plan");
        if ($gsp_appsumo.length) {
            appsumo = parseInt($gsp_appsumo.html(), 10) || 0;
        }
        if ($gsp_plan.length) {
            user_plan = parseInt($gsp_plan.html(), 10) || 0;
        }

        var appsumo_blocked_langs = ['hy','be','kk','mk','mi','fa','pa-Arab','sl'];
        var appsumo_tier1_blocked_langs = ['eu-ES','gl-ES','lt-LT','yue-HK'];
        var free_plan_blocked_langs = ['hy','be','eu-ES','gl-ES','kk','lt-LT','mk','mi','fa','pa-Arab','sl','yue-HK'];

        var $lng_sel = $("#add_website_lang");

        var sel_lang_code = $("#gsp_old_p_lang").html();

        sel_lang_code = sel_lang_code == '' ? 'en' : sel_lang_code;

        if(!$lng_sel.length)
            return;

        var langs = this.langsObj;

        var langs_html = '';
        for(var t = 0;t < langs.length;t++) {

            var k1 = langs[t],
                l_name = k1["name"],
                l_val = k1["value"],
                l_val_0 = l_val.split('-')[0],
                audios_obj = k1["audios"];

            var lang_restricted = false;
            if(appsumo == 1 && thisPage.inArray(k1["value"],appsumo_blocked_langs)) {
                lang_restricted = true;
            }

            if(appsumo == 1 && user_plan == 1 && thisPage.inArray(k1["value"],appsumo_tier1_blocked_langs)) {
                lang_restricted = true;
            }

            if(user_plan == 0 && thisPage.inArray(k1["value"],free_plan_blocked_langs))
                lang_restricted = true;

            // this.preview_audios[k1["value"]] = audios_obj;

            var selected = sel_lang_code == 'en' ? (l_val == 'en-US' ? 'li_selected ss_ul_li_act' : '')  : (l_val_0 == sel_lang_code ?  'li_selected ss_ul_li_act' : ''),
                sel_title = sel_lang_code == 'en' ? (l_val == 'en-US' ? l_name : sel_title)  : (l_val_0 == sel_lang_code ?  l_name : sel_title);

            if(!lang_restricted)
                langs_html += '<li class="search_li '+selected+'" data-voices_data="'+k1["voice_data"]+'" data-val="'+l_val+'"><span>'+l_name+'</span></li>';
        }

        if(sel_lang_code != -1) {
            $lng_sel.find(".items_select_filter_content span").html(sel_title);
            $lng_sel.find(".li_selected").removeClass("li_selected");
        }

        $lng_sel.find(".items_select_ul").append(langs_html);
    };

    this.resetPlayerWebsiteSettings = function() {

        if(!$("#wbs_voice").length)
            return;

        var $player = $(".ss_voice_preview_wrapper").find(".ssplayer_wrapper");

        if(window.gspeech == undefined)
            return;

        var $gsLanguageSelector = $("#lng_sel"),
            $gsVoiceSelector = $("#wbs_voice");

        var player_lang = $gsLanguageSelector.find("li.li_selected").data('val'),
            player_voice = $gsVoiceSelector.find('.li_selected').data('val'),
            player_speed = $("#gsp_slider_speed").find('.gsp_value_label').val(),
            player_pitch = $("#gsp_slider_pitch").find('.gsp_value_label').val(),
            player_html = $("#voice_preview_data").data("preview_txt_ready");

        if(player_lang == -1 || player_voice == undefined) {
            player_lang = "en-US";
            player_html = player_lang == -1 ? "Please choose language" : "Please choose voice";
            player_voice = "C-2";
            player_speed = 1;
            player_pitch = 0;
        }

        $player.data("lang", player_lang);
        $player.data("voice", player_voice);
        $player.data("speed", player_speed);
        $player.data("pitch", player_pitch);
        $player.find(".ssplayer_audio_content").html(player_html);

        if($player.find(".ssplayer_icon_bg").hasClass("ssplayer_loading")) {
            window.gspeech.showeAbortMessage = false;
            window.gspeech.request.abort();
        }

        $player.find(".ssplayer_icon_bg").removeClass("ssplayer_play").removeClass("ssplayer_pause").removeClass("ssplayer_loading").addClass("ssplayer_speaker");
        $player.find(".ssplayer_txt_wrapper").removeClass("ssplayer_play").removeClass("ssplayer_pause").removeClass("ssplayer_loading").addClass("ssplayer_speaker");

        $player.data('once_loaded', false);
        $player.data('cur_s', 0);
        $player.find('.sstimeline_active').width('0%');
        $player.find('.ss_time_start').html('0:00');
        $player.find('.ss_time_end').html('0:00');

        var name_hash = $player.data("name_hash");

        if(name_hash != undefined) {
            var $playerElG = $('.' + name_hash).get(0);
            $playerElG.pause();
            $playerElG.currentTime = 0;
        }
    };

    this.createTranslationListWebsiteSettings = function() {

        var $this = this;

        var $lng_sel = $("#ss_translation_options");

        if(!$lng_sel.length)
            return;

        var appsumo = 0;
        const $appsumoElement = $("#gsp_appsumo");
        if ($appsumoElement.length) {
            appsumo = parseInt($appsumoElement.html(), 10) || 0;
        }

        var sel_lang_code = $lng_sel.data("val"),
            langs = this.langsObj,
            langs_html = '<div class="ss_langs_opt">',
            l_c = langs.length,
            p_s = parseInt(l_c / 4) + 1;

        for(var t = 0;t < langs.length;t++) {

            var k1 = langs[t],
                l_name = k1["name"];

            var voice_options = this.generateVoices(k1["voice_data"], k1["value"], appsumo);

            var l_item = '<div class="ss_translation_item ss_lang_holder_'+k1["value"]+'" data-voices_data="'+k1["voice_data"]+'" data-val="'+k1["value"]+'">';
            l_item += '<div class="ss_tr_line1">';
            l_item += '<span class="ss_checkbox_wrapper"><span class="ss_checkbox_line1"></span><span class="ss_checkbox_line2"></span><span class="ss_checkbox_ripple"></span><span class="ss_checkbox_bg"></span></span>';
            l_item += '<span class="ss_checkbox_label">'+l_name+'</span>';
            l_item += '</div>';
            l_item += '<div class="ss_tr_line2">';
            l_item += 
                        `
                            <div class="items_select_filter_wrapper ss_select_multiple ss_audio_holder" data-sel_voice="" data-def_txt="Select voices">
                                <div class="items_select_filter">
                                    <div class="items_select_filter_content"><span>Select voices</span></div>
                                    <div class="items_select_filter_icon_wrapper">
                                        <div class="items_select_filter_icon_holder">
                                            <div class="items_select_filter_icon_inner">
                                                <span class="items_select_filter_icon">
                                                    <svg class="" aria-hidden="true" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path fill="currentColor" d="M424.4 214.7L72.4 6.6C43.8-10.3 0 6.1 0 47.9V464c0 37.5 40.7 60.1 72.4 41.3l352-208c31.4-18.5 31.5-64.1 0-82.6z"></path></svg>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="items_select_ul_wrapper">
                                        <div class="items_select_ul_holder">
                                            <div class="items_select_ul_inner">
                                                <ul class="items_select_ul">`+voice_options+`</ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        `;
            l_item += '</div>';
            l_item += '</div>';

            if(voice_options != '')
                langs_html += l_item;

            if(t != 0 && t % p_s == 0)
                langs_html += '</div><div class="ss_langs_opt">';
        }
        langs_html += '</div>';

        $lng_sel.html(langs_html);

        // set preview audios
        // $(".ss_translation_item").each(function() {

        //     var lng_val = $(this).data("val");

        //     $(this).find(".search_li").each(function() {

        //         var voice_val = $(this).data("val"),
        //             audio_hash = $this.preview_audios[lng_val][voice_val];

        //         $(this).data('name_hash',audio_hash);
        //     });
        // });

        // set selection
        var sel_langs = $("#ss_translation_options").data("sel_langs");
        var sel_lang_global = $("#lng_sel").data("val");
        if(sel_langs == '')
            sel_langs = sel_lang_global;

        var sel_langs_array = sel_langs.split(';');
        for(let t=0;t<sel_langs_array.length;t++) {

            let sel_l_itm = sel_langs_array[t],
                sel_l_data = sel_l_itm.split('|'),
                s_l = sel_l_data[0],
                s_v_data = sel_l_data.length > 1 ? sel_l_data[1] : '';

            let $s_item = $('.ss_lang_holder_' + s_l);
            $s_item.find(".ss_tr_line2").addClass("ss_tr_line2_v").addClass("ss_ov_v");
            $s_item.find(".ss_checkbox_wrapper").addClass("ss_checked");

            // correction
            thisPage.createTranslationBlockPreviewTxt($s_item);

            // set voices
            if(s_v_data != '') {

                let s_v_array = s_v_data.split(','),
                    v_c_val = '';
                for(let q=0;q<s_v_array.length;q++) {

                    let v_item = s_v_array[q];
                    $s_item.find('.option-' + v_item).addClass("li_selected").addClass("ss_ul_li_act");

                    v_c_val += $s_item.find('.option-' + v_item).find("span").html() + ', ';
                }
                v_c_val = v_c_val.slice(0, -2);
                $s_item.find('.items_select_filter_content span').addClass("ss_processed74").html(v_c_val);
            }
        }

        // set disabled classes
        $(".ss_lang_holder_" + sel_lang_global).addClass("ss_tr_block_hardcoded").find(".ss_checkbox_wrapper").addClass("ss_disabled");
        
        // set voice
        let sel_v = $("#wbs_voice").data("sel_voice");
        let sel_v_val = $("#wbs_voice").data("val");

        sel_v = sel_v == "" ? sel_v_val : sel_v;
        if(sel_v != "" && sel_v != undefined) {
            $(".ss_lang_holder_" + sel_lang_global).find('.option-' + sel_v).addClass("li_selected").addClass("ss_ul_li_act").addClass("ss_option_hardcoded");

            let $c_c = $(".ss_lang_holder_" + sel_lang_global).find('.items_select_filter_content span');
            let v_c = $(".ss_lang_holder_" + sel_lang_global).find('.li_selected span').html();

            if(!$c_c.hasClass("ss_processed74"))
                $c_c.html(v_c);
        }
    };

    // Inner methods ///////////////////////////////////////////////////////////////////////

    this.makeTableFilter = function() {

        var $this = this;

        var widget_id = this.options.widget_id;

        var $order_table = $('.gsp_left_m_c_active').find('.items_wrapper');
        var $active_item =  $order_table.find('.itm_ord_active');
        var $search_input = $order_table.find('.search_input');
        var search_val = $search_input.val();

        $search_input.data('search_val', search_val);

        var order_table = $order_table.data('order_table');
        var order_field = $active_item.data('order_field');
        if($active_item.hasClass('item_ord_desc'))
            var order_dir = 'DESC';
        else
            var order_dir = 'ASC';

        // generate filters
        var filters_var = '';
        $order_table.find(".items_select_filter_wrapper:not(.itms_pages_limit)").each(function(i) {
            var filter_id = $(this).data('filter_id');
            var filter_val = $(this).find('.li_selected').data('val');

            if(filter_id == undefined)
                return;

            var itm_v = filter_id + ':' + filter_val;
            filters_var += itm_v + ';';
        });

        filters_var = filters_var.slice(0, -1);

        // pagination
        var pgn_limit = 0;
        var pgn_page = 0;
        if($order_table.find('.items_pagination').length) {
            pgn_limit = $order_table.find(".itms_pages_limit").find('.li_selected').data('val');
            pgn_page = $order_table.find('.items_pagination').find('.itms_p_sel').data('val');
        }

        // make table filter
        var ajax_id = 'make_table_filter_connection';
        var gspeech_token = this.getCookie('gspeech_token');
        var tts_url = thisPage.options.tts_url;

        // show loadings
        $order_table.find('.items_wrapper_overlay').addClass('items_wrapper_overlay_visible');
        $order_table.find('.itm_c').addClass('itm_c_hidden');
        $order_table.find('.itm_l').addClass('itm_l_visible');

        // make random widths
        $order_table.find('.item_row_item_1').each(function(i) {
            var rand = thisPage.getRundBetween(0, 70);
            $(this).find('.itm_l').css({'right':rand + '%'});
        });
        $order_table.find('.item_row_item_2').each(function(i) {
            var rand = thisPage.getRundBetween(0, 70);
            $(this).find('.itm_l').css({'right':rand + '%'});
        });

        var post_data = {
            'ajax_id':ajax_id,
            'token':gspeech_token,
            'order_table':order_table,
            'order_field':order_field,
            'order_dir':order_dir,
            'search_val':search_val,
            'filters_val':filters_var,
            'pgn_page':pgn_page,
            'widget_id':widget_id,
            'pgn_limit':pgn_limit
        };

        var hash = window.location.hash;

        hash = hash == '' ? '#settings' : hash;

        var hash_striped = hash.replace('#','');

        $.ajax({
            type: 'POST',
            url: tts_url + '/ajax',
            crossDomain: true,
            data: post_data,
            dataType: 'json',
            success: function(responseData, textStatus, jqXHR) {

                var result = responseData.success;
                var html = responseData.html;
                var pages_html = responseData.pages_html;
                var items_count_full = responseData.items_count_full;

                if(result == 'true') {
                    $('.gsp_left_m_c_active .items_inner_wrapper').html(html);
                    $('.items_pagination_itms_holder').html(pages_html);
                    
                    var items_count = $('.gsp_left_m_c_active .items_inner_wrapper').find('.item_item').length;
                    var pages_count = $('.gsp_left_m_c_active .items_pagination_itms_holder').find('.itms_p_i').length;
                    var s_ident = items_count == 1 ? '' : 's';
                    var vis_ident = pages_count == 1 ? 'p_hid' : '';
                    $('.gsp_left_m_c_active .items_pagination_itms_holder').removeClass('p_hid').addClass(vis_ident);

                    var item_text = ' item';
                    if(order_table == 'gspeech_ssblocks')
                        item_text = ' widget';
                    else if(order_table == 'gspeech_speeches')
                        item_text = ' audio';
                    
                    var count_txt = items_count + item_text + s_ident;

                    if(items_count_full != 0 && items_count_full != items_count)
                        count_txt += ' (total '+items_count_full+')';

                    $('.gsp_left_m_c_active .items_count').html(count_txt);
                    
                    $('html, body').animate({scrollTop:0}, 600);

                    if(hash_striped == "widgets") {

                        $this.setValsWidgets(widget_id);
                    }
                    else if(hash_striped == "audios") {

                        $this.setValsAudios(widget_id);
                    }
                }
                else if(result == "auth_failed") {

                    $this.refreshLogin("table_filter");
                }

                // hide loadings
                $('.gsp_left_m_c_active .items_wrapper_overlay').removeClass('items_wrapper_overlay_visible');
                $('.gsp_left_m_c_active .itm_l').removeClass('itm_l_visible');
            },
            error: function (responseData, textStatus, errorThrown) {

                $this.showMessage('error','Error sending request.');

                // if(window.gspeech != undefined)
                    // window.gspeech.doSmartSpeech('Error sending request.', 'en-US');
            }
        });
    };

    this.applyPageFunctions = function() {

        this.validateEmail = function(email_val) {

            // var email_val = $elem.val();
            var email_validate_pattern = new RegExp(/^[a-z0-9][a-z0-9-_\.]+@([a-z]|[a-z0-9]?[a-z0-9-]+[a-z0-9])\.[a-z0-9]{2,5}(?:\.[a-z]{2,5})?$/);

            if(!email_validate_pattern.test(email_val)) {
                return false;
            }
            else {
                return true;
            }
        };

        this.validateUrl = function(url_val) {

            // url validation
            // var expression_url = /(https?:\/\/(?:www\.|(?!www))[a-zA-Z0-9][a-zA-Z0-9-]+[a-zA-Z0-9]\.[^\s]{2,}|www\.[a-zA-Z0-9][a-zA-Z0-9-]+[a-zA-Z0-9]\.[^\s]{2,}|https?:\/\/(?:www\.|(?!www))[a-zA-Z0-9]+\.[^\s]{2,}|www\.[a-zA-Z0-9]+\.[^\s]{2,})/gi;
            var expression_url = /^(http(s)?:\/\/)?(www\.)?[a-z0-9]+([\-\.]{1}[a-z0-9]+)*\.[a-z]{2,5}(:[0-9]{1,5})?(\/.*)?$/gi;
            var regex_url = new RegExp(expression_url);

            if(url_val.match(regex_url)) {
                return true;
            }
            else {
                return false;
            }
        };

        this.shake = function ($elem, options) {
            // defaults
            var settings = {
                'shakes': 2,
                'distance': 30,
                'duration':300
            };

            if(options) {
                settings = options;
            }
            
            var pos;

            // position if necessary
            pos = $elem.css('position');
            if (!pos || pos === 'static') {
                $elem.css('position', 'relative');
            };
            // shake it
            for (var x = 1; x <= settings.shakes; x++) {
                $elem.animate({ left: settings.distance * -1 }, (settings.duration / settings.shakes) / 4)
                    .animate({ left: settings.distance }, (settings.duration / settings.shakes) / 2)
                    .animate({ left: 0 }, (settings.duration / settings.shakes) / 4);
            };
        };

        this.inArray = function(needle, haystack) {
            var length = haystack.length;
            for(var i = 0; i < length; i++) {
                if(haystack[i] == needle) return true;
            }
            return false;
        };

        this.getRundBetween = function(min, max) {

            return Math.floor(Math.random() * (max - min + 1)) + min;
        };

        this.applySSSelect = function() {

            // select
            var s_timeout1 = 0;
            var s_timeout2 = 0;
            $('body').on('click', '.items_select_filter_wrapper', function(e) {
                var $el = $(e.target);

                if($el.hasClass('li_search') || $el.parents('.li_search').length || $el.hasClass('li_selected') || $el.parents('.search_li').hasClass('li_selected') || $el.hasClass('play_voice_preview') || $el.parents('.play_voice_preview').length ) {
                    return;
                }

                // do not close for multiple select
                if($el.hasClass('search_li') || $el.parents('.search_li').length) {
                    if($el.parents('.items_select_filter_wrapper').hasClass("ss_select_multiple"))
                        return;
                }

                if(!$el.hasClass('items_select_filter_wrapper')) {
                    $el = $el.parents('.items_select_filter_wrapper');
                }

                if($el.hasClass("ss_disabled"))
                    return;

                var offset = $el.offset(),
                    offset_top = offset.top,
                    el_h = $el.outerHeight(),
                    w_h =  $(window).height(),
                    w_s_y = window.scrollY,
                    ofsset_screen_top = offset_top - w_s_y,
                    ofsset_screen_bottom = w_h - ofsset_screen_top - el_h;

                //check if search enabled, set focus
                if($el.find('.li_search_input').length && !$el.hasClass('isfw_opened')) {

                    var c_htm = $el.find('.items_select_filter_content span').html();
                    $el.find('.li_search_input').attr("placeholder", c_htm);
                    setTimeout(function() {
                        $el.find('.li_search_input').focus();
                    }, 100);
                }

                // set scroll top
                if(!$el.hasClass('isfw_opened')) {
                    setTimeout(function() {

                        if($el.find(".li_selected").length) {
                            var li_h = 35;
                            var i = 0;
                            var its_h = $el.find('.items_select_ul_inner').height();
                            $el.find('li').each(function() {
                                var $li = $(this);

                                if($li.hasClass('li_h')) {
                                    return; // just continue loop
                                }

                                i++;

                                if($li.hasClass('li_selected')) {
                                    return false;
                                }
                            });

                            var act_i = i > 0 ? i-1 : i;
                            var t_h = act_i * li_h;

                            var top_ratio = (its_h - li_h)/2;
                            var top_pos = t_h - top_ratio;
                        }
                        else {
                            var top_pos = 0;
                        }

                        $el.find('.items_select_ul_inner').scrollTop(top_pos);

                    }, 100);
                }

                // set height
                var itm_h = 35;
                var itms_c = $el.find("li:not(.li_h)").length;
                var itms_h = 210;
                itms_h = itms_c < 6 ? itms_c * itm_h : itms_h;
                $el.find('.items_select_ul_inner').height(itms_h);

                // check space from bottom, to place to top, if neccesary
                if(itms_h > ofsset_screen_bottom) {
                    $el.find('.items_select_ul_wrapper').css({'bottom': 'calc(100% + 4px)','top': 'initial'});
                }
                else {
                    $el.find('.items_select_ul_wrapper').css({'top': 'calc(100% + 4px)','bottom': 'initial'});
                }

                // animate icon
                var $isfiw = $el.find('.items_select_filter_icon_wrapper');
                if($isfiw.hasClass('isfi_opened'))
                    $isfiw.removeClass('isfi_opened');
                else
                    $isfiw.addClass('isfi_opened');
                
                // wrapper
                clearTimeout(s_timeout1);
                clearTimeout(s_timeout2);

                if($el.hasClass('isfw_opened')) { // opened -> close

                    if(!$el.hasClass('isfw_closing')) {

                        $el.addClass('isfw_closing');
                        s_timeout1 = setTimeout(function() {
                            $el.removeClass('isfw_opened');
                            $el.removeClass('isfw_closing');

                            $el.find('.ss_ul_li_act').removeClass("ss_ul_li_act");
                            $el.find('.li_selected').addClass("ss_ul_li_act");

                            if($el.find('.li_search_input').length) {
                                $el.find('.li_search_input').val("");
                                $el.find(".search_li").removeClass("li_h");
                                $el.find('.ss_no_result').remove();
                            }

                        }, 320);
                    }
                    else {
                        $el.removeClass('isfw_closing');
                    }
                }
                else {
                    setTimeout(function() {
                        $el.addClass('isfw_opened');
                     }, 1);   
                }

                // make 3d animation
                setTimeout(function() {
                    var $isuw = $el.find('.items_select_ul_wrapper');
                    if($isuw.hasClass('isuw_opened'))
                        $isuw.removeClass('isuw_opened');
                    else
                        $isuw.addClass('isuw_opened');
                },20);

                // reset
                s_timeout2 = setTimeout(function() {
                    $el.find('.items_select_ul_inner').height('auto');
                }, 320);
            });

            // hide right menus
            $('body').on('click', function(e) {

                var $target = $(e.target);

                if($target.hasClass('items_select_filter_wrapper') || $target.parents('.items_select_filter_wrapper').length) { // clicked on wrapper

                    if(!$target.hasClass('items_select_filter_wrapper'))
                        $target = $target.parents('.items_select_filter_wrapper');

                    if($target.hasClass('isfw_opened')) {

                        $target.addClass('self_clicked');

                        setTimeout(function() {
                            $target.removeClass('self_clicked');
                        }, 320);
                    }
                } 
                
                $(".isfw_opened:not(.self_clicked)").each(function() {

                    var $el = $(this);

                    // set height
                    var itm_h = 35;
                    var itms_c = $el.find("li:not(.li_h)").length;
                    var itms_h = 210;
                    itms_h = itms_c < 6 ? itms_c * itm_h : itms_h;
                    $el.find('.items_select_ul_inner').height(itms_h);

                    // animate icon
                    var $isfiw = $el.find('.items_select_filter_icon_wrapper');
                    $isfiw.removeClass('isfi_opened');

                    setTimeout(function() {
                        $el.removeClass('isfw_opened');
                        $el.find('.ss_ul_li_act').removeClass("ss_ul_li_act");
                        $el.find('.li_selected').addClass("ss_ul_li_act");

                        if($el.find('.li_search_input').length) {
                            $el.find('.li_search_input').val("");
                            $el.find(".search_li").removeClass("li_h");
                            $el.find('.ss_no_result').remove();
                        }
                    }, 320);

                    // make 3d animation
                    setTimeout(function() {
                        var $isuw = $el.find('.items_select_ul_wrapper');
                        $isuw.removeClass('isuw_opened');
                    },20);

                    // reset height
                    setTimeout(function() {
                        $el.find('.items_select_ul_inner').height('auto');

                        $('.self_clicked').removeClass('self_clicked');
                    }, 320);

                });
            });

            function setNextPrevActiveLi(dir) {

                var $el = $(".items_select_filter_wrapper.isfw_opened");

                var sel_index = 0;
                var lis_count = $el.find(".search_li:not(.li_h)").length;

                $el.find(".search_li:not(.li_h)").each(function(k) {

                    if($(this).hasClass("ss_ul_li_act")) {

                        sel_index = k;
                        return false;
                    }
                });

                if((dir == 0 && sel_index == 0) || (dir == 1 && sel_index == lis_count - 1 && sel_index != 0)) {
                    return;
                }

                var new_index = dir == 0 ? sel_index - 1 : sel_index + 1;

                if(!$el.find(".ss_ul_li_act:not(.li_h)").length)
                    new_index = 0;

                $el.find(".search_li:not(.li_h)").removeClass("ss_ul_li_act").each(function(k) {

                    if(k == new_index) {
                        $(this).addClass("ss_ul_li_act");
                        return false;
                    }
                });

                // set scroll top
                var it_h = parseInt($el.find('.search_li:first-child').height()),
                    its_h = parseInt($el.find('.items_select_ul_inner').height()),
                    top_ratio = (its_h - it_h)/2,
                    t_h = new_index * it_h,
                    top_pos = t_h - top_ratio;

                $el.find('.items_select_ul_inner').stop(true, true).animate({scrollTop:top_pos}, 300);
            }; 

            $("body").on("keydown", function(e) {

                var $el = $(".items_select_filter_wrapper.isfw_opened");

                // if(!$el.length)
                    // return;

                var e_key = e.key,
                    e_which = e.which;

                if(e_which == 38) {
                    setNextPrevActiveLi(0);
                    return false;
                }
                else if(e_which == 40) {
                    setNextPrevActiveLi(1);
                    return false;
                }
                else if(e_which == 27) {

                    // set height
                    var itm_h = 35;
                    var itms_c = $el.find("li:not(.li_h)").length;
                    var itms_h = 210;
                    itms_h = itms_c < 6 ? itms_c * itm_h : itms_h;
                    $el.find('.items_select_ul_inner').height(itms_h);

                    // animate icon
                    var $isfiw = $el.find('.items_select_filter_icon_wrapper');
                    $isfiw.removeClass('isfi_opened');

                    setTimeout(function() {
                        $el.removeClass('isfw_opened');
                        $el.find('.ss_ul_li_act').removeClass("ss_ul_li_act");
                        $el.find('.li_selected').addClass("ss_ul_li_act");

                        if($el.find('.li_search_input').length) {
                            $el.find('.li_search_input').val("");
                            $el.find(".search_li").removeClass("li_h");
                            $el.find('.ss_no_result').remove();
                        }
                    }, 320);

                    // make 3d animation
                    setTimeout(function() {
                        var $isuw = $el.find('.items_select_ul_wrapper');
                        $isuw.removeClass('isuw_opened');
                    },20);

                    // reset height
                    setTimeout(function() {
                        $el.find('.items_select_ul_inner').height('auto');
                    }, 320);

                }
                else if(e_which == 13) {

                    $el.find(".ss_ul_li_act").eq(0).trigger("mousedown");
                    $el.find(".ss_ul_li_act").eq(0).trigger("click");
                }
            }); 

            $("body").on("keyup", ".li_search_input", function(e) {

                var $ss_wrapper = $(this).parents(".items_select_filter_wrapper");

                if(!$ss_wrapper.hasClass("isfw_opened"))
                    return;

                var e_key = e.key,
                    e_which = e.which;

                if(e_which == 38 || e_which == 40 || e_which == 27 || e_which == 13) {
                    return;
                }

                $ss_wrapper.find('.items_select_ul_inner').scrollTop(0);

                $ss_wrapper.find('.ss_ul_li_act').removeClass("ss_ul_li_act");
                
                var search_val = $ss_wrapper.find(".li_search_input").val();
                search_val = search_val.replace('(','\\(');
                search_val = search_val.replace(')','\\)');
                search_val = search_val.replace('.','\\.');

                var $ul = $ss_wrapper.find('.items_select_ul');

                var count_lis = $ul.find('.search_li').length;
                var hidden_count = 0;
                $ul.find('li').each(function() {
                    $li = $(this);

                    if($li.hasClass('ss_no_result') || $li.hasClass('li_def'))
                        return;

                    var li_val = $li.find('span').html();
                    var rg = new RegExp(search_val, "gi");
                    if(li_val.match(rg))
                        $li.removeClass('li_h');
                    else {
                        $li.addClass('li_h');
                        hidden_count ++;
                    }
                });

                if(hidden_count == count_lis) {
                    if(!$ul.find('.ss_no_result').length) {
                        var hidden_li = '<li class="ss_no_result">No matching data</li>';
                        $ul.append(hidden_li);
                    }
                }
                else {
                    $ul.find('.search_li:not(.li_h)').eq(0).addClass("ss_ul_li_act");
                    $ul.find('.ss_no_result').remove();
                }

                return false;
            });  

            $('body').on('click', '.search_li', function(e) {

                var $el = $(e.target);

                // check if voice icon clicked
                if($el.hasClass('play_voice_preview') || $el.parents('.play_voice_preview').length)
                    return;

                if(!$el.hasClass('search_li'))
                    $el = $el.parents('.search_li');

                if($el.hasClass('ss_disabled'))
                    return;

                var if_multiple = $el.parents(".items_select_filter_wrapper").hasClass("ss_select_multiple") ? true : false;

                if($el.hasClass('li_selected') && !if_multiple)
                    return;

                if($el.hasClass('li_selected') && if_multiple && $el.hasClass('ss_option_hardcoded'))
                    return;

                // set active page to 1
                if($('.gsp_left_m_c_active .itms_p_sel').length) {
                    $('.gsp_left_m_c_active .itms_p_sel').removeClass('itms_p_sel');
                    $('.gsp_left_m_c_active .items_pagination_itms_holder').find('.itms_p_i:first-child').addClass('itms_p_sel');
                }

                setTimeout(function() {

                    var val = $el.find('span').html();

                    if(!if_multiple) {
                        $el.parents('.items_select_ul').find('.li_selected').removeClass('li_selected');
                        $el.addClass('li_selected').addClass('ss_ul_li_act');
                        $el.parents('.items_select_filter').find('.items_select_filter_content span').html(val);
                    }
                    else {

                        if($el.hasClass('li_selected'))
                            $el.removeClass("li_selected").removeClass("ss_ul_li_act");
                        else
                            $el.addClass("li_selected").addClass("ss_ul_li_act");

                        var m_s_val = '';
                        $el.parents(".items_select_ul").find(".search_li.li_selected").each(function() {
                            var val = $(this).find("span").html();
                            m_s_val += val + ', ';
                        });

                        if(m_s_val == "")
                            m_s_val = $el.parents(".items_select_filter_wrapper").data("def_txt");
                        else
                            m_s_val = m_s_val.slice(0, -2);

                        $el.parents('.items_select_filter').find('.items_select_filter_content span').html(m_s_val);
                    }

                    if($el.parents('.items_filter_table').length) { // for table filter, make filter

                        thisPage.makeTableFilter();
                    }

                    $el.parents(".items_select_filter_wrapper").removeClass("ss_error");
                    
                },1);
            });
        };

        this.applyMessagesFunctionality();

        this.applySSSelect();
    };

    this.applyMessagesFunctionality = function() {

        this.createRequiredHtml = function() {

            var messages_html = '<div class="ss_message_container nospeech" style="visibility: hidden;">';
            messages_html += '<div class="ss_message_title"></div>';
                messages_html += '<div class="ss_message_body"></div>';
            messages_html += ' <div class="ss_message_close">' + this.svgs["close"] + '</div>';
            messages_html += '</div>';

            messages_html += '<div class="ss_body_overlay"></div>';
            messages_html += '<div id="ss_page_loading" style="display: none;"><img src="https://storage.googleapis.com/gspeech-assets/bricks.svg" /></div>';

            $("body").append(messages_html);
        };

        this.showMessage = function(className,message,keepOpened,showOverlay,isComfirm,options) {

            // this.hideMessage();

            clearTimeout(this.timeouts.message_timeout);

            var keepOpened = keepOpened || false;
            var showOverlay = showOverlay || false;
            var isComfirm = isComfirm || false;
            var options = options || false;

            var gsp_classname = 'gsp_' + className;
            
            $('.ss_message_container').data('keep_opened',keepOpened);
            $('.ss_message_container').find('.ss_message_title').html(message);
            $('.ss_message_container').removeClass('ss_error').removeClass('ss_success');
            $('.ss_message_container').removeClass('gsp_error').removeClass('gsp_success');
            if(className != '')
                $('.ss_message_container').addClass(gsp_classname);

            $('.ss_message_container').addClass('ssvis');
            setTimeout(function() {
                $('.ss_message_container').addClass('ss_visible');
            }, 20);

            if(isComfirm) {

                $('.ss_message_container').addClass('sscomfirm-block');

                var subTitle = options.sub_title;
                var but1Txt = options.button_1_txt;
                var but2Txt = options.button_2_txt;
                var but2Class = options.button_2_class;
                var callback_function = options.callback_function;
                var itemId = options.item_id;

                this.options.callback_id = itemId;
                this.options.callback_function = callback_function;

                var comfirmHtm = '<div class="comfirm-sub-title">'+subTitle+'</div>';
                comfirmHtm += '<div class="comfirm-buttons-wrapper"><div class="ss-comfirm-button-1">'+but1Txt+'</div><div class="ss-comfirm-button-2 '+but2Class+'">'+but2Txt+'</div></div>';
                
                $('.ss_message_container').find('.ss_message_body').html(comfirmHtm);
            }
            else {
                $('.ss_message_container').removeClass('sscomfirm-block');
                $('.ss_message_container').find('.ss_message_body').html('');
            }

            if(!keepOpened) {
                this.timeouts.message_timeout = setTimeout(function() {
                    this.hideMessage();
                }.bind(this), this.options.messages_hide_delay);
            }
            if(showOverlay) {
                this.showOverlay();
            }
        };

        this.hideMessage = function(keepOverlay) {
            var keepOverlay = keepOverlay || false;

            // check for opened add site wrapper
            if($(".add_new_website_popup_wrapper").length) {
                if($(".add_new_website_popup_wrapper").hasClass('ssvisible')) {
                    keepOverlay = true;
                }
            }

            if(!keepOverlay) {
                this.hideOverlay();
            }

            $('.ss_message_container').removeClass('ss_visible');
            setTimeout(function() {
                $('.ss_message_container').removeClass('ssvis');
            }, 200);
        };

        this.showLoading = function() {

            $('#ss_page_loading').addClass('ss_visible');
        };

        this.hideLoading = function() {

            $('#ss_page_loading').removeClass('ss_visible');
        };

        this.showOverlay = function() {

            if($('.ss_body_overlay').hasClass('ss_visible')) {
                return;
            }

            $('.ss_body_overlay').addClass('ssvis');

            setTimeout(function() {
                $('.ss_body_overlay').addClass('ss_visible');
                $('.ss_body_overlay').removeClass('ssvis');
            },20);
        };

        this.hideOverlay = function() {
            if($('.ss_body_overlay').hasClass('ss_visible')) {

                $('.ss_body_overlay').addClass('ssvis');
                $('.ss_body_overlay').removeClass('ss_visible');

                setTimeout(function() {
                    $('.ss_body_overlay').removeClass('ssvis');
                },300);
            }
        };

        this.comfirmFunction = function() {

            this.options.callback_function(this.options.callback_id);
        };

        this.applyMessagesEvents = function() {

            $("body").on("click",'.ss_message_close', function(e) {
                this.hideMessage();
            }.bind(this));

            $('body').on('click', '.ss-comfirm-button-1', function() {
                this.hideMessage();
            }.bind(this));

            $('body').on('click', '.ss-comfirm-button-2', function() {
                this.comfirmFunction();
            }.bind(this));

            $("body").on("mouseenter", '.ss_message_container', function() {
                var keepOpened = $('.ss_message_container').data('keep_opened');
                if(!keepOpened) {
                    clearTimeout(this.timeouts.message_timeout);
                }
            }.bind(this));

            $("body").on("mouseleave", '.ss_message_container', function() {
                var keepOpened = $('.ss_message_container').data('keep_opened');
                if(!keepOpened) {
                    this.timeouts.message_timeout = setTimeout(function() {
                        this.hideMessage();
                    }.bind(this), this.options.messages_hide_delay);
                }
            }.bind(this));
        };

        this.createRequiredHtml();

        this.applyMessagesEvents();
    };

    this.escapeHTML = function(unsafe) {

        unsafe = unsafe.replace(/[\"\'\<\>]/g, '', unsafe);

        return unsafe;

        // return unsafe.replace(
        //     /[\u0000-\u002F\u003A-\u0040\u005B-\u0060\u007B-\u00FF]/g,
        //     c => '&#' + ('000' + c.charCodeAt(0)).slice(-4) + ';'
        // )
    };

    this.applyCookies = function() {

        this.setCookie = function(key, value, expiry) {

            var cookie_val = key + '=' + value + ';path=/';
            if(expiry != -1) {
                var expires = new Date();
                expires.setTime(expires.getTime() + (expiry * 60 * 60 * 1000)); // in hours
                cookie_val += ';expires=' + expires.toUTCString();
            }
            document.cookie = cookie_val;
        };

        this.getCookie = function(key) {
            var keyValue = document.cookie.match('(^|;) ?' + key + '=([^;]*)(;|$)');
            return keyValue ? keyValue[2] : null;
        };

        this.eraseCookie = function(key) {
            var keyValue = this.getCookie(key);
            this.setCookie(key, keyValue, '-2');
        };
    };

    // generate wrapper height 
    this.setWrapperHeight = function() {

        // $('.gspeech-wrapper').css({'height': 'auto'});

        // var footer_height = $(".gspeech_footer").height();
        // var wrapper_height = $('html').height() - footer_height;
        // var wrapper_min_height = 450;
        // wrapper_height = wrapper_height < wrapper_min_height ? wrapper_min_height : wrapper_height;

        // $('.gspeech-wrapper').css({
        //         'height': wrapper_height
        //     }
        // );

        $('.gsp_dashboard_wrapper').height('auto');

        var wrapper_height = parseInt($('html').height());
        var p_wrapper_height = parseInt($('.gsp_dashboard_wrapper').height());
        var wrapper_height_calc = wrapper_height - 108;
        var p_wrapper_height_calc = p_wrapper_height + 108;

        if(p_wrapper_height_calc < wrapper_height) {

            $('.gsp_dashboard_wrapper').height(wrapper_height_calc);
        }
    };

    this.generateWrapperHeight = function() {

        thisPage.setWrapperHeight();
        setTimeout(function() {
            thisPage.setWrapperHeight();
        }, 200);
        setTimeout(function() {
            thisPage.setWrapperHeight();
        }, 800);
        setTimeout(function() {
            thisPage.setWrapperHeight();
        }, 2000);
    };

    this.generateWrapperHeight();

    $(window).resize(function() {
        thisPage.setWrapperHeight();
    });

    this.applyOldPlugin = function() {

        $("#wpgs_accordion").accordion({
          collapsible: true,
          heightStyle: "content"
        });
        $("#wpgs_tabs").tabs();
        
        $('.speaker_type_select').change(function() {
            var roll = $(this).attr("roll");
            var val = $(this).val();
            
            var size_ident = $('input[name="wpgs_settings\\[speaker_size_' + roll + '\\]"]:checked').val();
            $("#sound_container_" + roll).attr("class","").addClass("sound_container_pro gspeech_slider_pro").addClass(val).addClass("size_" + size_ident);
            $("#sound_container_" + roll + '_hover').attr("class","").addClass("sound_container_pro hovered gspeech_slider_pro_hovered").addClass(val).addClass("size_" + size_ident);
        });
        
        $('.speaker_size_radio').change(function() {
            var roll = $(this).attr("roll");
            var val = $(this).val();
            
            speaker_type = $('select[name="wpgs_settings\\[speaker_type_' + roll + '\\]"]').val();
            $("#sound_container_" + roll).attr("class","").addClass("sound_container_pro gspeech_slider_pro").addClass(speaker_type).addClass("size_" + val);
            $("#sound_container_" + roll + '_hover').attr("class","").addClass("sound_container_pro hovered gspeech_slider_pro_hovered").addClass(speaker_type).addClass("size_" + val);
        });
        
        $('.next_speaker').click(function() {
            var select = $(this).parent('div').prev('select');
            var val = select.val();
            var int_val_array = val.split('_');
            var int_val = int_val_array[1];
            var new_val = int_val == 40 ? 1 : int_val*1 + 1*1;
            var new_val_selected = 'speaker_' + new_val;
            select.val(new_val_selected);
            select.trigger("change");
        });
        $('.prev_speaker').click(function() {
            var select = $(this).parent('div').prev('select');
            var val = select.val();
            var int_val_array = val.split('_');
            var int_val = int_val_array[1];
            var new_val = int_val == 1 ? 40 : int_val*1 - 1*1;
            var new_val_selected = 'speaker_' + new_val;
            select.val(new_val_selected);
            select.trigger("change");
        });
        
        $('.tooltip_select').change(function() {
            var val = $(this).val();
            
            var new_class = 'the-tooltip top left ' + val;
            var $tooltip = $(this).parents('.ui-accordion-content').find('.the-tooltip');
            $tooltip.attr("class",new_class);
        });
        
        $('.next_tooltip').click(function() {
            var select = $(this).parent('div').prev('select');
            var val = select.val();
            var next_elem = select.children('option:selected').next().val();
            if(typeof next_elem === 'undefined')
                next_elem = select.children('option:first').val();
            select.val(next_elem);
            select.trigger("change");
        });
        $('.prev_tooltip').click(function() {
            var select = $(this).parent('div').prev('select');
            var val = select.val();
            var prev_elem = select.children('option:selected').prev().val();
            if(typeof prev_elem === 'undefined') {
                prev_elem = select.children('option:last').val();
            }
            select.val(prev_elem);
            select.trigger("change");
        });
        
        var active_element;
        $('.colorSelector').click(function() {
            active_element = $(this).parent('.selector_wrapper');
        })
        
        $('.colorSelector').ColorPicker({
            onBeforeShow: function () {
                $color = active_element.find('input').val();
                $(this).ColorPickerSetColor($color);
            },
            onShow: function (colpkr) {
                $(colpkr).fadeIn(500);
                return false;
            },
            onHide: function (colpkr) {
                $(colpkr).fadeOut(500);
                return false;
            },
            onChange: function (hsb, hex, rgb) {
                active_element.children('div').children('div').css('backgroundColor', '#' + hex);
                active_element.find('input').val('#' + hex);
                roll = active_element.find('input').attr('roll');
                
                if(roll == 2) {
                    var elem = active_element.parent('div').parent('div').find('.animate_item_passive');
                    elem.css('backgroundColor' , '#' + hex);
                }
                else if(roll == 3) {
                    var elem = active_element.parent('div').parent('div').find('.animate_item_passive');
                    elem.css('color' , '#' + hex);
                }
                else if(roll == 4) {
                    var elem = active_element.parent('div').parent('div').find('.animate_item_active');
                    elem.css('backgroundColor' , '#' + hex);
                }
                else if(roll == 5) {
                    var elem = active_element.parent('div').parent('div').find('.animate_item_active');
                    elem.css('color' , '#' + hex);
                }
            }
        });
        
        $('.slider_select_1').change(function() {
            var val = $(this).val() / 100;
            var elem = $(this).parent('div').parent('div').find('.gspeech_slider_pro');
            elem.css('opacity',val);
        });
        $('.slider_select_2').change(function() {
            var val = $(this).val() / 100;
            var elem = $(this).parent('div').parent('div').find('.gspeech_slider_pro_hovered');
            elem.css('opacity',val);
        });

        //sliders
        //slider style1/////////////////////////////////////////////////////////////////////////////////////////////////////////////
        var select11 = $( "#slider_select11" );
        var place11 = select11.next('label');
        var slider11 = $( "<div id='slider_11' class='wpgs_slider'></div>" ).insertAfter( place11 ).slider({
          min: 1,
          max: 10,
          range: "min",
          value: select11[ 0 ].selectedIndex + 1,
          slide: function( event, ui ) {
            select11[ 0 ].selectedIndex = ui.value - 1;
            select11.trigger("change");
          }
        });
        $( "#slider_select11" ).change(function() {
          slider11.slider( "value", this.selectedIndex + 1 );
        });
        
        var select12 = $( "#slider_select12" );
        var place12 = select12.next('label');
        var slider12 = $( "<div id='slider_12' class='wpgs_slider'></div>" ).insertAfter( place12 ).slider({
            min: 1,
            max: 10,
            range: "min",
            value: select12[ 0 ].selectedIndex + 1,
            slide: function( event, ui ) {
                select12[ 0 ].selectedIndex = ui.value - 1;
                select12.trigger("change");
            }
        });
        $( "#slider_select12" ).change(function() {
            slider12.slider( "value", this.selectedIndex + 1 );
        });
        
        var select13 = $( "#slider_select13" );
        var place13 = select13.next('label');
        var slider13 = $( "<div id='slider_13' class='wpgs_slider'></div>" ).insertAfter( place13 ).slider({
            min: 1,
            max: 13,
            range: "min",
            value: select13[ 0 ].selectedIndex + 1,
            slide: function( event, ui ) {
                select13[ 0 ].selectedIndex = ui.value - 1;
            }
        });
        $( "#slider_select13" ).change(function() {
            slider13.slider( "value", this.selectedIndex + 1 );
        });
        //slider style2/////////////////////////////////////////////////////////////////////////////////////////////////////////////
        var select21 = $( "#slider_select21" );
        var place21 = select21.next('label');
        var slider21 = $( "<div id='slider_22' class='wpgs_slider'></div>" ).insertAfter( place21 ).slider({
            min: 1,
            max: 10,
            range: "min",
            value: select21[ 0 ].selectedIndex + 1,
            slide: function( event, ui ) {
                select21[ 0 ].selectedIndex = ui.value - 1;
                select21.trigger("change");
            }
        });
        $( "#slider_select21" ).change(function() {
            slider21.slider( "value", this.selectedIndex + 1 );
        });
        
        var select22 = $( "#slider_select22" );
        var place22 = select22.next('label');
        var slider22 = $( "<div id='slider_22' class='wpgs_slider'></div>" ).insertAfter( place22 ).slider({
            min: 1,
            max: 10,
            range: "min",
            value: select22[ 0 ].selectedIndex + 1,
            slide: function( event, ui ) {
                select22[ 0 ].selectedIndex = ui.value - 1;
                select22.trigger("change");
            }
        });
        $( "#slider_select22" ).change(function() {
            slider22.slider( "value", this.selectedIndex + 1 );
        });
        
        var select23 = $( "#slider_select23" );
        var place23 = select23.next('label');
        var slider23 = $( "<div id='slider_23' class='wpgs_slider'></div>" ).insertAfter( place23 ).slider({
            min: 1,
            max: 13,
            range: "min",
            value: select23[ 0 ].selectedIndex + 1,
            slide: function( event, ui ) {
                select23[ 0 ].selectedIndex = ui.value - 1;
            }
        });
        $( "#slider_select23" ).change(function() {
            slider23.slider( "value", this.selectedIndex + 1 );
        });
        //slider style3/////////////////////////////////////////////////////////////////////////////////////////////////////////////
        var select31 = $( "#slider_select31" );
        var place31 = select31.next('label');
        var slider31 = $( "<div id='slider_31' class='wpgs_slider'></div>" ).insertAfter( place31 ).slider({
            min: 1,
            max: 10,
            range: "min",
            value: select31[ 0 ].selectedIndex + 1,
            slide: function( event, ui ) {
                select31[ 0 ].selectedIndex = ui.value - 1;
                select31.trigger("change");
            }
        });
        $( "#slider_select31" ).change(function() {
            slider31.slider( "value", this.selectedIndex + 1 );
        });
        
        var select32 = $( "#slider_select32" );
        var place32 = select32.next('label');
        var slider32 = $( "<div id='slider_32' class='wpgs_slider'></div>" ).insertAfter( place32 ).slider({
            min: 1,
            max: 10,
            range: "min",
            value: select32[ 0 ].selectedIndex + 1,
            slide: function( event, ui ) {
                select32[ 0 ].selectedIndex = ui.value - 1;
                select32.trigger("change");
            }
        });
        $( "#slider_select32" ).change(function() {
            slider32.slider( "value", this.selectedIndex + 1 );
        });
        
        var select33 = $( "#slider_select33" );
        var place33 = select33.next('label');
        var slider33 = $( "<div id='slider_33' class='wpgs_slider'></div>" ).insertAfter( place33 ).slider({
            min: 1,
            max: 13,
            range: "min",
            value: select33[ 0 ].selectedIndex + 1,
            slide: function( event, ui ) {
                select33[ 0 ].selectedIndex = ui.value - 1;
            }
        });
        $( "#slider_select33" ).change(function() {
            slider33.slider( "value", this.selectedIndex + 1 );
        });
        //slider style4/////////////////////////////////////////////////////////////////////////////////////////////////////////////
        var select41 = $( "#slider_select41" );
        var place41 = select41.next('label');
        var slider41 = $( "<div id='slider_41' class='wpgs_slider'></div>" ).insertAfter( place41 ).slider({
            min: 1,
            max: 10,
            range: "min",
            value: select41[ 0 ].selectedIndex + 1,
            slide: function( event, ui ) {
                select41[ 0 ].selectedIndex = ui.value - 1;
                select41.trigger("change");
            }
        });
        $( "#slider_select41" ).change(function() {
            slider41.slider( "value", this.selectedIndex + 1 );
        });
        
        var select42 = $( "#slider_select42" );
        var place42 = select42.next('label');
        var slider42 = $( "<div id='slider_42' class='wpgs_slider'></div>" ).insertAfter( place42 ).slider({
            min: 1,
            max: 10,
            range: "min",
            value: select42[ 0 ].selectedIndex + 1,
            slide: function( event, ui ) {
                select42[ 0 ].selectedIndex = ui.value - 1;
                select42.trigger("change");
            }
        });
        $( "#slider_select42" ).change(function() {
            slider42.slider( "value", this.selectedIndex + 1 );
        });
        
        var select43 = $( "#slider_select43" );
        var place43 = select43.next('label');
        var slider43 = $( "<div id='slider_43' class='wpgs_slider'></div>" ).insertAfter( place43 ).slider({
            min: 1,
            max: 13,
            range: "min",
            value: select43[ 0 ].selectedIndex + 1,
            slide: function( event, ui ) {
                select43[ 0 ].selectedIndex = ui.value - 1;
            }
        });
        $( "#slider_select43" ).change(function() {
            slider43.slider( "value", this.selectedIndex + 1 );
        });
        //slider style5/////////////////////////////////////////////////////////////////////////////////////////////////////////////
        var select51 = $( "#slider_select51" );
        var place51 = select51.next('label');
        var slider51 = $( "<div id='slider_51' class='wpgs_slider'></div>" ).insertAfter( place51 ).slider({
            min: 1,
            max: 10,
            range: "min",
            value: select51[ 0 ].selectedIndex + 1,
            slide: function( event, ui ) {
                select51[ 0 ].selectedIndex = ui.value - 1;
                select51.trigger("change");
            }
        });
        $( "#slider_select51" ).change(function() {
            slider51.slider( "value", this.selectedIndex + 1 );
        });
        
        var select52 = $( "#slider_select52" );
        var place52 = select52.next('label');
        var slider52 = $( "<div id='slider_52' class='wpgs_slider'></div>" ).insertAfter( place52 ).slider({
            min: 1,
            max: 10,
            range: "min",
            value: select52[ 0 ].selectedIndex + 1,
            slide: function( event, ui ) {
                select52[ 0 ].selectedIndex = ui.value - 1;
                select52.trigger("change");
            }
        });
        $( "#slider_select52" ).change(function() {
            slider52.slider( "value", this.selectedIndex + 1 );
        });
        
        var select53 = $( "#slider_select53" );
        var place53 = select53.next('label');
        var slider53 = $( "<div id='slider_53' class='wpgs_slider'></div>" ).insertAfter( place53 ).slider({
            min: 1,
            max: 13,
            range: "min",
            value: select53[ 0 ].selectedIndex + 1,
            slide: function( event, ui ) {
                select53[ 0 ].selectedIndex = ui.value - 1;
            }
        });
        $( "#slider_select53" ).change(function() {
            slider53.slider( "value", this.selectedIndex + 1 );
        });
    };

    this.applySliderFunctionality = function(parent_selector, callback_function) {

        var $parent = this;

        var click_event = $parent.is_touch_devise ? 'touchstart' : 'click',
            mousedown_event = $parent.is_touch_devise ? 'touchstart' : 'mousedown',
            mouseenter_event = $parent.is_touch_devise ? 'touchstart' : 'mouseenter',
            mouseup_event = $parent.is_touch_devise ? 'touchend' : 'mouseup',
            mousemove_event = $parent.is_touch_devise ? 'touchmove' : 'mousemove';

        $(parent_selector + ' .gsp_slider_wrapper').each(function() {

            var $gsp_slider_wrapper = $(this);
            var $gsp_value_label = $gsp_slider_wrapper.parent('div').find('.gsp_value_label');
            var $gsp_reset_icon = $gsp_slider_wrapper.parent('div').find('.gsp_label_reset_icon');

            // set volume
            $gsp_slider_wrapper.data('value', '0');

            $gsp_slider_wrapper.find('.gsp_slider_bar_button').on(mousedown_event, function() {

                var v = $gsp_slider_wrapper.data('value');

                $gsp_slider_wrapper.find(".gsp_slider_bar").addClass('gsp_slide_enabled');
                $(this).addClass('gsp_slider_z_index_low');

                $gsp_slider_wrapper.find(".gsp_slider_bar_active").addClass('gsp_transition_none');
            });

            $("body").on(mouseup_event, function() {

                $gsp_slider_wrapper.find(".gsp_slider_bar").removeClass('gsp_slide_enabled');
                $gsp_slider_wrapper.find('.gsp_slider_bar_button').removeClass('gsp_slider_z_index_low');

                $gsp_slider_wrapper.find(".gsp_slider_bar_active").removeClass('gsp_transition_none');
            });

            $gsp_slider_wrapper.find('.gsp_slider_bar_percents').on(mousedown_event, function(e) {

                var w = $(this).width(),
                    posX1 = $(this).offset().left,
                    // pageX = e.pageX,
                    pageX = $parent.is_touch_devise ? e.touches[0].pageX : e.pageX,
                    qq = Math.abs(posX1 - pageX),
                    // tt = w - qq,
                    tt = qq,
                    percent = parseInt((100*tt)/w);

                // validation
                var bar_start = parseInt($gsp_slider_wrapper.data('bar_start'));
                var bar_end = parseInt($gsp_slider_wrapper.data('bar_end'));
                var bar_module = bar_end - bar_start;
                var bar_limit_start = parseFloat($gsp_slider_wrapper.data('bar_limit_start'));
                bar_limit_start = isNaN(bar_limit_start) ? 0 : bar_limit_start;
                var bar_limit_end = parseFloat($gsp_slider_wrapper.data('bar_limit_end'));
                bar_limit_end = isNaN(bar_limit_end) ? 0 : bar_limit_end;

                var cur_size = parseFloat(bar_module*percent/100);

                if(bar_start < 0) {
                    cur_size = cur_size - bar_end;
                }
                var bar_limit_condition = (bar_start < 0 && bar_limit_start >= 0) ? false : true;
                if(cur_size < bar_limit_start && bar_limit_condition) {
                    var new_val = bar_limit_start;
                    if(bar_start < 0) {
                        new_val = new_val - bar_start;
                    }
                    var new_perc = parseFloat(new_val * 100 / bar_module);
                    percent = new_perc;
                }
                // todo: add bar_limit_end check

                $gsp_slider_wrapper.find(".gsp_slider_bar_active").css('width', percent + '%');

                // set value
                $gsp_slider_wrapper.data('value', percent);

                updateValueLabel();

                // enable move
                $gsp_slider_wrapper.find(".gsp_slider_bar").addClass('gsp_slide_enabled');
                $gsp_slider_wrapper.find('.gsp_slider_bar_button').addClass('gsp_slider_z_index_low');
                setTimeout(function() {
                   
                }, 400);
            });

            // $gsp_slider_wrapper.find('.gsp_slider_bar_percents').on('mousemove', function(e) {
            $("body").on(mousemove_event, function(e) {

                if(!$gsp_slider_wrapper.find(".gsp_slider_bar").hasClass('gsp_slide_enabled')) {
                    return;
                }

                $gsp_slider_wrapper.find(".gsp_slider_bar_active").addClass('gsp_transition_none');

                var w = $gsp_slider_wrapper.find(".gsp_slider_bar_percents").width(),
                    posX1 = $gsp_slider_wrapper.find(".gsp_slider_bar_percents").offset().left,
                    // pageX = e.pageX,
                    pageX = $parent.is_touch_devise ? e.touches[0].pageX : e.pageX,
                    qq = pageX - posX1,
                    // tt = w - qq,
                    tt = qq,
                    percent = parseInt((100*tt)/w);

                percent = percent < 0 ? 0 : percent;
                percent = percent > 100 ? 100 : percent;

                setTimeout(function() {

                    // validation
                    var bar_start = parseInt($gsp_slider_wrapper.data('bar_start'));
                    var bar_end = parseInt($gsp_slider_wrapper.data('bar_end'));
                    var bar_module = bar_end - bar_start;
                    var bar_limit_start = parseFloat($gsp_slider_wrapper.data('bar_limit_start'));
                    bar_limit_start = isNaN(bar_limit_start) ? 0 : bar_limit_start;
                    var bar_limit_end = parseFloat($gsp_slider_wrapper.data('bar_limit_end'));
                    bar_limit_end = isNaN(bar_limit_end) ? bar_end : bar_limit_end;

                    var cur_size = parseFloat(bar_module*percent/100);

                    if(bar_start < 0) {
                        cur_size = cur_size - bar_end;
                    }
                    var bar_limit_condition = (bar_start < 0 && bar_limit_start >= 0) ? false : true;

                    if(cur_size < bar_limit_start && bar_limit_condition) {

                        var new_val = bar_limit_start;
                        if(bar_start < 0) {
                            new_val = new_val - bar_start;
                        }
                        var new_perc = parseFloat(new_val * 100 / bar_module);
                        percent = new_perc;
                    }

                    // todo: add bar_limit_end check

                    $gsp_slider_wrapper.find(".gsp_slider_bar_active").css('width', percent + '%');

                    // set value
                    $gsp_slider_wrapper.data('value', percent);

                    updateValueLabel();

                }.bind(this), 0);

            });

            // initital values
            setTimeout(function() {

                var bar_start = parseFloat($gsp_slider_wrapper.data('bar_start'));
                var bar_end = parseFloat($gsp_slider_wrapper.data('bar_end'));
                var start_value = parseFloat($gsp_slider_wrapper.data('start_value'));

                var bar_module = bar_end - bar_start;

                var start_value_size = start_value - bar_start;
                var current_percent = parseFloat((start_value_size * 100 ) / bar_module);

                var current_size_label = parseFloat((bar_module * current_percent) / 100);
                
                if(bar_start < 0) {
                    current_size_label = current_size_label + bar_start;
                }
                else {
                    current_size_label = current_size_label - bar_start;
                }

                current_size_label = current_size_label.toFixed(2);

                $gsp_slider_wrapper.data('value', current_percent);
                $gsp_slider_wrapper.data('bar_module', bar_module);
                $gsp_slider_wrapper.find(".gsp_slider_bar_active").css('width', current_percent + '%');

                $gsp_slider_wrapper.parent('div').find(".gsp_value_label").val(current_size_label);
            }, 200);

            function updateValueLabel() {

                var value = parseFloat($gsp_slider_wrapper.data('value'));
                var bar_module = parseFloat($gsp_slider_wrapper.data('bar_module'));
                
                var v_size = parseFloat(bar_module * value / 100);

                var bar_start = parseInt($gsp_slider_wrapper.data('bar_start'));
                var bar_end = parseInt($gsp_slider_wrapper.data('bar_end'));

                if(bar_start < 0) {
                    v_size = v_size - bar_end;
                }

                v_size = v_size.toFixed(2);
                $gsp_slider_wrapper.parent('div').find(".gsp_value_label").addClass('gsp_slider_label_active');
                $gsp_slider_wrapper.parent('div').find(".gsp_value_label").val(v_size);

                setTimeout(function() {
                    $gsp_slider_wrapper.parent('div').find(".gsp_value_label").removeClass('gsp_slider_label_active');
                }, 400);

                var start_value = parseFloat($gsp_slider_wrapper.data('start_value'));
                start_value = start_value.toFixed(2);
                if(v_size != start_value) {
                    $gsp_reset_icon.removeClass('gsp_reset_disabled');
                }
                else {
                    $gsp_reset_icon.addClass('gsp_reset_disabled');
                }

                applyBarCallback();
            };

            $gsp_value_label.on('keyup', function(e) {

                var key = e.key;
                if(key == 'Enter') {
                    updateBarSizeViaLabel();
                }
            });

            $gsp_value_label.on('blur', function(e) {
                updateBarSizeViaLabel();
            });

            $gsp_reset_icon.on(click_event, function(e) {

                if($(this).hasClass('gsp_reset_disabled')) {
                    $parent.shake($(this), {'shakes': 2,'distance': 2,'duration':150});

                    return;
                }

                var start_value = parseFloat($gsp_slider_wrapper.data('start_value'));
                var val = start_value.toFixed(2);
                $gsp_value_label.val(val);

                updateBarSizeViaLabel();
            });

            function updateBarSizeViaLabel() {

                var val_init = $gsp_value_label.val();
                var val = parseFloat(val_init);
                val = isNaN(val) ? 0 : val;

                // validation
                var bar_start = parseInt($gsp_slider_wrapper.data('bar_start'));
                var bar_end = parseInt($gsp_slider_wrapper.data('bar_end'));
                var bar_module = bar_end - bar_start;
                var bar_limit_start = parseFloat($gsp_slider_wrapper.data('bar_limit_start'));
                bar_limit_start = isNaN(bar_limit_start) ? 0 : bar_limit_start;
                var bar_limit_end = parseFloat($gsp_slider_wrapper.data('bar_limit_end'));
                bar_limit_end = isNaN(bar_limit_end) ? 0 : bar_limit_end;

                // check for strat
                if(val < bar_start) {
                    val = bar_start;
                }
                if(val > bar_end) {
                    val = bar_end;
                }

                var bar_limit_condition = (bar_start < 0 && bar_limit_start >= 0) ? false : true;
                if(val < bar_limit_start && bar_limit_condition) {
                    val = bar_limit_start;
                }
                // todo: add bar_limit_end check

                val = val.toFixed(2);

                $gsp_value_label.val(val);

                var start_value_size = val - bar_start;
                var current_percent = parseFloat((start_value_size * 100 ) / bar_module);

                $gsp_slider_wrapper.find(".gsp_slider_bar_active").css('width', current_percent + '%');

                $gsp_slider_wrapper.data('value', current_percent);

                var start_value = parseFloat($gsp_slider_wrapper.data('start_value'));
                start_value = start_value.toFixed(2);
                if(val != start_value) {
                    $gsp_reset_icon.removeClass('gsp_reset_disabled');
                }
                else {
                    $gsp_reset_icon.addClass('gsp_reset_disabled');
                }

                applyBarCallback();
            };

            function applyBarCallback() {

                callback_function();
            };
        });

        // disable drag
        $('.gsp_slider_wrapper').on('dragstart', function () {
            return false;
        });
    };

    this.init();
};


$(document).ready(function() {
    
    // gspeech 3.x
    var gsp_options = {};
    window.gspeechDash = new gspeechDash(gsp_options);
                    
});
})(jQuery);