/*
 * jQuery Panel Slider plugin v0.1.1
 * https://github.com/eduardomb/jquery-panelslider
*/
(function ($) {
    'use strict';

    var $body = $('body'),
        _sliding = false;

    function _slideIn(panel, options) {
        var panelWidth = panel.outerWidth(true),
            bodyAnimation = {},
            panelAnimation = {};

        if (panel.is(':visible') || _sliding) {
            return;
        }

        _sliding = true;
        panel.addClass('gs-active-panel').css({
            position: 'fixed',
            top: 0,
            height: '100%',
            zIndex: 99999999
        });
        panel.data(options);

        $("html").addClass("gs-panel-active");
        $("body").addClass("gs-panel-active");
        $("#gstm-overlay").bind("touchmove", false);
        $("#gstm-overlay").fadeIn(200);

        switch (options.side) {
            case 'left':
                panel.css({
                    left: '-' + panelWidth + 'px',
                    right: 'auto'
                });
                bodyAnimation['margin-left'] = '+=' + panelWidth;
                panelAnimation.left = '+=' + panelWidth;
                break;

            case 'right':
                panel.css({
                    left: 'auto',
                    right: '-' + panelWidth + 'px'
                });
                bodyAnimation['margin-left'] = '-=' + panelWidth;
                panelAnimation.right = '+=' + panelWidth;
                break;
        }

        $body.animate(bodyAnimation, options.duration);
        panel.show().animate(panelAnimation, options.duration, function () {
            _sliding = false;

            if (typeof options.onOpen == 'function') {
                options.onOpen();
            }
        });
    }

    function _slideTo(panel, panelTo, options) {
        
        if ( ! panel.is(':visible') || ! panelTo.length ) {
            return;
        }

        panelTo.data(options);

        var panelWidth = panelTo.outerWidth(true);

        panel.css({
            zIndex: 99999999
        });

        panelTo.addClass('gs-active-panel').css({
            position: 'fixed',
            top: 0,
            height: '100%',
            zIndex: 999999999
        });

        switch (options.side) {
            case 'left':
                panelTo.css({ left: 0, right: 'auto' });
                break;
            case 'right':
                panelTo.css({ left: 'auto', right: 0 });
                break;
        }

        panelTo.fadeIn(100, function() {
            panel.hide();
            panel.removeClass( 'gs-active-panel' );
        });

    }

    $.panelslider = function (element, options) {
        var active = $('.gs-active-panel');
        var defaults = {
            side: 'left',     // panel side: left or right
            duration: 200,    // Transition duration in miliseconds
            clickClose: true, // If true closes panel when clicking outside it
            onOpen: null,     // When supplied, function is called after the panel opens
        };

        options = $.extend({}, defaults, options);
        // this.options = options;

        // If another panel is opened, close it before opening the new one
        if (active.is(':visible') && active[0] != element[0]) {
            $.panelslider.close(function () {
                _slideIn(element, options);
            });
        } else if (!active.length || active.is(':hidden')) {
            _slideIn(element, options);
        }
    };

    $.panelslider.close = function (callback) {
        var active = $('.gs-active-panel'),
            duration = active.data('duration'),
            panelWidth = active.outerWidth(true),
            bodyAnimation = {},
            panelAnimation = {};

        if (!active.length || active.is(':hidden') || _sliding) {
            return;
        }

        _sliding = true;

        switch (active.data('side')) {
            case 'left':
                bodyAnimation['margin-left'] = '-=' + panelWidth;
                panelAnimation.left = '-=' + panelWidth;
                break;

            case 'right':
                bodyAnimation['margin-left'] = '+=' + panelWidth;
                panelAnimation.right = '-=' + panelWidth;
                break;
        }

        active.animate(panelAnimation, duration);
        $body.animate(bodyAnimation, duration, function () {
            active.hide();
            active.removeClass('gs-active-panel');
            _sliding = false;

            $("html").removeClass("gs-panel-active");
            $("body").removeClass("gs-panel-active");
            $("#gstm-overlay").fadeOut(200);

            if (callback) {
                callback();
            }
        });
    };

    $.panelslider.next = function () {
        var active = $('.gs-active-panel');
        var to = active.next('.gstm-panel');
        if ( ! to.length ) to = active.parent().find('.gstm-panel').first();
        _slideTo(active, to, active.data());
    };

    $.panelslider.prev = function () {
        var active = $('.gs-active-panel');
        var to = active.prev('.gstm-panel');
        if ( ! to.length ) to = active.parent().find('.gstm-panel').last();
        _slideTo(active, to, active.data());
    };

    // Bind click outside panel and ESC key to close panel if clickClose is true
    $(document).bind('click keyup', function (e) {
        var active = $('.gs-active-panel');

        if (e.type == 'keyup' && e.keyCode != 27) {
            return;
        }

        if (active.is(':visible') && active.data('clickClose')) {
            $.panelslider.close();
        }
    });

    // Prevent click on panel to close it
    $(document).on('click', '.gs-active-panel', function (e) {
        e.stopPropagation();
    });

    $.fn.panelslider = function (options) {
        this.click(function (e) {
            var active = $('.gs-active-panel'),
                panel = $(this.getAttribute('href'));

            // Close panel if it is already opened otherwise open it
            if (active.is(':visible') && panel[0] == active[0]) {
                $.panelslider.close();
            } else {
                $.panelslider(panel, options);
            }

            e.preventDefault();
            e.stopPropagation();
        });

        return this;
    };
})(jQuery);