jQuery(function($) {

	var isPro = gs_team_fs.is_paying_or_trial;

	if ( isPro ) {
		var nonce = window._gsteam_sort_data.nonce;
		window._gsteam_sort_data = null;
	}

	var resourceSort = $('#sortable-list');

	resourceSort.sortable({

		update: function() {

			if ( ! isPro ) return;

			$('#loading-animation').show(); // Show the animate loading gif while waiting

			$.ajax({
				url: ajaxurl, // ajaxurl is defined by WordPress and points to /wp-admin/admin-ajax.php
				type: 'POST',
				async: true,
				cache: false,
				dataType: 'json',
				data: {
					_nonce: nonce,
					action: 'update_taxonomy_order', // Tell WordPress how to handle this ajax request
					order: resourceSort.sortable('toArray').toString() // Passes ID's of list items in	1,3,2 format
				},
				success: function(response) {
					$('#loading-animation').hide(); // Hide the loading animation
					return; 
				},
				error: function(xhr,textStatus,e) {  // This can be expanded to provide more information
					alert('There was an error saving the updates');
					$('#loading-animation').hide(); // Hide the loading animation
					return; 
				}
			});

		}
		
	});

});